# hand generated file for libmodelica_parser

TEMPLATE = lib

DEPENDPATH  += .
INCLUDEPATH += .

win32: CONFIG += dll
unix:  CONFIG += staticlib

SANDBOX      = ../../build
INCLUDEPATH += $${SANDBOX}/include
DESTDIR      = $${SANDBOX}

CONFIG += debug_and_release
CONFIG(debug, debug|release) {
  TARGET = lib/modelica_parser_debug
} else {
  TARGET = lib/modelica_parser
}
CONFIG += warn_on

SOURCES += parse_tree_dumper.cpp

#############################################################
# SANDBOX_HEADERS sanboxing the headers
#############################################################

SANDBOX_HEADERS = MyAST.h parse_tree_dumper.hpp

#dependency to add header files to the sandbox
sandbox.name           = SANDBOX_INCLUDES ${QMAKE_FILE_IN}
sandbox.commands       = cp -a ${QMAKE_FILE_NAME} $${SANDBOX}/include/${QMAKE_FILE_NAME}
#sandbox.depends        = cp -a ${QMAKE_FILE_NAME} $${SANDBOX}/include/${QMAKE_FILE_NAME}
sandbox.variable_out   = HEADERS
sandbox.output         = $${SANDBOX}/include/${QMAKE_FILE_NAME}
sandbox.input          = SANDBOX_HEADERS
sandbox.clean          = $${SANDBOX}/include/${QMAKE_FILE_NAME}
QMAKE_EXTRA_COMPILERS += sandbox
#SOURCES += $${SANDBOX_HEADERS}

# FIXME: the above does not work so let's try it a different way
isEmpty(STUB) {
  system (mkdir -p $${SANDBOX}/include/)
  system (cp -a $${SANDBOX_HEADERS} $${SANDBOX}/include/)
}


#############################################################
# ANTLR scripts and tools (gratis of Ken Cecka)
#############################################################

ANTLR_GRAMMARS = modelica_lexer.g  modelica_parser.g

# find the class path and set up the antlr command
CLASSPATH = "$(CLASSPATH):$$system(java-config -p antlr)"
isEmpty(CLASSPATH) {
  error (Could not find antlr! )
}

#global defaults
isEmpty(ANTLR_DIR):ANTLR_DIR = $${SANDBOX}/include
isEmpty(ANTLR_CMD):ANTLR_CMD = java -cp $${CLASSPATH} antlr.Tool $${ANTLRFLAGS}

#dependency to generate *.cpp from *.g
antlr_cpp.name         = ANTLR_CPP ${QMAKE_FILE_IN}
antlr_cpp.commands     = $${ANTLR_CMD} -o $${ANTLR_DIR} ${QMAKE_FILE_NAME}
antlr_cpp.variable_out = SOURCES
antlr_cpp.output       = $${ANTLR_DIR}/${QMAKE_FILE_BASE}.cpp
antlr_cpp.input        = ANTLR_GRAMMARS
antlr_cpp.clean        = $${ANTLR_DIR}/${QMAKE_FILE_BASE}.cpp
QMAKE_EXTRA_COMPILERS += antlr_cpp

#dependency to generate *.hpp from *.g
antlr_hpp.name         = ANTLR_HPP ${QMAKE_FILE_IN}
antlr_hpp.commands     = $${ANTLR_CMD} -o $${ANTLR_DIR} ${QMAKE_FILE_NAME}
antlr_hpp.CONFIG      += no_link
antlr_hpp.variable_out = HEADERS
antlr_hpp.output       = $${ANTLR_DIR}/${QMAKE_FILE_BASE}.hpp
antlr_hpp.input        = ANTLR_GRAMMARS
antlr_hpp.clean        = $${ANTLR_DIR}/${QMAKE_FILE_BASE}.hpp
QMAKE_EXTRA_COMPILERS += antlr_hpp

#dependency to generate *TokenTypes.hpp from *.g
antlrTokenTypes_hpp.name     = ANTLRTOKENTYPES_HPP ${QMAKE_FILE_IN}
antlrTokenTypes_hpp.commands = $${ANTLR_CMD} -o $${ANTLR_DIR} ${QMAKE_FILE_NAME}
antlrTokenTypes_hpp.CONFIG  += no_link
antlr_hpp.variable_out       = HEADERS
antlrTokenTypes_hpp.output   = $${ANTLR_DIR}/${QMAKE_FILE_BASE}TokenTypes.hpp
antlrTokenTypes_hpp.input    = ANTLR_GRAMMARS
antlrTokenTypes_hpp.clean    = $${ANTLR_DIR}/${QMAKE_FILE_BASE}TokenTypes.hpp
QMAKE_EXTRA_COMPILERS       += antlrTokenTypes_hpp

#dependency to generate *TokenTypes.txt from *.g
antlrTokenTypes_txt.name     = ANTLRTOKENTYPES_TXT ${QMAKE_FILE_IN}
antlrTokenTypes_txt.commands = $${ANTLR_CMD} -o $${ANTLR_DIR} ${QMAKE_FILE_NAME}
antlrTokenTypes_txt.CONFIG  += no_link
antlrTokenTypes_txt.output   = $${ANTLR_DIR}/${QMAKE_FILE_BASE}TokenTypes.txt
antlrTokenTypes_txt.input    = ANTLR_GRAMMARS
antlrTokenTypes_txt.clean    = $${ANTLR_DIR}/${QMAKE_FILE_BASE}TokenTypes.txt
QMAKE_EXTRA_COMPILERS       += antlrTokenTypes_txt
