######################################################################

TEMPLATE = app

SANDBOX = ../build

INCLUDEPATH += $${SANDBOX}/include
DESTDIR      = $${SANDBOX}

CONFIG += qt 
CONFIG += debug_and_release
CONFIG += warn_on
CONFIG(debug, debug|release) {
    TARGET = bin/omc_debug
} else {
    TARGET = bin/omc
}

QT += network

RMLHOME      = $$system(mico-config --prefix)
RMLC         = $${RMLHOME}/bin/rmlc
INCLUDEPATH += $${RMLHOME}/include/plain
isEmpty(RMLHOME) {
  error (rml required)
}

LIBS += -L$${SANDBOX}/lib -labsyn_builder -lc_runtime -lruntime
LIBS += -lmodelica_parser -lflat_modelica_parser -lmodpar -lsendData

LIBS += -L$${RMLHOME}/lib/plain -lrml 
LIBS += $$system(antlr-config --libs)
LIBS += $$system(mico-config --libs)

LIBS += -ldl -lm 


# FIXME: Check to make sure that FIXME...
DEFINES += HAVE_SCANDIR

SRCMO = \
    Absyn.mo Algorithm.mo Builtin.mo Ceval.mo ClassInf.mo ClassLoader.mo \
	Codegen.mo Connect.mo Convert.mo DAE.mo DAELow.mo Derive.mo Debug.mo \
	DFA.mo Dump.mo DumpGraphviz.mo Constants.mo Env.mo Error.mo Exp.mo \
	SCode.mo Graphviz.mo Inst.mo Interactive.mo Lookup.mo Main.mo \
	MetaUtil.mo Mod.mo ModUtil.mo Patternm.mo Prefix.mo Static.mo \
	SimCodegen.mo Types.mo TaskGraph.mo Util.mo Values.mo VarTransform.mo \
	Refactor.mo DAEQuery.mo XMLDump.mo 

# SRCSIG == ALLMO 
SRCSIG = DAEEXT.mo Print.mo RTOpts.mo System.mo Parser.mo TaskGraphExt.mo \
		 Corba.mo Socket.mo ErrorExt.mo Settings.mo $${SRCMO} 

# runtime 
RTOBJ = ./runtime/systemimpl.c \
        ./runtime/rtopts.c \
        ./runtime/socketimpl.c \
        ./runtime/printimpl.c \
        ./runtime/ptolemyio.cpp \
        ./runtime/errorext.cpp \
        ./runtime/ErrorMessage.cpp \
        ./runtime/daeext.cpp \
        ./runtime/settingsimpl.c

#INCLUDEPATH += /usr/include/plain # FIXME...
SOURCES     += $${RTOBJ}


#mytarget.target   = .buildfile
#mytarget.commands = touch $$mytarget.target
#mytarget.depends  = mytarget2
#
#mytarget2.commands = @echo Building $$mytarget.target
#
#QMAKE_EXTRA_TARGETS += mytarget mytarget2
#
#QMAKE_CLEAN += *.sig

# information...
# http://xmelegance.org/devel/qthtml/qmake-manual.html
# http://xmelegance.org/devel/qthtml/qmake-function-reference.html#find-variablename-substr

mo.output    = ${QMAKE_FILE_BASE}.o # ${QMAKE_FILE_BASE}.h ${QMAKE_FILE_BASE}.c
mo.commands  = $${RMLC} -Wr,-ftrace -c ${QMAKE_FILE_NAME}
mo.input     = SRCMO
mo.clean     = ${QMAKE_FILE_BASE}.h ${QMAKE_FILE_BASE}.c ${QMAKE_FILE_BASE}.srz
QMAKE_EXTRA_COMPILERS += mo

sig.CONFIG   = no_link
sig.output   = ${QMAKE_FILE_BASE}.sig
sig.commands = RMLHOME=$${RMLHOME} ./rml2sig/rmldep-new.sh ${QMAKE_FILE_NAME}
sig.input    = SRCSIG
sig.clean    = ${QMAKE_FILE_BASE}.sig
QMAKE_EXTRA_COMPILERS += sig


#### NOTES:
# really good ANTLR scripts on the way down...
#   http://lists.trolltech.com/qt-interest/2005-10/thread00555-0.html
