######################################################################

TEMPLATE     = lib
DEPENDPATH  += .
INCLUDEPATH += .

win32: CONFIG += dll
unix:  CONFIG += staticlib

SANDBOX      = ../../build
INCLUDEPATH += $${SANDBOX}/include
DESTDIR      = $${SANDBOX}

CONFIG += debug_and_release
CONFIG(debug, debug|release) {
  TARGET = lib/modpar_debug
} else {
  TARGET = lib/modpar
}
CONFIG += warn_on

############################################################
# RML: definitions
############################################################
RMLHOME      = $$system(mico-config --prefix)
RMLC         = $${RMLHOME}/bin/rmlc
INCLUDEPATH += $${RMLHOME}/include/plain
LIBS        += -L$${RMLHOME}/lib/plain
# FIXME: what about the CFLAGS/CXXFLAGS?
isEmpty(RMLHOME) {
  error (rml required)
}

# include ... figure out how to define these things...
USE_MODPAR = 1

isEmpty(USE_MODPAR){
    SOURCES += TaskGraphExt_stub.cpp
} else {
    SOURCES += Codegen.cpp TaskMerging.cpp TaskGraph.cpp MergeRule.cpp \
	SingleChildMerge.cpp DuplicateParentMerge.cpp MergeAllParents.cpp \
	MergeSiblings.cpp Schedule.cpp TaskGraphExt.cpp solvers.cpp
}


NEWHS += Codegen.hpp               Schedule.hpp \
         DuplicateParentMerge.hpp  SingleChildMerge.hpp \
         MergeAllParents.hpp       TaskGraph.hpp \
         MergeRule.hpp             TaskMerging.hpp \
         MergeSiblings.hpp         reverse_depth_first_search.hpp \
         ParallelOptions.hpp       solvers.hpp

HEADERS += $${NEWHS}

# FIXME: deal with this too...
INCLUDEPATH += ../../mosh/src

# this is a little trick to force copying the header files to the sandbox
!exists(.FORCE.) {
  system(mkdir -p $${SANDBOX}/include)
  system(cp -a $${NEWHS} $${SANDBOX}/include)
}
