######################################################################
# hand generated file for libabsyn_builder

TEMPLATE = lib

DEPENDPATH  += .
INCLUDEPATH += .

win32: CONFIG += dll
unix:  CONFIG += staticlib

SANDBOX      = ../../build
INCLUDEPATH += $${SANDBOX}/include
DESTDIR      = $${SANDBOX}

CONFIG += debug_and_release
CONFIG(debug, debug|release) {
  TARGET = lib/absyn_builder
} else {
  TARGET = lib/absyn_builder
}
CONFIG += warn_on

# RML settings -- FIXME find a better way to actually find these...
INCLUDEPATH += /usr/include/plain
#LIBS        += /usr/lib/plain/librml.a # -lrml
LIBS        += -lantlr -lmodelica_parser -lflat_modelica_parser -lrm


SOURCES += parse.cpp

#############################################################
# buld the source using ANTLR
#############################################################

# find the class path and set up the antlr command
CLASSPATH = "$$system(java-config -p antlr)"
isEmpty(CLASSPATH) {
  error (Could not find antlr! )
}

#global defaults
isEmpty(ANTLR_DIR):ANTLR_DIR = $${SANDBOX}/include
isEmpty(ANTLR_CMD):ANTLR_CMD = java -cp $${CLASSPATH} antlr.Tool $${ANTLRFLAGS}

!exists(modelica_expression_parser.cpp){
  system ($${ANTLR_CMD} -glib \
            ../../modelica_parser/src/modelica_parser.g \
            expression_parser.g \
            $${SANDBOX}/include/modelica_parserTokenTypes.txt)
}
ANTLR_SOURCES += modelica_expression_parser.cpp
ANTLR_HEADERS += modelica_expression_parser.hpp \
                 modelica_expression_parserTokenTypes.hpp

!exists(modelica_tree_parser.cpp){
  system ($${ANTLR_CMD} walker.g \
          $${SANDBOX}/include/modelica_parserTokenTypes.txt)
}
ANTLR_SOURCES += modelica_tree_parser.cpp
ANTLR_HEADERS += modelica_tree_parser.hpp \
                 modelica_tree_parserTokenTypes.hpp

SOURCES += $${ANTLR_SOURCES}
HEADERS += $${ANTLR_HEADERS}

QMAKE_DISTCLEAN += $${ANTLR_SOURCES} $${ANTLR_HEADERS}
QMAKE_DISTCLEAN += modelica_parserTokenTypes.txt \
                   modelica_tree_parserTokenTypes.txt \
                   modelica_expression_parserTokenTypes.txt \
                   expandedtree_parser.g \
                   expandedexpression_parser.g \
                   modelica_parserTokenTypes.txt
