######################################################################

TEMPLATE = lib

DEPENDPATH  += .
INCLUDEPATH += .


SANDBOX = ../../build

INCLUDEPATH += $${SANDBOX}/include
DESTDIR      = $${SANDBOX}

CONFIG += debug_and_release
CONFIG += warn_on
CONFIG(debug, debug|release) {
    TARGET = lib/runtime_debug
} else {
    TARGET = lib/runtime
}


# CORBA settings
MICOHOME     = $$system(mico-config --prefix)
INCLUDEPATH += $${MICOHOME}/include

# RML settings -- FIXME find a better way to actually find these...
INCLUDEPATH += /usr/include/plain
LIBS        += /usr/lib/plain/librml.a # -lrml

#LIBS += ../absyn_builder/release/absyn_builder.a
#LIBS += ../../new_libs/libc_runtime/release/libc_runtime.a

# FIXME... conflicting types...
DEFINES += HAVE_SCANDIR

CONFIG += debug_and_release
CONFIG += warn_on

SOURCES	+= rtopts.c socketimpl.c printimpl.c systemimpl.c settingsimpl.c
SOURCES	+= ptolemyio.cpp daeext.cpp ErrorMessage.cpp errorext.cpp 

isEmpty(MICOHOME) {
  SOURCES += corbaimpl_stub.cpp
} else {
  SOURCES += corbaimpl.cpp

  IDL_GRAMMARS = omc_communication.idl

  #dependency to generate *.cc from *.idl
  idl_cc.name           = IDL_CC ${QMAKE_FILE_IN}
  idl_cc.commands       = idl ${QMAKE_FILE_NAME}
  idl_cc.variable_out   = SOURCES
  idl_cc.output         = ${QMAKE_FILE_BASE}.cc
  idl_cc.input          = IDL_GRAMMARS
  idl_cc.clean          = ${QMAKE_FILE_BASE}.cc
  QMAKE_EXTRA_COMPILERS += idl_cc

  #dependency to generate *.h from *.idl
  idl_h.name             = IDL_H ${QMAKE_FILE_IN}
  idl_h.commands         = idl ${QMAKE_FILE_NAME}
  idl_h.variable_out     = HEADERS
  idl_h.output           = ${QMAKE_FILE_BASE}.h
  idl_h.input            = IDL_GRAMMARS
  idl_h.clean            = ${QMAKE_FILE_BASE}.h
  QMAKE_EXTRA_COMPILERS += idl_h
}


#TEMPLATE = app
#
#DEPENDPATH  += .
#INCLUDEPATH += .
#INCLUDEPATH += ../../new_libs/libf2c/
#
#CONFIG += warn_on
##QT += network xml
#
#
#LIBS += /usr/lib/plain/librml.a # -lrml
#LIBS += ../absyn_builder/release/absyn_builder.a
#LIBS += ../../new_libs/libc_runtime/release/libc_runtime.a

#*******************************************
#              corba
#*******************************************

# FIXME: look at QMAKE_EXTRA_WIN_TARGETS
#   http://lists.gforge.inria.fr/pipermail/epsn-commits/2006-November/000049.html
#   look for eg3.tar.gz
#   and http://lists.kde.org/?l=kdevelop&m=120515407017330&w=2



##ifdef USE_CORBA
  MICOHOME     = $$system(mico-config --prefix)
  INCLUDEPATH += $${MICOHOME}/include
  MICO_LIBS    = $$system(mico-config --libs)
  LIBS        += $${MICO_LIBS}

#  SOURCES     += omc_communication.cc 
  SOURCES     += omc_communication_impl.cpp
#  SOURCES     += corbaimpl.cpp
##else
##  SOURCES     += corbaimpl_stub.cpp
##endif


#*******************************************
#              rml
#*******************************************
# FIXME: figure out how to generate this...
#INCLUDEPATH += /usr/include/plain
#
#
# generate omc_communication.cpp and omc_communication.h
#CFLAGS_FILE = . # needed to force qmake to run the generation commands
#omcc.output   = omc_communication.cc omc_communication.h
#omcc.input    = CFLAGS_FILE
#omcc.commands = idl omc_communication.idl
#omcc.variable_out = JUNK
#omcc.name = omc_communication.cc
#omcc.CONFIG = no_link
#QMAKE_EXTRA_COMPILERS += omcc
#SOURCES += omc_communication.cc

#SOURCES += rtopts.c socketimpl.c printimpl.c systemimpl.c settingsimpl.c
#
#SOURCES += ptolemyio.cpp daeext.cpp ErrorMessage.cpp errorext.cpp
#
#
#QMAKE_DISTCLEAN += release/*

