######################################################################

TEMPLATE     = lib
DEPENDPATH  += .
INCLUDEPATH += .

win32: CONFIG += dll
unix:  CONFIG += staticlib

SANDBOX      = ../build
INCLUDEPATH += $${SANDBOX}/include
DESTDIR      = $${SANDBOX}

CONFIG += debug_and_release
CONFIG(debug, debug|release) {
  TARGET = lib/c_runtime_debug
} else {
  TARGET = lib/c_runtime
}
CONFIG += warn_on

SOURCES += base_array.c     dogleg.c         lsame.c            r1updt.c \
           bigden.c         dpmpar.c         memory_pool.c      read_write.c \
           biglag.c         enorm.c          modelica_string.c  real_array.c \
           boolean_array.c  fdjac1.c         nelmead.c          string_array.c \
           daux.c           hybrd.c          newuoa.c           trsapp.c \
           ddasrt.c         hybrd1.c         newuob.c           update.c \
           ddassl.c         hybrj.c          qform.c            utility.c \
           dlamch.c         index_spec.c     qrfac.c \
           dlinpk.c         integer_array.c  r1mpyq.c

NEWHS += base_array.h  inline.h         modelica_string.h  string_array.h \
         blaswrap.h        integer_array.h  read_write.h       utility.h \
         boolean_array.h   matrix.h         real_array.h \
         f2c.h             memory_pool.h    solver_dasrt.h \
         index_spec.h      modelica.h       solver_euler.h
HEADERS += $${SANDBOX}/include/OpenModelica/sendData.h $${NEWHS}

# this is a little trick to force copying the header files to the sandbox
!exists(.FORCE.) {
  system(mkdir -p $${SANDBOX}/include)
  system(cp -a $${NEWHS} $${SANDBOX}/include)
}
