######################################################################


TEMPLATE     = lib
DEPENDPATH  += .
INCLUDEPATH += .

win32: CONFIG += dll
unix:  CONFIG += staticlib

SANDBOX = ../../build
DESTDIR = $${SANDBOX}

CONFIG += debug_and_release
CONFIG(debug, debug|release) {
  TARGET = lib/f2c_debug
} else {
  TARGET = lib/f2c
}
CONFIG      += warn_on

CFLAGS_FILE = . # needed to force qmake to run the generation commands

# generate f2c.h
f2c.output   = f2c.h
f2c.input    = CFLAGS_FILE
f2c.commands = \
    cp f2c.h0 f2c.h ; \
    cp -a f2c.h $${SANDBOX}/include
f2c.variable_out = JUNK
f2c.name = f2c.h
f2c.CONFIG = no_link
QMAKE_EXTRA_COMPILERS += f2c


# generate signal1.h and sysdep1.h
signal1.output   = signal1.h sysdep1.h
signal1.input    = CFLAGS_FILE
signal1.commands = \
    cp signal1.h0 signal1.h ; \
    cp sysdep1.h0 sysdep1.h ; \
    cp -a signal1.h sysdep1.h $${SANDBOX}/include
signal1.variable_out = JUNK
signal1.name = signal1.h
signal1.CONFIG = no_link
QMAKE_EXTRA_COMPILERS += signal1


# generate arith.h
arith.output   = arith.h
arith.input    = CFLAGS_FILE
arith.commands =  \
 	$(CC) $(CFLAGS) -DNO_FPINIT arithchk.c -lm -o a.exe ||\
	$(CC) -DNO_LONG_LONG $(CFLAGS) -DNO_FPINIT arithchk.c -lm -o a.exe ; \
	./a.exe > arith.h ; \
    cp -a arith.h $${SANDBOX}/include
arith.variable_out = JUNK
arith.name = arith.h
arith.CONFIG = no_link
QMAKE_EXTRA_COMPILERS += arith


# MISC
SOURCES += 	f77vers.c i77vers.c main.c s_rnge.c abort_.c exit_.c \
            getarg_.c iargc_.c getenv_.c signal_.c s_stop.c s_paus.c \
            system_.c cabs.c derf_.c derfc_.c erf_.c erfc_.c sig_die.c uninit.c
# POW
SOURCES +=	pow_ci.c pow_dd.c pow_di.c pow_hh.c pow_ii.c \
            pow_ri.c pow_zi.c pow_zz.c

# CX 
SOURCES +=	c_abs.c c_cos.c c_div.c c_exp.c c_log.c c_sin.c c_sqrt.c

# DCX 
SOURCES +=	z_abs.c z_cos.c z_div.c z_exp.c z_log.c z_sin.c z_sqrt.c

# REAL 
SOURCES +=	r_abs.c r_acos.c r_asin.c r_atan.c r_atn2.c r_cnjg.c r_cos.c\
	r_cosh.c r_dim.c r_exp.c r_imag.c r_int.c\
	r_lg10.c r_log.c r_mod.c r_nint.c r_sign.c\
	r_sin.c r_sinh.c r_sqrt.c r_tan.c r_tanh.c

# DBL 
SOURCES +=	d_abs.c d_acos.c d_asin.c d_atan.c d_atn2.c\
	d_cnjg.c d_cos.c d_cosh.c d_dim.c d_exp.c\
	d_imag.c d_int.c d_lg10.c d_log.c d_mod.c\
	d_nint.c d_prod.c d_sign.c d_sin.c d_sinh.c\
	d_sqrt.c d_tan.c d_tanh.c

# INT 
SOURCES +=	i_abs.c i_dim.c i_dnnt.c i_indx.c i_len.c i_mod.c \
    i_nint.c i_sign.c lbitbits.c lbitshft.c

# HALF 
SOURCES +=	h_abs.c h_dim.c h_dnnt.c h_indx.c h_len.c h_mod.c h_nint.c h_sign.c

# CMP 
SOURCES +=	l_ge.c l_gt.c l_le.c l_lt.c hl_ge.c hl_gt.c hl_le.c hl_lt.c

# EFL 
SOURCES +=	ef1asc_.c ef1cmc_.c

# CHAR 
SOURCES +=	f77_aloc.c s_cat.c s_cmp.c s_copy.c

# I77 
SOURCES +=	backspac.c close.c dfe.c dolio.c due.c endfile.c err.c\
	fmt.c fmtlib.c ftell_.c iio.c ilnw.c inquire.c lread.c lwrite.c\
	open.c rdfmt.c rewind.c rsfe.c rsli.c rsne.c sfe.c sue.c\
	typesize.c uio.c util.c wref.c wrtfmt.c wsfe.c wsle.c wsne.c xwsne.c

# FIXME: here is a problem with lingint...
# QINT 
#SOURCES +=	qbitbits.c qbitshft.c ftell64_.c pow_qq.c 

# TIME 
SOURCES +=	dtime_.c etime_.c


QMAKE_DISTCLEAN += a.exe sysdep1.h signal1.h f2c.h
