######################################################################


TEMPLATE     = lib
DEPENDPATH  += .
INCLUDEPATH += .

win32: CONFIG += dll
unix:  CONFIG += staticlib


SANDBOX = ../build

INCLUDEPATH += $${SANDBOX}/include
DESTDIR      = $${SANDBOX}

CONFIG += debug_and_release
CONFIG(debug, debug|release) {
  TARGET = lib/sim_debug
} else {
  TARGET = lib/sim
}
CONFIG      += warn_on

SOURCES += dgesv_aux.c            simulation_init.cpp     solver_dasrt.cpp \
           meta_modelica.c        simulation_input.cpp    solver_euler.cpp \
           options.cpp            simulation_result.cpp   tables.cpp \
           simulation_events.cpp  simulation_runtime.cpp

SOURCES += bigden.f   ddassl.f   dpmpar.f  hybrd1.f   newuoa.f  r1mpyq.f \
           biglag.f   dlamch.f   enorm.f   hybrj.f    newuob.f  r1updt.f \
           daux.f     dlinpk.f   fdjac1.f  lsame.f    qform.f   trsapp.f \
           ddasrt.f   dogleg.f   hybrd.f   nelmead.f  qrfac.f   update.f


NEWHS += meta_modelica.h      simulation_init.h    simulation_runtime.h \
         options.h            simulation_input.h   tables.h \
         simulation_events.h  simulation_result.h
HEADERS += $${SANDBOX}/include/OpenModelica/sendData.h \
           $${SANDBOX}/include/OpenModelica/f2c.h

# this is a little trick to force copying the header files to the sandbox
!exists(.FORCE.) {
  system(mkdir -p $${SANDBOX}/include)
  system(cp -a $${NEWHS} $${SANDBOX}/include)
}
