within SolarHouse;
package HVAC "Heating, ventilation and air conditioning"

  model HeaterModel "Simple on-off heater"
    extends Iface.BlockIcon;
    parameter SI.Temp_C Reference=20;
    parameter SI.Temp_C Hysteresis=1;
    parameter SI.Power PowerMax=400;
    Modelica.Blocks.Logical.OnOffController Controller(final bandwidth=
          Hysteresis) annotation (Placement(transformation(extent={{-2,30},{-22,
              50}}, rotation=0)));
    Modelica.Thermal.HeatTransfer.Sources.PrescribedHeatFlow HeatFlowOutput 
      annotation (Placement(transformation(extent={{40,-30},{60,-10}}, rotation
            =0)));
    annotation (Diagram(graphics),
                         Icon(graphics={
          Rectangle(
            extent={{-100,-100},{100,100}},
            lineColor={0,0,255},
            pattern=LinePattern.None,
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-78,-100},{76,30}},
            lineColor={0,0,0},
            pattern=LinePattern.None,
            fillPattern=FillPattern.VerticalCylinder,
            fillColor={255,255,255}),
          Ellipse(
            extent={{-64,-94},{54,-28}},
            lineColor={0,0,255},
            pattern=LinePattern.None,
            fillColor={255,255,0},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-62,-56},{-46,-20},{-18,2},{18,14},{-4,-8},{22,0},{16,-16},
                {26,-32},{42,-44},{-62,-56}},
            lineColor={0,0,255},
            pattern=LinePattern.None,
            fillColor={255,255,0},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-14,-86},{-44,-74},{-40,-54},{-28,-40},{-6,-30},{-14,-50},
                {4,-44},{0,-58},{18,-72},{12,-82},{-14,-86}},
            lineColor={0,0,255},
            pattern=LinePattern.None,
            fillColor={255,0,0},
            fillPattern=FillPattern.Solid)}));
    HT.Interfaces.HeatPort_b port annotation (Placement(transformation(extent={
              {100,-12},{120,8}}, rotation=0)));
    Modelica.Blocks.Sources.Constant ZeroPower(final k(
        quantity="Power",
        unit="W") = 0) annotation (Placement(transformation(extent={{-80,-46},{
              -60,-26}}, rotation=0)));
    Modelica.Blocks.Sources.Constant ReferenceTemp(final k(
        quantity="Temperature",
        unit="degC") = Reference) annotation (Placement(transformation(extent={
              {64,54},{44,74}}, rotation=0)));
    HT.Celsius.TemperatureSensor TemperatureInside 
      annotation (Placement(transformation(extent={{62,14},{42,34}}, rotation=0)));
    Modelica.Blocks.Logical.Switch Switch 
      annotation (Placement(transformation(extent={{-20,-30},{0,-10}}, rotation
            =0)));
    Modelica.Blocks.Sources.Constant MaxPower(final k(
        quantity="Power",
        unit="W") = PowerMax) annotation (Placement(transformation(extent={{-80,
              -14},{-60,6}}, rotation=0)));
  equation
    connect(HeatFlowOutput.port, port) annotation (Line(points={{60,-20},{82,
            -20},{82,-2},{110,-2}}, color={191,0,0}));
    connect(TemperatureInside.port, port) annotation (Line(points={{62,24},{82,
            24},{82,-2},{110,-2}}, color={191,0,0}));
    connect(ReferenceTemp.y, Controller.reference) annotation (Line(points={{43,
            64},{22,64},{22,46},{6.66134e-16,46}}, color={0,0,127}));
    connect(TemperatureInside.T, Controller.u) annotation (Line(points={{42,24},
            {22,24},{22,34},{6.66134e-16,34}}, color={0,0,127}));
    connect(Controller.y, Switch.u2) annotation (Line(points={{-23,40},{-34,40},
            {-34,-20},{-22,-20}}, color={255,0,255}));
    connect(Switch.y, HeatFlowOutput.Q_flow) annotation (Line(points={{1,-20},{
            40,-20}}, color={0,0,127}));
    connect(MaxPower.y, Switch.u1) annotation (Line(
        points={{-59,-4},{-40,-4},{-40,-12},{-22,-12}},
        color={0,0,127},
        pattern=LinePattern.None));
    connect(ZeroPower.y, Switch.u3) annotation (Line(
        points={{-59,-36},{-40,-36},{-40,-28},{-22,-28}},
        color={0,0,127},
        pattern=LinePattern.None));
  end HeaterModel;
end HVAC;
