within SolarHouse;
package Interfaces
  connector SunLight "Connector for solar radiation"
    SI.HeatFlux q_dir "Direct solar radiation";
    SI.HeatFlux q_dif "Diffuse solar radiation";
    Real dir[3] "Direction of solar radiation";
  end SunLight;

  connector DirLightIn = input SunLight annotation (Icon(graphics={Text(
          extent={{-98,196},{102,102}},
          lineColor={255,127,0},
          textString=
               "%name"), Polygon(
          points={{-100,100},{100,0},{-100,-100},{-100,100}},
          lineColor={161,161,54},
          fillColor={161,161,54},
          fillPattern=FillPattern.Solid)}),
                            Diagram(graphics={Text(
          extent={{-120,120},{100,60}},
          lineColor={161,161,54},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid,
          textString=
               "%name"), Polygon(
          points={{0,50},{100,0},{0,-50},{0,50}},
          lineColor={0,0,255},
          pattern=LinePattern.None,
          fillColor={161,161,54},
          fillPattern=FillPattern.Solid)}));
  connector DirLightOut = output SunLight annotation (Icon(graphics={Text(
          extent={{-98,196},{102,102}},
          lineColor={255,127,0},
          textString=
               "%name"), Polygon(
          points={{-100,100},{100,0},{-100,-100},{-100,100}},
          lineColor={161,161,54},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid)}),
                                         Diagram(graphics={Text(
          extent={{-120,120},{100,60}},
          lineColor={161,161,54},
          textString=
               "%name"), Polygon(
          points={{-100,50},{0,0},{-100,-50},{-100,50}},
          lineColor={161,161,54},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid)}));
  connector LightHeat
    "Heat transfer of the thermal solar radiation with two components: direct and diffuse"
    SI.HeatFlowRate q_dir "Direct solar radiation";
    SI.HeatFlowRate q_dif "Diffuse solar radiation";
    annotation (Documentation(info="<html>
Connector used in transfer of solar radiation through panes - direction of sun's rays is no longer important.
</html>"));
  end LightHeat;

  connector LightIn = input LightHeat "Undirected solar radiation" 
                                                         annotation (Icon(graphics
        ={Text(
          extent={{-98,196},{102,102}},
          lineColor={255,127,0},
          textString=
               "%name"), Polygon(
          points={{-100,100},{-100,-100},{100,0},{-100,100}},
          lineColor={0,0,255},
          pattern=LinePattern.None,
          fillColor={255,170,85},
          fillPattern=FillPattern.Solid)}),
                            Diagram(graphics={Text(
          extent={{-120,120},{100,60}},
          lineColor={255,170,85},
          lineThickness=0.5,
          fillColor={255,170,85},
          fillPattern=FillPattern.Solid,
          textString=
               "%name"), Polygon(
          points={{0,50},{100,0},{0,-50},{0,50}},
          lineColor={0,0,255},
          pattern=LinePattern.None,
          fillColor={255,170,85},
          fillPattern=FillPattern.Solid)}));
  connector LightOut = output LightHeat "Undirected solar" annotation (Icon(graphics
        ={Text(
          extent={{-98,196},{102,102}},
          lineColor={255,127,0},
          textString=
               "%name"), Polygon(
          points={{-100,100},{-100,-100},{100,0},{-100,100}},
          lineColor={255,170,85},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid)}),
                                         Diagram(graphics={Text(
          extent={{-120,120},{100,60}},
          lineColor={255,170,85},
          lineThickness=0.5,
          fillColor={255,170,85},
          fillPattern=FillPattern.Solid,
          textString=
               "%name"), Polygon(
          points={{-100,50},{-100,-50},{0,0},{-100,50}},
          lineColor={255,170,85},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid)}));
  connector HeatFluxPort
    "Same as HeatPort from Thermal/HeatTransfer with HeatFlux for Q_flow"
    SI.Temperature T "Port temperature";
    flow SI.HeatFlux Q_flux
      "Heat flux (positive if flowing from outside into the component)";
  end HeatFluxPort;

  connector HeatFluxPort_a
    "Thermal port for 1-dim. heat transfer (filled rectangular icon)"
    extends HeatFluxPort;
    annotation (
      defaultComponentName="port_a",
      Documentation(info="<HTML>
<p>This connector is used for 1-dimensional heat flux between components.
The variables in the connector are:</p>
<pre>   
   T       Temperature in [Kelvin].
   Q_flow  Heat flux in [Watt/m^2].
</pre>
<p>This connector is only slightly changed copy of connector found in <i>Modelica Standard Library</i> (Thermal/HeatTransfer) with intention to get rid of surface area dependencies in some blocks.</p></HTML>
"),   Icon(graphics={Rectangle(
            extent={{-100,100},{100,-100}},
            lineColor={255,0,0},
            fillColor={255,0,0},
            fillPattern=FillPattern.Solid), Text(
            extent={{-98,196},{102,102}},
            lineColor={255,0,0},
            textString=
                 "%name")}),
      Diagram(graphics={Rectangle(
            extent={{0,50},{100,-50}},
            lineColor={255,0,0},
            fillColor={255,0,0},
            fillPattern=FillPattern.Solid), Text(
            extent={{-120,120},{100,60}},
            lineColor={255,0,0},
            textString=
                 "%name")}));
  end HeatFluxPort_a;

  connector HeatFluxPort_b
    "Thermal port for 1-dim. heat transfer (unfilled rectangular icon)"
    extends HeatFluxPort;
    annotation (
      defaultComponentName="port_b",
      Documentation(info="<HTML>
<p>This connector is used for 1-dimensional heat flux between components.
The variables in the connector are:</p>
<pre>   
   T       Temperature in [Kelvin].
   Q_flow  Heat flux in [Watt/m^2].
</pre>
<p>This connector is only slightly changed copy of connector found in <i>Modelica Standard Library</i> (Thermal/HeatTransfer) with intention to get rid of surface area dependencies in some blocks.</p>
</HTML>
"),   Diagram(graphics={Rectangle(
            extent={{-100,50},{0,-50}},
            lineColor={255,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid), Text(
            extent={{-100,120},{120,60}},
            lineColor={255,0,0},
            textString=
                 "%name")}),
      Icon(graphics={Rectangle(
            extent={{-100,100},{100,-100}},
            lineColor={255,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid), Text(
            extent={{-98,196},{102,102}},
            lineColor={255,0,0},
            textString=
                 "%name")}));
  end HeatFluxPort_b;

  type SpecificPlaneHeatCapacity = Real (
      quantity="SpecificPlaneHeatCapacity",
      unit="W.s/(m2.K)",
      min=0) "Specific heat capacity defined for unit plane.";
  annotation (Documentation(info="<html>
A few custom defined interfaces mainly used in calculation of the thermal-solar-radiation distribution.
</html>"));
end Interfaces;
