within ;
package SolarHouse 
import Modelica.*;
import SI = Modelica.SIunits;
import Const = Modelica.Constants;
import HT = Modelica.Thermal.HeatTransfer;
import Iface = Modelica.Blocks.Interfaces;
import Modelica.SIunits.Conversions.*;


  annotation (Documentation(info="<html>
  A library for solar house modelling. It was built upon model of real-world test chamber and thus includes many components implementing empirical expressions which were derived from experimentation on the test chamber.

<h3>References</h3>
<ol>
 <li>A. Sodja, B. Zupancic. <i>Modelling thermal processes in buildings using an object-oriented approach and Modelica</i>, Simulation Modelling Practice and Theory 17 (2009) 1143-1159.</li>
 <li>I. Skrjanc, B. Zupancic, B. Furlan, A. Krainer. <i>Theoretical and experimental fuzzy modelling of building 
thermal dynamic response</i>, Building and Environment 39 (9) (2001) 1023-1038.</li>
</ol>
</html>"),  version="1");
end SolarHouse;
