//Simulation code for PulseError
//Generated by OpenModelica.

#include "modelica.h"

#include "assert.h"

#include "string.h"

#include "simulation_runtime.h"

#include "PulseError_functions.cpp"
extern "C" {

}

#define NHELP 4
#define NG 8//number of zero crossing
#define NX 1
#define NY 7
#define NP 16 // number of paramters
#define NO 0 // number of outputvar on topmodel
#define NI 0 // number of inputvar on topmodel
#define NR 4 // number of residuals for initialialization function
#define NEXT 0 // number of external objects
#define MAXORD 5
#define NYSTR 0 // number of alg. string variables
#define NPSTR 0 // number of alg. string variables



static DATA* localData = 0;
#define time localData->timeValue
char *model_name="PulseError";
char *model_dir="";
char* state_names[1]={"$dummy"};
char* derivative_names[1]={"der($dummy)"};
char* algvars_names[7]={"pulse.y", "pulse.T0", "pulse.T_width", "trapezoid.y", "trapezoid.T0", "trapezoid.counter", "trapezoid.counter2"};
char* input_names[1] = {""};
char* output_names[1] = {""};
char* param_names[16]={"pulse.amplitude", "pulse.width", "pulse.period", "pulse.offset", "pulse.startTime", "trapezoid.amplitude", "trapezoid.rising", "trapezoid.width", "trapezoid.falling", "trapezoid.period", "trapezoid.nperiod", "trapezoid.offset", "trapezoid.startTime", "trapezoid.T_rising", "trapezoid.T_width", "trapezoid.T_falling"};
char* string_alg_names[1] = {""};
char* string_param_names[1] = {""};

char* state_comments[1]={""};
char* derivative_comments[1]={""};
char* algvars_comments[7]={ "Connector of Real output signal",  "Start time of current period", "",  "Connector of Real output signal",  "Start time of current period",  "Period counter", ""};
char* input_comments[1] = {""};
char* output_comments[1] = {""};
char* param_comments[16]={ "Amplitude of pulse",  "Width of pulse in % of periods",  "Time for one period",  "Offset of output signals",  "Output = offset for time < startTime",  "Amplitude of trapezoid",  "Rising duration of trapezoid",  "Width duration of trapezoid",  "Falling duration of trapezoid",  "Time for one period",  "Number of periods (< 0 means infinite number of periods)",  "Offset of output signal",  "Output = offset for time < startTime",  "End time of rising phase within one period",  "End time of width phase within one period",  "End time of falling phase within one period"};
char* string_param_comments[16]={ "Amplitude of pulse",  "Width of pulse in % of periods",  "Time for one period",  "Offset of output signals",  "Output = offset for time < startTime",  "Amplitude of trapezoid",  "Rising duration of trapezoid",  "Width duration of trapezoid",  "Falling duration of trapezoid",  "Time for one period",  "Number of periods (< 0 means infinite number of periods)",  "Offset of output signal",  "Output = offset for time < startTime",  "End time of rising phase within one period",  "End time of width phase within one period",  "End time of falling phase within one period"};
char* string_alg_comments[16]={ "Amplitude of pulse",  "Width of pulse in % of periods",  "Time for one period",  "Offset of output signals",  "Output = offset for time < startTime",  "Amplitude of trapezoid",  "Rising duration of trapezoid",  "Width duration of trapezoid",  "Falling duration of trapezoid",  "Time for one period",  "Number of periods (< 0 means infinite number of periods)",  "Offset of output signal",  "Output = offset for time < startTime",  "End time of rising phase within one period",  "End time of width phase within one period",  "End time of falling phase within one period"};

#define $trapezoid$pointT_falling localData->parameters[15]
#define $trapezoid$pointT_width localData->parameters[14]
#define $trapezoid$pointT_rising localData->parameters[13]
#define $trapezoid$pointstartTime localData->parameters[12]
#define $trapezoid$pointoffset localData->parameters[11]
#define $trapezoid$pointnperiod localData->parameters[10]
#define $trapezoid$pointperiod localData->parameters[9]
#define $trapezoid$pointfalling localData->parameters[8]
#define $trapezoid$pointwidth localData->parameters[7]
#define $trapezoid$pointrising localData->parameters[6]
#define $trapezoid$pointamplitude localData->parameters[5]
#define $pulse$pointstartTime localData->parameters[4]
#define $pulse$pointoffset localData->parameters[3]
#define $pulse$pointperiod localData->parameters[2]
#define $pulse$pointwidth localData->parameters[1]
#define $pulse$pointamplitude localData->parameters[0]
#define $trapezoid$pointcounter2 localData->algebraics[6]
#define $trapezoid$pointcounter localData->algebraics[5]
#define $trapezoid$pointT0 localData->algebraics[4]
#define $trapezoid$pointy localData->algebraics[3]
#define $pulse$pointT_width localData->algebraics[2]
#define $pulse$pointT0 localData->algebraics[1]
#define $pulse$pointy localData->algebraics[0]
#define $$dummy localData->states[0]
#define $derivative$$dummy localData->statesDerivatives[0]

char* getName( double* ptr)
{
  if( &$trapezoid$pointcounter2 == ptr ) return algvars_names[6];
  if( &$trapezoid$pointcounter == ptr ) return algvars_names[5];
  if( &$trapezoid$pointT0 == ptr ) return algvars_names[4];
  if( &$trapezoid$pointy == ptr ) return algvars_names[3];
  if( &$pulse$pointT_width == ptr ) return algvars_names[2];
  if( &$pulse$pointT0 == ptr ) return algvars_names[1];
  if( &$pulse$pointy == ptr ) return algvars_names[0];
  if( &$derivative$$dummy == ptr ) return derivative_names[0];
  if( &$$dummy == ptr ) return state_names[0];

  return "";
}
static char init_fixed[NX+NX+NY+NP]={1/*$dummy*/, 1/*default*/, 0/*pulse.y*/, 0/*pulse.T0*/, 
0/*pulse.T_width*/, 0/*trapezoid.y*/, 0/*trapezoid.T0*/, 
0/*trapezoid.counter*/, 0/*trapezoid.counter2*/, 1/*pulse.amplitude*/, 
1/*pulse.width*/, 1/*pulse.period*/, 1/*pulse.offset*/, 
1/*pulse.startTime*/, 1/*trapezoid.amplitude*/, 1/*trapezoid.rising*/, 
1/*trapezoid.width*/, 1/*trapezoid.falling*/, 1/*trapezoid.period*/, 
1/*trapezoid.nperiod*/, 1/*trapezoid.offset*/, 1/*trapezoid.startTime*/, 
1/*trapezoid.T_rising*/, 1/*trapezoid.T_width*/, 1/*trapezoid.T_falling*/};
char var_attr[NX+NY+NP]={/*$dummy:*/1+0, /*pulse.y:*/1+0, /*pulse.T0:*/1+16, /*pulse.T_width:*/1+0, 
/*trapezoid.y:*/1+0, /*trapezoid.T0:*/1+16, /*trapezoid.counter:*/4+16, 
/*trapezoid.counter2:*/4+16, /*pulse.amplitude:*/1+0, /*pulse.width:*/1+0, 
/*pulse.period:*/1+0, /*pulse.offset:*/1+0, /*pulse.startTime:*/1+0, 
/*trapezoid.amplitude:*/1+0, /*trapezoid.rising:*/1+0, /*trapezoid.width:*/1+0, 
/*trapezoid.falling:*/1+0, /*trapezoid.period:*/1+0, /*trapezoid.nperiod:*/4+16, 
/*trapezoid.offset:*/1+0, /*trapezoid.startTime:*/1+0, /*trapezoid.T_rising:*/1+0, 
/*trapezoid.T_width:*/1+0, /*trapezoid.T_falling:*/1+0};
#define DIVISION(a,b,c) ((b != 0) ? a / b : a / division_error(b,c))


int encounteredDivisionByZero = 0;
double division_error(double b,const char* division_str)
{
  if(!encounteredDivisionByZero){
    fprintf(stderr,"ERROR: Division by zero in partial equation: %s.\n",division_str);
    encounteredDivisionByZero = 1;
   }   return b;
}


void setLocalData(DATA* data)
{

   localData = data;
}

DATA* initializeDataStruc(DATA_FLAGS flags)
{


  DATA* returnData = (DATA*)malloc(sizeof(DATA));

  if(!returnData) //error check

    return 0;

  returnData->nStates = NX;

  returnData->nAlgebraic = NY;

  returnData->nParameters = NP;

  returnData->nInputVars = NI;

  returnData->nOutputVars = NO;

  returnData->nZeroCrossing = NG;

  returnData->nInitialResiduals = NR;

  returnData->nHelpVars = NHELP;
  returnData->stringVariables.nParameters = NPSTR;

  returnData->stringVariables.nAlgebraic = NYSTR;
  if(flags & STATES && returnData->nStates){

    returnData->states = (double*) malloc(sizeof(double)*returnData->nStates);

    returnData->oldStates = (double*) malloc(sizeof(double)*returnData->nStates);

    returnData->oldStates2 = (double*) malloc(sizeof(double)*returnData->nStates);

    assert(returnData->states&&returnData->oldStates&&returnData->oldStates2);
    memset(returnData->states,0,sizeof(double)*returnData->nStates);

    memset(returnData->oldStates,0,sizeof(double)*returnData->nStates);

    memset(returnData->oldStates2,0,sizeof(double)*returnData->nStates);
    
  }else{

    returnData->states = 0;

    returnData->oldStates = 0;

    returnData->oldStates2 = 0;

  }
  if(flags & STATESDERIVATIVES && returnData->nStates){

    returnData->statesDerivatives = (double*) malloc(sizeof(double)*returnData->nStates);

    returnData->oldStatesDerivatives = (double*) malloc(sizeof(double)*returnData->nStates);

    returnData->oldStatesDerivatives2 = (double*) malloc(sizeof(double)*returnData->nStates);

    assert(returnData->statesDerivatives&&returnData->oldStatesDerivatives&&returnData->oldStatesDerivatives2);
    memset(returnData->statesDerivatives,0,sizeof(double)*returnData->nStates);

    memset(returnData->oldStatesDerivatives,0,sizeof(double)*returnData->nStates);

    memset(returnData->oldStatesDerivatives2,0,sizeof(double)*returnData->nStates);
    
  }else{

    returnData->statesDerivatives = 0;

    returnData->oldStatesDerivatives = 0;

    returnData->oldStatesDerivatives2 = 0;

  }
  if(flags & HELPVARS && returnData->nHelpVars){

    returnData->helpVars = (double*) malloc(sizeof(double)*returnData->nHelpVars);

    assert(returnData->helpVars);
    memset(returnData->helpVars,0,sizeof(double)*returnData->nHelpVars);
  }else{

    returnData->helpVars = 0;

  }
  if(flags & ALGEBRAICS && returnData->nAlgebraic){

    returnData->algebraics = (double*) malloc(sizeof(double)*returnData->nAlgebraic);

    returnData->oldAlgebraics = (double*) malloc(sizeof(double)*returnData->nAlgebraic);

    returnData->oldAlgebraics2 = (double*) malloc(sizeof(double)*returnData->nAlgebraic);
        
     assert(returnData->algebraics&&returnData->oldAlgebraics&&returnData->oldAlgebraics2);
    memset(returnData->algebraics,0,sizeof(double)*returnData->nAlgebraic);

    memset(returnData->oldAlgebraics,0,sizeof(double)*returnData->nAlgebraic);

    memset(returnData->oldAlgebraics2,0,sizeof(double)*returnData->nAlgebraic);

  }else{

    returnData->algebraics = 0;

    returnData->oldAlgebraics = 0;

    returnData->oldAlgebraics2 = 0;
    
    returnData->stringVariables.algebraics = 0;
  }
if (flags & ALGEBRAICS && returnData->stringVariables.nAlgebraic) {
    returnData->stringVariables.algebraics = (char**)malloc(sizeof(char*)*returnData->stringVariables.nAlgebraic);

    assert(returnData->stringVariables.algebraics);

    memset(returnData->stringVariables.algebraics,0,sizeof(char*)*returnData->stringVariables.nAlgebraic);

    } else {
    returnData->stringVariables.algebraics=0;

    }  if(flags & PARAMETERS && returnData->nParameters){

    returnData->parameters = (double*) malloc(sizeof(double)*returnData->nParameters);

    assert(returnData->parameters);
    memset(returnData->parameters,0,sizeof(double)*returnData->nParameters);
  }else{

    returnData->parameters = 0;

  }
if (flags & PARAMETERS && returnData->stringVariables.nParameters) {
  	  returnData->stringVariables.parameters = (char**)malloc(sizeof(char*)*returnData->stringVariables.nParameters);

      assert(returnData->stringVariables.parameters);

      memset(returnData->stringVariables.parameters,0,sizeof(char*)*returnData->stringVariables.nParameters);

    } else {
      returnData->stringVariables.parameters=0;

    } if(flags & OUTPUTVARS && returnData->nOutputVars){

    returnData->outputVars = (double*) malloc(sizeof(double)*returnData->nOutputVars);

    assert(returnData->outputVars);
    memset(returnData->outputVars,0,sizeof(double)*returnData->nOutputVars);
  }else{

    returnData->outputVars = 0;

  }
  if(flags & INPUTVARS && returnData->nInputVars){

    returnData->inputVars = (double*) malloc(sizeof(double)*returnData->nInputVars);

    assert(returnData->inputVars);
    memset(returnData->inputVars,0,sizeof(double)*returnData->nInputVars);
  }else{

    returnData->inputVars = 0;

  }
  if(flags & INITIALRESIDUALS && returnData->nInitialResiduals){

    returnData->initialResiduals = (double*) malloc(sizeof(double)*returnData->nInitialResiduals);

    assert(returnData->initialResiduals);
    memset(returnData->initialResiduals,0,sizeof(double)*returnData->nInitialResiduals);
  }else{

    returnData->initialResiduals = 0;

  }
  if(flags & INITFIXED){

    returnData->initFixed = init_fixed;

  }else{

    returnData->initFixed = 0;

  }

  /*   names   */

  if(flags & MODELNAME){

    returnData->modelName = model_name;

  }else{

    returnData->modelName = 0;

  }

  if(flags & STATESNAMES){

    returnData->statesNames = state_names;

  }else{

    returnData->statesNames = 0;

  }
if(flags & STATESDERIVATIVESNAMES){

    returnData->stateDerivativesNames = derivative_names;

  }else{

    returnData->stateDerivativesNames = 0;

  }
if(flags & ALGEBRAICSNAMES){

    returnData->algebraicsNames = algvars_names;

  }else{

    returnData->algebraicsNames = 0;

  }
if(flags & PARAMETERSNAMES){

    returnData->parametersNames = param_names;

  }else{

    returnData->parametersNames = 0;

  }
if(flags & INPUTNAMES){

    returnData->inputNames = input_names;

  }else{

    returnData->inputNames = 0;

  }
if(flags & OUTPUTNAMES){

    returnData->outputNames = output_names;

  }else{

    returnData->outputNames = 0;

  }

  /*   comments  */

  if(flags & STATESCOMMENTS){

    returnData->statesComments = state_comments;

  }else{

    returnData->statesComments = 0;

  }
if(flags & STATESDERIVATIVESCOMMENTS){

    returnData->stateDerivativesComments = derivative_comments;

  }else{

    returnData->stateDerivativesComments = 0;

  }
if(flags & ALGEBRAICSCOMMENTS){

    returnData->algebraicsComments = algvars_comments;

  }else{

    returnData->algebraicsComments = 0;

  }
if(flags & PARAMETERSCOMMENTS){

    returnData->parametersComments = param_comments;

  }else{

    returnData->parametersComments = 0;

  }
if(flags & INPUTCOMMENTS){

    returnData->inputComments = input_comments;

  }else{

    returnData->inputComments = 0;

  }
if(flags & OUTPUTCOMMENTS){

    returnData->outputComments = output_comments;

  }else{

    returnData->outputComments = 0;

  }
if (flags & EXTERNALVARS) {

  returnData->extObjs = (void**)malloc(sizeof(void*)*NEXT);

  if (!returnData->extObjs) { 

     printf("error allocating external objects\n");

     exit(-2);

  }
setLocalData(returnData); /* must be set since used by constructors*/


  }

  return returnData;

}
void deInitializeDataStruc(DATA* data, DATA_FLAGS flags)

{
  if(!data)

    return;
  if(flags & STATES && data->states){
    free(data->states);
    data->states = 0;
  }
  if(flags & STATESDERIVATIVES && data->statesDerivatives){
    free(data->statesDerivatives);
    data->statesDerivatives = 0;
  }
  if(flags & ALGEBRAICS && data->algebraics){
    free(data->algebraics);
    data->algebraics = 0;
  }
  if(flags & PARAMETERS && data->parameters){
    free(data->parameters);
    data->parameters = 0;
  }
  if(flags & OUTPUTVARS && data->inputVars){
    free(data->inputVars);
    data->inputVars = 0;
  }
  if(flags & INPUTVARS && data->outputVars){

    free(data->outputVars);

    data->outputVars = 0;

  }

  if(flags & INITIALRESIDUALS && data->initialResiduals){

    free(data->initialResiduals);

    data->initialResiduals = 0;

  }

  if (flags & EXTERNALVARS && data->extObjs) {



    free(data->extObjs);

    data->extObjs = 0;

  }

}

int functionDAE_output()
{
  state mem_state;
  modelica_boolean tmp0;
  modelica_boolean tmp1;
  modelica_boolean tmp2;
  modelica_boolean tmp3;
  modelica_boolean tmp4;
  modelica_boolean tmp5;
  modelica_boolean tmp6;


  mem_state = get_memory_state();
  RELATIONLESS(tmp0,time,$trapezoid$pointstartTime);
  RELATIONGREATEREQ(tmp1,time,($trapezoid$pointT0 + $trapezoid$pointT_falling));
  tmp2 = ((tmp0 || ((modelica_integer)$trapezoid$pointcounter2 == 0)) || tmp1);
  if (tmp2) {
  }
  else {
    RELATIONLESS(tmp3,time,($trapezoid$pointT0 + $trapezoid$pointT_rising));
    tmp4 = tmp3;
    if (tmp4) {
    }
    else {
      RELATIONLESS(tmp5,time,($trapezoid$pointT0 + $trapezoid$pointT_width));
      tmp6 = tmp5;
      if (tmp6) {
      }
      else {
      }
    }
  }
  $trapezoid$pointy = ($trapezoid$pointoffset + ((tmp2)?0.0:((tmp4)?(((time - $trapezoid$pointT0) * $trapezoid$pointamplitude) / $trapezoid$pointT_rising):((tmp6)?$trapezoid$pointamplitude:(((($trapezoid$pointT0 + $trapezoid$pointT_falling) - time) * $trapezoid$pointamplitude) / ($trapezoid$pointT_falling - $trapezoid$pointT_width))))));


  restore_memory_state(mem_state);
  return 0;

}
int functionDAE_output2()
{
  state mem_state;
  modelica_boolean tmp0;
  modelica_boolean tmp1;
  modelica_boolean tmp2;


  mem_state = get_memory_state();
  $pulse$pointT_width = (($pulse$pointperiod * $pulse$pointwidth) / 100.0);

  RELATIONLESS(tmp0,time,$pulse$pointstartTime);
  RELATIONGREATEREQ(tmp1,time,($pulse$pointT0 + $pulse$pointT_width));
  tmp2 = (tmp0 || tmp1);
  if (tmp2) {
  }
  else {
  }
  $pulse$pointy = ($pulse$pointoffset + ((tmp2)?0.0:$pulse$pointamplitude));


  restore_memory_state(mem_state);
  return 0;

}

/*
*/
int input_function()
{
  return 0;

}

/*
*/
int output_function()
{
  return 0;

}
int functionDAE_res(double *t, double *x, double *xd, double *delta, long int *ires, double *rpar, long int* ipar)
{
  int i;
  double temp_xd[NX];
  double* statesBackup;
  double* statesDerivativesBackup;
  double timeBackup;


  statesBackup = localData->states;
  statesDerivativesBackup = localData->statesDerivatives;
  timeBackup = localData->timeValue;
  localData->states = x;
  for (i=0; i<localData->nStates; i++) temp_xd[i]=localData->statesDerivatives[i];
  
  localData->statesDerivatives = temp_xd;
  localData->timeValue = *t;
  
  functionODE();
  /* get the difference between the temp_xd(=localData->statesDerivatives) and xd(=statesDerivativesBackup)*/
   for (i=0; i < localData->nStates; i++) delta[i]=localData->statesDerivatives[i]-statesDerivativesBackup[i];
  
  localData->states = statesBackup;
  localData->statesDerivatives = statesDerivativesBackup;
  localData->timeValue = timeBackup;
  if (modelErrorCode) {
    if (ires) *ires = -1;
    modelErrorCode =0;
  }
  return 0;


}
int function_zeroCrossing(long *neqm, double *t, double *x, long *ng, double *gout, double *rpar, long* ipar)
{
  double timeBackup;
  state mem_state;


  mem_state = get_memory_state();
  timeBackup = localData->timeValue;
  localData->timeValue = *t;
  functionODE();
  functionDAE_output();
  ZEROCROSSING(0,Less(time,$trapezoid$pointT0 + $trapezoid$pointT_width));

  ZEROCROSSING(1,Less(time,$trapezoid$pointT0 + $trapezoid$pointT_rising));

  ZEROCROSSING(2,GreaterEq(time,$trapezoid$pointT0 + $trapezoid$pointT_falling));

  ZEROCROSSING(3,Less(time,$trapezoid$pointstartTime));

  ZEROCROSSING(4,GreaterEq(time,$pulse$pointT0 + $pulse$pointT_width));

  ZEROCROSSING(5,Less(time,$pulse$pointstartTime));

  ZEROCROSSING(6,Sample(*t,$pulse$pointstartTime,$pulse$pointperiod));

  ZEROCROSSING(7,Sample(*t,$trapezoid$pointstartTime,$trapezoid$pointperiod));


  restore_memory_state(mem_state);
  localData->timeValue = timeBackup;
  return 0;

}
int handleZeroCrossing(long index)
{
  state mem_state;


  mem_state = get_memory_state();
  switch(index) {
    case 0:

    save($trapezoid$pointy);
    break;
    case 1:

    save($trapezoid$pointy);
    break;
    case 2:

    save($trapezoid$pointy);
    break;
    case 3:

    save($trapezoid$pointy);
    break;
    case 4:

    save($pulse$pointy);
    break;
    case 5:

    save($pulse$pointy);
    break;
    case 6:

    break;
    case 7:

    break;

    default: break;
  }
  restore_memory_state(mem_state);
  return 0;

}
int function_updateDependents()
{
  state mem_state;
  sin_rettype tmp0;
  modelica_boolean tmp1;
  modelica_boolean tmp2;
  modelica_boolean tmp3;
  modelica_boolean tmp4;
  modelica_boolean tmp5;
  modelica_boolean tmp6;
  modelica_boolean tmp7;
  modelica_boolean tmp8;
  modelica_boolean tmp9;
  modelica_boolean tmp10;
  sample_rettype tmp11;
  modelica_integer tmp12;
  sample_rettype tmp13;
  modelica_integer tmp14;
  sample_rettype tmp15;
  modelica_integer tmp16;
  sample_rettype tmp17;

  inUpdate=initial()?0:1;

  mem_state = get_memory_state();
  tmp0 = sin((time * 628.318530717));
  $derivative$$dummy = tmp0;
  RELATIONLESS(tmp1,time,$trapezoid$pointstartTime);
  RELATIONGREATEREQ(tmp2,time,($trapezoid$pointT0 + $trapezoid$pointT_falling));
  tmp3 = ((tmp1 || ((modelica_integer)$trapezoid$pointcounter2 == 0)) || tmp2);
  if (tmp3) {
  }
  else {
    RELATIONLESS(tmp4,time,($trapezoid$pointT0 + $trapezoid$pointT_rising));
    tmp5 = tmp4;
    if (tmp5) {
    }
    else {
      RELATIONLESS(tmp6,time,($trapezoid$pointT0 + $trapezoid$pointT_width));
      tmp7 = tmp6;
      if (tmp7) {
      }
      else {
      }
    }
  }
  $trapezoid$pointy = ($trapezoid$pointoffset + ((tmp3)?0.0:((tmp5)?(((time - $trapezoid$pointT0) * $trapezoid$pointamplitude) / $trapezoid$pointT_rising):((tmp7)?$trapezoid$pointamplitude:(((($trapezoid$pointT0 + $trapezoid$pointT_falling) - time) * $trapezoid$pointamplitude) / ($trapezoid$pointT_falling - $trapezoid$pointT_width))))));
  $pulse$pointT_width = (($pulse$pointperiod * $pulse$pointwidth) / 100.0);
  RELATIONLESS(tmp8,time,$pulse$pointstartTime);
  RELATIONGREATEREQ(tmp9,time,($pulse$pointT0 + $pulse$pointT_width));
  tmp10 = (tmp8 || tmp9);
  if (tmp10) {
  }
  else {
  }
  $pulse$pointy = ($pulse$pointoffset + ((tmp10)?0.0:$pulse$pointamplitude));
  tmp11 = sample($pulse$pointstartTime, $pulse$pointperiod);
  localData->helpVars[3] = tmp11;
  tmp12 = (modelica_integer)pre($trapezoid$pointcounter2);
  tmp13 = sample($trapezoid$pointstartTime, $trapezoid$pointperiod);
  localData->helpVars[2] = ((tmp12 != 0) && tmp13);
  tmp14 = (modelica_integer)pre($trapezoid$pointcounter2);
  tmp15 = sample($trapezoid$pointstartTime, $trapezoid$pointperiod);
  localData->helpVars[1] = ((tmp14 != 0) && tmp15);
  tmp16 = (modelica_integer)pre($trapezoid$pointcounter2);
  tmp17 = sample($trapezoid$pointstartTime, $trapezoid$pointperiod);
  localData->helpVars[0] = ((tmp16 != 0) && tmp17);

  restore_memory_state(mem_state);
  inUpdate=0;
  return 0;

}
int function_when(int i)
{
  modelica_integer tmp0;
  modelica_integer tmp1;
  modelica_integer tmp2;
  modelica_boolean tmp3;
  state mem_state;


  mem_state = get_memory_state();
  switch(i) {
     case 0: //when pre($trapezoid$pointcounter2) <> 0 AND sample($trapezoid$pointstartTime,$trapezoid$pointperiod)

    save($trapezoid$pointT0);

    $trapezoid$pointT0 = time;

    
    break;
     case 1: //when pre($trapezoid$pointcounter2) <> 0 AND sample($trapezoid$pointstartTime,$trapezoid$pointperiod)

    save($trapezoid$pointcounter2);

    tmp0 = (modelica_integer)pre($trapezoid$pointcounter);
    $trapezoid$pointcounter2 = tmp0;

    
    break;
     case 2: //when pre($trapezoid$pointcounter2) <> 0 AND sample($trapezoid$pointstartTime,$trapezoid$pointperiod)

    save($trapezoid$pointcounter);

    tmp1 = (modelica_integer)pre($trapezoid$pointcounter);
    tmp2 = (modelica_integer)pre($trapezoid$pointcounter);
    tmp3 = (tmp2 > 0);
    if (tmp3) {
    }
    else {
    }
    $trapezoid$pointcounter = (tmp1 - ((tmp3)?1:0));

    
    break;
     case 3: //when sample($pulse$pointstartTime,$pulse$pointperiod)

    save($pulse$pointT0);

    $pulse$pointT0 = time;

    
    break;
    default: break;
  }

  restore_memory_state(mem_state);
  return 0;

}
int functionODE()
{
  state mem_state;
  sin_rettype tmp0;


  mem_state = get_memory_state();
  tmp0 = sin((time * 628.318530717));
  $derivative$$dummy = tmp0;

  restore_memory_state(mem_state);
  return 0;

}
int initial_function()
{


  $pulse$pointT0 = $pulse$pointstartTime;
  $trapezoid$pointT0 = $trapezoid$pointstartTime;
  $trapezoid$pointcounter = (modelica_integer)$trapezoid$pointnperiod;
  $trapezoid$pointcounter2 = (modelica_integer)$trapezoid$pointnperiod;
  $trapezoid$pointT_falling = ($trapezoid$pointT_width + $trapezoid$pointfalling);
  $trapezoid$pointT_width = ($trapezoid$pointT_rising + $trapezoid$pointwidth);
  $trapezoid$pointT_rising = $trapezoid$pointrising;

  return 0;

}
int initial_residual()
{
  modelica_boolean tmp0;
  modelica_boolean tmp1;
  modelica_boolean tmp2;
  modelica_boolean tmp3;
  modelica_boolean tmp4;
  modelica_boolean tmp5;
  modelica_boolean tmp6;
  modelica_boolean tmp7;
  modelica_boolean tmp8;
  modelica_boolean tmp9;
  sin_rettype tmp10;
  int i=0;
  state mem_state;


  mem_state = get_memory_state();
  localData->initialResiduals[i++] = ($pulse$pointT_width - (($pulse$pointperiod * $pulse$pointwidth) / 100.0));
  RELATIONLESS(tmp0,time,$pulse$pointstartTime);
  RELATIONGREATEREQ(tmp1,time,($pulse$pointT0 + $pulse$pointT_width));
  tmp2 = (tmp0 || tmp1);
  if (tmp2) {
  }
  else {
  }
  localData->initialResiduals[i++] = ($pulse$pointy - ($pulse$pointoffset + ((tmp2)?0.0:$pulse$pointamplitude)));
  RELATIONLESS(tmp3,time,$trapezoid$pointstartTime);
  RELATIONGREATEREQ(tmp4,time,($trapezoid$pointT0 + $trapezoid$pointT_falling));
  tmp5 = ((tmp3 || ((modelica_integer)$trapezoid$pointcounter2 == 0)) || tmp4);
  if (tmp5) {
  }
  else {
    RELATIONLESS(tmp6,time,($trapezoid$pointT0 + $trapezoid$pointT_rising));
    tmp7 = tmp6;
    if (tmp7) {
    }
    else {
      RELATIONLESS(tmp8,time,($trapezoid$pointT0 + $trapezoid$pointT_width));
      tmp9 = tmp8;
      if (tmp9) {
      }
      else {
      }
    }
  }
  localData->initialResiduals[i++] = ($trapezoid$pointy - ($trapezoid$pointoffset + ((tmp5)?0.0:((tmp7)?(((time - $trapezoid$pointT0) * $trapezoid$pointamplitude) / $trapezoid$pointT_rising):((tmp9)?$trapezoid$pointamplitude:(((($trapezoid$pointT0 + $trapezoid$pointT_falling) - time) * $trapezoid$pointamplitude) / ($trapezoid$pointT_falling - $trapezoid$pointT_width)))))));
  tmp10 = sin((time * 628.318530717));
  localData->initialResiduals[i++] = ($derivative$$dummy - tmp10);

  restore_memory_state(mem_state);
  return 0;

}
int bound_parameters()
{
  state mem_state;


  mem_state = get_memory_state();
  $trapezoid$pointT_falling = ($trapezoid$pointT_width + $trapezoid$pointfalling);
  $trapezoid$pointT_width = ($trapezoid$pointT_rising + $trapezoid$pointwidth);
  $trapezoid$pointT_rising = $trapezoid$pointrising;

  restore_memory_state(mem_state);
  return 0;

}
int checkForDiscreteVarChanges()
{
  int needToIterate=0;
  if (edge(localData->helpVars[3])) AddEvent(3 + localData->nZeroCrossing);
  if (edge(localData->helpVars[2])) AddEvent(2 + localData->nZeroCrossing);
  if (edge(localData->helpVars[1])) AddEvent(1 + localData->nZeroCrossing);
  if (edge(localData->helpVars[0])) AddEvent(0 + localData->nZeroCrossing);
  if (change($trapezoid$pointcounter2)) { needToIterate=1; }
  if (change($trapezoid$pointcounter)) { needToIterate=1; }
  if (change($trapezoid$pointT0)) { needToIterate=1; }
  if (change($pulse$pointT0)) { needToIterate=1; }
  for (long i = 0; i < localData->nHelpVars; i++) {
    if (change(localData->helpVars[i])) { needToIterate=1; }
  }
  return needToIterate;
}
