package ModelicaServices "Models and functions used in the Modelica Standard Library requiring a tool specific implementation"
  package UsersGuide "Users Guide"
    annotation(__Dymola_DocumentationClass = true);
    class ReleaseNotes "Release notes"
      annotation(Documentation(info = "<html>
<h4>Version 1.0, 2009-06-21</h4>

<p>
First version of the ModelicaServices library.
</p>

</html>
"));
    end ReleaseNotes;
    class ModelicaLicense2 "Modelica License 2"
      annotation(Documentation(info = "<html>

<p>All files in this directory (ModelicaServices) and in all
subdirectories are licensed by the <b><u>Modelica Association</u></b> under the
<b><u>Modelica License 2</u></b>.</p>

<p style=\"margin-left: 40px;\"><b>Licensor:</b><br>
Modelica Association<br>
(Ideella F&ouml;reningar 822003-8858 in Link&ouml;ping) <br>
c/o PELAB, IDA, Link&ouml;pings Universitet <br>
S-58183 Link&ouml;ping <br>
Sweden<br>
email: Board@Modelica.org<br>
web&nbsp; : http://www.Modelica.org</p>
<p style=\"margin-left: 40px;\"><b>Copyright notices of the files:</b></p>
<div style=\"margin-left: 40px;\">Copyright &copy; 1998-2009,
DLR, Dynasim.<br>
</div>
<br>
</p>

<p> <a href=\"#1.%20The%20Modelica%20License%202%7Coutline\">The
Modelica License 2</a><br>
<a href=\"#2.%20Frequently%20Asked%20Questions%7Coutline\">Frequently
Asked Questions</a><br>
<br>
</p>

<hr>
<h4><a name=\"1. The Modelica License 2|outline\"></a>The Modelica License 2</h4>

<p>
<b>Preamble.</b> The goal of this license is that Modelica related
model libraries, software, images, documents, data files etc. can be
used freely in the original or a modified form, in open source and in
commercial environments (as long as the license conditions below are
fulfilled, in particular sections 2c) and 2d). The Original Work is
provided free of charge and the use is completely at your own risk.
Developers of free Modelica packages are encouraged to utilize this
license for their work.</p>

<p>
The Modelica License applies to any Original Work that contains the
following licensing notice adjacent to the copyright notice(s) for
this Original Work:</p>
<p><b>Licensed
by the Modelica Association under the Modelica License 2</b></p>

<p><b>1. Definitions.</b></p>
<ol>
 <li>&ldquo;License&rdquo; is this Modelica License.</li>

 <li>
 &ldquo;Original Work&rdquo; is any work of authorship, including
 software, images, documents, data files, that contains the above
 licensing notice or that is packed together with a licensing notice
 referencing it.</li>

 <li>
 &ldquo;Licensor&rdquo; is the provider of the Original Work who has
 placed this licensing notice adjacent to the copyright notice(s) for
 the Original Work. The Original Work is either directly provided by
 the owner of the Original Work, or by a licensee of the owner.</li>

 <li>
 &ldquo;Derivative Work&rdquo; is any modification of the Original
 Work which represents, as a whole, an original work of authorship.
 For the matter of clarity and as examples: </li>

 <ol>
  <li>
  Derivative Work shall not include work that remains separable from
  the Original Work, as well as merely extracting a part of the
  Original Work without modifying it.</li>

  <li>
  Derivative Work shall not include (a) fixing of errors and/or (b)
  adding vendor specific Modelica annotations and/or (c) using a
  subset of the classes of a Modelica package, and/or (d) using a
  different representation, e.g., a binary representation.</li>

  <li>
  Derivative Work shall include classes that are copied from the
  Original Work where declarations, equations or the documentation
  are modified.</li>

  <li>
  Derivative Work shall include executables to simulate the models
  that are generated by a Modelica translator based on the Original
  Work (of a Modelica package).</li>
 </ol>

 <li>
 &ldquo;Modified Work&rdquo; is any modification of the Original Work
 with the following exceptions: (a) fixing of errors and/or (b)
 adding vendor specific Modelica annotations and/or (c) using a
 subset of the classes of a Modelica package, and/or (d) using a
 different representation, e.g., a binary representation.</li>

 <li>
 &quot;Source Code&quot; means the preferred form of the Original
 Work for making modifications to it and all available documentation
 describing how to modify the Original Work.</li>

 <li>
 &ldquo;You&rdquo; means an individual or a legal entity exercising
 rights under, and complying with all of the terms of, this License.</li>

 <li>
 &ldquo;Modelica package&rdquo; means any Modelica library that is
 defined with the<br>&ldquo;<FONT FACE=\"Courier New, monospace\"><FONT SIZE=2 STYLE=\"font-size: 9pt\"><b>package</b></FONT></FONT><FONT FACE=\"Courier New, monospace\"><FONT SIZE=2 STYLE=\"font-size: 9pt\">
 &lt;Name&gt; ... </FONT></FONT><FONT FACE=\"Courier New, monospace\"><FONT SIZE=2 STYLE=\"font-size: 9pt\"><b>end</b></FONT></FONT><FONT FACE=\"Courier New, monospace\"><FONT SIZE=2 STYLE=\"font-size: 9pt\">
 &lt;Name&gt;;</FONT></FONT>&ldquo; Modelica language element.</li>
</ol>

<p>
<b>2. Grant of Copyright License.</b> Licensor grants You a
worldwide, royalty-free, non-exclusive, sublicensable license, for
the duration of the copyright, to do the following:</p>

<ol>
 <li><p>
 To reproduce the Original Work in copies, either alone or as part of
 a collection.</li></p>
 <li><p>
 To create Derivative Works according to Section 1d) of this License.</li></p>
 <li><p>
 To distribute or communicate to the public copies of the <u>Original
 Work</u> or a <u>Derivative Work</u> under <u>this License</u>. No
 fee, neither as a copyright-license fee, nor as a selling fee for
 the copy as such may be charged under this License. Furthermore, a
 verbatim copy of this License must be included in any copy of the
 Original Work or a Derivative Work under this License.<br>      For
 the matter of clarity, it is permitted A) to distribute or
 communicate such copies as part of a (possible commercial)
 collection where other parts are provided under different licenses
 and a license fee is charged for the other parts only and B) to
 charge for mere printing and shipping costs.</li></p>
 <li><p>
 To distribute or communicate to the public copies of a <u>Derivative
 Work</u>, alternatively to Section 2c), under <u>any other license</u>
 of your choice, especially also under a license for
 commercial/proprietary software, as long as You comply with Sections
 3, 4 and 8 below. <br>      For the matter of clarity, no
 restrictions regarding fees, either as to a copyright-license fee or
 as to a selling fee for the copy as such apply.</li></p>
 <li><p>
 To perform the Original Work publicly.</li></p>
 <li><p>
 To display the Original Work publicly.</li></p>
</ol>

<p>
<b>3. Acceptance.</b> Any use of the Original Work or a
Derivative Work, or any action according to either Section 2a) to 2f)
above constitutes Your acceptance of this License.</p>

<p>
<b>4. Designation of Derivative Works and of Modified Works.
</b>The identifying designation of Derivative Work and of Modified
Work must be different to the corresponding identifying designation
of the Original Work. This means especially that the (root-level)
name of a Modelica package under this license must be changed if the
package is modified (besides fixing of errors, adding vendor specific
Modelica annotations, using a subset of the classes of a Modelica
package, or using another representation, e.g. a binary
representation).</p>

<p>
<b>5. Grant of Patent License.</b>
Licensor grants You a worldwide, royalty-free, non-exclusive, sublicensable license,
under patent claims owned by the Licensor or licensed to the Licensor by
the owners of the Original Work that are embodied in the Original Work
as furnished by the Licensor, for the duration of the patents,
to make, use, sell, offer for sale, have made, and import the Original Work
and Derivative Works under the conditions as given in Section 2.
For the matter of clarity, the license regarding Derivative Works covers
patent claims to the extent as they are embodied in the Original Work only.</p>

<p>
<b>6. Provision of Source Code.</b> Licensor agrees to provide
You with a copy of the Source Code of the Original Work but reserves
the right to decide freely on the manner of how the Original Work is
provided.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For the matter of clarity, Licensor might provide only a binary
representation of the Original Work. In that case, You may (a) either
reproduce the Source Code from the binary representation if this is
possible (e.g., by performing a copy of an encrypted Modelica
package, if encryption allows the copy operation) or (b) request the
Source Code from the Licensor who will provide it to You.</p>

<p>
<b>7. Exclusions from License Grant.</b> Neither the names of
Licensor, nor the names of any contributors to the Original Work, nor
any of their trademarks or service marks, may be used to endorse or
promote products derived from this Original Work without express
prior permission of the Licensor. Except as otherwise expressly
stated in this License and in particular in Sections 2 and 5, nothing
in this License grants any license to Licensor&rsquo;s trademarks,
copyrights, patents, trade secrets or any other intellectual
property, and no patent license is granted to make, use, sell, offer
for sale, have made, or import embodiments of any patent claims.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No license is granted to the trademarks of
Licensor even if such trademarks are included in the Original Work,
except as expressly stated in this License. Nothing in this License
shall be interpreted to prohibit Licensor from licensing under terms
different from this License any Original Work that Licensor otherwise
would have a right to license.</p>

<p>
<b>8. Attribution Rights.</b> You must retain in the Source
Code of the Original Work and of any Derivative Works that You
create, all author, copyright, patent, or trademark notices, as well
as any descriptive text identified therein as an &quot;Attribution
Notice&quot;. The same applies to the licensing notice of this
License in the Original Work. For the matter of clarity, &ldquo;author
notice&rdquo; means the notice that identifies the original
author(s). <br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;You must cause the Source Code for any Derivative
Works that You create to carry a prominent Attribution Notice
reasonably calculated to inform recipients that You have modified the
Original Work. <br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In case the Original Work or Derivative Work is not provided in
Source Code, the Attribution Notices shall be appropriately
displayed, e.g., in the documentation of the Derivative Work.</p>

<p><b>9. Disclaimer
of Warranty. <br></b><u><b>The Original Work is provided under this
License on an &quot;as is&quot; basis and without warranty, either
express or implied, including, without limitation, the warranties of
non-infringement, merchantability or fitness for a particular
purpose. The entire risk as to the quality of the Original Work is
with You.</b></u><b> </b>This disclaimer of warranty constitutes an
essential part of this License. No license to the Original Work is
granted by this License except under this disclaimer.</p>

<p>
<b>10. Limitation of Liability.</b> Under no circumstances and
under no legal theory, whether in tort (including negligence),
contract, or otherwise, shall the Licensor, the owner or a licensee
of the Original Work be liable to anyone for any direct, indirect,
general, special, incidental, or consequential damages of any
character arising as a result of this License or the use of the
Original Work including, without limitation, damages for loss of
goodwill, work stoppage, computer failure or malfunction, or any and
all other commercial damages or losses. This limitation of liability
shall not apply to the extent applicable law prohibits such
limitation.</p>

<p>
<b>11. Termination.</b> This License conditions your rights to
undertake the activities listed in Section 2 and 5, including your
right to create Derivative Works based upon the Original Work, and
doing so without observing these terms and conditions is prohibited
by copyright law and international treaty. Nothing in this License is
intended to affect copyright exceptions and limitations. This License
shall terminate immediately and You may no longer exercise any of the
rights granted to You by this License upon your failure to observe
the conditions of this license.</p>

<p>
<b>12. Termination for Patent Action.</b> This License shall
terminate automatically and You may no longer exercise any of the
rights granted to You by this License as of the date You commence an
action, including a cross-claim or counterclaim, against Licensor,
any owners of the Original Work or any licensee alleging that the
Original Work infringes a patent. This termination provision shall
not apply for an action alleging patent infringement through
combinations of the Original Work under combination with other
software or hardware.</p>

<p>
<b>13. Jurisdiction.</b> Any action or suit relating to this
License may be brought only in the courts of a jurisdiction wherein
the Licensor resides and under the laws of that jurisdiction
excluding its conflict-of-law provisions. The application of the
United Nations Convention on Contracts for the International Sale of
Goods is expressly excluded. Any use of the Original Work outside the
scope of this License or after its termination shall be subject to
the requirements and penalties of copyright or patent law in the
appropriate jurisdiction. This section shall survive the termination
of this License.</p>

<p>
<b>14. Attorneys&rsquo; Fees.</b> In any action to enforce the
terms of this License or seeking damages relating thereto, the
prevailing party shall be entitled to recover its costs and expenses,
including, without limitation, reasonable attorneys' fees and costs
incurred in connection with such action, including any appeal of such
action. This section shall survive the termination of this License.</p>

<p>
<b>15. Miscellaneous.</b>
</p>
<ol>
 <li>If any
 provision of this License is held to be unenforceable, such
 provision shall be reformed only to the extent necessary to make it
 enforceable.</li>

 <li>No verbal
 ancillary agreements have been made. Changes and additions to this
 License must appear in writing to be valid. This also applies to
 changing the clause pertaining to written form.</li>

 <li>You may use the
 Original Work in all ways not otherwise restricted or conditioned by
 this License or by law, and Licensor promises not to interfere with
 or be responsible for such uses by You.</li>
</ol>

<p>
<br>
</p>

<hr>

<h4><a name=\"2. Frequently Asked Questions|outline\"></a>
Frequently Asked Questions</h4>
<p>This
section contains questions/answer to users and/or distributors of
Modelica packages and/or documents under Modelica License 2. Note,
the answers to the questions below are not a legal interpretation of
the Modelica License 2. In case of a conflict, the language of the
license shall prevail.</p>

<p><br>
</p>

<p><FONT COLOR=\"#008000\"><FONT SIZE=3><b>Using
or Distributing a Modelica </b></FONT></FONT><FONT COLOR=\"#008000\"><FONT SIZE=3><u><b>Package</b></u></FONT></FONT><FONT COLOR=\"#008000\"><FONT SIZE=3><b>
under the Modelica License 2</b></FONT></FONT></p>

<p><b>What are the main
differences to the previous version of the Modelica License?</b></p>
<ol>
 <li><p>
 Modelica License 1 is unclear whether the licensed Modelica package
 can be distributed under a different license. Version 2 explicitly
 allows that &ldquo;Derivative Work&rdquo; can be distributed under
 any license of Your choice, see examples in Section 1d) as to what
 qualifies as Derivative Work (so, version 2 is clearer).</p>
 <li><p>
 If You modify a Modelica package under Modelica License 2 (besides
 fixing of errors, adding vendor specific Modelica annotations, using
 a subset of the classes of a Modelica package, or using another
 representation, e.g., a binary representation), you must rename the
 root-level name of the package for your distribution. In version 1
 you could keep the name (so, version 2 is more restrictive). The
 reason of this restriction is to reduce the risk that Modelica
 packages are available that have identical names, but different
 functionality.</p>
 <li><p>
 Modelica License 1 states that &ldquo;It is not allowed to charge a
 fee for the original version or a modified version of the software,
 besides a reasonable fee for distribution and support<SPAN LANG=\"en-GB\">&ldquo;.
 Version 2 has a </SPAN>similar intention for all Original Work under
 <u>Modelica License 2</u> (to remain free of charge and open source)
 but states this more clearly as &ldquo;No fee, neither as a
 copyright-license fee, nor as a selling fee for the copy as such may
 be charged&rdquo;. Contrary to version 1, Modelica License 2 has no
 restrictions on fees for Derivative Work that is provided under a
 different license (so, version 2 is clearer and has fewer
 restrictions).</p>
 <li><p>
 Modelica License 2 introduces several useful provisions for the
 licensee (articles 5, 6, 12), and for the licensor (articles 7, 12,
 13, 14) that have no counter part in version 1.</p>
 <li><p>
 Modelica License 2 can be applied to all type of work, including
 documents, images and data files, contrary to version 1 that was
 dedicated for software only (so, version 2 is more general).</p>
</ol>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) as part of my commercial
Modelica modeling and simulation environment?</b></p>
<p>Yes,
according to Section 2c). However, you are not allowed to charge a
fee for this part of your environment. Of course, you can charge for
your part of the environment.
</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different
license?</b></p>
<p>No.
The license of an unmodified Modelica package cannot be changed
according to Sections 2c) and 2d). This means that you cannot <u>sell</u>
copies of it, any distribution has to be free of charge.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different license
when I first encrypt the package?</b></p>
<p>No.
Merely encrypting a package does not qualify for Derivative Work and
therefore the encrypted package has to stay under Modelica License 2.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different license
when I first add classes to the package?</b></p>
<p>No.
The package itself remains unmodified, i.e., it is Original Work, and
therefore the license for this part must remain under Modelica
License 2. The newly added classes can be, however, under a different
license.
</p>

<p><b>Can
I copy a class out of a Modelica package (under Modelica License 2)
and include it </b><u><b>unmodified</b></u><b> in a Modelica package
under a </b><u><b>commercial/proprietary license</b></u><b>?</b></p>
<p>No,
according to article 2c). However, you can include model, block,
function, package, record and connector classes in your Modelica
package under <u>Modelica License 2</u>. This means that your
Modelica package could be under a commercial/proprietary license, but
one or more classes of it are under Modelica License 2.<br>Note, a
&ldquo;type&rdquo; class (e.g., type Angle = Real(unit=&rdquo;rad&rdquo;))
can be copied and included unmodified under a commercial/proprietary
license (for details, see the next question).</p>

<p><b>Can
I copy a type class or </b><u><b>part</b></u><b> of a model, block,
function, record, connector class, out of a Modelica package (under
Modelica License 2) and include it modified or unmodified in a
Modelica package under a </b><u><b>commercial/proprietary</b></u><b>
license</b></p>
<p>Yes,
according to article 2d), since this will in the end usually qualify
as Derivative Work. The reasoning is the following: A type class or
part of another class (e.g., an equation, a declaration, part of a
class description) cannot be utilized &ldquo;by its own&rdquo;. In
order to make this &ldquo;usable&rdquo;, you have to add additional
code in order that the class can be utilized. This is therefore
usually Derivative Work and Derivative Work can be provided under a
different license. Note, this only holds, if the additional code
introduced is sufficient to qualify for Derivative Work. Merely, just
copying a class and changing, say, one character in the documentation
of this class would be no Derivative Work and therefore the copied
code would have to stay under Modelica License 2.</p>

<p><b>Can
I copy a class out of a Modelica package (under Modelica License 2)
and include it in </b><u><b>modified </b></u><b>form in a
</b><u><b>commercial/proprietary</b></u><b> Modelica package?</b></p>
<p>Yes.
If the modification can be seen as a &ldquo;Derivative Work&rdquo;,
you can place it under your commercial/proprietary license. If the
modification does not qualify as &ldquo;Derivative Work&rdquo; (e.g.,
bug fixes, vendor specific annotations), it must remain under
Modelica License 2. This means that your Modelica package could be
under a commercial/proprietary license, but one or more parts of it
are under Modelica License 2.</p>

<p><b>Can I distribute a
&ldquo;save total model&rdquo; under my commercial/proprietary
license, even if classes under Modelica License 2 are included?</b></p>
<p>Your
classes of the &ldquo;save total model&rdquo; can be distributed
under your commercial/proprietary license, but the classes under
Modelica License 2 must remain under Modelica License 2. This means
you can distribute a &ldquo;save total model&rdquo;, but some parts
might be under Modelica License 2.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) in encrypted form?</b></p>
<p>Yes.
Note, if the encryption does not allow &ldquo;copying&rdquo; of
classes (in to unencrypted Modelica source code), you have to send
the Modelica source code of this package to your customer, if he/she
wishes it, according to article&nbsp;6.</p>

<p><b>Can I distribute an
executable under my commercial/proprietary license, if the model from
which the executable is generated uses models from a Modelica package
under Modelica License 2?</b></p>
<p>Yes,
according to article 2d), since this is seen as Derivative Work. The
reasoning is the following: An executable allows the simulation of a
concrete model, whereas models from a Modelica package (without
pre-processing, translation, tool run-time library) are not able to
be simulated without tool support. By the processing of the tool and
by its run-time libraries, significant new functionality is added (a
model can be simulated whereas previously it could not be simulated)
and functionality available in the package is removed (e.g., to build
up a new model by dragging components of the package is no longer
possible with the executable).</p>

<p><b>Is my modification to
a Modelica package (under Modelica License 2) a Derivative Work?</b></p>
<p>It
is not possible to give a general answer to it. To be regarded as &quot;an
original work of authorship&quot;, a derivative work must be
different enough from the original or must contain a substantial
amount of new material. Making minor changes or additions of little
substance to a preexisting work will not qualify the work as a new
version for such purposes.
</p>

<p><br>
</p>
<p><FONT COLOR=\"#008000\"><FONT SIZE=3><b>Using
or Distributing a Modelica </b></FONT></FONT><FONT COLOR=\"#008000\"><FONT SIZE=3><u><b>Document</b></u></FONT></FONT><FONT COLOR=\"#008000\"><FONT SIZE=3><b>
under the Modelica License 2</b></FONT></FONT></p>

<p>This
section is devoted especially for the following applications:</p>
<ol>
 <li><p>
 A Modelica tool extracts information out of a Modelica package and
 presents the result in form of a &ldquo;manual&rdquo; for this
 package in, e.g., html, doc, or pdf format.</p>
 <li><p>
 The Modelica language specification is a document defining the
 Modelica language. It will be licensed under Modelica License 2.</p>
 <li><p>
 Someone writes a book about the Modelica language and/or Modelica
 packages and uses information which is available in the Modelica
 language specification and/or the corresponding Modelica package.</p>
</ol>

<p><b>Can I sell a manual
that was basically derived by extracting information automatically
from a Modelica package under Modelica License 2 (e.g., a &ldquo;reference
guide&rdquo; of the Modelica Standard Library):</b></p>
<p>Yes.
Extracting information from a Modelica package, and providing it in a
human readable, suitable format, like html, doc or pdf format, where
the content is significantly modified (e.g. tables with interface
information are constructed from the declarations of the public
variables) qualifies as Derivative Work and there are no restrictions
to charge a fee for Derivative Work under alternative 2d).</p>

<p><b>Can
I copy a text passage out of a Modelica document (under Modelica
License 2) and use it </b><u><b>unmodified</b></u><b> in my document
(e.g. the Modelica syntax description in the Modelica Specification)?</b></p>
<p>Yes.
In case you distribute your document, the copied parts are still
under Modelica License 2 and you are not allowed to charge a license
fee for this part. You can, of course, charge a fee for the rest of
your document.</p>

<p><b>Can
I copy a text passage out of a Modelica document (under Modelica
License 2) and use it in </b><u><b>modified</b></u><b> form in my
document?</b></p>
<p>Yes,
the creation of Derivative Works is allowed. In case the content is
significantly modified this qualifies as Derivative Work and there
are no restrictions to charge a fee for Derivative Work under
alternative 2d).</p>

<p><b>Can I sell a printed
version of a Modelica document (under Modelica License 2), e.g., the
Modelica Language Specification?</b></p>
<p>No,
if you are not the copyright-holder, since article 2c) does not allow
a selling fee for a (in this case physical) copy. However, mere
printing and shipping costs may be recovered.</p>
</html>"));
    end ModelicaLicense2;
    class Contact "Contact"
      annotation(Documentation(info = "<html>
<dl>
<dt><b>Main Author:</b>
<dd>
</dl>

<table border=0 cellspacing=0 cellpadding=2>
<tr>
<td>
<a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
    Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
    Institut f&uuml;r Robotik und Mechatronik<br>
    Abteilung f&uuml;r Systemdynamik und Regelungstechnik<br>
    Postfach 1116<br>
    D-82230 Wessling<br>
    Germany<br>
    email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A></td>
</tr>
</table>


<p><b>Acknowledgements:</b></p>

<p>
The design of the Animation.Shape component is from Hilding Elmqvist, Dynasim AB.
</p>

</html>
"));
    end Contact;
  end UsersGuide;
  annotation(preferredView = "info", version = "1.0", versionDate = "2009-06-21", versionBuild = 2, revisionId = "$Id:: package.mo 3123 2009-11-08 18:29:01Z #$", Documentation(info = "<html>
<p>
This package contains a set of functions and models to be used in the
Modelica Standard Library that requires a tool specific implementation.
These are:
</p>

<ul>
<li> <a href=\"Modelica://ModelicaServices.Animation.Shape\">ModelicaServices.Animation.Shape</a>.
     provides a 3-dim. visualization of
     mechanical objects. It is used in
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape</a>
     via inheritance.</li>
</ul>

<p>
<b>Licensed by DLR and Dynasim under the Modelica License 2</b><br>
Copyright &copy; 2009, DLR and Dynasim.
</p>

<p>
<i>This Modelica package is <u>free</u> software and
the use is completely at <u>your own risk</u>;
it can be redistributed and/or modified under the terms of the
Modelica license 2, see the license conditions (including the
disclaimer of warranty)
<a href=\"Modelica://ModelicaServices.UsersGuide.ModelicaLicense2\">here</a></u>
or at
<a href=\"http://www.Modelica.org/licenses/ModelicaLicense2\">
http://www.Modelica.org/licenses/ModelicaLicense2</a>.
</p>

</html>"), uses(Modelica(version = "3.1")));
  package Animation "Models and functions for 3-dim. animation"
    model Shape "Different visual shapes with variable size; all data have to be set as modifiers (see info layer)"
      extends Modelica.Utilities.Internal.PartialModelicaServices.Animation.PartialShape;
      import T = Modelica.Mechanics.MultiBody.Frames.TransformationMatrices;
      import SI = Modelica.SIunits;
      import Modelica.Mechanics.MultiBody.Frames;
      import Modelica.Mechanics.MultiBody.Types;
      function PackShape
        input Types.ShapeType shapeType;
        output Real pack;
      algorithm 
        pack:=1.2;
      end PackShape;
      function PackMaterial
        input Real material1;
        input Real material2;
        input Real material3;
        input Types.SpecularCoefficient sp;
        output Real mat;
      algorithm 
        mat:=material1 + material2 + material3 + sp;
      end PackMaterial;
    protected 
      Real abs_n_x(final unit = "1") = Modelica.Math.Vectors.length(lengthDirection) annotation(HideResult = true);
      Real e_x[3](each final unit = "1") = noEvent(if abs_n_x < 1e-10 then {1,0,0} else lengthDirection / abs_n_x) annotation(HideResult = true);
      Real n_z_aux[3](each final unit = "1") = cross(e_x, widthDirection) annotation(HideResult = true);
      Real e_y[3](each final unit = "1") = noEvent(cross(Modelica.Math.Vectors.normalize(cross(e_x, if n_z_aux * n_z_aux > 1e-06 then widthDirection else if abs(e_x[1]) > 1e-06 then {0,1,0} else {1,0,0})), e_x)) annotation(HideResult = true);
      output Real Form annotation(HideResult = false);
    public 
      output Real rxvisobj[3](each final unit = "1") "x-axis unit vector of shape, resolved in world frame" annotation(HideResult = false);
      output Real ryvisobj[3](each final unit = "1") "y-axis unit vector of shape, resolved in world frame" annotation(HideResult = false);
      output SI.Position rvisobj[3] "position vector from world frame to shape frame, resolved in world frame" annotation(HideResult = false);
    protected 
      output SI.Length size[3] "{length,width,height} of shape" annotation(HideResult = false);
      output Real Material annotation(HideResult = false);
      output Real Extra annotation(HideResult = false);
      annotation(Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {2,2}), graphics = {Rectangle(extent = {{ -100, -100},{80,60}}, lineColor = {0,0,255}, fillColor = {255,255,255}, fillPattern = FillPattern.Solid),Polygon(points = {{ -100,60},{ -80,100},{100,100},{80,60},{ -100,60}}, lineColor = {0,0,255}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Polygon(points = {{100,100},{100, -60},{80, -100},{80,60},{100,100}}, lineColor = {0,0,255}, fillColor = {160,160,164}, fillPattern = FillPattern.Solid),Text(extent = {{ -100, -100},{80,60}}, lineColor = {0,0,0}, textString = "%shapeType"),Text(extent = {{ -132,160},{128,100}}, textString = "%name", lineColor = {0,0,255})}), Documentation(info = "<html>

<p>
This model is documented at
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape</a>.
</p>


</html>
"));

    equation 
      Form = (987000 + PackShape(shapeType)) * 1e+20;
      rxvisobj = transpose(R.T) * e_x;
      ryvisobj = transpose(R.T) * e_y;
      rvisobj = r + T.resolve1(R.T, r_shape);
      size = {length,width,height};
      Material = PackMaterial(color[1] / 255.0, color[2] / 255.0, color[3] / 255.0, specularCoefficient);
      Extra = extra;
    end Shape;
  end Animation;
end ModelicaServices;
package Modelica

package Blocks

package Interfaces
  "Library of connectors and partial models for input/output blocks"
  import Modelica.SIunits;
    extends Modelica.Icons.Library;

connector RealInput = input Real "'input Real' as connector" 
  annotation (defaultComponentName="u",
  Icon(graphics={Polygon(
          points={{-100,100},{100,0},{-100,-100},{-100,100}},
          lineColor={0,0,127},
          fillColor={0,0,127},
          fillPattern=FillPattern.Solid)},
       coordinateSystem(extent={{-100,-100},{100,100}}, preserveAspectRatio=true, initialScale=0.2)),
  Diagram(coordinateSystem(
        preserveAspectRatio=true, initialScale=0.2,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{0,50},{100,0},{0,-50},{0,50}},
          lineColor={0,0,127},
          fillColor={0,0,127},
          fillPattern=FillPattern.Solid), Text(
          extent={{-10,85},{-10,60}},
          lineColor={0,0,127},
          textString="%name")}),
    Documentation(info="<html>
<p>
Connector with one input signal of type Real.
</p>
</html>"));

connector RealOutput = output Real "'output Real' as connector" 
  annotation (defaultComponentName="y",
  Icon(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{-100,100},{100,0},{-100,-100},{-100,100}},
          lineColor={0,0,127},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid)}),
  Diagram(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{-100,50},{0,0},{-100,-50},{-100,50}},
          lineColor={0,0,127},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid), Text(
          extent={{30,110},{30,60}},
          lineColor={0,0,127},
          textString="%name")}),
    Documentation(info="<html>
<p>
Connector with one output signal of type Real.
</p>
</html>"));

connector BooleanInput = input Boolean "'input Boolean' as connector" 
  annotation (defaultComponentName="u",
       Icon(graphics={Polygon(
          points={{-100,100},{100,0},{-100,-100},{-100,100}},
          lineColor={255,0,255},
          fillColor={255,0,255},
          fillPattern=FillPattern.Solid)},
            coordinateSystem(extent={{-100,-100},{100,100}},
        preserveAspectRatio=true, initialScale=0.2)),    Diagram(coordinateSystem(
        preserveAspectRatio=true, initialScale=0.2,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{0,50},{100,0},{0,-50},{0,50}},
          lineColor={255,0,255},
          fillColor={255,0,255},
          fillPattern=FillPattern.Solid), Text(
          extent={{-10,85},{-10,60}},
          lineColor={255,0,255},
          textString="%name")}),
    Documentation(info="<html>
<p>
Connector with one input signal of type Boolean.
</p>
</html>"));

connector BooleanOutput = output Boolean "'output Boolean' as connector" 
                                  annotation (defaultComponentName="y",
  Icon(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{-100,100},{100,0},{-100,-100},{-100,100}},
          lineColor={255,0,255},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid)}),
  Diagram(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{-100,50},{0,0},{-100,-50},{-100,50}},
          lineColor={255,0,255},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid), Text(
          extent={{30,110},{30,60}},
          lineColor={255,0,255},
          textString="%name")}),
    Documentation(info="<html>
<p>
Connector with one output signal of type Boolean.
</p>
</html>"));

connector IntegerInput = input Integer "'input Integer' as connector" 
  annotation (defaultComponentName="u",
  Icon(graphics={Polygon(
          points={{-100,100},{100,0},{-100,-100},{-100,100}},
          lineColor={255,127,0},
          fillColor={255,127,0},
          fillPattern=FillPattern.Solid)},
       coordinateSystem(extent={{-100,-100},{100,100}}, preserveAspectRatio=true,
                 initialScale=0.2)),
  Diagram(coordinateSystem(
        preserveAspectRatio=true, initialScale=0.2,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{0,50},{100,0},{0,-50},{0,50}},
          lineColor={255,127,0},
          fillColor={255,127,0},
          fillPattern=FillPattern.Solid), Text(
          extent={{-10,85},{-10,60}},
          lineColor={255,127,0},
          textString="%name")}),
    Documentation(info="<html>
<p>
Connector with one input signal of type Integer.
</p>
</html>"));

connector IntegerOutput = output Integer "'output Integer' as connector" 
                                  annotation (defaultComponentName="y",
  Icon(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{-100,100},{100,0},{-100,-100},{-100,100}},
          lineColor={255,127,0},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid)}),
  Diagram(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={Polygon(
          points={{-100,50},{0,0},{-100,-50},{-100,50}},
          lineColor={255,127,0},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid), Text(
          extent={{30,110},{30,60}},
          lineColor={255,127,0},
          textString="%name")}),
    Documentation(info="<html>
<p>
Connector with one output signal of type Integer.
</p>
</html>"));

    partial block BlockIcon "Basic graphical layout of input/output block"

      annotation (
        Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
              100,100}}), graphics={Rectangle(
            extent={{-100,-100},{100,100}},
            lineColor={0,0,127},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid), Text(
            extent={{-150,150},{150,110}},
            textString="%name",
            lineColor={0,0,255})}),
      Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output
block (no declarations, no equations). Most blocks
of package Modelica.Blocks inherit directly or indirectly
from this block.
</p>
</html>"));

    end BlockIcon;

    partial block SO "Single Output continuous control block"
      extends BlockIcon;

      RealOutput y "Connector of Real output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics),
      Documentation(info="<html>
<p>
Block has one continuous Real output signal.
</p>
</html>"));

    end SO;

    partial block MO "Multiple Output continuous control block"
      extends BlockIcon;

      parameter Integer nout(min=1) = 1 "Number of outputs";
      RealOutput y[nout] "Connector of Real output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
        Documentation(info="<html>
<p>
Block has one continuous Real output signal vector.
</p>
</html>"));

    end MO;

    partial block SISO "Single Input Single Output continuous control block"
      extends BlockIcon;

      RealInput u "Connector of Real input signal" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
      RealOutput y "Connector of Real output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
      Documentation(info="<html>
<p>
Block has one continuous Real input and one continuous Real output signal.
</p>
</html>"));
    end SISO;

    partial block SI2SO
    "2 Single Input / 1 Single Output continuous control block"
      extends BlockIcon;

      RealInput u1 "Connector of Real input signal 1" 
        annotation (Placement(transformation(extent={{-140,40},{-100,80}},
            rotation=0)));
      RealInput u2 "Connector of Real input signal 2" 
        annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
            rotation=0)));
      RealOutput y "Connector of Real output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));

      annotation (
        Documentation(info="<html>
<p>
Block has two continuous Real input signals u1 and u2 and one
continuous Real output signal y.
</p>
</html>"),
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics));

    end SI2SO;

partial block SIMO "Single Input Multiple Output continuous control block"
  extends BlockIcon;
  parameter Integer nout=1 "Number of outputs";
      RealInput u "Connector of Real input signal" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
      RealOutput y[nout] "Connector of Real output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));

  annotation (Documentation(info="<HTML>
<p> Block has one continuous Real input signal and a
    vector of continuous Real output signals.</p>

</HTML>
"));
end SIMO;

    partial block MISO "Multiple Input Single Output continuous control block"

      extends BlockIcon;
      parameter Integer nin=1 "Number of inputs";
      RealInput u[nin] "Connector of Real input signals" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
      RealOutput y "Connector of Real output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (Documentation(info="<HTML>
<p>
Block has a vector of continuous Real input signals and
one continuous Real output signal.
</p>
</HTML>
"));
    end MISO;

    partial block MIMO
    "Multiple Input Multiple Output continuous control block"

      extends BlockIcon;
      parameter Integer nin=1 "Number of inputs";
      parameter Integer nout=1 "Number of outputs";
      RealInput u[nin] "Connector of Real input signals" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
      RealOutput y[nout] "Connector of Real output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (Documentation(info="<HTML>
<p>
Block has a continuous Real input and a continuous Real output signal vector.
The signal sizes of the input and output vector may be different.
</p>
</HTML>
"));
    end MIMO;

    partial block MIMOs
    "Multiple Input Multiple Output continuous control block with same number of inputs and outputs"

      extends BlockIcon;
      parameter Integer n=1 "Number of inputs (= number of outputs)";
      RealInput u[n] "Connector of Real input signals" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
      RealOutput y[n] "Connector of Real output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
        Documentation(info="<HTML>
<p>
Block has a continuous Real input and a continuous Real output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</HTML>
"));
    end MIMOs;

    partial block MI2MO
    "2 Multiple Input / Multiple Output continuous control block"
      extends BlockIcon;

      parameter Integer n=1 "Dimension of input and output vectors.";

      RealInput u1[n] "Connector 1 of Real input signals" 
        annotation (Placement(transformation(extent={{-140,40},{-100,80}},
            rotation=0)));
      RealInput u2[n] "Connector 2 of Real input signals" 
        annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
            rotation=0)));
      RealOutput y[n] "Connector of Real output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
        Documentation(info="<html>
<p>
Block has two continuous Real input vectors u1 and u2 and one
continuous Real output vector y.
All vectors have the same number of elements.
</p>
</html>"),
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics));

    end MI2MO;

    partial block SignalSource "Base class for continuous signal source"
      extends SO;
      parameter Real offset=0 "Offset of output signal y";
      parameter SIunits.Time startTime=0
      "Output y = offset for time < startTime";
    annotation (Documentation(info="<html>
<p>
Basic block for Real sources of package Blocks.Sources.
This component has one continuous Real output signal y
and two parameters (offset, startTime) to shift the
generated signal.
</p>
</html>"));
    end SignalSource;

    partial block SVcontrol "Single-Variable continuous controller"
      extends BlockIcon;

      RealInput u_s "Connector of setpoint input signal" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
      RealInput u_m "Connector of measurement input signal" 
        annotation (Placement(transformation(
          origin={0,-120},
          extent={{20,-20},{-20,20}},
          rotation=270)));
      RealOutput y "Connector of actuator output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Text(
            extent={{-102,34},{-142,24}},
            textString="(setpoint)",
            lineColor={0,0,255}),
          Text(
            extent={{100,24},{140,14}},
            textString="(actuator)",
            lineColor={0,0,255}),
          Text(
            extent={{-83,-112},{-33,-102}},
            textString=" (measurement)",
            lineColor={0,0,255})}),
      Documentation(info="<html>
<p>
Block has two continuous Real input signals and one
continuous Real output signal. The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
    end SVcontrol;

    partial block MVcontrol "Multi-Variable continuous controller"
      extends BlockIcon;

      parameter Integer nu_s=1 "Number of setpoint inputs";
      parameter Integer nu_m=1 "Number of measurement inputs";
      parameter Integer ny=1 "Number of actuator outputs";
      RealInput u_s[nu_s] "Connector of setpoint input signals" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
      RealInput u_m[nu_m] "Connector of measurement input signals" 
        annotation (Placement(transformation(
          origin={0,-120},
          extent={{20,-20},{-20,20}},
          rotation=270)));
      RealOutput y[ny] "Connector of actuator output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Text(
            extent={{-100,36},{-140,26}},
            textString="(setpoint)",
            lineColor={0,0,255}),
          Text(
            extent={{102,24},{142,14}},
            textString="(actuator)",
            lineColor={0,0,255}),
          Text(
            extent={{-75,-108},{-25,-98}},
            textString=" (measurement)",
            lineColor={0,0,255})}),
      Documentation(info="<html>
<p>
Block has two continuous Real input signal vectors and one
continuous Real output signal vector. The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
    end MVcontrol;

    partial block DiscreteBlockIcon
    "Graphical layout of discrete block component icon"

      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={Rectangle(
            extent={{-100,-100},{100,100}},
            lineColor={0,0,127},
            fillColor={223,223,159},
            fillPattern=FillPattern.Solid), Text(
            extent={{-150,150},{150,110}},
            textString="%name",
            lineColor={0,0,255})}),
                           Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output,
discrete block (no declarations, no equations), e.g.,
from Blocks.Discrete.
</p>
</html>"));
    end DiscreteBlockIcon;

    partial block DiscreteBlock "Base class of discrete control blocks"
      extends DiscreteBlockIcon;

      parameter SI.Time samplePeriod(min=100*Modelica.Constants.eps, start = 0.1)
      "Sample period of component";
      parameter SI.Time startTime=0 "First sample time instant";
  protected
      output Boolean sampleTrigger "True, if sample time instant";
      output Boolean firstTrigger "Rising edge signals first sample instant";
    equation
      sampleTrigger = sample(startTime, samplePeriod);
      when sampleTrigger then
        firstTrigger = time <= startTime + samplePeriod/2;
      end when;
    annotation (Documentation(info="<html>
<p>
Basic definitions of a discrete block of library
Blocks.Discrete.
</p>
</html>"));
    end DiscreteBlock;

    partial block DiscreteSISO
    "Single Input Single Output discrete control block"

      extends DiscreteBlock;

      Modelica.Blocks.Interfaces.RealInput u "Continuous input signal" 
                                  annotation (Placement(transformation(extent={
              {-140,-20},{-100,20}}, rotation=0)));
      Modelica.Blocks.Interfaces.RealOutput y "Continuous output signal" 
                                   annotation (Placement(transformation(extent=
              {{100,-10},{120,10}}, rotation=0)));
    annotation (Documentation(info="<html>
<p>
Block has one continuous input and one continuous output signal
which are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</html>"));
    end DiscreteSISO;

    partial block DiscreteMIMO
    "Multiple Input Multiple Output discrete control block"

      extends DiscreteBlock;
      parameter Integer nin=1 "Number of inputs";
      parameter Integer nout=1 "Number of outputs";

      Modelica.Blocks.Interfaces.RealInput u[nin] "Continuous input signals" 
                                   annotation (Placement(transformation(extent=
              {{-140,-20},{-100,20}}, rotation=0)));
      Modelica.Blocks.Interfaces.RealOutput y[nout] "Continuous output signals"
                                    annotation (Placement(transformation(extent=
             {{100,-10},{120,10}}, rotation=0)));

      annotation (Documentation(info="<html>
<p>
Block has a continuous input and a continuous output signal vector
which are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</HTML>
"));
    end DiscreteMIMO;

    partial block DiscreteMIMOs
    "Multiple Input Multiple Output discrete control block"
      parameter Integer n=1 "Number of inputs (= number of outputs)";
      extends DiscreteBlock;

      Modelica.Blocks.Interfaces.RealInput u[n] "Continuous input signals" 
                                   annotation (Placement(transformation(extent=
              {{-140,-20},{-100,20}}, rotation=0)));
      Modelica.Blocks.Interfaces.RealOutput y[n] "Continuous output signals" 
                                    annotation (Placement(transformation(extent=
             {{100,-10},{120,10}}, rotation=0)));

      annotation (Documentation(info="<html>
<p>
Block has a continuous input and a continuous output signal vector
where the signal sizes of the input and output vector are identical.
These signals are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</HTML>
"));

    end DiscreteMIMOs;

    partial block SVdiscrete "Discrete Single-Variable controller"
      extends DiscreteBlock;

      Discrete.Sampler sampler_s(
        final samplePeriod=samplePeriod,
        final startTime=startTime) annotation (Placement(transformation(extent=
              {{-100,-10},{-80,10}}, rotation=0)));
      Discrete.Sampler sampler_m(
        final samplePeriod=samplePeriod,
        final startTime=startTime) annotation (Placement(transformation(
          origin={0,-90},
          extent={{-10,-10},{10,10}},
          rotation=90)));
      Modelica.Blocks.Interfaces.RealInput u_s
      "Continuous scalar setpoint input signal"   annotation (Placement(
          transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
      Modelica.Blocks.Interfaces.RealInput u_m
      "Continuous scalar measurement input signal"   annotation (Placement(
          transformation(
          origin={0,-120},
          extent={{20,-20},{-20,20}},
          rotation=270)));
      Modelica.Blocks.Interfaces.RealOutput y
      "Continuous scalar actuator output signal"   annotation (Placement(
          transformation(extent={{100,-10},{120,10}}, rotation=0)));
    equation
      connect(u_s, sampler_s.u)           annotation (Line(points={{-120,0},{
            -102,0}}));
      connect(u_m, sampler_m.u)           annotation (Line(points={{0,-120},{0,
            -111},{0,-102},{-7.34788e-016,-102}}));
      annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Text(
            extent={{-100,34},{-140,24}},
            lineColor={0,0,0},
            textString="(setpoint)"),
          Text(
            extent={{100,22},{130,14}},
            lineColor={0,0,0},
            textString="(actuator)"),
          Text(
            extent={{-70,-112},{-20,-102}},
            lineColor={0,0,0},
            textString=" (measurement)")}),
                              Documentation(info="<html>
<p>
Block has two continuous Real input signals and one
continuous Real output signal
that are sampled due to the defined <b>samplePeriod</b> parameter.
The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
    end SVdiscrete;

    partial block MVdiscrete "Discrete Multi-Variable controller"
      extends DiscreteBlock;
      parameter Integer nu_s=1 "Number of setpoint inputs";
      parameter Integer nu_m=1 "Number of measurement inputs";
      parameter Integer ny=1 "Number of actuator outputs";
      Discrete.Sampler sampler_s[nu_s](
        each final samplePeriod=samplePeriod,
        each final startTime=startTime) 
                                   annotation (Placement(transformation(extent=
              {{-90,-10},{-70,10}}, rotation=0)));
      Discrete.Sampler sampler_m[nu_m](
        each final samplePeriod=samplePeriod,
        each final startTime=startTime) 
                                   annotation (Placement(transformation(
          origin={0,-80},
          extent={{-10,-10},{10,10}},
          rotation=90)));
      Modelica.Blocks.Interfaces.RealInput u_s[nu_s]
      "Continuous setpoint input signals"   annotation (Placement(
          transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
      Modelica.Blocks.Interfaces.RealInput u_m[nu_m]
      "Continuous measurement input signals"   annotation (Placement(
          transformation(
          origin={0,-120},
          extent={{20,-20},{-20,20}},
          rotation=270)));
      Modelica.Blocks.Interfaces.RealOutput y[ny]
      "Continuous actuator output signals"   annotation (Placement(
          transformation(extent={{100,-10},{120,10}}, rotation=0)));
    equation
      connect(u_s, sampler_s.u)           annotation (Line(points={{-120,0},{
            -92,0}}));
      connect(u_m, sampler_m.u)           annotation (Line(points={{0,-120},{0,
            -106},{0,-92},{-7.34788e-016,-92}}));
      annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Text(
            extent={{-100,-10},{-80,-30}},
            textString="u_s",
            lineColor={0,0,255}),
          Text(
            extent={{-98,34},{-138,24}},
            lineColor={0,0,0},
            textString="(setpoint)"),
          Text(
            extent={{98,24},{138,14}},
            lineColor={0,0,0},
            textString="(actuator)"),
          Text(
            extent={{-62,-110},{-12,-100}},
            lineColor={0,0,0},
            textString=" (measurement)")}),
                              Documentation(info="<html>
<p>
Block has two continuous Real input signal vectors and one
continuous Real output signal vector. The vector signals
are sampled due to the defined <b>samplePeriod</b> parameter.
The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
    end MVdiscrete;

    partial block BooleanBlockIcon "Basic graphical layout of Boolean block"

      annotation (
        Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
              100,100}}), graphics={Rectangle(
            extent={{-100,-100},{100,100}},
            lineColor={255,0,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid), Text(
            extent={{-150,150},{150,110}},
            textString="%name",
            lineColor={0,0,255})}),
      Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output,
Boolean block (no declarations, no equations).
</p>
</html>"));

    end BooleanBlockIcon;

    partial block BooleanSISO
    "Single Input Single Output control block with signals of type Boolean"

      extends BooleanBlockIcon;

  public
      BooleanInput u "Connector of Boolean input signal" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
      BooleanOutput y "Connector of Boolean output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));

      annotation (
      Documentation(info="<html>
<p>
Block has one continuous Boolean input and one continuous Boolean output signal.
</p>
</html>"));
    end BooleanSISO;

partial block BooleanMIMOs
    "Multiple Input Multiple Output continuous control block with same number of inputs and outputs of boolean type"

  extends BooleanBlockIcon;
  parameter Integer n=1 "Number of inputs (= number of outputs)";
  BooleanInput u[n] "Connector of Boolean input signals" 
    annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
  BooleanOutput y[n] "Connector of Boolean output signals" 
    annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
              0)));
  annotation (Documentation(info="<HTML>
<p>
Block has a continuous Boolean input and a continuous Boolean output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</HTML>
"));
end BooleanMIMOs;

partial block MI2BooleanMOs
    "2 Multiple Input / Boolean Multiple Output block with same signal lengths"

  extends BooleanBlockIcon;
  parameter Integer n=1 "Dimension of input and output vectors.";
  RealInput u1[n] "Connector 1 of Boolean input signals" 
    annotation (Placement(transformation(extent={{-140,40},{-100,80}}, rotation=
             0)));
  RealInput u2[n] "Connector 2 of Boolean input signals" 
    annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
            rotation=0)));
  BooleanOutput y[n] "Connector of Boolean output signals" 
    annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
              0)));
  annotation (Documentation(info="<html>
<p>Block has two Boolean input vectors u1 and u2 and one Boolean output
vector y. All vectors have the same number of elements.</p>
</html>
"));
end MI2BooleanMOs;

    partial block SI2BooleanSO "2 Single Input / Boolean Single Output block"

      extends BooleanBlockIcon;
      input RealInput u1 "Connector 1 of Boolean input signals" 
        annotation (Placement(transformation(extent={{-140,40},{-100,80}},
            rotation=0)));
      input RealInput u2 "Connector 2 of Boolean input signals" 
        annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
            rotation=0)));
      output BooleanOutput y "Connector of Boolean output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
        Documentation(info="<html>
<p>
Block has two Boolean input signals u1 and u2 and one Boolean output signal y.
</p>
</html>
"));

    end SI2BooleanSO;

    partial block BooleanSignalSource "Base class for Boolean signal sources"

      extends BooleanBlockIcon;
      BooleanOutput y "Connector of Boolean output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
      annotation (
        Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{68,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid)}),
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics),
      Documentation(info="<html>
<p>
Basic block for Boolean sources of package Blocks.Sources.
This component has one continuous Boolean output signal y.
</p>
</html>"));

    end BooleanSignalSource;

partial block IntegerBlockIcon "Basic graphical layout of Integer block"

  annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={Rectangle(
            extent={{-100,-100},{100,100}},
            lineColor={255,127,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid), Text(
            extent={{-150,150},{150,110}},
            textString="%name",
            lineColor={0,0,255})}),
        Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output,
Integer block (no declarations, no equations).
</p>
</html>"));
end IntegerBlockIcon;

partial block IntegerSO "Single Integer Output continuous control block"
  extends IntegerBlockIcon;

  IntegerOutput y "Connector of Integer output signal" 
    annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
              0)));
    annotation (Documentation(info="<html>
<p>
Block has one continuous Integer output signal.
</p>
</html>"));
end IntegerSO;

partial block IntegerMO "Multiple Integer Output continuous control block"
  extends IntegerBlockIcon;

  parameter Integer nout(min=1) = 1 "Number of outputs";
  IntegerOutput y[nout] "Connector of Integer output signals" 
    annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
              0)));
    annotation (Documentation(info="<html>
<p>
Block has one continuous Integer output signal vector.
</p>
</html>"));
end IntegerMO;

partial block IntegerSignalSource
    "Base class for continuous Integer signal source"
  extends IntegerSO;
  parameter Integer offset=0 "Offset of output signal y";
  parameter SI.Time startTime=0 "Output y = offset for time < startTime";
    annotation (Documentation(info="<html>
<p>
Basic block for Integer sources of package Blocks.Sources.
This component has one continuous Integer output signal y
and two parameters (offset, startTime) to shift the
generated signal.
</p>
</html>"));
end IntegerSignalSource;

partial block IntegerSIBooleanSO
    "Integer Input Boolean Output continuous control block"

  extends BooleanBlockIcon;
  IntegerInput u "Connector of Integer input signal" 
    annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
  BooleanOutput y "Connector of Boolean output signal" 
    annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
              0)));
  annotation (Documentation(info="<HTML>
<p>
Block has a continuous Integer input and a continuous Boolean output signal.
</p>
</HTML>
"));
end IntegerSIBooleanSO;

partial block IntegerMIBooleanMOs
    "Multiple Integer Input Multiple Boolean Output continuous control block with same number of inputs and outputs"

  extends BooleanBlockIcon;
  parameter Integer n=1 "Number of inputs (= number of outputs)";
  IntegerInput u[n] "Connector of Integer input signals" 
    annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
  BooleanOutput y[n] "Connector of Boolean output signals" 
    annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
              0)));
  annotation (Documentation(info="<HTML>
<p>
Block has a continuous Integer input and a continuous Boolean output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</HTML>
"));
end IntegerMIBooleanMOs;

  partial block partialBooleanBlockIcon
    "Basic graphical layout of logical block"

    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={Rectangle(
            extent={{-100,100},{100,-100}},
            lineColor={0,0,0},
            fillColor={210,210,210},
            fillPattern=FillPattern.Solid,
            borderPattern=BorderPattern.Raised), Text(
            extent={{-150,150},{150,110}},
            textString="%name",
            lineColor={0,0,255})}),                        Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output,
Boolean block (no declarations, no equations) used especially
in the Blocks.Logical library.
</p>
</html>"));

  end partialBooleanBlockIcon;

  partial block partialBooleanSISO
    "Partial block with 1 input and 1 output Boolean signal"
    extends partialBooleanBlockIcon;
           Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal"
                                            annotation (Placement(
          transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
           Blocks.Interfaces.BooleanOutput y
      "Connector of Boolean output signal"   annotation (Placement(
          transformation(extent={{100,-10},{120,10}}, rotation=0)));

    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={Ellipse(
            extent={{-71,7},{-85,-7}},
            lineColor=DynamicSelect({235,235,235}, if u > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if u > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid), Ellipse(
            extent={{71,7},{85,-7}},
            lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid)}),
                              Documentation(info="<html>
<p>
Block has one continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

  end partialBooleanSISO;

  partial block partialBooleanSI2SO
    "Partial block with 2 input and 1 output Boolean signal"
    extends partialBooleanBlockIcon;
           Blocks.Interfaces.BooleanInput u1
      "Connector of first Boolean input signal" 
                                             annotation (Placement(
          transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
           Blocks.Interfaces.BooleanInput u2
      "Connector of second Boolean input signal" 
                                             annotation (Placement(
          transformation(extent={{-140,-100},{-100,-60}}, rotation=0)));
           Blocks.Interfaces.BooleanOutput y
      "Connector of Boolean output signal"   annotation (Placement(
          transformation(extent={{100,-10},{120,10}}, rotation=0)));

    annotation (Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(
            extent={{-71,7},{-85,-7}},
            lineColor=DynamicSelect({235,235,235}, if u1 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if u1 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-71,-74},{-85,-88}},
            lineColor=DynamicSelect({235,235,235}, if u2 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if u2 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{71,7},{85,-7}},
            lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid)}),
      Documentation(info="<html>
<p>
Block has two continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

  end partialBooleanSI2SO;

  partial block partialBooleanSI3SO
    "Partial block with 3 input and 1 output Boolean signal"
    extends partialBooleanBlockIcon;
           Blocks.Interfaces.BooleanInput u1
      "Connector of first Boolean input signal" 
                                             annotation (Placement(
          transformation(extent={{-140,60},{-100,100}}, rotation=0)));
           Blocks.Interfaces.BooleanInput u2
      "Connector of second Boolean input signal" 
                                             annotation (Placement(
          transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
           Blocks.Interfaces.BooleanInput u3
      "Connector of third Boolean input signal" 
                                             annotation (Placement(
          transformation(extent={{-140,-100},{-100,-60}}, rotation=0)));
           Blocks.Interfaces.BooleanOutput y
      "Connector of Boolean output signal"   annotation (Placement(
          transformation(extent={{100,-10},{120,10}}, rotation=0)));

    annotation (Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(
            extent={{-71,74},{-85,88}},
            lineColor=DynamicSelect({235,235,235}, if u1 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if u1 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-71,7},{-85,-7}},
            lineColor=DynamicSelect({235,235,235}, if u2 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if u2 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-71,-74},{-85,-88}},
            lineColor=DynamicSelect({235,235,235}, if u3 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if u3 > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{71,7},{85,-7}},
            lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid)}),
      Documentation(info="<html>
Block has three continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

  end partialBooleanSI3SO;

  partial block partialBooleanSI "Partial block with 1 input Boolean signal"
    extends partialBooleanBlockIcon;

           Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal"
                                            annotation (Placement(
          transformation(extent={{-140,-20},{-100,20}}, rotation=0)));

    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={Ellipse(
            extent={{-71,7},{-85,-7}},
            lineColor=DynamicSelect({235,235,235}, if u > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if u > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid)}),
                              Documentation(info="<html>
<p>
Block has one continuous Boolean input signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

  end partialBooleanSI;

  partial block partialBooleanSO "Partial block with 1 output Boolean signal"

           Blocks.Interfaces.BooleanOutput y
      "Connector of Boolean output signal"   annotation (Placement(
          transformation(extent={{100,-10},{120,10}}, rotation=0)));
    extends partialBooleanBlockIcon;

    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={Ellipse(
            extent={{71,7},{85,-7}},
            lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid)}),
                              Documentation(info="<html>
<p>
Block has one continuous Boolean output signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

  end partialBooleanSO;

  partial block partialBooleanSource
    "Partial source block (has 1 output Boolean signal and an appropriate default icon)"
    extends partialBooleanBlockIcon;

    Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" 
      annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));

    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Polygon(
            points={{-80,88},{-88,66},{-72,66},{-80,88}},
            lineColor={255,0,255},
            fillColor={255,0,255},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,66},{-80,-82}}, color={255,0,255}),
          Line(points={{-90,-70},{72,-70}}, color={255,0,255}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={255,0,255},
            fillColor={255,0,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{71,7},{85,-7}},
            lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid)}),
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
              {100,100}}), graphics={
          Polygon(
            points={{-70,92},{-76,70},{-64,70},{-70,92}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-70,70},{-70,-88}}, color={95,95,95}),
          Line(points={{-90,-70},{68,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-64},{68,-76},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{54,-80},{106,-92}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-64,92},{-46,74}},
            lineColor={0,0,0},
            textString="y")}),
      Documentation(info="<html>
<p>
Basic block for Boolean sources of package Blocks.Sources.
This component has one continuous Boolean output signal y
and a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

  end partialBooleanSource;

  partial block partialBooleanThresholdComparison
    "Partial block to compare the Real input u with a threshold and provide the result as 1 Boolean output signal"

    parameter Real threshold=0 "Comparison with respect to threshold";

    Blocks.Interfaces.RealInput u "Connector of Boolean input signal" 
                                  annotation (Placement(transformation(extent={
              {-140,-20},{-100,20}}, rotation=0)));
    Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" 
                                      annotation (Placement(transformation(
            extent={{100,-10},{120,10}}, rotation=0)));

    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Rectangle(
            extent={{-100,100},{100,-100}},
            lineColor={0,0,0},
            fillColor={210,210,210},
            fillPattern=FillPattern.Solid,
            borderPattern=BorderPattern.Raised),
          Text(
            extent={{-150,-140},{150,-110}},
            lineColor={0,0,0},
            textString="%threshold"),
          Ellipse(
            extent={{71,7},{85,-7}},
            lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid)}),
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
              {100,100}}),
                graphics),
      Documentation(info="<html>
<p>
Block has one continuous Real input and one continuous Boolean output signal
as well as a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

  end partialBooleanThresholdComparison;

  partial block partialBooleanComparison
    "Partial block with 2 Real input and 1 Boolean output signal (the result of a comparison of the two Real inputs"

    Blocks.Interfaces.RealInput u1 "Connector of first Boolean input signal" 
                                   annotation (Placement(transformation(extent=
              {{-140,-20},{-100,20}}, rotation=0)));
    Blocks.Interfaces.RealInput u2 "Connector of second Boolean input signal" 
                                   annotation (Placement(transformation(extent=
              {{-140,-100},{-100,-60}}, rotation=0)));
    Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" 
      annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));

    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Rectangle(
            extent={{-100,100},{100,-100}},
            lineColor={0,0,0},
            fillColor={210,210,210},
            fillPattern=FillPattern.Solid,
            borderPattern=BorderPattern.Raised),
          Ellipse(
            extent={{73,7},{87,-7}},
            lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0}
                 else {235,235,235}),
            fillPattern=FillPattern.Solid),
          Ellipse(extent={{32,10},{52,-10}}, lineColor={0,0,255}),
          Line(points={{-100,-80},{42,-80},{42,0}}, color={0,0,255})}),
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
              {100,100}}),
                graphics),
      Documentation(info="<html>
<p>
Block has two continuous Real input and one continuous Boolean output signal
as a result of the comparision of the two input signals. The block
has a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

  end partialBooleanComparison;

package Adaptors
    "Obsolete package with components to send signals to a bus or receive signals from a bus (only for backward compatibility)"

  extends Modelica.Icons.Library;

  block SendReal "Obsolete block to send Real signal to bus"
    RealOutput toBus "Output signal to be connected to bus" annotation (Placement(
            transformation(extent={{100,-10},{120,10}}, rotation=0)));
    RealInput u "Input signal to be send to bus" annotation (Placement(
            transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
  equation
    toBus = u;
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,40},{100,-40}},
              lineColor={0,0,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-144,96},{144,46}},
              lineColor={0,0,0},
              textString="%name"),
            Text(
              extent={{-100,30},{100,-30}},
              lineColor={0,0,255},
              textString="send")}),        Documentation(info="<html>
<p>
Obsolete block that was previously used to connect a Real signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>
"));
  end SendReal;

  block SendBoolean "Obsolete block to send Boolean signal to bus"
    BooleanOutput toBus "Output signal to be connected to bus" annotation (Placement(
            transformation(extent={{100,-10},{120,10}}, rotation=0)));
    BooleanInput u "Input signal to be send to bus" annotation (Placement(
            transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
  equation
    toBus = u;
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,40},{100,-40}},
              lineColor={255,0,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-144,96},{144,46}},
              lineColor={0,0,0},
              textString="%name"),
            Text(
              extent={{-100,30},{100,-30}},
              lineColor={255,0,255},
              textString="send")}),        Documentation(info="<html>
<p>
Obsolete block that was previously used to connect a Boolean signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>
"));
  end SendBoolean;

  block SendInteger "Obsolete block to send Integer signal to bus"
    IntegerOutput toBus "Output signal to be connected to bus" annotation (Placement(
            transformation(extent={{100,-10},{120,10}}, rotation=0)));
    IntegerInput u "Input signal to be send to bus" annotation (Placement(
            transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
  equation
    toBus = u;
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,40},{100,-40}},
              lineColor={255,127,0},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-144,96},{144,46}},
              lineColor={0,0,0},
              textString="%name"),
            Text(
              extent={{-100,30},{100,-30}},
              lineColor={255,127,0},
              textString="send")}),        Documentation(info="<html>
<p>
Obsolete block that was previously used to connect an Integer signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
  end SendInteger;

  block ReceiveReal "Obsolete block to receive Real signal from bus"
    RealInput fromBus "To be connected with signal on bus" annotation (Placement(
            transformation(extent={{-120,-10},{-100,10}}, rotation=0)));
    RealOutput y "Output signal to be received from bus" annotation (Placement(
            transformation(extent={{100,-10},{120,10}}, rotation=0)));
  equation
    y = fromBus;
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,40},{100,-40}},
              lineColor={0,0,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-100,30},{100,-30}},
              lineColor={0,0,255},
              textString="receive"),
            Text(
              extent={{-144,96},{144,46}},
              lineColor={0,0,0},
              textString="%name")}),
                            Documentation(info="<html>
<p>
Obsolete block that was previously used to connect a Real signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
  end ReceiveReal;

  block ReceiveBoolean "Obsolete block to receive Boolean signal from bus"
    BooleanInput fromBus "To be connected with signal on bus" annotation (Placement(
            transformation(extent={{-120,-10},{-100,10}}, rotation=0)));
    BooleanOutput y "Output signal to be received from bus" annotation (Placement(
            transformation(extent={{100,-10},{120,10}}, rotation=0)));
  equation
    y = fromBus;
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,40},{100,-40}},
              lineColor={255,0,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-100,30},{100,-30}},
              lineColor={255,0,255},
              textString="receive"),
            Text(
              extent={{-144,96},{144,46}},
              lineColor={0,0,0},
              textString="%name")}),
                            Documentation(info="<html>
<p>
Obsolete block that was previously used to connect a Boolean signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
  end ReceiveBoolean;

  block ReceiveInteger "Obsolete block to receive Integer signal from bus"
    IntegerInput fromBus "To be connected with signal on bus" annotation (Placement(
            transformation(extent={{-120,-10},{-100,10}}, rotation=0)));
    IntegerOutput y "Output signal to be received from bus" annotation (Placement(
            transformation(extent={{100,-10},{120,10}}, rotation=0)));
  equation
    y = fromBus;
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,40},{100,-40}},
              lineColor={255,127,0},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-100,30},{100,-30}},
              lineColor={255,127,0},
              textString="receive"),
            Text(
              extent={{-144,96},{144,46}},
              lineColor={0,0,0},
              textString="%name")}),
                            Documentation(info="<html>
<p>
Obsolete block that was previously used to connect an Integer signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>
"));
  end ReceiveInteger;

    annotation (Documentation(info="<html>
<p>
The components of this package should no longer be used.
They are only provided for backward compatibility.
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
end Adaptors;

  partial block PartialConversionBlock
    "Partial block defining the interface for conversion blocks"

    RealInput u "Connector of Real input signal to be converted" 
      annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
    RealOutput y
      "Connector of Real output signal containing input signal u in another unit"
      annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Rectangle(
            extent={{-100,100},{100,-100}},
            lineColor={0,0,127},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,0},{30,0}}, color={191,0,0}),
          Polygon(
            points={{90,0},{30,20},{30,-20},{90,0}},
            lineColor={191,0,0},
            fillColor={191,0,0},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-115,155},{115,105}},
            textString="%name",
            lineColor={0,0,255})}),                                      Documentation(info="<html>
<p>
This block defines the interface of a conversion block that
converts from one unit into another one.
</p>

</html>"));

  end PartialConversionBlock;
    annotation (
      Documentation(info="<HTML>
<p>
This package contains interface definitions for
<b>continuous</b> input/output blocks with Real,
Integer and Boolean signals. Furthermore, it contains
partial models for continuous and discrete blocks.
</p>

</HTML>
", revisions="<html>
<ul>
<li><i>Oct. 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       Added several new interfaces. <a href=\"../Documentation/ChangeNotes1.5.html\">Detailed description</a> available.
<li><i>Oct. 24, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       RealInputSignal renamed to RealInput. RealOutputSignal renamed to
       output RealOutput. GraphBlock renamed to BlockIcon. SISOreal renamed to
       SISO. SOreal renamed to SO. I2SOreal renamed to M2SO.
       SignalGenerator renamed to SignalSource. Introduced the following
       new models: MIMO, MIMOs, SVcontrol, MVcontrol, DiscreteBlockIcon,
       DiscreteBlock, DiscreteSISO, DiscreteMIMO, DiscreteMIMOs,
       BooleanBlockIcon, BooleanSISO, BooleanSignalSource, MI2BooleanMOs.</li>
<li><i>June 30, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized a first version, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.</li>
</ul>
</html>
"));
end Interfaces;


package Continuous "Library of continuous control blocks with internal states"

  import Modelica.Blocks.Interfaces;
  import Modelica.SIunits;
  extends Modelica.Icons.Library;

  block Integrator "Output the integral of the input signal"
    import Modelica.Blocks.Types.Init;
    parameter Real k=1 "Integrator gain";

    /* InitialState is the default, because it was the default in Modelica 2.2
     and therefore this setting is backward compatible
  */
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.InitialState
      "Type of initialization (1: no init, 2: steady state, 3,4: initial output)"
                                                                                      annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real y_start=0 "Initial or guess value of output (= state)" 
      annotation (Dialog(group="Initialization"));
    extends Interfaces.SISO(y(start=y_start));

  initial equation
    if initType == Init.SteadyState then
       der(y) = 0;
    elseif initType == Init.InitialState or 
           initType == Init.InitialOutput then
      y = y_start;
    end if;
  equation
    der(y) = k*u;
    annotation (
      Documentation(info="<html>
<p>
This blocks computes output <b>y</b> (element-wise) as
<i>integral</i> of the input <b>u</b> multiplied with
the gain <i>k</i>:
</p>
<pre>
         k
     y = - u
         s
</pre>

<p>
It might be difficult to initialize the integrator in steady state.
This is discussed in the description of package
<a href=\"Modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

</html>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{0,-10},{60,-70}},
            lineColor={192,192,192},
            textString="I"),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="k=%k"),
          Line(points={{-80,-80},{80,80}}, color={0,0,127})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255}),
          Text(
            extent={{-36,60},{32,2}},
            lineColor={0,0,0},
            textString="k"),
          Text(
            extent={{-32,0},{36,-58}},
            lineColor={0,0,0},
            textString="s"),
          Line(points={{-46,0},{46,0}}, color={0,0,0})}));
  end Integrator;

  block LimIntegrator "Integrator with limited value of the output"
    import Modelica.Blocks.Types.Init;
    parameter Real k=1 "Integrator gain";
    parameter Real outMax(start=1) "Upper limit of output";
    parameter Real outMin=-outMax "Lower limit of output";
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.InitialState
      "Type of initialization (1: no init, 2: steady state, 3/4: initial output)"
      annotation(Evaluate=true, Dialog(group="Initialization"));
    parameter Boolean limitsAtInit = true
      "= false, if limits are ignored during initializiation (i.e., der(y)=k*u)"
      annotation(Evaluate=true, Dialog(group="Initialization"));
    parameter Real y_start=0
      "Initial or guess value of output (must be in the limits outMin .. outMax)"
      annotation (Dialog(group="Initialization"));
    extends Interfaces.SISO(y(start=y_start));

  initial equation
    if initType == Init.SteadyState then
       der(y) = 0;
    elseif initType == Init.InitialState or 
           initType == Init.InitialOutput then
      y = y_start;
    end if;
  equation
    if initial() and not limitsAtInit then
       der(y) = k*u;
       assert(y >= outMin - 0.01*abs(outMin) and 
              y <= outMax + 0.01*abs(outMax),
             "LimIntegrator: During initialization the limits have been ignored.\n"+
             "However, the result is that the output y is not within the required limits:\n"+
             "  y = " + String(y) + ", outMin = " + String(outMin) + ", outMax = " + String(outMax));
    else
       der(y) = if y < outMin and u < 0 or y > outMax and u > 0 then 0 else k*u;
    end if;
    annotation (
      Documentation(info="<html>
<p>
This blocks computes <b>y</b> (element-wise) as <i>integral</i>
of the input <b>u</b> multiplied with the gain <i>k</i>. If the
integral reaches a given upper or lower <i>limit</i> and the
input will drive the integral outside of this bound, the
integration is halted and only restarted if the input drives
the integral away from the bounds.
</p>

<p>
It might be difficult to initialize the integrator in steady state.
This is discussed in the description of package
<a href=\"Modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

<p>
If parameter <b>limitAtInit</b> = <b>false</b>, the limits of the
integrator are removed from the initialization problem which
leads to a much simpler equation system. After initialization has been
performed, it is checked via an assert whether the output is in the
defined limits. For backward compatibility reasons
<b>limitAtInit</b> = <b>true</b>. In most cases it is best
to use <b>limitAtInit</b> = <b>false</b>.
</p>
</html>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-80},{20,20},{80,20}}, color={0,0,127}),
          Text(
            extent={{0,-10},{60,-70}},
            lineColor={192,192,192},
            textString="I"),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="k=%k")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Text(
            extent={{-54,46},{-4,-48}},
            lineColor={0,0,0},
            textString="lim"),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255}),
          Text(
            extent={{-8,60},{60,2}},
            lineColor={0,0,0},
            textString="k"),
          Text(
            extent={{-8,-2},{60,-60}},
            lineColor={0,0,0},
            textString="s"),
          Line(points={{4,0},{46,0}}, color={0,0,0})}));
  end LimIntegrator;

  block Derivative "Approximated derivative block"
    import Modelica.Blocks.Types.Init;
    parameter Real k=1 "Gains";
    parameter SIunits.Time T(min=Modelica.Constants.small) = 0.01
      "Time constants (T>0 required; T=0 is ideal derivative block)";
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
      "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                      annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real x_start=0 "Initial or guess value of state" 
      annotation (Dialog(group="Initialization"));
    parameter Real y_start=0 "Initial value of output (= state)" 
      annotation(Dialog(enable=initType == Init.InitialOutput, group=
            "Initialization"));
    extends Interfaces.SISO;

    output Real x(start=x_start) "State of block";

  protected
    parameter Boolean zeroGain = abs(k) < Modelica.Constants.eps;
  initial equation
    if initType == Init.SteadyState then
      der(x) = 0;
    elseif initType == Init.InitialState then
      x = x_start;
    elseif initType == Init.InitialOutput then
      if zeroGain then
         x = u;
      else
         y = y_start;
      end if;
    end if;
  equation
    der(x) = if zeroGain then 0 else (u - x)/T;
    y = if zeroGain then 0 else (k/T)*(u - x);
    annotation (
      Documentation(info="
<HTML>
<p>
This blocks defines the transfer function between the
input u and the output y
(element-wise) as <i>approximated derivative</i>:
</p>
<pre>
             k * s
     y = ------------ * u
            T * s + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general block <b>TransferFunction</b> instead
and model a derivative block with parameters<br>
b = {k,0}, a = {T, 1}.
</p>

<p>
If k=0, the block reduces to y=0.
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-80},{-80,60},{-70,17.95},{-60,-11.46},{-50,-32.05},
                {-40,-46.45},{-30,-56.53},{-20,-63.58},{-10,-68.51},{0,-71.96},
                {10,-74.37},{20,-76.06},{30,-77.25},{40,-78.07},{50,-78.65},{60,
                -79.06}}, color={0,0,127}),
          Text(
            extent={{-30,14},{86,60}},
            lineColor={192,192,192},
            textString="DT1"),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="k=%k")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Text(
            extent={{-54,52},{50,10}},
            lineColor={0,0,0},
            textString="k s"),
          Text(
            extent={{-54,-6},{52,-52}},
            lineColor={0,0,0},
            textString="T s + 1"),
          Line(points={{-50,0},{50,0}}, color={0,0,0}),
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255})}));
  end Derivative;

  block FirstOrder "First order transfer function block (= 1 pole)"
    import Modelica.Blocks.Types.Init;
    parameter Real k=1 "Gain";
    parameter SIunits.Time T(start=1) "Time Constant";
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
      "Type of initialization (1: no init, 2: steady state, 3/4: initial output)"
                                                                                      annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real y_start=0 "Initial or guess value of output (= state)" 
      annotation (Dialog(group="Initialization"));

    extends Interfaces.SISO(y(start=y_start));

  initial equation
    if initType == Init.SteadyState then
      der(y) = 0;
    elseif initType == Init.InitialState or initType == Init.InitialOutput then
      y = y_start;
    end if;
  equation
    der(y) = (k*u - y)/T;
    annotation (
      Documentation(info="<HTML>
<p>
This blocks defines the transfer function between the input u
and the output y (element-wise) as <i>first order</i> system:
</p>
<pre>
               k
     y = ------------ * u
            T * s + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general block <b>TransferFunction</b> instead
and model a first order SISO system with parameters<br>
b = {k}, a = {T, 1}.
</p>
<pre>
Example:
   parameter: k = 0.3, T = 0.4
   results in:
             0.3
      y = ----------- * u
          0.4 s + 1.0
</pre>

</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-80},{-70,-45.11},{-60,-19.58},{-50,-0.9087},{-40,
                12.75},{-30,22.75},{-20,30.06},{-10,35.41},{0,39.33},{10,42.19},
                {20,44.29},{30,45.82},{40,46.94},{50,47.76},{60,48.36},{70,48.8},
                {80,49.12}}, color={0,0,127}),
          Text(
            extent={{0,0},{60,-60}},
            lineColor={192,192,192},
            textString="PT1"),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="T=%T")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Text(
            extent={{-48,52},{50,8}},
            lineColor={0,0,0},
            textString="k"),
          Text(
            extent={{-54,-6},{56,-56}},
            lineColor={0,0,0},
            textString="T s + 1"),
          Line(points={{-50,0},{50,0}}, color={0,0,0}),
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255})}));
  end FirstOrder;

  block SecondOrder "Second order transfer function block (= 2 poles)"
    import Modelica.Blocks.Types.Init;
    parameter Real k=1 "Gain";
    parameter Real w(start=1) "Angular frequency";
    parameter Real D(start=1) "Damping";
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
      "Type of initialization (1: no init, 2: steady state, 3/4: initial output)"
                                                                                      annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real y_start=0 "Initial or guess value of output (= state)" 
      annotation (Dialog(group="Initialization"));
    parameter Real yd_start=0
      "Initial or guess value of derivative of output (= state)" 
      annotation (Dialog(group="Initialization"));

    extends Interfaces.SISO(y(start=y_start));
    output Real yd(start=yd_start) "Derivative of y";

  initial equation
    if initType == Init.SteadyState then
      der(y) = 0;
      der(yd) = 0;
    elseif initType == Init.InitialState or initType == Init.InitialOutput then
      y = y_start;
      yd = yd_start;
    end if;
  equation
    der(y) = yd;
    der(yd) = w*(w*(k*u - y) - 2*D*yd);
    annotation (
      Documentation(info="<HTML>
<p>
This blocks defines the transfer function between the input u and
the output y (element-wise) as <i>second order</i> system:
</p>
<pre>
                             k
     y = ---------------------------------------- * u
            ( s / w )^2 + 2*D*( s / w ) + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general model class <b>TransferFunction</b>
instead and model a second order SISO system with parameters<br>
b = {k}, a = {1/w^2, 2*D/w, 1}.
</p>
<pre>
Example:

   parameter: k =  0.3,  w = 0.5,  D = 0.4
   results in:
                  0.3
      y = ------------------- * u
          4.0 s^2 + 1.6 s + 1
</pre>

</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-80},{-72,-68.53},{-64,-39.5},{-56,-2.522},{-48,
                32.75},{-40,58.8},{-32,71.51},{-24,70.49},{-16,58.45},{-8,40.06},
                {0,20.55},{8,4.459},{16,-5.271},{24,-7.629},{32,-3.428},{40,
                5.21},{48,15.56},{56,25.03},{64,31.66},{72,34.5},{80,33.61}},
              color={0,0,127}),
          Text(
            extent={{0,-10},{60,-70}},
            lineColor={192,192,192},
            textString="PT2"),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="w=%w")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Text(
            extent={{-60,60},{60,14}},
            lineColor={0,0,0},
            textString="k"),
          Text(
            extent={{-60,8},{-32,-20}},
            lineColor={0,0,0},
            textString="s"),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255}),
          Line(points={{-50,14},{50,14}}, color={0,0,0}),
          Line(points={{-54,-20},{-38,-20}}, color={0,0,0}),
          Text(
            extent={{-52,-26},{-36,-48}},
            lineColor={0,0,0},
            textString="w"),
          Line(points={{-50,2},{-56,-8},{-56,-28},{-52,-46}}, color={0,0,0}),
          Line(points={{-40,2},{-34,-10},{-34,-30},{-38,-46}}, color={0,0,0}),
          Text(
            extent={{-34,8},{-22,-10}},
            lineColor={0,0,0},
            textString="2"),
          Text(
            extent={{-34,-6},{6,-36}},
            lineColor={0,0,0},
            textString="+2D"),
          Text(
            extent={{2,8},{30,-20}},
            lineColor={0,0,0},
            textString="s"),
          Line(points={{8,-20},{24,-20}}, color={0,0,0}),
          Text(
            extent={{10,-26},{26,-48}},
            lineColor={0,0,0},
            textString="w"),
          Line(points={{12,2},{6,-8},{6,-28},{10,-46}}, color={0,0,0}),
          Line(points={{22,2},{28,-10},{28,-30},{24,-46}}, color={0,0,0}),
          Text(
            extent={{30,2},{58,-42}},
            lineColor={0,0,0},
            textString="+1")}));
  end SecondOrder;

  block PI "Proportional-Integral controller"
    import Modelica.Blocks.Types.Init;
    parameter Real k=1 "Gain";
    parameter SIunits.Time T(start=1,min=Modelica.Constants.small)
      "Time Constant (T>0 required)";
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
      "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                              annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real x_start=0 "Initial or guess value of state" 
      annotation (Dialog(group="Initialization"));
    parameter Real y_start=0 "Initial value of output" 
      annotation(Dialog(enable=initType == Init.SteadyState or initType == Init.InitialOutput, group=
            "Initialization"));

    extends Interfaces.SISO;
    output Real x(start=x_start) "State of block";

  initial equation
    if initType == Init.SteadyState then
      der(x) = 0;
    elseif initType == Init.InitialState then
      x = x_start;
    elseif initType == Init.InitialOutput then
      y = y_start;
    end if;
  equation
    der(x) = u/T;
    y = k*(x + u);
    annotation (defaultComponentName="PI",
      Documentation(info="
<HTML>
<p>
This blocks defines the transfer function between the input u and
the output y (element-wise) as <i>PI</i> system:
</p>
<pre>
                 1
   y = k * (1 + ---) * u
                T*s
           T*s + 1
     = k * ------- * u
             T*s
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general model class <b>TransferFunction</b>
instead and model a PI SISO system with parameters<br>
b = {k*T, k}, a = {T, 0}.
</p>
<pre>
Example:

   parameter: k = 0.3,  T = 0.4

   results in:
               0.4 s + 1
      y = 0.3 ----------- * u
                 0.4 s
</pre>

<p>
It might be difficult to initialize the PI component in steady state
due to the integrator part.
This is discussed in the description of package
<a href=\"Modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-80},{-80,-20},{60,80}}, color={0,0,127}),
          Text(
            extent={{0,6},{60,-56}},
            lineColor={192,192,192},
            textString="PI"),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="T=%T")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Text(
            extent={{-68,24},{-24,-18}},
            lineColor={0,0,0},
            textString="k"),
          Text(
            extent={{-32,48},{60,0}},
            lineColor={0,0,0},
            textString="T s + 1"),
          Text(
            extent={{-30,-8},{52,-40}},
            lineColor={0,0,0},
            textString="T s"),
          Line(points={{-24,0},{54,0}}, color={0,0,0}),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{62,0},{100,0}}, color={0,0,255})}));
  end PI;

  block PID "PID-controller in additive description form"
    import Modelica.Blocks.Types.InitPID;
    extends Interfaces.SISO;

    parameter Real k=1 "Gain";
    parameter SIunits.Time Ti(min=Modelica.Constants.small, start=0.5)
      "Time Constant of Integrator";
    parameter SIunits.Time Td(min=0, start=0.1)
      "Time Constant of Derivative block";
    parameter Real Nd(min=Modelica.Constants.small) = 10
      "The higher Nd, the more ideal the derivative block";
    parameter Modelica.Blocks.Types.InitPID initType= Modelica.Blocks.Types.InitPID.DoNotUse_InitialIntegratorState
      "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                       annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real xi_start=0
      "Initial or guess value value for integrator output (= integrator state)"
      annotation (Dialog(group="Initialization"));
    parameter Real xd_start=0
      "Initial or guess value for state of derivative block" 
      annotation (Dialog(group="Initialization"));
    parameter Real y_start=0 "Initial value of output" 
      annotation(Dialog(enable=initType == Init.InitialOutput, group=
            "Initialization"));

    Blocks.Math.Gain P(k=1) "Proportional part of PID controller" 
      annotation (Placement(transformation(extent={{-60,60},{-20,100}},
            rotation=0)));
    Blocks.Continuous.Integrator I(k=1/Ti, y_start=xi_start,
      initType=if initType==InitPID.SteadyState then 
                  InitPID.SteadyState else 
               if initType==InitPID.InitialState or 
                  initType==InitPID.DoNotUse_InitialIntegratorState then 
                  InitPID.InitialState else InitPID.NoInit)
      "Integral part of PID controller" 
      annotation (Placement(transformation(extent={{-60,-20},{-20,20}},
            rotation=0)));
    Blocks.Continuous.Derivative D(k=Td, T=max([Td/Nd, 100*Modelica.
          Constants.eps]), x_start=xd_start,
      initType=if initType==InitPID.SteadyState or 
                  initType==InitPID.InitialOutput then InitPID.SteadyState else 
               if initType==InitPID.InitialState then InitPID.InitialState else 
                  InitPID.NoInit) "Derivative part of PID controller" 
      annotation (Placement(transformation(extent={{-60,-100},{-20,-60}},
            rotation=0)));
    Blocks.Math.Gain Gain(k=k) "Gain of PID controller" 
      annotation (Placement(transformation(extent={{60,-10},{80,10}}, rotation=
              0)));
    Blocks.Math.Add3 Add annotation (Placement(transformation(extent={{20,-10},
              {40,10}}, rotation=0)));
  initial equation
    if initType==InitPID.InitialOutput then
       y = y_start;
    end if;

  equation
    connect(u, P.u) annotation (Line(points={{-120,0},{-80,0},{-80,80},{-64,80}},
          color={0,0,127}));
    connect(u, I.u) 
      annotation (Line(points={{-120,0},{-64,0}}, color={0,0,127}));
    connect(u, D.u) annotation (Line(points={{-120,0},{-80,0},{-80,-80},{-64,
            -80}}, color={0,0,127}));
    connect(P.y, Add.u1) annotation (Line(points={{-18,80},{0,80},{0,8},{18,8}},
          color={0,0,127}));
    connect(I.y, Add.u2) 
      annotation (Line(points={{-18,0},{18,0}}, color={0,0,127}));
    connect(D.y, Add.u3) annotation (Line(points={{-18,-80},{0,-80},{0,-8},{18,
            -8}}, color={0,0,127}));
    connect(Add.y, Gain.u) 
      annotation (Line(points={{41,0},{58,0}}, color={0,0,127}));
    connect(Gain.y, y) 
      annotation (Line(points={{81,0},{110,0}}, color={0,0,127}));
    annotation (defaultComponentName="PID",
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-80},{-80,50},{-80,-20},{60,80}}, color={0,0,127}), 

          Text(
            extent={{-20,-20},{80,-60}},
            lineColor={192,192,192},
            textString="PID"),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="Ti=%Ti")}),
      Documentation(info="<HTML>
<p>
This is the text-book version of a PID-controller.
For a more practically useful PID-controller, use
block LimPID.
</p>

<p>
The PID block can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in
<a href=\"Modelica://Modelica.Blocks.Types.InitPID\">Modelica.Blocks.Types.InitPID</a>.
This type is identical to
<a href=\"Modelica://Modelica.Blocks.Types.Init\">Types.Init</a>,
with the only exception that the additional option
<b>DoNotUse_InitialIntegratorState</b> is added for
backward compatibility reasons (= integrator is initialized with
InitialState whereas differential part is initialized with
NoInit which was the initialization in version 2.2 of the Modelica
standard library).
</p>

<p>
Based on the setting of initType, the integrator (I) and derivative (D)
blocks inside the PID controller are initialized according to the following table:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>initType</b></td>
      <td valign=\"top\"><b>I.initType</b></td>
      <td valign=\"top\"><b>D.initType</b></td></tr>

  <tr><td valign=\"top\"><b>NoInit</b></td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">NoInit</td></tr>

  <tr><td valign=\"top\"><b>SteadyState</b></td>
      <td valign=\"top\">SteadyState</td>
      <td valign=\"top\">SteadyState</td></tr>

  <tr><td valign=\"top\"><b>InitialState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">InitialState</td></tr>

  <tr><td valign=\"top\"><b>InitialOutput</b><br>
          and initial equation: y = y_start</td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">SteadyState</td></tr>

  <tr><td valign=\"top\"><b>DoNotUse_InitialIntegratorState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">NoInit</td></tr>
</table>

<p>
In many cases, the most useful initial condition is
<b>SteadyState</b> because initial transients are then no longer
present. If initType = InitPID.SteadyState, then in some
cases difficulties might occur. The reason is the
equation of the integrator:
</p>

<pre>
   <b>der</b>(y) = k*u;
</pre>

<p>
The steady state equation \"der(x)=0\" leads to the condition that the input u to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is natural to
initialize it with zero. As sketched this is, however, not possible.
The solution is to not initialize u or the variable that is used
to compute u by an algebraic equation.
</p>


</HTML>
"),   Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics));
  end PID;

  block LimPID
    "P, PI, PD, and PID controller with limited output, anti-windup compensation and setpoint weighting"
    import Modelica.Blocks.Types.InitPID;
    import Modelica.Blocks.Types.SimpleController;
    extends Interfaces.SVcontrol;
    output Real controlError = u_s - u_m
      "Control error (set point - measurement)";

    parameter Modelica.Blocks.Types.SimpleController controllerType=
           Modelica.Blocks.Types.SimpleController.PID "Type of controller";
    parameter Real k(min=0) = 1 "Gain of controller";
    parameter SIunits.Time Ti(min=Modelica.Constants.small, start=0.5)
      "Time constant of Integrator block" 
       annotation(Dialog(enable=controllerType==SimpleController.PI or 
                                controllerType==SimpleController.PID));
    parameter SIunits.Time Td(min=0, start= 0.1)
      "Time constant of Derivative block" 
         annotation(Dialog(enable=controllerType==SimpleController.PD or 
                                  controllerType==SimpleController.PID));
    parameter Real yMax(start=1) "Upper limit of output";
    parameter Real yMin=-yMax "Lower limit of output";
    parameter Real wp(min=0) = 1
      "Set-point weight for Proportional block (0..1)";
    parameter Real wd(min=0) = 0 "Set-point weight for Derivative block (0..1)"
         annotation(Dialog(enable=controllerType==SimpleController.PD or 
                                  controllerType==SimpleController.PID));
    parameter Real Ni(min=100*Modelica.Constants.eps) = 0.9
      "Ni*Ti is time constant of anti-windup compensation" 
       annotation(Dialog(enable=controllerType==SimpleController.PI or 
                                controllerType==SimpleController.PID));
    parameter Real Nd(min=100*Modelica.Constants.eps) = 10
      "The higher Nd, the more ideal the derivative block" 
         annotation(Dialog(enable=controllerType==SimpleController.PD or 
                                  controllerType==SimpleController.PID));
    parameter Modelica.Blocks.Types.InitPID initType= Modelica.Blocks.Types.InitPID.DoNotUse_InitialIntegratorState
      "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                       annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Boolean limitsAtInit = true
      "= false, if limits are ignored during initializiation" 
      annotation(Evaluate=true, Dialog(group="Initialization",
                         enable=controllerType==SimpleController.PI or 
                                controllerType==SimpleController.PID));
    parameter Real xi_start=0
      "Initial or guess value value for integrator output (= integrator state)"
      annotation (Dialog(group="Initialization",
                  enable=controllerType==SimpleController.PI or 
                         controllerType==SimpleController.PID));
    parameter Real xd_start=0
      "Initial or guess value for state of derivative block" 
      annotation (Dialog(group="Initialization",
                           enable=controllerType==SimpleController.PD or 
                                  controllerType==SimpleController.PID));
    parameter Real y_start=0 "Initial value of output" 
      annotation(Dialog(enable=initType == InitPID.InitialOutput, group=
            "Initialization"));

    Blocks.Math.Add addP(k1=wp, k2=-1) 
      annotation (Placement(transformation(extent={{-80,40},{-60,60}}, rotation=
             0)));
    Blocks.Math.Add addD(k1=wd, k2=-1) if with_D 
      annotation (Placement(transformation(extent={{-80,-10},{-60,10}},
            rotation=0)));
    Blocks.Math.Gain P(k=1) 
                       annotation (Placement(transformation(extent={{-40,40},{
              -20,60}}, rotation=0)));
    Blocks.Continuous.Integrator I(k=1/Ti, y_start=xi_start,
      initType=if initType==InitPID.SteadyState then 
                  InitPID.SteadyState else 
               if initType==InitPID.InitialState or 
                  initType==InitPID.DoNotUse_InitialIntegratorState then 
                  InitPID.InitialState else InitPID.NoInit) if with_I 
      annotation (Placement(transformation(extent={{-40,-60},{-20,-40}},
            rotation=0)));
    Blocks.Continuous.Derivative D(k=Td, T=max([Td/Nd, 1.e-14]), x_start=xd_start,
      initType=if initType==InitPID.SteadyState or 
                  initType==InitPID.InitialOutput then InitPID.SteadyState else 
               if initType==InitPID.InitialState then InitPID.InitialState else 
                  InitPID.NoInit) if with_D 
      annotation (Placement(transformation(extent={{-40,-10},{-20,10}},
            rotation=0)));
    Blocks.Math.Gain gainPID(k=k) annotation (Placement(transformation(extent={
              {30,-10},{50,10}}, rotation=0)));
    Blocks.Math.Add3 addPID annotation (Placement(transformation(
            extent={{0,-10},{20,10}}, rotation=0)));
    Blocks.Math.Add3 addI(k2=-1) if with_I annotation (Placement(
          transformation(extent={{-80,-60},{-60,-40}}, rotation=0)));
    Blocks.Math.Add addSat(k1=+1, k2=-1) if 
                                     with_I 
      annotation (Placement(transformation(
          origin={80,-50},
          extent={{-10,-10},{10,10}},
          rotation=270)));
    Blocks.Math.Gain gainTrack(k=1/(k*Ni)) if with_I 
      annotation (Placement(transformation(extent={{40,-80},{20,-60}}, rotation=
             0)));
    Blocks.Nonlinear.Limiter limiter(uMax=yMax, uMin=yMin, limitsAtInit=limitsAtInit) 
      annotation (Placement(transformation(extent={{70,-10},{90,10}}, rotation=
              0)));
  protected
    parameter Boolean with_I = controllerType==SimpleController.PI or 
                               controllerType==SimpleController.PID annotation(Evaluate=true, HideResult=true);
    parameter Boolean with_D = controllerType==SimpleController.PD or 
                               controllerType==SimpleController.PID annotation(Evaluate=true, HideResult=true);
  public
    Sources.Constant Dzero(k=0) if not with_D 
      annotation (Placement(transformation(extent={{-30,20},{-20,30}}, rotation=
             0)));
    Sources.Constant Izero(k=0) if not with_I 
      annotation (Placement(transformation(extent={{10,-55},{0,-45}}, rotation=
              0)));
  initial equation
    if initType==InitPID.InitialOutput then
       y = y_start;
    end if;
  equation
    assert(yMax >= yMin, "LimPID: Limits must be consistent. However, yMax (=" + String(yMax) +
                         ") < yMin (=" + String(yMin) + ")");
    if initType == InitPID.InitialOutput and (y_start < yMin or y_start > yMax) then
        Modelica.Utilities.Streams.error("LimPID: Start value y_start (=" + String(y_start) +
           ") is outside of the limits of yMin (=" + String(yMin) +") and yMax (=" + String(yMax) + ")");
    end if;
    assert(limitsAtInit or not limitsAtInit and y >= yMin and y <= yMax,
           "LimPID: During initialization the limits have been switched off.\n" +
           "After initialization, the output y (=" + String(y) +
           ") is outside of the limits of yMin (=" + String(yMin) +") and yMax (=" + String(yMax) + ")");

    connect(u_s, addP.u1) annotation (Line(points={{-120,0},{-96,0},{-96,56},{
            -82,56}}, color={0,0,127}));
    connect(u_s, addD.u1) annotation (Line(points={{-120,0},{-96,0},{-96,6},{
            -82,6}}, color={0,0,127}));
    connect(u_s, addI.u1) annotation (Line(points={{-120,0},{-96,0},{-96,-42},{
            -82,-42}}, color={0,0,127}));
    connect(addP.y, P.u) annotation (Line(points={{-59,50},{-42,50}}, color={0,
            0,127}));
    connect(addD.y, D.u) 
      annotation (Line(points={{-59,0},{-42,0}}, color={0,0,127}));
    connect(addI.y, I.u) annotation (Line(points={{-59,-50},{-42,-50}}, color={
            0,0,127}));
    connect(P.y, addPID.u1) annotation (Line(points={{-19,50},{-10,50},{-10,8},
            {-2,8}}, color={0,0,127}));
    connect(D.y, addPID.u2) 
      annotation (Line(points={{-19,0},{-2,0}}, color={0,0,127}));
    connect(I.y, addPID.u3) annotation (Line(points={{-19,-50},{-10,-50},{-10,
            -8},{-2,-8}}, color={0,0,127}));
    connect(addPID.y, gainPID.u) 
      annotation (Line(points={{21,0},{28,0}}, color={0,0,127}));
    connect(gainPID.y, addSat.u2) annotation (Line(points={{51,0},{60,0},{60,
            -20},{74,-20},{74,-38}}, color={0,0,127}));
    connect(gainPID.y, limiter.u) 
      annotation (Line(points={{51,0},{68,0}}, color={0,0,127}));
    connect(limiter.y, addSat.u1) annotation (Line(points={{91,0},{94,0},{94,
            -20},{86,-20},{86,-38}}, color={0,0,127}));
    connect(limiter.y, y) 
      annotation (Line(points={{91,0},{110,0}}, color={0,0,127}));
    connect(addSat.y, gainTrack.u) annotation (Line(points={{80,-61},{80,-70},{
            42,-70}}, color={0,0,127}));
    connect(gainTrack.y, addI.u3) annotation (Line(points={{19,-70},{-88,-70},{
            -88,-58},{-82,-58}}, color={0,0,127}));
    connect(u_m, addP.u2) annotation (Line(
        points={{0,-120},{0,-92},{-92,-92},{-92,44},{-82,44}},
        color={0,0,127},
        thickness=0.5));
    connect(u_m, addD.u2) annotation (Line(
        points={{0,-120},{0,-92},{-92,-92},{-92,-6},{-82,-6}},
        color={0,0,127},
        thickness=0.5));
    connect(u_m, addI.u2) annotation (Line(
        points={{0,-120},{0,-92},{-92,-92},{-92,-50},{-82,-50}},
        color={0,0,127},
        thickness=0.5));
    connect(Dzero.y, addPID.u2) annotation (Line(points={{-19.5,25},{-14,25},{
            -14,0},{-2,0}}, color={0,0,127}));
    connect(Izero.y, addPID.u3) annotation (Line(points={{-0.5,-50},{-10,-50},{
            -10,-8},{-2,-8}}, color={0,0,127}));
    annotation (defaultComponentName="PID",
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-80},{-80,50},{-80,-20},{30,60},{80,60}}, color={0,
                0,127}),
          Text(
            extent={{-20,-20},{80,-60}},
            lineColor={192,192,192},
            textString="PID")}),
      Documentation(info="<HTML>
<p>
Via parameter <b>controllerType</b> either <b>P</b>, <b>PI</b>, <b>PD</b>,
or <b>PID</b> can be selected. If, e.g., PI is selected, all components belonging to the
D-part are removed from the block (via conditional declarations).
The example model
<a href=\"Modelica://Modelica.Blocks.Examples.PID_Controller\">Modelica.Blocks.Examples.PID_Controller</a>
demonstrates the usage of this controller.
Several practical aspects of PID controller design are incorporated
according to chapter 3 of the book:
</p>

<dl>
<dt>&Aring;str&ouml;m K.J., and H&auml;gglund T.:</dt>
<dd> <b>PID Controllers: Theory, Design, and Tuning</b>.
     Instrument Society of America, 2nd edition, 1995.
</dd>
</dl>

<p>
Besides the additive <b>proportional, integral</b> and <b>derivative</b>
part of this controller, the following features are present:
</p>
<ul>
<li> The output of this controller is limited. If the controller is
     in its limits, anti-windup compensation is activated to drive
     the integrator state to zero. </li>
<li> The high-frequency gain of the derivative part is limited
     to avoid excessive amplification of measurement noise.</li>
<li> Setpoint weighting is present, which allows to weight
     the setpoint in the proportional and the derivative part
     independantly from the measurement. The controller will respond
     to load disturbances and measurement noise independantly of this setting
     (parameters wp, wd). However, setpoint changes will depend on this
     setting. For example, it is useful to set the setpoint weight wd
     for the derivative part to zero, if steps may occur in the
     setpoint signal.</li>
</ul>

<p>
The parameters of the controller can be manually adjusted by performing
simulations of the closed loop system (= controller + plant connected
together) and using the following strategy:
</p>

<ol>
<li> Set very large limits, e.g., yMax = Modelica.Constants.inf</li>
<li> Select a <b>P</b>-controller and manually enlarge parameter <b>k</b>
     (the total gain of the controller) until the closed-loop response
     cannot be improved any more.</li>
<li> Select a <b>PI</b>-controller and manually adjust parameters
     <b>k</b> and <b>Ti</b> (the time constant of the integrator).
     The first value of Ti can be selected, such that it is in the
     order of the time constant of the oscillations occuring with
     the P-controller. If, e.g., vibrations in the order of T=10 ms
     occur in the previous step, start with Ti=0.01 s.</li>
<li> If you want to make the reaction of the control loop faster
     (but probably less robust against disturbances and measurement noise)
     select a <b>PID</b>-Controller and manually adjust parameters
     <b>k</b>, <b>Ti</b>, <b>Td</b> (time constant of derivative block).</li>
<li> Set the limits yMax and yMin according to your specification.</li>
<li> Perform simulations such that the output of the PID controller
     goes in its limits. Tune <b>Ni</b> (Ni*Ti is the time constant of
     the anti-windup compensation) such that the input to the limiter
     block (= limiter.u) goes quickly enough back to its limits.
     If Ni is decreased, this happens faster. If Ni=infinity, the
     anti-windup compensation is switched off and the controller works bad.</li>
</ol>

<p>
<b>Initialization</b>
</p>

<p>
This block can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in
<a href=\"Modelica://Modelica.Blocks.Types.InitPID\">Modelica.Blocks.Types.InitPID</a>.
This type is identical to
<a href=\"Modelica://Modelica.Blocks.Types.Init\">Types.Init</a>,
with the only exception that the additional option
<b>DoNotUse_InitialIntegratorState</b> is added for
backward compatibility reasons (= integrator is initialized with
InitialState whereas differential part is initialized with
NoInit which was the initialization in version 2.2 of the Modelica
standard library).
</p>

<p>
Based on the setting of initType, the integrator (I) and derivative (D)
blocks inside the PID controller are initialized according to the following table:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>initType</b></td>
      <td valign=\"top\"><b>I.initType</b></td>
      <td valign=\"top\"><b>D.initType</b></td></tr>

  <tr><td valign=\"top\"><b>NoInit</b></td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">NoInit</td></tr>

  <tr><td valign=\"top\"><b>SteadyState</b></td>
      <td valign=\"top\">SteadyState</td>
      <td valign=\"top\">SteadyState</td></tr>

  <tr><td valign=\"top\"><b>InitialState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">InitialState</td></tr>

  <tr><td valign=\"top\"><b>InitialOutput</b><br>
          and initial equation: y = y_start</td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">SteadyState</td></tr>

  <tr><td valign=\"top\"><b>DoNotUse_InitialIntegratorState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">NoInit</td></tr>
</table>

<p>
In many cases, the most useful initial condition is
<b>SteadyState</b> because initial transients are then no longer
present. If initType = InitPID.SteadyState, then in some
cases difficulties might occur. The reason is the
equation of the integrator:
</p>

<pre>
   <b>der</b>(y) = k*u;
</pre>

<p>
The steady state equation \"der(x)=0\" leads to the condition that the input u to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is natural to
initialize it with zero. As sketched this is, however, not possible.
The solution is to not initialize u_m or the variable that is used
to compute u_m by an algebraic equation.
</p>

<p>
If parameter <b>limitAtInit</b> = <b>false</b>, the limits at the
output of this controller block are removed from the initialization problem which
leads to a much simpler equation system. After initialization has been
performed, it is checked via an assert whether the output is in the
defined limits. For backward compatibility reasons
<b>limitAtInit</b> = <b>true</b>. In most cases it is best
to use <b>limitAtInit</b> = <b>false</b>.
</p>
</HTML>
"),   Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));
  end LimPID;

  block TransferFunction "Linear transfer function"
    import Modelica.Blocks.Types.Init;
    extends Interfaces.SISO;

    parameter Real b[:]={1} "Numerator coefficients of transfer function" 
      annotation(Dialog(group="y = (2*s+3)/(4*s^2+5*s+6)*u is defined as b={2,3}, a={4,5,6}"));
    parameter Real a[:] "Denominator coefficients of transfer function" 
      annotation(Dialog(group="y = (2*s+3)/(4*s^2+5*s+6)*u is defined as b={2,3}, a={4,5,6}"));
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
      "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                       annotation(Evaluate=true, Dialog(group=
            "Initialization"));
    parameter Real x_start[size(a, 1) - 1]=zeros(nx)
      "Initial or guess values of states" 
      annotation (Dialog(group="Initialization"));
    parameter Real y_start=0
      "Initial value of output (derivatives of y are zero upto nx-1-th derivative)"
      annotation(Dialog(enable=initType == Init.InitialOutput, group=
            "Initialization"));
    output Real x[size(a, 1) - 1](start=x_start)
      "State of transfer function from controller canonical form";
  protected
    parameter Integer na=size(a, 1) "Size of Denominator of transfer function.";
    parameter Integer nb=size(b, 1) "Size of Numerator of transfer function.";
    parameter Integer nx=size(a, 1) - 1;
    parameter Real bb[:] = vector([zeros(max(0,na-nb),1);b]);
    parameter Real d = bb[1]/a[1];
    parameter Real a_end = if a[end] > 100*Modelica.Constants.eps*sqrt(a*a) then a[end] else 1.0;
    Real x_scaled[size(x,1)] "Scaled vector x";

  initial equation
    if initType == Init.SteadyState then
      der(x_scaled) = zeros(nx);
    elseif initType == Init.InitialState then
      x_scaled = x_start*a_end;
    elseif initType == Init.InitialOutput then
      y = y_start;
      der(x_scaled[2:nx]) = zeros(nx-1);
    end if;
  equation
    assert(size(b,1) <= size(a,1), "Transfer function is not proper");
    if nx == 0 then
       y = d*u;
    else
       der(x_scaled[1])    = (-a[2:na]*x_scaled + a_end*u)/a[1];
       der(x_scaled[2:nx]) = x_scaled[1:nx-1];
       y = ((bb[2:na] - d*a[2:na])*x_scaled)/a_end + d*u;
       x = x_scaled/a_end;
    end if;
    annotation (
      Documentation(info="<html>
<p>
This block defines the transfer function between the input
u and the output y
as (nb = dimension of b, na = dimension of a):
</p>
<pre>
           b[1]*s^[nb-1] + b[2]*s^[nb-2] + ... + b[nb]
   y(s) = --------------------------------------------- * u(s)
           a[1]*s^[na-1] + a[2]*s^[na-2] + ... + a[na]
</pre>
<p>
State variables <b>x</b> are defined according to <b>controller canonical</b>
form. Internally, vector <b>x</b> is scaled to improve the numerics (the states in versions before version 3.0 of the Modelica Standard Library have been not scaled). This scaling is
not visible from the outside of this block because the non-scaled vector <b>x</b>
is provided as output signal and the start value is with respect to the non-scaled
vector <b>x</b>.
Initial values of the states <b>x</b> can be set via parameter <b>x_start</b>.
</p>

<p>
Example:
</p>
<pre>
     TransferFunction g(b = {2,4}, a = {1,3});
</pre>
<p>
results in the following transfer function:
</p>
<pre>
        2*s + 4
   y = --------- * u
         s + 3
</pre>
</html>"),
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,0},{80,0}}, color={0,0,127}),
          Text(
            extent={{-90,10},{90,90}},
            textString="b(s)",
            lineColor={0,0,127}),
          Text(
            extent={{-90,-10},{90,-90}},
            textString="a(s)",
            lineColor={0,0,127})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{40,0},{-40,0}}, color={0,0,0}),
          Text(
            extent={{-55,55},{55,5}},
            lineColor={0,0,0},
            textString="b(s)"),
          Text(
            extent={{-55,-5},{55,-55}},
            lineColor={0,0,0},
            textString="a(s)"),
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255})}));
  end TransferFunction;

  block StateSpace "Linear state space system"
    import Modelica.Blocks.Types.Init;
    parameter Real A[:, size(A, 1)]
      "Matrix A of state space model (e.g. A=[1, 0; 0, 1])";
    parameter Real B[size(A, 1), :]
      "Matrix B of state space model (e.g. B=[1; 1])";
    parameter Real C[:, size(A, 1)]
      "Matrix C of state space model (e.g. C=[1, 1])";
    parameter Real D[size(C, 1), size(B, 2)]=zeros(size(C, 1), size(B, 2))
      "Matrix D of state space model";
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
      "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                      annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real x_start[nx]=zeros(nx) "Initial or guess values of states" 
      annotation (Dialog(group="Initialization"));
    parameter Real y_start[ny]=zeros(ny)
      "Initial values of outputs (remaining states are in steady state if possible)"
      annotation(Dialog(enable=initType == Init.InitialOutput, group=
            "Initialization"));

    extends Interfaces.MIMO(final nin=size(B, 2), final nout=size(C, 1));
    output Real x[size(A, 1)](start=x_start) "State vector";

  protected
    parameter Integer nx = size(A, 1) "number of states";
    parameter Integer ny = size(C, 1) "number of outputs";
  initial equation
    if initType == Init.SteadyState then
      der(x) = zeros(nx);
    elseif initType == Init.InitialState then
      x = x_start;
    elseif initType == Init.InitialOutput then
      x = Modelica.Math.Matrices.equalityLeastSquares(A, -B*u, C, y_start - D*u);
    end if;
  equation
    der(x) = A*x + B*u;
    y = C*x + D*u;
    annotation (
      Documentation(info="<HTML>
<p>
The State Space block defines the relation
between the input u and the output
y in state space form:
</p>
<pre>

    der(x) = A * x + B * u
        y  = C * x + D * u
</pre>
<p>
The input is a vector of length nu, the output is a vector
of length ny and nx is the number of states. Accordingly
</p>
<pre>
        A has the dimension: A(nx,nx),
        B has the dimension: B(nx,nu),
        C has the dimension: C(ny,nx),
        D has the dimension: D(ny,nu)
</pre>
<p>
Example:
</p>
<pre>
     parameter: A = [0.12, 2;3, 1.5]
     parameter: B = [2, 7;3, 1]
     parameter: C = [0.1, 2]
     parameter: D = zeros(ny,nu)
results in the following equations:
  [der(x[1])]   [0.12  2.00] [x[1]]   [2.0  7.0] [u[1]]
  [         ] = [          ]*[    ] + [        ]*[    ]
  [der(x[2])]   [3.00  1.50] [x[2]]   [0.1  2.0] [u[2]]
                             [x[1]]            [u[1]]
       y[1]   = [0.1  2.0] * [    ] + [0  0] * [    ]
                             [x[2]]            [u[2]]
</pre>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Text(
            extent={{-90,10},{-10,90}},
            textString="A",
            lineColor={0,0,127}),
          Text(
            extent={{10,10},{90,90}},
            textString="B",
            lineColor={0,0,127}),
          Text(
            extent={{-90,-10},{-10,-90}},
            textString="C",
            lineColor={0,0,127}),
          Text(
            extent={{10,-10},{90,-90}},
            textString="D",
            lineColor={0,0,127}),
          Line(points={{0,-90},{0,90}}, color={192,192,192}),
          Line(points={{-90,0},{90,0}}, color={192,192,192})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Text(
            extent={{-60,40},{60,0}},
            lineColor={0,0,0},
            textString="sx=Ax+Bu"),
          Text(
            extent={{-60,0},{60,-40}},
            lineColor={0,0,0},
            textString=" y=Cx+Du"),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255})}));
  end StateSpace;

  block Der "Derivative of input (= analytic differentations)"
      extends Interfaces.SISO;

  equation
    y = der(u);
      annotation (defaultComponentName="der1",
   Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,100}}), 
          graphics={Text(
            extent={{-80,76},{80,-82}},
            textString="der()",
            lineColor={0,0,127})}),
          Documentation(info="<HTML>
<p>
Defines that the output y is the <i>derivative</i>
of the input u. Note, that Modelica.Blocks.Continuous.Derivative
computes the derivative in an approximate sense, where as this block computes
the derivative exactly. This requires that the input u is differentiated
by the Modelica translator, if this derivative is not yet present in
the model.
</p>
</HTML>"));
  end Der;

  block LowpassButterworth
    "Output the input signal filtered with a low pass Butterworth filter of any order"

    import Modelica.Math.*;
    import Modelica.Blocks.Types.Init;

    extends Modelica.Blocks.Interfaces.SISO;

    parameter Integer n(min=1) = 2 "Order of filter";
    parameter SI.Frequency f(start=1) "Cut-off frequency";
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
      "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                      annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real x1_start[m]=zeros(m)
      "Initial or guess values of states 1 (der(x1)=x2))" 
      annotation (Dialog(group="Initialization"));
    parameter Real x2_start[m]=zeros(m) "Initial or guess values of states 2" 
      annotation (Dialog(group="Initialization"));
    parameter Real xr_start=0.0
      "Initial or guess value of real pole for uneven order otherwise dummy" 
      annotation (Dialog(group="Initialization"));
    parameter Real y_start=0.0
      "Initial value of output (states are initialized in steady state if possible)"
       annotation(Dialog(enable=initType == Init.InitialOutput, group=
            "Initialization"));

    output Real x1[m](start=x1_start)
      "states 1 of second order filters (der(x1) = x2)";
    output Real x2[m](start=x2_start) "states 2 of second order filters";
    output Real xr(start=xr_start)
      "state of real pole for uneven order otherwise dummy";
  protected
    constant Real pi=Modelica.Constants.pi;
    parameter Integer m=integer(n/2);
    parameter Boolean evenOrder = 2*m == n;
    parameter Real w=2*pi*f;
    Real z[m + 1];
    Real polereal[m];
    Real poleimag[m];
    Real realpol;
    Real k2[m];
    Real D[m];
    Real w0[m];
    Real k1;
    Real T;
  initial equation
    if initType == Init.SteadyState then
      der(x1) = zeros(m);
      der(x2) = zeros(m);
      if not evenOrder then
        der(xr) = 0.0;
      end if;
    elseif initType == Init.InitialState then
      x1 = x1_start;
      x2 = x2_start;
      if not evenOrder then
        xr = xr_start;
      end if;
    elseif initType == Init.InitialOutput then
      y = y_start;
      der(x1) = zeros(m);
      if evenOrder then
        if m > 1 then
          der(x2[1:m-1]) = zeros(m-1);
        end if;
      else
        der(x1) = zeros(m);
      end if;
    end if;
  equation
    k2 = ones(m);
    k1 = 1;
    z[1] = u;

    // calculate filter parameters
    for i in 1:m loop
      // poles of prototype lowpass
      polereal[i] = cos(pi/2 + pi/n*(i - 0.5));
      poleimag[i] = sin(pi/2 + pi/n*(i - 0.5));
      // scaling and calculation of secon order filter coefficients
      w0[i] = (polereal[i]^2 + poleimag[i]^2)*w;
      D[i] = -polereal[i]/w0[i]*w;
    end for;
    realpol = 1*w;
    T = 1/realpol;

    // calculate second order filters
    for i in 1:m loop
      der(x1[i]) = x2[i];
      der(x2[i]) = k2[i]*w0[i]^2*z[i] - 2*D[i]*w0[i]*x2[i] - w0[i]^2*x1[i];
      z[i + 1] = x1[i];
    end for;

    // calculate first order filter if necessary
    if evenOrder then
      // even order
      xr = 0;
      y = z[m + 1];
    else
      // uneven order
      der(xr) = (k1*z[m + 1] - xr)/T;
      y = xr;
    end if;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
          Polygon(
            points={{-79.5584,91.817},{-87.5584,69.817},{-71.5584,69.817},{-79.5584,
                89.817},{-79.5584,91.817}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-80},{-72,-68.53},{-64,-39.5},{-56,-2.522},{-48,
                32.75},{-40,58.8},{-32,71.51},{-24,70.49},{-16,58.45},{-8,40.06},
                {0,20.55},{8,4.459},{16,-5.271},{24,-7.629},{32,-3.428},{40,
                5.21},{48,15.56},{56,25.03},{64,31.66},{72,34.5},{80,33.61}},
              color={0,0,127}),
          Line(points={{-90.9779,-80.7697},{81.0221,-80.7697}}, color={192,192,
                192}),
          Polygon(
            points={{91.3375,-79.8233},{69.3375,-71.8233},{69.3375,-87.8233},{
                91.3375,-79.8233}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-45.1735,-11.47},{92,-68}},
            lineColor={192,192,192},
            textString="LowpassButterworthFilter"),
          Text(
            extent={{8,-106},{8,-146}},
            lineColor={0,0,0},
            textString="f=%f"),
          Text(
            extent={{-2,94},{94,48}},
            lineColor={192,192,192},
            textString="%n")}),
      Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
              100,100}}), graphics={
          Line(points={{40,0},{-40,0}}, color={0,0,0}),
          Text(
            extent={{-55,55},{55,5}},
            lineColor={0,0,0},
            textString="1"),
          Text(
            extent={{-55,-5},{55,-55}},
            lineColor={0,0,0},
            textString="a(s)"),
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255})}),
      Documentation(info="<html>
<p>
This block defines the transfer function between the input u
and the output y as an n-th order low pass filter with <i>Butterworth</i>
characteristics and cut-off frequency f. It is implemented as
a series of second order filters and a first order filter.
Butterworth filters have the feature that the amplitude at the
cut-off frequency f is 1/sqrt(2) (= 3 dB), i.e., they are
always \"normalized\". Step responses of the Butterworth filter of
different orders are shown in the next figure:
</p>

<p>
<img src=\"../Images/Blocks/Butterworth.png\">
</p>

<p>
If transients at the simulation start shall be avoided, the filter
should be initialized in steady state (e.g., using option
initType=Modelica.Blocks.Types.Init.SteadyState).
</p>


</html>
"));
  end LowpassButterworth;

  block CriticalDamping
    "Output the input signal filtered with an n-th order filter with critical damping"

    import Modelica.Blocks.Types.Init;
    extends Modelica.Blocks.Interfaces.SISO;

    parameter Integer n=2 "Order of filter";
    parameter Modelica.SIunits.Frequency f(start=1) "Cut-off frequency";
    parameter Boolean normalized = true
      "= true, if amplitude at f_cut is 3 dB, otherwise unmodified filter";
    parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
      "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                      annotation(Evaluate=true,
        Dialog(group="Initialization"));
    parameter Real x_start[n]=zeros(n) "Initial or guess values of states" 
      annotation (Dialog(group="Initialization"));
    parameter Real y_start=0.0
      "Initial value of output (remaining states are in steady state)" 
      annotation(Dialog(enable=initType == Init.InitialOutput, group=
            "Initialization"));

    output Real x[n](start=x_start) "Filter states";
  protected
    parameter Real alpha=if normalized then sqrt(2^(1/n) - 1) else 1.0
      "Frequency correction factor for normalized filter";
    parameter Real w=2*Modelica.Constants.pi*f/alpha;
  initial equation
    if initType == Init.SteadyState then
      der(x) = zeros(n);
    elseif initType == Init.InitialState then
      x = x_start;
    elseif initType == Init.InitialOutput then
      y = y_start;
      der(x[1:n-1]) = zeros(n-1);
    end if;
  equation
    der(x[1]) = (u - x[1])*w;
    for i in 2:n loop
      der(x[i]) = (x[i - 1] - x[i])*w;
    end for;
    y = x[n];
    annotation (
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Line(points={{-80.6897,77.6256},{-80.6897,-90.3744}}, color={192,192,
                192}),
          Polygon(
            points={{-79.7044,90.6305},{-87.7044,68.6305},{-71.7044,68.6305},{-79.7044,
                88.6305},{-79.7044,90.6305}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
          Polygon(
            points={{90,-80},{68,-72},{68,-88},{90,-80}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{0,0},{60,-60}},
            lineColor={192,192,192},
            textString="PTn"),
          Line(points={{-80.7599,-80.5082},{-70.7599,-74.5082},{-56,-60},{-48,-42},
                {-42,-18},{-36,4},{-26,20},{-10.7599,34.9018},{-0.759907,
                38.8218},{9.24009,41.6818},{19.2401,43.7818},{29.2401,45.3118},
                {39.2401,46.4318},{49.2401,47.2518},{59.2401,47.8518},{69.2401,
                48.2918},{79.2401,48.6118}}, color={0,0,127}),
          Text(
            extent={{-70,94},{26,48}},
            lineColor={192,192,192},
            textString="%n"),
          Text(
            extent={{8,-106},{8,-146}},
            lineColor={0,0,0},
            textString="f=%f")}),
      Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
              100,100}}), graphics={
          Line(points={{40,0},{-40,0}}, color={0,0,0}),
          Text(
            extent={{-55,55},{55,5}},
            lineColor={0,0,0},
            textString="1"),
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
          Line(points={{-100,0},{-60,0}}, color={0,0,255}),
          Line(points={{60,0},{100,0}}, color={0,0,255}),
          Text(
            extent={{-54,-6},{44,-56}},
            lineColor={0,0,0},
            textString="(s/w + 1)"),
          Text(
            extent={{38,-10},{58,-30}},
            lineColor={0,0,0},
            textString="n")}),
      Documentation(info="<html>
<p>This block defines the transfer function between the
input u and the output y
as an n-th order filter with <i>critical damping</i>
characteristics and cut-off frequency f. It is
implemented as a series of first order filters.
This filter type is especially useful to filter the input of an
inverse model, since the filter does not introduce any transients.
</p>

<p>
If parameter <b>normalized</b> = <b>true</b> (default), the filter
is normalized such that the amplitude of the filter transfer function
at the cut-off frequency f is 1/sqrt(2) (= 3 dB). Otherwise, the filter
is not normalized, i.e., it is unmodified. A normalized filter is usually
much better for applications, since filters of different orders are
\"comparable\", whereas non-normalized filters usually require to adapt the
cut-off frequency, when the order of the filter is changed.
Figures of the filter step responses are shown below.
Note, in versions before version 3.0 of the Modelica Standard library,
the CriticalDamping filter was provided only in non-normalzed form.
</p>

<p>If transients at the simulation start shall be avoided, the filter
should be initialized in steady state (e.g., using option
initType=Modelica.Blocks.Types.Init.SteadyState).
</p>

<p>
The critical damping filter is defined as
</p>

<pre>
    &alpha; = <b>if</b> normalized <b>then</b> <b>sqrt</b>(2^(1/n) - 1) <b>else</b> 1 // frequency correction factor
    &omega; = 2*&pi;*f/&alpha;
              1
    y = ------------- * u
         (s/w + 1)^n

</pre>

<p>
<img src=\"../Images/Blocks/CriticalDampingNormalized.png\">
</p>

<p>
<img src=\"../Images/Blocks/CriticalDampingNonNormalized.png\">
</p>

</html>
"));
  end CriticalDamping;

  annotation (
    Documentation(info="<html>
<p>
This package contains basic <b>continuous</b> input/output blocks
described by differential equations.
</p>

<p>
All blocks of this package can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in
<a href=\"Modelica://Modelica.Blocks.Types.Init\">Modelica.Blocks.Types.Init</a>:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>Name</b></td>
      <td valign=\"top\"><b>Description</b></td></tr>

  <tr><td valign=\"top\"><b>Init.NoInit</b></td>
      <td valign=\"top\">no initialization (start values are used as guess values with fixed=false)</td></tr>

  <tr><td valign=\"top\"><b>Init.SteadyState</b></td>
      <td valign=\"top\">steady state initialization (derivatives of states are zero)</td></tr>

  <tr><td valign=\"top\"><b>Init.InitialState</b></td>
      <td valign=\"top\">Initialization with initial states</td></tr>

  <tr><td valign=\"top\"><b>Init.InitialOutput</b></td>
      <td valign=\"top\">Initialization with initial outputs (and steady state of the states if possibles)</td></tr>
</table>

<p>
For backward compatibility reasons the default of all blocks is
<b>Init.NoInit</b>, with the exception of Integrator and LimIntegrator
where the default is <b>Init.InitialState</b> (this was the initialization
defined in version 2.2 of the Modelica standard library).
</p>

<p>
In many cases, the most useful initial condition is
<b>Init.SteadyState</b> because initial transients are then no longer
present. The drawback is that in combination with a non-linear
plant, non-linear algebraic equations occur that might be
difficult to solve if appropriate guess values for the
iteration variables are not provided (i.e. start values with fixed=false).
However, it is often already useful to just initialize
the linear blocks from the Continuous blocks library in SteadyState.
This is uncritical, because only linear algebraic equations occur.
If Init.NoInit is set, then the start values for the states are
interpreted as <b>guess</b> values and are propagated to the
states with fixed=<b>false</b>.
</p>

<p>
Note, initialization with Init.SteadyState is usually difficult
for a block that contains an integrator
(Integrator, LimIntegrator, PI, PID, LimPID).
This is due to the basic equation of an integrator:
</p>

<pre>
  <b>initial equation</b>
     <b>der</b>(y) = 0;   // Init.SteadyState
  <b>equation</b>
     <b>der</b>(y) = k*u;
</pre>

<p>
The steady state equation leads to the condition that the input to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is always defined by
Init.InitialState or Init.SteadyState initializtion.
</p>

<p>
In such a case, <b>Init.NoInit</b> has to be selected for the integrator
and an additional initial equation has to be added to the system
to which the integrator is connected. E.g., useful initial conditions
for a 1-dim. rotational inertia controlled by a PI controller are that
<b>angle</b>, <b>speed</b>, and <b>acceleration</b> of the inertia are zero.
</p>

</html>
"));
end Continuous;

package Sources
  "Library of signal source blocks generating Real and Boolean signals"
  block RealExpression "Set output signal to a time varying Real expression"

    Modelica.Blocks.Interfaces.RealOutput y=0.0 "Value of Real output" 
      annotation (                            Dialog(group=
            "Time varying output signal"), Placement(transformation(extent={{
              100,-10},{120,10}}, rotation=0)));

    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=false,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(
            extent={{-100,40},{100,-40}},
            lineColor={0,0,0},
            fillColor={235,235,235},
            fillPattern=FillPattern.Solid,
            borderPattern=BorderPattern.Raised),
          Text(
            extent={{-96,15},{96,-15}},
            lineColor={0,0,0},
            textString="%y"),
          Text(
            extent={{-150,90},{140,50}},
            textString="%name",
            lineColor={0,0,255})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics),
      Documentation(info="<html>
<p>
The (time varying) Real output signal of this block can be defined in its
parameter menu via variable <b>y</b>. The purpose is to support the
easy definition of Real expressions in a block diagram. For example,
in the y-menu the definition \"if time &lt; 1 then 0 else 1\" can be given in order
to define that the output signal is one, if time &ge; 1 and otherwise
it is zero. Note, that \"time\" is a built-in variable that is always
accessible and represents the \"model time\" and that
Variable <b>y</b> is both a variable and a connector.
</p>
</html>"));

  end RealExpression;

  block IntegerExpression
    "Set output signal to a time varying Integer expression"

    Modelica.Blocks.Interfaces.IntegerOutput y=0 "Value of Integer output" 
      annotation (                            Dialog(group=
            "Time varying output signal"), Placement(transformation(extent={{
              100,-10},{120,10}}, rotation=0)));

    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=false,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(
            extent={{-100,40},{100,-40}},
            lineColor={0,0,0},
            fillColor={235,235,235},
            fillPattern=FillPattern.Solid,
            borderPattern=BorderPattern.Raised),
          Text(
            extent={{-96,15},{96,-15}},
            lineColor={0,0,0},
            textString="%y"),
          Text(
            extent={{-150,90},{140,50}},
            textString="%name",
            lineColor={0,0,255})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics),
      Documentation(info="<html>
<p>
The (time varying) Integer output signal of this block can be defined in its
parameter menu via variable <b>y</b>. The purpose is to support the
easy definition of Integer expressions in a block diagram. For example,
in the y-menu the definition \"if time &lt; 1 then 0 else 1\" can be given in order
to define that the output signal is one, if time &ge; 1 and otherwise
it is zero. Note, that \"time\" is a built-in variable that is always
accessible and represents the \"model time\" and that
Variable <b>y</b> is both a variable and a connector.
</p>
</html>"));

  end IntegerExpression;

  block BooleanExpression
    "Set output signal to a time varying Boolean expression"

    Modelica.Blocks.Interfaces.BooleanOutput y=false "Value of Boolean output" 
      annotation (                            Dialog(group=
            "Time varying output signal"), Placement(transformation(extent={{
              100,-10},{120,10}}, rotation=0)));

    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=false,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(
            extent={{-100,40},{100,-40}},
            lineColor={0,0,0},
            fillColor={235,235,235},
            fillPattern=FillPattern.Solid,
            borderPattern=BorderPattern.Raised),
          Text(
            extent={{-96,15},{96,-15}},
            lineColor={0,0,0},
            textString="%y"),
          Text(
            extent={{-150,90},{140,50}},
            textString="%name",
            lineColor={0,0,255}),
          Polygon(
            points={{100,10},{120,0},{100,-10},{100,10}},
            lineColor=DynamicSelect({255,0,255}, if y > 0.5 then {0,255,0}
                 else {255,0,255}),
            fillColor=DynamicSelect({255,255,255}, if y > 0.5 then {0,255,0}
                 else {255,255,255}),
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics),
      Documentation(info="<html>
<p>
The (time varying) Boolean output signal of this block can be defined in its
parameter menu via variable <b>y</b>. The purpose is to support the
easy definition of Boolean expressions in a block diagram. For example,
in the y-menu the definition \"time &gt;= 1 and time &lt;= 2\" can be given in order
to define that the output signal is <b>true</b> in the time interval
1 &le; time &le; 2 and otherwise it is <b>false</b>.
Note, that \"time\" is a built-in variable that is always
accessible and represents the \"model time\" and that
Variable <b>y</b> is both a variable and a connector.
</p>
</html>"));

  end BooleanExpression;
  import Modelica.Blocks.Interfaces;
  import Modelica.SIunits;
      extends Modelica.Icons.Library;

      block Clock "Generate actual time signal "
        parameter Modelica.SIunits.Time offset=0 "Offset of output signal";
        parameter Modelica.SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Interfaces.SO;

      equation
        y = offset + (if time < startTime then 0 else time - startTime);
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(extent={{-80,80},{80,-80}}, lineColor={160,160,164}),
          Line(points={{0,80},{0,60}}, color={160,160,164}),
          Line(points={{80,0},{60,0}}, color={160,160,164}),
          Line(points={{0,-80},{0,-60}}, color={160,160,164}),
          Line(points={{-80,0},{-60,0}}, color={160,160,164}),
          Line(points={{37,70},{26,50}}, color={160,160,164}),
          Line(points={{70,38},{49,26}}, color={160,160,164}),
          Line(points={{71,-37},{52,-27}}, color={160,160,164}),
          Line(points={{39,-70},{29,-51}}, color={160,160,164}),
          Line(points={{-39,-70},{-29,-52}}, color={160,160,164}),
          Line(points={{-71,-37},{-50,-26}}, color={160,160,164}),
          Line(points={{-71,37},{-54,28}}, color={160,160,164}),
          Line(points={{-38,70},{-28,51}}, color={160,160,164}),
          Line(
            points={{0,0},{-50,50}},
            color={0,0,0},
            thickness=0.5),
          Line(
            points={{0,0},{40,0}},
            color={0,0,0},
            thickness=0.5),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="startTime=%startTime")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Polygon(
            points={{-80,90},{-85,68},{-75,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(
            points={{-80,0},{-10,0},{60,70}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-64},{68,-76},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-34,0},{-37,-13},{-30,-13},{-34,0}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-34,-13},{-34,-70}}, color={95,95,95}),
          Polygon(
            points={{-34,-69},{-37,-56},{-31,-56},{-34,-69},{-34,-69}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-77,-28},{-35,-40}},
            lineColor={0,0,0},
            textString="offset"),
          Text(
            extent={{-30,-73},{18,-86}},
            lineColor={0,0,0},
            textString="startTime"),
          Text(
            extent={{-81,91},{-40,71}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{63,-79},{94,-89}},
            lineColor={0,0,0},
            textString="time"),
          Line(points={{-10,0},{-10,-70}}, color={95,95,95}),
          Line(points={{-10,0},{50,0}}, color={95,95,95}),
          Line(points={{50,0},{50,60}}, color={95,95,95}),
          Text(
            extent={{35,33},{50,23}},
            lineColor={0,0,0},
            textString="1"),
          Text(
            extent={{14,13},{32,1}},
            lineColor={0,0,0},
            textString="1")}),
      Documentation(info="<html>
<p>
The Real output y is a clock signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Clock.png\">
</p>
</html>"));
      end Clock;

      block Constant "Generate constant signal of type Real"
        parameter Real k(start=1) "Constant output value";
        extends Interfaces.SO;

      equation
        y = k;
        annotation (defaultComponentName="const",
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,0},{80,0}}, color={0,0,0}),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="k=%k")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Polygon(
            points={{-80,90},{-86,68},{-74,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(
            points={{-80,0},{80,0}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-64},{68,-76},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-83,92},{-30,74}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{70,-80},{94,-100}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-101,8},{-81,-12}},
            lineColor={0,0,0},
            textString="k")}),
      Documentation(info="<html>
<p>
The Real output y is a constant signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Constant.png\">
</p>
</html>"));
      end Constant;

      block Step "Generate step signal of type Real"
        parameter Real height=1 "Height of step";
        extends Interfaces.SignalSource;

      equation
        y = offset + (if time < startTime then 0 else height);
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-70},{0,-70},{0,50},{80,50}}, color={0,0,0}),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="startTime=%startTime")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Polygon(
            points={{-80,90},{-86,68},{-74,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(
            points={{-80,-18},{0,-18},{0,50},{80,50}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-64},{68,-76},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{70,-80},{94,-100}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-21,-72},{25,-90}},
            lineColor={0,0,0},
            textString="startTime"),
          Line(points={{0,-17},{0,-71}}, color={95,95,95}),
          Text(
            extent={{-68,-36},{-22,-54}},
            lineColor={0,0,0},
            textString="offset"),
          Line(points={{-13,50},{-13,-17}}, color={95,95,95}),
          Polygon(
            points={{2,50},{-19,50},{2,50}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-13,-17},{-16,-4},{-10,-4},{-13,-17},{-13,-17}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-13,50},{-16,37},{-9,37},{-13,50}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-68,26},{-22,8}},
            lineColor={0,0,0},
            textString="height"),
          Polygon(
            points={{-13,-69},{-16,-56},{-10,-56},{-13,-69},{-13,-69}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-13,-18},{-13,-70}}, color={95,95,95}),
          Polygon(
            points={{-13,-18},{-16,-31},{-9,-31},{-13,-18}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-72,100},{-31,80}},
            lineColor={0,0,0},
            textString="y")}),
      Documentation(info="<html>
<p>
The Real output y is a step signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Step.png\">
</p>

</html>"));
      end Step;

      block Ramp "Generate ramp signal"
        parameter Real height=1 "Height of ramps";
        parameter Modelica.SIunits.Time duration(min=Modelica.Constants.small, start = 2)
      "Durations of ramp";
        parameter Real offset=0 "Offset of output signal";
        parameter Modelica.SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Interfaces.SO;

      equation
        y = offset + (if time < startTime then 0 else if time < (startTime +
          duration) then (time - startTime)*height/duration else height);
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-70},{-40,-70},{31,38}}, color={0,0,0}),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="duration=%duration"),
          Line(points={{31,38},{86,38}}, color={0,0,0})}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Polygon(
            points={{-80,90},{-86,68},{-74,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(
            points={{-80,-20},{-20,-20},{50,50}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-64},{68,-76},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-40,-20},{-42,-30},{-37,-30},{-40,-20}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-40,-20},{-40,-70}},
            color={95,95,95},
            thickness=0.25,
            arrow={Arrow.None,Arrow.None}),
          Polygon(
            points={{-40,-70},{-43,-60},{-38,-60},{-40,-70},{-40,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-72,-39},{-34,-50}},
            lineColor={0,0,0},
            textString="offset"),
          Text(
            extent={{-38,-72},{6,-83}},
            lineColor={0,0,0},
            textString="startTime"),
          Text(
            extent={{-78,92},{-37,72}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{70,-80},{94,-91}},
            lineColor={0,0,0},
            textString="time"),
          Line(points={{-20,-20},{-20,-70}}, color={95,95,95}),
          Line(
            points={{-19,-20},{50,-20}},
            color={95,95,95},
            thickness=0.25,
            arrow={Arrow.None,Arrow.None}),
          Line(
            points={{50,50},{101,50}},
            color={0,0,255},
            thickness=0.5),
          Line(
            points={{50,50},{50,-20}},
            color={95,95,95},
            thickness=0.25,
            arrow={Arrow.None,Arrow.None}),
          Polygon(
            points={{50,-20},{42,-18},{42,-22},{50,-20}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-20,-20},{-11,-18},{-11,-22},{-20,-20}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{50,50},{48,40},{53,40},{50,50}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{50,-20},{47,-10},{52,-10},{50,-20},{50,-20}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{53,23},{82,10}},
            lineColor={0,0,0},
            textString="height"),
          Text(
            extent={{-2,-21},{37,-33}},
            lineColor={0,0,0},
            textString="duration")}),
      Documentation(info="<html>
<p>
The Real output y is a ramp signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Ramp.png\">
</p>
</html>"));
      end Ramp;

      block Sine "Generate sine signal"
        parameter Real amplitude=1 "Amplitude of sine wave";
        parameter SIunits.Frequency freqHz(start=1) "Frequency of sine wave";
        parameter SIunits.Angle phase=0 "Phase of sine wave";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Interfaces.SO;
  protected
        constant Real pi=Modelica.Constants.pi;

      equation
        y = offset + (if time < startTime then 0 else amplitude*
          Modelica.Math.sin(2*pi*freqHz*(time - startTime) + phase));
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,0},{68,0}}, color={192,192,192}),
          Polygon(
            points={{90,0},{68,8},{68,-8},{90,0}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,
                74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,
                59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,
                -64.2},{29.3,-73.1},{35,-78.4},{40.6,-80},{46.2,-77.6},{51.9,-71.5},
                {57.5,-61.9},{63.9,-47.2},{72,-24.8},{80,0}}, color={0,0,0}),
          Text(
            extent={{-147,-152},{153,-112}},
            lineColor={0,0,0},
            textString="freqHz=%freqHz")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,-90},{-80,84}}, color={95,95,95}),
          Polygon(
            points={{-80,97},{-84,81},{-76,81},{-80,97}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-99,-40},{85,-40}}, color={95,95,95}),
          Polygon(
            points={{97,-40},{81,-36},{81,-45},{97,-40}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-41,-2},{-31.6,34.2},{-26.1,53.1},{-21.3,66.4},{-17.1,74.6},
                {-12.9,79.1},{-8.64,79.8},{-4.42,76.6},{-0.201,69.7},{4.02,59.4},
                {8.84,44.1},{14.9,21.2},{27.5,-30.8},{33,-50.2},{37.8,-64.2},{
                42,-73.1},{46.2,-78.4},{50.5,-80},{54.7,-77.6},{58.9,-71.5},{
                63.1,-61.9},{67.9,-47.2},{74,-24.8},{80,0}},
            color={0,0,255},
            thickness=0.5),
          Line(
            points={{-41,-2},{-80,-2}},
            color={0,0,255},
            thickness=0.5),
          Text(
            extent={{-87,12},{-40,0}},
            lineColor={0,0,0},
            textString="offset"),
          Line(points={{-41,-2},{-41,-40}}, color={95,95,95}),
          Text(
            extent={{-60,-43},{-14,-54}},
            lineColor={0,0,0},
            textString="startTime"),
          Text(
            extent={{75,-47},{100,-60}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-80,99},{-40,82}},
            lineColor={0,0,0},
            textString="y"),
          Line(points={{-9,79},{43,79}}, color={95,95,95}),
          Line(points={{-41,-2},{50,-2}}, color={95,95,95}),
          Polygon(
            points={{33,79},{30,66},{37,66},{33,79}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{37,57},{83,39}},
            lineColor={0,0,0},
            textString="amplitude"),
          Polygon(
            points={{33,-2},{30,11},{36,11},{33,-2},{33,-2}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{33,77},{33,-2}}, color={95,95,95})}),
      Documentation(info="<html>
<p>
The Real output y is a sine signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Sine.png\">
</p>
</html>"));
      end Sine;

      block ExpSine "Generate exponentially damped sine signal"
        parameter Real amplitude=1 "Amplitude of sine wave";
        parameter SIunits.Frequency freqHz(start=2) "Frequency of sine wave";
        parameter SIunits.Angle phase=0 "Phase of sine wave";
        parameter SIunits.Damping damping(start=1)
      "Damping coefficient of sine wave";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Interfaces.SO;
  protected
        constant Real pi=Modelica.Constants.pi;

      equation
        y = offset + (if time < startTime then 0 else amplitude*
          Modelica.Math.exp(-(time - startTime)*damping)*Modelica.Math.sin(2*pi
          *freqHz*(time - startTime) + phase));
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,0},{68,0}}, color={192,192,192}),
          Polygon(
            points={{90,0},{68,8},{68,-8},{90,0}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,0},{-75.2,32.3},{-72,50.3},{-68.7,64.5},{-65.5,74.2},
                {-62.3,79.3},{-59.1,79.6},{-55.9,75.3},{-52.7,67.1},{-48.6,52.2},
                {-43,25.8},{-35,-13.9},{-30.2,-33.7},{-26.1,-45.9},{-22.1,-53.2},
                {-18.1,-55.3},{-14.1,-52.5},{-10.1,-45.3},{-5.23,-32.1},{8.44,
                13.7},{13.3,26.4},{18.1,34.8},{22.1,38},{26.9,37.2},{31.8,31.8},
                {38.2,19.4},{51.1,-10.5},{57.5,-21.2},{63.1,-25.9},{68.7,-25.9},
                {75.2,-20.5},{80,-13.8}}, color={0,0,0}),
          Text(
            extent={{-147,-152},{153,-112}},
            lineColor={0,0,0},
            textString="freqHz=%freqHz")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-86,-90},{-86,84}}, color={95,95,95}),
          Polygon(
            points={{-86,98},{-90,82},{-82,82},{-86,98}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-99,-40},{85,-40}}, color={95,95,95}),
          Polygon(
            points={{97,-40},{81,-35},{81,-44},{97,-40}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-50,0},{-46.1,28.2},{-43.5,44},{-40.9,56.4},{-38.2,64.9},{
                -35.6,69.4},{-33,69.6},{-30.4,65.9},{-27.8,58.7},{-24.5,45.7},{
                -19.9,22.5},{-13.4,-12.2},{-9.5,-29.5},{-6.23,-40.1},{-2.96,-46.5},
                {0.302,-48.4},{3.57,-45.9},{6.83,-39.6},{10.8,-28.1},{21.9,12},
                {25.8,23.1},{29.7,30.5},{33,33.3},{36.9,32.5},{40.8,27.8},{46,
                16.9},{56.5,-9.2},{61.7,-18.6},{66.3,-22.7},{70.9,-22.6},{76.1,
                -18},{80,-12.1}},
            color={0,0,255},
            thickness=0.5),
          Text(
            extent={{-80,17},{-57,-3}},
            lineColor={0,0,0},
            textString="offset"),
          Text(
            extent={{-72,-43},{-25,-53}},
            lineColor={0,0,0},
            textString="startTime"),
          Text(
            extent={{77,-53},{101,-64}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-89,99},{-49,82}},
            lineColor={0,0,0},
            textString="y"),
          Line(points={{-50,0},{18,0}}, color={95,95,95}),
          Line(
            points={{-50,0},{-86,0}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-50,77},{-50,0}}, color={95,95,95}),
          Line(points={{18,-1},{18,76}}, color={95,95,95}),
          Line(points={{18,73},{-50,73}}, color={95,95,95}),
          Text(
            extent={{-42,83},{9,74}},
            lineColor={0,0,0},
            textString="1/freqHz"),
          Polygon(
            points={{-49,73},{-40,75},{-40,71},{-49,73}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{18,73},{10,75},{10,71},{18,73}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-50,-61},{-19,-61}}, color={95,95,95}),
          Polygon(
            points={{-18,-61},{-26,-59},{-26,-63},{-18,-61}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-51,-63},{-27,-75}},
            lineColor={0,0,0},
            textString="t"),
          Text(
            extent={{-83,-69},{100,-96}},
            lineColor={0,0,0},
            textString="amplitude*exp(-damping*t)*sin(2*pi*freqHz*t+phase)"),
          Line(points={{-50,0},{-50,-40}}, color={95,95,95}),
          Line(points={{-50,-54},{-50,-72}}, color={95,95,95}),
          Line(points={{-15,-77},{-1,-48}}, color={95,95,95})}),
      Documentation(info="<html>
<p>
The Real output y is a sine signal with exponentially changing amplitude:
</p>

<p>
<img src=\"../Images/Blocks/Sources/ExpSine.png\">
</p>
</html>"));
      end ExpSine;

      model Exponentials "Generate a rising and falling exponential signal"

        parameter Real outMax=1 "Height of output for infinite riseTime";
        parameter SIunits.Time riseTime(min=0,start = 0.5) "Rise time";
        parameter SIunits.Time riseTimeConst(min=Modelica.Constants.small)=0.1
      "Rise time constant; rising is defined as outMax*(1-exp(-riseTime/riseTimeConst))";
        parameter SIunits.Time fallTimeConst(min=Modelica.Constants.small)=
          riseTimeConst "Fall time constant";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Interfaces.SO;
  protected
        Real y_riseTime;

      equation
        y_riseTime = outMax*(1 - Modelica.Math.exp(-riseTime/riseTimeConst));
        y = offset + (if (time < startTime) then 0 else if (time < (startTime
           + riseTime)) then outMax*(1 - Modelica.Math.exp(-(time - startTime)/riseTimeConst)) else 
                y_riseTime*Modelica.Math.exp(-(time - startTime - riseTime)/
          fallTimeConst));

        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-90,-70},{68,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-70},{-77.2,-55.3},{-74.3,-42.1},{-70.8,-27.6},{-67.3,
                -15},{-63.7,-4.08},{-59.5,7.18},{-55.3,16.7},{-50.3,26},{-44.6,
                34.5},{-38.3,42.1},{-31.2,48.6},{-22.7,54.3},{-12.1,59.2},{-10,
                60},{-7.88,47.5},{-5.05,32.7},{-2.22,19.8},{0.606,8.45},{4.14,-3.7},
                {7.68,-14},{11.9,-24.2},{16.2,-32.6},{21.1,-40.5},{26.8,-47.4},
                {33.1,-53.3},{40.9,-58.5},{50.8,-62.8},{60,-65.4}}, color={0,0,
                0}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="riseTime=%riseTime")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-90,-74},{84,-74}}, color={95,95,95}),
          Polygon(
            points={{97,-74},{81,-70},{81,-78},{97,-74}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-40,-34},{-37.2,-19.3},{-34.3,-6.1},{-30.8,8.4},{-27.3,21},
                {-23.7,31.92},{-19.5,43.18},{-15.3,52.7},{-10.3,62},{-4.6,70.5},
                {1.7,78.1},{8.8,84.6},{17.3,90.3},{27.9,95.2},{30,96},{32.12,
                83.5},{34.95,68.7},{37.78,55.8},{40.606,44.45},{44.14,32.3},{
                47.68,22},{51.9,11.8},{56.2,3.4},{61.1,-4.5},{66.8,-11.4},{73.1,
                -17.3},{80.9,-22.5},{90.8,-26.8},{100,-29.4}},
            color={0,0,255},
            thickness=0.5),
          Polygon(
            points={{-80,86},{-86,64},{-74,64},{-80,86}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,64},{-80,-84}}, color={95,95,95}),
          Text(
            extent={{-81,87},{-40,67}},
            lineColor={95,95,95},
            textString="y"),
          Text(
            extent={{-71,-46},{-38,-55}},
            lineColor={0,0,0},
            textString="offset"),
          Polygon(
            points={{-40,-74},{-43,-64},{-38,-64},{-40,-74},{-40,-74}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-40,-33},{-40,-64}}, color={95,95,95}),
          Polygon(
            points={{-40,-34},{-42,-44},{-37,-44},{-40,-34}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-39,-34},{-80,-34}},
            color={0,0,255},
            thickness=0.5),
          Text(
            extent={{-62,-76},{-17,-85}},
            lineColor={0,0,0},
            textString="startTime"),
          Polygon(
            points={{-41,-34},{-32,-32},{-32,-36},{-41,-34}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-40,-34},{29,-34}}, color={95,95,95}),
          Polygon(
            points={{29,-34},{21,-32},{21,-36},{29,-34}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-26,-22},{19,-32}},
            lineColor={0,0,0},
            textString="riseTime"),
          Text(
            extent={{75,-79},{98,-90}},
            lineColor={0,0,0},
            textString="time"),
          Line(points={{30,96},{30,-38}}, color={95,95,95})}),
      Documentation(info="<html>
<p>
The Real output y is a rising exponential followed
by a falling exponential signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Exponentials.png\">
</p>
</html>"));
      end Exponentials;

      block Pulse "Generate pulse signal of type Real"
        parameter Real amplitude=1 "Amplitude of pulse";
        parameter Real width(
          final min=Modelica.Constants.small,
          final max=100) = 50 "Width of pulse in % of period";
        parameter Modelica.SIunits.Time period(final min=Modelica.Constants.small,start=1)
      "Time for one period";
        parameter Real offset=0 "Offset of output signals";
        parameter Modelica.SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Modelica.Blocks.Interfaces.SO;

  protected
        Modelica.SIunits.Time T0(final start=startTime)
      "Start time of current period";
        Modelica.SIunits.Time T_width = period*width/100;
      equation
        when sample(startTime, period) then
          T0 = time;
        end when;
        y = offset + (if time < startTime or time >= T0 + T_width then 0 else 
          amplitude);
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-70},{-40,-70},{-40,44},{0,44},{0,-70},{40,-70},{40,
                44},{79,44}}, color={0,0,0}),
          Text(
            extent={{-147,-152},{153,-112}},
            lineColor={0,0,0},
            textString="period=%period")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Polygon(
            points={{-80,90},{-85,68},{-74,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-65},{68,-76},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-34,1},{-37,-12},{-30,-12},{-34,1}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-34,-1},{-34,-70}}, color={95,95,95}),
          Polygon(
            points={{-34,-70},{-37,-57},{-31,-57},{-34,-70},{-34,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-78,-24},{-35,-36}},
            lineColor={0,0,0},
            textString="offset"),
          Text(
            extent={{-30,-72},{16,-81}},
            lineColor={0,0,0},
            textString="startTime"),
          Text(
            extent={{-82,96},{-49,79}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{66,-79},{87,-89}},
            lineColor={0,0,0},
            textString="time"),
          Line(points={{-10,0},{-10,-70}}, color={95,95,95}),
          Line(
            points={{-80,0},{-10,0},{-10,50},{30,50},{30,0},{50,0},{50,50},{90,
                50}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-10,88},{-10,49}}, color={95,95,95}),
          Line(points={{30,74},{30,50}}, color={95,95,95}),
          Line(points={{50,88},{50,50}}, color={95,95,95}),
          Line(points={{-10,83},{51,83}}, color={95,95,95}),
          Line(points={{-10,69},{30,69}}, color={95,95,95}),
          Text(
            extent={{-3,93},{39,84}},
            lineColor={0,0,0},
            textString="period"),
          Text(
            extent={{-7,78},{30,69}},
            lineColor={0,0,0},
            textString="width"),
          Line(points={{-43,50},{-10,50}}, color={95,95,95}),
          Line(points={{-34,50},{-34,1}}, color={95,95,95}),
          Text(
            extent={{-77,30},{-37,21}},
            lineColor={0,0,0},
            textString="amplitude"),
          Polygon(
            points={{-34,49},{-37,36},{-30,36},{-34,49}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-34,1},{-37,14},{-31,14},{-34,1},{-34,1}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{90,50},{90,0},{100,0}},
            color={0,0,255},
            thickness=0.5),
          Polygon(
            points={{-10,69},{-1,71},{-1,67},{-10,69}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{30,69},{22,71},{22,67},{30,69}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-10,83},{-1,85},{-1,81},{-10,83}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{50,83},{42,85},{42,81},{50,83}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid)}),
      Documentation(info="<html>
<p>
The Real output y is a pulse signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Pulse.png\">
</p>
</html>"));
      end Pulse;

      block SawTooth "Generate saw tooth signal"
        parameter Real amplitude=1 "Amplitude of saw tooth";
        parameter SIunits.Time period(final min=Modelica.Constants.small,start = 1)
      "Time for one period";
        parameter Real offset=0 "Offset of output signals";
        parameter SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Interfaces.SO;
  protected
        SIunits.Time T0(final start=startTime) "Start time of current period";

      equation
        when sample(startTime, period) then
          T0 = time;
        end when;
        y = offset + (if time < startTime then 0 else (amplitude/period)*(time
           - T0));
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-70},{-60,-70},{0,40},{0,-70},{60,41},{60,-70}},
              color={0,0,0}),
          Text(
            extent={{-147,-152},{153,-112}},
            lineColor={0,0,0},
            textString="period=%period")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Polygon(
            points={{-80,90},{-86,68},{-74,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-65},{68,-75},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-34,-19},{-37,-32},{-30,-32},{-34,-19}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-34,-20},{-34,-70}}, color={95,95,95}),
          Polygon(
            points={{-34,-70},{-37,-57},{-31,-57},{-34,-70},{-34,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-65,-39},{-29,-47}},
            lineColor={0,0,0},
            textString="offset"),
          Text(
            extent={{-29,-72},{13,-80}},
            lineColor={0,0,0},
            textString="startTime"),
          Text(
            extent={{-82,92},{-43,76}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{67,-78},{88,-87}},
            lineColor={0,0,0},
            textString="time"),
          Line(points={{-10,-20},{-10,-70}}, color={95,95,95}),
          Line(points={{-10,88},{-10,-20}}, color={95,95,95}),
          Line(points={{30,88},{30,59}}, color={95,95,95}),
          Line(points={{-10,83},{30,83}}, color={95,95,95}),
          Text(
            extent={{-12,94},{34,85}},
            lineColor={0,0,0},
            textString="period"),
          Line(points={{-44,60},{30,60}}, color={95,95,95}),
          Line(points={{-34,47},{-34,-7}}, color={95,95,95}),
          Text(
            extent={{-73,25},{-36,16}},
            lineColor={0,0,0},
            textString="amplitude"),
          Polygon(
            points={{-34,60},{-37,47},{-30,47},{-34,60}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-34,-20},{-37,-7},{-31,-7},{-34,-20},{-34,-20}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-10,83},{-1,85},{-1,81},{-10,83}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{30,83},{22,85},{22,81},{30,83}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-80,-20},{-10,-20},{30,60},{30,-20},{72,60},{72,-20}},
            color={0,0,255},
            thickness=0.5)}),
      Documentation(info="<html>
<p>
The Real output y is a saw tooth signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/SawTooth.png\">
</p>
</html>"));
      end SawTooth;

      block Trapezoid "Generate trapezoidal signal of type Real"
        parameter Real amplitude=1 "Amplitude of trapezoid";
        parameter SIunits.Time rising(final min=0) = 0
      "Rising duration of trapezoid";
        parameter SIunits.Time width(final min=0) = 0.5
      "Width duration of trapezoid";
        parameter SIunits.Time falling(final min=0) = 0
      "Falling duration of trapezoid";
        parameter SIunits.Time period(final min=Modelica.Constants.small, start= 1)
      "Time for one period";
        parameter Integer nperiod=-1
      "Number of periods (< 0 means infinite number of periods)";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Interfaces.SO;
  protected
        parameter SIunits.Time T_rising=rising
      "End time of rising phase within one period";
        parameter SIunits.Time T_width=T_rising + width
      "End time of width phase within one period";
        parameter SIunits.Time T_falling=T_width + falling
      "End time of falling phase within one period";
        SIunits.Time T0(final start=startTime) "Start time of current period";
        Integer counter(start=nperiod) "Period counter";
        Integer counter2(start=nperiod);

      equation
        when pre(counter2) <> 0 and sample(startTime, period) then
          T0 = time;
          counter2 = pre(counter);
          counter = pre(counter) - (if pre(counter) > 0 then 1 else 0);
        end when;
        y = offset + (if (time < startTime or counter2 == 0 or time >= T0 +
          T_falling) then 0 else if (time < T0 + T_rising) then (time - T0)*
          amplitude/T_rising else if (time < T0 + T_width) then amplitude else 
          (T0 + T_falling - time)*amplitude/(T_falling - T_width));
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-147,-152},{153,-112}},
            lineColor={0,0,0},
            textString="period=%period"),
          Line(points={{-81,-70},{-60,-70},{-30,40},{9,40},{39,-70},{61,-70},{
                90,40}}, color={0,0,0})}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Polygon(
            points={{-81,90},{-87,68},{-75,68},{-81,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-81,68},{-81,-80}}, color={95,95,95}),
          Line(points={{-91,-70},{81,-70}}, color={95,95,95}),
          Polygon(
            points={{89,-70},{67,-65},{67,-76},{89,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-46,-30},{-48,-41},{-44,-41},{-46,-30}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-46,-31},{-46,-70}},
            color={95,95,95},
            pattern=LinePattern.Solid,
            arrow={Arrow.None,Arrow.None}),
          Polygon(
            points={{-46,-70},{-48,-60},{-44,-60},{-46,-70},{-46,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-80,-46},{-42,-55}},
            lineColor={0,0,0},
            textString="offset"),
          Text(
            extent={{-49,-71},{-6,-81}},
            lineColor={0,0,0},
            textString="startTime"),
          Text(
            extent={{-80,95},{-47,80}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{66,-78},{89,-89}},
            lineColor={0,0,0},
            textString="time"),
          Line(
            points={{-30,82},{-31,-70}},
            color={95,95,95},
            pattern=LinePattern.Dash),
          Line(
            points={{-11,59},{-11,40}},
            color={95,95,95},
            pattern=LinePattern.Dash),
          Line(
            points={{19,59},{19,39}},
            color={95,95,95},
            pattern=LinePattern.Dash),
          Line(
            points={{39,59},{39,-30}},
            color={95,95,95},
            pattern=LinePattern.Dash),
          Line(points={{-21,76},{60,76}}, color={95,95,95}),
          Line(points={{-30,56},{39,56}}, color={95,95,95}),
          Text(
            extent={{-3,86},{24,77}},
            lineColor={0,0,0},
            textString="period"),
          Text(
            extent={{-11,68},{18,59}},
            lineColor={0,0,0},
            textString="width"),
          Line(
            points={{-43,40},{-11,40}},
            color={95,95,95},
            pattern=LinePattern.Dash),
          Line(
            points={{-40,40},{-40,-19}},
            color={95,95,95},
            pattern=LinePattern.Solid,
            arrow={Arrow.None,Arrow.None}),
          Text(
            extent={{-77,11},{-44,1}},
            lineColor={0,0,0},
            textString="amplitude"),
          Polygon(
            points={{-30,56},{-23,58},{-23,54},{-30,56}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-11,56},{-18,58},{-18,54},{-11,56}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-30,76},{-21,78},{-21,74},{-30,76}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{60,76},{52,78},{52,74},{60,76}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-81,-30},{-31,-30},{-11,40},{19,40},{39,-30},{59,-30},{79,
                40},{99,40}},
            color={0,0,255},
            thickness=0.5),
          Polygon(
            points={{-40,40},{-42,29},{-38,29},{-40,40}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-40,-29},{-42,-19},{-38,-19},{-40,-29},{-40,-29}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{60,84},{59,-30}},
            color={95,95,95},
            pattern=LinePattern.Dash),
          Polygon(
            points={{38,56},{31,58},{31,54},{38,56}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{19,56},{26,58},{26,54},{19,56}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{19,56},{12,58},{12,54},{19,56}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-13,56},{-6,58},{-6,54},{-13,56}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-35,68},{-6,60}},
            lineColor={0,0,0},
            textString="rising"),
          Text(
            extent={{16,68},{44,60}},
            lineColor={0,0,0},
            textString="falling")}),
      Documentation(info="<html>
<p>
The Real output y is a trapezoid signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Trapezoid.png\">
</p>
</html>"));
      end Trapezoid;

      block KinematicPTP
    "Move as fast as possible along a distance within given kinematic constraints"

        parameter Real deltaq[:] "Distance to move";
        parameter Real qd_max[:](each final min=Modelica.Constants.small)
      "Maximum velocities der(q)";
        parameter Real qdd_max[:](each final min=Modelica.Constants.small)
      "Maximum accelerations der(qd)";
        parameter SIunits.Time startTime=0
      "Time instant at which movement starts";

        extends Interfaces.MO(final nout=max([size(deltaq, 1); size(qd_max, 1);
               size(qdd_max, 1)]));

  protected
        parameter Real p_deltaq[nout]=(if size(deltaq, 1) == 1 then ones(nout)*
            deltaq[1] else deltaq);
        parameter Real p_qd_max[nout]=(if size(qd_max, 1) == 1 then ones(nout)*
            qd_max[1] else qd_max);
        parameter Real p_qdd_max[nout]=(if size(qdd_max, 1) == 1 then ones(nout)
            *qdd_max[1] else qdd_max);
        Real sd_max;
        Real sdd_max;
        Real sdd;
        Real aux1[nout];
        Real aux2[nout];
        SIunits.Time Ta1;
        SIunits.Time Ta2;
        SIunits.Time Tv;
        SIunits.Time Te;
        Boolean noWphase;

      equation
        for i in 1:nout loop
          aux1[i] = p_deltaq[i]/p_qd_max[i];
          aux2[i] = p_deltaq[i]/p_qdd_max[i];
        end for;
        sd_max = 1/max(abs(aux1));
        sdd_max = 1/max(abs(aux2));

        Ta1 = sqrt(1/sdd_max);
        Ta2 = sd_max/sdd_max;
        noWphase = Ta2 >= Ta1;
        Tv = if noWphase then Ta1 else 1/sd_max;
        Te = if noWphase then Ta1 + Ta1 else Tv + Ta2;

        // path-acceleration
        sdd = if time < startTime then 0 else ((if noWphase then (if time < Ta1
           + startTime then sdd_max else (if time < Te + startTime then -
          sdd_max else 0)) else (if time < Ta2 + startTime then sdd_max else (
          if time < Tv + startTime then 0 else (if time < Te + startTime then -
          sdd_max else 0)))));

        // acceleration
        y = p_deltaq*sdd;
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,78},{-80,-82}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,0},{82,0}}, color={192,192,192}),
          Polygon(
            points={{90,0},{68,8},{68,-8},{90,0}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-80,0},{-70,0},{-70,70},{-30,70},{-30,0},{20,0},{20,-70},{
                60,-70},{60,0},{68,0}},
            color={0,0,0},
            thickness=0.25),
          Text(
            extent={{2,80},{80,20}},
            lineColor={192,192,192},
            textString="acc"),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="deltaq=%deltaq")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,78},{-80,-72}}, color={95,95,95}),
          Polygon(
            points={{-80,91},{-86,71},{-75,71},{-80,91},{-80,91}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,0},{82,0}}, color={95,95,95}),
          Polygon(
            points={{89,0},{68,5},{68,-5},{89,0}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-80,0},{-70,0},{-70,70},{-30,70},{-30,0},{20,0},{20,-70},{
                60,-70},{60,0},{68,0}},
            color={0,0,255},
            thickness=0.5),
          Text(
            extent={{-73,95},{-16,80}},
            lineColor={0,0,0},
            textString="acceleration"),
          Text(
            extent={{66,20},{88,8}},
            lineColor={0,0,0},
            textString="time")}),
          Documentation(info="<HTML>
<p>
The goal is to move as <b>fast</b> as possible along a distance
<b>deltaq</b>
under given <b>kinematical constraints</b>. The distance can be a positional or
angular range. In robotics such a movement is called <b>PTP</b> (Point-To-Point).
This source block generates the <b>acceleration</b> qdd of this signal
as output:
</p>

<p>
<img src=\"../Images/Blocks/Sources/KinematicPTP.png\">
</p>

<p>
After integrating the output two times, the position q is
obtained. The signal is constructed in such a way that it is not possible
to move faster, given the <b>maximally</b> allowed <b>velocity</b> qd_max and
the <b>maximally</b> allowed <b>acceleration</b> qdd_max.
</p>
<p>
If several distances are given (vector deltaq has more than 1 element),
an acceleration output vector is constructed such that all signals
are in the same periods in the acceleration, constant velocity
and deceleration phase. This means that only one of the signals
is at its limits whereas the others are sychnronized in such a way
that the end point is reached at the same time instant.
</p>

<p>
This element is useful to generate a reference signal for a controller
which controls a drive train or in combination with model
Modelica.Mechanics.Rotational.<b>Accelerate</b> to drive
a flange according to a given acceleration.
</p>

</HTML>
",       revisions=
             "<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>June 27, 2001</i>
       by Bernhard Bachmann.<br>
       Bug fixed that element is also correct if startTime is not zero.</li>
<li><i>Nov. 3, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Vectorized and moved from Rotational to Blocks.Sources.</li>
<li><i>June 29, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       realized.</li>
</ul>
</html>"));
      end KinematicPTP;

  block KinematicPTP2
    "Move as fast as possible from start to end position within given kinematic constraints with output signals q, qd=der(q), qdd=der(qd)"
    import SI = Modelica.SIunits;
    parameter Real q_begin[:] = {0} "Start position";
    parameter Real q_end[:] "End position";
    parameter Real qd_max[:](each final min=Modelica.Constants.small)
      "Maximum velocities der(q)";
    parameter Real qdd_max[:](each final min=Modelica.Constants.small)
      "Maximum accelerations der(qd)";
    parameter Modelica.SIunits.Time startTime=0
      "Time instant at which movement starts";

    extends Modelica.Blocks.Interfaces.BlockIcon;
    final parameter Integer nout=max([size(q_begin, 1); size(q_end, 1); size(
        qd_max, 1); size(qdd_max, 1)])
      "Number of output signals (= dimension of q, qd, qdd, moving)";
    output Modelica.SIunits.Time endTime "Time instant at which movement stops";

    Modelica.Blocks.Interfaces.RealOutput q[nout]
      "Reference position of path planning" 
      annotation (Placement(transformation(extent={{100,70},{120,90}}, rotation=
             0)));
    Modelica.Blocks.Interfaces.RealOutput qd[nout]
      "Reference speed of path planning" 
      annotation (Placement(transformation(extent={{100,20},{120,40}}, rotation=
             0)));
    Modelica.Blocks.Interfaces.RealOutput qdd[nout]
      "Reference acceleration of path planning" 
      annotation (Placement(transformation(extent={{100,-40},{120,-20}},
            rotation=0)));
    Modelica.Blocks.Interfaces.BooleanOutput moving[nout]
      "= true, if end position not yet reached; = false, if end position reached or axis is completely at rest"
      annotation (Placement(transformation(extent={{100,-90},{120,-70}},
            rotation=0)));

  protected
    parameter Real p_q_begin[nout]=(if size(q_begin, 1) == 1 then ones(nout)*
        q_begin[1] else q_begin);
    parameter Real p_q_end[nout]=(if size(q_end, 1) == 1 then ones(nout)*
        q_end[1] else q_end);
    parameter Real p_qd_max[nout]=(if size(qd_max, 1) == 1 then ones(nout)*
        qd_max[1] else qd_max);
    parameter Real p_qdd_max[nout]=(if size(qdd_max, 1) == 1 then ones(nout)*
        qdd_max[1] else qdd_max);
    parameter Real p_deltaq[nout]=p_q_end - p_q_begin;
    constant Real eps=10*Modelica.Constants.eps;
    Boolean motion_ref;
    Real sd_max_inv;
    Real sdd_max_inv;
    Real sd_max;
    Real sdd_max;
    Real sdd;
    Real aux1[nout];
    Real aux2[nout];
    SI.Time Ta1;
    SI.Time Ta2;
    SI.Time Tv;
    SI.Time Te;
    Boolean noWphase;
    SI.Time Ta1s;
    SI.Time Ta2s;
    SI.Time Tvs;
    SI.Time Tes;
    Real sd_max2;
    Real s1;
    Real s2;
    Real s3;
    Real s;
    Real sd;
    Real r_s;
    Real r_sd;
    Real r_sdd;

    function position
       input Real q_qd_qdd[3]
        "Required values for position, speed, acceleration";
       input Real dummy
        "Just to have one input signal that should be differentiated to avoid possible problems in the Modelica tool (is not used)";
       output Real q;
    algorithm
      q :=q_qd_qdd[1];
      annotation (derivative(noDerivative=q_qd_qdd) = position_der,
          __Dymola_InlineAfterIndexReduction=true);
    end position;

    function position_der
       input Real q_qd_qdd[3]
        "Required values for position, speed, acceleration";
       input Real dummy
        "Just to have one input signal that should be differentiated to avoid possible problems in the Modelica tool (is not used)";
       input Real dummy_der;
       output Real qd;
    algorithm
      qd :=q_qd_qdd[2];
      annotation (derivative(noDerivative=q_qd_qdd) = position_der2,
          __Dymola_InlineAfterIndexReduction=true);
    end position_der;

    function position_der2
       input Real q_qd_qdd[3]
        "Required values for position, speed, acceleration";
       input Real dummy
        "Just to have one input signal that should be differentiated to avoid possible problems in the Modelica tool (is not used)";
       input Real dummy_der;
       input Real dummy_der2;
       output Real qdd;
    algorithm
      qdd :=q_qd_qdd[3];
    end position_der2;
  equation
    for i in 1:nout loop
      aux1[i] = p_deltaq[i]/p_qd_max[i];
      aux2[i] = p_deltaq[i]/p_qdd_max[i];
    end for;

    sd_max_inv = max(abs(aux1));
    sdd_max_inv = max(abs(aux2));

    if sd_max_inv <= eps or sdd_max_inv <= eps then
      sd_max = 0;
      sdd_max = 0;
      Ta1 = 0;
      Ta2 = 0;
      noWphase = false;
      Tv = 0;
      Te = 0;
      Ta1s = 0;
      Ta2s = 0;
      Tvs = 0;
      Tes = 0;
      sd_max2 = 0;
      s1 = 0;
      s2 = 0;
      s3 = 0;
      r_sdd = 0;
      r_sd = 0;
      r_s = 0;
    else
      sd_max = 1/max(abs(aux1));
      sdd_max = 1/max(abs(aux2));
      Ta1 = sqrt(1/sdd_max);
      Ta2 = sd_max/sdd_max;
      noWphase = Ta2 >= Ta1;
      Tv = if noWphase then Ta1 else 1/sd_max;
      Te = if noWphase then Ta1 + Ta1 else Tv + Ta2;
      Ta1s = Ta1 + startTime;
      Ta2s = Ta2 + startTime;
      Tvs = Tv + startTime;
      Tes = Te + startTime;
      sd_max2 = sdd_max*Ta1;
      s1 = sdd_max*(if noWphase then Ta1*Ta1 else Ta2*Ta2)/2;
      s2 = s1 + (if noWphase then sd_max2*(Te - Ta1) - (sdd_max/2)*(Te - Ta1)
        ^2 else sd_max*(Tv - Ta2));
      s3 = s2 + sd_max*(Te - Tv) - (sdd_max/2)*(Te - Tv)*(Te - Tv);

      if time < startTime then
        r_sdd = 0;
        r_sd = 0;
        r_s = 0;
      elseif noWphase then
        if time < Ta1s then
          r_sdd = sdd_max;
          r_sd = sdd_max*(time - startTime);
          r_s = (sdd_max/2)*(time - startTime)*(time - startTime);
        elseif time < Tes then
          r_sdd = -sdd_max;
          r_sd = sd_max2 - sdd_max*(time - Ta1s);
          r_s = s1 + sd_max2*(time - Ta1s) - (sdd_max/2)*(time - Ta1s)*(time
             - Ta1s);
        else
          r_sdd = 0;
          r_sd = 0;
          r_s = s2;
        end if;
      elseif time < Ta2s then
        r_sdd = sdd_max;
        r_sd = sdd_max*(time - startTime);
        r_s = (sdd_max/2)*(time - startTime)*(time - startTime);
      elseif time < Tvs then
        r_sdd = 0;
        r_sd = sd_max;
        r_s = s1 + sd_max*(time - Ta2s);
      elseif time < Tes then
        r_sdd = -sdd_max;
        r_sd = sd_max - sdd_max*(time - Tvs);
        r_s = s2 + sd_max*(time - Tvs) - (sdd_max/2)*(time - Tvs)*(time - Tvs);
      else
        r_sdd = 0;
        r_sd = 0;
        r_s = s3;
      end if;

    end if;

    // acceleration
    qdd = p_deltaq*sdd;
    qd = p_deltaq*sd;
    q = p_q_begin + p_deltaq*s;
    endTime = Tes;

    s = position({r_s, r_sd, r_sdd}, time);
    sd = der(s);
    sdd = der(sd);

    // report when axis is moving
    motion_ref = time <= endTime;
    for i in 1:nout loop
      moving[i] = if abs(q_begin[i] - q_end[i]) > eps then motion_ref else false;
    end for;

    annotation (defaultComponentName="kinematicPTP",
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-82}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,0},{17,0}}, color={192,192,192}),
          Line(
            points={{-80,0},{-70,0},{-70,70},{-50,70},{-50,0},{-15,0},{-15,-70},
                {5,-70},{5,0},{18,0}},
            color={0,0,0},
            thickness=0.25),
          Text(
            extent={{34,96},{94,66}},
            lineColor={0,0,0},
            textString="q"),
          Text(
            extent={{40,44},{96,14}},
            lineColor={0,0,0},
            textString="qd"),
          Text(
            extent={{32,-18},{99,-44}},
            lineColor={0,0,0},
            textString="qdd"),
          Text(
            extent={{-32,-74},{97,-96}},
            lineColor={0,0,0},
            textString="moving")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(points={{-80,78},{-80,-70}}, color={95,95,95}),
          Polygon(
            points={{-80,94},{-86,74},{-74,74},{-80,94},{-80,94}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,0},{82,0}}, color={95,95,95}),
          Polygon(
            points={{90,0},{68,6},{68,-6},{90,0}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-80,0},{-70,0},{-70,70},{-30,70},{-30,0},{20,0},{20,-70},{
                60,-70},{60,0},{68,0}},
            color={0,0,255},
            thickness=0.5),
          Text(
            extent={{-72,96},{-15,81}},
            lineColor={0,0,0},
            textString="acceleration"),
          Text(
            extent={{69,18},{91,6}},
            lineColor={0,0,0},
            textString="time")}),
      Documentation(info="<html>
<p>
The goal is to move as <b>fast</b> as possible from start position <b>q_begin</b>
to end position <b>q_end</b>
under given <b>kinematical constraints</b>. The positions can be translational or
rotational definitions (i.e., q_begin/q_end is given). In robotics such a movement is called <b>PTP</b> (Point-To-Point).
This source block generates the <b>position</b> q(t), the
<b>speed</b> qd(t) = der(q), and the <b>acceleration</b> qdd = der(qd)
as output. The signals are constructed in such a way that it is not possible
to move faster, given the <b>maximally</b> allowed <b>velocity</b> qd_max and
the <b>maximally</b> allowed <b>acceleration</b> qdd_max:
</p>

<p>
<img src=\"../Images/Blocks/Sources/KinematicPTP2.png\">
</p>

<p>
If vectors q_begin/q_end have more than 1 element,
the output vectors are constructed such that all signals
are in the same periods in the acceleration, constant velocity
and deceleration phase. This means that only one of the signals
is at its limits whereas the others are sychnronized in such a way
that the end point is reached at the same time instant.
</p>

<p>
This element is useful to generate a reference signal for a controller
which controls, e.g., a drive train, or to drive
a flange according to a given acceleration.
</p>

</html>
",   revisions="<html>
<ul>
<li><i>March 24, 2007</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Non-standard Modelica function \"constrain(..)\" replaced by standard
       Modelica implementation (via internal function position()).<br>
       New output signal \"moving\" added.</li>
<li><i>June 27, 2001</i>
       by Bernhard Bachmann.<br>
       Bug fixed that element is also correct if startTime is not zero.</li>
<li><i>Nov. 3, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Vectorized and moved from Rotational to Blocks.Sources.</li>
<li><i>June 29, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       realized.</li>
</ul>
</html>"));
  end KinematicPTP2;

      block TimeTable
    "Generate a (possibly discontinuous) signal by linear interpolation in a table"

        parameter Real table[:, 2]
      "Table matrix (time = first column; e.g. table=[0, 0; 1, 1; 2, 4])";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0
      "Output = offset for time < startTime";
        extends Interfaces.SO;
  protected
        Real a "Interpolation coefficients a of actual interval (y=a*x+b)";
        Real b "Interpolation coefficients b of actual interval (y=a*x+b)";
        Integer last(start=1) "Last used lower grid index";
        SIunits.Time nextEvent(start=0, fixed=true) "Next event instant";

        function getInterpolationCoefficients
      "Determine interpolation coefficients and next time event"
          input Real table[:, 2] "Table for interpolation";
          input Real offset "y-offset";
          input Real startTime "time-offset";
          input Real t "Actual time instant";
          input Integer last "Last used lower grid index";
          input Real TimeEps
        "Relative epsilon to check for identical time instants";
          output Real a "Interpolation coefficients a (y=a*x + b)";
          output Real b "Interpolation coefficients b (y=a*x + b)";
          output Real nextEvent "Next event instant";
          output Integer next "New lower grid index";
    protected
          Integer columns=2 "Column to be interpolated";
          Integer ncol=2 "Number of columns to be interpolated";
          Integer nrow=size(table, 1) "Number of table rows";
          Integer next0;
          Real tp;
          Real dt;
        algorithm
          next := last;
          nextEvent := t - TimeEps*abs(t);
          // in case there are no more time events
          tp := t + TimeEps*abs(t) - startTime;

          if tp < 0.0 then
            // First event not yet reached
            nextEvent := startTime;
            a := 0;
            b := offset;
          elseif nrow < 2 then
            // Special action if table has only one row
            a := 0;
            b := offset + table[1, columns];
          else

              // Find next time event instant. Note, that two consecutive time instants
            // in the table may be identical due to a discontinuous point.
            while next < nrow and tp >= table[next, 1] loop
              next := next + 1;
            end while;

            // Define next time event, if last table entry not reached
            if next < nrow then
              nextEvent := startTime + table[next, 1];
            end if;

            // Determine interpolation coefficients
            next0 := next - 1;
            dt := table[next, 1] - table[next0, 1];
            if dt <= TimeEps*abs(table[next, 1]) then
              // Interpolation interval is not big enough, use "next" value
              a := 0;
              b := offset + table[next, columns];
            else
              a := (table[next, columns] - table[next0, columns])/dt;
              b := offset + table[next0, columns] - a*table[next0, 1];
            end if;
          end if;
          // Take into account startTime "a*(time - startTime) + b"
          b := b - a*startTime;
        end getInterpolationCoefficients;
      algorithm
        when {time >= pre(nextEvent),initial()} then
          (a,b,nextEvent,last) := getInterpolationCoefficients(table, offset,
            startTime, time, last, 100*Modelica.Constants.eps);
        end when;
      equation
        y = a*time + b;
        annotation (
          Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-48,70},{2,-50}},
            lineColor={255,255,255},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-48,-50},{-48,70},{52,70},{52,-50},{-48,-50},{-48,-20},
                {52,-20},{52,10},{-48,10},{-48,40},{52,40},{52,70},{2,70},{2,-51}}, 
              color={0,0,0}),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="offset=%offset")}),
          Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Polygon(
            points={{-80,90},{-85,68},{-74,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{88,-70},{68,-65},{68,-74},{88,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-20,90},{30,-30}},
            lineColor={255,255,255},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-20,-30},{-20,90},{80,90},{80,-30},{-20,-30},{-20,0},{
                80,0},{80,30},{-20,30},{-20,60},{80,60},{80,90},{30,90},{30,-31}}, 
              color={0,0,0}),
          Text(
            extent={{-70,-42},{-32,-54}},
            lineColor={0,0,0},
            textString="offset"),
          Polygon(
            points={{-31,-30},{-33,-40},{-28,-40},{-31,-30}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-31,-70},{-34,-60},{-29,-60},{-31,-70},{-31,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-31,-32},{-31,-70}}, color={95,95,95}),
          Line(points={{-20,-30},{-20,-70}}, color={95,95,95}),
          Text(
            extent={{-38,-73},{8,-83}},
            lineColor={0,0,0},
            textString="startTime"),
          Line(points={{-20,-30},{-80,-30}}, color={95,95,95}),
          Text(
            extent={{-76,93},{-44,75}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{66,-78},{90,-88}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-15,83},{24,68}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{33,83},{76,67}},
            lineColor={0,0,0},
            textString="y")}),
          Documentation(info="<HTML>
<p>
This block generates an output signal by <b>linear interpolation</b> in
a table. The time points and function values are stored in a matrix
<b>table[i,j]</b>, where the first column table[:,1] contains the
time points and the second column contains the data to be interpolated.
The table interpolation has the following proporties:
</p>
<ul>
<li>The time points need to be <b>monotonically increasing</b>. </li>
<li><b>Discontinuities</b> are allowed, by providing the same
    time point twice in the table. </li>
<li>Values <b>outside</b> of the table range, are computed by
    <b>extrapolation</b> through the last or first two points of the
    table.</li>
<li>If the table has only <b>one row</b>, no interpolation is performed and
    the function value is just returned independantly of the
    actual time instant.</li>
<li>Via parameters <b>startTime</b> and <b>offset</b> the curve defined
    by the table can be shifted both in time and in the ordinate value.
<li>The table is implemented in a numerically sound way by
    generating <b>time events</b> at interval boundaries,
    in order to not integrate over a discontinuous or not differentiable
    points.
</li>
</ul>
<p>
Example:
</p>
<pre>
   table = [0  0
            1  0
            1  1
            2  4
            3  9
            4 16]
If, e.g., time = 1.0, the output y =  0.0 (before event), 1.0 (after event)
    e.g., time = 1.5, the output y =  2.5,
    e.g., time = 2.0, the output y =  4.0,
    e.g., time = 5.0, the output y = 23.0 (i.e. extrapolation).
</pre>


<p>
<img src=\"../Images/Blocks/Sources/TimeTable.png\">
</p>

</HTML>
",       revisions=
             "<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Oct. 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       Corrected interface from
<pre>
    parameter Real table[:, :]=[0, 0; 1, 1; 2, 4];
</pre>
       to
<pre>
    parameter Real table[:, <b>2</b>]=[0, 0; 1, 1; 2, 4];
</pre>
       </li>
<li><i>Nov. 7, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized.</li>
</ul>
</html>"));
      end TimeTable;

  model CombiTimeTable
    "Table look-up with respect to time and linear/perodic extrapolation methods (data from matrix/file)"

    parameter Boolean tableOnFile=false
      "= true, if table is defined on file or in function usertab" 
      annotation(Dialog(group="table data definition"));
    parameter Real table[:, :] = fill(0.0,0,2)
      "Table matrix (time = first column; e.g. table=[0,2])" 
         annotation(Dialog(group="table data definition", enable = not tableOnFile));
    parameter String tableName="NoName"
      "Table name on file or in function usertab (see docu)" 
         annotation(Dialog(group="table data definition", enable = tableOnFile));
    parameter String fileName="NoName" "File where matrix is stored" 
         annotation(Dialog(group="table data definition", enable = tableOnFile,
                           __Dymola_loadSelector(filter="Text files (*.txt);;Matlab files (*.mat)",
                           caption="Open file in which table is present")));
    parameter Integer columns[:]=2:size(table, 2)
      "Columns of table to be interpolated" 
    annotation(Dialog(group="table data interpretation"));
    parameter Modelica.Blocks.Types.Smoothness smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments
      "Smoothness of table interpolation" 
    annotation(Dialog(group="table data interpretation"));
    parameter Modelica.Blocks.Types.Extrapolation extrapolation=Modelica.Blocks.Types.Extrapolation.LastTwoPoints
      "Extrapolation of data outside the definition range" 
    annotation(Dialog(group="table data interpretation"));
    parameter Real offset[:]={0} "Offsets of output signals" 
    annotation(Dialog(group="table data interpretation"));
    parameter Modelica.SIunits.Time startTime=0
      "Output = offset for time < startTime" 
    annotation(Dialog(group="table data interpretation"));
    extends Modelica.Blocks.Interfaces.MO(final nout=max([size(columns, 1); size(offset, 1)]));
    final parameter Real t_min(fixed=false)
      "Minimum abscissa value defined in table";
    final parameter Real t_max(fixed=false)
      "Maximum abscissa value defined in table";

  protected
    final parameter Real p_offset[nout]=(if size(offset, 1) == 1 then ones(nout)
         *offset[1] else offset);

    Integer tableID;

    function tableTimeInit
      "Initialize 1-dim. table where first column is time (for details see: Modelica/C-Sources/ModelicaTables.h)"
      input String tableName;
      input String fileName;
      input Real table[ :, :];
      input Real startTime;
      input Modelica.Blocks.Types.Smoothness smoothness;
      input Modelica.Blocks.Types.Extrapolation extrapolation;
      output Integer tableID;
    external "C" tableID = ModelicaTables_CombiTimeTable_init(
                   tableName, fileName, table, size(table, 1), size(table, 2),
                   startTime, smoothness, extrapolation);
      annotation(Library="ModelicaExternalC");
    end tableTimeInit;

    function tableTimeIpo
      "Interpolate 1-dim. table where first column is time (for details see: Modelica/C-Sources/ModelicaTables.h)"
      input Integer tableID;
      input Integer icol;
      input Real timeIn;
      output Real value;
    external "C" value = 
                       ModelicaTables_CombiTimeTable_interpolate(tableID, icol, timeIn);
      annotation(Library="ModelicaExternalC");
    end tableTimeIpo;

    function tableTimeTmin
      "Return minimum time value of 1-dim. table where first column is time (for details see: Modelica/C-Sources/ModelicaTables.h)"
      input Integer tableID;
      output Real Tmin "minimum time value in table";
    external "C" Tmin = 
                      ModelicaTables_CombiTimeTable_minimumTime(tableID);
      annotation(Library="ModelicaExternalC");
    end tableTimeTmin;

    function tableTimeTmax
      "Return maximum time value of 1-dim. table where first column is time (for details see: Modelica/C-Sources/ModelicaTables.h)"
      input Integer tableID;
      output Real Tmax "maximum time value in table";
    external "C" Tmax = 
                      ModelicaTables_CombiTimeTable_maximumTime(tableID);
      annotation(Library="ModelicaExternalC");
    end tableTimeTmax;

  equation
    if tableOnFile then
      assert(tableName<>"NoName", "tableOnFile = true and no table name given");
    end if;
    if not tableOnFile then
      assert(size(table,1) > 0 and size(table,2) > 0, "tableOnFile = false and parameter table is an empty matrix");
    end if;
    for i in 1:nout loop
      y[i] = p_offset[i] + tableTimeIpo(tableID, columns[i], time);
    end for;
    when initial() then
      tableID=tableTimeInit((if not tableOnFile then "NoName" else tableName),
                            (if not tableOnFile then "NoName" else fileName), table,
                            startTime, smoothness, extrapolation);
    end when;
  initial equation
      t_min=tableTimeTmin(tableID);
      t_max=tableTimeTmax(tableID);
    annotation (
      Documentation(info="<HTML>
<p>
This block generates an output signal y[:] by <b>linear interpolation</b> in
a table. The time points and function values are stored in a matrix
<b>table[i,j]</b>, where the first column table[:,1] contains the
time points and the other columns contain the data to be interpolated.
</p>

<p>
<img src=\"../Images/Blocks/Sources/CombiTimeTable.png\">
</p>

<p>
Via parameter <b>columns</b> it can be defined which columns of the
table are interpolated. If, e.g., columns={2,4}, it is assumed that
2 output signals are present and that the first output is computed
by interpolation of column 2 and the second output is computed
by interpolation of column 4 of the table matrix.
The table interpolation has the following properties:
</p>
<ul>
<li>The time points need to be <b>monotonically increasing</b>. </li>
<li><b>Discontinuities</b> are allowed, by providing the same
    time point twice in the table. </li>
<li>Values <b>outside</b> of the table range, are computed by
    extrapolation according to the setting of parameter
    <b>extrapolation</b>:
<pre>
  extrapolation = 0: hold the first or last value of the table,
                     if outside of the range.
                = 1: extrapolate through the last or first two
                     points of the table.
                = 2: periodically repeat the table data
                     (periodical function).
</pre></li>
<li>Via parameter <b>smoothness</b> it is defined how the data is interpolated:
<pre>
  smoothness = 0: linear interpolation
             = 1: smooth interpolation with Akima Splines such
                  that der(y) is continuous.
</pre></li>
<li>If the table has only <b>one row</b>, no interpolation is performed and
    the table values of this row are just returned.</li>
<li>Via parameters <b>startTime</b> and <b>offset</b> the curve defined
    by the table can be shifted both in time and in the ordinate value.
    The time instants stored in the table are therefore <b>relative</b>
    to <b>startTime</b>.
    If time &lt; startTime, no interpolation is performed and the offset
    is used as ordinate value for all outputs.
<li>The table is implemented in a numerically sound way by
    generating <b>time events</b> at interval boundaries,
    in order to not integrate over a discontinuous or not differentiable
    points.
<li>For special applications it is sometimes needed to know the minimum
    and maximum time instant defined in the table as a parameter. For this
    reason parameters <b>t_min</b> and <b>t_max</b> are provided and can be access from
    the outside of the table object.
</li>
</ul>
<p>
Example:
</p>
<pre>
   table = [0  0
            1  0
            1  1
            2  4
            3  9
            4 16]; extrapolation = 1 (default)
If, e.g., time = 1.0, the output y =  0.0 (before event), 1.0 (after event)
    e.g., time = 1.5, the output y =  2.5,
    e.g., time = 2.0, the output y =  4.0,
    e.g., time = 5.0, the output y = 23.0 (i.e. extrapolation via last 2 points).
</pre>
<p>
The table matrix can be defined in the following ways:
</p>
<ol>
<li> Explicitly supplied as <b>parameter matrix</b> \"table\",
     and the other parameters have the following values:
<pre>
   tableName is \"NoName\" or has only blanks,
   fileName  is \"NoName\" or has only blanks.
</pre></li>
<li> <b>Read</b> from a <b>file</b> \"fileName\" where the matrix is stored as
      \"tableName\". Both ASCII and binary file format is possible.
      (the ASCII format is described below).
      It is most convenient to generate the binary file from Matlab
      (Matlab 4 storage format), e.g., by command
<pre>
   save tables.mat tab1 tab2 tab3 -V4
</pre>
      when the three tables tab1, tab2, tab3 should be
      used from the model.</li>
<li>  Statically stored in function \"usertab\" in file \"usertab.c\".
      The matrix is identified by \"tableName\". Parameter
      fileName = \"NoName\" or has only blanks.</li>
</ol>
<p>
Table definition methods (1) and (3) do <b>not</b> allocate dynamic memory,
and do not access files, whereas method (2) does. Therefore (1) and (3)
are suited for hardware-in-the-loop simulation (e.g. with dSpace hardware).
When the constant \"NO_FILE\" is defined in \"usertab.c\", all parts of the
source code of method (2) are removed by the C-preprocessor, such that
no dynamic memory allocation and no access to files takes place.
</p>
<p>
If tables are read from an ASCII-file, the file need to have the
following structure (\"-----\" is not part of the file content):
</p>
<pre>
-----------------------------------------------------
#1
double tab1(6,2)   # comment line
  0   0
  1   0
  1   1
  2   4
  3   9
  4  16
double tab2(6,2)   # another comment line
  0   0
  2   0
  2   2
  4   8
  6  18
  8  32
-----------------------------------------------------
</pre>
<p>
Note, that the first two characters in the file need to be
\"#1\". Afterwards, the corresponding matrix has to be declared
with type, name and actual dimensions. Finally, in successive
rows of the file, the elements of the matrix have to be given.
Several matrices may be defined one after another.
</p>

</HTML>
", revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>March 31, 2001</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Used CombiTableTime as a basis and added the
       arguments <b>extrapolation, columns, startTime</b>.
       This allows periodic function definitions. </li>
</ul>
</html>"),
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-48,70},{2,-50}},
            lineColor={255,255,255},
            fillColor={255,255,0},
            fillPattern=FillPattern.Solid),
          Line(points={{-48,-50},{-48,70},{52,70},{52,-50},{-48,-50},{-48,-20},
                {52,-20},{52,10},{-48,10},{-48,40},{52,40},{52,70},{2,70},{2,-51}}, 
              color={0,0,0})}),
      Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
              100,100}}), graphics={
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-20,90},{20,-30}},
            lineColor={255,255,255},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-20,-30},{-20,90},{80,90},{80,-30},{-20,-30},{-20,0},{
                80,0},{80,30},{-20,30},{-20,60},{80,60},{80,90},{20,90},{20,-30}}, 
              color={0,0,0}),
          Text(
            extent={{-71,-42},{-32,-54}},
            lineColor={0,0,0},
            textString="offset"),
          Polygon(
            points={{-31,-30},{-33,-40},{-28,-40},{-31,-30}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-31,-70},{-34,-60},{-29,-60},{-31,-70},{-31,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-31,-31},{-31,-70}}, color={95,95,95}),
          Line(points={{-20,-30},{-20,-70}}, color={95,95,95}),
          Text(
            extent={{-42,-74},{6,-84}},
            lineColor={0,0,0},
            textString="startTime"),
          Line(points={{-20,-30},{-80,-30}}, color={95,95,95}),
          Text(
            extent={{-73,93},{-44,74}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{66,-81},{92,-92}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-19,83},{20,68}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{21,82},{50,68}},
            lineColor={0,0,0},
            textString="y[1]"),
          Line(points={{50,90},{50,-30}}, color={0,0,0}),
          Line(points={{80,0},{100,0}}, color={0,0,255}),
          Text(
            extent={{34,-30},{71,-42}},
            textString="columns",
            lineColor={0,0,255}),
          Text(
            extent={{51,82},{80,68}},
            lineColor={0,0,0},
            textString="y[2]")}));
  end CombiTimeTable;

    block BooleanConstant "Generate constant signal of type Boolean"
      parameter Boolean k=true "Constant output value";
      extends Interfaces.partialBooleanSource;

    equation
      y = k;
      annotation (
        Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={Line(points={{-80,0},{80,0}}, color={0,0,0}),
            Text(
            extent={{-150,-140},{150,-110}},
            lineColor={0,0,0},
            textString="%k")}),
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Line(
            points={{-70,0},{80,0}},
            color={0,0,255},
            thickness=0.5),
          Text(
            extent={{-69,20},{-49,0}},
            lineColor={0,0,0},
            textString="k"),
          Text(
            extent={{-96,6},{-76,-4}},
            lineColor={0,0,0},
            textString="true"),
          Text(
            extent={{-98,-58},{-72,-68}},
            lineColor={0,0,0},
            textString="false")}),
        Documentation(info="<html>
<p>
The Boolean output y is a constant signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/BooleanConstant.png\">
</p>
</html>"));
    end BooleanConstant;

    block BooleanStep "Generate step signal of type Boolean"
      parameter Modelica.SIunits.Time startTime=0 "Time instant of step start";
      parameter Boolean startValue = false "Output before startTime";

      extends Interfaces.partialBooleanSource;
    equation
     y = if time >= startTime then not startValue else startValue;
      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={Line(points={{-80,-70},{0,-70},{0,50},
                {80,50}}, color={0,0,0}), Text(
            extent={{-150,-140},{150,-110}},
            lineColor={0,0,0},
            textString="%startTime")}),
                              Diagram(coordinateSystem(preserveAspectRatio=false,
                     extent={{-100,-100},{100,100}}), graphics={
          Line(
            points={{-80,-70},{0,-70},{0,50},{80,50}},
            color={0,0,255},
            thickness=0.5),
          Text(
            extent={{-15,-74},{20,-82}},
            lineColor={0,0,0},
            textString="startTime"),
          Polygon(
            points={{2,50},{-80,50},{2,50}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-66,62},{-22,48}},
            lineColor={0,0,0},
            textString="not startValue"),
          Text(
            extent={{-68,-58},{-36,-72}},
            lineColor={0,0,0},
            textString="startValue")}),
        Documentation(info="<html>
<p>
The Boolean output y is a step signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/BooleanStep.png\">
</p>
</html>"));
    end BooleanStep;

    block BooleanPulse "Generate pulse signal of type Boolean"

      parameter Real width(
        final min=Modelica.Constants.small,
        final max=100) = 50 "Width of pulse in % of period";
      parameter Modelica.SIunits.Time period(final min=Modelica.Constants.small,start=1)
      "Time for one period";
      parameter Modelica.SIunits.Time startTime=0 "Time instant of first pulse";
      extends Modelica.Blocks.Interfaces.partialBooleanSource;

  protected
      parameter Modelica.SIunits.Time Twidth=period*width/100
      "width of one pulse"                                              annotation(HideResult=true);
      discrete Modelica.SIunits.Time pulsStart "Start time of pulse" 
                                                 annotation(HideResult=true);
    initial equation
      pulsStart = startTime;
    equation
        when sample(startTime, period) then
          pulsStart = time;
        end when;
        y = time >= pulsStart and time < pulsStart + Twidth;
      annotation (
        Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={Text(
            extent={{-150,-140},{150,-110}},
            lineColor={0,0,0},
            textString="%period"), Line(points={{-80,-70},{-40,-70},{-40,44},{0,
                44},{0,-70},{40,-70},{40,44},{79,44}}, color={0,0,0})}),
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-60,-74},{-19,-82}},
            lineColor={0,0,0},
            textString="startTime"),
          Line(
            points={{-78,-70},{-40,-70},{-40,20},{20,20},{20,-70},{50,-70},{50,
                20},{100,20}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-40,61},{-40,21}}, color={95,95,95}),
          Line(points={{20,44},{20,20}}, color={95,95,95}),
          Line(points={{50,58},{50,20}}, color={95,95,95}),
          Line(points={{-40,53},{50,53}}, color={95,95,95}),
          Line(points={{-40,35},{20,35}}, color={95,95,95}),
          Text(
            extent={{-30,65},{16,55}},
            lineColor={0,0,0},
            textString="period"),
          Text(
            extent={{-33,47},{14,37}},
            lineColor={0,0,0},
            textString="width"),
          Line(points={{-70,20},{-41,20}}, color={95,95,95}),
          Polygon(
            points={{-40,35},{-31,37},{-31,33},{-40,35}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{20,35},{12,37},{12,33},{20,35}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-40,53},{-31,55},{-31,51},{-40,53}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{50,53},{42,55},{42,51},{50,53}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-95,26},{-66,17}},
            lineColor={0,0,0},
            textString="true"),
          Text(
            extent={{-96,-60},{-75,-69}},
            lineColor={0,0,0},
            textString="false")}),
        Documentation(info="<html>
<p>
The Boolean output y is a pulse signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Pulse.png\">
</p>
</html>"));
    end BooleanPulse;

    block SampleTrigger "Generate sample trigger signal"
      parameter Modelica.SIunits.Time period(final min=Modelica.Constants.small,start=0.01)
      "Sample period";
      parameter Modelica.SIunits.Time startTime=0
      "Time instant of first sample trigger";
      extends Interfaces.partialBooleanSource;

    equation
      y = sample(startTime, period);
      annotation (
        Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-60,-70},{-60,70}}, color={0,0,0}),
          Line(points={{-20,-70},{-20,70}}, color={0,0,0}),
          Line(points={{20,-70},{20,70}}, color={0,0,0}),
          Line(points={{60,-70},{60,70}}, color={0,0,0}),
          Text(
            extent={{-150,-140},{150,-110}},
            lineColor={0,0,0},
            textString="%period")}),
        Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-51,-72},{-11,-81}},
            lineColor={0,0,0},
            textString="startTime"),
          Line(points={{-30,47},{-30,19}}, color={95,95,95}),
          Line(points={{0,47},{0,18}}, color={95,95,95}),
          Line(points={{-30,41},{0,41}}, color={95,95,95}),
          Text(
            extent={{-37,61},{9,49}},
            lineColor={0,0,0},
            textString="period"),
          Line(points={{-73,19},{-30,19}}, color={95,95,95}),
          Polygon(
            points={{-30,41},{-21,43},{-21,39},{-30,41}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{0,41},{-8,43},{-8,39},{0,41}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-91,23},{-71,13}},
            lineColor={0,0,0},
            textString="true"),
          Text(
            extent={{-90,-59},{-70,-68}},
            lineColor={0,0,0},
            textString="false"),
          Line(
            points={{0,-70},{0,19}},
            color={0,0,255},
            thickness=0.5),
          Line(
            points={{-30,-70},{-30,19}},
            color={0,0,255},
            thickness=0.5),
          Line(
            points={{30,-70},{30,19}},
            color={0,0,255},
            thickness=0.5),
          Line(
            points={{60,-70},{60,19}},
            color={0,0,255},
            thickness=0.5)}),
        Documentation(info="<html>
<p>
The Boolean output y is a trigger signal where the output y is only <b>true</b>
at sample times (defined by parameter <b>period</b>) and is otherwise
<b>false</b>.
</p>

<p>
<img src=\"../Images/Blocks/Sources/SampleTrigger.png\">
</p>
</html>"));
    end SampleTrigger;

    block BooleanTable
    "Generate a Boolean output signal based on a vector of time instants"

      parameter Boolean startValue = false
      "Start value of y. At time = table[1], y changes to 'not startValue'";
      parameter Modelica.SIunits.Time table[:]
      "Vector of time points. At every time point, the output y gets its opposite value (e.g. table={0,1})";
      extends Interfaces.partialBooleanSource;

  protected
      function getFirstIndex "Get first index of table and check table"
        input Real table[:] "Vector of time instants";
        input Modelica.SIunits.Time simulationStartTime "Simulation start time";
        input Boolean startValue "Value of y for y < table[1]";
        output Integer index "First index to be used";
        output Modelica.SIunits.Time nextTime "Time instant of first event";
        output Boolean y "Value of y at simulationStartTime";
    protected
        Modelica.SIunits.Time t_last;
        Integer j;
        Integer n=size(table,1) "Number of table points";
      algorithm
        if size(table,1) == 0 then
           index :=0;
           nextTime :=-Modelica.Constants.inf;
           y :=startValue;
        elseif size(table,1) == 1 then
           index :=1;
           if table[1] > simulationStartTime then
              nextTime :=table[1];
              y        :=startValue;
           else
              nextTime :=simulationStartTime;
              y        :=startValue;
           end if;
        else

        // Check whether time values are strict monotonically increasing
          t_last :=table[1];
          for i in 2:n loop
             assert(table[i] > t_last,
               "Time values of table not strict monotonically increasing: table[" +
               String(i-1) + "] = " + String(table[i-1]) + "table[" + String(i)   +
               "] = " + String(table[i]));
          end for;

          // Determine first index in table
          j := 1;
          y := startValue;
          while j < n and table[j] <= simulationStartTime loop
            y :=not  y;
            j := j + 1;
          end while;

          if j == 1 then
             nextTime := table[1];
             y        := startValue;
          elseif j == n and table[n] <= simulationStartTime then
             nextTime := simulationStartTime - 1;
             y        :=not  y;
          else
             nextTime := table[j];
          end if;

          index := j;
        end if;
      end getFirstIndex;

      parameter Integer n = size(table,1) "Number of table points";
      Modelica.SIunits.Time nextTime;
      Integer index "Index of actual table entry";
    initial algorithm
      (index, nextTime, y) :=getFirstIndex(table, time, startValue);
    algorithm
      when time >= pre(nextTime) and n > 0 then
         if index < n then
            index    := index + 1;
            nextTime := table[index];
            y        :=not  y;
         elseif index == n then
            index := index + 1;
            y     :=not  y;
         end if;
      end when;
      annotation (
        Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
              100,100}}), graphics={Rectangle(
            extent={{-18,70},{32,-50}},
            lineColor={255,255,255},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid), Line(points={{-18,-50},{-18,70},{32,
                70},{32,-50},{-18,-50},{-18,-20},{32,-20},{32,10},{-18,10},{-18,
                40},{32,40},{32,70},{32,70},{32,-51}}, color={0,0,0})}),
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
              {100,100}}), graphics={
          Rectangle(
            extent={{-34,66},{16,-54}},
            lineColor={255,255,255},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-34,-54},{-34,66},{16,66},{16,-54},{-34,-54},{-34,-24},
                {16,-24},{16,6},{-34,6},{-34,36},{16,36},{16,66},{16,66},{16,-55}}, 
              color={0,0,0}),
          Text(
            extent={{-29,59},{10,44}},
            lineColor={0,0,0},
            textString="time")}),
        Documentation(info="<html>
<p>
The Boolean output y is a signal defined by parameter vector <b>table</b>.
In the vector time points are stored. At every time point, the output y
changes its value to the negated value of the previous one.
</p>

<p>
<img src=\"../Images/Blocks/Sources/BooleanTable.png\">
</p>
</html>"));
    end BooleanTable;

  block IntegerConstant "Generate constant signal of type Integer"
    parameter Integer k(start=1) "Constant output value";
    extends Interfaces.IntegerSO;

  equation
    y = k;
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,0},{80,0}}, color={0,0,0}),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="k=%k")}),
                            Diagram(coordinateSystem(preserveAspectRatio=true,
            extent={{-100,-100},{100,100}}), graphics={
          Polygon(
            points={{-80,90},{-86,68},{-74,68},{-80,90}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(
            points={{-80,0},{80,0}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-81,92},{-38,74}},
            lineColor={0,0,0},
            textString="y"),
          Text(
            extent={{66,-82},{94,-94}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-101,8},{-81,-12}},
            lineColor={0,0,0},
            textString="k")}),
      Documentation(info="<html>
<p>
The Integer output y is a constant signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/IntegerConstant.png\">
</p>
</html>"));
  end IntegerConstant;

  block IntegerStep "Generate step signal of type Integer"
    parameter Integer height=1 "Height of step";
    extends Interfaces.IntegerSignalSource;
  equation
    y = offset + (if time < startTime then 0 else height);
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
          Polygon(
            points={{-80,90},{-88,68},{-72,68},{-80,90}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
          Polygon(
            points={{90,-70},{68,-62},{68,-78},{90,-70}},
            lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,-70},{0,-70},{0,50},{80,50}}, color={0,0,0}),
          Text(
            extent={{-150,-150},{150,-110}},
            lineColor={0,0,0},
            textString="startTime=%startTime")}),
                            Diagram(coordinateSystem(preserveAspectRatio=true,
            extent={{-100,-100},{100,100}}), graphics={
          Polygon(
            points={{-80,88},{-86,68},{-74,68},{-80,88}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
          Line(
            points={{-80,-18},{0,-18},{0,50},{80,50}},
            color={0,0,255},
            thickness=0.5),
          Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
          Polygon(
            points={{90,-70},{70,-66},{70,-74},{90,-70}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{66,-78},{92,-88}},
            lineColor={0,0,0},
            textString="time"),
          Text(
            extent={{-21,-76},{26,-88}},
            lineColor={0,0,0},
            textString="startTime"),
          Line(points={{0,-17},{0,-71}}, color={95,95,95}),
          Text(
            extent={{-60,-36},{-12,-48}},
            lineColor={0,0,0},
            textString="offset"),
          Line(points={{-13,50},{-13,-17}}, color={95,95,95}),
          Polygon(
            points={{2,50},{-19,50},{2,50}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-13,-17},{-16,-4},{-10,-4},{-13,-17},{-13,-17}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-13,50},{-16,37},{-9,37},{-13,50}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-58,22},{-12,10}},
            lineColor={0,0,0},
            textString="height"),
          Polygon(
            points={{-13,-69},{-16,-56},{-10,-56},{-13,-69},{-13,-69}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Line(points={{-13,-18},{-13,-70}}, color={95,95,95}),
          Polygon(
            points={{-13,-18},{-16,-31},{-9,-31},{-13,-18}},
            lineColor={95,95,95},
            fillColor={95,95,95},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-78,96},{-44,80}},
            lineColor={0,0,0},
            textString="y")}),
      Documentation(info="<html>
<p>
The Integer output y is a step signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/IntegerStep.png\">
</p>
</html>"));
  end IntegerStep;

      annotation (
        Documentation(info="<HTML>
<p>
This package contains <b>source</b> components, i.e., blocks which
have only output signals. These blocks are used as signal generators
for Real, Integer and Boolean signals.
</p>

<p>
All Real source signals (with the exception of the Constant source)
have at least the following two parameters:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>offset</b></td>
      <td valign=\"top\">Value which is added to the signal</td>
  </tr>
  <tr><td valign=\"top\"><b>startTime</b></td>
      <td valign=\"top\">Start time of signal. For time &lt; startTime,
                the output y is set to offset.</td>
  </tr>
</table>

<p>
The <b>offset</b> parameter is especially useful in order to shift
the corresponding source, such that at initial time the system
is stationary. To determine the corresponding value of offset,
usually requires a trimming calculation.
</p>
</HTML>
", revisions="<html>
<ul>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       Integer sources added. Step, TimeTable and BooleanStep slightly changed.</li>
<li><i>Nov. 8, 1999</i>
       by <a href=\"mailto:clauss@eas.iis.fhg.de\">Christoph Clau&szlig;</a>,
       <a href=\"mailto:Andre.Schneider@eas.iis.fraunhofer.de\">Andre.Schneider@eas.iis.fraunhofer.de</a>,
       <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       New sources: Exponentials, TimeTable. Trapezoid slightly enhanced
       (nperiod=-1 is an infinite number of periods).</li>
<li><i>Oct. 31, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       <a href=\"mailto:clauss@eas.iis.fhg.de\">Christoph Clau&szlig;</a>,
       <a href=\"mailto:Andre.Schneider@eas.iis.fraunhofer.de\">Andre.Schneider@eas.iis.fraunhofer.de</a>,
       All sources vectorized. New sources: ExpSine, Trapezoid,
       BooleanConstant, BooleanStep, BooleanPulse, SampleTrigger.
       Improved documentation, especially detailed description of
       signals in diagram layer.</li>
<li><i>June 29, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized a first version, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.</li>
</ul>
</html>"));
end Sources;

package Types
  "Library of constants and types with choices, especially to build menus"
  extends Modelica.Icons.Library;
  type Smoothness = enumeration(
      LinearSegments "Table points are linearly interpolated",
      ContinuousDerivative
        "Table points are interpolated such that the first derivative is continuous")
    "Enumeration defining the smoothness of table interpolation" 
    annotation (Documentation(info="<html>

</html>"));
type Extrapolation = enumeration(
      HoldLastPoint "Hold the last table point outside of the table scope",
      LastTwoPoints
        "Extrapolate linearly through the last two table points outside of the table scope", 

      Periodic "Repeat the table scope periodically")
    "Enumeration defining the extrapolation of time table interpolation" 
        annotation ( Documentation(info="<html>

</html>"));

  type Init = enumeration(
      NoInit
        "No initialization (start values are used as guess values with fixed=false)", 

      SteadyState
        "Steady state initialization (derivatives of states are zero)",
      InitialState "Initialization with initial states",
      InitialOutput
        "Initialization with initial outputs (and steady state of the states if possibles)")
    "Enumeration defining initialization of a block" 
      annotation (Evaluate=true, Documentation(info="<html>

</html>"));

  type InitPID = enumeration(
      NoInit
        "No initialization (start values are used as guess values with fixed=false)", 

      SteadyState
        "Steady state initialization (derivatives of states are zero)",
      InitialState "Initialization with initial states",
      InitialOutput
        "Initialization with initial outputs (and steady state of the states if possibles)", 

      DoNotUse_InitialIntegratorState
        "Don't use, only for backward compatibility (initialize only integrator state)")
    "Enumeration defining initialization of PID and LimPID blocks" 
    annotation (Documentation(info="<html>
<p>
This initialization type is identical to Types.Init and has just one
additional option <b>DoNotUse_InitialIntegratorState</b>. This option
is introduced in order that the default initialization for the
Continuous.PID and Continuous.LimPID blocks are backward
compatible. In Modelica 2.2, the integrators have been initialized
with their given states where as the D-part has not been initialized.
The option \"DoNotUse_InitialIntegratorState\" leads to this
initialization definition.
</p>

</html>"),   Evaluate=true);

  type SimpleController = enumeration(
      P "P controller",
      PI "PI controller",
      PD "PD controller",
      PID "PID controller")
    "Enumeration defining P, PI, PD, or PID simple controller type" 
      annotation (Evaluate=true, Documentation(info="<html>

</html>"));

  annotation ( Documentation(info="<HTML>
<p>
In this package <b>types</b> and <b>constants</b> are defined that are used
in library Modelica.Blocks. The types have additional annotation choices
definitions that define the menus to be built up in the graphical
user interface when the type is used as parameter in a declaration.
</p>
</HTML>"));
end Types;

end Blocks;


package Mechanics

package MultiBody "Library to model 3-dimensional mechanical systems"

import SI = Modelica.SIunits;


extends Modelica.Icons.Library;

model World
  "World coordinate system + gravity field + default animation definition"

  import SI = Modelica.SIunits;
  import Modelica.Mechanics.MultiBody.Types.GravityTypes;
  import Modelica.Mechanics.MultiBody.Types;

    Interfaces.Frame_b frame_b
    "Coordinate system fixed in the origin of the world frame" 
                               annotation (Placement(transformation(extent={{84,
            -16},{116,16}}, rotation=0)));

  parameter Boolean enableAnimation=true
    "= true, if animation of all components is enabled";
  parameter Boolean animateWorld=true
    "= true, if world coordinate system shall be visualized" annotation(Dialog(enable=enableAnimation));
  parameter Boolean animateGravity=true
    "= true, if gravity field shall be visualized (acceleration vector or field center)"
                                                                                          annotation(Dialog(enable=enableAnimation));
  parameter Types.AxisLabel label1="x" "Label of horizontal axis in icon";
  parameter Types.AxisLabel label2="y" "Label of vertical axis in icon";
  parameter Types.GravityTypes gravityType=GravityTypes.UniformGravity
    "Type of gravity field"                                                                                                     annotation (Evaluate=true);
  parameter SI.Acceleration g=9.81 "Constant gravity acceleration" 
    annotation (Dialog(enable=gravityType == GravityTypes.UniformGravity));
  parameter Types.Axis n={0,-1,0}
    "Direction of gravity resolved in world frame (gravity = g*n/length(n))" 
    annotation (Evaluate=true, Dialog(enable=gravityType == Modelica.Mechanics.
          MultiBody.Types.GravityTypes.UniformGravity));
  parameter Real mue(
    unit="m3/s2",
    min=0) = 3.986e14
    "Gravity field constant (default = field constant of earth)" 
    annotation (Dialog(enable=gravityType == Types.GravityTypes.PointGravity));
  parameter Boolean driveTrainMechanics3D=true
    "= true, if 3-dim. mechanical effects of Parts.Mounting1D/Rotor1D/BevelGear1D shall be taken into account";

  parameter SI.Distance axisLength=nominalLength/2
    "Length of world axes arrows" 
    annotation (Dialog(tab="Animation", group="if animateWorld = true", enable=enableAnimation and animateWorld));
  parameter SI.Distance axisDiameter=axisLength/defaultFrameDiameterFraction
    "Diameter of world axes arrows" 
    annotation (Dialog(tab="Animation", group="if animateWorld = true", enable=enableAnimation and animateWorld));
  parameter Boolean axisShowLabels=true "= true, if labels shall be shown" 
    annotation (Dialog(tab="Animation", group="if animateWorld = true", enable=enableAnimation and animateWorld));
  input Types.Color axisColor_x=Modelica.Mechanics.MultiBody.Types.Defaults.FrameColor
    "Color of x-arrow" 
    annotation (Dialog(tab="Animation", group="if animateWorld = true", enable=enableAnimation and animateWorld));
  input Types.Color axisColor_y=axisColor_x 
    annotation (Dialog(tab="Animation", group="if animateWorld = true", enable=enableAnimation and animateWorld));
  input Types.Color axisColor_z=axisColor_x "Color of z-arrow" 
    annotation (Dialog(tab="Animation", group="if animateWorld = true", enable=enableAnimation and animateWorld));

  parameter SI.Position gravityArrowTail[3]={0,0,0}
    "Position vector from origin of world frame to arrow tail, resolved in world frame"
    annotation (Dialog(tab="Animation", group=
          "if animateGravity = true and gravityType = UniformGravity",
          enable=enableAnimation and animateGravity and gravityType == GravityTypes.UniformGravity));
  parameter SI.Length gravityArrowLength=axisLength/2 "Length of gravity arrow"
    annotation (Dialog(tab="Animation", group=
          "if animateGravity = true and gravityType = UniformGravity",
          enable=enableAnimation and animateGravity and gravityType == GravityTypes.UniformGravity));
  parameter SI.Diameter gravityArrowDiameter=gravityArrowLength/
      defaultWidthFraction "Diameter of gravity arrow" annotation (Dialog(tab=
          "Animation", group=
          "if animateGravity = true and gravityType = UniformGravity",
          enable=enableAnimation and animateGravity and gravityType == GravityTypes.UniformGravity));
  input Types.Color gravityArrowColor={0,230,0} "Color of gravity arrow" 
    annotation (Dialog(tab="Animation", group=
          "if animateGravity = true and gravityType = UniformGravity",
          enable=enableAnimation and animateGravity and gravityType == GravityTypes.UniformGravity));
  parameter SI.Diameter gravitySphereDiameter=12742000
    "Diameter of sphere representing gravity center (default = mean diameter of earth)"
    annotation (Dialog(tab="Animation", group=
          "if animateGravity = true and gravityType = PointGravity",
          enable=enableAnimation and animateGravity and gravityType == GravityTypes.PointGravity));
  input Types.Color gravitySphereColor={0,230,0} "Color of gravity sphere" 
    annotation (Dialog(tab="Animation", group=
          "if animateGravity = true and gravityType = PointGravity",
          enable=enableAnimation and animateGravity and gravityType == GravityTypes.PointGravity));

  parameter SI.Length nominalLength=1 "\"Nominal\" length of multi-body system"
    annotation (Dialog(tab="Defaults"));
  parameter SI.Length defaultAxisLength=nominalLength/5
    "Default for length of a frame axis (but not world frame)" 
    annotation (Dialog(tab="Defaults"));
  parameter SI.Length defaultJointLength=nominalLength/10
    "Default for the fixed length of a shape representing a joint" 
    annotation (Dialog(tab="Defaults"));
  parameter SI.Length defaultJointWidth=nominalLength/20
    "Default for the fixed width of a shape representing a joint" 
    annotation (Dialog(tab="Defaults"));
  parameter SI.Length defaultForceLength=nominalLength/10
    "Default for the fixed length of a shape representing a force (e.g. damper)"
    annotation (Dialog(tab="Defaults"));
  parameter SI.Length defaultForceWidth=nominalLength/20
    "Default for the fixed width of a shape represening a force (e.g. spring, bushing)"
    annotation (Dialog(tab="Defaults"));
  parameter SI.Length defaultBodyDiameter=nominalLength/9
    "Default for diameter of sphere representing the center of mass of a body" 
    annotation (Dialog(tab="Defaults"));
  parameter Real defaultWidthFraction=20
    "Default for shape width as a fraction of shape length (e.g., for Parts.FixedTranslation)"
    annotation (Dialog(tab="Defaults"));
  parameter SI.Length defaultArrowDiameter=nominalLength/40
    "Default for arrow diameter (e.g., of forces, torques, sensors)" 
    annotation (Dialog(tab="Defaults"));
  parameter Real defaultFrameDiameterFraction=40
    "Default for arrow diameter of a coordinate system as a fraction of axis length"
    annotation (Dialog(tab="Defaults"));
  parameter Real defaultSpecularCoefficient(min=0) = 0.7
    "Default reflection of ambient light (= 0: light is completely absorbed)" 
    annotation (Dialog(tab="Defaults"));
  parameter Real defaultN_to_m(unit="N/m", min=0) = 1000
    "Default scaling of force arrows (length = force/defaultN_to_m)" 
    annotation (Dialog(tab="Defaults"));
  parameter Real defaultNm_to_m(unit="N.m/m", min=0) = 1000
    "Default scaling of torque arrows (length = torque/defaultNm_to_m)" 
    annotation (Dialog(tab="Defaults"));

  /* The World object can only use the Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape model, but no
     other models in package Modelica.Mechanics.MultiBody.Visualizers, since the other models access
     data of the "outer Modelica.Mechanics.MultiBody.World world" object, i.e., there are
     mutually dependent classes. For this reason, the higher level visualization
     objects cannot be used.
  */
protected
  parameter Integer ndim=if enableAnimation and animateWorld then 1 else 0;
  parameter Integer ndim2=if enableAnimation and animateWorld and 
      axisShowLabels then 1 else 0;

  // Parameters to define axes
  parameter SI.Length headLength=min(axisLength, axisDiameter*Types.Defaults.
      FrameHeadLengthFraction);
  parameter SI.Length headWidth=axisDiameter*Types.Defaults.
      FrameHeadWidthFraction;
  parameter SI.Length lineLength=max(0, axisLength - headLength);
  parameter SI.Length lineWidth=axisDiameter;

  // Parameters to define axes labels
  parameter SI.Length scaledLabel=Modelica.Mechanics.MultiBody.Types.Defaults.FrameLabelHeightFraction*
      axisDiameter;
  parameter SI.Length labelStart=1.05*axisLength;

  // x-axis
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape x_arrowLine(
    shapeType="cylinder",
    length=lineLength,
    width=lineWidth,
    height=lineWidth,
    lengthDirection={1,0,0},
    widthDirection={0,1,0},
    color=axisColor_x,
    specularCoefficient=0) if enableAnimation and animateWorld;
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape x_arrowHead(
    shapeType="cone",
    length=headLength,
    width=headWidth,
    height=headWidth,
    lengthDirection={1,0,0},
    widthDirection={0,1,0},
    color=axisColor_x,
    r={lineLength,0,0},
    specularCoefficient=0) if enableAnimation and animateWorld;
  Modelica.Mechanics.MultiBody.Visualizers.Internal.Lines x_label(
    lines=scaledLabel*{[0, 0; 1, 1],[0, 1; 1, 0]},
    diameter=axisDiameter,
    color=axisColor_x,
    r_lines={labelStart,0,0},
    n_x={1,0,0},
    n_y={0,1,0},
    specularCoefficient=0) if enableAnimation and animateWorld and axisShowLabels;

  // y-axis
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape y_arrowLine(
    shapeType="cylinder",
    length=lineLength,
    width=lineWidth,
    height=lineWidth,
    lengthDirection={0,1,0},
    widthDirection={1,0,0},
    color=axisColor_y,
    specularCoefficient=0) if enableAnimation and animateWorld;
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape y_arrowHead(
    shapeType="cone",
    length=headLength,
    width=headWidth,
    height=headWidth,
    lengthDirection={0,1,0},
    widthDirection={1,0,0},
    color=axisColor_y,
    r={0,lineLength,0},
    specularCoefficient=0) if enableAnimation and animateWorld;
  Modelica.Mechanics.MultiBody.Visualizers.Internal.Lines y_label(
    lines=scaledLabel*{[0, 0; 1, 1.5],[0, 1.5; 0.5, 0.75]},
    diameter=axisDiameter,
    color=axisColor_y,
    r_lines={0,labelStart,0},
    n_x={0,1,0},
    n_y={-1,0,0},
    specularCoefficient=0) if enableAnimation and animateWorld and axisShowLabels;

  // z-axis
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape z_arrowLine(
    shapeType="cylinder",
    length=lineLength,
    width=lineWidth,
    height=lineWidth,
    lengthDirection={0,0,1},
    widthDirection={0,1,0},
    color=axisColor_z,
    specularCoefficient=0) if enableAnimation and animateWorld;
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape z_arrowHead(
    shapeType="cone",
    length=headLength,
    width=headWidth,
    height=headWidth,
    lengthDirection={0,0,1},
    widthDirection={0,1,0},
    color=axisColor_z,
    r={0,0,lineLength},
    specularCoefficient=0) if enableAnimation and animateWorld;
  Modelica.Mechanics.MultiBody.Visualizers.Internal.Lines z_label(
    lines=scaledLabel*{[0, 0; 1, 0],[0, 1; 1, 1],[0, 1; 1, 0]},
    diameter=axisDiameter,
    color=axisColor_z,
    r_lines={0,0,labelStart},
    n_x={0,0,1},
    n_y={0,1,0},
    specularCoefficient=0) if enableAnimation and animateWorld and axisShowLabels;

  // Uniform gravity visualization
  parameter SI.Length gravityHeadLength=min(gravityArrowLength,
      gravityArrowDiameter*Types.Defaults.ArrowHeadLengthFraction);
  parameter SI.Length gravityHeadWidth=gravityArrowDiameter*Types.Defaults.ArrowHeadWidthFraction;
  parameter SI.Length gravityLineLength=max(0, gravityArrowLength - gravityHeadLength);
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape gravityArrowLine(
    shapeType="cylinder",
    length=gravityLineLength,
    width=gravityArrowDiameter,
    height=gravityArrowDiameter,
    lengthDirection=n,
    widthDirection={0,1,0},
    color=gravityArrowColor,
    r_shape=gravityArrowTail,
    specularCoefficient=0) if enableAnimation and animateGravity and gravityType == GravityTypes.UniformGravity;
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape gravityArrowHead(
    shapeType="cone",
    length=gravityHeadLength,
    width=gravityHeadWidth,
    height=gravityHeadWidth,
    lengthDirection=n,
    widthDirection={0,1,0},
    color=gravityArrowColor,
    r_shape=gravityArrowTail + Modelica.Math.Vectors.normalize(
                                                n)*gravityLineLength,
    specularCoefficient=0) if enableAnimation and animateGravity and gravityType == GravityTypes.UniformGravity;

  // Point gravity visualization
  parameter Integer ndim_pointGravity=if enableAnimation and animateGravity
       and gravityType == 2 then 1 else 0;
  Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape gravitySphere(
    shapeType="sphere",
    r_shape={-gravitySphereDiameter/2,0,0},
    lengthDirection={1,0,0},
    length=gravitySphereDiameter,
    width=gravitySphereDiameter,
    height=gravitySphereDiameter,
    color=gravitySphereColor,
    specularCoefficient=0) if enableAnimation and animateGravity and gravityType == GravityTypes.PointGravity;

  function gravityAcceleration = gravityAccelerationTypes (
      gravityType=gravityType,
      g=g*Modelica.Math.Vectors.normalize(
                                     n),
      mue=mue);

protected
  function gravityAccelerationTypes
    "Gravity field acceleration depending on field type and position"
    import Modelica.Mechanics.MultiBody.Types.GravityTypes;
    extends Modelica.Icons.Function;
    input SI.Position r[3]
      "Position vector from world frame to actual point, resolved in world frame";
    input GravityTypes gravityType "Type of gravity field";
    input SI.Acceleration g[3]
      "Constant gravity acceleration, resolved in world frame, if gravityType=1";
    input Real mue(unit="m3/s2")
      "Field constant of point gravity field, if gravityType=2";
    output SI.Acceleration gravity[3]
      "Gravity acceleration at point r, resolved in world frame";
  algorithm
    gravity := if gravityType == GravityTypes.UniformGravity then g else 
               if gravityType == GravityTypes.PointGravity then 
                  -(mue/(r*r))*(r/Modelica.Math.Vectors.length(
                                                r)) else 
                    zeros(3);
  end gravityAccelerationTypes;
equation
  Connections.root(frame_b.R);

  assert(Modelica.Math.Vectors.length(
                       n) > 1.e-10,
    "Parameter n of World object is wrong (lenght(n) > 0 required)");
  frame_b.r_0 = zeros(3);
  frame_b.R = Frames.nullRotation();
  annotation (
    defaultComponentName="world",
    defaultComponentPrefixes="inner",
    missingInnerMessage="No \"world\" component is defined. A default world
component with the default gravity field will be used
(g=9.81 in negative y-axis). If this is not desired,
drag Modelica.Mechanics.MultiBody.World into the top level of your model.",
    Icon(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Rectangle(
          extent={{-100,100},{100,-100}},
          lineColor={0,0,0},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid),
        Line(
          points={{-100,-118},{-100,61}},
          color={0,0,0},
          thickness=0.5),
        Polygon(
          points={{-100,100},{-120,60},{-80,60},{-100,100},{-100,100}},
          lineColor={0,0,0},
          fillColor={0,0,0},
          fillPattern=FillPattern.Solid),
        Line(
          points={{-119,-100},{59,-100}},
          color={0,0,0},
          thickness=0.5),
        Polygon(
          points={{99,-100},{59,-80},{59,-120},{99,-100}},
          lineColor={0,0,0},
          fillColor={0,0,0},
          fillPattern=FillPattern.Solid),
        Text(
          extent={{-140,165},{140,103}},
          textString="%name",
          lineColor={0,0,255}),
        Text(
          extent={{95,-113},{144,-162}},
          lineColor={0,0,0},
          textString="%label1"),
        Text(
          extent={{-170,127},{-119,77}},
          lineColor={0,0,0},
          textString="%label2"),
        Line(points={{-56,78},{-56,-26}}, color={0,0,255}),
        Polygon(
          points={{-68,-26},{-56,-66},{-44,-26},{-68,-26}},
          fillColor={0,0,255},
          fillPattern=FillPattern.Solid,
          lineColor={0,0,255}),
        Line(points={{2,78},{2,-26}}, color={0,0,255}),
        Polygon(
          points={{-10,-26},{2,-66},{14,-26},{-10,-26}},
          fillColor={0,0,255},
          fillPattern=FillPattern.Solid,
          lineColor={0,0,255}),
        Line(points={{66,80},{66,-26}}, color={0,0,255}),
        Polygon(
          points={{54,-26},{66,-66},{78,-26},{54,-26}},
          fillColor={0,0,255},
          fillPattern=FillPattern.Solid,
          lineColor={0,0,255})}),
    Diagram(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics),
    Documentation(info="<HTML>
<p>
Model <b>World</b> represents a global coordinate system fixed in
ground. This model serves several purposes:
<ul>
<li> It is used as <b>inertial system</b> in which
     the equations of all elements of the MultiBody library
     are defined.</li>
<li> It is the world frame of an <b>animation window</b> in which
     all elements of the MultiBody library are visualized.</li>
<li> It is used to define the <b>gravity field</b> in which a
     multi-body model is present. Default is a uniform gravity
     field where the gravity acceleration vector g is the
     same at every position. Additionally, a point gravity field
     can be selected.</li>
<li> It is used to define <b>default settings</b> of animation properties
     (e.g. the diameter of a sphere representing by default
     the center of mass of a body, or the diameters of the cylinders
     representing a revolute joint).</li>
<li> It is used to define a <b>visual representation</b> of the
     world model (= 3 coordinate axes with labels) and of the defined
     gravity field.<br>
    <IMG SRC=\"../Images/MultiBody/world.png\" ALT=\"MultiBodys.World\">
</li>
</ul>
<p>
Since the gravity field function is required from all bodies with mass
and the default settings of animation properties are required
from nearly every component, exactly one instance of model World needs
to be present in every model on the top level. The basic declaration
needs to be:
</p>
<pre>
    <b>inner</b> Modelica.Mechanics.MultiBody.World world
</pre>
<p>
Note, it must be an <b>inner</b> declaration with instance name <b>world</b>
in order that this world object can be accessed from all objects in the
model. When dragging the \"World\" object from the package browser into
the diagram layer, this declaration is automatically generated
(this is defined via annotations in model World).
</p>
<p>
All vectors and tensors of a mechanical system are resolved in a
frame that is local to the corresponding component. Usually,
if all relative joint coordinates vanish, the local frames
of all components are parallel to each other, as well as to the
world frame (this holds as long as a Parts.FixedRotation,
component is <b>not</b> used). In this \"reference configuration\"
it is therefore
alternatively possible to resolve all vectors in the world
frame, since all frames are parallel to each other.
This is often very convenient. In order to give some visual
support in such a situation, in the icon of a World instance
two axes of the world frame are shown and the labels
of these axes can be set via parameters.
</p>
</HTML>
"));
end World;

package Forces "Components that exert forces and/or torques between frames"
  import SI = Modelica.SIunits;
  extends Modelica.Icons.Library;

  model WorldForce
    "External force acting at frame_b, defined by 3 input signals and resolved in frame world, frame_b or frame_resolve"

    import SI = Modelica.SIunits;
    extends Interfaces.PartialOneFrame_b;
    Interfaces.Frame_resolve frame_resolve if 
         resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_resolve
      "The input signals are optionally resolved in this frame" 
      annotation (Placement(transformation(
          origin={0,-100},
          extent={{-16,-16},{16,16}},
          rotation=270)));
    Modelica.Blocks.Interfaces.RealInput force[3](each final quantity="Force", each
        final unit = "N")
      "x-, y-, z-coordinates of force resolved in frame defined by resolveInFrame"
      annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameB resolveInFrame
      =
      Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.world
      "Frame in which input force is resolved (1: world, 2: frame_b, 3: frame_resolve)";
    parameter Real N_to_m(unit="N/m") = world.defaultN_to_m
      "Force arrow scaling (length = force/N_to_m)" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter diameter=world.defaultArrowDiameter
      "Diameter of force arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.ForceColor
      "Color of arrow" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(group="if animation = true", enable=animation));

  protected
    SI.Position f_in_m[3]=frame_b.f/N_to_m
      "Force mapped from N to m for animation";
    Visualizers.Advanced.Arrow arrow(
      diameter=diameter,
      color=color,
      specularCoefficient=specularCoefficient,
      R=frame_b.R,
      r=frame_b.r_0,
      r_tail=f_in_m,
      r_head=-f_in_m) if world.enableAnimation and animation;

  public
    Internal.BasicWorldForce basicWorldForce(resolveInFrame=resolveInFrame) 
      annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
  protected
    Interfaces.ZeroPosition zeroPosition if 
         not (resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_resolve) 
      annotation (Placement(transformation(extent={{20,-40},{40,-20}})));
  equation
    connect(basicWorldForce.frame_b, frame_b) annotation (Line(
        points={{10,0},{100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicWorldForce.force, force) annotation (Line(
        points={{-12,0},{-120,0}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(basicWorldForce.frame_resolve, frame_resolve) annotation (Line(
        points={{0,-10},{0,-100}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(zeroPosition.frame_resolve, basicWorldForce.frame_resolve) 
      annotation (Line(
        points={{20,-30},{0,-30},{0,-10}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    annotation (defaultComponentName="force",
      Diagram(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{
              100,100}}), graphics),
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Text(
            extent={{-89,-46},{91,-76}},
            lineColor={192,192,192},
            textString="resolve"),
          Polygon(
            points={{-100,10},{50,10},{50,31},{94,0},{50,-31},{50,-10},{-100,-10},
                {-100,10}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-149,103},{136,42}},
            textString="%name",
            lineColor={0,0,255}),
          Line(
            points={{0,-10},{0,-95}},
            color={95,95,95},
            pattern=LinePattern.Dot)}),
      Documentation(info="<HTML>

<p>
The <b>3</b> signals of the <b>force</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>force</b> acting at the frame
connector to which frame_b of this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input force in world frame (= default)</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input force in frame_b</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input force in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = Types.ResolveInFrameB.frame_resolve, the force coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If force={100,0,0}, and for all parameters the default setting is used,
then the interpretation is that a force of 100 N is acting along the positive
x-axis of frame_b.
</p>

<p>
Note, the cut-torque in frame_b (frame_b.t) is always set to zero.
Conceptually, a force and torque acts on the world frame in such a way that
the force and torque balance between world.frame_b and frame_b is fulfilled.
For efficiency reasons, this reaction torque is, however, not computed.
</p>

<p>
This force component is by default visualized as an arrow
acting at the connector to which it is connected. The diameter
and color of the arrow can be defined via
variables <b>diameter</b> and <b>color</b>. The arrow
points in the direction defined by the
force signal. The length of the arrow is proportional
to the length of the force vector using parameter
<b>N_to_m</b> as scaling factor. For example, if N_to_m = 100 N/m,
then a force of 350 N is displayed as an arrow of length 3.5 m.
</p>
<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/WorldForce1.png\">
</p>
<p>
This leads to the following animation
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/WorldForce2.png\">
</p>

</HTML>
"));
  end WorldForce;

  model WorldTorque
    "External torque acting at frame_b, defined by 3 input signals and resolved in frame world, frame_b or frame_resolve"

    extends Interfaces.PartialOneFrame_b;

    Interfaces.Frame_resolve frame_resolve if 
         resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_resolve
      "The input signals are optionally resolved in this frame" 
      annotation (Placement(transformation(
          origin={0,100},
          extent={{16,-16},{-16,16}},
          rotation=270)));
    Modelica.Blocks.Interfaces.RealInput torque[3](each final quantity="Torque", each
        final unit = "N.m")
      "x-, y-, z-coordiantes of torque resolved in frame defined by resolveInFrame"
      annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
            rotation=0)));
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameB resolveInFrame
      =
      Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.world
      "Frame in which input torque is resolved (1: world, 2: frame_b, 3: frame_resolve)";
    parameter Real Nm_to_m(unit="N.m/m") = world.defaultNm_to_m
      "Torque arrow scaling (length = torque/Nm_to_m)" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter diameter=world.defaultArrowDiameter
      "Diameter of torque arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.TorqueColor
      "Color of arrow" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(group="if animation = true", enable=animation));

  protected
    SI.Position t_in_m[3]=frame_b.t/Nm_to_m
      "Torque mapped from Nm to m for animation";
    Visualizers.Advanced.DoubleArrow arrow(
      diameter=diameter,
      color=color,
      specularCoefficient=specularCoefficient,
      R=frame_b.R,
      r=frame_b.r_0,
      r_tail=t_in_m,
      r_head=-t_in_m) if world.enableAnimation and animation;
  public
    Internal.BasicWorldTorque basicWorldTorque(resolveInFrame=resolveInFrame) 
      annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
  protected
    Interfaces.ZeroPosition zeroPosition if 
         not (resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_resolve) 
      annotation (Placement(transformation(extent={{20,10},{40,30}})));
  equation
    connect(basicWorldTorque.frame_b, frame_b) annotation (Line(
        points={{10,0},{100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicWorldTorque.torque, torque) annotation (Line(
        points={{-12,0},{-120,0}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(frame_resolve, basicWorldTorque.frame_resolve) annotation (Line(
        points={{0,100},{0,10}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(zeroPosition.frame_resolve, basicWorldTorque.frame_resolve) 
      annotation (Line(
        points={{20,20},{0,20},{0,10}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    annotation (defaultComponentName="torque",
      Documentation(info="<HTML>

<p>
The <b>3</b> signals of the <b>torque</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>torque</b> acting at the frame
connector to which frame_b of this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input torque in world frame (= default)</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input torque in frame_b</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input torque in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = Types.ResolveInFrameB.frame_resolve, the torque coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If torque={100,0,0}, and for all parameters the default setting is used,
then the interpretation is that a torque of 100 N is acting along the positive
x-axis of frame_b.
</p>

<p>
Note, the cut-force in frame_b (frame_b.f) is always set to zero.
Conceptually, a force and torque acts on the world frame in such a way that
the force and torque balance between world.frame_b and frame_b is fulfilled.
For efficiency reasons, this reaction torque is, however, not computed.
</p>

<p>
This torque component is by default visualized as a <b>double arrow</b>
acting at the connector to which it is connected. The diameter
and color of the arrow can be defined via
variables <b>diameter</b> and <b>color</b>. The double arrow points
in the direction defined by the
torque vector. The length of the double arrow is proportional
to the length of the torque vector using parameter
<b>Nm_to_m</b> as scaling factor. For example, if Nm_to_m = 100 Nm/m,
then a torque of 350 Nm is displayed as an arrow of length 3.5 m.
</p>
<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/WorldTorque1.png\">
</p>
<p>
This leads to the following animation
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/WorldTorque2.png\">
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-61,64},{46,27}},
            lineColor={192,192,192},
            textString="resolve"),
          Text(
            extent={{-145,-28},{140,-89}},
            textString="%name",
            lineColor={0,0,255}),
          Line(
            points={{0,95},{0,82}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Line(
            points={{-100,0},{-94,13},{-86,28},{-74,48},{-65,60},{-52,72},{-35,
                81},{-22,84},{-8,84},{7,80},{19,73},{32,65},{44,55},{52,47},{58,
                40}},
            color={0,0,0},
            thickness=0.5),
          Polygon(
            points={{94,10},{75,59},{41,24},{94,10}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));
  end WorldTorque;

  model WorldForceAndTorque
    "External force and torque acting at frame_b, defined by 3+3 input signals and resolved in frame world, frame_b or in frame_resolve"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;
    extends Interfaces.PartialOneFrame_b;
    Interfaces.Frame_resolve frame_resolve if 
         resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_resolve
      "The input signals are optionally resolved in this frame" 
      annotation (Placement(transformation(
          origin={0,100},
          extent={{16,-16},{-16,16}},
          rotation=270)));
    Blocks.Interfaces.RealInput force[3](each final quantity="Force", each
        final unit = "N")
      "x-, y-, z-coordinates of force resolved in frame defined by resolveInFrame"
      annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
            rotation=0)));
    Blocks.Interfaces.RealInput torque[3](each final quantity="Torque", each
        final unit = "N.m")
      "x-, y-, z-coordiantes of torque resolved in frame defined by resolveInFrame"
      annotation (Placement(transformation(extent={{-140,40},{-100,80}},
            rotation=0)));

    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameB resolveInFrame
      =
      Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.world
      "Frame in which input force and torque are resolved (1: world, 2: frame_b, 3: frame_resolve)";

    parameter Real N_to_m(unit="N/m") = world.defaultN_to_m
      " Force arrow scaling (length = force/N_to_m)" 
      annotation (Dialog(group="if animation = true", enable=animation));
    parameter Real Nm_to_m(unit="N.m/m") = world.defaultNm_to_m
      " Torque arrow scaling (length = torque/Nm_to_m)" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter forceDiameter=world.defaultArrowDiameter
      " Diameter of force arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter torqueDiameter=forceDiameter " Diameter of torque arrow" 
                                  annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color forceColor=Modelica.Mechanics.MultiBody.Types.Defaults.ForceColor
      " Color of force arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color torqueColor=Modelica.Mechanics.MultiBody.Types.Defaults.TorqueColor
      " Color of torque arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(group="if animation = true", enable=animation));

  protected
    SI.Position f_in_m[3]=frame_b.f/N_to_m
      "Force mapped from N to m for animation";
    SI.Position t_in_m[3]=frame_b.t/Nm_to_m
      "Torque mapped from Nm to m for animation";
    Visualizers.Advanced.Arrow forceArrow(
      diameter=forceDiameter,
      color=forceColor,
      specularCoefficient=specularCoefficient,
      R=frame_b.R,
      r=frame_b.r_0,
      r_tail=f_in_m,
      r_head=-f_in_m) if world.enableAnimation and animation;
    Visualizers.Advanced.DoubleArrow torqueArrow(
      diameter=torqueDiameter,
      color=torqueColor,
      specularCoefficient=specularCoefficient,
      R=frame_b.R,
      r=frame_b.r_0,
      r_tail=t_in_m,
      r_head=-t_in_m) if world.enableAnimation and animation;
  public
    Internal.BasicWorldForce basicWorldForce(resolveInFrame=resolveInFrame) 
      annotation (Placement(transformation(extent={{18,-50},{38,-70}})));
    Internal.BasicWorldTorque basicWorldTorque(resolveInFrame=resolveInFrame) 
      annotation (Placement(transformation(extent={{-10,50},{10,70}})));
  protected
    Interfaces.ZeroPosition zeroPosition if 
         not (resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_resolve) 
      annotation (Placement(transformation(extent={{58,70},{78,90}})));
  equation
    connect(basicWorldForce.frame_b, frame_b) annotation (Line(
        points={{38,-60},{60,-60},{60,0},{100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicWorldForce.force, force) annotation (Line(
        points={{16,-60},{-120,-60}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(basicWorldTorque.frame_b, frame_b) 
                                      annotation (Line(
        points={{10,60},{60,60},{60,0},{100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicWorldTorque.torque, torque) 
                                    annotation (Line(
        points={{-12,60},{-120,60}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(basicWorldForce.frame_resolve, frame_resolve) annotation (Line(
        points={{28,-50},{28,80},{0,80},{0,100}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(basicWorldTorque.frame_resolve, frame_resolve) 
                                                  annotation (Line(
        points={{0,70},{0,100}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(zeroPosition.frame_resolve, basicWorldTorque.frame_resolve) 
                                                               annotation (Line(
        points={{58,80},{0,80},{0,70}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(zeroPosition.frame_resolve, basicWorldForce.frame_resolve) 
      annotation (Line(
        points={{58,80},{40,80},{40,-40},{28,-40},{28,-50}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    annotation (defaultComponentName="forceAndTorque",
      Diagram(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{
              100,100}}), graphics),
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Text(
            extent={{-63,56},{44,19}},
            lineColor={192,192,192},
            textString="resolve"),
          Text(
            extent={{-151,-73},{134,-134}},
            textString="%name",
            lineColor={0,0,255}),
          Line(
            points={{-100,60},{-86,68},{-80,72},{-70,78},{-64,82},{-46,86},{-34,
                88},{-16,88},{-2,86},{12,80},{24,74},{34,68},{46,58},{52,54},{
                58,48}},
            color={0,0,0},
            thickness=0.5),
          Polygon(
            points={{89,17},{64,76},{30,41},{89,17}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(
            points={{0,95},{0,-26}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Line(
            points={{0,0},{96,0}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Polygon(
            points={{-104,-48},{54,0},{46,20},{96,0},{66,-42},{60,-22},{-96,-72},
                {-104,-48}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid)}),
      Documentation(info="<HTML>
<p>
The <b>3</b> signals of the <b>force</b> and <b>torque</b>
connector are interpreted
as the x-, y- and z-coordinates of a <b>force</b> and
<b>torque</b> acting at the frame
connector to which frame_b of this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input forceand torque in world frame (= default)</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input force and torque in frame_b</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input force and torque in frame_resolve
                    (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = Types.ResolveInFrameB.frame_resolve, the force and
torque coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If force={100,0,0}, and for all parameters the default setting is used,
then the interpretation is that a force of 100 N is acting along the positive
x-axis of frame_b.
</p>

<p>
Conceptually, a force and torque acts on the world frame in such a way that
the force and torque balance between world.frame_b and frame_b is fulfilled.
For efficiency reasons, this reaction torque is, however, not computed.
</p>

<p>
The force and torque are by default visualized as an arrow (force)
and as a double arrow (torque) acting at the connector to which
they are connected. The diameters
and colors of the arrows can be defined via
variables <b>forceDiameter</b>, <b>torqueDiameter</b>,
<b>forceColor</b> and <b>torqueColor</b>. The arrows
point in the directions defined by the
force and torque vectors. The lengths of the arrows are proportional
to the length of the force and torque vectors, respectively, using parameters
<b>N_to_m</b> and <b>Nm_to_m</b> as scaling factors. For example, if N_to_m = 100 N/m,
then a force of 350 N is displayed as an arrow of length 3.5 m.
</p>
<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/WorldForceAndTorque1.png\">
</p>
<p>
This leads to the following animation
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/WorldForceAndTorque2.png\">
</p>
</HTML>
"),   Coordsys(
        extent=[-100, -100; 100, 100],
        grid=[1, 1],
        component=[20, 20]),
      Documentation(info="
An external force element exerts the inport signal
as negative force on the connector frame (the force vector
is resolved in the world frame).
"),   Icon(Text(extent=[-132, 99; 128, 39], string="%name",
          lineColor={0,0,255}),                              Polygon(points=[-100,
               10; 49, 10; 49, 31; 100, 0; 49, -31; 49, -10; -100, -10; -100,
              10], style(
            color=0,
            gradient=0,
            fillColor=0,
            fillPattern=1),
          lineColor={0,0,255})),
      Diagram(Polygon(points=[-90, 10; 40, 10; 40, 31; 91, 0; 40, -31; 40, -10;
               -90, -10; -90, 10], style(
            color=0,
            gradient=0,
            fillColor=0,
            fillPattern=1),
          lineColor={0,0,255})));
  end WorldForceAndTorque;

  model Force
    "Force acting between two frames, defined by 3 input signals and resolved in frame world, frame_a, frame_b or frame_resolve"

    import SI = Modelica.SIunits;
    extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
    Interfaces.Frame_resolve frame_resolve if 
         resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve
      "The input signals are optionally resolved in this frame" 
      annotation (Placement(transformation(
          origin={40,100},
          extent={{-16,-16},{16,16}},
          rotation=90)));
    Modelica.Blocks.Interfaces.RealInput force[3](each final quantity="Force", each
        final unit = "N")
      "x-, y-, z-coordinates of force resolved in frame defined by resolveInFrame"
      annotation (Placement(transformation(
          origin={-60,120},
          extent={{-20,-20},{20,20}},
          rotation=270)));
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB
      resolveInFrame=
      Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b
      "Frame in which input force is resolved (1: world, 2: frame_a, 3: frame_b, 4: frame_resolve)";
    parameter Real N_to_m(unit="N/m") = world.defaultN_to_m
      " Force arrow scaling (length = force/N_to_m)" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter forceDiameter=world.defaultArrowDiameter
      " Diameter of force arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter connectionLineDiameter=forceDiameter
      " Diameter of line connecting frame_a and frame_b" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color forceColor=Modelica.Mechanics.MultiBody.Types.Defaults.ForceColor
      " Color of force arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color connectionLineColor=Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor
      " Color of line connecting frame_a and frame_b" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(group="if animation = true", enable=animation));

  protected
    SI.Position f_in_m[3]=frame_b.f/N_to_m
      "Force mapped from N to m for animation";
    Visualizers.Advanced.Arrow forceArrow(
      diameter=forceDiameter,
      color=forceColor,
      specularCoefficient=specularCoefficient,
      R=frame_b.R,
      r=frame_b.r_0,
      r_tail=f_in_m,
      r_head=-f_in_m) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape connectionLine(
      shapeType="cylinder",
      lengthDirection=basicForce.r_0,
      widthDirection={0,1,0},
      length=Modelica.Math.Vectors.length(basicForce.r_0),
      width=connectionLineDiameter,
      height=connectionLineDiameter,
      color=connectionLineColor,
      specularCoefficient=specularCoefficient,
      r=frame_a.r_0) if world.enableAnimation and animation;

  public
    MultiBody.Forces.Internal.BasicForce basicForce(resolveInFrame=resolveInFrame) 
      annotation (Placement(transformation(extent={{0,-10},{20,10}})));
  protected
    MultiBody.Interfaces.ZeroPosition zeroPosition if 
         not (resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) 
      annotation (Placement(transformation(extent={{40,10},{60,30}})));
  equation
    connect(basicForce.frame_a, frame_a) annotation (Line(
        points={{0,0},{-100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicForce.frame_b, frame_b) annotation (Line(
        points={{20,0},{100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(force, basicForce.force) annotation (Line(
        points={{-60,120},{-60,40},{4,40},{4,12}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(basicForce.frame_resolve, frame_resolve) annotation (Line(
        points={{14,10},{14,40},{40,40},{40,100}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(zeroPosition.frame_resolve, basicForce.frame_resolve) annotation (
        Line(
        points={{40,20},{27,20},{27,10},{14,10}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    annotation (
      Diagram(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{
              100,100}}),
              graphics),
      Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{100,
              100}}), graphics={
          Rectangle(
            extent={{-98,99},{99,-98}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-92,61},{87,35}},
            lineColor={192,192,192},
            textString="resolve"),
          Text(
            extent={{-136,-52},{149,-113}},
            textString="%name",
            lineColor={0,0,255}),
          Line(
            points={{40,100},{40,0}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Polygon(
            points={{-94,0},{-64,11},{-64,-10},{-94,0}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-60,100},{40,100}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Polygon(
            points={{94,0},{65,12},{65,-11},{94,0}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{-64,0},{-20,0}}, color={0,0,0}),
          Line(points={{20,0},{65,0}}, color={0,0,0})}),
      Documentation(info="<html>
<p>
The <b>3</b> signals of the <b>force</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>force</b> acting at the frame
connector to which frame_b of this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameAB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input force in world frame</td></tr>

<tr><td valign=\"top\">frame_a</td>
    <td valign=\"top\">Resolve input force in frame_a</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input force in frame_b (= default)</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input force in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = ResolveInFrameAB.frame_resolve, the force coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If force={100,0,0}, and for all parameters the default setting is used,
then the interpretation is that a force of 100 N is acting along the positive
x-axis of frame_b.
</p>

<p>
Note, the cut-torque in frame_b (frame_b.t) is always set to zero.
Additionally, a force and torque acts on frame_a in such a way that
the force and torque balance between frame_a and frame_b is fulfilled.
</p>

<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/Force1.png\">
</p>
<p>
This leads to the following animation (the yellow cylinder
characterizes the line between frame_a and frame_b of the
Force component, i.e., the force acts with negative sign
also on the opposite side of this cylinder, but for
clarity this is not shown in the animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/Force2.png\">
</p>
</html>
"));
  end Force;

  model Torque
    "Torque acting between two frames, defined by 3 input signals and resolved in frame world, frame_a, frame_b or frame_resolve"

    import SI = Modelica.SIunits;
    extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
    Interfaces.Frame_resolve frame_resolve if 
         resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve
      "The input signals are optionally resolved in this frame" 
      annotation (Placement(transformation(
          origin={40,100},
          extent={{-16,-16},{16,16}},
          rotation=90)));

    Modelica.Blocks.Interfaces.RealInput torque[3](each final quantity="Torque", each
        final unit = "N.m")
      "x-, y-, z-coordiantes of torque resolved in frame defined by resolveInFrame"
      annotation (Placement(transformation(
          origin={-60,120},
          extent={{-20,-20},{20,20}},
          rotation=270)));
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB
      resolveInFrame=
      Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b
      "Frame in which input force is resolved (1: world, 2: frame_a, 3: frame_b, 4: frame_resolve)";
    parameter Real Nm_to_m(unit="N.m/m") = world.defaultNm_to_m
      " Torque arrow scaling (length = torque/Nm_to_m)" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter torqueDiameter=world.defaultArrowDiameter
      " Diameter of torque arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter connectionLineDiameter=torqueDiameter
      " Diameter of line connecting frame_a and frame_b" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color torqueColor=Modelica.Mechanics.MultiBody.Types.Defaults.TorqueColor
      " Color of torque arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color connectionLineColor=Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor
      " Color of line connecting frame_a and frame_b" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(group="if animation = true", enable=animation));

  protected
    SI.Position t_in_m[3]=frame_b.t/Nm_to_m
      "Torque mapped from Nm to m for animation";
    Visualizers.Advanced.DoubleArrow torqueArrow(
      diameter=torqueDiameter,
      color=torqueColor,
      specularCoefficient=specularCoefficient,
      R=frame_b.R,
      r=frame_b.r_0,
      r_tail=t_in_m,
      r_head=-t_in_m) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape connectionLine(
      shapeType="cylinder",
      lengthDirection=basicTorque.r_0,
      widthDirection={0,1,0},
      length=Modelica.Math.Vectors.length(
                           basicTorque.r_0),
      width=connectionLineDiameter,
      height=connectionLineDiameter,
      color=connectionLineColor,
      specularCoefficient=specularCoefficient,
      r=frame_a.r_0) if world.enableAnimation and animation;

  public
    Internal.BasicTorque basicTorque(resolveInFrame=resolveInFrame) 
      annotation (Placement(transformation(extent={{-8,-10},{12,10}})));
  protected
    Interfaces.ZeroPosition zeroPosition if 
         not (resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) 
      annotation (Placement(transformation(extent={{34,10},{54,30}})));
  equation
    connect(basicTorque.frame_a, frame_a) annotation (Line(
        points={{-8,0},{-100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicTorque.frame_b, frame_b) annotation (Line(
        points={{12,0},{100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicTorque.torque, torque) annotation (Line(
        points={{-4,12},{-4,60},{-60,60},{-60,120}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(basicTorque.frame_resolve, frame_resolve) annotation (Line(
        points={{6,10},{6,60},{40,60},{40,100}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(zeroPosition.frame_resolve, basicTorque.frame_resolve) annotation (
        Line(
        points={{34,20},{20,20},{20,10},{6,10}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    annotation (
      Diagram(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{
              100,100}}),
              graphics),
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Rectangle(
            extent={{-98,99},{99,-98}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-59,55},{72,30}},
            lineColor={192,192,192},
            textString="resolve"),
          Text(
            extent={{-139,-27},{146,-88}},
            textString="%name",
            lineColor={0,0,255}),
          Polygon(
            points={{100,20},{84,52},{69,39},{100,20}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(
            points={{40,100},{76,46}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Polygon(
            points={{-99,20},{-86,53},{-70,42},{-99,20}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-60,100},{40,100}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Line(points={{-79,47},{-70,61},{-59,72},{-45,81},{-32,84},{-20,85}},
              color={0,0,0}),
          Line(points={{77,45},{66,60},{55,69},{49,74},{41,80},{31,84},{20,85}}, 
              color={0,0,0})}),
      Documentation(info="<HTML>
<p>
The <b>3</b> signals of the <b>torque</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>torque</b> acting at the frame
connector to which frame_b of this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameAB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input torque in world frame</td></tr>

<tr><td valign=\"top\">frame_a</td>
    <td valign=\"top\">Resolve input torque in frame_a</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input torque in frame_b (= default)</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input torque in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = ResolveInFrameAB.frame_resolve, the torque coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If torque={100,0,0}, and for all parameters the default setting is used,
then the interpretation is that a torque of 100 N.m is acting along the positive
x-axis of frame_b.
</p>

<p>
Note, the cut-forces in frame_a and frame_b (frame_a.f, frame_b.f) are
always set to zero and the cut-torque at frame_a (frame_a.t) is the same
as the cut-torque at frame_b (frame_b.t) but with opposite sign.
</p>

<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/Torque1.png\">
</p>
<p>
This leads to the following animation (the yellow cylinder
characterizes the line between frame_a and frame_b of the
Torque component, i.e., the torque acts with negative sign
also on the opposite side of this cylinder, but for
clarity this is not shown in the animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/Torque2.png\">
</p>
</HTML>
"));
  end Torque;

  model ForceAndTorque
    "Force and torque acting between two frames, defined by 3+3 input signals and resolved in frame world, frame_a, frame_b or frame_resolve"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;
    extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;

    Blocks.Interfaces.RealInput force[3](each final quantity="Force", each
        final unit = "N")
      "x-, y-, z-coordinates of force resolved in frame defined by resolveInFrame"
      annotation (Placement(transformation(
          origin={-80,120},
          extent={{-20,-20},{20,20}},
          rotation=270)));
    Blocks.Interfaces.RealInput torque[3](each final quantity="Torque", each
        final unit = "N.m")
      "x-, y-, z-coordiantes of torque resolved in frame defined by resolveInFrame"
      annotation (Placement(transformation(
          origin={0,120},
          extent={{-20,-20},{20,20}},
          rotation=270)));
    Interfaces.Frame_resolve frame_resolve if 
         resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve
      "The input signals are optionally resolved in this frame" 
      annotation (Placement(transformation(
          origin={80,100},
          extent={{-16,-16},{16,16}},
          rotation=90)));

    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB
      resolveInFrame=
      Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b
      "Frame in which input force and torque are resolved (1: world, 2: frame_a, 3: frame_b, 4: frame_resolve)";
    parameter Real N_to_m(unit="N/m") = world.defaultN_to_m
      "Force arrow scaling (length = force/N_to_m)" 
      annotation (Dialog(group="if animation = true", enable=animation));
    parameter Real Nm_to_m(unit="N.m/m") = world.defaultNm_to_m
      "Torque arrow scaling (length = torque/Nm_to_m)" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter forceDiameter=world.defaultArrowDiameter
      "Diameter of force arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter torqueDiameter=forceDiameter " Diameter of torque arrow" 
                                  annotation (Dialog(group="if animation = true", enable=animation));
    input SI.Diameter connectionLineDiameter=forceDiameter
      "Diameter of line connecting frame_a and frame_b" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color forceColor=Modelica.Mechanics.MultiBody.Types.Defaults.ForceColor
      "Color of force arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color torqueColor=Modelica.Mechanics.MultiBody.Types.Defaults.TorqueColor
      "Color of torque arrow" annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color connectionLineColor=Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor
      "Color of line connecting frame_a and frame_b" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(group="if animation = true", enable=animation));

  protected
    SI.Position f_in_m[3]=frame_b.f/N_to_m
      "Force mapped from N to m for animation";
    SI.Position t_in_m[3]=frame_b.t/Nm_to_m
      "Torque mapped from Nm to m for animation";
    Visualizers.Advanced.Arrow forceArrow(
      diameter=forceDiameter,
      color=forceColor,
      specularCoefficient=specularCoefficient,
      R=frame_b.R,
      r=frame_b.r_0,
      r_tail=f_in_m,
      r_head=-f_in_m) if world.enableAnimation and animation;
    Visualizers.Advanced.DoubleArrow torqueArrow(
      diameter=torqueDiameter,
      color=torqueColor,
      specularCoefficient=specularCoefficient,
      R=frame_b.R,
      r=frame_b.r_0,
      r_tail=t_in_m,
      r_head=-t_in_m) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape connectionLine(
      shapeType="cylinder",
      lengthDirection=basicForce.r_0,
      widthDirection={0,1,0},
      length=Modelica.Math.Vectors.length(
                           basicForce.r_0),
      width=connectionLineDiameter,
      height=connectionLineDiameter,
      color=connectionLineColor,
      specularCoefficient=specularCoefficient,
      r=frame_a.r_0) if world.enableAnimation and animation;

  public
    Internal.BasicForce basicForce(resolveInFrame=resolveInFrame) 
      annotation (Placement(transformation(extent={{-84,-10},{-64,10}})));
    Internal.BasicTorque basicTorque(resolveInFrame=resolveInFrame) 
      annotation (Placement(transformation(extent={{-4,10},{16,30}})));
  protected
    Interfaces.ZeroPosition zeroPosition if 
         not (resolveInFrame == Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) 
      annotation (Placement(transformation(extent={{20,30},{40,50}})));
  equation
    connect(basicForce.frame_a, frame_a) annotation (Line(
        points={{-84,0},{-100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicForce.frame_b, frame_b) annotation (Line(
        points={{-64,0},{100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicTorque.frame_b, frame_b) annotation (Line(
        points={{16,20},{68,20},{68,0},{100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicTorque.frame_a, frame_a) annotation (Line(
        points={{-4,20},{-90,20},{-90,0},{-100,0}},
        color={95,95,95},
        thickness=0.5,
        smooth=Smooth.None));
    connect(basicForce.force, force) annotation (Line(
        points={{-80,12},{-80,120}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(basicTorque.torque, torque) annotation (Line(
        points={{0,32},{0,120}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(basicTorque.frame_resolve, frame_resolve) annotation (Line(
        points={{10,30},{10,80},{80,80},{80,100}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(basicForce.frame_resolve, frame_resolve) annotation (Line(
        points={{-70,10},{-70,80},{80,80},{80,100}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(zeroPosition.frame_resolve, basicTorque.frame_resolve)  annotation (
        Line(
        points={{20,40},{10,40},{10,30}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    connect(zeroPosition.frame_resolve, basicForce.frame_resolve) annotation (
        Line(
        points={{20,40},{-70,40},{-70,10}},
        color={95,95,95},
        pattern=LinePattern.Dot,
        smooth=Smooth.None));
    annotation (
      Diagram(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{
              100,100}},
          grid={2,2}),
              graphics),
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}},
          grid={2,2}), graphics={
          Rectangle(
            extent={{-98,99},{99,-98}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-59,55},{72,30}},
            lineColor={192,192,192},
            textString="resolve"),
          Text(
            extent={{-136,-52},{149,-113}},
            textString="%name",
            lineColor={0,0,255}),
          Polygon(
            points={{100,21},{84,55},{69,39},{100,21}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(
            points={{80,100},{80,0}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Polygon(
            points={{-95,1},{-64,11},{-64,-10},{-95,1}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-100,20},{-86,53},{-70,42},{-100,20}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-80,100},{80,100}},
            color={95,95,95},
            pattern=LinePattern.Dot),
          Polygon(
            points={{94,0},{65,12},{65,-11},{94,0}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{-64,0},{-20,0}}, color={0,0,0}),
          Line(points={{20,0},{65,0}}, color={0,0,0}),
          Line(points={{-79,47},{-70,61},{-59,72},{-45,81},{-32,84},{-20,85}},
              color={0,0,0}),
          Line(points={{76,47},{66,60},{55,69},{49,74},{41,80},{31,84},{20,85}}, 
              color={0,0,0}),
          Text(
            extent={{-144,124},{-106,102}},
            lineColor={0,0,0},
            textString="f"),
          Text(
            extent={{20,124},{58,102}},
            lineColor={0,0,0},
            textString="t")}),
      Documentation(info="<HTML>
The <b>3</b> signals of the <b>force</b> connector and the
<b>3</b> signals of the <b>torque</b> connector
are interpreted
as the x-, y- and z-coordinates of a <b>force</b> and of a
<b>torque</b> acting at the frame
connector to which frame_b of this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameAB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input force/torque in world frame</td></tr>

<tr><td valign=\"top\">frame_a</td>
    <td valign=\"top\">Resolve input force/torque in frame_a</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input force/torque in frame_b (= default)</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input force/torque in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = ResolveInFrameAB.frame_resolve, the force and torque coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If force={100,0,0}, and for all parameters the default setting is used,
then the interpretation is that a force of 100 N is acting along the positive
x-axis of frame_b.
</p>

<p>
Note, a force and torque acts on frame_a in such a way that
the force and torque balance between frame_a and frame_b is fulfilled.
</p>

<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/ForceAndTorque1.png\">
</p>
<p>
This leads to the following animation (the yellow cylinder
characterizes the line between frame_a and frame_b of the
ForceAndTorque component, i.e., the force and torque acts with
negative sign
also on the opposite side of this cylinder, but for
clarity this is not shown in the animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/ForceAndTorque2.png\">
</p>
</HTML>
"));
  end ForceAndTorque;

  model LineForceWithMass
    "General line force component with an optional point mass on the connection line"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;
    extends Interfaces.PartialTwoFrames;
    Modelica.Mechanics.Translational.Interfaces.Flange_a flange_b
      "1-dim. translational flange (connect force of Translational library between flange_a and flange_b)"
      annotation (Placement(transformation(
          origin={60,100},
          extent={{-10,-10},{10,10}},
          rotation=90)));
    Modelica.Mechanics.Translational.Interfaces.Flange_b flange_a
      "1-dim. translational flange (connect force of Translational library between flange_a and flange_b)"
      annotation (Placement(transformation(
          origin={-60,100},
          extent={{-10,-10},{10,10}},
          rotation=90)));

    parameter Boolean animateLine=true
      "= true, if a line shape between frame_a and frame_b shall be visualized";
    parameter Boolean animateMass=true
      "= true, if point mass shall be visualized as sphere provided m > 0";
    parameter SI.Mass m(min=0)=0
      "Mass of point mass on the connetion line between the origin of frame_a and the origin of frame_b";
    parameter Real lengthFraction(
      unit="1",
      min=0,
      max=1) = 0.5
      "Location of point mass with respect to frame_a as a fraction of the distance from frame_a to frame_b";
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation"));
    parameter Types.ShapeType lineShapeType="cylinder"
      " Type of shape visualizing the line from frame_a to frame_b" 
      annotation (Dialog(tab="Animation", group="if animateLine = true", enable=animateLine));
    input SI.Length lineShapeWidth=world.defaultArrowDiameter " Width of shape"
      annotation (Dialog(tab="Animation", group="if animateLine = true", enable=animateLine));
    input SI.Length lineShapeHeight=lineShapeWidth " Height of shape" 
      annotation (Dialog(tab="Animation", group="if animateLine = true", enable=animateLine));
    parameter Types.ShapeExtra lineShapeExtra=0.0 " Extra parameter for shape" 
      annotation (Dialog(tab="Animation", group="if animateLine = true", enable=animateLine));
    input Types.Color lineShapeColor=Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor
      " Color of line shape" 
      annotation (Dialog(tab="Animation", group="if animateLine = true", enable=animateLine));
    input Real massDiameter=world.defaultBodyDiameter
      " Diameter of point mass sphere" 
      annotation (Dialog(tab="Animation", group="if animateMass = true", enable=animateMass));
    input Types.Color massColor=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      " Color of point mass" 
      annotation (Dialog(tab="Animation", group="if animateMass = true", enable=animateMass));
    parameter SI.Position s_small=1.E-10
      " Prevent zero-division if distance between frame_a and frame_b is zero" 
      annotation (Dialog(tab="Advanced"));
    SI.Distance length
      "Distance between the origin of frame_a and the origin of frame_b";
    SI.Position r_rel_0[3]
      "Position vector from frame_a to frame_b resolved in world frame";
    Real e_rel_0[3](each final unit="1")
      "Unit vector in direction from frame_a to frame_b, resolved in world frame";

  protected
    SI.Force fa "Force from flange_a";
    SI.Force fb "Force from flange_b";
    SI.Position r_CM_0[3](stateSelect=StateSelect.avoid)
      "Position vector from world frame to point mass, resolved in world frame";
    SI.Velocity v_CM_0[3](stateSelect=StateSelect.avoid)
      "First derivative of r_CM_0";
    SI.Acceleration ag_CM_0[3] "der(v_CM_0) - gravityAcceleration";

    Visualizers.Advanced.Shape lineShape(
      shapeType=lineShapeType,
      color=lineShapeColor,
      specularCoefficient=specularCoefficient,
      length=length,
      width=lineShapeWidth,
      height=lineShapeHeight,
      lengthDirection=e_rel_0,
      widthDirection=Frames.resolve1(frame_a.R, {0,1,0}),
      extra=lineShapeExtra,
      r=frame_a.r_0) if world.enableAnimation and animateLine;

    Visualizers.Advanced.Shape massShape(
      shapeType="sphere",
      color=massColor,
      specularCoefficient=specularCoefficient,
      length=massDiameter,
      width=massDiameter,
      height=massDiameter,
      lengthDirection=e_rel_0,
      widthDirection={0,1,0},
      r_shape=e_rel_0*(length*lengthFraction - massDiameter/2),
      r=frame_a.r_0) if world.enableAnimation and animateMass and m > 0;
  equation
    Connections.potentialRoot(frame_a.R, 100);
    Connections.potentialRoot(frame_b.R, 100);
    assert(noEvent(length > s_small), "
The distance between the origin of frame_a and the origin of frame_b
of a LineForceWithMass component became smaller as parameter s_small
(= a small number, defined in the \"Advanced\" menu). The distance is
set to s_small, although it is smaller, to avoid a division by zero
when computing the direction of the line force. Possible reasons
for this situation:
- At initial time the distance may already be zero: Change the initial
  positions of the bodies connected by this element.
- Hardware stops are not modeled or are modeled not stiff enough.
  Include stops, e.g., stiff springs, or increase the stiffness
  if already present.
- Another error in your model may lead to unrealistically large forces
  and torques that would in reality destroy the stops.
- The flange_b connector might be defined by a pre-defined motion,
  e.g., with Modelica.Mechanics.Translational.Position and the
  predefined flange_b.s is zero or negative.
");

    // Determine relative position vector between the two frames
    r_rel_0 = frame_b.r_0 - frame_a.r_0;
    length = Modelica.Math.Vectors.length(
                           r_rel_0);
    flange_a.s = 0;
    flange_b.s = length;
    e_rel_0 = r_rel_0/Frames.Internal.maxWithoutEvent(length, s_small);

    // Determine translational flange forces
    if cardinality(flange_a) > 0 and cardinality(flange_b) > 0 then
      fa = flange_a.f;
      fb = flange_b.f;
    elseif cardinality(flange_a) > 0 and cardinality(flange_b) == 0 then
      fa = flange_a.f;
      fb = -fa;
    elseif cardinality(flange_a) == 0 and cardinality(flange_b) > 0 then
      fa = -fb;
      fb = flange_b.f;
    else
      fa = 0;
      fb = 0;
    end if;

    /* Force and torque balance of point mass
     - Kinematics for center of mass CM of point mass including gravity
       r_CM_0 = frame_a.r0 + r_rel_CM_0;
       v_CM_0 = der(r_CM_0);
       ag_CM_0 = der(v_CM_0) - world.gravityAcceleration(r_CM_0);
     - Power balance for the connection line
       (f1=force on frame_a side, f2=force on frame_b side, h=lengthFraction)
       0 = f1*va - m*ag_CM*(va+(vb-va)*h) + f2*vb
         = (f1 - m*ag_CM*(1-h))*va + (f2 - m*ag_CM*h)*vb
       since va and vb are completely indepedent from other
       the paranthesis must vanish:
         f1 := m*ag_CM*(1-h)
         f2 := m*ag_CM*h
     - Force balance on frame_a and frame_b finally results in
         0 = frame_a.f + e_rel_a*fa - f1_a
         0 = frame_b.f + e_rel_b*fb - f2_b
       and therefore
         frame_a.f = -e_rel_a*fa + m*ag_CM_a*(1-h)
         frame_b.f = -e_rel_b*fb + m*ag_CM_b*h
  */
    if m > 0 then
      r_CM_0 = frame_a.r_0 + r_rel_0*lengthFraction;
      v_CM_0 = der(r_CM_0);
      ag_CM_0 = der(v_CM_0) - world.gravityAcceleration(r_CM_0);
      frame_a.f = Frames.resolve2(frame_a.R, (m*(1 - lengthFraction))*ag_CM_0
         - e_rel_0*fa);
      frame_b.f = Frames.resolve2(frame_b.R, (m*lengthFraction)*ag_CM_0 -
        e_rel_0*fb);
    else
      r_CM_0 = zeros(3);
      v_CM_0 = zeros(3);
      ag_CM_0 = zeros(3);
      frame_a.f = -Frames.resolve2(frame_a.R, e_rel_0*fa);
      frame_b.f = -Frames.resolve2(frame_b.R, e_rel_0*fb);
    end if;

    // Provide appropriate equations, if direct connections of line forces
    if Connections.isRoot(frame_a.R) then
      frame_a.R = Frames.nullRotation();
    else
      frame_a.t = zeros(3);
    end if;

    if Connections.isRoot(frame_b.R) then
      frame_b.R = Frames.nullRotation();
    else
      frame_b.t = zeros(3);
    end if;
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(
            extent={{-95,-40},{-15,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-85,-30},{-25,30}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{15,-40},{95,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{23,-30},{83,29}},
            lineColor={128,128,128},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-145,-53},{145,-113}},
            textString="%name",
            lineColor={0,0,255}),
          Rectangle(
            extent={{-40,41},{44,-40}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-70,15},{-41,-13}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{40,14},{69,-14}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Line(points={{-56,0},{-56,23},{-30,23},{-30,70},{-60,70},{-60,101}},
              color={0,0,0}),
          Line(points={{55,-1},{55,20},{30,20},{30,70},{60,70},{60,100}}, color
              ={0,0,0}),
          Line(
            points={{-56,0},{55,-1}},
            color={0,0,0},
            pattern=LinePattern.Dot),
          Ellipse(
            extent={{-8,8},{8,-8}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-60,80},{46,80}}, color={0,0,255}),
          Polygon(
            points={{60,80},{45,86},{45,74},{60,80}},
            lineColor={0,0,255},
            fillColor={0,0,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-22,100},{20,76}},
            textString="length",
            lineColor={0,0,255}),
          Ellipse(
            extent={{-100,-40},{-20,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-90,-30},{-30,30}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{20,-40},{100,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{31,-29},{91,30}},
            lineColor={128,128,128},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-50,39},{50,-41}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-74,15},{-45,-13}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{45,15},{74,-13}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Line(points={{-60,0},{-60,24},{-40,24},{-40,60},{-60,60},{-60,100}},
              color={0,0,0}),
          Line(points={{60,1},{60,21},{40,21},{40,60},{60,60},{60,100}}, color=
                {0,0,0}),
          Line(
            points={{-60,0},{60,0}},
            color={0,0,0},
            pattern=LinePattern.Dot),
          Ellipse(
            extent={{-8,8},{8,-8}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{-60,0},{-31,0}}, color={0,0,255}),
          Polygon(points={{-19,0},{-31,3},{-31,-3},{-19,0}}, lineColor={0,0,255}), 

          Line(points={{-60,16},{0,16}}, color={0,0,255}),
          Line(points={{0,0},{0,20}}, color={0,0,255}),
          Text(
            extent={{-43,-8},{-7,-33}},
            lineColor={0,0,0},
            textString="e_rel_0"),
          Polygon(points={{0,16},{-12,19},{-12,13},{0,16}}, lineColor={0,0,255}), 

          Text(
            extent={{-50,35},{51,26}},
            lineColor={0,0,0},
            textString="length*lengthFraction"),
          Line(
            points={{-17,26},{-26,16}},
            pattern=LinePattern.Dot,
            color={0,0,255}),
          Line(
            points={{-31,-13},{-40,0}},
            pattern=LinePattern.Dot,
            color={0,0,255})}),
      Documentation(info="<html>
<p>
This component is used to exert a <b>line force</b>
between the origin of frame_a and the origin of frame_b
by attaching components of the <b>1-dimensional translational</b>
mechanical library of Modelica (Modelica.Mechanics.Translational)
between the two flange connectors <b>flange_a</b> and
<b>flange_b</b>. Optionally, there is a <b>point mass</b> on the line
connecting the origin of frame_a and the origin of frame_b.
This point mass approximates the <b>mass</b> of the <b>force element</b>.
The distance of the point mass from frame_a as a fraction of the
distance between frame_a and frame_b is defined via
parameter <b>lengthFraction</b> (default is 0.5, i.e., the point
mass is in the middle of the line).
</p>
<p>
In the translational library there is the implicit assumption that
forces of components that have only one flange connector act with
opposite sign on the bearings of the component. This assumption
is also used in the LineForceWithMass component: If a connection
is present to only one of the flange connectors, then the force
in this flange connector acts implicitly with opposite sign also
in the other flange connector.
</p>
</html>"));
  end LineForceWithMass;

  model LineForceWithTwoMasses
    "General line force component with two optional point masses on the connection line"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;

    extends Interfaces.PartialTwoFrames;
    Modelica.Mechanics.Translational.Interfaces.Flange_a flange_b
      "1-dim. translational flange (connect force of Translational library between flange_a and flange_b)"
      annotation (Placement(transformation(
          origin={60,110},
          extent={{-10,-10},{10,10}},
          rotation=90)));
    Modelica.Mechanics.Translational.Interfaces.Flange_b flange_a
      "1-dim. translational flange (connect force of Translational library between flange_a and flange_b)"
      annotation (Placement(transformation(
          origin={-60,110},
          extent={{-10,-10},{10,10}},
          rotation=90)));

    parameter Boolean animate=true "= true, if animation shall be enabled";
    parameter Boolean animateMasses=true
      "= true, if point masses shall be visualized provided animate=true and m_a, m_b > 0";
    parameter SI.Mass m_a(min=0)=0
      "Mass of point mass a on the connetion line between the origin of frame_a and the origin of frame_b";
    parameter SI.Mass m_b(min=0)=0
      "Mass of point mass b on the connetion line between the origin of frame_a and the origin of frame_b";
    parameter SI.Position L_a=0
      "Distance between point mass a and frame_a (positive, if in direction of frame_b)";
    parameter SI.Position L_b=L_a
      "Distance between point mass b and frame_b (positive, if in direction of frame_a)";
    input SI.Diameter cylinderDiameter_a=world.defaultForceWidth
      " Diameter of cylinder at frame_a" 
      annotation (Dialog(tab="Animation", group="Cylinder at frame_a if animation = true", enable=animate));
    parameter SI.Length cylinderLength_a=2*L_a " Length of cylinder at frame_a"
      annotation (Dialog(tab="Animation", group="Cylinder at frame_a if animation = true", enable=animate));
    input Types.Color color_a={155,155,155} " Color of cylinder at frame_a" 
      annotation (Dialog(tab="Animation", group="Cylinder at frame_a if animation = true", enable=animate));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="Cylinder at frame_a if animation = true", enable=animate));
    input Real diameterFraction=0.8
      " Diameter of cylinder at frame_b with respect to diameter of cylinder at frame_a"
      annotation (Dialog(tab="Animation", group="Cylinder at frame_b if animation = true", enable=animate));
    parameter SI.Length cylinderLength_b=2*L_b " Length of cylinder at frame_b"
      annotation (Dialog(tab="Animation", group="Cylinder at frame_b if animation = true", enable=animate));
    input Types.Color color_b={100,100,100} " Color of cylinder at frame_b" 
      annotation (Dialog(tab="Animation", group="Cylinder at frame_b if animation = true", enable=animate));
    input Real massDiameterFaction=1.7
      " Diameter of point mass spheres with respect to cylinderDiameter_a" 
      annotation (Dialog(tab="Animation", group="if animation = true and animateMasses = true", enable=animate and animateMasses));
    input Types.Color massColor=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      " Color of point masses" 
      annotation (Dialog(tab="Animation", group="if animation = true and animateMasses = true", enable=animate and animateMasses));
    parameter SI.Position s_small=1.E-10
      " Prevent zero-division if distance between frame_a and frame_b is zero" 
      annotation (Dialog(tab="Advanced"));
    SI.Distance length
      "Distance between the origin of frame_a and the origin of frame_b";
    SI.Position r_rel_0[3]
      "Position vector from frame_a to frame_b resolved in world frame";
    Real e_rel_0[3](each final unit="1")
      "Unit vector in direction from frame_a to frame_b, resolved in world frame";

  protected
    SI.Force fa "Force from flange_a";
    SI.Force fb "Force from flange_b";
    SI.Position r_CM1_0[3](stateSelect=StateSelect.avoid)
      "Position vector from world frame to point mass 1, resolved in world frame";
    SI.Position r_CM2_0[3](stateSelect=StateSelect.avoid)
      "Position vector from world frame to point mass 2, resolved in world frame";
    SI.Velocity v_CM1_0[3](stateSelect=StateSelect.avoid)
      "der(r_CM_1_0) - velocity of point mass 1";
    SI.Velocity v_CM2_0[3](stateSelect=StateSelect.avoid)
      "der(r_CM_2_0) - velocity of point mass 2";
    SI.Acceleration ag_CM1_0[3] "der(v_CM1_0) - gravityAcceleration(r_CM1_0)";
    SI.Acceleration ag_CM2_0[3] "der(v_CM2_0) - gravityAcceleration(r_CM2_0)";
    SI.Force aux1_0[3] "Auxiliary force 1";
    SI.Force aux2_0[3] "Auxiliary force 2";

    input SI.Length cylinderDiameter_b=cylinderDiameter_a*diameterFraction;
    input SI.Length massDiameter=cylinderDiameter_a*massDiameterFaction;
    parameter Boolean animateMasses2=world.enableAnimation and animate and animateMasses and m_a > 0 and m_b > 0;
    Visualizers.Advanced.Shape cylinder_a(
      shapeType="cylinder",
      color=color_a,
      specularCoefficient=specularCoefficient,
      length=cylinderLength_a,
      width=cylinderDiameter_a,
      height=cylinderDiameter_a,
      lengthDirection=e_rel_0,
      widthDirection={0,1,0},
      r=frame_a.r_0) if world.enableAnimation and animate;

    Visualizers.Advanced.Shape cylinder_b(
      shapeType="cylinder",
      color=color_b,
      specularCoefficient=specularCoefficient,
      length=cylinderLength_b,
      width=cylinderDiameter_b,
      height=cylinderDiameter_b,
      lengthDirection=-e_rel_0,
      widthDirection={0,1,0},
      r=frame_b.r_0) if world.enableAnimation and animate;

    Visualizers.Advanced.Shape sphere_a(
      shapeType="sphere",
      color=massColor,
      specularCoefficient=specularCoefficient,
      length=massDiameter,
      width=massDiameter,
      height=massDiameter,
      lengthDirection=e_rel_0,
      widthDirection={0,1,0},
      r_shape=e_rel_0*(L_a - massDiameter/2),
      r=frame_a.r_0) if animateMasses2;

    Visualizers.Advanced.Shape sphere_b(
      shapeType="sphere",
      color=massColor,
      specularCoefficient=specularCoefficient,
      length=massDiameter,
      width=massDiameter,
      height=massDiameter,
      lengthDirection=-e_rel_0,
      widthDirection={0,1,0},
      r_shape=-e_rel_0*(L_b - massDiameter/2),
      r=frame_b.r_0) if animateMasses2;
  equation
    Connections.potentialRoot(frame_a.R, 100);
    Connections.potentialRoot(frame_b.R, 100);
    assert(noEvent(length > s_small), "
The distance between the origin of frame_a and the origin of frame_b
of a LineForceWithTwoMasses component became smaller as parameter s_small
(= a small number, defined in the \"Advanced\" menu). The distance is
set to s_small, although it is smaller, to avoid a division by zero
when computing the direction of the line force. Possible reasons
for this situation:
- At initial time the distance may already be zero: Change the initial
  positions of the bodies connected by this element.
- Hardware stops are not modeled or are modeled not stiff enough.
  Include stops, e.g., stiff springs, or increase the stiffness
  if already present.
- Another error in your model may lead to unrealistically large forces
  and torques that would in reality destroy the stops.
- The flange_b connector might be defined by a pre-defined motion,
  e.g., with Modelica.Mechanics.Translational.Position and the
  predefined flange_b.s is zero or negative.
");

    // Determine relative position vector between the two frames
    r_rel_0 = frame_b.r_0 - frame_a.r_0;
    length = Modelica.Math.Vectors.length(
                           r_rel_0);
    flange_a.s = 0;
    flange_b.s = length;
    e_rel_0 = r_rel_0/Frames.Internal.maxWithoutEvent(length, s_small);

    // Determine translational flange forces
    if cardinality(flange_a) > 0 and cardinality(flange_b) > 0 then
      fa = flange_a.f;
      fb = flange_b.f;
    elseif cardinality(flange_a) > 0 and cardinality(flange_b) == 0 then
      fa = flange_a.f;
      fb = -fa;
    elseif cardinality(flange_a) == 0 and cardinality(flange_b) > 0 then
      fa = -fb;
      fb = flange_b.f;
    else
      fa = 0;
      fb = 0;
    end if;

    /* Force and torque balance of the two point masses
     - Kinematics for center of masses CM1, CM2 of point masses including gravity
       (L = length, va = der(frame_a.r_0), vb = der(frame_b.r_0))
       r_CM1_0 = frame_a.r_0 + e_rel_0*L_a;
       r_CM2_0 = frame_b.r_0 - e_rel_0*L_b;
       v_CM1_0 = der(r_CM1_0);
       v_CM2_0 = der(r_CM2_0);
       ag_CM1_0 = der(v_CM1_0) - world.gravityAcceleration(r_CM1_0);
       ag_CM2_0 = der(v_CM2_0) - world.gravityAcceleration(r_CM2_0);
       der(e_rel_0) = der(r_rel_0/sqrt(r_rel_0*r_rel_0))
                    = 1/L*(I - e_rel_0*e_rel_0')*der(r_rel_0)
                    = 1/L*(I - e_rel_0*e_rel_0')*(vb - va)
       v_CM1_0 = va + L_a/L*(I - e_rel_0*e_rel_0')*(vb - va)
       v_CM2_0 = vb - L_b/L*(I - e_rel_0*e_rel_0')*(vb - va)
     - Power balance for the connection line
       (f1=force on frame_a side, f2=force on frame_b side)
       0 = f1*va - m_a*ag_CM1*v_CM1 + f2*vb - m_b*ag_CM2*v_CM2
         = f1*va - m_a*ag_CM1*(va + L_a/L*(I - e_rel*e_rel')*(vb - va)) +
           f2*vb - m_b*ag_CM2*(vb - L_b/L*(I - e_rel*e_rel')*(vb - va))
         = (f1 - m_a*ag_CM1*(I - L_a/L*(I - e_rel*e_rel'))
               - m_b*ag_CM2*(L_b/L*(I - e_rel*e_rel')))*va +
           (f2 - m_b*ag_CM2*(I - L_b/L*(I - e_rel_0*e_rel_0'))
               - m_a*ag_CM1*(L_a/L*(I - e_rel*e_rel')))*vb
         = va*(f1 - m_a*ag_CM1 +
               (m_a*ag_CM1*L_a/L - m_b*ag_CM2*L_b/L)*(I - e_rel*e_rel')) +
           vb*(f2 - m_b*ag_CM2 +
               (m_b*ag_CM2*L_b/L - m_a*ag_CM1*L_a/L)*(I - e_rel*e_rel'))
       since va and vb are completely independent from other
       the paranthesis must vanish:
         f1 := m_a*ag_CM1 - (m_a*ag_CM1*L_a/L - m_b*ag_CM2*L_b/L)*(I - e_rel*e_rel')
         f2 := m_b*ag_CM2 + (m_a*ag_CM1*L_a/L - m_b*ag_CM2*L_b/L)*(I - e_rel*e_rel')
       or
         aux1 := ag_CM1*(m_a*L_a/L) - ag_CM2*(m_b*L_b/L);
         aux2 := aux1 - (aux1'*e_rel)*e_rel
         f1 := m_a*ag_CM1 - aux2
         f2 := m_b*ag_CM2 + aux2
     - Force balance on frame_a and frame_b finally results in
         0 = frame_a.f + e_rel_a*fa - f1_a
         0 = frame_b.f + e_rel_b*fb - f2_b
       and therefore
         frame_a.f = -e_rel_a*fa + m_a*ag_CM1 - aux2
         frame_b.f = -e_rel_b*fb + m_b*ag_CM2 + aux2
  */
    if m_a > 0 or m_b > 0 then
      r_CM1_0 = frame_a.r_0 + e_rel_0*L_a;
      r_CM2_0 = frame_b.r_0 - e_rel_0*L_b;
      v_CM1_0 = der(r_CM1_0);
      v_CM2_0 = der(r_CM2_0);
      ag_CM1_0 = der(v_CM1_0) - world.gravityAcceleration(r_CM1_0);
      ag_CM2_0 = der(v_CM2_0) - world.gravityAcceleration(r_CM2_0);
      aux1_0 = ag_CM1_0*(m_a*L_a/length) - ag_CM2_0*(m_b*L_b/length);
      aux2_0 = aux1_0 - (aux1_0*e_rel_0)*e_rel_0;
      frame_a.f = Frames.resolve2(frame_a.R, m_a*ag_CM1_0 - aux2_0 - e_rel_0*fa);
      frame_b.f = Frames.resolve2(frame_b.R, m_b*ag_CM2_0 + aux2_0 - e_rel_0*fb);
    else
      r_CM1_0 = zeros(3);
      r_CM2_0 = zeros(3);
      v_CM1_0 = zeros(3);
      v_CM2_0 = zeros(3);
      ag_CM1_0 = zeros(3);
      ag_CM2_0 = zeros(3);
      aux1_0 = zeros(3);
      aux2_0 = zeros(3);
      frame_a.f = -Frames.resolve2(frame_a.R, e_rel_0*fa);
      frame_b.f = -Frames.resolve2(frame_b.R, e_rel_0*fb);
    end if;

    // Provide appropriate equations, if direct connections of line forces
    if Connections.isRoot(frame_a.R) then
      frame_a.R = Frames.nullRotation();
    else
      frame_a.t = zeros(3);
    end if;

    if Connections.isRoot(frame_b.R) then
      frame_b.R = Frames.nullRotation();
    else
      frame_b.t = zeros(3);
    end if;
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(
            extent={{-100,-40},{-20,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-90,-30},{-30,30}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{20,-40},{100,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{31,-29},{91,30}},
            lineColor={128,128,128},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-145,-53},{145,-113}},
            textString="%name",
            lineColor={0,0,255}),
          Rectangle(
            extent={{-52,40},{48,-40}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-74,15},{-45,-13}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{45,14},{74,-14}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Line(points={{-60,0},{-60,23},{-30,23},{-30,70},{-60,70},{-60,101}},
              color={0,0,0}),
          Line(points={{60,0},{60,20},{30,20},{30,70},{60,70},{60,100}}, color=
                {0,0,0}),
          Line(
            points={{-23,0},{25,0}},
            color={0,0,0},
            pattern=LinePattern.Dot),
          Ellipse(
            extent={{23,8},{39,-8}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-39,8},{-23,-8}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{-60,0},{-29,0}}, color={0,0,0}),
          Line(points={{29,0},{60,0}}, color={0,0,0})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-60,80},{46,80}}, color={0,0,255}),
          Polygon(
            points={{60,80},{45,86},{45,74},{60,80}},
            lineColor={0,0,255},
            fillColor={0,0,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-22,100},{20,76}},
            textString="length",
            lineColor={0,0,255}),
          Ellipse(
            extent={{-100,-40},{-20,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-90,-30},{-30,30}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{20,-40},{100,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{31,-29},{91,30}},
            lineColor={128,128,128},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-49,39},{51,-41}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-74,15},{-45,-13}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{45,15},{74,-13}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Line(points={{-60,0},{-60,24},{-40,24},{-40,60},{-60,60},{-60,110}},
              color={0,0,0}),
          Line(points={{60,1},{60,21},{40,21},{40,60},{60,60},{60,110}}, color=
                {0,0,0}),
          Line(
            points={{-60,0},{60,0}},
            color={0,0,0},
            pattern=LinePattern.Dot),
          Ellipse(
            extent={{20,8},{36,-8}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{-18,-18},{11,-18}}, color={0,0,255}),
          Polygon(points={{23,-18},{11,-15},{11,-21},{23,-18}}, lineColor={0,0,
                255}),
          Line(points={{-60,16},{-37,16}}, color={0,0,255}),
          Line(points={{-25,0},{-25,20}}, color={0,0,255}),
          Text(
            extent={{-16,-19},{20,-44}},
            lineColor={0,0,0},
            textString="e_rel_0"),
          Polygon(points={{-25,16},{-37,19},{-37,13},{-25,16}}, lineColor={0,0,
                255}),
          Text(
            extent={{-39,31},{-22,21}},
            lineColor={0,0,0},
            textString="L_a"),
          Ellipse(
            extent={{-33,7},{-17,-9}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{29,3},{29,22}}, color={0,0,255}),
          Line(points={{29,16},{60,16}}, color={0,0,255}),
          Polygon(points={{29,16},{41,19},{41,13},{29,16}}, lineColor={0,0,255}), 

          Text(
            extent={{15,36},{32,26}},
            lineColor={0,0,0},
            textString="L_b"),
          Line(
            points={{37,18},{30,27}},
            pattern=LinePattern.Dot,
            color={0,0,255})}),
      Documentation(info="<html>
<p>
This component is used to exert a <b>line force</b>
between the origin of frame_a and the origin of frame_b
by attaching components of the <b>1-dimensional translational</b>
mechanical library of Modelica (Modelica.Mechanics.Translational)
between the two flange connectors <b>flange_a</b> and
<b>flange_b</b>. Optionally, there are <b>two point masses</b> on the line
connecting the origin of frame_a and the origin of frame_b.
These point masses approximate the <b>masses</b> of the <b>force element</b>.
The locations of the two point masses are defined by their
(fixed) distances of L_a relative to frame_a and of L_b relative
to frame_b, respectively.
</p>
<p>
In example
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Examples.Elementary.LineForceWithTwoMasses\">
MultiBody.Examples.Elementary.LineForceWithTwoMasses</a> the usage of this
line force element is shown and is compared with an alternative
implementation using a
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUPS\">
MultiBody.Joints.Assemblies.JointUPS</a> component.
The composition diagram of this example
is displayed in the figure below.
</p>
<IMG SRC=\"../Images/MultiBody/Examples/Elementary/LineForceWithTwoMasses1.png\">
<p>
The animation view at time = 0 is shown in the next figure.
The system on the left side in the front is the animation with
the LineForceWithTwoMasses component whereas the system on the right
side in the back is the animation with the JointUPS component.
Both implementations yield the same result. However, the implementation
with the LineForceWithTwoMasses component is simpler.
</p>
<IMG SRC=\"../Images/MultiBody/Examples/Elementary/LineForceWithTwoMasses2.png\">
<p>
In the translational library there is the implicit assumption that
forces of components that have only one flange connector act with
opposite sign on the bearings of the component. This assumption
is also used in the LineForceWithTwoMasses component: If a connection
is present to only one of the flange connectors, then the force
in this flange connector acts implicitly with opposite sign also
in the other flange connector.
</p>
</html>"));
  end LineForceWithTwoMasses;

  model Spring "Linear translational spring with optional mass"
    import Modelica.Mechanics.MultiBody.Types;
    extends Interfaces.PartialTwoFrames;
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Boolean showMass=true
      "= true, if point mass shall be visualized as sphere if animation=true and m>0";

    parameter SI.TranslationalSpringConstant c(final min=0) "Spring constant";
    parameter SI.Length s_unstretched=0 "Unstretched spring length";
    parameter SI.Mass m(min=0)=0
      "Spring mass located on the connetion line between the origin of frame_a and the origin of frame_b";
    parameter Real lengthFraction(
      min=0,
      max=1) = 0.5
      "Location of spring mass with respect to frame_a as a fraction of the distance from frame_a to frame_b (=0: at frame_a; =1: at frame_b)";
    input SI.Distance width=world.defaultForceWidth " Width of spring" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input SI.Distance coilWidth=width/10 " Width of spring coil" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Integer numberOfWindings=5 " Number of spring windings" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.SpringColor
      " Color of spring" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input SIunits.Diameter massDiameter=max(0, (width - 2*coilWidth)*0.9)
      " Diameter of mass point sphere" annotation (Dialog(tab="Animation", group=
            "if animation = true and showMass = true", enable=animation and showMass));
    input Types.Color massColor=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      " Color of mass point" annotation (Dialog(tab="Animation", group=
            "if animation = true and showMass = true", enable=animation and showMass));

    Forces.LineForceWithMass lineForce(
      animateLine=animation,
      animateMass=showMass,
      m=m,
      lengthFraction=lengthFraction,
      lineShapeType="spring",
      lineShapeHeight=coilWidth*2,
      lineShapeWidth=width,
      lineShapeExtra=numberOfWindings,
      lineShapeColor=color,
      specularCoefficient=specularCoefficient,
      massDiameter=massDiameter,
      massColor=massColor) annotation (Placement(transformation(extent={{-20,
              -20},{20,20}}, rotation=0)));
    Modelica.Mechanics.Translational.Components.Spring spring(
                                                   s_rel0=s_unstretched, c=c) 
      annotation (Placement(transformation(extent={{-8,40},{12,60}}, rotation=0)));

  equation
    connect(lineForce.frame_a, frame_a) 
      annotation (Line(
        points={{-20,0},{-100,0}},
        color={95,95,95},
        thickness=0.5));
    connect(lineForce.frame_b, frame_b) 
      annotation (Line(
        points={{20,0},{100,0}},
        color={95,95,95},
        thickness=0.5));
    connect(spring.flange_b, lineForce.flange_b) 
      annotation (Line(points={{12,50},{12,20}}, color={0,191,0}));
    connect(spring.flange_a, lineForce.flange_a) 
      annotation (Line(points={{-8,50},{-12,50},{-12,20}}, color={0,191,0}));

    annotation (
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Line(
            points={{-100,0},{-58,0},{-43,-30},{-13,30},{17,-30},{47,30},{62,0},
                {100,0}},
            color={0,0,0},
            pattern=LinePattern.Solid,
            thickness=0.25,
            arrow={Arrow.None,Arrow.None}),
          Text(
            extent={{-130,49},{132,109}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{-141,-92},{125,-51}},
            lineColor={0,0,0},
            textString="c=%c"),
          Ellipse(
            extent={{-8,8},{8,-8}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
              100,100}}),
              graphics),
      Documentation(info="<HTML>
<p>
<b>Linear spring</b> acting as line force between frame_a and frame_b.
A <b>force f</b> is exerted on the origin of frame_b and with opposite sign
on the origin of frame_a along the line from the origin of frame_a to the origin
of frame_b according to the equation:
</p>
<pre>
   f = c*(s - s_unstretched);
</pre>
<p>
where \"c\" and \"s_unstretched\" are parameters and \"s\" is the
distance between the origin of frame_a and the origin of frame_b.
</p>
<p>
Optionally, the mass of the spring is taken into account by a
point mass located on the line between frame_a and frame_b
(default: middle of the line). If the spring mass is zero, the
additional equations to handle the mass are removed.
</p>
<p>
In the following figure a typical animation of the
spring is shown. The blue sphere in the middle of the
spring characterizes the location of the point mass.
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Examples/Elementary/SpringWithMass.png\"
ALT=\"model Examples.Elementary.SpringWithMass\">
</p>
</HTML>"));
  end Spring;

  model Damper "Linear (velocity dependent) damper"
    import Modelica.Mechanics.MultiBody.Types;
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter SI.TranslationalDampingConstant d(final min=0, start = 0)
      "Damping constant";
    parameter SI.Distance length_a=world.defaultForceLength
      " Length of cylinder at frame_a side" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input SIunits.Diameter diameter_a=world.defaultForceWidth
      " Diameter of cylinder at frame_a side" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input SIunits.Diameter diameter_b=0.6*diameter_a
      " Diameter of cylinder at frame_b side" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color color_a={100,100,100} " Color at frame_a" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation, colorSelector));
    input Types.Color color_b={155,155,155} " Color at frame_b" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation, colorSelector));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    extends Interfaces.PartialLineForce;

  protected
    SI.Position r0_b[3]=e_a*noEvent(min(length_a, s));
    Visualizers.Advanced.Shape shape_a(
      shapeType="cylinder",
      color=color_a,
      specularCoefficient=specularCoefficient,
      length=noEvent(min(length_a, s)),
      width=diameter_a,
      height=diameter_a,
      lengthDirection=e_a,
      widthDirection={0,1,0},
      r=frame_a.r_0,
      R=frame_a.R) if 
                     world.enableAnimation and animation;
    Visualizers.Advanced.Shape shape_b(
      shapeType="cylinder",
      color=color_b,
      specularCoefficient=specularCoefficient,
      length=noEvent(max(s - length_a, 0)),
      width=diameter_b,
      height=diameter_b,
      lengthDirection=e_a,
      widthDirection={0,1,0},
      r_shape=r0_b,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
  equation
    f = d*der(s);
    annotation (
      Documentation(info="<HTML>
<p>
<b>Linear damper</b> acting as line force between frame_a and frame_b.
A <b>force f</b> is exerted on the origin of frame_b and with opposite sign
on the origin of frame_a along the line from the origin of frame_a to the origin
of frame_b according to the equation:
</p>
<pre>
   f = d*<b>der</b>(s);
</pre>
<p>
where \"d\" is a parameter, \"s\" is the
distance between the origin of frame_a and the origin of frame_b
and der(s) is the time derivative of \"s\".
</p>
<p>
In the following figure a typical animation is shown
where a mass is hanging on a damper.
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/Damper.png\">
</p>
</HTML>"),
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-101,0},{-60,0}}, color={0,0,0}),
          Line(points={{-60,-30},{-60,30}}, color={0,0,0}),
          Line(points={{-60,-30},{60,-30}}, color={0,0,0}),
          Line(points={{-60,30},{60,30}}, color={0,0,0}),
          Rectangle(
            extent={{-60,30},{30,-30}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{30,0},{100,0}}, color={0,0,0}),
          Text(
            extent={{-140,47},{145,105}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{-156,-96},{152,-53}},
            lineColor={0,0,0},
            textString="d=%d")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-100,0},{-60,0}}, color={0,0,0}),
          Line(points={{-60,-30},{-60,30}}, color={0,0,0}),
          Line(points={{-60,-30},{60,-30}}, color={0,0,0}),
          Line(points={{-60,30},{60,30}}, color={0,0,0}),
          Rectangle(
            extent={{-60,30},{30,-30}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{30,0},{100,0}}, color={0,0,0}),
          Line(points={{-50,60},{50,60}}, color={128,128,128}),
          Text(
            extent={{-20,60},{10,85}},
            lineColor={128,128,128},
            textString="der(s)"),
          Polygon(
            points={{64,60},{42,68},{42,52},{62,60},{64,60}},
            lineColor={128,128,128},
            fillColor={160,160,164},
            fillPattern=FillPattern.Solid)}));
  end Damper;

  model SpringDamperParallel "Linear spring and linear damper in parallel"
    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter SI.TranslationalSpringConstant c(final min=0) "Spring constant";
    parameter SI.Length s_unstretched=0 "Unstretched spring length";
    parameter SI.TranslationalDampingConstant d(final min=0) = 0
      "Damping constant";
    input SI.Distance width=world.defaultForceWidth " Width of spring" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input SI.Distance coilWidth=width/10 " Width of spring coil" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Integer numberOfWindings=5 " Number of spring windings" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.SpringColor
      " Color of spring" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    extends Interfaces.PartialLineForce;

  protected
    Visualizers.Advanced.Shape shape(
      shapeType="spring",
      color=color,
      length=s,
      width=width,
      height=coilWidth*2,
      lengthDirection=e_a,
      widthDirection={0,1,0},
      extra=numberOfWindings,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
  equation
    f = c*(s - s_unstretched) + d*der(s);
    annotation (
      Documentation(info="<HTML>
<p>
<b>Linear spring</b> and <b>dinear damper</b>
in parallel acting as line force between frame_a and frame_b.
A <b>force f</b> is exerted on the origin of frame_b and with opposite sign
on the origin of frame_a along the line from the origin of frame_a to the origin
of frame_b according to the equation:
</p>
<pre>
   f = c*(s - s_unstretched) + d*<b>der</b>(s);
</pre>
<p>
where \"c\", \"s_unstretched\" and \"d\" are parameters, \"s\" is the
distance between the origin of frame_a and the origin of frame_b
and der(s) is the time derivative of s.
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-131,-166},{114,-108}},
            textString="%name",
            lineColor={0,0,255}),
          Line(points={{-80,40},{-60,40},{-45,10},{-15,70},{15,10},{45,70},{60,
                40},{80,40}}, color={0,0,0}),
          Line(points={{-80,40},{-80,-70}}, color={0,0,0}),
          Line(points={{-80,-70},{-52,-70}}, color={0,0,0}),
          Rectangle(
            extent={{-52,-40},{38,-100}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-52,-40},{68,-40}}, color={0,0,0}),
          Line(points={{-52,-100},{68,-100}}, color={0,0,0}),
          Line(points={{38,-70},{80,-70}}, color={0,0,0}),
          Line(points={{80,40},{80,-70}}, color={0,0,0}),
          Line(points={{-100,0},{-80,0}}, color={0,0,0}),
          Line(points={{80,0},{100,0}}, color={0,0,0}),
          Text(
            extent={{-140,72},{138,108}},
            lineColor={0,0,0},
            textString="c,d=%c,%d")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(
            points={{-80,32},{-58,32},{-43,2},{-13,62},{17,2},{47,62},{62,32},{
                80,32}},
            color={0,0,0},
            thickness=0.5),
          Line(points={{-68,32},{-68,97}}, color={128,128,128}),
          Line(points={{72,32},{72,97}}, color={128,128,128}),
          Line(points={{-68,92},{72,92}}, color={128,128,128}),
          Polygon(
            points={{62,95},{72,92},{62,89},{62,95}},
            lineColor={128,128,128},
            fillColor={128,128,128},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-20,72},{20,97}},
            lineColor={0,0,255},
            textString="s"),
          Rectangle(
            extent={{-52,-20},{38,-80}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-52,-80},{68,-80}}, color={0,0,0}),
          Line(points={{-52,-20},{68,-20}}, color={0,0,0}),
          Line(points={{38,-50},{80,-50}}, color={0,0,0}),
          Line(points={{-80,-50},{-52,-50}}, color={0,0,0}),
          Line(points={{-80,32},{-80,-50}}, color={0,0,0}),
          Line(points={{80,32},{80,-50}}, color={0,0,0}),
          Line(points={{-100,0},{-80,0}}, color={0,0,0}),
          Line(points={{100,0},{80,0}}, color={0,0,0})}));
  end SpringDamperParallel;

  model SpringDamperSeries
    "Linear spring and linear damper in series connection"
    import SI = Modelica.SIunits;
    parameter SI.TranslationalSpringConstant c(final min=0) "Spring constant";
    parameter SI.Length s_unstretched=0 "Unstretched spring length";
    parameter SI.TranslationalDampingConstant d(final min=0) = 0
      "Damping constant";
    parameter SI.Length s_damper_start=0 "Initial length of damper";
    SI.Position s_damper(start=s_damper_start, fixed=true)
      "Actual length of damper (frame_a - damper - spring - frame_b)";
    extends Interfaces.PartialLineForce;

  equation
    f = c*(s - s_unstretched - s_damper);
    d*der(s_damper) = f;
    annotation (
      Documentation(info="<HTML>
<p>
<b>Linear spring</b> and <b>linear damper</b> in series connection
acting as line force between frame_a and frame_b:
</p>
<pre>
  frame_a --> damper ----> spring --> frame_b
          |              |
          |-- s_damper --|  (s_damper is the state variable of this system)
</pre>
<p>
A <b>force f</b> is exerted on the origin of frame_b and with opposite sign
on the origin of frame_a along the line from the origin of frame_a to the origin
of frame_b according to the equations:
</p>
<pre>
   f = c*(s - s_unstretched - s_damper);
   f = d*der(s_damper);
</pre>
<p>
where \"c\", \"s_unstretched\" and \"d\" are parameters, \"s\" is the
distance between the origin of frame_a and the origin of frame_b.
\"s_damper\" is the length of the damper (= an internal state of this
force element) and der(s_damper) is the time derivative of s_damper.
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-100,0},{-15,0}}, color={0,0,0}),
          Line(points={{-60,-30},{-15,-30}}, color={0,0,0}),
          Line(points={{-60,30},{-15,30}}, color={0,0,0}),
          Rectangle(
            extent={{-60,30},{-30,-30}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-15,0},{-5,0},{5,-30},{25,30},{45,-30},{65,30},{75,0},{
                100,0}}, color={0,0,0}),
          Text(
            extent={{-140,47},{145,105}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{-148,-96},{160,-53}},
            lineColor={0,0,0},
            textString="c,d=%c,%d")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-100,0},{-15,0}}, color={0,0,0}),
          Line(points={{-60,-30},{-15,-30}}, color={0,0,0}),
          Line(points={{-60,30},{-15,30}}, color={0,0,0}),
          Rectangle(
            extent={{-60,30},{-30,-30}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Line(points={{-15,0},{-5,0},{5,-30},{25,30},{45,-30},{65,30},{75,0},{
                99,0}}, color={0,0,0}),
          Line(points={{-75,0},{-75,85}}, color={160,160,164}),
          Line(points={{-10,0},{-10,65}}, color={160,160,164}),
          Line(points={{80,0},{80,85}}, color={160,160,164}),
          Line(points={{-75,80},{80,80}}, color={160,160,164}),
          Line(points={{-75,60},{-10,60}}, color={160,160,164}),
          Polygon(
            points={{-10,60},{-20,65},{-20,55},{-10,60}},
            lineColor={160,160,164},
            fillColor={160,160,164},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{80,80},{70,85},{70,75},{80,80}},
            lineColor={160,160,164},
            fillColor={160,160,164},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-72,63},{-11,78}},
            lineColor={160,160,164},
            textString="s_damper"),
          Text(
            extent={{0,80},{20,100}},
            lineColor={160,160,164},
            textString="s")}));
  end SpringDamperSeries;

  package Internal "Internal package, should not be used by user"

    model BasicForce
      "Force acting between two frames, defined by 3 input signals"

      import Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB;
      extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
      Interfaces.Frame_resolve frame_resolve
        "The input signals are optionally resolved in this frame" 
        annotation (Placement(transformation(
            origin={40,100},
            extent={{-16,-16},{16,16}},
            rotation=90)));
      Modelica.Blocks.Interfaces.RealInput force[3](each final quantity="Force", each
          final unit="N")
        "x-, y-, z-coordinates of force resolved in frame defined by resolveInFrame"
        annotation (Placement(transformation(
            origin={-60,120},
            extent={{-20,-20},{20,20}},
            rotation=270)));
      parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB
        resolveInFrame=
        Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b
        "Frame in which force is resolved (1: world, 2: frame_a, 3: frame_b, 4: frame_resolve)";

      Modelica.SIunits.Position r_0[3]
        "Position vector from origin of frame_a to origin of frame_b resolved in world frame";
      Modelica.SIunits.Force f_b_0[3] "frame_b.f resoved in world frame";

    equation
      assert(cardinality(frame_resolve) > 0, "Connector frame_resolve must be connected at least once and frame_resolve.r_0/.R must be set");
      frame_resolve.f = zeros(3);
      frame_resolve.t = zeros(3);

       if resolveInFrame == ResolveInFrameAB.frame_a then
          f_b_0     = -Frames.resolve1(frame_a.R, force);
          frame_b.f =  Frames.resolve2(frame_b.R, f_b_0);
       elseif resolveInFrame == ResolveInFrameAB.frame_b then
          f_b_0     = -Frames.resolve1(frame_b.R, force);
          frame_b.f = -force;
       elseif resolveInFrame == ResolveInFrameAB.world then
          f_b_0     = -force;
          frame_b.f =  Frames.resolve2(frame_b.R, f_b_0);
       elseif resolveInFrame == ResolveInFrameAB.frame_resolve then
          f_b_0     = -Frames.resolve1(frame_resolve.R, force);
          frame_b.f = Frames.resolve2(frame_b.R, f_b_0);
       else
          assert(false, "Wrong value for parameter resolveInFrame");
          f_b_0     = zeros(3);
          frame_b.f = zeros(3);
       end if;
       frame_b.t = zeros(3);

       // Force and torque balance
       r_0 = frame_b.r_0 - frame_a.r_0;
       zeros(3) = frame_a.f + Frames.resolve2(frame_a.R, f_b_0);
       zeros(3) = frame_a.t + Frames.resolve2(frame_a.R, cross(r_0, f_b_0));
      annotation (
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                {100,100}}),
                graphics),
        Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{
                100,100}}), graphics={
            Rectangle(
              extent={{-98,99},{99,-98}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-92,61},{87,35}},
              lineColor={192,192,192},
              textString="resolve"),
            Text(
              extent={{-136,-52},{149,-113}},
              textString="%name",
              lineColor={0,0,255}),
            Line(
              points={{40,100},{40,0}},
              color={95,95,95},
              pattern=LinePattern.Dot),
            Polygon(
              points={{-94,0},{-64,11},{-64,-10},{-94,0}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Line(
              points={{-60,100},{40,100}},
              color={95,95,95},
              pattern=LinePattern.Dot),
            Polygon(
              points={{94,0},{65,12},{65,-11},{94,0}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Line(points={{-64,0},{-20,0}}, color={0,0,0}),
            Line(points={{20,0},{65,0}}, color={0,0,0})}),
        Documentation(info="<HTML>
<p>
The <b>3</b> signals of the <b>force</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>force</b> acting at the frame
connector to which frame_b of this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameAB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input force in world frame</td></tr>

<tr><td valign=\"top\">frame_a</td>
    <td valign=\"top\">Resolve input force in frame_a</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input force in frame_b (= default)</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input force in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = ResolveInFrameAB.frame_resolve, the force coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If resolveInFrame is not ResolveInFrameAB.frame_resolve, then the position
vector and the orientation object of frame_resolve must be set to constant
values from the outside in order that the model remains balanced
(these constant values are ignored).
</p>

</HTML>
"));
    end BasicForce;

    model BasicTorque
      "Torque acting between two frames, defined by 3 input signals"

      import SI = Modelica.SIunits;
      import Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB;
      extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
      Interfaces.Frame_resolve frame_resolve
        "The input signals are optionally resolved in this frame" 
        annotation (Placement(transformation(
            origin={40,100},
            extent={{-16,-16},{16,16}},
            rotation=90)));

      Modelica.Blocks.Interfaces.RealInput torque[3](each final quantity="Torque", each
          final unit="N.m")
        "x-, y-, z-coordiantes of torque resolved in frame defined by resolveInFrame"
        annotation (Placement(transformation(
            origin={-60,120},
            extent={{-20,-20},{20,20}},
            rotation=270)));
      parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB
        resolveInFrame=
        Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b
        "Frame in which torque is resolved (1: world, 2: frame_a, 3: frame_b, 4: frame_resolve)";

      SI.Position r_0[3]
        "Position vector from origin of frame_a to origin of frame_b resolved in world frame";
      SI.Torque t_b_0[3] "frame_b.t resoved in world frame";

    equation
      assert(cardinality(frame_resolve) > 0, "Connector frame_resolve must be connected at least once and frame_resolve.r_0/.R must be set");
      frame_resolve.f = zeros(3);
      frame_resolve.t = zeros(3);

      r_0 = frame_b.r_0 - frame_a.r_0;
      frame_a.f = zeros(3);
      frame_b.f = zeros(3);

       if resolveInFrame == ResolveInFrameAB.frame_a then
          t_b_0     = -Frames.resolve1(frame_a.R, torque);
          frame_b.t =  Frames.resolve2(frame_b.R, t_b_0);
       elseif resolveInFrame == ResolveInFrameAB.frame_b then
          t_b_0     = -Frames.resolve1(frame_b.R, torque);
          frame_b.t = -torque;
       elseif resolveInFrame == ResolveInFrameAB.world then
          t_b_0     = -torque;
          frame_b.t =  Frames.resolve2(frame_b.R, t_b_0);
       elseif resolveInFrame == ResolveInFrameAB.frame_resolve then
          t_b_0     = -Frames.resolve1(frame_resolve.R, torque);
          frame_b.t =  Frames.resolve2(frame_b.R, t_b_0);
       else
          assert(false, "Wrong value for parameter resolveInFrame");
          t_b_0     = zeros(3);
          frame_b.t = zeros(3);
       end if;

       // torque balance
       zeros(3) = frame_a.t + Frames.resolve2(frame_a.R, t_b_0);
      annotation (
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                {100,100}}),
                graphics),
        Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                100,100}}), graphics={
            Rectangle(
              extent={{-98,99},{99,-98}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-59,55},{72,30}},
              lineColor={192,192,192},
              textString="resolve"),
            Text(
              extent={{-139,-27},{146,-88}},
              textString="%name",
              lineColor={0,0,255}),
            Polygon(
              points={{100,20},{84,52},{69,39},{100,20}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Line(
              points={{40,100},{76,46}},
              color={95,95,95},
              pattern=LinePattern.Dot),
            Polygon(
              points={{-99,20},{-86,53},{-70,42},{-99,20}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Line(
              points={{-60,100},{40,100}},
              color={95,95,95},
              pattern=LinePattern.Dot),
            Line(points={{-79,47},{-70,61},{-59,72},{-45,81},{-32,84},{-20,85}}, 
                color={0,0,0}),
            Line(points={{77,45},{66,60},{55,69},{49,74},{41,80},{31,84},{20,85}}, 
                color={0,0,0})}),
        Documentation(info="<HTML>
<p>
The <b>3</b> signals of the <b>torque</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>torque</b> acting at the frame
connector to which frame_b of this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameAB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input torque in world frame</td></tr>

<tr><td valign=\"top\">frame_a</td>
    <td valign=\"top\">Resolve input torque in frame_a</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input torque in frame_b (= default)</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input torque in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = ResolveInFrameAB.frame_resolve, the torque coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If resolveInFrame is not ResolveInFrameAB.frame_resolve, then the position
vector and the orientation object of frame_resolve must be set to constant
values from the outside in order that the model remains balanced
(these constant values are ignored).
</p>
</HTML>
"));
    end BasicTorque;

    model BasicWorldForce
      "External force acting at frame_b, defined by 3 input signals"

      import SI = Modelica.SIunits;
      import Modelica.Mechanics.MultiBody.Types.ResolveInFrameB;
      extends Interfaces.PartialOneFrame_b;
      Interfaces.Frame_resolve frame_resolve
        "The input signals are optionally resolved in this frame" 
        annotation (Placement(transformation(
            origin={0,-100},
            extent={{-16,-16},{16,16}},
            rotation=270)));

      Modelica.Blocks.Interfaces.RealInput force[3](each final quantity="Force", each
          final unit="N")
        "x-, y-, z-coordinates of force resolved in frame defined by resolveInFrame"
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
              rotation=0)));
      parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameB
        resolveInFrame=
        Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.world
        "Frame in which force is resolved (1: world, 2: frame_b, 3: frame_resolve)";

    equation
       assert(cardinality(frame_resolve) > 0, "Connector frame_resolve must be connected at least once and frame_resolve.r_0/.R must be set");
       frame_resolve.f = zeros(3);
       frame_resolve.t = zeros(3);

       if resolveInFrame == ResolveInFrameB.world then
          frame_b.f = -Frames.resolve2(frame_b.R, force);
       elseif resolveInFrame == ResolveInFrameB.frame_b then
          frame_b.f = -force;
       elseif resolveInFrame == ResolveInFrameB.frame_resolve then
          frame_b.f = -Frames.resolveRelative(force, frame_resolve.R, frame_b.R);
       else
          assert(false, "Wrong value for parameter resolveInFrame");
          frame_b.f = zeros(3);
       end if;
       frame_b.t = zeros(3);
      annotation (
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                {100,100}}), graphics={Polygon(
              points={{-100,10},{50,10},{50,31},{97,0},{50,-31},{50,-10},{-100,
                  -10},{-100,10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid), Line(
              points={{0,-10},{0,-97}},
              color={95,95,95},
              pattern=LinePattern.Dot)}),
        Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                100,100}}), graphics={
            Text(
              extent={{-89,-46},{91,-76}},
              lineColor={192,192,192},
              textString="resolve"),
            Polygon(
              points={{-100,10},{50,10},{50,31},{94,0},{50,-31},{50,-10},{-100,
                  -10},{-100,10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-149,103},{136,42}},
              textString="%name",
              lineColor={0,0,255}),
            Line(
              points={{0,-10},{0,-95}},
              color={95,95,95},
              pattern=LinePattern.Dot)}),
        Documentation(info="<HTML>
<p>
The 3 signals of the <b>force</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>force</b> acting at the frame
connector to which this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input force in world frame (= default)</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input force in frame_b</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input force in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = Types.ResolveInFrameB.frame_resolve, the force coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If resolveInFrame is not Types.ResolveInFrameB.frame_resolve, then the position
vector and the orientation object of frame_resolve must be set to constant
values from the outside in order that the model remains balanced
(these constant values are ignored).
</p>

</HTML>
"));
    end BasicWorldForce;

    model BasicWorldTorque
      "External torque acting at frame_b, defined by 3 input signals"

      import SI = Modelica.SIunits;
      import Modelica.Mechanics.MultiBody.Types.ResolveInFrameB;
      extends Interfaces.PartialOneFrame_b;
      Interfaces.Frame_resolve frame_resolve
        "The input signals are optionally resolved in this frame" 
        annotation (Placement(transformation(
            origin={0,100},
            extent={{16,-16},{-16,16}},
            rotation=270)));

      Modelica.Blocks.Interfaces.RealInput torque[3](each final quantity="Torque", each
          final unit="N.m")
        "x-, y-, z-coordinates of torque resolved in frame defined by resolveInFrame"
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
              rotation=0)));
      parameter Modelica.Mechanics.MultiBody.Types.ResolveInFrameB
        resolveInFrame=
        Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.world
        "Frame in which torque is resolved (1: world, 2: frame_b, 3: frame_resolve)";

    equation
       assert(cardinality(frame_resolve) > 0, "Connector frame_resolve must be connected at least once and frame_resolve.r_0/.R must be set");
       frame_resolve.f = zeros(3);
       frame_resolve.t = zeros(3);

       if resolveInFrame == ResolveInFrameB.world then
          frame_b.t = -Frames.resolve2(frame_b.R, torque);
       elseif resolveInFrame == ResolveInFrameB.frame_b then
          frame_b.t = -torque;
       elseif resolveInFrame == ResolveInFrameB.frame_resolve then
          frame_b.t = -Frames.resolveRelative(torque, frame_resolve.R, frame_b.R);
       else
          assert(false, "Wrong value for parameter resolveInFrame");
          frame_b.t = zeros(3);
       end if;
       frame_b.f = zeros(3);
      annotation (
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                {100,100}}), graphics={
            Line(
              points={{0,97},{0,82}},
              color={95,95,95},
              pattern=LinePattern.Dot),
            Line(
              points={{-100,0},{-94,13},{-86,28},{-74,48},{-65,60},{-52,72},{-35,
                  81},{-22,84},{-8,84},{7,80},{19,73},{32,65},{44,55},{52,47},{
                  58,40}},
              color={0,0,0},
              thickness=0.5),
            Polygon(
              points={{97,6},{75,59},{41,24},{97,6}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid)}),
        Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                100,100}}), graphics={
            Text(
              extent={{-61,64},{46,27}},
              lineColor={192,192,192},
              textString="resolve"),
            Text(
              extent={{-145,-28},{140,-89}},
              textString="%name",
              lineColor={0,0,255}),
            Line(
              points={{0,95},{0,82}},
              color={95,95,95},
              pattern=LinePattern.Dot),
            Line(
              points={{-100,0},{-94,13},{-86,28},{-74,48},{-65,60},{-52,72},{-35,
                  81},{-22,84},{-8,84},{7,80},{19,73},{32,65},{44,55},{52,47},{
                  58,40}},
              color={0,0,0},
              thickness=0.5),
            Polygon(
              points={{94,10},{75,59},{41,24},{94,10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid)}),
        Documentation(info="<HTML>
<p>
The 3 signals of the <b>torque</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>torque</b> acting at the frame
connector to which this component is attached.
Via parameter <b>resolveInFrame</b> it is defined, in which frame these
coordinates shall be resolved:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.ResolveInFrameB.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">world</td>
    <td valign=\"top\">Resolve input torque in world frame (= default)</td></tr>

<tr><td valign=\"top\">frame_b</td>
    <td valign=\"top\">Resolve input torque in frame_b</td></tr>

<tr><td valign=\"top\">frame_resolve</td>
    <td valign=\"top\">Resolve input torque in frame_resolve (frame_resolve must be connected)</td></tr>
</table>

<p>
If resolveInFrame = Types.ResolveInFrameB.frame_resolve, the torque coordinates
are with respect to the frame, that is connected to <b>frame_resolve</b>.
<p>

<p>
If resolveInFrame is not Types.ResolveInFrameB.frame_resolve, then the position
vector and the orientation object of frame_resolve must be set to constant
values from the outside in order that the model remains balanced
(these constant values are ignored).
</p>

</HTML>
"));
    end BasicWorldTorque;
  end Internal;
  annotation ( Documentation(info="<HTML>
<p>
This package contains components that exert forces and torques
between two frame connectors, e.g., between two parts.
</p>
<h4>Content</h4>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><th><b><i>Model</i></b></th><th><b><i>Description</i></b></th></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.WorldForce\">WorldForce</a></td>
      <td valign=\"top\"> External force acting at the frame to which this component
           is connected and defined by 3 input signals,
           that are interpreted as one vector resolved in frame world, frame_b or frame_resolve. <br>
           <IMG SRC=\"../Images/MultiBody/Forces/ArrowForce.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.WorldTorque\">WorldTorque</a></td>
      <td valign=\"top\"> External torque acting at the frame to which this component
           is connected and defined by 3 input signals,
           that are interpreted as one vector resolved in frame world, frame_b or frame_resolve. <br>
           <IMG SRC=\"../Images/MultiBody/Forces/ArrowTorque.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.WorldForceAndTorque\">WorldForceAndTorque</a></td>
      <td valign=\"top\"> External force and external torque acting at the frame
           to which this component
           is connected and defined by 3+3 input signals,
           that are interpreted as a force and as a torque vector
           resolved in frame world, frame_b or frame_resolve. <br>
           <IMG SRC=\"../Images/MultiBody/Forces/ArrowForce.png\"><br>
           <IMG SRC=\"../Images/MultiBody/Forces/ArrowTorque.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.Force\">Force</a></td>
      <td valign=\"top\"> Force acting between two frames defined by 3 input signals
           resolved in frame world, frame_a, frame_b or in frame_resolve. <br>
           <IMG SRC=\"../Images/MultiBody/Forces/ArrowForce2.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.Torque\">Torque</a></td>
      <td valign=\"top\"> Torque acting between two frames defined by 3 input signals
           resolved in frame world, frame_a, frame_b or in frame_resolve. <br>
           <IMG SRC=\"../Images/MultiBody/Forces/ArrowTorque2.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.ForceAndTorque\">ForceAndTorque</a></td>
      <td valign=\"top\"> Force and torque acting between two frames defined by 3+3 input signals
           resolved in frame world, frame_a, frame_b or in frame_resolve. <br>
           <IMG SRC=\"../Images/MultiBody/Forces/ArrowForce2.png\"><br>
           <IMG SRC=\"../Images/MultiBody/Forces/ArrowTorque2.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.LineForceWithMass\">LineForceWithMass</a></td>
      <td valign=\"top\">  General line force component with an optional point mass
            on the connection line. The force law can be defined by a
            component of Modelica.Mechanics.Translational<br>
           <IMG SRC=\"../Images/MultiBody/Forces/LineForceWithMass.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.LineForceWithTwoMasses\">LineForceWithTwoMasses</a></td>
      <td valign=\"top\">  General line force component with two optional point masses
            on the connection line. The force law can be defined by a
            component of Modelica.Mechanics.Translational<br>
           <IMG SRC=\"../Images/MultiBody/Forces/LineForceWithTwoMasses.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.Spring\">Spring</a></td>
      <td valign=\"top\"> Linear translational spring with optional mass <br>
           <IMG SRC=\"../Images/MultiBody/Forces/Spring2.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.Damper\">Damper</a></td>
      <td valign=\"top\"> Linear (velocity dependent) damper <br>
           <IMG SRC=\"../Images/MultiBody/Forces/Damper2.png\"></td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.SpringDamperParallel\">SpringDamperParallel</a></td>
      <td valign=\"top\"> Linear spring and damper in parallel connection </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Forces.SpringDamperSeries\">SpringDamperSeries</a></td>
      <td valign=\"top\"> Linear spring and damper in series connection </td>
  </tr>
</table>
</HTML>"));
end Forces;

package Frames "Functions to transform rotational frame quantities"

  extends Modelica.Icons.Library;

  record Orientation
    "Orientation object defining rotation from a frame 1 into a frame 2"

    import SI = Modelica.SIunits;
    extends Modelica.Icons.Record;
    Real T[3, 3] "Transformation matrix from world frame to local frame";
    SI.AngularVelocity w[3]
      "Absolute angular velocity of local frame, resolved in local frame";

    encapsulated function equalityConstraint
      "Return the constraint residues to express that two frames have the same orientation"

      import Modelica;
      import Modelica.Mechanics.MultiBody.Frames;
      extends Modelica.Icons.Function;
      input Frames.Orientation R1
        "Orientation object to rotate frame 0 into frame 1";
      input Frames.Orientation R2
        "Orientation object to rotate frame 0 into frame 2";
      output Real residue[3]
        "The rotation angles around x-, y-, and z-axis of frame 1 to rotate frame 1 into frame 2 for a small rotation (should be zero)";
    algorithm
      residue := {
         Modelica.Math.atan2(cross(R1.T[1, :], R1.T[2, :])*R2.T[2, :],R1.T[1,:]*R2.T[1,:]),
         Modelica.Math.atan2(-cross(R1.T[1, :],R1.T[2, :])*R2.T[1, :],R1.T[2,:]*R2.T[2,:]),
         Modelica.Math.atan2(R1.T[2, :]*R2.T[1, :],R1.T[3,:]*R2.T[3,:])};
      annotation(Inline=true);
    end equalityConstraint;

    annotation (Documentation(info="<html>
<p>
This object describes the <b>rotation</b> from a <b>frame 1</b> into a <b>frame 2</b>.
An instance of this type should never be directly accessed but
only with the access functions provided
in package Modelica.Mechanics.MultiBody.Frames. As a consequence, it is not necessary to know
the internal representation of this object as described in the next paragraphs.
</p>
<p>
\"Orientation\" is defined to be a record consisting of two
elements: \"Real T[3,3]\", the transformation matrix to rotate frame 1
into frame 2 and \"Real w[3]\", the angular velocity of frame 2 with
respect to frame 1, resolved in frame 2. Element \"T\"
has the following interpretation:
</p>
<pre>
   Orientation R;
   <b>R.T</b> = [<b>e</b><sub>x</sub>, <b>e</b><sub>y</sub>, <b>e</b><sub>z</sub>];
       e.g., <b>R.T</b> = [1,0,0; 0,1,0; 0,0,1]
</pre>
<p>
where <b>e</b><sub>x</sub>,<b>e</b><sub>y</sub>,<b>e</b><sub>z</sub>
are unit vectors in the direction of the x-axis, y-axis, and z-axis
of frame 1, resolved in frame 2, respectively. Therefore, if <b>v</b><sub>1</sub>
is vector <b>v</b> resolved in frame 1 and <b>v</b><sub>2</sub> is
vector <b>v</b> resolved in frame 2, the following relationship holds:
</p>
<pre>
    <b>v</b><sub>2</sub> = <b>R.T</b> * <b>v</b><sub>1</sub>
</pre>
</p>
The <b>inverse</b> orientation
<b>R_inv.T</b> = <b>R.T</b><sup>T</sup> describes the rotation
from frame 2 into frame 1.
</p>
<p>
Since the orientation is described by 9 variables, there are
6 constraints between these variables. These constraints
are defined in function <b>Frames.orientationConstraint</b>.
</p>
<p>
R.w is the angular velocity of frame 2 with respect to frame 1, resolved
in frame 2. Formally, R.w is defined as:<br>
<b>skew</b>(R.w) = R.T*<b>der</b>(transpose(R.T))
with
</p>
<pre>
             |   0   -w[3]  w[2] |
   <b>skew</b>(w) = |  w[3]   0   -w[1] |
             | -w[2]  w[1]     0 |
</pre>

</html>
"));

  end Orientation;

  function orientationConstraint
    "Return residues of orientation constraints (shall be zero)"
    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    output Real residue[6]
      "Residues of constraints between elements of orientation object (shall be zero)";
  algorithm
    residue := {R.T[:, 1]*R.T[:, 1] - 1,R.T[:, 2]*R.T[:, 2] - 1,R.T[:, 3]*R.T[:,
       3] - 1,R.T[:, 1]*R.T[:, 2],R.T[:, 1]*R.T[:, 3],R.T[:, 2]*R.T[:, 3]};
    annotation(Inline=true);
  end orientationConstraint;

  function angularVelocity1
    "Return angular velocity resolved in frame 1 from orientation object"

    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    output Modelica.SIunits.AngularVelocity w[3]
      "Angular velocity of frame 2 with respect to frame 1 resolved in frame 1";
  algorithm
    w := resolve1(R, R.w);
    annotation(Inline=true);
  end angularVelocity1;

  function angularVelocity2
    "Return angular velocity resolved in frame 2 from orientation object"

    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    output Modelica.SIunits.AngularVelocity w[3]
      "Angular velocity of frame 2 with respect to frame 1 resolved in frame 2";
  algorithm
    w := R.w;
    annotation(Inline=true);
  end angularVelocity2;

  function resolve1 "Transform vector from frame 2 to frame 1"
    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    input Real v2[3] "Vector in frame 2";
    output Real v1[3] "Vector in frame 1";
  algorithm
    v1 := transpose(R.T)*v2;
    annotation (derivative(noDerivative=R) = Internal.resolve1_der,
        __Dymola_InlineAfterIndexReduction=true);
  end resolve1;

  function resolve2 "Transform vector from frame 1 to frame 2"
    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    input Real v1[3] "Vector in frame 1";
    output Real v2[3] "Vector in frame 2";
  algorithm
    v2 := R.T*v1;
    annotation (derivative(noDerivative=R) = Internal.resolve2_der,
        __Dymola_InlineAfterIndexReduction=true);
  end resolve2;

  function resolveRelative
    "Transform vector from frame 1 to frame 2 using absolute orientation objects of frame 1 and of frame 2"

    extends Modelica.Icons.Function;
    input Real v1[3] "Vector in frame 1";
    input Orientation R1 "Orientation object to rotate frame 0 into frame 1";
    input Orientation R2 "Orientation object to rotate frame 0 into frame 2";
    output Real v2[3] "Vector in frame 2";
  algorithm
    v2 := resolve2(R2, resolve1(R1, v1));
    annotation (derivative(noDerivative=R1, noDerivative=R2) = Internal.resolveRelative_der,
        __Dymola_InlineAfterIndexReduction=true);
  end resolveRelative;

  function resolveDyade1
    "Transform second order tensor from frame 2 to frame 1"
    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    input Real D2[3, 3] "Second order tensor resolved in frame 2";
    output Real D1[3, 3] "Second order tensor resolved in frame 1";
  algorithm
    D1 := transpose(R.T)*D2*R.T;
    annotation(Inline=true);
  end resolveDyade1;

  function resolveDyade2
    "Transform second order tensor from frame 1 to frame 2"
    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    input Real D1[3, 3] "Second order tensor resolved in frame 1";
    output Real D2[3, 3] "Second order tensor resolved in frame 2";
  algorithm
    D2 := R.T*D1*transpose(R.T);
    annotation(Inline=true);
  end resolveDyade2;

  function nullRotation
    "Return orientation object that does not rotate a frame"
    extends Modelica.Icons.Function;
    output Orientation R
      "Orientation object such that frame 1 and frame 2 are identical";
  algorithm
    R := Orientation(T=identity(3),w= zeros(3));
    annotation(Inline=true);
  end nullRotation;

  function inverseRotation "Return inverse orientation object"
    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    output Orientation R_inv
      "Orientation object to rotate frame 2 into frame 1";
  algorithm
    R_inv := Orientation(T=transpose(R.T),w= -resolve1(R, R.w));
    annotation(Inline=true);
  end inverseRotation;

  function relativeRotation "Return relative orientation object"
    extends Modelica.Icons.Function;
    input Orientation R1 "Orientation object to rotate frame 0 into frame 1";
    input Orientation R2 "Orientation object to rotate frame 0 into frame 2";
    output Orientation R_rel
      "Orientation object to rotate frame 1 into frame 2";
  algorithm
    R_rel := Orientation(T=R2.T*transpose(R1.T),w= R2.w - resolve2(R2, resolve1(
       R1, R1.w)));
    annotation(Inline=true);
  end relativeRotation;

  function absoluteRotation
    "Return absolute orientation object from another absolute and a relative orientation object"

    extends Modelica.Icons.Function;
    input Orientation R1 "Orientation object to rotate frame 0 into frame 1";
    input Orientation R_rel "Orientation object to rotate frame 1 into frame 2";
    output Orientation R2 "Orientation object to rotate frame 0 into frame 2";
  algorithm
    R2 := Orientation(T=R_rel.T*R1.T,w= resolve2(R_rel, R1.w) + R_rel.w);
    annotation(Inline=true);
  end absoluteRotation;

  function planarRotation "Return orientation object of a planar rotation"
    import Modelica.Math;
    extends Modelica.Icons.Function;
    input Real e[3](each final unit="1")
      "Normalized axis of rotation (must have length=1)";
    input Modelica.SIunits.Angle angle
      "Rotation angle to rotate frame 1 into frame 2 along axis e";
    input Modelica.SIunits.AngularVelocity der_angle "= der(angle)";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";
  algorithm
    R := Orientation(T=[e]*transpose([e]) + (identity(3) - [e]*transpose([e]))*
      Math.cos(angle) - skew(e)*Math.sin(angle),w= e*der_angle);

    annotation(Inline=true);
  end planarRotation;

  function planarRotationAngle
    "Return angle of a planar rotation, given the rotation axis and the representations of a vector in frame 1 and frame 2"

    extends Modelica.Icons.Function;
    input Real e[3](each final unit="1")
      "Normalized axis of rotation to rotate frame 1 around e into frame 2 (must have length=1)";
    input Real v1[3]
      "A vector v resolved in frame 1 (shall not be parallel to e)";
    input Real v2[3]
      "Vector v resolved in frame 2, i.e., v2 = resolve2(planarRotation(e,angle),v1)";
    output Modelica.SIunits.Angle angle
      "Rotation angle to rotate frame 1 into frame 2 along axis e in the range: -pi <= angle <= pi";
  algorithm
    /* Vector v is resolved in frame 1 and frame 2 according to:
        (1)  v2 = (e*transpose(e) + (identity(3) - e*transpose(e))*cos(angle) - skew(e)*sin(angle))*v1;
                = e*(e*v1) + (v1 - e*(e*v1))*cos(angle) - cross(e,v1)*sin(angle)
       Equation (1) is multiplied with "v1" resulting in (note: e*e = 1)
            v1*v2 = (e*v1)*(e*v2) + (v1*v1 - (e*v1)*(e*v1))*cos(angle)
       and therefore:
        (2) cos(angle) = ( v1*v2 - (e*v1)*(e*v2)) / (v1*v1 - (e*v1)*(e*v1))
       Similiarly, equation (1) is multiplied with cross(e,v1), i.e., a
       a vector that is orthogonal to e and to v1:
              cross(e,v1)*v2 = - cross(e,v1)*cross(e,v1)*sin(angle)
       and therefore:
          (3) sin(angle) = -cross(e,v1)*v2/(cross(e,v1)*cross(e,v1));
       We have e*e=1; Therefore:
          (4) v1*v1 - (e*v1)*(e*v1) = |v1|^2 - (|v1|*cos(e,v1))^2
       and
          (5) cross(e,v1)*cross(e,v1) = (|v1|*sin(e,v1))^2
                                      = |v1|^2*(1 - cos(e,v1)^2)
                                      = |v1|^2 - (|v1|*cos(e,v1))^2
       The denominators of (2) and (3) are identical, according to (4) and (5).
       Furthermore, the denominators are always positive according to (5).
       Therefore, in the equation "angle = atan2(sin(angle), cos(angle))" the
       denominators of sin(angle) and cos(angle) can be removed,
       resulting in:
          angle = atan2(-cross(e,v1)*v2, v1*v2 - (e*v1)*(e*v2));
    */
    angle := Modelica.Math.atan2(-cross(e, v1)*v2, v1*v2 - (e*v1)*(e*v2));
    annotation (Inline=true, Documentation(info="<HTML>
<p>
A call to this function of the form
</p>
<pre>
    Real[3]                e, v1, v2;
    Modelica.SIunits.Angle angle;
  <b>equation</b>
    angle = <b>planarRotationAngle</b>(e, v1, v2);
</pre>
<p>
computes the rotation angle \"<b>angle</b>\" of a planar
rotation along unit vector <b>e</b>, rotating frame 1 into frame 2, given
the coordinate representations of a vector \"v\" in frame 1 (<b>v1</b>)
and in frame 2 (<b>v2</b>). Therefore, the result of this function
fulfills the following equation:
</p>
<pre>
    v2 = <b>resolve2</b>(<b>planarRotation</b>(e,angle), v1)
</pre>
<p>
The rotation angle is returned in the range
</p>
<pre>
    -<font face=\"Symbol\">p</font> &lt;= angle &lt;= <font face=\"Symbol\">p</font>
</pre>
<p>
This function makes the following assumptions on the input arguments
</p>
<ul>
<li> Vector <b>e</b> has length 1, i.e., length(e) = 1</li>
<li> Vector \"v\" is not parallel to <b>e</b>, i.e.,
     length(cross(e,v1)) &ne; 0</li>
</ul>
<p>
The function does not check the above assumptions. If these
assumptions are violated, a wrong result will be returned
and/or a division by zero will occur.
</p>
</HTML>"));
  end planarRotationAngle;

  function axisRotation
    "Return rotation object to rotate around an angle along one frame axis"

    import Modelica.Math.*;
    extends Modelica.Icons.Function;
    input Integer axis(min=1, max=3) "Rotate around 'axis' of frame 1";
    input Modelica.SIunits.Angle angle
      "Rotation angle to rotate frame 1 into frame 2 along 'axis' of frame 1";
    input Modelica.SIunits.AngularVelocity der_angle "= der(angle)";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";
  algorithm
    R := Orientation(T=(if axis == 1 then [1, 0, 0; 0, cos(angle), sin(angle);
      0, -sin(angle), cos(angle)] else if axis == 2 then [cos(angle), 0, -sin(
      angle); 0, 1, 0; sin(angle), 0, cos(angle)] else [cos(angle), sin(angle),
       0; -sin(angle), cos(angle), 0; 0, 0, 1]),w= if axis == 1 then {der_angle,
      0,0} else if axis == 2 then {0,der_angle,0} else {0,0,der_angle});
    annotation(Inline=true);
  end axisRotation;

  function axesRotations
    "Return fixed rotation object to rotate in sequence around fixed angles along 3 axes"

    import TM = Modelica.Mechanics.MultiBody.Frames.TransformationMatrices;
    extends Modelica.Icons.Function;
    input Integer sequence[3](
      min={1,1,1},
      max={3,3,3}) = {1,2,3}
      "Sequence of rotations from frame 1 to frame 2 along axis sequence[i]";
    input Modelica.SIunits.Angle angles[3]
      "Rotation angles around the axes defined in 'sequence'";
    input Modelica.SIunits.AngularVelocity der_angles[3] "= der(angles)";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";
  algorithm
    /*
  R := absoluteRotation(absoluteRotation(axisRotation(sequence[1], angles[1],
    der_angles[1]), axisRotation(sequence[2], angles[2], der_angles[2])),
    axisRotation(sequence[3], angles[3], der_angles[3]));
*/
    R := Orientation(T=TM.axisRotation(sequence[3], angles[3])*TM.axisRotation(
      sequence[2], angles[2])*TM.axisRotation(sequence[1], angles[1]),w=
      Frames.axis(sequence[3])*der_angles[3] + TM.resolve2(TM.axisRotation(
      sequence[3], angles[3]), Frames.axis(sequence[2])*der_angles[2]) +
      TM.resolve2(TM.axisRotation(sequence[3], angles[3])*TM.axisRotation(
      sequence[2], angles[2]), Frames.axis(sequence[1])*der_angles[1]));
    annotation(Inline=true);
  end axesRotations;

  function axesRotationsAngles
    "Return the 3 angles to rotate in sequence around 3 axes to construct the given orientation object"

    import SI = Modelica.SIunits;

    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    input Integer sequence[3](
      min={1,1,1},
      max={3,3,3}) = {1,2,3}
      "Sequence of rotations from frame 1 to frame 2 along axis sequence[i]";
    input SI.Angle guessAngle1=0
      "Select angles[1] such that |angles[1] - guessAngle1| is a minimum";
    output SI.Angle angles[3]
      "Rotation angles around the axes defined in 'sequence' such that R=Frames.axesRotation(sequence,angles); -pi < angles[i] <= pi";
  protected
    Real e1_1[3](each final unit="1")
      "First rotation axis, resolved in frame 1";
    Real e2_1a[3](each final unit="1")
      "Second rotation axis, resolved in frame 1a";
    Real e3_1[3](each final unit="1")
      "Third rotation axis, resolved in frame 1";
    Real e3_2[3](each final unit="1")
      "Third rotation axis, resolved in frame 2";
    Real A
      "Coefficient A in the equation A*cos(angles[1])+B*sin(angles[1]) = 0";
    Real B
      "Coefficient B in the equation A*cos(angles[1])+B*sin(angles[1]) = 0";
    SI.Angle angle_1a "Solution 1 for angles[1]";
    SI.Angle angle_1b "Solution 2 for angles[1]";
    TransformationMatrices.Orientation T_1a
      "Orientation object to rotate frame 1 into frame 1a";
  algorithm
    /* The rotation object R is constructed by:
     (1) Rotating frame 1 along axis e1 (= axis sequence[1]) with angles[1]
         arriving at frame 1a.
     (2) Rotating frame 1a along axis e2 (= axis sequence[2]) with angles[2]
         arriving at frame 1b.
     (3) Rotating frame 1b along axis e3 (= axis sequence[3]) with angles[3]
         arriving at frame 2.
     The goal is to determine angles[1:3]. This is performed in the following way:
     1. e2 and e3 are perpendicular to each other, i.e., e2*e3 = 0;
        Both vectors are resolved in frame 1 (T_ij is transformation matrix
        from frame j to frame i; e1_1*e2_1a = 0, since the vectors are
        perpendicular to each other):
           e3_1 = T_12*e3_2
                = R[sequence[3],:];
           e2_1 = T_11a*e2_1a
                = ( e1_1*transpose(e1_1) + (identity(3) - e1_1*transpose(e1_1))*cos(angles[1])
                    + skew(e1_1)*sin(angles[1]) )*e2_1a
                = e2_1a*cos(angles[1]) + cross(e1_1, e2_1a)*sin(angles[1]);
        From this follows finally an equation for angles[1]
           e2_1*e3_1 = 0
                     = (e2_1a*cos(angles[1]) + cross(e1_1, e2_1a)*sin(angles[1]))*e3_1
                     = (e2_1a*e3_1)*cos(angles[1]) + cross(e1_1, e2_1a)*e3_1*sin(angles[1])
                     = A*cos(angles[1]) + B*sin(angles[1])
                       with A = e2_1a*e3_1, B = cross(e1_1, e2_1a)*e3_1
        This equation has two solutions in the range -pi < angles[1] <= pi:
           sin(angles[1]) =  k*A/sqrt(A*A + B*B)
           cos(angles[1]) = -k*B/sqrt(A*A + B*B)
                        k = +/-1
           tan(angles[1]) = k*A/(-k*B)
        that is:
           angles[1] = atan2(k*A, -k*B)
        If A and B are both zero at the same time, there is a singular configuration
        resulting in an infinite number of solutions for angles[1] (every value
        is possible).
     2. angles[2] is determined with function Frames.planarRotationAngle.
        This function requires to provide e_3 in frame 1a and in frame 1b:
          e3_1a = Frames.resolve2(planarRotation(e1_1,angles[1]), e3_1);
          e3_1b = e3_2
     3. angles[3] is determined with function Frames.planarRotationAngle.
        This function requires to provide e_2 in frame 1b and in frame 2:
          e2_1b = e2_1a
          e2_2  = Frames.resolve2( R, Frames.resolve1(planarRotation(e1_1,angles[1]), e2_1a));
  */
    assert(sequence[1] <> sequence[2] and sequence[2] <> sequence[3],
      "input argument 'sequence[1:3]' is not valid");
    e1_1 := if sequence[1] == 1 then {1,0,0} else if sequence[1] == 2 then {0,1,
      0} else {0,0,1};
    e2_1a := if sequence[2] == 1 then {1,0,0} else if sequence[2] == 2 then {0,
      1,0} else {0,0,1};
    e3_1 := R.T[sequence[3], :];
    e3_2 := if sequence[3] == 1 then {1,0,0} else if sequence[3] == 2 then {0,1,
      0} else {0,0,1};

    A := e2_1a*e3_1;
    B := cross(e1_1, e2_1a)*e3_1;
    if abs(A) <= 1.e-12 and abs(B) <= 1.e-12 then
      angles[1] := guessAngle1;
    else
      angle_1a := Modelica.Math.atan2(A, -B);
      angle_1b := Modelica.Math.atan2(-A, B);
      angles[1] := if abs(angle_1a - guessAngle1) <= abs(angle_1b - guessAngle1) then 
              angle_1a else angle_1b;
    end if;
    T_1a := TransformationMatrices.planarRotation(e1_1, angles[1]);
    angles[2] := planarRotationAngle(e2_1a, TransformationMatrices.resolve2(
      T_1a, e3_1), e3_2);
    angles[3] := planarRotationAngle(e3_2, e2_1a,
      TransformationMatrices.resolve2(R.T, TransformationMatrices.resolve1(T_1a,
       e2_1a)));

    annotation (Documentation(info="<HTML>
<p>
A call to this function of the form
</p>
<pre>
    Frames.Orientation     R;
    <b>parameter</b> Integer      sequence[3] = {1,2,3};
    Modelica.SIunits.Angle angles[3];
  <b>equation</b>
    angle = <b>axesRotationAngles</b>(R, sequence);
</pre>
<p>
computes the rotation angles \"<b>angles</b>[1:3]\" to rotate frame 1
into frame 2 along axes <b>sequence</b>[1:3], given the orientation
object <b>R</b> from frame 1 to frame 2. Therefore, the result of
this function fulfills the following equation:
</p>
<pre>
    R = <b>axesRotation</b>(sequence, angles)
</pre>
<p>
The rotation angles are returned in the range
</p>
<pre>
    -<font face=\"Symbol\">p</font> &lt;= angles[i] &lt;= <font face=\"Symbol\">p</font>
</pre>
<p>
There are <b>two solutions</b> for \"angles[1]\" in this range.
Via the third argument <b>guessAngle1</b> (default = 0) the
returned solution is selected such that |angles[1] - guessAngle1| is
minimal. The orientation object R may be in a singular configuration, i.e.,
there is an infinite number of angle values leading to the same R. The returned solution is
selected by setting angles[1] = guessAngle1. Then angles[2]
and angles[3] can be uniquely determined in the above range.
</p>
<p>
Note, that input argument <b>sequence</b> has the restriction that
only values 1,2,3 can be used and that sequence[1] &ne; sequence[2]
and sequence[2] &ne; sequence[3]. Often used values are:
</p>
<pre>
  sequence = <b>{1,2,3}</b>  // Cardan angle sequence
           = <b>{3,1,3}</b>  // Euler angle sequence
           = <b>{3,2,1}</b>  // Tait-Bryan angle sequence
</pre>
</HTML>"));
  end axesRotationsAngles;

  function smallRotation
    "Return rotation angles valid for a small rotation and optionally residues that should be zero"

    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    input Boolean withResidues=false
      "= false/true, if 'angles'/'angles and residues' are returned in phi";
    output Modelica.SIunits.Angle phi[if withResidues then 6 else 3]
      "The rotation angles around x-, y-, and z-axis of frame 1 to rotate frame 1 into frame 2 for a small rotation + optionally 3 residues that should be zero";
  algorithm
    /* Planar rotation:
       Trel = [e]*transpose([e]) + (identity(3) - [e]*transpose([e]))*cos(angle) - skew(e)*sin(angle)
            = identity(3) - skew(e)*angle, for small angles
            = identity(3) - skew(e*angle)
               define phi = e*angle, then
       Trel = [1,      phi3,   -phi2;
               -phi3,     1,    phi1;
                phi2, -phi1,       1 ];
  */
    phi := if withResidues then {R.T[2, 3],-R.T[1, 3],R.T[1, 2],R.T[1, 1] - 1,R.
       T[2, 2] - 1,R.T[1, 1]*R.T[2, 2] - R.T[2, 1]*R.T[1, 2] - 1} else {R.T[2,
      3],-R.T[1, 3],R.T[1, 2]};
    annotation(Inline=true);
  end smallRotation;

  function from_nxy "Return fixed orientation object from n_x and n_y vectors"
    extends Modelica.Icons.Function;
    input Real n_x[3](each final unit="1")
      "Vector in direction of x-axis of frame 2, resolved in frame 1";
    input Real n_y[3](each final unit="1")
      "Vector in direction of y-axis of frame 2, resolved in frame 1";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";
  protected
    Real abs_n_x=sqrt(n_x*n_x);
    Real e_x[3](each final unit="1")=if abs_n_x < 1.e-10 then {1,0,0} else n_x/abs_n_x;
    Real n_z_aux[3](each final unit="1")=cross(e_x, n_y);
    Real n_y_aux[3](each final unit="1")=if n_z_aux*n_z_aux > 1.0e-6 then n_y else (if abs(e_x[1])
         > 1.0e-6 then {0,1,0} else {1,0,0});
    Real e_z_aux[3](each final unit="1")=cross(e_x, n_y_aux);
    Real e_z[3](each final unit="1")=e_z_aux/sqrt(e_z_aux*e_z_aux);
  algorithm
    R := Orientation(T={e_x,cross(e_z, e_x),e_z},w= zeros(3));
    annotation (Documentation(info="<html>
<p>
It is assumed that the two input vectors n_x and n_y are
resolved in frame 1 and are directed along the x and y axis
of frame 2 (i.e., n_x and n_y are orthogonal to each other)
The function returns the orientation object R to rotate from
frame 1 to frame 2.
</p>
<p>
The function is robust in the sense that it returns always
an orientation object R, even if n_y is not orthogonal to n_x.
This is performed in the following way:
</p>
<p>
If n_x and n_y are not orthogonal to each other, first a unit
vector e_y is determined that is orthogonal to n_x and is lying
in the plane spanned by n_x and n_y. If n_x and n_y are parallel
or nearly parallel to each other, a vector e_y is selected
arbitrarily such that e_x and e_y are orthogonal to each other.
</p>
</html>"));
  end from_nxy;

  function from_nxz "Return fixed orientation object from n_x and n_z vectors"
    extends Modelica.Icons.Function;
    input Real n_x[3](each final unit="1")
      "Vector in direction of x-axis of frame 2, resolved in frame 1";
    input Real n_z[3](each final unit="1")
      "Vector in direction of z-axis of frame 2, resolved in frame 1";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";
  protected
    Real abs_n_x=sqrt(n_x*n_x);
    Real e_x[3](each final unit="1")=if abs_n_x < 1.e-10 then {1,0,0} else n_x/abs_n_x;
    Real n_y_aux[3](each final unit="1")=cross(n_z, e_x);
    Real n_z_aux[3](each final unit="1")=if n_y_aux*n_y_aux > 1.0e-6 then n_z else (if abs(e_x[1])
         > 1.0e-6 then {0,0,1} else {1,0,0});
    Real e_y_aux[3](each final unit="1")=cross(n_z_aux, e_x);
    Real e_y[3](each final unit="1")=e_y_aux/sqrt(e_y_aux*e_y_aux);
  algorithm
    R := Orientation(T={e_x,e_y,cross(e_x, e_y)},w= zeros(3));
    annotation (Documentation(info="<html>
<p>
It is assumed that the two input vectors n_x and n_z are
resolved in frame 1 and are directed along the x and z axis
of frame 2 (i.e., n_x and n_z are orthogonal to each other)
The function returns the orientation object R to rotate from
frame 1 to frame 2.
</p>
<p>
The function is robust in the sense that it returns always
an orientation object R, even if n_z is not orthogonal to n_x.
This is performed in the following way:
</p>
<p>
If n_x and n_z are not orthogonal to each other, first a unit
vector e_z is determined that is orthogonal to n_x and is lying
in the plane spanned by n_x and n_z. If n_x and n_z are parallel
or nearly parallel to each other, a vector e_z is selected
arbitrarily such that n_x and e_z are orthogonal to each other.
</p>
</html>"));
  end from_nxz;

  function from_T "Return orientation object R from transformation matrix T"
    extends Modelica.Icons.Function;
    input Real T[3, 3]
      "Transformation matrix to transform vector from frame 1 to frame 2 (v2=T*v1)";
    input Modelica.SIunits.AngularVelocity w[3]
      "Angular velocity from frame 2 with respect to frame 1, resolved in frame 2 (skew(w)=T*der(transpose(T)))";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";
  algorithm
    R := Orientation(T=T,w= w);
    annotation(Inline=true);
  end from_T;

  function from_T2
    "Return orientation object R from transformation matrix T and its derivative der(T)"
    extends Modelica.Icons.Function;
    input Real T[3, 3]
      "Transformation matrix to transform vector from frame 1 to frame 2 (v2=T*v1)";
    input Real der_T[3,3] "= der(T)";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";

  algorithm
    R := Orientation(T=T,w={T[3, :]*der_T[2, :],-T[3, :]*der_T[1, :],T[2, :]*der_T[1, :]});
    annotation (Inline=true,Documentation(info="<html>
<p>
Computes the orientation object from a transformation matrix T and
the derivative der(T) of the transformation matrix.
Usually, it is more efficient to use function \"from_T\" instead, where
the angular velocity has to be given as input argument. Only if this
is not possible or too difficult to compute, use function from_T2(..).
</p>
</html>"));
  end from_T2;

  function from_T_inv
    "Return orientation object R from inverse transformation matrix T_inv"

    extends Modelica.Icons.Function;
    input Real T_inv[3, 3]
      "Inverse transformation matrix to transform vector from frame 2 to frame 1 (v1=T_inv*v2)";
    input Modelica.SIunits.AngularVelocity w[3]
      "Angular velocity from frame 1 with respect to frame 2, resolved in frame 1 (skew(w)=T_inv*der(transpose(T_inv)))";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";
  algorithm
    R := Orientation(T=transpose(T_inv),w= -w);
    annotation(Inline=true);
  end from_T_inv;

  function from_Q
    "Return orientation object R from quaternion orientation object Q"

    extends Modelica.Icons.Function;
    input Quaternions.Orientation Q
      "Quaternions orientation object to rotate frame 1 into frame 2";
    input Modelica.SIunits.AngularVelocity w[3]
      "Angular velocity from frame 2 with respect to frame 1, resolved in frame 2";
    output Orientation R "Orientation object to rotate frame 1 into frame 2";
  algorithm
    /*
  T := (2*Q[4]*Q[4] - 1)*identity(3) + 2*([Q[1:3]]*transpose([Q[1:3]]) - Q[4]*
    skew(Q[1:3]));
*/
    R := Orientation([2*(Q[1]*Q[1] + Q[4]*Q[4]) - 1, 2*(Q[1]*Q[2] + Q[3]*Q[4]),
       2*(Q[1]*Q[3] - Q[2]*Q[4]); 2*(Q[2]*Q[1] - Q[3]*Q[4]), 2*(Q[2]*Q[2] + Q[4]
      *Q[4]) - 1, 2*(Q[2]*Q[3] + Q[1]*Q[4]); 2*(Q[3]*Q[1] + Q[2]*Q[4]), 2*(Q[3]
      *Q[2] - Q[1]*Q[4]), 2*(Q[3]*Q[3] + Q[4]*Q[4]) - 1],w= w);
    annotation(Inline=true);
  end from_Q;

  function to_T "Return transformation matrix T from orientation object R"
    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    output Real T[3, 3]
      "Transformation matrix to transform vector from frame 1 to frame 2 (v2=T*v1)";
  algorithm
    T := R.T;
    annotation(Inline=true);
  end to_T;

  function to_T_inv
    "Return inverse transformation matrix T_inv from orientation object R"

    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    output Real T_inv[3, 3]
      "Inverse transformation matrix to transform vector from frame 2 into frame 1 (v1=T_inv*v2)";
  algorithm
    T_inv := transpose(R.T);
    annotation(Inline=true);
  end to_T_inv;

  function to_Q
    "Return quaternion orientation object Q from orientation object R"

    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    input Quaternions.Orientation Q_guess=Quaternions.nullRotation()
      "Guess value for output Q (there are 2 solutions; the one closer to Q_guess is used";
    output Quaternions.Orientation Q
      "Quaternions orientation object to rotate frame 1 into frame 2";
  algorithm
    Q := Quaternions.from_T(R.T, Q_guess);
    annotation(Inline=true);
  end to_Q;

  function to_vector "Map rotation object into vector"
    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    output Real vec[9] "Elements of R in one vector";
  algorithm
    vec := {R.T[1, 1],R.T[2, 1],R.T[3, 1],R.T[1, 2],R.T[2, 2],R.T[3, 2],R.T[1,
      3],R.T[2, 3],R.T[3, 3]};
    annotation(Inline=true);
  end to_vector;

  function to_exy
    "Map rotation object into e_x and e_y vectors of frame 2, resolved in frame 1"

    extends Modelica.Icons.Function;
    input Orientation R "Orientation object to rotate frame 1 into frame 2";
    output Real exy[3, 2]
      "= [e_x, e_y] where e_x and e_y are axes unit vectors of frame 2, resolved in frame 1";
  algorithm
    exy := [R.T[1, :], R.T[2, :]];
    annotation(Inline=true);
  end to_exy;

  function axis "Return unit vector for x-, y-, or z-axis"
    extends Modelica.Icons.Function;
    input Integer axis(min=1, max=3) "Axis vector to be returned";
    output Real e[3](each final unit="1") "Unit axis vector";
  algorithm
    e := if axis == 1 then {1,0,0} else (if axis == 2 then {0,1,0} else {0,0,1});
    annotation(Inline=true);
  end axis;

  package Quaternions
    "Functions to transform rotational frame quantities based on quaternions (also called Euler parameters)"
    extends Modelica.Icons.Library;

    type Orientation
      "Orientation type defining rotation from a frame 1 into a frame 2 with quaternions {p1,p2,p3,p0}"

      extends Internal.QuaternionBase;

      encapsulated function equalityConstraint
        "Return the constraint residues to express that two frames have the same quaternion orientation"

        import Modelica;
        import Modelica.Mechanics.MultiBody.Frames.Quaternions;
        extends Modelica.Icons.Function;
        input Quaternions.Orientation Q1
          "Quaternions orientation object to rotate frame 0 into frame 1";
        input Quaternions.Orientation Q2
          "Quaternions orientation object to rotate frame 0 into frame 2";
        output Real residue[3]
          "The half of the rotation angles around x-, y-, and z-axis of frame 1 to rotate frame 1 into frame 2 for a small rotation (shall be zero)";
      algorithm
        residue := [Q1[4], Q1[3], -Q1[2], -Q1[1]; -Q1[3], Q1[4], Q1[1], -Q1[2];
           Q1[2], -Q1[1], Q1[4], -Q1[3]]*Q2;
        annotation(Inline=true);
      end equalityConstraint;

      annotation ( Documentation(info="<html>
<p>
This type describes the <b>rotation</b> to rotate a frame 1 into
a frame 2 using quaternions (also called <b>Euler parameters</b>)
according to the following definition:
</p>
<pre>
   Quaternions.Orientation Q;
   Real  n[3];
   Real  phi(unit=\"rad\");
   Q = [ n*sin(phi/2)
           cos(phi/2) ]
</pre>
<p>
where \"n\" is the <b>axis of rotation</b> to rotate frame 1 into
frame 2 and \"phi\" is the <b>rotation angle</b> for this rotation.
Vector \"n\" is either resolved in frame 1 or in frame 2
(the result is the same since the coordinates of \"n\" with respect to
frame 1 are identical to its coordinates with respect to frame 2).
<p>
<p>
The term \"quaternions\" is prefered over the historically
more reasonable \"Euler parameters\" in order to not get
confused with Modelica \"parameters\".
</p>
</html>
"));
    end Orientation;

    type der_Orientation = Real[4] (each unit="1/s")
      "First time derivative of Quaternions.Orientation";

    function orientationConstraint
      "Return residues of orientation constraints (shall be zero)"
      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      output Real residue[1] "Residue constraint (shall be zero)";
    algorithm
      residue := {Q*Q - 1};
      annotation(Inline=true);
    end orientationConstraint;

    function angularVelocity1
      "Compute angular velocity resolved in frame 1 from quaternion orientation object and its derivative"

      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      input der_Orientation der_Q "Derivative of Q";
      output Modelica.SIunits.AngularVelocity w[3]
        "Angular velocity resolved in frame 1";
    algorithm
      w := 2*([Q[4], -Q[3], Q[2], -Q[1]; Q[3], Q[4], -Q[1], -Q[2]; -Q[2], Q[1],
         Q[4], -Q[3]]*der_Q);
      annotation(Inline=true);
    end angularVelocity1;

    function angularVelocity2
      "Compute angular velocity resolved in frame 2 from quaternions orientation object and its derivative"

      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      input der_Orientation der_Q "Derivative of Q";
      output Modelica.SIunits.AngularVelocity w[3]
        "Angular velocity of frame 2 with respect to frame 1 resolved in frame 2";
    algorithm
      w := 2*([Q[4], Q[3], -Q[2], -Q[1]; -Q[3], Q[4], Q[1], -Q[2]; Q[2], -Q[1],
         Q[4], -Q[3]]*der_Q);
      annotation(Inline=true);
    end angularVelocity2;

    function resolve1 "Transform vector from frame 2 to frame 1"
      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      input Real v2[3] "Vector in frame 2";
      output Real v1[3] "Vector in frame 1";
    algorithm
      v1 := 2*((Q[4]*Q[4] - 0.5)*v2 + (Q[1:3]*v2)*Q[1:3] + Q[4]*cross(Q[1:3],
        v2));
      annotation(Inline=true);
    end resolve1;

    function resolve2 "Transform vector from frame 1 to frame 2"
      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      input Real v1[3] "Vector in frame 1";
      output Real v2[3] "Vector in frame 2";
    algorithm
      v2 := 2*((Q[4]*Q[4] - 0.5)*v1 + (Q[1:3]*v1)*Q[1:3] - Q[4]*cross(Q[1:3],
        v1));
      annotation(Inline=true);
    end resolve2;

    function multipleResolve1
      "Transform several vectors from frame 2 to frame 1"
      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      input Real v2[3, :] "Vectors in frame 2";
      output Real v1[3, size(v2, 2)] "Vectors in frame 1";
    algorithm
      v1 := ((2*Q[4]*Q[4] - 1)*identity(3) + 2*([Q[1:3]]*transpose([Q[1:3]]) +
        Q[4]*skew(Q[1:3])))*v2;
      annotation(Inline=true);
    end multipleResolve1;

    function multipleResolve2
      "Transform several vectors from frame 1 to frame 2"
      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      input Real v1[3, :] "Vectors in frame 1";
      output Real v2[3, size(v1, 2)] "Vectors in frame 2";
    algorithm
      v2 := ((2*Q[4]*Q[4] - 1)*identity(3) + 2*([Q[1:3]]*transpose([Q[1:3]]) -
        Q[4]*skew(Q[1:3])))*v1;
      annotation(Inline=true);
    end multipleResolve2;

    function nullRotation
      "Return quaternions orientation object that does not rotate a frame"

      extends Modelica.Icons.Function;
      output Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
    algorithm
      Q := {0,0,0,1};
      annotation(Inline=true);
    end nullRotation;

    function inverseRotation "Return inverse quaternions orientation object"
      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      output Quaternions.Orientation Q_inv
        "Quaternions orientation object to rotate frame 2 into frame 1";
    algorithm
      Q_inv := {-Q[1],-Q[2],-Q[3],Q[4]};
      annotation(Inline=true);
    end inverseRotation;

    function relativeRotation "Return relative quaternions orientation object"
      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q1
        "Quaternions orientation object to rotate frame 0 into frame 1";
      input Quaternions.Orientation Q2
        "Quaternions orientation object to rotate frame 0 into frame 2";
      output Quaternions.Orientation Q_rel
        "Quaternions orientation object to rotate frame 1 into frame 2";
    algorithm
      Q_rel := [Q1[4], Q1[3], -Q1[2], -Q1[1]; -Q1[3], Q1[4], Q1[1], -Q1[2]; Q1[
        2], -Q1[1], Q1[4], -Q1[3]; Q1[1], Q1[2], Q1[3], Q1[4]]*Q2;
      annotation(Inline=true);
    end relativeRotation;

    function absoluteRotation
      "Return absolute quaternions orientation object from another absolute and a relative quaternions orientation object"

      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q1
        "Quaternions orientation object to rotate frame 0 into frame 1";
      input Quaternions.Orientation Q_rel
        "Quaternions orientation object to rotate frame 1 into frame 2";
      output Quaternions.Orientation Q2
        "Quaternions orientation object to rotate frame 0 into frame 2";
    algorithm
      Q2 := [Q_rel[4], Q_rel[3], -Q_rel[2], Q_rel[1]; -Q_rel[3], Q_rel[4],
        Q_rel[1], Q_rel[2]; Q_rel[2], -Q_rel[1], Q_rel[4], Q_rel[3]; -Q_rel[1],
         -Q_rel[2], -Q_rel[3], Q_rel[4]]*Q1;
      annotation(Inline=true);
    end absoluteRotation;

    function planarRotation
      "Return quaternions orientation object of a planar rotation"
      import Modelica.Math;
      extends Modelica.Icons.Function;
      input Real e[3](each final unit="1")
        "Normalized axis of rotation (must have length=1)";
      input Modelica.SIunits.Angle angle
        "Rotation angle to rotate frame 1 into frame 2 along axis e";
      output Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2 along axis e";
    algorithm
      Q := vector([e*Math.sin(angle/2); Math.cos(angle/2)]);
      annotation(Inline=true);
    end planarRotation;

    function smallRotation "Return rotation angles valid for a small rotation"
      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      output Modelica.SIunits.Angle phi[3]
        "The rotation angles around x-, y-, and z-axis of frame 1 to rotate frame 1 into frame 2 for a small relative rotation";
    algorithm
      phi := 2*{Q[1],Q[2],Q[3]};
      annotation(Inline=true);
    end smallRotation;

    function from_T
      "Return quaternions orientation object Q from transformation matrix T"

      extends Modelica.Icons.Function;
      input Real T[3, 3]
        "Transformation matrix to transform vector from frame 1 to frame 2 (v2=T*v1)";
      input Quaternions.Orientation Q_guess=nullRotation()
        "Guess value for Q (there are 2 solutions; the one close to Q_guess is used";
      output Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2 (Q and -Q have same transformation matrix)";
    protected
      Real paux;
      Real paux4;
      Real c1;
      Real c2;
      Real c3;
      Real c4;
      constant Real p4limit=0.1;
      constant Real c4limit=4*p4limit*p4limit;
    algorithm
      /*
   Note, for quaternions, Q and -Q have the same transformation matrix.
   Calculation of quaternions from transformation matrix T:
   It is guaranteed that c1>=0, c2>=0, c3>=0, c4>=0 and
   that not all of them can be zero at the same time
   (e.g. if 3 of them are zero, the 4th variable is 1).
   Since the sqrt(..) has to be performed on one of these variables,
   it is applied on a variable which is far enough from zero.
   This guarantees that the sqrt(..) is never taken near zero
   and therefore the derivative of sqrt(..) can never be infinity.
   There is an ambiguity for quaternions, since Q and -Q
   lead to the same transformation matrix. The ambiguity
   is resolved here by selecting the Q that is closer to
   the input argument Q_guess.
*/
      c1 := 1 + T[1, 1] - T[2, 2] - T[3, 3];
      c2 := 1 + T[2, 2] - T[1, 1] - T[3, 3];
      c3 := 1 + T[3, 3] - T[1, 1] - T[2, 2];
      c4 := 1 + T[1, 1] + T[2, 2] + T[3, 3];

      if c4 > c4limit or (c4 > c1 and c4 > c2 and c4 > c3) then
        paux := sqrt(c4)/2;
        paux4 := 4*paux;
        Q := {(T[2, 3] - T[3, 2])/paux4,(T[3, 1] - T[1, 3])/paux4,(T[1, 2] - T[
          2, 1])/paux4,paux};

      elseif c1 > c2 and c1 > c3 and c1 > c4 then
        paux := sqrt(c1)/2;
        paux4 := 4*paux;
        Q := {paux,(T[1, 2] + T[2, 1])/paux4,(T[1, 3] + T[3, 1])/paux4,(T[2, 3]
           - T[3, 2])/paux4};

      elseif c2 > c1 and c2 > c3 and c2 > c4 then
        paux := sqrt(c2)/2;
        paux4 := 4*paux;
        Q := {(T[1, 2] + T[2, 1])/paux4,paux,(T[2, 3] + T[3, 2])/paux4,(T[3, 1]
           - T[1, 3])/paux4};

      else
        paux := sqrt(c3)/2;
        paux4 := 4*paux;
        Q := {(T[1, 3] + T[3, 1])/paux4,(T[2, 3] + T[3, 2])/paux4,paux,(T[1, 2]
           - T[2, 1])/paux4};
      end if;

      if Q*Q_guess < 0 then
        Q := -Q;
      end if;
    end from_T;

    function from_T_inv
      "Return quaternions orientation object Q from inverse transformation matrix T_inv"

      extends Modelica.Icons.Function;
      input Real T_inv[3, 3]
        "Inverse transformation matrix to transform vector from frame 2 to frame 1 (v1=T_inv*v2)";
      input Quaternions.Orientation Q_guess=nullRotation()
        "Guess value for output Q (there are 2 solutions; the one closer to Q_guess is used";
      output Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2 (Q and -Q have same transformation matrix)";
    algorithm
      Q := from_T(transpose(T_inv), Q_guess);
      annotation(Inline=true);
    end from_T_inv;

    function to_T
      "Return transformation matrix T from quaternion orientation object Q"

      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      output Real T[3, 3]
        "Transformation matrix to transform vector from frame 1 to frame 2 (v2=T*v1)";
    algorithm
      /*
  T := (2*Q[4]*Q[4] - 1)*identity(3) + 2*([Q[1:3]]*transpose([Q[1:3]]) - Q[4]*
    skew(Q[1:3]));
*/
      T := [2*(Q[1]*Q[1] + Q[4]*Q[4]) - 1, 2*(Q[1]*Q[2] + Q[3]*Q[4]), 2*(Q[1]*Q[
        3] - Q[2]*Q[4]); 2*(Q[2]*Q[1] - Q[3]*Q[4]), 2*(Q[2]*Q[2] + Q[4]*Q[4])
         - 1, 2*(Q[2]*Q[3] + Q[1]*Q[4]); 2*(Q[3]*Q[1] + Q[2]*Q[4]), 2*(Q[3]*Q[2]
         - Q[1]*Q[4]), 2*(Q[3]*Q[3] + Q[4]*Q[4]) - 1];
      annotation(Inline=true);
    end to_T;

    function to_T_inv
      "Return inverse transformation matrix T_inv from quaternion orientation object Q"

      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      output Real T_inv[3, 3]
        "Transformation matrix to transform vector from frame 2 to frame 1 (v1=T*v2)";
    algorithm
      /*
  T_inv := (2*Q[4]*Q[4] - 1)*identity(3) + 2*([Q[1:3]]*transpose([Q[1:3]]) + Q[
    4]*skew(Q[1:3]));
*/
      T_inv := [2*(Q[1]*Q[1] + Q[4]*Q[4]) - 1, 2*(Q[2]*Q[1] - Q[3]*Q[4]), 2*(Q[
        3]*Q[1] + Q[2]*Q[4]); 2*(Q[1]*Q[2] + Q[3]*Q[4]), 2*(Q[2]*Q[2] + Q[4]*Q[
        4]) - 1, 2*(Q[3]*Q[2] - Q[1]*Q[4]); 2*(Q[1]*Q[3] - Q[2]*Q[4]), 2*(Q[2]*
        Q[3] + Q[1]*Q[4]), 2*(Q[3]*Q[3] + Q[4]*Q[4]) - 1];
      annotation(Inline=true);
    end to_T_inv;

    annotation ( Documentation(info="<HTML>
<p>
Package <b>Frames.Quaternions</b> contains type definitions and
functions to transform rotational frame quantities with quaternions.
Functions of this package are currently only utilized in
MultiBody.Parts.Body components, when quaternions shall be used
as parts of the body states.
Some functions are also used in a new Modelica package for
B-Spline interpolation that is able to interpolate paths consisting of
position vectors and orientation objects.
</p>
<h4>Content</h4>
<p>In the table below an example is given for every function definition.
The used variables have the following declaration:
</p>
<pre>
   Quaternions.Orientation Q, Q1, Q2, Q_rel, Q_inv;
   Real[3,3]   T, T_inv;
   Real[3]     v1, v2, w1, w2, n_x, n_y, n_z, res_ori, phi;
   Real[6]     res_equal;
   Real        L, angle;
</pre>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><th><b><i>Function/type</i></b></th><th><b><i>Description</i></b></th></tr>
  <tr><td valign=\"top\"><b>Orientation Q;</b></td>
      <td valign=\"top\">New type defining a quaternion object that describes<br>
          the rotation of frame 1 into frame 2.
      </td>
  </tr>
  <tr><td valign=\"top\"><b>der_Orientation</b> der_Q;</td>
      <td valign=\"top\">New type defining the first time derivative
         of Frames.Quaternions.Orientation.
      </td>
  </tr>
  <tr><td valign=\"top\">res_ori = <b>orientationConstraint</b>(Q);</td>
      <td valign=\"top\">Return the constraints between the variables of a quaternion object<br>
      (shall be zero).</td>
  </tr>
  <tr><td valign=\"top\">w1 = <b>angularVelocity1</b>(Q, der_Q);</td>
      <td valign=\"top\">Return angular velocity resolved in frame 1 from
          quaternion object Q<br> and its derivative der_Q.
     </td>
  </tr>
  <tr><td valign=\"top\">w2 = <b>angularVelocity2</b>(Q, der_Q);</td>
      <td valign=\"top\">Return angular velocity resolved in frame 2 from
          quaternion object Q<br> and its derivative der_Q.
     </td>
  </tr>
  <tr><td valign=\"top\">v1 = <b>resolve1</b>(Q,v2);</td>
      <td valign=\"top\">Transform vector v2 from frame 2 to frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">v2 = <b>resolve2</b>(Q,v1);</td>
      <td valign=\"top\">Transform vector v1 from frame 1 to frame 2.
     </td>
  </tr>
  <tr><td valign=\"top\">[v1,w1] = <b>multipleResolve1</b>(Q, [v2,w2]);</td>
      <td valign=\"top\">Transform several vectors from frame 2 to frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">[v2,w2] = <b>multipleResolve2</b>(Q, [v1,w1]);</td>
      <td valign=\"top\">Transform several vectors from frame 1 to frame 2.
      </td>
  </tr>
  <tr><td valign=\"top\">Q = <b>nullRotation</b>()</td>
      <td valign=\"top\">Return quaternion object R that does not rotate a frame.
  </tr>
  <tr><td valign=\"top\">Q_inv = <b>inverseRotation</b>(Q);</td>
      <td valign=\"top\">Return inverse quaternion object.
      </td>
  </tr>
  <tr><td valign=\"top\">Q_rel = <b>relativeRotation</b>(Q1,Q2);</td>
      <td valign=\"top\">Return relative quaternion object from two absolute
          quaternion objects.
      </td>
  </tr>
  <tr><td valign=\"top\">Q2 = <b>absoluteRotation</b>(Q1,Q_rel);</td>
      <td valign=\"top\">Return absolute quaternion object from another
          absolute<br> and a relative quaternion object.
      </td>
  </tr>
  <tr><td valign=\"top\">Q = <b>planarRotation</b>(e, angle);</td>
      <td valign=\"top\">Return quaternion object of a planar rotation.
      </td>
  </tr>
  <tr><td valign=\"top\">phi = <b>smallRotation</b>(Q);</td>
      <td valign=\"top\">Return rotation angles phi valid for a small rotation.
      </td>
  </tr>
  <tr><td valign=\"top\">Q = <b>from_T</b>(T);</td>
      <td valign=\"top\">Return quaternion object Q from transformation matrix T.
      </td>
  </tr>
  <tr><td valign=\"top\">Q = <b>from_T_inv</b>(T_inv);</td>
      <td valign=\"top\">Return quaternion object Q from inverse transformation matrix T_inv.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>to_T</b>(Q);</td>
      <td valign=\"top\">Return transformation matrix T from quaternion object Q.
  </tr>
  <tr><td valign=\"top\">T_inv = <b>to_T_inv</b>(Q);</td>
      <td valign=\"top\">Return inverse transformation matrix T_inv from quaternion object Q.
      </td>
  </tr>
</table>
</HTML>"));
  end Quaternions;

  package TransformationMatrices "Functions for transformation matrices"
    extends Modelica.Icons.Library;
    type Orientation
      "Orientation type defining rotation from a frame 1 into a frame 2 with a transformation matrix"

      extends Internal.TransformationMatrix;

      encapsulated function equalityConstraint
        "Return the constraint residues to express that two frames have the same orientation"

        import Modelica;
        import Modelica.Mechanics.MultiBody.Frames.TransformationMatrices;
        extends Modelica.Icons.Function;
        input TransformationMatrices.Orientation T1
          "Orientation object to rotate frame 0 into frame 1";
        input TransformationMatrices.Orientation T2
          "Orientation object to rotate frame 0 into frame 2";
        output Real residue[3]
          "The rotation angles around x-, y-, and z-axis of frame 1 to rotate frame 1 into frame 2 for a small rotation (should be zero)";
      algorithm
        residue := {cross(T1[1, :], T1[2, :])*T2[2, :],-cross(T1[1, :], T1[2, :])
          *T2[1, :],T1[2, :]*T2[1, :]};
        annotation(Inline=true);
      end equalityConstraint;
      annotation (Documentation(info="<html>
<p>
This type describes the <b>rotation</b> from a <b>frame 1</b> into a <b>frame 2</b>.
An instance <b>R</b> of type <b>Orientation</b> has the following interpretation:
</p>
<pre>
   <b>T</b> = [<b>e</b><sub>x</sub>, <b>e</b><sub>y</sub>, <b>e</b><sub>z</sub>];
       e.g., <b>T</b> = [1,0,0; 0,1,0; 0,0,1]
</pre>
<p>
where <b>e</b><sub>x</sub>,<b>e</b><sub>y</sub>,<b>e</b><sub>z</sub>
are unit vectors in the direction of the x-axis, y-axis, and z-axis
of frame 1, resolved in frame 2, respectively. Therefore, if <b>v</b><sub>1</sub>
is vector <b>v</b> resolved in frame 1 and <b>v</b><sub>2</sub> is
vector <b>v</b> resolved in frame 2, the following relationship holds:
</p>
<pre>
    <b>v</b><sub>2</sub> = <b>T</b> * <b>v</b><sub>1</sub>
</pre>
</p>
The <b>inverse</b> orientation
<b>T_inv</b> = <b>T</b><sup>T</sup> describes the rotation
from frame 2 into frame 1.
</p>
<p>
Since the orientation is described by 9 variables, there are
6 constraints between these variables. These constraints
are defined in function <b>TransformationMatrices.orientationConstraint</b>.
</p>
<p>
Note, that in the MultiBody library the rotation object is
never directly accessed but only with the access functions provided
in package TransformationMatrices. As a consequence, other implementations of
Rotation can be defined by adapting this package correspondingly.
</p>
</html>
"));
    end Orientation;

    type der_Orientation = Real[3, 3] (each unit="1/s")
      "New type defining the first time derivative of Orientation";

    function orientationConstraint
      "Return residues of orientation constraints (shall be zero)"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      output Real residue[6]
        "Residues of constraints between elements of orientation object (shall be zero)";
    algorithm
      residue := {T[:, 1]*T[:, 1] - 1,T[:, 2]*T[:, 2] - 1,T[:, 3]*T[:, 3] - 1,T[
        :, 1]*T[:, 2],T[:, 1]*T[:, 3],T[:, 2]*T[:, 3]};
      annotation(Inline=true);
    end orientationConstraint;

    function angularVelocity1
      "Return angular velocity resolved in frame 1 from orientation object and its derivative"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input der_Orientation der_T "Derivative of T";
      output Modelica.SIunits.AngularVelocity w[3]
        "Angular velocity of frame 2 with respect to frame 1 resolved in frame 1";
    algorithm
      /* The angular velocity w of frame 2 with respect to frame 1 resolved in frame 1,
     is defined as:
        w = vec( der(transpose(T))*T );
     where
                   |   0 -w3  w2 |
         skew(w) = |  w3   0 -w1 | and w = vec(skew(w))
                   | -w2  w1   0 |
     i.e.
         W = der(transpose(T))*T)
         w = {W(3,2), -W(3,1), W(2,1)}
     Therefore, only 3 values of W need to be computed:
             | der(T[:,1]) |
         W = | der(T[:,2]) | * | T[:,1], T[:,2], T[:,3] |
             | der(T[:,3]) |
             |  W(3,2) |   |  der(T[:,3])*T[:,2] |
         w = | -W(3,1) | = | -der(T[:,3])*T[:,1] |
             |  W(2,1) |   |  der(T[:,2])*T[:,1] |
  */
      w := {der_T[:, 3]*T[:, 2],-der_T[:, 3]*T[:, 1],der_T[:, 2]*T[:, 1]};
      annotation(Inline=true);
    end angularVelocity1;

    function angularVelocity2
      "Return angular velocity resolved in frame 2 from orientation object and its derivative"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input der_Orientation der_T "Derivative of T";
      output Modelica.SIunits.AngularVelocity w[3]
        "Angular velocity of frame 2 with respect to frame 1 resolved in frame 2";
    algorithm
      /* The angular velocity w of frame 2 with respect to frame 1 resolved in frame 2,
     is defined as:
        w = vec(T*der(transpose(T)));
     where
                   |   0 -w3  w2 |
         skew(w) = |  w3   0 -w1 | and w = vec(skew(w))
                   | -w2  w1   0 |
     i.e.
         W = T*der(transpose(T))
         w = {W(3,2), -W(3,1), W(2,1)}
     Therefore, only 3 values of W need to be computed:
             | T[1,:] |
         W = | T[2,:] | * | der(T[1,:]), der(T[2,:]), der(T[3,:]) |
             | T[3,:] |
             |  W(3,2) |   |  T[3,:]*der(T[2,:]) |
         w = | -W(3,1) | = | -T[3,:]*der(T[1,:]) |
             |  W(2,1) |   |  T[2,:]*der(T[1,:]) |
  */
      w := {T[3, :]*der_T[2, :],-T[3, :]*der_T[1, :],T[2, :]*der_T[1, :]};
      annotation(Inline=true);
    end angularVelocity2;

    function resolve1 "Transform vector from frame 2 to frame 1"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Real v2[3] "Vector in frame 2";
      output Real v1[3] "Vector in frame 1";
    algorithm
      v1 := transpose(T)*v2;
      annotation(Inline=true);
    end resolve1;

    function resolve2 "Transform vector from frame 1 to frame 2"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Real v1[3] "Vector in frame 1";
      output Real v2[3] "Vector in frame 2";
    algorithm
      v2 := T*v1;
      annotation(Inline=true);
    end resolve2;

    function multipleResolve1
      "Transform several vectors from frame 2 to frame 1"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Real v2[3, :] "Vectors in frame 2";
      output Real v1[3, size(v2, 2)] "Vectors in frame 1";
    algorithm
      v1 := transpose(T)*v2;
      annotation(Inline=true);
    end multipleResolve1;

    function multipleResolve2
      "Transform several vectors from frame 1 to frame 2"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Real v1[3, :] "Vectors in frame 1";
      output Real v2[3, size(v1, 2)] "Vectors in frame 2";
    algorithm
      v2 := T*v1;
      annotation(Inline=true);
    end multipleResolve2;

    function resolveDyade1
      "Transform second order tensor from frame 2 to frame 1"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Real D2[3, 3] "Second order tensor resolved in frame 2";
      output Real D1[3, 3] "Second order tensor resolved in frame 1";
    algorithm
      D1 := transpose(T)*D2*T;
      annotation(Inline=true);
    end resolveDyade1;

    function resolveDyade2
      "Transform second order tensor from frame 1 to frame 2"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Real D1[3, 3] "Second order tensor resolved in frame 1";
      output Real D2[3, 3] "Second order tensor resolved in frame 2";
    algorithm
      D2 := T*D1*transpose(T);
      annotation(Inline=true);
    end resolveDyade2;

    function nullRotation
      "Return orientation object that does not rotate a frame"
      extends Modelica.Icons.Function;
      output TransformationMatrices.Orientation T
        "Orientation object such that frame 1 and frame 2 are identical";
    algorithm
      T := identity(3);
      annotation(Inline=true);
    end nullRotation;

    function inverseRotation "Return inverse orientation object"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      output TransformationMatrices.Orientation T_inv
        "Orientation object to rotate frame 2 into frame 1";
    algorithm
      T_inv := transpose(T);
      annotation(Inline=true);
    end inverseRotation;

    function relativeRotation "Return relative orientation object"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T1
        "Orientation object to rotate frame 0 into frame 1";
      input TransformationMatrices.Orientation T2
        "Orientation object to rotate frame 0 into frame 2";
      output TransformationMatrices.Orientation T_rel
        "Orientation object to rotate frame 1 into frame 2";
    algorithm
      T_rel := T2*transpose(T1);
      annotation(Inline=true);
    end relativeRotation;

    function absoluteRotation
      "Return absolute orientation object from another absolute and a relative orientation object"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T1
        "Orientation object to rotate frame 0 into frame 1";
      input TransformationMatrices.Orientation T_rel
        "Orientation object to rotate frame 1 into frame 2";
      output TransformationMatrices.Orientation T2
        "Orientation object to rotate frame 0 into frame 2";
    algorithm
      T2 := T_rel*T1;
      annotation(Inline=true);
    end absoluteRotation;

    function planarRotation "Return orientation object of a planar rotation"
      import Modelica.Math;
      extends Modelica.Icons.Function;
      input Real e[3](each final unit="1")
        "Normalized axis of rotation (must have length=1)";
      input Modelica.SIunits.Angle angle
        "Rotation angle to rotate frame 1 into frame 2 along axis e";
      output TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
    algorithm
      T := [e]*transpose([e]) + (identity(3) - [e]*transpose([e]))*Math.cos(
        angle) - skew(e)*Math.sin(angle);
      annotation(Inline=true);
    end planarRotation;

    function planarRotationAngle
      "Return angle of a planar rotation, given the rotation axis and the representations of a vector in frame 1 and frame 2"

      extends Modelica.Icons.Function;
      input Real e[3](each final unit="1")
        "Normalized axis of rotation to rotate frame 1 around e into frame 2 (must have length=1)";
      input Real v1[3]
        "A vector v resolved in frame 1 (shall not be parallel to e)";
      input Real v2[3]
        "Vector v resolved in frame 2, i.e., v2 = resolve2(planarRotation(e,angle),v1)";
      output Modelica.SIunits.Angle angle
        "Rotation angle to rotate frame 1 into frame 2 along axis e in the range: -pi <= angle <= pi";
    algorithm
      /* Vector v is resolved in frame 1 and frame 2 according to:
        (1)  v2 = (e*transpose(e) + (identity(3) - e*transpose(e))*cos(angle) - skew(e)*sin(angle))*v1;
                = e*(e*v1) + (v1 - e*(e*v1))*cos(angle) - cross(e,v1)*sin(angle)
       Equation (1) is multiplied with "v1" resulting in (note: e*e = 1)
            v1*v2 = (e*v1)*(e*v2) + (v1*v1 - (e*v1)*(e*v1))*cos(angle)
       and therefore:
        (2) cos(angle) = ( v1*v2 - (e*v1)*(e*v2)) / (v1*v1 - (e*v1)*(e*v1))
       Similiarly, equation (1) is multiplied with cross(e,v1), i.e., a
       a vector that is orthogonal to e and to v1:
              cross(e,v1)*v2 = - cross(e,v1)*cross(e,v1)*sin(angle)
       and therefore:
          (3) sin(angle) = -cross(e,v1)*v2/(cross(e,v1)*cross(e,v1));
       We have e*e=1; Therefore:
          (4) v1*v1 - (e*v1)*(e*v1) = |v1|^2 - (|v1|*cos(e,v1))^2
       and
          (5) cross(e,v1)*cross(e,v1) = (|v1|*sin(e,v1))^2
                                      = |v1|^2*(1 - cos(e,v1)^2)
                                      = |v1|^2 - (|v1|*cos(e,v1))^2
       The denominators of (2) and (3) are identical, according to (4) and (5).
       Furthermore, the denominators are always positive according to (5).
       Therefore, in the equation "angle = atan2(sin(angle), cos(angle))" the
       denominators of sin(angle) and cos(angle) can be removed,
       resulting in:
          angle = atan2(-cross(e,v1)*v2, v1*v2 - (e*v1)*(e*v2));
    */
      angle := Modelica.Math.atan2(-cross(e, v1)*v2, v1*v2 - (e*v1)*(e*v2));
      annotation (Inline=true, Documentation(info="<HTML>
<p>
A call to this function of the form
</p>
<pre>
    Real[3]                e, v1, v2;
    Modelica.SIunits.Angle angle;
  <b>equation</b>
    angle = <b>planarRotationAngle</b>(e, v1, v2);
</pre>
<p>
computes the rotation angle \"<b>angle</b>\" of a planar
rotation along unit vector <b>e</b>, rotating frame 1 into frame 2, given
the coordinate representations of a vector \"v\" in frame 1 (<b>v1</b>)
and in frame 2 (<b>v2</b>). Therefore, the result of this function
fulfills the following equation:
</p>
<pre>
    v2 = <b>resolve2</b>(<b>planarRotation</b>(e,angle), v1)
</pre>
<p>
The rotation angle is returned in the range
</p>
<pre>
    -<font face=\"Symbol\">p</font> &lt;= angle &lt;= <font face=\"Symbol\">p</font>
</pre>
<p>
This function makes the following assumptions on the input arguments
</p>
<ul>
<li> Vector <b>e</b> has length 1, i.e., length(e) = 1</li>
<li> Vector \"v\" is not parallel to <b>e</b>, i.e.,
     length(cross(e,v1)) &ne; 0</li>
</ul>
<p>
The function does not check the above assumptions. If these
assumptions are violated, a wrong result will be returned
and/or a division by zero will occur.
</p>
</HTML>"));
    end planarRotationAngle;

    function axisRotation
      "Return rotation object to rotate around one frame axis"
      import Modelica.Math.*;
      extends Modelica.Icons.Function;
      input Integer axis(min=1, max=3) "Rotate around 'axis' of frame 1";
      input Modelica.SIunits.Angle angle
        "Rotation angle to rotate frame 1 into frame 2 along 'axis' of frame 1";
      output TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
    algorithm
      T := if axis == 1 then [1, 0, 0; 0, cos(angle), sin(angle); 0, -sin(angle),
         cos(angle)] else if axis == 2 then [cos(angle), 0, -sin(angle); 0, 1,
        0; sin(angle), 0, cos(angle)] else [cos(angle), sin(angle), 0; -sin(
        angle), cos(angle), 0; 0, 0, 1];
      annotation(Inline=true);
    end axisRotation;

    function axesRotations
      "Return rotation object to rotate in sequence around 3 axes"
      extends Modelica.Icons.Function;
      input Integer sequence[3](
        min={1,1,1},
        max={3,3,3}) = {1,2,3}
        "Sequence of rotations from frame 1 to frame 2 along axis sequence[i]";
      input Modelica.SIunits.Angle angles[3]={0,0,0}
        "Rotation angles around the axes defined in 'sequence'";
      output TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
    algorithm
      T := absoluteRotation(absoluteRotation(axisRotation(sequence[1], angles[1]),
         axisRotation(sequence[2], angles[2])), axisRotation(sequence[3],
        angles[3]));
      annotation(Inline=true);
    end axesRotations;

    function axesRotationsAngles
      "Return the 3 angles to rotate in sequence around 3 axes to construct the given orientation object"

      import SI = Modelica.SIunits;

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Integer sequence[3](
        min={1,1,1},
        max={3,3,3}) = {1,2,3}
        "Sequence of rotations from frame 1 to frame 2 along axis sequence[i]";
      input SI.Angle guessAngle1=0
        "Select angles[1] such that |angles[1] - guessAngle1| is a minimum";
      output SI.Angle angles[3]
        "Rotation angles around the axes defined in 'sequence' such that T=TransformationMatrices.axesRotation(sequence,angles); -pi < angles[i] <= pi";
    protected
      Real e1_1[3](each final unit="1")
        "First rotation axis, resolved in frame 1";
      Real e2_1a[3](each final unit="1")
        "Second rotation axis, resolved in frame 1a";
      Real e3_1[3](each final unit="1")
        "Third rotation axis, resolved in frame 1";
      Real e3_2[3](each final unit="1")
        "Third rotation axis, resolved in frame 2";
      Real A
        "Coefficient A in the equation A*cos(angles[1])+B*sin(angles[1]) = 0";
      Real B
        "Coefficient B in the equation A*cos(angles[1])+B*sin(angles[1]) = 0";
      SI.Angle angle_1a "Solution 1 for angles[1]";
      SI.Angle angle_1b "Solution 2 for angles[1]";
      TransformationMatrices.Orientation T_1a
        "Orientation object to rotate frame 1 into frame 1a";
    algorithm
      /* The rotation object T is constructed by:
     (1) Rotating frame 1 along axis e1 (= axis sequence[1]) with angles[1]
         arriving at frame 1a.
     (2) Rotating frame 1a along axis e2 (= axis sequence[2]) with angles[2]
         arriving at frame 1b.
     (3) Rotating frame 1b along axis e3 (= axis sequence[3]) with angles[3]
         arriving at frame 2.
     The goal is to determine angles[1:3]. This is performed in the following way:
     1. e2 and e3 are perpendicular to each other, i.e., e2*e3 = 0;
        Both vectors are resolved in frame 1 (T_ij is transformation matrix
        from frame j to frame i; e1_1*e2_1a = 0, since the vectors are
        perpendicular to each other):
           e3_1 = T_12*e3_2
                = T[sequence[3],:];
           e2_1 = T_11a*e2_1a
                = ( e1_1*transpose(e1_1) + (identity(3) - e1_1*transpose(e1_1))*cos(angles[1])
                    + skew(e1_1)*sin(angles[1]) )*e2_1a
                = e2_1a*cos(angles[1]) + cross(e1_1, e2_1a)*sin(angles[1]);
        From this follows finally an equation for angles[1]
           e2_1*e3_1 = 0
                     = (e2_1a*cos(angles[1]) + cross(e1_1, e2_1a)*sin(angles[1]))*e3_1
                     = (e2_1a*e3_1)*cos(angles[1]) + cross(e1_1, e2_1a)*e3_1*sin(angles[1])
                     = A*cos(angles[1]) + B*sin(angles[1])
                       with A = e2_1a*e3_1, B = cross(e1_1, e2_1a)*e3_1
        This equation has two solutions in the range -pi < angles[1] <= pi:
           sin(angles[1]) =  k*A/sqrt(A*A + B*B)
           cos(angles[1]) = -k*B/sqrt(A*A + B*B)
                        k = +/-1
           tan(angles[1]) = k*A/(-k*B)
        that is:
           angles[1] = atan2(k*A, -k*B)
        If A and B are both zero at the same time, there is a singular configuration
        resulting in an infinite number of solutions for angles[1] (every value
        is possible).
     2. angles[2] is determined with function TransformationMatrices.planarRotationAngle.
        This function requires to provide e_3 in frame 1a and in frame 1b:
          e3_1a = TransformationMatrices.resolve2(planarRotation(e1_1,angles[1]), e3_1);
          e3_1b = e3_2
     3. angles[3] is determined with function TransformationMatrices.planarRotationAngle.
        This function requires to provide e_2 in frame 1b and in frame 2:
          e2_1b = e2_1a
          e2_2  = TransformationMatrices.resolve2( T, TransformationMatrices.resolve1(planarRotation(e1_1,angles[1]), e2_1a));
  */
      assert(sequence[1] <> sequence[2] and sequence[2] <> sequence[3],
        "input argument 'sequence[1:3]' is not valid");
      e1_1 := if sequence[1] == 1 then {1,0,0} else if sequence[1] == 2 then {0,
        1,0} else {0,0,1};
      e2_1a := if sequence[2] == 1 then {1,0,0} else if sequence[2] == 2 then {
        0,1,0} else {0,0,1};
      e3_1 := T[sequence[3], :];
      e3_2 := if sequence[3] == 1 then {1,0,0} else if sequence[3] == 2 then {0,
        1,0} else {0,0,1};

      A := e2_1a*e3_1;
      B := cross(e1_1, e2_1a)*e3_1;
      if abs(A) <= 1.e-12 and abs(B) <= 1.e-12 then
        angles[1] := guessAngle1;
      else
        angle_1a := Modelica.Math.atan2(A, -B);
        angle_1b := Modelica.Math.atan2(-A, B);
        angles[1] := if abs(angle_1a - guessAngle1) <= abs(angle_1b -
          guessAngle1) then angle_1a else angle_1b;
      end if;
      T_1a := planarRotation(e1_1, angles[1]);
      angles[2] := TransformationMatrices.planarRotationAngle(e2_1a,
        TransformationMatrices.resolve2(T_1a, e3_1), e3_2);
      angles[3] := TransformationMatrices.planarRotationAngle(e3_2, e2_1a,
        TransformationMatrices.resolve2(T, TransformationMatrices.resolve1(T_1a,
         e2_1a)));

      annotation (Documentation(info="<HTML>
<p>
A call to this function of the form
</p>
<pre>
    TransformationMatrices.Orientation     T;
    <b>parameter</b> Integer      sequence[3] = {1,2,3};
    Modelica.SIunits.Angle angles[3];
  <b>equation</b>
    angle = <b>axesRotationAngles</b>(T, sequence);
</pre>
<p>
computes the rotation angles \"<b>angles</b>[1:3]\" to rotate frame 1
into frame 2 along axes <b>sequence</b>[1:3], given the orientation
object <b>T</b> from frame 1 to frame 2. Therefore, the result of
this function fulfills the following equation:
</p>
<pre>
    T = <b>axesRotation</b>(sequence, angles)
</pre>
<p>
The rotation angles are returned in the range
</p>
<pre>
    -<font face=\"Symbol\">p</font> &lt;= angles[i] &lt;= <font face=\"Symbol\">p</font>
</pre>
<p>
There are <b>two solutions</b> for \"angles[1]\" in this range.
Via the third argument <b>guessAngle1</b> (default = 0) the
returned solution is selected such that |angles[1] - guessAngle1| is
minimal. The orientation object T may be in a singular configuration, i.e.,
there is an infinite number of angle values leading to the same T. The returned solution is
selected by setting angles[1] = guessAngle1. Then angles[2]
and angles[3] can be uniquely determined in the above range.
</p>
<p>
Note, that input argument <b>sequence</b> has the restriction that
only values 1,2,3 can be used and that sequence[1] &ne; sequence[2]
and sequence[2] &ne; sequence[3]. Often used values are:
</p>
<pre>
  sequence = <b>{1,2,3}</b>  // Cardan angle sequence
           = <b>{3,1,3}</b>  // Euler angle sequence
           = <b>{3,2,1}</b>  // Tait-Bryan angle sequence
</pre>
</HTML>"));
    end axesRotationsAngles;

    function smallRotation
      "Return rotation angles valid for a small rotation and optionally residues that should be zero"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Boolean withResidues=false
        "= false/true, if 'angles'/'angles and residues' are returned in phi";
      output Modelica.SIunits.Angle phi[if withResidues then 6 else 3]
        "The rotation angles around x-, y-, and z-axis of frame 1 to rotate frame 1 into frame 2 for a small rotation + optionally 3 residues that should be zero";
    algorithm
      /* Planar rotation:
       Trel = [e]*transpose([e]) + (identity(3) - [e]*transpose([e]))*cos(angle) - skew(e)*sin(angle)
            = identity(3) - skew(e)*angle, for small angles
            = identity(3) - skew(e*angle)
               define phi = e*angle, then
       Trel = [1,      phi3,   -phi2;
               -phi3,     1,    phi1;
                phi2, -phi1,       1 ];
  */
      phi := if withResidues then {T[2, 3],-T[1, 3],T[1, 2],T[1, 1] - 1,T[2, 2]
         - 1,T[1, 1]*T[2, 2] - T[2, 1]*T[1, 2] - 1} else {T[2, 3],-T[1, 3],T[1,
         2]};
      annotation(Inline=true);
    end smallRotation;

    function from_nxy "Return orientation object from n_x and n_y vectors"
      extends Modelica.Icons.Function;
      input Real n_x[3](each final unit="1")
        "Vector in direction of x-axis of frame 2, resolved in frame 1";
      input Real n_y[3](each final unit="1")
        "Vector in direction of y-axis of frame 2, resolved in frame 1";
      output TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
    protected
      Real abs_n_x=sqrt(n_x*n_x);
      Real e_x[3](each final unit="1")=if abs_n_x < 1.e-10 then {1,0,0} else n_x/abs_n_x;
      Real n_z_aux[3](each final unit="1")=cross(e_x, n_y);
      Real n_y_aux[3](each final unit="1")=if n_z_aux*n_z_aux > 1.0e-6 then n_y else (if abs(e_x[1])
           > 1.0e-6 then {0,1,0} else {1,0,0});
      Real e_z_aux[3](each final unit="1")=cross(e_x, n_y_aux);
      Real e_z[3](each final unit="1")=e_z_aux/sqrt(e_z_aux*e_z_aux);
    algorithm
      T := {e_x,cross(e_z, e_x),e_z};
      annotation (Documentation(info="<html>
<p>
It is assumed that the two input vectors n_x and n_y are
resolved in frame 1 and are directed along the x and y axis
of frame 2 (i.e., n_x and n_y are orthogonal to each other)
The function returns the orientation object T to rotate from
frame 1 to frame 2.
</p>
<p>
The function is robust in the sense that it returns always
an orientation object T, even if n_y is not orthogonal to n_x.
This is performed in the following way:
</p>
<p>
If n_x and n_y are not orthogonal to each other, first a unit
vector e_y is determined that is orthogonal to n_x and is lying
in the plane spanned by n_x and n_y. If n_x and n_y are parallel
or nearly parallel to each other, a vector e_y is selected
arbitrarily such that e_x and e_y are orthogonal to each other.
</p>
</html>"));
    end from_nxy;

    function from_nxz "Return orientation object from n_x and n_z vectors"
      extends Modelica.Icons.Function;
      input Real n_x[3](each final unit="1")
        "Vector in direction of x-axis of frame 2, resolved in frame 1";
      input Real n_z[3](each final unit="1")
        "Vector in direction of z-axis of frame 2, resolved in frame 1";
      output TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
    protected
      Real abs_n_x=sqrt(n_x*n_x);
      Real e_x[3](each final unit="1")=if abs_n_x < 1.e-10 then {1,0,0} else n_x/abs_n_x;
      Real n_y_aux[3](each final unit="1")=cross(n_z, e_x);
      Real n_z_aux[3](each final unit="1")=if n_y_aux*n_y_aux > 1.0e-6 then n_z else (if abs(e_x[1])
           > 1.0e-6 then {0,0,1} else {1,0,0});
      Real e_y_aux[3](each final unit="1")=cross(n_z_aux, e_x);
      Real e_y[3](each final unit="1")=e_y_aux/sqrt(e_y_aux*e_y_aux);
    algorithm
      T := {e_x,e_y,cross(e_x, e_y)};
      annotation (Documentation(info="<html>
<p>
It is assumed that the two input vectors n_x and n_z are
resolved in frame 1 and are directed along the x and z axis
of frame 2 (i.e., n_x and n_z are orthogonal to each other)
The function returns the orientation object T to rotate from
frame 1 to frame 2.
</p>
<p>
The function is robust in the sense that it returns always
an orientation object T, even if n_z is not orthogonal to n_x.
This is performed in the following way:
</p>
<p>
If n_x and n_z are not orthogonal to each other, first a unit
vector e_z is determined that is orthogonal to n_x and is lying
in the plane spanned by n_x and n_z. If n_x and n_z are parallel
or nearly parallel to each other, a vector e_z is selected
arbitrarily such that n_x and e_z are orthogonal to each other.
</p>
</html>"));
    end from_nxz;

    function from_T "Return orientation object R from transformation matrix T"
      extends Modelica.Icons.Function;
      input Real T[3, 3]
        "Transformation matrix to transform vector from frame 1 to frame 2 (v2=T*v1)";
      output TransformationMatrices.Orientation R
        "Orientation object to rotate frame 1 into frame 2";
    algorithm
      R := T;
      annotation(Inline=true);
    end from_T;

    function from_T_inv
      "Return orientation object R from inverse transformation matrix T_inv"

      extends Modelica.Icons.Function;
      input Real T_inv[3, 3]
        "Inverse transformation matrix to transform vector from frame 2 to frame 1 (v1=T_inv*v2)";
      output TransformationMatrices.Orientation R
        "Orientation object to rotate frame 1 into frame 2";
    algorithm
      R := transpose(T_inv);
      annotation(Inline=true);
    end from_T_inv;

    function from_Q
      "Return orientation object T from quaternion orientation object Q"

      extends Modelica.Icons.Function;
      input Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
      output TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
    algorithm
      /*
  T := (2*Q[4]*Q[4] - 1)*identity(3) + 2*([Q[1:3]]*transpose([Q[1:3]]) - Q[4]*
    skew(Q[1:3]));
*/
      T := [2*(Q[1]*Q[1] + Q[4]*Q[4]) - 1, 2*(Q[1]*Q[2] + Q[3]*Q[4]), 2*(Q[1]*Q[
        3] - Q[2]*Q[4]); 2*(Q[2]*Q[1] - Q[3]*Q[4]), 2*(Q[2]*Q[2] + Q[4]*Q[4])
         - 1, 2*(Q[2]*Q[3] + Q[1]*Q[4]); 2*(Q[3]*Q[1] + Q[2]*Q[4]), 2*(Q[3]*Q[2]
         - Q[1]*Q[4]), 2*(Q[3]*Q[3] + Q[4]*Q[4]) - 1];
      annotation(Inline=true);
    end from_Q;

    function to_T "Return transformation matrix T from orientation object R"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation R
        "Orientation object to rotate frame 1 into frame 2";
      output Real T[3, 3]
        "Transformation matrix to transform vector from frame 1 to frame 2 (v2=T*v1)";
    algorithm
      T := R;
      annotation(Inline=true);
    end to_T;

    function to_T_inv
      "Return inverse transformation matrix T_inv from orientation object R"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation R
        "Orientation object to rotate frame 1 into frame 2";
      output Real T_inv[3, 3]
        "Inverse transformation matrix to transform vector from frame 2 into frame 1 (v1=T_inv*v2)";
    algorithm
      T_inv := transpose(R);
      annotation(Inline=true);
    end to_T_inv;

    function to_Q
      "Return quaternion orientation object Q from orientation object T"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      input Quaternions.Orientation Q_guess=Quaternions.nullRotation()
        "Guess value for output Q (there are 2 solutions; the one closer to Q_guess is used";
      output Quaternions.Orientation Q
        "Quaternions orientation object to rotate frame 1 into frame 2";
    algorithm
      Q := Quaternions.from_T(T, Q_guess);
      annotation(Inline=true);
    end to_Q;

    function to_vector "Map rotation object into vector"
      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      output Real vec[9] "Elements of T in one vector";
    algorithm
      vec := {T[1, 1],T[2, 1],T[3, 1],T[1, 2],T[2, 2],T[3, 2],T[1, 3],T[2, 3],T[
        3, 3]};
      annotation(Inline=true);
    end to_vector;

    function to_exy
      "Map rotation object into e_x and e_y vectors of frame 2, resolved in frame 1"

      extends Modelica.Icons.Function;
      input TransformationMatrices.Orientation T
        "Orientation object to rotate frame 1 into frame 2";
      output Real exy[3, 2]
        "= [e_x, e_y] where e_x and e_y are axes unit vectors of frame 2, resolved in frame 1";
    algorithm
      exy := [T[1, :], T[2, :]];
      annotation(Inline=true);
    end to_exy;
    annotation (Documentation(info="<HTML>
<p>
Package <b>Frames.TransformationMatrices</b> contains type definitions and
functions to transform rotational frame quantities using
transformation matrices.
</p>
<h4>Content</h4>
<p>In the table below an example is given for every function definition.
The used variables have the following declaration:
</p>
<pre>
   Orientation T, T1, T2, T_rel, T_inv;
   Real[3]     v1, v2, w1, w2, n_x, n_y, n_z, e, e_x, res_ori, phi;
   Real[6]     res_equal;
   Real        L, angle;
</pre>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><th><b><i>Function/type</i></b></th><th><b><i>Description</i></b></th></tr>
  <tr><td valign=\"top\"><b>Orientation T;</b></td>
      <td valign=\"top\">New type defining an orientation object that describes<br>
          the rotation of frame 1 into frame 2.
      </td>
  </tr>
  <tr><td valign=\"top\"><b>der_Orientation</b> der_T;</td>
      <td valign=\"top\">New type defining the first time derivative
         of Frames.Orientation.
      </td>
  </tr>
  <tr><td valign=\"top\">res_ori = <b>orientationConstraint</b>(T);</td>
      <td valign=\"top\">Return the constraints between the variables of an orientation object<br>
      (shall be zero).</td>
  </tr>
  <tr><td valign=\"top\">w1 = <b>angularVelocity1</b>(T, der_T);</td>
      <td valign=\"top\">Return angular velocity resolved in frame 1 from
          orientation object T<br> and its derivative der_T.
     </td>
  </tr>
  <tr><td valign=\"top\">w2 = <b>angularVelocity2</b>(T, der_T);</td>
      <td valign=\"top\">Return angular velocity resolved in frame 2 from
          orientation object T<br> and its derivative der_T.
     </td>
  </tr>
  <tr><td valign=\"top\">v1 = <b>resolve1</b>(T,v2);</td>
      <td valign=\"top\">Transform vector v2 from frame 2 to frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">v2 = <b>resolve2</b>(T,v1);</td>
      <td valign=\"top\">Transform vector v1 from frame 1 to frame 2.
     </td>
  </tr>
  <tr><td valign=\"top\">[v1,w1] = <b>multipleResolve1</b>(T, [v2,w2]);</td>
      <td valign=\"top\">Transform several vectors from frame 2 to frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">[v2,w2] = <b>multipleResolve2</b>(T, [v1,w1]);</td>
      <td valign=\"top\">Transform several vectors from frame 1 to frame 2.
      </td>
  </tr>
  <tr><td valign=\"top\">D1 = <b>resolveDyade1</b>(T,D2);</td>
      <td valign=\"top\">Transform second order tensor D2 from frame 2 to frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">D2 = <b>resolveDyade2</b>(T,D1);</td>
      <td valign=\"top\">Transform second order tensor D1 from frame 1 to frame 2.
     </td>
  </tr>
  <tr><td valign=\"top\">T= <b>nullRotation</b>()</td>
      <td valign=\"top\">Return orientation object T that does not rotate a frame.
  </tr>
  <tr><td valign=\"top\">T_inv = <b>inverseRotation</b>(T);</td>
      <td valign=\"top\">Return inverse orientation object.
      </td>
  </tr>
  <tr><td valign=\"top\">T_rel = <b>relativeRotation</b>(T1,T2);</td>
      <td valign=\"top\">Return relative orientation object from two absolute
          orientation objects.
      </td>
  </tr>
  <tr><td valign=\"top\">T2 = <b>absoluteRotation</b>(T1,T_rel);</td>
      <td valign=\"top\">Return absolute orientation object from another
          absolute<br> and a relative orientation object.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>planarRotation</b>(e, angle);</td>
      <td valign=\"top\">Return orientation object of a planar rotation.
      </td>
  </tr>
  <tr><td valign=\"top\">angle = <b>planarRotationAngle</b>(e, v1, v2);</td>
      <td valign=\"top\">Return angle of a planar rotation, given the rotation axis<br>
        and the representations of a vector in frame 1 and frame 2.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>axisRotation</b>(i, angle);</td>
      <td valign=\"top\">Return orientation object T for rotation around axis i of frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>axesRotations</b>(sequence, angles);</td>
      <td valign=\"top\">Return rotation object to rotate in sequence around 3 axes. Example:<br>
          T = axesRotations({1,2,3},{90,45,-90});
      </td>
  </tr>
  <tr><td valign=\"top\">angles = <b>axesRotationsAngles</b>(T, sequence);</td>
      <td valign=\"top\">Return the 3 angles to rotate in sequence around 3 axes to<br>
          construct the given orientation object.
      </td>
  </tr>
  <tr><td valign=\"top\">phi = <b>smallRotation</b>(T);</td>
      <td valign=\"top\">Return rotation angles phi valid for a small rotation.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>from_nxy</b>(n_x, n_y);</td>
      <td valign=\"top\">Return orientation object from n_x and n_y vectors.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>from_nxz</b>(n_x, n_z);</td>
      <td valign=\"top\">Return orientation object from n_x and n_z vectors.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>from_T</b>(T);</td>
      <td valign=\"top\">Return orientation object R from transformation matrix T.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>from_T_inv</b>(T_inv);</td>
      <td valign=\"top\">Return orientation object R from inverse transformation matrix T_inv.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>from_Q</b>(Q);</td>
      <td valign=\"top\">Return orientation object T from quaternion orientation object Q.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>to_T</b>(R);</td>
      <td valign=\"top\">Return transformation matrix T from orientation object R.
  </tr>
  <tr><td valign=\"top\">T_inv = <b>to_T_inv</b>(R);</td>
      <td valign=\"top\">Return inverse transformation matrix T_inv from orientation object R.
      </td>
  </tr>
  <tr><td valign=\"top\">Q = <b>to_Q</b>(T);</td>
      <td valign=\"top\">Return quaternione orientation object Q from orientation object T.
      </td>
  </tr>
  <tr><td valign=\"top\">exy = <b>to_exy</b>(T);</td>
      <td valign=\"top\">Return [e_x, e_y] matrix of an orientation object T, <br>
          with e_x and e_y vectors of frame 2, resolved in frame 1.
  </tr>
</table>
</HTML>"));
  end TransformationMatrices;

  package Internal
    "Internal definitions that may be removed or changed (do not use)"
    extends Modelica.Icons.Library;

    type TransformationMatrix = Real[3, 3];
    type QuaternionBase = Real[4];

    function maxWithoutEvent
      "Maximum of the input arguments, without event and without warning message when differentiating"

      input Real u1;
      input Real u2;
      output Real y;
      //  annotation (Header="#include \"MultiBody.h\"");
    protected
      Integer dummy;
    algorithm
      y := if u1 > u2 then u1 else u2;
      dummy := 0;
      annotation (Inline=false,
    derivative=maxWithoutEvent_d, Documentation(info="<html>
<p>
Function <b>maxWithoutEvent</b> returns the maximum of its two
input arguments. This functions is used instead of the Modelica
built-in function \"max\" or an if-statement with \"noEvent(..)\",
because Dymola prints a warning message when differentiating
in these cases. For the special cases as used in the MultiBody
library, these warning messages are irrelevant but will potentially
irritate the user. The C-function \"maxWithoutEvent\" and its
derivatives provided as additional functions \"maxWithoutEvent_d\"
and \"maxWithoutEvent_dd\" will not lead to such warning
messages.
</p>
</html>"));
    end maxWithoutEvent;

    function maxWithoutEvent_d
      "First derivative of function maxWithoutEvent(..)"
      input Real u1;
      input Real u2;
      input Real u1_d;
      input Real u2_d;
      output Real y_d;
      //annotation (Header="#include \"MultiBody.h\"");
    protected
      Integer dummy;
    algorithm
      y_d := if u1 > u2 then u1_d else u2_d;
      dummy := 0;
      annotation (Inline=false, derivative(order=2) = maxWithoutEvent_dd);
    end maxWithoutEvent_d;

    function maxWithoutEvent_dd
      "First derivative of function maxWithoutEvent_d(..)"
      input Real u1;
      input Real u2;
      input Real u1_d;
      input Real u2_d;
      input Real u1_dd;
      input Real u2_dd;
      output Real y_dd;
    algorithm
      y_dd := if u1 > u2 then u1_dd else u2_dd;
    end maxWithoutEvent_dd;

    function resolve1_der "Derivative of function Frames.resolve1(..)"
      import Modelica.Mechanics.MultiBody.Frames;
      extends Modelica.Icons.Function;
      input Orientation R "Orientation object to rotate frame 1 into frame 2";
      input Real v2[3] "Vector resolved in frame 2";
      input Real v2_der[3] "= der(v2)";
      output Real v1_der[3] "Derivative of vector v resolved in frame 1";
    algorithm
      v1_der := Frames.resolve1(R, v2_der + cross(R.w, v2));
      annotation(Inline=true);
    end resolve1_der;

    function resolve2_der "Derivative of function Frames.resolve2(..)"
      import Modelica.Mechanics.MultiBody.Frames;
      extends Modelica.Icons.Function;
      input Orientation R "Orientation object to rotate frame 1 into frame 2";
      input Real v1[3] "Vector resolved in frame 1";
      input Real v1_der[3] "= der(v1)";
      output Real v2_der[3] "Derivative of vector v resolved in frame 2";
    algorithm
      v2_der := Frames.resolve2(R, v1_der) - cross(R.w, Frames.resolve2(R, v1));
      annotation(Inline=true);
    end resolve2_der;

    function resolveRelative_der
      "Derivative of function Frames.resolveRelative(..)"
      import Modelica.Mechanics.MultiBody.Frames;
      extends Modelica.Icons.Function;
      input Real v1[3] "Vector in frame 1";
      input Orientation R1 "Orientation object to rotate frame 0 into frame 1";
      input Orientation R2 "Orientation object to rotate frame 0 into frame 2";
      input Real v1_der[3] "= der(v1)";
      output Real v2_der[3] "Derivative of vector v resolved in frame 2";
    algorithm
      v2_der := Frames.resolveRelative(v1_der+cross(R1.w,v1), R1, R2)
                - cross(R2.w, Frames.resolveRelative(v1, R1, R2));

      /* skew(w) = T*der(T'), -skew(w) = der(T)*T'

     v2 = T2*(T1'*v1)
     der(v2) = der(T2)*T1'*v1 + T2*der(T1')*v1 + T2*T1'*der(v1)
             = der(T2)*T2'*T2*T1'*v1 + T2*T1'*T1*der(T1')*v1 + T2*T1'*der(v1)
             = -w2 x (T2*T1'*v1) + T2*T1'*(w1 x v1) + T2*T1'*der(v1)
             = T2*T1'*(der(v1) + w1 x v1) - w2 x (T2*T1'*v1)
  */
      annotation(Inline=true);
    end resolveRelative_der;
  end Internal;

  annotation ( Documentation(info="<HTML>
<p>
Package <b>Frames</b> contains type definitions and
functions to transform rotational frame quantities. The basic idea is to
hide the actual definition of an <b>orientation</b> in this package
by providing essentially type <b>Orientation</b> together with
<b>functions</b> operating on instances of this type.
</p>
<h4>Content</h4>
<p>In the table below an example is given for every function definition.
The used variables have the following declaration:
</p>
<pre>
   Frames.Orientation R, R1, R2, R_rel, R_inv;
   Real[3,3]   T, T_inv;
   Real[3]     v1, v2, w1, w2, n_x, n_y, n_z, e, e_x, res_ori, phi;
   Real[6]     res_equal;
   Real        L, angle;
</pre>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><th><b><i>Function/type</i></b></th><th><b><i>Description</i></b></th></tr>
  <tr><td valign=\"top\"><b>Orientation R;</b></td>
      <td valign=\"top\">New type defining an orientation object that describes<br>
          the rotation of frame 1 into frame 2.
      </td>
  </tr>
  <tr><td valign=\"top\">res_ori = <b>orientationConstraint</b>(R);</td>
      <td valign=\"top\">Return the constraints between the variables of an orientation object<br>
      (shall be zero).</td>
  </tr>
  <tr><td valign=\"top\">w1 = <b>angularVelocity1</b>(R);</td>
      <td valign=\"top\">Return angular velocity resolved in frame 1 from
          orientation object R.
     </td>
  </tr>
  <tr><td valign=\"top\">w2 = <b>angularVelocity2</b>(R);</td>
      <td valign=\"top\">Return angular velocity resolved in frame 2 from
          orientation object R.
     </td>
  </tr>
  <tr><td valign=\"top\">v1 = <b>resolve1</b>(R,v2);</td>
      <td valign=\"top\">Transform vector v2 from frame 2 to frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">v2 = <b>resolve2</b>(R,v1);</td>
      <td valign=\"top\">Transform vector v1 from frame 1 to frame 2.
     </td>
  </tr>
  <tr><td valign=\"top\">v2 = <b>resolveRelative</b>(v1,R1,R2);</td>
      <td valign=\"top\">Transform vector v1 from frame 1 to frame 2
          using absolute orientation objects R1 of frame 1 and R2 of frame 2.
      </td>
  </tr>
  <tr><td valign=\"top\">D1 = <b>resolveDyade1</b>(R,D2);</td>
      <td valign=\"top\">Transform second order tensor D2 from frame 2 to frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">D2 = <b>resolveDyade2</b>(R,D1);</td>
      <td valign=\"top\">Transform second order tensor D1 from frame 1 to frame 2.
     </td>
  </tr>
  <tr><td valign=\"top\">R = <b>nullRotation</b>()</td>
      <td valign=\"top\">Return orientation object R that does not rotate a frame.
  </tr>
  <tr><td valign=\"top\">R_inv = <b>inverseRotation</b>(R);</td>
      <td valign=\"top\">Return inverse orientation object.
      </td>
  </tr>
  <tr><td valign=\"top\">R_rel = <b>relativeRotation</b>(R1,R2);</td>
      <td valign=\"top\">Return relative orientation object from two absolute
          orientation objects.
      </td>
  </tr>
  <tr><td valign=\"top\">R2 = <b>absoluteRotation</b>(R1,R_rel);</td>
      <td valign=\"top\">Return absolute orientation object from another
          absolute<br> and a relative orientation object.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>planarRotation</b>(e, angle, der_angle);</td>
      <td valign=\"top\">Return orientation object of a planar rotation.
      </td>
  </tr>
  <tr><td valign=\"top\">angle = <b>planarRotationAngle</b>(e, v1, v2);</td>
      <td valign=\"top\">Return angle of a planar rotation, given the rotation axis<br>
        and the representations of a vector in frame 1 and frame 2.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>axisRotation</b>(axis, angle, der_angle);</td>
      <td valign=\"top\">Return orientation object R to rotate around angle along axis of frame 1.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>axesRotations</b>(sequence, angles, der_angles);</td>
      <td valign=\"top\">Return rotation object to rotate in sequence around 3 axes. Example:<br>
          R = axesRotations({1,2,3},{pi/2,pi/4,-pi}, zeros(3));
      </td>
  </tr>
  <tr><td valign=\"top\">angles = <b>axesRotationsAngles</b>(R, sequence);</td>
      <td valign=\"top\">Return the 3 angles to rotate in sequence around 3 axes to<br>
          construct the given orientation object.
      </td>
  </tr>
  <tr><td valign=\"top\">phi = <b>smallRotation</b>(R);</td>
      <td valign=\"top\">Return rotation angles phi valid for a small rotation R.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>from_nxy</b>(n_x, n_y);</td>
      <td valign=\"top\">Return orientation object from n_x and n_y vectors.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>from_nxz</b>(n_x, n_z);</td>
      <td valign=\"top\">Return orientation object from n_x and n_z vectors.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>from_T</b>(T,w);</td>
      <td valign=\"top\">Return orientation object R from transformation matrix T and
          its angular velocity w.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>from_T2</b>(T,der(T));</td>
      <td valign=\"top\">Return orientation object R from transformation matrix T and
          its derivative der(T).
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>from_T_inv</b>(T_inv,w);</td>
      <td valign=\"top\">Return orientation object R from inverse transformation matrix T_inv and
          its angular velocity w.
      </td>
  </tr>
  <tr><td valign=\"top\">R = <b>from_Q</b>(Q,w);</td>
      <td valign=\"top\">Return orientation object R from quaternion orientation object Q
          and its angular velocity w.
      </td>
  </tr>
  <tr><td valign=\"top\">T = <b>to_T</b>(R);</td>
      <td valign=\"top\">Return transformation matrix T from orientation object R.
  </tr>
  <tr><td valign=\"top\">T_inv = <b>to_T_inv</b>(R);</td>
      <td valign=\"top\">Return inverse transformation matrix T_inv from orientation object R.
      </td>
  </tr>
  <tr><td valign=\"top\">Q = <b>to_Q</b>(R);</td>
      <td valign=\"top\">Return quaternione orientation object Q from orientation object R.
      </td>
  </tr>
  <tr><td valign=\"top\">exy = <b>to_exy</b>(R);</td>
      <td valign=\"top\">Return [e_x, e_y] matrix of an orientation object R, <br>
          with e_x and e_y vectors of frame 2, resolved in frame 1.
  </tr>
  <tr><td valign=\"top\">L = <b>length</b>(n_x);</td>
      <td valign=\"top\">Return length L of a vector n_x.
      </td>
  </tr>
  <tr><td valign=\"top\">e_x = <b>normalize</b>(n_x);</td>
      <td valign=\"top\">Return normalized vector e_x of n_x such that length of e_x is one.
      </td>
  </tr>
  <tr><td valign=\"top\">e = <b>axis</b>(i);</td>
      <td valign=\"top\">Return unit vector e directed along axis i
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Frames.Quaternions\">Quaternions</a></td>
      <td valign=\"top\"><b>Package</b> with functions to transform rotational frame quantities based
          on quaternions (also called Euler parameters).
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Frames.TransformationMatrices\">TransformationMatrices</a></td>
      <td valign=\"top\"><b>Package</b> with functions to transform rotational frame quantities based
          on transformation matrices.
      </td>
  </tr>
</table>
</HTML>"));
end Frames;

package Interfaces
  "Connectors and partial models for 3-dim. mechanical components"

  extends Modelica.Icons.Library;

  connector Frame
    "Coordinate system fixed to the component with one cut-force and cut-torque (no icon)"
    import SI = Modelica.SIunits;
    SI.Position r_0[3]
      "Position vector from world frame to the connector frame origin, resolved in world frame";
    Frames.Orientation R
      "Orientation object to rotate the world frame into the connector frame";
    flow SI.Force f[3] "Cut-force resolved in connector frame" annotation (
        unassignedMessage="All Forces cannot be uniquely calculated.
The reason could be that the mechanism contains
a planar loop or that joints constrain the
same motion. For planar loops, use for one
revolute joint per loop the joint
Joints.RevolutePlanarLoopConstraint instead of
Joints.Revolute.");
    flow SI.Torque t[3] "Cut-torque resolved in connector frame";
    annotation (Documentation(info="<html>
<p>
Basic definition of a coordinate system that is fixed to a mechanical
component. In the origin of the coordinate system the cut-force
and the cut-torque is acting. This component has no icon definition
and is only used by inheritance from frame connectors to define
different icons.
</p>
</html>"));
  end Frame;

  connector Frame_a
    "Coordinate system fixed to the component with one cut-force and cut-torque (filled rectangular icon)"
    extends Frame;

    annotation (defaultComponentName="frame_a",
     Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1},
          initialScale=0.16), graphics={Rectangle(
            extent={{-10,10},{10,-10}},
            lineColor={95,95,95},
            lineThickness=0.5), Rectangle(
            extent={{-30,100},{30,-100}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid)}),
     Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1},
          initialScale=0.16), graphics={Text(
            extent={{-140,-50},{140,-88}},
            lineColor={0,0,0},
            textString="%name"), Rectangle(
            extent={{-12,40},{12,-40}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid)}),
      Documentation(info="<html>
<p>
Basic definition of a coordinate system that is fixed to a mechanical
component. In the origin of the coordinate system the cut-force
and the cut-torque is acting.
This component has a filled rectangular icon.
</p>
</html>"));
  end Frame_a;

  connector Frame_b
    "Coordinate system fixed to the component with one cut-force and cut-torque (non-filled rectangular icon)"
    extends Frame;

    annotation (defaultComponentName="frame_b",
     Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1},
          initialScale=0.16), graphics={Rectangle(
            extent={{-10,10},{10,-10}},
            lineColor={95,95,95},
            lineThickness=0.5), Rectangle(
            extent={{-30,100},{30,-100}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
     Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1},
          initialScale=0.16), graphics={Text(
            extent={{-140,-50},{140,-88}},
            lineColor={0,0,0},
            textString="%name"), Rectangle(
            extent={{-12,40},{12,-40}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
      Documentation(info="<html>
<p>
Basic definition of a coordinate system that is fixed to a mechanical
component. In the origin of the coordinate system the cut-force
and the cut-torque is acting. This component has a non-filled rectangular icon.
</p>
</html>"));
  end Frame_b;

connector Frame_resolve "Coordinate system fixed to the component used to express in which
coordinate system a vector is resolved (non-filled rectangular icon)"
  extends Frame;

  annotation (defaultComponentName="frame_resolve",
    Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1},
          initialScale=0.16), graphics={Rectangle(
            extent={{-10,10},{10,-10}},
            lineColor={95,95,95},
            pattern=LinePattern.Dot), Rectangle(
            extent={{-30,100},{30,-100}},
            lineColor={95,95,95},
            pattern=LinePattern.Dot,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
    Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1},
          initialScale=0.16), graphics={Text(
            extent={{-140,-50},{140,-88}},
            lineColor={0,0,0},
            textString="%name"), Rectangle(
            extent={{-12,40},{12,-40}},
            lineColor={95,95,95},
            pattern=LinePattern.Dot,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
    Documentation(info="<html>
<p>
Basic definition of a coordinate system that is fixed to a mechanical
component. In the origin of the coordinate system the cut-force
and the cut-torque is acting. This coordinate system is used to
express in which coordinate system a vector is resolved.
A component that uses a Frame_resolve connector has to set the
cut-force and cut-torque of this frame to zero. When connecting
from a Frame_resolve connector to another frame connector,
by default the connecting line has line style \"dotted\".
This component has a non-filled rectangular icon.
</p>
</html>"));
end Frame_resolve;

  connector FlangeWithBearing
    "Connector consisting of 1-dim. rotational flange and its bearing frame"
    parameter Boolean includeBearingConnector=false
      "= true, if bearing frame connector is present, otherwise not present";
    Modelica.Mechanics.Rotational.Interfaces.Flange_a flange
      "1-dim. rotational flange";
    Modelica.Mechanics.MultiBody.Interfaces.Frame bearingFrame if 
      includeBearingConnector
      "3-dim. frame in which the 1-dim. shaft is mounted";

    annotation (
      defaultComponentName="flange",
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-20,1},{20,-1}},
            lineColor={135,135,135},
            lineThickness=0.5),
          Rectangle(
            extent={{-100,100},{100,-100}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-100,25},{100,-24}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={175,175,175}),
          Line(points={{-80,60},{80,60}}, color={0,0,0}),
          Line(points={{-80,-60},{80,-60}}, color={0,0,0}),
          Line(points={{0,100},{0,60}}, color={0,0,0}),
          Line(points={{0,-60},{0,-100}}, color={0,0,0}),
          Rectangle(extent={{-100,100},{100,-100}}, lineColor={135,135,135}),
          Rectangle(extent={{-100,25},{100,-24}}, lineColor={0,0,0})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(
            points={{-50,-40},{50,-40}},
            color={0,0,0},
            thickness=0.5),
          Line(
            points={{-50,40},{50,40}},
            color={0,0,0},
            thickness=0.5),
          Text(
            extent={{-158,-66},{158,-124}},
            lineColor={0,0,0},
            lineThickness=0.5,
            textString="%name"),
          Rectangle(
            extent={{-60,60},{60,-60}},
            lineColor={255,255,255},
            lineThickness=0.5,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-60,15},{60,-15}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={175,175,175}),
          Line(points={{0,60},{0,40}}, color={0,0,0}),
          Line(points={{0,-40},{0,-60}}, color={0,0,0}),
          Line(points={{-50,40},{50,40}}, color={0,0,0}),
          Line(points={{-50,-40},{50,-40}}, color={0,0,0}),
          Rectangle(extent={{-60,60},{60,-60}}, lineColor={135,135,135}),
          Rectangle(extent={{-60,15},{60,-15}}, lineColor={0,0,0})}),
      Documentation(info="<html>
<p>
This hierarchical connector models a 1-dim. rotational flange
connector and its optional bearing defined by a 3-dim. frame connector.
If a connection to the subconnectors should be clearly visible,
connect first an  instance of
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Interfaces.FlangeWithBearingAdaptor\">FlangeWithBearingAdaptor</a>
to the FlangeWithBearing connector.
</p>
</html>"));

  end FlangeWithBearing;

  model FlangeWithBearingAdaptor
    "Adaptor to allow direct connections to the sub-connectors of FlangeWithBearing"
    parameter Boolean includeBearingConnector=false
      "= true, if bearing frame connector is present, otherwise not present";

    Modelica.Mechanics.MultiBody.Interfaces.FlangeWithBearing flangeAndFrame(
        includeBearingConnector=includeBearingConnector)
      "Compound connector consisting of 1-dim. rotational flange and 3-dim. frame mounting"
                                   annotation (Placement(transformation(extent=
              {{-130,-30},{-70,30}}, rotation=0)));
    Modelica.Mechanics.Rotational.Interfaces.Flange_b flange
      "1-dim. rotational flange" 
      annotation (Placement(transformation(extent={{-10,-10},{10,10}}, rotation=
             0)));
    Frame_a frame if includeBearingConnector
      "3-dim. frame in which the 1-dim. shaft is mounted"             annotation (Placement(
          transformation(
          origin={0,-100},
          extent={{-16,-16},{16,16}},
          rotation=90)));

  equation
    connect(flange, flangeAndFrame.flange) annotation (Line(
        points={{0,0},{-100,0}},
        color={0,0,0}));
    connect(frame, flangeAndFrame.bearingFrame) annotation (Line(
        points={{0,-100},{0,-40},{-100,-40},{-100,0}},
        color={0,0,0},
        thickness=0.5));
    annotation (
      defaultComponentName="adaptor",
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics),
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-100,30},{20,-100}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-100,-10},{-100,-40},{0,-40},{0,-100}},
            color={0,0,0},
            thickness=0.5),
          Line(points={{-90,0},{0,0}}, color={0,0,0}),
          Text(
            extent={{-216,88},{86,36}},
            lineColor={0,0,255},
            textString="%name")}),
      Documentation(info="<html>
<p>
Adaptor object to make a more visible connection to the flange and frame
subconnectors of a
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Interfaces.FlangeWithBearing\">FlangeWithBearing</a>
connector.
</p>
</html>"));
  end FlangeWithBearingAdaptor;

  partial model PartialTwoFrames
    "Base model for components providing two frame connectors + outer world + assert to guarantee that the component is connected"

    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));
  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of component is not connected");
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of component is not connected");
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={Text(
            extent={{-136,-25},{-100,-50}},
            lineColor={128,128,128},
            textString="a"), Text(
            extent={{100,-25},{136,-50}},
            lineColor={128,128,128},
            textString="b")}),
      Documentation(info="<HTML>
<p>
This partial model provides two frame connectors, access to the world
object and an assert to check that both frame connectors are connected.
Therefore, inherit from this partial model if the two frame connectors are
needed and if the two frame connectors should be connected for a correct model.
</p>
</HTML>"),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));

  end PartialTwoFrames;

  partial model PartialTwoFramesDoubleSize
    "Base model for components providing two frame connectors + outer world + assert to guarantee that the component is connected (default icon size is factor 2 larger as usual)"

    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the component with one cut-force and cut-torque"
     annotation (Placement(transformation(extent={{-108,-8},{-92,8}})));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the component with one cut-force and cut-torque"
      annotation (Placement(transformation(extent={{92,-8},{108,8}})));

  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of component is not connected");
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of component is not connected");
    annotation (
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          initialScale=0.2)),
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          initialScale=0.2), graphics={Text(
            extent={{-117,-13},{-106,-23}},
            lineColor={128,128,128},
            textString="a"), Text(
            extent={{110,-15},{122,-25}},
            lineColor={128,128,128},
            textString="b")}),
      Documentation(info="<HTML>
<p>
This partial model provides two frame connectors, access to the world
object and an assert to check that both frame connectors are connected.
Therefore, inherit from this partial model if the two frame connectors are
needed and if the two frame connectors should be connected for a correct model.
</p>
<p>
When dragging \"PartialTwoFrames\", the default size is a factor of two
larger as usual. This partial model is used by the Joint.Assemblies
joint aggregation models.
</p>
</HTML>"));
  end PartialTwoFramesDoubleSize;

  partial model PartialOneFrame_a
    "Base model for components providing one frame_a connector + outer world + assert to guarantee that the component is connected"

    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                                                                                                          annotation (Placement(
          transformation(extent={{-116,-16},{-84,16}}, rotation=0)));
  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of component is not connected");
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}),
                     graphics),
                      Documentation(info="<html>
<p>
This partial model provides one frame_a connector, access to the world
object and an assert to check that the frame_a connector is connected.
Therefore, inherit from this partial model if the frame_a connector is
needed and if this connector should be connected for a correct model.
</p>
</html>"));
  end PartialOneFrame_a;

  partial model PartialOneFrame_b
    "Base model for components providing one frame_b connector + outer world + assert to guarantee that the component is connected"

    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the component with one cut-force and cut-torque"
      annotation (Placement(transformation(extent={{84,-16},{116,16}}, rotation=
             0)));
  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of component is not connected");
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={Text(
            extent={{94,-20},{130,-45}},
            lineColor={128,128,128},
            textString="b")}),
      Documentation(info="<HTML>
<p>
This partial model provides one frame_b connector, access to the world
object and an assert to check that the frame_b connector is connected.
Therefore, inherit from this partial model if the frame_b connector is
needed and if this connector should be connected for a correct model.
</p>
</HTML>"),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));

  end PartialOneFrame_b;

  partial model PartialElementaryJoint
    "Base model for elementary joints (has two frames + outer world + assert to guarantee that the joint is connected)"

    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the joint with one cut-force and cut-torque" 
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the joint with one cut-force and cut-torque" 
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));

  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    Connections.branch(frame_a.R, frame_b.R);
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of joint object is not connected");
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of joint object is not connected");
    annotation (Documentation(info="<HTML>
<p>
All <b>elementary joints</b> should inherit from this base model, i.e.,
joints that are directly defined by equations, provided they compute
either the rotation object of frame_b from the rotation object of frame_a
and from relative quantities (or vice versa), or there is a constraint
equation between the rotation objects of the two frames.
In other cases, a joint object should inherit from
<b>Interfaces.PartialTwoFrames</b> (e.g., joint Spherical, because there
is no constraint between the rotation objects of frame_a and frame_b
or joint Cylindrical because it is not an elementary joint).
</p>
<p>
This partial model provides two frame connectors, a \"Connections.branch\"
between frame_a and frame_b, access to the world
object and an assert to check that both frame connectors are connected.
</p>
</HTML>
 "), Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));
  end PartialElementaryJoint;

  partial model PartialForce
    "Base model for force elements (provide frame_b.f and frame_b.t in subclasses)"

    import SI = Modelica.SIunits;
    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the joint with one cut-force and cut-torque" 
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the joint with one cut-force and cut-torque" 
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));

    SI.Position r_rel_b[3]
      "Position vector from origin of frame_a to origin of frame_b, resolved in frame_b";
  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of force object is not connected");
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of force object is not connected");

    /* Determine relative position vector
     between frame_a and frame_b
  */
    r_rel_b = Frames.resolve2(frame_b.R, frame_b.r_0 - frame_a.r_0);

    /* Force and torque balance between frame_a and frame_b */
    zeros(3) = frame_a.f + Frames.resolveRelative(frame_b.f, frame_b.R, frame_a.
       R);
    zeros(3) = frame_a.t + Frames.resolveRelative(frame_b.t + cross(r_rel_b,
      frame_b.f), frame_b.R, frame_a.R);
    annotation (Documentation(info="<HTML>
<p>
All <b>3-dimensional force</b> and <b>torque elements</b>
should be based on this superclass.
This model defines frame_a and frame_b, computes the relative
translation and rotation between the two frames and calculates
the cut-force and cut-torque at frame_a by a force and torque
balance from the cut-force and cut-torque at frame_b.
As a result, in a subclass, only the relationship between
the cut-force and cut-torque at frame_b has to be defined as
a function of the following relative quantities:
</p>
<pre>
  r_rel_b[3]: Position vector from origin of frame_a to origin
              of frame_b, resolved in frame_b
  R_rel     : Relative orientation object to rotate from frame_a to frame_b
</pre>
<p>
Assume that force f = {100,0,0} should be applied on the body
to which this force element is attached at frame_b, then
the definition should be:
</p>
<pre>
   <b>model</b> Constant_x_Force
      extends Modelica.Mechanics.MultiBody.Interfaces.PartialForce;
   <b>equation</b>
      frame_b.f = {-100, 0, 0};
      frame_b.t = zeros(3);
   <b>end</b> Constant_x_Force;
</pre>
<p>
Note, that frame_b.f and frame_b.t are flow variables and therefore
the negative value of frame_b.f and frame_b.t is acting at the part
to which this force element is connected.
</p>
</HTML>"), Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
              {100,100}}), graphics={Text(
            extent={{-136,42},{-100,17}},
            lineColor={128,128,128},
            textString="a"), Text(
            extent={{102,44},{138,19}},
            lineColor={128,128,128},
            textString="b")}));
  end PartialForce;

  partial model PartialLineForce "Base model for line force elements"
    import SI = Modelica.SIunits;
    parameter SI.Position s_small=1.E-6
      " Prevent zero-division if relative distance s=0" 
      annotation (Dialog(tab="Advanced"));
    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the force element with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the force element with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));
    SI.Force f
      "Line force acting on frame_a and on frame_b (positive, if acting on frame_b and directed from frame_a to frame_b)";
    SI.Position s
      "(Guarded) distance between the origin of frame_a and the origin of frame_b (>= s_small))";
    Real e_a[3](each final unit="1")
      "Unit vector on the line connecting the origin of frame_a with the origin of frame_b resolved in frame_a (directed from frame_a to frame_b)";
    Modelica.SIunits.Position r_rel_a[3]
      "Position vector from origin of frame_a to origin of frame_b, resolved in frame_a";
  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    Connections.potentialRoot(frame_a.R, 100);
    Connections.potentialRoot(frame_b.R, 100);

    assert(cardinality(frame_a) > 0,
      "Connector frame_a of line force object is not connected");
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of line force object is not connected");

    // Determine distance s and n_a
    r_rel_a = Frames.resolve2(frame_a.R, frame_b.r_0 - frame_a.r_0);
    s = noEvent(max(Modelica.Math.Vectors.length(
                                  r_rel_a), s_small));
    e_a = r_rel_a/s;

    /* Determine forces and torques at frame_a and frame_b */
    frame_a.f = -e_a*f;
    frame_b.f = -Frames.resolve2(Frames.relativeRotation(frame_a.R, frame_b.R),
       frame_a.f);

    // Additional equations, if direct connections of line forces
    if Connections.isRoot(frame_a.R) then
      frame_a.R = Frames.nullRotation();
    else
      frame_a.t = zeros(3);
    end if;

    if Connections.isRoot(frame_b.R) then
      frame_b.R = Frames.nullRotation();
    else
      frame_b.t = zeros(3);
    end if;

    annotation (Documentation(info="<HTML>
<p>
All <b>line force</b> elements should be based on this base model.
This model defines frame_a and frame_b, computes the relative
distance <b>s</b> and provides the force and torque
balance of the cut-forces and cut-torques at frame_a and
frame_b, respectively. In sub-models, only the line force <b>f</b>,
acting at frame_b on the line from frame_a to frame_b, as a function
of the relative distance <b>s</b> and its derivative <b>der</b>(<b>s</b>)
has to be defined. Example:
</p>
<pre>
   <b>model</b> Spring
      <b>parameter</b> Real c \"spring constant\",
      <b>parameter</b> Real s_unstretched \"unstretched spring length\";
      <b>extends</b> Modelica.Mechanics.MultiBody.Interfaces.PartialLineForce;
   <b>equation</b>
      f = c*(s-s_unstretched);
   <b>end</b> Spring;
</pre>
</HTML>"), Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
              {100,100}}), graphics={Text(
            extent={{-136,44},{-100,19}},
            lineColor={128,128,128},
            textString="a"), Text(
            extent={{100,42},{136,17}},
            lineColor={128,128,128},
            textString="b")}));
  end PartialLineForce;

  partial model PartialAbsoluteSensor
    "Base model to measure an absolute frame variable"
    extends Modelica.Icons.RotationalSensor;
    parameter Integer n_out = 1 "Number of output signals";
    Interfaces.Frame_a frame_a
      "Coordinate system from which absolute quantities are provided as output signals"
      annotation (Placement(transformation(extent={{-116,-16},{-84,16}},
            rotation=0)));

    Modelica.Blocks.Interfaces.RealOutput y[n_out]
      "Measured data as signal vector" 
      annotation (Placement(transformation(extent={{100,-10},{120,10}},
            rotation=0)));
  protected
    outer Modelica.Mechanics.MultiBody.World world;

  equation
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of absolute sensor object is not connected");
    annotation (
      Documentation(info="
<HTML>
<p>
This is the base class of a 3-dim. mechanics component with one frame and one
output port in order to measure an absolute quantity in the frame connector
and to provide the measured signal as output for further processing
with the blocks of package Modelica.Blocks.
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-70,0},{-100,0}}, color={0,0,0}),
          Line(points={{70,0},{100,0}}, color={0,0,255}),
          Text(
            extent={{-132,-125},{131,-79}},
            textString="%name",
            lineColor={0,0,255})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));
  end PartialAbsoluteSensor;

  partial model PartialRelativeSensor
    "Base model to measure a relative variable between two frames"
    extends Modelica.Icons.RotationalSensor;
    parameter Integer n_out = 1 "Number of output signals";
    Interfaces.Frame_a frame_a "Coordinate system a" annotation (Placement(
          transformation(extent={{-116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b "Coordinate system b" annotation (Placement(
          transformation(extent={{84,-16},{116,16}}, rotation=0)));

    Modelica.Blocks.Interfaces.RealOutput y[n_out]
      "Measured data as signal vector" 
      annotation (Placement(transformation(
          origin={0,-110},
          extent={{10,-10},{-10,10}},
          rotation=90)));
  protected
    outer Modelica.Mechanics.MultiBody.World world;

  equation
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of relative sensor object is not connected");
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of relative sensor object is not connected");

    annotation (
      Documentation(info="
<HTML>
<p>
This is a base class for 3-dim. mechanical components with two frames
and one output port in order to measure relative quantities
between the two frames or the cut-forces/torques in the frame and
to provide the measured signals as output for further processing
with the blocks of package Modelica.Blocks.
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-70,0},{-101,0}}, color={0,0,0}),
          Line(points={{70,0},{100,0}}, color={0,0,0}),
          Line(points={{0,-100},{0,-70}}, color={0,0,127}),
          Text(
            extent={{-132,76},{129,124}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{-118,52},{-82,27}},
            lineColor={128,128,128},
            textString="a"),
          Text(
            extent={{85,53},{121,28}},
            lineColor={128,128,128},
            textString="b")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));
  end PartialRelativeSensor;

  partial model PartialVisualizer
    "Base model for visualizers (has a frame_a on the left side + outer world + assert to guarantee that the component is connected)"

    Interfaces.Frame_a frame_a
      "Coordinate system in which visualization data is resolved"                          annotation (Placement(
          transformation(extent={{-116,-16},{-84,16}}, rotation=0)));
  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of visualizer object is not connected");
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}),
                     graphics),
                      Documentation(info="<html>
<p>
This partial model provides one frame_a connector, access to the world
object and an assert to check that the frame_a connector is connected.
It is used by inheritance from all visualizer objects.
</p>
</html>"));
  end PartialVisualizer;

  model ZeroPosition
    "Set absolute position vector of frame_resolve to a zero vector and the orientation object to a null rotation"
     extends Modelica.Blocks.Interfaces.BlockIcon;
    Interfaces.Frame_resolve frame_resolve 
      annotation (Placement(transformation(extent={{-116,-16},{-84,16}})));
  equation
    Connections.root(frame_resolve.R);
    frame_resolve.R = Modelica.Mechanics.MultiBody.Frames.nullRotation();
    frame_resolve.r_0 = zeros(3);
    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={Text(
            extent={{-74,24},{80,-20}},
            lineColor={0,0,0},
            textString="r = 0")}), Diagram(coordinateSystem(
            preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
          graphics));
  end ZeroPosition;
  annotation ( Documentation(info="<html>
<p>
This package contains connectors and partial models (i.e. models
that are only used to build other models) of the MultiBody library.
</p>
</html>"));
end Interfaces;

package Joints "Components that constrain the motion between two frames"
  import SI = Modelica.SIunits;
  extends Modelica.Icons.Library;

  model Prismatic
    "Prismatic joint (1 translational degree-of-freedom, 2 potential states, optional axis flange)"

    import SI = Modelica.SIunits;
    extends Modelica.Mechanics.MultiBody.Interfaces.PartialElementaryJoint;
    Modelica.Mechanics.Translational.Interfaces.Flange_a axis if useAxisFlange
      "1-dim. translational flange that drives the joint" 
      annotation (Placement(transformation(extent={{90,50},{70,70}}, rotation=0)));
    Modelica.Mechanics.Translational.Interfaces.Flange_b support if useAxisFlange
      "1-dim. translational flange of the drive drive support (assumed to be fixed in the world frame, NOT in the joint)"
      annotation (Placement(transformation(extent={{-30,50},{-50,70}}, rotation=
             0)));

    parameter Boolean useAxisFlange=false "= true, if axis flange is enabled" 
      annotation(Evaluate=true, HideResult=true, choices(__Dymola_checkBox=true));
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n={1,0,0}
      "Axis of translation resolved in frame_a (= same as in frame_b)" 
      annotation (Evaluate=true);
    constant SI.Position s_offset=0
      "Relative distance offset (distance between frame_a and frame_b = s_offset + s)"
      annotation (Evaluate=false);
    parameter Types.Axis boxWidthDirection={0,1,0}
      "Vector in width direction of box, resolved in frame_a" 
      annotation (Evaluate=true, Dialog(tab="Animation", group=
            "if animation = true", enable=animation));
    parameter SI.Distance boxWidth=world.defaultJointWidth
      "Width of prismatic joint box" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance boxHeight=boxWidth "Height of prismatic joint box" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color boxColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of prismatic joint box" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter StateSelect stateSelect=StateSelect.prefer
      "Priority to use distance s and v=der(s) as states" annotation(Dialog(tab="Advanced"));
    final parameter Real e[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                               n)
      "Unit vector in direction of prismatic axis n";

    SI.Position s(start=0, final stateSelect=stateSelect)
      "Relative distance between frame_a and frame_b" 
      annotation (unassignedMessage="
The relative distance s of a prismatic joint cannot be determined.
Possible reasons:
- A non-zero mass might be missing on either side of the parts
  connected to the prismatic joint.
- Too many StateSelect.always are defined and the model
  has less degrees of freedom as specified with this setting
  (remove all StateSelect.always settings).
");

    SI.Velocity v(start=0,final stateSelect=stateSelect)
      "First derivative of s (relative velocity)";
    SI.Acceleration a(start=0) "Second derivative of s (relative acceleration)";
    SI.Force f "Actuation force in direction of joint axis";

  protected
    Visualizers.Advanced.Shape box(
      shapeType="box",
      color=boxColor,
      specularCoefficient=specularCoefficient,
      length=if noEvent(abs(s + s_offset) > 1.e-6) then s + s_offset else 1.e-6,
      width=boxWidth,
      height=boxHeight,
      lengthDirection=e,
      widthDirection=boxWidthDirection,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
    Translational.Components.Fixed fixed 
      annotation (Placement(transformation(extent={{-50,30},{-30,50}})));
    Translational.Interfaces.InternalSupport internalAxis(f = f) 
      annotation (Placement(transformation(extent={{70,50},{90,30}})));
    Translational.Sources.ConstantForce constantForce(f_constant=0) if not useAxisFlange 
      annotation (Placement(transformation(extent={{40,30},{60,50}})));
  equation
    v = der(s);
    a = der(v);

    // relationships between kinematic quantities of frame_a and of frame_b
    frame_b.r_0 = frame_a.r_0 + Frames.resolve1(frame_a.R, e*(s_offset + s));
    frame_b.R = frame_a.R;

    // Force and torque balance
    zeros(3) = frame_a.f + frame_b.f;
    zeros(3) = frame_a.t + frame_b.t + cross(e*(s_offset + s), frame_b.f);

    // d'Alemberts principle
    f = -e*frame_b.f;

    // Connection to internal connectors
    s = internalAxis.s;

    connect(fixed.flange, support) annotation (Line(
        points={{-40,40},{-40,60}},
        color={0,127,0},
        smooth=Smooth.None));
    connect(internalAxis.flange, axis)    annotation (Line(
        points={{80,40},{80,60}},
        color={0,127,0},
        smooth=Smooth.None));
    connect(constantForce.flange, internalAxis.flange)    annotation (Line(
        points={{60,40},{80,40}},
        color={0,127,0},
        smooth=Smooth.None));
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-100,-50},{-30,41}},
            pattern=LinePattern.None,
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Rectangle(
            extent={{-100,40},{-30,50}},
            pattern=LinePattern.None,
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Rectangle(
            extent={{-30,-30},{100,20}},
            pattern=LinePattern.None,
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Rectangle(
            extent={{-30,20},{100,30}},
            pattern=LinePattern.None,
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Line(points={{-30,-50},{-30,50}}, color={0,0,0}),
          Line(points={{100,-30},{100,21}}, color={0,0,0}),
          Text(
            extent={{60,12},{96,-13}},
            lineColor={128,128,128},
            textString="b"),
          Text(
            extent={{-95,13},{-60,-9}},
            lineColor={128,128,128},
            textString="a"),
          Text(
            visible=useAxisFlange,
            extent={{-150,-155},{150,-95}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{-150,-93},{150,-54}},
            lineColor={0,0,0},
            textString="n=%n"),
          Rectangle(
            visible=useAxisFlange,
            extent={{90,30},{100,70}},
            pattern=LinePattern.None,
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Text(
            visible=not useAxisFlange,
            extent={{-150,55},{150,115}},
            textString="%name",
            lineColor={0,0,255})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics),
      Documentation(info="<HTML>
<p>
Joint where frame_b is translated along axis n which is fixed in frame_a.
The two frames coincide when the relative distance \"s = 0\".
</p>

<p>
Optionally, two additional 1-dimensional mechanical flanges
(flange \"axis\" represents the driving flange and
flange \"support\" represents the bearing) can be enabled via
parameter <b>useAxisFlange</b>. The enabled axis flange can be
driven with elements of the
<a href=\"Modelica://Modelica.Mechanics.Translational\">Modelica.Mechanics.Translational</a>
library.

</p>

<p>
In the \"Advanced\" menu it can be defined via parameter <b>stateSelect</b>
that the relative distance \"s\" and its derivative shall be definitely
used as states by setting stateSelect=StateSelect.always.
Default is StateSelect.prefer to use the relative distance and its
derivative as preferred states. The states are usually selected automatically.
In certain situations, especially when closed kinematic loops are present,
it might be slightly more efficient, when using the StateSelect.always setting.
</p>

<p>
In the following figure the animation of a prismatic
joint is shown. The light blue coordinate system is
frame_a and the dark blue coordinate system is
frame_b of the joint. The black arrow is parameter
vector \"n\" defining the translation axis
(here: n = {1,1,0}).
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/Prismatic.png\">
</p>

</HTML>
"));
  end Prismatic;

  model Revolute
    "Revolute joint (1 rotational degree-of-freedom, 2 potential states, optional axis flange)"

    import SI = Modelica.SIunits;

    Modelica.Mechanics.Rotational.Interfaces.Flange_a axis if useAxisFlange
      "1-dim. rotational flange that drives the joint" 
      annotation (Placement(transformation(extent={{10,90},{-10,110}}, rotation=
             0)));
    Modelica.Mechanics.Rotational.Interfaces.Flange_b support if useAxisFlange
      "1-dim. rotational flange of the drive support (assumed to be fixed in the world frame, NOT in the joint)"
      annotation (Placement(transformation(extent={{-70,90},{-50,110}},
            rotation=0)));

    Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_a
      "Coordinate system fixed to the joint with one cut-force and cut-torque" 
      annotation (Placement(transformation(extent={{-116,-16},{-84,16}},
            rotation=0)));
    Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_b
      "Coordinate system fixed to the joint with one cut-force and cut-torque" 
      annotation (Placement(transformation(extent={{84,-16},{116,16}},
            rotation=0)));

    parameter Boolean useAxisFlange=false "= true, if axis flange is enabled" 
      annotation(Evaluate=true, HideResult=true, choices(__Dymola_checkBox=true));
    parameter Boolean animation=true
      "= true, if animation shall be enabled (show axis as cylinder)";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n={0,0,1}
      "Axis of rotation resolved in frame_a (= same as in frame_b)" 
      annotation (Evaluate=true);
    constant SI.Angle phi_offset=0
      "Relative angle offset (angle = phi_offset + phi)";
    parameter SI.Distance cylinderLength=world.defaultJointLength
      "Length of cylinder representing the joint axis" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance cylinderDiameter=world.defaultJointWidth
      "Diameter of cylinder representing the joint axis" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Modelica.Mechanics.MultiBody.Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of cylinder representing the joint axis" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Modelica.Mechanics.MultiBody.Types.SpecularCoefficient
      specularCoefficient =                                                            world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter StateSelect stateSelect=StateSelect.prefer
      "Priority to use joint angle phi and w=der(phi) as states" annotation(Dialog(tab="Advanced"));

    SI.Angle phi(start=0, final stateSelect=stateSelect)
      "Relative rotation angle from frame_a to frame_b" 
       annotation (unassignedMessage="
The rotation angle phi of a revolute joint cannot be determined.
Possible reasons:
- A non-zero mass might be missing on either side of the parts
  connected to the revolute joint.
- Too many StateSelect.always are defined and the model
  has less degrees of freedom as specified with this setting
  (remove all StateSelect.always settings).
");
    SI.AngularVelocity w(start=0, stateSelect=stateSelect)
      "First derivative of angle phi (relative angular velocity)";
    SI.AngularAcceleration a(start=0)
      "Second derivative of angle phi (relative angular acceleration)";
    SI.Torque tau "Driving torque in direction of axis of rotation";
    SI.Angle angle "= phi_offset + phi";

  protected
    outer Modelica.Mechanics.MultiBody.World world;
    parameter Real e[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                         n)
      "Unit vector in direction of rotation axis, resolved in frame_a (= same as in frame_b)";
    Frames.Orientation R_rel
      "Relative orientation object from frame_a to frame_b or from frame_b to frame_a";
    Visualizers.Advanced.Shape cylinder(
      shapeType="cylinder",
      color=cylinderColor,
      specularCoefficient=specularCoefficient,
      length=cylinderLength,
      width=cylinderDiameter,
      height=cylinderDiameter,
      lengthDirection=e,
      widthDirection={0,1,0},
      r_shape=-e*(cylinderLength/2),
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;

  protected
    Modelica.Mechanics.Rotational.Components.Fixed fixed
      "support flange is fixed to ground" 
      annotation (Placement(transformation(extent={{-70,70},{-50,90}})));
    Rotational.Interfaces.InternalSupport internalAxis(tau=tau) 
      annotation (Placement(transformation(extent={{-10,90},{10,70}})));
    Rotational.Sources.ConstantTorque constantTorque(tau_constant=0) if not useAxisFlange 
      annotation (Placement(transformation(extent={{40,70},{20,90}})));
  equation
    Connections.branch(frame_a.R, frame_b.R);

    assert(cardinality(frame_a) > 0,
      "Connector frame_a of revolute joint is not connected");
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of revolute joint is not connected");

    angle = phi_offset + phi;
    w = der(phi);
    a = der(w);

    // relationships between quantities of frame_a and of frame_b
    frame_b.r_0 = frame_a.r_0;

    if rooted(frame_a.R) then
      R_rel = Frames.planarRotation(e, phi_offset + phi, w);
      frame_b.R = Frames.absoluteRotation(frame_a.R, R_rel);
      frame_a.f = -Frames.resolve1(R_rel, frame_b.f);
      frame_a.t = -Frames.resolve1(R_rel, frame_b.t);
    else
      R_rel = Frames.planarRotation(-e, phi_offset + phi, w);
      frame_a.R = Frames.absoluteRotation(frame_b.R, R_rel);
      frame_b.f = -Frames.resolve1(R_rel, frame_a.f);
      frame_b.t = -Frames.resolve1(R_rel, frame_a.t);
    end if;

    // d'Alemberts principle
    tau = -frame_b.t*e;

    // Connection to internal connectors
    phi = internalAxis.phi;

    connect(fixed.flange, support) annotation (Line(
        points={{-60,80},{-60,100}},
        color={0,0,0},
        smooth=Smooth.None));
    connect(internalAxis.flange, axis) annotation (Line(
        points={{0,80},{0,100}},
        color={0,0,0},
        smooth=Smooth.None));
    connect(constantTorque.flange, internalAxis.flange) annotation (Line(
        points={{20,80},{0,80}},
        color={0,0,0},
        smooth=Smooth.None));
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-100,-60},{-30,60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{30,-60},{100,60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(extent={{-100,59},{-30,-60}}, lineColor={0,0,0}),
          Rectangle(extent={{30,60},{100,-60}}, lineColor={0,0,0}),
          Text(
            extent={{-90,14},{-54,-11}},
            lineColor={128,128,128},
            textString="a"),
          Text(
            extent={{51,11},{87,-14}},
            lineColor={128,128,128},
            textString="b"),
          Line(
            visible=useAxisFlange,
            points={{-20,80},{-20,60}},
            color={0,0,0}),
          Line(
            visible=useAxisFlange,
            points={{20,80},{20,60}},
            color={0,0,0}),
          Rectangle(
            visible=useAxisFlange,
            extent={{-10,100},{10,50}},
            lineColor={0,0,0},
            fillPattern=FillPattern.VerticalCylinder,
            fillColor={192,192,192}),
          Polygon(
            visible=useAxisFlange,
            points={{-10,30},{10,30},{30,50},{-30,50},{-10,30}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-30,11},{30,-10}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Polygon(
            visible=useAxisFlange,
            points={{10,30},{30,50},{30,-50},{10,-30},{10,30}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-150,-117},{150,-77}},
            lineColor={0,0,0},
            textString="n=%n"),
          Text(
            visible=useAxisFlange,
            extent={{-150,-175},{150,-115}},
            textString="%name",
            lineColor={0,0,255}),
          Line(
            visible=useAxisFlange,
            points={{-20,70},{-60,70},{-60,60}},
            color={0,0,0},
            smooth=Smooth.None),
          Line(
            visible=useAxisFlange,
            points={{20,70},{50,70},{50,60}},
            color={0,0,0},
            smooth=Smooth.None),
          Line(
            visible=useAxisFlange,
            points={{-90,100},{-30,100}},
            color={0,0,0}),
          Line(
            visible=useAxisFlange,
            points={{-30,100},{-50,80}},
            color={0,0,0}),
          Line(
            visible=useAxisFlange,
            points={{-49,100},{-70,80}},
            color={0,0,0}),
          Line(
            visible=useAxisFlange,
            points={{-70,100},{-90,80}},
            color={0,0,0}),
          Text(
            visible=not useAxisFlange,
            extent={{-150,70},{150,130}},
            textString="%name",
            lineColor={0,0,255})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics),
      Documentation(info="<html>

<p>
Joint where frame_b rotates around axis n which is fixed in frame_a.
The two frames coincide when the rotation angle \"phi = 0\".
</p>

<p>
Optionally, two additional 1-dimensional mechanical flanges
(flange \"axis\" represents the driving flange and
flange \"support\" represents the bearing) can be enabled via
parameter <b>useAxisFlange</b>. The enabled axis flange can be
driven with elements of the
<a href=\"Modelica://Modelica.Mechanics.Rotational\">Modelica.Mechanics.Rotational</a>
library.

</p>

<p>
In the \"Advanced\" menu it can be defined via parameter <b>stateSelect</b>
that the rotation angle \"phi\" and its derivative shall be definitely
used as states by setting stateSelect=StateSelect.always.
Default is StateSelect.prefer to use the joint angle and its
derivative as preferred states. The states are usually selected automatically.
In certain situations, especially when closed kinematic loops are present,
it might be slightly more efficient, when using the StateSelect.always setting.
</p>
<p>
If a <b>planar loop</b> is present, e.g., consisting of 4 revolute joints
where the joint axes are all parallel to each other, then there is no
longer a unique mathematical solution and the symbolic algorithms will
fail. Usually, an error message will be printed pointing out this
situation. In this case, one revolute joint of the loop has to be replaced
by a Joints.RevolutePlanarLoopConstraint joint. The
effect is that from the 5 constraints of a usual revolute joint,
3 constraints are removed and replaced by appropriate known
variables (e.g., the force in the direction of the axis of rotation is
treated as known with value equal to zero; for standard revolute joints,
this force is an unknown quantity).
</p>

<p>
In the following figure the animation of a revolute
joint is shown. The light blue coordinate system is
frame_a and the dark blue coordinate system is
frame_b of the joint. The black arrow is parameter
vector \"n\" defining the translation axis
(here: n = {0,0,1}, phi.start = 45<sup>o</sup>).
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/Revolute.png\">
</p>

</html>
"));
  end Revolute;

  model RevolutePlanarLoopConstraint
    "Revolute joint that is described by 2 positional constraints for usage in a planar loop (the ambiguous cut-force perpendicular to the loop and the ambiguous cut-torques are set arbitrarily to zero)"

    import SI = Modelica.SIunits;
    import Cv = Modelica.SIunits.Conversions;
    import T = Modelica.Mechanics.MultiBody.Frames.TransformationMatrices;
    import Modelica.Mechanics.MultiBody.Types;

    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the joint with one cut-force and cut-torque" 
      annotation (Placement(transformation(extent={{-116,-16},{-84,16}},
            rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the joint with one cut-force and cut-torque" 
      annotation (Placement(transformation(extent={{84,-16},{116,16}}, rotation=
             0)));

    parameter Boolean animation=true
      "= true, if animation shall be enabled (show axis as cylinder)";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n={0,0,1}
      "Axis of rotation resolved in frame_a (= same as in frame_b)" 
      annotation (Evaluate=true);
    parameter SI.Distance cylinderLength=world.defaultJointLength
      "Length of cylinder representing the joint axis" 
      annotation (Dialog(group="if animation = true", enable=animation));
    parameter SI.Distance cylinderDiameter=world.defaultJointWidth
      "Diameter of cylinder representing the joint axis" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of cylinder representing the joint axis" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(group="if animation = true", enable=animation));
  protected
    outer Modelica.Mechanics.MultiBody.World world;
    parameter Real e[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                         n)
      "Unit vector in direction of rotation axis, resolved in frame_a (= same as in frame_b)";
    parameter Real nnx_a[3](each final unit="1")=if abs(e[1]) > 0.1 then {0,1,0} else (if abs(e[2])
         > 0.1 then {0,0,1} else {1,0,0})
      "Arbitrary vector that is not aligned with rotation axis n" 
      annotation (Evaluate=true);
    parameter Real ey_a[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                            cross(e, nnx_a))
      "Unit vector orthogonal to axis n of revolute joint, resolved in frame_a"
      annotation (Evaluate=true);
    parameter Real ex_a[3](each final unit="1")=cross(ey_a, e)
      "Unit vector orthogonal to axis n of revolute joint and to ey_a, resolved in frame_a"
      annotation (Evaluate=true);
    Real ey_b[3](each final unit="1") "ey_a, resolved in frame_b";
    Real ex_b[3](each final unit="1") "ex_a, resolved in frame_b";
    Frames.Orientation R_rel
      "Dummy or relative orientation object from frame_a to frame_b";
    Modelica.SIunits.Position r_rel_a[3]
      "Position vector from origin of frame_a to origin of frame_b, resolved in frame_a";
    SI.Force f_c[2] "Dummy or constraint forces in direction of ex_a, ey_a";

    Visualizers.Advanced.Shape cylinder(
      shapeType="cylinder",
      color=cylinderColor,
      specularCoefficient=specularCoefficient,
      length=cylinderLength,
      width=cylinderDiameter,
      height=cylinderDiameter,
      lengthDirection=e,
      widthDirection={0,1,0},
      r_shape=-e*(cylinderLength/2),
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
  equation
    assert(cardinality(frame_a) > 0,
      "Connector frame_a of revolute joint is not connected");
    assert(cardinality(frame_b) > 0,
      "Connector frame_b of revolute joint is not connected");

    // Determine relative position vector resolved in frame_a
    R_rel = Frames.relativeRotation(frame_a.R, frame_b.R);
    r_rel_a = Frames.resolve2(frame_a.R, frame_b.r_0 - frame_a.r_0);
    // r_rel_a = T.resolve1(R_rel.T, T.resolve2(frame_b.R.T, frame_b.r_0 - frame_a.r_0));

    // Constraint equations
    0 = ex_a*r_rel_a;
    0 = ey_a*r_rel_a;

    /* Transform forces and torques
     (the torques are assumed to be zero by the assumption
      of a planar joint)
  */
    frame_a.t = zeros(3);
    frame_b.t = zeros(3);

    frame_a.f = [ex_a, ey_a]*f_c;
    frame_b.f = -Frames.resolve2(R_rel, frame_a.f);

    // check that revolute joint is used in planar loop
    ex_b = Frames.resolve2(R_rel, ex_a);
    ey_b = Frames.resolve2(R_rel, ey_a);
    assert(noEvent(abs(e*r_rel_a) <= 1.e-10 and abs(e*ex_b) <= 1.e-10 and 
        abs(e*ey_b) <= 1.e-10), "
The MultiBody.Joints.RevolutePlanarLoopConstraint joint is used as cut-joint of a
planar loop. However, the revolute joint is not part of a planar loop where the
axis of the revolute joint (parameter n) is orthogonal to the possible movements.
Either use instead joint MultiBody.Joints.Revolute or correct the
definition of the axes vectors n in the revolute joints of the planar loop.
");
    annotation (defaultComponentName="revolute",
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-146,70},{143,109}},
            lineColor={0,0,0},
            textString="n=%n"),
          Text(
            extent={{-137,-125},{139,-68}},
            textString="%name",
            lineColor={0,0,255}),
          Rectangle(
            extent={{-20,10},{20,-10}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-100,-60},{-20,60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{20,-60},{100,60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(extent={{-100,59},{-20,-60}}, lineColor={0,0,0}),
          Rectangle(extent={{20,60},{100,-60}}, lineColor={0,0,0}),
          Text(
            extent={{-90,14},{-54,-11}},
            lineColor={128,128,128},
            textString="a"),
          Text(
            extent={{51,11},{87,-14}},
            lineColor={128,128,128},
            textString="b"),
          Line(
            points={{-91,-76},{-33,15},{30,-49},{87,61}},
            color={255,0,0},
            thickness=0.5,
            smooth=Smooth.None)}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-100,-60},{-20,60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{-20,10},{20,-10}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{20,-60},{100,60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192})}),
      Documentation(info="<HTML>
<p>
Joint where frame_b rotates around axis n which is fixed in frame_a and
where this joint is used in a planar loop providing 2 constraint equations
on position level.
</p>

<p>
If a <b>planar loop</b> is present, e.g., consisting of 4 revolute joints
where the joint axes are all parallel to each other, then there is no
unique mathematical solution if all revolute joints are modelled with
Joints.Revolute and the symbolic algorithms will
fail. The reason is that, e.g., the cut-forces in the revolute joints perpendicular
to the planar loop are not uniquely defined when 3-dim. descriptions of revolute
joints are used. Usually, an error message will be printed pointing out this
situation. In this case, <b>one</b> revolute joint in the loop has to be replaced by
model Joints.RevolutePlanarLoopCutJoint. The
effect is that from the 5 constraints of a 3-dim. revolute joint,
3 constraints are removed and replaced by appropriate known
variables (e.g., the force in the direction of the axis of rotation is
treated as known with value equal to zero; for standard revolute joints,
this force is an unknown quantity).
</p>


</HTML>
"));
  end RevolutePlanarLoopConstraint;

  model Cylindrical
    "Cylindrical joint (2 degrees-of-freedom, 4 potential states)"
    import SI = Modelica.SIunits;
    extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
    parameter Boolean animation=true
      "= true, if animation shall be enabled (show cylinder)";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n={1,0,0}
      "Cylinder axis resolved in frame_a (= same as in frame_b)" 
      annotation (Evaluate=true);
    parameter SI.Distance cylinderDiameter=world.defaultJointWidth
      "Diameter of cylinder" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of cylinder" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter StateSelect stateSelect=StateSelect.prefer
      "Priority to use joint coordinates (phi, s, w, v) as states" annotation(Dialog(tab="Advanced"));

    Prismatic prismatic(
      n=n,
      animation=false,
      stateSelect=StateSelect.never) annotation (Placement(transformation(extent={{-70,-25},{
              -15,25}}, rotation=0)));
    Revolute revolute(
      n=n,
      animation=false,
      stateSelect=StateSelect.never) annotation (Placement(transformation(extent={{10,-25},{
              65,25}}, rotation=0)));

    SI.Position s(start=0, stateSelect=stateSelect)
      "Relative distance between frame_a and frame_b";
    SI.Angle phi(start=0, stateSelect=stateSelect)
      "Relative rotation angle from frame_a to frame_b";
    SI.Velocity v(start=0, stateSelect=stateSelect)
      "First derivative of s (relative velocity)";
    SI.AngularVelocity w(start=0, stateSelect=stateSelect)
      "First derivative of angle phi (relative angular velocity)";
    SI.Acceleration a(start=0) "Second derivative of s (relative acceleration)";
    SI.AngularAcceleration wd(start=0)
      "Second derivative of angle phi (relative angular acceleration)";

  protected
    Visualizers.Advanced.Shape cylinder(
      shapeType="cylinder",
      color=cylinderColor,
      specularCoefficient=specularCoefficient,
      length=prismatic.s,
      width=cylinderDiameter,
      height=cylinderDiameter,
      lengthDirection=prismatic.n,
      widthDirection={0,1,0},
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation 
      annotation (Placement(transformation(extent={{-20,40},{0,60}},  rotation=
              0)));
  equation
    phi = revolute.phi;
    w = der(phi);
    wd = der(w);
    s = prismatic.s;
    v = der(s);
    a = der(v);
    connect(frame_a, prismatic.frame_a) 
      annotation (Line(
        points={{-100,0},{-70,0}},
        color={95,95,95},
        thickness=0.5));
    connect(prismatic.frame_b, revolute.frame_a) 
      annotation (Line(
        points={{-15,0},{10,0}},
        color={95,95,95},
        thickness=0.5));
    connect(revolute.frame_b, frame_b) 
      annotation (Line(
        points={{65,0},{100,0}},
        color={95,95,95},
        thickness=0.5));
    annotation (
      Documentation(info="<HTML>
<p>
Joint where frame_b rotates around and translates along axis n
which is fixed in frame_a. The two frames coincide when
\"phi=revolute.phi=0\" and \"s=prismatic.s=0\". This joint
has the following potential states;
<ul>
<li> The relative angle phi [rad] around axis n, </li>
<li> the relative distance s [m] along axis n, </li>
<li> the relative angular velocity w [rad/s] (= der(phi))
     and </li>
<li> the relative velocity v [m/s] (= der(s)).</li>
</ul>
<p>
They are used as candidates for automatic selection of states
from the tool. This may be enforced by setting \"stateSelect=StateSelect.<b>always</b>\"
in the <b>Advanced</b> menu. The states are usually selected automatically.
In certain situations, especially when closed kinematic loops are present,
it might be slightly more efficient, when using the \"StateSelect.always\" setting.
</p>
<p>
In the following figure the animation of a cylindrical
joint is shown. The light blue coordinate system is
frame_a and the dark blue coordinate system is
frame_b of the joint. The black arrow is parameter
vector \"n\" defining the cylinder axis
(here: n = {0,0,1}).
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/Cylindrical.png\">
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-100,-50},{0,50}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{0,-30},{100,30}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Line(points={{0,-50},{0,50}}, color={0,0,0}),
          Text(
            extent={{-126,116},{134,56}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{-118,-65},{120,-102}},
            lineColor={0,0,0},
            textString="n=%n")}));
  end Cylindrical;

  model Universal "Universal joint (2 degrees-of-freedom, 4 potential states)"
    import SI = Modelica.SIunits;

    extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n_a={1,0,0}
      "Axis of revolute joint 1 resolved in frame_a" annotation (Evaluate=true);
    parameter Modelica.Mechanics.MultiBody.Types.Axis n_b={0,1,0}
      "Axis of revolute joint 2 resolved in frame_b" annotation (Evaluate=true);

    parameter SI.Distance cylinderLength=world.defaultJointLength
      "Length of cylinders representing the joint axes" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance cylinderDiameter=world.defaultJointWidth
      "Diameter of cylinders representing the joint axes" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of cylinders representing the joint axes" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter StateSelect stateSelect=StateSelect.prefer
      "Priority to use joint coordinates (phi_a, phi_b, w_a, w_b) as states" annotation(Dialog(tab="Advanced"));

    Modelica.Mechanics.MultiBody.Joints.Revolute revolute_a(
      n=n_a,
      stateSelect=StateSelect.never,
      cylinderDiameter=cylinderDiameter,
      cylinderLength=cylinderLength,
      cylinderColor=cylinderColor,
      specularCoefficient=specularCoefficient,
      animation=animation) annotation (Placement(transformation(extent={{-60,
              -25},{-10,25}}, rotation=0)));
    Modelica.Mechanics.MultiBody.Joints.Revolute revolute_b(
      n=n_b,
      stateSelect=StateSelect.never,
      animation=animation,
      cylinderDiameter=cylinderDiameter,
      cylinderLength=cylinderLength,
      cylinderColor=cylinderColor,
      specularCoefficient=specularCoefficient) 
      annotation (Placement(transformation(
          origin={35,45},
          extent={{-25,-25},{25,25}},
          rotation=90)));

    SI.Angle phi_a(start=0, stateSelect=stateSelect)
      "Relative rotation angle from frame_a to intermediate frame";
    SI.Angle phi_b(start=0, stateSelect=stateSelect)
      "Relative rotation angle from intermediate frame to frame_b";
    SI.AngularVelocity w_a(start=0, stateSelect=stateSelect)
      "First derivative of angle phi_a (relative angular velocity a)";
    SI.AngularVelocity w_b(start=0, stateSelect=stateSelect)
      "First derivative of angle phi_b (relative angular velocity b)";
    SI.AngularAcceleration a_a(start=0)
      "Second derivative of angle phi_a (relative angular acceleration a)";
    SI.AngularAcceleration a_b(start=0)
      "Second derivative of angle phi_b (relative angular acceleration b)";

  equation
    phi_a = revolute_a.phi;
    phi_b = revolute_b.phi;
    w_a = der(phi_a);
    w_b = der(phi_b);
    a_a = der(w_a);
    a_b = der(w_b);
    connect(frame_a, revolute_a.frame_a) 
      annotation (Line(
        points={{-100,0},{-60,0}},
        color={95,95,95},
        thickness=0.5));
    connect(revolute_b.frame_b, frame_b) annotation (Line(
        points={{35,70},{35,90},{70,90},{70,0},{100,0}},
        color={95,95,95},
        thickness=0.5));
    connect(revolute_a.frame_b, revolute_b.frame_a) annotation (Line(
        points={{-10,0},{35,0},{35,20}},
        color={95,95,95},
        thickness=0.5));
    annotation (
      Documentation(info="<HTML>
<p>
Joint where frame_a rotates around axis n_a which is fixed in frame_a
and frame_b rotates around axis n_b which is fixed in frame_b.
The two frames coincide when
\"revolute_a.phi=0\" and \"revolute_b.phi=0\". This joint
has the following potential states;
<ul>
<li> The relative angle phi_a = revolute_a.phi [rad] around axis n_a, </li>
<li> the relative angle phi_b = revolute_b.phi [rad] around axis n_b, </li>
<li> the relative angular velocity w_a (= der(phi_a))  and </li>
<li> the relative angular velocity w_b (= der(phi_b)).</li>
</ul>
<p>
They are used as candidates for automatic selection of states
from the tool. This may be enforced by setting \"stateSelect=StateSelect.<b>always</b>\"
in the <b>Advanced</b> menu. The states are usually selected automatically.
In certain situations, especially when closed kinematic loops are present,
it might be slightly more efficient, when using the \"StateSelect.always\" setting.
</p>

<p>
In the following figure the animation of a universal
joint is shown. The light blue coordinate system is
frame_a and the dark blue coordinate system is
frame_b of the joint
(here: n_a = {0,0,1}, n_b = {0,1,0}, phi_a.start = 90<sup>o</sup>,
phi_b.start = 45<sup>o</sup>).
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/Universal.png\">
</p>
</HTML>"),
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-100,15},{-65,-15}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={235,235,235}),
          Ellipse(
            extent={{-80,-80},{80,80}},
            lineColor={160,160,164},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-60,-60},{60,60}},
            lineColor={160,160,164},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-134,-70},{126,-130}},
            textString="%name",
            lineColor={0,0,255}),
          Rectangle(
            extent={{12,82},{80,-82}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{56,15},{100,-15}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={235,235,235}),
          Line(
            points={{12,78},{12,-78}},
            color={0,0,0},
            thickness=0.5),
          Ellipse(
            extent={{-52,-40},{80,40}},
            lineColor={160,160,164},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-32,-20},{60,26}},
            lineColor={160,160,164},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-22,-54},{-60,0},{-22,50},{40,52},{-22,-54}},
            pattern=LinePattern.None,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Line(
            points={{12,78},{12,-20}},
            color={0,0,0},
            thickness=0.5),
          Line(
            points={{32,38},{-12,-36}},
            color={0,0,0},
            thickness=0.5)}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));
  end Universal;

  model Planar "Planar joint (3 degrees-of-freedom, 6 potential states)"
    import SI = Modelica.SIunits;

    extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n={0,0,1}
      "Axis orthogonal to unconstrained plane, resolved in frame_a (= same as in frame_b)"
      annotation (Evaluate=true);
    parameter Modelica.Mechanics.MultiBody.Types.Axis n_x={1,0,0}
      "Vector in direction of x-axis of plane, resolved in frame_a (n_x shall be orthogonal to n)"
      annotation (Evaluate=true);
    parameter SI.Distance cylinderLength=world.defaultJointLength
      "Length of revolute cylinder" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance cylinderDiameter=world.defaultJointWidth
      "Diameter of revolute cylinder" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of revolute cylinder" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance boxWidth=0.3*cylinderDiameter
      "Width of prismatic joint boxes" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance boxHeight=boxWidth "Height of prismatic joint boxes" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color boxColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of prismatic joint boxes" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter StateSelect stateSelect=StateSelect.prefer
      "Priority to use joint coordinates (s_x, s_y, phi, v_x, v_y, w) as states"
                                                                                 annotation(Dialog(tab="Advanced"));

    Prismatic prismatic_x(
      stateSelect=StateSelect.never,
      n=(cross(cross(n, n_x), n)),
      animation=false) annotation (Placement(transformation(extent={{-69,-20},
              {-29,20}}, rotation=0)));
    Prismatic prismatic_y(
      stateSelect=StateSelect.never,
      n=(cross(n, n_x)),
      animation=false) annotation (Placement(transformation(
          origin={0,50},
          extent={{-20,-20},{20,20}},
          rotation=90)));
    Revolute revolute(
      stateSelect=StateSelect.never,
      n=n,
      animation=false) annotation (Placement(transformation(extent={{41,-20},{
              81,20}}, rotation=0)));

    SI.Position s_x(start=0, stateSelect=stateSelect)
      "Relative distance along first prismatic joint starting at frame_a";
    SI.Position s_y(start=0, stateSelect=stateSelect)
      "Relative distance along second prismatic joint starting at first prismatic joint";
    SI.Angle phi(start=0, stateSelect=stateSelect)
      "Relative rotation angle from frame_a to frame_b";
    SI.Velocity v_x(start=0, stateSelect=stateSelect)
      "First derivative of s_x (relative velocity in s_x direction)";
    SI.Velocity v_y(start=0, stateSelect=stateSelect)
      "First derivative of s_y (relative velocity in s_y direction)";
    SI.AngularVelocity w(start=0, stateSelect=stateSelect)
      "First derivative of angle phi (relative angular velocity)";
    SI.Acceleration a_x(start=0)
      "Second derivative of s_x (relative acceleration in s_x direction)";
    SI.Acceleration a_y(start=0)
      "Second derivative of s_y (relative acceleration in s_y direction)";
    SI.AngularAcceleration wd(start=0)
      "Second derivative of angle phi (relative angular acceleration)";

  protected
    parameter Integer ndim=if world.enableAnimation and animation then 1 else 0;
    parameter Real e[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                         n);
  protected
    Visualizers.Advanced.Shape box_x[ndim](
      each shapeType="box",
      each color=boxColor,
      each length=prismatic_x.s,
      each width=boxWidth,
      each height=boxWidth,
      each lengthDirection=prismatic_x.e,
      each widthDirection={0,1,0},
      each r=frame_a.r_0,
      each R=frame_a.R) annotation (Placement(transformation(extent={{-80,30},{
              -60,50}}, rotation=0)));
    Visualizers.Advanced.Shape box_y[ndim](
      each shapeType="box",
      each color=boxColor,
      each length=prismatic_y.s,
      each width=boxWidth,
      each height=boxWidth,
      each lengthDirection=prismatic_y.e,
      each widthDirection={1,0,0},
      each r=prismatic_y.frame_a.r_0,
      each R=prismatic_y.frame_a.R) annotation (Placement(transformation(extent=
             {{-46,69},{-26,89}}, rotation=0)));
    Visualizers.Advanced.Shape cylinder[ndim](
      each shapeType="cylinder",
      each color=cylinderColor,
      each length=cylinderLength,
      each width=cylinderDiameter,
      each height=cylinderDiameter,
      each lengthDirection=n,
      each widthDirection={0,1,0},
      each r_shape=-e*(cylinderLength/2),
      each r=revolute.frame_b.r_0,
      each R=revolute.frame_b.R) annotation (Placement(transformation(extent={{
              50,30},{70,50}}, rotation=0)));
  equation
    s_x = prismatic_x.s;
    s_y = prismatic_y.s;
    phi = revolute.phi;
    v_x = der(s_x);
    v_y = der(s_y);
    w   = der(phi);
    a_x = der(v_x);
    a_y = der(v_y);
    wd  = der(w);

    connect(frame_a, prismatic_x.frame_a) 
      annotation (Line(
        points={{-100,0},{-69,0}},
        color={95,95,95},
        thickness=0.5));
    connect(prismatic_x.frame_b, prismatic_y.frame_a) annotation (Line(
        points={{-29,0},{-1.22465e-015,0},{-1.22465e-015,30}},
        color={95,95,95},
        thickness=0.5));
    connect(prismatic_y.frame_b, revolute.frame_a) annotation (Line(
        points={{1.22465e-015,70},{0,80},{30,80},{30,0},{41,0}},
        color={95,95,95},
        thickness=0.5));
    connect(revolute.frame_b, frame_b) 
      annotation (Line(
        points={{81,0},{100,0}},
        color={95,95,95},
        thickness=0.5));
    annotation (
      Documentation(info="<HTML>
<p>
Joint where frame_b can move in a plane and can rotate around an
axis orthogonal to the plane. The plane is defined by
vector n which is perpendicular to the plane and by vector n_x,
which points in the direction of the x-axis of the plane.
frame_a and frame_b coincide when s_x=prismatic_x.s=0,
s_y=prismatic_y.s=0 and phi=revolute.phi=0. This joint has the following
potential states:
<ul>
<li> the relative distance s_x = prismatic_x.s [m] along axis n_x, </li>
<li> the relative distance s_y = prismatic_y.s [m] along axis n_y = cross(n,n_x), </li>
<li> the relative angle phi = revolute.phi [rad] around axis n, </li>
<li> the relative velocity v_x (= der(s_x)).</li>
<li> the relative velocity v_y (= der(s_y)).</li>
<li> the relative angular velocity w (= der(phi))</li>
</ul>
<p>
They are used as candidates for automatic selection of states
from the tool. This may be enforced by setting \"stateSelect=StateSelect.<b>always</b>\"
in the <b>Advanced</b> menu. The states are usually selected automatically.
In certain situations, especially when closed kinematic loops are present,
it might be slightly more efficient, when using the \"StateSelect.always\" setting.
</p>
<p>
In the following figure the animation of a planar
joint is shown. The light blue coordinate system is
frame_a and the dark blue coordinate system is
frame_b of the joint. The black arrows are parameter
vectors \"n\" and \"n_x\"
(here: n = {0,1,0}, n_x = {0,0,1}, s_x.start = 0.5,
s_y.start = 0.5, phi.start = 45<sup>o</sup>).
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/Planar.png\">
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-30,-60},{-10,60}},
            lineColor={0,0,0},
            pattern=LinePattern.None,
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{10,-60},{30,60}},
            lineColor={0,0,0},
            pattern=LinePattern.None,
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-100,-10},{-30,10}},
            lineColor={0,0,0},
            pattern=LinePattern.None,
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{100,-10},{30,10}},
            lineColor={0,0,0},
            pattern=LinePattern.None,
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-131,-74},{133,-112}},
            lineColor={0,0,0},
            textString="n=%n"),
          Text(
            extent={{-124,127},{136,67}},
            textString="%name",
            lineColor={0,0,255})}));
  end Planar;

  model Spherical
    "Spherical joint (3 constraints and no potential states, or 3 degrees-of-freedom and 3 states)"

    import Modelica.Mechanics.MultiBody.Frames;
    import SI = Modelica.SIunits;

    extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
    parameter Boolean animation=true
      "= true, if animation shall be enabled (show sphere)";
    parameter SI.Distance sphereDiameter=world.defaultJointLength
      "Diameter of sphere representing the spherical joint" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of sphere representing the spherical joint" 
      annotation (Dialog(group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(group="if animation = true", enable=animation));

    parameter Boolean angles_fixed = false
      "= true, if angles_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.Angle angles_start[3]={0,0,0}
      "Initial values of angles to rotate frame_a around 'sequence_start' axes into frame_b"
      annotation (Dialog(tab="Initialization"));
    parameter Types.RotationSequence sequence_start={1,2,3}
      "Sequence of rotations to rotate frame_a into frame_b at initial time" 
      annotation (Evaluate=true, Dialog(tab="Initialization"));

    parameter Boolean w_rel_a_fixed = false
      "= true, if w_rel_a_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularVelocity w_rel_a_start[3]={0,0,0}
      "Initial values of angular velocity of frame_b with respect to frame_a, resolved in frame_a"
      annotation (Dialog(tab="Initialization"));

    parameter Boolean z_rel_a_fixed = false
      "= true, if z_rel_a_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularAcceleration z_rel_a_start[3]={0,0,0}
      "Initial values of angular acceleration z_rel_a = der(w_rel_a)" 
      annotation (Dialog(tab="Initialization"));

    parameter Boolean enforceStates=false
      " = true, if relative variables of spherical joint shall be used as states (StateSelect.always)"
      annotation (Dialog(tab="Advanced"));
    parameter Boolean useQuaternions=true
      " = true, if quaternions shall be used as states otherwise use 3 angles as states (provided enforceStates=true)"
      annotation (Dialog(tab="Advanced", enable=enforceStates));
    parameter Types.RotationSequence sequence_angleStates={1,2,3}
      " Sequence of rotations to rotate frame_a into frame_b around the 3 angles used as states"
       annotation (Evaluate=true, Dialog(tab="Advanced", enable=enforceStates
             and not useQuaternions));

    final parameter Frames.Orientation R_rel_start=
        Frames.axesRotations(sequence_start, angles_start, zeros(3))
      "Orientation object from frame_a to frame_b at initial time";

  protected
    Visualizers.Advanced.Shape sphere(
      shapeType="sphere",
      color=sphereColor,
      specularCoefficient=specularCoefficient,
      length=sphereDiameter,
      width=sphereDiameter,
      height=sphereDiameter,
      lengthDirection={1,0,0},
      widthDirection={0,1,0},
      r_shape={-0.5,0,0}*sphereDiameter,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;

    // Declarations for quaternions (dummies, if quaternions are not used)
    parameter Frames.Quaternions.Orientation Q_start=
              Modelica.Mechanics.MultiBody.Frames.to_Q(R_rel_start)
      "Quaternion orientation object from frame_a to frame_b at initial time";
    Frames.Quaternions.Orientation Q(start=Q_start, stateSelect=if 
          enforceStates and useQuaternions then StateSelect.prefer else 
          StateSelect.never)
      "Quaternion orientation object from frame_a to frame_b (dummy value, if quaternions are not used as states)";

    // Declaration for 3 angles
    parameter SI.Angle phi_start[3]=if sequence_start[1] ==
        sequence_angleStates[1] and sequence_start[2] == sequence_angleStates[2]
         and sequence_start[3] == sequence_angleStates[3] then angles_start else 
         Frames.axesRotationsAngles(R_rel_start, sequence_angleStates)
      "Potential angle states at initial time";
    SI.Angle phi[3](start=phi_start, stateSelect=if enforceStates and not 
          useQuaternions then StateSelect.always else StateSelect.never)
      "Dummy or 3 angles to rotate frame_a into frame_b";
    SI.AngularVelocity phi_d[3](stateSelect=if enforceStates and not 
          useQuaternions then StateSelect.always else StateSelect.never)
      "= der(phi)";
    SI.AngularAcceleration phi_dd[3] "= der(phi_d)";

    // Other declarations
    SI.AngularVelocity w_rel[3](start=Frames.resolve2(R_rel_start, w_rel_a_start),
          fixed = fill(w_rel_a_fixed,3), stateSelect=if 
          enforceStates and useQuaternions then StateSelect.always else 
          StateSelect.never)
      "Dummy or relative angular velocity of frame_b with respect to frame_a, resolved in frame_b";
    Frames.Orientation R_rel
      "Dummy or relative orientation object to rotate from frame_a to frame_b";
    Frames.Orientation R_rel_inv
      "Dummy or relative orientation object to rotate from frame_b to frame_a";
  initial equation
    if angles_fixed then
      if not enforceStates then
        // no states defined in spherical object
        zeros(3) = Frames.Orientation.equalityConstraint(Frames.absoluteRotation(frame_a.R,R_rel_start),frame_b.R);
      elseif useQuaternions then
        // Quaternions Q are used as states
        zeros(3) = Frames.Quaternions.Orientation.equalityConstraint(Q, Q_start);
      else
        // The 3 angles 'phi' are used as states
        phi = phi_start;
      end if;
    end if;

    if z_rel_a_fixed then
      // Initialize acceleration variables
      der(w_rel) = Frames.resolve2(R_rel_start, z_rel_a_start);
    end if;
  equation
    // torque balance
    zeros(3) = frame_a.t;
    zeros(3) = frame_b.t;

    if enforceStates then
      Connections.branch(frame_a.R, frame_b.R);

      frame_b.r_0 = frame_a.r_0;
      if rooted(frame_a.R) then
        R_rel_inv = Frames.nullRotation();
        frame_b.R = Frames.absoluteRotation(frame_a.R, R_rel);
        zeros(3) = frame_a.f + Frames.resolve1(R_rel, frame_b.f);
      else
        R_rel_inv = Frames.inverseRotation(R_rel);
        frame_a.R = Frames.absoluteRotation(frame_b.R, R_rel_inv);
        zeros(3) = frame_b.f + Frames.resolve2(R_rel, frame_a.f);
      end if;

      // Compute relative orientation object
      if useQuaternions then
        // Use Quaternions as states (with dynamic state selection)
        {0} = Frames.Quaternions.orientationConstraint(Q);
        w_rel = Frames.Quaternions.angularVelocity2(Q, der(Q));
        R_rel = Frames.from_Q(Q, w_rel);

        // Dummies
        phi = zeros(3);
        phi_d = zeros(3);
        phi_dd = zeros(3);

      else
        // Use angles as states
        phi_d = der(phi);
        phi_dd = der(phi_d);
        R_rel = Frames.axesRotations(sequence_angleStates, phi, phi_d);
        w_rel = Frames.angularVelocity2(R_rel);

        // Dummies
        Q = zeros(4);
      end if;

    else
      // Spherical joint does not have states
      frame_b.r_0 = frame_a.r_0;
      //frame_b.r_0 = transpose(frame_b.R.T)*(frame_b.R.T*(transpose(frame_a.R.T)*(frame_a.R.T*frame_a.r_0)));

      zeros(3) = frame_a.f + Frames.resolveRelative(frame_b.f, frame_b.R, frame_a.R);

      if w_rel_a_fixed or z_rel_a_fixed then
        w_rel = Frames.angularVelocity2(frame_b.R) - Frames.resolve2(frame_b.R,
           Frames.angularVelocity1(frame_a.R));
      else
        w_rel = zeros(3);
      end if;

      // Dummies
      R_rel = Frames.nullRotation();
      R_rel_inv = Frames.nullRotation();
      Q = zeros(4);
      phi = zeros(3);
      phi_d = zeros(3);
      phi_dd = zeros(3);
    end if;
    annotation (
      Documentation(info="<html>
<p>
Joint with <b>3 constraints</b> that define that the origin of
frame_a and the origin of frame_b coincide. By default this joint
defines only the 3 constraints without any potential states.
If parameter <b>enforceStates</b> is set to <b>true</b>
in the \"Advanced\" menu, three states are introduced.
Depending on parameter <b>useQuaternions</b> these are either
quaternions and the relative angular velocity or 3 angles
and the angle derivatves. In the latter case the orientation
of frame_b is computed by rotating frame_a along the axes defined
in parameter vector \"sequence_angleStates\" (default = {1,2,3}, i.e.,
the Cardan angle sequence) around the angles used as states.
For example, the default is to rotate the x-axis of frame_a
around angles[1], the new y-axis around angles[2] and the new z-axis
around angles[3], arriving at frame_b. If angles are used
as states there is the slight disadvantage that
a singular configuration is present leading to a divison by zero.
</p>
<p>
If this joint is used in a <b>chain</b> structure, a Modelica translator
has to select orientation coordinates of a body as states, if the
default setting is used. It is usually better to use relative coordinates
in the spherical joint as states, and therefore in this situation
parameter enforceStates might be set to <b>true</b>.
</p>
<p>
If this joint is used in a <b>loop</b> structure, the default
setting results in a <b>cut-joint</b> that
breaks the loop in independent kinematic pieces, hold together
by the constraints of this joint. As a result, a Modelica translator
will first try to select 3 generalized coordinates in the joints of
the remaining parts of the loop and their first derivative as states
and if this is not possible, e.g., because there are only spherical
joints in the loop, will select coordinates from a body of the loop
as states.
</p>
<p>
In the following figure the animation of a spherical
joint is shown. The light blue coordinate system is
frame_a and the dark blue coordinate system is
frame_b of the joint.
(here: angles_start = {45, 45, 45}<sup>o</sup>).
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/Spherical.png\">
</p>
</html>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(
            extent={{-70,-70},{70,70}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-49,-50},{51,50}},
            lineColor={128,128,128},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{30,70},{71,-68}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-100,10},{-68,-10}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{23,10},{100,-10}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-24,25},{26,-25}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={160,160,164}),
          Text(
            extent={{-100,-132},{100,-72}},
            textString="%name",
            lineColor={0,0,255})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(
            extent={{-70,-70},{70,70}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-49,-50},{51,50}},
            lineColor={128,128,128},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{30,70},{71,-68}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-100,10},{-68,-10}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{23,10},{100,-10}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-24,25},{26,-25}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={160,160,164})}));
  end Spherical;

  model FreeMotion
    "Free motion joint (6 degrees-of-freedom, 12 potential states)"

    import Modelica.Math.*;
    import SI = Modelica.SIunits;

    extends Interfaces.PartialTwoFrames;

    parameter Boolean animation=true
      "= true, if animation shall be enabled (show arrow from frame_a to frame_b)";

    SI.Position r_rel_a[3](start={0,0,0}, stateSelect=if enforceStates then 
                StateSelect.always else StateSelect.prefer)
      "Position vector from origin of frame_a to origin of frame_b, resolved in frame_a"
      annotation(Dialog(group="Initialization", __Dymola_initialDialog=true));
    SI.Velocity v_rel_a[3](start={0,0,0}, stateSelect=if enforceStates then StateSelect.always else 
                StateSelect.prefer)
      "= der(r_rel_a), i.e., velocity of origin of frame_b with respect to origin of frame_a, resolved in frame_a"
      annotation(Dialog(group="Initialization", __Dymola_initialDialog=true));
    SI.Acceleration a_rel_a[3](start={0,0,0}) "= der(v_rel_a)" 
      annotation(Dialog(group="Initialization", __Dymola_initialDialog=true));

    parameter Boolean angles_fixed = false
      "= true, if angles_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(group="Initialization"));
    parameter SI.Angle angles_start[3]={0,0,0}
      "Initial values of angles to rotate frame_a around 'sequence_start' axes into frame_b"
      annotation (Dialog(group="Initialization"));
    parameter Types.RotationSequence sequence_start={1,2,3}
      "Sequence of rotations to rotate frame_a into frame_b at initial time" 
      annotation (Evaluate=true, Dialog(group="Initialization"));

    parameter Boolean w_rel_a_fixed = false
      "= true, if w_rel_a_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(group="Initialization"));
    parameter SI.AngularVelocity w_rel_a_start[3]={0,0,0}
      "Initial values of angular velocity of frame_b with respect to frame_a, resolved in frame_a"
      annotation (Dialog(group="Initialization"));

    parameter Boolean z_rel_a_fixed = false
      "= true, if z_rel_a_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(group="Initialization"));
    parameter SI.AngularAcceleration z_rel_a_start[3]={0,0,0}
      "Initial values of angular acceleration z_rel_a = der(w_rel_a)" 
      annotation (Dialog(group="Initialization"));

    parameter SI.Length arrowDiameter=world.defaultArrowDiameter
      "Diameter of arrow from frame_a to frame_b" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color arrowColor=Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor
      "Color of arrow" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Boolean enforceStates=true
      " = true, if relative variables between frame_a and frame_b shall be used as states"
      annotation (Dialog(tab="Advanced"));
    parameter Boolean useQuaternions=true
      " = true, if quaternions shall be used as states otherwise use 3 angles as states"
      annotation (Dialog(tab="Advanced"));
    parameter Types.RotationSequence sequence_angleStates={1,2,3}
      " Sequence of rotations to rotate frame_a into frame_b around the 3 angles used as states"
       annotation (Evaluate=true, Dialog(tab="Advanced", enable=not 
            useQuaternions));

    final parameter Frames.Orientation R_rel_start=
        Modelica.Mechanics.MultiBody.Frames.axesRotations(sequence_start, angles_start,zeros(3))
      "Orientation object from frame_a to frame_b at initial time";

  protected
    Visualizers.Advanced.Arrow arrow(
      r_head=r_rel_a,
      diameter=arrowDiameter,
      color=arrowColor,
      specularCoefficient=specularCoefficient,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;

    // Declarations for quaternions (dummies, if quaternions are not used)
    parameter Frames.Quaternions.Orientation Q_start=Frames.to_Q(R_rel_start)
      "Quaternion orientation object from frame_a to frame_b at initial time";
    Frames.Quaternions.Orientation Q(start=Q_start, stateSelect=if 
          enforceStates then (if useQuaternions then StateSelect.prefer else 
          StateSelect.never) else StateSelect.default)
      "Quaternion orientation object from frame_a to frame_b (dummy value, if quaternions are not used as states)";

    // Declaration for 3 angles
    parameter SI.Angle phi_start[3]=if sequence_start[1] ==
        sequence_angleStates[1] and sequence_start[2] == sequence_angleStates[2]
         and sequence_start[3] == sequence_angleStates[3] then angles_start else 
              Frames.axesRotationsAngles(R_rel_start,
        sequence_angleStates) "Potential angle states at initial time";
    SI.Angle phi[3](start=phi_start, stateSelect=if enforceStates then (if 
          useQuaternions then StateSelect.never else StateSelect.always) else 
          StateSelect.prefer)
      "Dummy or 3 angles to rotate frame_a into frame_b";
    SI.AngularVelocity phi_d[3](stateSelect=if enforceStates then (if 
          useQuaternions then StateSelect.never else StateSelect.always) else 
          StateSelect.prefer) "= der(phi)";
    SI.AngularAcceleration phi_dd[3] "= der(phi_d)";

    // Other declarations
    SI.AngularVelocity w_rel_b[3](start=Frames.resolve2(R_rel_start, w_rel_a_start),
                                  fixed=fill(w_rel_a_fixed,3),
                                  stateSelect=if enforceStates then 
                                  (if useQuaternions then StateSelect.always else 
                                  StateSelect.avoid) else StateSelect.prefer)
      "Dummy or relative angular velocity of frame_b with respect to frame_a, resolved in frame_b";
    Frames.Orientation R_rel
      "Dummy or relative orientation object to rotate from frame_a to frame_b";
    Frames.Orientation R_rel_inv
      "Dummy or relative orientation object to rotate from frame_b to frame_a";

  initial equation
    if angles_fixed then
      // Initialize positional variables
      if not enforceStates then
        // no states defined
        zeros(3) = Frames.Orientation.equalityConstraint(Frames.absoluteRotation(frame_a.R,R_rel_start),frame_b.R);
      elseif useQuaternions then
        // Quaternions Q are used as states
        zeros(3) = Frames.Quaternions.Orientation.equalityConstraint(Q, Q_start);
      else
        // The 3 angles 'phi' are used as states
        phi = phi_start;
      end if;
    end if;

    if z_rel_a_fixed then
      // Initialize acceleration variables
      der(w_rel_b) = Frames.resolve2(R_rel_start, z_rel_a_start);
    end if;

  equation
    // Kinematic differential equations for translational motion
    der(r_rel_a) = v_rel_a;
    der(v_rel_a) = a_rel_a;

    // Kinematic relationships
    frame_b.r_0 = frame_a.r_0 + Frames.resolve1(frame_a.R, r_rel_a);

    // Cut-forces and cut-torques are zero
    frame_a.f = zeros(3);
    frame_a.t = zeros(3);
    frame_b.f = zeros(3);
    frame_b.t = zeros(3);

    if enforceStates then
      Connections.branch(frame_a.R, frame_b.R);

      if rooted(frame_a.R) then
        R_rel_inv = Frames.nullRotation();
        frame_b.R = Frames.absoluteRotation(frame_a.R, R_rel);
      else
        R_rel_inv = Frames.inverseRotation(R_rel);
        frame_a.R = Frames.absoluteRotation(frame_b.R, R_rel_inv);
      end if;

      // Compute relative orientation object
      if useQuaternions then
        // Use Quaternions as states (with dynamic state selection)
        {0} = Frames.Quaternions.orientationConstraint(Q);
        w_rel_b = Frames.Quaternions.angularVelocity2(Q, der(Q));
        R_rel = Frames.from_Q(Q, w_rel_b);

        // Dummies
        phi = zeros(3);
        phi_d = zeros(3);
        phi_dd = zeros(3);

      else
        // Use angles as states
        phi_d = der(phi);
        phi_dd = der(phi_d);
        R_rel = Frames.axesRotations(sequence_angleStates, phi, phi_d);
        w_rel_b = Frames.angularVelocity2(R_rel);

        // Dummies
        Q = zeros(4);
      end if;

    else
      // Free motion joint does not have states
      if w_rel_a_fixed or z_rel_a_fixed then
        w_rel_b = Frames.angularVelocity2(frame_b.R) - Frames.resolve2(frame_b.
          R, Frames.angularVelocity1(frame_a.R));
      else
        // dummy
        w_rel_b = zeros(3);
      end if;

      // Dummies
      R_rel = Frames.nullRotation();
      R_rel_inv = Frames.nullRotation();
      Q = zeros(4);
      phi = zeros(3);
      phi_d = zeros(3);
      phi_dd = zeros(3);
    end if;
    annotation (
      Documentation(info="<HTML>
<p>
Joint which does not constrain the motion between frame_a and frame_b.
Such a joint is only meaningful if the <b>relative</b> distance and orientation
between frame_a and frame_b, and their derivatives, shall be used
as <b>states</b>.
</p>
<p>
Note, that <b>bodies</b> such as Parts.Body, Parts.BodyShape,
have potential states describing the distance
and orientation, and their derivatives, between the <b>world frame</b> and
a <b>body fixed frame</b>.
Therefore, if these potential state variables are suited,
a FreeMotion joint is not needed.
</p>
The states of the FreeMotion object are:
</p>
<ul>
<li> The <b>relative position vector</b> r_rel_a from the origin of
     frame_a to the origin of frame_b, resolved in
     frame_a and the <b>relative velocity</b> v_rel_a of the origin of
     frame_b with respect to the origin of frame_a, resolved in frame_a
     (= der(r_rel_a)).</li>
</li>
<li> If parameter <b>useQuaternions</b> in the \"Advanced\" menu
     is <b>true</b> (this is the default), then <b>4 quaternions</b>
     are states. Additionally, the coordinates of the
     relative angular velocity vector are 3 potential states.<br>
     If <b>useQuaternions</b> in the \"Advanced\" menu
     is <b>false</b>, then <b>3 angles</b> and the derivatives of
     these angles are potential states. The orientation of frame_b
     is computed by rotating frame_a along the axes defined
     in parameter vector \"sequence_angleStates\" (default = {1,2,3}, i.e.,
     the Cardan angle sequence) around the angles used as states.
     For example, the default is to rotate the x-axis of frame_a
     around angles[1], the new y-axis around angles[2] and the new z-axis
     around angles[3], arriving at frame_b.
 </li>
</ul>
<p>
The quaternions have the slight disadvantage that there is a
non-linear constraint equation between the 4 quaternions.
Therefore, at least one non-linear equation has to be solved
during simulation. A tool might, however, analytically solve this
simple constraint equation. Using the 3 angles as states has the
disadvantage that there is a singular configuration in which a
division by zero will occur. If it is possible to determine in advance
for an application class that this singular configuration is outside
of the operating region, the 3 angles might be used as
states by setting <b>useQuaternions</b> = <b>false</b>.
</p>
<p>
In text books about 3-dimensional mechanics often 3 angles and the
angular velocity are used as states. This is not the case here, since
3 angles and their derivatives are used as states
(if useQuaternions = false). The reason
is that for real-time simulation the discretization formula of the
integrator might be \"inlined\" and solved together with the model equations.
By appropriate symbolic transformation the performance is
drastically increased if angles and their
derivatives are used as states, instead of angles and the angular
velocity.
</p>
<p>
If parameter
<b>enforceStates</b> is set to <b>true</b> (= the default)
in the \"Advanced\" menu,
then FreeMotion variables are forced to be used as states according
to the setting of parameters \"useQuaternions\" and
\"sequence_angleStates\".
</p>
<p>
In the following figure the animation of a FreeMotion
joint is shown. The light blue coordinate system is
frame_a and the dark blue coordinate system is
frame_b of the joint.
(here: r_rel_a_start = {0.5, 0, 0.5}, angles_start = {45, 45, 45}<sup>o</sup>).
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/FreeMotion.png\">
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(
            points={{-86,31},{-74,61},{-49,83},{-17,92},{19,88},{40,69},{59,48}}, 

            color={160,160,164},
            thickness=0.5),
          Polygon(
            points={{90,0},{50,20},{50,-20},{90,0}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{69,58},{49,40},{77,28},{69,58}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{136,-35},{-150,-98}},
            lineColor={0,0,255},
            textString="%name"),
          Rectangle(
            extent={{-70,-5},{-90,5}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{50,-5},{30,5}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{11,-5},{-9,5}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-30,-5},{-50,5}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(
            points={{-86,31},{-74,61},{-49,83},{-17,92},{19,88},{40,69},{59,48}}, 

            color={160,160,164},
            thickness=0.5),
          Polygon(
            points={{90,0},{50,20},{50,-20},{90,0}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{69,58},{49,40},{77,28},{69,58}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{50,-5},{30,5}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{11,-5},{-9,5}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-30,-5},{-50,5}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-70,-5},{-90,5}},
            lineColor={0,0,0},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid)}));
  end FreeMotion;

  model SphericalSpherical
    "Spherical - spherical joint aggregation (1 constraint, no potential states) with an optional point mass in the middle"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;
    extends Interfaces.PartialTwoFrames;

    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Boolean showMass=true
      "= true, if mass shall be shown (provided animation = true and m > 0)";
    parameter Boolean computeRodLength=false
      "= true, if rodLength shall be computed during initialization (see info)";
    parameter SI.Length rodLength(
      min=Modelica.Constants.eps,
      fixed=not computeRodLength, start = 1)
      "Distance between the origins of frame_a and frame_b (if computeRodLength=true, guess value)";
    parameter SI.Mass m(min=0)=0
      "Mass of rod (= point mass located in middle of rod)";
    parameter SI.Diameter sphereDiameter=world.defaultJointLength
      "Diameter of spheres respresenting the spherical joints" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of spheres respresenting the spherical joints" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Diameter rodDiameter=sphereDiameter/Types.Defaults.JointRodDiameterFraction
      "Diameter of rod connecting the two spherical joint" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color rodColor=Modelica.Mechanics.MultiBody.Types.Defaults.RodColor
      "Color of rod connecting the two spherical joints" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Diameter massDiameter=sphereDiameter
      "Diameter of sphere representing the mass point" 
      annotation (Dialog(tab=
            "Animation", group="if animation = true and showMass = true and m > 0",
            enable=animation and showMass and m > 0));
    input Types.Color massColor=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      "Color of sphere representing the mass point"  annotation (
        Dialog(tab="Animation", group=
            "if animation = true and showMass = true and m > 0",
            enable=animation and showMass and m > 0));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

    parameter Boolean kinematicConstraint=true
      "= false, if no constraint shall be defined, due to analytically solving a kinematic loop (\"false\" should not be used by user, but only by MultiBody.Joints.Assemblies joints)"
      annotation (Dialog(tab="Advanced"));
    Real constraintResidue = rRod_0*rRod_0 - rodLength*rodLength
      "Constraint equation of joint in residue form: Either length constraint (= default) or equation to compute rod force (for analytic solution of loops in combination with Internal.RevoluteWithLengthConstraint/PrismaticWithLengthConstraint)"
      annotation (Dialog(tab="Advanced", enable=not kinematicConstraint));
    parameter Boolean checkTotalPower=false
      "= true, if total power flowing into this component shall be determined (must be zero)"
      annotation (Dialog(tab="Advanced"));

    SI.Force f_rod
      "Constraint force in direction of the rod (positive on frame_a, when directed from frame_a to frame_b)";
    SI.Position rRod_0[3]
      "Position vector from frame_a to frame_b resolved in world frame";
    SI.Position rRod_a[3]
      "Position vector from frame_a to frame_b resolved in frame_a";
    Real eRod_a[3](each final unit="1")
      "Unit vector in direction from frame_a to frame_b, resolved in frame_a";
    SI.Position r_CM_0[3]
      "Dummy if m==0, or position vector from world frame to mid-point of rod, resolved in world frame";
    SI.Velocity v_CM_0[3] "First derivative of r_CM_0";
    SI.Force f_CM_a[3]
      "Dummy if m==0, or inertial force acting at mid-point of rod due to mass oint acceleration, resolved in frame_a";
    SI.Force f_CM_e[3]
      "Dummy if m==0, or projection of f_CM_a onto eRod_a, resolved in frame_a";
    SI.Force f_b_a1[3]
      "Force acting at frame_b, but without force in rod, resolved in frame_a";
    SI.Power totalPower
      "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";

  protected
    Visualizers.Advanced.Shape shape_rod(
      shapeType="cylinder",
      color=rodColor,
      specularCoefficient=specularCoefficient,
      length=rodLength,
      width=rodDiameter,
      height=rodDiameter,
      lengthDirection=eRod_a,
      widthDirection={0,1,0},
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape shape_a(
      shapeType="sphere",
      color=sphereColor,
      specularCoefficient=specularCoefficient,
      length=sphereDiameter,
      width=sphereDiameter,
      height=sphereDiameter,
      lengthDirection=eRod_a,
      widthDirection={0,1,0},
      r_shape=-eRod_a*(sphereDiameter/2),
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape shape_b(
      shapeType="sphere",
      color=sphereColor,
      specularCoefficient=specularCoefficient,
      length=sphereDiameter,
      width=sphereDiameter,
      height=sphereDiameter,
      lengthDirection=eRod_a,
      widthDirection={0,1,0},
      r_shape=eRod_a*(rodLength - sphereDiameter/2),
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape shape_mass(
      shapeType="sphere",
      color=massColor,
      specularCoefficient=specularCoefficient,
      length=massDiameter,
      width=massDiameter,
      height=massDiameter,
      lengthDirection=eRod_a,
      widthDirection={0,1,0},
      r_shape=eRod_a*(rodLength/2 - sphereDiameter/2),
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation and showMass and m > 0;
  equation
    // Determine relative position vector between the two frames
    if kinematicConstraint then
      rRod_0 = transpose(frame_b.R.T)*(frame_b.R.T*frame_b.r_0) - transpose(
        frame_a.R.T)*(frame_a.R.T*frame_a.r_0);
    else
      rRod_0 = frame_b.r_0 - frame_a.r_0;
    end if;

    //rRod_0 = frame_b.r_0 - frame_a.r_0;
    rRod_a = Frames.resolve2(frame_a.R, rRod_0);
    eRod_a = rRod_a/rodLength;

    // Constraint equation
    constraintResidue = 0;

    // Cut-torques at frame_a and frame_b
    frame_a.t = zeros(3);
    frame_b.t = zeros(3);

    /* Force and torque balance of rod
     - Kinematics for center of mass CM of mass point
       r_CM_0 = frame_a.r_0 + rRod_0/2;
       v_CM_0 = der(r_CM_0);
       a_CM_a = resolve2(frame_a.R, der(v_CM_0) - world.gravityAcceleration(r_CM_0));
     - Inertial and gravity force in direction (f_CM_e) and orthogonal (f_CM_n) to rod
       f_CM_a = m*a_CM_a
       f_CM_e = f_CM_a*eRod_a;           // in direction of rod
       f_CM_n = rodLength(f_CM_a - f_CM_e);  // orthogonal to rod
     - Force balance in direction of rod
       f_CM_e = fa_rod_e + fb_rod_e;
     - Force balance orthogonal to rod
       f_CM_n = fa_rod_n + fb_rod_n;
     - Torque balance with respect to frame_a
       0 = (-f_CM_n)*rodLength/2 + fb_rod_n*rodLength
     The result is:
     fb_rod_n = f_CM_n/2;
     fa_rod_n = fb_rod_n;
     fb_rod_e = f_CM_e - fa_rod_e;
     fa_rod_e is the unknown computed from loop
  */

      // f_b_a1 is needed in aggregation joints to solve kinematic loops analytically
    if m > 0 then
      r_CM_0 = frame_a.r_0 + rRod_0/2;
      v_CM_0 = der(r_CM_0);
      f_CM_a = m*Frames.resolve2(frame_a.R, der(v_CM_0) -
        world.gravityAcceleration(r_CM_0));
      f_CM_e = (f_CM_a*eRod_a)*eRod_a;
      frame_a.f = (f_CM_a - f_CM_e)/2 + f_rod*eRod_a;
      f_b_a1 = (f_CM_a + f_CM_e)/2;
      frame_b.f = Frames.resolveRelative(f_b_a1 - f_rod*eRod_a, frame_a.R,
        frame_b.R);
    else
      r_CM_0 = zeros(3);
      v_CM_0 = zeros(3);
      f_CM_a = zeros(3);
      f_CM_e = zeros(3);
      f_b_a1 = zeros(3);
      frame_a.f = f_rod*eRod_a;
      frame_b.f = -Frames.resolveRelative(frame_a.f, frame_a.R, frame_b.R);
    end if;

    if checkTotalPower then
      totalPower = frame_a.f*Frames.resolve2(frame_a.R, der(frame_a.r_0)) +
        frame_b.f*Frames.resolve2(frame_b.R, der(frame_b.r_0)) + (-m)*(der(
        v_CM_0) - world.gravityAcceleration(r_CM_0))*v_CM_0 + frame_a.t*
        Frames.angularVelocity2(frame_a.R) + frame_b.t*Frames.angularVelocity2(
        frame_b.R);
    else
      totalPower = 0;
    end if;
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(
            extent={{-95,-40},{-15,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-84,-30},{-24,30}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{15,-40},{95,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{25,-29},{85,30}},
            lineColor={128,128,128},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-149,111},{141,51}},
            textString="%name",
            lineColor={0,0,255}),
          Rectangle(
            extent={{-40,40},{41,-41}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-51,6},{48,-4}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-68,15},{-39,-13}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{39,14},{68,-14}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Text(
            extent={{-130,-58},{137,-98}},
            lineColor={0,0,0},
            textString="%rodLength")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Ellipse(
            extent={{-98,-40},{-18,40}},
            lineColor={0,0,0},
            fillColor={160,160,164},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-88,-30},{-28,30}},
            lineColor={160,160,164},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{18,-40},{98,40}},
            lineColor={160,160,164},
            fillColor={160,160,164},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{29,-30},{89,29}},
            lineColor={192,192,192},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Line(points={{-56,-60},{46,-60}}, color={0,0,255}),
          Polygon(
            points={{56,-60},{41,-54},{41,-66},{56,-60}},
            lineColor={0,0,255},
            fillColor={0,0,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-37,-63},{33,-79}},
            textString="rodLength",
            lineColor={0,0,255}),
          Rectangle(
            extent={{-40,41},{40,-40}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-51,6},{48,-4}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-71,15},{-42,-13}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{42,14},{71,-14}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{-56,-71},{-56,1}}, color={0,0,255}),
          Line(points={{56,-72},{56,0}}, color={0,0,255}),
          Polygon(points={{11,1},{-1,4},{-1,-2},{11,1}}, lineColor={0,0,255}),
          Line(points={{-56,1},{-1,1}}, color={0,0,255}),
          Text(
            extent={{-32,-4},{4,-29}},
            lineColor={0,0,0},
            textString="eRod_a")}),
      Documentation(info="<html>
<p>
Joint that has a spherical joint on each of its two ends.
The rod connecting the two spherical joints is approximated by a
point mass that is located in the middle of the rod. When the mass
is set to zero (default), special code for a massless body is generated.
In the following default animation figure, the two spherical joints are
represented by two red spheres, the connecting rod by a grey cylinder
and the point mass in the middle of the rod by a light blue sphere:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/SphericalSpherical.png\" ALT=\"model Joints.SphericalSpherical\">
</p>
This joint introduces <b>one constraint</b> defining that the distance between
the origin of frame_a and the origin of frame_b is constant (= rodLength).
It is highly recommended to use this joint in loops
whenever possible, because this enhances the efficiency
considerably due to smaller systems of non-linear algebraic
equations.
</p>
<p>
It is sometimes desirable to <b>compute</b> the <b>rodLength</b>
of the connecting rod during initialization. For this, parameter
<b>computeLength</b> has to be set to <b>true</b> and instead <b>one</b> other,
easier to determine, position variable in the same loop
needs to have a fixed attribute of <b>true</b>. For example,
if a loop consists of one Revolute joint, one Prismatic joint and
a SphericalSpherical joint, one may fix the start values of the revolute
joint angle and of the relative distance of the prismatic joint
in order to compute the rodLength of the rod.
</p>
<p>
It is not possible to connect other components, such as a body with mass
properties or a special visual shape object to the rod connecting
the two spherical joints. If this is needed, use instead joint Joints.<b>UniversalSpherical</b>
that has this property.
</p>
</html>"));
  end SphericalSpherical;

  model UniversalSpherical
    "Universal - spherical joint aggregation (1 constraint, no potential states)"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;

    extends Interfaces.PartialTwoFrames;
    Interfaces.Frame_a frame_ia
      "Coordinate system at the origin of frame_a, fixed at the rod connecting the universal with the spherical joint"
      annotation (Placement(transformation(
          origin={-40,100},
          extent={{-16,-16},{16,16}},
          rotation=270)));
    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter Boolean showUniversalAxes=true
      " = true, if universal joint shall be visualized with two cylinders, otherwise with a sphere (provided animation=true)";
    parameter Boolean computeRodLength=false
      "= true, if distance between frame_a and frame_b shall be computed during initialization (see info)";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n1_a={0,0,1}
      "Axis 1 of universal joint resolved in frame_a (axis 2 is orthogonal to axis 1 and to rod)"
      annotation (Evaluate=true);
    parameter SI.Position rRod_ia[3]={1,0,0}
      "Vector from origin of frame_a to origin of frame_b, resolved in frame_ia (if computeRodLength=true, rRod_ia is only an axis vector along the connecting rod)"
      annotation (Evaluate=true);
    parameter SI.Diameter sphereDiameter=world.defaultJointLength
      "Diameter of spheres representing the universal and the spherical joint" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of spheres representing the universal and the spherical joint" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.ShapeType rodShapeType="cylinder"
      "Shape type of rod connecting the universal and the spherical joint" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance rodWidth=sphereDiameter/Types.Defaults.JointRodDiameterFraction
      "Width of rod shape in direction of axis 2 of universal joint." 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance rodHeight=rodWidth
      "Height of rod shape in direction that is orthogonal to rod and to axis 2"
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.ShapeExtra rodExtra=0.0
      "Additional parameter depending on rodShapeType" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color rodColor=Modelica.Mechanics.MultiBody.Types.Defaults.RodColor
      "Color of rod shape connecting the universal and the spherical joints" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance cylinderLength=world.defaultJointLength
      "Length of cylinders representing the two universal joint axes" annotation (
       Dialog(tab="Animation", group="if animation = true and showUniversalAxes",
                               enable=animation and showUniversalAxes));
    parameter SI.Distance cylinderDiameter=world.defaultJointWidth
      "Diameter of cylinders representing the two universal joint axes" 
      annotation (Dialog(tab="Animation", group=
            "if animation = true and showUniversalAxes",
            enable=animation and showUniversalAxes));
    input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
      "Color of cylinders representing the two universal joint axes" annotation (
        Dialog(tab="Animation", group="if animation = true and showUniversalAxes",
                                enable=animation and showUniversalAxes));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

    parameter Boolean kinematicConstraint=true
      "= false, if no constraint shall be defined, due to analytically solving a kinematic loop"
      annotation (Dialog(tab="Advanced"));
    Real constraintResidue = rRod_0*rRod_0 - rodLength*rodLength
      "Constraint equation of joint in residue form: Either length constraint (= default) or equation to compute rod force (for analytic solution of loops in combination with Internal.RevoluteWithLengthConstraint/PrismaticWithLengthConstraint)"
      annotation (Dialog(tab="Advanced", enable=not kinematicConstraint));
    parameter Boolean checkTotalPower=false
      "= true, if total power flowing into this component shall be determined (must be zero)"
      annotation (Dialog(tab="Advanced"));
    SI.Force f_rod
      "Constraint force in direction of the rod (positive, if rod is pressed)";
    final parameter SI.Distance rodLength(fixed=not computeRodLength)=
      Modelica.Math.Vectors.length(
                    rRod_ia)
      "Length of rod (distance between origin of frame_a and origin of frame_b)";
    final parameter Real eRod_ia[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                                     rRod_ia)
      "Unit vector from origin of frame_a to origin of frame_b, resolved in frame_ia";
    final parameter Real e2_ia[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                                   cross(n1_a, eRod_ia))
      "Unit vector in direction of axis 2 of universal joint, resolved in frame_ia (orthogonal to n1_a and eRod_ia; note: frame_ia is parallel to frame_a when the universal joint angles are zero)";
    final parameter Real e3_ia[3](each final unit="1")=cross(eRod_ia, e2_ia)
      "Unit vector perpendicular to eRod_ia and e2_ia, resolved in frame_ia";
    SI.Power totalPower
      "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";
    SI.Force f_b_a1[3]
      "frame_b.f without f_rod part, resolved in frame_a (needed for analytic loop handling)";
    Real eRod_a[3](each final unit="1")
      "Unit vector in direction of rRod_a, resolved in frame_a (needed for analytic loop handling)";
    SI.Position rRod_0[3](start=rRod_ia)
      "Position vector from origin of frame_a to origin of frame_b resolved in world frame";
    SI.Position rRod_a[3](start=rRod_ia)
      "Position vector from origin of frame_a to origin of frame_b resolved in frame_a";

  protected
    SI.Force f_b_a[3] "frame_b.f resolved in frame_a";
    SI.Force f_ia_a[3] "frame_ia.f resolved in frame_a";
    SI.Torque t_ia_a[3] "frame_ia.t resolved in frame_a";
    Real n2_a[3](each final unit="1")
      "Vector in direction of axis 2 of the universal joint (e2_ia), resolved in frame_a";
    Real length2_n2_a(start=1, unit="m2") "Square of length of vector n2_a";
    SI.Length length_n2_a "Length of vector n2_a";
    Real e2_a[3](each final unit="1")
      "Unit vector in direction of axis 2 of the universal joint (e2_ia), resolved in frame_a";
    Real e3_a[3](each final unit="1")
      "Unit vector perpendicular to eRod_ia and e2_a, resolved in frame_a";
    Real der_rRod_a_L[3](each unit="1/s") "= der(rRod_a)/rodLength";
    SI.AngularVelocity w_rel_ia1[3];
    Frames.Orientation R_rel_ia1;
    Frames.Orientation R_rel_ia2;
    // Real T_rel_ia[3, 3];
    Frames.Orientation R_rel_ia "Rotation from frame_a to frame_ia";

    Visualizers.Advanced.Shape rodShape(
      shapeType=rodShapeType,
      color=rodColor,
      specularCoefficient=specularCoefficient,
      length=rodLength,
      width=rodWidth,
      height=rodHeight,
      lengthDirection=eRod_ia,
      widthDirection=e2_ia,
      r=frame_ia.r_0,
      R=frame_ia.R) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape sphericalShape_b(
      shapeType="sphere",
      color=sphereColor,
      specularCoefficient=specularCoefficient,
      length=sphereDiameter,
      width=sphereDiameter,
      height=sphereDiameter,
      lengthDirection={1,0,0},
      widthDirection={0,1,0},
      r_shape={-0.5,0,0}*sphereDiameter,
      r=frame_b.r_0,
      R=frame_b.R) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape sphericalShape_a(
      shapeType="sphere",
      color=sphereColor,
      specularCoefficient=specularCoefficient,
      length=sphereDiameter,
      width=sphereDiameter,
      height=sphereDiameter,
      lengthDirection={1,0,0},
      widthDirection={0,1,0},
      r_shape={-0.5,0,0}*sphereDiameter,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation and not showUniversalAxes;
    Visualizers.Advanced.Shape universalShape1(
      shapeType="cylinder",
      color=cylinderColor,
      specularCoefficient=specularCoefficient,
      length=cylinderLength,
      width=cylinderDiameter,
      height=cylinderDiameter,
      lengthDirection=n1_a,
      widthDirection={0,1,0},
      r_shape=-n1_a*(cylinderLength/2),
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation and showUniversalAxes;
    Visualizers.Advanced.Shape universalShape2(
      shapeType="cylinder",
      color=cylinderColor,
      specularCoefficient=specularCoefficient,
      length=cylinderLength,
      width=cylinderDiameter,
      height=cylinderDiameter,
      lengthDirection=e2_ia,
      widthDirection={0,1,0},
      r_shape=-e2_ia*(cylinderLength/2),
      r=frame_ia.r_0,
      R=frame_ia.R) if world.enableAnimation and animation and showUniversalAxes;

  equation
    Connections.branch(frame_a.R, frame_ia.R);
    if kinematicConstraint then
      rRod_0 = transpose(frame_b.R.T)*(frame_b.R.T*frame_b.r_0) - transpose(
        frame_a.R.T)*(frame_a.R.T*frame_a.r_0);
    else
      rRod_0 = frame_b.r_0 - frame_a.r_0;
    end if;
    //rRod_0 = frame_b.r_0 - frame_a.r_0;
    rRod_a = Frames.resolve2(frame_a.R, rRod_0);

    // Constraint equation
    constraintResidue = 0;

    /* Determine relative Rotation R_rel_ia from frame_a to frame_ia
     and absolute rotation of frame_a.R.
  */
    eRod_a = rRod_a/rodLength;
    n2_a = cross(n1_a, eRod_a);
    length2_n2_a = n2_a*n2_a;

    assert(length2_n2_a > 1.e-10, "
A Modelica.Mechanics.MultiBody.Joints.UniversalSpherical joint (consisting of
a universal joint and a spherical joint connected together
by a rigid rod) is in the singular configuration of the
universal joint. This means that axis 1 of the universal
joint defined via parameter \"n1_a\" is parallel to vector
\"rRod_ia\" that is directed from the origin of frame_a to the
origin of frame_b.
   You may try to use another \"n1_a\" vector. If this fails,
use instead Modelica.Mechanics.MultiBody.Joints.SphericalSpherical, if this is
possible, because this joint aggregation does not have a
singular configuration.
");

    length_n2_a = sqrt(length2_n2_a);
    e2_a = n2_a/length_n2_a;
    e3_a = cross(eRod_a, e2_a);

    /* The statements below are an efficient implementation of the
   original equations:
     T_rel_ia = [eRod_ia, e2_ia, e3_ia]*transpose([eRod_a, e2_a, e3_a]);
     R_rel_ia = Frames.from_T(T_rel_ia,
                   Frames.TransformationMatrices.angularVelocity2(T_rel_ia, der(T_rel_ia)));
   To perform this, the rotation is split into two parts:
     R_rel_ia : Rotation object from frame_a to frame_ia
     R_rel_ia1: Rotation object from frame_a to frame_ia1
                (frame that is fixed in frame_ia such that x-axis
                is along the rod axis)
                T = transpose([eRod_a, e2_a, e3_a]; w = w_rel_ia1
     R_rel_ia2: Fixed rotation object from frame_ia1 to frame_ia
                T = [eRod_ia, e2_ia, e3_ia]; w = zeros(3)

   The difficult part is to compute w_rel_ia1:
      w_rel_ia1 = [  e3_a*der(e2_a);
                    -e3_a*der(eRod_a);
                     e2_a*der(eRod_a)]
   der(eRod_a) is directly given, since eRod_a is a function
   of translational quantities only.
      der(eRod_a) = (der(rRod_a) - eRod_a*(eRod_a*der(rRod_a)))/rodLength
      der(n2_a)   = cross(n1_a, der(eRod_a))
      der(e2_a)   = (der(n2_a) - e2_a*(e2_a*der(n2_a)))/length_n2_a
   Inserting these equations in w_rel_ia1 results in:
      e3_a*der(eRod_a) = e3_a*der(rRod_a)/rodLength       // e3_a*eRod_a = 0
      e2_a*der(eRod_a) = e2_a*der(rRod_a)/rodLength       // e2_a*eRod_a = 0
      e3_a*der(e2_a)   = e3_a*der(n2_a)/lenght_n2_a       // e3_a*e2_a = 0
                       = e3_a*cross(n1_a, der(eRod_a))/length_n2_a
                       = e3_a*cross(n1_a, der(rRod_a) - eRod_a*(eRod_a*der(rRod_a)))/(length_n2_a*rodLength)
                       = e3_a*cross(n1_a, der(rRod_a))/(length_n2_a*rodLength)
   Furthermore, we have:
     rRod_a            = resolve2(frame_a.R, rRod_0);
     der(rRod_a)       = resolve2(frame_a.R, der(rRod_0)) - cross(frame_a.R.w, rRod_a));
*/
    der_rRod_a_L = (Frames.resolve2(frame_a.R, der(rRod_0)) - cross(frame_a.R.w,
       rRod_a))/rodLength;
    w_rel_ia1 = {e3_a*cross(n1_a, der_rRod_a_L)/length_n2_a,-e3_a*der_rRod_a_L,
      e2_a*der_rRod_a_L};
    R_rel_ia1 = Frames.from_T(transpose([eRod_a, e2_a, e3_a]), w_rel_ia1);
    R_rel_ia2 = Frames.from_T([eRod_ia, e2_ia, e3_ia], zeros(3));
    R_rel_ia = Frames.absoluteRotation(R_rel_ia1, R_rel_ia2);
    /*
  T_rel_ia = [eRod_ia, e2_ia, e3_ia]*transpose([eRod_a, e2_a, e3_a]);
  R_rel_ia = Frames.from_T(T_rel_ia,
    Frames.TransformationMatrices.angularVelocity2(T_rel_ia, der(T_rel_ia)));
*/

    // Compute kinematic quantities of frame_ia
    frame_ia.r_0 = frame_a.r_0;
    frame_ia.R = Frames.absoluteRotation(frame_a.R, R_rel_ia);

    /* In the following formulas f_a, f_b, f_ia, t_a, t_b, t_ia are
     the forces and torques at frame_a, frame_b, frame_ia, respectively,
     resolved in frame_a. e_x, e_y, e_z are the unit vectors resolved in frame_a.
     Torque balance at the rod around the origin of frame_a:
       0 = t_a + t_ia + cross(rRod_a, f_b)
     with
         rRod_a = rodLength*e_x
         f_b     = -f_rod*e_x + f_b[2]*e_y + f_b[3]*e_z
     follows:
       0 = t_a + t_ia + rodLength*(f_b[2]*e_z - f_b[3]*e_y)
     The projection of t_a with respect to universal joint axes vanishes:
       n1_a*t_a = 0
       e_y*t_a = 0
     Therefore:
        0 = n1_a*t_ia + rodLength*f_b[2]*(n1_a*e_z)
        0 = e_y*t_ia - rodLength*f_b[3]
     or
        f_b = -f_rod*e_x - e_y*(n1_a*t_ia)/(rodLength*(n1_a*e_z)) + e_z*(e_y*t_ia)/rodLength
     Force balance:
        0 = f_a + f_b + f_ia
  */
    f_ia_a = Frames.resolve1(R_rel_ia, frame_ia.f);
    t_ia_a = Frames.resolve1(R_rel_ia, frame_ia.t);

      // f_b_a1 is needed in aggregation joints to solve kinematic loops analytically
    f_b_a1 = -e2_a*((n1_a*t_ia_a)/(rodLength*(n1_a*e3_a))) + e3_a*((e2_a*t_ia_a)
      /rodLength);
    f_b_a = -f_rod*eRod_a + f_b_a1;
    frame_b.f = Frames.resolveRelative(f_b_a, frame_a.R, frame_b.R);
    frame_b.t = zeros(3);
    zeros(3) = frame_a.f + f_b_a + f_ia_a;
    zeros(3) = frame_a.t + t_ia_a + cross(rRod_a, f_b_a);

    // Measure power for test purposes
    if checkTotalPower then
      totalPower = frame_a.f*Frames.resolve2(frame_a.R, der(frame_a.r_0)) +
        frame_b.f*Frames.resolve2(frame_b.R, der(frame_b.r_0)) + frame_ia.f*
        Frames.resolve2(frame_ia.R, der(frame_ia.r_0)) + frame_a.t*
        Frames.angularVelocity2(frame_a.R) + frame_b.t*Frames.angularVelocity2(
        frame_b.R) + frame_ia.t*Frames.angularVelocity2(frame_ia.R);
    else
      totalPower = 0;
    end if;
    annotation (
      Documentation(info="<html>
<p>
This component consists of a <b>universal joint</b> at frame_a and
a <b>spherical joint</b> at frame_b that are connected together with
a <b>rigid rod</b>, see default aimation figure (the arrows are not
part of the default animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/UniversalSpherical.png\" ALT=\"model Joints.UniversalSpherical\">
</p>
<p>
This joint aggregation has no mass and no inertia and introduces the constraint
that the distance between the origin of frame_a and the origin of frame_b is constant
(= Frames.length(rRod_ia)). The universal joint is defined in the following way:
<p>
<ul>
<li> The rotation <b>axis</b> of revolute joint <b>1</b> is along parameter
     vector n1_a which is fixed in frame_a.<li>
<li> The rotation <b>axis</b> of revolute joint <b>2</b> is perpendicular to
     axis 1 and to the line connecting the universal and the spherical joint.
</ul>
<p>
The definition of axis 2 of the universal joint is performed according
to the most often occuring case. In a future release, axis 2 might
be explicitly definable via a parameter. However, the treatment is much more
complicated and the number of operations is considerably higher,
if axis 2 is not orthogonal to axis 1 and to the connecting rod.
</p>
<p>
Note, there is a <b>singularity</b> when axis 1 and the connecting rod are parallel
to other. Therefore, if possible n1_a should be selected in such a way that it
is perpendicular to rRod_ia in the initial configuration (i.e., the
distance to the singularity is as large as possible).
</p>
<p>
An additional <b>frame_ia</b> is present. It is <b>fixed</b> in the connecting
<b>rod</b> at the origin of <b>frame_a</b>. The placement of frame_ia on the rod
is implicitly defined by the universal joint (frame_a and frame_ia coincide
when the angles of the two revolute joints of the universal joint are zero)
and by parameter vector <b>rRod_ia</b>, the position vector
from the origin of frame_a to the origin of frame_b, resolved in frame_<b>ia</b>.
</p>
<p>
The easiest way to define the parameters of this joint is by moving the
MultiBody system in a <b>reference configuration</b> where <b>all frames</b>
of all components are <b>parallel</b> to other (alternatively,
at least frame_a and frame_ia of the UniversalSpherical joint
should be parallel to other when defining an instance of this
component). Since frame_a and frame_ia are parallel to other,
vector <b>rRod_ia</b> from frame_a to frame_b resolved in frame_<b>ia</b> can be resolved
in frame_<b>a</b> (or the <b>world frame</b>, if all frames are parallel to other).
</p>
<p>
This joint aggregation can be used in cases where
in reality a rod with spherical joints at end are present.
Such a system has an additional degree of freedom to rotate
the rod along its axis. In practice this rotation is usually
of no interested and is mathematically removed by replacing one
of the spherical joints by a universal joint. Still, in most
cases the Joints.SphericalSpherical joint aggregation can be used instead
of the UniversalSpherical joint
since the rod is animated and its mass properties are approximated by
a point mass in the middle of the rod. The SphericalSpherical joint
has the advantage that it does not have a singular configuration.
</p>
<p>
In the public interface of the UniversalSpherical joint, the following
(final) <b>parameters</b> are provided:
</p>
<pre>
  <b>parameter</b> Real rodLength(unit=\"m\")  \"Length of rod\";
  <b>parameter</b> Real eRod_ia[3] \"Unit vector along rod, resolved in frame_ia\";
  <b>parameter</b> Real e2_ia  [3] \"Unit vector along axis 2, resolved in frame_ia\";
</pre>
<p>
This allows a more convenient definition of data which is related to the rod.
For example, if a box shall be connected at frame_ia directing from
the origin of frame_a to the middle of the rod, this might be defined as:
</p>
<pre>
    Modelica.Mechanics.MultiBody.Joints.UniversalSpherical jointUS(rRod_ia={1.2, 1, 0.2});
    Modelica.Mechanics.MultiBody.Visualizers.FixedShape    shape(shapeType       = \"box\",
                                              lengthDirection = jointUS.eRod_ia,
                                              widthDirection  = jointUS.e2_ia,
                                              length          = jointUS.rodLength/2,
                                              width           = jointUS.rodLength/10);
  <b>equation</b>
    <b>connect</b>(jointUS.frame_ia, shape.frame_a);
</pre>
</html>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-122,-49},{138,-107}},
            lineColor={0,0,255},
            textString="%name"),
          Ellipse(
            extent={{-100,-40},{-19,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-90,-30},{-29,29}},
            lineColor={160,160,164},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-60,41},{-9,-44}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-60,40},{-60,-40}},
            color={0,0,0},
            thickness=0.5),
          Ellipse(
            extent={{-83,-17},{-34,21}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-74,-12},{-40,15}},
            lineColor={160,160,164},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-72,-20},{-89,3},{-69,25},{-45,27},{-72,-20}},
            pattern=LinePattern.None,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Line(
            points={{-60,40},{-60,-10}},
            color={0,0,0},
            thickness=0.5),
          Line(
            points={{-49,20},{-69,-15}},
            color={0,0,0},
            thickness=0.5),
          Ellipse(
            extent={{44,14},{73,-14}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{20,-40},{100,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{30,-30},{90,30}},
            lineColor={192,192,192},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-22,45},{40,-43}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{46,14},{75,-14}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Rectangle(
            extent={{-36,-8},{48,8}},
            lineColor={0,0,0},
            pattern=LinePattern.None,
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Text(
            extent={{-105,118},{-67,86}},
            lineColor={128,128,128},
            textString="ia"),
          Text(
            extent={{-24,103},{167,64}},
            lineColor={0,0,0},
            textString="%rRod_ia"),
          Line(
            points={{-40,101},{-40,60},{-60,1}},
            color={128,128,128},
            thickness=0.5)}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-60,-70},{46,-70}}, color={0,0,255}),
          Polygon(
            points={{60,-70},{45,-64},{45,-76},{60,-70}},
            lineColor={0,0,255},
            fillColor={0,0,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-56,-71},{56,-90}},
            textString="rRod",
            lineColor={0,0,255}),
          Ellipse(
            extent={{-100,-40},{-19,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-90,-30},{-29,29}},
            lineColor={160,160,164},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-60,41},{-19,-41}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-60,40},{-60,-40}},
            color={0,0,0},
            thickness=0.5),
          Ellipse(
            extent={{-83,-17},{-34,21}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{-74,-12},{-40,15}},
            lineColor={160,160,164},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-72,-20},{-89,3},{-69,25},{-45,27},{-72,-20}},
            pattern=LinePattern.None,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Line(
            points={{-60,40},{-60,-10}},
            color={0,0,0},
            thickness=0.5),
          Line(
            points={{-49,20},{-69,-15}},
            color={0,0,0},
            thickness=0.5),
          Polygon(points={{7,-1},{-5,2},{-5,-4},{7,-1}}, lineColor={0,0,255}),
          Line(points={{-50,19},{-30,57}}, color={0,0,255}),
          Text(
            extent={{-34,78},{8,62}},
            lineColor={0,0,0},
            textString="e2"),
          Polygon(points={{-25,64},{-33,56},{-27,53},{-25,64}}, lineColor={0,0,
                255}),
          Line(points={{-60,41},{-60,65}}, color={0,0,255}),
          Polygon(points={{-60,75},{-64,63},{-56,63},{-60,75}}, lineColor={0,0,
                255}),
          Text(
            extent={{-93,82},{-64,62}},
            lineColor={0,0,0},
            textString="n1"),
          Line(points={{-60,-40},{-60,-72}}, color={0,0,255}),
          Ellipse(
            extent={{20,-40},{100,40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={192,192,192}),
          Ellipse(
            extent={{30,-30},{90,30}},
            lineColor={192,192,192},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-22,45},{40,-43}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{45,14},{74,-14}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-36,-8},{48,8}},
            lineColor={0,0,0},
            pattern=LinePattern.None,
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Text(
            extent={{-31,-7},{0,-28}},
            lineColor={0,0,0},
            textString="eRod"),
          Line(points={{-60,0},{-5,0}}, color={0,0,255}),
          Polygon(points={{7,0},{-5,3},{-5,-3},{7,0}}, lineColor={0,0,255}),
          Line(points={{60,-1},{60,-72}}, color={0,0,255}),
          Line(
            points={{-40,100},{-40,70},{-60,0}},
            color={128,128,128},
            thickness=0.5),
          Text(
            extent={{-23,30},{26,10}},
            textString=" eRod*e2 = 0;  n1*e2 = 0",
            lineColor={0,0,255})}));
  end UniversalSpherical;

  model GearConstraint "Ideal 3-dim. gearbox (arbitrary shaft directions)"
    extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
    Interfaces.Frame_a bearing "Coordinate system fixed in the bearing" 
     annotation (Placement(transformation(
          origin={0,-100},
          extent={{-16,-16},{16,16}},
          rotation=90)));

    parameter Real ratio(start=2) "Gear speed ratio";

    parameter Modelica.Mechanics.MultiBody.Types.Axis n_a={1,0,0}
      "Axis of rotation of shaft a (same coordinates in frame_a, frame_b, bearing)";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n_b={1,0,0}
      "Axis of rotation of shaft b (same coordinates in frame_a, frame_b, bearing)";

    parameter Modelica.SIunits.Position r_a[3]={0,0,0}
      "Vector from frame bearing to frame_a resolved in bearing";
    parameter Modelica.SIunits.Position r_b[3]={0,0,0}
      "Vector from frame bearing to frame_b resolved in bearing";

    Modelica.Mechanics.MultiBody.Joints.Revolute actuatedRevolute_a(useAxisFlange=true, n=n_a, animation=false) 
      annotation (Placement(transformation(extent={{-40,-10},{-60,10}},
            rotation=0)));
    Modelica.Mechanics.MultiBody.Joints.Revolute actuatedRevolute_b(useAxisFlange=true,n=n_b, animation=false) 
      annotation (Placement(transformation(extent={{40,-10},{60,10}}, rotation=
              0)));
    Modelica.Mechanics.Rotational.Components.IdealGear idealGear(
                                                      ratio=ratio) 
      annotation (Placement(transformation(extent={{-10,30},{10,50}}, rotation=
              0)));
    Modelica.Mechanics.MultiBody.Parts.FixedTranslation fixedTranslation1(animation=false, r=r_b) 
      annotation (Placement(transformation(extent={{10,-10},{30,10}}, rotation=
              0)));
    Modelica.Mechanics.MultiBody.Parts.FixedTranslation fixedTranslation2(animation=false, r=r_a) 
      annotation (Placement(transformation(
          origin={-20,0},
          extent={{-10,-10},{10,10}},
          rotation=180)));
  equation
    assert(cardinality(bearing) > 0,
      "Connector bearing of component is not connected");

    connect(actuatedRevolute_a.axis, idealGear.flange_a) 
      annotation (Line(points={{-50,10},{-50,40},{-10,40}}, color={0,0,0}));
    connect(idealGear.flange_b, actuatedRevolute_b.axis) 
      annotation (Line(points={{10,40},{50,40},{50,10}}, color={0,0,0}));
    connect(actuatedRevolute_a.frame_a,fixedTranslation2. frame_b) annotation (Line(
        points={{-40,0},{-35,0},{-35,1.22465e-015},{-30,1.22465e-015}},
        color={95,95,95},
        thickness=0.5));
    connect(fixedTranslation2.frame_a, bearing) annotation (Line(
        points={{-10,-1.22465e-015},{-4,-1.22465e-015},{-4,0},{0,0},{0,-100}},
        color={95,95,95},
        thickness=0.5));
    connect(fixedTranslation1.frame_a, bearing) 
      annotation (Line(
        points={{10,0},{0,0},{0,-100}},
        color={95,95,95},
        thickness=0.5));
    connect(fixedTranslation1.frame_b, actuatedRevolute_b.frame_a) 
      annotation (Line(
        points={{30,0},{40,0}},
        color={95,95,95},
        thickness=0.5));
    connect(frame_a, actuatedRevolute_a.frame_b) 
      annotation (Line(
        points={{-100,0},{-60,0}},
        color={95,95,95},
        thickness=0.5));
    connect(actuatedRevolute_b.frame_b, frame_b) 
      annotation (Line(
        points={{60,0},{100,0}},
        color={95,95,95},
        thickness=0.5));
    annotation (
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Rectangle(
            extent={{-98,98},{98,-98}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-40,20},{-20,-20}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{-40,140},{-20,20}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{20,100},{40,60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{20,60},{40,-60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{40,10},{100,-10}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{-20,90},{20,70}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Rectangle(
            extent={{-100,10},{-40,-10}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={192,192,192}),
          Text(
            extent={{-156,186},{152,130}},
            textString="%name=%ratio",
            lineColor={0,0,255}),
          Line(points={{-80,20},{-60,20}}, color={0,0,0}),
          Line(points={{-80,-20},{-60,-20}}, color={0,0,0}),
          Line(points={{-10,60},{10,60}}, color={0,0,0}),
          Line(points={{60,20},{80,20}}, color={0,0,0}),
          Line(points={{60,-20},{80,-20}}, color={0,0,0}),
          Line(points={{-70,-20},{-70,-70},{70,-70},{70,-20}}, color={0,0,0}),
          Line(points={{0,60},{0,-70},{0,-100}}, color={0,0,0}),
          Line(points={{-10,100},{10,100}}, color={0,0,0})}),
      Documentation(info="<html>
<p>This ideal massless joint provides a gear constraint between
frames <tt>frame_a</tt> and <tt>frame_b</tt>. The axes of rotation
of <tt>frame_a</tt> and <tt>frame_b</tt> may be arbitrary.</p>
<p><b>Reference</b><br>
<span style=\"font-variant:small-caps\">Schweiger</span>, Christian ;
<span style=\"font-variant:small-caps\">Otter</span>, Martin:
<a href=\"http://www.modelica.org/Conference2003/papers/h06_Schweiger_powertrains_v5.pdf\">Modelling
3D Mechanical Effects of 1-dim. Powertrains</a>. In: <i>Proceedings of the 3rd International
Modelica Conference</i>. Link&ouml;ping : The Modelica Association and Link&ouml;ping University,
November 3-4, 2003, pp. 149-158</p>
</html>"),
      Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
              100,100}}),
              graphics));
  end GearConstraint;

    model RollingWheel
    "Joint (no mass, no inertia) that describes an ideal rolling wheel (rolling on the plane z=0)"

      import SI = Modelica.SIunits;
      import Modelica.Mechanics.MultiBody.Frames;

      Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_a
      "Frame fixed in wheel center point. x-Axis: upwards, y-axis: along wheel axis"
        annotation (Placement(transformation(extent={{-16,-16},{16,16}})));

      parameter SI.Radius wheelRadius "Wheel radius";
      parameter StateSelect stateSelect=StateSelect.always
      "Priority to use generalized coordinates as states"   annotation(HideResult=true,Evaluate=true);

      SI.Position x(start=0, stateSelect=stateSelect)
      "x-coordinate of wheel axis";

      SI.Position y(start=0, stateSelect=stateSelect)
      "y-coordinate of wheel axis";
      SI.Position z;

      SI.Angle angles[3](start={0,0,0}, stateSelect=stateSelect)
      "Angles to rotate world-frame in to frame_a around z-, y-, x-axis" 
        annotation(Dialog(group="Initialization", __Dymola_initialDialog=true));

      SI.AngularVelocity der_angles[3](start={0,0,0}, stateSelect=stateSelect)
      "Derivative of angles" 
        annotation(Dialog(group="Initialization", __Dymola_initialDialog=true));

       SI.Position r_road_0[3]
      "Position vector from world frame to contact point on road, resolved in world frame";

      // Contact force
      SI.Force f_wheel_0[3]
      "Contact force acting on wheel, resolved in world frame";
      SI.Force f_n "Contact force acting on wheel in normal direction";
      SI.Force f_lat "Contact force acting on wheel in lateral direction";
      SI.Force f_long "Contact force acting on wheel in longitudinal direction";
      SI.Position err
      "|r_road_0 - frame_a.r_0| - wheelRadius (must be zero; used for checking)";
  protected
       Real e_axis_0[3] "Unit vector along wheel axis, resolved in world frame";
       SI.Position delta_0[3](start={0,0,-wheelRadius})
      "Distance vector from wheel center to contact point";

       // Coordinate system at contact point
       Real e_n_0[3]
      "Unit vector in normal direction of road at contact point, resolved in world frame";
       Real e_lat_0[3]
      "Unit vector in lateral direction of wheel at contact point, resolved in world frame";
       Real e_long_0[3]
      "Unit vector in longitudinal direction of wheel at contact point, resolved in world frame";

       // Road description
       SI.Position s "Road surface parameter 1";
       SI.Position w "Road surface parameter 2";
       Real e_s_0[3]
      "Road heading at (s,w), resolved in world frame (unit vector)";

       // Slip velocities
       SI.Velocity v_0[3] "Velocity of wheel center, resolved in world frame";
       SI.AngularVelocity w_0[3]
      "Angular velocity of wheel, resolved in world frame";

       SI.Velocity vContact_0[3]
      "Velocity of wheel contact point, resolved in world frame";

       // Utility vectors
       Real aux[3];

    equation
       // frame_a.R is computed from generalized coordinates
       Connections.root(frame_a.R);
       frame_a.r_0 = {x,y,z};
       der_angles  = der(angles);
       frame_a.R = Frames.axesRotations({3,2,1}, angles, der_angles);

       // Road description
       r_road_0 = {s,w,0};
       e_n_0    = {0,0,1};
       e_s_0    = {1,0,0};

       // Coordinate system at contact point (e_long_0, e_lat_0, e_n_0)
       e_axis_0  = Frames.resolve1(frame_a.R, {0,1,0});
       aux       = cross(e_n_0, e_axis_0);
       e_long_0 = aux / Modelica.Math.Vectors.length(aux);
       e_lat_0  = cross(e_long_0, e_n_0);

       // Determine point on road where the wheel is in contact with the road
       delta_0 = r_road_0 - frame_a.r_0;
       0 = delta_0*e_axis_0;
       0 = delta_0*e_long_0;

       // One holonomic positional constraint equation (no penetration in to the ground)
       0 = wheelRadius - delta_0*cross(e_long_0, e_axis_0);

       // only for testing
       err = Modelica.Math.Vectors.length(delta_0) - wheelRadius;

       // Slip velocities
       v_0 = der(frame_a.r_0);
       w_0 = Frames.angularVelocity1(frame_a.R);
       vContact_0 = v_0 + cross(w_0, delta_0);

       // Two non-holonomic constraint equations on velocity level (ideal rolling, no slippage)
       0 = vContact_0*e_long_0;
       0 = vContact_0*e_lat_0;

       // Contact force
       f_wheel_0 = f_n*e_n_0 + f_lat*e_lat_0 + f_long*e_long_0;

       // Force and torque balance at the wheel center
       zeros(3) = frame_a.f + Frames.resolve2(frame_a.R, f_wheel_0);
       zeros(3) = frame_a.t + Frames.resolve2(frame_a.R, cross(delta_0, f_wheel_0));

       // Guard against singularity
       assert(abs(e_n_0*e_axis_0) < 0.99, "Wheel lays nearly on the ground (which is a singularity)");
      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Rectangle(
            extent={{-100,-80},{100,-100}},
            lineColor={0,0,0},
            fillColor={175,175,175},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-154,124},{146,84}},
            lineColor={0,0,255},
            textString="%name"),
          Ellipse(
            extent={{-80,80},{80,-80}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}));
    end RollingWheel;

    model RollingWheelSet
    "Joint (no mass, no inertia) that describes an ideal rolling wheel set (two ideal rolling wheels connected together by an axis)"
      import SI = Modelica.SIunits;
     Modelica.Mechanics.MultiBody.Interfaces.Frame_a frameMiddle
      "Frame fixed in middle of axis connecting both wheels (y-axis: along wheel axis, z-Axis: upwards)"
        annotation (Placement(transformation(extent={{-16,16},{16,-16}}),
            iconTransformation(extent={{-16,-16},{16,16}})));

      parameter Boolean animation=true
      "= true, if animation of wheel set shall be enabled";

      parameter SI.Radius wheelRadius "Radius of one wheel";
      parameter SI.Distance wheelDistance "Distance between the two wheels";

      parameter StateSelect stateSelect = StateSelect.default
      "Priority to use the generalized coordinates as states";

      Modelica.SIunits.Position x(start=0, stateSelect=stateSelect)
      "x coordinate for center between wheels";
      Modelica.SIunits.Position y(start=0, stateSelect=stateSelect)
      "y coordinate for center between wheels";
      Modelica.SIunits.Angle phi(start=0, stateSelect=stateSelect)
      "Orientation angle of wheel axis along z-axis";
      Modelica.SIunits.Angle theta1(start=0, stateSelect=stateSelect)
      "Angle of wheel 1";
      Modelica.SIunits.Angle theta2(start=0, stateSelect=stateSelect)
      "Angle of wheel 2";
      Modelica.SIunits.AngularVelocity der_theta1(start=0, stateSelect=stateSelect)
      "Derivative of theta 1";
      Modelica.SIunits.AngularVelocity der_theta2(start=0, stateSelect=stateSelect)
      "Derivative of theta 2";

      Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame1
      "Frame fixed in center point of left wheel (y-axis: along wheel axis, z-Axis: upwards)"
        annotation (Placement(transformation(extent={{-96,16},{-64,-16}}),
            iconTransformation(extent={{-96,16},{-64,-16}})));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame2
      "Frame fixed in center point of right wheel (y-axis: along wheel axis, z-Axis: upwards)"
        annotation (Placement(transformation(extent={{64,16},{96,-16}})));
      Modelica.Mechanics.MultiBody.Parts.Fixed fixed(                 r={0,0,
            wheelRadius}, animation=animation) 
                          annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={0,-90})));
      Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod1(                 r={
            0,wheelDistance/2,0}, animation=animation) 
        annotation (Placement(transformation(extent={{-8,-10},{-28,10}})));
      Modelica.Mechanics.MultiBody.Joints.Prismatic prismatic1(animation=
            animation)                   annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={0,-66})));
      Modelica.Mechanics.MultiBody.Joints.Prismatic prismatic2(
        n={0,1,0}, animation=animation)  annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={-24,-50})));
      Modelica.Mechanics.MultiBody.Joints.Revolute revolute(animation=animation) 
                                         annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={0,-22})));
      Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod2(                 r={
            0,-wheelDistance/2,0}, animation=animation) 
        annotation (Placement(transformation(extent={{12,-10},{32,10}})));
      Modelica.Mechanics.MultiBody.Joints.Revolute revolute1(
        n={0,1,0},
        useAxisFlange=true,
        animation=animation) 
        annotation (Placement(transformation(extent={{-34,-10},{-54,10}})));
      Modelica.Mechanics.MultiBody.Joints.Revolute revolute2(
        n={0,1,0},
        useAxisFlange=true,
        animation=animation) 
        annotation (Placement(transformation(extent={{40,-10},{60,10}})));
      Modelica.Mechanics.MultiBody.Joints.Internal.RollingConstraintVerticalWheel
      rolling1(                             radius=wheelRadius) 
        annotation (Placement(transformation(extent={{-70,-60},{-50,-40}})));
      Modelica.Mechanics.MultiBody.Joints.Internal.RollingConstraintVerticalWheel
      rolling2(                             radius=wheelRadius,
          lateralSlidingConstraint=false) 
        annotation (Placement(transformation(extent={{54,-60},{74,-40}})));
      Modelica.Mechanics.Rotational.Interfaces.Flange_a axis1
      "1-dim. rotational flange that drives the joint" 
        annotation (Placement(transformation(extent={{-110,90},{-90,110}})));
      Modelica.Mechanics.Rotational.Interfaces.Flange_a axis2
      "1-dim. rotational flange that drives the joint" 
        annotation (Placement(transformation(extent={{90,90},{110,110}})));
      Modelica.Mechanics.MultiBody.Parts.Mounting1D mounting1D 
        annotation (Placement(transformation(extent={{-10,38},{10,58}})));
      Modelica.Mechanics.Rotational.Interfaces.Flange_b support
      "Support of 1D axes"   annotation (Placement(transformation(extent={{-10,
                70},{10,90}}), iconTransformation(extent={{-10,70},{10,90}})));
    equation
      prismatic1.s  = x;
      prismatic2.s  = y;
      revolute.phi  = phi;
      revolute1.phi = theta1;
      revolute2.phi = theta2;
      der_theta1 = der(theta1);
      der_theta2 = der(theta2);

      connect(revolute.frame_b, frameMiddle) annotation (Line(
          points={{6.12323e-016,-12},{0,-12},{0,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(rod1.frame_a, frameMiddle) annotation (Line(
          points={{-8,0},{0,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(rod2.frame_a, frameMiddle) annotation (Line(
          points={{12,0},{0,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(rod1.frame_b, revolute1.frame_a) annotation (Line(
          points={{-28,0},{-34,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(revolute1.frame_b, frame1) annotation (Line(
          points={{-54,0},{-80,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(revolute2.frame_a, rod2.frame_b) annotation (Line(
          points={{40,0},{32,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(revolute2.frame_b, frame2) annotation (Line(
          points={{60,0},{80,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(prismatic1.frame_a, fixed.frame_b) annotation (Line(
          points={{-6.12323e-016,-76},{6.12323e-016,-76},{6.12323e-016,-80}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(prismatic1.frame_b, prismatic2.frame_a) annotation (Line(
          points={{6.12323e-016,-56},{6.12323e-016,-50},{-14,-50}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(prismatic2.frame_b, revolute.frame_a) annotation (Line(
          points={{-34,-50},{-40,-50},{-40,-36},{-6.12323e-016,-36},{
            -6.12323e-016,-32}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(rolling1.frame_a, revolute1.frame_b) annotation (Line(
          points={{-60,-48},{-60,0},{-54,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(rolling2.frame_a, revolute2.frame_b) annotation (Line(
          points={{64,-48},{64,0},{60,0}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(revolute1.axis, axis1) annotation (Line(
          points={{-44,10},{-44,100},{-100,100}},
          color={0,0,0},
          smooth=Smooth.None));
      connect(revolute2.axis, axis2) annotation (Line(
          points={{50,10},{50,100},{100,100}},
          color={0,0,0},
          smooth=Smooth.None));
      connect(frameMiddle, mounting1D.frame_a) annotation (Line(
          points={{0,0},{0,38}},
          color={95,95,95},
          thickness=0.5,
          smooth=Smooth.None));
      connect(mounting1D.flange_b, support) annotation (Line(
          points={{10,48},{16,48},{16,80},{0,80}},
          color={0,0,0},
          smooth=Smooth.None));
      annotation (defaultComponentName="wheelSet",Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Rectangle(
            extent={{-100,-80},{100,-100}},
            lineColor={0,0,0},
            fillColor={175,175,175},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-146,-98},{154,-138}},
            textString="%name",
            lineColor={0,0,255}),
          Ellipse(
            extent={{42,80},{118,-80}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-62,2},{64,-6}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-118,80},{-42,-80}},
            lineColor={0,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Line(
            points={{86,24},{64,24},{64,10},{56,10}},
            color={0,0,0},
            smooth=Smooth.None),
          Line(
            points={{86,-24},{64,-24},{64,-12},{56,-12}},
            color={0,0,0},
            smooth=Smooth.None),
          Line(
            points={{-96,100},{-80,100},{-80,4}},
            color={0,0,0},
            smooth=Smooth.None),
          Line(
            points={{100,100},{80,100},{80,-2}},
            color={0,0,0},
            smooth=Smooth.None),
          Line(
            points={{0,72},{0,40},{-20,40},{-20,2}},
            color={0,0,0},
            smooth=Smooth.None),
          Line(
            points={{0,40},{20,40},{20,2}},
            color={0,0,0},
            smooth=Smooth.None)}),
        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
              {100,100}}), graphics={
          Line(
            points={{-68,24},{-68,52}},
            color={0,0,255},
            smooth=Smooth.None),
          Polygon(
            points={{-68,70},{-74,52},{-62,52},{-68,70}},
            lineColor={0,0,255},
            smooth=Smooth.None,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-56,62},{-38,50}},
            lineColor={0,0,255},
            textString="x"),
          Line(
            points={{-62,30},{-94,30}},
            color={0,0,255},
            smooth=Smooth.None),
          Polygon(
            points={{-90,36},{-90,24},{-108,30},{-90,36}},
            lineColor={0,0,255},
            smooth=Smooth.None,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-114,50},{-96,38}},
            lineColor={0,0,255},
            textString="y")}));
    end RollingWheelSet;

  package Assemblies "Joint aggregations for analytic loop handling"
    import SI = Modelica.SIunits;
    extends Modelica.Icons.Library;

    model JointUPS
      "Universal - prismatic - spherical joint aggregation (no constraints, no potential states)"

      import SI = Modelica.SIunits;
      import Modelica.Mechanics.MultiBody.Types;
      extends Interfaces.PartialTwoFramesDoubleSize;
      Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_ia
        "Coordinate system at origin of frame_a fixed at prismatic joint" 
        annotation (Placement(transformation(
            origin={-80,100},
            extent={{-8,-8},{8,8}},
            rotation=270)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_ib
        "Coordinate system at origin of frame_b fixed at prismatic joint" 
        annotation (Placement(transformation(
            origin={80,100},
            extent={{-8,8},{8,-8}},
            rotation=270)));
      Modelica.Mechanics.Translational.Interfaces.Flange_a axis
        "1-dim. translational flange that drives the prismatic joint" 
        annotation (Placement(transformation(extent={{45,95},{35,105}},
              rotation=0)));
      Modelica.Mechanics.Translational.Interfaces.Flange_b bearing
        "1-dim. translational flange of the drive bearing of the prismatic joint"
        annotation (Placement(transformation(extent={{-35,95},{-45,105}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter Boolean showUniversalAxes=true
        " = true, if universal joint shall be visualized with two cylinders, otherwise with a sphere (provided animation=true)";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n1_a={0,0,1}
        "Axis 1 of universal joint resolved in frame_a (axis 2 is orthogonal to axis 1 and to line from universal to spherical joint)"
        annotation (Evaluate=true);
      parameter SI.Position nAxis_ia[3]={1,0,0}
        "Axis vector along line from origin of frame_a to origin of frame_b, resolved in frame_ia"
        annotation (Evaluate=true);
      parameter SI.Position s_offset=0
        "Relative distance offset (distance between frame_a and frame_b = s(t) + s_offset)";
      parameter SI.Diameter sphereDiameter=world.defaultJointLength
        "Diameter of spheres representing the spherical joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of spheres representing the spherical joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter axisDiameter=sphereDiameter/Types.Defaults.
          JointRodDiameterFraction
        "Diameter of cylinder on the connecting line from frame_a to frame_b" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color axisColor=Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor
        "Color of cylinder on the connecting line from frame_a to frame_b" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance cylinderLength=world.defaultJointLength
        "Length of cylinders representing the two universal joint axes" annotation (
         Dialog(tab="Animation", group="if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));
      parameter SI.Distance cylinderDiameter=world.defaultJointWidth
        "Diameter of cylinders representing the two universal joint axes" 
        annotation (Dialog(tab="Animation", group=
              "if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));
     input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of cylinders representing the two universal joint axes" annotation (
          Dialog(tab="Animation", group="if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));

      parameter Boolean checkTotalPower=false
        "= true, if total power flowing into this component shall be determined (must be zero)"
        annotation (Dialog(tab="Advanced"));
      final parameter Real eAxis_ia[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                                        nAxis_ia)
        "Unit vector from origin of frame_a to origin of frame_b, resolved in frame_ia";
      final parameter Real e2_ia[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                                     cross(n1_a, eAxis_ia))
        "Unit vector in direction of second rotation axis of universal joint, resolved in frame_ia";
      final parameter Real e3_ia[3](each final unit="1")=cross(eAxis_ia, e2_ia)
        "Unit vector perpendicular to eAxis_ia and e2_ia, resolved in frame_ia";
      SI.Position s
        "Relative distance between frame_a and frame_b along axis nAxis = s + s_offset";
      SI.Force f "= axis.f (driving force in the axis; = -bearing.f)";
      SI.Length axisLength "Distance between frame_a and frame_b";
      SI.Power totalPower
        "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";

    protected
      SI.Force f_c_a[3] "frame_ia.f resolved in frame_a";
      SI.Torque t_cd_a[3] "frame_ia.t + frame_ib.t resolved in frame_a";
      SI.Force f_bd_a[3] "frame_b.f + frame_ib.f resolved in frame_a";
      SI.Position rAxis_0[3]
        "Position vector from origin of frame_a to origin of frame_b resolved in world frame";
      SI.Position rAxis_a[3]
        "Position vector from origin of frame_a to origin of frame_b resolved in frame_a";
      Real eAxis_a[3](each final unit="1")
        "Unit vector in direction of rAxis_a, resolved in frame_a";
      Real e2_a[3](each final unit="1")
        "Unit vector in direction of second rotation axis of universal joint, resolved in frame_a";
      Real e3_a[3](each final unit="1")
        "Unit vector perpendicular to eAxis_a and e2_a, resolved in frame_a";
      Real n2_a[3](each final unit="1")
        "Vector in direction of second rotation axis of universal joint, resolved in frame_a";
      Real length2_n2_a(unit="m2") "Square of length of vector n2_a";
      SI.Length length_n2_a "Length of vector n2_a";
      Real der_rAxis_a_L[3](each unit="1/s") "= der(rAxis_a)/axisLength";
      SI.AngularVelocity w_rel_ia1[3];
      Frames.Orientation R_ia1_a;
      Frames.Orientation R_ia2_a;
      Frames.Orientation R_ia_a "Rotation from frame_a to frame_ia";
      // Real T_ia_a[3, 3] "Transformation matrix from frame_a to frame_ia";

      Visualizers.Advanced.Shape axisCylinder(
        shapeType="cylinder",
        color=axisColor,
        specularCoefficient=specularCoefficient,
        length=axisLength,
        width=axisDiameter,
        height=axisDiameter,
        lengthDirection=eAxis_ia,
        widthDirection=e2_ia,
        r=frame_ia.r_0,
        R=frame_ia.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape sphericalShape_b(
        shapeType="sphere",
        color=sphereColor,
        specularCoefficient=specularCoefficient,
        length=sphereDiameter,
        width=sphereDiameter,
        height=sphereDiameter,
        lengthDirection={1,0,0},
        widthDirection={0,1,0},
        r_shape={-0.5,0,0}*sphereDiameter,
        r=frame_b.r_0,
        R=frame_b.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape sphericalShape_a(
        shapeType="sphere",
        color=sphereColor,
        specularCoefficient=specularCoefficient,
        length=sphereDiameter,
        width=sphereDiameter,
        height=sphereDiameter,
        lengthDirection={1,0,0},
        widthDirection={0,1,0},
        r_shape={-0.5,0,0}*sphereDiameter,
        r=frame_a.r_0,
        R=frame_a.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape universalShape1(
        shapeType="cylinder",
        color=cylinderColor,
        specularCoefficient=specularCoefficient,
        length=cylinderLength,
        width=cylinderDiameter,
        height=cylinderDiameter,
        lengthDirection=n1_a,
        widthDirection={0,1,0},
        r_shape=-n1_a*(cylinderLength/2),
        r=frame_a.r_0,
        R=frame_a.R) if world.enableAnimation and animation and showUniversalAxes;
      Visualizers.Advanced.Shape universalShape2(
        shapeType="cylinder",
        color=cylinderColor,
        specularCoefficient=specularCoefficient,
        length=cylinderLength,
        width=cylinderDiameter,
        height=cylinderDiameter,
        lengthDirection=e2_ia,
        widthDirection={0,1,0},
        r_shape=-e2_ia*(cylinderLength/2),
        r=frame_ia.r_0,
        R=frame_ia.R) if world.enableAnimation and animation and showUniversalAxes;
    equation
      Connections.branch(frame_a.R, frame_ia.R);
      Connections.branch(frame_ia.R, frame_ib.R);

      // Translational flanges
      axisLength = s + s_offset;
      bearing.s = 0;
      axis.s = s;
      axis.f = f;

      // Position vector rAxis from frame_a to frame_b
      rAxis_0 = frame_b.r_0 - frame_a.r_0;
      rAxis_a = Frames.resolve2(frame_a.R, rAxis_0);

      /* Determine relative Rotation R_rel_c from frame_a to frame_ia
     and absolute rotation of frame_a.R.
  */
      axisLength = sqrt(rAxis_0*rAxis_0);
      assert(axisLength > 1.0e-15, "
Distance between frame_a and frame_b of a JointUPS joint
became zero. This is not allowed. If this occurs during
initialization, the initial conditions are probably wrong.");

      eAxis_a = rAxis_a/axisLength;
      n2_a = cross(n1_a, eAxis_a);
      length2_n2_a = n2_a*n2_a;
      assert(noEvent(length2_n2_a > 1.e-10), "
A Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUPS joint (consisting of
a universal, prismatic and spherical joint) is in the singular
configuration of the universal joint. This means that axis 1 of
the universal joint defined via parameter \"n1_a\" is parallel to vector
\"eAxis_ia\" that is directed from the origin of frame_a to the
origin of frame_b. You may try to use another \"n1_a\" vector.
");
      length_n2_a = sqrt(length2_n2_a);
      e2_a = n2_a/length_n2_a;
      e3_a = cross(eAxis_a, e2_a);

      /* The statements below are an efficient implementation of the
     original equations:
       T_ia_a = [eAxis_ia, e2_ia, e3_ia]*transpose([eAxis_a, e2_a, e3_a]);
       R_ia_a = Frames.from_T(T_ia_a,
                     Frames.TransformationMatrices.angularVelocity2(T_ia_a, der(T_ia_a)));
   To perform this, the rotation is split into two parts:
     R_ia_a : Rotation object from frame_a to frame_ia
     R_ia1_a: Rotation object from frame_a to frame_ia1
                (frame that is fixed in frame_ia such that x-axis
                is along the rod axis)
                T = transpose([eAxis_a, e2_a, e3_a]; w = w_rel_ia1
     R_ia2_a: Fixed rotation object from frame_ia1 to frame_ia
                T = [eAxis_a, e2_ia, e3_ia]; w = zeros(3)

   The difficult part is to compute w_rel_ia1:
      w_rel_ia1 = [  e3_a*der(e2_a);
                    -e3_a*der(eAxis_a);
                     e2_a*der(eAxis_a)]
   der(eAxis_a) is directly given, since eAxis_a is a function
   of translational quantities only.
      der(eAxis_a) = (der(rAxis_a) - eAxis_a*(eAxis_a*der(rAxis_a)))/axisLength
      der(n2_a)    = cross(n1_a, der(eAxis_a))
      der(e2_a)    = (der(n2_a) - e2_a*(e2_a*der(n2_a)))/length_n2_a
   Inserting these equations in w_rel_ia1 results in:
      e3_a*der(eAxis_a) = e3_a*der(rAxis_a)/axisLength       // e3_a*eAxis_a = 0
      e2_a*der(eAxis_a) = e2_a*der(rAxis_a)/axisLength       // e2_a*eAxis_a = 0
      e3_a*der(e2_a)    = e3_a*der(n2_a)/lenght_n2_a       // e3_a*e2_a = 0
                        = e3_a*cross(n1_a, der(eAxis_a))/length_n2_a
                        = e3_a*cross(n1_a, der(rAxis_a) - eAxis_a*(eAxis_a*der(rAxis_a)))/(length_n2_a*axisLength)
                        = e3_a*cross(n1_a, der(rAxis_a))/(length_n2_a*axisLength)
   Furthermore, we have:
     rAxis_a      = resolve2(frame_a.R, rAxis_0);
     der(rAxis_a) = resolve2(frame_a.R, der(rAxis_0)) - cross(frame_a.R.w, rAxis_a));
*/
      der_rAxis_a_L = (Frames.resolve2(frame_a.R, der(rAxis_0)) - cross(frame_a.
         R.w, rAxis_a))/axisLength;
      w_rel_ia1 = {e3_a*cross(n1_a, der_rAxis_a_L)/length_n2_a,-e3_a*
        der_rAxis_a_L,e2_a*der_rAxis_a_L};
      R_ia1_a = Frames.from_T(transpose([eAxis_a, e2_a, e3_a]), w_rel_ia1);
      R_ia2_a = Frames.from_T([eAxis_ia, e2_ia, e3_ia], zeros(3));
      R_ia_a = Frames.absoluteRotation(R_ia1_a, R_ia2_a);
      /*
  T_ia_a = [eAxis_ia, e2_ia, e3_ia]*transpose([eAxis_a, e2_a, e3_a]);
  R_ia_a = Frames.from_T(T_ia_a, Frames.TransformationMatrices.angularVelocity2
    (T_ia_a, der(T_ia_a)));
*/

      // Compute kinematic quantities of frame_ia and frame_ib
      frame_ia.r_0 = frame_a.r_0;
      frame_ib.r_0 = frame_b.r_0;
      frame_ia.R = Frames.absoluteRotation(frame_a.R, R_ia_a);
      frame_ib.R = frame_ia.R;

      /* In the following formulas f_a, f_b, f_ia, f_ib, t_a, t_b, t_ia, t_ib are
     the forces and torques at frame_a, frame_b, frame_ia, frame_ib respectively,
     resolved in frame_a. eAxis, e2, e3 are the unit vectors resolved in frame_a.
     Torque balance at the rod around the origin of frame_a:
       0 = t_a + t_ia + t_ib + cross(rAxis, (f_b+f_ib))
     with
         rAxis = axisLength*eAxis
         f_bd  = f_b + f_ib
         f_bd  = f*eAxis + f_bd[2]*e2 + f_bd[3]*e3
     follows:
         0 = t_a + t_ia + axisLength*(f_bd[2]*e_z - f_bd[3]*e_y)
     The projection of t_a with respect to universal joint axes vanishes:
       e1*t_a = 0
       e2*t_a = 0
     Therefore:
        0 = e1*(t_ia + t_ib) + axisLength*f_bd[2]*(e1*e3)
        0 = e2*(t_ia + t_ib) - axisLength*f_bd[3]
     or
        f_bd = f*eAxis - e2*(e1*(t_ia+t_ib))/(axisLength*(e1*e3)) +
                e3*(e2*(t_ia+t_ib))/axisLength
     Force balance:
        0 = f_a + f_bd + f_ia
  */
      f_c_a = Frames.resolve1(R_ia_a, frame_ia.f);
      t_cd_a = Frames.resolve1(R_ia_a, frame_ia.t + frame_ib.t);
      f_bd_a = -eAxis_a*f - e2_a*((n1_a*t_cd_a)/(axisLength*(n1_a*e3_a))) +
        e3_a*((e2_a*t_cd_a)/axisLength);
      zeros(3) = frame_b.f + Frames.resolveRelative(frame_ib.f, frame_ib.R,
        frame_b.R) - Frames.resolveRelative(f_bd_a, frame_a.R, frame_b.R);
      zeros(3) = frame_b.t;
      zeros(3) = frame_a.f + f_c_a + f_bd_a;
      zeros(3) = frame_a.t + t_cd_a + cross(rAxis_a, f_bd_a);

      // Measure power for test purposes
      if checkTotalPower then
        totalPower = frame_a.f*Frames.resolve2(frame_a.R, der(frame_a.r_0)) +
          frame_b.f*Frames.resolve2(frame_b.R, der(frame_b.r_0)) + frame_ia.f*
          Frames.resolve2(frame_ia.R, der(frame_ia.r_0)) + frame_ib.f*
          Frames.resolve2(frame_ib.R, der(frame_ib.r_0)) + frame_a.t*
          Frames.angularVelocity2(frame_a.R) + frame_b.t*
          Frames.angularVelocity2(frame_b.R) + frame_ia.t*
          Frames.angularVelocity2(frame_ia.R) + frame_ib.t*
          Frames.angularVelocity2(frame_ib.R) + axis.f*der(axis.s) + bearing.f*
          der(bearing.s);
      else
        totalPower = 0;
      end if;
      annotation (
        Documentation(info="<html>
<p>
This component consists of a <b>universal</b> joint at frame_a,
a <b>spherical</b> joint at frame_b and a <b>prismatic</b> joint along the
line connecting the origin of frame_a and the origin of frame_b,
see the default animation in the following figure (the axes vectors
are not part of the default animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/JointUPS.png\" ALT=\"model Joints.Assemblies.JointUPS\">
</p>
<p>
This joint aggregation has no mass and no inertia and
introduces neither constraints nor potential state variables.
It is especially useful to build up more complicated force elements
where the mass and/or inertia of the force element shall be taken
into account.
</p>
<p>
The universal joint is defined in the following way:
<p>
<ul>
<li> The rotation <b>axis</b> of revolute joint <b>1</b> is along parameter
     vector n1_a which is fixed in frame_a.<li>
<li> The rotation <b>axis</b> of revolute joint <b>2</b> is perpendicular to
     axis 1 and to the line connecting the universal and the spherical joint.
</ul>
<p>
The definition of axis 2 of the universal joint is performed according
to the most often occuring case. In a future release, axis 2 might
be explicitly definable via a parameter. However, the treatment is much more
complicated and the number of operations is considerably higher,
if axis 2 is not orthogonal to axis 1 and to the connecting rod.
</p>
<p>
Note, there is a <b>singularity</b> when axis 1 and the connecting line are parallel
to each other. Therefore, if possible n1_a should be selected in such a way that it
is perpendicular to nAxis_ia in the initial configuration (i.e., the
distance to the singularity is as large as possible).
</p>
<p>
An additional <b>frame_ia</b> is present. It is <b>fixed</b> on the line
connecting the universal and the spherical joint at the
origin of <b>frame_a</b>. The placement of frame_ia on this line
is implicitly defined by the universal joint (frame_a and frame_ia coincide
when the angles of the two revolute joints of the universal joint are zero)
and by parameter vector <b>nAxis_ia</b>, an axis vector directed
along the line from the origin of frame_a to the spherical joint,
resolved in frame_<b>ia</b>.
</p
<p>
An additional <b>frame_ib</b> is present. It is <b>fixed</b> in the line
connecting the prismatic and the spherical joint at the
origin of <b>frame_b</b>.
It is always parallel to <b>frame_ia</b>.
</p>
<p>
Note, this joint aggregation can be used in cases where
in reality a rod with spherical joints at each end are present.
Such a system has an additional degree of freedom to rotate
the rod along its axis. In practice this rotation is usually
of no interested and is mathematically removed by replacing one
of the spherical joints by a universal joint.
</p>
<p>
The easiest way to define the parameters of this joint is by moving the
MultiBody system in a <b>reference configuration</b> where <b>all frames</b>
of all components are <b>parallel</b> to each other (alternatively,
at least frame_a, frame_ia and frame_ib of the JointUSP joint
should be parallel to each other when defining an instance of this
component).
</p>
</html> "),
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Text(
              extent={{-140,-50},{140,-75}},
              lineColor={0,0,255},
              textString="%name"),
            Ellipse(
              extent={{-100,-40},{-19,40}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-90,-30},{-29,29}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-60,41},{-9,-44}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Line(
              points={{-60,40},{-60,-40}},
              color={0,0,0},
              thickness=0.5),
            Ellipse(
              extent={{-83,-17},{-34,21}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-74,-12},{-40,15}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{-72,-20},{-89,3},{-69,25},{-45,27},{-72,-20}},
              pattern=LinePattern.None,
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Line(
              points={{-60,40},{-60,-10}},
              color={0,0,0},
              thickness=0.5),
            Line(
              points={{-49,20},{-69,-15}},
              color={0,0,0},
              thickness=0.5),
            Ellipse(
              extent={{44,14},{73,-14}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{20,-40},{100,40}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{30,-30},{90,30}},
              lineColor={192,192,192},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-22,45},{40,-43}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{45,14},{74,-14}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Text(
              extent={{-98,84},{-60,65}},
              lineColor={128,128,128},
              textString="ia"),
            Line(
              points={{-40,0},{-40,90},{-80,90},{-80,97}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{61,86},{109,64}},
              lineColor={128,128,128},
              textString="ib"),
            Rectangle(
              extent={{-35,-13},{-6,14}},
              pattern=LinePattern.None,
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-35,14},{-6,18}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-6,-7},{46,6}},
              pattern=LinePattern.None,
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-6,6},{46,10}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Line(points={{-6,-13},{-6,18}}, color={0,0,0}),
            Line(
              points={{60,-1},{60,90},{80,90},{80,97}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{60,90},{40,90},{40,95}},
              color={95,95,95},
              thickness=0.5),
            Line(points={{-30,70},{10,70}}, color={0,0,0}),
            Polygon(
              points={{30,70},{10,76},{10,63},{30,70}},
              lineColor={128,128,128},
              fillColor={128,128,128},
              fillPattern=FillPattern.Solid),
            Line(
              points={{-40,90},{-40,90},{-40,95}},
              color={95,95,95},
              thickness=0.5)}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Line(points={{-60,-70},{46,-70}}, color={0,0,255}),
            Polygon(
              points={{60,-70},{45,-64},{45,-76},{60,-70}},
              lineColor={0,0,255},
              fillColor={0,0,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-62,-73},{65,-90}},
              textString="rAxis",
              lineColor={0,0,255}),
            Ellipse(
              extent={{-100,-40},{-19,40}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-90,-30},{-29,29}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-60,41},{-19,-41}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Line(
              points={{-60,40},{-60,-40}},
              color={0,0,0},
              thickness=0.5),
            Ellipse(
              extent={{-83,-17},{-34,21}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-74,-12},{-40,15}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{-72,-20},{-89,3},{-69,25},{-45,27},{-72,-20}},
              pattern=LinePattern.None,
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Line(
              points={{-60,40},{-60,-10}},
              color={0,0,0},
              thickness=0.5),
            Line(
              points={{-49,20},{-69,-15}},
              color={0,0,0},
              thickness=0.5),
            Line(
              points={{-40,0},{-40,90},{-80,90},{-80,99}},
              color={95,95,95},
              thickness=0.5),
            Polygon(points={{7,-1},{-5,2},{-5,-4},{7,-1}}, lineColor={0,0,255}), 

            Line(points={{-50,19},{-30,57}}, color={0,0,255}),
            Text(
              extent={{-24,74},{7,53}},
              lineColor={0,0,0},
              textString="e2"),
            Polygon(points={{-25,64},{-33,56},{-27,53},{-25,64}}, lineColor={0,
                  0,255}),
            Line(points={{-60,41},{-60,65}}, color={0,0,255}),
            Polygon(points={{-60,75},{-64,63},{-56,63},{-60,75}}, lineColor={0,
                  0,255}),
            Text(
              extent={{-96,82},{-65,61}},
              lineColor={0,0,0},
              textString="n1"),
            Line(points={{-60,-40},{-60,-72}}, color={0,0,255}),
            Ellipse(
              extent={{20,-40},{100,40}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{30,-30},{90,30}},
              lineColor={192,192,192},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-22,45},{40,-43}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{45,14},{74,-14}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={128,128,128}),
            Line(points={{60,0},{60,-74}}, color={0,0,255}),
            Rectangle(
              extent={{-35,14},{-6,18}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-35,-13},{-6,14}},
              pattern=LinePattern.None,
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-6,6},{46,10}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-6,-7},{46,6}},
              pattern=LinePattern.None,
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Line(points={{-6,-13},{-6,18}}, color={0,0,0}),
            Text(
              extent={{-40,-2},{-1,-16}},
              lineColor={0,0,0},
              textString="nAxis"),
            Line(points={{-61,1},{-2,1}}, color={0,0,255}),
            Polygon(points={{10,1},{-2,4},{-2,-2},{10,1}}, lineColor={0,0,255}), 

            Line(
              points={{60,-1},{60,90},{80,90},{80,99}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{-24,117},{-9,102}},
              textString="f",
              lineColor={0,0,255}),
            Polygon(
              points={{-26,103},{-36,100},{-26,97},{-26,103}},
              lineColor={0,0,255},
              fillColor={0,0,255},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{26,103},{36,100},{26,97},{26,103}},
              lineColor={0,0,255},
              fillColor={0,0,255},
              fillPattern=FillPattern.Solid),
            Line(points={{14,100},{36,100}}, color={0,0,255}),
            Text(
              extent={{12,116},{27,101}},
              textString="f",
              lineColor={0,0,255}),
            Polygon(
              points={{30,93},{40,90},{30,87},{30,93}},
              lineColor={128,128,128},
              fillColor={128,128,128},
              fillPattern=FillPattern.Solid),
            Line(points={{-40,90},{40,90}}, color={128,128,128}),
            Line(points={{-25,100},{-10,100}}, color={0,0,255}),
            Text(
              extent={{-18,90},{19,77}},
              lineColor={128,128,128},
              textString="s"),
            Line(
              points={{60,90},{40,90},{40,98}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{-40,90},{-40,96},{-40,98}},
              color={135,135,135},
              thickness=0.5)}));
    end JointUPS;

    model JointUSR
      "Universal - spherical - revolute joint aggregation (no constraints, no potential states)"

      import SI = Modelica.SIunits;
      import Cv = Modelica.SIunits.Conversions;
      import Modelica.Mechanics.MultiBody.Types;

      extends Interfaces.PartialTwoFramesDoubleSize;
      Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_ia
        "Coordinate system at origin of frame_a fixed at connecting rod of universal and spherical joint"
        annotation (Placement(transformation(
            origin={-80,100},
            extent={{-8,-8},{8,8}},
            rotation=90)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_ib
        "Coordinate system at origin of frame_b fixed at connecting rod of spherical and revolute joint"
        annotation (Placement(transformation(
            origin={80,100},
            extent={{-8,8},{8,-8}},
            rotation=270)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_im
        "Coordinate system at origin of spherical joint fixed at connecting rod of spherical and revolute joint"
        annotation (Placement(transformation(
            origin={0,100},
            extent={{8,-8},{-8,8}},
            rotation=270)));
      Modelica.Mechanics.Rotational.Interfaces.Flange_a axis
        "1-dim. rotational flange that drives the revolute joint" 
        annotation (Placement(transformation(extent={{105,85},{95,75}},
              rotation=0)));
      Modelica.Mechanics.Rotational.Interfaces.Flange_b bearing
        "1-dim. rotational flange of the drive bearing of the revolute joint" 
        annotation (Placement(transformation(extent={{95,45},{105,35}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter Boolean showUniversalAxes=true
        " = true, if universal joint shall be visualized with two cylinders, otherwise with a sphere (provided animation=true)";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n1_a={0,0,1}
        "Axis 1 of universal joint fixed and resolved in frame_a (axis 2 is orthogonal to axis 1 and to rod 1)"
        annotation (Evaluate=true);
      parameter Modelica.Mechanics.MultiBody.Types.Axis n_b={0,0,1}
        "Axis of revolute joint fixed and resolved in frame_b" 
        annotation (Evaluate=true);
      parameter SI.Position rRod1_ia[3]={1,0,0}
        "Vector from origin of frame_a to spherical joint, resolved in frame_ia"
        annotation (Evaluate=true);
      parameter SI.Position rRod2_ib[3]={-1,0,0}
        "Vector from origin of frame_ib to spherical joint, resolved in frame_ib";
      parameter Cv.NonSIunits.Angle_deg phi_offset=0
        "Relative angle offset of revolute joint (angle = phi(t) + from_deg(phi_offset))";
      parameter Cv.NonSIunits.Angle_deg phi_guess=0
        "Select the configuration such that at initial time |phi(t0) - from_deg(phi_guess)|is minimal";
      parameter SI.Diameter sphereDiameter=world.defaultJointLength
        "Diameter of the spheres representing the universal and the spherical joint"
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.
           JointColor
        "Color of the spheres representing the universal and the spherical joint"
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter rod1Diameter=sphereDiameter/Types.Defaults.
          JointRodDiameterFraction
        "Diameter of rod 1 connecting the universal and the spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rod1Color=Modelica.Mechanics.MultiBody.Types.Defaults.
          RodColor
        "Color of rod 1 connecting the universal and the spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

      parameter SI.Diameter rod2Diameter=rod1Diameter
        "Diameter of rod 2 connecting the revolute and the spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rod2Color=rod1Color
        "Color of rod 2 connecting the revolute and the spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter revoluteDiameter=world.defaultJointWidth
        "Diameter of cylinder representing the revolute joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance revoluteLength=world.defaultJointLength
        "Length of cylinder representing the revolute joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color revoluteColor=Modelica.Mechanics.MultiBody.Types.
          Defaults.JointColor
        "Color of cylinder representing the revolute joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance cylinderLength=world.defaultJointLength
        "Length of cylinders representing the two universal joint axes" annotation (
         Dialog(tab="Animation", group="if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));
      parameter SI.Distance cylinderDiameter=world.defaultJointWidth
        "Diameter of cylinders representing the two universal joint axes" 
        annotation (Dialog(tab="Animation", group=
              "if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));
      input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of cylinders representing the two universal joint axes" annotation (
          Dialog(tab="Animation", group="if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));
      parameter Boolean checkTotalPower=false
        "= true, if total power flowing into this component shall be determined (must be zero)"
        annotation (Dialog(tab="Advanced"));
      final parameter Real eRod1_ia[3](each final unit="1")=rod1.eRod_ia
        "Unit vector from origin of frame_a to origin of spherical joint, resolved in frame_ia";
      final parameter Real e2_ia[3](each final unit="1")=rod1.e2_ia
        "Unit vector in direction of axis 2 of universal joint, resolved in frame_ia";
      final parameter SI.Distance rod1Length=rod1.rodLength
        "Length of rod 1 (= distance between universal and spherical joint";
      SI.Power totalPower
        "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";
      SI.Position aux
        "Denominator used to compute force in rod connecting universal and spherical joint";
      SI.Force f_rod
        "Constraint force in direction of the rod (positive, if rod is pressed)";

      Modelica.Mechanics.MultiBody.Joints.Internal.RevoluteWithLengthConstraint
        revolute(
        animation=animation,
        lengthConstraint=rod1Length,
        n=n_b,
        phi_offset=phi_offset,
        phi_guess=phi_guess,
        cylinderDiameter=revoluteDiameter,
        cylinderLength=revoluteLength,
        cylinderColor=revoluteColor,
        specularCoefficient=specularCoefficient) annotation (Placement(
            transformation(extent={{75,-20},{35,20}}, rotation=0)));
      Modelica.Mechanics.MultiBody.Joints.UniversalSpherical rod1(
        animation=animation,
        showUniversalAxes=showUniversalAxes,
        rRod_ia=rRod1_ia,
        n1_a=n1_a,
        sphereDiameter=sphereDiameter,
        sphereColor=sphereColor,
        rodWidth=rod1Diameter,
        rodHeight=rod1Diameter,
        rodColor=rod1Color,
        cylinderLength=cylinderLength,
        cylinderDiameter=cylinderDiameter,
        cylinderColor=cylinderColor,
        specularCoefficient=specularCoefficient,
        kinematicConstraint=false,
        constraintResidue=rod1.f_rod - f_rod) 
                                   annotation (Placement(transformation(extent=
                {{-92,-20},{-52,20}}, rotation=0)));
      Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod2(
        animation=animation,
        width=rod2Diameter,
        height=rod2Diameter,
        color=rod2Color,
        specularCoefficient=specularCoefficient,
        r=rRod2_ib) annotation (Placement(transformation(extent={{15,-20},{-25,
                20}}, rotation=0)));
      Sensors.RelativePosition relativePosition(resolveInFrame=Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_a) 
        annotation (Placement(transformation(extent={{60,-70},{40,-90}},
              rotation=0)));
      Modelica.Blocks.Sources.Constant position_b[3](k=rRod2_ib) 
        annotation (Placement(transformation(extent={{-20,-50},{0,-30}},
              rotation=0)));
    equation
     // Connections.root(frame_ib.R);

      /* Compute the unknown force in the rod of the rod1 joint
     by a torque balance at the revolute joint:
       0 = revolute.frame_b.t + frame_ib.t + frame_im.t + cross(rRod2_ib, frame_im.f)
           + cross(r_ib, -rod1.f_b_a1)
           + cross(r_ib, Frames.resolve2(rod1.R_rel, rod1.f_rod*rod1.eRod1_ia))
     The condition is that the projection of the torque in the revolute
     joint along the axis of the revolute joint is equal to the driving
     axis torque in the flange:
       -revolute.tau = revolute.e*frame_b.t
     Therefore, we have
        tau = e*(frame_ib.t  + frame_im.t + cross(rRod2_ib, frame_im.f)
              + cross(rRod2_ib, -rod1.f_b_a1))
              + e*cross(rRod2_ib, Frames.resolve2(rod1.R_rel, rod1.f_rod*rod1.eRod_a))
            = e*(frame_ib.t + frame_im.t + cross(rRod2_ib, frame_im.f)
              + cross(rRod2_ib, -rod.f_b_a1))
              + rod1.f_rod*e*cross(rRod2_ib, Frames.resolve2(rod1.R_rel, rod1.eRod_a))
     Solving this equation for f_rod results in
       f_rod = (-tau - e*(frame_ib.t + frame_im.t + cross(rRod2_ib, frame_im.f)
               + cross(rRod2_ib, -rod1.f_b_a1)))
               / (cross(e,rRod2_ib)*Frames.resolve2(rod1.R_rel, rod1.eRod_a)))
     Additionally, a guard against division by zero is introduced

     f_rod is passed to component JointsUSR.rod1 via variable "constraintResidue" in the Advanced menu
  */
      aux = cross(revolute.e, rRod2_ib)*Frames.resolveRelative(rod1.eRod_a,
        rod1.frame_a.R, rod1.frame_b.R);
      f_rod = (-revolute.tau - revolute.e*(frame_ib.t + frame_im.t + cross(
        rRod2_ib, frame_im.f) - cross(rRod2_ib, Frames.resolveRelative(rod1.
        f_b_a1, rod1.frame_a.R, rod1.frame_b.R))))/noEvent(if abs(aux) < 1.e-10 then 
              1.e-10 else aux);

      // Measure power for test purposes
      if checkTotalPower then
        totalPower = frame_a.f*Frames.resolve2(frame_a.R, der(frame_a.r_0)) +
          frame_b.f*Frames.resolve2(frame_b.R, der(frame_b.r_0)) + frame_ia.f*
          Frames.resolve2(frame_ia.R, der(frame_ia.r_0)) + frame_ib.f*
          Frames.resolve2(frame_ib.R, der(frame_ib.r_0)) + frame_im.f*
          Frames.resolve2(frame_im.R, der(frame_im.r_0)) + frame_a.t*
          Frames.angularVelocity2(frame_a.R) + frame_b.t*
          Frames.angularVelocity2(frame_b.R) + frame_ia.t*
          Frames.angularVelocity2(frame_ia.R) + frame_ib.t*
          Frames.angularVelocity2(frame_ib.R) + frame_im.t*
          Frames.angularVelocity2(frame_im.R) + axis.tau*der(axis.phi) +
          bearing.tau*der(bearing.phi);
      else
        totalPower = 0;
      end if;

      connect(revolute.frame_b, rod2.frame_a) annotation (Line(
          points={{35,0},{15,0}},
          color={95,95,95},
          thickness=0.5));
      connect(rod2.frame_b, rod1.frame_b) annotation (Line(
          points={{-25,0},{-52,0}},
          color={95,95,95},
          thickness=0.5));
      connect(revolute.frame_a, frame_b) annotation (Line(
          points={{75,0},{100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(rod2.frame_a, frame_ib) annotation (Line(
          points={{15,0},{26,0},{26,70},{80,70},{80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(rod1.frame_a, frame_a) annotation (Line(
          points={{-92,0},{-100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(relativePosition.frame_b, frame_a) 
                                               annotation (Line(
          points={{40,-80},{-96,-80},{-96,0},{-100,0}},
          color={95,95,95},
          pattern=LinePattern.Dot));
      connect(relativePosition.frame_a, frame_b) 
                                               annotation (Line(
          points={{60,-80},{96,-80},{96,0},{100,0}},
          color={95,95,95},
          pattern=LinePattern.Dot));
      connect(position_b.y, revolute.position_b)       annotation (Line(
          points={{1,-40},{20,-40},{20,-12},{31,-12}},
          color={0,0,127}));
      connect(rod2.frame_b, frame_im) annotation (Line(
          points={{-25,0},{-40,0},{-40,80},{0,80},{0,100}},
          color={95,95,95},
          thickness=0.5));
      connect(rod1.frame_ia, frame_ia) annotation (Line(
          points={{-80,20},{-80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(revolute.axis, axis) annotation (Line(points={{55,20},{55,60},{90,
              60},{90,80},{100,80}}, color={0,0,0}));
      connect(relativePosition.r_rel, revolute.position_a) annotation (Line(
          points={{50,-69},{50,-40},{90,-40},{90,-12},{79,-12}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(revolute.bearing, bearing) annotation (Line(
          points={{67,20},{67,40},{100,40}},
          color={0,0,0},
          smooth=Smooth.None));
      annotation (
        Documentation(info="<html>
<p>
This component consists of a <b>universal</b> joint at frame_a, a <b>revolute</b>
joint at frame_b and a <b>spherical</b> joint which is connected via <b>rod1</b>
to the universal and via <b>rod2</b> to the revolute joint, see the default
animation in the following figure (the axes vectors are not part of the
default animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/JointUSR.png\" ALT=\"model Joints.Assemblies.JointUSR\">
</p>
<p>
This joint aggregation has no mass and no inertia and
introduces neither constraints nor potential state variables.
It should be used in kinematic loops whenever possible since
the non-linear system of equations introduced by this joint aggregation
is solved <b>analytically</b> (i.e., a solution is always computed, if a
unique solution exists).
</p>
<p>
The universal joint is defined in the following way:
<p>
<ul>
<li> The rotation <b>axis</b> of revolute joint <b>1</b> is along parameter
     vector n1_a which is fixed in frame_a.<li>
<li> The rotation <b>axis</b> of revolute joint <b>2</b> is perpendicular to
     axis 1 and to the line connecting the universal and the spherical joint
     (= rod 1).
</ul>
<p>
The definition of axis 2 of the universal joint is performed according
to the most often occuring case. In a future release, axis 2 might
be explicitly definable via a parameter. However, the treatment is much more
complicated and the number of operations is considerably higher,
if axis 2 is not orthogonal to axis 1 and to the connecting rod.
</p>
<p>
Note, there is a <b>singularity</b> when axis 1 and the connecting rod are parallel
to each other. Therefore, if possible n1_a should be selected in such a way that it
is perpendicular to rRod1_ia in the initial configuration (i.e., the
distance to the singularity is as large as possible).
</p>
<p>
The rest of this joint aggregation is defined by the following parameters:
</p>
<ul>
<li> The position of the spherical joint with respect to the universal
     joint is defined by vector <b>rRod1_ia</b>. This vector is directed from
     frame_a to the spherical joint and is resolved in frame_ia
     (it is most simple to select frame_ia such that it is parallel to
     frame_a in the reference or initial configuration).</li>
<li> The position of the spherical joint with respect to the revolute
     joint is defined by vector <b>rRod2_ib</b>. This vector is directed from
     the inner frame of the revolute joint (frame_ib or revolute.frame_a)
     to the spherical joint and is resolved in frame_ib (note, that frame_ib
     and frame_b are parallel to each other).</li>
<li> The axis of rotation of the revolute joint is defined by axis
     vector <b>n_b</b>. It is fixed and resolved in frame_b.</li>
<li> When specifying this joint aggregation with the definitions above, <b>two</b>
     different <b>configurations</b> are possible. Via parameter <b>phi_guess</b>
     a guess value for revolute.phi(t0) at the initial time t0 is given. The configuration
     is selected that is closest to phi_guess (|revolute.phi - phi_guess|is minimal).
</ul>
<p>
An additional <b>frame_ia</b> is present. It is <b>fixed</b> in the rod
connecting the universal and the spherical joint at the
origin of <b>frame_a</b>. The placement of frame_ia on the rod
is implicitly defined by the universal joint (frame_a and frame_ia coincide
when the angles of the two revolute joints of the universal joint are zero)
and by parameter vector <b>rRod1_ia</b>, the position vector
from the origin of frame_a to the spherical joint, resolved in frame_<b>ia</b>.
</p
<p>
An additional <b>frame_ib</b> is present. It is <b>fixed</b> in the rod
connecting the revolute and the spherical joint at the side of the revolute
joint that is connected to this rod (= rod2.frame_a = revolute.frame_a).
</p>
<p>
An additional <b>frame_im</b> is present. It is <b>fixed</b> in the rod
connecting the revolute and the spherical joint at the side of the spherical
joint that is connected to this rod (= rod2.frame_b).
It is always parallel to <b>frame_ib</b>.
</p>
<p>
The easiest way to define the parameters of this joint is by moving the
MultiBody system in a <b>reference configuration</b> where <b>all frames</b>
of all components are <b>parallel</b> to each other (alternatively,
at least frame_a and frame_ia of the JointUSR joint
should be parallel to each other when defining an instance of this
component).
</p>
<p>
In the public interface of the JointUSR joint, the following
(final) <b>parameters</b> are provided:
</p>
<pre>
  <b>parameter</b> Real rod1Length(unit=\"m\")  \"Length of rod 1\";
  <b>parameter</b> Real eRod1_ia[3] \"Unit vector along rod 1, resolved in frame_ia\";
  <b>parameter</b> Real e2_ia  [3]  \"Unit vector along axis 2, resolved in frame_ia\";
</pre>
<p>
This allows a more convenient definition of data which is related to rod 1.
For example, if a box shall be connected at frame_ia directing from
the origin of frame_a to the middle of rod 1, this might be defined as:
</p>
<pre>
    Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUSP jointUSR(rRod1_ia={1.2, 1, 0.2});
    Modelica.Mechanics.MultiBody.Visualizers.FixedShape     shape(shapeType       = \"box\",
                                               lengthDirection = jointUSR.eRod1_ia,
                                               widthDirection  = jointUSR.e2_ia,
                                               length          = jointUSR.rod1Length/2,
                                               width           = jointUSR.rod1Length/10);
  <b>equation</b>
    <b>connect</b>(jointUSP.frame_ia, shape.frame_a);
</pre>
</html> "),
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Text(
              extent={{-140,-41},{140,-66}},
              lineColor={0,0,255},
              textString="%name"),
            Ellipse(
              extent={{-100,-30},{-40,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-93,-22},{-48,23}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-70,40},{-39,-33}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Line(
              points={{-70,28},{-70,-30}},
              color={0,0,0},
              thickness=0.5),
            Ellipse(
              extent={{-89,-18},{-48,18}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-84,-12},{-53,13}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{-81,-17},{-92,-1},{-83,16},{-57,24},{-81,-17}},
              pattern=LinePattern.None,
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Line(
              points={{-70,30},{-70,-10}},
              color={0,0,0},
              thickness=0.5),
            Line(
              points={{-61,16},{-79,-15}},
              color={0,0,0},
              thickness=0.5),
            Line(
              points={{-50,0},{-50,80},{-80,80},{-80,100}},
              color={95,95,95},
              thickness=0.5),
            Ellipse(
              extent={{-40,-30},{20,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-33,-22},{12,23}},
              lineColor={192,192,192},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-44,31},{-14,-30}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-23,10},{-3,-10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{19,6},{61,-6}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{-50,5},{-21,-5}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{60,-30},{76,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{85,-30},{100,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{76,10},{85,-10}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(extent={{60,30},{76,-30}}, lineColor={0,0,0}),
            Rectangle(extent={{85,30},{100,-30}}, lineColor={0,0,0}),
            Text(
              extent={{40,109},{77,91}},
              lineColor={128,128,128},
              textString="ib"),
            Text(
              extent={{-124,109},{-95,92}},
              lineColor={128,128,128},
              textString="ia"),
            Line(
              points={{60,30},{60,80},{80,80},{80,100}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{-43,108},{-10,92}},
              lineColor={128,128,128},
              textString="im"),
            Line(
              points={{19,6},{19,80},{0,80},{0,100}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{80,80},{101,80}},
              color={128,128,128},
              thickness=0.5),
            Line(
              points={{90,30},{90,40},{95,40}},
              color={95,95,95},
              thickness=0.5)}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics));
    end JointUSR;

    model JointUSP
      "Universal - spherical - prismatic joint aggregation (no constraints, no potential states)"

      import SI = Modelica.SIunits;
      import Modelica.Mechanics.MultiBody.Types;

      extends Interfaces.PartialTwoFramesDoubleSize;
      Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_ia
        "Coordinate system at origin of frame_a fixed at connecting rod of universal and spherical joint"
        annotation (Placement(transformation(
            origin={-80,100},
            extent={{-8,-8},{8,8}},
            rotation=90)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_ib
        "Coordinate system at origin of frame_b fixed at connecting rod of spherical and prismatic joint"
        annotation (Placement(transformation(
            origin={80,100},
            extent={{-8,8},{8,-8}},
            rotation=270)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_im
        "Coordinate system at origin of spherical joint fixed at connecting rod of spherical and prismatic joint"
        annotation (Placement(transformation(
            origin={0,100},
            extent={{8,-8},{-8,8}},
            rotation=270)));
      Modelica.Mechanics.Translational.Interfaces.Flange_a axis
        "1-dim. translational flange that drives the prismatic joint" 
        annotation (Placement(transformation(extent={{95,75},{105,85}},
              rotation=0)));
      Modelica.Mechanics.Translational.Interfaces.Flange_b bearing
        "1-dim. translational flange of the drive bearing of the prismatic joint"
        annotation (Placement(transformation(extent={{105,35},{95,45}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter Boolean showUniversalAxes=true
        " = true, if universal joint shall be visualized with two cylinders, otherwise with a sphere (provided animation=true)";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n1_a={0,0,1}
        "Axis 1 of universal joint fixed and resolved in frame_a (axis 2 is orthogonal to axis 1 and to rod 1)"
        annotation (Evaluate=true);
      parameter Modelica.Mechanics.MultiBody.Types.Axis n_b={-1,0,0}
        "Axis of prismatic joint fixed and resolved in frame_b" 
        annotation (Evaluate=true);
      parameter SI.Position rRod1_ia[3]={1,0,0}
        "Vector from origin of frame_a to spherical joint, resolved in frame_ia"
        annotation (Evaluate=true);
      parameter SI.Position rRod2_ib[3]={-1,0,0}
        "Vector from origin of frame_ib to spherical joint, resolved in frame_ib (frame_ib is parallel to frame_b)"
        annotation (Evaluate=true);
      parameter SI.Position s_offset=0
        "Relative distance offset of prismatic joint (distance between the prismatic joint frames = s(t) + s_offset)";
      parameter SI.Position s_guess=0
        "Select the configuration such that at initial time |s(t0)-s_guess|is minimal";
      parameter SI.Diameter sphereDiameter=world.defaultJointLength
        "Diameter of the spheres representing the universal and the spherical joint"
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of the spheres representing the universal and the spherical joint"
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter rod1Diameter=sphereDiameter/Types.Defaults.
          JointRodDiameterFraction
        "Diameter of rod 1 connecting the universal and the spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rod1Color=Modelica.Mechanics.MultiBody.Types.Defaults.RodColor
        "Color of rod 1 connecting the universal and the spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter rod2Diameter=rod1Diameter
        "Diameter of rod 2 connecting the prismatic and the spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rod2Color=rod1Color
        "Color of rod 2 connecting the prismatic and the spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter Types.Axis boxWidthDirection={0,1,0}
        "Vector in width direction of prismatic joint, resolved in frame_b" 
        annotation (Evaluate=true, Dialog(tab="Animation", group=
              "if animation = true", enable=animation));
      parameter SI.Distance boxWidth=world.defaultJointWidth
        "Width of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance boxHeight=boxWidth "Height of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color boxColor=sphereColor "Color of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance cylinderLength=world.defaultJointLength
        "Length of cylinders representing the two universal joint axes" annotation (
         Dialog(tab="Animation", group="if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));
      parameter SI.Distance cylinderDiameter=world.defaultJointWidth
        "Diameter of cylinders representing the two universal joint axes" 
        annotation (Dialog(tab="Animation", group=
              "if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));
      input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of cylinders representing the two universal joint axes" annotation (
          Dialog(tab="Animation", group="if animation = true and showUniversalAxes",
                enable=animation and showUniversalAxes));
      parameter Boolean checkTotalPower=false
        "= true, if total power flowing into this component shall be determined (must be zero)"
        annotation (Dialog(tab="Advanced"));
      final parameter Real eRod1_ia[3](each final unit="1")=rod1.eRod_ia
        "Unit vector from origin of frame_a to origin of spherical joint, resolved in frame_ia";
      final parameter Real e2_ia[3](each final unit="1")=rod1.e2_ia
        "Unit vector in direction of axis 2 of universal joint, resolved in frame_ia";
      final parameter SI.Distance rod1Length=rod1.rodLength
        "Length of rod 1 (= distance between universal and spherical joint";
      SI.Force f_rod
        "Constraint force in direction of the rod (positive, if rod is pressed)";
      SI.Power totalPower
        "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";

      Modelica.Mechanics.MultiBody.Joints.Internal.PrismaticWithLengthConstraint
        prismatic(
        animation=animation,
        length=rod1.rodLength,
        n=n_b,
        s_offset=s_offset,
        s_guess=s_guess,
        boxWidthDirection=boxWidthDirection,
        boxWidth=boxWidth,
        boxHeight=boxHeight,
        boxColor=boxColor,
        specularCoefficient=specularCoefficient) 
                                annotation (Placement(transformation(extent={{
                76,-20},{36,20}}, rotation=0)));
      Modelica.Mechanics.MultiBody.Joints.UniversalSpherical rod1(
        animation=animation,
        showUniversalAxes=showUniversalAxes,
        rRod_ia=rRod1_ia,
        n1_a=n1_a,
        sphereDiameter=sphereDiameter,
        sphereColor=sphereColor,
        rodWidth=rod1Diameter,
        rodHeight=rod1Diameter,
        rodColor=rod1Color,
        specularCoefficient=specularCoefficient,
        cylinderLength=cylinderLength,
        cylinderDiameter=cylinderDiameter,
        cylinderColor=cylinderColor,
        kinematicConstraint=false,
        constraintResidue=rod1.f_rod - f_rod) 
                                   annotation (Placement(transformation(extent=
                {{-92,-20},{-52,20}}, rotation=0)));
      Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod2(
        animation=animation,
        r=rRod2_ib,
        width=rod2Diameter,
        height=rod2Diameter,
        specularCoefficient=specularCoefficient,
        color=rod2Color) annotation (Placement(transformation(extent={{0,20},{
                -40,-20}}, rotation=0)));
      Sensors.RelativePosition relativePosition(resolveInFrame=Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_a) 
        annotation (Placement(transformation(extent={{50,-70},{30,-90}},
              rotation=0)));
      Modelica.Blocks.Sources.Constant position_b[3](k=rRod2_ib) 
        annotation (Placement(transformation(extent={{-20,-60},{0,-40}},
              rotation=0)));
    protected
      Real aux
        "Denominator used to compute force in rod connecting universal and spherical joint";
    equation
      /* Compute the unknown force in rod1 connecting the universal and
     the spherical joint by a force balance at the prismatic joint
        0 = -prismatic.frame_b.f + frame_ib.f + frame_im.f - rod1.frame_b.f
     The force at rod1.frame_b is split into two parts:
        rod1.frame_b.f = Frames.resolve2(rod1.R_rel, rod1.f_b_a1 - rod1.f_rod*rod1.eRod_a)
     where rod1.f_rod is the unknown force in rod1.
     The condition is that the projection of the force in the prismatic
     joint along the axis of its translation axis is equal to the driving
     axis force in the flange:
       -prismatic.f = prismatic.e*prismatic.frame_b.f
     Therefore, we have with e=prismatic.e and f=prismatic.f
       -f = e*(frame_ib.f + frame_im.f
               - Frames.resolve2(rod1.R_rel, rod1.f_b_a1 - rod1.f_rod*rod1.eRod_a))
          = e*(frame_ib.f + frame_im.f - Frames.resolve2(rod1.R_rel, rod1.f_b_a1)
              + rod1.f_rod*Frames.resolve2(rod1.R_rel, rod1.eRod_a))
     Solving this equation for f_rod results in
       rod1.f_rod = -(f+e*(frame_ib.f + frame_im.f - Frames.resolve2(rod1.R_rel, rod1.f_b_a1))
                   /(e*Frames.resolve2(rod1.R_rel, rod1.eRod_a))
     Additionally, a guard against division by zero is introduced
  */
      aux = prismatic.e*Frames.resolveRelative(rod1.eRod_a, rod1.frame_a.R,
        rod1.frame_b.R);
      f_rod = (-prismatic.f - prismatic.e*(frame_ib.f + frame_im.f -
        Frames.resolveRelative(rod1.f_b_a1, rod1.frame_a.R, rod1.frame_b.R)))/
        noEvent(if abs(aux) < 1.e-10 then 1.e-10 else aux);
      // Measure power for test purposes
      if checkTotalPower then
        totalPower = frame_a.f*Frames.resolve2(frame_a.R, der(frame_a.r_0)) +
          frame_b.f*Frames.resolve2(frame_b.R, der(frame_b.r_0)) + frame_ia.f*
          Frames.resolve2(frame_ia.R, der(frame_ia.r_0)) + frame_ib.f*
          Frames.resolve2(frame_ib.R, der(frame_ib.r_0)) + frame_im.f*
          Frames.resolve2(frame_im.R, der(frame_im.r_0)) + frame_a.t*
          Frames.angularVelocity2(frame_a.R) + frame_b.t*
          Frames.angularVelocity2(frame_b.R) + frame_ia.t*
          Frames.angularVelocity2(frame_ia.R) + frame_ib.t*
          Frames.angularVelocity2(frame_ib.R) + frame_im.t*
          Frames.angularVelocity2(frame_im.R) + axis.f*der(axis.s) + bearing.f*
          der(bearing.s);
      else
        totalPower = 0;
      end if;

      connect(prismatic.frame_b, rod2.frame_a) annotation (Line(
          points={{36,0},{0,0}},
          color={95,95,95},
          thickness=0.5));
      connect(rod2.frame_b, rod1.frame_b) annotation (Line(
          points={{-40,0},{-52,0}},
          color={0,0,0},
          thickness=0.5));
      connect(prismatic.frame_a, frame_b) annotation (Line(
          points={{76,0},{100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(rod2.frame_a, frame_ib) annotation (Line(
          points={{0,0},{7,0},{7,70},{80,70},{80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(rod1.frame_a, frame_a) annotation (Line(
          points={{-92,0},{-100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(relativePosition.frame_b, frame_a) 
                                               annotation (Line(
          points={{30,-80},{-97,-80},{-97,0},{-100,0}},
          color={95,95,95},
          pattern=LinePattern.Dot));
      connect(relativePosition.frame_a, frame_b) 
                                               annotation (Line(
          points={{50,-80},{95,-80},{95,0},{100,0}},
          color={95,95,95},
          pattern=LinePattern.Dot));
      connect(rod2.frame_b, frame_im) annotation (Line(
          points={{-40,0},{-46,0},{-46,80},{0,80},{0,100}},
          color={95,95,95},
          thickness=0.5));
      connect(rod1.frame_ia, frame_ia) annotation (Line(
          points={{-80,20},{-80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(position_b.y, prismatic.position_b)       annotation (Line(
          points={{1,-50},{10,-50},{10,-12},{32,-12}},
          color={0,0,127}));
      connect(prismatic.axis, axis) annotation (Line(points={{40,14},{40,56},{
              90,56},{90,80},{100,80}}, color={0,191,0}));
      connect(prismatic.bearing, bearing) 
        annotation (Line(points={{64,14},{64,40},{100,40}}, color={0,191,0}));
      connect(relativePosition.r_rel, prismatic.position_a) 
                                                          annotation (Line(
          points={{40,-69},{40,-50},{90,-50},{90,-12},{80,-12}},
          color={0,0,127},
          smooth=Smooth.None));
      annotation (
        Documentation(info="<html>
<p>
This component consists of a <b>universal</b> joint at frame_a, a <b>prismatic</b>
joint at frame_b and a <b>spherical</b> joint which is connected via <b>rod1</b>
to the universal and via <b>rod2</b> to the prismatic joint, see the default
animation in the following figure (the axes vectors are not part of the
default animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/JointUSP.png\" ALT=\"model Joints.Assemblies.JointUSP\">
</p>
<p>
This joint aggregation has no mass and no inertia and
introduces neither constraints nor potential state variables.
It should be used in kinematic loops whenever possible since
the non-linear system of equations introduced by this joint aggregation
is solved <b>analytically</b> (i.e., a solution is always computed, if a
unique solution exists).
</p>
<p>
The universal joint is defined in the following way:
<p>
<ul>
<li> The rotation <b>axis</b> of revolute joint <b>1</b> is along parameter
     vector n1_a which is fixed in frame_a.<li>
<li> The rotation <b>axis</b> of revolute joint <b>2</b> is perpendicular to
     axis 1 and to the line connecting the universal and the spherical joint
     (= rod 1).
</ul>
<p>
The definition of axis 2 of the universal joint is performed according
to the most often occuring case. In a future release, axis 2 might
be explicitly definable via a parameter. However, the treatment is much more
complicated and the number of operations is considerably higher,
if axis 2 is not orthogonal to axis 1 and to the connecting rod.
</p>
<p>
Note, there is a <b>singularity</b> when axis 1 and the connecting rod are parallel
to each other. Therefore, if possible n1_a should be selected in such a way that it
is perpendicular to rRod1_ia in the initial configuration (i.e., the
distance to the singularity is as large as possible).
</p>
<p>
The rest of this joint aggregation is defined by the following parameters:
</p>
<ul>
<li> The position of the spherical joint with respect to the universal
     joint is defined by vector <b>rRod1_ia</b>. This vector is directed from
     frame_a to the spherical joint and is resolved in frame_ia
     (it is most simple to select frame_ia such that it is parallel to
     frame_a in the reference or initial configuration).</li>
<li> The position of the spherical joint with respect to the prismatic
     joint is defined by vector <b>rRod2_ib</b>. This vector is directed from
     the inner frame of the prismatic joint (frame_ib or prismatic.frame_a)
     to the spherical joint and is resolved in frame_ib (note, that frame_ib
     and frame_b are parallel to each other).</li>
<li> The axis of translation of the prismatic joint is defined by axis
     vector <b>n_b</b>. It is fixed and resolved in frame_b.</li>
<li> The two frames of the prismatic joint, i.e., frame_b and frame_ib,
     are parallel to each other.
     The distance between the origins of these two frames along axis n_b
     is equal to \"prismatic.s(t) + s_offset\", where \"prismatic.s(t)\" is
     a time varying variable and \"s_offset\" is a fixed, constant offset
     parameter.</li>
<li> When specifying this joint aggregation with the definitions above, <b>two</b>
     different <b>configurations</b> are possible. Via parameter <b>s_guess</b>
     a guess value for prismatic.s(t0) at the initial time t0 is given. The configuration
     is selected that is closest to s_guess (|prismatic.s - s_guess|is minimal).
</ul>
<p>
An additional <b>frame_ia</b> is present. It is <b>fixed</b> in the rod
connecting the universal and the spherical joint at the
origin of <b>frame_a</b>. The placement of frame_ia on the rod
is implicitly defined by the universal joint (frame_a and frame_ia coincide
when the angles of the two revolute joints of the universal joint are zero)
and by parameter vector <b>rRod1_ia</b>, the position vector
from the origin of frame_a to the spherical joint, resolved in frame_<b>ia</b>.
</p
<p>
An additional <b>frame_ib</b> is present. It is <b>fixed</b> in the rod
connecting the prismatic and the spherical joint at the side of the prismatic
joint that is connected to this rod (= rod2.frame_a = prismatic.frame_a).
It is always parallel to <b>frame_b</b>.
</p>
<p>
An additional <b>frame_im</b> is present. It is <b>fixed</b> in the rod
connecting the prismatic and the spherical joint at the side of the spherical
joint that is connected to this rod (= rod2.frame_b).
It is always parallel to <b>frame_b</b>.
</p>
<p>
The easiest way to define the parameters of this joint is by moving the
MultiBody system in a <b>reference configuration</b> where <b>all frames</b>
of all components are <b>parallel</b> to each other (alternatively,
at least frame_a and frame_ia of the JointUSP joint
should be parallel to each other when defining an instance of this
component).
</p>
<p>
In the public interface of the JointUSP joint, the following
(final) <b>parameters</b> are provided:
</p>
<pre>
  <b>parameter</b> Real rod1Length(unit=\"m\")  \"Length of rod 1\";
  <b>parameter</b> Real eRod1_ia[3] \"Unit vector along rod 1, resolved in frame_ia\";
  <b>parameter</b> Real e2_ia  [3]  \"Unit vector along axis 2, resolved in frame_ia\";
</pre>
<p>
This allows a more convenient definition of data which is related to rod 1.
For example, if a box shall be connected at frame_ia directing from
the origin of frame_a to the middle of rod 1, this might be defined as:
</p>
<pre>
    Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUSP jointUSP(rRod1_ia={1.2, 1, 0.2});
    Modelica.Mechanics.MultiBody.Visualizers.FixedShape     shape(shapeType       = \"box\",
                                               lengthDirection = jointUSP.eRod1_ia,
                                               widthDirection  = jointUSP.e2_ia,
                                               length          = jointUSP.rod1Length/2,
                                               width           = jointUSP.rod1Length/10);
  <b>equation</b>
    <b>connect</b>(jointUSP.frame_ia, shape.frame_a);
</pre>
</html> "),
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Rectangle(
              extent={{50,20},{80,-20}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{80,30},{100,-30}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-140,-45},{140,-70}},
              lineColor={0,0,255},
              textString="%name"),
            Ellipse(
              extent={{-100,-30},{-40,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-93,-22},{-48,23}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-70,40},{-39,-33}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Line(
              points={{-70,28},{-70,-30}},
              color={0,0,0},
              thickness=0.5),
            Ellipse(
              extent={{-89,-18},{-48,18}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-84,-12},{-53,13}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{-81,-17},{-92,-1},{-83,16},{-57,24},{-81,-17}},
              pattern=LinePattern.None,
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Line(
              points={{-70,30},{-70,-10}},
              color={0,0,0},
              thickness=0.5),
            Line(
              points={{-61,16},{-79,-15}},
              color={0,0,0},
              thickness=0.5),
            Line(
              points={{-50,0},{-50,80},{-80,80},{-80,100}},
              color={95,95,95},
              thickness=0.5),
            Ellipse(
              extent={{-40,-30},{20,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-33,-22},{12,23}},
              lineColor={192,192,192},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-44,31},{-14,-30}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-23,10},{-3,-10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{19,6},{50,-6}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{-50,5},{-21,-5}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Text(
              extent={{37,109},{68,90}},
              lineColor={128,128,128},
              textString="ib"),
            Text(
              extent={{-124,110},{-93,90}},
              lineColor={128,128,128},
              textString="ia"),
            Line(
              points={{50,6},{50,80},{80,80},{80,100}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{-44,111},{-8,91}},
              lineColor={128,128,128},
              textString="im"),
            Line(
              points={{19,6},{19,80},{0,80},{0,100}},
              color={95,95,95},
              thickness=0.5),
            Rectangle(
              extent={{80,24},{100,30}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{50,14},{80,20}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Line(
              points={{95,80},{79,80}},
              color={135,135,135},
              thickness=0.5),
            Line(
              points={{95,40},{90,40},{90,30}},
              color={135,135,135},
              thickness=0.5)}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Line(
              points={{-78,30},{-50,30}},
              color={128,128,128},
              arrow={Arrow.None,Arrow.Filled}),
            Text(
              extent={{-76,39},{-49,32}},
              lineColor={128,128,128},
              textString="rRod1_ia"),
            Text(
              extent={{-27,40},{0,33}},
              lineColor={128,128,128},
              textString="rRod2_ib"),
            Line(
              points={{3,30},{-43,30}},
              color={128,128,128},
              arrow={Arrow.None,Arrow.Filled})}));
    end JointUSP;

    model JointSSR
      "Spherical - spherical - revolute joint aggregation with mass (no constraints, no potential states)"

      import SI = Modelica.SIunits;
      import Cv = Modelica.SIunits.Conversions;
      import Modelica.Mechanics.MultiBody.Types;

      extends Interfaces.PartialTwoFramesDoubleSize;
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_ib
        "Coordinate system at origin of frame_b fixed at connecting rod of spherical and revolute joint"
        annotation (Placement(transformation(
            origin={80,100},
            extent={{-8,8},{8,-8}},
            rotation=270)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_im
        "Coordinate system at origin of spherical joint in the middle fixed at connecting rod of spherical and revolute joint"
        annotation (Placement(transformation(
            origin={0,100},
            extent={{8,-8},{-8,8}},
            rotation=270)));
      Modelica.Mechanics.Rotational.Interfaces.Flange_a axis
        "1-dim. rotational flange that drives the revolute joint" 
        annotation (Placement(transformation(extent={{105,85},{95,75}},
              rotation=0)));
      Modelica.Mechanics.Rotational.Interfaces.Flange_b bearing
        "1-dim. rotational flange of the drive bearing of the revolute joint" 
        annotation (Placement(transformation(extent={{95,45},{105,35}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter Boolean showMass=true
        "= true, if point mass on rod 1 shall be shown (provided animation = true and rod1Mass > 0)";
      parameter SI.Length rod1Length(min=Modelica.Constants.eps, start = 1)
        "Distance between the origins of the two spherical joints ";
      parameter SI.Mass rod1Mass(min=0)=0
        "Mass of rod 1 (= point mass located in middle of rod connecting the two spherical joints)";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n_b={0,0,1}
        "Axis of revolute joint fixed and resolved in frame_b";
      parameter SI.Position rRod2_ib[3]={1,0,0}
        "Vector from origin of frame_ib to spherical joint in the middle, resolved in frame_ib";
      parameter Cv.NonSIunits.Angle_deg phi_offset=0
        "Relative angle offset of revolute joint (angle = phi(t) + from_deg(phi_offset))";
      parameter Cv.NonSIunits.Angle_deg phi_guess=0
        "Select the configuration such that at initial time |phi(t0) - from_deg(phi_guess)|is minimal";
      parameter SI.Diameter sphereDiameter=world.defaultJointLength
        "Diameter of the spheres representing the two spherical joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.
           JointColor
        "Color of the spheres representing the two spherical joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter rod1Diameter=sphereDiameter/Types.Defaults.
          JointRodDiameterFraction
        "Diameter of rod 1 connecting the two spherical joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rod1Color=Modelica.Mechanics.MultiBody.Types.Defaults.
          RodColor "Color of rod 1 connecting the two spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter rod2Diameter=rod1Diameter
        "Diameter of rod 2 connecting the revolute joint and spherical joint 2"
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rod2Color=rod1Color
        "Color of rod 2 connecting the revolute joint and spherical joint 2" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter revoluteDiameter=world.defaultJointWidth
        "Diameter of cylinder representing the revolute joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance revoluteLength=world.defaultJointLength
        "Length of cylinder representing the revolute joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color revoluteColor=Modelica.Mechanics.MultiBody.Types.
          Defaults.JointColor
        "Color of cylinder representing the revolute joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter Boolean checkTotalPower=false
        "= true, if total power flowing into this component shall be determined (must be zero)"
        annotation (Dialog(tab="Advanced"));
      SI.Position aux
        "Denominator used to compute force in rod connecting universal and spherical joint";
      SI.Force f_rod
        "Constraint force in direction of the rod (positive, if rod is pressed)";
      SI.Power totalPower
        "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";

      Modelica.Mechanics.MultiBody.Joints.Internal.RevoluteWithLengthConstraint
        revolute(
        animation=animation,
        lengthConstraint=rod1Length,
        n=n_b,
        phi_offset=phi_offset,
        phi_guess=phi_guess,
        cylinderDiameter=revoluteDiameter,
        cylinderLength=revoluteLength,
        cylinderColor=revoluteColor,
        specularCoefficient=specularCoefficient) 
                                 annotation (Placement(transformation(extent={{
                75,-20},{35,20}}, rotation=0)));
      Modelica.Mechanics.MultiBody.Joints.SphericalSpherical rod1(
        animation=animation,
        showMass=showMass,
        m=rod1Mass,
        rodLength=rod1Length,
        rodDiameter=rod1Diameter,
        sphereDiameter=sphereDiameter,
        rodColor=rod1Color,
        specularCoefficient=specularCoefficient,
        kinematicConstraint=false,
        sphereColor=sphereColor,
        constraintResidue=rod1.f_rod - f_rod) 
                                 annotation (Placement(transformation(extent={{
                -89,-20},{-49,20}}, rotation=0)));
      Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod2(
        animation=animation,
        width=rod2Diameter,
        height=rod2Diameter,
        color=rod2Color,
        specularCoefficient=specularCoefficient,
        r=rRod2_ib) annotation (Placement(transformation(extent={{15,-20},{-25,
                20}}, rotation=0)));
      Sensors.RelativePosition relativePosition(resolveInFrame=Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_a) 
        annotation (Placement(transformation(extent={{60,-70},{40,-90}},
              rotation=0)));
      Modelica.Blocks.Sources.Constant position_b[3](k=rRod2_ib) 
        annotation (Placement(transformation(extent={{-20,-50},{0,-30}},
              rotation=0)));
    equation
      /* Compute the unknown force in the rod of the rod1 joint
     by a torque balance at the revolute joint:
       0 = frame_b.t + frame_ib.t + frame_im.t + cross(rRod2_ib, frame_im.f)
           + cross(rRod2_ib, -rod1.f_b_a1)
           + cross(rRod2_ib, Frames.resolve2(rod1.R_rel, rod1.f_rod*rod1.eRod_a))
     The condition is that the projection of the torque in the revolute
     joint along the axis of the revolute joint is equal to the driving
     axis torque in the flange:
       -revolute.tau = revolute.e*frame_b.t
     Therefore, we have with e=revolute.e and tau=revolute.tau
        tau = e*(frame_ib.t  + frame_im.t + cross(rRod2_ib, frame_im.f)
              + cross(rRod2_ib, -rod1.f_b_a1))
              + e*cross(rRod2_ib, Frames.resolve2(rod1.R_rel, rod1.f_rod*rod1.eRod_a))
            = e*(frame_ib.t + frame_im.t + cross(rRod2_ib, frame_im.f)
              + cross(rRod2_ib, -rod.f_b_a1))
              + rod1.f_rod*e*cross(rRod2_ib, Frames.resolve2(rod1.R_rel, rod1.eRod_a))
     Solving this equation for f_rod results in
       rod1.f_rod = (tau - e*(frame_ib.t + frame_im.t + cross(rRod2_ib, frame_im.f)
                   + cross(rRod2_ib, -rod1.f_b_a1)))
                   / (cross(e,rRod2_ib)*Frames.resolve2(rod1.R_rel, rod1.eRod_a)))
     Additionally, a guard against division by zero is introduced
  */

      aux = cross(revolute.e, rRod2_ib)*Frames.resolveRelative(rod1.eRod_a,
        rod1.frame_a.R, rod1.frame_b.R);
      f_rod = (-revolute.tau - revolute.e*(frame_ib.t + frame_im.t + cross(
        rRod2_ib, frame_im.f) - cross(rRod2_ib, Frames.resolveRelative(rod1.
        f_b_a1, rod1.frame_a.R, rod1.frame_b.R))))/noEvent(if abs(aux) < 1.e-10 then 
              1.e-10 else aux);

      // Measure power for test purposes
      if checkTotalPower then
        totalPower = frame_a.f*Frames.resolve2(frame_a.R, der(frame_a.r_0)) +
          frame_b.f*Frames.resolve2(frame_b.R, der(frame_b.r_0)) + frame_ib.f*
          Frames.resolve2(frame_ib.R, der(frame_ib.r_0)) + frame_im.f*
          Frames.resolve2(frame_im.R, der(frame_im.r_0)) + frame_a.t*
          Frames.angularVelocity2(frame_a.R) + frame_b.t*
          Frames.angularVelocity2(frame_b.R) + frame_ib.t*
          Frames.angularVelocity2(frame_ib.R) + frame_im.t*
          Frames.angularVelocity2(frame_im.R) + axis.tau*der(axis.phi) +
          bearing.tau*der(bearing.phi) + (-rod1Mass)*(der(rod1.v_CM_0) -
          world.gravityAcceleration(rod1.r_CM_0))*rod1.v_CM_0;
      else
        totalPower = 0;
      end if;

      connect(revolute.frame_b, rod2.frame_a) annotation (Line(
          points={{35,0},{15,0}},
          color={95,95,95},
          thickness=0.5));
      connect(rod2.frame_b, rod1.frame_b) annotation (Line(
          points={{-25,0},{-49,0}},
          color={95,95,95},
          thickness=0.5));
      connect(revolute.frame_a, frame_b) annotation (Line(
          points={{75,0},{100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(rod2.frame_a, frame_ib) annotation (Line(
          points={{15,0},{26,0},{26,70},{80,70},{80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(rod1.frame_a, frame_a) annotation (Line(
          points={{-89,0},{-100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(relativePosition.frame_b, frame_a) 
                                               annotation (Line(
          points={{40,-80},{-95,-80},{-95,0},{-100,0}},
          color={95,95,95},
          pattern=LinePattern.Dot));
      connect(relativePosition.frame_a, frame_b) 
                                               annotation (Line(
          points={{60,-80},{96,-80},{96,0},{100,0}},
          color={95,95,95},
          pattern=LinePattern.Dot));
      connect(position_b.y, revolute.position_b)       annotation (Line(
          points={{1,-40},{20,-40},{20,-12},{31,-12}},
          color={0,0,127}));
      connect(revolute.axis, axis) annotation (Line(points={{55,20},{55,60},{90,
              60},{90,80},{100,80}}, color={0,0,0}));
      connect(rod2.frame_b, frame_im) annotation (Line(
          points={{-25,0},{-35,0},{-35,60},{0,60},{0,100}},
          color={95,95,95},
          thickness=0.5));
      connect(relativePosition.r_rel, revolute.position_a) 
                                                         annotation (Line(
          points={{50,-69},{50,-50},{90,-50},{90,-12},{79,-12}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(revolute.bearing, bearing) annotation (Line(
          points={{67,20},{67,40},{100,40}},
          color={0,0,0},
          smooth=Smooth.None));
      annotation (
        Documentation(info="<html>
<p>
This component consists of a <b>spherical</b> joint 1 at frame_a, a <b>revolute</b>
joint at frame_b and a <b>spherical</b> joint 2 which is connected via rod 1
to the spherical joint 1 and via rod 2 to the revolute joint, see the default
animation in the following figure (the axes vectors are not part of the
default animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/JointSSR.png\" ALT=\"model Joints.Assemblies.JointSSR\">
</p>
<p>
Besides an optional point mass in the middle of rod 1,
this joint aggregation has no mass and no inertia,
and introduces neither constraints nor potential state variables.
It should be used in kinematic loops whenever possible since
the non-linear system of equations introduced by this joint aggregation
is solved <b>analytically</b> (i.e., a solution is always computed, if a
unique solution exists).
</p>
<p>
An additional <b>frame_ib</b> is present. It is <b>fixed</b> in rod 2
connecting the revolute and the spherical joint at the side of the revolute
joint that is connected to this rod (= rod2.frame_a = revolute.frame_a).
</p>
<p>
An additional <b>frame_im</b> is present. It is <b>fixed</b> in rod 2
connecting the revolute and the spherical joint at the side of spherical
joint 2 that is connected to this rod (= rod2.frame_b).
It is always parallel to <b>frame_ib</b>.
</p>
<p>
The easiest way to define the parameters of this joint is by moving the
MultiBody system in a <b>reference configuration</b> where <b>all frames</b>
of all components are <b>parallel</b> to each other (alternatively,
at least frame_b and frame_ib of the JointSSR joint
should be parallel to each other when defining an instance of this
component).
</p>
</html> "),
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Text(
              extent={{-141,-41},{139,-66}},
              lineColor={0,0,255},
              textString="%name"),
            Ellipse(
              extent={{-100,-30},{-40,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-93,-22},{-48,23}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-63,33},{-39,-33}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-40,-30},{20,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-33,-22},{12,23}},
              lineColor={192,192,192},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-44,31},{-19,-30}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-23,10},{-3,-10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{19,6},{61,-6}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{60,-30},{76,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{85,-30},{100,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{76,10},{85,-10}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(extent={{60,30},{76,-30}}, lineColor={0,0,0}),
            Rectangle(extent={{85,30},{100,-30}}, lineColor={0,0,0}),
            Text(
              extent={{88,112},{127,92}},
              lineColor={128,128,128},
              textString="ib"),
            Ellipse(
              extent={{-80,11},{-60,-9}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-62,6},{-21,-5}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Line(
              points={{80,80},{100,80}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{19,6},{19,80},{0,80},{0,100}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{-47,111},{-8,92}},
              lineColor={128,128,128},
              textString="im"),
            Line(
              points={{68,30},{68,80},{80,80},{80,98}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{90,30},{90,40},{95,40}},
              color={95,95,95},
              thickness=0.5)}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics));
    end JointSSR;

    model JointSSP
      "Spherical - spherical - prismatic joint aggregation with mass (no constraints, no potential states)"

      import SI = Modelica.SIunits;
      import Cv = Modelica.SIunits.Conversions;
      import Modelica.Mechanics.MultiBody.Types;

      extends Interfaces.PartialTwoFramesDoubleSize;
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_ib
        "Coordinate system at origin of frame_b fixed at connecting rod of spherical and prismatic joint"
        annotation (Placement(transformation(
            origin={80,100},
            extent={{-8,8},{8,-8}},
            rotation=270)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_im
        "Coordinate system at origin of spherical joint in the middle fixed at connecting rod of spherical and prismatic joint"
        annotation (Placement(transformation(
            origin={0,100},
            extent={{8,-8},{-8,8}},
            rotation=270)));
      Modelica.Mechanics.Translational.Interfaces.Flange_a axis
        "1-dim. translational flange that drives the prismatic joint" 
        annotation (Placement(transformation(extent={{95,75},{105,85}},
              rotation=0)));
      Modelica.Mechanics.Translational.Interfaces.Flange_b bearing
        "1-dim. translational flange of the drive bearing of the prismatic joint"
        annotation (Placement(transformation(extent={{105,35},{95,45}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter Boolean showMass=true
        "= true, if point mass on rod 1 shall be shown (provided animation = true and rod1Mass > 0)";
      parameter SI.Length rod1Length(min=Modelica.Constants.eps, start = 1)
        "Distance between the origins of the two spherical joints ";
      parameter SI.Mass rod1Mass(min=0)=0
        "Mass of rod 1 (= point mass located in middle of rod connecting the two spherical joints)";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n_b={0,0,1}
        "Axis of prismatic joint fixed and resolved in frame_b";
      parameter SI.Position rRod2_ib[3]={1,0,0}
        "Vector from origin of frame_ib to spherical joint in the middle, resolved in frame_ib";
      parameter SI.Position s_offset=0
        "Relative distance offset of prismatic joint (distance between frame_b and frame_ib = s(t) + s_offset)";
      parameter SI.Position s_guess=0
        "Select the configuration such that at initial time |s(t0)-s_guess|is minimal";

      parameter SI.Diameter sphereDiameter=world.defaultJointLength
        "Diameter of the spheres representing the two spherical joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.
           JointColor
        "Color of the spheres representing the two spherical joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter rod1Diameter=sphereDiameter/Types.Defaults.
          JointRodDiameterFraction
        "Diameter of rod 1 connecting the two spherical joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rod1Color=Modelica.Mechanics.MultiBody.Types.Defaults.
          RodColor "Color of rod 1 connecting the two spherical joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

      parameter SI.Diameter rod2Diameter=rod1Diameter
        "Diameter of rod 2 connecting the revolute joint and spherical joint 2"
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rod2Color=rod1Color
        "Color of rod 2 connecting the revolute joint and spherical joint 2" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

      parameter Types.Axis boxWidthDirection={0,1,0}
        "Vector in width direction of prismatic joint box, resolved in frame_b"
        annotation (Evaluate=true, Dialog(tab="Animation", group=
              "if animation = true", enable=animation));
      parameter SI.Distance boxWidth=world.defaultJointWidth
        "Width of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance boxHeight=boxWidth "Height of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color boxColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter Boolean checkTotalPower=false
        "= true, if total power flowing into this component shall be determined (must be zero)"
        annotation (Dialog(tab="Advanced"));
      Real aux
        "Denominator used to compute force in rod connecting universal and spherical joint";
      SI.Force f_rod
        "Constraint force in direction of the rod (positive, if rod is pressed)";
      SI.Power totalPower
        "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";

      Modelica.Mechanics.MultiBody.Joints.Internal.PrismaticWithLengthConstraint
        prismatic(
        animation=animation,
        length=rod1Length,
        n=n_b,
        s_offset=s_offset,
        s_guess=s_guess,
        boxWidthDirection=boxWidthDirection,
        boxWidth=boxWidth,
        boxHeight=boxHeight,
        specularCoefficient=specularCoefficient,
        boxColor=boxColor) annotation (Placement(transformation(extent={{75,-20},
                {35,20}}, rotation=0)));
      Modelica.Mechanics.MultiBody.Joints.SphericalSpherical rod1(
        animation=animation,
        showMass=showMass,
        m=rod1Mass,
        rodLength=rod1Length,
        rodDiameter=rod1Diameter,
        sphereDiameter=sphereDiameter,
        rodColor=rod1Color,
        kinematicConstraint=false,
        specularCoefficient=specularCoefficient,
        sphereColor=sphereColor,
        constraintResidue=rod1.f_rod - f_rod) 
                                 annotation (Placement(transformation(extent={{
                -89,-20},{-49,20}}, rotation=0)));
      Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod2(
        animation=animation,
        width=rod2Diameter,
        height=rod2Diameter,
        specularCoefficient=specularCoefficient,
        color=rod2Color,
        r=rRod2_ib) annotation (Placement(transformation(extent={{15,-20},{-25,
                20}}, rotation=0)));
      Sensors.RelativePosition relativePosition(resolveInFrame=Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_a) 
        annotation (Placement(transformation(extent={{60,-70},{40,-90}},
              rotation=0)));
      Modelica.Blocks.Sources.Constant position_b[3](k=rRod2_ib) 
        annotation (Placement(transformation(extent={{-20,-50},{0,-30}},
              rotation=0)));
    equation
      /* Compute the unknown force in the rod of the rod1 joint
     by a force balance:
       0 = frame_b.f + frame_ib.f + frame_im.f +
           Frames.resolve2(rod1.R_rel, rod1.f_rod*rod1.eRod_a)
     The condition is that the projection of the force in the prismatic
     joint along the axis of the prismatic joint is equal to the driving
     axis force in the flange:
       -prismatic.f = prismatic.e*frame_b.f
     Therefore, we have with e=prismatic.e and f=prismatic.f
        f = e*(frame_ib.f + frame_im.f +
               Frames.resolve2(rod1.R_rel, rod1.f_rod*rod1.eRod_a))
          = e*(frame_ib.f + frame_im.f +
               rod1.f_rod*Frames.resolve2(rod1.R_rel, rod1.eRod_a))
     Solving this equation for f_rod results in
       rod1.f_rod = (f - e*(frame_ib.f + frame_im.f))
                    / (e*Frames.resolve2(rod1.R_rel, rod1.eRod_a))
     Additionally, a guard against division by zero is introduced
  */
      aux = prismatic.e*Frames.resolveRelative(rod1.eRod_a, rod1.frame_a.R,
        rod1.frame_b.R);
      f_rod = (-prismatic.f - prismatic.e*(frame_ib.f + frame_im.f))/
        noEvent(if abs(aux) < 1.e-10 then 1.e-10 else aux);

      // Measure power for test purposes
      if checkTotalPower then
        totalPower = frame_a.f*Frames.resolve2(frame_a.R, der(frame_a.r_0)) +
          frame_b.f*Frames.resolve2(frame_b.R, der(frame_b.r_0)) + frame_ib.f*
          Frames.resolve2(frame_ib.R, der(frame_ib.r_0)) + frame_im.f*
          Frames.resolve2(frame_im.R, der(frame_im.r_0)) + frame_a.t*
          Frames.angularVelocity2(frame_a.R) + frame_b.t*
          Frames.angularVelocity2(frame_b.R) + frame_ib.t*
          Frames.angularVelocity2(frame_ib.R) + frame_im.t*
          Frames.angularVelocity2(frame_im.R) + axis.f*der(axis.s) + bearing.f*
          der(bearing.s) + (-rod1Mass)*(der(rod1.v_CM_0) -
          world.gravityAcceleration(rod1.r_CM_0))*rod1.v_CM_0;
      else
        totalPower = 0;
      end if;

      connect(prismatic.frame_b, rod2.frame_a) annotation (Line(
          points={{35,0},{15,0}},
          color={95,95,95},
          thickness=0.5));
      connect(rod2.frame_b, rod1.frame_b) annotation (Line(
          points={{-25,0},{-49,0}},
          color={95,95,95},
          thickness=0.5));
      connect(prismatic.frame_a, frame_b) annotation (Line(
          points={{75,0},{100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(rod2.frame_a, frame_ib) annotation (Line(
          points={{15,0},{26,0},{26,70},{80,70},{80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(rod1.frame_a, frame_a) annotation (Line(
          points={{-89,0},{-100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(relativePosition.frame_b, frame_a) 
                                               annotation (Line(
          points={{40,-80},{-95,-80},{-95,0},{-100,0}},
          color={95,95,95},
          pattern=LinePattern.Dot));
      connect(relativePosition.frame_a, frame_b) 
                                               annotation (Line(
          points={{60,-80},{96,-80},{96,0},{100,0}},
          color={95,95,95},
          pattern=LinePattern.Dot));
      connect(position_b.y, prismatic.position_b)       annotation (Line(
          points={{1,-40},{20,-40},{20,-12},{31,-12}},
          color={0,0,127}));
      connect(prismatic.axis, axis) annotation (Line(points={{39,14},{40,14},{
              40,60},{90,60},{90,80},{100,80}}, color={0,0,0}));
      connect(prismatic.bearing, bearing) 
        annotation (Line(points={{63,14},{63,40},{100,40}}, color={0,0,0}));
      connect(rod2.frame_b, frame_im) annotation (Line(
          points={{-25,0},{-35,0},{-35,60},{0,60},{0,100}},
          color={95,95,95},
          thickness=0.5));
      connect(relativePosition.r_rel, prismatic.position_a) 
                                                          annotation (Line(
          points={{50,-69},{50,-50},{90,-50},{90,-12},{79,-12}},
          color={0,0,127},
          smooth=Smooth.None));
      annotation (
        Documentation(info="<html>
<p>
This component consists of a <b>spherical</b> joint 1 at frame_a, a <b>prismatic</b>
joint at frame_b and a <b>spherical</b> joint 2 which is connected via rod 1
to the spherical joint 1 and via rod 2 to the prismatic joint, see the default
animation in the following figure (the axes vectors are not part of the
default animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/JointSSP.png\" ALT=\"model Joints.Assemblies.JointSSP\">
</p>
<p>
Besides an optional point mass in the middle of rod 1,
this joint aggregation has no mass and no inertia,
and introduces neither constraints nor potential state variables.
It should be used in kinematic loops whenever possible since
the non-linear system of equations introduced by this joint aggregation
is solved <b>analytically</b> (i.e., a solution is always computed, if a
unique solution exists).
</p>
<p>
An additional <b>frame_ib</b> is present. It is <b>fixed</b> in rod 2
connecting the prismatic and the spherical joint at the side of the prismatic
joint that is connected to this rod (= rod2.frame_a = prismatic.frame_a).
</p>
<p>
An additional <b>frame_im</b> is present. It is <b>fixed</b> in rod 2
connecting the prismatic and the spherical joint at the side of spherical
joint 2 that is connected to this rod (= rod2.frame_b).
It is always parallel to <b>frame_ib</b>.
</p>
<p>
The easiest way to define the parameters of this joint is by moving the
MultiBody system in a <b>reference configuration</b> where <b>all frames</b>
of all components are <b>parallel</b> to each other (alternatively,
at least frame_b and frame_ib of the JointSSP joint
should be parallel to each other when defining an instance of this
component).
</p>
</html> "),
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Text(
              extent={{-140,-40},{140,-65}},
              lineColor={0,0,255},
              textString="%name"),
            Ellipse(
              extent={{-100,-30},{-40,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-93,-22},{-48,23}},
              lineColor={160,160,164},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-63,33},{-39,-33}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-40,-30},{20,30}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={192,192,192}),
            Ellipse(
              extent={{-33,-22},{12,23}},
              lineColor={192,192,192},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-44,31},{-19,-30}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-23,10},{-3,-10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{19,6},{61,-6}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Text(
              extent={{89,115},{132,92}},
              lineColor={128,128,128},
              textString="ib"),
            Ellipse(
              extent={{-80,11},{-60,-9}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-62,6},{-21,-5}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Line(
              points={{19,6},{19,80},{0,80},{0,100}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{-49,114},{-11,92}},
              lineColor={128,128,128},
              textString="im"),
            Rectangle(
              extent={{50,20},{80,-20}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{80,30},{100,-30}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{50,14},{80,20}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{80,24},{100,30}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Line(
              points={{50,6},{50,80},{80,80},{80,100}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{101,80},{80,80}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{99,40},{90,40},{90,30}},
              color={95,95,95},
              thickness=0.5)}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics));
    end JointSSP;

    model JointRRR
      "Planar revolute - revolute - revolute joint aggregation (no constraints, no potential states)"

      import SI = Modelica.SIunits;
      import Cv = Modelica.SIunits.Conversions;
      import Modelica.Mechanics.MultiBody.Types;

      extends Interfaces.PartialTwoFramesDoubleSize;

      Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_ia
        "Coordinate system at origin of frame_a fixed at connecting rod of left and middle revolute joint"
        annotation (Placement(transformation(
            origin={-80,100},
            extent={{-8,-8},{8,8}},
            rotation=90)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_ib
        "Coordinate system at origin of frame_b fixed at connecting rod of middle and right revolute joint"
        annotation (Placement(transformation(
            origin={80,100},
            extent={{-8,8},{8,-8}},
            rotation=270)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_im
        "Coordinate system at origin of revolute joint in the middle fixed at connecting rod of middle and right revolute joint"
        annotation (Placement(transformation(
            origin={0,100},
            extent={{8,-8},{-8,8}},
            rotation=270)));
      Modelica.Mechanics.Rotational.Interfaces.Flange_a axis
        "1-dim. rotational flange that drives the right revolute joint at frame_b"
        annotation (Placement(transformation(extent={{105,85},{95,75}},
              rotation=0)));
      Modelica.Mechanics.Rotational.Interfaces.Flange_b bearing
        "1-dim. rotational flange of the drive bearing of the right revolute joint at frame_b"
        annotation (Placement(transformation(extent={{95,45},{105,35}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n_a={0,0,1}
        "Axes of revolute joints resolved in frame_a (all axes are parallel to each other)"
        annotation (Evaluate=true);
      final parameter Real n_b[3](each final unit="1",fixed=false) = {0,0,1}
        "Axis of revolute joint fixed and resolved in frame_b" 
        annotation (Evaluate=true);
      parameter SI.Position rRod1_ia[3]={1,0,0}
        "Vector from origin of frame_a to revolute joint in the middle, resolved in frame_ia"
        annotation (Evaluate=true);
      parameter SI.Position rRod2_ib[3]={-1,0,0}
        "Vector from origin of frame_ib to revolute joint in the middle, resolved in frame_ib";
      parameter Cv.NonSIunits.Angle_deg phi_offset=0
        "Relative angle offset of revolute joint at frame_b (angle = phi(t) + from_deg(phi_offset))";
      parameter Cv.NonSIunits.Angle_deg phi_guess=0
        "Select the configuration such that at initial time |phi(t0) - from_deg(phi_guess)|is minimal";
      parameter SI.Distance cylinderLength=world.defaultJointLength
        "Length of cylinders representing the revolute joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance cylinderDiameter=world.defaultJointWidth
        "Diameter of cylinders representing the revolute joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of cylinders representing the revolute joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter rodDiameter=1.1*cylinderDiameter
        "Diameter of the two rods connecting the revolute joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rodColor=Modelica.Mechanics.MultiBody.Types.Defaults.RodColor
        "Color of the two rods connecting the revolute joint" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

      parameter Boolean checkTotalPower=false
        "= true, if total power flowing into this component shall be determined (must be zero)"
        annotation (Dialog(tab="Advanced"));
      final parameter Real e_a[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                                   n_a)
        "Unit vector along axes of rotations, resolved in frame_a";
      final parameter Real e_ia[3](each final unit="1")=jointUSR.e2_ia
        "Unit vector along axes of rotations, resolved in frame_ia";
      final parameter Real e_b[3](each final unit="1")=jointUSR.revolute.e
        "Unit vector along axes of rotations, resolved in frame_b, frame_ib and frame_im";
      SI.Power totalPower=jointUSR.totalPower
        "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";

      JointUSR jointUSR(
        animation=false,
        n1_a=n_a,
        n_b=n_b,
        phi_offset=phi_offset,
        rRod2_ib=rRod2_ib,
        showUniversalAxes=false,
        rRod1_ia=rRod1_ia,
        checkTotalPower=checkTotalPower,
        phi_guess=phi_guess) annotation (Placement(transformation(extent={{-30,
                -20},{10,20}}, rotation=0)));

    protected
     Visualizers.Advanced.Shape shape_rev1(
        shapeType="cylinder",
        color=cylinderColor,
        specularCoefficient=specularCoefficient,
        length=cylinderLength,
        width=cylinderDiameter,
        height=cylinderDiameter,
        lengthDirection=e_a,
        widthDirection={0,1,0},
        r_shape=-e_a*(cylinderLength/2),
        r=frame_a.r_0,
        R=frame_a.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape shape_rev2(
        shapeType="cylinder",
        color=cylinderColor,
        specularCoefficient=specularCoefficient,
        length=cylinderLength,
        width=cylinderDiameter,
        height=cylinderDiameter,
        lengthDirection=e_b,
        widthDirection={0,1,0},
        r_shape=-e_b*(cylinderLength/2),
        r=frame_im.r_0,
        R=frame_im.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape shape_rev3(
        shapeType="cylinder",
        color=cylinderColor,
        specularCoefficient=specularCoefficient,
        length=cylinderLength,
        width=cylinderDiameter,
        height=cylinderDiameter,
        lengthDirection=e_b,
        widthDirection={0,1,0},
        r_shape=-e_b*(cylinderLength/2),
        r=frame_b.r_0,
        R=frame_b.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape shape_rod1(
        shapeType="cylinder",
        color=rodColor,
        specularCoefficient=specularCoefficient,
        length=Modelica.Math.Vectors.length(
                             rRod1_ia),
        width=rodDiameter,
        height=rodDiameter,
        lengthDirection=rRod1_ia,
        widthDirection=e_ia,
        r=frame_ia.r_0,
        R=frame_ia.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape shape_rod2(
        shapeType="cylinder",
        color=rodColor,
        specularCoefficient=specularCoefficient,
        length=Modelica.Math.Vectors.length(
                             rRod2_ib),
        width=rodDiameter,
        height=rodDiameter,
        lengthDirection=rRod2_ib,
        widthDirection=e_b,
        r=frame_ib.r_0,
        R=frame_ib.R) if world.enableAnimation and animation;
    initial equation
      n_b = Frames.resolve2(frame_b.R, Frames.resolve1(frame_a.R, n_a));
    equation
      connect(jointUSR.frame_a, frame_a) 
        annotation (Line(
          points={{-30,0},{-100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSR.frame_b, frame_b) 
        annotation (Line(
          points={{10,0},{100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSR.frame_ia, frame_ia) annotation (Line(
          points={{-26,20},{-26,70},{-80,70},{-80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSR.frame_im, frame_im) annotation (Line(
          points={{-10,20},{-10,70},{0,70},{0,100}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSR.frame_ib, frame_ib) annotation (Line(
          points={{6,20},{6,50},{80,50},{80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSR.axis, axis) 
        annotation (Line(points={{10,16},{86,16},{86,80},{100,80}}, color={0,0,
              0}));
      connect(jointUSR.bearing, bearing) 
        annotation (Line(points={{10,8},{94,8},{94,40},{100,40}}, color={0,0,0}));
      annotation (
        Documentation(info="<html>
<p>
This component consists of <b>3 revolute</b> joints with parallel
axes of rotation that are connected together by two rods, see the default
animation in the following figure (the axes vectors are not part of the
default animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/JointRRR.png\" ALT=\"model Joints.Assemblies.JointRRR\">
</p>
<p>
This joint aggregation introduces neither constraints nor state variables and
should therefore be used in kinematic loops whenever possible to
avoid non-linear systems of equations. It is only meaningful to
use this component in <b>planar loops</b>. Basically, the position
and orientation of the 3 revolute joints as well as of frame_ia, frame_ib, and
frame_im are calculated by solving analytically a non-linear equation,
given the position and orientation at frame_a and at frame_b.
</p>
<p>
Connector <b>frame_a</b> is the \"left\" side of the first revolute joint
whereas <b>frame_ia</b> is the \"right side of this revolute joint, fixed in rod 1.
Connector <b>frame_b</b> is the \"right\" side of the third revolute joint
whereas <b>frame_ib</b> is the \"left\" side of this revolute joint, fixed in rod 2.
Finally, connector <b>frame_im</b> is the connector at the \"right\" side
of the revolute joint in the middle, fixed in rod 2.
</p>
<p>
The easiest way to define the parameters of this joint is by moving the
MultiBody system in a <b>reference configuration</b> where <b>all frames</b>
of all components are <b>parallel</b> to each other (alternatively,
at least frame_a, frame_ia, frame_im, frame_ib, frame_b of the JointRRR joint
should be parallel to each other when defining an instance of this
component).
</p>
<p>
Basically, the JointRRR model consists internally of a universal -
spherical - revolute joint aggregation (= JointUSR). In a planar
loop this will behave as if 3 revolute joints with parallel axes
are connected by rigid rods.
</p>
</html> "),
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Rectangle(
              extent={{-90,90},{90,-90}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-140,-55},{140,-80}},
              lineColor={0,0,255},
              textString="%name"),
            Text(
              extent={{36,114},{71,92}},
              lineColor={128,128,128},
              textString="ib"),
            Text(
              extent={{-126,115},{-87,90}},
              lineColor={128,128,128},
              textString="ia"),
            Ellipse(
              extent={{-100,25},{-50,-25}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-85,10},{-65,-10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{50,25},{100,-25}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{65,10},{85,-10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-26,80},{24,30}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-10,66},{10,46}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{-71,9},{-24,45},{-19,39},{-66,3},{-71,9}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{54,12},{5,47},{10,52},{59,18},{54,12}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{100,-4},{83,-4},{84,3},{100,3},{100,-4}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Line(
              points={{80,24},{80,80},{80,80},{80,100}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{-128,-29},{136,-47}},
              lineColor={0,0,0},
              textString="n_a=%n_a"),
            Line(
              points={{0,57},{0,86},{0,86},{0,100}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{-46,114},{-7,91}},
              lineColor={128,128,128},
              textString="im"),
            Line(
              points={{-80,100},{-80,8}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{80,80},{101,80}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{100,40},{93,40},{93,3}},
              color={95,95,95},
              thickness=0.5)}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics));
    end JointRRR;

    model JointRRP
      "Planar revolute - revolute - prismatic joint aggregation (no constraints, no potential states)"

      import SI = Modelica.SIunits;
      import Cv = Modelica.SIunits.Conversions;
      import Modelica.Mechanics.MultiBody.Types;

      extends Interfaces.PartialTwoFramesDoubleSize;
      Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_ia
        "Coordinate system at origin of frame_a fixed at connecting rod of revolute joints"
        annotation (Placement(transformation(
            origin={-80,100},
            extent={{-8,-8},{8,8}},
            rotation=90)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_ib
        "Coordinate system at origin of frame_b fixed at connecting rod of revolute and prismatic joint"
        annotation (Placement(transformation(
            origin={80,100},
            extent={{-8,8},{8,-8}},
            rotation=270)));
      Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_im
        "Coordinate system at origin of revolute joint in the middle fixed at connecting rod of revolute and prismatic joint"
        annotation (Placement(transformation(
            origin={0,100},
            extent={{8,-8},{-8,8}},
            rotation=270)));
      Modelica.Mechanics.Translational.Interfaces.Flange_a axis
        "1-dim. translational flange that drives the prismatic joint" 
        annotation (Placement(transformation(extent={{95,75},{105,85}},
              rotation=0)));
      Modelica.Mechanics.Translational.Interfaces.Flange_b bearing
        "1-dim. translational flange of the drive bearing of the prismatic joint"
        annotation (Placement(transformation(extent={{105,35},{95,45}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n_a={0,0,1}
        "Axes of the two revolute joints resolved in frame_a (both axes are parallel to each other)"
        annotation (Evaluate=true);
      parameter Modelica.Mechanics.MultiBody.Types.Axis n_b={-1,0,0}
        "Axis of prismatic joint fixed and resolved in frame_b (must be orthogonal to revolute joint axes)"
        annotation (Evaluate=true);
      parameter SI.Position rRod1_ia[3]={1,0,0}
        "Vector from origin of frame_a to revolute joint in the middle, resolved in frame_ia"
        annotation (Evaluate=true);
      parameter SI.Position rRod2_ib[3]={-1,0,0}
        "Vector from origin of frame_ib to revolute joint in the middle, resolved in frame_ib (frame_ib is parallel to frame_b)";
      parameter SI.Position s_offset=0
        "Relative distance offset of prismatic joint (distance between the prismatic joint frames = s(t) + s_offset)";
      parameter SI.Position s_guess=0
        "Select the configuration such that at initial time |s(t0)-s_guess|is minimal";
      parameter SI.Distance cylinderLength=world.defaultJointLength
        "Length of cylinders representing the revolute joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance cylinderDiameter=world.defaultJointWidth
        "Diameter of cylinders representing the revolute joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of cylinders representing the revolute joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter Types.Axis boxWidthDirection={0,1,0}
        "Vector in width direction of prismatic joint, resolved in frame_b" 
        annotation (Evaluate=true, Dialog(tab="Animation", group=
              "if animation = true", enable=animation));
      parameter SI.Distance boxWidth=world.defaultJointWidth
        "Width of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance boxHeight=boxWidth "Height of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color boxColor=cylinderColor "Color of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Diameter rodDiameter=1.1*cylinderDiameter
        "Diameter of the two rods connecting the joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color rodColor=Modelica.Mechanics.MultiBody.Types.Defaults.RodColor
        "Color of the two rods connecting the joints" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter Boolean checkTotalPower=false
        "= true, if total power flowing into this component shall be determined (must be zero)"
        annotation (Dialog(tab="Advanced"));
      final parameter Real e_a[3](each final unit="1")=Modelica.Math.Vectors.normalize(
                                                   n_a)
        "Unit vector along axes of rotations, resolved in frame_a";
      final parameter Real e_ia[3](each final unit="1")=jointUSP.e2_ia
        "Unit vector along axes of rotations, resolved in frame_ia";
      final parameter Real e_im[3](each final unit="1", each fixed=false)
        "Unit vector along axes of rotations, resolved in frame_im";
      final parameter Real e_b[3](each final unit="1")=jointUSP.prismatic.e
        "Unit vector along axes of translation of the prismatic joint, resolved in frame_b and frame_ib";
      SI.Power totalPower=jointUSP.totalPower
        "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";

      JointUSP jointUSP(
        animation=false,
        showUniversalAxes=false,
        n1_a=n_a,
        n_b=n_b,
        s_offset=s_offset,
        s_guess=s_guess,
        rRod1_ia=rRod1_ia,
        rRod2_ib=rRod2_ib,
        checkTotalPower=checkTotalPower) annotation (Placement(transformation(
              extent={{-30,-20},{10,20}}, rotation=0)));

    protected
      Visualizers.Advanced.Shape shape_rev1(
        shapeType="cylinder",
        color=cylinderColor,
        specularCoefficient=specularCoefficient,
        length=cylinderLength,
        width=cylinderDiameter,
        height=cylinderDiameter,
        lengthDirection=e_a,
        widthDirection={0,1,0},
        r_shape=-e_a*(cylinderLength/2),
        r=frame_a.r_0,
        R=frame_a.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape shape_rev2(
        shapeType="cylinder",
        color=cylinderColor,
        specularCoefficient=specularCoefficient,
        length=cylinderLength,
        width=cylinderDiameter,
        height=cylinderDiameter,
        lengthDirection=e_im,
        widthDirection={0,1,0},
        r_shape=-e_im*(cylinderLength/2),
        r=frame_im.r_0,
        R=frame_im.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape shape_prism(
        shapeType="box",
        color=boxColor,
        specularCoefficient=specularCoefficient,
        length=jointUSP.prismatic.distance,
        width=boxWidth,
        height=boxHeight,
        lengthDirection=e_b,
        widthDirection=e_im,
        r=frame_b.r_0,
        R=frame_b.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape shape_rod1(
        shapeType="cylinder",
        color=rodColor,
        specularCoefficient=specularCoefficient,
        length=Modelica.Math.Vectors.length(
                             rRod1_ia),
        width=rodDiameter,
        height=rodDiameter,
        lengthDirection=rRod1_ia,
        widthDirection=e_ia,
        r=frame_ia.r_0,
        R=frame_ia.R) if world.enableAnimation and animation;
      Visualizers.Advanced.Shape shape_rod2(
        shapeType="cylinder",
        color=rodColor,
        specularCoefficient=specularCoefficient,
        length=Modelica.Math.Vectors.length(
                             rRod2_ib),
        width=rodDiameter,
        height=rodDiameter,
        lengthDirection=rRod2_ib,
        widthDirection=e_b,
        r=frame_ib.r_0,
        R=frame_ib.R) if world.enableAnimation and animation;
    initial equation
      e_im = Frames.resolve2(frame_im.R, Frames.resolve1(frame_a.R, e_a));
    equation
      connect(jointUSP.frame_a, frame_a) 
        annotation (Line(
          points={{-30,0},{-100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSP.frame_b, frame_b) 
        annotation (Line(
          points={{10,0},{100,0}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSP.frame_ia, frame_ia) annotation (Line(
          points={{-26,20},{-26,70},{-80,70},{-80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSP.frame_im, frame_im) annotation (Line(
          points={{-10,20},{-10,70},{0,70},{0,100}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSP.frame_ib, frame_ib) annotation (Line(
          points={{6,20},{6,50},{80,50},{80,100}},
          color={95,95,95},
          thickness=0.5));
      connect(jointUSP.axis, axis) 
        annotation (Line(points={{10,16},{86,16},{86,80},{100,80}}, color={0,0,
              0}));
      connect(jointUSP.bearing, bearing) 
        annotation (Line(points={{10,8},{94,8},{94,40},{100,40}}, color={0,0,0}));
      annotation (
        Documentation(info="<html>
<p>
This component consists of <b>2 revolute</b> joints with parallel
axes of rotation that and a <b>prismatic</b> joint with a translational
axis that is orthogonal to the revolute joint axes, see the default
animation in the following figure (the axes vectors are not part of the
default animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Joints/JointRRP.png\" ALT=\"model Joints.Assemblies.JointRRP\">
</p>
<p>
This joint aggregation introduces neither constraints nor state variables and
should therefore be used in kinematic loops whenever possible to
avoid non-linear systems of equations. It is only meaningful to
use this component in <b>planar loops</b>. Basically, the position
and orientation of the 3 joints as well as of frame_ia, frame_ib, and
frame_im are calculated by solving analytically a non-linear equation,
given the position and orientation at frame_a and at frame_b.
</p>
<p>
Connector <b>frame_a</b> is the \"left\" side of the first revolute joint
whereas <b>frame_ia</b> is the \"right side of this revolute joint, fixed in rod 1.
Connector <b>frame_b</b> is the \"right\" side of the prismatic joint
whereas <b>frame_ib</b> is the \"left\" side of this prismatic joint, fixed in rod 2.
Finally, connector <b>frame_im</b> is the connector at the \"right\" side
of the revolute joint in the middle, fixed in rod 2. The frames
frame_b, frame_ib, frame_im are always parallel to each other.
</p>
<p>
The easiest way to define the parameters of this joint is by moving the
MultiBody system in a <b>reference configuration</b> where <b>all frames</b>
of all components are <b>parallel</b> to each other (alternatively,
at least frame_a, frame_ia, frame_im, frame_ib, frame_b of the JointRRP joint
should be parallel to each other when defining an instance of this
component).
</p>
<p>
Basically, the JointRRP model consists internally of a universal -
spherical - prismatic joint aggregation (= JointUSP). In a planar
loop this will behave as if 2 revolute joints with parallel axes
and 1 prismatic joint are connected by rigid rods.
</p>
</html> "),
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics={
            Rectangle(
              extent={{-90,90},{90,-90}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-139,-53},{141,-78}},
              lineColor={0,0,255},
              textString="%name"),
            Text(
              extent={{26,124},{68,93}},
              lineColor={128,128,128},
              textString="ib"),
            Text(
              extent={{-134,128},{-94,94}},
              lineColor={128,128,128},
              textString="ia"),
            Ellipse(
              extent={{-100,25},{-50,-25}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-85,10},{-65,-10}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-26,80},{24,30}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-10,66},{10,46}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{-71,9},{-24,45},{-19,39},{-66,3},{-71,9}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{54,5},{5,47},{8,53},{58,11},{54,5}},
              lineColor={0,0,0},
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-128,-29},{139,-47}},
              lineColor={0,0,0},
              textString="n_a=%n_a"),
            Line(
              points={{0,57},{0,86},{0,86},{0,100}},
              color={95,95,95},
              thickness=0.5),
            Text(
              extent={{-55,126},{-15,92}},
              lineColor={128,128,128},
              textString="im"),
            Line(
              points={{-80,100},{-80,8}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{80,80},{101,80}},
              color={95,95,95},
              thickness=0.5),
            Line(
              points={{100,40},{93,40},{93,3}},
              color={95,95,95},
              thickness=0.5),
            Rectangle(
              extent={{80,15},{100,21}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{53,5},{80,11}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{53,5},{80,-15}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{80,15},{100,-21}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Line(
              points={{80,100},{80,80},{57,11}},
              color={95,95,95},
              thickness=0.5)}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1},
            initialScale=0.2), graphics));
    end JointRRP;
    annotation ( Documentation(info="<HTML>
<p>
The joints in this package are mainly designed to be used
in <b>kinematic loop</b> structures. Every component consists of
<b>3 elementary joints</b>. These joints are combined in such a
way that the kinematics of the 3 joints between frame_a and
frame_b are computed from the movement of frame_a and frame_b,
i.e., there are <b>no constraints</b> between frame_a and frame_b.
This requires to solve a <b>non-linear system of equations</b> which
is performed <b>analytically</b> (i.e., when a mathematical
solution exists, it is computed efficiently and reliably).
A detailed description how to use these joints is provided in
<a href=\"Modelica://Modelica.Mechanics.MultiBody.UsersGuide.Tutorial.LoopStructures.AnalyticLoopHandling\">MultiBody.UsersGuide.Tutorial.LoopStructures.AnalyticLoopHandling</a>.
</p>
<p>
The assembly joints in this package are named <b>JointXYZ</b> where
<b>XYZ</b> are the first letters of the elementary joints used in the
component, in particular:
</p>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>P</b></td><td valign=\"top\">Prismatic joint</td></tr>
  <tr><td valign=\"top\"><b>R</b></td><td valign=\"top\">Revolute joint</td></tr>
  <tr><td valign=\"top\"><b>S</b></td><td valign=\"top\">Spherical joint</td></tr>
  <tr><td valign=\"top\"><b>U</b></td><td valign=\"top\">Universal joint</td></tr>
</table>
<p>
For example, JointUSR is an assembly joint consisting
of a universal, a spherical and a revolute joint.
</p>
<p> This package contains the following models:
</p>
<h4>Content</h4>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><th><b><i>Model</i></b></th><th><b><i>Description</i></b></th></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUPS\">JointUPS</a></td>
      <td valign=\"top\"> Universal - prismatic - spherical joint aggregation<br>
     <img src=\"../Images/MultiBody/Joints/JointUPS.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUSR\">JointUSR</a></td>
      <td valign=\"top\"> Universal - spherical - revolute joint aggregation<br>
     <img src=\"../Images/MultiBody/Joints/JointUSR.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUSP\">JointUSP</a></td>
      <td valign=\"top\"> Universal - spherical - prismatic joint aggregation<br>
     <img src=\"../Images/MultiBody/Joints/JointUSP.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies.JointSSR\">JointSSR</a></td>
      <td valign=\"top\"> Spherical - spherical - revolute joint aggregation
           with an optional mass point at the rod connecting
           the two spherical joints<br>
     <img src=\"../Images/MultiBody/Joints/JointSSR.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies.JointSSP\">JointSSP</a></td>
      <td valign=\"top\"> Spherical - spherical - prismatic joint aggregation
           with an optional mass point at the rod connecting
           the two spherical joints<br>
     <img src=\"../Images/MultiBody/Joints/JointSSP.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies.JointRRR\">JointRRR</a></td>
      <td valign=\"top\"> Revolute - revolute - revolute joint aggregation for planar loops<br>
     <img src=\"../Images/MultiBody/Joints/JointRRR.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies.JointRRP\">JointRRP</a></td>
      <td valign=\"top\"> Revolute - revolute - prismatic joint aggregation for planar loops<br>
     <img src=\"../Images/MultiBody/Joints/JointRRP.png\">
      </td>
  </tr>
</table>
<p>
Note, no component of this package has potential states, since the
components are designed in such a way that the generalized coordinates
of the used elementary joints are computed from the frame_a and frame_b
coordinates. Still, it is possible to use the components in a
tree structure. In this case states are selected from bodies that are
connected to the frame_a or frame_b side of the component.
In most cases this gives a less efficient solution, as if elementary
joints of package Modelica.Mechanics.MultiBody.Joints would be used directly.
</p>
<p>
The analytic handling of kinematic loops by using joint aggregations
with 6 degrees of freedom as provided in this package, is a <b>new</b>
methodology. It is based on a more general method for solving
non-linear equations of kinematic loops developed by Woernle and
Hiller. An automatic application of this more general method
is difficult, and a manual application is only suited for
specialists in this field. The method introduced here is a
compromize: It can be quite easily applied by an end user, but
for a smaller class of kinematic loops. The method of the \"characteristic
pair of joints\" from Woernle and Hiller is described in:
</p>
<dl>
<dt>Woernle C.:</dt>
<dd><b>Ein systematisches Verfahren zur Aufstellung der geometrischen
    Schliessbedingungen in kinematischen Schleifen mit Anwendung
    bei der R&uuml;ckw&auml;rtstransformation f&uuml;r
    Industrieroboter.</b><br>
    Fortschritt-Berichte VDI, Reihe 18, Nr. 59, Duesseldorf: VDI-Verlag 1988,
    ISBN 3-18-145918-6.<br>&nbsp;</dd>
<dt>Hiller M., and Woernle C.:</dt
<dd><b>A Systematic Approach for Solving the Inverse Kinematic
    Problem of Robot Manipulators</b>.<br>
    Proceedings 7th World Congress Th. Mach. Mech., Sevilla 1987. </dd>
</dl>
</HTML>"));
  end Assemblies;

  package Internal
    "Components used for analytic solution of kinematic loops (use only if you know what you are doing)"

    extends Modelica.Icons.Library;

    model RevoluteWithLengthConstraint
      "Revolute joint where the rotation angle is computed from a length constraint (1 degree-of-freedom, no potential state)"

      import SI = Modelica.SIunits;
      import Cv = Modelica.SIunits.Conversions;
      extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
      Modelica.Mechanics.Rotational.Interfaces.Flange_a axis
        "1-dim. rotational flange that drives the joint" 
        annotation (Placement(transformation(extent={{10,90},{-10,110}},
              rotation=0)));
      Modelica.Mechanics.Rotational.Interfaces.Flange_b bearing
        "1-dim. rotational flange of the drive bearing" 
        annotation (Placement(transformation(extent={{-50,90},{-70,110}},
              rotation=0)));

      Modelica.Blocks.Interfaces.RealInput position_a[3](each final quantity="Position", each
          final unit =                                                                                   "m")
        "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint"
        annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
              rotation=0)));
      Modelica.Blocks.Interfaces.RealInput position_b[3](each final quantity="Position",
        each final unit="m")
        "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint"
        annotation (Placement(transformation(extent={{140,-80},{100,-40}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter SI.Position lengthConstraint(start=1)
        "Fixed length of length constraint";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n={0,0,1}
        "Axis of rotation resolved in frame_a (= same as in frame_b)" 
        annotation (Evaluate=true);
      parameter Cv.NonSIunits.Angle_deg phi_offset=0
        "Relative angle offset (angle = phi + from_deg(phi_offset))";
      parameter Cv.NonSIunits.Angle_deg phi_guess=0
        "Select the configuration such that at initial time |phi - from_deg(phi_guess)|is minimal";
      parameter SI.Distance cylinderLength=world.defaultJointLength
        "Length of cylinder representing the joint axis" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance cylinderDiameter=world.defaultJointWidth
        "Diameter of cylinder representing the joint axis" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color cylinderColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of cylinder representing the joint axis" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

      final parameter Boolean positiveBranch(fixed=false)
        "Based on phi_guess, selection of one of the two solutions of the non-linear constraint equation";
      final parameter Real e[3](each final unit="1")=Modelica.Math.Vectors.normalize(              n)
        "Unit vector in direction of rotation axis, resolved in frame_a";

      SI.Angle phi "Rotation angle of revolute joint";
      Frames.Orientation R_rel
        "Relative orientation object from frame_a to frame_b";
      SI.Angle angle
        "= phi + from_deg(phi_offset) (relative rotation angle between frame_a and frame_b)";
      SI.Torque tau "= axis.tau (driving torque in the axis)";

    protected
      SI.Position r_a[3]=position_a
        "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint";
      SI.Position r_b[3]=position_b
        "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint";
      Real e_r_a "Projection of r_a on e";
      Real e_r_b "Projection of r_b on e";
      Real A "Coefficient A of equation: A*cos(phi) + B*sin(phi) + C = 0";
      Real B "Coefficient B of equation: A*cos(phi) + B*sin(phi) + C = 0";
      Real C "Coefficient C of equation: A*cos(phi) + B*sin(phi) + C = 0";
      Real k1 "Constant of quadratic equation";
      Real k2 "Constant of quadratic equation";
      Real k1a(start=1);
      Real k1b;
      Real kcos_angle "= k1*cos(angle)";
      Real ksin_angle "= k1*sin(angle)";

      Visualizers.Advanced.Shape cylinder(
        shapeType="cylinder",
        color=cylinderColor,
        specularCoefficient=specularCoefficient,
        length=cylinderLength,
        width=cylinderDiameter,
        height=cylinderDiameter,
        lengthDirection=e,
        widthDirection={0,1,0},
        r_shape=-e*(cylinderLength/2),
        r=frame_a.r_0,
        R=frame_a.R) if world.enableAnimation and animation;

      function selectBranch
        "Determine branch which is closest to initial angle=0"

        import Modelica.Math.*;
        input SI.Length L "Length of length constraint";
        input Real e[3](each final unit="1")
          "Unit vector along axis of rotation, resolved in frame_a (= same in frame_b)";
        input SI.Angle angle_guess
          "Select the configuration such that at initial time |angle-angle_guess|is minimal (angle=0: frame_a and frame_b coincide)";
        input SI.Position r_a[3]
          "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint";
        input SI.Position r_b[3]
          "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint";
        output Boolean positiveBranch "Branch of the initial solution";
      protected
        Real e_r_a "Projection of r_a on e";
        Real e_r_b "Projection of r_b on e";
        Real A "Coefficient A of equation: A*cos(phi) + B*sin(phi) + C = 0";
        Real B "Coefficient B of equation: A*cos(phi) + B*sin(phi) + C = 0";
        Real C "Coefficient C of equation: A*cos(phi) + B*sin(phi) + C = 0";
        Real k1 "Constant of quadratic equation";
        Real k2 "Constant of quadratic equation";
        Real k1a;
        Real k1b;
        Real kcos1 "k1*cos(angle1)";
        Real ksin1 "k1*sin(angle1)";
        Real kcos2 "k2*cos(angle2)";
        Real ksin2 "k2*sin(angle2)";
        SI.Angle angle1 "solution 1 of nonlinear equation";
        SI.Angle angle2 "solution 2 of nonlinear equation";
      algorithm
        /* The position vector r_rel from frame_a to frame_b of the length constraint
       element, resolved in frame_b of the revolute joint is given by
       (T_rel is the planar transformation matrix from frame_a to frame_b of
        the revolute joint):
          r_rel = r_b - T_rel*r_a
       The length constraint can therefore be formulated as:
          r_rel*r_rel = L*L
       with
          (r_b - T_rel*r_a)*(r_b - T_rel*r_a)
             = r_b*r_b - 2*r_b*T_rel*r_a + r_a*transpose(T_rel)*T_rel*r_a
             = r_b*r_b + r_a*r_a - 2*r_b*T_rel*r_a
       follows
          (1) 0 = r_a*r_a + r_b*r_b - 2*r_b*T_rel*r_a - L*L
       The vectors r_a, r_b and parameter L are NOT a function of
       the angle of the revolute joint. Since T_rel = T_rel(angle) is a function
       of the unknown angle of the revolute joint, this is a non-linear
       equation in this angle.
          T_rel = [e]*tranpose([e]) + (identity(3) - [e]*transpose([e]))*cos(angle)
                  - skew(e)*sin(angle);
       with
          r_b*T_rel*r_a
             = r_b*(e*(e*r_a) + (r_a - e*(e*r_a))*cos(angle) - cross(e,r_a)*sin(angle)
             = (e*r_b)*(e*r_a) + (r_b*r_a - (e*r_b)*(e*r_a))*cos(angle) - r_b*cross(e,r_a)*sin(angle)
       follows for the constraint equation (1)
          (2) 0 = r_a*r_a + r_b*r_b - L*L
                  - 2*(e*r_b)*(e*r_a)
                  - 2*(r_b*r_a - (e*r_b)*(e*r_a))*cos(angle)
                  + 2*r_b*cross(e,r_a)*sin(angle)
       or
          (3) A*cos(angle) + B*sin(angle) + C = 0
       with
              A = -2*(r_b*r_a - (e*r_b)*(e*r_a))
              B = 2*r_b*cross(e,r_a)
              C = r_a*r_a + r_b*r_b - L*L - 2*(e*r_b)*(e*r_a)
       Equation (3) is solved by computing sin(angle) and cos(angle)
       independently from each other. This allows to compute
       angle in the range: -180 deg <= angle <= 180 deg
    */
        e_r_a := e*r_a;
        e_r_b := e*r_b;
        A := -2*(r_b*r_a - e_r_b*e_r_a);
        B := 2*r_b*cross(e, r_a);
        C := r_a*r_a + r_b*r_b - L*L - 2*e_r_b*e_r_a;
        k1 := A*A + B*B;
        k1a :=k1 - C*C;
        assert(k1a > 1.e-10, "
Singular position of loop (either no or two analytic solutions;
the mechanism has lost one-degree-of freedom in this position).
Try first to use another Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXXX component.
In most cases it is best that the joints outside of the JointXXX
component are revolute and NOT prismatic joints. If this also
lead to singular positions, it could be that this kinematic loop
cannot be solved analytically. In this case you have to build
up the loop with basic joints (NO aggregation JointXXX components)
and rely on dynamic state selection, i.e., during simulation
the states will be dynamically selected in such a way that in no
position a degree of freedom is lost.
");
        k1b := max(k1a, 1.0e-12);
        k2 := sqrt(k1b);

        kcos1 := -A*C + B*k2;
        ksin1 := -B*C - A*k2;
        angle1 := atan2(ksin1, kcos1);

        kcos2 := -A*C - B*k2;
        ksin2 := -B*C + A*k2;
        angle2 := atan2(ksin2, kcos2);

        if abs(angle1 - angle_guess) <= abs(angle2 - angle_guess) then
          positiveBranch := true;
        else
          positiveBranch := false;
        end if;
      end selectBranch;
    initial equation
      positiveBranch = selectBranch(lengthConstraint, e, Cv.from_deg(phi_offset
         + phi_guess), r_a, r_b);
    equation
      Connections.branch(frame_a.R, frame_b.R);
      axis.tau = tau;
      axis.phi = phi;
      bearing.phi = 0;

      angle = Cv.from_deg(phi_offset) + phi;

      // transform kinematic quantities from frame_a to frame_b
      frame_b.r_0 = frame_a.r_0;

      R_rel = Frames.planarRotation(e, angle, der(angle));
      frame_b.R = Frames.absoluteRotation(frame_a.R, R_rel);

      // Force and torque balance
      zeros(3) = frame_a.f + Frames.resolve1(R_rel, frame_b.f);
      zeros(3) = frame_a.t + Frames.resolve1(R_rel, frame_b.t);

      // Compute rotation angle (details, see function "selectBranch")
      e_r_a = e*r_a;
      e_r_b = e*r_b;
      A = -2*(r_b*r_a - e_r_b*e_r_a);
      B = 2*r_b*cross(e, r_a);
      C = r_a*r_a + r_b*r_b - lengthConstraint*lengthConstraint - 2*e_r_b*e_r_a;
      k1 = A*A + B*B;
      k1a = k1 - C*C;

      assert(k1a > 1.e-10, "
Singular position of loop (either no or two analytic solutions;
the mechanism has lost one-degree-of freedom in this position).
Try first to use another Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXXX component.
In most cases it is best that the joints outside of the JointXXX
component are revolute and NOT prismatic joints. If this also
lead to singular positions, it could be that this kinematic loop
cannot be solved analytically. In this case you have to build
up the loop with basic joints (NO aggregation JointXXX components)
and rely on dynamic state selection, i.e., during simulation
the states will be dynamically selected in such a way that in no
position a degree of freedom is lost.
");

      k1b = Frames.Internal.maxWithoutEvent(k1a, 1.0e-12);
      k2 = sqrt(k1b);
      kcos_angle = -A*C + (if positiveBranch then B else -B)*k2;
      ksin_angle = -B*C + (if positiveBranch then -A else A)*k2;

      angle = Modelica.Math.atan2(ksin_angle, kcos_angle);
      annotation (
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={
            Rectangle(
              extent={{-30,10},{10,-10}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-100,-60},{-30,60}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{30,-60},{100,60}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Text(
              extent={{-139,-168},{137,-111}},
              textString="%name",
              lineColor={0,0,255}),
            Rectangle(extent={{-100,60},{-30,-60}}, lineColor={0,0,0}),
            Rectangle(extent={{30,60},{100,-60}}, lineColor={0,0,0}),
            Text(
              extent={{-142,-108},{147,-69}},
              lineColor={0,0,0},
              textString="n=%n"),
            Line(points={{-60,60},{-60,90}}, color={0,0,0}),
            Line(points={{-20,70},{-60,70}}, color={0,0,0}),
            Line(points={{-20,80},{-20,60}}, color={0,0,0}),
            Line(points={{20,80},{20,60}}, color={0,0,0}),
            Line(points={{20,70},{41,70}}, color={0,0,0}),
            Polygon(
              points={{-9,30},{10,30},{30,50},{-29,50},{-9,30}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{10,30},{30,50},{30,-51},{10,-31},{10,30}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-10,90},{10,50}},
              lineColor={0,0,0},
              fillPattern=FillPattern.VerticalCylinder,
              fillColor={192,192,192})}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={
            Rectangle(
              extent={{-100,-60},{-30,60}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Rectangle(
              extent={{-30,10},{10,-10}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{30,-60},{100,60}},
              lineColor={0,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={192,192,192}),
            Line(points={{-60,60},{-60,96}}, color={0,0,0}),
            Line(points={{-20,70},{-60,70}}, color={0,0,0}),
            Line(points={{-20,80},{-20,60}}, color={0,0,0}),
            Line(points={{20,80},{20,60}}, color={0,0,0}),
            Line(points={{20,70},{41,70}}, color={0,0,0}),
            Polygon(
              points={{-9,30},{10,30},{30,50},{-29,50},{-9,30}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Polygon(
              points={{10,30},{30,50},{30,-51},{10,-31},{10,30}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-10,50},{10,100}},
              lineColor={0,0,0},
              fillPattern=FillPattern.VerticalCylinder,
              fillColor={192,192,192})}),
        Documentation(info="<html>
<p>
Joint where frame_b rotates around axis n which is fixed in frame_a.
The two frames coincide when \"phi + phi_offset = 0\", where
\"phi_offset\" is a parameter with a zero default
and \"phi\" is the rotation angle.
</p>
<p>
This variant of the revolute joint is designed to work together
with a length constraint in a kinematic loop. This means that the
angle of the revolute joint, phi, is computed such that the
length constraint is fulfilled.
</p>
<p>
<b>Usually, this joint should not be used by a user of the MultiBody
library. It is only provided to built-up the Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXYZ
joints.</b>
</p>

<p>
In releases before version 3.0 of the Modelica Standard Library, it was possible
to activate the torque projection equation (= cut-torque projected to the rotation
axis must be identical to the drive torque of flange axis) via parameter
<b>axisTorqueBalance</b>. This is no longer possible, since otherwise this
model would not be \"balanced\" (= same number of unknowns as equations).
Instead, when using this model in version 3.0 and later versions,
the force in the length constraint component (Joints.SphericalSpherical or
Joints.UniversalSpherical) must be calculated such that the driving torque
in direction of the rotation
axis is (RC shall be the name of the instance of RevoluteWithLenghtConstraint):
</p>
<pre>
    0 = RC.axis.tau + RC.e*RC.frame_b.t;
</pre>
<p>
If this equation is used, usually the force in the length constraint
and the second derivative of the revolute angle will be part of a linear
algebraic system of equations. In some cases it is possible to solve
this system of equations locally, i.e., provide the rod force directly
as function of the revolute constraint torque. In any case, this projection
equation or an equivalent one has to be provided via variable \"constraintResidue\" in the \"Advanced\"
menu of \"Joints.SphericalSpherical\" or \"Joints.UniversalSpherical\".
</p>

</html>
"));
    end RevoluteWithLengthConstraint;

    model PrismaticWithLengthConstraint
      "Prismatic joint where the translational distance is computed from a length constraint (1 degree-of-freedom, no potential state)"

      import SI = Modelica.SIunits;
      import Cv = Modelica.SIunits.Conversions;
      extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
      Modelica.Mechanics.Translational.Interfaces.Flange_a axis
        "1-dim. translational flange that drives the joint" 
        annotation (Placement(transformation(extent={{70,80},{90,60}}, rotation=
               0)));
      Modelica.Mechanics.Translational.Interfaces.Flange_b bearing
        "1-dim. translational flange of the drive bearing" 
        annotation (Placement(transformation(extent={{-30,80},{-50,60}},
              rotation=0)));
      Modelica.Blocks.Interfaces.RealInput position_a[3]
        "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint"
        annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
              rotation=0)));
      Modelica.Blocks.Interfaces.RealInput position_b[3]
        "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint"
        annotation (Placement(transformation(extent={{140,-80},{100,-40}},
              rotation=0)));

      parameter Boolean animation=true "= true, if animation shall be enabled";
      parameter SI.Position length(start=1) "Fixed length of length constraint";
      parameter Modelica.Mechanics.MultiBody.Types.Axis n={1,0,0}
        "Axis of translation resolved in frame_a (= same as in frame_b)" 
        annotation (Evaluate=true);
      parameter SI.Position s_offset=0
        "Relative distance offset (distance between frame_a and frame_b = s(t) + s_offset)";
      parameter SI.Position s_guess=0
        "Select the configuration such that at initial time |s(t0)-s_guess|is minimal";
      parameter Types.Axis boxWidthDirection={0,1,0}
        "Vector in width direction of box, resolved in frame_a" 
        annotation (Evaluate=true, Dialog(tab="Animation", group=
              "if animation = true", enable=animation));
      parameter SI.Distance boxWidth=world.defaultJointWidth
        "Width of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      parameter SI.Distance boxHeight=boxWidth "Height of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.Color boxColor=Modelica.Mechanics.MultiBody.Types.Defaults.JointColor
        "Color of prismatic joint box" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
      input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
        "Reflection of ambient light (= 0: light is completely absorbed)" 
        annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

      final parameter Boolean positiveBranch(fixed=false)
        "Selection of one of the two solutions of the non-linear constraint equation";
      final parameter Real e[3](each final unit="1")=Modelica.Math.Vectors.normalize(              n)
        "Unit vector in direction of translation axis, resolved in frame_a";
      SI.Position s
        "Relative distance between frame_a and frame_b along axis n = s + s_offset)";
      SI.Position distance
        "Relative distance between frame_a and frame_b along axis n";
      SI.Position r_rel_a[3]
        "Position vector from frame_a to frame_b resolved in frame_a";
      SI.Force f "= axis.f (driving force in the axis)";

    protected
      SI.Position r_a[3]=position_a
        "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint";
      SI.Position r_b[3]=position_b
        "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint";
      Modelica.SIunits.Position rbra[3] "= rb - ra";
      Real B "Coefficient B of equation: s*s + B*s + C = 0";
      Real C "Coefficient C of equation: s*s + B*s + C = 0";
      Real k1 "Constant of quadratic equation solution";
      Real k2 "Constant of quadratic equation solution";
      Real k1a(start=1);
      Real k1b;

      Visualizers.Advanced.Shape box(
        shapeType="box",
        color=boxColor,
        specularCoefficient=specularCoefficient,
        length=if noEvent(abs(s + s_offset) > 1.e-6) then s + s_offset else 1.e-6,
        width=boxWidth,
        height=boxHeight,
        lengthDirection=e,
        widthDirection=boxWidthDirection,
        r=frame_a.r_0,
        R=frame_a.R) if world.enableAnimation and animation;

      function selectBranch
        "Determine branch which is closest to initial angle=0"
        import Modelica.Math.*;
        input SI.Length L "Length of length constraint";
        input Real e[3](each final unit="1")
          "Unit vector along axis of translation, resolved in frame_a (= same in frame_b)";
        input SI.Position d_guess
          "Select the configuration such that at initial time |d-d_guess|is minimal (d: distance between origin of frame_a and origin of frame_b)";
        input SI.Position r_a[3]
          "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of prismatic joint";
        input SI.Position r_b[3]
          "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of prismatic joint";
        output Boolean positiveBranch "Branch of the initial solution";
      protected
        Modelica.SIunits.Position rbra[3] "= rb - ra";
        Real B "Coefficient B of equation: d*d + B*d + C = 0";
        Real C "Coefficient C of equation: d*d + B*d + C = 0";
        Real k1 "Constant of quadratic equation solution";
        Real k2 "Constant of quadratic equation solution";
        Real k1a;
        Real k1b;
        Real d1 "solution 1 of quadratic equation";
        Real d2 "solution 2 of quadratic equation";
      algorithm
        /* The position vector r_rel from frame_a to frame_b of the length constraint
       element, resolved in frame_b of the prismatic joint (frame_a and frame_b
       of the prismatic joint are parallel to each other) is given by:
          r_rel = d*e + r_b - r_a
       The length constraint can therefore be formulated as:
          r_rel*r_rel = L*L
       with
          (d*e + r_b - r_a)*(d*e + r_b - r_a)
                   = d*d + 2*d*e*(r_b - r_a) + (r_b - r_a)*(r_b - r_a)
       follows
          (1)  0 = d*d + d*2*e*(r_b - r_a) + (r_b - r_a)*(r_b - r_a) - L*L
       The vectors r_a, r_b and parameter L are NOT a function of
       the distance d of the prismatic joint. Therefore, (1) is a quadratic
       equation in the single unknown "d":
          (2) d*d + B*d + C = 0
              with   B = 2*e*(r_b - r_a)
                     C = (r_b - r_a)*(r_b - r_a) - L*L
       The solution is
          (3) d = - B/2 +/- sqrt(B*B/4 - C)
    */
        rbra := r_b - r_a;
        B := 2*(e*rbra);
        C := rbra*rbra - L*L;
        k1 := B/2;
        k1a :=k1*k1 - C;
      assert(noEvent(k1a > 1.e-10), "
Singular position of loop (either no or two analytic solutions;
the mechanism has lost one-degree-of freedom in this position).
Try first to use another Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXXX component.
If this also lead to singular positions, it could be that this
kinematic loop cannot be solved analytically with a fixed state
selection. In this case you have to build up the loop with
basic joints (NO aggregation JointXXX components) and rely on
dynamic state selection, i.e., during simulation the states will
be dynamically selected in such a way that in no position a
degree of freedom is lost.
");
        k1b :=max(k1a, 1.0e-12);
        k2 :=sqrt(k1b);
        d1 := -k1 + k2;
        d2 := -k1 - k2;
        if abs(d1 - d_guess) <= abs(d2 - d_guess) then
          positiveBranch := true;
        else
          positiveBranch := false;
        end if;
      end selectBranch;
    initial equation
      positiveBranch = selectBranch(length, e, s_offset + s_guess, r_a, r_b);
    equation
      Connections.branch(frame_a.R, frame_b.R);

      axis.f = f;
      axis.s = s;
      bearing.s = 0;
      distance = s_offset + s;

      // relationships of frame_a and frame_b quantities
      r_rel_a = e*distance;
      frame_b.r_0 = frame_a.r_0 + Frames.resolve1(frame_a.R, r_rel_a);
      frame_b.R = frame_a.R;
      zeros(3) = frame_a.f + frame_b.f;
      zeros(3) = frame_a.t + frame_b.t + cross(r_rel_a, frame_b.f);

      // Compute translational distance (details, see function "selectBranch")
      rbra = r_b - r_a;
      B = 2*(e*rbra);
      C = rbra*rbra - length*length;
      k1 = B/2;
      k1a = k1*k1 - C;
      assert(noEvent(k1a > 1.e-10), "
Singular position of loop (either no or two analytic solutions;
the mechanism has lost one-degree-of freedom in this position).
Try first to use another Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXXX component.
If this also lead to singular positions, it could be that this
kinematic loop cannot be solved analytically with a fixed state
selection. In this case you have to build up the loop with
basic joints (NO aggregation JointXXX components) and rely on
dynamic state selection, i.e., during simulation the states will
be dynamically selected in such a way that in no position a
degree of freedom is lost.
");
      k1b = Frames.Internal.maxWithoutEvent(k1a, 1.0e-12);
      k2 = sqrt(k1b);
      distance = -k1 + (if positiveBranch then k2 else -k2);
      annotation (
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={
            Rectangle(
              extent={{-30,-40},{100,30}},
              pattern=LinePattern.None,
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(extent={{-30,40},{100,-40}}, lineColor={0,0,0}),
            Rectangle(
              extent={{-100,-60},{-30,50}},
              pattern=LinePattern.None,
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-100,50},{-30,60}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-30,30},{100,40}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Text(
              extent={{-136,-170},{140,-113}},
              textString="%name",
              lineColor={0,0,255}),
            Rectangle(extent={{-100,60},{-30,-60}}, lineColor={0,0,0}),
            Line(points={{100,-40},{100,-60}}, color={0,0,255}),
            Rectangle(
              extent={{100,40},{90,80}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-136,-116},{153,-77}},
              lineColor={0,0,0},
              textString="n=%n")}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={
            Line(points={{-30,-50},{-30,50}}, color={0,0,0}),
            Line(points={{0,-67},{90,-67}}, color={128,128,128}),
            Text(
              extent={{31,-68},{68,-81}},
              lineColor={128,128,128},
              textString="s"),
            Line(points={{-100,-67},{0,-67}}, color={128,128,128}),
            Polygon(
              points={{-39,-64},{-29,-67},{-39,-70},{-39,-64}},
              lineColor={128,128,128},
              fillColor={128,128,128},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-77,-70},{-43,-85}},
              lineColor={128,128,128},
              textString="s_offset"),
            Line(points={{-100,-71},{-100,-51}}, color={128,128,128}),
            Line(points={{-30,-73},{-30,-33}}, color={128,128,128}),
            Line(points={{100,-70},{100,-30}}, color={128,128,128}),
            Polygon(
              points={{90,-64},{100,-67},{90,-70},{90,-64}},
              lineColor={128,128,128},
              fillColor={128,128,128},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{-100,50},{-30,60}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-100,-60},{-30,50}},
              pattern=LinePattern.None,
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(extent={{-30,40},{100,-40}}, lineColor={0,0,0}),
            Rectangle(
              extent={{-30,-40},{100,30}},
              pattern=LinePattern.None,
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(
              extent={{-30,30},{100,40}},
              pattern=LinePattern.None,
              fillColor={0,0,0},
              fillPattern=FillPattern.Solid,
              lineColor={0,0,255}),
            Rectangle(extent={{-100,60},{-30,-60}}, lineColor={0,0,0}),
            Line(points={{100,-40},{100,-60}}, color={0,0,255}),
            Text(
              extent={{42,91},{57,76}},
              textString="f",
              lineColor={0,0,255}),
            Line(points={{40,75},{70,75}}, color={0,0,255}),
            Polygon(
              points={{-21,78},{-31,75},{-21,72},{-21,78}},
              lineColor={0,0,255},
              fillColor={0,0,255},
              fillPattern=FillPattern.Solid),
            Line(points={{-8,75},{-31,75}}, color={0,0,255}),
            Text(
              extent={{-21,90},{-6,75}},
              textString="f",
              lineColor={0,0,255}),
            Polygon(
              points={{60,78},{70,75},{60,72},{60,78}},
              lineColor={0,0,255},
              fillColor={0,0,255},
              fillPattern=FillPattern.Solid),
            Line(points={{-30,64},{70,64}}, color={128,128,128}),
            Polygon(
              points={{60,67},{70,64},{60,61},{60,67}},
              lineColor={128,128,128},
              fillColor={128,128,128},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{0,63},{37,50}},
              lineColor={128,128,128},
              textString="s"),
            Rectangle(
              extent={{100,40},{90,80}},
              lineColor={0,0,0},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid)}),
        Documentation(info="<HTML>
<p>
Joint where frame_b is translated along axis n which is fixed in frame_a.
The two frames coincide when \"s + s_offset = 0\", where
\"s_offset\" is a parameter with a zero default
and \"s\" is the relative distance.
</p>
<p>
This variant of the prismatic joint is designed to work together
with a length constraint in a kinematic loop. This means that the
relative distance \"s\" of the joint is computed such that the
length constraint is fulfilled.
</p>
<p>
<b>Usually, this joint should not be used by a user of the MultiBody
library. It is only provided to built-up the Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXYZ
joints.</b>
</p>

<p>
In releases before version 3.0 of the Modelica Standard Library, it was possible
to activate the force projection equation (= cut-force projected to the translation
axis must be identical to the driving force of flange axis) via parameter
<b>axisForceBalance</b>. This is no longer possible, since otherwise this
model would not be \"balanced\" (= same number of unknowns as equations).
Instead, when using this model in version 3.0 and later versions,
the force in the length constraint component (Joints.SphericalSpherical or
Joints.UniversalSpherical) must be calculated such that the driving force
in direction of the translation
axis is (RC shall be the name of the instance of PrismaticWithLenghtConstraint):
</p>
<pre>
    0 = RC.axis.f + RC.e*RC.frame_b.f;
</pre>
<p>
If this equation is used, usually the force in the length constraint
and the second derivative of the prismatic distance will be part of a linear
algebraic system of equations. In some cases it is possible to solve
this system of equations locally, i.e., provide the rod force directly
as function of the prismatic constraint force. In any case, this projection
equation or an equivalent one has to be provided via variable \"constraintResidue\" in the \"Advanced\"
menu of \"Joints.SphericalSpherical\" or \"Joints.UniversalSpherical\".
</p>

</HTML>
"));
    end PrismaticWithLengthConstraint;

     model RollingConstraintVerticalWheel
      "Rolling constraint for wheel that is always perpendicular to x-y plane"
        import SI = Modelica.SIunits;
        import Modelica.Mechanics.MultiBody.Frames;

        Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_a
        "Frame fixed in wheel center point. x-Axis: upwards, y-axis: along wheel axis"
          annotation (Placement(transformation(extent={{-16,4},{16,36}}),
              iconTransformation(extent={{-16,4},{16,36}})));

        parameter SI.Radius radius "Wheel radius";

        parameter Boolean lateralSlidingConstraint = true
        "= true, if lateral sliding constraint taken into account, = false if lateral force = 0 (needed to avoid overconstraining if two ideal rolling wheels are connect on one axis)"
                                                                                                            annotation(choices(__Dymola_checkBox=true),HideResult=true,Evaluate=true);

        // Contact force
        SI.Force f_wheel_0[3]
        "Contact force acting on wheel, resolved in world frame";
        SI.Force f_lat "Contact force acting on wheel in lateral direction";
        SI.Force f_long
        "Contact force acting on wheel in longitudinal direction";
    protected
         Real e_axis_0[3]
        "Unit vector along wheel axis, resolved in world frame";
         SI.Position rContact_0[3]
        "Distance vector from wheel center to contact point, resolved in world frame";

         // Coordinate system at contact point
         Real e_n_0[3]
        "Unit vector in normal direction of road at contact point, resolved in world frame";
         Real e_lat_0[3]
        "Unit vector in lateral direction of wheel at contact point, resolved in world frame";
         Real e_long_0[3]
        "Unit vector in longitudinal direction of wheel at contact point, resolved in world frame";

         // Slip velocities
         SI.Velocity v_0[3] "Velocity of wheel center, resolved in world frame";
         SI.AngularVelocity w_0[3]
        "Angular velocity of wheel, resolved in world frame";

         SI.Velocity vContact_0[3]
        "Velocity of wheel contact point, resolved in world frame";

         // Utility vectors
         Real aux[3];

     equation
         // Coordinate system at contact point (e_long_0, e_lat_0, e_n_0)
         e_n_0    = {0,0,1};
         e_axis_0 = Frames.resolve1(frame_a.R, {0,1,0});
         aux      = cross(e_n_0, e_axis_0);
         e_long_0 = aux / Modelica.Math.Vectors.length(aux);
         e_lat_0  = cross(e_long_0, e_n_0);

         // Slip velocities
         rContact_0 = {0,0,-radius};
         v_0 = der(frame_a.r_0);
         w_0 = Frames.angularVelocity1(frame_a.R);
         vContact_0 = v_0 + cross(w_0, rContact_0);

         // Two non-holonomic constraint equations on velocity level (ideal rolling, no slippage)
         0 = vContact_0*e_long_0;
         if lateralSlidingConstraint then
            0 = vContact_0*e_lat_0;
            f_wheel_0 = f_lat*e_lat_0 + f_long*e_long_0;
         else
            0 = f_lat;
            f_wheel_0 = f_long*e_long_0;
         end if;

         // Force and torque balance at the wheel center
         zeros(3) = frame_a.f + Frames.resolve2(frame_a.R, f_wheel_0);
         zeros(3) = frame_a.t + Frames.resolve2(frame_a.R, cross(rContact_0, f_wheel_0));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,-60},{100,-80}},
              lineColor={0,0,0},
              fillColor={175,175,175},
              fillPattern=FillPattern.Solid),
            Text(
              extent={{-148,-86},{152,-126}},
              lineColor={0,0,255},
              textString="%name"),
            Line(
              points={{0,-60},{0,4}},
              color={0,0,0},
              smooth=Smooth.None,
              pattern=LinePattern.Dot),
            Line(
              visible=lateralSlidingConstraint,
              points={{-98,-30},{-16,-30}},
              color={0,0,0},
              smooth=Smooth.None),
            Polygon(
              visible=lateralSlidingConstraint,
              points={{-40,-16},{-40,-42},{-6,-30},{-40,-16}},
              lineColor={0,0,0},
              smooth=Smooth.None,
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid)}),   Diagram(coordinateSystem(
                preserveAspectRatio=false, extent={{-100,-100},{100,100}}), graphics));
     end RollingConstraintVerticalWheel;

    annotation (Documentation(info="<HTML>
<p>
The models in this package should not be used by the user.
They are designed to build up other models in the MultiBody library
and some of them cannot be used in an arbitrary way and require
particular knowledge how to set the options in the parameter menu.
Don't use the models of this package.
</p>
</HTML>"));
  end Internal;

  annotation ( Documentation(info="<HTML>
<p>
This package contains <b>joint components</b>,
that is, idealized, massless elements that constrain
the motion between frames. In subpackage <b>Assemblies</b>
aggregation joint components are provided to handle
kinematic loops analytically (this means that non-linear systems
of equations occuring in these joint aggregations are analytically
solved, i.e., robustly and efficiently).
</p>
<h4>Content</h4>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><th><b><i>Model</i></b></th><th><b><i>Description</i></b></th></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Prismatic\">Prismatic</a>
      <td valign=\"top\">Prismatic joint and actuated prismatic joint
          (1 translational degree-of-freedom, 2 potential states)<br>
      <IMG SRC=\"../Images/MultiBody/Joints/Prismatic.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Revolute\">Revolute</a>
 </td>
      <td valign=\"top\">Revolute and actuated revolute joint
          (1 rotational degree-of-freedom, 2 potential states)<br>
      <IMG SRC=\"../Images/MultiBody/Joints/Revolute.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Cylindrical\">Cylindrical</a></td>
      <td valign=\"top\">Cylindrical joint (2 degrees-of-freedom, 4 potential states)<br>
      <IMG SRC=\"../Images/MultiBody/Joints/Cylindrical.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Universal\">Universal</a></td>
      <td valign=\"top\">Universal joint (2 degrees-of-freedom, 4 potential states)<br>
      <IMG SRC=\"../Images/MultiBody/Joints/Universal.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Planar\">Planar</a></td>
      <td valign=\"top\">Planar joint (3 degrees-of-freedom, 6 potential states)<br>
      <IMG SRC=\"../Images/MultiBody/Joints/Planar.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Spherical\">Spherical</a></td>
      <td valign=\"top\">Spherical joint (3 constraints and no potential states, or 3 degrees-of-freedom and 3 states)<br>
      <IMG SRC=\"../Images/MultiBody/Joints/Spherical.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.FreeMotion\">FreeMotion</a></td>
      <td valign=\"top\">Free motion joint (6 degrees-of-freedom, 12 potential states)<br>
      <IMG SRC=\"../Images/MultiBody/Joints/FreeMotion.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.SphericalSpherical\">SphericalSpherical</a></td>
      <td valign=\"top\">Spherical - spherical joint aggregation (1 constraint,
          no potential states) with an optional point mass in the middle<br>
      <IMG SRC=\"../Images/MultiBody/Joints/SphericalSpherical.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.UniversalSpherical\">UniversalSpherical</a></td>
      <td valign=\"top\">Universal - spherical joint aggregation (1 constraint, no potential states)<br>
      <IMG SRC=\"../Images/MultiBody/Joints/UniversalSpherical.png\">
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.GearConstraint\">GearConstraint</a></td>
      <td valign=\"top\">Ideal 3-dim. gearbox (arbitrary shaft directions)
      </td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Joints.Assemblies\">MultiBody.Joints.Assemblies</a></td>
      <td valign=\"top\"><b>Package</b> of joint aggregations for analytic loop handling.
      </td>
  </tr>
</table>
</HTML>"));
end Joints;

package Parts
  "Rigid components such as bodies with mass and inertia and massless rods"

  import SI = Modelica.SIunits;
  extends Modelica.Icons.Library;

  model Fixed "Frame fixed in the world frame at a given position"
    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;

    Interfaces.Frame_b frame_b "Coordinate system fixed in the world frame" 
      annotation (Placement(transformation(extent={{84,-16},{116,16}}, rotation=
             0)));

    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter SI.Position r[3]={0,0,0}
      "Position vector from world frame to frame_b, resolved in world frame";
    parameter Types.ShapeType shapeType="cylinder" " Type of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Position r_shape[3]={0,0,0}
      " Vector from world frame to shape origin, resolved in world frame" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Position lengthDirection[3]=r - r_shape
      " Vector in length direction of shape, resolved in world frame" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Position widthDirection[3]={0,1,0}
      " Vector in width direction of shape, resolved in world frame" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Length length=Modelica.Math.Vectors.length(
                                             r - r_shape) " Length of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance width=length/world.defaultWidthFraction
      " Width of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance height=width " Height of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.ShapeExtra extra=0.0
      " Additional parameter for cone, pipe etc. (see docu of Visualizers.Advanced.Shape)"
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.RodColor
      " Color of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

  protected
    outer Modelica.Mechanics.MultiBody.World world;
    Visualizers.Advanced.Shape shape(
      shapeType=shapeType,
      color=color,
      specularCoefficient=specularCoefficient,
      length=length,
      width=width,
      height=height,
      lengthDirection=lengthDirection,
      widthDirection=widthDirection,
      extra=extra,
      r_shape=r_shape,
      r=zeros(3),
      R=Frames.nullRotation()) if world.enableAnimation and animation;
  equation
    Connections.root(frame_b.R);
    frame_b.r_0 = r;
    frame_b.R = Frames.nullRotation();
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-90,90},{90,-90}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{150,170},{-142,106}},
            textString="%name",
            lineColor={0,0,255}),
          Line(points={{0,100},{0,-100}}, color={0,0,0}),
          Line(points={{0,-80},{-100,-20}}, color={0,0,0}),
          Line(points={{0,-40},{-100,20}}, color={0,0,0}),
          Line(points={{0,0},{-100,60}}, color={0,0,0}),
          Line(points={{0,40},{-100,100}}, color={0,0,0}),
          Line(points={{0,0},{100,0}}, color={0,0,0}),
          Text(
            extent={{-146,-104},{154,-148}},
            lineColor={0,0,0},
            textString="r=%r")}),
      Documentation(info="<html>
<p>
Element consisting of a frame (frame_b) that is fixed in the world
frame at a given position defined by parameter vector <b>r</b>
(vector from origin of world frame to frame_b, resolved in the
world frame).
</p>
<p>
By default, this component is visualized by a cylinder connecting the
world frame and frame_b of this components, as shown in the figure below.
Note, that the visualized world frame on the left side and
Fixed.frame_b on the right side are not part of the
component animation and that the animation may be switched off via parameter
animation = <b>false</b>.
</p>
<IMG SRC=\"../Images/MultiBody/Fixed.png\" ALT=\"Parts.Fixed\">
</HTML>
"),   Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{0,100},{0,-100}}, color={0,0,0}),
          Line(points={{0,-80},{-100,-20}}, color={0,0,0}),
          Line(points={{0,-40},{-100,20}}, color={0,0,0}),
          Line(points={{0,0},{-100,60}}, color={0,0,0}),
          Line(points={{0,40},{-100,100}}, color={0,0,0}),
          Line(points={{0,0},{100,0}}, color={0,0,0})}));
  end Fixed;

  model FixedTranslation "Fixed translation of frame_b with respect to frame_a"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;
    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));

    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter SI.Position r[3](start={0,0,0})
      "Vector from frame_a to frame_b resolved in frame_a";
    parameter Types.ShapeType shapeType="cylinder" " Type of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Position r_shape[3]={0,0,0}
      " Vector from frame_a to shape origin, resolved in frame_a" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.Axis lengthDirection=r - r_shape
      " Vector in length direction of shape, resolved in frame_a" 
      annotation (Evaluate=true, Dialog(tab="Animation", group=
            "if animation = true", enable=animation));
    parameter Types.Axis widthDirection={0,1,0}
      " Vector in width direction of shape, resolved in frame_a" 
      annotation (Evaluate=true, Dialog(tab="Animation", group=
            "if animation = true", enable=animation));
    parameter SI.Length length=Modelica.Math.Vectors.length(
                                             r - r_shape) " Length of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance width=length/world.defaultWidthFraction
      " Width of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance height=width " Height of shape." 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.ShapeExtra extra=0.0
      " Additional parameter depending on shapeType (see docu of Visualizers.Advanced.Shape)."
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.RodColor
      " Color of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));

  protected
    outer Modelica.Mechanics.MultiBody.World world;
    Visualizers.Advanced.Shape shape(
      shapeType=shapeType,
      color=color,
      specularCoefficient=specularCoefficient,
      r_shape=r_shape,
      lengthDirection=lengthDirection,
      widthDirection=widthDirection,
      length=length,
      width=width,
      height=height,
      extra=extra,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
  equation
    Connections.branch(frame_a.R, frame_b.R);
    assert(cardinality(frame_a) > 0 or cardinality(frame_b) > 0,
      "Neither connector frame_a nor frame_b of FixedTranslation object is connected");

    frame_b.r_0 = frame_a.r_0 + Frames.resolve1(frame_a.R, r);
    frame_b.R = frame_a.R;

    /* Force and torque balance */
    zeros(3) = frame_a.f + frame_b.f;
    zeros(3) = frame_a.t + frame_b.t + cross(r, frame_b.f);
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-99,5},{101,-5}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-131,101},{129,41}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{127,-72},{-133,-22}},
            lineColor={0,0,0},
            textString="%=r"),
          Text(
            extent={{-89,38},{-53,13}},
            lineColor={128,128,128},
            textString="a"),
          Text(
            extent={{57,39},{93,14}},
            lineColor={128,128,128},
            textString="b")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-100,5},{100,-5}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(
            points={{-95,20},{-58,20}},
            color={128,128,128},
            arrow={Arrow.None,Arrow.Filled}),
          Line(
            points={{-94,18},{-94,50}},
            color={128,128,128},
            arrow={Arrow.None,Arrow.Filled}),
          Text(
            extent={{-72,35},{-58,24}},
            lineColor={128,128,128},
            textString="x"),
          Text(
            extent={{-113,57},{-98,45}},
            lineColor={128,128,128},
            textString="y"),
          Line(points={{-100,-4},{-100,-69}}, color={128,128,128}),
          Line(points={{-100,-63},{90,-63}}, color={128,128,128}),
          Text(
            extent={{-22,-39},{16,-63}},
            lineColor={128,128,128},
            textString="r"),
          Polygon(
            points={{88,-59},{88,-68},{100,-63},{88,-59}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{100,-3},{100,-68}}, color={128,128,128}),
          Line(
            points={{69,20},{106,20}},
            color={128,128,128},
            arrow={Arrow.None,Arrow.Filled}),
          Line(
            points={{70,18},{70,50}},
            color={128,128,128},
            arrow={Arrow.None,Arrow.Filled}),
          Text(
            extent={{92,35},{106,24}},
            lineColor={128,128,128},
            textString="x"),
          Text(
            extent={{51,57},{66,45}},
            lineColor={128,128,128},
            textString="y")}),
      Documentation(info="<HTML>
<p>
Component for a <b>fixed translation</b> of frame_b with respect
to frame_a, i.e., the relationship between connectors frame_a and frame_b
remains constant and frame_a is always <b>parallel</b> to frame_b.
</p>
<p>
By default, this component is visualized by a cylinder connecting
frame_a and frame_b, as shown in the figure below. Note, that the
two visualized frames are not part of the component animation and that
the animation may be switched off via parameter animation = <b>false</b>.
</p>
<IMG SRC=\"../Images/MultiBody/FixedTranslation.png\" ALT=\"Parts.FixedTranslation\">
</HTML>"));
  end FixedTranslation;

  model FixedRotation
    "Fixed translation followed by a fixed rotation of frame_b with respect to frame_a"

    import Modelica.Mechanics.MultiBody.Frames;
    import Modelica.Mechanics.MultiBody.Types;
    import SI = Modelica.SIunits;
    import Cv = Modelica.SIunits.Conversions;
    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));

    parameter Boolean animation=true "= true, if animation shall be enabled";
    parameter SI.Position r[3]={0,0,0}
      "Vector from frame_a to frame_b resolved in frame_a";
    parameter Modelica.Mechanics.MultiBody.Types.RotationTypes rotationType=
              Modelica.Mechanics.MultiBody.Types.RotationTypes.RotationAxis
      "Type of rotation description" 
      annotation (Evaluate=true);
    parameter Types.Axis n={1,0,0}
      " Axis of rotation in frame_a (= same as in frame_b)" 
      annotation (Evaluate=true, Dialog(group="if rotationType = RotationAxis",
                  enable=rotationType==Modelica.Mechanics.MultiBody.Types.RotationTypes.RotationAxis));
    parameter Cv.NonSIunits.Angle_deg angle=0
      " Angle to rotate frame_a around axis n into frame_b" 
      annotation (Dialog(group="if rotationType = RotationAxis",
                  enable=rotationType==Modelica.Mechanics.MultiBody.Types.RotationTypes.RotationAxis));

    parameter Types.Axis n_x={1,0,0}
      " Vector along x-axis of frame_b resolved in frame_a" 
      annotation (Evaluate=true, Dialog(group="if rotationType = TwoAxesVectors",
                  enable=rotationType==Types.RotationTypes.TwoAxesVectors));
    parameter Types.Axis n_y={0,1,0}
      " Vector along y-axis of frame_b resolved in frame_a" 
      annotation (Evaluate=true, Dialog(group="if rotationType = TwoAxesVectors",
                  enable=rotationType==Types.RotationTypes.TwoAxesVectors));

    parameter Types.RotationSequence sequence(
      min={1,1,1},
      max={3,3,3}) = {1,2,3} " Sequence of rotations" 
      annotation (Evaluate=true, Dialog(group=
                  "if rotationType = PlanarRotationSequence",
                  enable=rotationType==Types.RotationTypes.PlanarRotationSequence));
    parameter Cv.NonSIunits.Angle_deg angles[3]={0,0,0}
      " Rotation angles around the axes defined in 'sequence'" 
      annotation (Dialog(group="if rotationType = PlanarRotationSequence",
                  enable=rotationType==Types.RotationTypes.PlanarRotationSequence));
    parameter Types.ShapeType shapeType="cylinder" " Type of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Position r_shape[3]={0,0,0}
      " Vector from frame_a to shape origin, resolved in frame_a" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.Axis lengthDirection=r - r_shape
      " Vector in length direction of shape, resolved in frame_a" 
      annotation (Evaluate=true, Dialog(tab="Animation", group=
            "if animation = true", enable=animation));
    parameter Types.Axis widthDirection={0,1,0}
      " Vector in width direction of shape, resolved in frame_a" 
      annotation (Evaluate=true, Dialog(tab="Animation", group=
            "if animation = true", enable=animation));
    parameter SI.Length length=Modelica.Math.Vectors.length(
                                             r - r_shape) " Length of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance width=length/world.defaultWidthFraction
      " Width of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance height=width " Height of shape." 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.ShapeExtra extra=0.0
      " Additional parameter depending on shapeType (see docu of Visualizers.Advanced.Shape)."
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
  /*
  parameter Boolean checkTotalPower=false
    "= true, if total power flowing into this component shall be determined (must be zero)"
    annotation (Dialog(tab="Advanced"));
*/

    input Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.RodColor
      " Color of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    final parameter Frames.Orientation R_rel=if rotationType == 1 then 
        Frames.planarRotation(Modelica.Math.Vectors.normalize(
                                               n), Cv.from_deg(angle), 0) else 
        if rotationType == 2 then Frames.from_nxy(n_x, n_y) else 
        Frames.axesRotations(sequence, Cv.from_deg(angles), zeros(3))
      "Fixed rotation object from frame_a to frame_b";
  /*
  SI.Power totalPower
    "Total power flowing into this element, if checkTotalPower=true (otherwise dummy)";
*/
  protected
    outer Modelica.Mechanics.MultiBody.World world;

    /*
  parameter Frames.Orientation R_rel_inv=
      Frames.inverseRotation(R_rel)
*/
    parameter Frames.Orientation R_rel_inv=Frames.from_T(transpose(R_rel.T),
        zeros(3)) "Inverse of R_rel (rotate from frame_b to frame_a)";
    Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape shape(
      shapeType=shapeType,
      color=color,
      specularCoefficient=specularCoefficient,
      r_shape=r_shape,
      lengthDirection=lengthDirection,
      widthDirection=widthDirection,
      length=length,
      width=width,
      height=height,
      extra=extra,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;

  equation
    Connections.branch(frame_a.R, frame_b.R);
    assert(cardinality(frame_a) > 0 or cardinality(frame_b) > 0,
      "Neither connector frame_a nor frame_b of FixedRotation object is connected");

    /* Relationships between quantities of frame_a and frame_b */
    frame_b.r_0 = frame_a.r_0 + Frames.resolve1(frame_a.R, r);
    if rooted(frame_a.R) then
      frame_b.R = Frames.absoluteRotation(frame_a.R, R_rel);
      zeros(3) = frame_a.f + Frames.resolve1(R_rel, frame_b.f);
      zeros(3) = frame_a.t + Frames.resolve1(R_rel, frame_b.t) - cross(r, frame_a.f);
    else
      frame_a.R = Frames.absoluteRotation(frame_b.R, R_rel_inv);
      zeros(3) = frame_b.f + Frames.resolve1(R_rel_inv, frame_a.f);
      zeros(3) = frame_b.t + Frames.resolve1(R_rel_inv, frame_a.t) + cross(Frames.resolve1(R_rel_inv,r), frame_b.f);
    end if;

  /*
  if checkTotalPower then
    totalPower = frame_a.f*Frames.resolve2(frame_a.R, der(frame_a.r_0)) +
                 frame_b.f*Frames.resolve2(frame_b.R, der(frame_b.r_0)) +
                 frame_a.t*Frames.angularVelocity2(frame_a.R) +
                 frame_b.t*Frames.angularVelocity2(frame_b.R);
  else
    totalPower = 0;
  end if;
*/
    annotation (
      Documentation(info="<HTML>
<p>
Component for a <b>fixed translation</b> and <b>fixed rotation</b> of frame_b with respect
to frame_a, i.e., the relationship between connectors frame_a and frame_b
remains constant. There are several possibilities to define the
orientation of frame_b with respect to frame_a:
</p>
<ul>
<li><b>Planar rotation</b> along axis 'n' (that is fixed and resolved
    in frame_a) with a fixed angle 'angle'.</li>
<li><b>Vectors n_x</b> and <b>n_y</b> that are directed along the corresponding axes
    direction of frame_b and are resolved in frame_a (if n_y is not
    orthogonal to n_x, the y-axis of frame_b is selected such that it is
    orthogonal to n_x and in the plane of n_x and n_y).</li>
<li><b>Sequence</b> of <b>three planar axes rotations</b>.
    For example, \"sequence = {1,2,3}\" and \"angles = {90, 45, -90}\"
    means to rotate frame_a around the x axis with 90 degrees, around the new
    y axis with 45 degrees and around the new z axis around -90 degrees to
    arrive at frame_b. Note, that sequence={1,2,3}
    is the Cardan angle sequence and sequence = {3,1,3} is the Euler angle
    sequence.</li>
</ul>
<p>
By default, this component is visualized by a cylinder connecting
frame_a and frame_b, as shown in the figure below. In this figure
frame_b is rotated along the z-axis of frame_a with 60 degree. Note, that the
two visualized frames are not part of the component animation and that
the animation may be switched off via parameter animation = <b>false</b>.
</p>
<IMG SRC=\"../Images/MultiBody/FixedRotation.png\" ALT=\"Parts.FixedRotation\">
</HTML>", revisions="<HTML><p><b>Release Notes:</b></p>
<ul>
  <li><i>July 28, 2003</i><br>
         Bug fixed: if rotationType = PlanarRotationSequence, then 'angles'
         was used with unit [rad] instead of [deg].</li>
</ul>
</HTML>"),
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-136,79},{132,139}},
            textString="%name",
            lineColor={0,0,255}),
          Rectangle(
            extent={{-100,5},{100,-4}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(points={{80,20},{129,50}}, color={0,0,0}),
          Line(points={{80,20},{57,59}}, color={0,0,0}),
          Polygon(
            points={{144,60},{117,59},{132,37},{144,60}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{43,80},{46,50},{68,65},{43,80}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-144,-52},{143,-89}},
            lineColor={0,0,0},
            textString="r=%r"),
          Text(
            extent={{-117,51},{-81,26}},
            lineColor={128,128,128},
            textString="a"),
          Text(
            extent={{84,-24},{120,-49}},
            lineColor={128,128,128},
            textString="b")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-100,-1},{-100,-66}}, color={128,128,128}),
          Line(points={{100,0},{100,-65}}, color={128,128,128}),
          Line(points={{-100,-60},{89,-60}}, color={128,128,128}),
          Text(
            extent={{-22,-36},{16,-60}},
            lineColor={128,128,128},
            textString="r"),
          Rectangle(
            extent={{-100,5},{100,-5}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Line(
            points={{69,29},{97,45}},
            color={128,128,128},
            arrow={Arrow.None,Arrow.Filled}),
          Line(
            points={{70,27},{55,54}},
            color={128,128,128},
            arrow={Arrow.None,Arrow.Filled}),
          Text(
            extent={{95,42},{109,31}},
            lineColor={128,128,128},
            textString="x"),
          Text(
            extent={{42,70},{57,58}},
            lineColor={128,128,128},
            textString="y"),
          Line(
            points={{-95,22},{-58,22}},
            color={128,128,128},
            arrow={Arrow.None,Arrow.Filled}),
          Line(
            points={{-94,20},{-94,52}},
            color={128,128,128},
            arrow={Arrow.None,Arrow.Filled}),
          Text(
            extent={{-72,37},{-58,26}},
            lineColor={128,128,128},
            textString="x"),
          Text(
            extent={{-113,59},{-98,47}},
            lineColor={128,128,128},
            textString="y"),
          Polygon(
            points={{88,-56},{88,-65},{100,-60},{88,-56}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid)}));
  end FixedRotation;

  model Body
    "Rigid body with mass, inertia tensor and one frame connector (12 potential states)"

    import SI = Modelica.SIunits;
    import C = Modelica.Constants;
    import Modelica.Math.*;
    import Modelica.Mechanics.MultiBody.Types;
    import Modelica.Mechanics.MultiBody.Frames;
    Interfaces.Frame_a frame_a "Coordinate system fixed at body" 
      annotation (Placement(transformation(extent={{-116,-16},{-84,16}},
            rotation=0)));
    parameter Boolean animation=true
      "= true, if animation shall be enabled (show cylinder and sphere)";
    parameter SI.Position r_CM[3](start={0,0,0})
      "Vector from frame_a to center of mass, resolved in frame_a";
    parameter SI.Mass m(min=0, start = 1) "Mass of rigid body";
    parameter SI.Inertia I_11(min=0) = 0.001 " (1,1) element of inertia tensor"
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_22(min=0) = 0.001 " (2,2) element of inertia tensor"
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_33(min=0) = 0.001 " (3,3) element of inertia tensor"
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_21(min=-C.inf)=0 " (2,1) element of inertia tensor" annotation (
        Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_31(min=-C.inf)=0 " (3,1) element of inertia tensor" annotation (
        Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_32(min=-C.inf)=0 " (3,2) element of inertia tensor" annotation (
        Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));

    SI.Position r_0[3](start={0,0,0}, stateSelect=if enforceStates then 
                StateSelect.always else StateSelect.avoid)
      "Position vector from origin of world frame to origin of frame_a" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));
    SI.Velocity v_0[3](start={0,0,0}, stateSelect=if enforceStates then StateSelect.always else 
                StateSelect.avoid)
      "Absolute velocity of frame_a, resolved in world frame (= der(r_0))" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));
    SI.Acceleration a_0[3](start={0,0,0})
      "Absolute acceleration of frame_a resolved in world frame (= der(v_0))" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));

    parameter Boolean angles_fixed = false
      "= true, if angles_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.Angle angles_start[3]={0,0,0}
      "Initial values of angles to rotate frame_a around 'sequence_start' axes into frame_b"
      annotation (Dialog(tab="Initialization"));
    parameter Types.RotationSequence sequence_start={1,2,3}
      "Sequence of rotations to rotate frame_a into frame_b at initial time" 
      annotation (Evaluate=true, Dialog(tab="Initialization"));

    parameter Boolean w_0_fixed = false
      "= true, if w_0_start are used as initial values, else as guess values" 
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularVelocity w_0_start[3]={0,0,0}
      "Initial or guess values of angular velocity of frame_a resolved in world frame"
      annotation (Dialog(tab="Initialization"));

    parameter Boolean z_0_fixed = false
      "= true, if z_0_start are used as initial values, else as guess values" 
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularAcceleration z_0_start[3]={0,0,0}
      "Initial values of angular acceleration z_0 = der(w_0)" 
      annotation (Dialog(tab="Initialization"));

    parameter SI.Diameter sphereDiameter=world.defaultBodyDiameter
      "Diameter of sphere" annotation (Dialog(
        tab="Animation",
        group="if animation = true",
        enable=animation));
    input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      "Color of sphere" annotation (Dialog(
        tab="Animation",
        group="if animation = true",
        enable=animation));
    parameter SI.Diameter cylinderDiameter=sphereDiameter/Types.Defaults.
        BodyCylinderDiameterFraction "Diameter of cylinder" 
      annotation (Dialog(
        tab="Animation",
        group="if animation = true",
        enable=animation));
    input Types.Color cylinderColor=sphereColor "Color of cylinder" 
      annotation (Dialog(
        tab="Animation",
        group="if animation = true",
        enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(
        tab="Animation",
        group="if animation = true",
        enable=animation));
    parameter Boolean enforceStates=false
      " = true, if absolute variables of body object shall be used as states (StateSelect.always)"
      annotation (Evaluate=true,Dialog(tab="Advanced"));
    parameter Boolean useQuaternions=true
      " = true, if quaternions shall be used as potential states otherwise use 3 angles as potential states"
      annotation (Evaluate=true,Dialog(tab="Advanced"));
    parameter Types.RotationSequence sequence_angleStates={1,2,3}
      " Sequence of rotations to rotate world frame into frame_a around the 3 angles used as potential states"
       annotation (Evaluate=true, Dialog(tab="Advanced", enable=not 
            useQuaternions));

    final parameter SI.Inertia I[3, 3]=[I_11, I_21, I_31; I_21, I_22, I_32;
        I_31, I_32, I_33] "inertia tensor";
    final parameter Frames.Orientation R_start=Modelica.Mechanics.MultiBody.Frames.axesRotations(
        sequence_start, angles_start, zeros(3))
      "Orientation object from world frame to frame_a at initial time";
    final parameter SI.AngularAcceleration z_a_start[3]=Frames.resolve2(R_start, z_0_start)
      "Initial values of angular acceleration z_a = der(w_a), i.e., time derivative of angular velocity resolved in frame_a";

    SI.AngularVelocity w_a[3](start=Frames.resolve2(R_start, w_0_start),
                              fixed=fill(w_0_fixed,3),
                              stateSelect=if enforceStates then (if useQuaternions then 
                              StateSelect.always else StateSelect.never) else StateSelect.avoid)
      "Absolute angular velocity of frame_a resolved in frame_a";
    SI.AngularAcceleration z_a[3](start=Frames.resolve2(R_start, z_0_start),fixed=fill(z_0_fixed,3))
      "Absolute angular acceleration of frame_a resolved in frame_a";
    SI.Acceleration g_0[3] "Gravity acceleration resolved in world frame";

  protected
    outer Modelica.Mechanics.MultiBody.World world;

    // Declarations for quaternions (dummies, if quaternions are not used)
    parameter Frames.Quaternions.Orientation Q_start=Frames.to_Q(R_start)
      "Quaternion orientation object from world frame to frame_a at initial time";
    Frames.Quaternions.Orientation Q(start=Q_start, stateSelect=if 
          enforceStates then (if useQuaternions then StateSelect.prefer else 
          StateSelect.never) else StateSelect.avoid)
      "Quaternion orientation object from world frame to frame_a (dummy value, if quaternions are not used as states)";

    // Declaration for 3 angles
    parameter SI.Angle phi_start[3]=if sequence_start[1] ==
        sequence_angleStates[1] and sequence_start[2] == sequence_angleStates[2]
         and sequence_start[3] == sequence_angleStates[3] then angles_start else 
         Frames.axesRotationsAngles(R_start, sequence_angleStates)
      "Potential angle states at initial time";
    SI.Angle phi[3](start=phi_start, stateSelect=if enforceStates then (if 
          useQuaternions then StateSelect.never else StateSelect.always) else 
          StateSelect.avoid)
      "Dummy or 3 angles to rotate world frame into frame_a of body";
    SI.AngularVelocity phi_d[3](stateSelect=if enforceStates then (if 
          useQuaternions then StateSelect.never else StateSelect.always) else 
          StateSelect.avoid) "= der(phi)";
    SI.AngularAcceleration phi_dd[3] "= der(phi_d)";

    // Declarations for animation
    Visualizers.Advanced.Shape cylinder(
      shapeType="cylinder",
      color=cylinderColor,
      specularCoefficient=specularCoefficient,
      length=if Modelica.Math.Vectors.length(r_CM) > sphereDiameter/2 then 
                Modelica.Math.Vectors.length(r_CM) - (if cylinderDiameter > 1.1*
          sphereDiameter then sphereDiameter/2 else 0) else 0,
      width=cylinderDiameter,
      height=cylinderDiameter,
      lengthDirection=r_CM,
      widthDirection={0,1,0},
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape sphere(
      shapeType="sphere",
      color=sphereColor,
      specularCoefficient=specularCoefficient,
      length=sphereDiameter,
      width=sphereDiameter,
      height=sphereDiameter,
      lengthDirection={1,0,0},
      widthDirection={0,1,0},
      r_shape=r_CM - {1,0,0}*sphereDiameter/2,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation and sphereDiameter > 0;
  initial equation
    if angles_fixed then
      // Initialize positional variables
      if not Connections.isRoot(frame_a.R) then
        // frame_a.R is computed somewhere else
        zeros(3) = Frames.Orientation.equalityConstraint(frame_a.R, R_start);
      elseif useQuaternions then
        // frame_a.R is computed from quaternions Q
        zeros(3) = Frames.Quaternions.Orientation.equalityConstraint(Q, Q_start);
      else
        // frame_a.R is computed from the 3 angles 'phi'
        phi = phi_start;
      end if;
    end if;

  equation
    if enforceStates then
      Connections.root(frame_a.R);
    else
      Connections.potentialRoot(frame_a.R);
    end if;
    r_0 = frame_a.r_0;

    if not Connections.isRoot(frame_a.R) then
      // Body does not have states
      // Dummies
      Q = {0,0,0,1};
      phi = zeros(3);
      phi_d = zeros(3);
      phi_dd = zeros(3);
    elseif useQuaternions then
      // Use Quaternions as states (with dynamic state selection)
      frame_a.R = Frames.from_Q(Q, Frames.Quaternions.angularVelocity2(Q, der(Q)));
      {0} = Frames.Quaternions.orientationConstraint(Q);

      // Dummies
      phi = zeros(3);
      phi_d = zeros(3);
      phi_dd = zeros(3);
    else
      // Use Cardan angles as states
      phi_d = der(phi);
      phi_dd = der(phi_d);
      frame_a.R = Frames.axesRotations(sequence_angleStates, phi, phi_d);

      // Dummies
      Q = {0,0,0,1};
    end if;

    // gravity acceleration at center of mass resolved in world frame
    g_0 = world.gravityAcceleration(frame_a.r_0 + Frames.resolve1(frame_a.R,
      r_CM));

    // translational kinematic differential equations
    v_0 = der(frame_a.r_0);
    a_0 = der(v_0);

    // rotational kinematic differential equations
    w_a = Frames.angularVelocity2(frame_a.R);
    z_a = der(w_a);

    /* Newton/Euler equations with respect to center of mass
            a_CM = a_a + cross(z_a, r_CM) + cross(w_a, cross(w_a, r_CM));
            f_CM = m*(a_CM - g_a);
            t_CM = I*z_a + cross(w_a, I*w_a);
       frame_a.f = f_CM
       frame_a.t = t_CM + cross(r_CM, f_CM);
    Inserting the first three equations in the last two results in:
  */
    frame_a.f = m*(Frames.resolve2(frame_a.R, a_0 - g_0) + cross(z_a, r_CM) +
      cross(w_a, cross(w_a, r_CM)));
    frame_a.t = I*z_a + cross(w_a, I*w_a) + cross(r_CM, frame_a.f);
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Rectangle(
            extent={{-100,30},{-3,-31}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={0,127,255}),
          Text(
            extent={{131,-123},{-129,-73}},
            lineColor={0,0,0},
            textString="m=%m"),
          Text(
            extent={{-128,132},{132,72}},
            textString="%name",
            lineColor={0,0,255}),
          Ellipse(
            extent={{-20,60},{100,-60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={0,127,255})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics),
      Documentation(info="<HTML>
<p>
<b>Rigid body</b> with mass and inertia tensor.
All parameter vectors have to be resolved in frame_a.
The <b>inertia tensor</b> has to be defined with respect to a
coordinate system that is parallel to frame_a with the
origin at the center of mass of the body.
</p>
<p>
By default, this component is visualized by a <b>cylinder</b> located
between frame_a and the center of mass and by a <b>sphere</b> that has
its center at the center of mass. If the cylinder length is smaller as
the radius of the sphere, e.g., since frame_a is located at the
center of mass, the cylinder is not displayed. Note, that
the animation may be switched off via parameter animation = <b>false</b>.
</p>
<IMG SRC=\"../Images/MultiBody/Body.png\" ALT=\"Parts.Body\">
<p>
<b>States of Body Components</b>
</p>
<p>
Every body has potential states. If possible a tool will select
the states of joints and not the states of bodies because this is
usually the most efficient choice. In this case the position, orientation,
velocity and angular velocity of frame_a of the body will be computed
by the component that is connected to frame_a. However, if a body is moving
freely in space, variables of the body have to be used as states. The potential
states of the body are:
</p>
<ul>
<li> The <b>position vector</b> frame_a.r_0 from the origin of the
     world frame to the origin of frame_a of the body, resolved in
     the world frame and the <b>absolute velocity</b> v_0 of the origin of
     frame_a, resolved in the world frame (= der(frame_a.r_0)).</li>
</li>
<li> If parameter <b>useQuaternions</b> in the \"Advanced\" menu
     is <b>true</b> (this is the default), then <b>4 quaternions</b>
     are potential states. Additionally, the coordinates of the
     absolute angular velocity vector of the
     body are 3 potential states.<br>
     If <b>useQuaternions</b> in the \"Advanced\" menu
     is <b>false</b>, then <b>3 angles</b> and the derivatives of
     these angles are potential states. The orientation of frame_a
     is computed by rotating the world frame along the axes defined
     in parameter vector \"sequence_angleStates\" (default = {1,2,3}, i.e.,
     the Cardan angle sequence) around the angles used as potential states.
     For example, the default is to rotate the x-axis of the world frame
     around angles[1], the new y-axis around angles[2] and the new z-axis
     around angles[3], arriving at frame_a.
 </li>
</ul>
<p>
The quaternions have the slight disadvantage that there is a
non-linear constraint equation between the 4 quaternions.
Therefore, at least one non-linear equation has to be solved
during simulation. A tool might, however, analytically solve this
simple constraint equation. Using the 3 angles as states has the
disadvantage that there is a singular configuration in which a
division by zero will occur. If it is possible to determine in advance
for an application class that this singular configuration is outside
of the operating region, the 3 angles might be used as potential
states by setting <b>useQuaternions</b> = <b>false</b>.
</p>
<p>
In text books about 3-dimensional mechanics often 3 angles and the
angular velocity are used as states. This is not the case here, since
3 angles and their derivatives are used as potential states
(if useQuaternions = false). The reason
is that for real-time simulation the discretization formula of the
integrator might be \"inlined\" and solved together with the body equations.
By appropriate symbolic transformation the performance is
drastically increased if angles and their
derivatives are used as states, instead of angles and the angular
velocity.
</p>
<p>
Whether or not variables of the body are used as states is usually
automatically selected by the Modelica translator. If parameter
<b>enforceStates</b> is set to <b>true</b> in the \"Advanced\" menu,
then body variables are forced to be used as states according
to the setting of parameters \"useQuaternions\" and
\"sequence_angleStates\".
</p>
</HTML>"));
  end Body;

  model BodyShape
    "Rigid body with mass, inertia tensor, different shapes for animation, and two frame connectors (12 potential states)"

    import SI = Modelica.SIunits;
    import C = Modelica.Constants;
    import Modelica.Mechanics.MultiBody.Types;

    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));

    parameter Boolean animation=true
      "= true, if animation shall be enabled (show shape between frame_a and frame_b and optionally a sphere at the center of mass)";
    parameter Boolean animateSphere=true
      "= true, if mass shall be animated as sphere provided animation=true";
    parameter SI.Position r[3](start={0,0,0})
      "Vector from frame_a to frame_b resolved in frame_a";
    parameter SI.Position r_CM[3](start={0,0,0})
      "Vector from frame_a to center of mass, resolved in frame_a";
    parameter SI.Mass m(min=0, start = 1) "Mass of rigid body";
    parameter SI.Inertia I_11(min=0) = 0.001 " (1,1) element of inertia tensor"
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_22(min=0) = 0.001 " (2,2) element of inertia tensor"
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_33(min=0) = 0.001 " (3,3) element of inertia tensor"
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_21(min=-C.inf) = 0
      " (2,1) element of inertia tensor" 
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_31(min=-C.inf) = 0
      " (3,1) element of inertia tensor" 
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));
    parameter SI.Inertia I_32(min=-C.inf) = 0
      " (3,2) element of inertia tensor" 
      annotation (Dialog(group=
            "Inertia tensor (resolved in center of mass, parallel to frame_a)"));

    SI.Position r_0[3](start={0,0,0}, stateSelect=if enforceStates then 
                StateSelect.always else StateSelect.avoid)
      "Position vector from origin of world frame to origin of frame_a" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));
    SI.Velocity v_0[3](start={0,0,0}, stateSelect=if enforceStates then StateSelect.always else 
                StateSelect.avoid)
      "Absolute velocity of frame_a, resolved in world frame (= der(r_0))" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));
    SI.Acceleration a_0[3](start={0,0,0})
      "Absolute acceleration of frame_a resolved in world frame (= der(v_0))" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));

    parameter Boolean angles_fixed = false
      "= true, if angles_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.Angle angles_start[3]={0,0,0}
      "Initial values of angles to rotate frame_a around 'sequence_start' axes into frame_b"
      annotation (Dialog(tab="Initialization"));
    parameter Types.RotationSequence sequence_start={1,2,3}
      "Sequence of rotations to rotate frame_a into frame_b at initial time" 
      annotation (Evaluate=true, Dialog(tab="Initialization"));

    parameter Boolean w_0_fixed = false
      "= true, if w_0_start are used as initial values, else as guess values" 
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularVelocity w_0_start[3]={0,0,0}
      "Initial or guess values of angular velocity of frame_a resolved in world frame"
      annotation (Dialog(tab="Initialization"));

    parameter Boolean z_0_fixed = false
      "= true, if z_0_start are used as initial values, else as guess values" 
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularAcceleration z_0_start[3]={0,0,0}
      "Initial values of angular acceleration z_0 = der(w_0)" 
      annotation (Dialog(tab="Initialization"));

    parameter Types.ShapeType shapeType="cylinder" " Type of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Position r_shape[3]={0,0,0}
      " Vector from frame_a to shape origin, resolved in frame_a" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.Axis lengthDirection=r - r_shape
      " Vector in length direction of shape, resolved in frame_a" 
      annotation (Evaluate=true, Dialog(tab="Animation", group=
            "if animation = true", enable=animation));
    parameter Types.Axis widthDirection={0,1,0}
      " Vector in width direction of shape, resolved in frame_a" 
      annotation (Evaluate=true, Dialog(tab="Animation", group=
            "if animation = true", enable=animation));
    parameter SI.Length length=Modelica.Math.Vectors.length(
                                             r - r_shape) " Length of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance width=length/world.defaultWidthFraction
      " Width of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Distance height=width " Height of shape." 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter Types.ShapeExtra extra=0.0
      " Additional parameter depending on shapeType (see docu of Visualizers.Advanced.Shape)."
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    input Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      " Color of shape" 
      annotation (Dialog(tab="Animation", group="if animation = true", enable=animation));
    parameter SI.Diameter sphereDiameter=2*width " Diameter of sphere" 
      annotation (Dialog(tab="Animation", group=
            "if animation = true and animateSphere = true",
            enable=animation and animateSphere));
    input Types.Color sphereColor=color " Color of sphere of mass" 
      annotation (Dialog(tab="Animation", group=
            "if animation = true and animateSphere = true", enable=animation and animateSphere));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(tab="Animation", group=
            "if animation = true", enable=animation));
    parameter Boolean enforceStates=false
      " = true, if absolute variables of body object shall be used as states (StateSelect.always)"
      annotation (Dialog(tab="Advanced"));
    parameter Boolean useQuaternions=true
      " = true, if quaternions shall be used as potential states otherwise use 3 angles as potential states"
      annotation (Dialog(tab="Advanced"));
    parameter Types.RotationSequence sequence_angleStates={1,2,3}
      " Sequence of rotations to rotate world frame into frame_a around the 3 angles used as potential states"
       annotation (Evaluate=true, Dialog(tab="Advanced", enable=not 
            useQuaternions));

    FixedTranslation frameTranslation(r=r, animation=false) 
      annotation (Placement(transformation(extent={{-20,-20},{20,20}}, rotation=
             0)));
    Body body(
      r_CM=r_CM,
      m=m,
      I_11=I_11,
      I_22=I_22,
      I_33=I_33,
      I_21=I_21,
      I_31=I_31,
      I_32=I_32,
      animation=false,
      sequence_start=sequence_start,
      angles_fixed=angles_fixed,
      angles_start=angles_start,
      w_0_fixed=w_0_fixed,
      w_0_start=w_0_start,
      z_0_fixed=z_0_fixed,
      z_0_start=z_0_start,
      useQuaternions=useQuaternions,
      enforceStates=enforceStates,
      sequence_angleStates=sequence_angleStates) 
      annotation (Placement(transformation(extent={{-27.3333,-70.3333},{13,-30}},
            rotation=0)));
  protected
    outer Modelica.Mechanics.MultiBody.World world;
    Visualizers.Advanced.Shape shape1(
      shapeType=shapeType,
      color=color,
      specularCoefficient=specularCoefficient,
      length=length,
      width=width,
      height=height,
      lengthDirection=lengthDirection,
      widthDirection=widthDirection,
      r_shape=r_shape,
      extra=extra,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
    Visualizers.Advanced.Shape shape2(
      shapeType="sphere",
      color=sphereColor,
      specularCoefficient=specularCoefficient,
      length=sphereDiameter,
      width=sphereDiameter,
      height=sphereDiameter,
      lengthDirection={1,0,0},
      widthDirection={0,1,0},
      r_shape=r_CM - {1,0,0}*sphereDiameter/2,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation and animateSphere;
  equation
    r_0 = frame_a.r_0;
    v_0 = der(r_0);
    a_0 = der(v_0);
    connect(frame_a, frameTranslation.frame_a) 
      annotation (Line(
        points={{-100,0},{-20,0}},
        color={95,95,95},
        thickness=0.5));
    connect(frame_b, frameTranslation.frame_b) 
      annotation (Line(
        points={{100,0},{20,0}},
        color={95,95,95},
        thickness=0.5));
    connect(frame_a, body.frame_a) annotation (Line(
        points={{-100,0},{-60,0},{-60,-50.1666},{-27.3333,-50.1666}},
        color={95,95,95},
        thickness=0.5));
    annotation (
      Documentation(info="<HTML>
<p>
<b>Rigid body</b> with mass and inertia tensor and <b>two frame connectors</b>.
All parameter vectors have to be resolved in frame_a.
The <b>inertia tensor</b> has to be defined with respect to a
coordinate system that is parallel to frame_a with the
origin at the center of mass of the body. The coordinate system <b>frame_b</b>
is always parallel to <b>frame_a</b>.
</p>
<p>
By default, this component is visualized by any <b>shape</b> that can be
defined with Modelica.Mechanics.MultiBody.Visualizers.FixedShape. This shape is placed
between frame_a and frame_b (default: length(shape) = Frames.length(r)).
Additionally a <b>sphere</b> may be visualized that has
its center at the center of mass.
Note, that
the animation may be switched off via parameter animation = <b>false</b>.
</p>
<IMG SRC=\"../Images/MultiBody/BodyShape.png\" ALT=\"Parts.BodyShape\">
<p>
The following shapes can be defined via parameter <b>shapeType</b>,
e.g., shapeType=\"cone\":
</p>
<IMG SRC=\"../Images/MultiBody/FixedShape.png\" ALT=\"Visualizers.FixedShape\">
<p>
A BodyShape component has potential states. For details of these
states and of the \"Advanced\" menu parameters, see model
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Parts.Body\">MultiBody.Parts.Body</a>.
</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-134,126},{126,66}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{122,-123},{-138,-73}},
            lineColor={0,0,0},
            textString="%=r"),
          Rectangle(
            extent={{-100,31},{101,-30}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={0,127,255}),
          Ellipse(
            extent={{-60,60},{60,-60}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={0,127,255}),
          Text(
            extent={{-50,24},{55,-27}},
            lineColor={0,0,0},
            textString="%m"),
          Text(
            extent={{55,12},{91,-13}},
            lineColor={0,0,0},
            textString="b"),
          Text(
            extent={{-92,13},{-56,-12}},
            lineColor={0,0,0},
            textString="a")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Line(points={{-100,9},{-100,43}}, color={128,128,128}),
          Line(points={{100,0},{100,44}}, color={128,128,128}),
          Line(points={{-100,40},{90,40}}, color={135,135,135}),
          Polygon(
            points={{90,44},{90,36},{100,40},{90,44}},
            lineColor={128,128,128},
            fillColor={128,128,128},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-22,68},{20,40}},
            lineColor={128,128,128},
            textString="r"),
          Line(points={{-100,-10},{-100,-90}}, color={128,128,128}),
          Line(points={{-100,-84},{-10,-84}}, color={128,128,128}),
          Polygon(
            points={{-10,-80},{-10,-88},{0,-84},{-10,-80}},
            lineColor={128,128,128},
            fillColor={128,128,128},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-82,-66},{-56,-84}},
            lineColor={128,128,128},
            textString="r_CM"),
          Line(points={{0,-46},{0,-90}}, color={128,128,128})}));
  end BodyShape;

  model BodyBox
    "Rigid body with box shape. Mass and animation properties are computed from box data and density (12 potential states)"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;

    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));
    parameter Boolean animation=true
      "= true, if animation shall be enabled (show box between frame_a and frame_b)";
    parameter SI.Position r[3](start={0.1,0,0})
      "Vector from frame_a to frame_b resolved in frame_a";
    parameter SI.Position r_shape[3]={0,0,0}
      "Vector from frame_a to box origin, resolved in frame_a";
    parameter Modelica.Mechanics.MultiBody.Types.Axis lengthDirection=r - r_shape
      "Vector in length direction of box, resolved in frame_a" 
      annotation (Evaluate=true);
    parameter Modelica.Mechanics.MultiBody.Types.Axis widthDirection={0,1,0}
      "Vector in width direction of box, resolved in frame_a" 
      annotation (Evaluate=true);
    parameter SI.Length length=Modelica.Math.Vectors.length(
                                             r - r_shape) "Length of box";
    parameter SI.Distance width=length/world.defaultWidthFraction
      "Width of box";
    parameter SI.Distance height=width "Height of box";
    parameter SI.Distance innerWidth=0
      "Width of inner box surface (0 <= innerWidth <= width)";
    parameter SI.Distance innerHeight=innerWidth
      "Height of inner box surface (0 <= innerHeight <= height)";
    parameter SI.Density density = 7700
      "Density of cylinder (e.g., steel: 7700 .. 7900, wood : 400 .. 800)";
    input Modelica.Mechanics.MultiBody.Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      "Color of box" 
      annotation (Dialog(enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(enable=animation));

    SI.Position r_0[3](start={0,0,0}, stateSelect=if enforceStates then 
                StateSelect.always else StateSelect.avoid)
      "Position vector from origin of world frame to origin of frame_a" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));
    SI.Velocity v_0[3](start={0,0,0}, stateSelect=if enforceStates then StateSelect.always else 
                StateSelect.avoid)
      "Absolute velocity of frame_a, resolved in world frame (= der(r_0))" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));
    SI.Acceleration a_0[3](start={0,0,0})
      "Absolute acceleration of frame_a resolved in world frame (= der(v_0))" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));

    parameter Boolean angles_fixed = false
      "= true, if angles_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.Angle angles_start[3]={0,0,0}
      "Initial values of angles to rotate frame_a around 'sequence_start' axes into frame_b"
      annotation (Dialog(tab="Initialization"));
    parameter Types.RotationSequence sequence_start={1,2,3}
      "Sequence of rotations to rotate frame_a into frame_b at initial time" 
      annotation (Evaluate=true, Dialog(tab="Initialization"));

    parameter Boolean w_0_fixed = false
      "= true, if w_0_start are used as initial values, else as guess values" 
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularVelocity w_0_start[3]={0,0,0}
      "Initial or guess values of angular velocity of frame_a resolved in world frame"
      annotation (Dialog(tab="Initialization"));

    parameter Boolean z_0_fixed = false
      "= true, if z_0_start are used as initial values, else as guess values" 
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularAcceleration z_0_start[3]={0,0,0}
      "Initial values of angular acceleration z_0 = der(w_0)" 
      annotation (Dialog(tab="Initialization"));

    parameter Boolean enforceStates=false
      " = true, if absolute variables of body object shall be used as states (StateSelect.always)"
      annotation (Dialog(tab="Advanced"));
    parameter Boolean useQuaternions=true
      " = true, if quaternions shall be used as potential states otherwise use 3 angles as potential states"
      annotation (Dialog(tab="Advanced"));
    parameter Types.RotationSequence sequence_angleStates={1,2,3}
      " Sequence of rotations to rotate world frame into frame_a around the 3 angles used as potential states"
       annotation (Evaluate=true, Dialog(tab="Advanced", enable=not 
            useQuaternions));

    final parameter SI.Mass mo(min=0)=density*length*width*height
      "Mass of box without hole";
    final parameter SI.Mass mi(min=0)=density*length*innerWidth*innerHeight
      "Mass of hole of box";
    final parameter SI.Mass m(min=0)=mo - mi "Mass of box";
    final parameter Frames.Orientation R=Frames.from_nxy(r, widthDirection)
      "Orientation object from frame_a to coordinates system spanned by r and widthDirection";
    final parameter SI.Position r_CM[3]=Modelica.Math.Vectors.normalize(
                                                         r)*length/2
      "Position vector from origin of frame_a to center of mass, resolved in frame_a";
    final parameter SI.Inertia I[3, 3]=Frames.resolveDyade1(R, diagonal({mo*(
        width*width + height*height) - mi*(innerWidth*innerWidth + innerHeight*
        innerHeight),mo*(length*length + height*height) - mi*(length*length +
        innerHeight*innerHeight),mo*(length*length + width*width) - mi*(length*
        length + innerWidth*innerWidth)}/12))
      "Inertia tensor of body box with respect to center of mass, parallel to frame_a";
    Body body(
      animation=false,
      r_CM=r_CM,
      m=m,
      I_11=I[1, 1],
      I_22=I[2, 2],
      I_33=I[3, 3],
      I_21=I[2, 1],
      I_31=I[3, 1],
      I_32=I[3, 2],
      sequence_start=sequence_start,
      angles_fixed=angles_fixed,
      angles_start=angles_start,
      w_0_fixed=w_0_fixed,
      w_0_start=w_0_start,
      z_0_fixed=z_0_fixed,
      z_0_start=z_0_start,
      useQuaternions=useQuaternions,
      enforceStates=enforceStates,
      sequence_angleStates=sequence_angleStates) 
      annotation (Placement(transformation(extent={{-30,-80},{10,-40}},
            rotation=0)));
    FixedTranslation frameTranslation(
      r=r,
      animation=animation,
      shapeType="box",
      r_shape=r_shape,
      lengthDirection=lengthDirection,
      widthDirection=widthDirection,
      length=length,
      width=width,
      height=height,
      color=color,
     specularCoefficient=specularCoefficient) annotation (Placement(
          transformation(extent={{-30,-20},{10,20}}, rotation=0)));

  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    r_0 = frame_a.r_0;
    v_0 = der(r_0);
    a_0 = der(v_0);

    assert(innerWidth <= width,
      "parameter innerWidth is greater as parameter width");
    assert(innerHeight <= height,
      "parameter innerHeight is greater as paraemter height");
    connect(frameTranslation.frame_a, frame_a) annotation (Line(
        points={{-30,0},{-100,0}},
        color={95,95,95},
        thickness=0.5));
    connect(frameTranslation.frame_b, frame_b) annotation (Line(
        points={{10,0},{100,0}},
        color={95,95,95},
        thickness=0.5));
    connect(frame_a, body.frame_a) annotation (Line(
        points={{-100,0},{-70,0},{-70,-60},{-30,-60}},
        color={95,95,95},
        thickness=0.5));
    annotation (
      Documentation(info="<HTML>
<p>
<b>Rigid body</b> with <b>box</b> shape.
The mass properties of the body (mass, center of mass,
inertia tensor) are computed
from the box data. Optionally, the box may be hollow.
The (outer) box shape is by default used in the animation.
The hollow part is not shown in the animation.
The two connector frames <b>frame_a</b> and <b>frame_b</b>
are always parallel to each other. Example of component
animation (note, that
the animation may be switched off via parameter animation = <b>false</b>):
</p>
<IMG SRC=\"../Images/MultiBody/BodyBox.png\" ALT=\"Parts.BodyBox\">
<p>
A BodyBox component has potential states. For details of these
states and of the \"Advanced\" menu parameters, see model
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Parts.Body\">MultiBody.Parts.Body</a>.</p>
</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Polygon(
            points={{100,40},{100,-30},{90,-40},{90,30},{100,40}},
            lineColor={0,95,191},
            fillColor={0,95,191},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{-100,30},{90,-40}},
            lineColor={0,127,255},
            pattern=LinePattern.None,
            fillColor={0,127,255},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-100,30},{-90,40},{100,40},{90,30},{-100,30}},
            lineColor={0,95,191},
            fillColor={0,95,191},
            fillPattern=FillPattern.Solid),
          Text(
            extent={{-129,100},{131,40}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{130,-98},{-130,-48}},
            lineColor={0,0,0},
            textString="%=r"),
          Text(
            extent={{52,8},{88,-17}},
            lineColor={0,0,0},
            textString="b"),
          Text(
            extent={{-87,12},{-51,-13}},
            lineColor={0,0,0},
            textString="a")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));
  end BodyBox;

  model BodyCylinder
    "Rigid body with cylinder shape. Mass and animation properties are computed from cylinder data and density (12 potential states)"

    import SI = Modelica.SIunits;
    import NonSI = Modelica.SIunits.Conversions.NonSIunits;
    import Modelica.Mechanics.MultiBody.Types;
    Interfaces.Frame_a frame_a
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{
              -116,-16},{-84,16}}, rotation=0)));
    Interfaces.Frame_b frame_b
      "Coordinate system fixed to the component with one cut-force and cut-torque"
                               annotation (Placement(transformation(extent={{84,
              -16},{116,16}}, rotation=0)));
    parameter Boolean animation=true
      "= true, if animation shall be enabled (show cylinder between frame_a and frame_b)";
    parameter SI.Position r[3](start={0.1,0,0})
      "Vector from frame_a to frame_b, resolved in frame_a";
    parameter SI.Position r_shape[3]={0,0,0}
      "Vector from frame_a to cylinder origin, resolved in frame_a";
    parameter Modelica.Mechanics.MultiBody.Types.Axis lengthDirection=r - r_shape
      "Vector in length direction of cylinder, resolved in frame_a" 
      annotation (Evaluate=true);
    parameter SI.Length length=Modelica.Math.Vectors.length(
                                             r - r_shape) "Length of cylinder";
    parameter SI.Distance diameter=length/world.defaultWidthFraction
      "Diameter of cylinder";
    parameter SI.Distance innerDiameter=0
      "Inner diameter of cylinder (0 <= innerDiameter <= Diameter)";
    parameter SI.Density density = 7700
      "Density of cylinder (e.g., steel: 7700 .. 7900, wood : 400 .. 800)";
    input Modelica.Mechanics.MultiBody.Types.Color color=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      "Color of cylinder" annotation (Dialog(enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(enable=animation));

    SI.Position r_0[3](start={0,0,0}, stateSelect=if enforceStates then 
                StateSelect.always else StateSelect.avoid)
      "Position vector from origin of world frame to origin of frame_a" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));
    SI.Velocity v_0[3](start={0,0,0}, stateSelect=if enforceStates then StateSelect.always else 
                StateSelect.avoid)
      "Absolute velocity of frame_a, resolved in world frame (= der(r_0))" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));
    SI.Acceleration a_0[3](start={0,0,0})
      "Absolute acceleration of frame_a resolved in world frame (= der(v_0))" 
      annotation(Dialog(tab="Initialization", __Dymola_initialDialog=true));

    parameter Boolean angles_fixed = false
      "= true, if angles_start are used as initial values, else as guess values"
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.Angle angles_start[3]={0,0,0}
      "Initial values of angles to rotate frame_a around 'sequence_start' axes into frame_b"
      annotation (Dialog(tab="Initialization"));
    parameter Types.RotationSequence sequence_start={1,2,3}
      "Sequence of rotations to rotate frame_a into frame_b at initial time" 
      annotation (Evaluate=true, Dialog(tab="Initialization"));

    parameter Boolean w_0_fixed = false
      "= true, if w_0_start are used as initial values, else as guess values" 
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularVelocity w_0_start[3]={0,0,0}
      "Initial or guess values of angular velocity of frame_a resolved in world frame"
      annotation (Dialog(tab="Initialization"));

    parameter Boolean z_0_fixed = false
      "= true, if z_0_start are used as initial values, else as guess values" 
      annotation(Evaluate=true, choices(__Dymola_checkBox=true), Dialog(tab="Initialization"));
    parameter SI.AngularAcceleration z_0_start[3]={0,0,0}
      "Initial values of angular acceleration z_0 = der(w_0)" 
      annotation (Dialog(tab="Initialization"));

    parameter Boolean enforceStates=false
      " = true, if absolute variables of body object shall be used as states (StateSelect.always)"
      annotation (Dialog(tab="Advanced"));
    parameter Boolean useQuaternions=true
      " = true, if quaternions shall be used as potential states otherwise use 3 angles as potential states"
      annotation (Dialog(tab="Advanced"));
    parameter Types.RotationSequence sequence_angleStates={1,2,3}
      " Sequence of rotations to rotate world frame into frame_a around the 3 angles used as potential states"
       annotation (Evaluate=true, Dialog(tab="Advanced", enable=not 
            useQuaternions));

    constant Real pi=Modelica.Constants.pi;
    final parameter SI.Distance radius=diameter/2 "Radius of cylinder";
    final parameter SI.Distance innerRadius=innerDiameter/2
      "Inner-Radius of cylinder";
    final parameter SI.Mass mo(min=0)=density*pi*length*radius*radius
      "Mass of cylinder without hole";
    final parameter SI.Mass mi(min=0)=density*pi*length*innerRadius*innerRadius
      "Mass of hole of cylinder";
    final parameter SI.Inertia I22=(mo*(length*length + 3*radius*radius) - mi*(
        length*length + 3*innerRadius*innerRadius))/12
      "Inertia with respect to axis through center of mass, perpendicular to cylinder axis";
    final parameter SI.Mass m(min=0)=mo - mi "Mass of cylinder";
    final parameter Frames.Orientation R=Frames.from_nxy(r, {0,1,0})
      "Orientation object from frame_a to frame spanned by cylinder axis and axis perpendicular to cylinder axis";
    final parameter SI.Position r_CM[3]=Modelica.Math.Vectors.normalize(
                                                         r)*length/2
      "Position vector from frame_a to center of mass, resolved in frame_a";
    final parameter SI.Inertia I[3, 3]=Frames.resolveDyade1(R, diagonal({(mo*
        radius*radius - mi*innerRadius*innerRadius)/2,I22,I22}))
      "Inertia tensor of cylinder with respect to center of mass, resolved in frame parallel to frame_a";

    Body body(
      r_CM=r_CM,
      m=m,
      I_11=I[1, 1],
      I_22=I[2, 2],
      I_33=I[3, 3],
      I_21=I[2, 1],
      I_31=I[3, 1],
      I_32=I[3, 2],
      animation=false,
      sequence_start=sequence_start,
      angles_fixed=angles_fixed,
      angles_start=angles_start,
      w_0_fixed=w_0_fixed,
      w_0_start=w_0_start,
      z_0_fixed=z_0_fixed,
      z_0_start=z_0_start,
      useQuaternions=useQuaternions,
      enforceStates=enforceStates,
      sequence_angleStates=sequence_angleStates) 
      annotation (Placement(transformation(extent={{-30,-80},{10,-40}},
            rotation=0)));
    FixedTranslation frameTranslation(
      r=r,
      animation=animation,
      shapeType="pipecylinder",
      r_shape=r_shape,
      lengthDirection=lengthDirection,
      length=length,
      width=diameter,
      height=diameter,
      extra=innerDiameter/diameter,
      color=color,
      specularCoefficient=specularCoefficient,
      widthDirection={0,1,0}) annotation (Placement(transformation(extent={{-30,
              -20},{10,20}}, rotation=0)));

  protected
    outer Modelica.Mechanics.MultiBody.World world;
  equation
    r_0 = frame_a.r_0;
    v_0 = der(r_0);
    a_0 = der(v_0);

    assert(innerDiameter < diameter,
      "parameter innerDiameter is greater as parameter diameter.");
    connect(frameTranslation.frame_a, frame_a) annotation (Line(
        points={{-30,0},{-100,0}},
        color={95,95,95},
        thickness=0.5));
    connect(frameTranslation.frame_b, frame_b) annotation (Line(
        points={{10,0},{100,0}},
        color={95,95,95},
        thickness=0.5));
    connect(frame_a, body.frame_a) annotation (Line(
        points={{-100,0},{-70,0},{-70,-60},{-30,-60}},
        color={95,95,95},
        thickness=0.5));
    annotation (
      Documentation(info="<HTML>
<p>
<b>Rigid body</b> with <b>cylinder</b> shape.
The mass properties of the body (mass, center of mass,
inertia tensor) are computed
from the cylinder data. Optionally, the cylinder may be hollow.
The cylinder shape is by default used in the animation.
The two connector frames <b>frame_a</b> and <b>frame_b</b>
are always parallel to each other. Example of component
animation (note, that
the animation may be switched off via parameter animation = <b>false</b>):
</p>
<IMG SRC=\"../Images/MultiBody/BodyCylinder.png\" ALT=\"Parts.BodyCylinder\">
<p>
A BodyCylinder component has potential states. For details of these
states and of the \"Advanced\" menu parameters, see model
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Parts.Body\">MultiBody.Parts.Body</a>.</HTML>
"),   Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{-129,100},{131,40}},
            textString="%name",
            lineColor={0,0,255}),
          Text(
            extent={{130,-98},{-130,-48}},
            lineColor={0,0,0},
            textString="%=r"),
          Rectangle(
            extent={{-100,40},{100,-40}},
            lineColor={0,0,0},
            fillPattern=FillPattern.HorizontalCylinder,
            fillColor={0,127,255}),
          Text(
            extent={{-87,13},{-51,-12}},
            lineColor={0,0,0},
            textString="a"),
          Text(
            extent={{51,12},{87,-13}},
            lineColor={0,0,0},
            textString="b")}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics));
  end BodyCylinder;

  model PointMass
    "Rigid body where body rotation and inertia tensor is neglected (6 potential states)"

    import SI = Modelica.SIunits;
    import Modelica.Mechanics.MultiBody.Types;
    Interfaces.Frame_a frame_a
      "Coordinate system fixed at center of mass point" 
      annotation (Placement(transformation(extent={{-16,-16},{16,16}}, rotation=
             0)));
    parameter Boolean animation=true
      "= true, if animation shall be enabled (show sphere)";
    parameter SI.Mass m(min=0) "Mass of mass point";
    input SI.Diameter sphereDiameter=world.defaultBodyDiameter
      "Diameter of sphere" annotation (Dialog(
        tab="Animation",
        group="if animation = true",
        enable=animation));
    input Types.Color sphereColor=Modelica.Mechanics.MultiBody.Types.Defaults.BodyColor
      "Color of sphere" annotation (Dialog(
        tab="Animation",
        group="if animation = true",
        enable=animation));
    input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient
      "Reflection of ambient light (= 0: light is completely absorbed)" 
      annotation (Dialog(
        tab="Animation",
        group="if animation = true",
        enable=animation));
    parameter StateSelect stateSelect=StateSelect.avoid
      "Priority to use frame_a.r_0, v_0 (= der(frame_a.r_0)) as states" annotation(Dialog(tab="Advanced"));

    SI.Position r_0[3](start={0,0,0}, stateSelect=stateSelect)
      "Position vector from origin of world frame to origin of frame_a, resolved in world frame"
      annotation(Dialog(group="Initialization", __Dymola_initialDialog=true));
    SI.Velocity v_0[3](start={0,0,0}, stateSelect=stateSelect)
      "Absolute velocity of frame_a, resolved in world frame (= der(r_0))" 
      annotation(Dialog(group="Initialization", __Dymola_initialDialog=true));
    SI.Acceleration a_0[3](start={0,0,0})
      "Absolute acceleration of frame_a resolved in world frame (= der(v_0))" 
      annotation(Dialog(group="Initialization", __Dymola_initialDialog=true));

  protected
    outer Modelica.Mechanics.MultiBody.World world;

    // Declarations for animation
    Visualizers.Advanced.Shape sphere(
      shapeType="sphere",
      color=sphereColor,
      specularCoefficient=specularCoefficient,
      length=sphereDiameter,
      width=sphereDiameter,
      height=sphereDiameter,
      lengthDirection={1,0,0},
      widthDirection={0,1,0},
      r_shape= - {1,0,0}*sphereDiameter/2,
      r=frame_a.r_0,
      R=frame_a.R) if world.enableAnimation and animation;
  equation
    // If any possible, do not use the connector as root
    Connections.potentialRoot(frame_a.R, 10000);

    if Connections.isRoot(frame_a.R) then
       assert(cardinality(frame_a)==0, "
A Modelica.Mechanics.MultiBody.Parts.PointMass model is connected in
a way, so that no equations are present to compute frame_a.R
(the orientation object in the connector). Setting frame_a.R to
an arbitrary value in the PointMass model, might lead to a wrong
overall model, depending on how the PointMass model is used.
   You can avoid this message, by providing equations that
compute the orientation object, e.g., by using the
Modelica.Mechanics.MultiBody.Joints.FreeMotion joint.
   If a PointMass model is not connected at all, the
orientation object is set to a unit rotation. But this is
the only case where this is done.
");
       frame_a.R = Frames.nullRotation();
    else
       frame_a.t = zeros(3);
    end if;

    // Newton equation: f = m*(a-g)
    r_0 = frame_a.r_0;
    v_0 = der(r_0);
    a_0 = der(v_0);
    frame_a.f = m*Frames.resolve2(frame_a.R, a_0 - world.gravityAcceleration(r_0));
    annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics={
          Text(
            extent={{132,-102},{-129,-56}},
            lineColor={0,0,0},
            textString="m=%m"),
          Text(
            extent={{-128,110},{132,55}},
            textString="%name",
            lineColor={0,0,255}),
          Ellipse(
            extent={{-50,50},{50,-50}},
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere,
            fillColor={0,127,255})}),
      Diagram(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={1,1}), graphics),
      Documentation(info="<HTML>
<p>
<b>Rigid body</b> where the inertia tensor is neglected.
This body is
solely defined by its mass.
By default, this component is visualized by a <b>sphere</b> that has
its center at frame_a. Note, that
the animation may be switched off via parameter animation = <b>false</b>.
</p>

<p>
Every PointMass has potential states. If possible a tool will select
the states of joints and not the states of PointMasss because this is
usually the most efficient choice. In this case the position and
velocity of frame_a of the body will be computed
by the component that is connected to frame_a. However, if a PointMass is moving
freely in space, variables of the PointMass have to be used as states. The potential
states are: The <b>position vector</b> frame_a.r_0 from the origin of the
world frame to the origin of frame_a of the body, resolved in
the world frame and the <b>absolute velocity</b> v_0 of the origin of
frame_a, resolved in the world frame (= der(frame_a.r_0)).
</p>

<p>
Whether or not variables of the body are used as states is usually
automatically selected by the Modelica translator. If parameter
<b>enforceStates</b> is set to <b>true</b> in the \"Advanced\" menu,
then PointMass variables frame_a.r_0 and der(frame_a.r_0)
are forced to be used as states.
</p>
</HTML>"));
  end PointMass;

  model Mounting1D
    "Propagate 1-dim. support torque to 3-dim. system (provided world.driveTrainMechanics3D=true)"
    parameter Modelica.SIunits.Angle phi0=0 "Fixed offset angle of housing";
    parameter Modelica.Mechanics.MultiBody.Types.Axis n={1,0,0}
      "Axis of rotation = axis of support torque (resolved in frame_a)";

    Modelica.Mechanics.Rotational.Interfaces.Flange_b flange_b
      "(right) flange fixed in housing" annota