within ;
package ExpRecordPkg
  function addLibComplexNum "function for external test"

    input ExpRecordPkg.ComplexRec x1;
    input ExpRecordPkg.ComplexRec x2;
    output ExpRecordPkg.ComplexRec y = ExpRecordPkg.ComplexRec(0,0);

  external "C" addLibComplexNum(x1.realComp,x1.imagComp,x2.realComp,x2.imagComp,y.realComp,y.imagComp) annotation(Library="recordExterFkt");

  end addLibComplexNum;

  model RecordExtFktTester
    parameter ExpRecordPkg.ComplexRec x1 = ExpRecordPkg.ComplexRec(2,2);
    parameter ExpRecordPkg.ComplexRec x2 = ExpRecordPkg.ComplexRec(2,1);
    ExpRecordPkg.ComplexRec y;
  equation
     y = ExpRecordPkg.addLibComplexNum(x1,x2);
  end RecordExtFktTester;

  record ComplexRec
    Real realComp;
    Real imagComp;

  end ComplexRec;
  annotation (uses(Modelica(version="3.2")));
end ExpRecordPkg;
