block EMF3
  import SI = Modelica.SIunits;
  final constant Real pi = 2 * asin(1.0);
  parameter Integer m(min = 1) = 3 "number of phases";
  parameter SI.ElectricalTorqueConstant k = 0.01583 "Transformation coefficient";
  Modelica.SIunits.Voltage v[m] "Voltage drops between the two plugs";
  Modelica.SIunits.Current i[m] "Currents flowing into positive plugs";
  SI.Angle phi "Angle of shaft flange with respect to support (= flange.phi - support.phi)";
  SI.Angle offset = 2 / 3 * pi;
  SI.AngularVelocity w "Angular velocity of flange relative to support";
  SI.ElectricalTorqueConstant ke[m];
  annotation(Diagram(), Icon(graphics = {Ellipse(rotation = 0, lineColor = {0,0,255}, fillColor = {0,0,255}, pattern = LinePattern.Solid, fillPattern = FillPattern.None, lineThickness = 0.25, extent = {{-59.7403,59.5041},{64.2267,-62.5738}}),Text(rotation = 0, lineColor = {0,0,255}, fillColor = {0,0,255}, pattern = LinePattern.Solid, fillPattern = FillPattern.None, lineThickness = 0.25, extent = {{33.5301,-54.3093},{88.5478,-77.4498}}, textString = "EMF3")}), experiment(StartTime = 0.0, StopTime = 1.0, Tolerance = 1e-06));
  Modelica.Electrical.MultiPhase.Interfaces.PositivePlug p(final m = m) annotation(Placement(visible = true, transformation(origin = {-0.236128,95.1594}, extent = {{-12,-12},{12,12}}, rotation = 0), iconTransformation(origin = {-0.236128,95.1594}, extent = {{-12,-12},{12,12}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Interfaces.NegativePlug n(final m = m) annotation(Placement(visible = true, transformation(origin = {0,-95.1594}, extent = {{-12,-12},{12,12}}, rotation = 0), iconTransformation(origin = {0,-95.1594}, extent = {{-12,-12},{12,12}}, rotation = 0)));
  Modelica.Mechanics.Rotational.Interfaces.Flange_b flange annotation(Placement(visible = true, transformation(origin = {94.9233,0.236128}, extent = {{-12,-12},{12,12}}, rotation = 0), iconTransformation(origin = {94.9233,0.236128}, extent = {{-12,-12},{12,12}}, rotation = 0)));
  Modelica.Mechanics.Rotational.Interfaces.Support support annotation(Placement(visible = true, transformation(origin = {-99.8819,0}, extent = {{-12,-12},{12,12}}, rotation = 0), iconTransformation(origin = {-99.8819,0}, extent = {{-12,-12},{12,12}}, rotation = 0)));
equation
  v = p.pin.v - n.pin.v;
  zeros(m) = p.pin.i + n.pin.i;
  i = p.pin.i;
  phi = flange.phi - support.phi;
  w = der(phi);
  for j in 1:m loop
  ke[j] = k * sin(phi + offset + (j - 1) / m * 2 * pi);

  end for;
  v = ke * w;
  flange.tau = -ke * i "flange.tau = sum(ke[k]*i[k]), k=1:m";
  support.tau = -flange.tau;
end EMF3;

