within TestTriggerPkg;
block testForLoopBlock
  parameter Integer nValues(min=1) "|Variable|number of values in vector";
  parameter Real[nValues] startValues(final unit=fill(tiscUnit, nValues)) =
    ones(nValues) "|Variable|start value for TISC-Value"
    annotation (Evaluate=false);
  parameter Real[nValues] offset=zeros(nValues) "offset of value"
    annotation (Dialog(group="Unit conversion (Out=TISC*<factor>+<offset>)"));
  parameter String tiscUnit="" "|Variable|unit of value on TISC-Server";
  parameter Real[nValues] factor=ones(nValues) "factor of value"
    annotation (Dialog(group="Unit conversion (Out=TISC*<factor>+<offset>)"));
  Modelica.Blocks.Interfaces.RealOutput[nValues] value(final start={startValues[
        i]*factor[i] + offset[i] for i in 1:nValues}) "received values";
  input Integer triggerInput(final start=1);

  Integer nextTriggerValue(start=-1);
equation

algorithm
  when triggerInput == nextTriggerValue then
    for i in 1:nValues loop
      value[i] := -value[i]*i;
    end for;
    nextTriggerValue := -pre(nextTriggerValue);
  end when;

end testForLoopBlock;
