model buck
  parameter Real booleanpulse1__Twidth(quantity = "Time",unit = "s") = booleanpulse1__period*booleanpulse1__width/100;
  parameter Real booleanpulse1__period(quantity = "Time",unit = "s",min = 1e-60,start = 1) = 0.0001;
  discrete Real booleanpulse1__pulsStart(quantity = "Time",unit = "s");
  parameter Real booleanpulse1__startTime(quantity = "Time",unit = "s") = 0;
  parameter Real booleanpulse1__width(min = 1e-60,max = 100) = 50;
  Real booleanpulse1__y;
  parameter Real capacitor1__C(quantity = "Capacitance",unit = "F",min = 0,start = 1) = 0.0001;
  Real capacitor1__i(quantity = "ElectricCurrent",unit = "A");
  Real capacitor1__n__i(quantity = "ElectricCurrent",unit = "A");
  Real capacitor1__n__v(quantity = "ElectricPotential",unit = "V");
  Real capacitor1__p__i(quantity = "ElectricCurrent",unit = "A");
  Real capacitor1__p__v(quantity = "ElectricPotential",unit = "V");
  Real capacitor1__v(quantity = "ElectricPotential",unit = "V",start = 0);
  parameter Real constantvoltage1__V(quantity = "ElectricPotential",unit = "V",start = 1) = 12;
  Real constantvoltage1__i(quantity = "ElectricCurrent",unit = "A");
  Real constantvoltage1__n__i(quantity = "ElectricCurrent",unit = "A");
  Real constantvoltage1__n__v(quantity = "ElectricPotential",unit = "V");
  Real constantvoltage1__p__i(quantity = "ElectricCurrent",unit = "A");
  Real constantvoltage1__p__v(quantity = "ElectricPotential",unit = "V");
  Real constantvoltage1__v(quantity = "ElectricPotential",unit = "V");
  Real ground1__p__i(quantity = "ElectricCurrent",unit = "A");
  Real ground1__p__v(quantity = "ElectricPotential",unit = "V");
  parameter Real idealclosingswitch1__Goff(quantity = "Conductance",unit = "S",min = 0) = 1e-05;
  Real idealclosingswitch1__LossPower(quantity = "Power",unit = "W");
  parameter Real idealclosingswitch1__Ron(quantity = "Resistance",unit = "Ohm",min = 0) = 1e-05;
  parameter Real idealclosingswitch1__T(quantity = "ThermodynamicTemperature",unit = "K",displayUnit = "degC",min = 0,start = 288.15,nominal = 300) = 293.15;
  Real idealclosingswitch1__T_heatPort(quantity = "ThermodynamicTemperature",unit = "K",displayUnit = "degC",min = 0,start = 288.15,nominal = 300);
  Real idealclosingswitch1__control;
  Real idealclosingswitch1__i(quantity = "ElectricCurrent",unit = "A");
  Real idealclosingswitch1__n__i(quantity = "ElectricCurrent",unit = "A");
  Real idealclosingswitch1__n__v(quantity = "ElectricPotential",unit = "V");
  Real idealclosingswitch1__p__i(quantity = "ElectricCurrent",unit = "A");
  Real idealclosingswitch1__p__v(quantity = "ElectricPotential",unit = "V");
  Real idealclosingswitch1__s(unit = "1");
  constant Real idealclosingswitch1__unitCurrent(quantity = "ElectricCurrent",unit = "A") = 1;
  constant Real idealclosingswitch1__unitVoltage(quantity = "ElectricPotential",unit = "V") = 1;
  parameter Real idealclosingswitch1__useHeatPort = 0;
  Real idealclosingswitch1__v(quantity = "ElectricPotential",unit = "V");
  parameter Real idealdiode1__Goff(quantity = "Conductance",unit = "S",min = 0) = 1e-05;
  Real idealdiode1__LossPower(quantity = "Power",unit = "W");
  parameter Real idealdiode1__Ron(quantity = "Resistance",unit = "Ohm",min = 0) = 1e-05;
  parameter Real idealdiode1__T(quantity = "ThermodynamicTemperature",unit = "K",displayUnit = "degC",min = 0,start = 288.15,nominal = 300) = 293.15;
  Real idealdiode1__T_heatPort(quantity = "ThermodynamicTemperature",unit = "K",displayUnit = "degC",min = 0,start = 288.15,nominal = 300);
  parameter Real idealdiode1__Vknee(quantity = "ElectricPotential",unit = "V",min = 0,start = 0) = 0;
  Real idealdiode1__i(quantity = "ElectricCurrent",unit = "A");
  Real idealdiode1__n__i(quantity = "ElectricCurrent",unit = "A");
  Real idealdiode1__n__v(quantity = "ElectricPotential",unit = "V");
  Real idealdiode1__off(start = 1);
  Real idealdiode1__p__i(quantity = "ElectricCurrent",unit = "A");
  Real idealdiode1__p__v(quantity = "ElectricPotential",unit = "V");
  Real idealdiode1__s(unit = "1",start = 0);
  constant Real idealdiode1__unitCurrent(quantity = "ElectricCurrent",unit = "A") = 1;
  constant Real idealdiode1__unitVoltage(quantity = "ElectricPotential",unit = "V") = 1;
  parameter Real idealdiode1__useHeatPort = 0;
  Real idealdiode1__v(quantity = "ElectricPotential",unit = "V");
  parameter Real inductor1__L(quantity = "Inductance",unit = "H",start = 1) = 0.0001;
  Real inductor1__i(quantity = "ElectricCurrent",unit = "A",start = 0);
  Real inductor1__n__i(quantity = "ElectricCurrent",unit = "A");
  Real inductor1__n__v(quantity = "ElectricPotential",unit = "V");
  Real inductor1__p__i(quantity = "ElectricCurrent",unit = "A");
  Real inductor1__p__v(quantity = "ElectricPotential",unit = "V");
  Real inductor1__v(quantity = "ElectricPotential",unit = "V");
  Real resistor1__LossPower(quantity = "Power",unit = "W");
  parameter Real resistor1__R(quantity = "Resistance",unit = "Ohm",start = 1) = 10;
  Real resistor1__R_actual(quantity = "Resistance",unit = "Ohm");
  parameter Real resistor1__T(quantity = "ThermodynamicTemperature",unit = "K",displayUnit = "degC",min = 0,start = 288.15,nominal = 300) = resistor1__T_ref;
  Real resistor1__T_heatPort(quantity = "ThermodynamicTemperature",unit = "K",displayUnit = "degC",min = 0,start = 288.15,nominal = 300);
  parameter Real resistor1__T_ref(quantity = "ThermodynamicTemperature",unit = "K",displayUnit = "degC",min = 0,start = 288.15,nominal = 300) = 300.15;
  parameter Real resistor1__alpha(quantity = "LinearTemperatureCoefficient",unit = "1/K") = 0;
  Real resistor1__i(quantity = "ElectricCurrent",unit = "A");
  Real resistor1__n__i(quantity = "ElectricCurrent",unit = "A");
  Real resistor1__n__v(quantity = "ElectricPotential",unit = "V");
  Real resistor1__p__i(quantity = "ElectricCurrent",unit = "A");
  Real resistor1__p__v(quantity = "ElectricPotential",unit = "V");
  parameter Real resistor1__useHeatPort = 0;
  Real resistor1__v(quantity = "ElectricPotential",unit = "V");
  discrete Real z_0;
  discrete Real z_1(start = booleanpulse1__startTime);
  discrete Real z_2;
  discrete Real z_3;
initial equation
  pre(booleanpulse1__pulsStart) = booleanpulse1__startTime;
equation
  ground1__p__v = 0;
  capacitor1__i = capacitor1__C*der(capacitor1__v);
  capacitor1__v = capacitor1__p__v-capacitor1__n__v;
  0 = capacitor1__p__i+capacitor1__n__i;
  capacitor1__i = capacitor1__p__i;
  resistor1__R_actual = resistor1__R*(1+resistor1__alpha*(resistor1__T_heatPort-resistor1__T_ref));
  resistor1__v = resistor1__R_actual*resistor1__i;
  resistor1__LossPower = resistor1__v*resistor1__i;
  resistor1__v = resistor1__p__v-resistor1__n__v;
  0 = resistor1__p__i+resistor1__n__i;
  resistor1__i = resistor1__p__i;
  resistor1__T_heatPort = resistor1__T;
  idealdiode1__off = pre(z_0);
  idealdiode1__v = idealdiode1__s*(idealdiode1__off*1+(1-idealdiode1__off)*idealdiode1__Ron)+idealdiode1__Vknee;
  idealdiode1__i = idealdiode1__s*(idealdiode1__off*idealdiode1__Goff+(1-idealdiode1__off)*1)+idealdiode1__Goff*idealdiode1__Vknee;
  idealdiode1__LossPower = idealdiode1__v*idealdiode1__i;
  idealdiode1__v = idealdiode1__p__v-idealdiode1__n__v;
  0 = idealdiode1__p__i+idealdiode1__n__i;
  idealdiode1__i = idealdiode1__p__i;
  idealdiode1__T_heatPort = idealdiode1__T;
  inductor1__L*der(inductor1__i) = inductor1__v;
  inductor1__v = inductor1__p__v-inductor1__n__v;
  0 = inductor1__p__i+inductor1__n__i;
  inductor1__i = inductor1__p__i;
  idealclosingswitch1__v = idealclosingswitch1__s*(idealclosingswitch1__control*idealclosingswitch1__Ron+(1-idealclosingswitch1__control)*1);
  idealclosingswitch1__i = idealclosingswitch1__s*(idealclosingswitch1__control*1+(1-idealclosingswitch1__control)*idealclosingswitch1__Goff);
  idealclosingswitch1__LossPower = idealclosingswitch1__v*idealclosingswitch1__i;
  idealclosingswitch1__v = idealclosingswitch1__p__v-idealclosingswitch1__n__v;
  0 = idealclosingswitch1__p__i+idealclosingswitch1__n__i;
  idealclosingswitch1__i = idealclosingswitch1__p__i;
  idealclosingswitch1__T_heatPort = idealclosingswitch1__T;
  constantvoltage1__v = constantvoltage1__V;
  constantvoltage1__v = constantvoltage1__p__v-constantvoltage1__n__v;
  0 = constantvoltage1__p__i+constantvoltage1__n__i;
  constantvoltage1__i = constantvoltage1__p__i;
  booleanpulse1__y = pre(z_3)*pre(z_2);
  ground1__p__i+capacitor1__n__i+resistor1__n__i+idealdiode1__p__i+constantvoltage1__n__i = 0;
  capacitor1__p__i+resistor1__p__i+inductor1__n__i = 0;
  idealdiode1__n__i+inductor1__p__i+idealclosingswitch1__n__i = 0;
  idealclosingswitch1__p__i+constantvoltage1__p__i = 0;
  booleanpulse1__y = idealclosingswitch1__control;
  capacitor1__n__v = constantvoltage1__n__v;
  capacitor1__n__v = ground1__p__v;
  capacitor1__n__v = idealdiode1__p__v;
  capacitor1__n__v = resistor1__n__v;
  idealclosingswitch1__n__v = idealdiode1__n__v;
  idealclosingswitch1__n__v = inductor1__p__v;
  constantvoltage1__p__v = idealclosingswitch1__p__v;
  capacitor1__p__v = inductor1__n__v;
  capacitor1__p__v = resistor1__p__v;
initial algorithm
  if idealdiode1__s<0 then
    z_0:=1;
  else
    z_0:=0;
  end if;
  if time<booleanpulse1__pulsStart+booleanpulse1__Twidth then
    z_2:=1;
  else
    z_2:=0;
  end if;
  if time>=booleanpulse1__pulsStart then
    z_3:=1;
  else
    z_3:=0;
  end if;
algorithm
  when idealdiode1__s<0 then
    z_0:=1;
  elsewhen idealdiode1__s>=0 then
    z_0:=0;
  end when;
  when time>z_1 then
    booleanpulse1__pulsStart:=time;
    z_1:=z_1+booleanpulse1__period;
  end when;
  when time<booleanpulse1__pulsStart+booleanpulse1__Twidth then
    z_2:=1;
  elsewhen time>=booleanpulse1__pulsStart+booleanpulse1__Twidth then
    z_2:=0;
  end when;
  when time>=booleanpulse1__pulsStart then
    z_3:=1;
  elsewhen time<booleanpulse1__pulsStart then
    z_3:=0;
  end when;
end buck;

