package externalObject
  class Object
    extends ExternalObject;
    //
    function constructor
      input Integer someNumber;
      output Object obj;

      external "C" obj = create(someNumber)       annotation(Include = "#include \"mainfunctions.h\"", Library = {"libexternalObject.a"});
    end constructor;
    // GCC (OpenModelica)
    //annotation(Include = "#include \"mainfunctions.h\"", Library = {"libexternalObject.a"});
    // VStudio (Dymola)
    //annotation(Include = "#include \"mainfunctions.h\"", Library = {"externalObject"});
    function destructor
      input Object obj;

      external "C" destroy(obj) ; 
    end destructor;
    //
    annotation(Icon(coordinateSystem(extent = {{-100,-100},{100,100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2,2})), Diagram(coordinateSystem(extent = {{-100,-100},{100,100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2,2})));
  end Object;
  model someModel
    Integer a = 1;
    parameter Integer b = 2;
    Object obj = Object(b);
    annotation(Icon(coordinateSystem(extent = {{-100,-100},{100,100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2,2})), Diagram(coordinateSystem(extent = {{-100,-100},{100,100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2,2})));
  end someModel;
  annotation(Icon(coordinateSystem(extent = {{-100,-100},{100,100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2,2})), Diagram(coordinateSystem(extent = {{-100,-100},{100,100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2,2})), uses(Modelica(version = "3.2")));
end externalObject;

