model BrushedDCMotor "A servo mechanism"
  Modelica.Mechanics.Rotational.Components.Inertia inertia1(J=3.53e-06) annotation(Placement(visible=true, transformation(origin={67.9637,-0.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0)));
  annotation(experiment(StartTime=0.0, StopTime=0.05, Algorithm="dassl", Tolerance=1e-06, Interval=0.0001));
  Modelica.Electrical.Analog.Basic.EMF emf(k=0.023444) annotation(Placement(visible=true, transformation(origin={30.0,0.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0)));
  Modelica.Electrical.Analog.Basic.Inductor inductor1(L=0.00027) annotation(Placement(visible=true, transformation(origin={15.0,30.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0)));
  Modelica.Electrical.Analog.Basic.Resistor resistor1(R=1.91) annotation(Placement(visible=true, transformation(origin={-12.594,30.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0)));
  Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(Placement(visible=true, transformation(origin={-45.0,30.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0), iconTransformation(origin={-100.0,40.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0)));
  Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(Placement(visible=true, transformation(origin={-45.0,-15.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0), iconTransformation(origin={-100.0,-50.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0)));
  Modelica.Mechanics.Rotational.Interfaces.Flange_b flange_b annotation(Placement(visible=true, transformation(origin={95.0,-0.0}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0), iconTransformation(origin={100.0,2.207}, extent={{-10.0,-10.0},{10.0,10.0}}, rotation=0)));
equation 
  connect(resistor1.p,pin_p) annotation(Line(visible=true, origin={-33.797,30.0}, points={{11.203,0.0},{-11.203,0.0}}, color={0,0,255}));
  connect(pin_n,emf.n) annotation(Line(visible=true, origin={5.0,-13.3333}, points={{-50.0,-1.6667},{25.0,-1.6667},{25.0,3.3333}}, color={0,0,255}));
  connect(flange_b,inertia1.flange_b) annotation(Line(visible=true, origin={86.4819,-0.0}, points={{8.5181,-0.0},{-8.5182,0.0}}));
  connect(inductor1.p,resistor1.n) annotation(Line(visible=true, origin={1.203,30.0}, points={{3.797,0.0},{-3.797,0.0}}, color={0,0,255}));
  connect(emf.p,inductor1.n) annotation(Line(visible=true, origin={28.3333,23.3333}, points={{1.6667,-13.3333},{1.6667,6.6667},{-3.3333,6.6667}}, color={0,0,255}));
  connect(emf.flange,inertia1.flange_a) annotation(Line(visible=true, origin={48.9819,0.0}, points={{-8.9819,0.0},{8.9819,0.0}}));
  annotation(experiment(StartTime=0.0, StopTime=25), Documentation(info="<html><p>The structure of the control system is shown in the schematic picture below. It consists of an input signal, a sensor, a feedback loop, and a regulator. The physical system consists of the gear and axis system described in <a href=\"Modelica://IntroductoryExamples.MultiDomain.DCMotor/\">DC Motor</a> and <a href=\"Modelica://IntroductoryExamples.MultiDomain.WeakAxis/\">Weak Axis</a>. Since the physical system has negative static gain the PI gain also has to be negative.</p>
<p><img src=\"MultiDomain/image018.png\" border=\"0\" alt=\"\" /></p>
<p>In the <a href=\"Modelica://IntroductoryExamples.MultiDomain.StiffServoMechanism/\">stiff servo mechanism example</a> it is shown how different controller gains affect the response. After selecting a gain <em>k = 1.5</em> for both the stiff and weak axis systems we can compare the results:</p>
<p><img src=\"MultiDomain/image027.png\" border=\"0\" alt=\"\" /></p>
<p>As seen the controller design made using the stiff axis model performs well also when the more accurate weak axis is used in simulations.</p></html>", revisions=""), Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}, preserveAspectRatio=true, initialScale=0.1, grid={10,10}), graphics={Rectangle(visible=true, origin={-0.0,-35.0}, lineColor={112,31,0}, fillColor={255,66,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder, lineThickness=0, extent={{-25.0,0.0},{50.0,75.0}}),Polygon(visible=true, origin={-0.0,-35.0}, lineColor={112,31,0}, fillColor={183,47,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder, lineThickness=0, points={{-25.0,75.0},{-50.0,50.0},{-50.0,25.0},{-25.0,0.0}}),Text(visible=true, fillPattern=FillPattern.Solid, extent={{-100.0,-150.0},{100.0,-110.0}}, textString="%name", fontName="Arial"),Rectangle(visible=true, origin={-0.0,-35.0}, lineColor={152,152,152}, fillColor={227,227,227}, fillPattern=FillPattern.HorizontalCylinder, extent={{50.0,25.0},{100.0,50.0}}),Polygon(visible=true, origin={-0.0,-35.0}, lineColor={150,150,150}, fillColor={128,128,128}, fillPattern=FillPattern.Solid, points={{-34.3,-25.0},{-34.3,-8.75},{-5.24,-8.75},{2.32,40.39},{24.71,40.39},{35.47,-10.2},{65.7,-10.2},{65.7,-25.0}})}), Diagram(coordinateSystem(extent={{-216.0,-139.5},{216.0,139.5}}, preserveAspectRatio=true, initialScale=0.1, grid={5,5})));
end BrushedDCMotor;
