within TestTILMediaOSMC;
model gas_pT "Gas vapor model with p, T and xi as independent variables"
  replaceable parameter TestTILMediaOSMC.BaseGas gasType constrainedby
    TestTILMediaOSMC.BaseGas "type record of the gas or gas mixture"
    annotation(choicesAllMatching=true);

  input Modelica.SIunits.AbsolutePressure p "Pressure"
               annotation(Dialog);

  input Modelica.SIunits.Temperature T "Temperature"
                  annotation(Dialog);

  input Modelica.SIunits.MassFraction xi[gasType.nc-1] = gasType.xi_default
    "Mass fraction" annotation(Dialog);
equation

  annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
            {100,100}}), graphics={Ellipse(extent={{-100,100},{100,-100}},
            lineColor={0,0,255}), Text(
          extent={{-46,40},{52,-36}},
          lineColor={0,0,255},
          textString="Gas")}));
end gas_pT;
