model EndocrineSystem
  extends EndocrineCoeffs;
  Real MG(start = 1) "Mass of the gland";
  Real B(start = 1) "Gormon in the body";
  Real G(start = 1) "Gormon in gland";
  Real SG "synthesis of gland";
  Real DG "degradation of gland";
  Real I "intensity";
  Real A1 "aux";
  Real A2 "aux";
  Real A3 "aux";
  Real B0 "aux";
  constant Real Small = 0.0;
equation
  I = Intensity(time);
  A1 = K1 * I;
  B0 = K2 * (1 - exp(-K3 * B * I)) + K4 * (1 - exp(K5 * B));
  //gormon in body elimination
  A3 = K6 * MG * exp(-B * K7);
  //speed of gormon exit
  A2 = K8 * (1 - exp(-B * K9)) * exp(-G * K10);
  //synthesis of the gormon
  SG = K11 * MG * (-G * K12);
  //gland synthesis
  DG = MG * K13 * exp(-B * K14) * (K15 + I);
  //gland degradation
  der(G) = if G > 0 then A3 + A2 - A1 else Small;
  //gormon in gland
  //allow small increase in gormon
  der(B) = A1 - A2 - B0;
  //gormon in body
  der(MG) = if MG > 0 then SG - DG else Small;
  //mass of gland
  annotation(Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2, 2})), Diagram(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2, 2})));
end EndocrineSystem;