model Muscle "muscle model"
  extends MuscleCoeff;
  Real SMF(start = 1) "synthesis of MF";
  Real DMF(start = 1) "degradation of MF";
  Real MF(start = 1) "mf in muscle";
  Real SMX(start = 1) "synthesis of MF";
  Real DMX(start = 1) "degradation of MF";
  Real MX(start = 1) "mx in muscle";
  Real I(start = 0.1) "intensity of the training";
  Real G "gormon - input";
  constant Real Small = 1e-5;
equation
  I = Intensity(time);
  SMF = f1 * G * MF * (f2 + I);
  DMF = MF * (f3 + f4 * I);
  SMX = f5 * MX * (1 - exp(-G * f6)) * (1 - exp(-I * f7)) * (f8 - MX / MF) + f9 * MX;
  DMX = MX * (f10 + f11 * I);
  if MX <= 0 then
    MX = Small;
  else
    der(MX) = SMX - DMX;
  end if;
  if MF <= 0 then
    MF = Small;
  else
    der(MF) = SMF - DMF;
  end if;
  annotation(Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2, 2})), Diagram(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2, 2})));
end Muscle;