within FalseIterationVar;

model TestFalseItrationVar
  Modelica.SIunits.Pressure p;
  Modelica.SIunits.Temperature T;
  //Pure Component Properties
  Modelica.SIunits.PartialPressure p_s "Saturation partial pressure of condensing component";
  Modelica.SIunits.SpecificEnthalpy delta_hv "Specific enthalpy of vaporation of condensing component";
  Modelica.SIunits.SpecificEnthalpy delta_hd "Specific enthalpy of desublimation of condensing component";
  parameter Integer nc=5;
  Modelica.SIunits.SpecificEnthalpy h_i[nc];
equation
  p = 4e6;
  T = 273.15 + time * 10;
  (p_s, delta_hv, delta_hd, h_i) = pureComponentProperties_pTnc(p, T, nc);
end TestFalseItrationVar;