within FunctionPkg;
function specificEntropy_phxi
  // Don't use these functions during simulation, Medium classes are always faster! Only use for start and initial values.
  input LiquidTypes.BaseLiquid liquidType "Liquid type" annotation(choicesAllMatching = true);
  input Modelica.SIunits.AbsolutePressure p "Pressure";
  input Modelica.SIunits.SpecificEnthalpy h "Specific enthalpy";
  input Modelica.SIunits.MassFraction[:] xi = zeros(liquidType.nc - 1)
    "Mass fractions of the first nc-1 components";
  output Modelica.SIunits.SpecificEntropy s "Specific entropy";
algorithm
  s := Internals.specificEntropy_phxi(p, h, xi, liquidType.concatLiquidName, liquidType.nc);

end specificEntropy_phxi;
