within FunctionPkg.Internals;
function specificEntropy_phxi
  input Modelica.SIunits.AbsolutePressure p "Pressure";
  input Modelica.SIunits.SpecificEnthalpy h "Specific enthalpy";
  input Modelica.SIunits.MassFraction[:] xi
    "Mass fractions of the first nc-1 components";
  input LiquidName  liquidName "Liquid name";
  input Integer nc "Number of components";
  output Modelica.SIunits.SpecificEntropy s "Specific entropy";
external "C" s = TILMedia_LiquidFunctions_specificEntropy_phxi(p, h, xi, liquidName, nc)
  annotation(Include="
  double TILMedia_LiquidFunctions_specificEntropy_phxi(const double p,const double T,const double* xi,const char* const name,const int nc)
{
  return p - T;
}
  
  ");

end specificEntropy_phxi;
