within ThermoS.Uops;
model Reservoir
  // A large Reservoir with constant (p, T, & Xi)
  // Permits reverse flow through its port

  replaceable package Medium = PartialMixtureMedium ;
  FluidPort port (redeclare package Medium = Medium)  ; 
	// Specify that our Medium is used in outlet

  parameter Medium.AbsolutePressure     p              ;
  parameter Medium.Temperature          T              ;
  parameter Medium.MassFraction         Xi[Medium.nXi]  ;

  Medium.ThermodynamicState   state	;

  equation
    state 		= Medium.setState_pTX( p, T, Xi ); 
    port.h_outflow 	= Medium.specificEnthalpy(state) ;
    port.Xi_outflow 	= Xi;
    port.p		= p ;
end Reservoir;
