within ThermoS.Uops;
model Valve

  // A simple Valve
  replaceable package Medium = PartialMixtureMedium;

  // Specify that our Medium is used in/outlet
  FluidPort inlet(redeclare package Medium = Medium);
  FluidPort outlet(redeclare package Medium = Medium);

  // Valve Coefficient   (1 m3/s @ one bar differential with 1kg/m3 density)
  parameter Real cv=1.0/sqrt(1e5);
  Medium.ThermodynamicState state;

equation
  /* No change in Enthalpy in the Valve
    * inStream returns value when flow is into the device
    * Looks trivial for one to one connections. But is designed to handle
    * large number of connection branches without singularity
*/
  outlet.h_outflow  = inStream(inlet.h_outflow); // flow is  inlet to outlet
  outlet.Xi_outflow = inStream(inlet.Xi_outflow); // pass composition un_altered
  inlet.h_outflow   = inStream(outlet.h_outflow); // reverse flow case
  inlet.Xi_outflow  = inStream(outlet.Xi_outflow); // pass composition un_altered

  // Mass balance
  inlet.m_flow + outlet.m_flow = 0;

  // Pressure difference drives the flow
  /* Pressure used for state is regularized .. 
     avoid sudden change during reversal*/
  state = Medium.setState_phX( regStep( (inlet.p - outlet.p), inlet.p, outlet.p, 10),
    			       inStream(inlet.h_outflow),
    			       inStream(inlet.Xi_outflow));

  /* Note the regRoot function regularizes sign(x) * sqrt(abs(x)) function near at x=0
    Here below 10Pa pressure differential it kicks in */
  inlet.m_flow = sqrt(Medium.density(state)) * cv * regRoot((inlet.p - outlet.p), 10);
end Valve;
