within ThermoS.Uops;
model Product
  replaceable package Medium = PartialMixtureMedium;
  //  Medium.BaseProperties  medium   ;

  FluidPort inlet(redeclare package Medium = Medium);
  // Specify that our Medium is used in outlet
  Medium.AbsolutePressure p;
  Medium.Temperature T;
  Medium.MassFraction Xi[Medium.nXi];
  Medium.ThermodynamicState state;

equation
  state = Medium.setState_pTX( p, T, Xi);
  inlet.p = state.p;
  inlet.h_outflow = Medium.specificEnthalpy(state);
  inlet.Xi_outflow = state.X[1:nXi];  // state X size is alwasy nS
end Product;
