within ThermoS;
package Util "General Utility functions"
/***********************************************************/
/* Useful String Manipulation Functions */
/* These exist in Modelica.Utilities.Strings .. 
      but just an illustration of using external calls */
/***********************************************************/
/*==================*/
 function strlen 
/*==================*/
    input String str; 
    output Integer len; 
    external "C" len=ModelicaStrings_length(str);
 end strlen;
/*==================*/
function substr 
/*==================*/
    input String str; 
    input Integer i1,i2; 
    output String out; 
    external "C" out=ModelicaStrings_substring(str,i1,i2);
 end substr;
/* Other functions I need for pretty printing 
   Error Checking in Simulation etc.
/*==================*/
function decimalS
/*==================*/
   input Real    x ;
   input Integer n ;
   output String   s ;
 algorithm
    s := String(floor(x*(10^n)) /  (10^n)) ;      
end decimalS;
/*==================*/
function ldFile
/*==================*/
/* Load file and bail out if unsuccessful */
	input String fname;
	output Boolean result;
 algorithm
        result := OpenModelica.Scripting.loadFile(fname) ;
	if (result) then
	       print(fname + " is Loaded\n");
	       print(fname + " failed to load\n");
	       OpenModelica.Scripting.exit(0) ;
	end if;
end ldFile;
end Util;
