within ThermoS.Uops;
model OpenTank
//It has two connections
  //   inlet ... can be located at any level in the tank
  //   and outlet is AT THE BOTTOM of the tank
  replaceable   package Medium = PartialMixtureMedium ;
  replaceable   package Tank =  Cylinder ;
  FluidPort 	inlet (redeclare package Medium = Medium)  ; 
  FluidPort 	outlet (redeclare package Medium = Medium)  ; 
//  Parameters
  parameter    Length	in_pos   = 1   ;   
  parameter    Length	out_pos  = 0   ;   
  CoefficientOfHeatTransfer	hcoef = 150	    ; // Ambient to fluid heat transfer coeff. 
  Medium.ThermodynamicState	state 		    ; // Fluid state in the heater
  Heat				Q_in		    ; // Heat tranferred to fluid  
  Area	                        A_h	            ; //  heat transfer area
  Temperature			Tf		    ; // Tank Fluid temperature (K)
  Temperature			Ta		    ; // Ambient temperature (K)
  Energy			U		    ; // Internal energy of fluid holdup
  SpecificHeatCapacity          Cp    		    ; // Specific heat of fluid in holdup
// Tank State
  Volume		        holdup              ; // Volume of fluid in the tank 
  Area                          csarea              ; // Tank Cross sectional Area (at fluid level)
  Length                        level               ; // Fluid Level in the tank
  Density                       rho                 ; // Fluid Density
  Pressure                      tankP  = 1e5        ; // Pressure in the Tank
  Percent                       pFull                ; // %Vol occupied by fluid
  equation
       state = Medium.setState_pTX((inlet.p + outlet.p)*0.5 , Tf, outlet.Xi_outflow);
       outlet.h_outflow = Medium.specificEnthalpy(state);
       rho = Medium.density(state) ;
   der(holdup) =  (inlet.m_flow + outlet.m_flow) /   rho ;  
   level = Tank.level(holdup) ;
   pFull = 100 * holdup / Tank.vol ;
   outlet.p = tankP + rho * 9.8 * level  ; 
   if (level > in_pos) then    // Inlet is below the tank level
   	inlet.p = tankP +  rho * 9.8 * (level - in_pos) ; 
	assert(level >in_pos, "Tank Level is above the Inlet");
   	inlet.p = tankP ;
	assert(level <=in_pos, "Tank Level is below the Inlet");
   end if;
    // Energy Balance
       inlet.m_flow * actualStream(inlet.h_outflow) 
             + outlet.m_flow *  actualStream(outlet.h_outflow) + Q_in 
        =  der(U)  ;   // fluid
        U = holdup * Medium.density(state) * Medium.specificInternalEnergy(state) ;
	Q_in = hcoef * A_h * (Ta - Tf)  ;
        Cp = Medium.specificHeatCapacityCp(state) ;
    // Ignoring Composition change dynamics due to hold up
     outlet.Xi_outflow = inStream(inlet.Xi_outflow) ;  // Normal flow
     inlet.Xi_outflow = inStream(outlet.Xi_outflow) ;  // for  Reverse flow
     inlet.h_outflow = outlet.h_outflow ;   // Well mixed condition 
end OpenTank;
