package MiniMedium
  extends Modelica.Media.Interfaces.PartialTwoPhaseMedium;

  redeclare record extends ThermodynamicState(phase(start = 0))
      // inherits phase integer
      Temperature T "Temperature of medium";
      AbsolutePressure p "Absolute pressure of medium";
      Density d "Density of medium";
      SpecificEnergy u "Specific inner energy of medium";
      SpecificEnthalpy h "Specific enthalpy of medium";
      SpecificEntropy s "Specific entropy of medium";
  end ThermodynamicState;

  redeclare record extends SaturationProperties
      // inherits Tsat and psat
      ThermodynamicState liq;
      ThermodynamicState vap;
  end SaturationProperties;

  redeclare function setSat_p
    input AbsolutePressure p;
    output SaturationProperties sat;
  algorithm
    sat.liq.d := 5;
  end setSat_p;
  annotation(uses(Modelica(version = "3.2.1")), preferredView = "text");
end MiniMedium;