/*
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Linköping University,
 * Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3
 * AND THIS OSMC PUBLIC LICENSE (OSMC-PL).
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES RECIPIENT'S
 * ACCEPTANCE OF THE OSMC PUBLIC LICENSE.
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from Linköping University, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or
 * http://www.openmodelica.org, and in the OpenModelica distribution.
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS
 * OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 */

#include "FMU2Wrapper.h"
//#include "log.hpp"
#include <iostream>

using namespace std;

//#define LOG_FMI2()   EmptyLog()
//#define DO_LOG_FMI2  false

// ---------------------------------------------------------------------------
// Common Functions
// ---------------------------------------------------------------------------

//
// Inquire version numbers of header files and setting logging status
//

extern "C"
const char* fmi2GetTypesPlatform()
{
  //LOG_FMI() << "Entry: fmi2GetTypesPlatform" << endl;
  return fmi2TypesPlatform;
}

extern "C"
const char* fmi2GetVersion()
{
  //LOG_FMI() << "Entry: fmi2GetVersion" << endl;
  return fmi2Version;
}

extern "C"
fmi2Status fmi2SetDebugLogging(fmi2Component c,
                               fmi2Boolean loggingOn,
                               size_t nCategories,
                               const fmi2String categories[])
{
  //LOG_FMI() << "Entry: fmi2SetDebugLogging" << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->setDebugLogging(loggingOn);
}

//
// Creation and destruction of FMU instances
//

extern "C"
fmi2Component fmi2Instantiate(fmi2String instanceName,
                              fmi2Type fmuType,
                              fmi2String GUID,
                              fmi2String fmuResourceLocation,
                              const fmi2CallbackFunctions *functions,
                              fmi2Boolean visible,
                              fmi2Boolean loggingOn)
{
  //LOG_FMI() << "Entry: fmi2Instantiate" << endl;
  return reinterpret_cast<fmi2Component>(OBJECTCONSTRUCTOR);
}

extern "C"
void fmi2FreeInstance(fmi2Component c)
{
  //LOG_FMI() << "Entry: fmi2FreeInstance" << endl;
  delete reinterpret_cast<FMU2Wrapper*>(c);
}

//
// Enter and exit initialization mode, terminate and reset
//

extern "C"
fmi2Status fmi2SetupExperiment(fmi2Component c,
                               fmi2Boolean toleranceDefined,
                               fmi2Real tolerance,
                               fmi2Real startTime,
                               fmi2Boolean stopTimeDefined,
                               fmi2Real stopTime)
{
  return reinterpret_cast<FMU2Wrapper*>
    (c)->setupExperiment(toleranceDefined, tolerance, startTime,
                         stopTimeDefined, stopTime);
}

extern "C"
fmi2Status fmi2EnterInitializationMode(fmi2Component c)
{
  //LOG_FMI() << "Entry: fmi2EnterInitializationMode" << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->initialize();
}

extern "C"
fmi2Status fmi2ExitInitializationMode(fmi2Component c)
{
  return fmi2OK;
}

extern "C"
fmi2Status fmi2Terminate(fmi2Component c)
{
  //LOG_FMI() << "Entry: fmi2Terminate" << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->terminate();
}

extern "C"
fmi2Status fmi2Reset(fmi2Component c)
{
  //LOG_FMI() << "Entry: fmi2Reset" << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->reset();
}

//
// Getting and setting variable values
//

extern "C"
fmi2Status fmi2GetReal(fmi2Component c,
                       const fmi2ValueReference vr[], size_t nvr,
                       fmi2Real value[])
{
  //LOG_FMI() << "Entry: fmi2GetReal nvr=" << nvr << "value references=" << printArray(vr, nvr, " ") << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->getReal(vr, nvr, value);
}

extern "C"
fmi2Status fmi2GetInteger(fmi2Component c,
                          const fmi2ValueReference vr[], size_t nvr,
                          fmi2Integer value[])
{
  //LOG_FMI() << "Entry: fmi2GetInteger nvr=" << nvr << "value references=" << printArray(vr, nvr, " ") << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->getInteger(vr, nvr, value);
}

extern "C"
fmi2Status fmi2GetBoolean(fmi2Component c,
                          const fmi2ValueReference vr[], size_t nvr,
                          fmi2Boolean value[])
{
  //LOG_FMI() << "Entry: fmi2GetBoolean nvr=" << nvr << "value references=" << printArray(vr, nvr, " ") << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->getBoolean(vr, nvr, value);
}

extern "C"
fmi2Status fmi2GetString(fmi2Component c,
                         const fmi2ValueReference vr[], size_t nvr,
                         fmi2String  value[])
{
  //LOG_FMI() << "Entry: fmi2String nvr=" << nvr << "value references=" << printArray(vr, nvr, " ") << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->getString(vr, nvr, value);
}

extern "C"
fmi2Status fmi2SetReal(fmi2Component c,
                       const fmi2ValueReference vr[], size_t nvr,
                       const fmi2Real value[])
{
  //LOG_FMI() << "Entry: fmi2SetReal nvr=" << nvr << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->setReal(vr, nvr, value);
}

extern "C"
fmi2Status fmi2SetInteger(fmi2Component c,
                          const fmi2ValueReference vr[], size_t nvr,
                          const fmi2Integer value[])
{
  //LOG_FMI() << "Entry: fmi2SetInteger nvr=" << nvr << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->setInteger(vr, nvr, value);
}

extern "C"
fmi2Status fmi2SetBoolean(fmi2Component c,
                          const fmi2ValueReference vr[], size_t nvr,
                          const fmi2Boolean value[])
{
  //LOG_FMI() << "Entry: fmi2Boolean nvr=" << nvr << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->setBoolean(vr, nvr, value);
}

extern "C"
fmi2Status fmi2SetString(fmi2Component c,
                         const fmi2ValueReference vr[], size_t nvr,
                         const fmi2String value[])
{
  //LOG_FMI() << "Entry: fmi2String nvr=" << nvr << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->setString(vr, nvr, value);
}

//
// Getting and setting the internal FMU state
//

extern "C"
fmi2Status fmi2GetFMUstate (fmi2Component c, fmi2FMUstate* FMUstate)
{
  return fmi2Error; // not implemented
}

extern "C"
fmi2Status fmi2SetFMUstate (fmi2Component c, fmi2FMUstate  FMUstate)
{
  return fmi2Error; // not implemented
}

extern "C"
fmi2Status fmi2FreeFMUstate(fmi2Component c, fmi2FMUstate* FMUstate)
{
  return fmi2Error; // not implemented
}

extern "C"
fmi2Status fmi2SerializedFMUstateSize(fmi2Component c, fmi2FMUstate FMUstate,
                                      size_t *size)
{
  return fmi2Error; // not implemented
}

extern "C"
fmi2Status fmi2SerializeFMUstate(fmi2Component c, fmi2FMUstate FMUstate,
                                 fmi2Byte serializedState[], size_t size)
{
  return fmi2Error; // not implemented
}

extern "C"
fmi2Status fmi2DeSerializeFMUstate(fmi2Component c,
                                   const fmi2Byte serializedState[],
                                   size_t size, fmi2FMUstate* FMUstate)
{
  return fmi2Error; // not implemented
}

//
// Getting directional derivatives
//

extern "C"
fmi2Status fmi2GetDirectionalDerivative(fmi2Component c,
                                        const fmi2ValueReference vUnknown_ref[],
                                        size_t nUnknown,
                                        const fmi2ValueReference vKnown_ref[],
                                        size_t nKnown,
                                        const fmi2Real dvKnown[],
                                        fmi2Real dvUnknown[])
{
  return fmi2Error; // not implemented
}

// ---------------------------------------------------------------------------
// Types for Functions for FMI2 for Model Exchange
// ---------------------------------------------------------------------------

//
// Enter and exit the different modes
//

extern "C"
fmi2Status fmi2EnterEventMode(fmi2Component c)
{
  return fmi2OK;
}

extern "C"
fmi2Status fmi2NewDiscreteStates(fmi2Component c, fmi2EventInfo *eventInfo)
{
  eventInfo->newDiscreteStatesNeeded = fmi2False;
  eventInfo->terminateSimulation = fmi2False;
  return reinterpret_cast<FMU2Wrapper*>(c)->eventUpdate(eventInfo);
}

extern "C"
fmi2Status fmi2EnterContinuousTimeMode(fmi2Component c)
{
  return fmi2OK;
}

extern "C"
fmi2Status fmi2CompletedIntegratorStep(fmi2Component c,
                                       fmi2Boolean noSetFMUStatePriorToCurrentPoint,
                                       fmi2Boolean* enterEventMode,
                                       fmi2Boolean* terminateSimulation)
{
  //LOG_FMI() << "Entry: fmi2CompletedIntegratorStep" << endl;
  *terminateSimulation = fmi2False;
  return reinterpret_cast<FMU2Wrapper*>(c)->completedIntegratorStep(enterEventMode);
}

//
// Providing independent variables and re-initialization of caching
//

extern "C"
fmi2Status fmi2SetTime(fmi2Component c, fmi2Real time)
{
  //LOG_FMI() << "Entry: fmi2SetTime is called: fmi2Component=" << c << " time=" << time << endl;
  if(!c) return fmi2Fatal; // TODO OpenModelica produces this Error if loading an FMI2 Model.
  return reinterpret_cast<FMU2Wrapper*>(c)->setTime(time);
}

extern "C"
fmi2Status fmi2SetContinuousStates(fmi2Component c,
                                   const fmi2Real x[], size_t nx)
{
  //LOG_FMI() << "Entry: fmi2SetContinuousStates nx=" << nx << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->setContinuousStates(x, nx);
}

//
// Evaluation of the model equations
//

extern "C"
fmi2Status fmi2GetDerivatives(fmi2Component c,
                              fmi2Real derivatives[], size_t nx)
{
  //LOG_FMI() << "Entry: fmi2GetDerivates nx = " << nx << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->getDerivatives(derivatives, nx);
}

extern "C"
fmi2Status fmi2GetEventIndicators(fmi2Component c,
                                  fmi2Real eventIndicators[], size_t ni)
{
  //if(DO_LOG_FMI2)
  //{
  //  LOG_FMI() << "Entry: fmi2GetEventIndicators ni=" << ni << endl;
  //  fmi2Status result = reinterpret_cast<FMU2Wrapper*>(c)->getEventIndicators(eventIndicators, ni);
  //  LOG_FMI() << "Return values eventIndicators =" << printArray(eventIndicators, ni, " ") << endl;
  //  return result;
  //}
  //else
  //{
    return reinterpret_cast<FMU2Wrapper*>(c)->getEventIndicators(eventIndicators, ni);
  //}
}

extern "C"
fmi2Status fmi2GetContinuousStates(fmi2Component c,
                                   fmi2Real states[], size_t nx)
{
  //LOG_FMI() << "Entry: fmi2GetContinuousStates nx=" << nx << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->getContinuousStates(states, nx);
}

extern "C"
fmi2Status fmi2GetNominalsOfContinuousStates(fmi2Component c,
                                             fmi2Real x_nominal[], size_t nx)
{
  //LOG_FMI() << "Entry: fmi2GetNominalContinuousStates" << endl;
  return reinterpret_cast<FMU2Wrapper*>(c)->getNominalContinuousStates(x_nominal, nx);
}

