#pragma once
#include <iostream>
#include <string>
#include <vector>
#include <assert.h>
#include "fmi2Functions.h"
#include "FMU2GlobalSettings.h"

class FMU2Wrapper
{
public:
    FMU2Wrapper(fmi2String instanceName, fmi2String GUID,
                const fmi2CallbackFunctions *functions, fmi2Boolean loggingOn);
    virtual ~FMU2Wrapper();
    virtual fmi2Status setDebugLogging(fmi2Boolean loggingOn);

/*  independent variables and re-initialization of caching */
    virtual fmi2Status setupExperiment(fmi2Boolean toleranceDefined,
                                       fmi2Real tolerance,
                                       fmi2Real startTime,
                                       fmi2Boolean stopTimeDefined,
                                       fmi2Real stopTime);
    virtual fmi2Status setTime                (fmi2Real time);
    virtual fmi2Status setContinuousStates    (const fmi2Real x[], size_t nx);
    virtual fmi2Status completedIntegratorStep(fmi2Boolean *enterEventMode);

    virtual fmi2Status setReal   (const fmi2ValueReference vr[], size_t nvr,
                                  const fmi2Real    value[]);
    virtual fmi2Status setInteger(const fmi2ValueReference vr[], size_t nvr,
                                  const fmi2Integer value[]);
    virtual fmi2Status setBoolean(const fmi2ValueReference vr[], size_t nvr,
                                  const fmi2Boolean value[]);
    virtual fmi2Status setString (const fmi2ValueReference vr[], size_t nvr,
                                  const fmi2String  value[]);

/*  of the model equations */
    virtual fmi2Status initialize        ();
    virtual fmi2Status getDerivatives    (fmi2Real derivatives[]    , size_t nx);
    virtual fmi2Status getEventIndicators(fmi2Real eventIndicators[], size_t ni);
    virtual fmi2Status getReal   (const fmi2ValueReference vr[], size_t nvr,
                                  fmi2Real    value[]);
    virtual fmi2Status getInteger(const fmi2ValueReference vr[], size_t nvr,
                                  fmi2Integer value[]);
    virtual fmi2Status getBoolean(const fmi2ValueReference vr[], size_t nvr,
                                  fmi2Boolean value[]);
    virtual fmi2Status getString (const fmi2ValueReference vr[], size_t nvr,
                                  fmi2String  value[]);

    virtual fmi2Status eventUpdate               (fmi2EventInfo *eventInfo);
    virtual fmi2Status getContinuousStates       (fmi2Real states[], size_t nx);
    virtual fmi2Status getNominalContinuousStates(fmi2Real x_nominal[], size_t nx);
    virtual fmi2Status terminate                 ();
    virtual fmi2Status reset                     ();

private:
    FMU2GlobalSettings _global_settings;
    boost::shared_ptr<MODEL_IDENTIFIER> _model;
    std::vector<fmi2Real> _tmp_real_buffer;
    std::vector<fmi2Integer> _tmp_int_buffer;
    std::vector<fmi2Boolean> _tmp_bool_buffer;
    double _need_update;
    void updateModel();

    typedef enum {
      Instantiated       = 1 << 0,
      InitializationMode = 1 << 1,
      EventMode          = 1 << 2,
      ContinuousTimeMode = 1 << 3,
      Terminated         = 1 << 4,
      Error              = 1 << 5,
      Fatal              = 1 << 6
    } ModelState;

    fmi2String _instanceName;
    fmi2String _GUID;
    fmi2CallbackFunctions _functions;
    ModelState _state;
};
