package Modelica  "Modelica Standard Library - Version 3.2.1 (Build 3)"
  extends Modelica.Icons.Package;

  package Math  "Library of mathematical functions (e.g., sin, cos) and of functions operating on vectors and matrices"
    extends Modelica.Icons.Package;

    package Vectors  "Library of functions operating on vectors"
      extends Modelica.Icons.Package;

      function interpolate  "Interpolate in a vector"
        extends Modelica.Icons.Function;
        input Real[:] x "Abscissa table vector (strict monotonically increasing values required)";
        input Real[size(x, 1)] y "Ordinate table vector";
        input Real xi "Desired abscissa value";
        input Integer iLast = 1 "Index used in last search";
        output Real yi "Ordinate value corresponding to xi";
        output Integer iNew = 1 "xi is in the interval x[iNew] <= xi < x[iNew+1]";
      protected
        Integer i;
        Integer nx = size(x, 1);
        Real x1;
        Real x2;
        Real y1;
        Real y2;
      algorithm
        assert(nx > 0, "The table vectors must have at least 1 entry.");
        if nx == 1 then
          yi := y[1];
        else
          i := min(max(iLast, 1), nx - 1);
          if xi >= x[i] then
            while i < nx and xi >= x[i] loop
              i := i + 1;
            end while;
            i := i - 1;
          else
            while i > 1 and xi < x[i] loop
              i := i - 1;
            end while;
          end if;
          x1 := x[i];
          x2 := x[i + 1];
          y1 := y[i];
          y2 := y[i + 1];
          assert(x2 > x1, "Abscissa table vector values must be increasing");
          yi := y1 + (y2 - y1) * (xi - x1) / (x2 - x1);
          iNew := i;
        end if;
      end interpolate;
    end Vectors;
  end Math;

  package Icons  "Library of icons"
    extends Icons.Package;

    partial package ExamplesPackage  "Icon for packages containing runnable examples"
      extends Modelica.Icons.Package;
    end ExamplesPackage;

    partial package Package  "Icon for standard packages" end Package;

    partial package InterfacesPackage  "Icon for packages containing interfaces"
      extends Modelica.Icons.Package;
    end InterfacesPackage;

    partial package UtilitiesPackage  "Icon for utility packages"
      extends Modelica.Icons.Package;
    end UtilitiesPackage;

    partial function Function  "Icon for functions" end Function;
  end Icons;

  package SIunits  "Library of type and unit definitions based on SI units according to ISO 31-1992"
    extends Modelica.Icons.Package;
    type Period = Real(final quantity = "Time", final unit = "s");
  end SIunits;
  annotation(version = "3.2.1", versionBuild = 3, versionDate = "2013-08-14", dateModified = "2014-06-27 19:30:00Z");
end Modelica;

package Noise  "A library with additional noise modules compatible to the Modelica standard library"
  extends Modelica.Icons.Package;

  package Examples  "Examples for the Noise library"
    extends Modelica.Icons.ExamplesPackage;

    package RailIrregularities  "A package of examples demonstrating the shaping of rail irregularities"
      extends Modelica.Icons.ExamplesPackage;

      package MinimumPhaseInterpolator  "Provides a filter function for rail irregularities (minimum phase)"
        extends Interpolators.StepResponse(T = {0.0000000e+00, 1.0000000e-01, 2.0000000e-01, 3.0000000e-01, 4.0000000e-01, 5.0000000e-01, 6.0000000e-01, 7.0000000e-01, 8.0000000e-01, 9.0000000e-01, 1.0000000e+00, 1.1000000e+00, 1.2000000e+00, 1.3000000e+00, 1.4000000e+00, 1.5000000e+00, 1.6000000e+00, 1.7000000e+00, 1.8000000e+00, 1.9000000e+00, 2.0000000e+00, 2.1000000e+00, 2.2000000e+00, 2.3000000e+00, 2.4000000e+00, 2.5000000e+00, 2.6000000e+00, 2.7000000e+00, 2.8000000e+00, 2.9000000e+00, 3.0000000e+00, 3.1000000e+00, 3.2000000e+00, 3.3000000e+00, 3.4000000e+00, 3.5000000e+00, 3.6000000e+00, 3.7000000e+00, 3.8000000e+00, 3.9000000e+00, 4.0000000e+00, 4.1000000e+00, 4.2000000e+00, 4.3000000e+00, 4.4000000e+00, 4.5000000e+00, 4.6000000e+00, 4.7000000e+00, 4.8000000e+00, 4.9000000e+00, 5.0000000e+00, 5.1000000e+00, 5.2000000e+00, 5.3000000e+00, 5.4000000e+00, 5.5000000e+00, 5.6000000e+00, 5.7000000e+00, 5.8000000e+00, 5.9000000e+00, 6.0000000e+00, 6.1000000e+00, 6.2000000e+00, 6.3000000e+00, 6.4000000e+00, 6.5000000e+00, 6.6000000e+00, 6.7000000e+00, 6.8000000e+00, 6.9000000e+00, 7.0000000e+00, 7.1000000e+00, 7.2000000e+00, 7.3000000e+00, 7.4000000e+00, 7.5000000e+00, 7.6000000e+00, 7.7000000e+00, 7.8000000e+00, 7.9000000e+00, 8.0000000e+00, 8.1000000e+00, 8.2000000e+00, 8.3000000e+00, 8.4000000e+00, 8.5000000e+00, 8.6000000e+00, 8.7000000e+00, 8.8000000e+00, 8.9000000e+00, 9.0000000e+00, 9.1000000e+00, 9.2000000e+00, 9.3000000e+00, 9.4000000e+00, 9.5000000e+00, 9.6000000e+00, 9.7000000e+00, 9.8000000e+00, 9.9000000e+00, 1.0000000e+01, 1.0100000e+01, 1.0200000e+01, 1.0300000e+01, 1.0400000e+01, 1.0500000e+01, 1.0600000e+01, 1.0700000e+01, 1.0800000e+01, 1.0900000e+01, 1.1000000e+01, 1.1100000e+01, 1.1200000e+01, 1.1300000e+01, 1.1400000e+01, 1.1500000e+01, 1.1600000e+01, 1.1700000e+01, 1.1800000e+01, 1.1900000e+01, 1.2000000e+01, 1.2100000e+01, 1.2200000e+01, 1.2300000e+01, 1.2400000e+01, 1.2500000e+01, 1.2600000e+01, 1.2700000e+01, 1.2800000e+01, 1.2900000e+01, 1.3000000e+01, 1.3100000e+01, 1.3200000e+01, 1.3300000e+01, 1.3400000e+01, 1.3500000e+01, 1.3600000e+01, 1.3700000e+01, 1.3800000e+01, 1.3900000e+01, 1.4000000e+01, 1.4100000e+01, 1.4200000e+01, 1.4300000e+01, 1.4400000e+01, 1.4500000e+01, 1.4600000e+01, 1.4700000e+01, 1.4800000e+01, 1.4900000e+01, 1.5000000e+01, 1.5100000e+01, 1.5200000e+01, 1.5300000e+01, 1.5400000e+01, 1.5500000e+01, 1.5600000e+01, 1.5700000e+01, 1.5800000e+01, 1.5900000e+01, 1.6000000e+01, 1.6100000e+01, 1.6200000e+01, 1.6300000e+01, 1.6400000e+01, 1.6500000e+01, 1.6600000e+01, 1.6700000e+01, 1.6800000e+01, 1.6900000e+01, 1.7000000e+01, 1.7100000e+01, 1.7200000e+01, 1.7300000e+01, 1.7400000e+01, 1.7500000e+01, 1.7600000e+01, 1.7700000e+01, 1.7800000e+01, 1.7900000e+01, 1.8000000e+01, 1.8100000e+01, 1.8200000e+01, 1.8300000e+01, 1.8400000e+01, 1.8500000e+01, 1.8600000e+01, 1.8700000e+01, 1.8800000e+01, 1.8900000e+01, 1.9000000e+01, 1.9100000e+01, 1.9200000e+01, 1.9300000e+01, 1.9400000e+01, 1.9500000e+01, 1.9600000e+01, 1.9700000e+01, 1.9800000e+01, 1.9900000e+01, 2.0000000e+01, 2.0100000e+01, 2.0200000e+01, 2.0300000e+01, 2.0400000e+01, 2.0500000e+01, 2.0600000e+01, 2.0700000e+01, 2.0800000e+01, 2.0900000e+01, 2.1000000e+01, 2.1100000e+01, 2.1200000e+01, 2.1300000e+01, 2.1400000e+01, 2.1500000e+01, 2.1600000e+01, 2.1700000e+01, 2.1800000e+01, 2.1900000e+01, 2.2000000e+01, 2.2100000e+01, 2.2200000e+01, 2.2300000e+01, 2.2400000e+01, 2.2500000e+01, 2.2600000e+01, 2.2700000e+01, 2.2800000e+01, 2.2900000e+01, 2.3000000e+01, 2.3100000e+01, 2.3200000e+01, 2.3300000e+01, 2.3400000e+01, 2.3500000e+01, 2.3600000e+01, 2.3700000e+01, 2.3800000e+01, 2.3900000e+01, 2.4000000e+01, 2.4100000e+01, 2.4200000e+01, 2.4300000e+01, 2.4400000e+01, 2.4500000e+01, 2.4600000e+01, 2.4700000e+01, 2.4800000e+01, 2.4900000e+01, 2.5000000e+01, 2.5100000e+01, 2.5200000e+01, 2.5300000e+01, 2.5400000e+01, 2.5500000e+01, 2.5600000e+01, 2.5700000e+01, 2.5800000e+01, 2.5900000e+01, 2.6000000e+01, 2.6100000e+01, 2.6200000e+01, 2.6300000e+01, 2.6400000e+01, 2.6500000e+01, 2.6600000e+01, 2.6700000e+01, 2.6800000e+01, 2.6900000e+01, 2.7000000e+01, 2.7100000e+01, 2.7200000e+01, 2.7300000e+01, 2.7400000e+01, 2.7500000e+01, 2.7600000e+01, 2.7700000e+01, 2.7800000e+01, 2.7900000e+01, 2.8000000e+01, 2.8100000e+01, 2.8200000e+01, 2.8300000e+01, 2.8400000e+01, 2.8500000e+01, 2.8600000e+01, 2.8700000e+01, 2.8800000e+01, 2.8900000e+01, 2.9000000e+01, 2.9100000e+01, 2.9200000e+01, 2.9300000e+01, 2.9400000e+01, 2.9500000e+01, 2.9600000e+01, 2.9700000e+01, 2.9800000e+01, 2.9900000e+01, 3.0000000e+01, 3.0100000e+01, 3.0200000e+01, 3.0300000e+01, 3.0400000e+01, 3.0500000e+01, 3.0600000e+01, 3.0700000e+01, 3.0800000e+01, 3.0900000e+01, 3.1000000e+01, 3.1100000e+01, 3.1200000e+01, 3.1300000e+01, 3.1400000e+01, 3.1500000e+01, 3.1600000e+01, 3.1700000e+01, 3.1800000e+01, 3.1900000e+01, 3.2000000e+01, 3.2100000e+01, 3.2200000e+01, 3.2300000e+01, 3.2400000e+01, 3.2500000e+01, 3.2600000e+01, 3.2700000e+01, 3.2800000e+01, 3.2900000e+01, 3.3000000e+01, 3.3100000e+01, 3.3200000e+01, 3.3300000e+01, 3.3400000e+01, 3.3500000e+01, 3.3600000e+01, 3.3700000e+01, 3.3800000e+01, 3.3900000e+01, 3.4000000e+01, 3.4100000e+01, 3.4200000e+01, 3.4300000e+01, 3.4400000e+01, 3.4500000e+01, 3.4600000e+01, 3.4700000e+01, 3.4800000e+01, 3.4900000e+01, 3.5000000e+01, 3.5100000e+01, 3.5200000e+01, 3.5300000e+01, 3.5400000e+01, 3.5500000e+01, 3.5600000e+01, 3.5700000e+01, 3.5800000e+01, 3.5900000e+01, 3.6000000e+01, 3.6100000e+01, 3.6200000e+01, 3.6300000e+01, 3.6400000e+01, 3.6500000e+01, 3.6600000e+01, 3.6700000e+01, 3.6800000e+01, 3.6900000e+01, 3.7000000e+01, 3.7100000e+01, 3.7200000e+01, 3.7300000e+01, 3.7400000e+01, 3.7500000e+01, 3.7600000e+01, 3.7700000e+01, 3.7800000e+01, 3.7900000e+01, 3.8000000e+01, 3.8100000e+01, 3.8200000e+01, 3.8300000e+01, 3.8400000e+01, 3.8500000e+01, 3.8600000e+01, 3.8700000e+01, 3.8800000e+01, 3.8900000e+01, 3.9000000e+01, 3.9100000e+01, 3.9200000e+01, 3.9300000e+01, 3.9400000e+01, 3.9500000e+01, 3.9600000e+01, 3.9700000e+01, 3.9800000e+01, 3.9900000e+01, 4.0000000e+01, 4.0100000e+01, 4.0200000e+01, 4.0300000e+01, 4.0400000e+01, 4.0500000e+01, 4.0600000e+01, 4.0700000e+01, 4.0800000e+01, 4.0900000e+01, 4.1000000e+01, 4.1100000e+01, 4.1200000e+01, 4.1300000e+01, 4.1400000e+01, 4.1500000e+01, 4.1600000e+01, 4.1700000e+01, 4.1800000e+01, 4.1900000e+01, 4.2000000e+01, 4.2100000e+01, 4.2200000e+01, 4.2300000e+01, 4.2400000e+01, 4.2500000e+01, 4.2600000e+01, 4.2700000e+01, 4.2800000e+01, 4.2900000e+01, 4.3000000e+01, 4.3100000e+01, 4.3200000e+01, 4.3300000e+01, 4.3400000e+01, 4.3500000e+01, 4.3600000e+01, 4.3700000e+01, 4.3800000e+01, 4.3900000e+01, 4.4000000e+01, 4.4100000e+01, 4.4200000e+01, 4.4300000e+01, 4.4400000e+01, 4.4500000e+01, 4.4600000e+01, 4.4700000e+01, 4.4800000e+01, 4.4900000e+01, 4.5000000e+01, 4.5100000e+01, 4.5200000e+01, 4.5300000e+01, 4.5400000e+01, 4.5500000e+01, 4.5600000e+01, 4.5700000e+01, 4.5800000e+01, 4.5900000e+01, 4.6000000e+01, 4.6100000e+01, 4.6200000e+01, 4.6300000e+01, 4.6400000e+01, 4.6500000e+01, 4.6600000e+01, 4.6700000e+01, 4.6800000e+01, 4.6900000e+01, 4.7000000e+01, 4.7100000e+01, 4.7200000e+01, 4.7300000e+01, 4.7400000e+01, 4.7500000e+01, 4.7600000e+01, 4.7700000e+01, 4.7800000e+01, 4.7900000e+01, 4.8000000e+01, 4.8100000e+01, 4.8200000e+01, 4.8300000e+01, 4.8400000e+01, 4.8500000e+01, 4.8600000e+01, 4.8700000e+01, 4.8800000e+01, 4.8900000e+01, 4.9000000e+01, 4.9100000e+01, 4.9200000e+01, 4.9300000e+01, 4.9400000e+01, 4.9500000e+01, 4.9600000e+01, 4.9700000e+01, 4.9800000e+01, 4.9900000e+01, 5.0000000e+01, 5.0100000e+01, 5.0200000e+01, 5.0300000e+01, 5.0400000e+01, 5.0500000e+01, 5.0600000e+01, 5.0700000e+01, 5.0800000e+01, 5.0900000e+01, 5.1000000e+01, 5.1100000e+01, 5.1200000e+01, 5.1300000e+01, 5.1400000e+01, 5.1500000e+01, 5.1600000e+01, 5.1700000e+01, 5.1800000e+01, 5.1900000e+01, 5.2000000e+01, 5.2100000e+01, 5.2200000e+01, 5.2300000e+01, 5.2400000e+01, 5.2500000e+01, 5.2600000e+01, 5.2700000e+01, 5.2800000e+01, 5.2900000e+01, 5.3000000e+01, 5.3100000e+01, 5.3200000e+01, 5.3300000e+01, 5.3400000e+01, 5.3500000e+01, 5.3600000e+01, 5.3700000e+01, 5.3800000e+01, 5.3900000e+01, 5.4000000e+01, 5.4100000e+01, 5.4200000e+01, 5.4300000e+01, 5.4400000e+01, 5.4500000e+01, 5.4600000e+01, 5.4700000e+01, 5.4800000e+01, 5.4900000e+01, 5.5000000e+01, 5.5100000e+01, 5.5200000e+01, 5.5300000e+01, 5.5400000e+01, 5.5500000e+01, 5.5600000e+01, 5.5700000e+01, 5.5800000e+01, 5.5900000e+01, 5.6000000e+01, 5.6100000e+01, 5.6200000e+01, 5.6300000e+01, 5.6400000e+01, 5.6500000e+01, 5.6600000e+01, 5.6700000e+01, 5.6800000e+01, 5.6900000e+01, 5.7000000e+01, 5.7100000e+01, 5.7200000e+01, 5.7300000e+01, 5.7400000e+01, 5.7500000e+01, 5.7600000e+01, 5.7700000e+01, 5.7800000e+01, 5.7900000e+01, 5.8000000e+01, 5.8100000e+01, 5.8200000e+01, 5.8300000e+01, 5.8400000e+01, 5.8500000e+01, 5.8600000e+01, 5.8700000e+01, 5.8800000e+01, 5.8900000e+01, 5.9000000e+01, 5.9100000e+01, 5.9200000e+01, 5.9300000e+01, 5.9400000e+01, 5.9500000e+01, 5.9600000e+01, 5.9700000e+01, 5.9800000e+01, 5.9900000e+01, 6.0000000e+01, 6.0100000e+01, 6.0200000e+01, 6.0300000e+01, 6.0400000e+01, 6.0500000e+01, 6.0600000e+01, 6.0700000e+01, 6.0800000e+01, 6.0900000e+01, 6.1000000e+01, 6.1100000e+01, 6.1200000e+01, 6.1300000e+01, 6.1400000e+01, 6.1500000e+01, 6.1600000e+01, 6.1700000e+01, 6.1800000e+01, 6.1900000e+01, 6.2000000e+01, 6.2100000e+01, 6.2200000e+01, 6.2300000e+01, 6.2400000e+01, 6.2500000e+01, 6.2600000e+01, 6.2700000e+01, 6.2800000e+01, 6.2900000e+01, 6.3000000e+01, 6.3100000e+01, 6.3200000e+01, 6.3300000e+01, 6.3400000e+01, 6.3500000e+01, 6.3600000e+01, 6.3700000e+01, 6.3800000e+01, 6.3900000e+01, 6.4000000e+01, 6.4100000e+01, 6.4200000e+01, 6.4300000e+01, 6.4400000e+01, 6.4500000e+01, 6.4600000e+01, 6.4700000e+01, 6.4800000e+01, 6.4900000e+01, 6.5000000e+01, 6.5100000e+01, 6.5200000e+01, 6.5300000e+01, 6.5400000e+01, 6.5500000e+01, 6.5600000e+01, 6.5700000e+01, 6.5800000e+01, 6.5900000e+01, 6.6000000e+01, 6.6100000e+01, 6.6200000e+01, 6.6300000e+01, 6.6400000e+01, 6.6500000e+01, 6.6600000e+01, 6.6700000e+01, 6.6800000e+01, 6.6900000e+01, 6.7000000e+01, 6.7100000e+01, 6.7200000e+01, 6.7300000e+01, 6.7400000e+01, 6.7500000e+01, 6.7600000e+01, 6.7700000e+01, 6.7800000e+01, 6.7900000e+01, 6.8000000e+01, 6.8100000e+01, 6.8200000e+01, 6.8300000e+01, 6.8400000e+01, 6.8500000e+01, 6.8600000e+01, 6.8700000e+01, 6.8800000e+01, 6.8900000e+01, 6.9000000e+01, 6.9100000e+01, 6.9200000e+01, 6.9300000e+01, 6.9400000e+01, 6.9500000e+01, 6.9600000e+01, 6.9700000e+01, 6.9800000e+01, 6.9900000e+01, 7.0000000e+01, 7.0100000e+01, 7.0200000e+01, 7.0300000e+01, 7.0400000e+01, 7.0500000e+01, 7.0600000e+01, 7.0700000e+01, 7.0800000e+01, 7.0900000e+01, 7.1000000e+01, 7.1100000e+01, 7.1200000e+01, 7.1300000e+01, 7.1400000e+01, 7.1500000e+01, 7.1600000e+01, 7.1700000e+01, 7.1800000e+01, 7.1900000e+01, 7.2000000e+01, 7.2100000e+01, 7.2200000e+01, 7.2300000e+01, 7.2400000e+01, 7.2500000e+01, 7.2600000e+01, 7.2700000e+01, 7.2800000e+01, 7.2900000e+01, 7.3000000e+01, 7.3100000e+01, 7.3200000e+01, 7.3300000e+01, 7.3400000e+01, 7.3500000e+01, 7.3600000e+01, 7.3700000e+01, 7.3800000e+01, 7.3900000e+01, 7.4000000e+01, 7.4100000e+01, 7.4200000e+01, 7.4300000e+01, 7.4400000e+01, 7.4500000e+01, 7.4600000e+01, 7.4700000e+01, 7.4800000e+01, 7.4900000e+01, 7.5000000e+01, 7.5100000e+01, 7.5200000e+01, 7.5300000e+01, 7.5400000e+01, 7.5500000e+01, 7.5600000e+01, 7.5700000e+01, 7.5800000e+01, 7.5900000e+01, 7.6000000e+01, 7.6100000e+01, 7.6200000e+01, 7.6300000e+01, 7.6400000e+01, 7.6500000e+01, 7.6600000e+01, 7.6700000e+01, 7.6800000e+01, 7.6900000e+01, 7.7000000e+01, 7.7100000e+01, 7.7200000e+01, 7.7300000e+01, 7.7400000e+01, 7.7500000e+01, 7.7600000e+01, 7.7700000e+01, 7.7800000e+01, 7.7900000e+01, 7.8000000e+01, 7.8100000e+01, 7.8200000e+01, 7.8300000e+01, 7.8400000e+01, 7.8500000e+01, 7.8600000e+01, 7.8700000e+01, 7.8800000e+01, 7.8900000e+01, 7.9000000e+01, 7.9100000e+01, 7.9200000e+01, 7.9300000e+01, 7.9400000e+01, 7.9500000e+01, 7.9600000e+01, 7.9700000e+01, 7.9800000e+01, 7.9900000e+01, 8.0000000e+01, 8.0100000e+01, 8.0200000e+01, 8.0300000e+01, 8.0400000e+01, 8.0500000e+01, 8.0600000e+01, 8.0700000e+01, 8.0800000e+01, 8.0900000e+01, 8.1000000e+01, 8.1100000e+01, 8.1200000e+01, 8.1300000e+01, 8.1400000e+01, 8.1500000e+01, 8.1600000e+01, 8.1700000e+01, 8.1800000e+01, 8.1900000e+01, 8.2000000e+01, 8.2100000e+01, 8.2200000e+01, 8.2300000e+01, 8.2400000e+01, 8.2500000e+01, 8.2600000e+01, 8.2700000e+01, 8.2800000e+01, 8.2900000e+01, 8.3000000e+01, 8.3100000e+01, 8.3200000e+01, 8.3300000e+01, 8.3400000e+01, 8.3500000e+01, 8.3600000e+01, 8.3700000e+01, 8.3800000e+01, 8.3900000e+01, 8.4000000e+01, 8.4100000e+01, 8.4200000e+01, 8.4300000e+01, 8.4400000e+01, 8.4500000e+01, 8.4600000e+01, 8.4700000e+01, 8.4800000e+01, 8.4900000e+01, 8.5000000e+01, 8.5100000e+01}, step = {0.0000000e+00, 5.4748721e-05, 1.3669502e-04, 2.3594576e-04, 3.4737509e-04, 4.6765124e-04, 5.9429827e-04, 7.2548962e-04, 8.5980984e-04, 9.9616472e-04, 1.1337263e-03, 1.2718827e-03, 1.4101993e-03, 1.5483796e-03, 1.6862062e-03, 1.8235176e-03, 1.9602063e-03, 2.0961932e-03, 2.2313923e-03, 2.3657151e-03, 2.4991084e-03, 2.6315732e-03, 2.7631398e-03, 2.8938253e-03, 3.0236104e-03, 3.1524528e-03, 3.2803213e-03, 3.4072178e-03, 3.5331704e-03, 3.6582123e-03, 3.7823648e-03, 3.9056322e-03, 4.0280049e-03, 4.1494689e-03, 4.2700163e-03, 4.3896486e-03, 4.5083742e-03, 4.6262042e-03, 4.7431516e-03, 4.8592323e-03, 4.9744653e-03, 5.0888668e-03, 5.2024432e-03, 5.3151898e-03, 5.4270976e-03, 5.5381634e-03, 5.6483930e-03, 5.7577981e-03, 5.8663889e-03, 5.9741707e-03, 6.0811443e-03, 6.1873108e-03, 6.2926773e-03, 6.3972578e-03, 6.5010701e-03, 6.6041311e-03, 6.7064519e-03, 6.8080372e-03, 6.9088886e-03, 7.0090072e-03, 7.1083938e-03, 7.2070485e-03, 7.3049708e-03, 7.4021618e-03, 7.4986260e-03, 7.5943713e-03, 7.6894064e-03, 7.7837381e-03, 7.8773709e-03, 7.9703081e-03, 8.0625551e-03, 8.1541212e-03, 8.2450185e-03, 8.3352594e-03, 8.4248527e-03, 8.5138028e-03, 8.6021107e-03, 8.6897769e-03, 8.7768033e-03, 8.8631928e-03, 8.9489484e-03, 9.0340718e-03, 9.1185642e-03, 9.2024273e-03, 9.2856639e-03, 9.3682774e-03, 9.4502713e-03, 9.5316487e-03, 9.6124134e-03, 9.6925709e-03, 9.7721279e-03, 9.8510922e-03, 9.9294708e-03, 1.0007269e-02, 1.0084489e-02, 1.0161136e-02, 1.0237215e-02, 1.0312734e-02, 1.0387700e-02, 1.0462120e-02, 1.0536000e-02, 1.0609343e-02, 1.0682152e-02, 1.0754428e-02, 1.0826176e-02, 1.0897397e-02, 1.0968095e-02, 1.1038271e-02, 1.1107927e-02, 1.1177066e-02, 1.1245690e-02, 1.1313801e-02, 1.1381403e-02, 1.1448496e-02, 1.1515084e-02, 1.1581171e-02, 1.1646761e-02, 1.1711861e-02, 1.1776475e-02, 1.1840605e-02, 1.1904254e-02, 1.1967426e-02, 1.2030126e-02, 1.2092357e-02, 1.2154126e-02, 1.2215436e-02, 1.2276290e-02, 1.2336692e-02, 1.2396647e-02, 1.2456158e-02, 1.2515230e-02, 1.2573868e-02, 1.2632075e-02, 1.2689856e-02, 1.2747215e-02, 1.2804155e-02, 1.2860681e-02, 1.2916795e-02, 1.2972499e-02, 1.3027794e-02, 1.3082683e-02, 1.3137169e-02, 1.3191255e-02, 1.3244944e-02, 1.3298237e-02, 1.3351136e-02, 1.3403643e-02, 1.3455760e-02, 1.3507491e-02, 1.3558838e-02, 1.3609805e-02, 1.3660393e-02, 1.3710606e-02, 1.3760445e-02, 1.3809915e-02, 1.3859017e-02, 1.3907756e-02, 1.3956133e-02, 1.4004152e-02, 1.4051816e-02, 1.4099127e-02, 1.4146090e-02, 1.4192707e-02, 1.4238980e-02, 1.4284911e-02, 1.4330503e-02, 1.4375758e-02, 1.4420681e-02, 1.4465272e-02, 1.4509535e-02, 1.4553472e-02, 1.4597085e-02, 1.4640375e-02, 1.4683346e-02, 1.4726001e-02, 1.4768342e-02, 1.4810372e-02, 1.4852092e-02, 1.4893506e-02, 1.4934615e-02, 1.4975423e-02, 1.5015931e-02, 1.5056140e-02, 1.5096053e-02, 1.5135670e-02, 1.5174994e-02, 1.5214026e-02, 1.5252769e-02, 1.5291222e-02, 1.5329388e-02, 1.5367268e-02, 1.5404864e-02, 1.5442177e-02, 1.5479210e-02, 1.5515965e-02, 1.5552443e-02, 1.5588645e-02, 1.5624574e-02, 1.5660232e-02, 1.5695621e-02, 1.5730742e-02, 1.5765599e-02, 1.5800193e-02, 1.5834526e-02, 1.5868600e-02, 1.5902418e-02, 1.5935983e-02, 1.5969296e-02, 1.6002359e-02, 1.6035175e-02, 1.6067747e-02, 1.6100077e-02, 1.6132168e-02, 1.6164021e-02, 1.6195638e-02, 1.6227022e-02, 1.6258175e-02, 1.6289099e-02, 1.6319796e-02, 1.6350269e-02, 1.6380518e-02, 1.6410546e-02, 1.6440355e-02, 1.6469946e-02, 1.6499321e-02, 1.6528483e-02, 1.6557432e-02, 1.6586170e-02, 1.6614699e-02, 1.6643020e-02, 1.6671134e-02, 1.6699044e-02, 1.6726750e-02, 1.6754254e-02, 1.6781558e-02, 1.6808662e-02, 1.6835568e-02, 1.6862279e-02, 1.6888795e-02, 1.6915117e-02, 1.6941246e-02, 1.6967184e-02, 1.6992932e-02, 1.7018490e-02, 1.7043861e-02, 1.7069045e-02, 1.7094042e-02, 1.7118853e-02, 1.7143479e-02, 1.7167922e-02, 1.7192182e-02, 1.7216261e-02, 1.7240158e-02, 1.7263875e-02, 1.7287413e-02, 1.7310773e-02, 1.7333956e-02, 1.7356964e-02, 1.7379797e-02, 1.7402457e-02, 1.7424945e-02, 1.7447262e-02, 1.7469409e-02, 1.7491389e-02, 1.7513201e-02, 1.7534847e-02, 1.7556329e-02, 1.7577647e-02, 1.7598805e-02, 1.7619802e-02, 1.7640640e-02, 1.7661322e-02, 1.7681847e-02, 1.7702217e-02, 1.7722435e-02, 1.7742501e-02, 1.7762417e-02, 1.7782184e-02, 1.7801803e-02, 1.7821277e-02, 1.7840605e-02, 1.7859791e-02, 1.7878835e-02, 1.7897738e-02, 1.7916501e-02, 1.7935127e-02, 1.7953615e-02, 1.7971968e-02, 1.7990186e-02, 1.8008271e-02, 1.8026223e-02, 1.8044043e-02, 1.8061733e-02, 1.8079293e-02, 1.8096725e-02, 1.8114028e-02, 1.8131205e-02, 1.8148256e-02, 1.8165181e-02, 1.8181982e-02, 1.8198659e-02, 1.8215213e-02, 1.8231645e-02, 1.8247956e-02, 1.8264146e-02, 1.8280216e-02, 1.8296167e-02, 1.8311999e-02, 1.8327713e-02, 1.8343310e-02, 1.8358791e-02, 1.8374155e-02, 1.8389405e-02, 1.8404541e-02, 1.8419564e-02, 1.8434475e-02, 1.8449273e-02, 1.8463961e-02, 1.8478540e-02, 1.8493009e-02, 1.8507370e-02, 1.8521624e-02, 1.8535772e-02, 1.8549813e-02, 1.8563750e-02, 1.8577583e-02, 1.8591312e-02, 1.8604939e-02, 1.8618464e-02, 1.8631888e-02, 1.8645211e-02, 1.8658435e-02, 1.8671561e-02, 1.8684588e-02, 1.8697518e-02, 1.8710350e-02, 1.8723087e-02, 1.8735729e-02, 1.8748277e-02, 1.8760731e-02, 1.8773092e-02, 1.8785361e-02, 1.8797538e-02, 1.8809625e-02, 1.8821622e-02, 1.8833529e-02, 1.8845348e-02, 1.8857080e-02, 1.8868724e-02, 1.8880281e-02, 1.8891753e-02, 1.8903140e-02, 1.8914442e-02, 1.8925660e-02, 1.8936794e-02, 1.8947845e-02, 1.8958815e-02, 1.8969702e-02, 1.8980508e-02, 1.8991234e-02, 1.9001879e-02, 1.9012445e-02, 1.9022932e-02, 1.9033340e-02, 1.9043670e-02, 1.9053922e-02, 1.9064098e-02, 1.9074196e-02, 1.9084218e-02, 1.9094164e-02, 1.9104035e-02, 1.9113831e-02, 1.9123553e-02, 1.9133200e-02, 1.9142774e-02, 1.9152275e-02, 1.9161703e-02, 1.9171059e-02, 1.9180344e-02, 1.9189557e-02, 1.9198700e-02, 1.9207772e-02, 1.9216775e-02, 1.9225709e-02, 1.9234573e-02, 1.9243370e-02, 1.9252099e-02, 1.9260760e-02, 1.9269355e-02, 1.9277884e-02, 1.9286347e-02, 1.9294745e-02, 1.9303077e-02, 1.9311346e-02, 1.9319552e-02, 1.9327694e-02, 1.9335774e-02, 1.9343792e-02, 1.9351749e-02, 1.9359645e-02, 1.9367481e-02, 1.9375257e-02, 1.9382974e-02, 1.9390633e-02, 1.9398234e-02, 1.9405777e-02, 1.9413264e-02, 1.9420695e-02, 1.9428070e-02, 1.9435389e-02, 1.9442654e-02, 1.9449865e-02, 1.9457022e-02, 1.9464126e-02, 1.9471177e-02, 1.9478176e-02, 1.9485123e-02, 1.9492019e-02, 1.9498864e-02, 1.9505659e-02, 1.9512404e-02, 1.9519099e-02, 1.9525745e-02, 1.9532343e-02, 1.9538893e-02, 1.9545395e-02, 1.9551849e-02, 1.9558257e-02, 1.9564617e-02, 1.9570932e-02, 1.9577200e-02, 1.9583422e-02, 1.9589599e-02, 1.9595731e-02, 1.9601817e-02, 1.9607859e-02, 1.9613856e-02, 1.9619809e-02, 1.9625718e-02, 1.9631583e-02, 1.9637404e-02, 1.9643182e-02, 1.9648916e-02, 1.9654607e-02, 1.9660255e-02, 1.9665861e-02, 1.9671424e-02, 1.9676944e-02, 1.9682422e-02, 1.9687859e-02, 1.9693253e-02, 1.9698607e-02, 1.9703919e-02, 1.9709190e-02, 1.9714420e-02, 1.9719610e-02, 1.9724759e-02, 1.9729869e-02, 1.9734939e-02, 1.9739970e-02, 1.9744962e-02, 1.9749915e-02, 1.9754830e-02, 1.9759707e-02, 1.9764546e-02, 1.9769347e-02, 1.9774112e-02, 1.9778840e-02, 1.9783531e-02, 1.9788186e-02, 1.9792805e-02, 1.9797389e-02, 1.9801938e-02, 1.9806451e-02, 1.9810930e-02, 1.9815374e-02, 1.9819785e-02, 1.9824161e-02, 1.9828504e-02, 1.9832814e-02, 1.9837090e-02, 1.9841334e-02, 1.9845546e-02, 1.9849725e-02, 1.9853872e-02, 1.9857988e-02, 1.9862072e-02, 1.9866124e-02, 1.9870146e-02, 1.9874137e-02, 1.9878097e-02, 1.9882026e-02, 1.9885925e-02, 1.9889794e-02, 1.9893632e-02, 1.9897441e-02, 1.9901220e-02, 1.9904970e-02, 1.9908690e-02, 1.9912381e-02, 1.9916043e-02, 1.9919676e-02, 1.9923280e-02, 1.9926856e-02, 1.9930403e-02, 1.9933923e-02, 1.9937414e-02, 1.9940877e-02, 1.9944313e-02, 1.9947722e-02, 1.9951103e-02, 1.9954457e-02, 1.9957784e-02, 1.9961085e-02, 1.9964359e-02, 1.9967607e-02, 1.9970829e-02, 1.9974025e-02, 1.9977195e-02, 1.9980340e-02, 1.9983460e-02, 1.9986555e-02, 1.9989625e-02, 1.9992671e-02, 1.9995693e-02, 1.9998690e-02, 2.0001664e-02, 2.0004614e-02, 2.0007541e-02, 2.0010446e-02, 2.0013327e-02, 2.0016186e-02, 2.0019023e-02, 2.0021838e-02, 2.0024631e-02, 2.0027403e-02, 2.0030153e-02, 2.0032882e-02, 2.0035591e-02, 2.0038279e-02, 2.0040948e-02, 2.0043596e-02, 2.0046224e-02, 2.0048832e-02, 2.0051422e-02, 2.0053992e-02, 2.0056543e-02, 2.0059075e-02, 2.0061588e-02, 2.0064083e-02, 2.0066560e-02, 2.0069018e-02, 2.0071459e-02, 2.0073881e-02, 2.0076286e-02, 2.0078673e-02, 2.0081043e-02, 2.0083395e-02, 2.0085730e-02, 2.0088048e-02, 2.0090348e-02, 2.0092632e-02, 2.0094899e-02, 2.0097150e-02, 2.0099384e-02, 2.0101602e-02, 2.0103803e-02, 2.0105988e-02, 2.0108157e-02, 2.0110311e-02, 2.0112448e-02, 2.0114570e-02, 2.0116676e-02, 2.0118767e-02, 2.0120842e-02, 2.0122902e-02, 2.0124947e-02, 2.0126977e-02, 2.0128991e-02, 2.0130991e-02, 2.0132976e-02, 2.0134946e-02, 2.0136902e-02, 2.0138843e-02, 2.0140770e-02, 2.0142683e-02, 2.0144581e-02, 2.0146465e-02, 2.0148335e-02, 2.0150192e-02, 2.0152034e-02, 2.0153863e-02, 2.0155679e-02, 2.0157481e-02, 2.0159269e-02, 2.0161044e-02, 2.0162806e-02, 2.0164555e-02, 2.0166292e-02, 2.0168015e-02, 2.0169725e-02, 2.0171423e-02, 2.0173108e-02, 2.0174781e-02, 2.0176441e-02, 2.0178089e-02, 2.0179725e-02, 2.0181348e-02, 2.0182960e-02, 2.0184560e-02, 2.0186148e-02, 2.0187724e-02, 2.0189288e-02, 2.0190841e-02, 2.0192382e-02, 2.0193912e-02, 2.0195430e-02, 2.0196937e-02, 2.0198433e-02, 2.0199917e-02, 2.0201390e-02, 2.0202852e-02, 2.0204303e-02, 2.0205743e-02, 2.0207171e-02, 2.0208589e-02, 2.0209995e-02, 2.0211391e-02, 2.0212775e-02, 2.0214149e-02, 2.0215511e-02, 2.0216863e-02, 2.0218204e-02, 2.0219533e-02, 2.0220852e-02, 2.0222161e-02, 2.0223458e-02, 2.0224744e-02, 2.0226020e-02, 2.0227285e-02, 2.0228539e-02, 2.0229782e-02, 2.0231015e-02, 2.0232237e-02, 2.0233449e-02, 2.0234650e-02, 2.0235841e-02, 2.0237021e-02, 2.0238192e-02, 2.0239351e-02, 2.0240501e-02, 2.0241641e-02, 2.0242770e-02, 2.0243890e-02, 2.0245000e-02, 2.0246100e-02, 2.0247191e-02, 2.0248271e-02, 2.0249343e-02, 2.0250404e-02, 2.0251457e-02, 2.0252500e-02, 2.0253534e-02, 2.0254559e-02, 2.0255575e-02, 2.0256582e-02, 2.0257580e-02, 2.0258570e-02, 2.0259551e-02, 2.0260523e-02, 2.0261487e-02, 2.0262443e-02, 2.0263391e-02, 2.0264330e-02, 2.0265261e-02, 2.0266185e-02, 2.0267100e-02, 2.0268008e-02, 2.0268908e-02, 2.0269800e-02, 2.0270685e-02, 2.0271562e-02, 2.0272431e-02, 2.0273293e-02, 2.0274148e-02, 2.0274996e-02, 2.0275836e-02, 2.0276669e-02, 2.0277495e-02, 2.0278313e-02, 2.0279125e-02, 2.0279929e-02, 2.0280727e-02, 2.0281517e-02, 2.0282301e-02, 2.0283077e-02, 2.0283847e-02, 2.0284609e-02, 2.0285365e-02, 2.0286114e-02, 2.0286856e-02, 2.0287592e-02, 2.0288320e-02, 2.0289042e-02, 2.0289758e-02, 2.0290466e-02, 2.0291168e-02, 2.0291864e-02, 2.0292553e-02, 2.0293236e-02, 2.0293912e-02, 2.0294582e-02, 2.0295246e-02, 2.0295903e-02, 2.0296554e-02, 2.0297200e-02, 2.0297839e-02, 2.0298472e-02, 2.0299100e-02, 2.0299721e-02, 2.0300337e-02, 2.0300947e-02, 2.0301552e-02, 2.0302151e-02, 2.0302745e-02, 2.0303333e-02, 2.0303916e-02, 2.0304494e-02, 2.0305066e-02, 2.0305634e-02, 2.0306196e-02, 2.0306754e-02, 2.0307307e-02, 2.0307855e-02, 2.0308398e-02, 2.0308936e-02, 2.0309470e-02, 2.0309999e-02, 2.0310524e-02, 2.0311044e-02, 2.0311560e-02, 2.0312071e-02, 2.0312578e-02, 2.0313081e-02, 2.0313579e-02, 2.0314073e-02, 2.0314562e-02, 2.0315048e-02, 2.0315529e-02, 2.0316006e-02, 2.0316479e-02, 2.0316948e-02, 2.0317413e-02, 2.0317874e-02, 2.0318331e-02, 2.0318783e-02, 2.0319232e-02, 2.0319677e-02, 2.0320118e-02, 2.0320555e-02, 2.0320988e-02, 2.0321418e-02, 2.0321843e-02, 2.0322265e-02, 2.0322683e-02, 2.0323097e-02, 2.0323507e-02, 2.0323914e-02, 2.0324317e-02, 2.0324716e-02, 2.0325111e-02, 2.0325503e-02, 2.0325891e-02, 2.0326275e-02, 2.0326656e-02, 2.0327033e-02, 2.0327406e-02, 2.0327776e-02, 2.0328142e-02, 2.0328505e-02, 2.0328864e-02, 2.0329220e-02, 2.0329572e-02, 2.0329921e-02, 2.0330266e-02, 2.0330608e-02, 2.0330947e-02, 2.0331282e-02, 2.0331614e-02, 2.0331942e-02, 2.0332267e-02, 2.0332589e-02, 2.0332908e-02, 2.0333224e-02, 2.0333536e-02, 2.0333845e-02, 2.0334151e-02, 2.0334454e-02, 2.0334753e-02, 2.0335050e-02, 2.0335343e-02, 2.0335634e-02, 2.0335921e-02, 2.0336205e-02, 2.0336486e-02, 2.0336765e-02, 2.0337040e-02, 2.0337312e-02, 2.0337581e-02, 2.0337847e-02, 2.0338110e-02, 2.0338370e-02, 2.0338627e-02, 2.0338881e-02, 2.0339132e-02, 2.0339379e-02, 2.0339624e-02, 2.0339866e-02, 2.0340105e-02, 2.0340341e-02, 2.0340573e-02, 2.0340803e-02, 2.0341029e-02, 2.0341253e-02, 2.0341473e-02, 2.0341691e-02, 2.0341905e-02, 2.0342116e-02, 2.0342324e-02, 2.0342528e-02, 2.0342730e-02, 2.0342929e-02, 2.0343124e-02, 2.0343316e-02, 2.0343506e-02, 2.0343692e-02, 2.0343875e-02, 2.0344054e-02, 2.0344231e-02, 2.0344405e-02, 2.0344575e-02, 2.0344743e-02, 2.0344907e-02, 2.0345068e-02, 2.0345226e-02, 2.0345382e-02, 2.0345534e-02, 2.0345683e-02, 2.0345829e-02, 2.0345972e-02, 2.0346112e-02, 2.0346249e-02}, continuous = true, nFuture = 1, nPast = 900);
      end MinimumPhaseInterpolator;
    end RailIrregularities;
  end Examples;

  package Interpolators  "Additional interpolation packages"
    extends Modelica.Icons.Package;

    package FirstOrder  "A linear first order filter (k / (Ts + 1))"
      extends Utilities.Interfaces.PartialInterpolatorWithKernel(final continuous = true, final nFuture = 0, nPast = 5, varianceFactor = 0.900004539919624, suggestedSamplePeriod = 0.1);
      constant Real k = 1 "Gain";
      constant Modelica.SIunits.Period T = 0.01 "Time Constant";

      redeclare function extends kernel  "Kernel for first-order ideal low pass (k / (Ts + 1))"
      protected
        Real a;
        Real b;
      algorithm
        b := k / T;
        a := 1 / T;
        h := if t < 0 then 0 else b / a * (1 - exp(-a * t));
        annotation(Inline = true);
      end kernel;

      redeclare function extends der_kernel_offset
      algorithm
        h := 1;
      end der_kernel_offset;

      redeclare function extends interpolate   annotation(Inline = true, derivative(order = 1) = der_interpolate); end interpolate;
    end FirstOrder;

    package StepResponse  "A generic filter using a tabulated step response"
      extends Utilities.Interfaces.PartialInterpolatorWithKernel(continuous = true, smoothness = 0, suggestedSamplePeriod = (max(T) - min(T)) / (size(T, 1) - 1), nPast = integer(max(T) / suggestedSamplePeriod), nFuture = -integer(min(T) / suggestedSamplePeriod), varianceFactor = trapz(T, kernelVariance(T)) / suggestedSamplePeriod);
      constant Real[:] T = linspace(0, 0.2, 101) "Time vector";
      constant Real[:] step = FirstOrder.kernel(T) "Step response data";
      constant Real[:] dstep = cat(1, {(step[2] - step[1]) / (T[2] - T[1])}, (step[3:size(T, 1)] - step[1:size(T, 1) - 2]) ./ (T[3:size(T, 1)] - T[1:size(T, 1) - 2]), {(step[end] - step[end - 1]) / (T[end] - T[end - 1])});

      redeclare function extends kernel  "Kernel for a tabulated step response"
      algorithm
        if t <= T[1] then
          h := step[1];
        elseif t >= T[end] then
          h := step[end];
        else
          h := Modelica.Math.Vectors.interpolate(T, step, t);
        end if;
        annotation(Inline = true);
      end kernel;

      function kernelVariance  "Function to be integrated for the varianceFactor"
        extends Utilities.Interfaces.partialKernel;
      algorithm
        h := (kernel(t) - kernel(t - suggestedSamplePeriod)) ^ 2;
      end kernelVariance;

      redeclare function extends der_kernel_offset  "Derivative of kernel for a tabulated step response"
      algorithm
        if t <= T[1] then
          h := 0;
        elseif t >= T[end] then
          h := 0;
        else
          h := Modelica.Math.Vectors.interpolate(T, dstep, t);
        end if;
        annotation(Inline = true);
      end der_kernel_offset;

      function trapz  "Integral of a time signal using trapezium rule"
        input Real[:] T "Time vector";
        input Real[size(T, 1)] X "Values vector";
        output Real Y "Integral";
      algorithm
        Y := 0.5 .* sum((X[2:end] + X[1:end - 1]) .* (T[2:end] - T[1:end - 1]));
      end trapz;
    end StepResponse;

    package Utilities  "Utilities for Interpolators"
      extends Modelica.Icons.UtilitiesPackage;

      package Interfaces  "Interfaces package"
        extends Modelica.Icons.InterfacesPackage;

        partial package PartialInterpolator  "Interfaces of an interpolator in a buffer of random numbers"
          extends Modelica.Icons.Package;
          constant Boolean continuous = false "=true if interpolation is continuous, otherwise discontinuous";
          constant Integer nFuture(min = 0) = 0 "Number of buffer values required in the future (=0 for causal filters)";
          constant Integer nPast(min = 0) = 0 "Number of buffer values required in the past";
          constant Real varianceFactor = 1 "The factor by which the variance will be scaled, if this interpolation is used";
          constant Integer smoothness = 0 "The smoothness of the interpolation. =0: continuous, =1: continuous and differentiable, ...";

          replaceable partial function interpolate  "Interface of a function to interpolate in a buffer of random numbers"
            extends Modelica.Icons.Function;
            input Real[:] buffer "Buffer of random numbers";
            input Real offset "Offset from buffer start (0..size(buffer)-1";
            input Real samplePeriod = 1 "The sample period of the noise buffer";
            output Real y "Interpolated value at position offset";
          protected
            Integer nBuffer = size(buffer, 1) "Size of the buffer";
          end interpolate;
        end PartialInterpolator;

        partial package PartialInterpolatorWithKernel  "Generic interpolator interface providing a kernel function"
          extends PartialInterpolator;
          constant Real suggestedSamplePeriod = 0 "The appropriate sample period for this filter";

          redeclare replaceable function extends interpolate  "Interpolates the buffer using a replaceable kernel"
          protected
            Real coefficient "The intermediate container for the kernel evaluations";
          algorithm
            assert(offset >= nPast and offset < nBuffer - nFuture, "offset out of range (offset=" + String(offset) + ", nBuffer=" + String(nBuffer) + ")");
            y := 0;
            for i in (-nPast):nFuture loop
              coefficient := (-kernel(t = (mod(offset, 1) - i - 1) * samplePeriod)) + kernel(t = (mod(offset, 1) - i + 0) * samplePeriod);
              y := y + buffer[integer(offset) + i + 1] * coefficient;
            end for;
            annotation(derivative(order = 1) = der_interpolate, Inline = true);
          end interpolate;

          function der_interpolate  "Interpolates the buffer using a replaceable kernel"
            extends Modelica.Icons.Function;
            input Real[:] buffer "Buffer of random numbers";
            input Real offset "Offset from buffer start (0..size(buffer)-1";
            input Real samplePeriod = 1 "The sample period of the noise buffer";
            input Real[size(buffer, 1)] der_buffer "Derivatives of buffer values";
            input Real der_offset "Derivative of offset value";
            input Real der_samplePeriod = 1 "The sample period of the noise buffer";
            output Real der_y "Interpolated value at position offset";
          algorithm
            der_y := 0;
            for i in (-nPast):nFuture loop
              der_y := der_y + ((-der_kernel_offset(t = (mod(offset, 1) - i - 1) * samplePeriod)) + der_kernel_offset(t = (mod(offset, 1) - i + 0) * samplePeriod)) * buffer[integer(offset) + i + 1] * der_offset * samplePeriod + ((-kernel(t = (mod(offset, 1) - i - 1) * samplePeriod)) + kernel(t = (mod(offset, 1) - i + 0) * samplePeriod)) * der_buffer[integer(offset) + i + 1];
            end for;
          end der_interpolate;

          replaceable partial function kernel  "Kernel for interpolation"
            extends partialKernel;
          end kernel;

          replaceable partial function der_kernel_offset  "Partial derivative of the kernel with respect to the offset"
            extends partialKernel;
          end der_kernel_offset;
        end PartialInterpolatorWithKernel;

        function partialKernel  "Interface for convolution kernels"
          input Real t "The (scaled) time for sampling period=1";
          output Real h "The impulse response of the convolution filter";
        end partialKernel;
      end Interfaces;
    end Utilities;
  end Interpolators;
  annotation(version = "1.0-Beta.1", versionDate = "2015-06-22", versionBuild = 1);
end Noise;

model M
  Noise.Examples.RailIrregularities.MinimumPhaseInterpolator.trapz trapz;
end M;
