within ;
package Modelica_AddOn "Modelica AddOns planned for 3.2.2"
extends Modelica.Icons.Package;

  package UsersGuide "User's Guide"
  extends Modelica.Icons.Information;
    class Contact "Contact"
      extends Modelica.Icons.Contact;
      annotation (Documentation(info="<html>
<h4>Contact</h4>

<p>
<img src=\"modelica://EMachines/Resources/Images/EDrives.png\"/>
</p>

<p>Visit our homepage at <a href=\"http://www.edrives.eu\">http://www.edrives.eu</a>.

<blockquote>
Anton Haumer<br>
email: <a HREF=\"mailto:anton.haumer@edrives.eu\">anton.haumer@edrives.eu</a><br>
</blockquote>

<blockquote>
  Dr. Christian Kral<br>
  email: <a href=\"mailto:christian.kral@edrives.eu\">christian.kral@edrives.eu</a>
</blockquote>
</html>"));
    end Contact;

    class ReleaseNotes "Release Notes"
      extends Modelica.Icons.ReleaseNotes;
      annotation (Documentation(info="<html>
<h5>Version 3.2.2, 2014-12-11</h5>
<ul>
<li>Initial version based on MSL <u><b>3.2.1</b></u></li>
<li>All relevant changes and additions to MSL 3.2.2 (compared with 3.2.1)</li>
</ul>
</html>"));
    end ReleaseNotes;
  annotation (DocumentationClass=true, Documentation(info="<html>
<p>
This library includes all Modelica classes of the future <b>MSL 3.2.2</b> which are not yet included in MSL 3.2.1 and which are required for EDrives 0.X.X and EMachines 0.X.X. After the release of EDrives 1.0.0 and EMachines 1.0.0 package Modelica_AddOn will become obsolete, since EMachines and EDrives will then depend on MSL 3.2.2.
</p>
<p>
Components which might ot be included in MSL 3.2.2 but later:
<ul>
<li>Electrical.QuasiStatic.MulitPhase.Blocks.QuasiRMS</li>
<li>Electrical.QuasiStatic.MulitPhase.Sensor.CurrentQuasiRMSSensor</li>
<li>Electrical.QuasiStatic.MulitPhase.Sensor.VoltageQuasiRMSSensor</li>
</ul>
</p>
</html>"));
  end UsersGuide;

  package Blocks "Blocks"
  extends Modelica.Icons.Package;

    package Math "Mathematical blocks"
    extends Modelica.Icons.Package;

      block Mean "Calculate mean over period 1/f"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Modelica.SIunits.Frequency f(start=50) "Base frequency";
        parameter Real x0=0 "Start value of integrator state";
        parameter Boolean yGreaterOrEqualZero=false "=true, if output y is guaranteed to be >= 0 for the exact solution"
          annotation (Evaluate=true, Dialog(tab="Advanced"));
      protected
        parameter Modelica.SIunits.Time t0(fixed=false) "Start time of simulation";
        Real x "Integrator state";
      initial equation
        t0 = time;
        x = x0;
        y = 0;
      equation
        der(x) = u;
        when sample(t0 + 1/f, 1/f) then
          y = if not yGreaterOrEqualZero then f*pre(x) else max(0.0, f*pre(x));
          reinit(x, 0);
        end when;
        annotation (Documentation(info="<html>
<p>
This block calculates the mean of the input signal u over the given period 1/f:
</p>
<pre>
1 T
- &int; u(t) dt
T 0
</pre>
<p>
Note: The output is updated after each period defined by 1/f.
</p>

<p>
If parameter <b>yGreaterOrEqualZero</b> in the Advanced tab is <b>true</b> (default = <b>false</b>),
then the modeller provides the information that the mean of the input signal is guaranteed
to be &ge; 0 for the exact solution. However, due to inaccuracies in the numerical integration scheme,
the output might be slightly negative. If this parameter is set to true, then the output is
explicitly set to 0.0, if the mean value results in a negative value.
</p>
</html>"),       Icon(graphics={Text(
                extent={{-80,60},{80,20}},
                lineColor={0,0,0},
                textString="mean"),Text(
                extent={{-80,-20},{80,-60}},
                lineColor={0,0,0},
                textString="f=%f")}));
      end Mean;

      block RectifiedMean "Calculate rectified mean over period 1/f"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Modelica.SIunits.Frequency f(start=50) "Base frequency";
        parameter Real x0=0 "Start value of integrator state";
        Modelica_AddOn.Blocks.Math.Mean mean(final f=f, final x0=x0)
          annotation (Placement(transformation(extent={{0,-10},{20,10}})));
        Modelica.Blocks.Math.Abs abs1
          annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
      equation
        connect(u, abs1.u) annotation (Line(
            points={{-120,0},{-62,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(abs1.y, mean.u) annotation (Line(
            points={{-39,0},{-2,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(mean.y, y) annotation (Line(
            points={{21,0},{110,0}},
            color={0,0,127},
            smooth=Smooth.None));
        annotation (Documentation(info="<html>
<p>
This block calculates the rectified mean of the input signal u over the given period 1/f, using the
<a href=\"modelica://Modelica.Blocks.Math.Mean\">mean block</a>.
</p>
<p>
Note: The output is updated after each period defined by 1/f.
</p>
</html>"),       Icon(graphics={Text(
                extent={{-80,60},{80,20}},
                lineColor={0,0,0},
                textString="RM"),Text(
                extent={{-80,-20},{80,-60}},
                lineColor={0,0,0},
                textString="f=%f")}));
      end RectifiedMean;

      block RootMeanSquare "Calculate root mean square over period 1/f"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Modelica.SIunits.Frequency f(start=50) "Base frequency";
        parameter Real x0=0 "Start value of integrator state";
        Modelica.Blocks.Math.MultiProduct product(nu=2)
          annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
        Modelica_AddOn.Blocks.Math.Mean mean(
          final f=f,
          final yGreaterOrEqualZero=true,
          final x0=x0)
          annotation (Placement(transformation(extent={{0,-10},{20,10}})));
        Modelica.Blocks.Math.Sqrt sqrt1
          annotation (Placement(transformation(extent={{40,-10},{60,10}})));
      equation
        connect(product.y, mean.u) annotation (Line(
            points={{-18.3,0},{-2,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(mean.y, sqrt1.u) annotation (Line(
            points={{21,0},{38,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sqrt1.y, y) annotation (Line(
            points={{61,0},{110,0}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(u, product.u[1]) annotation (Line(
            points={{-120,0},{-60,0},{-60,3.5},{-40,3.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(u, product.u[2]) annotation (Line(
            points={{-120,0},{-60,0},{-60,-3.5},{-40,-3.5}},
            color={0,0,127},
            smooth=Smooth.None));
        annotation (Documentation(info="<html>
<p>
This block calculates the root mean square of the input signal u over the given period 1/f, using the
<a href=\"modelica://Modelica.Blocks.Math.Mean\">mean block</a>.
</p>
<p>
Note: The output is updated after each period defined by 1/f.
</p>
</html>"),       Icon(graphics={Text(
                extent={{-80,60},{80,20}},
                lineColor={0,0,0},
                textString="RMS"),Text(
                extent={{-80,-20},{80,-60}},
                lineColor={0,0,0},
                textString="f=%f")}));
      end RootMeanSquare;

      block Harmonic "Calculate harmonic over period 1/f"
        extends Modelica.Blocks.Icons.Block;
        parameter Modelica.SIunits.Frequency f(start=50) "Base frequency";
        parameter Integer k(start=1) "Order of harmonic";
        parameter Real x0Cos=0 "Start value of cos integrator state";
        parameter Real x0Sin=0 "Start value of sin integrator state";
        Modelica.Blocks.Sources.Sine sin1(
          final amplitude=sqrt(2),
          final phase=Modelica.Constants.pi/2,
          final freqHz=k*f) annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              rotation=270,
              origin={-80,70})));
        Modelica.Blocks.Sources.Sine sin2(
          final amplitude=sqrt(2),
          final phase=0,
          final freqHz=k*f) annotation (Placement(transformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={-80,-70})));
        Modelica.Blocks.Math.MultiProduct product1(nu=2)
          annotation (Placement(transformation(extent={{-60,30},{-40,50}})));
        Modelica.Blocks.Math.MultiProduct product2(nu=2)
          annotation (Placement(transformation(extent={{-60,-50},{-40,-30}})));
        Modelica_AddOn.Blocks.Math.Mean mean1(final f=f, final x0=x0Cos)
          annotation (Placement(transformation(extent={{-20,30},{0,50}})));
        Modelica_AddOn.Blocks.Math.Mean mean2(final f=f, final x0=x0Sin)
          annotation (Placement(transformation(extent={{-20,-50},{0,-30}})));
        Modelica.Blocks.Interfaces.RealInput u
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
        Modelica.Blocks.Interfaces.RealOutput y_rms "Root mean square of polar representation"
                                                     annotation (Placement(
              transformation(extent={{100,50},{120,70}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y_arg "Angle of polar representation"
          annotation (Placement(transformation(extent={{100,-70},{120,-50}}, rotation=
                 0)));
        Modelica.Blocks.Math.RectangularToPolar rectangularToPolar
          annotation (Placement(transformation(extent={{40,-12},{60,8}})));
      equation
        connect(product2.y, mean2.u) annotation (Line(
            points={{-38.3,-40},{-22,-40}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(product1.y, mean1.u) annotation (Line(
            points={{-38.3,40},{-22,40}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(mean1.y, rectangularToPolar.u_re) annotation (Line(
            points={{1,40},{20,40},{20,4},{38,4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(mean2.y, rectangularToPolar.u_im) annotation (Line(
            points={{1,-40},{20,-40},{20,-8},{38,-8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rectangularToPolar.y_abs, y_rms) annotation (Line(
            points={{61,4},{80,4},{80,60},{110,60}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rectangularToPolar.y_arg, y_arg) annotation (Line(
            points={{61,-8},{80,-8},{80,-60},{110,-60}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sin1.y, product1.u[1]) annotation (Line(
            points={{-80,59},{-80,59},{-80,43.5},{-60,43.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(u, product1.u[2]) annotation (Line(
            points={{-120,0},{-80,0},{-80,36.5},{-60,36.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(u, product2.u[1]) annotation (Line(
            points={{-120,0},{-80,0},{-80,-36.5},{-60,-36.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sin2.y, product2.u[2]) annotation (Line(
            points={{-80,-59},{-80,-43.5},{-60,-43.5}},
            color={0,0,127},
            smooth=Smooth.None));
        annotation (Documentation(info="<html>
<p>
This block calculates the root mean square and the phase angle of a single harmonic <i>k</i> of the input signal u over the given period 1/f, using the
<a href=\"modelica://Modelica.Blocks.Math.Mean\">mean block</a>.
</p>
<p>
Note: The output is updated after each period defined by 1/f.
</p>
<p>
Note: The harmonic is defined by <code>&radic;2 rms cos(k 2 &pi; f t - arg)</code>
</p>
</html>"),       Icon(graphics={
              Text(
                extent={{-80,60},{80,20}},
                lineColor={0,0,0},
                textString="H%k"),
              Text(
                extent={{-80,-20},{80,-60}},
                lineColor={0,0,0},
                textString="f=%f"),
              Text(
                extent={{20,100},{100,60}},
                lineColor={0,0,0},
                textString="rms"),
              Text(
                extent={{20,-60},{100,-100}},
                lineColor={0,0,0},
                textString="arg")}));
      end Harmonic;
    end Math;

    package Routing "Routing blocks"
    extends Modelica.Icons.Package;

      block IntegerReplicator "Integer signal replicator"
        extends Modelica.Blocks.Icons.IntegerBlock;
        parameter Integer nout=1 "Number of outputs";
        Modelica.Blocks.Interfaces.IntegerInput u "Connector of Integer input signal"
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
        Modelica.Blocks.Interfaces.IntegerOutput y[nout] "Connector of Integer output signals"
                                                annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
      equation
        y = fill(u, nout);
        annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                  {100,100}}), graphics={
              Line(points={{-100,0},{-6,0}}, color={255,127,0}),
              Line(points={{100,0},{10,0}}, color={255,127,0}),
              Line(points={{0,0},{100,10}}, color={255,127,0}),
              Line(points={{0,0},{100,-10}}, color={255,127,0}),
              Ellipse(
                extent={{-14,16},{16,-14}},
                lineColor={0,0,0},
                fillColor={255,127,0},
                fillPattern=FillPattern.Solid)}), Documentation(info="<html>
<p>
This block replicates the Integer input signal to an array of <code>nout</code> identical Integer output signals.
</p>
</html>"));
      end IntegerReplicator;

      block BooleanReplicator "Boolean signal replicator"
        extends Modelica.Blocks.Icons.BooleanBlock;
        parameter Integer nout=1 "Number of outputs";
        Modelica.Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal"
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
        Modelica.Blocks.Interfaces.BooleanOutput y[nout] "Connector of Boolean output signals"
                                                annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
      equation
        y = fill(u, nout);
        annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                  {100,100}}), graphics={
              Line(points={{-100,0},{-6,0}}, color={255,0,255}),
              Line(points={{100,0},{10,0}}, color={255,0,255}),
              Line(points={{0,0},{100,10}}, color={255,0,255}),
              Line(points={{0,0},{100,-10}}, color={255,0,255}),
              Ellipse(
                extent={{-14,16},{16,-14}},
                lineColor={0,0,0},
                fillColor={255,0,255},
                fillPattern=FillPattern.Solid)}), Documentation(info="<html>
<p>
This block replicates the Boolean input signal to an array of <code>nout</code> identical Boolean output signals.
</p>
</html>"));
      end BooleanReplicator;
    end Routing;
  end Blocks;

  package Electrical "Electrical"
  extends Modelica.Icons.Package;

    package Analog "Analog"
    extends Modelica.Icons.Package;
      package Ideal "Ideal"
      extends Modelica.Icons.Package;

        model IdealDiode "Ideal diode"
          extends Modelica.Electrical.Analog.Interfaces.OnePort;
          parameter Modelica.SIunits.Resistance Ron(final min=0) = 1.E-5 "Forward state-on differential resistance (closed diode resistance)";
          parameter Modelica.SIunits.Conductance Goff(final min=0) = 1.E-5 "Backward state-off conductance (opened diode conductance)";
          parameter Modelica.SIunits.Voltage Vknee(final min=0) = 0 "Forward threshold voltage";
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort;
          Boolean off(start=true) "Switching state";
        protected
          Real s(start=0, final unit="1") "Auxiliary variable for actual position on the ideal diode characteristic";
          /* s = 0: knee point
     s < 0: below knee point, diode conducting
     s > 0: above knee point, diode locking */
          constant Modelica.SIunits.Voltage unitVoltage=1 annotation (HideResult=true);
          constant Modelica.SIunits.Current unitCurrent=1 annotation (HideResult=true);
        equation
          off = s < 0;
          v = (s*unitCurrent)*(if off then 1 else Ron) + Vknee;
          i = (s*unitVoltage)*(if off then Goff else 1) + Goff*Vknee;
          LossPower = v*i;
          annotation (
            Documentation(info="<html>
<P>
This is an ideal switch which is<br><br>
<b>open </b>(off), if it is reversed biased (voltage drop less than 0)<br>
<b>closed</b> (on), if it is conducting (current > 0).<br>
<br/>
This is the behaviour if all parameters are exactly zero.<br><br>
Note, there are circuits, where this ideal description
with zero resistance and zero conductance is not possible.
In order to prevent singularities during switching, the opened
diode has a small conductance <i>Gon</i> and the closed diode has a low
resistance <i>Roff</i> which is default.
</P>
<P>
The parameter <i>Vknee</i> which is the forward threshold voltage, allows to displace
the knee point <br>
along  the <i>Gon</i>-characteristic until <i>v = Vknee</i>.
<br> <br>
<b>Please note:</b>
In case of useHeatPort=true the temperature dependence of the electrical
behavior is <b>not</b> modelled.
</p>
</html>",         revisions="<html>
<ul>
<li><i> March 11, 2009   </i>
       by Christoph Clauss<br> conditional heat port added<br>
       </li>
<li><i>Mai 7, 2004   </i>
       by Christoph Clauss and Anton Haumer<br> Vknee added<br>
       </li>
<li><i>some years ago   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                    100}}), graphics={
                Polygon(
                  points={{30,0},{-30,40},{-30,-40},{30,0}},
                  lineColor={0,0,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{-90,0},{40,0}}, color={0,0,255}),
                Line(points={{40,0},{90,0}}, color={0,0,255}),
                Line(points={{30,40},{30,-40}}, color={0,0,255}),
                Line(
                  visible=useHeatPort,
                  points={{0,-100},{0,-20}},
                  color={127,0,0},
                  smooth=Smooth.None,
                  pattern=LinePattern.Dot),
                Text(
                  extent={{-156,101},{144,61}},
                  textString="%name",
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                    100}}), graphics={Line(points={{-80,0},{80,0}}, color={128,128,128}),
                  Polygon(
                  points={{70,4},{80,0},{70,-4},{70,4}},
                  lineColor={128,128,128},
                  fillColor={128,128,128},
                  fillPattern=FillPattern.Solid),Line(points={{0,80},{0,-80}}, color={
                  128,128,128}),Polygon(
                  points={{-4,70},{0,80},{4,70},{-4,70}},
                  lineColor={128,128,128},
                  fillColor={128,128,128},
                  fillPattern=FillPattern.Solid),Text(
                  extent={{10,80},{20,70}},
                  lineColor={128,128,128},
                  textString="i"),Text(
                  extent={{70,-10},{80,-20}},
                  lineColor={128,128,128},
                  textString="v"),Line(
                  points={{-80,-40},{-20,-10},{20,10},{40,70}},
                  color={0,0,0},
                  thickness=0.5),Line(
                  points={{20,9},{20,0}},
                  color={128,128,128},
                  pattern=LinePattern.Dot),Text(
                  extent={{20,0},{40,-10}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Vknee"),Text(
                  extent={{20,70},{40,60}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Ron"),Text(
                  extent={{-20,10},{0,0}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Goff"),Ellipse(
                  extent={{18,12},{22,8}},
                  pattern=LinePattern.Dot,
                  lineColor={0,0,255})}));
        end IdealDiode;

        model IdealThyristor "Ideal thyristor"
          extends Modelica.Electrical.Analog.Interfaces.OnePort;
          parameter Modelica.SIunits.Resistance Ron(final min=0) = 1.E-5 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance Goff(final min=0) = 1.E-5 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage Vknee(final min=0) = 0 "Forward threshold voltage";
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
                293.15);
          Boolean off(start=true) "Switching state";
          Modelica.Blocks.Interfaces.BooleanInput fire annotation (Placement(
                transformation(
                origin={70,110},
                extent={{-20,-20},{20,20}},
                rotation=270)));
        protected
          Real s(final unit="1") "Auxiliary variable: if on then current, if opened then voltage";
          constant Modelica.SIunits.Voltage unitVoltage=1 annotation (HideResult=true);
          constant Modelica.SIunits.Current unitCurrent=1 annotation (HideResult=true);
        equation
          off = s < 0 or pre(off) and not fire;
          v = (s*unitCurrent)*(if off then 1 else Ron) + Vknee;
          i = (s*unitVoltage)*(if off then Goff else 1) + Goff*Vknee;
          LossPower = v*i;
          annotation (
            Documentation(info="<html>
<p>This is an ideal thyristor model which is<br><br>
<b>open </b>(off), if the voltage drop is less than 0 or both the thyristor already open (off = true) and fire is false<br>
<b>closed</b> (not off), if both the voltage drop is greater or equal 0 and either the thyristor was already closed (off=false) or fire is true.
</P>
<p>
This is the behaviour if all parameters are exactly zero.<br><br>
Note, there are circuits, where this ideal description
with zero resistance and zero conductance is not possible.
In order to prevent singularities during switching, the opened
thyristor has a small conductance <i>Goff</i> and the closed thyristor has a low
resistance <i>Ron</i> which is default.
</P>
<P>
The parameter <i>Vknee</i> which is the forward threshold voltage, allows to displace
the knee point <br>
along  the <i>Goff</i>-characteristic until <i>v = Vknee</i>.
<br> <br>
<b>Please note:</b>
In case of useHeatPort=true the temperature dependence of the electrical
behavior is <b>not</b> modelled. The parameters are not temperature dependent.
</p>
</html>",         revisions="<html>
<ul>
<li><i> March 11, 2009   </i>
       by Christoph Clauss<br> conditional heat port added<br>
       </li>
<li><i>Mai 7, 2004   </i>
       by Christoph Clauss and Anton Haumer<br> Vknee added<br>
       </li>
<li><i>some years ago   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                    100}}), graphics={
                Text(
                  extent={{-150,-47},{150,-87}},
                  textString="%name",
                  lineColor={0,0,255}),
                Polygon(
                  points={{30,0},{-30,40},{-30,-40},{30,0}},
                  lineColor={0,0,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{-90,0},{40,0}}, color={0,0,255}),
                Line(points={{40,0},{90,0}}, color={0,0,255}),
                Line(points={{30,40},{30,-40}}, color={0,0,255}),
                Line(points={{30,20},{70,60},{70,90}}, color={0,0,255}),
                Line(points={{40,50},{60,30}}, color={0,0,255}),
                Line(
                  visible=useHeatPort,
                  points={{0,-100},{0,-20}},
                  color={127,0,0},
                  smooth=Smooth.None,
                  pattern=LinePattern.Dot)}),
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                    100}}), graphics={Line(points={{-80,0},{80,0}}, color={128,128,128}),
                  Polygon(
                  points={{70,4},{80,0},{70,-4},{70,4}},
                  lineColor={128,128,128},
                  fillColor={128,128,128},
                  fillPattern=FillPattern.Solid),Line(points={{0,80},{0,-80}}, color={
                  128,128,128}),Polygon(
                  points={{-4,70},{0,80},{4,70},{-4,70}},
                  lineColor={128,128,128},
                  fillColor={128,128,128},
                  fillPattern=FillPattern.Solid),Text(
                  extent={{10,80},{20,70}},
                  lineColor={128,128,128},
                  textString="i"),Text(
                  extent={{70,-10},{80,-20}},
                  lineColor={128,128,128},
                  textString="v"),Line(
                  points={{-80,-40},{-20,-10},{20,10},{40,70}},
                  color={0,0,0},
                  thickness=0.5),Line(
                  points={{20,9},{20,0}},
                  color={128,128,128},
                  pattern=LinePattern.Dot),Text(
                  extent={{20,0},{40,-10}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Vknee"),Text(
                  extent={{20,70},{40,60}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Ron"),Text(
                  extent={{-20,10},{0,0}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Goff"),Ellipse(
                  extent={{18,12},{22,8}},
                  pattern=LinePattern.Dot,
                  lineColor={0,0,255}),Line(
                  points={{20,10},{70,40}},
                  color={0,0,0},
                  thickness=0.5)}));
        end IdealThyristor;

        model IdealGTOThyristor "Ideal GTO thyristor"
          extends Modelica.Electrical.Analog.Interfaces.OnePort;
          parameter Modelica.SIunits.Resistance Ron(final min=0) = 1.E-5 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance Goff(final min=0) = 1.E-5 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage Vknee(final min=0) = 0 "Forward threshold voltage";
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
                293.15);
          Boolean off(start=true) "Switching state";
          Modelica.Blocks.Interfaces.BooleanInput fire annotation (Placement(
                transformation(
                origin={70,110},
                extent={{-20,-20},{20,20}},
                rotation=270)));
        protected
          Real s(final unit="1") "Auxiliary variable: if on then current, if opened then voltage";
          constant Modelica.SIunits.Voltage unitVoltage=1 annotation (HideResult=true);
          constant Modelica.SIunits.Current unitCurrent=1 annotation (HideResult=true);
        equation
          off = s < 0 or not fire;
          v = (s*unitCurrent)*(if off then 1 else Ron) + Vknee;
          i = (s*unitVoltage)*(if off then Goff else 1) + Goff*Vknee;
          LossPower = v*i;
          annotation (
            Documentation(info="<html>
<p>This is an ideal GTO thyristor model which is<br><br>
<b>open </b>(off), if the voltage drop is less than 0 or fire is false<br>
<b>closed</b> (not off), if the voltage drop is greater or equal 0  and fire is true.
</P>
<p>
This is the behaviour if all parameters are exactly zero.<br><br>
Note, there are circuits, where this ideal description
with zero resistance and zero conductance is not possible.
In order to prevent singularities during switching, the opened
thyristor has a small conductance <i>Goff</i> and the closed thyristor has a low
resistance <i>Ron</i> which is default.
</P>
<P>
The parameter <i>Vknee</i> which is the forward threshold voltage, allows to displace
the knee point <br>
along  the <i>Goff</i>-characteristic until <i>v = Vknee</i>.
<br> <br>
<b>Please note:</b>
In case of useHeatPort=true the temperature dependence of the electrical
behavior is <b>not</b> modelled. The parameters are not temperature dependent.
</p>
</html>",         revisions="<html>
<ul>
<li><i> March 11, 2009   </i>
       by Christoph Clauss<br> conditional heat port added<br>
       </li>
<li><i>Mai 7, 2004   </i>
       by Christoph Clauss and Anton Haumer<br> Vknee added<br>
       </li>
<li><i>some years ago   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                    100}}), graphics={
                Polygon(
                  points={{30,0},{-30,40},{-30,-40},{30,0}},
                  lineColor={0,0,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{-90,0},{40,0}}, color={0,0,255}),
                Line(points={{40,0},{90,0}}, color={0,0,255}),
                Line(points={{30,40},{30,-40}}, color={0,0,255}),
                Line(points={{30,10},{70,50},{70,90}}, color={0,0,255}),
                Line(points={{50,50},{70,30}}, color={0,0,255}),
                Line(
                  visible=useHeatPort,
                  points={{0,-100},{0,-20}},
                  color={127,0,0},
                  smooth=Smooth.None,
                  pattern=LinePattern.Dot),
                Text(
                  extent={{-149,-43},{151,-83}},
                  textString="%name",
                  lineColor={0,0,255}),
                Line(
                  points={{30,22},{70,62}},
                  color={0,0,255},
                  smooth=Smooth.None),
                Polygon(
                  points={{44,43},{44,36},{51,36},{44,43}},
                  lineColor={0,0,255},
                  smooth=Smooth.None,
                  fillPattern=FillPattern.Solid,
                  fillColor={0,0,255}),
                Polygon(
                  points={{46,33},{53,33},{53,26},{46,33}},
                  lineColor={0,0,255},
                  smooth=Smooth.None,
                  fillPattern=FillPattern.Solid,
                  fillColor={0,0,255}),
                Text(
                  extent={{0,62},{0,34}},
                  lineColor={0,0,255},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  textString="GTO")}),
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                    100}}), graphics={Line(points={{-80,0},{80,0}}, color={128,128,128}),
                  Polygon(
                  points={{70,4},{80,0},{70,-4},{70,4}},
                  lineColor={128,128,128},
                  fillColor={128,128,128},
                  fillPattern=FillPattern.Solid),Line(points={{0,80},{0,-80}}, color={
                  128,128,128}),Polygon(
                  points={{-4,70},{0,80},{4,70},{-4,70}},
                  lineColor={128,128,128},
                  fillColor={128,128,128},
                  fillPattern=FillPattern.Solid),Text(
                  extent={{10,80},{20,70}},
                  lineColor={128,128,128},
                  textString="i"),Text(
                  extent={{70,-10},{80,-20}},
                  lineColor={128,128,128},
                  textString="v"),Line(
                  points={{-80,-40},{-20,-10},{20,10},{40,70}},
                  color={0,0,0},
                  thickness=0.5),Line(
                  points={{20,9},{20,0}},
                  color={128,128,128},
                  pattern=LinePattern.Dot),Text(
                  extent={{20,0},{40,-10}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Vknee"),Text(
                  extent={{20,70},{40,60}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Ron"),Text(
                  extent={{-20,10},{0,0}},
                  lineColor={128,128,128},
                  pattern=LinePattern.Dot,
                  textString="Goff"),Ellipse(
                  extent={{18,12},{22,8}},
                  pattern=LinePattern.Dot,
                  lineColor={0,0,255}),Line(
                  points={{20,10},{70,40}},
                  color={0,0,0},
                  thickness=0.5)}));
        end IdealGTOThyristor;
      end Ideal;
    end Analog;

    package Machines "Machines"
    extends Modelica.Icons.Package;

      package Sensors
        model RotorDisplacementAngle "Rotor lagging angle"
          parameter Integer m=3 "Number of phases";
          parameter Integer p(min=1) "Number of pole pairs";
          parameter Boolean useSupport=false "Use support or fixed housing"
            annotation (Evaluate=true);
          Modelica.Blocks.Interfaces.RealOutput rotorDisplacementAngle(final quantity=
                "Angle", final unit="rad") annotation (Placement(transformation(extent=
                    {{100,-10},{120,10}}, rotation=0)));
          Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug_p(final m=m)
            annotation (Placement(transformation(extent={{-110,50},{-90,70}}, rotation=
                    0)));
          Modelica.Electrical.MultiPhase.Interfaces.NegativePlug plug_n(final m=m)
            annotation (Placement(transformation(extent={{-110,-70},{-90,-50}},
                  rotation=0)));
          Modelica.Electrical.MultiPhase.Sensors.VoltageSensor VoltageSensor1(final m=m)
            annotation (Placement(transformation(
                origin={-80,0},
                extent={{10,-10},{-10,10}},
                rotation=90)));
          SpacePhasors.Blocks.ToSpacePhasor ToSpacePhasorVS(final m=m) annotation (
              Placement(transformation(extent={{-60,-10},{-40,10}}, rotation=0)));
          Modelica.Mechanics.Rotational.Interfaces.Flange_a flange annotation (
              Placement(transformation(extent={{-10,90},{10,110}}, rotation=0)));
          Modelica.Mechanics.Rotational.Sensors.RelAngleSensor relativeAngleSensor
            annotation (Placement(transformation(extent={{40,70},{20,90}}, rotation=0)));
          Modelica.Blocks.Sources.Constant constant_(final k=Modelica.Constants.pi/2)
            annotation (Placement(transformation(extent={{-50,40},{-30,60}}, rotation=0)));
          Modelica.Blocks.Math.Add add(final k2=1, final k1=p) annotation (Placement(
                transformation(
                origin={-10,30},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Machines.SpacePhasors.Blocks.Rotator rotatorVS2R
            annotation (Placement(transformation(extent={{-20,10},{0,-10}},rotation=0)));
          Modelica.Electrical.Machines.SpacePhasors.Blocks.ToPolar ToPolarVSR
            annotation (Placement(transformation(extent={{20,-10},{40,10}},rotation=0)));
          Modelica.Mechanics.Rotational.Interfaces.Flange_a support if useSupport "support at which the reaction torque is acting"
                                                             annotation (Placement(
                transformation(extent={{90,90},{110,110}}, rotation=0)));
          Modelica.Mechanics.Rotational.Components.Fixed fixed if (not useSupport)
            annotation (Placement(transformation(extent={{90,70},{110,90}}, rotation=0)));
        equation
          connect(plug_p, VoltageSensor1.plug_p)
            annotation (Line(points={{-100,60},{-80,60},{-80,10}},color={0,0,255}));
          connect(plug_n, VoltageSensor1.plug_n) annotation (Line(points={{-100,-60},{
                  -80,-60},{-80,-10}}, color={0,0,255}));
          connect(relativeAngleSensor.flange_b, flange)
            annotation (Line(points={{20,80},{0,80},{0,100}}, color={0,0,0}));
          connect(relativeAngleSensor.flange_a, support) annotation (Line(
              points={{40,80},{60,80},{60,100},{100,100}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(relativeAngleSensor.flange_a, fixed.flange) annotation (Line(
              points={{40,80},{100,80}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(relativeAngleSensor.phi_rel, add.u1) annotation (Line(
              points={{30,69},{30,50},{-4,50},{-4,42}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(constant_.y, add.u2) annotation (Line(
              points={{-29,50},{-16,50},{-16,42}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(VoltageSensor1.v, ToSpacePhasorVS.u) annotation (Line(
              points={{-69,0},{-62,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(ToSpacePhasorVS.y, rotatorVS2R.u) annotation (Line(
              points={{-39,0},{-22,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(rotatorVS2R.y, ToPolarVSR.u) annotation (Line(
              points={{1,0},{18,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(add.y, rotatorVS2R.angle) annotation (Line(
              points={{-10,19},{-10,12}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(ToPolarVSR.y[2], rotorDisplacementAngle) annotation (Line(
              points={{41,0.5},{80,0.5},{80,0},{80,0},{80,0},{110,0}},
              color={0,0,127},
              smooth=Smooth.None));
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                    100}}), graphics={
                Ellipse(
                  extent={{-60,80},{60,40}},
                  lineColor={0,255,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Ellipse(
                  extent={{-60,-40},{60,-80}},
                  lineColor={0,255,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{-60,60},{60,40}},
                  lineColor={0,255,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{-60,-40},{60,-60}},
                  lineColor={0,255,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{-40,40},{40,-40}},
                  lineColor={0,255,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{0,0},{-80,80}}, color={0,0,255}),
                Polygon(
                  points={{-80,80},{-68,76},{-76,68},{-80,80}},
                  lineColor={0,0,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{0,0},{0,80}}, color={0,255,0}),
                Polygon(
                  points={{0,84},{4,72},{-4,72},{0,84}},
                  lineColor={0,255,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{80,120},{120,80}},
                  lineColor={192,192,192},
                  fillColor={192,192,192},
                  fillPattern=FillPattern.Solid),
                Line(
                  visible=not useSupport,
                  points={{80,100},{120,100}},
                  color={0,0,0},
                  smooth=Smooth.None),
                Line(
                  visible=not useSupport,
                  points={{90,120},{80,100}},
                  color={0,0,0},
                  smooth=Smooth.None),
                Line(
                  visible=not useSupport,
                  points={{100,120},{90,100}},
                  color={0,0,0},
                  smooth=Smooth.None),
                Line(
                  visible=not useSupport,
                  points={{110,120},{100,100}},
                  color={0,0,0},
                  smooth=Smooth.None),
                Line(
                  visible=not useSupport,
                  points={{120,120},{110,100}},
                  color={0,0,0},
                  smooth=Smooth.None)}),
            Documentation(info="<HTML>
Calculates rotor lagging angle by measuring the stator phase voltages, transforming them to the corresponding space phasor in stator-fixed coordinate system, <br>
rotating the space phasor to the rotor-fixed coordinate system and calculating the angle of this space phasor.
<p>
The sensor's housing can be implicitly fixed (useSupport=false).<br>
If the machine's stator also implicitly fixed (useSupport=false), the angle at the flange
is equal to the angle of the machine's rotor against the stator.<br>
Otherwise, the sensor's support has to be connected to the machine's support.
</p>
</HTML>"),  Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics));
        end RotorDisplacementAngle;
      end Sensors;

      package SpacePhasors "Space phasors"
      extends Modelica.Icons.Package;

        package Blocks "Blocks for space phasor transformation"
        extends Modelica.Icons.Package;

          block Rotator "Rotates space phasor"
            extends Modelica.Blocks.Interfaces.MIMOs(final n=2);
          protected
            Real RotationMatrix[2, 2]={{+cos(-angle),-sin(-angle)},{+sin(-angle),+cos(-
                angle)}};
            //Real InverseRotator[2,2] = {{+cos(+angle),-sin(+angle)},{+sin(+angle),+cos(+angle)}};
          public
            Modelica.Blocks.Interfaces.RealInput angle annotation (Placement(
                  transformation(
                  origin={0,-120},
                  extent={{-20,-20},{20,20}},
                  rotation=90)));
          equation
            y = RotationMatrix*u;
            //u = InverseRotator*y;
            annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                      {100,100}}), graphics={
                  Line(points={{0,0},{0,80},{-10,60},{10,60},{0,80}}, color={0,0,255}),
                  Line(points={{0,0},{80,0},{60,10},{60,-10},{80,0}}, color={0,0,255}),
                  Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,255}),
                  Rectangle(
                    extent={{-51,51},{-1,-51}},
                    pattern=LinePattern.None,
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid,
                    lineColor={0,0,255}),
                  Rectangle(
                    extent={{51,-1},{-1,-51}},
                    pattern=LinePattern.None,
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid,
                    lineColor={0,0,255}),
                  Polygon(
                    points={{50,0},{42,14},{54,16},{50,0}},
                    lineColor={0,0,255},
                    fillColor={0,0,255},
                    fillPattern=FillPattern.Solid),
                  Text(
                    extent={{-88,-72},{84,-92}},
                    lineColor={0,0,0},
                    textString="angle")}), Documentation(info="<HTML>
Rotates a space phasor (voltage or current) input <code>u</code> by the <code>angle</code> in negative mathematical direction. This block represents the transformation of one space phasor <code>u</code> from one rotating reference (coordinate) frame into another where the spave phasor is <code>y</code>. The output reference frame leads the input reference frame by angle <code>angle</code>.

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Electrical/Machines/Rotator.png\">
    </td>
  </tr>
  <caption align=\"bottom\"><b>Fig. 1:</b> Original and rotated reference frame of a space phasor </caption>
</table>

</HTML>"));
          end Rotator;

          block ToSpacePhasor "Conversion of multi phase instantaneous values to space phasors"
            extends Modelica.Blocks.Interfaces.MIMO(final nin=m, final nout=2);
            parameter Integer m(min=1) = 3 "Number of phases";
          protected
            parameter Modelica.SIunits.Angle phi[m]=
                Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m);
            parameter Real TransformationMatrix[2, m]=2/m*{+cos(+phi),+sin(+phi)};
            parameter Real InverseTransformation[m, 2]={{+cos(-phi[k]),-sin(-phi[k])}
                for k in 1:m};
          public
            Modelica.Blocks.Interfaces.RealOutput zero "Zero sequence component"
              annotation (Placement(transformation(extent={{100,-70},{120,-90}}, rotation=
                     0)));
          equation
            m*zero = sum(u);
            y = TransformationMatrix*u;
            //u = fill(zero,m) + InverseTransformation*y;
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                      100}}), graphics={
                  Line(points={{0,0},{80,80},{60,72},{72,60},{80,80}}, color={0,0,255}),
                  Line(points={{0,0},{80,-80},{72,-60},{60,-72},{80,-80}}, color={0,0,255}),
                  Line(
                    points={{-80,0},{-73.33,10},{-66.67,17.32},{-60,20},{-53.33,17.32},{-46.67,
                        10},{-40,0},{-33.33,-10},{-26.67,-17.32},{-20,-20},{-13.33,-17.32},
                        {-6.67,-10},{0,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Line(
                    points={{-90,0},{-83.33,10},{-76.67,17.32},{-70,20},{-63.33,17.32},{-56.67,
                        10},{-50,0},{-43.33,-10},{-36.67,-17.32},{-30,-20},{-23.33,-17.32},
                        {-16.67,-10},{-10,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Line(
                    points={{-70,0},{-63.33,10},{-56.67,17.32},{-50,20},{-43.33,17.32},{-36.67,
                        10},{-30,0},{-23.33,-10},{-16.67,-17.32},{-10,-20},{-3.33,-17.32},
                        {3.33,-10},{10,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Text(
                    extent={{-12,-74},{64,-86}},
                    lineColor={0,0,0},
                    textString="zero")}),
              Documentation(info="<HTML>
Transformation of multi phase values (of voltages or currents) to space phasor and zero sequence value.
</HTML>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics));
          end ToSpacePhasor;

          block FromSpacePhasor "Conversion of space phasors to multi phase instantaneous values"
            extends Modelica.Blocks.Interfaces.MIMO(final nin=2, final nout=m);
            parameter Integer m(min=1) = 3 "Number of phases";
          protected
            parameter Modelica.SIunits.Angle phi[m]=
                Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m);
            parameter Real TransformationMatrix[2, m]=2/m*{+cos(+phi),+sin(+phi)};
            parameter Real InverseTransformation[m, 2]={{+cos(-phi[k]),-sin(-phi[k])}
                for k in 1:m};
          public
            Modelica.Blocks.Interfaces.RealInput zero "Zero seqeuence component"
              annotation (Placement(transformation(extent={{-140,-60},{-100,-100}},
                    rotation=0)));
          equation
            y = fill(zero, m) + InverseTransformation*u;
            //m*zero = sum(y);
            //u = TransformationMatrix *y;
            annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                      {100,100}}), graphics={
                  Line(points={{0,0},{-80,80},{-60,72},{-72,60},{-80,80}}, color={0,0,255}),
                  Line(points={{0,0},{-80,-80},{-72,-60},{-60,-72},{-80,-80}}, color={0,0,
                        255}),
                  Line(
                    points={{0,0},{6.67,10},{13.33,17.32},{20,20},{26.67,17.32},{33.33,10},
                        {40,0},{46.67,-10},{53.33,-17.32},{60,-20},{66.67,-17.32},{73.33,
                        -10},{80,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Line(
                    points={{-10,0},{-3.33,10},{3.33,17.32},{10,20},{16.67,17.32},{23.33,
                        10},{30,0},{36.67,-10},{43.33,-17.32},{50,-20},{56.67,-17.32},{
                        63.33,-10},{70,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Line(
                    points={{10,0},{16.67,10},{23.33,17.32},{30,20},{36.67,17.32},{43.33,
                        10},{50,0},{56.67,-10},{63.33,-17.32},{70,-20},{76.67,-17.32},{
                        83.33,-10},{90,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Text(
                    extent={{-62,-74},{14,-86}},
                    lineColor={0,0,0},
                    textString="zero")}), Documentation(info="<HTML>
Transformation of space phasor and zero sequence value to mutli phase values (of voltages or currents).
</HTML>"));
          end FromSpacePhasor;

          block ToPolar "Converts a space phasor to polar coordinates"
            extends Modelica.Blocks.Interfaces.MIMOs(final n=2);
            constant Real small=Modelica.Constants.small;
          equation
            y[1] = sqrt(u[1]^2 + u[2]^2);
            y[2] = if noEvent(y[1] <= small) then 0 else Modelica.Math.atan2(u[2], u[1]);
            /*
  if y[1] <= small then
    y[2] = 0;
  else
    if u[2] >= 0 then
      y[2] =  Modelica.Math.acos(u[1]/y[1]);
    else
      y[2] = -Modelica.Math.acos(u[1]/y[1]);
    end if;
  end if;
*/
            annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                      {100,100}}), graphics={
                  Line(points={{-60,60},{-60,-60},{60,-60}}, color={0,0,255}),
                  Line(points={{-100,-100},{100,100}}, color={0,0,255}),
                  Polygon(points={{26,26},{14,20},{20,14},{26,26}}, lineColor={0,0,255}),
                  Line(
                    points={{-18,-18},{-14,-22},{-10,-28},{-6,-34},{-2,-44},{0,-52},{0,-60}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Polygon(points={{-18,-18},{-14,-26},{-10,-22},{-18,-18}}, lineColor={0,
                        0,255}),
                  Text(
                    extent={{-100,100},{-6,-6}},
                    lineColor={0,0,255},
                    textString="R"),
                  Text(
                    extent={{6,6},{100,-100}},
                    lineColor={0,0,255},
                    textString="P")}), Documentation(info="<HTML>
Converts a space phasor from rectangular coordinates to polar coordinates.
</HTML>"));
          end ToPolar;

          block FromPolar "Converts a space phasor from polar coordinates"
            extends Modelica.Blocks.Interfaces.MIMOs(final n=2);
          equation
            y = u[1]*{cos(u[2]),sin(u[2])};
            annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                      {100,100}}), graphics={
                  Line(points={{-60,60},{-60,-60},{60,-60}}, color={0,0,255}),
                  Line(points={{-100,-100},{100,100}}, color={0,0,255}),
                  Polygon(points={{26,26},{14,20},{20,14},{26,26}}, lineColor={0,0,255}),
                  Line(
                    points={{-18,-18},{-14,-22},{-10,-28},{-6,-34},{-2,-44},{0,-52},{0,-60}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Polygon(points={{-18,-18},{-14,-26},{-10,-22},{-18,-18}}, lineColor={0,
                        0,255}),
                  Text(
                    extent={{-100,100},{-6,-6}},
                    lineColor={0,0,255},
                    textString="P"),
                  Text(
                    extent={{6,6},{100,-100}},
                    lineColor={0,0,255},
                    textString="R")}), Documentation(info="<HTML>
Converts a space phasor from polar coordinates to rectangular coordinates.
</HTML>"));
          end FromPolar;

          block QuasiRMS
            extends Modelica.Blocks.Interfaces.MISO(final nin=2);
            Modelica_AddOn.Electrical.Machines.SpacePhasors.Blocks.ToPolar toPolar
              annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
            Modelica.Blocks.Math.Gain gain(final k=1/sqrt(2))
              annotation (Placement(transformation(extent={{20,-10},{40,10}})));
          equation
            connect(u, toPolar.u) annotation (Line(
                points={{-120,0},{-42,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(toPolar.y[1], gain.u) annotation (Line(
                points={{-19,-0.5},{0,-0.5},{0,0},{18,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(gain.y, y) annotation (Line(
                points={{41,0},{110,0}},
                color={0,0,127},
                smooth=Smooth.None));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics),
              Documentation(info="<html>
<p>
This model determines the RMS value of the input space phasor <code>u</code>.</p> </html>"),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                      100}}), graphics={Text(
                    extent={{-60,40},{60,-20}},
                    lineColor={0,0,255},
                    textString="RMS")}));
          end QuasiRMS;
        annotation (Documentation(info="<HTML>
This package contains space phasor transformation blocks for use in controllers:
<ul>
<li>ToSpacePhasor: transforms a set of mutli phase values to space phasor and zero sequence system</li>
<li>FromSpacePhasor: transforms a space phasor and zero sequence system to a set of multi phase values</li>
<li>Rotator: rotates a space phasor (from one coordinate system into another)</li>
<li>ToPolar: Converts a space phasor from rectangular coordinates to polar coordinates</li>
<li>FromPolar: Converts a space phasor from polar coordinates to rectangular coordinates</li>
</ul>
<p>
Space phasors are defined as vectors of length = 2,
the first element representing the real part and the second element representing the imaginary part of the space phasor.
</p>
</HTML>",         revisions="<HTML>
  <dl>
  <dt><b>Main Authors:</b></dt>
  <dd>
  <a href=\"http://www.haumer.at/\">Anton Haumer</a><br>
  Technical Consulting &amp; Electrical Engineering<br>
  A-3423 St.Andrae-Woerdern<br>Austria<br>
  email: <a href=\"mailto:a.haumer@haumer.at\">a.haumer@haumer.at</a>
  </dd>
  <dt><b>Copyright:</b></dt>
  <dd>Copyright &copy; 1998-2013, Modelica Association and Anton Haumer.<br>
  <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
  under the terms of the <b>Modelica license</b>, see the license conditions
  and the accompanying <b>disclaimer</b> in the documentation of package
  Modelica in file \"Modelica/package.mo\".</i></dd>
</dl>
  <ul>
  <li> v1.00 2004/09/16 Anton Haumer</li>
  <li> v1.30 2004/11/05 Anton Haumer<br>
       several improvements in SpacePhasors.Blocks</li>
  <li> v1.6.1 2005/11/10 Anton Haumer<br>
       improved Transformation and Rotation</li>
  </ul>
</HTML>"));
        end Blocks;

        package Functions "Functions for space phasor transformation"
        extends Modelica.Icons.Package;

          function ToSpacePhasor "Conversion from multi phase input to space phasor and zero sequence component"
            extends Modelica.Icons.Function;
            input Real x[:] "Multi phase (voltage or current) input";
            output Real y[2] "Space phasor";
            output Real y0 "Zero sequence component (of voltage or current)";
          protected
            constant Modelica.SIunits.Angle pi=Modelica.Constants.pi;
            parameter Integer m=size(x, 1) "Number of phases";
            parameter Modelica.SIunits.Angle phi[m]=
                Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m);
            parameter Real TransformationMatrix[2, m]=2/m*{+cos(+phi),+sin(+phi)};
            parameter Real InverseTransformation[m, 2]={{+cos(-phi[k]),-sin(-phi[k])}
                for k in 1:m};
          algorithm
            y := TransformationMatrix*x;
            y0 := 1/m*sum(x);
            annotation (Inline=true, Documentation(info="<HTML>
Transformation of multi phase values (of voltages or currents) to space phasor and zero sequence value.
</HTML>"));
          end ToSpacePhasor;

          function FromSpacePhasor "Conversion from space phasor and zero sequence component to multi phase"
            extends Modelica.Icons.Function;
            input Real x[2] "Space phasor";
            input Real x0 "Zero sequence component";
            input Integer m "Number of phases";
            output Real y[m] "Multi phase output";
          protected
            constant Modelica.SIunits.Angle pi=Modelica.Constants.pi;
            parameter Modelica.SIunits.Angle phi[m]=
                Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m);
            parameter Real TransformationMatrix[2, m]=2/m*{+cos(+phi),+sin(+phi)};
            parameter Real InverseTransformation[m, 2]={{+cos(-phi[k]),-sin(-phi[k])}
                for k in 1:m};
          algorithm
            y := fill(x0, m) + InverseTransformation*x;
            annotation (Inline=true, Documentation(info="<HTML>
Transformation of space phasor and zero sequence value to mutli phase values (of voltages or currents).
</HTML>"));
          end FromSpacePhasor;

          function Rotator "Rotates space phasor"
            extends Modelica.Icons.Function;
            input Real x[2] "Input space phasor";
            input Modelica.SIunits.Angle angle "Input angle of rotation";
            output Real y[2] "Output space phasor";
          protected
            Real RotationMatrix[2, 2]={{+cos(-angle),-sin(-angle)},{+sin(-angle),+cos(-
                angle)}};
          algorithm
            y := RotationMatrix*x;
            annotation (Inline=true, Documentation(info="<HTML>
Rotates a space phasor (voltage or current) input <code>u</code> by the <code>angle</code> in negative mathematical direction. This block represents the transformation of one space phasor <code>u</code> from one rotating reference (coordinate) frame into another where the spave phasor is <code>y</code>. The output reference frame leads the input reference frame by angle <code>angle</code>.

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Electrical/Machines/Rotator.png\">
    </td>
  </tr>
  <caption align=\"bottom\"><b>Fig. 1:</b> Original and rotated reference frame of a space phasor </caption>
</table>
</HTML>"));
          end Rotator;

          function ToPolar "Converts a space phasor to polar coordinates"
            extends Modelica.Icons.Function;
            input Real x[2] "Real and imaginary part of space phasor";
            output Real absolute "Magnitude of space phasor";
            output Modelica.SIunits.Angle angle "Angle of space phasor";
          protected
            constant Real small=Modelica.Constants.small;
          algorithm
            absolute := sqrt(x[1]^2 + x[2]^2);
            angle := if absolute <= small then 0 else Modelica.Math.atan2(x[2], x[1]);
            /*
  if absolute <= small then
    angle := 0;
  else
    if x[2] >= 0 then
      angle :=  Modelica.Math.acos(x[1]/absolute);
    else
      angle := -Modelica.Math.acos(x[1]/absolute);
    end if;
  end if;
*/
            annotation (Inline=true, Documentation(info="<HTML>
Converts a space phasor from rectangular coordinates to polar coordinates, providing angle=0 for {0,0}.
</HTML>"));
          end ToPolar;

          function FromPolar "Converts a space phasor from polar coordinates"
            extends Modelica.Icons.Function;
            input Real absolute "Magnitude of space phasor";
            input Modelica.SIunits.Angle angle "Angle of space phasor";
            output Real x[2] "Real and imaginary part of space phasor";
          protected
            constant Modelica.SIunits.Angle pi=Modelica.Constants.pi;
            constant Real small=Modelica.Constants.small;
          algorithm
            x := absolute*{cos(angle),sin(angle)};
            annotation (Inline=true, Documentation(info="<HTML>
Converts a space phasor from polar coordinates to rectangular coordinates.
</HTML>"));
          end FromPolar;

          function quasiRMS "Calculate quasi-RMS value of input"
            extends Modelica.Icons.Function;
            import Modelica.Constants.pi;
            input Real x[3];
            output Real y;
          protected
            Integer m=size(x, 1) "Number of phases";
            Modelica.SIunits.Angle phi[m]=
                Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m);
            Real TransformationMatrix[2, m]=2/m*{+cos(+phi),+sin(+phi)};
            Real h[2]=TransformationMatrix*x;
          algorithm
            y := sqrt(h[1]^2 + h[2]^2)/sqrt(2);
            annotation (Inline=true, Documentation(info="<HTML>
  Transformation of m phase values (voltages or currents) to space phasor and calculate length of space phasor / sqrt(2).
</HTML>"));
          end quasiRMS;

          function activePower "Calculate active power of voltage and current input"
            extends Modelica.Icons.Function;
            input Modelica.SIunits.Voltage v[m] "phase voltages";
            input Modelica.SIunits.Current i[m] "phase currents";
            output Modelica.SIunits.Power p "Active power";
          protected
            constant Integer m=3 "Number of phases";
            constant Modelica.SIunits.Angle pi=Modelica.Constants.pi;
            Modelica.SIunits.Voltage v_[2] "Voltage space phasor";
            Modelica.SIunits.Current i_[2] "Current space phasor";
          algorithm
            v_ := zeros(2);
            i_ := zeros(2);
            for k in 1:m loop
              v_ := v_ + 2/m*{+cos((k - 1)/m*2*pi),+sin(+(k - 1)/m*2*pi)}*v[k];
              i_ := i_ + 2/m*{+cos((k - 1)/m*2*pi),+sin(+(k - 1)/m*2*pi)}*i[k];
            end for;
            p := m/2*(+v_[1]*i_[1] + v_[2]*i_[2]);
            annotation (Inline=true, Documentation(info="<HTML>
Transformation of three phase voltages and currents to space phasors and calculate active power.
</HTML>"));
          end activePower;
        annotation (Documentation(info="<HTML>
This package contains space phasor transformation functions for use in calculations:
<ul>
<li>ToSpacePhasor: transforms a set of three-phase values to space phasor and zero sequence system</li>
<li>FromSpacePhasor: transforms a space phasor and zero sequence system to a set of three-phase values</li>
<li>Rotator: rotates a space phasor (from one coordinate system into another)</li>
<li>ToPolar: Converts a space phasor from rectangular coordinates to polar coordinates</li>
<li>FromPolar: Converts a space phasor from polar coordinates to rectangular coordinates</li>
</ul>
<p>
Space phasors are defined as vectors of length = 2,
the first element representing the real part and the second element representing the imaginary part of the space phasor.
</p>
</HTML>",         revisions="<HTML>
<dl>
  <dt><b>Main Authors:</b></dt>
  <dd>
  <a href=\"http://www.haumer.at/\">Anton Haumer</a><br>
  Technical Consulting &amp; Electrical Engineering<br>
  A-3423 St.Andrae-Woerdern<br>Austria<br>
  email: <a href=\"mailto:a.haumer@haumer.at\">a.haumer@haumer.at</a>
  </dd>

  <dt><b>Release Notes:</b></dt>
  <dd>
  <ul>
  <li> v1.00 2004/09/16 Anton Haumer</li>
  <li> v1.6.1 2005/11/10 Anton Haumer<br>
       improved Transformation and Rotation</li>
  </ul>
  </dd>

  <dt><b>Copyright:</b></dt>
  <dd>Copyright &copy; 1998-2013, Modelica Association and Anton Haumer.<br>
  <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
  under the terms of the <b>Modelica license</b>, see the license conditions
  and the accompanying <b>disclaimer</b> in the documentation of package
  Modelica in file \"Modelica/package.mo\".</i></dd>
</dl>
</HTML>"));
        end Functions;
      end SpacePhasors;

      package Icons "Icons"
      extends Modelica.Icons.Package;
        partial model QuasiStaticFundamentalWaveMachine "Icon of quasi static fundamental wave machine"

          annotation (Icon(graphics={
                Rectangle(
                  extent={{-40,60},{80,-60}},
                  lineColor={0,0,0},
                  fillPattern=FillPattern.HorizontalCylinder,
                  fillColor={255,206,120}),
                Rectangle(
                  extent={{-40,60},{-60,-60}},
                  lineColor={0,0,0},
                  fillPattern=FillPattern.HorizontalCylinder,
                  fillColor={128,128,128}),
                Rectangle(
                  extent={{80,10},{100,-10}},
                  lineColor={0,0,0},
                  fillPattern=FillPattern.HorizontalCylinder,
                  fillColor={95,95,95}),
                Rectangle(
                  extent={{-40,70},{40,50}},
                  lineColor={95,95,95},
                  fillColor={95,95,95},
                  fillPattern=FillPattern.Solid),
                Polygon(
                  points={{-50,-90},{-40,-90},{-10,-20},{40,-20},{70,-90},{80,-90},{80,
                      -100},{-50,-100},{-50,-90}},
                  lineColor={0,0,0},
                  fillColor={0,0,0},
                  fillPattern=FillPattern.Solid)}), Documentation(info="<html>
<p>
This icon is designed for a <b>quasi static fundamental wave machine</b> model.
</p>
</html>"));
        end QuasiStaticFundamentalWaveMachine;
      end Icons;

      package Utilities "Utilities"
      extends Modelica.Icons.Package;
        model MultiTerminalBox "Terminal box Y/D-connection"
          parameter Integer m(min=1) = 3 "number of phases";
          final parameter Integer mSystems=
              MultiPhase.Functions.numberOfSymmetricBaseSystems(m);
          final parameter Integer mBasic=integer(m/mSystems);
          parameter String terminalConnection(start="Y") "Choose Y=star/D=delta"
            annotation (choices(choice="Y" "Star connection", choice="D" "Delta connection"));
          Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug_sp(final m=m) "To positive stator plug"
                                      annotation (Placement(transformation(extent={{50,
                    -90},{70,-110}}, rotation=0)));
          Modelica.Electrical.MultiPhase.Interfaces.NegativePlug plug_sn(final m=m) "To negative stator plug"
                                      annotation (Placement(transformation(extent={{-70,
                    -90},{-50,-110}}, rotation=0)));
          MultiPhase.Basic.MultiStar multiStar(final m=m) if (terminalConnection <> "D")
            annotation (Placement(transformation(
                origin={-70,-80},
                extent={{-10,10},{10,-10}},
                rotation=180)));
          MultiPhase.Basic.MultiDelta multiDelta(final m=m) if (terminalConnection ==
            "D") annotation (Placement(transformation(extent={{-20,-70},{-40,-50}},
                  rotation=0)));
          Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plugSupply(final m=m) "To grid"
                      annotation (Placement(transformation(extent={{-10,-70},{10,-90}},
                  rotation=0)));
          Modelica.Electrical.MultiPhase.Interfaces.NegativePlug starpoint(final m=
                mSystems) if (terminalConnection <> "D") annotation (Placement(
                transformation(extent={{-100,-90},{-80,-70}}, rotation=0)));
        equation
          connect(plug_sn, multiStar.plug_p)
            annotation (Line(points={{-60,-100},{-60,-80}}, color={0,0,255}));
          connect(plug_sn, multiDelta.plug_n) annotation (Line(points={{-60,-100},{-40,
                  -100},{-40,-60}}, color={0,0,255}));
          connect(multiDelta.plug_p, plug_sp)
            annotation (Line(points={{-20,-60},{60,-60},{60,-100}}, color={0,0,255}));
          connect(plug_sp, plugSupply)
            annotation (Line(points={{60,-100},{0,-100},{0,-80}}, color={0,0,255}));
          connect(starpoint, multiStar.starpoints) annotation (Line(
              points={{-90,-80},{-80,-80}},
              color={0,0,255},
              smooth=Smooth.None));
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                    100}}), graphics={Polygon(
                  points={{-74,-80},{-80,-86},{-80,-120},{-40,-140},{40,-140},{80,-110},
                      {80,-84},{76,-80},{-74,-80}},
                  lineColor={95,95,95},
                  fillColor={135,135,135},
                  fillPattern=FillPattern.CrossDiag),Text(
                  extent={{-40,-90},{40,-130}},
                  lineColor={0,0,0},
                  textString="%terminalConnection")}),
            Documentation(info="<html>
TerminalBox: at the bottom connected to both machine plugs, connect at the top to the grid as usual,<br>
choosing Y-connection (StarDelta=Y) or D-connection (StarDelta=D).
</html>"),  Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics));
        end MultiTerminalBox;
      end Utilities;
    end Machines;

    package MultiPhase "Library for electrical components with 2, 3 or more phases"
    extends Modelica.Icons.Package;

      package Basic "Basic multi phase components"
        extends Modelica.Icons.Package;

        model MultiStar "Star connection of multi phase systems consisting of multiple base systems"
          parameter Integer m(final min=1) = 3 "Number of phases";
          final parameter Integer mSystems=Functions.numberOfSymmetricBaseSystems(m) "Number of base systems";
          final parameter Integer mBasic=integer(m/mSystems) "Phase number of base systems";
          Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug_p(final m=m)
            annotation (Placement(transformation(extent={{-110,-10},{-90,10}}, rotation=
                   0)));
          Modelica.Electrical.MultiPhase.Interfaces.NegativePlug starpoints(final m=
                mSystems) annotation (Placement(transformation(extent={{90,-10},{110,10}},
                  rotation=0)));
        equation
          for k in 1:mSystems loop
            for j in 1:mBasic loop
              connect(plug_p.pin[(k - 1)*mBasic + j], starpoints.pin[k]);
            end for;
          end for;
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                    100}}), graphics={
                Text(
                  extent={{-150,60},{150,120}},
                  textString="%name",
                  lineColor={0,0,255}),
                Text(
                  extent={{-100,-110},{100,-70}},
                  lineColor={0,0,0},
                  textString="m=%m"),
                Line(
                  points={{74,-4},{-6,-4}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{-6,-4},{-45,64}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{-6,-4},{-44,-73}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(points={{-90,0},{-40,0}}, color={0,0,255}),
                Line(points={{80,0},{90,0}}, color={0,0,255}),
                Line(
                  points={{6,4},{-33,72}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{86,4},{6,4}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{6,4},{-32,-65}},
                  thickness=0.5,
                  color={0,0,255})}),
            Documentation(info="<html>
<p>
Star (wye) connection of a multi phase circuit consiting of multiple base systems (see
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.MultiPhase\">multi phase guidelines</a>). The potentials at the star points are all equal.
</p>
<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.Star\">Star</a>,
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.Delta\">Delta</a>,
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.MultiDelta\">MultiDelta</a>
</p></html>"),
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics));
        end MultiStar;

        model MultiDelta "Delta (polygon) connection of multi phase systems consisting of multiple base systems"
          parameter Integer m(final min=2) = 3 "Number of phases";
          final parameter Integer mSystems=Functions.numberOfSymmetricBaseSystems(m) "Number of base systems";
          final parameter Integer mBasic=integer(m/mSystems) "Phase number of base systems";
          Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug_p(final m=m)
            annotation (Placement(transformation(extent={{-110,-10},{-90,10}}, rotation=
                   0)));
          Modelica.Electrical.MultiPhase.Interfaces.NegativePlug plug_n(final m=m)
            annotation (Placement(transformation(extent={{90,-10},{110,10}}, rotation=0)));
        equation
          for k in 1:mSystems loop
            for j in 1:mBasic - 1 loop
              connect(plug_n.pin[(k - 1)*mBasic + j], plug_p.pin[(k - 1)*mBasic + j + 1]);
            end for;
            connect(plug_n.pin[k*mBasic], plug_p.pin[(k - 1)*mBasic + 1]);
          end for;
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}), graphics={
                Text(
                  extent={{-150,60},{150,120}},
                  lineColor={0,0,255},
                  textString="%name"),
                Text(
                  extent={{-100,-110},{100,-70}},
                  lineColor={0,0,0},
                  textString="m=%m"),
                Line(points={{-90,0},{-46,0}}, color={0,0,255}),
                Line(
                  points={{-44,62},{-44,-76},{75,-6},{-44,62},{-44,61}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(points={{80,0},{90,0}}, color={0,0,255}),
                Line(
                  points={{-36,74},{-36,-64},{83,6},{-36,74},{-36,73}},
                  thickness=0.5,
                  color={0,0,255})}), Documentation(info="<html>
<p>
Delta (polygon) connection of a multi phase circuit consiting of multiple base systems (see
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.MultiPhase\">multi phase guidelines</a>). 
</p>
<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.Star\">Star</a>,
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.Delta\">Delta</a>,
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.MultiStar\">MultiStar</a>
</p>
</html>"));
        end MultiDelta;

        model MultiStarResistance "Resistance connection of star points"
          parameter Integer m(final min=3) = 3 "Number of phases";
          final parameter Integer mBasic=Functions.numberOfSymmetricBaseSystems(m) "Number of symmetric base systems";
          parameter Modelica.SIunits.Resistance R=1e6 "Insulation resistance between base systems";
          Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug(m=m)
            annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
          Modelica_AddOn.Electrical.MultiPhase.Basic.MultiStar multiStar(m=m)
            annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=0,
                origin={-50,0})));
          Modelica.Electrical.MultiPhase.Basic.Resistor resistor(m=mBasic, R=fill(R,
                mBasic)) annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=0,
                origin={0,0})));
          Modelica.Electrical.MultiPhase.Basic.Star star(m=mBasic) annotation (
              Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=0,
                origin={50,0})));
          Modelica.Electrical.Analog.Interfaces.NegativePin pin annotation (Placement(
                transformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={100,0})));
        equation
          connect(plug, multiStar.plug_p) annotation (Line(
              points={{-100,0},{-100,0},{-60,0},{-60,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(multiStar.starpoints, resistor.plug_p) annotation (Line(
              points={{-40,0},{-40,0},{-10,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(resistor.plug_n, star.plug_p) annotation (Line(
              points={{10,0},{10,0},{34,0},{34,0},{40,0},{40,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star.pin_n, pin) annotation (Line(
              points={{60,0},{60,0},{98,0},{98,0},{100,0},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                    100}}), graphics={
                Line(
                  points={{-40,40},{0,0},{40,40},{0,0},{0,-40}},
                  color={0,0,255},
                  smooth=Smooth.None,
                  origin={-60,0},
                  rotation=90),
                Rectangle(
                  extent={{-10,20},{10,-20}},
                  lineColor={0,0,255},
                  origin={0,0},
                  rotation=90),
                Line(
                  points={{-40,40},{0,0},{40,40},{0,0},{0,-40}},
                  color={0,0,255},
                  smooth=Smooth.None,
                  origin={60,0},
                  rotation=90)}),
            Documentation(info="<html>
<p>
Multi star points are connected by resistors. This model is required to operate multi phase systems with even phase numbers to avoid ideal connections of start points of base systems; see
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.MultiPhase\">multi phase guidelines</a>.
</p>
</html>"));
        end MultiStarResistance;
      end Basic;

      package Ideal "Ideal multi phase components"
      extends Modelica.Icons.Package;

        model IdealDiode "Multiphase ideal diode"
          extends Modelica.Electrical.MultiPhase.Interfaces.TwoPlug;
          parameter Modelica.SIunits.Resistance Ron[m](final min=zeros(m), start=fill(
                1.E-5, m)) "Closed diode resistance";
          parameter Modelica.SIunits.Conductance Goff[m](final min=zeros(m), start=fill(
                1.E-5, m)) "Opened diode conductance";
          parameter Modelica.SIunits.Voltage Vknee[m](final min=zeros(m), start=zeros(m)) "Threshold voltage";
          extends Modelica.Electrical.MultiPhase.Interfaces.ConditionalHeatPort(final
              mh=m, final T=fill(293.15, m));
          Modelica_AddOn.Electrical.Analog.Ideal.IdealDiode idealDiode[m](
            final Ron=Ron,
            final Goff=Goff,
            final Vknee=Vknee,
            each final useHeatPort=useHeatPort) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}}, rotation=0)));
        equation
          connect(plug_p.pin, idealDiode.p)
            annotation (Line(points={{-100,0},{-10,0}}, color={0,0,255}));
          connect(idealDiode.n, plug_n.pin)
            annotation (Line(points={{10,0},{100,0}}, color={0,0,255}));
          connect(idealDiode.heatPort, heatPort) annotation (Line(
              points={{0,-10},{0,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                    100}}), graphics={
                Text(
                  extent={{-150,-40},{150,-100}},
                  textString="%name",
                  lineColor={0,0,255}),
                Line(points={{-90,0},{40,0}}, color={0,0,255}),
                Polygon(
                  points={{30,0},{-30,40},{-30,-40},{30,0}},
                  lineColor={0,0,0},
                  fillColor={255,255,255}),
                Line(points={{30,40},{30,-40}}, color={0,0,255}),
                Line(points={{40,0},{90,0}}, color={0,0,255}),
                Text(
                  extent={{-80,100},{80,60}},
                  lineColor={0,0,0},
                  textString="m=%m")}),
            Documentation(info="<HTML>
<p>
Contains m ideal diodes (Modelica.Electrical.Analog.Ideal.IdealDiode).
</p>
</HTML>"),  Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics));
        end IdealDiode;

        model IdealThyristor "Multiphase ideal thyristor"
          extends Modelica.Electrical.MultiPhase.Interfaces.TwoPlug;
          parameter Modelica.SIunits.Resistance Ron[m](final min=zeros(m), start=fill(
                1.E-5, m)) "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance Goff[m](final min=zeros(m), start=fill(
                1.E-5, m)) "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage Vknee[m](final min=zeros(m), start=zeros(m)) "Threshold voltage";
          Boolean off[m](start=fill(true, m)) "Alias of boolean thyristor off; type, e.g.: off(start=fill(true,m))"
            annotation (Dialog);
          extends Modelica.Electrical.MultiPhase.Interfaces.ConditionalHeatPort(final
              mh=m, final T=fill(293.15, m));
          Modelica.Blocks.Interfaces.BooleanInput fire[m] annotation (Placement(
                transformation(
                origin={70,110},
                extent={{-20,-20},{20,20}},
                rotation=270)));
          Modelica_AddOn.Electrical.Analog.Ideal.IdealThyristor idealThyristor[m](
            final Ron=Ron,
            final Goff=Goff,
            final Vknee=Vknee,
            each final useHeatPort=useHeatPort) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}}, rotation=0)));
        equation
          off = idealThyristor.off;
          connect(plug_p.pin, idealThyristor.p) annotation (Line(points={{-100,0},{-60,
                  0},{-60,0},{-38,0},{-38,0},{-10,0}}, color={0,0,255}));
          connect(idealThyristor.n, plug_n.pin)
            annotation (Line(points={{10,0},{100,0}}, color={0,0,255}));
          connect(fire, idealThyristor.fire) annotation (Line(points={{70,110},{70,80},
                  {7,80},{7,11}}, color={255,0,255}));
          connect(idealThyristor.heatPort, heatPort) annotation (Line(
              points={{0,-10},{0,-100}},
              color={191,0,0},
              pattern=LinePattern.None,
              smooth=Smooth.None));
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}), graphics={
                Text(
                  extent={{-150,-40},{150,-100}},
                  textString="%name",
                  lineColor={0,0,255}),
                Line(points={{-90,0},{40,0}}, color={0,0,255}),
                Polygon(
                  points={{30,0},{-30,40},{-30,-40},{30,0}},
                  lineColor={0,0,0},
                  fillColor={255,255,255}),
                Line(points={{30,40},{30,-40}}, color={0,0,255}),
                Line(points={{40,0},{90,0}}, color={0,0,255}),
                Line(points={{40,50},{60,30}}, color={0,0,255}),
                Line(points={{30,20},{70,60},{70,90}}, color={0,0,255}),
                Text(
                  extent={{-100,100},{60,60}},
                  lineColor={0,0,0},
                  textString="m=%m")}), Documentation(info="<HTML>
<p>
Contains m ideal thyristors (Modelica.Electrical.Analog.Ideal.IdealThyristor).
</p>
</HTML>"));
        end IdealThyristor;

        model IdealGTOThyristor "Multiphase ideal GTO thyristor"
          extends Modelica.Electrical.MultiPhase.Interfaces.TwoPlug;
          parameter Modelica.SIunits.Resistance Ron[m](final min=zeros(m), start=fill(
                1.E-5, m)) "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance Goff[m](final min=zeros(m), start=fill(
                1.E-5, m)) "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage Vknee[m](final min=zeros(m), start=zeros(m)) "Threshold voltage";
          extends Modelica.Electrical.MultiPhase.Interfaces.ConditionalHeatPort(final
              mh=m, final T=fill(293.15, m));
          Modelica.Blocks.Interfaces.BooleanInput fire[m] annotation (Placement(
                transformation(
                origin={70,110},
                extent={{-20,-20},{20,20}},
                rotation=270)));
          Modelica_AddOn.Electrical.Analog.Ideal.IdealGTOThyristor idealGTOThyristor[m](
            final Ron=Ron,
            final Goff=Goff,
            final Vknee=Vknee,
            each final useHeatPort=useHeatPort) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}}, rotation=0)));
        equation
          connect(idealGTOThyristor.p, plug_p.pin)
            annotation (Line(points={{-10,0},{-100,0}}, color={0,0,255}));
          connect(idealGTOThyristor.n, plug_n.pin)
            annotation (Line(points={{10,0},{100,0}}, color={0,0,255}));
          connect(fire, idealGTOThyristor.fire) annotation (Line(points={{70,110},{70,
                  80},{7,80},{7,11}}, color={255,0,255}));
          connect(idealGTOThyristor.heatPort, heatPort) annotation (Line(
              points={{0,-10},{0,-100}},
              color={191,0,0},
              pattern=LinePattern.None,
              smooth=Smooth.None));
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}), graphics={
                Text(
                  extent={{-150,-40},{150,-100}},
                  textString="%name",
                  lineColor={0,0,255}),
                Line(points={{-90,0},{40,0}}, color={0,0,255}),
                Polygon(
                  points={{30,0},{-30,40},{-30,-40},{30,0}},
                  lineColor={0,0,0},
                  fillColor={255,255,255}),
                Line(points={{30,40},{30,-40}}, color={0,0,255}),
                Line(points={{40,0},{90,0}}, color={0,0,255}),
                Line(points={{40,50},{60,30}}, color={0,0,255}),
                Line(points={{30,20},{70,60},{70,90}}, color={0,0,255}),
                Text(
                  extent={{-100,100},{60,60}},
                  lineColor={0,0,0},
                  textString="m=%m")}), Documentation(info="<HTML>
<p>
Contains m ideal GTO thyristors (Modelica.Electrical.Analog.Ideal.IdealGTOThyristor).
</p>
</HTML>"));
        end IdealGTOThyristor;
      end Ideal;

      package Functions "Multiphase functions"
      extends Modelica.Icons.Package;

        function symmetricOrientationMatrix "Matrix symmetric orientation angles for creating the symmetric transformation matrix"
          extends Modelica.Icons.Function;
          import Modelica.Constants.pi;
          input Integer m "Number of phases";
          output Modelica.SIunits.Angle orientation[m, m] "Angles of symmetric transformation matrix";
        algorithm
          // Init transformation matrix with zeros
          orientation := zeros(m, m);
          // Insert non zero coefficients
          if mod(m, 2) == 0 then
            // Even number of phases
            if m == 2 then
              // Special case two phase machine
              orientation := {{0,+pi/2},{0,-pi/2}};
            else
              orientation[1:integer(m/2), 1:integer(m/2)] := symmetricOrientationMatrix(
                integer(m/2));
              orientation[1 + integer(m/2):m, 1 + integer(m/2):m] :=
                symmetricOrientationMatrix(integer(m/2)) - fill(
                pi/m,
                integer(m/2),
                integer(m/2));
            end if;
          else
            // Odd number of phases
            for k in 1:m loop
              orientation[k, :] :=
                Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m)*k;
            end for;
          end if;
          annotation (Documentation(info="<html>
<p>
This function determines the orientation of the symmetrical winding with <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\"> phases. For an odd number of phases the difference of the windings angles of two adjacent phases is <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/2pi_over_m.png\">. In case of an even number of phases the aligned orientation of winding is not modeled since they do not add any information. Instead the <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\"> windings are divided into two different groups. The first group refers to the indices <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/k_le_m_over_2.png\">. The second group covers the indices <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/k_gt_m_over_2.png\">. The difference of the windings angles of two adjacent phases - of both the first and the second group, respectively - is <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/4pi_over_m.png\">. The phase shift of the two groups is <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/pi_over_m.png\">.
</p>
<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.MultiPhase\">User's guide</a> on multi phase winding,
[<a href=\"modelica://Modelica.Electrical.Machines.UsersGuide.References\">Vaske1963</a>.
</p>
</html>"));
        end symmetricOrientationMatrix;

        function symmetricTransformationMatrix "Transformation matrix for symmetrical components"
          extends Modelica.Icons.Function;
          import Modelica.Constants.pi;
          input Integer m "Number of phases";
          output Complex transformation[m, m] "Transformation matrix for m phase symmetrical components";
        algorithm
          // Init transformation matrix with zeros
          transformation := Modelica.ComplexMath.fromPolar(fill(
            numberOfSymmetricBaseSystems(m)/m,
            m,
            m),
            Modelica_AddOn.Electrical.MultiPhase.Functions.symmetricOrientationMatrix(m));
          annotation (Documentation(info="<html>
<p>
This function determines the orientation of the symmetrical winding with <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\"> phases. For an odd number of phases the difference of the windings angles of two adjacent phases is <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/2pi_over_m.png\">. In case of an even number of phases the aligned orientation of winding is not modeled since they do not add any information. Instead the <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\"> windings are divided into two different groups. The first group refers to the indices <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/k_le_m_over_2.png\">. The second group covers the indices <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/k_gt_m_over_2.png\">. The difference of the windings angles of two adjacent phases - of both the first and the second group, respectively - is <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/4pi_over_m.png\">. The phase shift of the two groups is <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/pi_over_m.png\">.
</p>
<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.MultiPhase\">User's guide on multi phase winding</a>,
</p>
</html>"));
        end symmetricTransformationMatrix;

        function numberOfSymmetricBaseSystems "Determines the number of symmeric base systems of m phase symmetric system"
          extends Modelica.Icons.Function;
          input Integer m=3 "Number of phases";
          output Integer n "Number of symmetric base systems";
        algorithm
          // Init number of base systmes
          n := 1;
          if mod(m, 2) == 0 then
            // Even number of phases
            if m == 2 then
              // Special case two phase machine
              n := 1;
            else
              n := n*2*numberOfSymmetricBaseSystems(integer(m/2));
            end if;
          else
            // Odd number of phases
            n := 1;
          end if;
        end numberOfSymmetricBaseSystems;

        function factorY2D "Calculates factor Y voltage to polygon (delta) voltage"
          extends Modelica.Icons.Function;
          import Modelica.Constants.pi;
          input Integer m=3 "Number of phases";
          output Real y "Factor Y to D";
        protected
          parameter Integer mBasic=integer(m/
              Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
              m));
        algorithm
          y := 2*sin(pi/mBasic);
          annotation ();
        end factorY2D;

        function factorY2DC "Calculates factor of DC-voltage from RMS Y-voltage"
          extends Modelica.Icons.Function;
          import Modelica.Constants.pi;
          input Integer m=3 "Number of phases";
          output Real y "Factor Yrms to DC";
        protected
          parameter Integer mBasic=integer(m/
              Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
              m));
        algorithm
          y := sqrt(2)*2*sin((mBasic - 1)/mBasic*pi/2)*sin(pi/(2*m))/(pi/(2*m));
        end factorY2DC;

        function indexPositiveSequence "Determines the indices of the all positive sequences"
          extends Modelica.Icons.Function;
          input Integer m=3 "Number of phases";
          output Integer ind[
            Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
            m)] "Number of symmetric base systems";
        protected
          Integer n=
              Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
              m);
        algorithm
          if n == 1 then
            ind[1] := 1;
          else
            ind := (0:n - 1)*integer(m/n) + ones(n);
          end if;
        end indexPositiveSequence;

        function indexNonPositiveSequence "Determines the indices of all non positive sequences"
          extends Modelica.Icons.Function;
          input Integer m=3 "Number of phases";
          output Integer ind[
            Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
            m)*(integer(m/
            Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
            m)) - 1)] "Indices of non positive sequences";
        protected
          Integer n=
              Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
              m) "Number of base systems";
          Integer mbas=integer(m/n) "Number of phases of base system";
        algorithm
          if mbas == 1 then
            ind := fill(0, 0);
          elseif mbas == 2 then
            for k in 1:n loop
              ind[k] := 2 + 2*(k - 1);
            end for;
          else
            for k in 1:n loop
              ind[(mbas - 1)*(k - 1) + 1:(mbas - 1)*k] := (2:mbas) + mbas*(k - 1)*ones(
                mbas - 1);
            end for;
          end if;
        end indexNonPositiveSequence;
      end Functions;
    end MultiPhase;

    package QuasiStatic "Quasi static electrical"
    extends Modelica.Icons.Package;
      package MultiPhase "Quasi static multi phase"
      extends Modelica.Icons.Package;

        package Basic "Basic for quasi stationary multi phase systems"
        extends Modelica.Icons.Package;

          model MultiStar "Star connection of multi phase systems consisting of multiple base systems"
            import Modelica;
            parameter Integer m(final min=1) = 3 "Number of phases";
            final parameter Integer mSystems=
                Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
                m) "Number of base systems";
            final parameter Integer mBasic=integer(m/mSystems) "Phase number of base systems";
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.PositivePlug plug_p(
                final m=m) annotation (Placement(transformation(extent={{-110,-10},{-90,
                      10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.NegativePlug
              starpoints(final m=mSystems) annotation (Placement(transformation(extent={{
                      90,-10},{110,10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.PlugToPins_p
              plugToPins_p(final m=m) annotation (Placement(transformation(extent={{-80,-10},
                      {-60,10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.PlugToPins_n
              plugToPins_n(final m=mSystems)
              annotation (Placement(transformation(extent={{80,-10},{60,10}})));
          equation
            for k in 1:mSystems loop
              for j in 1:mBasic loop
                connect(plugToPins_p.pin_p[(k - 1)*mBasic + j], plugToPins_n.pin_n[k]);
              end for;
            end for;
            connect(plug_p, plugToPins_p.plug_p)
              annotation (Line(points={{-100,0},{-72,0}}, color={85,170,255}));
            connect(plugToPins_n.plug_n, starpoints) annotation (Line(
                points={{72,0},{100,0}},
                color={85,170,255},
                smooth=Smooth.None));
            annotation (
              Icon(graphics={
                  Text(
                    extent={{-150,60},{150,120}},
                    textString="%name",
                    lineColor={0,0,255}),
                  Line(
                    points={{86,4},{6,4}},
                    color={0,0,255},
                    thickness=0.5),
                  Line(
                    points={{6,4},{-33,72}},
                    color={0,0,255},
                    thickness=0.5),
                  Line(
                    points={{6,4},{-32,-65}},
                    color={0,0,255},
                    thickness=0.5),
                  Text(
                    extent={{-100,-110},{100,-70}},
                    lineColor={0,0,0},
                    textString="m=%m"),
                  Line(points={{-90,0},{-40,0}}, color={0,0,255}),
                  Line(points={{80,0},{90,0}}, color={0,0,255}),
                  Line(
                    points={{-6,-4},{-45,64}},
                    color={0,0,255},
                    thickness=0.5),
                  Line(
                    points={{74,-4},{-6,-4}},
                    color={0,0,255},
                    thickness=0.5),
                  Line(
                    points={{-6,-4},{-44,-73}},
                    color={0,0,255},
                    thickness=0.5)}),
              Documentation(info="<html>
<p>
Star (wye) connection of a multi phase circuit consiting of multiple base systems (see
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.MultiPhase\">multi phase guidelines</a>). The potentials at the star points are all equal.
</p>
<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star\">Star</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Delta\">Delta</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Basic.MultiDelta\">MultiDelta</a>
</p></html>"),Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics));
          end MultiStar;

          model MultiDelta "Delta (polygon) connection of multi phase systems consisting of multiple base systems"
            import Modelica;
            parameter Integer m(final min=2) = 3 "Number of phases";
            final parameter Integer mSystems=
                Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
                m) "Number of base systems";
            final parameter Integer mBasic=integer(m/mSystems) "Phase number of base systems";
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.PositivePlug plug_p(
                final m=m) annotation (Placement(transformation(extent={{-110,-10},{-90,
                      10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.NegativePlug plug_n(
                final m=m) annotation (Placement(transformation(extent={{90,-10},{110,10}},
                    rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.PlugToPins_p
              plugToPins_p(final m=m) annotation (Placement(transformation(extent={{-80,-10},
                      {-60,10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.PlugToPins_n
              plugToPins_n(final m=m) annotation (Placement(transformation(extent={{80,-10},
                      {60,10}}, rotation=0)));
          equation
            for k in 1:mSystems loop
              for j in 1:mBasic - 1 loop
                connect(plugToPins_n.pin_n[(k - 1)*mBasic + j], plugToPins_p.pin_p[(k - 1)
                  *mBasic + j + 1]);
              end for;
              connect(plugToPins_n.pin_n[k*mBasic], plugToPins_p.pin_p[(k - 1)*mBasic + 1]);
            end for;
            connect(plug_p, plugToPins_p.plug_p) annotation (Line(points={{-100,0},{-93,0},
                    {-86,0},{-72,0}}, color={85,170,255}));
            connect(plugToPins_n.plug_n, plug_n) annotation (Line(points={{72,0},{79,0},{
                    79,0},{86,0},{86,0},{100,0}}, color={85,170,255}));
            annotation (Icon(graphics={
                  Text(
                    extent={{-150,60},{150,120}},
                    lineColor={0,0,255},
                    textString="%name"),
                  Line(
                    points={{-44,62},{-44,-76},{75,-6},{-44,62},{-44,61}},
                    color={0,0,255},
                    thickness=0.5),
                  Text(
                    extent={{-100,-110},{100,-70}},
                    lineColor={0,0,0},
                    textString="m=%m"),
                  Line(points={{-90,0},{-44,0}}, color={0,0,255}),
                  Line(points={{80,0},{90,0}}, color={0,0,255}),
                  Line(
                    points={{-36,74},{-36,-64},{83,6},{-36,74},{-36,73}},
                    color={0,0,255},
                    thickness=0.5)}), Documentation(info="<html>
<p>
Delta (polygon) connection of a multi phase circuit consiting of multiple base systems (see
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.MultiPhase\">multi phase guidelines</a>). 
</p>
<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star\">Star</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Delta\">Delta</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Basic.MultiStar\">MultiStar</a>
</p>
</html>"));
          end MultiDelta;

          model MultiStarResistance "Resistance connection of star points"
            parameter Integer m(final min=3) = 3 "Number of phases";
            final parameter Integer mBasic=
                Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
                m) "Number of symmetric base systems";
            parameter Modelica.SIunits.Resistance R=1e6 "Insulation resistance between base systems";
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.PositivePlug plug(m=
                 m) annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
            Modelica_AddOn.Electrical.QuasiStatic.MultiPhase.Basic.MultiStar multiStar(m=
                  m) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-50,0})));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Resistor resistor(m=
                  mBasic, final R_ref=fill(R, mBasic)) annotation (Placement(
                  transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={0,0})));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star star(m=mBasic)
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={50,0})));
            Modelica.Electrical.QuasiStationary.SinglePhase.Interfaces.NegativePin pin
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=180,
                  origin={100,0})));
          equation
            connect(plug, multiStar.plug_p) annotation (Line(
                points={{-100,0},{-60,0}},
                color={85,170,255},
                smooth=Smooth.None));
            connect(multiStar.starpoints, resistor.plug_p) annotation (Line(
                points={{-40,0},{-10,0}},
                color={85,170,255},
                smooth=Smooth.None));
            connect(resistor.plug_n, star.plug_p) annotation (Line(
                points={{10,0},{40,0}},
                color={85,170,255},
                smooth=Smooth.None));
            connect(star.pin_n, pin) annotation (Line(
                points={{60,0},{100,0}},
                color={85,170,255},
                smooth=Smooth.None));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                      100}}), graphics={
                  Line(
                    points={{-40,40},{0,0},{40,40},{0,0},{0,-40}},
                    color={0,0,255},
                    smooth=Smooth.None,
                    origin={-60,0},
                    rotation=90),
                  Rectangle(
                    extent={{-10,20},{10,-20}},
                    lineColor={0,0,255},
                    origin={0,0},
                    rotation=90),
                  Line(
                    points={{-40,40},{0,0},{40,40},{0,0},{0,-40}},
                    color={0,0,255},
                    smooth=Smooth.None,
                    origin={60,0},
                    rotation=90)}),
              Documentation(info="<html>
<p>
Multi star points are connected by resistors. This model is required to operate multi phase systems with even phase numbers to avoid ideal connections of start points of base systems; see
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.MultiPhase\">multi phase guidelines</a>.
</p>
</html>"));
          end MultiStarResistance;
        end Basic;

        package Blocks "Blocks for quasi stationary multi phase systems"
        extends Modelica.Icons.Package;
          block QuasiRMS
            import Modelica;
            extends Modelica.Blocks.Interfaces.SO;
            parameter Integer m(min=2) = 3 "Number of phases";
            Modelica.ComplexBlocks.Interfaces.ComplexInput u[m]
              annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
          equation
            y = Modelica_AddOn.Electrical.QuasiStatic.MultiPhase.Functions.quasiRMS(u);
            annotation (Documentation(info="<HTML>
<p>
This block determines the continuous quasi <a href=\"Modelica://Modelica.Blocks.Math.RootMeanSquare\">RMS</a> value of a multi phase system, representiong an equivalent RMS vector or phasor.
</p>
<pre>
 y = sqrt(sum(u[k]^2 for k in 1:m)/m)
</pre>
</HTML>"));
          end QuasiRMS;

          block SymmetricalComponents "Creates symmetrical components from signals representing quasi static phasors"
            import Modelica;
            extends Modelica.ComplexBlocks.Interfaces.ComplexMIMO(final nin=m,final nout=
                  m);
            parameter Integer m=3 "Number of phases";
          equation
            y =
              Modelica_AddOn.Electrical.MultiPhase.Functions.symmetricTransformationMatrix(
              m)*u;
            annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                      -100},{100,100}}), graphics), Icon(coordinateSystem(
                    preserveAspectRatio=false, extent={{-100,-100},{100,100}}), graphics={
                  Line(
                    points={{-44,0},{-44,0},{-8,-20},{-22,-16},{-18,-10},{-8,-20}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{-44,0},{-44,40},{-40,26},{-48,26},{-44,40}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{-18,10},{-18,10},{2,-24},{-8,-14},{-2,-10},{2,-24}},
                    color={0,0,255},
                    smooth=Smooth.None,
                    origin={-54,-18},
                    rotation=-90),
                  Line(
                    points={{42,48},{42,48},{78,28},{64,32},{68,38},{78,28}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{42,48},{42,88},{46,74},{38,74},{42,88}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{-18,10},{-18,10},{2,-24},{-8,-14},{-2,-10},{2,-24}},
                    color={0,0,255},
                    smooth=Smooth.None,
                    origin={32,30},
                    rotation=-90),
                  Line(
                    points={{42,-22},{42,-22},{78,-42},{64,-38},{68,-32},{78,-42}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{42,-22},{42,18},{46,4},{38,4},{42,18}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{-18,10},{-18,10},{2,-24},{-8,-14},{-2,-10},{2,-24}},
                    color={0,0,255},
                    smooth=Smooth.None,
                    origin={32,-40},
                    rotation=-90),
                  Line(
                    points={{42,-88},{42,-48},{46,-62},{38,-62},{42,-48}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{52,-88},{52,-48},{56,-62},{48,-62},{52,-48}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{32,-88},{32,-48},{36,-62},{28,-62},{32,-48}},
                    color={0,0,255},
                    smooth=Smooth.None)}));
          end SymmetricalComponents;

          block SingleToMultiPhase "Extends complex phase signal to complex multi phase signals using symmetricOrientation"
            extends Modelica.ComplexBlocks.Interfaces.ComplexSIMO(final nout=m);
            parameter Integer m=3 "Number of phases";
          equation
            y = u*Modelica.ComplexMath.fromPolar(fill(1, m), -
              Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m));
            annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                      -100},{100,100}}), graphics={Line(
                    points={{-60,-20},{-60,20},{-56,8},{-64,8},{-60,20}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{40,-20},{40,20},{44,8},{36,8},{40,20}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{40,-20},{40,-20},{76,-40},{64,-38},{68,-30},{76,-40}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{-18,10},{-18,10},{2,-24},{-8,-16},{-2,-10},{2,-24}},
                    color={0,0,255},
                    smooth=Smooth.None,
                    origin={30,-38},
                    rotation=-90)}), Icon(graphics={
                  Line(
                    points={{-60,-20},{-60,20},{-56,8},{-64,8},{-60,20}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{40,-20},{40,20},{44,6},{36,6},{40,20}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{40,-20},{40,-20},{76,-40},{62,-36},{66,-30},{76,-40}},
                    color={0,0,255},
                    smooth=Smooth.None),
                  Line(
                    points={{-18,10},{-18,10},{2,-24},{-8,-14},{-2,-10},{2,-24}},
                    color={0,0,255},
                    smooth=Smooth.None,
                    origin={30,-38},
                    rotation=-90)}));
          end SingleToMultiPhase;

          block ToSpacePhasor "Conversion: m phase -> space phasor"
            extends Modelica.Blocks.Icons.Block;
            import Modelica.ComplexMath.j;
            import Modelica.ComplexMath.exp;
            import Modelica.ComplexMath.'sum';
            parameter Integer m(min=1) = 3 "Number of phases";
            Modelica.ComplexBlocks.Interfaces.ComplexInput u[m]
              annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
            Modelica.Blocks.Interfaces.RealOutput y[2]
              annotation (Placement(transformation(extent={{100,-10},{120,10}})));
          protected
            parameter Modelica.SIunits.Angle phi[m]=
                Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m);
            Complex c;
          equation
            c = sqrt(2)/m*'sum'({u[k]*exp(j*phi[k]) for k in 1:m});
            y = {c.re,c.im};
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                      100}}), graphics={
                  Line(points={{0,0},{80,80},{60,72},{72,60},{80,80}}, color={0,0,255}),
                  Line(points={{0,0},{80,-80},{72,-60},{60,-72},{80,-80}}, color={0,0,255}),
                  Line(
                    points={{-80,0},{-73.33,10},{-66.67,17.32},{-60,20},{-53.33,17.32},{-46.67,
                        10},{-40,0},{-33.33,-10},{-26.67,-17.32},{-20,-20},{-13.33,-17.32},
                        {-6.67,-10},{0,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Line(
                    points={{-90,0},{-83.33,10},{-76.67,17.32},{-70,20},{-63.33,17.32},{-56.67,
                        10},{-50,0},{-43.33,-10},{-36.67,-17.32},{-30,-20},{-23.33,-17.32},
                        {-16.67,-10},{-10,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Line(
                    points={{-70,0},{-63.33,10},{-56.67,17.32},{-50,20},{-43.33,17.32},{-36.67,
                        10},{-30,0},{-23.33,-10},{-16.67,-17.32},{-10,-20},{-3.33,-17.32},
                        {3.33,-10},{10,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Text(
                    extent={{-12,-74},{64,-86}},
                    lineColor={0,0,0},
                    textString="zero")}),
              Documentation(info="<HTML>
    Transformation of m phase values (voltages or currents) to space phasor.
</HTML>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics));
          end ToSpacePhasor;

          block FromSpacePhasor "Conversion: space phasor -> m phase"
            extends Modelica.Blocks.Icons.Block;
            import Modelica.ComplexMath.j;
            import Modelica.ComplexMath.exp;
            parameter Integer m(min=1) = 3 "Number of phases";
            Modelica.Blocks.Interfaces.RealInput u[2]
              annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
            Modelica.ComplexBlocks.Interfaces.ComplexOutput y[m]
              annotation (Placement(transformation(extent={{100,-10},{120,10}})));
          protected
            parameter Modelica.SIunits.Angle phi[m]=
                Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m);
          equation
            y = {Complex(u[1], u[2])*exp(-j*phi[k])/sqrt(2) for k in 1:m};
            annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                      {100,100}}), graphics={
                  Line(points={{0,0},{-80,80},{-60,72},{-72,60},{-80,80}}, color={0,0,255}),
                  Line(points={{0,0},{-80,-80},{-72,-60},{-60,-72},{-80,-80}}, color={0,0,
                        255}),
                  Line(
                    points={{0,0},{6.67,10},{13.33,17.32},{20,20},{26.67,17.32},{33.33,10},
                        {40,0},{46.67,-10},{53.33,-17.32},{60,-20},{66.67,-17.32},{73.33,
                        -10},{80,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Line(
                    points={{-10,0},{-3.33,10},{3.33,17.32},{10,20},{16.67,17.32},{23.33,
                        10},{30,0},{36.67,-10},{43.33,-17.32},{50,-20},{56.67,-17.32},{
                        63.33,-10},{70,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Line(
                    points={{10,0},{16.67,10},{23.33,17.32},{30,20},{36.67,17.32},{43.33,
                        10},{50,0},{56.67,-10},{63.33,-17.32},{70,-20},{76.67,-17.32},{
                        83.33,-10},{90,0}},
                    color={0,0,255},
                    smooth=Smooth.Bezier),
                  Text(
                    extent={{-62,-74},{14,-86}},
                    lineColor={0,0,0},
                    textString="zero")}), Documentation(info="<HTML>
          Transformation of space phasorto m phase values (voltages or currents).
</HTML>"));
          end FromSpacePhasor;
        end Blocks;

        package Sensors "Sensors for quasi stationary multi phase systems"
        extends Modelica.Icons.Package;

          model ReferenceSensor "Sensor of reference angle gamma"
            extends Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.AbsoluteSensor;
            Modelica.Blocks.Interfaces.RealOutput y "Reference angle" annotation (
                Placement(transformation(extent={{100,-10},{120,10}}, rotation=0)));
          equation
            y = plug_p.reference.gamma;
            plug_p.pin.i = fill(Complex(0), m);
            annotation (Icon(graphics={Text(
                    extent={{60,-60},{-60,-30}},
                    lineColor={0,0,0},
                    fillColor={0,0,0},
                    fillPattern=FillPattern.Solid,
                    textString="ref")}), Diagram(coordinateSystem(preserveAspectRatio=
                      false, extent={{-100,-100},{100,100}}), graphics));
          end ReferenceSensor;

          model CurrentQuasiRMSSensor "Continuous quasi current RMS sensor for multi phase system"
            extends Modelica.Icons.RotationalSensor;
            extends Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.TwoPlug;
            parameter Integer m(min=1) = 3 "Number of phases";
            Modelica.Blocks.Interfaces.RealOutput I "Continuous quasi average RMS of current"
                                                        annotation (Placement(
                  transformation(
                  origin={0,-100},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.QuasiStationary.SinglePhase.Sensors.CurrentSensor
              currentSensor[m] annotation (Placement(transformation(extent={{-10,-10},{10,
                      10}}, rotation=0)));
            Modelica_AddOn.Electrical.QuasiStatic.MultiPhase.Blocks.QuasiRMS quasiRMS(
                final m=m) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={0,-50})));
          equation
            connect(quasiRMS.y, I) annotation (Line(
                points={{0,-61},{0,-100}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(plugToPins_p.pin_p, currentSensor.pin_p) annotation (Line(
                points={{-68,0},{-10,0}},
                color={85,170,255},
                smooth=Smooth.None));
            connect(currentSensor.pin_n, plugToPins_n.pin_n) annotation (Line(
                points={{10,0},{68,0}},
                color={85,170,255},
                smooth=Smooth.None));
            connect(currentSensor.y, quasiRMS.u) annotation (Line(
                points={{0,-11},{0,-38}},
                color={85,170,255},
                smooth=Smooth.None));
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                      100}}), graphics={
                  Line(points={{-90,0},{-70,0}}, color={0,0,255}),
                  Line(points={{0,-70},{0,-90}}, color={0,0,255}),
                  Text(
                    extent={{-100,60},{100,120}},
                    textString="%name",
                    lineColor={0,0,255}),
                  Text(
                    extent={{-100,-60},{-20,-100}},
                    lineColor={0,0,0},
                    textString="m="),
                  Text(
                    extent={{20,-60},{100,-100}},
                    lineColor={0,0,0},
                    textString="%m"),
                  Line(points={{70,0},{90,0}}, color={0,0,255})}),
              Documentation(revisions="<html>
</html>",           info="<html>
<p>This sensor determines the continuous quasi <a href=\"Modelica://Modelica.Blocks.Math.RootMeanSquare\">RMS</a> value of a multi phase current system, representiong an equivalent RMS current vector <code>I</code> or phasor.</p>
<pre> I = sqrt(sum(i[k]^2 for k in 1:m)/m)</pre>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics));
          end CurrentQuasiRMSSensor;

          model VoltageQuasiRMSSensor "Continuous quasi voltage RMS sensor for multi phase system"
            extends Modelica.Icons.RotationalSensor;
            extends Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.TwoPlug;
            parameter Integer m(min=1) = 3 "Number of phases";
            Modelica.Blocks.Interfaces.RealOutput V "Continuous quasi average RMS of current"
                                                        annotation (Placement(
                  transformation(
                  origin={0,-100},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.QuasiStationary.SinglePhase.Sensors.VoltageSensor
              voltageSensor[m] annotation (Placement(transformation(extent={{-10,-10},{10,
                      10}}, rotation=0)));
            Modelica_AddOn.Electrical.QuasiStatic.MultiPhase.Blocks.QuasiRMS quasiRMS(
                final m=m) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={0,-50})));
          equation
            connect(quasiRMS.y, V) annotation (Line(
                points={{0,-61},{0,-100}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(plugToPins_p.pin_p, voltageSensor.pin_p) annotation (Line(
                points={{-68,0},{-10,0}},
                color={85,170,255},
                smooth=Smooth.None));
            connect(voltageSensor.pin_n, plugToPins_n.pin_n) annotation (Line(
                points={{10,0},{68,0}},
                color={85,170,255},
                smooth=Smooth.None));
            connect(voltageSensor.y, quasiRMS.u) annotation (Line(
                points={{0,-11},{0,-38}},
                color={85,170,255},
                smooth=Smooth.None));
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                      100}}), graphics={
                  Line(points={{-90,0},{-70,0}}, color={0,0,255}),
                  Line(points={{0,-70},{0,-90}}, color={0,0,255}),
                  Text(
                    extent={{-100,60},{100,120}},
                    textString="%name",
                    lineColor={0,0,255}),
                  Text(
                    extent={{-100,-60},{-20,-100}},
                    lineColor={0,0,0},
                    textString="m="),
                  Text(
                    extent={{20,-60},{100,-100}},
                    lineColor={0,0,0},
                    textString="%m"),
                  Line(points={{70,0},{90,0}}, color={0,0,255})}),
              Documentation(revisions="<html>
</html>",           info="<html>
<p>This sensor determines the continuous quasi <a href=\"Modelica://Modelica.Blocks.Math.RootMeanSquare\">RMS</a> value of a multi phase voltage system, representiong an equivalent RMS voltage vector V or phasor.</p>
<pre> V = sqrt(sum(v[k]^2 for k in 1:m)/m)</pre>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics));
          end VoltageQuasiRMSSensor;

          model PowerSensor "Power sensor"
            extends Modelica.Icons.RotationalSensor;
            parameter Integer m(min=1) = 3 "number of phases";
            Modelica.SIunits.AngularVelocity omega=der(currentP.reference.gamma);
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.PositivePlug
              currentP(final m=m) annotation (Placement(transformation(extent={{-110,-10},
                      {-90,10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.NegativePlug
              currentN(final m=m) annotation (Placement(transformation(extent={{90,-10},{
                      110,10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.PositivePlug
              voltageP(final m=m) annotation (Placement(transformation(extent={{-10,90},{
                      10,110}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.NegativePlug
              voltageN(final m=m) annotation (Placement(transformation(extent={{-10,-110},
                      {10,-90}}, rotation=0)));
            Modelica.ComplexBlocks.Interfaces.ComplexOutput y annotation (Placement(
                  transformation(
                  origin={-80,-110},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.PlugToPins_p
              plugToPinsCurrentP(final m=m) annotation (Placement(transformation(extent={
                      {-80,-10},{-60,10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.PlugToPins_p
              plugToPinsVoltageP(final m=m) annotation (Placement(transformation(
                  origin={0,70},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.PlugToPins_n
              plugToPinsCurrentN(final m=m) annotation (Placement(transformation(extent={
                      {80,-10},{60,10}}, rotation=0)));
            Modelica.Electrical.QuasiStationary.MultiPhase.Basic.PlugToPins_n
              plugToPinsVoltageN(final m=m) annotation (Placement(transformation(
                  origin={0,-70},
                  extent={{-10,10},{10,-10}},
                  rotation=90)));
            Modelica.Electrical.QuasiStationary.SinglePhase.Sensors.PowerSensor
              powerSensor[m] annotation (Placement(transformation(extent={{-10,-10},{10,
                      10}}, rotation=0)));
            Modelica.ComplexBlocks.ComplexMath.Sum sum(final nin=m) annotation (Placement(
                  transformation(
                  origin={-80,-70},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
          equation
            connect(plugToPinsCurrentP.plug_p, currentP) annotation (Line(points={{-72,0},
                    {-79,0},{-86,0},{-100,0}}, color={85,170,255}));
            connect(currentN, plugToPinsCurrentN.plug_n) annotation (Line(points={{100,0},
                    {93,0},{86,0},{72,0}}, color={85,170,255}));
            connect(voltageP, plugToPinsVoltageP.plug_p)
              annotation (Line(points={{0,100},{0,100},{0,72}}, color={85,170,255}));
            connect(plugToPinsVoltageN.plug_n, voltageN)
              annotation (Line(points={{0,-72},{0,-72},{0,-100}}, color={85,170,255}));
            connect(plugToPinsCurrentP.pin_p, powerSensor.currentP) annotation (Line(
                  points={{-68,0},{-53.5,0},{-53.5,0},{-39,0},{-39,0},{-10,0}}, color={85,
                    170,255}));
            connect(powerSensor.currentN, plugToPinsCurrentN.pin_n) annotation (Line(
                  points={{10,0},{24.5,0},{24.5,0},{39,0},{39,0},{68,0}}, color={85,170,
                    255}));
            connect(powerSensor.voltageP, plugToPinsVoltageP.pin_p) annotation (Line(
                  points={{0,10},{0,10},{0,68},{0,68}}, color={85,170,255}));
            connect(powerSensor.voltageN, plugToPinsVoltageN.pin_n) annotation (Line(
                  points={{0,-10},{0,-10},{0,-68},{0,-68}}, color={85,170,255}));
            connect(powerSensor.y, sum.u) annotation (Line(points={{-8,-11},{-8,-40},{-80,
                    -40},{-80,-58}}, color={85,170,255}));
            connect(sum.y, y)
              annotation (Line(points={{-80,-81},{-80,-110}}, color={85,170,255}));
            annotation (
              Icon(graphics={
                  Line(points={{0,100},{0,70}}, color={0,0,255}),
                  Line(points={{0,-70},{0,-100}}, color={0,0,255}),
                  Text(extent={{-29,-70},{30,-11}}, textString="P"),
                  Line(points={{-80,-100},{-80,0}}, color={85,170,255}),
                  Text(
                    textColor={0,0,255},
                    extent={{-100,110},{100,150}},
                    textString="%name"),
                  Line(points={{-100,0},{100,0}}, color={0,0,255})}),
              Documentation(info="<html>

<p>
This sensor can be used to measure <i>m</i> complex apparent power values, using <i>m</i>
<a href=\"modelica://Modelica.Electrical.QuasiStationary.SinglePhase.Sensors.PowerSensor\">single phase PowerSensors</a>.
</p>

<h4>See also</h4>

<p>
<a href=\"modelica://Modelica.Electrical.QuasiStationary.SinglePhase.Sensors.PowerSensor\">SinglePhase.PowerSensor</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sensors.PotentialSensor\">PotentialSensor</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sensors.VoltageSensor\">VoltageSensor</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sensors.CurrentSensor\">CurrentSensor</a>
</p>

</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics));
          end PowerSensor;
        end Sensors;

        package Sources "Soruces for quasi stationary multi phase systems"
        extends Modelica.Icons.Package;

          model ReferenceVoltageSource "Variable multiphase AC voltage with reference angle input"
            extends Modelica_AddOn.Electrical.QuasiStatic.MultiPhase.Interfaces.ReferenceSource;
            import Modelica.Constants.pi;
            Modelica.Blocks.Interfaces.RealInput gamma "Reference angle of voltage source"
                                                  annotation (Placement(transformation(
                  origin={40,100},
                  extent={{-20,-20},{20,20}},
                  rotation=270)));
            Modelica.ComplexBlocks.Interfaces.ComplexInput V[m] annotation (Placement(
                  transformation(
                  origin={-40,100},
                  extent={{-20,-20},{20,20}},
                  rotation=270)));
          equation
            plug_p.reference.gamma = gamma;
            v = V;
            annotation (Documentation(info="<html>

<p>
This model describes <i>m</i> variable current sources, with <i>m</i> complex signal inputs,
specifying the complex current by the complex RMS voltage components.
Additionally, the frequency of the current source is defined by a real signal input.
<i>m</i> <a href=\"modelica://Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VariableCurrentSource\">single phase VariableCurrentSources</a> are used.
</p>

<h4>See also</h4>

<p>
<a href=\"modelica://Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource\">SinglePhase.VoltageSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VoltageSource\">VoltageSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VariableVoltageSource\">VariableVoltageSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.CurrentSource\">CurrentSource</a>.
</p>
</html>"),           Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics));
          end ReferenceVoltageSource;

          model ReferenceCurrentSource "Variable multiphase AC current with reference angle input"
            extends Modelica_AddOn.Electrical.QuasiStatic.MultiPhase.Interfaces.ReferenceSource;
            import Modelica.Constants.pi;
            Modelica.Blocks.Interfaces.RealInput gamma "Reference angle of current source"
                                                  annotation (Placement(transformation(
                  origin={40,100},
                  extent={{-20,-20},{20,20}},
                  rotation=270)));
            Modelica.ComplexBlocks.Interfaces.ComplexInput I[m] annotation (Placement(
                  transformation(
                  origin={-40,100},
                  extent={{-20,-20},{20,20}},
                  rotation=270)));
          equation
            plug_p.reference.gamma = gamma;
            i = I;
            annotation (
              Icon(graphics={
                  Line(points={{-60,60},{60,60}}, color={85,170,255}),
                  Polygon(
                    points={{60,60},{30,70},{30,50},{60,60}},
                    lineColor={0,0,255},
                    fillColor={0,0,255},
                    fillPattern=FillPattern.Solid),
                  Line(points={{0,-50},{0,50}}, color={0,0,0})}),
              Documentation(info="<html>

<p>
This model describes <i>m</i> variable current sources, with <i>m</i> complex signal inputs,
specifying the complex current by the complex RMS voltage components.
Additionally, the frequency of the current source is defined by a real signal input.
<i>m</i> <a href=\"modelica://Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VariableCurrentSource\">single phase VariableCurrentSources</a> are used.
</p>

<h4>See also</h4>

<p>
<a href=\"modelica://Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource\">SinglePhase.VoltageSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VoltageSource\">VoltageSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VariableVoltageSource\">VariableVoltageSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.CurrentSource\">CurrentSource</a>.
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}}), graphics));
          end ReferenceCurrentSource;
        end Sources;

        package Interfaces "Interfaces for quasi stationary multi phase systems"
        extends Modelica.Icons.Package;
          partial model ReferenceSource "Partial of voltage or current source with reference input"
            extends Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.OnePort;
            import Modelica.Constants.pi;
          equation
            Connections.root(plug_p.reference);
            annotation (Icon(graphics={
                  Ellipse(
                    extent={{-50,50},{50,-50}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Text(
                    extent={{100,-100},{-100,-60}},
                    textString="%name",
                    lineColor={0,0,255}),
                  Line(points={{-90,0},{-50,0}}, color={0,0,0}),
                  Line(points={{50,0},{90,0}}, color={0,0,0}),
                  Text(
                    extent={{100,60},{-100,100}},
                    lineColor={0,0,0},
                    fillColor={0,0,0},
                    fillPattern=FillPattern.Solid,
                    textString="m=%m")}), Documentation(info="<html>
<p>
The source partial model relies on the
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces.TwoPlug\">TwoPlug</a> and contains a proper icon.
</p>

<h4>See also</h4>

<p>
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VoltageSource\">VoltageSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VariableVoltageSource\">VariableVoltageSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.CurrentSource\">CurrentSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VariableCurrentSource\">VariableCurrentSource</a>,
<a href=\"modelica://Modelica.Electrical.QuasiStationary.SinglePhase.Interfaces.Source\">SinglePhase.Interfaces.Source</a>.
</p>
</html>"));
          end ReferenceSource;
        end Interfaces;

        package Functions "Functions for quasi stationary multi phase systems"
        extends Modelica.Icons.Package;

          function quasiRMS "Overall quasi-RMS value of complex input (current or voltage)"
            extends Modelica.Icons.Function;
            import Modelica.ComplexMath.'abs';
            input Complex u[:];
            output Real y;
            import Modelica.Constants.pi;
          protected
            Integer m=size(u, 1) "Number of phases";
          algorithm
            y := sum({'abs'(u[k]) for k in 1:m})/m;
            annotation (Inline=true, Documentation(info="<HTML>
  This function determines the continuous quasi <a href=\"Modelica://Modelica.Blocks.Math.RootMeanSquare\">RMS</a> value of a multi phase system, 
  represented by m quasi static time domain phasors. 
</HTML>"));
          end quasiRMS;

          function activePower "Calculate active power of complex input voltage and current"
            extends Modelica.Icons.Function;
            input Modelica.SIunits.ComplexVoltage v[:] "QuasiStationary voltage phasors";
            input Modelica.SIunits.ComplexCurrent i[size(v, 1)] "QuasiStationary current phasors";
            output Modelica.SIunits.Power p "Active power";
          algorithm
            p := sum(Modelica.ComplexMath.real({v[k]*Modelica.ComplexMath.conj(i[k]) for
              k in 1:size(v, 1)}));
            annotation (Inline=true, Documentation(info="<HTML>
<p>
Calculates instantaneous power from multiphase voltages and currents.
In quasistaionary operation, instantaneous power equals active power;
</p>
</HTML>"));
          end activePower;
        end Functions;
      end MultiPhase;
    end QuasiStatic;

    package PowerConverters "Rectifiers, Inverters and DC/DC converters"
      extends Modelica.Icons.Package;
      package UsersGuide "User's Guide"
        extends Modelica.Icons.Information;
        class ACDCConcept "AC/DC converter concept"
          extends Modelica.Icons.Information;
          annotation (DocumentationClass=true, Documentation(info="<html>

<p>AC/DC converters are also called rectifiers</p>

<h4>Component classification</h4>

<p>Convential AC/DC converters contain diodes and thyristors. If thyristors are used, the output voltage of the rectifier can be controlled. If only diodes are used, the output voltages is solely dependent on the input voltage and the characteristic of applied diodes.</p>
<ul>
  <li>Diode rectifiers</li>
  <li>Thyristor rectifiers</li>
  <li>Half controlled rectifiers; half of the semiconductors are diodes and thyristors, respectively</li>
</ul>

<h4>Topology classificaton</h4>

<p>The PowerConverters library provides bridge and center tap rectifiers for single and multi phase supply, see 
<a href=\"modelica://Modelica_Electrical_PowerConverters.ACDC\">AC/DC converters</a>.</p>

<h4>Control</h4>

<p>For each of the provided rectifiers a 
<a href=\"modelica://Modelica_Electrical_PowerConverters.ACDC.Control\">control model</a> is availanble. 
These control models have electrical connectors to be connected with the AC suppy. 
The firing angle of thyristor rectifiers can either be set by a parameter or a signal input. 
</p>

<h4>Examples</h4>

<p>A variety of examples is provided at
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC\">Examples.ACDC</a>. 
These examples include different kinds of DC loads. Even the control characeteristics 
of the rectifiers can be obtained experimentally; the names of these models 
contain <code>_Characteristic</code>.
</p>
</html>"));
        end ACDCConcept;

        class DCACConcept "DC/AC converter concept"
          extends Modelica.Icons.Information;
          annotation (DocumentationClass=true, Documentation(info="<html>

<p>There are a single and multi phase DC/AC converter model provided by the PowerConverters library.</p>

<h4>Control</h4>

<p>There are currently no space phasor pulse width modulation (PWM) models provided. However, for operating the single 
and multi phase inverter the PWM 
<a href=\"modelica://Modelica_Electrical_PowerConverters.DCDC.Control.SignalPWM\">controller</a> 
can be used. 
</p>

<h4>Examples</h4>

<p>Some examples are provided at
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.DCAC\">Examples.DCAC</a>.
</p>
</html>"));
        end DCACConcept;

        class DCDCConcept "DC/DC converter concept"
          extends Modelica.Icons.Information;
          annotation (DocumentationClass=true, Documentation(info="<html>

<p>The following DC/DC converter topologies are currently included in the PowerConverters libraray.</p>

<p>
<ul>
<li>Chopper step down converter</li>
<li>H bridge converter; four quadrant operation</li>
</ul>
</p>

<h4>Control</h4>

<p>A pulse width modulation (PWM) 
<a href=\"modelica://Modelica_Electrical_PowerConverters.DCDC.Control\">controller</a> 
is provided. 
</p>

<h4>Examples</h4>

<p>Some examples are provided at
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.DCDC\">Examples.DCDC</a>.
</p>
</html>"));
        end DCDCConcept;

        class Contact "Contact"
          extends Modelica.Icons.Contact;
          annotation (Documentation(info="<html>
<h4>Contact</h4>

<p>
  Dr. Christian Kral<br>
  <a href=\"http://christiankral.net/\">Electric Machines, Drives and Systems</a><br>
  A-1060 Vienna, Austria<br>
  email: <a href=\"mailto:dr.christian.kral@gmail.com\">dr.christian.kral@gmail.com</a>
</p>

<p>
Anton Haumer<br>
<a href=\"http://www.haumer.at\">Technical Consulting &amp; Electrical Engineering</a><br>
3423 St. Andrae-Woerdern, Austria<br>
email: <a HREF=\"mailto:a.haumer@haumer.at\">a.haumer@haumer.at</a><br>
</p>

</html>"));
        end Contact;

        class ReleaseNotes "Release Notes"
          extends Modelica.Icons.ReleaseNotes;
          annotation (Documentation(info="<html>

<h5>Version 1.2.0, 2014-04-06</h5>
<ul>
<li>Moved enabling signals from control to inverter models due to consistency reasons</li>
<li>Added partial models for enabling firing signals</li>
</ul>

<h5>Version 1.1.0, 2014-03-24</h5>
<ul>
<li>Removed StepUp converter due to consistency reasons</li>
</ul>

<h5>Version 1.0.0, 2014-03-24</h5>
<ul>
<li>First tagged version</li>
</ul>

</html>"));
        end ReleaseNotes;

        class References "References"
          extends Modelica.Icons.References;
          annotation (Documentation(info="<html>
<h4>References</h4>

<p>
<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td valign=\"top\">[Skvarenina01]</td>
      <td valign=\"top\">Timothy L. Skvarenina,
        <a href=\"http://www.crcpress.com/product/isbn/9780849373367\">
        <i>The Power Electronics Handbook</i></a>,
        CRC Press 2001, ISBN 9780849373367</td>
    </tr>

    <tr>
      <td valign=\"top\">[Luo05]</td>
      <td valign=\"top\">Fang Lin Luo, Hong Ye and Muhammad H. Rashid,
        <a href=\"http://store.elsevier.com/product.jsp?isbn=9780120887576&_requestid=1725\"><i>Digital Power Electronics and Applications</i></a>,
        Elsevier Academic Press, 2005, ISBN 978-0120887576</td>
    </tr>

    <tr>
      <td valign=\"top\">[Williams2006]</td>
      <td valign=\"top\"><a href=\"http://www.freescience.info/go.php?pagename=books&id=1732\">
<i>Principles and Elements of Power Electronics: Devices, Drivers, Applications, and Passive Components</i></a>, available at <a href=\"http://www.freescience.info/go.php?pagename=books&id=1732\">FreeScience</a>, ISBN 978-0-9553384-0-3</td>
    </tr>
</table>
</p>
</html>"));
        end References;
        annotation (DocumentationClass=true, Documentation(info="*<html>
<p>
This library provides power converters for DC and AC single and multi phase electrical systems. The PowerConverters library contains three types of converters.
</p>

<ul>
  <li>AC/DC converters (rectifiers)</li>
  <li>DC/AC converters (inverters)</li>
  <li>DC/DC converters</li>
</ul>

<p>
General types of AC/AC converters are currently not provided in this library.
</p>

<h4>Converter characteristics</h4>

<ul>
  <li>All converter models rely on existing diode, thyristor and switch models provided in the
      <a href=\"modelica://Modelica.Electrical.Analog.Ideal\">Analog.Ideal</a> and the 
      <a href=\"modelica://Modelica.Electrical.MultiPhase.Ideal\">MultiPhase.Ideal</a> 
      package of the Modelica Standard Library.</li>
  <li>Switching losses and recovery effects are not considered</li>
  <li>Only conduction losses are taken into account</li>
  <li>The parameters of the semiconductors include<li>
  <ul>
    <li>The on state resistance <code>Ron</code><li> 
    <li>The off state conductance <code>Goff</code><li> 
    <li>The knee voltage <code>Vknee</code><li> 
  </ul>
  <li>Each converter is equipped with an optional heat port which can be enabled by the parameter
      <code>useHeatPort</code>; the heat ports of all semiconductors are connected,
      so all temepratures of all semiconductors are equal and the heat flow of the converter heat port 
      is determined by the sum of all semiconductor heat flows</li> 
  <li>Each converter containg boolean firing inputs provides variables <code>offStart...</code>     
      to specify the inital conditions of the off state of each semiconductor</li>
  <li>The boolean firing signals are enabled either by means of the a parameter <code>constantEnable</code> or by a conditional signal input, enabled by <code>useConstantEnable = false</code><li>
  <li>The number of phases of multi phase converters is not restricted to three</li>
</ul>

<h4>Literature</h4>

<p>
General background knowledge on power converters and power electronics can be found in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.References\">[Skvarenina01]</a> and 
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.References\">[Luo05]</a>. 
A freely available book is available in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.References\">[Williams2006]</a>.
</p>
</html>"));
      end UsersGuide;

      package Examples "Examples"
        extends Modelica.Icons.ExamplesPackage;
        package ACDC "AC to DC converter examples"
          extends Modelica.Icons.ExamplesPackage;
          package Rectifier1Pulse "Single pulse rectifier"
            extends Modelica.Icons.ExamplesPackage;
            model Thyristor1Pulse_R "One pulse rectifier with resistive load"
              extends ExampleTemplates.Thyristor1Pulse(pulse2(
                  useConstantFiringAngle=true,
                  f=f,
                  constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(idealthyristor.n, resistor.p) annotation (Line(
                  points={{4.44089e-16,40},{30,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end Thyristor1Pulse_R;

            model Thyristor1Pulse_R_Characteristic "Control characteristic of one pulse rectifier with resitive load"
              extends ExampleTemplates.Thyristor1Pulse(pulse2(
                    useConstantFiringAngle=false, f=f));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Blocks.Sources.Ramp ramp(height=pi, duration=10) annotation (
                 Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={-40,-70})));
            equation
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, idealthyristor.n) annotation (Line(
                  points={{30,40},{0,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ramp.y, pulse2.firingAngle) annotation (Line(
                  points={{-40,-59},{-40,-12}},
                  color={0,0,127},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=10,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot average voltage <code>meanVoltage.v</code> versus firingAngle <code>pulse2.firingAngle</code> to see control characteristic of this type of rectifier with resistive load.</p>
</html>"));
            end Thyristor1Pulse_R_Characteristic;
          end Rectifier1Pulse;

          package RectifierBridge2Pulse "Two pulse Graetz bridge"
            extends Modelica.Icons.ExamplesPackage;
            model DiodeBridge2Pulse "Two pulse Graetz diode bridge with resistive load"
              import Modelica;
              import Modelica_AddOn;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    visible=true, transformation(
                    origin={-80,-50},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage(V=sqrt(2)*
                    Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,20},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.DiodeBridge2Pulse
                rectifier(useHeatPort=false)
                annotation (Placement(transformation(extent={{-40,24},{-20,44}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{-4.44089e-16,-60},{-4.44089e-16,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(ground.p, sinevoltage.n) annotation (Line(
                  points={{-80,-40},{-80,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sinevoltage.p, rectifier.ac_p) annotation (Line(
                  points={{-80,30},{-80,40},{-40,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage.n, rectifier.ac_n) annotation (Line(
                  points={{-80,10},{-80,10},{-80,-8},{-50,-8},{-50,28},{-40,28}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, currentSensor.n) annotation (Line(
                  points={{-19.8,28},{-10,28},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.n, currentSensor.p) annotation (Line(
                  points={{50,0},{50,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Two pulse diode bridge example.</p>
</html>"));
            end DiodeBridge2Pulse;

            model HalfControlledBridge2Pulse "Two pulse Graetz half controlled bridge with resistive load"
              import Modelica;
              import Modelica_AddOn;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.Angle constantFiringAngle=90*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    visible=true, transformation(
                    origin={-80,-50},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage(V=sqrt(2)*
                    Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,20},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.HalfControlledBridge2Pulse
                rectifier(useHeatPort=false, offStart_p1=true)
                annotation (Placement(transformation(extent={{-40,24},{-20,44}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageBridge2Pulse
                pulse2(
                f=f,
                useFilter=false,
                constantFiringAngle=constantFiringAngle) annotation (Placement(
                    transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-30,-2})));
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{-4.44089e-16,-60},{-4.44089e-16,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(ground.p, sinevoltage.n) annotation (Line(
                  points={{-80,-40},{-80,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sinevoltage.p, rectifier.ac_p) annotation (Line(
                  points={{-80,30},{-80,40},{-40,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage.n, rectifier.ac_n) annotation (Line(
                  points={{-80,10},{-80,10},{-80,-8},{-50,-8},{-50,28},{-40,28}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, currentSensor.n) annotation (Line(
                  points={{-19.8,28},{-10,28},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.n, currentSensor.p) annotation (Line(
                  points={{50,0},{50,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-36,9},{-36,22}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_n, rectifier.fire_n) annotation (Line(
                  points={{-24,9},{-24,22}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2.ac_p, rectifier.ac_p) annotation (Line(
                  points={{-40,4},{-60,4},{-60,40},{-40,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.ac_n, pulse2.ac_n) annotation (Line(
                  points={{-40,28},{-50,28},{-50,-8},{-40,-8}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
    <p>Two pulse half controlled bridge example.</p>
</html>"));
            end HalfControlledBridge2Pulse;

            model ThyristorBridge2Pulse_R "Two pulse Graetz thyristor bridge rectifier with resistive load"
              extends ExampleTemplates.ThyristorBridge2Pulse(pulse2(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorBridge2Pulse_R;

            model ThyristorBridge2Pulse_RL "Two pulse Graetz thyristor bridge rectifier with R-L load"
              extends ExampleTemplates.ThyristorBridge2Pulse(pulse2(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, currentSensor.p) annotation (Line(
                  points={{30,-10},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorBridge2Pulse_RL;

            model ThyristorBridge2Pulse_RLV "Two pulse Graetz thyristor bridge rectifier with R-L load and voltage"
              extends ExampleTemplates.ThyristorBridge2Pulse(pulse2(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, currentSensor.p) annotation (Line(
                  points={{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorBridge2Pulse_RLV;

            model ThyristorBridge2Pulse_RLV_Characteristic "Characteristic of two pulse Graetz thyristor bridge rectifier with R-L load and voltage"
              extends ExampleTemplates.ThyristorBridge2Pulse(pulse2(
                    useConstantFiringAngle=false));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vdi0=2/pi*sin(pi/2)*sqrt(2)*Vrms "Ideal max. DC voltage";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
              Modelica.Blocks.Sources.Ramp ramp(height=pi, duration=10) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-30,70})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, currentSensor.p) annotation (Line(
                  points={{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ramp.y, pulse2.firingAngle) annotation (Line(
                  points={{-30,59},{-30,-14}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=10,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot average voltage <code>meanVoltage.v</code> versus firingAngle <code>pulse2.firingAngle</code> to see control characteristic of this type of rectifier with R-L load including active voltage.</p>
</html>"));
            end ThyristorBridge2Pulse_RLV_Characteristic;

            model ThyristorBridge2Pulse_DC_Drive "Two pulse Graetz thyristor bridge feeding a DC drive"
              import Modelica;
              import Modelica_AddOn;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vrms=dcpmData.VaNominal/(2/pi*sin(
                  pi/2)*sqrt(2)) "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.ApparentPower SMains=250E3 "Mains short circuit apparent power";
              parameter Real lamdaMains=0.1 "Mains short circuit power factor";
              final parameter Modelica.SIunits.Impedance ZMains=Vrms^2/SMains "Mains short circuit impedance";
              final parameter Modelica.SIunits.Resistance RMains=ZMains*lamdaMains "Mains resistance"
                                   annotation (Evaluate=true);
              final parameter Modelica.SIunits.Inductance LMains=ZMains*sqrt(1 -
                  lamdaMains^2)/(2*pi*f) "Mains inductance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Inductance Ld=10*dcpmData.La "Smoothing inductance"
                                       annotation (Evaluate=true);
              final parameter Modelica.SIunits.Torque tauNominal=dcpmData.ViNominal
                  *dcpmData.IaNominal/dcpmData.wNominal "Nominal torque";
              output Modelica.SIunits.AngularVelocity w(displayUnit="rpm") = dcpm.wMechanical;
              output Modelica.SIunits.Torque tau=dcpm.tauShaft;
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    visible=true, transformation(
                    origin={-80,-50},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage(V=sqrt(2)*
                    Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,0},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.ThyristorBridge2Pulse
                rectifier(useHeatPort=false)
                annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageBridge2Pulse
                pulse2(useConstantFiringAngle=false, useFilter=true) annotation (
                  Placement(transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-30,-30})));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=Ld) annotation (
                  Placement(visible=true, transformation(
                    origin={30,-10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Machines.BasicMachines.DCMachines.DC_PermanentMagnet
                dcpm(
                VaNominal=dcpmData.VaNominal,
                IaNominal=dcpmData.IaNominal,
                wNominal=dcpmData.wNominal,
                TaNominal=dcpmData.TaNominal,
                Ra=dcpmData.Ra,
                TaRef=dcpmData.TaRef,
                La=dcpmData.La,
                Jr=dcpmData.Jr,
                useSupport=false,
                Js=dcpmData.Js,
                frictionParameters=dcpmData.frictionParameters,
                coreParameters=dcpmData.coreParameters,
                strayLoadParameters=dcpmData.strayLoadParameters,
                brushParameters=dcpmData.brushParameters,
                phiMechanical(fixed=true),
                wMechanical(fixed=true, start=dcpmData.wNominal),
                TaOperational=293.15,
                alpha20a=dcpmData.alpha20a,
                ia(start=0, fixed=true)) annotation (Placement(transformation(
                      extent={{10,-90},{30,-70}}, rotation=0)));
              parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.DcPermanentMagnetData
                dcpmData "Data record of PM excited DC machine"
                annotation (Placement(transformation(extent={{-20,-90},{0,-70}})));
              Modelica.Mechanics.Rotational.Sources.Torque torque
                annotation (Placement(transformation(extent={{60,-90},{40,-70}})));
              Modelica.Blocks.Sources.Ramp ramp(
                duration=10,
                startTime=5,
                height=tauNominal,
                offset=-tauNominal)
                annotation (Placement(transformation(extent={{90,-90},{70,-70}})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={-30,-60})));
              Modelica.Electrical.Analog.Basic.Resistor rMains(R=RMains)
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-80,30})));
              Modelica.Electrical.Analog.Basic.Inductor lMains(L=LMains)
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-80,60})));
            initial equation
              lMains.i = 0;
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{-4.44089e-16,-60},{-4.44089e-16,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(ground.p, sinevoltage.n) annotation (Line(
                  points={{-80,-40},{-80,-10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sinevoltage.n, rectifier.ac_n) annotation (Line(
                  points={{-80,-10},{-60,-10},{-60,-6},{-40,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, currentSensor.n) annotation (Line(
                  points={{-19.8,-6},{-10,-6},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,6},{-10,6},{-10,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.n, currentSensor.p) annotation (Line(
                  points={{50,0},{50,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-36,-19},{-36,-12}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_n, rectifier.fire_n) annotation (Line(
                  points={{-24,-19},{-24,-12}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2.ac_p, rectifier.ac_p) annotation (Line(
                  points={{-40,-24},{-54,-24},{-54,6},{-40,6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.ac_n, pulse2.ac_n) annotation (Line(
                  points={{-40,-6},{-50,-6},{-50,-36},{-40,-36}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, dcpm.pin_ap) annotation (Line(
                  points={{30,-20},{30,-70},{26,-70}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(torque.flange, dcpm.flange) annotation (Line(
                  points={{40,-80},{30,-80}},
                  color={0,0,0},
                  smooth=Smooth.None));
              connect(ramp.y, torque.tau) annotation (Line(
                  points={{69,-80},{62,-80}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, inductor.p) annotation (Line(
                  points={{-20,6},{-10,6},{-10,40},{30,40},{30,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, dcpm.pin_an) annotation (Line(
                  points={{10,-40},{10,-70},{14,-70}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(const.y, pulse2.firingAngle) annotation (Line(
                  points={{-30,-49},{-30,-42}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rMains.n, lMains.p) annotation (Line(
                  points={{-80,40},{-80,50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rMains.p, sinevoltage.p) annotation (Line(
                  points={{-80,20},{-80,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.ac_p, lMains.n) annotation (Line(
                  points={{-40,6},{-60,6},{-60,70},{-80,70}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=15,
                  Interval=0.0002,
                  Tolerance=1e-006),
                Documentation(info="<html>
<p>
In this example a PM excited DC machine is started with nominal torque at nominal speed. After 5 seconds, load torque is reduced to zero over a period of additional 10 seconds. At 15 seconds, the machine is operating at no load.
</p>

<p>
Plot torque <code>tau</code>, current <code>currentSensor.i</code> and average current <code>meanCurrent.y</code>. Also plot speed <code>w</code>, voltage <code>voltageSensor.v</code> and the average voltage <code>meanVoltage.y</code>.</p>  
</html>"));
            end ThyristorBridge2Pulse_DC_Drive;
          end RectifierBridge2Pulse;

          package RectifierCenterTap2Pulse "Center tap rectifier with two pulses"
            extends Modelica.Icons.ExamplesPackage;
            model DiodeCenterTap2Pulse "Two pulse diode rectifier with center tap with resistive load"
              import Modelica;
              import Modelica_AddOn;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    visible=true, transformation(
                    origin={-90,-50},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage_n(V=sqrt(2)
                    *Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,-13.9999},
                    extent={{-9.999890000000001,-10},{10,10}},
                    rotation=-90)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage_p(V=sqrt(2)
                    *Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,14},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.DiodeCenterTap2Pulse
                rectifier
                annotation (Placement(transformation(extent={{-40,30},{-20,50}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{-4.44089e-16,-60},{-4.44089e-16,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sinevoltage_p.n, sinevoltage_n.p) annotation (Line(
                  points={{-80,4},{-80,-4.00001}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ground.p, sinevoltage_p.n) annotation (Line(
                  points={{-90,-40},{-90,0},{-80,0},{-80,4}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage_p.p, rectifier.ac_p) annotation (Line(
                  points={{-80,24},{-80,46},{-40,46}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage_n.n, rectifier.ac_n) annotation (Line(
                  points={{-80,-23.9999},{-80,-32},{-50,-32},{-50,34},{-40,34}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ground.p, currentSensor.n) annotation (Line(
                  points={{-90,-40},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-40},{50,-40},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.p, rectifier.dc_p) annotation (Line(
                  points={{50,20},{50,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Two pulse diode center tap example.</p>
</html>"));
            end DiodeCenterTap2Pulse;

            model ThyristorCenterTap2Pulse_R "Two pulse thyristor rectifier with center tap and resistive load"
              extends ExampleTemplates.ThyristorCenterTap2Pulse(pulse2(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTap2Pulse_R;

            model ThyristorCenterTap2Pulse_RL "Two pulse thyristor rectifier with center tap and R-L load"
              extends ExampleTemplates.ThyristorCenterTap2Pulse(pulse2(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, currentSensor.p) annotation (Line(
                  points={{30,-10},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTap2Pulse_RL;

            model ThyristorCenterTap2Pulse_RLV "Two pulse thyristor rectifier with center tap and R-L load and voltage"
              extends ExampleTemplates.ThyristorCenterTap2Pulse(pulse2(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(start=0,
                    fixed=true)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, currentSensor.p) annotation (Line(
                  points={{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTap2Pulse_RLV;

            model ThyristorCenterTap2Pulse_RLV_Characteristic "Characteristic of two pulse thyristor rectifier with center tap and R-L load and voltage"
              extends ExampleTemplates.ThyristorCenterTap2Pulse(pulse2(
                    useConstantFiringAngle=false));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
              Modelica.Blocks.Sources.Ramp ramp(height=pi, duration=10) annotation (
                 Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={-30,-60})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, currentSensor.p) annotation (Line(
                  points={{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ramp.y, pulse2.firingAngle) annotation (Line(
                  points={{-30,-49},{-30,-12}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=10,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot average voltage <code>meanVoltage.v</code> versus firingAngle <code>pulse2.firingAngle</code> to see control characteristic of this type of rectifier with R-L load including active voltage.</p>
</html>"));
            end ThyristorCenterTap2Pulse_RLV_Characteristic;
            annotation (Icon(coordinateSystem(
                  extent={{-100,-100},{100,100}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={2,2})), Diagram(coordinateSystem(
                  extent={{-100,-100},{100,100}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={2,2})));
          end RectifierCenterTap2Pulse;

          package RectifierCenterTapmPulse "m pulse rectifier with center tap"
            extends Modelica.Icons.ExamplesPackage;
            model DiodeCenterTapmPulse "2*m pulse diode rectifier with center tap with resistive load"
              import Modelica;
              import Modelica_AddOn;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Integer m(final min=3) = 3 "Number of phases";
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-80,-100},{-60,-80}})));
              Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,-30})));
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage_p(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,10})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.DiodeCenterTapmPulse
                rectifier(final m=m)
                annotation (Placement(transformation(extent={{-40,30},{-20,50}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=m*f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-50})));
              Blocks.Math.Mean meanCurrent(f=m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-70})));
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(star.pin_n, ground.p) annotation (Line(
                  points={{-70,-40},{-70,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-70},{0,-70},{0,-60},{-6.66134e-16,-60}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-50},{50,-50},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(star.plug_p, sineVoltage_p.plug_n) annotation (Line(
                  points={{-70,-20},{-70,1.33227e-15}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(star.pin_n, currentSensor.n) annotation (Line(
                  points={{-70,-40},{-70,-50},{-10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.ac, sineVoltage_p.plug_p) annotation (Line(
                  points={{-40,40},{-70,40},{-70,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-50},{10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, resistor.p) annotation (Line(
                  points={{-20,40},{30,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p><code>m</code> pulse diode center tap example, where <code>m</code> is the number of phases.</p>
</html>"));
            end DiodeCenterTapmPulse;

            model ThyristorCenterTapmPulse_R "2*m pulse thyristor rectifier with center tap and resistive load"
              extends ExampleTemplates.ThyristorCenterTapmPulse(pulsem(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-50},{10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTapmPulse_R;

            model ThyristorCenterTapmPulse_RL "2*m pulse thyristor rectifier with center tap and R-L load"
              extends ExampleTemplates.ThyristorCenterTapmPulse(pulsem(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, currentSensor.p) annotation (Line(
                  points={{30,-10},{30,-50},{10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTapmPulse_RL;

            model ThyristorCenterTapmPulse_RLV "2*m pulse thyristor rectifier with center tap and R-L load and voltage"
              extends ExampleTemplates.ThyristorCenterTapmPulse(pulsem(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-50 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, currentSensor.p) annotation (Line(
                  points={{30,-40},{30,-40},{30,-48},{30,-48},{30,-50},{10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTapmPulse_RLV;

            model ThyristorCenterTapmPulse_RLV_Characteristic "Characteristic of 2*m pulse thyristor rectifier with center tap and R-L load and voltage"
              extends ExampleTemplates.ThyristorCenterTapmPulse(pulsem(
                    useConstantFiringAngle=false));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-50 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
              Modelica.Blocks.Sources.Ramp ramp(height=pi, duration=10) annotation (
                 Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={-30,-70})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, constantVoltage.n) annotation (Line(
                  points={{10,-50},{30,-50},{30,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ramp.y, pulsem.firingAngle) annotation (Line(
                  points={{-30,-59},{-30,-12}},
                  color={0,0,127},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=10,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot average voltage <code>meanVoltage.v</code> versus firingAngle <code>pulsem.firingAngle</code> to see control characteristic of this type of rectifier with R-L load including active voltage.</p>
</html>"));
            end ThyristorCenterTapmPulse_RLV_Characteristic;
          end RectifierCenterTapmPulse;

          package RectifierBridge2mPulse "2*m pulse rectifier bridge"
            extends Modelica.Icons.ExamplesPackage;
            model DiodeBridge2mPulse "2*m pulse diode rectifier bridge with resistive load"
              import Modelica;
              import Modelica_AddOn;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Integer m(final min=3) = 3 "Number of phases";
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-30})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.DiodeBridge2mPulse
                rectifier(final m=m)
                annotation (Placement(transformation(extent={{-40,24},{-20,44}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*m*f) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_AddOn.Electrical.MultiPhase.Basic.MultiStarResistance
                multiStarResistance(final m=m) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-60})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-90,-100},{-70,-80}})));
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{0,-60},{0,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sineVoltage.plug_p, rectifier.ac) annotation (Line(
                  points={{-80,-20},{-80,34},{-40,34}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, currentSensor.n) annotation (Line(
                  points={{-20,28},{-10,28},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-40},{50,-40},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage.plug_n, multiStarResistance.plug) annotation (
                  Line(
                  points={{-80,-40},{-80,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(multiStarResistance.pin, ground.p) annotation (Line(
                  points={{-80,-70},{-80,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p><code>2*m</code> pulse diode bridge example, where <code>m</code> is the number of phases.</p>
</html>"));
            end DiodeBridge2mPulse;

            model HalfControlledBridge2mPulse "2*m pulse half controlled rectifier bridge with resistive load"
              import Modelica_Electrical_PowerConverters =
                Modelica_AddOn.Electrical.PowerConverters;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Integer m(final min=3) = 3 "Number of phases";
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.Angle constantFiringAngle=90*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-30})));
              Modelica_Electrical_PowerConverters.ACDC.HalfControlledBridge2mPulse
                rectifier(final m=m, offStart_p=fill(true, m))
                annotation (Placement(transformation(extent={{-40,24},{-20,44}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*m*f) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_Electrical_PowerConverters.ACDC.Control.VoltageBridge2mPulse
                pulse2m(
                m=m,
                f=f,
                useFilter=false,
                constantFiringAngle=constantFiringAngle) annotation (Placement(
                    transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-30,0})));
              Modelica_AddOn.Electrical.MultiPhase.Basic.MultiStarResistance
                multiStarResistance(final m=m) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-60})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-90,-100},{-70,-80}})));
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{0,-60},{0,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sineVoltage.plug_p, rectifier.ac) annotation (Line(
                  points={{-80,-20},{-80,34},{-40,34}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, currentSensor.n) annotation (Line(
                  points={{-19.8,28},{-10,28},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-40},{50,-40},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2m.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-36,11},{-36,22}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2m.ac, sineVoltage.plug_p) annotation (Line(
                  points={{-40,6.66134e-16},{-80,6.66134e-16},{-80,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage.plug_n, multiStarResistance.plug) annotation (
                  Line(
                  points={{-80,-40},{-80,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(multiStarResistance.pin, ground.p) annotation (Line(
                  points={{-80,-70},{-80,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
    <p><code>2*m</code> pulse half controlled bridge, where <code>m</code> is the number of phases.</p>
</html>"));
            end HalfControlledBridge2mPulse;

            model ThyristorBridge2mPulse_R "2*m pulse thyristor rectifier bridge with resistive load"
              extends ExampleTemplates.ThyristorBridge2mPulse(pulse2m(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorBridge2mPulse_R;

            model ThyristorBridge2mPulse_RL "2*m pulse thyristor rectifier bridge with R-L load"
              extends ExampleTemplates.ThyristorBridge2mPulse(pulse2m(
                    constantFiringAngle=constantFiringAngle), rectifier(offStart_p=
                      fill(true, m), offStart_n=fill(true, m)));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(start=0,
                    fixed=true)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, currentSensor.p) annotation (Line(
                  points={{30,-10},{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorBridge2mPulse_RL;

            model ThyristorBridge2mPulse_RLV "2*m pulse thyristor rectifier bridge with R-L load and voltage"
              extends ExampleTemplates.ThyristorBridge2mPulse(pulse2m(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(start=0,
                    fixed=true)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, currentSensor.p) annotation (Line(
                  points={{30,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorBridge2mPulse_RLV;

            model ThyristorBridge2mPulse_RLV_Characteristic "Characteristic of 2*m pulse thyristor rectifier bridge with R-L load and voltage"
              extends ExampleTemplates.ThyristorBridge2mPulse(pulse2m(
                    useConstantFiringAngle=false));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vdi0=
                  Modelica_AddOn.Electrical.MultiPhase.Functions.factorY2DC(m)*Vrms "Ideal max. DC voltage";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
              Modelica.Blocks.Sources.Ramp ramp(height=pi, duration=10) annotation (
                 Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={-30,-50})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, constantVoltage.n) annotation (Line(
                  points={{10,-40},{30,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ramp.y, pulse2m.firingAngle) annotation (Line(
                  points={{-30,-39},{-30,-12}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=10,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot average voltage <code>meanVoltage.v</code> versus firingAngle <code>pulse2m.firingAngle</code> to see control characteristic of this type of rectifier with R-L load including active voltage.</p>
</html>"));
            end ThyristorBridge2mPulse_RLV_Characteristic;

            model ThyristorBridge2mPulse_DC_Drive "2*m pulse thyristor bridge feeding a DC drive"
              import Modelica;
              import Modelica_AddOn;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Integer m(final min=3) = 3 "Number of phases";
              parameter Modelica.SIunits.Voltage Vrms=dcpmData.VaNominal/
                  Modelica_AddOn.Electrical.MultiPhase.Functions.factorY2DC(m) "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.ApparentPower SMains=250E3 "Mains short circuit apparent power";
              parameter Real lamdaMains=0.1 "Mains short circuit power factor";
              final parameter Modelica.SIunits.Impedance ZMains=Vrms^2/SMains*m "Mains short circuit impedance";
              final parameter Modelica.SIunits.Resistance RMains=ZMains*lamdaMains "Mains resistance"
                                   annotation (Evaluate=true);
              final parameter Modelica.SIunits.Inductance LMains=ZMains*sqrt(1 -
                  lamdaMains^2)/(2*pi*f) "Mains inductance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Inductance Ld=3*dcpmData.La "Smoothing inductance"
                                       annotation (Evaluate=true);
              final parameter Modelica.SIunits.Torque tauNominal=dcpmData.ViNominal
                  *dcpmData.IaNominal/dcpmData.wNominal "Nominal torque";
              output Modelica.SIunits.AngularVelocity w(displayUnit="rpm") = dcpm.wMechanical;
              output Modelica.SIunits.Torque tau=dcpm.tauShaft;
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sinevoltage(
                m=m,
                each final V=fill(sqrt(2)*Vrms, m),
                each freqHz=fill(f, m)) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,0},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.ThyristorBridge2mPulse
                rectifier(useHeatPort=false, m=m)
                annotation (Placement(transformation(extent={{-48,-10},{-28,10}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*m*f) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageBridge2mPulse
                pulse2(
                useConstantFiringAngle=false,
                useFilter=true,
                m=m) annotation (Placement(transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-38,-40})));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=Ld) annotation (
                  Placement(visible=true, transformation(
                    origin={30,-10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Machines.BasicMachines.DCMachines.DC_PermanentMagnet
                dcpm(
                VaNominal=dcpmData.VaNominal,
                IaNominal=dcpmData.IaNominal,
                wNominal=dcpmData.wNominal,
                TaNominal=dcpmData.TaNominal,
                Ra=dcpmData.Ra,
                TaRef=dcpmData.TaRef,
                La=dcpmData.La,
                Jr=dcpmData.Jr,
                useSupport=false,
                Js=dcpmData.Js,
                frictionParameters=dcpmData.frictionParameters,
                coreParameters=dcpmData.coreParameters,
                strayLoadParameters=dcpmData.strayLoadParameters,
                brushParameters=dcpmData.brushParameters,
                phiMechanical(fixed=true),
                wMechanical(fixed=true, start=dcpmData.wNominal),
                TaOperational=293.15,
                alpha20a=dcpmData.alpha20a,
                ia(start=0, fixed=true)) annotation (Placement(transformation(
                      extent={{10,-90},{30,-70}}, rotation=0)));
              parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.DcPermanentMagnetData
                dcpmData "Data record of PM excited DC machine"
                annotation (Placement(transformation(extent={{-20,-90},{0,-70}})));
              Modelica.Mechanics.Rotational.Sources.Torque torque
                annotation (Placement(transformation(extent={{60,-90},{40,-70}})));
              Modelica.Blocks.Sources.Ramp ramp(
                duration=10,
                startTime=5,
                height=tauNominal,
                offset=-tauNominal)
                annotation (Placement(transformation(extent={{90,-90},{70,-70}})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={-38,-70})));
              Modelica.Electrical.MultiPhase.Basic.Resistor rMains(m=m, R=fill(
                    RMains, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-80,30})));
              Modelica.Electrical.MultiPhase.Basic.Inductor lMains(m=m, L=fill(
                    LMains, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-80,60})));
              Modelica_AddOn.Electrical.MultiPhase.Basic.MultiStarResistance
                earthing(m=m) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-30})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-30,-60},{-10,-40}})));
            initial equation
              lMains.i[1:m - 1] = zeros(m - 1);
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{-4.44089e-16,-60},{-4.44089e-16,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, currentSensor.n) annotation (Line(
                  points={{-28,-6},{-10,-6},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-28,6},{-10,6},{-10,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.n, currentSensor.p) annotation (Line(
                  points={{50,0},{50,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-44,-29},{-44,-11.8}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_n, rectifier.fire_n) annotation (Line(
                  points={{-32,-29},{-32,-12}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, dcpm.pin_ap) annotation (Line(
                  points={{30,-20},{30,-70},{26,-70}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(torque.flange, dcpm.flange) annotation (Line(
                  points={{40,-80},{30,-80}},
                  color={0,0,0},
                  smooth=Smooth.None));
              connect(ramp.y, torque.tau) annotation (Line(
                  points={{69,-80},{62,-80}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, inductor.p) annotation (Line(
                  points={{-28,6},{-10,6},{-10,40},{30,40},{30,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, dcpm.pin_an) annotation (Line(
                  points={{10,-40},{10,-70},{14,-70}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(const.y, pulse2.firingAngle) annotation (Line(
                  points={{-38,-59},{-38,-52}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rMains.plug_p, sinevoltage.plug_p) annotation (Line(
                  points={{-80,20},{-80,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(lMains.plug_p, rMains.plug_n) annotation (Line(
                  points={{-80,50},{-80,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(lMains.plug_n, rectifier.ac) annotation (Line(
                  points={{-80,70},{-60,70},{-60,6.66134e-16},{-48,6.66134e-16}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.ac, pulse2.ac) annotation (Line(
                  points={{-48,6.66134e-16},{-60,6.66134e-16},{-60,-40},{-48,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage.plug_n, earthing.plug) annotation (Line(
                  points={{-80,-10},{-80,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, ground.p) annotation (Line(
                  points={{-28,-6},{-20,-6},{-20,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                experiment(
                  StopTime=15,
                  Interval=0.0002,
                  Tolerance=1e-006));
            end ThyristorBridge2mPulse_DC_Drive;
          end RectifierBridge2mPulse;

          package RectifierCenterTap2mPulse "2*m pulse rectifier with center tap"
            extends Modelica.Icons.ExamplesPackage;
            model DiodeCenterTap2mPulse "2*m pulse diode center tap rectifier with resistive load"
              import Modelica;
              import Modelica_AddOn;
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Integer m(final min=3) = 3 "Number of phases";
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-90,-100},{-70,-80}})));
              Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-100,-10})));
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage_p(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,10})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.DiodeCenterTap2mPulse
                rectifier(final m=m)
                annotation (Placement(transformation(extent={{-40,30},{-20,50}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*m*f) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-50})));
              Blocks.Math.Mean meanCurrent(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-70})));
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage_n(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,-20})));
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(star.pin_n, ground.p) annotation (Line(
                  points={{-100,-20},{-100,-50},{-80,-50},{-80,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-70},{0,-70},{0,-60},{-6.66134e-16,-60}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-50},{50,-50},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage_p.plug_n, sineVoltage_n.plug_p) annotation (Line(
                  points={{-70,1.33227e-15},{-70,-4},{-70,-4},{-70,-4},{-70,-4},{-70,
                      -10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage_n.plug_n, rectifier.ac_n) annotation (Line(
                  points={{-70,-30},{-70,-40},{-50,-40},{-50,34},{-40,34}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage_p.plug_p, rectifier.ac_p) annotation (Line(
                  points={{-70,20},{-70,46},{-40,46}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(star.plug_p, sineVoltage_p.plug_n) annotation (Line(
                  points={{-100,0},{-70,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(star.pin_n, currentSensor.n) annotation (Line(
                  points={{-100,-20},{-100,-50},{-10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-50},{10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}), graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p><code>2*m</code> pulse diode center tap example template, where <code>m</code> is the number of phases.</p>
</html>"));
            end DiodeCenterTap2mPulse;

            model ThyristorCenterTap2mPulse_R "2*m pulse thyristor center tap rectifier with resistive load"
              extends ExampleTemplates.ThyristorCenterTap2mPulse(pulse2m(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,20},{30,-50},{10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTap2mPulse_R;

            model ThyristorCenterTap2mPulse_RL "2*m pulse thyristor rectifier with R-L load"
              extends ExampleTemplates.ThyristorCenterTap2mPulse(pulse2m(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, currentSensor.p) annotation (Line(
                  points={{30,-10},{30,-50},{10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTap2mPulse_RL;

            model ThyristorCenterTap2mPulse_RLV "2*m pulse thyristor center tap rectifier with R-L load and voltage"
              extends ExampleTemplates.ThyristorCenterTap2mPulse(pulse2m(
                    constantFiringAngle=constantFiringAngle));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Angle constantFiringAngle=30*pi/180 "Firing angle";
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(start=0,
                    fixed=true)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, currentSensor.p) annotation (Line(
                  points={{30,-40},{30,-40},{30,-48},{30,-48},{30,-50},{10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ThyristorCenterTap2mPulse_RLV;

            model ThyristorCenterTap2mPulse_RLV_Characteristic "Characteristic of 2*m pulse center tap thyristor rectifier with R-L load and voltage"
              extends ExampleTemplates.ThyristorCenterTap2mPulse(pulse2m(
                    useConstantFiringAngle=false));
              extends Modelica.Icons.Example;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Resistance R=20 "Load resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load resistance"
                annotation (Evaluate=true);
              parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(visible=true, transformation(
                    origin={30,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(start=0,
                    fixed=true)) annotation (Placement(visible=true, transformation(
                    origin={30,0},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    VDC) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,-30})));
              Modelica.Blocks.Sources.Ramp ramp(height=pi, duration=10) annotation (
                 Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={-30,-70})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,20},{30,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, constantVoltage.p) annotation (Line(
                  points={{30,-10},{30,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, constantVoltage.n) annotation (Line(
                  points={{10,-50},{30,-50},{30,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ramp.y, pulse2m.firingAngle) annotation (Line(
                  points={{-30,-59},{-30,-12}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(resistor.p, rectifier.dc_p) annotation (Line(
                  points={{30,40},{-10,40},{-10,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=10,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot average voltage <code>meanVoltage.v</code> versus firingAngle <code>pulse2m.firingAngle</code> to see control characteristic of this type of rectifier with R-L load including active voltage.</p>
</html>"));
            end ThyristorCenterTap2mPulse_RLV_Characteristic;
          end RectifierCenterTap2mPulse;

          package ExampleTemplates "Templates of examples"
            extends Modelica.Icons.Package;
            partial model Thyristor1Pulse "Template of single pulse rectifier"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              // parameter Modelica.SIunits.Angle constantFiringAngle = 90 * pi / 180 "Firing angle";
              // parameter Modelica.SIunits.Resistance R = 20 "Load resistance";
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage(V=sqrt(2)*
                    Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,0},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    visible=true, transformation(
                    origin={-80,-50},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanVoltage(f=f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Blocks.Math.Mean meanCurrent(f=f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageBridge2Pulse
                pulse2(f=f, useFilter=false) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-40,0})));
              Analog.Ideal.IdealThyristor idealthyristor(off(fixed=true))
                annotation (Placement(visible=true, transformation(
                    origin={-10,40},
                    extent={{-10,10},{10,-10}},
                    rotation=0)));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{-4.44089e-16,-60},{-4.44089e-16,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(ground.p, sinevoltage.n) annotation (Line(
                  points={{-80,-40},{-80,-10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sinevoltage.p, idealthyristor.p) annotation (Line(
                  points={{-80,10},{-80,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ground.p, currentSensor.n) annotation (Line(
                  points={{-80,-40},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_p, idealthyristor.fire) annotation (Line(
                  points={{-46,11},{-46,20},{-3,20},{-3,29}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.n, currentSensor.p) annotation (Line(
                  points={{50,0},{50,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(idealthyristor.n, voltagesensor.p) annotation (Line(
                  points={{0,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage.p, pulse2.ac_p) annotation (Line(
                  points={{-80,10},{-80,10},{-80,20},{-60,20},{-60,6},{-50,6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage.n, pulse2.ac_n) annotation (Line(
                  points={{-80,-10},{-80,-10},{-80,-20},{-60,-20},{-60,-6},{-50,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                Documentation(info="<html>
<p>Inductive load does not make sense, since average DC voltage is very low due to long conduction period of the thyristor.</p>
</html>"));
            end Thyristor1Pulse;

            partial model ThyristorBridge2Pulse "Template of two pulse Graetz thyristor bridge"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              // parameter Modelica.SIunits.Angle constantFiringAngle = 90 * pi / 180 "Firing angle";
              // parameter Modelica.SIunits.Resistance R = 20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    visible=true, transformation(
                    origin={-80,-50},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage(V=sqrt(2)*
                    Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,20},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.ThyristorBridge2Pulse
                rectifier(useHeatPort=false, offStart_p1=true)
                annotation (Placement(transformation(extent={{-40,24},{-20,44}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageBridge2Pulse
                pulse2(f=f, useFilter=false) annotation (Placement(transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-30,-2})));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{-4.44089e-16,-60},{-4.44089e-16,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(ground.p, sinevoltage.n) annotation (Line(
                  points={{-80,-40},{-80,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sinevoltage.p, rectifier.ac_p) annotation (Line(
                  points={{-80,30},{-80,40},{-40,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage.n, rectifier.ac_n) annotation (Line(
                  points={{-80,10},{-80,10},{-80,-8},{-50,-8},{-50,28},{-40,28}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, currentSensor.n) annotation (Line(
                  points={{-19.8,28},{-10,28},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.n, currentSensor.p) annotation (Line(
                  points={{50,0},{50,-40},{10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-36,9},{-36,22}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_n, rectifier.fire_n) annotation (Line(
                  points={{-24,9},{-24,22}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2.ac_p, rectifier.ac_p) annotation (Line(
                  points={{-40,4},{-60,4},{-60,40},{-40,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.ac_n, pulse2.ac_n) annotation (Line(
                  points={{-40,28},{-50,28},{-50,-8},{-40,-8}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                Documentation(info="<html>
<p>Two pulse thyristor bridge example template.</p>
</html>"));
            end ThyristorBridge2Pulse;

            model ThyristorCenterTap2Pulse "Template of two pulse thyristor rectifier with center tap"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              import Modelica.Constants.pi;
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              // parameter Modelica.SIunits.Angle constantFiringAngle = 90 * pi / 180 "Firing angle";
              // parameter Modelica.SIunits.Resistance R = 20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-120 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    visible=true, transformation(
                    origin={-90,-50},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage_n(V=sqrt(2)
                    *Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,-13.9999},
                    extent={{-9.999890000000001,-10},{10,10}},
                    rotation=-90)));
              Modelica.Electrical.Analog.Sources.SineVoltage sinevoltage_p(V=sqrt(2)
                    *Vrms, freqHz=f) annotation (Placement(visible=true,
                    transformation(
                    origin={-80,14},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.ThyristorCenterTap2Pulse
                rectifier
                annotation (Placement(transformation(extent={{-40,30},{-20,50}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageBridge2Pulse
                pulse2(f=f, useFilter=false) annotation (Placement(transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-30,0})));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{-4.44089e-16,-60},{-4.44089e-16,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sinevoltage_p.n, sinevoltage_n.p) annotation (Line(
                  points={{-80,4},{-80,-4.00001}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ground.p, sinevoltage_p.n) annotation (Line(
                  points={{-90,-40},{-90,0},{-80,0},{-80,4}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage_p.p, rectifier.ac_p) annotation (Line(
                  points={{-80,24},{-80,46},{-40,46}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sinevoltage_n.n, rectifier.ac_n) annotation (Line(
                  points={{-80,-23.9999},{-80,-32},{-50,-32},{-50,34},{-40,34}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ground.p, currentSensor.n) annotation (Line(
                  points={{-90,-40},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-40},{50,-40},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltagesensor.p, rectifier.dc_p) annotation (Line(
                  points={{50,20},{50,40},{-20,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-36,11},{-36,28}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2.fire_n, rectifier.fire_n) annotation (Line(
                  points={{-24,11},{-24,28}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(rectifier.ac_n, pulse2.ac_n) annotation (Line(
                  points={{-40,34},{-50,34},{-50,-6},{-40,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2.ac_p, rectifier.ac_p) annotation (Line(
                  points={{-40,6},{-60,6},{-60,46},{-40,46}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=true,
                    initialScale=0.1,
                    grid={2,2})),
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    preserveAspectRatio=false,
                    initialScale=0.1,
                    grid={2,2}), graphics),
                Documentation(info="<html>
<p>Two pulse thyristor center tap example template.</p>
</html>"));
            end ThyristorCenterTap2Pulse;

            partial model ThyristorCenterTapmPulse "Template of 2*m pulse rectifier with center tap"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              import Modelica.Constants.pi;
              parameter Integer m(final min=3) = 3 "Number of phases";
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              // parameter Modelica.SIunits.Angle constantFiringAngle = 90 * pi / 180 "Firing angle";
              // parameter Modelica.SIunits.Resistance R = 20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-80,-100},{-60,-80}})));
              Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,-30})));
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage_p(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,10})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.ThyristorCenterTapmPulse
                rectifier(final m=m)
                annotation (Placement(transformation(extent={{-40,30},{-20,50}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=m*f) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-50})));
              Blocks.Math.Mean meanCurrent(f=m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-70})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageBridge2mPulse
                pulsem(
                m=m,
                f=f,
                useFilter=false) annotation (Placement(transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-30,0})));
            equation
              connect(star.pin_n, ground.p) annotation (Line(
                  points={{-70,-40},{-70,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-70},{0,-70},{0,-60},{-6.66134e-16,-60}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-50},{50,-50},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulsem.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-36,11},{-36,28}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulsem.ac, sineVoltage_p.plug_p) annotation (Line(
                  points={{-40,6.66134e-16},{-46,6.66134e-16},{-46,0},{-50,0},{-50,
                      40},{-70,40},{-70,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(star.plug_p, sineVoltage_p.plug_n) annotation (Line(
                  points={{-70,-20},{-70,1.33227e-15}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(star.pin_n, currentSensor.n) annotation (Line(
                  points={{-70,-40},{-70,-50},{-10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.ac, sineVoltage_p.plug_p) annotation (Line(
                  points={{-40,40},{-70,40},{-70,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}), graphics),
                Documentation(info="<html>
<p><code>m</code> pulse thyristor center tap example template, where <code>m</code> is the number of phases.</p>
</html>"));
            end ThyristorCenterTapmPulse;

            partial model ThyristorBridge2mPulse "Template of 2*m pulse thyristor rectifier"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              import Modelica.Constants.pi;
              parameter Integer m(final min=3) = 3 "Number of phases";
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              // parameter Modelica.SIunits.Angle constantFiringAngle = 90 * pi / 180 "Firing angle";
              // parameter Modelica.SIunits.Resistance R = 20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-30})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.ThyristorBridge2mPulse
                rectifier(final m=m)
                annotation (Placement(transformation(extent={{-40,24},{-20,44}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*m*f) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-40})));
              Blocks.Math.Mean meanCurrent(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-60})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageBridge2mPulse
                pulse2m(
                m=m,
                f=f,
                useFilter=false) annotation (Placement(transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-30,0})));
              Modelica_AddOn.Electrical.MultiPhase.Basic.MultiStarResistance
                multiStarResistance(final m=m) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-60})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-90,-100},{-70,-80}})));
            equation
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-60},{0,-60},{0,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(sineVoltage.plug_p, rectifier.ac) annotation (Line(
                  points={{-80,-20},{-80,34},{-40,34}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_n, currentSensor.n) annotation (Line(
                  points={{-20,28},{-10,28},{-10,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-40},{50,-40},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2m.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-36,11},{-36,22.2}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2m.fire_n, rectifier.fire_n) annotation (Line(
                  points={{-24,11},{-24,22}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2m.ac, sineVoltage.plug_p) annotation (Line(
                  points={{-40,6.66134e-16},{-80,6.66134e-16},{-80,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage.plug_n, multiStarResistance.plug) annotation (
                  Line(
                  points={{-80,-40},{-80,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(multiStarResistance.pin, ground.p) annotation (Line(
                  points={{-80,-70},{-80,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}), graphics),
                Documentation(info="<html>
<p><code>2*m</code> pulse thyristor bridge example template, where <code>m</code> is the number of phases.</p>
</html>"));
            end ThyristorBridge2mPulse;

            partial model ThyristorCenterTap2mPulse "Template of 2*m pulse rectifier with center tap"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              import Modelica.Constants.pi;
              parameter Integer m(final min=3) = 3 "Number of phases";
              parameter Modelica.SIunits.Voltage Vrms=110 "RMS supply voltage";
              parameter Modelica.SIunits.Frequency f=50 "Frequency";
              // parameter Modelica.SIunits.Angle constantFiringAngle = 90 * pi / 180 "Firing angle";
              // parameter Modelica.SIunits.Resistance R = 20 "Load resistance";
              // parameter Modelica.SIunits.Inductance L = 1 "Load resistance" annotation(Evaluate=true);
              // parameter Modelica.SIunits.Voltage VDC=-260 "DC load offset voltage";
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-90,-100},{-70,-80}})));
              Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-100,-10})));
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage_p(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,10})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.ThyristorCenterTap2mPulse
                rectifier(final m=m)
                annotation (Placement(transformation(extent={{-40,30},{-20,50}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltagesensor
                annotation (Placement(visible=true, transformation(
                    origin={50,10},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
              Blocks.Math.Mean meanVoltage(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,40})));
              Blocks.Math.RootMeanSquare rootMeanSquareVoltage(f=2*m*f) annotation (
                 Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,10})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={0,-50})));
              Blocks.Math.Mean meanCurrent(f=2*m*f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,-70})));
              Modelica_AddOn.Electrical.PowerConverters.ACDC.Control.VoltageCenterTap2mPulse
                pulse2m(
                m=m,
                f=f,
                useFilter=false) annotation (Placement(transformation(
                    extent={{10,10},{-10,-10}},
                    rotation=180,
                    origin={-30,0})));
              Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage_n(
                final m=m,
                V=fill(sqrt(2)*Vrms, m),
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                freqHz=fill(f, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,-20})));
            equation
              connect(star.pin_n, ground.p) annotation (Line(
                  points={{-100,-20},{-100,-50},{-80,-50},{-80,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(meanCurrent.u, currentSensor.i) annotation (Line(
                  points={{68,-70},{0,-70},{0,-60},{-6.66134e-16,-60}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, meanVoltage.u) annotation (Line(
                  points={{60,10},{64,10},{64,40},{68,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltagesensor.v, rootMeanSquareVoltage.u) annotation (Line(
                  points={{60,10},{68,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(rectifier.dc_p, voltagesensor.p) annotation (Line(
                  points={{-20,40},{50,40},{50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.p, voltagesensor.n) annotation (Line(
                  points={{10,-50},{50,-50},{50,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2m.fire_p, rectifier.fire_p) annotation (Line(
                  points={{-36,11},{-36,28}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(pulse2m.ac, sineVoltage_p.plug_p) annotation (Line(
                  points={{-40,6.66134e-16},{-46,6.66134e-16},{-46,46},{-70,46},{-70,
                      20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage_p.plug_n, sineVoltage_n.plug_p) annotation (Line(
                  points={{-70,1.33227e-15},{-70,-4},{-70,-4},{-70,-4},{-70,-4},{-70,
                      -10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage_n.plug_n, rectifier.ac_n) annotation (Line(
                  points={{-70,-30},{-70,-40},{-50,-40},{-50,34},{-40,34}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sineVoltage_p.plug_p, rectifier.ac_p) annotation (Line(
                  points={{-70,20},{-70,46},{-40,46}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(star.plug_p, sineVoltage_p.plug_n) annotation (Line(
                  points={{-100,0},{-70,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(star.pin_n, currentSensor.n) annotation (Line(
                  points={{-100,-20},{-100,-50},{-10,-50}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pulse2m.fire_n, rectifier.fire_n) annotation (Line(
                  points={{-24,11},{-24,28}},
                  color={255,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}), graphics),
                Documentation(info="<html>
<p><code>2*m</code> pulse thyristor center tap example template, where <code>m</code> is the number of phases.</p>
</html>"));
            end ThyristorCenterTap2mPulse;
          end ExampleTemplates;
        end ACDC;

        package DCAC "DC to AC converter examples"
          extends Modelica.Icons.ExamplesPackage;
          package SinglePhaseTwoLevel "Single phase two level inverter examples"
            extends Modelica.Icons.ExamplesPackage;
            model SinglePhaseTwoLevel_R "Single phase DC to AC converter with resistive load"
              extends ExampleTemplates.SinglePhaseTwoLevel(sine(
                  amplitude=0.5,
                  offset=0.5,
                  freqHz=f1));
              extends Modelica.Icons.Example;
              parameter Modelica.SIunits.Resistance R=100 "Resistance";
              parameter Modelica.SIunits.Frequency f1=50 "AC frequency";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={40,10})));
            equation
              connect(resistor.p, inverter.ac) annotation (Line(
                  points={{40,20},{40,30},{-30,30}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{40,1.33227e-15},{40,-70},{10,-70}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StartTime=0,
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>. The instantaneous voltage and current directly show the switch pattern of the inverter. The average voltage and average current reveal the fundamental wave of the voltage and current, each of them being basically in phase with the command <code>sine.y</code>.</p>
</html>"));
            end SinglePhaseTwoLevel_R;

            model SinglePhaseTwoLevel_RL "Single phase DC to AC converter with R-L load"
              extends ExampleTemplates.SinglePhaseTwoLevel(sine(
                  amplitude=0.5,
                  offset=0.5,
                  freqHz=f1));
              extends Modelica.Icons.Example;
              parameter Modelica.SIunits.Resistance R=100 "Resistance";
              parameter Modelica.SIunits.Inductance L=1 "Inductance";
              parameter Modelica.SIunits.Frequency f1=50 "AC frequency";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={40,10})));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true))
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={40,-22})));
            equation
              connect(resistor.p, inverter.ac) annotation (Line(
                  points={{40,20},{40,30},{-30,30}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{40,0},{40,-12}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, currentSensor.p) annotation (Line(
                  points={{40,-32},{40,-70},{10,-70}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StartTime=0,
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i</code>, avarage current <code>meanCurrent.y</code>, voltage <code>voltageSensor.v</code> and average voltage <code>meanVoltage.v</code>. The instantaneous voltage directly show the switch pattern of the inverter. The current shows a particular ripple determined by the input voltage and the switching frequency. The average voltage is basically in phase with the command <code>sine.y</code>. The average current has a phase shift due to the R-L load.</p>
</html>"));
            end SinglePhaseTwoLevel_RL;
          end SinglePhaseTwoLevel;

          package MultiPhaseTwoLevel "Multi phase two level inverter example"
            extends Modelica.Icons.ExamplesPackage;
            model MultiPhaseTwoLevel_R "Multi phase DC to AC converter with R load"
              import Modelica_Electrical_PowerConverters =
                Modelica_AddOn.Electrical.PowerConverters;
              extends Modelica.Icons.Example;
              parameter Integer m=3 "Number of phases";
              parameter Modelica.SIunits.Frequency f=1000 "Switching frequency";
              parameter Modelica.SIunits.Frequency f1=50 "Fundamental wave AC frequency";
              parameter Modelica.SIunits.Resistance R=100 "Resistance";
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage_n(
                  V=50) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,10})));
              Modelica_Electrical_PowerConverters.DCAC.MultiPhase2Level inverter(
                  useHeatPort=false, m=m)
                annotation (Placement(transformation(extent={{-50,20},{-30,40}})));
              Modelica.Electrical.MultiPhase.Sensors.CurrentSensor currentSensor(m=
                    m) annotation (Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=90,
                    origin={40,-50})));
              Modelica.Electrical.MultiPhase.Sensors.VoltageSensor voltageSensor(m=
                    m) annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=270,
                    origin={70,-10})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={-90,40})));
              Modelica_Electrical_PowerConverters.DCDC.Control.SignalPWM signalPWM[
                m](each useConstantDutyCycle=false, each f=f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-40,-20})));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage_p(
                  V=50) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,50})));
              Modelica.Blocks.Sources.Sine sine[m](
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                startTime=zeros(m),
                amplitude=fill(0.5, m),
                offset=fill(0.5, m),
                freqHz=fill(f1, m)) annotation (Placement(transformation(extent={{-30,
                        -64},{-50,-44}})));
              Blocks.Math.Harmonic fundamentalWaveCurrent[m](
                each k=1,
                each x0Cos=0,
                each x0Sin=0,
                each f=f1) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={90,-50})));
              Blocks.Math.Harmonic fundamentalWaveVoltage[m](
                each k=1,
                each x0Cos=0,
                each x0Sin=0,
                each f=f1) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={90,50})));
              Modelica.Electrical.MultiPhase.Basic.Resistor resistor(m=m, R=fill(R,
                    m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={40,10})));
              Modelica.Electrical.MultiPhase.Basic.Star star(m=m) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={40,-90})));
            equation
              connect(constantVoltage_p.n, constantVoltage_n.p) annotation (Line(
                  points={{-70,40},{-70,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage_p.p, inverter.dc_p) annotation (Line(
                  points={{-70,60},{-50,60},{-50,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage_n.n, inverter.dc_n) annotation (Line(
                  points={{-70,0},{-50,0},{-50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ground.p, constantVoltage_p.n) annotation (Line(
                  points={{-90,30},{-70,30},{-70,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sine.y, signalPWM.dutyCycle) annotation (Line(
                  points={{-51,-54},{-60,-54},{-60,-20},{-52,-20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltageSensor.v, fundamentalWaveVoltage.u) annotation (Line(
                  points={{81,-10},{90,-10},{90,38}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(fundamentalWaveCurrent.u, currentSensor.i) annotation (Line(
                  points={{78,-50},{51,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(signalPWM.fire, inverter.fire_p) annotation (Line(
                  points={{-46,-9},{-46,18}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(signalPWM.notFire, inverter.fire_n) annotation (Line(
                  points={{-34,-9},{-34,18}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(inverter.ac, resistor.plug_p) annotation (Line(
                  points={{-30,30},{40,30},{40,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.plug_p, inverter.ac) annotation (Line(
                  points={{70,4.44089e-16},{70,30},{-30,30}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.plug_n, currentSensor.plug_n) annotation (Line(
                  points={{70,-20},{70,-70},{40,-70},{40,-60}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.plug_n, star.plug_p) annotation (Line(
                  points={{40,-60},{40,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.plug_n, currentSensor.plug_p) annotation (Line(
                  points={{40,0},{40,-40},{40,-40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StartTime=0,
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.00002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i[:]</code>, harmonic current magnitude <code>fundamentalWaveCurrent[:].y_RMS</code>, harmonic voltage magnitude <code>fundamentalWaveVoltage[:].y_RMS</code>. The instantaneous voltages <code>voltageSensor.i[:]</code> and currents <code>currentSensor.i[:]</code> directly show the switching pattern of the inverter. There is not smoothing effect due to an inductance in this example; see <a href=\"Modelica_Electrical_PowerConverters.Examples.DCAC.MultiPhaseTwoLevel.MultiPhaseTwoLevel_RL\">MultiPhaseTwoLevel_RL</a>.</p>
</html>"));
            end MultiPhaseTwoLevel_R;

            model MultiPhaseTwoLevel_RL "Multi phase DC to AC converter with R-L load"
              import Modelica_Electrical_PowerConverters =
                Modelica_AddOn.Electrical.PowerConverters;
              extends Modelica.Icons.Example;
              parameter Integer m=6 "Number of phases";
              parameter Modelica.SIunits.Frequency f=1000 "Switching frequency";
              parameter Modelica.SIunits.Frequency f1=50 "Fundamental wave AC frequency";
              parameter Modelica.SIunits.Resistance R=100 "Resistance";
              parameter Modelica.SIunits.Inductance L=1 "Inductance";
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage_n(
                  V=50) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,10})));
              Modelica_Electrical_PowerConverters.DCAC.MultiPhase2Level inverter(
                  useHeatPort=false, m=m)
                annotation (Placement(transformation(extent={{-50,20},{-30,40}})));
              Modelica.Electrical.MultiPhase.Sensors.CurrentSensor currentSensor(m=
                    m) annotation (Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=90,
                    origin={40,-50})));
              Modelica.Electrical.MultiPhase.Sensors.VoltageSensor voltageSensor(m=
                    m) annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=270,
                    origin={70,-10})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={-90,40})));
              Modelica_Electrical_PowerConverters.DCDC.Control.SignalPWM signalPWM[
                m](each useConstantDutyCycle=false, each f=f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-40,-20})));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage_p(
                  V=50) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,50})));
              Modelica.Blocks.Sources.Sine sine[m](
                phase=-
                    Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                startTime=zeros(m),
                amplitude=fill(0.5, m),
                offset=fill(0.5, m),
                freqHz=fill(f1, m)) annotation (Placement(transformation(extent={{-30,
                        -64},{-50,-44}})));
              Blocks.Math.Harmonic fundamentalWaveCurrent[m](
                each k=1,
                each x0Cos=0,
                each x0Sin=0,
                each f=f1) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={90,-50})));
              Blocks.Math.Harmonic fundamentalWaveVoltage[m](
                each k=1,
                each x0Cos=0,
                each x0Sin=0,
                each f=f1) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={90,50})));
              Modelica.Electrical.MultiPhase.Basic.Resistor resistor(m=m, R=fill(R,
                    m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={40,10})));
              Modelica.Electrical.MultiPhase.Basic.Inductor inductor(m=m, L=fill(L,
                    m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={40,-20})));
              Modelica.Electrical.MultiPhase.Basic.Star star(m=m) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={40,-90})));
            initial equation
              inductor.i[1:m - 1] = zeros(m - 1);
            equation
              connect(constantVoltage_p.n, constantVoltage_n.p) annotation (Line(
                  points={{-70,40},{-70,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage_p.p, inverter.dc_p) annotation (Line(
                  points={{-70,60},{-50,60},{-50,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage_n.n, inverter.dc_n) annotation (Line(
                  points={{-70,0},{-50,0},{-50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ground.p, constantVoltage_p.n) annotation (Line(
                  points={{-90,30},{-70,30},{-70,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sine.y, signalPWM.dutyCycle) annotation (Line(
                  points={{-51,-54},{-60,-54},{-60,-20},{-52,-20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltageSensor.v, fundamentalWaveVoltage.u) annotation (Line(
                  points={{81,-10},{90,-10},{90,38}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(fundamentalWaveCurrent.u, currentSensor.i) annotation (Line(
                  points={{78,-50},{51,-50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(signalPWM.fire, inverter.fire_p) annotation (Line(
                  points={{-46,-9},{-46,18}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(signalPWM.notFire, inverter.fire_n) annotation (Line(
                  points={{-34,-9},{-34,18}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(inverter.ac, resistor.plug_p) annotation (Line(
                  points={{-30,30},{40,30},{40,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.plug_n, inductor.plug_p) annotation (Line(
                  points={{40,0},{40,-10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.plug_p, inverter.ac) annotation (Line(
                  points={{70,4.44089e-16},{70,30},{-30,30}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.plug_n, currentSensor.plug_n) annotation (Line(
                  points={{70,-20},{70,-70},{40,-70},{40,-60}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.plug_p, inductor.plug_n) annotation (Line(
                  points={{40,-40},{40,-30}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.plug_n, star.plug_p) annotation (Line(
                  points={{40,-60},{40,-80}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StartTime=0,
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.00002),
                Documentation(info="<html>
<p>Plot current <code>currentSensor.i[:]</code>, harmonic current magnitude <code>fundamentalWaveCurrent[:].y_RMS</code>, harmonic voltage magnitude <code>fundamentalWaveVoltage[:].y_RMS</code>. The instantaneous voltages <code>voltageSensor.i[:]</code> directly show the switching pattern of the inverter.</p>
</html>"));
            end MultiPhaseTwoLevel_RL;
          end MultiPhaseTwoLevel;

          package ExampleTemplates "Templates of examples"
            extends Modelica.Icons.Package;
            partial model SinglePhaseTwoLevel "Single phas two level inverter including control"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              parameter Modelica.SIunits.Frequency f=1000 "Switching frequency";
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage_n(
                  V=50) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,10})));
              Modelica_AddOn.Electrical.PowerConverters.DCAC.SinglePhase2Level
                inverter(useHeatPort=false)
                annotation (Placement(transformation(extent={{-50,20},{-30,40}})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(extent={{10,-80},{-10,-60}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltageSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=270,
                    origin={70,-10})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={-90,40})));
              Modelica_AddOn.Electrical.PowerConverters.DCDC.Control.SignalPWM
                signalPWM(useConstantDutyCycle=false, f=f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-40,-20})));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage_p(
                  V=50) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-70,50})));
              Modelica.Blocks.Sources.Sine sine(freqHz=50) annotation (Placement(
                    transformation(extent={{-30,-64},{-50,-44}})));
              Blocks.Math.Harmonic fundamentalWaveVoltage(f=f, k=1) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={90,50})));
              Blocks.Math.Harmonic fundamentalWaveCurrent(f=f, k=1) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={30,-90})));
            equation
              connect(voltageSensor.n, currentSensor.p) annotation (Line(
                  points={{70,-20},{70,-70},{10,-70}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(signalPWM.fire, inverter.fire_p) annotation (Line(
                  points={{-46,-9},{-46,18}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage_p.n, constantVoltage_n.p) annotation (Line(
                  points={{-70,40},{-70,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage_p.p, inverter.dc_p) annotation (Line(
                  points={{-70,60},{-50,60},{-50,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage_n.n, inverter.dc_n) annotation (Line(
                  points={{-70,0},{-50,0},{-50,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(ground.p, constantVoltage_p.n) annotation (Line(
                  points={{-90,30},{-70,30},{-70,40}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.n, ground.p) annotation (Line(
                  points={{-10,-70},{-90,-70},{-90,30}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.p, inverter.ac) annotation (Line(
                  points={{70,4.44089e-16},{70,30},{-30,30}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(sine.y, signalPWM.dutyCycle) annotation (Line(
                  points={{-51,-54},{-60,-54},{-60,-20},{-52,-20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(inverter.fire_n, signalPWM.notFire) annotation (Line(
                  points={{-34,18},{-34,-9}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.i, fundamentalWaveCurrent.u) annotation (Line(
                  points={{0,-80},{0,-90},{18,-90}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(voltageSensor.v, fundamentalWaveVoltage.u) annotation (Line(
                  points={{80,-10},{90,-10},{90,38}},
                  color={0,0,127},
                  smooth=Smooth.None));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false,
                      extent={{-100,-100},{100,100}}), graphics), Documentation(
                    info="<html>
<p>Single phase two level example template including supply and sensors; load is not yet included.</p>
</html>"));
            end SinglePhaseTwoLevel;
          end ExampleTemplates;
          annotation (Documentation(info="<html>
</html>"));
        end DCAC;

        package DCDC "DC to DC converter examples"
          extends Modelica.Icons.ExamplesPackage;
          package ChopperStepDown "Step down chopper"
            extends Modelica.Icons.ExamplesPackage;
            model ChopperStepDown_R "Step down chopper with resistive load"
              extends ExampleTemplates.ChopperStepDown;
              extends Modelica.Icons.Example;
              parameter Modelica.SIunits.Resistance R=100 "Resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,50})));
            equation
              connect(chopperStepDown.dc_p2, resistor.p) annotation (Line(
                  points={{-40,6},{-30,6},{-30,70},{30,70},{30,60}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{30,40},{30,-6},{0,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StartTime=0,
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>This example demonstrates the switching on of a resistive load operated by a step down chopper.
DC output voltage is equal to <code>dutyCycle</code> times the input voltage.
Plot current <code>currentSensor.i</code>, averaged current <code>meanCurrent.y</code>, total voltage <code>voltageSensor.v</code> and voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end ChopperStepDown_R;

            model ChopperStepDown_RL "Step down chopper with R-L load"
              extends ExampleTemplates.ChopperStepDown;
              extends Modelica.Icons.Example;
              parameter Modelica.SIunits.Resistance R=100 "Resistance";
              parameter Modelica.SIunits.Inductance L=1 "Inductance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,50})));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=L, i(fixed=true,
                    start=0)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={30,10})));
            equation
              connect(chopperStepDown.dc_p2, resistor.p) annotation (Line(
                  points={{-40,6},{-30,6},{-30,70},{30,70},{30,60}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{30,40},{30,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, currentSensor.p) annotation (Line(
                  points={{30,1.33227e-15},{30,-6},{0,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StartTime=0,
                  StopTime=0.1,
                  Tolerance=1e-06,
                  Interval=0.0002),
                Documentation(info="<html>
<p>This example demonstrates the switching on of an R-L load operated by a step down chopper.
DC output voltage is equal to <code>dutyCycle</code> times the input voltage.
Plot current <code>currentSensor.i</code>, averaged current <code>meanCurrent.y</code>, total voltage <code>voltageSensor.v</code> and voltage <code>meanVoltage.v</code>. The waveform the average current is determined by the time constant <code>L/R</code> of the load.</p>
</html>"));
            end ChopperStepDown_RL;
          end ChopperStepDown;

          package HBridge "H bridge converter"
            extends Modelica.Icons.ExamplesPackage;
            model HBridge_R "H bridge DC/DC converter with resistive load"
              extends ExampleTemplates.HBridge;
              extends Modelica.Icons.Example;
              parameter Modelica.SIunits.Resistance R=100 "Resistance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={20,50})));
            equation
              connect(resistor.p, hbridge.dc_p2) annotation (Line(
                  points={{20,60},{20,70},{-30,70},{-30,6},{-40,6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.n, currentSensor.p) annotation (Line(
                  points={{20,40},{20,-6},{0,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=0.1,
                  Interval=0.0002,
                  Tolerance=1e-06),
                Documentation(info="<html>
<p>This example demonstrates the switching on of a resistive load operated by an H bridge.
DC output voltage is equal to <code>2 * (dutyCycle - 0.5)</code> times the input voltage.
Plot current <code>currentSensor.i</code>, averaged current <code>meanCurrent.y</code>, total voltage <code>voltageSensor.v</code> and voltage <code>meanVoltage.v</code>.</p>
</html>"));
            end HBridge_R;

            model HBridge_RL "H bridge DC/DC converter with R-L load"
              extends ExampleTemplates.HBridge;
              extends Modelica.Icons.Example;
              parameter Modelica.SIunits.Resistance R=100 "Resistance";
              parameter Modelica.SIunits.Inductance L=1 "Inductance";
              Modelica.Electrical.Analog.Basic.Resistor resistor(R=R) annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={20,50})));
              Modelica.Electrical.Analog.Basic.Inductor inductor(i(fixed=true,
                    start=0), L=L) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={20,10})));
            equation
              connect(resistor.n, inductor.p) annotation (Line(
                  points={{20,40},{20,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(inductor.n, currentSensor.p) annotation (Line(
                  points={{20,0},{20,-6},{4.44089e-16,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(resistor.p, hbridge.dc_p2) annotation (Line(
                  points={{20,60},{20,70},{-30,70},{-30,6},{-40,6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                Documentation(info="<html>
<p>This example demonstrates the switching on of an R-L load operated by an H bridge.
DC output voltage is equal to <code>2 * (dutyCycle - 0.5)</code> times the input voltage.
Plot current <code>currentSensor.i</code>, averaged current <code>meanCurrent.y</code>, total voltage <code>voltageSensor.v</code> and voltage <code>meanVoltage.v</code>. The waveform the average current is determined by the time constant <code>L/R</code> of the load.</p>
</html>"),      experiment(
                  StopTime=0.1,
                  Interval=0.0002,
                  Tolerance=1e-06));
            end HBridge_RL;

            model HBridge_DC_Drive "H bridge DC/DC converter with DC drive"
              extends ExampleTemplates.HBridge(signalPWM(useConstantDutyCycle=false),
                  constantVoltage(V=120));
              extends Modelica.Icons.Example;
              parameter Modelica.SIunits.Inductance Ld=3*dcpmData.La "Smoothing inductance";
              final parameter Modelica.SIunits.Torque tauNominal=dcpmData.ViNominal
                  *dcpmData.IaNominal/dcpmData.wNominal "Nominal torque";
              parameter Real dMin=0.2 "Minimum duty cycle";
              parameter Real dMax=1 - dMin "Maximum duty cycle";
              Modelica.Electrical.Machines.BasicMachines.DCMachines.DC_PermanentMagnet
                dcpm(
                VaNominal=dcpmData.VaNominal,
                IaNominal=dcpmData.IaNominal,
                wNominal=dcpmData.wNominal,
                TaNominal=dcpmData.TaNominal,
                Ra=dcpmData.Ra,
                TaRef=dcpmData.TaRef,
                La=dcpmData.La,
                Jr=dcpmData.Jr,
                useSupport=false,
                Js=dcpmData.Js,
                frictionParameters=dcpmData.frictionParameters,
                coreParameters=dcpmData.coreParameters,
                strayLoadParameters=dcpmData.strayLoadParameters,
                brushParameters=dcpmData.brushParameters,
                ia(start=0, fixed=true),
                TaOperational=293.15,
                alpha20a=dcpmData.alpha20a,
                phiMechanical(fixed=true, start=0),
                wMechanical(fixed=true, start=0)) annotation (Placement(
                    transformation(extent={{20,-80},{40,-60}}, rotation=0)));
              parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.DcPermanentMagnetData
                dcpmData "Data record of PM excited DC machine"
                annotation (Placement(transformation(extent={{-10,-80},{10,-60}})));
              Modelica.Mechanics.Rotational.Sources.Torque torque
                annotation (Placement(transformation(extent={{70,-80},{50,-60}})));
              Modelica.Blocks.Sources.TimeTable torqueTable(table=[0, 0; 6, 0; 7, -
                    tauNominal; 9, -tauNominal; 10, +tauNominal; 15, tauNominal; 16,
                    -tauNominal; 18, -tauNominal; 19, 0; 24, 0])
                annotation (Placement(transformation(extent={{100,-80},{80,-60}})));
              Modelica.Blocks.Sources.TimeTable dutyCycleTable(table=[0, 0.5; 3,
                    0.5; 4, dMax; 12, dMax; 13, dMin; 21, dMin; 22, 0.5; 24, 0.5])
                annotation (Placement(transformation(extent={{-100,-70},{-80,-50}})));
              Modelica.Electrical.Analog.Basic.Inductor inductor(L=Ld) annotation (
                  Placement(visible=true, transformation(
                    origin={40,30},
                    extent={{10,-10},{-10,10}},
                    rotation=90)));
            equation
              connect(inductor.n, dcpm.pin_ap) annotation (Line(
                  points={{40,20},{40,-60},{36,-60}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(dcpm.pin_an, currentSensor.p) annotation (Line(
                  points={{24,-60},{24,-6},{4.44089e-16,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(dcpm.flange, torque.flange) annotation (Line(
                  points={{40,-70},{50,-70}},
                  color={0,0,0},
                  smooth=Smooth.None));
              connect(torque.tau, torqueTable.y) annotation (Line(
                  points={{72,-70},{79,-70}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(inductor.p, hbridge.dc_p2) annotation (Line(
                  points={{40,40},{40,70},{-30,70},{-30,6},{-40,6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(dutyCycleTable.y, signalPWM.dutyCycle) annotation (Line(
                  points={{-79,-60},{-62,-60}},
                  color={0,0,127},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                        {100,100}}),graphics),
                experiment(
                  StopTime=24,
                  Interval=0.0002,
                  Tolerance=1e-06),
                Documentation(info="<html>
<p>This example of am H brdge with DC drive demonstrates the operation of the DC machine in four quadrants. 
The DC output voltage is equal to <code>2 * (dutyCycle - 0.5)</code> times the input voltage.</p>

<p>
<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
  <tr>
    <th><b>start time (s)</b></th>
    <th><b>machine speed</b>
    <th><b>machine torque</b>
    <th><b>mode</b></th>
  </tr>
  <tr>
    <td>0</td> <td>zero</td> <td>zero</td> <td></td>
  </tr>
  <tr>
    <td>3</td> <td>positive</td> <td>zero</td> <td></td>
  </tr>
  <tr>
    <td>6</td> <td>positive</td> <td>positive</td> <td>motor</td>
  </tr>
  <tr>
    <td>9.5</td> <td>positive</td> <td>negative</td> <td>generator</td>
  </tr>
  <tr>
    <td>12.5</td> <td>negative</td> <td>negative</td> <td>motor</td>
  </tr>
  <tr>
    <td>15.5</td> <td>negative</td> <td>positive</td> <td>generator</td>
  </tr>
  <tr>
    <td>19</td> <td>negative</td> <td>zero</td> <td></td>
  </tr>
  <tr>
    <td>22</td> <td>zero</td> <td>zero</td> <td></td>
  </tr>
</table></p>

<p>
Plot machine current <code>dcpm.ia</code>, averaged current <code>meanCurrent.y</code>, machine speed <code>dcpm.wMechanical</code>, avderage machine speed <code>dcpm.va</code> and torque <code>dcpm.tauElectrical</code>.</p>
</html>"));
            end HBridge_DC_Drive;
          end HBridge;

          package ExampleTemplates "Templates of examples"
            extends Modelica.Icons.Package;
            partial model ChopperStepDown "Step down chopper including control"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              parameter Modelica.SIunits.Frequency f=1000 "Switching frequency";
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    100) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,0})));
              Modelica_AddOn.Electrical.PowerConverters.DCDC.ChopperStepDown
                chopperStepDown(useHeatPort=false)
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(extent={{0,-16},{-20,4}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltageSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=270,
                    origin={60,10})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-90,-40},{-70,-20}})));
              Modelica_AddOn.Electrical.PowerConverters.DCDC.Control.SignalPWM
                signalPWM(constantDutyCycle=0.25, f=f) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-50,-60})));
              Blocks.Math.Mean meanCurrent(f=f, x0=0) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-10,-40})));
              Blocks.Math.Mean meanVoltage(f=f, x0=0) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={90,10})));
            equation
              connect(constantVoltage.p, chopperStepDown.dc_p1) annotation (Line(
                  points={{-80,10},{-70,10},{-70,6},{-60,6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, chopperStepDown.dc_n1) annotation (Line(
                  points={{-80,-10},{-70,-10},{-70,-6},{-60,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(chopperStepDown.dc_p2, voltageSensor.p) annotation (Line(
                  points={{-40,6},{-30,6},{-30,70},{60,70},{60,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.n, currentSensor.p) annotation (Line(
                  points={{60,0},{60,-6},{0,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.n, chopperStepDown.dc_n2) annotation (Line(
                  points={{-20,-6},{-39.8,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, ground.p) annotation (Line(
                  points={{-80,-10},{-80,-20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.v, meanVoltage.u) annotation (Line(
                  points={{70,10},{78,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(currentSensor.i, meanCurrent.u) annotation (Line(
                  points={{-10,-16},{-10,-28}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(signalPWM.fire, chopperStepDown.fire_p) annotation (Line(
                  points={{-56,-49},{-56,-12}},
                  color={255,0,255},
                  smooth=Smooth.None));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false,
                      extent={{-100,-100},{100,100}}), graphics), Documentation(
                    info="<html>
<p>Step down chopper example template including supply and sensors; load is not yet included</p>
</html>"));
            end ChopperStepDown;

            partial model HBridge "H bridge DC/DC converter"
              import Modelica;
              import Modelica_AddOn;
              extends Icons.ExampleTemplate;
              parameter Modelica.SIunits.Frequency f=1000 "Switching frequency";
              Modelica_AddOn.Electrical.PowerConverters.DCDC.HBridge hbridge(
                  useHeatPort=false)
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V=
                    100) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,0})));
              Modelica_AddOn.Electrical.PowerConverters.DCDC.Control.SignalPWM
                signalPWM(constantDutyCycle=0.6, f=f) annotation (Placement(
                    transformation(extent={{-60,-70},{-40,-50}})));
              Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                    transformation(extent={{-90,-40},{-70,-20}})));
              Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
                annotation (Placement(transformation(extent={{0,-16},{-20,4}})));
              Modelica.Electrical.Analog.Sensors.VoltageSensor voltageSensor
                annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=270,
                    origin={60,10})));
              Blocks.Math.Mean meanCurrent(f=f, x0=0) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-10,-40})));
              Blocks.Math.Mean meanVoltage(f=f, x0=0) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={90,10})));
            equation
              connect(hbridge.fire_p, signalPWM.fire) annotation (Line(
                  points={{-56,-12},{-56,-49}},
                  color={255,0,255},
                  smooth=Smooth.None));
              connect(ground.p, constantVoltage.n) annotation (Line(
                  points={{-80,-20},{-80,-10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.p, hbridge.dc_p1) annotation (Line(
                  points={{-80,10},{-68,10},{-68,6},{-60,6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(constantVoltage.n, hbridge.dc_n1) annotation (Line(
                  points={{-80,-10},{-68,-10},{-68,-6},{-60,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.n, currentSensor.p) annotation (Line(
                  points={{60,0},{60,-6},{0,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(voltageSensor.v, meanVoltage.u) annotation (Line(
                  points={{70,10},{78,10}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(currentSensor.i, meanCurrent.u) annotation (Line(
                  points={{-10,-16},{-10,-28}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(hbridge.dc_p2, voltageSensor.p) annotation (Line(
                  points={{-40,6},{-30,6},{-30,70},{60,70},{60,20}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(currentSensor.n, hbridge.dc_n2) annotation (Line(
                  points={{-20,-6},{-40,-6}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(signalPWM.notFire, hbridge.fire_n) annotation (Line(
                  points={{-44,-49},{-44,-12}},
                  color={255,0,255},
                  smooth=Smooth.None));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false,
                      extent={{-100,-100},{100,100}}), graphics), Documentation(
                    info="<html>
<p>H bridge example template including suppy and sensors; load is not yet included</p>
</html>"));
            end HBridge;
          end ExampleTemplates;
        end DCDC;
        annotation (Documentation(info="<html>
<p>This is a collection of AC/DC, DC/DC and DC/AC converters.</p>
</html>"));
      end Examples;

      package ACDC "AC to DC converters"
        extends Modelica.Icons.Package;
        package Control "Control components for rectifiers"
          extends Modelica.Icons.Package;
          block Signal2mPulse "Generic control of 2*m pulse rectifiers"
            import Modelica.Constants.pi;
            extends Icons.Control;
            parameter Integer m(final min=1) = 3 "Number of phases";
            parameter Boolean useConstantFiringAngle=true "Use constant firing angle instead of signal input";
            parameter Modelica.SIunits.Angle constantFiringAngle=0 "Firing angle"
              annotation (Dialog(enable=useConstantFiringAngle));
            parameter Boolean useFilter=true "Enable use of filter"
              annotation (Dialog(tab="Filter"));
            parameter Modelica.SIunits.Frequency f=50 "Frequency"
              annotation (Dialog(tab="Filter", enable=useFilter));
            parameter Modelica.SIunits.Frequency fCut=2*f "Cut off frequency of filter"
              annotation (Dialog(tab="Filter", enable=useFilter));
            parameter Modelica.SIunits.Voltage vStart[m]=zeros(m) "Start voltage of filter output"
              annotation (Dialog(tab="Filter", enable=useFilter));
            Modelica.Blocks.Interfaces.RealInput firingAngle if not
              useConstantFiringAngle "Firing angle (rad)" annotation (Placement(
                  transformation(
                  extent={{20,-20},{-20,20}},
                  rotation=270,
                  origin={0,-120})));
            parameter Modelica.SIunits.Angle firingAngleMax(
              min=0,
              max=Modelica.Constants.pi) = Modelica.Constants.pi "Maximum firing angle";
            Modelica.Blocks.Sources.Constant constantconstantFiringAngle(final k=
                  constantFiringAngle) if useConstantFiringAngle annotation (
                Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=180,
                  origin={-30,-80})));
            Modelica.Blocks.Logical.GreaterThreshold positiveThreshold[m](threshold=
                 zeros(m)) annotation (Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={-60,10})));
            Modelica.Blocks.Logical.LessThreshold negativeThreshold[m](threshold=
                  zeros(m)) annotation (Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={60,10})));
            Modelica.Blocks.Logical.Timer timerPositive[m] annotation (Placement(
                  transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={-60,40})));
            Modelica.Blocks.Logical.Timer timerNegative[m] annotation (Placement(
                  transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={60,40})));
            Modelica.Blocks.Logical.Greater greaterPositive[m] annotation (
                Placement(transformation(
                  extent={{10,10},{-10,-10}},
                  rotation=270,
                  origin={-60,80})));
            Modelica.Blocks.Logical.Greater negativeEqual[m] annotation (Placement(
                  transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={60,80})));
            Modelica.Blocks.Interfaces.BooleanOutput fire_p[m] annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={-60,110})));
            Modelica.Blocks.Interfaces.BooleanOutput fire_n[m] annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={60,110})));
            Modelica.Blocks.Math.Gain gain(final k=1/2/pi/f) annotation (Placement(
                  transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={0,10})));
            Modelica.Blocks.Routing.Replicator replicator(final nout=m) annotation (
               Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={0,40})));
            Modelica.Blocks.Nonlinear.Limiter limiter(final uMax=max(Modelica.Constants.pi,
                  firingAngleMax), final uMin=0) annotation (Placement(
                  transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={0,-20})));
            Modelica.Blocks.Interfaces.RealInput v[m] "Voltages" annotation (
                Placement(transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=0,
                  origin={-120,0})));
            Filter filter[m](
              each final f=f,
              each final fCut=2*f,
              yStart=vStart) if useFilter annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-80,-80})));
            Modelica.Blocks.Routing.RealPassThrough realPassThrough[m] if not
              useFilter "Pass through in case filter is off"
              annotation (Placement(transformation(extent={{-90,-60},{-70,-40}})));
          equation
            connect(positiveThreshold.y, timerPositive.u) annotation (Line(
                points={{-60,21},{-60,28}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(negativeThreshold.y, timerNegative.u) annotation (Line(
                points={{60,21},{60,28}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(timerPositive.y, greaterPositive.u1) annotation (Line(
                points={{-60,51},{-60,68}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(negativeEqual.u1, timerNegative.y) annotation (Line(
                points={{60,68},{60,51}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(greaterPositive.y, fire_p) annotation (Line(
                points={{-60,91},{-60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(negativeEqual.y, fire_n) annotation (Line(
                points={{60,91},{60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(gain.y, replicator.u) annotation (Line(
                points={{1.33227e-15,21},{1.33227e-15,28},{-2.66454e-15,28}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(replicator.y, greaterPositive.u2) annotation (Line(
                points={{1.55431e-15,51},{1.55431e-15,60},{-52,60},{-52,68}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(replicator.y, negativeEqual.u2) annotation (Line(
                points={{1.55431e-15,51},{1.55431e-15,52},{0,52},{0,60},{52,60},{52,
                    68}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(limiter.y, gain.u) annotation (Line(
                points={{1.55431e-15,-9},{1.55431e-15,-2},{-2.66454e-15,-2}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(firingAngle, limiter.u) annotation (Line(
                points={{-8.88178e-16,-120},{0,-120},{0,-32},{-2.66454e-15,-32}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(constantconstantFiringAngle.y, limiter.u) annotation (Line(
                points={{-19,-80},{0,-80},{0,-32},{-2.66454e-15,-32}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(v, filter.u) annotation (Line(
                points={{-120,0},{-100,0},{-100,-80},{-92,-80}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(filter.y, positiveThreshold.u) annotation (Line(
                points={{-69,-80},{-60,-80},{-60,-2}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(filter.y, negativeThreshold.u) annotation (Line(
                points={{-69,-80},{-60,-80},{-60,-50},{-52,-50},{-52,-50},{60,-50},
                    {60,-2}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(realPassThrough.u, v) annotation (Line(
                points={{-92,-50},{-100,-50},{-100,0},{-120,0},{-120,8.88178e-16}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(realPassThrough.y, positiveThreshold.u) annotation (Line(
                points={{-69,-50},{-60,-50},{-60,-2}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(realPassThrough.y, negativeThreshold.u) annotation (Line(
                points={{-69,-50},{-56,-50},{-56,-50},{60,-50},{60,-2}},
                color={0,0,127},
                smooth=Smooth.None));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics={Line(
                          points={{-40,-20},{-40,-24},{-20,-24},{-20,-40},{-40,-40},
                      {-40,-60}},
                          color={255,0,255},
                          smooth=Smooth.None),Line(
                          points={{20,-20},{20,-44},{40,-44},{40,-60},{20,-60},{20,
                      -60}},
                          color={255,0,255},
                          smooth=Smooth.None),Text(
                          extent={{-40,60},{40,0}},
                          lineColor={255,0,255},
                          fillColor={0,0,255},
                          fillPattern=FillPattern.Solid,
                          textString="2*%m%")}),
              Documentation(revisions="<html>
</html>",     info="<html>

<p>
General information about controllers is summarized in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.ACDC.Control\">Control</a>.
</p>
</html>"));
          end Signal2mPulse;

          model VoltageBridge2Pulse "Control of 2 pulse bridge rectifier"
            import Modelica.Constants.pi;
            extends Icons.Control;
            parameter Modelica.SIunits.Frequency f=50 "Frequency";
            parameter Boolean useConstantFiringAngle=true "Use constant firing angle instead of signal input";
            parameter Modelica.SIunits.Angle constantFiringAngle=0 "Firing angle"
              annotation (Dialog(enable=useConstantFiringAngle));
            parameter Modelica.SIunits.Angle firingAngleMax(
              min=0,
              max=Modelica.Constants.pi) = Modelica.Constants.pi "Maximum firing angle";
            parameter Boolean useFilter=true "Enable use of filter"
              annotation (Dialog(tab="Filter"));
            parameter Modelica.SIunits.Frequency fCut=2*f "Cut off frequency of filter"
              annotation (Dialog(tab="Filter", enable=useFilter));
            parameter Modelica.SIunits.Voltage vStart=0 "Start voltage of filter output"
              annotation (Dialog(tab="Filter", enable=useFilter));
            Modelica.Blocks.Interfaces.RealInput firingAngle if not
              useConstantFiringAngle "Firing angle (rad)" annotation (Placement(
                  transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={0,-120})));
            Signal2mPulse twoPulse(
              final useConstantFiringAngle=useConstantFiringAngle,
              final f=f,
              final constantFiringAngle=constantFiringAngle,
              final firingAngleMax=firingAngleMax,
              final m=1,
              final useFilter=useFilter,
              final fCut=fCut,
              final vStart=fill(vStart, 1)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={0,0})));
            Modelica.Electrical.Analog.Interfaces.PositivePin ac_p
              annotation (Placement(transformation(extent={{-110,50},{-90,70}})));
            Modelica.Electrical.Analog.Interfaces.NegativePin ac_n
              annotation (Placement(transformation(extent={{-110,-70},{-90,-50}})));
            Modelica.Electrical.Analog.Sensors.VoltageSensor voltageSensor
              annotation (Placement(transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=270,
                  origin={-80,0})));
            Modelica.Blocks.Interfaces.BooleanOutput fire_p annotation (Placement(
                  transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={-60,110})));
            Modelica.Blocks.Interfaces.BooleanOutput fire_n annotation (Placement(
                  transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={60,110})));
          equation
            connect(voltageSensor.v, twoPulse.v[1]) annotation (Line(
                points={{-70,-2.22045e-15},{-60,-2.22045e-15},{-60,0},{-12,0},{-12,
                    8.88178e-16}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(voltageSensor.p, ac_p) annotation (Line(
                points={{-80,10},{-80,60},{-100,60}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSensor.n, ac_n) annotation (Line(
                points={{-80,-10},{-80,-60},{-100,-60}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(firingAngle, twoPulse.firingAngle) annotation (Line(
                points={{8.88178e-16,-120},{8.88178e-16,-12}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(twoPulse.fire_n[1], fire_n) annotation (Line(
                points={{6,11},{6,80},{60,80},{60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(twoPulse.fire_p[1], fire_p) annotation (Line(
                points={{-6,11},{-6,80},{-60,80},{-60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics={Line(
                          points={{-40,-20},{-40,-24},{-20,-24},{-20,-40},{-40,-40},
                      {-40,-60}},
                          color={255,0,255},
                          smooth=Smooth.None),Line(
                          points={{20,-20},{20,-44},{40,-44},{40,-60},{20,-60},{20,
                      -60}},
                          color={255,0,255},
                          smooth=Smooth.None),Text(
                          extent={{-40,60},{40,0}},
                          lineColor={255,0,255},
                          fillColor={0,0,255},
                          fillPattern=FillPattern.Solid,
                          textString="2")}),
              Documentation(revisions="<html>
</html>",     info="<html>

<p>
General information about controllers is summarized in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.ACDC.Control\">Control</a>.
</p>

<p>
This model provides two firing signal for Graetz bridge thyristor and half bridge rectifiers. The boolean
signal <code>fire_p</code> is assigned to the thyristors connected with the positive DC output pin.  
The boolean
signal <code>fire_n</code> is assigned to the thyristors connected with the negative DC output pin.  
</p>
</html>"));
          end VoltageBridge2Pulse;

          model VoltageBridge2mPulse "Control of 2*m pulse bridge rectifier"
            import Modelica.Constants.pi;
            extends Icons.Control;
            parameter Integer m(final min=3) = 3 "Number of phases";
            parameter Modelica.SIunits.Frequency f=50 "Frequency";
            parameter Boolean useConstantFiringAngle=true "Use constant firing angle instead of signal input";
            parameter Modelica.SIunits.Angle constantFiringAngle=0 "Firing angle"
              annotation (Dialog(enable=useConstantFiringAngle));
            parameter Modelica.SIunits.Angle firingAngleMax(
              min=0,
              max=Modelica.Constants.pi) = Modelica.Constants.pi "Maximum firing angle";
            parameter Boolean useFilter=true "Enable use of filter"
              annotation (Dialog(tab="Filter"));
            parameter Modelica.SIunits.Frequency fCut=2*f "Cut off frequency of filter"
              annotation (Dialog(tab="Filter", enable=useFilter));
            parameter Modelica.SIunits.Voltage vStart[m]=zeros(m) "Start voltage of filter output"
              annotation (Dialog(tab="Filter", enable=useFilter));
            Modelica.Blocks.Interfaces.RealInput firingAngle if not
              useConstantFiringAngle "Firing angle (rad)" annotation (Placement(
                  transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={0,-120})));
            Signal2mPulse twomPulse(
              final useConstantFiringAngle=useConstantFiringAngle,
              final f=f,
              final constantFiringAngle=constantFiringAngle,
              final firingAngleMax=firingAngleMax,
              final m=m,
              useFilter=useFilter,
              final fCut=fCut,
              final vStart=vStart) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={0,10})));
            Modelica.Electrical.MultiPhase.Interfaces.PositivePlug ac(final m=m)
              annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
            Modelica_AddOn.Electrical.MultiPhase.Basic.MultiDelta delta(final m=m) "Delta connection"
                                 annotation (Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=90,
                  origin={-80,10})));
            Modelica.Electrical.MultiPhase.Sensors.VoltageSensor voltageSensor(
                final m=m) "Voltage sensor" annotation (Placement(transformation(
                  extent={{10,10},{-10,-10}},
                  rotation=270,
                  origin={-44,10})));
            Modelica.Blocks.Interfaces.BooleanOutput fire_p[m] annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={-60,110})));
            Modelica.Blocks.Interfaces.BooleanOutput fire_n[m] annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={60,110})));
          equation
            connect(ac, voltageSensor.plug_p) annotation (Line(
                points={{-100,4.44089e-16},{-100,-4.44089e-16},{-44,-4.44089e-16}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSensor.plug_p, delta.plug_n) annotation (Line(
                points={{-44,-4.44089e-16},{-54,-4.44089e-16},{-54,0},{-62,0},{-62,
                    -4.44089e-16},{-80,-4.44089e-16}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(delta.plug_p, voltageSensor.plug_n) annotation (Line(
                points={{-80,20},{-44,20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSensor.v, twomPulse.v) annotation (Line(
                points={{-33,10},{-12,10}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(firingAngle, twomPulse.firingAngle) annotation (Line(
                points={{1.11022e-15,-120},{1.11022e-15,-26},{0,-26},{0,-14},{
                    4.44089e-16,-14},{4.44089e-16,-2}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(twomPulse.fire_n, fire_n) annotation (Line(
                points={{6,21},{6,80},{60,80},{60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(twomPulse.fire_p, fire_p) annotation (Line(
                points={{-6,21},{-6,80},{-60,80},{-60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics={Line(
                          points={{-40,-20},{-40,-24},{-20,-24},{-20,-40},{-40,-40},
                      {-40,-60}},
                          color={255,0,255},
                          smooth=Smooth.None),Line(
                          points={{20,-20},{20,-44},{40,-44},{40,-60},{20,-60},{20,
                      -60}},
                          color={255,0,255},
                          smooth=Smooth.None),Text(
                          extent={{-40,60},{40,0}},
                          lineColor={255,0,255},
                          fillColor={0,0,255},
                          fillPattern=FillPattern.Solid,
                          textString="2*%m%")}),
              Documentation(info="<html>

<p>
General information about controllers is summarized in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.ACDC.Control\">Control</a>.
</p>

<p>
Half of the semiconductors of the <code>2*m</code> pulse bridge rectifier are connected with the positive DC output pin (firing signal <code>fire_p</code>). The other half of the simconductors is connected with the negative DC output pin (firing signal <code>fire_n</code>). Parameter <code>m</code> indicates the number of phases</code>.
</p>
</html>",     revisions="<html>
</html>"));
          end VoltageBridge2mPulse;

          model VoltageCenterTap2mPulse "Control of 2*m pulse cetner tap rectifier"
            extends Icons.Control;
            import Modelica.Constants.pi;
            parameter Integer m(final min=3) = 3 "Number of phases";
            parameter Modelica.SIunits.Frequency f=50 "Frequency";
            parameter Boolean useConstantFiringAngle=true "Use constant firing angle instead of signal input";
            parameter Modelica.SIunits.Angle constantFiringAngle=0 "Firing angle"
              annotation (Dialog(enable=useConstantFiringAngle));
            parameter Modelica.SIunits.Angle firingAngleMax(
              min=0,
              max=Modelica.Constants.pi) = Modelica.Constants.pi "Maximum firing angle";
            parameter Boolean useFilter=true "Enable use of filter"
              annotation (Dialog(tab="Filter"));
            parameter Modelica.SIunits.Frequency fCut=2*f "Cut off frequency of filter"
              annotation (Dialog(tab="Filter", enable=useFilter));
            parameter Modelica.SIunits.Voltage vStart[m]=zeros(m) "Start voltage of filter output"
              annotation (Dialog(tab="Filter", enable=useFilter));
            Modelica.Blocks.Interfaces.RealInput firingAngle if not
              useConstantFiringAngle "Firing angle (rad)" annotation (Placement(
                  transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={0,-120})));
            Signal2mPulse twomPulse(
              final useConstantFiringAngle=useConstantFiringAngle,
              final f=f,
              final constantFiringAngle=constantFiringAngle,
              final firingAngleMax=firingAngleMax,
              final m=m,
              final useFilter=useFilter,
              final fCut=2*f,
              final vStart=vStart) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={10,0})));
            Modelica.Electrical.MultiPhase.Interfaces.PositivePlug ac(final m=m)
              annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
            Modelica.Blocks.Interfaces.BooleanOutput fire_p[m] annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={-60,110})));
            Modelica.Blocks.Interfaces.BooleanOutput fire_n[m] annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={60,110})));
            Modelica_AddOn.Electrical.MultiPhase.Basic.MultiDelta delta(final m=m) "Delta connection"
                                 annotation (Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=0,
                  origin={-80,0})));
            Modelica.Electrical.MultiPhase.Sensors.PotentialSensor voltageSensor(
                final m=m) "Voltage sensor"
              annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
            Modelica.Blocks.Math.Gain gain[m](final k=fill(-1, m))
              annotation (Placement(transformation(extent={{-28,-10},{-8,10}})));
          equation
            connect(firingAngle, twomPulse.firingAngle) annotation (Line(
                points={{8.88178e-16,-120},{8.88178e-16,-80},{10,-80},{10,-12}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(voltageSensor.plug_p, delta.plug_p) annotation (Line(
                points={{-60,6.66134e-16},{-66,6.66134e-16},{-66,0},{-68,0},{-68,
                    4.44089e-16},{-70,4.44089e-16}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(ac, delta.plug_n) annotation (Line(
                points={{-100,4.44089e-16},{-90,4.44089e-16}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(gain.y, twomPulse.v) annotation (Line(
                points={{-7,0},{-2,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(voltageSensor.phi, gain.u) annotation (Line(
                points={{-39,0},{-30,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(twomPulse.fire_n, fire_n) annotation (Line(
                points={{16,11},{16,80},{60,80},{60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(twomPulse.fire_p, fire_p) annotation (Line(
                points={{4,11},{4,80},{-60,80},{-60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics={Line(
                          points={{-40,-20},{-40,-24},{-20,-24},{-20,-40},{-40,-40},
                      {-40,-60}},
                          color={255,0,255},
                          smooth=Smooth.None),Line(
                          points={{20,-20},{20,-44},{40,-44},{40,-60},{20,-60},{20,
                      -60}},
                          color={255,0,255},
                          smooth=Smooth.None),Text(
                          extent={{-40,60},{40,0}},
                          lineColor={255,0,255},
                          fillColor={0,0,255},
                          fillPattern=FillPattern.Solid,
                          textString="2*%m%")}),
              Documentation(revisions="<html>
</html>",     info="<html>

<p>
General information about controllers is summarized in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.ACDC.Control\">Control</a>.
</p>
</html>"));
          end VoltageCenterTap2mPulse;

          block Filter "PT1 + allpass filter"
            extends Modelica.Blocks.Interfaces.SISO;
            import Modelica.Constants.pi;
            parameter Modelica.SIunits.Frequency f=50 "Mains Frequency";
            parameter Modelica.SIunits.Frequency fCut=2*f "Cut off frequency";
            final parameter Integer na(final min=2) = 2 "Count of 1st order allpass";
            final parameter Modelica.SIunits.Frequency fa=f/tan(pi/na - atan(f/fCut)
                /(2*na));
            parameter Real yStart=0 "Start value of output"
              annotation (Dialog(enable=useFilter));
            Modelica.Blocks.Continuous.FirstOrder firstOrder(
              final k=1,
              final T=1/(2*pi*fCut),
              initType=Modelica.Blocks.Types.Init.InitialOutput,
              y_start=yStart)
              annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
            Modelica.Blocks.Continuous.TransferFunction transferFunction[na](
              each final b={-1/(2*pi*fa),1},
              each final a={+1/(2*pi*fa),1},
              each initType=Modelica.Blocks.Types.Init.InitialOutput,
              each y_start=yStart)
              annotation (Placement(transformation(extent={{40,-10},{60,10}})));
          equation
            for j in 1:na - 1 loop
              connect(transferFunction[j].y, transferFunction[j + 1].u);
            end for;
            connect(u, firstOrder.u) annotation (Line(
                points={{-120,0},{-62,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(firstOrder.y, transferFunction[1].u) annotation (Line(
                points={{-39,0},{38,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(transferFunction[na].y, y) annotation (Line(
                points={{61,0},{110,0}},
                color={0,0,127},
                smooth=Smooth.None));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics),
              Documentation(info="<html>
<p>First order filter with cut-off frequency <code>fCut</code>. The phase shift of the filter is compensated by a series of two first order allpass filters tuned on suppy frequency <code>f</code>.</p>
</html>"),    Icon(graphics={Polygon(
                          visible=true,
                          lineColor={192,192,192},
                          fillColor={192,192,192},
                          fillPattern=FillPattern.Solid,
                          points={{-80,90},{-88,68},{-72,68},{-80,90}}),Line(
                          visible=true,
                          points={{-80,78},{-80,-90}},
                          color={192,192,192}),Polygon(
                          visible=true,
                          lineColor={192,192,192},
                          fillColor={192,192,192},
                          fillPattern=FillPattern.Solid,
                          points={{90,-80},{68,-72},{68,-88},{90,-80}}),Line(
                          visible=true,
                          points={{-90,-80},{82,-80}},
                          color={192,192,192}),Rectangle(
                          visible=true,
                          lineColor={160,160,164},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Backward,
                          extent={{-80,-80},{22,8}}),Line(
                          visible=true,
                          origin={3.333,-8.667},
                          points={{-83.333,34.667},{24.667,34.667},{42.667,-71.333}},
                          color={0,0,127},
                          smooth=Smooth.Bezier)}));
          end Filter;
          annotation (Documentation(info="<html>
<p>
A generic controller with signal input and <code>2*m</code> firing signals is provided in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.ACDC.Control.Signal2mPulse\">Signal2mPulse</a>,
where <code>m</code> is the arbitrary number of phases</code>. 
Additinal topology specific controllers with electrical connectors are also included.
</p>

<h4>Filters</h4>

<p>
Each controller is equipped with an optional 
<a href=\"modelica://Modelica_Electrical_PowerConverters.ACDC.Control.Filter\">filter</a> 
to filter the input voltages. By default the filter is enabled.  
</p>

<p>
Such filter is needed if the electrical grid includes a significant voltage drop across the grid impedance 
distoring the input voltage wave form of the rectifier. The filter included in the PowerConverters library is first order filter with additional compensation of the filter specific phase lag. 
However, it important to note that the transients of the filters may cause some initial effects which deteriorate after
certein periods.
</p>

<h4>Enable</h4>

<p>
The topology specific controllers allow enabling and disabling of the firing signals. The internal enabling signal of the controllers is either derived from the parameter <code>constantEnable</code>,
if <code>useConstantEnable = true</code>. For if <code>useConstantEnable = false</code> the internal 
enabling signal is taken from the optional signal input <code>enable</code>. 
</p>
</html>"));
        end Control;

        model DiodeBridge2Pulse "Two pulse Graetz diode rectifier bridge"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          parameter Modelica.SIunits.Resistance RonDiode(final min=0) = 1e-05 "Closed diode resistance";
          parameter Modelica.SIunits.Conductance GoffDiode(final min=0) = 1e-05 "Opened diode conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode(final min=0) = 0 "Diode forward threshold voltage";
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACtwoPin;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCtwoPin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          Analog.Ideal.IdealDiode diode_p1(
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort,
            final Ron=RonDiode) "Diode connecting the positve AC input pin with postitive DC output"
            annotation (Placement(visible=true, transformation(
                origin={10,50},
                extent={{-10,10},{10,-10}},
                rotation=90)));
          Analog.Ideal.IdealDiode diode_p2(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) "Diode connecting the negative AC input pin with postitive DC output"
            annotation (Placement(visible=true, transformation(
                origin={40,50},
                extent={{-10,10},{10,-10}},
                rotation=90)));
          Analog.Ideal.IdealDiode diode_n1(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) "Diode connecting the positve AC input pin with negative DC output"
            annotation (Placement(visible=true, transformation(
                origin={10,-50},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Analog.Ideal.IdealDiode diode_n2(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) "Diode connecting the negative AC input pin with negative DC output"
            annotation (Placement(visible=true, transformation(
                origin={40,-50},
                extent={{-10,-10},{10,10}},
                rotation=90)));
        equation
          if not useHeatPort then
            LossPower = diode_p1.LossPower + diode_p2.LossPower + diode_n1.LossPower
               + diode_n2.LossPower;
          end if;
          connect(diode_p2.n, diode_p1.n) annotation (Line(
              points={{40,60},{10,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n1.p, diode_n2.p) annotation (Line(
              points={{10,-60},{40,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n2.n, diode_p2.p) annotation (Line(
              points={{40,-40},{40,40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_p1.p, diode_n1.n) annotation (Line(
              points={{10,40},{10,-40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_p1.n, dc_p) annotation (Line(
              points={{10,60},{100,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n1.p, dc_n) annotation (Line(
              points={{10,-60},{102,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n1.heatPort, heatPort) annotation (Line(
              points={{20,-50},{20,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_n2.heatPort, heatPort) annotation (Line(
              points={{50,-50},{50,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_p1.heatPort, heatPort) annotation (Line(
              points={{0,50},{-50,50},{-50,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_p2.heatPort, heatPort) annotation (Line(
              points={{30,50},{30,30},{-50,30},{-50,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(ac_p, diode_p1.p) annotation (Line(
              points={{-100,60},{-60,60},{-60,20},{10,20},{10,40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(ac_n, diode_p2.p) annotation (Line(
              points={{-100,-60},{-60,-60},{-60,-20},{40,-20},{40,40}},
              color={0,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a two pulse Graetz diode rectifier bridge. The circuit topology is the same as in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTap2Pulse\">Examples.ACDC.ThyristorCenterTap2Pulse</a>.
</p>
</html>"));
        end DiodeBridge2Pulse;

        model ThyristorBridge2Pulse "Two pulse Graetz thyristor rectifier bridge"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          parameter Modelica.SIunits.Resistance RonThyristor(final min=0) = 1e-05 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance GoffThyristor(final min=0) = 1e-05 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage VkneeThyristor(final min=0) = 0 "Thyristor forward threshold voltage";
          parameter Boolean offStart_p1=true "Boolean start value of variable thyristor_p1.off"
            annotation (choices(checkBox=true));
          parameter Boolean offStart_p2=true "Boolean start value of variable thyristor_p2.off"
            annotation (choices(checkBox=true));
          parameter Boolean offStart_n1=true "Boolean start value of variable thyristor_n1.off"
            annotation (choices(checkBox=true));
          parameter Boolean offStart_n2=true "Boolean start value of variable thyristor_n2.off"
            annotation (choices(checkBox=true));
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACtwoPin;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCtwoPin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable2;
          Analog.Ideal.IdealThyristor thyristor_p1(
            final Ron=RonThyristor,
            final Goff=GoffThyristor,
            final Vknee=VkneeThyristor,
            final useHeatPort=useHeatPort,
            final off(start=offStart_p1, fixed=true)) "Thyristor connecting the positve AC input pin with postitive DC output"
            annotation (Placement(visible=true, transformation(
                origin={-20,50},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Analog.Ideal.IdealThyristor thyristor_p2(
            final Ron=RonThyristor,
            final Goff=GoffThyristor,
            final Vknee=VkneeThyristor,
            final useHeatPort=useHeatPort,
            final off(start=offStart_p2, fixed=true)) "Thyristor connecting the negative AC input pin with postitive DC output"
            annotation (Placement(visible=true, transformation(
                origin={20,50},
                extent={{-10,10},{10,-10}},
                rotation=90)));
          Analog.Ideal.IdealThyristor thyristor_n1(
            final Ron=RonThyristor,
            final Goff=GoffThyristor,
            final Vknee=VkneeThyristor,
            final useHeatPort=useHeatPort,
            final off(start=offStart_n1, fixed=true)) "Thyristor connecting the positve AC input with negative DC output"
            annotation (Placement(visible=true, transformation(
                origin={-20,-50},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Analog.Ideal.IdealThyristor thyristor_n2(
            final Ron=RonThyristor,
            final Goff=GoffThyristor,
            final Vknee=VkneeThyristor,
            final useHeatPort=useHeatPort,
            final off(start=offStart_n2, fixed=true)) "Thyristor connecting the negative AC input with negative DC output"
            annotation (Placement(visible=true, transformation(
                origin={20,-50},
                extent={{-10,10},{10,-10}},
                rotation=90)));
        equation
          if not useHeatPort then
            LossPower = thyristor_p1.LossPower + thyristor_p2.LossPower +
              thyristor_n1.LossPower + thyristor_n2.LossPower;
          end if;
          connect(thyristor_p2.n, thyristor_p1.n) annotation (Line(
              points={{20,60},{-20,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n1.p, thyristor_n2.p) annotation (Line(
              points={{-20,-60},{20,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n2.n, thyristor_p2.p) annotation (Line(
              points={{20,-40},{20,40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p1.p, thyristor_n1.n) annotation (Line(
              points={{-20,40},{-20,-40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p1.n, dc_p) annotation (Line(
              points={{-20,60},{100,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n1.p, dc_n) annotation (Line(
              points={{-20,-60},{102,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n1.heatPort, heatPort) annotation (Line(
              points={{-10,-50},{0,-50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_n2.heatPort, heatPort) annotation (Line(
              points={{10,-50},{0,-50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_p1.heatPort, heatPort) annotation (Line(
              points={{-10,50},{0,50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_p2.heatPort, heatPort) annotation (Line(
              points={{10,50},{0,50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(ac_p, thyristor_p1.p) annotation (Line(
              points={{-100,60},{-100,20},{-20,20},{-20,40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(ac_n, thyristor_n2.n) annotation (Line(
              points={{-100,-60},{-100,-20},{20,-20},{20,-40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(andCondition_p.y, thyristor_p1.fire) annotation (Line(
              points={{-60,-69},{-60,57},{-31,57}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_p.y, thyristor_n2.fire) annotation (Line(
              points={{-60,-69},{-60,-30},{40,-30},{40,-43},{31,-43}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, thyristor_p2.fire) annotation (Line(
              points={{60,-69},{60,57},{31,57}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, thyristor_n1.fire) annotation (Line(
              points={{60,-69},{60,-66},{-40,-66},{-40,-43},{-31,-43}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,12},{0,28}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a two pulse Graetz thyristor rectifier bridge. The firing signal <code>fire_p</code> are connected
with thyristor <code>thyristor_p1</code> and <code>thyristor_n2</code>. 
The firing signal <code>fire_n</code> are connected
with thyristor <code>thyristor_p2</code> and <code>thyristor_n1</code>. See example 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTap2Pulse\">Examples.ACDC.ThyristorCenterTap2Pulse</a>.
</p>
</html>"));
        end ThyristorBridge2Pulse;

        model HalfControlledBridge2Pulse "Two pulse Graetz half controlled rectifier bridge"
          import Modelica.Constants.pi;
          extends Icons.Converter;
          parameter Modelica.SIunits.Resistance RonDiode(final min=0) = 1e-05 "Closed diode resistance";
          parameter Modelica.SIunits.Conductance GoffDiode(final min=0) = 1e-05 "Opened diode conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode(final min=0) = 0 "Diode forward threshold voltage";
          parameter Modelica.SIunits.Resistance RonThyristor(final min=0) = 1e-05 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance GoffThyristor(final min=0) = 1e-05 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage VkneeThyristor(final min=0) = 0 "Thyristor forward threshold voltage";
          parameter Boolean offStart_p1=true "Boolean start value of variable thyristor_p1.off"
            annotation (choices(checkBox=true));
          parameter Boolean offStart_p2=true "Boolean start value of variable thyristor_p2.off"
            annotation (choices(checkBox=true));
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACtwoPin;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCtwoPin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable2;
          Analog.Ideal.IdealThyristor thyristor_p1(
            final Ron=RonThyristor,
            final Goff=GoffThyristor,
            final Vknee=VkneeThyristor,
            final useHeatPort=useHeatPort,
            final off(start=offStart_p1, fixed=true)) annotation (Placement(visible=
                 true, transformation(
                origin={-20,50},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Analog.Ideal.IdealThyristor thyristor_p2(
            final Ron=RonThyristor,
            final Goff=GoffThyristor,
            final Vknee=VkneeThyristor,
            final useHeatPort=useHeatPort,
            final off(start=offStart_p2, fixed=true)) annotation (Placement(visible=
                 true, transformation(
                origin={20,50},
                extent={{-10,10},{10,-10}},
                rotation=90)));
          Analog.Ideal.IdealDiode diode_n1(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) "Diode connected to negative DC potential"
                                                       annotation (Placement(
                visible=true, transformation(
                origin={-20,-50},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Analog.Ideal.IdealDiode diode_n2(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) "Diode connected to negative DC potential"
                                                       annotation (Placement(
                visible=true, transformation(
                origin={20,-50},
                extent={{-10,10},{10,-10}},
                rotation=90)));
        equation
          if not useHeatPort then
            LossPower = thyristor_p1.LossPower + thyristor_p2.LossPower + diode_n1.LossPower
               + diode_n2.LossPower;
          end if;
          connect(thyristor_p2.n, thyristor_p1.n) annotation (Line(
              points={{20,60},{-20,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n1.p, diode_n2.p) annotation (Line(
              points={{-20,-60},{20,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n2.n, thyristor_p2.p) annotation (Line(
              points={{20,-40},{20,40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p1.p, diode_n1.n) annotation (Line(
              points={{-20,40},{-20,-40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p1.n, dc_p) annotation (Line(
              points={{-20,60},{100,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n1.p, dc_n) annotation (Line(
              points={{-20,-60},{102,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n1.heatPort, heatPort) annotation (Line(
              points={{-10,-50},{0,-50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_n2.heatPort, heatPort) annotation (Line(
              points={{10,-50},{0,-50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_p1.heatPort, heatPort) annotation (Line(
              points={{-10,50},{0,50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_p2.heatPort, heatPort) annotation (Line(
              points={{10,50},{0,50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(ac_p, thyristor_p1.p) annotation (Line(
              points={{-100,60},{-100,20},{-20,20},{-20,40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(ac_n, diode_n2.n) annotation (Line(
              points={{-100,-60},{-100,-20},{20,-20},{20,-40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(andCondition_p.y, thyristor_p1.fire) annotation (Line(
              points={{-60,-69},{-60,57},{-31,57}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, thyristor_p2.fire) annotation (Line(
              points={{60,-69},{60,57},{31,57}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-44,50},{36,2}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-44,26},{36,26}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{16,50},{16,2}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{16,26},{-24,50},{-24,2},{16,26}},
                      color={0,0,255},
                      smooth=Smooth.None),Rectangle(
                      extent={{-44,2},{36,-54}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-44,-30},{36,-30}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{16,-6},{16,-54}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{16,-30},{-24,-6},{-24,-54},{16,-30}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-4,-18},{-4,-2}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a two pulse Graetz half controlled rectifier bridge. The firing signal <code>fire_p</code> is connected
with thyristor <code>thyristor_p1</code>. 
The firing signal <code>fire_n</code> is connected
with thyristor <code>thyristor_p2</code>. 
The circuit topology is the same as in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTap2Pulse\">Examples.ACDC.ThyristorCenterTap2Pulse</a>.
</p>
</html>"));
        end HalfControlledBridge2Pulse;

        model DiodeCenterTap2Pulse "Two pulse diode rectifier with center tap"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          parameter Modelica.SIunits.Resistance RonDiode(final min=0) = 1e-05 "Closed diode resistance";
          parameter Modelica.SIunits.Conductance GoffDiode(final min=0) = 1e-05 "Opened diode conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode(final min=0) = 0 "Diode forward threshold voltage";
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACtwoPin;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCpin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          Analog.Ideal.IdealDiode diode_p(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) "Diodes conducting positive pin AC potentials"
                                                           annotation (Placement(
                visible=true, transformation(
                origin={0,60},
                extent={{-10,-10},{10,10}},
                rotation=0)));
          Analog.Ideal.IdealDiode diode_n(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) "Diodes conducting negative pin AC potentials"
                                                           annotation (Placement(
                visible=true, transformation(
                origin={0,-60},
                extent={{-10,-10},{10,10}},
                rotation=0)));
        equation
          if not useHeatPort then
            LossPower = diode_p.LossPower + diode_n.LossPower;
          end if;
          connect(ac_p, diode_p.p) annotation (Line(
              points={{-100,60},{-10,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(ac_n, diode_n.p) annotation (Line(
              points={{-100,-60},{-10,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_p.n, dc_p) annotation (Line(
              points={{10,60},{100,60},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n.n, dc_p) annotation (Line(
              points={{10,-60},{100,-60},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n.heatPort, heatPort) annotation (Line(
              points={{6.66134e-16,-70},{6.66134e-16,-100},{0,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_p.heatPort, heatPort) annotation (Line(
              points={{6.66134e-16,50},{6.66134e-16,40},{20,40},{20,-100},{
                  4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          annotation (
            Icon(coordinateSystem(
                extent={{-100,-100},{100,100}},
                preserveAspectRatio=true,
                initialScale=0.1,
                grid={2,2}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Diagram(coordinateSystem(
                extent={{-100,-100},{100,100}},
                preserveAspectRatio=false,
                initialScale=0.1,
                grid={2,2}), graphics),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a two pulse diode rectifier with center tap. In order to operate this rectifier a voltage with center tap is required. The center tap has to be connected with the negative pin of the load. The circuit topology is the same as in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTap2Pulse\">Examples.ACDC.ThyristorCenterTap2Pulse</a>.
</p>
</html>"));
        end DiodeCenterTap2Pulse;

        model ThyristorCenterTap2Pulse "Two pulse thyristor rectifier with center tap"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          parameter Modelica.SIunits.Resistance RonThyristor(final min=0) = 1e-05 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance GoffThyristor(final min=0) = 1e-05 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage VkneeThyristor(final min=0) = 0 "Thyristor forward threshold voltage";
          parameter Boolean offStart_p=true "Boolean start value of variable thyristor_p.off"
            annotation (choices(checkBox=true));
          parameter Boolean offStart_n=true "Boolean start value of variable thyristor_n.off"
            annotation (choices(checkBox=true));
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACtwoPin;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCpin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable2;
          Analog.Ideal.IdealThyristor thyristor_p(
            final Ron=RonThyristor,
            final Goff=GoffThyristor,
            final Vknee=VkneeThyristor,
            final useHeatPort=useHeatPort,
            final off(start=offStart_p, fixed=true)) "Thyristors conducting positive pin AC potentials"
                                                               annotation (
              Placement(visible=true, transformation(
                origin={0,60},
                extent={{-10,-10},{10,10}},
                rotation=0)));
          Analog.Ideal.IdealThyristor thyristor_n(
            final Ron=RonThyristor,
            final Goff=GoffThyristor,
            final Vknee=VkneeThyristor,
            final useHeatPort=useHeatPort,
            final off(start=offStart_n, fixed=true)) "Thyristors conducting negative pin AC potentials"
                                                               annotation (
              Placement(visible=true, transformation(
                origin={0,-60},
                extent={{-10,-10},{10,10}},
                rotation=0)));
        equation
          if not useHeatPort then
            LossPower = thyristor_p.LossPower + thyristor_n.LossPower;
          end if;
          connect(ac_p, thyristor_p.p) annotation (Line(
              points={{-100,60},{-10,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(ac_n, thyristor_n.p) annotation (Line(
              points={{-100,-60},{-10,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p.n, dc_p) annotation (Line(
              points={{10,60},{100,60},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n.n, dc_p) annotation (Line(
              points={{10,-60},{100,-60},{100,4.44089e-16}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n.heatPort, heatPort) annotation (Line(
              points={{6.66134e-16,-70},{6.66134e-16,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_p.heatPort, heatPort) annotation (Line(
              points={{6.66134e-16,50},{6.66134e-16,40},{20,40},{20,-100},{
                  4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(andCondition_p.y, thyristor_p.fire) annotation (Line(
              points={{-60,-69},{-60,80},{7,80},{7,71}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, thyristor_n.fire) annotation (Line(
              points={{60,-69},{60,-40},{7,-40},{7,-49}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Icon(coordinateSystem(
                extent={{-100,-100},{100,100}},
                preserveAspectRatio=true,
                initialScale=0.1,
                grid={2,2}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,12},{0,28}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Diagram(coordinateSystem(
                extent={{-100,-100},{100,100}},
                preserveAspectRatio=false,
                initialScale=0.1,
                grid={2,2}), graphics),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>This a two pulse thyristor rectifier with center tap. In order to operate this rectifier a voltage with center tap is required. The center tap has to be connected with the negative pin of the load. The circuit topology is the same as in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTap2Pulse\">Examples.ACDC.ThyristorCenterTap2Pulse</a>.
</p>
</html>"));
        end ThyristorCenterTap2Pulse;

        model DiodeCenterTapmPulse "m pulse diode rectifier with center tap"
          import Modelica.Constants.pi;
          extends Icons.Converter;
          parameter Integer m(final min=3) = 3 "Number of phases";
          parameter Modelica.SIunits.Resistance RonDiode(final min=0) = 1e-05 "Closed diode resistance";
          parameter Modelica.SIunits.Conductance GoffDiode(final min=0) = 1e-05 "Opened diode conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode(final min=0) = 0 "Diode forward threshold voltage";
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACplug;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCpin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          MultiPhase.Ideal.IdealDiode diode(
            final m=m,
            final Ron=fill(RonDiode, m),
            final Goff=fill(GoffDiode, m),
            final Vknee=fill(VkneeDiode, m),
            each final useHeatPort=useHeatPort) "Diodes connected to positive DC potential"
                                                        annotation (Placement(
                visible=true, transformation(
                origin={-10,0},
                extent={{10,10},{-10,-10}},
                rotation=180)));
          Modelica.Electrical.MultiPhase.Basic.Star star(final m=m)
            annotation (Placement(transformation(extent={{70,10},{90,-10}})));
          Modelica.Thermal.HeatTransfer.Components.ThermalCollector
            thermalCollector(final m=m) if useHeatPort
            annotation (Placement(transformation(extent={{20,-100},{40,-80}})));
        equation
          assert(mod(m, 2) == 1,
            "DiodeCenterTapmPulse: only odd phase numbers are allowed");
          if not useHeatPort then
            LossPower = sum(diode.idealDiode.LossPower);
          end if;
          connect(diode.plug_n, star.plug_p) annotation (Line(
              points={{0,0},{22,0},{22,-6.66134e-16},{70,-6.66134e-16}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star.pin_n, dc_p) annotation (Line(
              points={{90,-6.66134e-16},{100,-6.66134e-16},{100,4.44089e-16}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(heatPort, thermalCollector.port_b) annotation (Line(
              points={{4.44089e-16,-100},{30,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode.heatPort, thermalCollector.port_a) annotation (Line(
              points={{-10,-10},{-10,-20},{30,-20},{30,-80}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(ac, diode.plug_p) annotation (Line(
              points={{-100,0},{-20,0}},
              color={0,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>.
</p>

<p>
This is a m pulse diode rectifier with center tap. All voltage sources must have one interconnected plug (tap). This rectifiers works only with odd number of phases due the symmetry constrains of even phase numbers implemented in
<a href=\"modelica://Modelica.Electrical.MultiPhase.Functions.symmetricOrientation\">symmetricOrientation</a>. 
The circuit topology is the same as in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTapmPulse\">Examples.ACDC.ThyristorCenterTapmPulse</a>.
</p>
</html>"));
        end DiodeCenterTapmPulse;

        model ThyristorCenterTapmPulse "m pulse thyristor rectifier with center tap"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          // parameter Integer m(final min=3) = 3 "Number of phases";
          parameter Modelica.SIunits.Resistance RonThyristor(final min=0) = 1e-05 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance GoffThyristor(final min=0) = 1e-05 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage VkneeThyristor(final min=0) = 0 "Thyristor forward threshold voltage";
          parameter Boolean offStart[m]=fill(true, m) "Boolean start value of variable thyristor_p[:].off"
            annotation (choices(checkBox=true));
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACplug;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCpin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable1m;
          MultiPhase.Ideal.IdealThyristor thyristor(
            final m=m,
            final Ron=fill(RonThyristor, m),
            final Goff=fill(GoffThyristor, m),
            final Vknee=fill(VkneeThyristor, m),
            each final useHeatPort=useHeatPort,
            final off(start=offStart, fixed=fill(true, m))) "Thyristors conducting AC potentials"
                                                  annotation (Placement(visible=
                  true, transformation(
                origin={-10,0},
                extent={{10,10},{-10,-10}},
                rotation=180)));
          Modelica.Electrical.MultiPhase.Basic.Star star(final m=m)
            annotation (Placement(transformation(extent={{70,10},{90,-10}})));
          Modelica.Thermal.HeatTransfer.Components.ThermalCollector
            thermalCollector(final m=m) if useHeatPort
            annotation (Placement(transformation(extent={{20,-100},{40,-80}})));
        equation
          assert(mod(m, 2) == 1,
            "ThyristorCenterTapmPulse: only odd phase numbers are allowed");
          if not useHeatPort then
            LossPower = sum(thyristor.idealThyristor.LossPower);
          end if;
          connect(thyristor.plug_n, star.plug_p) annotation (Line(
              points={{0,0},{70,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star.pin_n, dc_p) annotation (Line(
              points={{90,4.44089e-16},{100,4.44089e-16}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(heatPort, thermalCollector.port_b) annotation (Line(
              points={{4.44089e-16,-100},{30,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor.heatPort, thermalCollector.port_a) annotation (Line(
              points={{-10,-10},{-10,-20},{30,-20},{30,-80}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(ac, thyristor.plug_p) annotation (Line(
              points={{-100,0},{-20,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(andCondition_p.y, thyristor.fire) annotation (Line(
              points={{-60,-69},{-60,20},{-3,20},{-3,11}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,12},{0,28}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a m pulse thyristor rectifier with center tap. All voltage sources must have one interconnected plug (tap). This rectifiers works only with odd number of phases due the symmetry constrains of even phase numbers implemented in
<a href=\"modelica://Modelica.Electrical.MultiPhase.Functions.symmetricOrientation\">symmetricOrientation</a>. 
See example
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTapmPulse\">Examples.ACDC.ThyristorCenterTapmPulse</a>.
</p>
</html>"));
        end ThyristorCenterTapmPulse;

        model DiodeBridge2mPulse "2*m pulse diode rectifier bridge"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          parameter Integer m(final min=3) = 3 "Number of phases";
          parameter Modelica.SIunits.Resistance RonDiode(final min=0) = 1e-05 "Closed diode resistance";
          parameter Modelica.SIunits.Conductance GoffDiode(final min=0) = 1e-05 "Opened diode conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode(final min=0) = 0 "Diode forward threshold voltage";
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACplug;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCtwoPin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          MultiPhase.Ideal.IdealDiode diode_p(
            final m=m,
            final Ron=fill(RonDiode, m),
            final Goff=fill(GoffDiode, m),
            final Vknee=fill(VkneeDiode, m),
            each final useHeatPort=useHeatPort) "Diodes connected to positive DC potential"
                                                        annotation (Placement(
                visible=true, transformation(
                origin={0,40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          MultiPhase.Ideal.IdealDiode diode_n(
            final m=m,
            final Ron=fill(RonDiode, m),
            final Goff=fill(GoffDiode, m),
            final Vknee=fill(VkneeDiode, m),
            each final useHeatPort=useHeatPort) "Diodes connected to negative DC potential"
                                                        annotation (Placement(
                visible=true, transformation(
                origin={0,-40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Modelica.Electrical.MultiPhase.Basic.Star star_p(final m=m)
            annotation (Placement(transformation(extent={{70,70},{90,50}})));
          Modelica.Electrical.MultiPhase.Basic.Star star_n(final m=m)
            annotation (Placement(transformation(extent={{70,-50},{90,-70}})));
          Modelica.Thermal.HeatTransfer.Components.ThermalCollector
            thermalCollector(final m=m) if useHeatPort
            annotation (Placement(transformation(extent={{10,-100},{30,-80}})));
        equation
          if not useHeatPort then
            LossPower = sum(diode_p.idealDiode.LossPower) + sum(diode_n.idealDiode.LossPower);
          end if;
          connect(ac, diode_p.plug_p) annotation (Line(
              points={{-100,4.44089e-16},{-100,0},{0,0},{0,30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_p.plug_p, diode_n.plug_n) annotation (Line(
              points={{0,30},{0,-30},{1.11022e-15,-30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_p.plug_n, star_p.plug_p) annotation (Line(
              points={{0,50},{0,60},{70,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_p.pin_n, dc_p) annotation (Line(
              points={{90,60},{100,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n.plug_p, star_n.plug_p) annotation (Line(
              points={{0,-50},{0,-60},{70,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_n.pin_n, dc_n) annotation (Line(
              points={{90,-60},{100,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thermalCollector.port_a, diode_n.heatPort) annotation (Line(
              points={{20,-80},{20,-40},{10,-40}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thermalCollector.port_b, heatPort) annotation (Line(
              points={{20,-100},{0,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_p.heatPort, thermalCollector.port_a) annotation (Line(
              points={{10,40},{20,40},{20,-80}},
              color={191,0,0},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}})),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a 2*m pulse diode rectifier bridge. In order to operate this rectifier a voltage source with center tap is required. The circuit topology is the same as in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorBridge2mPulse\">Examples.ACDC.ThyristorBridge2mPulse</a>. It is important to note that for multi phase circuits with even phase numbers greater than three the 
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.MultiStarResistance\">MultiStarResistance</a> shall be used for grounding the voltage sources. 
</p>
</html>"));
        end DiodeBridge2mPulse;

        model ThyristorBridge2mPulse "2*m pulse thyristor rectifier bridge"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          // parameter Integer m(final min=3) = 3 "Number of phases";
          parameter Modelica.SIunits.Resistance RonThyristor(final min=0) = 1e-05 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance GoffThyristor(final min=0) = 1e-05 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage VkneeThyristor(final min=0) = 0 "Thyristor forward threshold voltage";
          parameter Boolean offStart_p[m]=fill(true, m) "Boolean start value of variable thyristor_p[:].off"
            annotation (choices(checkBox=true));
          parameter Boolean offStart_n[m]=fill(true, m) "Boolean start value of variable thyristor_n[:].off"
            annotation (choices(checkBox=true));
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACplug;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCtwoPin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable2m;
          MultiPhase.Ideal.IdealThyristor thyristor_p(
            final m=m,
            final Ron=fill(RonThyristor, m),
            final Goff=fill(GoffThyristor, m),
            final Vknee=fill(VkneeThyristor, m),
            each final useHeatPort=useHeatPort,
            final off(start=offStart_p, fixed=fill(true, m))) "Thyristors connected to positive DC potential"
                                                            annotation (Placement(
                visible=true, transformation(
                origin={0,40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          MultiPhase.Ideal.IdealThyristor thyristor_n(
            final m=m,
            final Ron=fill(RonThyristor, m),
            final Goff=fill(GoffThyristor, m),
            final Vknee=fill(VkneeThyristor, m),
            each final useHeatPort=useHeatPort,
            final off(start=offStart_n, fixed=fill(true, m))) "Thyristors connected to negative DC potential"
                                                            annotation (Placement(
                visible=true, transformation(
                origin={0,-10},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Modelica.Electrical.MultiPhase.Basic.Star star_p(final m=m)
            annotation (Placement(transformation(extent={{70,70},{90,50}})));
          Modelica.Electrical.MultiPhase.Basic.Star star_n(final m=m)
            annotation (Placement(transformation(extent={{70,-20},{90,-40}})));
          Modelica.Thermal.HeatTransfer.Components.ThermalCollector
            thermalConnector(final m=m) if useHeatPort
            annotation (Placement(transformation(extent={{10,-100},{30,-80}})));
        equation
          if not useHeatPort then
            LossPower = sum(thyristor_p.idealThyristor.LossPower) + sum(thyristor_n.idealThyristor.LossPower);
          end if;
          connect(ac, thyristor_p.plug_p) annotation (Line(
              points={{-100,0},{-2.22045e-16,0},{-2.22045e-16,30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p.plug_p, thyristor_n.plug_n) annotation (Line(
              points={{-2.22045e-16,30},{8.88178e-16,30},{8.88178e-16,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p.plug_n, star_p.plug_p) annotation (Line(
              points={{1.33227e-15,50},{1.33227e-15,60},{70,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_p.pin_n, dc_p) annotation (Line(
              points={{90,60},{100,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n.plug_p, star_n.plug_p) annotation (Line(
              points={{-2.22045e-16,-20},{-2.22045e-16,-30},{70,-30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_n.pin_n, dc_n) annotation (Line(
              points={{90,-30},{100,-30},{100,-60},{102,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(heatPort, thermalConnector.port_b) annotation (Line(
              points={{4.44089e-16,-100},{20,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thermalConnector.port_a, thyristor_n.heatPort) annotation (Line(
              points={{20,-80},{20,-10},{10,-10}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_p.heatPort, thermalConnector.port_a) annotation (Line(
              points={{10,40},{20,40},{20,-80}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(andCondition_p.y, thyristor_p.fire) annotation (Line(
              points={{-60,-69},{-60,47},{-11,47}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, thyristor_n.fire) annotation (Line(
              points={{60,-69},{60,-40},{-20,-40},{-20,-3},{-11,-3}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,12},{0,28}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a 2*m pulse thyristor rectifier bridge. In order to operate this rectifier a voltage source with center tap is required. It is important to note that for multi phase circuits with phase even phase numbers greater than three the 
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.MultiStarResistance\">MultiStarResistance</a> shall be used for grounding the voltage sources. 
See example
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorBridge2mPulse\">Examples.ACDC.ThyristorBridge2mPulse</a>.
</p>
</html>"));
        end ThyristorBridge2mPulse;

        model HalfControlledBridge2mPulse "2*m pulse half controlled rectifier bridge"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          // parameter Integer m(final min=3) = 3 "Number of phases";
          parameter Modelica.SIunits.Resistance RonDiode(final min=0) = 1e-05 "Closed diode resistance";
          parameter Modelica.SIunits.Conductance GoffDiode(final min=0) = 1e-05 "Opened diode conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode(final min=0) = 0 "Diode forward threshold voltage";
          parameter Modelica.SIunits.Resistance RonThyristor(final min=0) = 1e-05 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance GoffThyristor(final min=0) = 1e-05 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage VkneeThyristor(final min=0) = 0 "Thyristor forward threshold voltage";
          parameter Boolean offStart_p[m]=fill(true, m) "Boolean start value of variable thyristor_p[:].off"
            annotation (choices(checkBox=true));
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACplug;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCtwoPin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable1m;
          Modelica.Electrical.MultiPhase.Basic.Star star_p(final m=m)
            annotation (Placement(transformation(extent={{70,70},{90,50}})));
          Modelica.Electrical.MultiPhase.Basic.Star star_n(final m=m)
            annotation (Placement(transformation(extent={{70,-50},{90,-70}})));
          MultiPhase.Ideal.IdealThyristor thyristor_p(
            final m=m,
            final Ron=fill(RonThyristor, m),
            final Goff=fill(GoffThyristor, m),
            final Vknee=fill(VkneeThyristor, m),
            each final useHeatPort=useHeatPort,
            final off(start=offStart_p, fixed=fill(true, m))) "Thyristors connected to positive DC potential"
                                                            annotation (Placement(
                visible=true, transformation(
                origin={0,40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          MultiPhase.Ideal.IdealDiode diode_n(
            final m=m,
            final Ron=fill(RonDiode, m),
            final Goff=fill(GoffDiode, m),
            final Vknee=fill(VkneeDiode, m),
            each final useHeatPort=useHeatPort) "Diodes connected to negative DC potential"
                                                        annotation (Placement(
                visible=true, transformation(
                origin={0,-40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Modelica.Thermal.HeatTransfer.Components.ThermalCollector
            thermalCollector(final m=m) if useHeatPort
            annotation (Placement(transformation(extent={{10,-100},{30,-80}})));
        equation
          if not useHeatPort then
            LossPower = sum(thyristor_p.idealThyristor.LossPower) + sum(diode_n.idealDiode.LossPower);
          end if;
          connect(ac, thyristor_p.plug_p) annotation (Line(
              points={{-100,4.44089e-16},{0,4.44089e-16},{0,30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p.plug_p, diode_n.plug_n) annotation (Line(
              points={{0,30},{0,-30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_p.plug_n, star_p.plug_p) annotation (Line(
              points={{0,50},{0,60},{70,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_p.pin_n, dc_p) annotation (Line(
              points={{90,60},{100,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n.plug_p, star_n.plug_p) annotation (Line(
              points={{0,-50},{0,-50},{0,-50},{0,-60},{70,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_n.pin_n, dc_n) annotation (Line(
              points={{90,-60},{102,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(heatPort, thermalCollector.port_b) annotation (Line(
              points={{4.44089e-16,-100},{20,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thermalCollector.port_a, diode_n.heatPort) annotation (Line(
              points={{20,-80},{20,-40},{10,-40}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_p.heatPort, thermalCollector.port_a) annotation (Line(
              points={{10,40},{20,40},{20,-80}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(andCondition_p.y, thyristor_p.fire) annotation (Line(
              points={{-60,-69},{-60,47},{-11,47}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-46,52},{34,4}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-46,28},{34,28}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{14,52},{14,4}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{14,28},{-26,52},{-26,4},{14,28}},
                      color={0,0,255},
                      smooth=Smooth.None),Rectangle(
                      extent={{-46,4},{34,-52}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-46,-28},{34,-28}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{14,-4},{14,-52}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{14,-28},{-26,-4},{-26,-52},{14,-28}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-6,-16},{-6,0}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>


<p>
This is a 2*m pulse half controlled rectifier bridge. In order to operate this rectifier a voltage source with center tap is required. The circuit topology is the same as in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorBridge2mPulse\">Examples.ACDC.ThyristorBridge2mPulse</a>. It is important to note that for multi phase circuits with even phase numbers greater than three the 
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.MultiStarResistance\">MultiStarResistance</a> shall be used for grounding the voltage sources. 
</p>
</html>"));
        end HalfControlledBridge2mPulse;

        model DiodeCenterTap2mPulse "2*m pulse diode rectifier with center tap"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          parameter Integer m(final min=3) = 3 "Number of phases";
          parameter Modelica.SIunits.Resistance RonDiode(final min=0) = 1e-05 "Closed diode resistance";
          parameter Modelica.SIunits.Conductance GoffDiode(final min=0) = 1e-05 "Opened diode conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode(final min=0) = 0 "Diode forward threshold voltage";
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACtwoPlug;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCpin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          MultiPhase.Ideal.IdealDiode diode_p(
            final m=m,
            final Ron=fill(RonDiode, m),
            final Goff=fill(GoffDiode, m),
            final Vknee=fill(VkneeDiode, m),
            each final useHeatPort=useHeatPort) "Diodes connected to positive DC potential"
                                                        annotation (Placement(
                visible=true, transformation(
                origin={-10,60},
                extent={{10,10},{-10,-10}},
                rotation=180)));
          MultiPhase.Ideal.IdealDiode diode_n(
            final m=m,
            final Ron=fill(RonDiode, m),
            final Goff=fill(GoffDiode, m),
            final Vknee=fill(VkneeDiode, m),
            each final useHeatPort=useHeatPort) "Diodes connected to negative DC potential"
                                                        annotation (Placement(
                visible=true, transformation(
                origin={-10,-60},
                extent={{10,10},{-10,-10}},
                rotation=180)));
          Modelica.Electrical.MultiPhase.Basic.Star star_p(final m=m)
            annotation (Placement(transformation(extent={{70,70},{90,50}})));
          Modelica.Electrical.MultiPhase.Basic.Star star_n(final m=m)
            annotation (Placement(transformation(extent={{72,-50},{92,-70}})));
          Modelica.Thermal.HeatTransfer.Components.ThermalCollector
            thermalCollector(final m=m) if useHeatPort
            annotation (Placement(transformation(extent={{20,-100},{40,-80}})));
        equation
          if not useHeatPort then
            LossPower = sum(diode_p.idealDiode.LossPower) + sum(diode_n.idealDiode.LossPower);
          end if;
          connect(diode_p.plug_n, star_p.plug_p) annotation (Line(
              points={{0,60},{70,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_p.pin_n, dc_p) annotation (Line(
              points={{90,60},{100,60},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(heatPort, thermalCollector.port_b) annotation (Line(
              points={{4.44089e-16,-100},{30,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thermalCollector.port_a, diode_n.heatPort) annotation (Line(
              points={{30,-80},{-10,-80},{-10,-70}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_p.heatPort, thermalCollector.port_a) annotation (Line(
              points={{-10,50},{-10,40},{30,40},{30,-80}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(ac_p, diode_p.plug_p) annotation (Line(
              points={{-100,60},{-20,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_n.pin_n, dc_p) annotation (Line(
              points={{92,-60},{100,-60},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n.plug_p, ac_n) annotation (Line(
              points={{-20,-60},{-100,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(diode_n.plug_n, star_n.plug_p) annotation (Line(
              points={{4.44089e-16,-60},{72,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a 2*m pulse diode rectifier with center tap. In order to operate this rectifier a voltage source with center tap is required. The center tap has to be connected with the negative pin of the load. The circuit topology is the same as in 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTap2mPulse\">Examples.ACDC.ThyristorCenterTap2mPulse</a>.
</p>
</html>"));
        end DiodeCenterTap2mPulse;

        model ThyristorCenterTap2mPulse "2*m pulse thyristor rectifier with center tap"
          extends Icons.Converter;
          import Modelica.Constants.pi;
          // parameter Integer m(final min=3) = 3 "Number of phases";
          parameter Modelica.SIunits.Resistance RonThyristor(final min=0) = 1e-05 "Closed thyristor resistance";
          parameter Modelica.SIunits.Conductance GoffThyristor(final min=0) = 1e-05 "Opened thyristor conductance";
          parameter Modelica.SIunits.Voltage VkneeThyristor(final min=0) = 0 "Thyristor forward threshold voltage";
          parameter Boolean offStart_p[m]=fill(true, m) "Boolean start value of variable thyristor_p[:].off"
            annotation (choices(checkBox=true));
          parameter Boolean offStart_n[m]=fill(true, m) "Boolean start value of variable thyristor_n[:].off"
            annotation (choices(checkBox=true));
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.ACtwoPlug;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.ACDC.DCpin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable2m;
          MultiPhase.Ideal.IdealThyristor thyristor_p(
            final m=m,
            final Ron=fill(RonThyristor, m),
            final Goff=fill(GoffThyristor, m),
            final Vknee=fill(VkneeThyristor, m),
            each final useHeatPort=useHeatPort,
            final off(start=offStart_p, fixed=fill(true, m))) "Thyristors conducting positive plug AC potentials"
                                                                annotation (
              Placement(visible=true, transformation(
                origin={-10,60},
                extent={{10,10},{-10,-10}},
                rotation=180)));
          MultiPhase.Ideal.IdealThyristor thyristor_n(
            final m=m,
            final Ron=fill(RonThyristor, m),
            final Goff=fill(GoffThyristor, m),
            final Vknee=fill(VkneeThyristor, m),
            each final useHeatPort=useHeatPort,
            final off(start=offStart_n, fixed=fill(true, m))) "Thyristors conducting negative plug AC potentials"
                                                                annotation (
              Placement(visible=true, transformation(
                origin={-10,-60},
                extent={{10,10},{-10,-10}},
                rotation=180)));
          Modelica.Electrical.MultiPhase.Basic.Star star_p(final m=m)
            annotation (Placement(transformation(extent={{70,70},{90,50}})));
          Modelica.Electrical.MultiPhase.Basic.Star star_n(final m=m)
            annotation (Placement(transformation(extent={{72,-50},{92,-70}})));
          Modelica.Thermal.HeatTransfer.Components.ThermalCollector
            thermalCollector(final m=m) if useHeatPort
            annotation (Placement(transformation(extent={{20,-100},{40,-80}})));
        equation
          if not useHeatPort then
            LossPower = sum(thyristor_p.idealThyristor.LossPower) + sum(thyristor_n.idealThyristor.LossPower);
          end if;
          connect(thyristor_p.plug_n, star_p.plug_p) annotation (Line(
              points={{0,60},{70,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_p.pin_n, dc_p) annotation (Line(
              points={{90,60},{100,60},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(heatPort, thermalCollector.port_b) annotation (Line(
              points={{4.44089e-16,-100},{30,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thermalCollector.port_a, thyristor_n.heatPort) annotation (Line(
              points={{30,-80},{-10,-80},{-10,-70}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thyristor_p.heatPort, thermalCollector.port_a) annotation (Line(
              points={{-10,50},{-10,40},{30,40},{30,-80}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(ac_p, thyristor_p.plug_p) annotation (Line(
              points={{-100,60},{-20,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_n.pin_n, dc_p) annotation (Line(
              points={{92,-60},{100,-60},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n.plug_p, ac_n) annotation (Line(
              points={{-20,-60},{-100,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thyristor_n.plug_n, star_n.plug_p) annotation (Line(
              points={{4.44089e-16,-60},{72,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(andCondition_p.y, thyristor_p.fire) annotation (Line(
              points={{-60,-69},{-60,80},{-3,80},{-3,71}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, thyristor_n.fire) annotation (Line(
              points={{60,-69},{60,-40},{-3,-40},{-3,-49}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Rectangle(
                      extent={{-40,24},{40,-24}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-40,0},{40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,24},{20,-24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{20,0},{-20,24},{-20,-24},{20,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,12},{0,28}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>

<p>
This is a 2*m pulse thyristor rectifier with center tap. In order to operate this rectifier a voltage source with center tap is required. The center tap has to be connected with the negative pin of the load. See example 
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.ACDC.ThyristorCenterTap2mPulse\">Examples.ACDC.ThyristorCenterTap2mPulse</a>.
</p>
</html>"));
        end ThyristorCenterTap2mPulse;
        annotation (Documentation(info="<html>
<p>
General information about AC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.ACDCConcept\">AC/DC converter concept</a>
</p>
</html>"));
      end ACDC;

      package DCAC "DC to AC converters"
        extends Modelica.Icons.Package;
        model SinglePhase2Level "Single phase DC to AC converter"
          extends Modelica.Blocks.Icons.Block;
          parameter Modelica.SIunits.Resistance RonTransistor=1e-05 "Transistor closed resistance";
          parameter Modelica.SIunits.Conductance GoffTransistor=1e-05 "Transistor opened conductance";
          parameter Modelica.SIunits.Voltage VkneeTransistor=0 "Transistor threshold voltage";
          parameter Modelica.SIunits.Resistance RonDiode=1e-05 "Diode closed resistance";
          parameter Modelica.SIunits.Conductance GoffDiode=1e-05 "Diode opened conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode=0 "Diode threshold voltage";
          // parameter Boolean useEnable "Enables enable signal connector";
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.DCAC.DCtwoPin;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.DCAC.ACpin;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable2;
          Analog.Ideal.IdealGTOThyristor transistor_p(
            final Ron=RonTransistor,
            final Goff=GoffTransistor,
            final Vknee=VkneeTransistor,
            final useHeatPort=useHeatPort) annotation (Placement(transformation(
                extent={{-10,10},{10,-10}},
                rotation=270,
                origin={30,20})));
          Analog.Ideal.IdealDiode diode_p(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={70,20})));
          Analog.Ideal.IdealGTOThyristor transistor_n(
            final Ron=RonTransistor,
            final Goff=GoffTransistor,
            final Vknee=VkneeTransistor,
            final useHeatPort=useHeatPort) annotation (Placement(transformation(
                extent={{-10,10},{10,-10}},
                rotation=270,
                origin={30,-20})));
          Analog.Ideal.IdealDiode diode_n(
            final Ron=RonDiode,
            final Goff=GoffDiode,
            final Vknee=VkneeDiode,
            final useHeatPort=useHeatPort) annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={70,-20})));
        equation
          if not useHeatPort then
            LossPower = transistor_p.LossPower + diode_n.LossPower + transistor_n.LossPower
               + diode_n.LossPower;
          end if;
          connect(transistor_p.p, dc_p) annotation (Line(
              points={{30,30},{50,30},{50,60},{-100,60},{-100,100}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_n.n, dc_n) annotation (Line(
              points={{30,-30},{50,-30},{50,-60},{-100,-60},{-100,-100}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_p.p, diode_p.n) annotation (Line(
              points={{30,30},{70,30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_p.n, diode_p.p) annotation (Line(
              points={{30,10},{70,10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_n.p, diode_n.n) annotation (Line(
              points={{30,-10},{70,-10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_n.n, diode_n.p) annotation (Line(
              points={{30,-30},{70,-30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_p.n, transistor_n.p) annotation (Line(
              points={{30,10},{50,10},{50,-10},{30,-10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(ac, transistor_p.n) annotation (Line(
              points={{100,0},{50,0},{50,10},{30,10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_p.heatPort, heatPort) annotation (Line(
              points={{40,20},{40,0},{4.44089e-16,0},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(transistor_n.heatPort, heatPort) annotation (Line(
              points={{40,-20},{40,-40},{4.44089e-16,-40},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_p.heatPort, heatPort) annotation (Line(
              points={{80,20},{80,-40},{4.44089e-16,-40},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_n.heatPort, heatPort) annotation (Line(
              points={{80,-20},{80,-40},{4.44089e-16,-40},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(andCondition_p.y, transistor_p.fire) annotation (Line(
              points={{-60,-69},{-60,13},{19,13}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, transistor_n.fire) annotation (Line(
              points={{60,-69},{60,-50},{10,-50},{10,-27},{19,-27}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Line(
                      points={{-100,-100},{100,100}},
                      color={0,0,127},
                      smooth=Smooth.None),Rectangle(
                      extent={{-40,40},{40,-40}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-20,20},{-20,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-28,20},{-28,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-40,0},{-28,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-20,4},{0,24},{0,40}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-20,-4},{0,-24},{0,-40}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-4,-20},{-10,-8},{-16,-14},{-4,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,-24},{10,-24},{10,24},{0,24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,8},{20,8}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{10,8},{0,-8},{20,-8},{10,8}},
                      color={0,0,255},
                      smooth=Smooth.None),Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC")}),
            Documentation(info="<html>
<p>
This is a single phase two level inverter. The boolean signals <code>fire_p</code> and <code>fire_n</code> shall not be <code>true</code> at the same time to avoid DC bus short circuits. The inverter consists of two transistors and two anti parallel free wheeling diodes.
</p>

<p>
An example of a single phase inverter with PWM voltage control is included in
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.DCAC.SinglePhaseTwoLevel\">Examples.DCAC.SinglePhaseTwoLevel</a>.
</p>
</html>"));
        end SinglePhase2Level;

        model MultiPhase2Level "Multi phase DC to AC converter"
          extends Modelica.Blocks.Icons.Block;
          extends Interfaces.Enable.Enable2m;
          parameter Modelica.SIunits.Resistance RonTransistor=1e-05 "Transistor closed resistance";
          parameter Modelica.SIunits.Conductance GoffTransistor=1e-05 "Transistor opened conductance";
          parameter Modelica.SIunits.Voltage VkneeTransistor=0 "Transistor threshold voltage";
          parameter Modelica.SIunits.Resistance RonDiode=1e-05 "Diode closed resistance";
          parameter Modelica.SIunits.Conductance GoffDiode=1e-05 "Diode opened conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode=0 "Diode threshold voltage";
          // parameter Boolean useEnable "Enables enable signal connector";
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.DCAC.DCtwoPin;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.DCAC.ACplug;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          MultiPhase.Ideal.IdealGTOThyristor transistor_p(
            final m=m,
            final Ron=fill(RonTransistor, m),
            final Goff=fill(GoffTransistor, m),
            final Vknee=fill(VkneeTransistor, m),
            final useHeatPort=useHeatPort) annotation (Placement(transformation(
                extent={{-10,10},{10,-10}},
                rotation=270,
                origin={30,20})));
          MultiPhase.Ideal.IdealDiode diode_p(
            final m=m,
            final Ron=fill(RonDiode, m),
            final Goff=fill(GoffDiode, m),
            final Vknee=fill(VkneeDiode, m),
            final useHeatPort=useHeatPort) annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={70,20})));
          Modelica.Electrical.MultiPhase.Basic.Star star_p(final m=m) annotation (
              Placement(transformation(
                extent={{-10,10},{10,-10}},
                rotation=90,
                origin={50,50})));
          MultiPhase.Ideal.IdealGTOThyristor transistor_n(
            final m=m,
            final Ron=fill(RonTransistor, m),
            final Goff=fill(GoffTransistor, m),
            final Vknee=fill(VkneeTransistor, m),
            final useHeatPort=useHeatPort) annotation (Placement(transformation(
                extent={{-10,10},{10,-10}},
                rotation=270,
                origin={30,-20})));
          MultiPhase.Ideal.IdealDiode diode_n(
            final m=m,
            final Ron=fill(RonDiode, m),
            final Goff=fill(GoffDiode, m),
            final Vknee=fill(VkneeDiode, m),
            final useHeatPort=useHeatPort) annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={70,-20})));
          Modelica.Electrical.MultiPhase.Basic.Star star_n(final m=m) annotation (
              Placement(transformation(
                extent={{10,10},{-10,-10}},
                rotation=90,
                origin={50,-50})));
          Modelica.Thermal.HeatTransfer.Components.ThermalCollector
            thermalCollector(final m=m) if useHeatPort
            annotation (Placement(transformation(extent={{-10,-60},{10,-40}})));
        equation
          if not useHeatPort then
            LossPower = sum(transistor_p.idealGTOThyristor.LossPower) + sum(diode_n.idealDiode.LossPower)
               + sum(transistor_n.idealGTOThyristor.LossPower) + sum(diode_n.idealDiode.LossPower);
          end if;
          connect(transistor_p.plug_p, star_p.plug_p) annotation (Line(
              points={{30,30},{50,30},{50,40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_p.plug_p, diode_p.plug_n) annotation (Line(
              points={{50,40},{50,30},{70,30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_n.plug_n, star_n.plug_p) annotation (Line(
              points={{30,-30},{50,-30},{50,-40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_n.plug_p, diode_n.plug_p) annotation (Line(
              points={{50,-40},{50,-30},{70,-30}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_p.plug_n, diode_p.plug_p) annotation (Line(
              points={{30,10},{70,10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_n.plug_p, diode_n.plug_n) annotation (Line(
              points={{30,-10},{70,-10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(star_n.pin_n, dc_n) annotation (Line(
              points={{50,-60},{50,-66},{-100,-66},{-100,-100}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(dc_p, star_p.pin_n) annotation (Line(
              points={{-100,100},{-100,70},{50,70},{50,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_p.plug_n, ac) annotation (Line(
              points={{30,10},{50,10},{50,0},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor_n.plug_p, ac) annotation (Line(
              points={{30,-10},{50,-10},{50,0},{100,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(heatPort, thermalCollector.port_b) annotation (Line(
              points={{4.44089e-16,-100},{0,-100},{0,-60},{6.66134e-16,-60}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(thermalCollector.port_a, transistor_n.heatPort) annotation (Line(
              points={{6.66134e-16,-40},{6.66134e-16,-36},{40,-36},{40,-20}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_n.heatPort, thermalCollector.port_a) annotation (Line(
              points={{80,-20},{80,-36},{6.66134e-16,-36},{6.66134e-16,-40}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(transistor_p.heatPort, thermalCollector.port_a) annotation (Line(
              points={{40,20},{40,4},{6.66134e-16,4},{6.66134e-16,-40}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode_p.heatPort, thermalCollector.port_a) annotation (Line(
              points={{80,20},{80,4},{6.66134e-16,4},{6.66134e-16,-40}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(andCondition_p.y, transistor_p.fire) annotation (Line(
              points={{-60,-69},{-60,13},{19,13}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, transistor_n.fire) annotation (Line(
              points={{60,-69},{60,-64},{16,-64},{16,-27},{19,-27}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Line(
                      points={{-100,-100},{100,100}},
                      color={0,0,127},
                      smooth=Smooth.None),Rectangle(
                      extent={{-40,40},{40,-40}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-20,20},{-20,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-28,20},{-28,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-40,0},{-28,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-20,4},{0,24},{0,40}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-20,-4},{0,-24},{0,-40}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-4,-20},{-10,-8},{-16,-14},{-4,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,-24},{10,-24},{10,24},{0,24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,8},{20,8}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{10,8},{0,-8},{20,-8},{10,8}},
                      color={0,0,255},
                      smooth=Smooth.None),Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="AC")}),
            Documentation(info="<html>
<p>
This is a multi phase two level inverter. The boolean signals <code>fire_p[k]</code> and <code>fire_n[k]</code> for any phase <code>k</code> shall not be <code>true</code> at the same time to avoid DC bus short circuits. The inverter consists of <code>2*m</code> transistors and two anti parallel free wheeling diodes, respectively, where <code>m</code> is the number of phases.
</p>
</html>"));
        end MultiPhase2Level;
        annotation (Documentation(info="<html>
<p>
General information about DC/AC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.DCACConcept\">DC/AC converter concept</a> 
</p>
</html>"));
      end DCAC;

      package DCDC "DC to DC converters"
        extends Modelica.Icons.Package;
        package Control "Control components for DC to DC converters"
          extends Modelica.Icons.Package;
          model SignalPWM "Generates a pulse width modulated (PWM) boolean fire signal"
            extends Icons.Control;
            parameter Boolean useConstantDutyCycle=true "Enables constant duty cycle";
            parameter Real constantDutyCycle=0 "Constant duty cycle"
              annotation (Dialog(enable=useConstantDutyCycle));
            parameter Modelica.SIunits.Frequency f=1000 "Switching frequency";
            parameter Modelica.SIunits.Time startTime=0 "Start time";
            Modelica.Blocks.Interfaces.RealInput dutyCycle if not
              useConstantDutyCycle "Duty cycle"
              annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
            Modelica.Blocks.Interfaces.BooleanOutput fire "Firing PWM signal"
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={-60,110})));
            Modelica.Blocks.Interfaces.BooleanOutput notFire "Firing PWM signal"
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={60,110})));
            Modelica.Blocks.Sources.Constant const(final k=constantDutyCycle) if
              useConstantDutyCycle
              annotation (Placement(transformation(extent={{-100,-60},{-80,-40}})));
            Modelica.Blocks.Nonlinear.Limiter limiter(uMax=1, uMin=0)
              annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
            Modelica.Blocks.Logical.Less greaterEqual annotation (Placement(
                  transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=0,
                  origin={22,-8})));
            Modelica.Blocks.Discrete.ZeroOrderHold zeroOrderHold(final startTime=
                  startTime, final samplePeriod=1/f)
              annotation (Placement(transformation(extent={{-30,-10},{-10,10}})));
            Modelica.Blocks.Sources.SawTooth sawtooth(
              final period=1/f,
              final amplitude=1,
              final nperiod=-1,
              final offset=0,
              final startTime=startTime) annotation (Placement(visible=true,
                  transformation(
                  origin={-50,-50},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Blocks.Logical.Not inverse annotation (Placement(
                  transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=90,
                  origin={52,20})));
          equation
            connect(const.y, limiter.u) annotation (Line(
                points={{-79,-50},{-70,-50},{-70,0},{-62,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(dutyCycle, limiter.u) annotation (Line(
                points={{-120,1.11022e-15},{-96,1.11022e-15},{-96,0},{-70,0},{-70,
                    6.66134e-16},{-62,6.66134e-16}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(limiter.y, zeroOrderHold.u) annotation (Line(
                points={{-39,6.66134e-16},{-38,6.66134e-16},{-38,4.44089e-16},{-36,
                    4.44089e-16},{-36,8.88178e-16},{-32,8.88178e-16}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(zeroOrderHold.y, greaterEqual.u2) annotation (Line(
                points={{-9,6.66134e-16},{-4,6.66134e-16},{-4,-4.44089e-16},{0,-4.44089e-16},
                    {0,4.44089e-16},{10,4.44089e-16}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(sawtooth.y, greaterEqual.u1) annotation (Line(
                points={{-39,-50},{0,-50},{0,-8},{10,-8}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(greaterEqual.y, inverse.u) annotation (Line(
                points={{33,-8},{52,-8},{52,8}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(greaterEqual.y, fire) annotation (Line(
                points={{33,-8},{36,-8},{36,80},{-60,80},{-60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(inverse.y, notFire) annotation (Line(
                points={{52,31},{52,80},{60,80},{60,110}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics={Line(
                          points={{-100,0},{-98,0},{12,0}},
                          color={0,0,255},
                          smooth=Smooth.None),Line(
                          points={{-60,-22},{-60,-64},{44,-64},{44,-36}},
                          color={0,0,255},
                          smooth=Smooth.None),Line(
                          points={{-80,-16},{-80,-20},{-40,20},{-40,-20},{-36,-16}},
                          color={0,0,255},
                          smooth=Smooth.None),Line(
                          points={{-62,0},{-76,4},{-76,-4},{-62,0}},
                          color={0,0,255},
                          smooth=Smooth.None),Line(
                          points={{44,-36},{44,-36},{40,-50},{44,-50},{48,-50},{44,
                      -36}},
                          color={0,0,255},
                          smooth=Smooth.None),Line(
                          points={{20,-20},{22,-20},{24,-20},{24,20},{44,20},{44,-20},
                      {64,-20},{64,-16}},
                          color={255,0,255},
                          smooth=Smooth.None),Line(
                          points={{-40,-16},{-40,-20},{0,20},{0,-20},{4,-16}},
                          color={0,0,255},
                          smooth=Smooth.None),Line(
                          points={{60,-20},{62,-20},{64,-20},{64,20},{84,20},{84,-20},
                      {84,-20},{88,-20}},
                          color={255,0,255},
                          smooth=Smooth.None)}),
              Documentation(info="<html>
<p>
This controller can be used both for DC/DC and AC/DC converters. 
The signal input of the PWM controller is the duty cycle; the duty cycle is the ratio of the on time 
to the switching period. The output firing signal is strictly determined by the actual duty cycle, indicated as <code>d</code> in Fig.&nbsp;1. 
</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Fig. 1:</b> Firing (<code>fire</code>) and inverse firing (<code>notFire</code>) signal of PWM control; <code>d</code> = duty cycle; <code>f</code> = switching period </caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica_Electrical_PowerConverters/Resources/Images/dutyCycle.png\">
    </td>
  </tr>
</table>

<p>
The firing signal is generated by comparing the sampled duty cycle input with a periodic saw tooth signal [<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.References\">Williams2006</a>]. 
</p>
</html>"));
          end SignalPWM;
          annotation (Documentation(info="<html>
<p>
Currently there is only one PWM method provided in this library.
</p>
</html>"));
        end Control;

        model ChopperStepDown "Step down chopper"
          import Modelica.Constants.pi;
          extends Icons.Converter;
          parameter Modelica.SIunits.Resistance RonTransistor=1e-05 "Transistor closed resistance";
          parameter Modelica.SIunits.Conductance GoffTransistor=1e-05 "Transistor opened conductance";
          parameter Modelica.SIunits.Voltage VkneeTransistor=0 "Transistor threshold voltage";
          parameter Modelica.SIunits.Resistance RonDiode(final min=0) = 1e-05 "Closed diode resistance";
          parameter Modelica.SIunits.Conductance GoffDiode(final min=0) = 1e-05 "Opened diode conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode(final min=0) = 0 "Diode forward threshold voltage";
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.DCDC.DCtwoPin1;
          extends Modelica_AddOn.Electrical.PowerConverters.Interfaces.DCDC.DCtwoPin2;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          extends Interfaces.Enable.Enable1;
          Analog.Ideal.IdealGTOThyristor transistor(
            useHeatPort=useHeatPort,
            Ron=RonTransistor,
            Goff=GoffTransistor,
            Vknee=VkneeTransistor) "Switching transistor" annotation (Placement(
                visible=true, transformation(
                origin={0,60},
                extent={{-10,-10},{10,10}},
                rotation=0)));
          Analog.Ideal.IdealDiode diode(
            Ron=RonDiode,
            Goff=GoffDiode,
            Vknee=VkneeDiode,
            useHeatPort=useHeatPort) "Free wheeling diode" annotation (Placement(
                visible=true, transformation(
                origin={40,0},
                extent={{-10,10},{10,-10}},
                rotation=90)));
        equation
          if not useHeatPort then
            LossPower = diode.LossPower + transistor.LossPower;
          end if;
          connect(diode.n, transistor.n) annotation (Line(
              points={{40,10},{40,60},{10,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor.n, dc_p2) annotation (Line(
              points={{10,60},{100,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(transistor.heatPort, heatPort) annotation (Line(
              points={{6.66134e-16,50},{0,50},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(diode.heatPort, heatPort) annotation (Line(
              points={{30,2.22045e-16},{30,0},{0,0},{0,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(dc_p1, transistor.p) annotation (Line(
              points={{-100,60},{-10,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(dc_n1, diode.p) annotation (Line(
              points={{-100,-60},{40,-60},{40,-10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(dc_n1, dc_n2) annotation (Line(
              points={{-100,-60},{100,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(andCondition_p.y, transistor.fire) annotation (Line(
              points={{-60,-69},{-60,80},{7,80},{7,71}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC in"),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC out"),Text(
                      extent={{-150,150},{150,110}},
                      textString="%name",
                      lineColor={0,0,255}),Rectangle(
                      extent={{-40,40},{40,-40}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-20,20},{-20,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-28,20},{-28,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-40,0},{-28,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-20,4},{0,24},{0,40}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-20,-4},{0,-24},{0,-40}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-4,-20},{-10,-8},{-16,-14},{-4,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,-24},{10,-24},{10,24},{0,24}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,8},{20,8}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{10,8},{0,-8},{20,-8},{10,8}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
This is a conventional step down chopper model. It consists of a transistor and free wheeling diode. 
</p>
</html>"));
        end ChopperStepDown;

        model HBridge "H bridge (four quadrant converter)"
          extends Icons.Converter;
          extends Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort(final T=
               293.15);
          parameter Modelica.SIunits.Resistance RonTransistor=1e-05 "Transistor closed resistance";
          parameter Modelica.SIunits.Conductance GoffTransistor=1e-05 "Transistor opened conductance";
          parameter Modelica.SIunits.Voltage VkneeTransistor=0 "Transistor threshold voltage";
          parameter Modelica.SIunits.Resistance RonDiode=1e-05 "Diode closed resistance";
          parameter Modelica.SIunits.Conductance GoffDiode=1e-05 "Diode opened conductance";
          parameter Modelica.SIunits.Voltage VkneeDiode=0 "Diode threshold voltage";
          extends Interfaces.Enable.Enable2;
          Modelica.Electrical.Analog.Interfaces.PositivePin dc_p1 "Positive DC input"
            annotation (Placement(transformation(extent={{-110,50},{-90,70}})));
          Modelica.Electrical.Analog.Interfaces.NegativePin dc_n1 "Negative DC input"
            annotation (Placement(transformation(extent={{-110,-70},{-90,-50}})));
          Modelica.Electrical.Analog.Interfaces.NegativePin dc_n2 "Negative DC output"
            annotation (Placement(transformation(extent={{90,-70},{110,-50}})));
          Modelica.Electrical.Analog.Interfaces.PositivePin dc_p2 "Postive DC output"
            annotation (Placement(transformation(extent={{90,50},{110,70}})));
          DCAC.SinglePhase2Level inverter_p(
            final RonTransistor=RonTransistor,
            final GoffTransistor=GoffTransistor,
            final VkneeTransistor=VkneeTransistor,
            final RonDiode=RonDiode,
            final GoffDiode=GoffDiode,
            final VkneeDiode=VkneeDiode,
            final useHeatPort=useHeatPort)
            annotation (Placement(transformation(extent={{-20,20},{0,40}})));
          DCAC.SinglePhase2Level inverter_n(
            final RonTransistor=RonTransistor,
            final GoffTransistor=GoffTransistor,
            final VkneeTransistor=VkneeTransistor,
            final RonDiode=RonDiode,
            final GoffDiode=GoffDiode,
            final VkneeDiode=VkneeDiode,
            final useHeatPort=useHeatPort)
            annotation (Placement(transformation(extent={{-58,-40},{-38,-20}})));
          Modelica.Blocks.Interfaces.BooleanInput fire_p "Firing signals of positive potential leg"
                                                       annotation (Placement(
                transformation(
                extent={{-20,-20},{20,20}},
                rotation=90,
                origin={-60,-120})));
          Modelica.Blocks.Interfaces.BooleanInput fire_n "Firing signals of negative potential leg"
                                                       annotation (Placement(
                transformation(
                extent={{-20,-20},{20,20}},
                rotation=90,
                origin={60,-120})));
        equation
          if not useHeatPort then
            LossPower = inverter_p.LossPower + inverter_n.LossPower;
          end if;
          connect(inverter_n.heatPort, heatPort) annotation (Line(
              points={{-48,-40},{-48,-70},{-10,-70},{-10,-100},{4.44089e-16,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(inverter_p.heatPort, heatPort) annotation (Line(
              points={{-10,20},{-10,-100},{0,-100}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(dc_p1, inverter_p.dc_p) annotation (Line(
              points={{-100,60},{-70,60},{-70,40},{-20,40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(dc_p1, inverter_n.dc_p) annotation (Line(
              points={{-100,60},{-70,60},{-70,-20},{-58,-20}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(dc_n1, inverter_n.dc_n) annotation (Line(
              points={{-100,-60},{-80,-60},{-80,-40},{-58,-40}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(dc_n1, inverter_p.dc_n) annotation (Line(
              points={{-100,-60},{-80,-60},{-80,20},{-20,20}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(inverter_p.ac, dc_p2) annotation (Line(
              points={{4.44089e-16,30},{100,30},{100,60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(inverter_n.ac, dc_n2) annotation (Line(
              points={{-38,-30},{100,-30},{100,-60}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, inverter_p.fire_n) annotation (Line(
              points={{60,-69},{60,-50},{-4,-50},{-4,18}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_n.y, inverter_n.fire_p) annotation (Line(
              points={{60,-69},{60,-50},{-54,-50},{-54,-42}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_p.y, inverter_n.fire_n) annotation (Line(
              points={{-60,-69},{-60,-60},{-42,-60},{-42,-42}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(andCondition_p.y, inverter_p.fire_p) annotation (Line(
              points={{-60,-69},{-60,-60},{-16,-60},{-16,18}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(graphics={Rectangle(
                      extent={{-40,40},{40,-40}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{0,-50},{100,-70}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC out"),Text(
                      extent={{-100,70},{0,50}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="DC in"),Line(
                      points={{-20,30},{-20,-30}},
                      color={0,0,127},
                      smooth=Smooth.None),Line(
                      points={{20,30},{20,-30}},
                      color={0,0,127},
                      smooth=Smooth.None),Line(
                      points={{-20,0},{20,0}},
                      color={0,0,127},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
The H bridge is a four quadrant DC/DC converter. It consists of two single phase DC/AC converters which are controlled differently; see Fig.&nbsp;1.</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Fig. 1:</b> H bridge</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica_Electrical_PowerConverters/Resources/Images/Hbridge.png\">
    </td>
  </tr>
</table>

<p>If the firing inputs <code>fire_p</code> and <code>fire_n</code> are inverse, the two legs are controlled symmetrically so that full positive or negative output voltage can be generated. See examples
<a href=\"modelica://Modelica_Electrical_PowerConverters.Examples.DCDC.HBridge\">DCDC.HBridge</a>.
</p>
</html>"));
        end HBridge;
        annotation (Documentation(info="<html>
<p>
General information about DC/DC converters can be found at the
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.DCDCConcept\">DC/DC converter concept</a>
</p>
</html>"));
      end DCDC;

      package Enable "Enabling models"
        extends Modelica.Icons.Package;
        model EnableLogic "Partial model providing enable parameter and optional enable input"
          parameter Boolean useConstantEnable=true "true = disabled boolean input, use constantEnable";
          parameter Boolean constantEnable=true "Constant enabling of firing signals"
            annotation (Dialog(enable=useConstantEnable));
          parameter Integer m(final min=1) = 3 "Number of phases";
          Modelica.Blocks.Sources.BooleanConstant enableConstantSource(final k=
                constantEnable) if useConstantEnable "Constant enable signal of fire and notFire"
                                                         annotation (Placement(
                transformation(
                extent={{-10,10.5},{10,-10.5}},
                rotation=180,
                origin={69.5,0})));
          Modelica.Blocks.Interfaces.BooleanInput enable if not useConstantEnable "Enables fire and notFire"
                                       annotation (Placement(transformation(
                extent={{-20,-20},{20,20}},
                rotation=90,
                origin={100,-120})));
          Blocks.Routing.BooleanReplicator booleanReplicator(final nout=m)
            annotation (Placement(transformation(
                extent={{10,-10},{-10,10}},
                rotation=0,
                origin={0,0})));
          Modelica.Blocks.Interfaces.BooleanOutput internalEnable[m] "m replicated enable signals"
                                          annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={-110,0})));
        equation
          connect(internalEnable, booleanReplicator.y) annotation (Line(
              points={{-110,4.44089e-16},{-11,4.44089e-16}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(enable, booleanReplicator.u) annotation (Line(
              points={{100,-120},{100,-80},{40,-80},{40,-40},{40,8.88178e-16},{26,
                  8.88178e-16},{12,8.88178e-16}},
              color={255,0,255},
              smooth=Smooth.None));
          connect(enableConstantSource.y, booleanReplicator.u) annotation (Line(
              points={{58.5,1.77636e-15},{58.5,8.88178e-16},{12,8.88178e-16}},
              color={255,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Documentation(info="<html>
<p>This model provides an internal enable signal derived either from a parameter or an optional signal input. 
For <code>useConstantEnable = true</code> the internal signal <code>internalEnable</code> is equal to the parameter <code>constantEnable</code>. 
For <code>useConstantEnable = false</code> the internal signal 
<code>internalEnable</code> is equal to the external signal input <code>enable</code>.</p>
</html>"),  Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Rectangle(
                      extent={{-100,100},{100,-100}},
                      lineColor={255,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{-58,60},{58,-60}},
                      lineColor={255,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="enable")}));
        end EnableLogic;
      end Enable;

      package Interfaces "Interfaces"
        import Modelica;
        extends Modelica.Icons.InterfacesPackage;
        package ACDC "AC to DC converter interfaces"
          extends Modelica.Icons.InterfacesPackage;
          partial model ACtwoPin "Positive and negative AC pin"
            Modelica.Electrical.Analog.Interfaces.PositivePin ac_p "Positive AC input"
              annotation (Placement(transformation(extent={{-110,50},{-90,70}})));
            Modelica.Electrical.Analog.Interfaces.NegativePin ac_n "Negative AC input"
              annotation (Placement(transformation(extent={{-110,-70},{-90,-50}})));
            Modelica.SIunits.Voltage vAC=ac_p.v - ac_n.v "AC voltages";
            Modelica.SIunits.Current iAC=ac_p.i "AC currents";
          end ACtwoPin;

          partial model ACplug "AC multi phase plug"
            parameter Integer m(final min=3) = 3 "Number of phases";
            Modelica.Electrical.MultiPhase.Interfaces.PositivePlug ac(final m=m) "AC input"
              annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
            Modelica.SIunits.Voltage vAC[m]=ac.pin[:].v "AC potentials";
            Modelica.SIunits.Current iAC[m]=ac.pin[:].i "AC currents";
          end ACplug;

          partial model ACtwoPlug
            parameter Integer m(final min=3) = 3 "Number of phases";
            Modelica.Electrical.MultiPhase.Interfaces.PositivePlug ac_p(final m=m) "Positive potential AC input"
              annotation (Placement(transformation(extent={{-110,50},{-90,70}})));
            Modelica.Electrical.MultiPhase.Interfaces.NegativePlug ac_n(final m=m) "Negative potential AC input"
              annotation (Placement(transformation(extent={{-110,-70},{-90,-50}})));
            Modelica.SIunits.Voltage vAC[m]=ac_p.pin[:].v - ac_n.pin[:].v "AC voltages";
            Modelica.SIunits.Current iAC[m]=ac_p.pin[:].i "AC currents";
          end ACtwoPlug;

          partial model DCtwoPin "Positive and negative DC pins"
            Modelica.Electrical.Analog.Interfaces.PositivePin dc_p "Postive DC output"
              annotation (Placement(transformation(extent={{90,50},{110,70}})));
            Modelica.Electrical.Analog.Interfaces.NegativePin dc_n "Negative DC output"
              annotation (Placement(transformation(extent={{90,-70},{110,-50}})));
            Modelica.SIunits.Voltage vDC=dc_p.v - dc_n.v "DC voltage";
            Modelica.SIunits.Current iDC=dc_p.i "DC current";
            annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent=
                      {{-100,-100},{100,100}})));
          end DCtwoPin;

          partial model DCpin "Single DC pin"
            Modelica.Electrical.Analog.Interfaces.PositivePin dc_p "Positive DC output"
              annotation (Placement(transformation(extent={{90,-10},{110,10}})));
            Modelica.SIunits.Voltage vDC=dc_p.v "DC potential";
            Modelica.SIunits.Current iDC=dc_p.i "DC current";
          end DCpin;
        end ACDC;

        package DCAC "DC to AC converter interfaces"
          extends Modelica.Icons.InterfacesPackage;
          partial model DCtwoPin "Positive and negative DC pins"
            Modelica.Electrical.Analog.Interfaces.PositivePin dc_p "Positive DC input"
              annotation (Placement(transformation(extent={{-110,110},{-90,90}})));
            Modelica.Electrical.Analog.Interfaces.NegativePin dc_n "Negative DC input"
                                  annotation (Placement(transformation(extent={{-110,
                      -110},{-90,-90}})));
            Modelica.SIunits.Voltage vDC=dc_p.v - dc_n.v "DC voltage";
            Modelica.SIunits.Current iDC=dc_p.i "DC current";
          end DCtwoPin;

          partial model ACpin "Single AC pin"
            Modelica.Electrical.Analog.Interfaces.PositivePin ac "AC output"
              annotation (Placement(transformation(extent={{90,-10},{110,10}})));
            Modelica.SIunits.Voltage vAC=ac.v "AC potential";
            Modelica.SIunits.Current iAC=ac.i "AC current";
          end ACpin;

          partial model ACplug "AC multi phase plug"
            parameter Integer m(final min=3) = 3 "Number of phases";
            Modelica.Electrical.MultiPhase.Interfaces.PositivePlug ac(final m=m) "AC output"
              annotation (Placement(transformation(extent={{90,-10},{110,10}})));
            Modelica.SIunits.Voltage vAC[m]=ac.pin[:].v "AC potential";
            Modelica.SIunits.Current iAC[m]=ac.pin[:].i "AC current";
          end ACplug;
        end DCAC;

        package DCDC "DC to DC converter interfaces"
          extends Modelica.Icons.InterfacesPackage;
          partial model DCtwoPin1 "Positive and negative pins of side 1"
            Modelica.Electrical.Analog.Interfaces.PositivePin dc_p1 "Positive DC input"
              annotation (Placement(transformation(extent={{-110,50},{-90,70}})));
            Modelica.Electrical.Analog.Interfaces.NegativePin dc_n1 "Negative DC input"
              annotation (Placement(transformation(extent={{-110,-70},{-90,-50}})));
            Modelica.SIunits.Voltage vDC1=dc_p1.v - dc_n1.v "DC voltage side 1";
            Modelica.SIunits.Current iDC1=dc_p1.i "DC current side 1";
          end DCtwoPin1;

          partial model DCtwoPin2 "Positive and negative pins of side 2"
            Modelica.Electrical.Analog.Interfaces.PositivePin dc_p2 "Postive DC output"
              annotation (Placement(transformation(extent={{90,50},{110,70}})));
            Modelica.Electrical.Analog.Interfaces.NegativePin dc_n2 "Negative DC output"
              annotation (Placement(transformation(extent={{90,-70},{110,-50}})));
            Modelica.SIunits.Voltage vDC2=dc_p2.v - dc_n2.v "DC voltages side 2";
            Modelica.SIunits.Current iDC2=dc_p2.i "DC current side 2";
          end DCtwoPin2;
        end DCDC;

        package Enable "Enabling interfaces"
          extends Modelica.Icons.InterfacesPackage;
          partial model Enable "Partial model providing enable parameter and optional enable input"
            import Modelica_AddOn;
            parameter Boolean useConstantEnable=true "true = disabled boolean input, use constantEnable"
              annotation (Dialog(tab="Enable"));
            parameter Boolean constantEnable=true "Constant enabling of firing signals"
              annotation (Dialog(tab="Enable", enable=useConstantEnable));
            parameter Integer m(final min=1) = 3 "Number of phases";
            Modelica_AddOn.Electrical.PowerConverters.Enable.EnableLogic
              enableLogic(
              final useConstantEnable=useConstantEnable,
              final constantEnable=constantEnable,
              final m=m) "Enabling logic"
              annotation (Placement(transformation(extent={{80,-90},{100,-70}})));
            Modelica.Blocks.Interfaces.BooleanInput enable if not useConstantEnable "Enables fire and notFire"
                                         annotation (Placement(transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={100,-120})));
          equation
            connect(enableLogic.enable, enable) annotation (Line(
                points={{100,-92},{100,-120}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent=
                      {{-100,-100},{100,100}}), graphics), Documentation(info="<html>
<p>
This partial model provides paramters and the conditional input signal for the enabling models:</p>
<p>
<ul>
<li><a href=\"modelica://Modelica_Electrical_PowerConverters.Interfaces.Enable1\">Enable1</a></li>
<li><a href=\"modelica://Modelica_Electrical_PowerConverters.Interfaces.Enable2\">Enable2</a></li>
<li><a href=\"modelica://Modelica_Electrical_PowerConverters.Interfaces.Enable1m\">Enable1m</a></li>
<li><a href=\"modelica://Modelica_Electrical_PowerConverters.Interfaces.Enable2m\">Enable2m</a></li>
</ul>
</p>
</html>"));
          end Enable;

          partial model Enable1 "Partial model providing enable parameter and optional enable input for one firing signal"
            extends Enable(final m=1);
            Modelica.Blocks.Logical.And andCondition_p "And condition for positive firing signal"
                                                         annotation (Placement(
                  transformation(
                  extent={{10,10},{-10,-10}},
                  rotation=270,
                  origin={-60,-80})));
            Modelica.Blocks.Interfaces.BooleanInput fire_p "Firing signal of positive potential transistor"
                                                               annotation (
                Placement(transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={-60,-120})));
          equation
            connect(andCondition_p.u1, fire_p) annotation (Line(
                points={{-60,-92},{-60,-120}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(enableLogic.enable, enable) annotation (Line(
                points={{100,-92},{100,-120}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(enableLogic.internalEnable[1], andCondition_p.u2) annotation (
                Line(
                points={{79,-80},{76,-80},{76,-96},{40,-96},{40,-76},{-40,-76},{-40,
                    -100},{-52,-100},{-52,-92}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent=
                      {{-100,-100},{100,100}}), graphics), Documentation(info="<html>
<p>This partial model provides the enabling logic for one firing signal.</p>
</html>"));
          end Enable1;

          partial model Enable1m "Partial model providing enable parameter and optional enable input for m firing signals"
            import Modelica_AddOn;
            parameter Boolean useConstantEnable=true "true = disabled boolean input, use constantEnable"
              annotation (Dialog(tab="Enable"));
            parameter Boolean constantEnable=true "Constant enabling of firing signals"
              annotation (Dialog(tab="Enable", enable=useConstantEnable));
            parameter Integer m(final min=3) = 3 "Number of phases";
            Modelica.Blocks.Logical.And andCondition_p[m] "And condition for m positive firing signals"
                                                            annotation (Placement(
                  transformation(
                  extent={{10,10},{-10,-10}},
                  rotation=270,
                  origin={-60,-80})));
            Modelica.Blocks.Interfaces.BooleanInput fire_p[m] "Firing signals of positive potential transistors"
                                                                 annotation (
                Placement(transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={-60,-120})));
            Modelica_AddOn.Electrical.PowerConverters.Enable.EnableLogic
              enableLogic(
              final useConstantEnable=useConstantEnable,
              final constantEnable=constantEnable,
              final m=m) "Enabling logic"
              annotation (Placement(transformation(extent={{80,-90},{100,-70}})));
            Modelica.Blocks.Interfaces.BooleanInput enable if not useConstantEnable "Enables fire and notFire"
                                         annotation (Placement(transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={100,-120})));
          equation
            connect(andCondition_p.u1, fire_p) annotation (Line(
                points={{-60,-92},{-60,-120}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(enableLogic.enable, enable) annotation (Line(
                points={{100,-92},{100,-120}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(enableLogic.internalEnable, andCondition_p.u2) annotation (Line(
                points={{79,-80},{76,-80},{76,-96},{40,-96},{40,-76},{-40,-76},{-40,
                    -100},{-52,-100},{-52,-92}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent=
                      {{-100,-100},{100,100}}), graphics), Documentation(info="<html>
<p>This partial model provides the enabling logic for <code>m</code> firing signal.</p>
</html>"));
          end Enable1m;

          partial model Enable2 "Partial model providing enable parameter and optional enable input for two firing signals"
            extends Enable1;
            Modelica.Blocks.Logical.And andCondition_n "And condition for negative firing signal"
                                                         annotation (Placement(
                  transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={60,-80})));
            Modelica.Blocks.Interfaces.BooleanInput fire_n "Firing signal of negative potential transistor"
                                                               annotation (
                Placement(transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={60,-120})));
          equation
            connect(fire_n, andCondition_n.u1) annotation (Line(
                points={{60,-120},{60,-92}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(enableLogic.internalEnable[1], andCondition_n.u2) annotation (
                Line(
                points={{79,-80},{76,-80},{76,-96},{52,-96},{52,-92}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent=
                      {{-100,-100},{100,100}}), graphics), Documentation(info="<html>
<p>This partial model provides the enabling logic for two firing signal.</p>
</html>"));
          end Enable2;

          partial model Enable2m "Partial model providing enable parameter and optional enable input for 2*m firing signals"
            extends Interfaces.Enable.Enable1m;
            Modelica.Blocks.Logical.And andCondition_n[m] "And condition for m negative firing signals"
                                                            annotation (Placement(
                  transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=270,
                  origin={60,-80})));
            Modelica.Blocks.Interfaces.BooleanInput fire_n[m] "Firing signals of negative potential transistors"
                                                                 annotation (
                Placement(transformation(
                  extent={{-20,-20},{20,20}},
                  rotation=90,
                  origin={60,-120})));
          equation
            connect(fire_n, andCondition_n.u1) annotation (Line(
                points={{60,-120},{60,-92}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(enableLogic.internalEnable, andCondition_n.u2) annotation (Line(
                points={{79,-80},{76,-80},{76,-96},{52,-96},{52,-92}},
                color={255,0,255},
                smooth=Smooth.None));
            annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent=
                      {{-100,-100},{100,100}}), graphics), Documentation(info="<html>
<p>This partial model provides the enabling logic for <code>2*m</code> firing signal.</p>
</html>"));
          end Enable2m;
        end Enable;
      end Interfaces;

      package Icons "Icons"
        extends Modelica.Icons.Package;
        partial model ExampleTemplate "Example template"
          annotation (Icon(graphics={Ellipse(
                      extent={{-100,100},{100,-100}},
                      lineColor={175,175,175},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Polygon(
                      points={{-36,-60},{-36,60},{64,0},{-36,-60}},
                      lineColor={175,175,175},
                      smooth=Smooth.None,
                      fillColor={175,175,175},
                      fillPattern=FillPattern.Solid),Rectangle(
                      extent={{-4,46},{14,-44}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid)}));
        end ExampleTemplate;

        partial model Converter "Converter icon"
          annotation (Icon(graphics={Rectangle(
                      extent={{-100,100},{100,-100}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-100,-100},{100,100}},
                      color={0,0,127},
                      smooth=Smooth.None),Text(
                      extent={{-150,150},{150,110}},
                      textString="%name",
                      lineColor={0,0,255})}));
        end Converter;

        partial block Control "Control icon"
          annotation (Icon(graphics={Rectangle(
                      extent={{-100,100},{100,-100}},
                      lineColor={0,0,127},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{-150,-140},{150,-180}},
                      textString="%name",
                      lineColor={0,0,255})}));
        end Control;
      end Icons;
      annotation (
        Icon(coordinateSystem(
            extent={{-100,-100},{100,100}},
            preserveAspectRatio=true,
            initialScale=0.1,
            grid={2,2}), graphics),
        Diagram(coordinateSystem(
            extent={{-100,-100},{100,100}},
            preserveAspectRatio=true,
            initialScale=0.1,
            grid={2,2})),
        preferredView="info",
        Documentation(info="<html>
<p>
Copyright &copy; 2013-2014, <a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.Contact\">Christian Kral</a> and
<a href=\"modelica://Modelica_Electrical_PowerConverters.UsersGuide.Contact\">Anton Haumer</a>
</p>
<p>
<i>This Modelica package is <u>free</u> software and the use is completely at <u>your own risk</u>; it can be redistributed and/or modified under the terms of the Modelica License 2. For license conditions (including the disclaimer of warranty) see <a href=\"modelica://Modelica.UsersGuide.ModelicaLicense2\">Modelica.UsersGuide.ModelicaLicense2</a> or visit <a href=\"https://www.modelica.org/licenses/ModelicaLicense2\"> https://www.modelica.org/licenses/ModelicaLicense2</a>.</i>
</p>
</html>"));
    end PowerConverters;
  end Electrical;

  package Magnetic "Magnetic"
  extends Modelica.Icons.Package;

    package FundamentalWave "Library for magnetic fundamental wave effects in electric machines"
      extends Modelica.Icons.Package;
      package UsersGuide "User's Guide"
        extends Modelica.Icons.Information;
        class Concept "Fundamental wave concept"
          extends Modelica.Icons.Information;
          annotation (Documentation(info="<html>

<h4>Overview of the concept of fundamental waves</h4>

<p>
The exact magnetic field in the air gap of an electric machine is usually determined by an electro magnetic finite element analysis. The waveform of the magnetic field, e.g., the magnetic potential difference <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/V_m_phi.png\">, consists of a spatial fundamental wave - with respect to an equivalent two pole machine - and additional harmonic waves of different order. The fundamental wave is however dominant in the air gap of an electric machine.
</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Fig. 1:</b> Field lines of a four pole induction machine</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Concept/aimc_fem.png\">
    </td>
  </tr>
</table>

<p>
In the fundamental wave theory only a pure sinusoidal distribution of magnetic quantities is assumed. It is thus assumed that all other harmonic wave effects are not taken into account.</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Fig. 2:</b> Magnetic potential difference of a four pole machine, where <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/varphi.png\"> is the angle of the spatial domain with respect to one pole pair</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Concept/four_pole_V_m.png\">
    </td>
  </tr>
</table>

<p>
The waveforms of the magnetic field quantities, e.g., the magnetic potential difference <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/V_m_phi.png\">, can be represented by complex phasor, e.g., <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/V_m.png\"> according to:
</p>

<p>
&nbsp;&nbsp;<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/V_m_real_complex.png\">
</p>

<p>It is important to note that the magnetic potential used in this library <b>always</b> refers to an equivalent two pole machine.</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Fig. 3:</b> Spatial distribution of the magnetic potential difference (red shade = positive sine wave, blue shade = negative sine wave) including complex phasor representing this spatial distribution</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Concept/electrical_reference_V_m.png\">
    </td>
  </tr>
</table>

<p>
The potential and flow quantities of this library are the complex magnetic potential difference and the complex magnetic flux as defined in the basic <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.MagneticPort\">magnetic port</a>. Due to the sinusoidal distribution of magnetic potential and flux, such a complex phasor representation can be used. This way, the FundamentalWave library can be seen as a spatial extension of the <a href=\"modelica://Modelica.Magnetic.FluxTubes\">FluxTubes</a> library.
</p>

<p>
The specific arrangement of windings in electric machines with <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/p.png\"> pole pairs give rise to sinusoidal dominant magnetic potential wave. The spatial period of this wave is determined by one pole pair
[<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.References\">Mueller70</a>,
 <a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.References\">Spaeth73</a>].
</p>

<p>
The main components of an electric machine model based on the FundamentalWave library are <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">multi phase</a> and <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">single phase windings</a>, <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap\">air gap</a> as well as <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">symmetric</a> or <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SaliencyCageWinding\">salient cage</a> models.
The electric machine models provided in this library are based on symmetrical windings in the stator and equivalent two or three phase windings in squirrel cage rotors. Slip ring induction machines may have different phase numbers in the stator and rotor.
</p>

<h4>Assumptions</h4>

<p>
The machine models of the FundamentalWave library are currently based on the following assumptions
</p>

<ul>
<li>The number of stator phases is greater or equal to three
    [<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.References\">Eckhardt82</a>]
    </li>
<li>The phase windings are assumed to be symmetrical; an extension to this approach can be considered</li>
<li>Only fundamental wave effects are taken into account</li>
<li>The magnetic potential difference refers to an equivalent two pole machine</li>
<li>There are no restrictions on the waveforms of voltages and currents</li>
<li>All resistances and inductances are modeled as constant quantities; saturation effects, cross coupling effects
    [<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.References\">Li07</a>], temperature dependency of resistances and deep bar effects could be considered in an extension to this library</li>
<li>Hysteresis losses are currently not considered [<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.References\">Haumer09</a>]</li>
<li>The losses dissipated in the electric machine models are
    <ul>
    <li>ohmic heat losses,</li>
    <li>eddy current losses in the stator core,</li>
    <li>stray load losses,</li>
    <li>friction losses.</li>
    </ul>
</li>
</ul>

<h4>Note</h4>

<p>
The term <b>fundamental wave</b> refers to spatial waves of the electro magnetic quantities. This library has no limitations with respect to the waveforms of the time domain signals of any voltages, currents, etc.
</p>
</html>"));
        end Concept;

        class MultiPhase "Multi phase windings"
          extends Modelica.Icons.Information;
          annotation (Documentation(info="<html>
<h4>Symmetrical three phase system</h4>

<p>
Symmetrical three phases systems of currents (or voltages) consists of three sinusoidal
sine waves with with an angular displacement of
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/2pi_3.png\"/>.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/i123.png\"/>,
</p>

<p>
Electrical three phase machines have (usually) symmetrical three phase windings which
excite spatial magnetic potential with a spacial displacement of
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/2pi_3.png\"/>
- with respect to the fundamental wave,
see [<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.References\">Laughton02</a>].
Such a symmetrical three phase system of currents (or voltages) can be represented by
<a href=\"http://en.wikipedia.org/wiki/Phasor\">phasors</a>, as depicted in Fig. 1(a).
The associated three phase winding is depicted in Fig. 2(a). The winding axis are displaced by
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/2pi_3.png\"/>:
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/orientationk_3.png\"/>
</p>

<p>
So there is is a strong coherence between angular displacement in the time and
spatial domain which also applies to multi phase systems.
</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><strong>Fig. 1: </strong>Symmetrical (a) three phase and (b) five phase current system</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/phase35.png\"
           alt=\"phase35.png\">
    </td>
  </tr>
</table>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><strong>Fig. 2: </strong>Symmetrical (a) three phase and (b) five phase winding</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/winding35.png\"
           alt=\"winding35.png\">
    </td>
  </tr>
</table>

<h4>Symmetrical multi phase system</h4>

<p>
In symmetrical multi phase systems odd and even phase numbers have to be distinguished.
</p>

<h5>Odd number of phases</h5>

<p>
For a symmetrical multi phase system with <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/m.png\"/>
phases the displacement in the time and spatial domain is
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/2pi_m.png\"/>,
as depicted in Fig. 1 and 2.
</p>

<p>
Mathematically, this symmetry is expressd in terms of phase currents by:
</p>

<p><img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/ik_odd.png\"/> </p>

<p>
The orientation of the winding axis of such winding is given by:
</p>

<p><img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/orientationk_m.png\"/> </p>

<h5>Even number of phases</h5>

<p>
In the current implementation of the FundamentalWave library, phase numbers equal
to the power of two are not supported. However, any other multi phase system with even
an phase number, <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/m.png\"/>,
can be recursively split into various symmetrical systems with odd phase numbers, as depicted in Fig. 3 and 4.
The displacement between the two symmetrical systems is
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/pi_m.png\"/>.
A function for calculating the <a href=\"modelica://Modelica.Electrical.MultiPhase.Functions.symmetricOrientation\">symmetricOrientation</a> is available.
</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><strong>Fig. 3: </strong>Symmetrical (a) six and (b) ten phase current system</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/phase610.png\"
           alt=\"phase610.png\">
    </td>
  </tr>
</table>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><strong>Fig. 4: </strong>Symmetrical (a) six and (b) ten phase winding</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/MultiPhase/winding610.png\"
           alt=\"winding610.png\">
    </td>
  </tr>
</table>


<h4>Note</h4>

<p>
In a fully symmetrical machine, the orientation of the winding axes and the symmetrical currents (or voltages)
<a href=\"http://en.wikipedia.org/wiki/Phasor\">phasors</a> have different signs; see Fig. 1 and 2 for odd phase numbers
and Fig. 3 and 4 for even phase numbes.
</p>
</html>"));
        end MultiPhase;

        class Parameters "Parameters of equivalent machines models"
          extends Modelica.Icons.Information;
          annotation (Documentation(info="<html>

<h4>Stator main inductance</h4>

<p>
The stator main inductance
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lm_m.png\">
of an
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/m.png\">
phase induction machine is related with the self inductance of on stator phase,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lss.png\">,
by:</p>
<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lm_m_Lss.png\">
</p>

<h4>Parameters of equivalent multi phase induction machines models</h4>

<p>Assume a set parameters,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Rs_3.png\">,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lssigma_3.png\">,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/L0_3.png\">,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lm_3.png\">,
of a three phase induction machine and a set of parameters,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Rs_m.png\">,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lssigma_m.png\">,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/L0_m.png\">,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lm_m.png\">,
of an
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/m.png\">
phase induction machine. It is also assumed that</p>
<ul>
<li>the nominal phase voltages</li>
<li>the nominal stator frequences</li>
</ul>
<p>of the three and
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/m.png\">
phase induction machine are equal. In this case the two parameter sets are related by:</p>
<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Rs_3m.png\"><br>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lssigma_3m.png\"><br>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/L0_3m.png\"><br>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/Lm_3m.png\"></p>
<p>
This way the same torque is generated and the machine currents are related by:
</p>
<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/is_3m.png\">
</p>

<p>
The same applies for the rotor parameters of a
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SlipRing\">
slip ring induction machine</a>, where the phase number
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/m.png\">
is simply replaced by
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/mr.png\">
for transforming equivalent three phase to
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/UsersGuide/Parameters/mr.png\">
phase winding parameters -- at the same nominal rotor voltage and frequency.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Examples.BasicMachines.AIMC_DOL_MultiPhase\">AIMC_DOL_MultiPhase</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Examples.BasicMachines.AIMS_Start_MultiPhase\">AIMS_Start_MultiPhase</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Examples.BasicMachines.SMPM_Inverter_MultiPhase\">SMPM_Inverter_MultiPhase</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Examples.BasicMachines.SMEE_Generator_MultiPhase\">SMEE_Generator_MultiPhase</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Examples.BasicMachines.SMR_Inverter_MultiPhase\">SMR_Inverter_MultiPhase</a>
</p>

</html>"));
        end Parameters;

        class Contact "Contact"
          extends Modelica.Icons.Contact;
          annotation (Documentation(info="<html>
<h4>Contact</h4>

<p>
  Dr. Christian Kral<br>
  <a href=\"http://christiankral.net/\">Electric Machines, Drives and Systems</a><br>
  A-1060 Vienna, Austria<br>
  email: <a href=\"mailto:dr.christian.kral@gmail.com\">dr.christian.kral@gmail.com</a>
</p>

<p>
Anton Haumer<br>
<a href=\"http://www.haumer.at\">Technical Consulting &amp; Electrical Engineering</a><br>
3423 St. Andrae-Woerdern, Austria<br>
email: <a HREF=\"mailto:a.haumer@haumer.at\">a.haumer@haumer.at</a><br>
</p>

<h4>Acknowledgements</h4>

<p>
Based on an original idea of Michael Beuschel this library was developed
[<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.References\">Beuschel00</a>].
The authors of the FundamentalWave library would like to thank Michael Beuschel
for contributing his source code to this library.
</p>

<p>
The research leading to version 2.0.0 has received funding from the ENIAC Joint Undertaking under grant
agreement no. 270693-2 and from the &Ouml;sterreichische
Forschungsf&ouml;rderungsgesellschaft mbH under project
no. 829420.
</p>
</html>"));
        end Contact;

        class ReleaseNotes "Release Notes"
          extends Modelica.Icons.ReleaseNotes;
          annotation (Documentation(info="<html>

<h5>Version 3.2.2, 2014-09-13</h5>

<ul>
<li>Updated documentation of 
    <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Short\">Short</a>, 
    <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Idle\">Idle</a> and
    <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.PermanentMagnet\">PermanentMagnet</a>
    </li>
<li>Added new components:</li>
<ul>
    <li><a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Crossing\">Crossing</a></li>
    <li><a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Permeance\">Permenace</a></li>
</ul>
<li>Removed parameter text from icon layer for reluctance and permeance model</li>
<li>Restructured cage models with reluctance instead of inductance model according to ticket #1536; 
the re-structuring of the model required to change the initial conditions of the included examples, since the number of rotor states is reduced by new implementation</li>
<li>Some more bug fixes according to #1226, since not all reference orientations have been correct</li>
<li>Added variables for magnitude and argument of complex magnetic potential difference and flux, see #1405</li>
</ul>

<h5>Version 3.2.1, 2013-07-31</h5>

<ul>
<li>Bug fix of wrong orientaton of squirrel and damper cage modells, see ticket #1226; this also includes the removal of the rotor cage heat sensor which previously has been used</li>
<li>Bug fix of conditional initialization of examples, see ticket #1223</li>
<li>Fixed missing default parameter TpmOperational in ambient of PM synchronous machine, see ticket #1216</li>
<li>Added voltages, currents, complex flux and magnetic potential difference as global variables in
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter\">multi phase converter</a></li>
<li>Added two more component examples, showing the equivalent nature of electrical and magnetic domain</li>
</ul>

<h5>Version 2.0.0, 2013-03-10</h5>

<ul>
<li>Corrected wrong parameter descriptions, see ticket #1003</li>
<li>Extended machine models towards phase numbers to greater or equal than three, see ticket #990</li>
</ul>

<h5>Version 1.7.3, 2013-02-25</h5>

<ul>
<li>Corrected wrong parameter description</li>
</ul>


<h5>Version 1.7.2, 2011-06-28</h5>

<ul>
<li>Corrected bug in calculation of core conductance in
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">SymmetricMultiPhaseWinding</a>:
the wrong calculation <code>G=(m/2)*GcRef/effectiveTurns^2</code> is now replaced by <code>G=(m/2)*GcRef*effectiveTurns^2</code></li>
</ul>

<h5>Version 1.7.1, 2010-09-03</h5>

<ul>
<li>Naming and documentation of
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PartialTwoPort\">
PartialTwoPort</a> is exchanged by
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PartialTwoPortElementary\">
PartialTwoPortElementary</a> to match the naming conventions of
<a href=\"modelica://Modelica.Mechanics.Rotational.Interfaces\">
Rotational.Interfaces</a>
and <a href=\"modelica://Modelica.Mechanics.Translational.Interfaces\">
Translational.Interfaces</a></li>
<li>Fixed a broken link and updated documentation</li>
<li>Adaptions to Complex SIunits</li>
</ul>

<h5>Version 1.7.0, 2010-05-31</h5>

<ul>
<li>Changed <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">symmetric multi phase winding</a> model
  <ul>
      <li>Added zero sequence inductance based on
          <a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.ZeroInductor\">zero inductor</a></li>
      <li>Replaced electrical model of stray
          <a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.Inductor\">inductor</a> by stray
          <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Reluctance\">reluctance</a> model</li>
      <li>Integrated cores <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.EddyCurrent\">losses</a>
          and <a href=\"modelica://Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a\">heat port</a></li>
  </ul></li>
  <li>Added rotor core loss parameters in asynchronous induction machine with slip rings</li>
  <li>Renamed heat ports of <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">single phase winding</a> and <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">symmetric multi phase winding</a>
     </li>
  <li>Relocated core losses between zero inductor and stray reluctance model in the magnetic domain</li>
  <li>Renamed instances of stator and rotor (winding) models in each machines</li>
  <li>Added magnetic potential sensor</li>
  <li>Removed state selections</li>
  <li>Updates due to changed loss variable and heat port names in
      <a href=\"modelica://Modelica.Electrical.Machines\">Electrical.Machines</a></li>
  <li>Added machine specific output records to summarize power and loss balance</li>
  <li>Updated images of Users Guide</li>
  <li>Improved performance due to <code>annotation(Evaluate=true)</code> added to the parameters of the
      <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">single phase winding</a>
  <li>Reduced number of states in <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseCageWinding\">symmetric cage</a> model by introducing an additional non-grounded star connection</li>
</ul>

<h5>Version 1.6.0, 2010-05-05</h5>

<ul>
<li>Renamed all parameters <code>windingAngle</code> to <code>orientation</code>. The following classes are affected:
<ul>
<li><a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.SinglePhaseElectroMagneticConverter\">SinglePhaseElectroMagneticConverter</a></li>
<li><a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter\">MultiPhaseElectroMagneticConverter</a></li>
<li><a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">SinglePhaseWinding</a></li>
<li><a href=\"modelica://Modelica.Electrical.MultiPhase.Functions.symmetricOrientation\">symmetricOrientation</a></li>
</ul></li>
<li>Update due to changed class names in <a href=\"modelica://Modelica.Electrical.Machines.Icons\">Machines.Icons</a></li>
<li>Using <a href=\"modelica://Modelica.Thermal.HeatTransfer.Interfaces.PartialElementaryConditionalHeatPort\">HeatTransfer.Interfaces.PartialElementaryConditionalHeatPort</a> instead of
    <a href=\"modelica://Modelica.Electrical.Analog.Interfaces.ConditionalHeatPort\">Analog.Interfaces.ConditionalHeatPort</a> in
    <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.EddyCurrent\">EddyCurrent</a> </li>
<li>Added <code>modelica://</code> to all Modelica hyper links</li>
<li>Fixed bug in displayed parameters of <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.EddyCurrent\">EddyCurrent</a> </li>
<li>Updated some images (and renamed image file <code>LossPower.png</code> to <code>lossPower.png</code>)</li>
<li>Exchanged positive and negative stator ports of <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap\">RotorSaliencyAirGap</a>
model, adapted equations accordingly and updated code documentation.</li>
</ul>

<h5>Version 1.5.0, 2010-04-28</h5>

<ul>
<li>Added stator core, friction, stray load and brush losses to all machine types based on
<a href=\"modelica://Modelica.Electrical.Machines.Losses\">loss models</a> of the <a href=\"modelica://Modelica.Electrical.Machines\">Machines</a> library.</li>
<li>Changed parameter of
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.EddyCurrent\">EddyCurrent</a>
model from R to G</li>
<li>Fixed wrong sign of internal quantity <code>tauElectrical</code>, model behavior does not change</li>
<li>Rewrote equations of electromagnetic coupling to look more elegant</li>
</ul>

<h5>Version 1.4.0, 2010-04-22</h5>

<ul>
<li>Added eddy current model in accordance to <a href=\"modelica://Modelica.Magnetic.FluxTubes\">FluxTubes</a> library</li>
<li>Added thermal heat port to eddy current model</li>
<li>Minor updates due to dependencies of <a href=\"modelica://Modelica.Electrical.Machines\">Machines</a>
</ul>

<h5>Version 1.3.0, 2010-02-26</h5>

<ul>
<li>Changed some icon references</li>
<li>Added state selections for the machine models</li>
<li>Restructured partial machine model</li>
<li>Added copyright information</li>
</ul>

<h5>Version 1.2.0, 2010-02-17</h5>

<ul>
<li>Renamed Machines to BasicMachines</li>
<li>Updated dependencies due to renamed class
<a href=\"modelica://Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20\">LinearTemperatureCoefficient20</a>
<li>Added release notes in User's Guide</li>
</ul>

<h5>Version 1.1.0, 2010-02-15</h5>

<ul>
<li>Added thermal connectors and temperature dependent resistances</li>
</ul>

<h5>Version 1.0.0, 2010-02-04</h5>

<ul>
<li>Integrated the library into the MSL</li>
</ul>

<h5>Version 0.4.0, 2009-10-29</h5>

<ul>
<li>Corrected bug in magnetic potential calculation</li>
</ul>

<h5>Version 0.3.0, 2009-10-28</h5>

<ul>
<li>Renamed number of turns and winding angles</li>
</ul>

<h5>Version 0.2.0, 2009-10-20</h5>

<ul>
<li>Added idle model</li>
</ul>

<h5>Version 0.1.0, 2009-07-22</h5>

<ul>
<li>First version based on the concept of the FluxTubes library and the Magnetics library of Michael Beuschel
[<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.References\">Beuschel00</a>]</li>
</ul>
</html>"));
        end ReleaseNotes;

        class References "References"
          extends Modelica.Icons.References;
          annotation (Documentation(info="<html>
<h4>References</h4>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td valign=\"top\">[Beuschel00]</td>
      <td valign=\"top\">M. Beuschel,
        &quot;<a href=\"https://www.modelica.org/events/workshop2000/proceedings/Beuschel.pdf\">
        A uniform approach for modelling electrical machines</a>,&quot;
        <i>Modelica Workshop</i>,
        pp. 101-108, October 23-24, 2000.</td>
    </tr>

    <tr>
      <td valign=\"top\">[Eckhardt82]</td>
      <td valign=\"top\">H. Eckhardt,
        <i>Grundz&uuml;ge der elektrischen Maschinen</i> (in German),
        B. G. Teubner Verlag, Stuttgart, 1982.</td>
    </tr>

    <tr>
      <td valign=\"top\">[Haumer09]</td>
      <td valign=\"top\">A. Haumer, and C. Kral,
        &quot;<a href=\"https://www.modelica.org/events/modelica2009/Proceedings/memorystick/pages/papers/0103/0103.pdf\">The
        AdvancedMachines Library: Loss Models for Electric Machines</a>,&quot;
        <i>Modelica Conference</i>, 2009.</td>
    </tr>

    <tr>
      <td valign=\"top\">[Lang84]</td>
      <td valign=\"top\">W. Lang,
        <i>&Uuml;ber die Bemessung verlustarmer Asynchronmotoren mit K&auml;figl&auml;ufer f&uuml;r Pulsumrichterspeisung</i>
       (in German),
       Doctoral Thesis, Technical University of Vienna, 1984.</td>
    </tr>

    <tr>
      <td valign=\"top\">[Laughton02]</td>
      <td valign=\"top\">M.A. Laughton, D.F. Warne
        <i>Electrical Engineer's Reference Book</i>
        Butterworth Heinemann, 16th edition, ISBN 978-0750646376, 2002</td>
    </tr>

    <tr>
      <td valign=\"top\">[Li07]</td>
      <td valign=\"top\">Y. Li, Z. Q. Zhu, D. Howe, and C. M. Bingham,
        &quot;Modeling of Cross-Coupling Magnetic Saturation in Signal-Injection-Based
        Sensorless Control of Permanent-Magnet Brushless AC Motors,&quot;
        <i>IEEE Transactions on Magnetics</i>,
        vol. 43, no. 6, pp. 2552-2554, June 2007.</td>
    </tr>

    <tr>
      <td valign=\"top\">[Mueller70]</td>
      <td valign=\"top\">G, M&uuml;ller,
        <i>Elektrische Maschinen -- Grundlagen, Aufbau und Wirkungsweise</i> (in German),
        VEB Verlag Technik Berlin, 4th edition, 1970.</td>
    </tr>

    <tr>
      <td valign=\"top\">[Spaeth73]</td>
      <td valign=\"top\">H. Sp&auml;th,
        <i>Elektrische Maschinen -- Eine Einf&uuml;hrung in die Theorie des Betriebsverhaltens</i> (in German),
        Springer-Verlag, Berlin, Heidelberg, New York, 1973.</td>
    </tr>

</table>
</html>"));
        end References;
        annotation (Documentation(info="<html>
<p>
This library contains components for modelling of electromagnetic fundamental wave
models for the application in multi phase phase
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines\">electric machines</a>.
The number of phases is not restricted to three. DC machines are (currently) not included
in this library. The FundamentalWave library is an alternative approach to the
<a href=\"modelica://Modelica.Electrical.Machines\">Modelica.Electrical.Machines</a> library.
A great advantage of this library is the strict object orientation of the electrical and
magnetic components that the electric machines models are composed of.
From a didactic point of view this library is very beneficial for students in the
field of electrical engineering.
</p>

<p>
For more details see the <a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.Concept\">concept.</a>
</p>

<h5>Note</h5>

<ul>
<li>All the machine models provided in this library are equivalent two pole machines.
The magnetic potential difference of the connector therefore also refers to an equivalent two pole machine</li>
<li>In machines with <strong>more than three phases</strong> only effects of currents and voltages on the magnetic <strong>fundamental waves</strong> are considered. Other magnetic effects due to higher harmonic are not taken into account.</li>
</ul>


</html>"));
      end UsersGuide;

      package Examples "Examples of electric machines based on the FundamentalWave concept"
        extends Modelica.Icons.ExamplesPackage;
        package Components "Examples of components of the FundamentalWave library"
          extends Modelica.Icons.ExamplesPackage;
          model EddyCurrentLosses "Comparison of equivalent circuits of eddy current loss models"
            extends Modelica.Icons.Example;
            parameter Integer m=3 "Number of phases";
            parameter Modelica.SIunits.Resistance R=0.1 "Resistance of leader cables";
            parameter Modelica.SIunits.Conductance Gc=1 "Loss conductance";
            parameter Modelica.SIunits.Reluctance R_m=1 "Reluctance of the magnetic circuit";
            parameter Real N=1 "Number of turns";
            output Modelica.SIunits.Power lossPower_e=sum(loss_e.conductor.LossPower);
            output Modelica.SIunits.Power lossPower_m=loss_m.lossPower;
            Modelica.Electrical.Analog.Basic.Ground ground_e
              annotation (Placement(transformation(extent={{-90,0},{-70,20}})));
            Modelica.Electrical.Analog.Basic.Ground ground_m
              annotation (Placement(transformation(extent={{-90,-90},{-70,-70}})));
            Modelica.Electrical.MultiPhase.Basic.Star star_e(m=m) annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-80,30})));
            Modelica.Electrical.MultiPhase.Basic.Star star_m(m=m) annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-80,-60})));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage_e(
              m=m,
              V=fill(1, m),
              freqHz=fill(1, m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-80,60})));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage_m(
              m=m,
              V=fill(1, m),
              freqHz=fill(1, m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-80,-30})));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor_e(m=m, R=fill(R,
                  m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-60,70})));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor_m(m=m, R=fill(R,
                  m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-60,-20})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
              converter_e(
              m=m,
              effectiveTurns=fill(N, m),
              orientation=
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m))
              annotation (Placement(transformation(extent={{20,50},{40,70}})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
              converter_m(
              m=m,
              effectiveTurns=fill(N, m),
              orientation=
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m))
              annotation (Placement(transformation(extent={{20,-40},{40,-20}})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Reluctance
              reluctance_e(R_m(d=R_m, q=R_m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={80,60})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Reluctance
              reluctance_m(R_m(d=R_m, q=R_m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={80,-30})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Ground mground_e
              annotation (Placement(transformation(extent={{30,0},{50,20}})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Ground mground_m
              annotation (Placement(transformation(extent={{30,-90},{50,-70}})));
            Modelica.Electrical.MultiPhase.Basic.Conductor loss_e(m=m, G=fill(Gc, m))
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-10,60})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.EddyCurrent loss_m(G=
                 m*N^2*Gc/2) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={60,-20})));
            Modelica.Electrical.MultiPhase.Sensors.PowerSensor powerb_e(m=m)
              annotation (Placement(transformation(extent={{-40,60},{-20,80}})));
            Modelica.Electrical.MultiPhase.Sensors.PowerSensor powerb_m(m=m)
              annotation (Placement(transformation(extent={{-40,-30},{-20,-10}})));
          initial equation
            reluctance_e.Phi = Complex(0, 0);
            reluctance_m.Phi = Complex(0, 0);
          equation
            connect(sineVoltage_e.plug_n, converter_e.plug_n) annotation (Line(
                points={{-80,50},{20,50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(sineVoltage_e.plug_n, star_e.plug_p) annotation (Line(
                points={{-80,50},{-80,40}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(sineVoltage_m.plug_n, star_m.plug_p) annotation (Line(
                points={{-80,-40},{-80,-50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(star_e.pin_n, ground_e.p) annotation (Line(
                points={{-80,20},{-80,20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(star_m.pin_n, ground_m.p) annotation (Line(
                points={{-80,-70},{-80,-70}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(sineVoltage_m.plug_n, converter_m.plug_n) annotation (Line(
                points={{-80,-40},{20,-40}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(converter_e.port_p, reluctance_e.port_p) annotation (Line(
                points={{40,70},{80,70}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_e.port_n, reluctance_e.port_n) annotation (Line(
                points={{40,50},{80,50}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_e.port_n, mground_e.port_p) annotation (Line(
                points={{40,50},{40,20}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_m.port_n, reluctance_m.port_n) annotation (Line(
                points={{40,-40},{80,-40}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_m.port_p, loss_m.port_p) annotation (Line(
                points={{40,-20},{50,-20}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(loss_m.port_n, reluctance_m.port_p) annotation (Line(
                points={{70,-20},{80,-20}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_m.port_n, mground_m.port_p) annotation (Line(
                points={{40,-40},{40,-70}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(resistor_e.plug_p, sineVoltage_e.plug_p) annotation (Line(
                points={{-70,70},{-80,70}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(sineVoltage_m.plug_p, resistor_m.plug_p) annotation (Line(
                points={{-80,-20},{-70,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(resistor_e.plug_n, powerb_e.pc) annotation (Line(
                points={{-50,70},{-40,70}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(powerb_e.pv, powerb_e.pc) annotation (Line(
                points={{-30,80},{-40,80},{-40,70}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(powerb_e.nc, loss_e.plug_p) annotation (Line(
                points={{-20,70},{-10,70}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(powerb_e.nv, sineVoltage_e.plug_n) annotation (Line(
                points={{-30,60},{-30,50},{-80,50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(resistor_m.plug_n, powerb_m.pc) annotation (Line(
                points={{-50,-20},{-40,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(powerb_m.pc, powerb_m.pv) annotation (Line(
                points={{-40,-20},{-40,-10},{-30,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(powerb_m.nc, converter_m.plug_p) annotation (Line(
                points={{-20,-20},{20,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(powerb_m.nv, sineVoltage_m.plug_n) annotation (Line(
                points={{-30,-30},{-30,-40},{-80,-40}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(loss_e.plug_n, sineVoltage_e.plug_n) annotation (Line(
                points={{-10,50},{-80,50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(loss_e.plug_p, converter_e.plug_p) annotation (Line(
                points={{-10,70},{20,70}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (experiment(StopTime=40, Interval=0.01), Documentation(info="<html>
<p>
In this example the eddy current losses are implemented in two different ways. Compare the loss dissipation <code>powerb_e.power</code> and <code>powerb_m.power</code> of the two models indicated by power meters.</p>
</html>"));
          end EddyCurrentLosses;

          model SinglePhaseInductance "Single phase inductance"
            extends Modelica.Icons.Example;
            parameter Modelica.SIunits.Frequency f=1 "Supply frequency";
            parameter Modelica.SIunits.Voltage VRMS=100 "RMS supply voltage";
            parameter Modelica.SIunits.Resistance R=0.1 "Leader cable resistance";
            parameter Modelica.SIunits.Inductance L=1 "Load inductance";
            parameter Real effectiveTurns=5 "Effective number of turns";
            final parameter Modelica.SIunits.Reluctance R_m=effectiveTurns^2/L "Equivalent magnetic reluctance";
            Modelica.Electrical.Analog.Basic.Ground ground_e
              annotation (Placement(transformation(extent={{-70,20},{-50,40}})));
            Modelica.Electrical.Analog.Basic.Ground ground_m
              annotation (Placement(transformation(extent={{-70,-80},{-50,-60}})));
            Modelica.Electrical.Analog.Sources.SineVoltage voltageSource_e(
              freqHz=f,
              V=sqrt(2)*VRMS,
              phase=Modelica.Constants.pi/2) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-60,70})));
            Modelica.Electrical.Analog.Sources.SineVoltage voltageSource_m(
              freqHz=f,
              V=sqrt(2)*VRMS,
              phase=Modelica.Constants.pi/2) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-60,-30})));
            Modelica.Electrical.Analog.Basic.Resistor resistor_e(R=R)
              annotation (Placement(transformation(extent={{-40,70},{-20,90}})));
            Modelica.Electrical.Analog.Basic.Resistor resistor_m(R=R)
              annotation (Placement(transformation(extent={{-40,-30},{-20,-10}})));
            Modelica.Electrical.Analog.Basic.Inductor inductor_e(L=L) annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={0,70})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.SinglePhaseElectroMagneticConverter
              converter_m(effectiveTurns=effectiveTurns, orientation=0)
              annotation (Placement(transformation(extent={{0,-40},{20,-20}})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Reluctance
              reluctance_m(R_m(d=R_m, q=R_m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={60,-30})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Ground groundM_m
              annotation (Placement(transformation(extent={{10,-80},{30,-60}})));
          initial equation
            resistor_e.i = 0;
            resistor_m.i = 0;
          equation
            connect(converter_m.port_p, reluctance_m.port_p) annotation (Line(
                points={{20,-20},{60,-20}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_m.port_n, reluctance_m.port_n) annotation (Line(
                points={{20,-40},{60,-40}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_m.port_n, groundM_m.port_p) annotation (Line(
                points={{20,-40},{20,-60}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(voltageSource_e.n, inductor_e.n) annotation (Line(
                points={{-60,60},{0,60}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_e.n, ground_e.p) annotation (Line(
                points={{-60,60},{-60,40}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_m.n, converter_m.pin_n) annotation (Line(
                points={{-60,-40},{0,-40}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_m.n, ground_m.p) annotation (Line(
                points={{-60,-40},{-60,-60}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_e.p, resistor_e.p) annotation (Line(
                points={{-60,80},{-40,80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(resistor_e.n, inductor_e.p) annotation (Line(
                points={{-20,80},{0,80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_m.p, resistor_m.p) annotation (Line(
                points={{-60,-20},{-40,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(resistor_m.n, converter_m.pin_p) annotation (Line(
                points={{-20,-20},{0,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (experiment(StopTime=100, Interval=0.01));
          end SinglePhaseInductance;

          model MultiPhaseInductance "Multi phase inductance"
            extends Modelica.Icons.Example;
            parameter Integer m=3 "Number of phases";
            parameter Modelica.SIunits.Frequency f=1 "Supply frequency";
            parameter Modelica.SIunits.Voltage VRMS=100 "RMS supply voltage";
            parameter Modelica.SIunits.Resistance R=0.1 "Leader cable resistance";
            parameter Real effectiveTurns=5 "Effective number of turns";
            parameter Modelica.SIunits.Inductance L=1 "Load inductance";
            final parameter Modelica.SIunits.Reluctance R_m=m*effectiveTurns^2/2/L "Equivalent magnetic reluctance";
            Modelica.Electrical.Analog.Basic.Ground ground_e
              annotation (Placement(transformation(extent={{-70,10},{-50,30}})));
            Modelica.Electrical.Analog.Basic.Ground ground_m
              annotation (Placement(transformation(extent={{-70,-90},{-50,-70}})));
            Modelica.Electrical.MultiPhase.Basic.Star star_e(m=m) annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-60,40})));
            Modelica.Electrical.MultiPhase.Basic.Star star_m(m=m) annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-60,-60})));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage voltageSource_e(
              m=m,
              freqHz=fill(f, m),
              V=fill(sqrt(2)*VRMS, m),
              phase=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                  m) + fill(Modelica.Constants.pi/2, m)) annotation (Placement(
                  transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-60,70})));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage voltageSource_m(
              m=m,
              freqHz=fill(f, m),
              V=fill(sqrt(2)*VRMS, m),
              phase=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                  m) + fill(Modelica.Constants.pi/2, m)) annotation (Placement(
                  transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={-60,-30})));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor_e(m=m, R=fill(R,
                  m))
              annotation (Placement(transformation(extent={{-40,70},{-20,90}})));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor_m(m=m, R=fill(R,
                  m))
              annotation (Placement(transformation(extent={{-40,-30},{-20,-10}})));
            Modelica.Electrical.MultiPhase.Basic.Inductor inductor_e(m=m, L=fill(L,
                  m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={0,70})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
              converter_m(
              m=m,
              orientation=
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
              effectiveTurns=fill(effectiveTurns, m))
              annotation (Placement(transformation(extent={{0,-40},{20,-20}})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Reluctance
              reluctance_m(R_m(d=R_m, q=R_m)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={60,-30})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Ground groundM_m
              annotation (Placement(transformation(extent={{10,-90},{30,-70}})));
          initial equation
            resistor_e.i = zeros(m);
            resistor_m.i[1:2] = zeros(2);
          equation
            connect(star_e.plug_p, voltageSource_e.plug_n) annotation (Line(
                points={{-60,50},{-60,60}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_e.plug_n, inductor_e.plug_n) annotation (Line(
                points={{-60,60},{0,60}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(converter_m.port_p, reluctance_m.port_p) annotation (Line(
                points={{20,-20},{60,-20}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_m.port_n, reluctance_m.port_n) annotation (Line(
                points={{20,-40},{60,-40}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(converter_m.port_n, groundM_m.port_p) annotation (Line(
                points={{20,-40},{20,-70}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(voltageSource_m.plug_n, star_m.plug_p) annotation (Line(
                points={{-60,-40},{-60,-50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_m.plug_n, converter_m.plug_n) annotation (Line(
                points={{-60,-40},{0,-40}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_e.plug_p, resistor_e.plug_p) annotation (Line(
                points={{-60,80},{-40,80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(resistor_e.plug_n, inductor_e.plug_p) annotation (Line(
                points={{-20,80},{0,80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(voltageSource_m.plug_p, resistor_m.plug_p) annotation (Line(
                points={{-60,-20},{-40,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(resistor_m.plug_n, converter_m.plug_p) annotation (Line(
                points={{-20,-20},{0,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(star_e.pin_n, ground_e.p) annotation (Line(
                points={{-60,30},{-60,30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(star_m.pin_n, ground_m.p) annotation (Line(
                points={{-60,-70},{-60,-70}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (experiment(StopTime=100, Interval=0.01));
          end MultiPhaseInductance;
        end Components;

        package BasicMachines "Examples of machines of the FundamentalWave library"
          extends Modelica.Icons.ExamplesPackage;
          model AIMC_DOL "Direct on line start of asynchronous induction machine with squirrel cage"
            extends Modelica.Icons.Example;
            constant Integer m=3 "Number of stator phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.Time tOn=0.1 "Start time of machine";
            parameter Modelica.SIunits.Torque T_Load=161.4 "Nominal load torque";
            parameter Modelica.SIunits.AngularVelocity w_Load(displayUnit="1/min")=
                 1440.45*2*Modelica.Constants.pi/60 "Nominal load speed";
            parameter Modelica.SIunits.Inertia J_Load=0.29 "Load inertia";
            parameter Integer p=2 "Number of pole pairs";
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={-90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                Placement(transformation(extent={{-50,80},{-70,100}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage(
              final m=m,
              freqHz=fill(fNominal, m),
              V=fill(sqrt(2.0/3.0)*VsNominal, m)) annotation (Placement(
                  transformation(
                  origin={-30,90},
                  extent={{10,-10},{-10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Ideal.IdealClosingSwitch idealCloser(
              final m=m,
              Ron=fill(1e-5, m),
              Goff=fill(1e-5, m)) annotation (Placement(transformation(
                  origin={0,60},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Blocks.Sources.BooleanStep booleanStep[m](each startTime=tOn,
                each startValue=false) annotation (Placement(transformation(extent=
                      {{-60,50},{-40,70}}, rotation=0)));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM annotation (Placement(transformation(
                  origin={0,30},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorE annotation (Placement(transformation(
                  origin={-60,30},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(
                terminalConnection="D") annotation (Placement(transformation(extent=
                     {{-10,-10},{10,10}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxE(
                terminalConnection="D") annotation (Placement(transformation(extent=
                     {{-10,-70},{10,-50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage
              aimcM(
              Jr=aimcData.Jr,
              Js=aimcData.Js,
              p=aimcData.p,
              fsNominal=aimcData.fsNominal,
              Rs=aimcData.Rs,
              TsRef=aimcData.TsRef,
              alpha20s(displayUnit="1/K") = aimcData.alpha20s,
              Lssigma=aimcData.Lssigma,
              Lszero=aimcData.Lszero,
              frictionParameters=aimcData.frictionParameters,
              statorCoreParameters=aimcData.statorCoreParameters,
              strayLoadParameters=aimcData.strayLoadParameters,
              Lm=aimcData.Lm,
              Lrsigma=aimcData.Lrsigma,
              Rr=aimcData.Rr,
              TrRef=aimcData.TrRef,
              alpha20r(displayUnit="1/K") = aimcData.alpha20r,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              TsOperational=293.15,
              TrOperational=293.15) annotation (Placement(transformation(extent={{-10,
                      -30},{10,-10}}, rotation=0)));
            Modelica.Electrical.Machines.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage
              aimcE(
              p=aimcData.p,
              fsNominal=aimcData.fsNominal,
              Rs=aimcData.Rs,
              TsRef=aimcData.TsRef,
              alpha20s(displayUnit="1/K") = aimcData.alpha20s,
              Lszero=aimcData.Lszero,
              Lssigma=aimcData.Lssigma,
              Jr=aimcData.Jr,
              Js=aimcData.Js,
              frictionParameters=aimcData.frictionParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              statorCoreParameters=aimcData.statorCoreParameters,
              strayLoadParameters=aimcData.strayLoadParameters,
              Lm=aimcData.Lm,
              Lrsigma=aimcData.Lrsigma,
              Rr=aimcData.Rr,
              alpha20r(displayUnit="1/K") = aimcData.alpha20r,
              TsOperational=293.15,
              TrRef=aimcData.TrRef,
              TrOperational=293.15) annotation (Placement(transformation(extent={{-10,
                      -90},{10,-70}}, rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaM(J=J_Load)
              annotation (Placement(transformation(extent={{50,-30},{70,-10}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaE(J=J_Load)
              annotation (Placement(transformation(extent={{50,-90},{70,-70}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
              quadraticLoadTorqueM(
              w_nominal=w_Load,
              tau_nominal=-T_Load,
              TorqueDirection=false,
              useSupport=false) annotation (Placement(transformation(extent={{100,-30},
                      {80,-10}},rotation=0)));
            Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
              quadraticLoadTorqueE(
              w_nominal=w_Load,
              tau_nominal=-T_Load,
              TorqueDirection=false,
              useSupport=false) annotation (Placement(transformation(extent={{100,-90},
                      {80,-70}},rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.AIM_SquirrelCageData
              aimcData
              annotation (Placement(transformation(extent={{-40,-100},{-20,-80}})));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentQuasiRMSSensor annotation (Placement(transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=270,
                  origin={0,10})));
          initial equation
            aimcE.is = zeros(m);
            aimcE.ir = zeros(2);
            aimcM.is = zeros(m);
            aimcM.rotorCage.electroMagneticConverter.Phi = Complex(0, 0);
          equation
            connect(star.pin_n, ground.p)
              annotation (Line(points={{-70,90},{-80,90}}, color={0,0,255}));
            connect(sineVoltage.plug_n, star.plug_p) annotation (Line(points={{-40,
                    90},{-40,90},{-50,90}}, color={0,0,255}));
            connect(aimcM.flange, loadInertiaM.flange_a) annotation (Line(points={{
                    10,-20},{10,-20},{50,-20}}, color={0,0,0}));
            connect(loadInertiaM.flange_b, quadraticLoadTorqueM.flange)
              annotation (Line(points={{70,-20},{80,-20}}, color={0,0,0}));
            connect(terminalBoxM.plug_sn, aimcM.plug_sn)
              annotation (Line(points={{-6,-10},{-6,-10}}, color={0,0,255}));
            connect(terminalBoxM.plug_sp, aimcM.plug_sp)
              annotation (Line(points={{6,-10},{6,-10}}, color={0,0,255}));
            connect(aimcE.flange, loadInertiaE.flange_a) annotation (Line(points={{
                    10,-80},{10,-80},{50,-80}}, color={0,0,0}));
            connect(loadInertiaE.flange_b, quadraticLoadTorqueE.flange)
              annotation (Line(points={{70,-80},{80,-80}}, color={0,0,0}));
            connect(terminalBoxE.plug_sn, aimcE.plug_sn)
              annotation (Line(points={{-6,-70},{-6,-70}}, color={0,0,255}));
            connect(terminalBoxE.plug_sp, aimcE.plug_sp)
              annotation (Line(points={{6,-70},{6,-70}}, color={0,0,255}));
            connect(currentRMSsensorE.plug_n, terminalBoxE.plugSupply) annotation (
                Line(points={{-60,20},{-60,-60},{0,-60},{0,-68}}, color={0,0,255}));
            connect(sineVoltage.plug_p, idealCloser.plug_p) annotation (Line(
                points={{-20,90},{0,90},{0,70}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(idealCloser.plug_n, currentRMSsensorM.plug_p) annotation (Line(
                points={{0,50},{0,47.5},{9.992e-16,47.5},{9.992e-16,45},{0,45},{0,
                    40}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(booleanStep.y, idealCloser.control) annotation (Line(
                points={{-39,60},{-7,60}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensorE.plug_p, idealCloser.plug_n) annotation (Line(
                points={{-60,40},{0,40},{0,50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensorM.plug_n, currentQuasiRMSSensor.plug_p)
              annotation (Line(
                points={{0,20},{0,20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(terminalBoxM.plugSupply, currentQuasiRMSSensor.plug_n)
              annotation (Line(
                points={{0,-8},{0,0}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (experiment(
                StopTime=1.5,
                Interval=0.0002,
                Tolerance=1e-05), Documentation(info="<HTML>
<h4>Direct on line (DOL) starting of an asynchronous induction machine with squirrel cage</h4>
<p>
At start time tStart three phase voltage is supplied to the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage\">asynchronous induction machine with squirrel cage</a>.
The machine starts from standstill, accelerating
inertias against load torque quadratic dependent on speed, finally reaching nominal speed.</p>

<p>
Simulate for 1.5 seconds and plot (versus time):
</p>

<ul>
<li><code>currentRMSsensorM|E.I</code>: equivalent RMS stator current</li>
<li><code>aimcM|E.wMechanical</code>: machine speed</li>
<li><code>aimcM|E.tauElectrical</code>: machine torque</li>
</ul>
</HTML>"));
          end AIMC_DOL;

          model AIMC_DOL_MultiPhase "Direct on line start of multi phase asynchronous induction machine with squirrel cage"
            extends Modelica.Icons.Example;
            constant Integer m3=3 "Number of stator phases of threephase system";
            parameter Integer m=5 "Number of stator phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.Time tOn=0.1 "Start time of machine";
            parameter Modelica.SIunits.Torque T_Load=161.4 "Nominal load torque";
            parameter Modelica.SIunits.AngularVelocity w_Load(displayUnit="1/min")=
                 1440.45*2*Modelica.Constants.pi/60 "Nominal load speed";
            parameter Modelica.SIunits.Inertia J_Load=0.29 "Load inertia";
            parameter Integer p=2 "Number of pole pairs";
            Modelica.Electrical.Analog.Basic.Ground groundM annotation (Placement(
                  transformation(
                  origin={-90,50},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Basic.Star starM(final m=m) annotation (
                Placement(transformation(extent={{-70,62},{-90,82}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltageM(
              final m=m,
              freqHz=fill(fNominal, m),
              V=fill(sqrt(2.0)*VsNominal, m),
              phase=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                  m)) annotation (Placement(transformation(
                  origin={-50,72},
                  extent={{10,-10},{-10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Ideal.IdealClosingSwitch idealCloserM(
              final m=m,
              Ron=fill(1e-5*m/m3, m),
              Goff=fill(1e-5*m3/m, m)) annotation (Placement(transformation(
                  origin={-20,72},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Blocks.Sources.BooleanStep booleanStepM[m](each startTime=tOn,
                each startValue=false) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={-20,40})));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM(m=m) annotation (Placement(transformation(
                  origin={10,72},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(m=m,
                terminalConnection="Y") annotation (Placement(transformation(extent=
                     {{20,60},{40,80}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage
              aimcM(
              Jr=aimcData.Jr,
              Js=aimcData.Js,
              p=aimcData.p,
              fsNominal=aimcData.fsNominal,
              TsRef=aimcData.TsRef,
              alpha20s(displayUnit="1/K") = aimcData.alpha20s,
              frictionParameters=aimcData.frictionParameters,
              statorCoreParameters=aimcData.statorCoreParameters,
              strayLoadParameters=aimcData.strayLoadParameters,
              TrRef=aimcData.TrRef,
              alpha20r(displayUnit="1/K") = aimcData.alpha20r,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              m=m,
              Rs=aimcData.Rs*m/3,
              Lssigma=aimcData.Lssigma*m/3,
              Lszero=aimcData.Lszero*m/3,
              Lm=aimcData.Lm*m/3,
              TsOperational=293.15,
              Lrsigma=aimcData.Lrsigma*m/3,
              Rr=aimcData.Rr*m/3,
              TrOperational=293.15) annotation (Placement(transformation(extent={{
                      20,40},{40,60}}, rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaM(J=J_Load)
              annotation (Placement(transformation(extent={{50,40},{70,60}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
              quadraticLoadTorqueM(
              w_nominal=w_Load,
              tau_nominal=-T_Load,
              TorqueDirection=false,
              useSupport=false) annotation (Placement(transformation(extent={{100,
                      40},{80,60}}, rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.AIM_SquirrelCageData
              aimcData annotation (Placement(transformation(extent={{-100,-100},{-80,
                      -80}})));
            Modelica.Electrical.Analog.Basic.Ground ground3 annotation (Placement(
                  transformation(
                  origin={-90,-52},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Basic.Star star3(final m=m3) annotation (
               Placement(transformation(extent={{-70,-40},{-90,-20}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage3(
              final m=m3,
              V=fill(sqrt(2.0)*VsNominal, m3),
              phase=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                  m3),
              freqHz=fill(fNominal, m3)) annotation (Placement(transformation(
                  origin={-50,-30},
                  extent={{10,-10},{-10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Ideal.IdealClosingSwitch idealCloser3(
              final m=m3,
              Ron=fill(1e-5, m3),
              Goff=fill(1e-5, m3)) annotation (Placement(transformation(
                  origin={-20,-30},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Blocks.Sources.BooleanStep booleanStep3[m3](each startTime=tOn,
                each startValue=false) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={-20,-62})));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensor3(m=3) annotation (Placement(transformation(
                  origin={10,-30},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBox3(
                terminalConnection="Y", m=m3) annotation (Placement(transformation(
                    extent={{20,-42},{40,-22}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage
              aimc3(
              Jr=aimcData.Jr,
              Js=aimcData.Js,
              p=aimcData.p,
              fsNominal=aimcData.fsNominal,
              Rs=aimcData.Rs,
              TsRef=aimcData.TsRef,
              alpha20s(displayUnit="1/K") = aimcData.alpha20s,
              Lssigma=aimcData.Lssigma,
              Lszero=aimcData.Lszero,
              frictionParameters=aimcData.frictionParameters,
              statorCoreParameters=aimcData.statorCoreParameters,
              strayLoadParameters=aimcData.strayLoadParameters,
              Lm=aimcData.Lm,
              Lrsigma=aimcData.Lrsigma,
              Rr=aimcData.Rr,
              TrRef=aimcData.TrRef,
              alpha20r(displayUnit="1/K") = aimcData.alpha20r,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              m=3,
              TsOperational=293.15,
              TrOperational=293.15) annotation (Placement(transformation(extent={{
                      20,-62},{40,-42}}, rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertia3(J=J_Load)
              annotation (Placement(transformation(extent={{50,-62},{70,-42}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
              quadraticLoadTorque3(
              w_nominal=w_Load,
              tau_nominal=-T_Load,
              TorqueDirection=false,
              useSupport=false) annotation (Placement(transformation(extent={{100,-62},
                      {80,-42}},rotation=0)));
            Modelica.Blocks.Math.Gain gain(k=(m/m3)) annotation (Placement(
                  transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={10,32})));
            Modelica.Blocks.Math.Feedback feedback
              annotation (Placement(transformation(extent={{80,10},{100,-10}})));
          initial equation
            aimc3.is[1:2] = zeros(2);
            aimc3.ir[1:2] = zeros(2);
            aimcM.is[1:2] = zeros(2);
            aimcM.rotorCage.electroMagneticConverter.Phi = Complex(0, 0);
          equation
            connect(starM.pin_n, groundM.p) annotation (Line(points={{-90,72},{-90,
                    70},{-90,60}}, color={0,0,255}));
            connect(sineVoltageM.plug_n, starM.plug_p) annotation (Line(points={{-60,
                    72},{-60,72},{-70,72}}, color={0,0,255}));
            connect(aimcM.flange, loadInertiaM.flange_a)
              annotation (Line(points={{40,50},{40,50},{50,50}}, color={0,0,0}));
            connect(terminalBoxM.plug_sn, aimcM.plug_sn)
              annotation (Line(points={{24,60},{24,60}}, color={0,0,255}));
            connect(terminalBoxM.plug_sp, aimcM.plug_sp)
              annotation (Line(points={{36,60},{36,60}}, color={0,0,255}));
            connect(sineVoltageM.plug_p, idealCloserM.plug_p) annotation (Line(
                points={{-40,72},{-30,72}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(idealCloserM.plug_n, currentRMSsensorM.plug_p) annotation (Line(
                points={{-10,72},{0,72}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(booleanStepM.y, idealCloserM.control) annotation (Line(
                points={{-20,51},{-20,65}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(star3.pin_n, ground3.p)
              annotation (Line(points={{-90,-30},{-90,-42}}, color={0,0,255}));
            connect(sineVoltage3.plug_n, star3.plug_p) annotation (Line(points={{-60,
                    -30},{-60,-30},{-70,-30}}, color={0,0,255}));
            connect(aimc3.flange, loadInertia3.flange_a) annotation (Line(points={{
                    40,-52},{40,-52},{50,-52}}, color={0,0,0}));
            connect(loadInertia3.flange_b, quadraticLoadTorque3.flange) annotation (
               Line(points={{70,-52},{74,-52},{76,-52},{80,-52}}, color={0,0,0}));
            connect(terminalBox3.plug_sn, aimc3.plug_sn)
              annotation (Line(points={{24,-42},{24,-42}}, color={0,0,255}));
            connect(terminalBox3.plug_sp, aimc3.plug_sp)
              annotation (Line(points={{36,-42},{36,-42}}, color={0,0,255}));
            connect(terminalBox3.plugSupply, currentRMSsensor3.plug_n) annotation (
                Line(points={{30,-40},{30,-30},{20,-30}}, color={0,0,255}));
            connect(sineVoltage3.plug_p, idealCloser3.plug_p) annotation (Line(
                points={{-40,-30},{-30,-30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(idealCloser3.plug_n, currentRMSsensor3.plug_p) annotation (Line(
                points={{-10,-30},{0,-30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(booleanStep3.y, idealCloser3.control) annotation (Line(
                points={{-20,-51},{-20,-37}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensorM.I, gain.u) annotation (Line(
                points={{10,62},{10,44}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(loadInertiaM.flange_b, quadraticLoadTorqueM.flange) annotation (
               Line(
                points={{70,50},{80,50}},
                color={0,0,0},
                smooth=Smooth.None));
            connect(currentRMSsensor3.I, feedback.u1) annotation (Line(
                points={{10,-19},{10,0},{82,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(feedback.u2, gain.y) annotation (Line(
                points={{90,8},{90,16},{10,16},{10,21}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(currentRMSsensorM.plug_n, terminalBoxM.plugSupply) annotation (
                Line(
                points={{20,72},{30,72},{30,62}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (
              experiment(
                StopTime=1.5,
                Interval=0.0002,
                Tolerance=1e-05),
              Documentation(info="<HTML>
<h4>Direct on line (DOL) starting of an asynchronous induction machine with squirrel cage</h4>
<p>
At start time tStart voltages are supplied to the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage\">multi phase asynchronous induction machines with squirrel cage</a>.
The machines starts from standstill, accelerating
inertias against load torque quadratic dependent on speed, finally reaching nominal speed. Two equivalent machines with different numbers of phases are compared and their equal behavior is demonstrated.</p>

<p>
Simulate for 1.5 seconds and plot (versus time):
</p>

<ul>
<li><code>aimcM|M3.tauElectrical</code>: machine torque</li>
<li><code>aimsM/M3.wMechanical</code>: machine speed</li>
<li><code>feedback.y</code>: zero since difference of three phase current phasor and scaled multi phase current phasor are equal</li>
</ul>
</HTML>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics={Rectangle(
                          extent={{-100,100},{100,20}},
                          lineColor={0,0,255},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash),Rectangle(
                          extent={{-100,-10},{100,-80}},
                          lineColor={0,0,255},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash),Text(
                          extent={{20,88},{100,80}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textString="%m phase machine
",                        textStyle={TextStyle.Bold}),Text(
                          extent={{20,-22},{100,-30}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textString="3 phase machine
",                        textStyle={TextStyle.Bold})}));
          end AIMC_DOL_MultiPhase;

          model AIMS_Start "Starting of asynchronous induction machine with slip rings"
            extends Modelica.Icons.Example;
            constant Integer m=3 "Number of phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.Time tOn=0.1 "Start time of machine";
            parameter Modelica.SIunits.Resistance RStart=0.16/aimsData.turnsRatio^2 "Starting resistance";
            parameter Modelica.SIunits.Time tRheostat=1.0 "Time of shortening the rheostat";
            parameter Modelica.SIunits.Torque T_Load=161.4 "Nominal load torque";
            parameter Modelica.SIunits.AngularVelocity w_Load(displayUnit="1/min")=
                 Modelica.SIunits.Conversions.from_rpm(1440.45) "Nominal load speed";
            parameter Modelica.SIunits.Inertia J_Load=0.29 "Load inertia";
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={-90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                Placement(transformation(extent={{-50,80},{-70,100}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage(
              final m=m,
              V=fill(sqrt(2.0/3.0)*VsNominal, m),
              freqHz=fill(fNominal, m)) annotation (Placement(transformation(
                  origin={-30,90},
                  extent={{10,-10},{-10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Ideal.IdealClosingSwitch idealCloser(
              final m=m,
              Ron=fill(1e-5, m),
              Goff=fill(1e-5, m)) annotation (Placement(transformation(
                  origin={0,60},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Blocks.Sources.BooleanStep booleanStep[m](each startTime=tOn)
              annotation (Placement(transformation(extent={{-60,50},{-40,70}},
                    rotation=0)));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM annotation (Placement(transformation(
                  origin={0,20},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorE annotation (Placement(transformation(
                  origin={-60,20},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(
                terminalConnection="D") annotation (Placement(transformation(extent=
                     {{-10,-10},{10,10}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxE(
                terminalConnection="D") annotation (Placement(transformation(extent=
                     {{-10,-70},{10,-50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SlipRing
              aimsM(
              Jr=aimsData.Jr,
              Js=aimsData.Js,
              p=aimsData.p,
              fsNominal=aimsData.fsNominal,
              Rs=aimsData.Rs,
              TsRef=aimsData.TsRef,
              alpha20s(displayUnit="1/K") = aimsData.alpha20s,
              Lssigma=aimsData.Lssigma,
              Lszero=aimsData.Lszero,
              frictionParameters=aimsData.frictionParameters,
              statorCoreParameters=aimsData.statorCoreParameters,
              strayLoadParameters=aimsData.strayLoadParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              Lm=aimsData.Lm,
              Lrsigma=aimsData.Lrsigma,
              Lrzero=aimsData.Lrzero,
              Rr=aimsData.Rr,
              TrRef=aimsData.TrRef,
              alpha20r(displayUnit="1/K") = aimsData.alpha20r,
              useTurnsRatio=aimsData.useTurnsRatio,
              VsNominal=aimsData.VsNominal,
              VrLockedRotor=aimsData.VrLockedRotor,
              rotorCoreParameters=aimsData.rotorCoreParameters,
              TurnsRatio=aimsData.turnsRatio,
              TsOperational=293.15,
              TrOperational=293.15) annotation (Placement(transformation(extent={{-10,
                      -30},{10,-10}}, rotation=0)));
            Modelica.Electrical.Machines.BasicMachines.AsynchronousInductionMachines.AIM_SlipRing
              aimsE(
              p=aimsData.p,
              fsNominal=aimsData.fsNominal,
              Rs=aimsData.Rs,
              TsRef=aimsData.TsRef,
              alpha20s(displayUnit="1/K") = aimsData.alpha20s,
              Lszero=aimsData.Lszero,
              Lssigma=aimsData.Lssigma,
              Jr=aimsData.Jr,
              Js=aimsData.Js,
              frictionParameters=aimsData.frictionParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              statorCoreParameters=aimsData.statorCoreParameters,
              strayLoadParameters=aimsData.strayLoadParameters,
              Lm=aimsData.Lm,
              Lrsigma=aimsData.Lrsigma,
              Lrzero=aimsData.Lrzero,
              Rr=aimsData.Rr,
              TrRef=aimsData.TrRef,
              alpha20r(displayUnit="1/K") = aimsData.alpha20r,
              useTurnsRatio=aimsData.useTurnsRatio,
              VsNominal=aimsData.VsNominal,
              VrLockedRotor=aimsData.VrLockedRotor,
              rotorCoreParameters=aimsData.rotorCoreParameters,
              TsOperational=566.3,
              turnsRatio=aimsData.turnsRatio,
              TrOperational=566.3) annotation (Placement(transformation(extent={{-10,
                      -90},{10,-70}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.SwitchedRheostat rheostatM(
              RStart=RStart,
              tStart=tRheostat,
              m=m) annotation (Placement(transformation(extent={{-40,-30},{-20,-10}},
                    rotation=0)));
            Modelica.Electrical.Machines.Utilities.SwitchedRheostat rheostatE(
              RStart=RStart,
              tStart=tRheostat,
              m=m) annotation (Placement(transformation(extent={{-40,-90},{-20,-70}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaM(J=J_Load)
              annotation (Placement(transformation(extent={{50,-30},{70,-10}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaE(J=J_Load)
              annotation (Placement(transformation(extent={{50,-90},{70,-70}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
              quadraticLoadTorqueM(
              tau_nominal=-T_Load,
              TorqueDirection=false,
              useSupport=false,
              w_nominal=w_Load) annotation (Placement(transformation(extent={{100,-30},
                      {80,-10}},rotation=0)));
            Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
              quadraticLoadTorqueE(
              tau_nominal=-T_Load,
              TorqueDirection=false,
              useSupport=false,
              w_nominal=w_Load) annotation (Placement(transformation(extent={{100,-90},
                      {80,-70}},rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.AIM_SlipRingData
              aimsData
              annotation (Placement(transformation(extent={{-60,-100},{-40,-80}})));
          initial equation
            aimsE.is = zeros(3);
            aimsE.ir = zeros(3);
            aimsM.is = zeros(3);
            aimsM.ir = zeros(3);
          equation
            connect(star.pin_n, ground.p)
              annotation (Line(points={{-70,90},{-80,90}}, color={0,0,255}));
            connect(sineVoltage.plug_n, star.plug_p) annotation (Line(points={{-40,
                    90},{-40,90},{-50,90}}, color={0,0,255}));
            connect(loadInertiaE.flange_b, quadraticLoadTorqueE.flange)
              annotation (Line(points={{70,-80},{80,-80}}, color={0,0,0}));
            connect(aimsE.flange, loadInertiaE.flange_a)
              annotation (Line(points={{10,-80},{50,-80}}, color={0,0,0}));
            connect(booleanStep.y, idealCloser.control)
              annotation (Line(points={{-39,60},{-7,60}}, color={255,0,255}));
            connect(terminalBoxE.plug_sn, aimsE.plug_sn)
              annotation (Line(points={{-6,-70},{-6,-70}}, color={0,0,255}));
            connect(terminalBoxE.plug_sp, aimsE.plug_sp)
              annotation (Line(points={{6,-70},{6,-70}}, color={0,0,255}));
            connect(rheostatE.plug_p, aimsE.plug_rp) annotation (Line(points={{-20,
                    -74},{-18,-74},{-10,-74}}, color={0,0,255}));
            connect(rheostatE.plug_n, aimsE.plug_rn) annotation (Line(points={{-20,
                    -86},{-18,-86},{-10,-86}}, color={0,0,255}));
            connect(loadInertiaM.flange_b, quadraticLoadTorqueM.flange) annotation (
               Line(points={{70,-20},{70,-20},{80,-20}}, color={0,0,0}));
            connect(aimsM.flange, loadInertiaM.flange_a) annotation (Line(points={{
                    10,-20},{10,-20},{50,-20}}, color={0,0,0}));
            connect(terminalBoxM.plug_sp, aimsM.plug_sp)
              annotation (Line(points={{6,-10},{6,-10}}, color={0,0,255}));
            connect(terminalBoxM.plug_sn, aimsM.plug_sn)
              annotation (Line(points={{-6,-10},{-6,-10}}, color={0,0,255}));
            connect(currentRMSsensorM.plug_n, terminalBoxM.plugSupply) annotation (
                Line(
                points={{0,10},{0,5.5},{0,5.5},{0,1},{0,1},{0,-8}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(rheostatM.plug_p, aimsM.plug_rp) annotation (Line(
                points={{-20,-14},{-10,-14}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(rheostatM.plug_n, aimsM.plug_rn) annotation (Line(
                points={{-20,-26},{-10,-26}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensorE.plug_n, terminalBoxE.plugSupply) annotation (
                Line(
                points={{-60,10},{-60,-60},{0,-60},{0,-68}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(idealCloser.plug_n, currentRMSsensorM.plug_p) annotation (Line(
                points={{0,50},{0,45},{9.992e-16,45},{9.992e-16,40},{0,40},{0,30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensorE.plug_p, idealCloser.plug_n) annotation (Line(
                points={{-60,30},{0,30},{0,50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(idealCloser.plug_p, sineVoltage.plug_p) annotation (Line(
                points={{0,70},{0,90},{-20,90}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (experiment(
                StopTime=1.5,
                Interval=0.001,
                Tolerance=1e-05), Documentation(info="<HTML>
<h4>Starting of an asynchronous induction machine with slipring rotor resistance starting</h4>
<p>
At start time <code>tOn</code> three phase voltage is supplied to the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SlipRing\">asynchronous induction machine with sliprings</a>.
The machine starts from standstill, accelerating inertias against load torque quadratic dependent on speed,
using a starting resistance. At time tRheostat external rotor resistance is shortened, finally reaching nominal speed.</p>

<p>
Simulate for 1.5 seconds and plot (versus time):
</p>

<ul>
<li><code>currentRMSsensorM|E.I</code>: equivalent RMS stator current</li>
<li><code>aimsM/E.wMechanical</code>: machine speed</li>
<li><code>aimsM|E.tauElectrical</code>: machine torque</li>
</ul>
</HTML>"));
          end AIMS_Start;

          model AIMS_Start_MultiPhase "Starting of multi phase asynchronous induction machine with slip rings"
            import Modelica;
            import Modelica_AddOn;
            extends Modelica.Icons.Example;
            constant Integer m3=3 "Number of stator phases of threephase system";
            parameter Integer m=5 "Number of stator phases";
            parameter Integer mr=5 "Number of rotor phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.Time tOn=0.1 "Start time of machine";
            parameter Modelica.SIunits.Resistance RStart=0.16/aimsData.turnsRatio^2 "Starting resistance";
            parameter Modelica.SIunits.Time tRheostat=1.0 "Time of shortening the rheostat";
            parameter Modelica.SIunits.Torque T_Load=161.4 "Nominal load torque";
            parameter Modelica.SIunits.AngularVelocity w_Load(displayUnit="1/min")=
                 Modelica.SIunits.Conversions.from_rpm(1440.45) "Nominal load speed";
            parameter Modelica.SIunits.Inertia J_Load=0.29 "Load inertia";
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(m=m,
                terminalConnection="Y") annotation (Placement(transformation(extent=
                     {{20,50},{40,70}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBox3(
                terminalConnection="Y", m=m3) annotation (Placement(transformation(
                    extent={{20,-50},{40,-30}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SlipRing
              aimsM(
              Jr=aimsData.Jr,
              Js=aimsData.Js,
              p=aimsData.p,
              fsNominal=aimsData.fsNominal,
              TsRef=aimsData.TsRef,
              alpha20s(displayUnit="1/K") = aimsData.alpha20s,
              frictionParameters=aimsData.frictionParameters,
              statorCoreParameters=aimsData.statorCoreParameters,
              strayLoadParameters=aimsData.strayLoadParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              TrRef=aimsData.TrRef,
              alpha20r(displayUnit="1/K") = aimsData.alpha20r,
              useTurnsRatio=aimsData.useTurnsRatio,
              VsNominal=aimsData.VsNominal,
              VrLockedRotor=aimsData.VrLockedRotor,
              rotorCoreParameters=aimsData.rotorCoreParameters,
              TurnsRatio=aimsData.turnsRatio,
              mr=mr,
              m=m,
              TsOperational=293.15,
              Rs=aimsData.Rs*m/3,
              Lssigma=aimsData.Lssigma*m/3,
              Lszero=aimsData.Lszero*m/3,
              Lm=aimsData.Lm*m/3,
              Lrsigma=aimsData.Lrsigma*mr/3,
              Lrzero=aimsData.Lrzero*mr/3,
              Rr=aimsData.Rr*mr/3,
              TrOperational=293.15) annotation (Placement(transformation(extent={{
                      20,30},{40,50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SlipRing
              aims3(
              p=aimsData.p,
              fsNominal=aimsData.fsNominal,
              Rs=aimsData.Rs,
              TsRef=aimsData.TsRef,
              alpha20s(displayUnit="1/K") = aimsData.alpha20s,
              Lszero=aimsData.Lszero,
              Lssigma=aimsData.Lssigma,
              Jr=aimsData.Jr,
              Js=aimsData.Js,
              frictionParameters=aimsData.frictionParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              statorCoreParameters=aimsData.statorCoreParameters,
              strayLoadParameters=aimsData.strayLoadParameters,
              Lm=aimsData.Lm,
              Lrsigma=aimsData.Lrsigma,
              Lrzero=aimsData.Lrzero,
              Rr=aimsData.Rr,
              TrRef=aimsData.TrRef,
              alpha20r(displayUnit="1/K") = aimsData.alpha20r,
              useTurnsRatio=aimsData.useTurnsRatio,
              VsNominal=aimsData.VsNominal,
              VrLockedRotor=aimsData.VrLockedRotor,
              rotorCoreParameters=aimsData.rotorCoreParameters,
              m=m3,
              TsOperational=566.3,
              TrOperational=566.3,
              TurnsRatio=aimsData.turnsRatio) annotation (Placement(transformation(
                    extent={{20,-70},{40,-50}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.SwitchedRheostat rheostatM(
              tStart=tRheostat,
              m=mr,
              RStart=RStart*mr/m3) annotation (Placement(transformation(extent={{-10,
                      30},{10,50}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.SwitchedRheostat rheostat3(
              RStart=RStart,
              tStart=tRheostat,
              m=m3) annotation (Placement(transformation(extent={{-10,-70},{10,-50}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaM(J=J_Load)
              annotation (Placement(transformation(extent={{50,30},{70,50}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertia3(J=J_Load)
              annotation (Placement(transformation(extent={{50,-70},{70,-50}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
              quadraticLoadTorqueM(
              tau_nominal=-T_Load,
              TorqueDirection=false,
              useSupport=false,
              w_nominal=w_Load) annotation (Placement(transformation(extent={{100,
                      30},{80,50}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
              quadraticLoadTorque3(
              tau_nominal=-T_Load,
              TorqueDirection=false,
              useSupport=false,
              w_nominal=w_Load) annotation (Placement(transformation(extent={{100,-70},
                      {80,-50}},rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.AIM_SlipRingData
              aimsData annotation (Placement(transformation(extent={{-100,-100},{-80,
                      -80}})));
            Modelica.Electrical.Analog.Basic.Ground groundM annotation (Placement(
                  transformation(
                  origin={-90,50},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Basic.Star starM(final m=m) annotation (
                Placement(transformation(extent={{-70,62},{-90,82}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltageM(
              final m=m,
              freqHz=fill(fNominal, m),
              V=fill(sqrt(2.0)*VsNominal, m),
              phase=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                  m)) annotation (Placement(transformation(
                  origin={-50,72},
                  extent={{10,-10},{-10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Ideal.IdealClosingSwitch idealCloserM(
              final m=m,
              Ron=fill(1e-5*m/3, m),
              Goff=fill(1e-5*m3/m, m)) annotation (Placement(transformation(
                  origin={-20,72},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Blocks.Sources.BooleanStep booleanStepM[m](each startTime=tOn,
                each startValue=false) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-40,40})));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM(m=m) annotation (Placement(transformation(
                  origin={10,72},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground ground3 annotation (Placement(
                  transformation(
                  origin={-90,-52},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Basic.Star star3(final m=m3) annotation (
               Placement(transformation(extent={{-70,-40},{-90,-20}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage3(
              final m=m3,
              V=fill(sqrt(2.0)*VsNominal, m3),
              phase=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                  m3),
              freqHz=fill(fNominal, m3)) annotation (Placement(transformation(
                  origin={-50,-30},
                  extent={{10,-10},{-10,10}},
                  rotation=0)));
            Modelica.Electrical.MultiPhase.Ideal.IdealClosingSwitch idealCloser3(
              final m=m3,
              Ron=fill(1e-5, m3),
              Goff=fill(1e-5, m3)) annotation (Placement(transformation(
                  origin={-20,-30},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Blocks.Sources.BooleanStep booleanStep3[m3](each startTime=tOn,
                each startValue=false) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-40,-60})));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensor3(m=3) annotation (Placement(transformation(
                  origin={10,-30},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Blocks.Math.Gain gain(k=(m/m3))
              annotation (Placement(transformation(extent={{40,80},{60,100}})));
            Modelica.Blocks.Math.Feedback feedback
              annotation (Placement(transformation(extent={{80,10},{100,-10}})));
          initial equation
            aims3.is[1:2] = zeros(2);
            aims3.ir[1:3] = zeros(3);
            aimsM.is[1:2] = zeros(2);
            aimsM.ir[1:mr - 2] = zeros(mr - 2);
          equation
            connect(loadInertia3.flange_b, quadraticLoadTorque3.flange) annotation (
               Line(points={{70,-60},{76,-60},{80,-60}}, color={0,0,0}));
            connect(aims3.flange, loadInertia3.flange_a) annotation (Line(points={{
                    40,-60},{40,-60},{50,-60}}, color={0,0,0}));
            connect(terminalBox3.plug_sn, aims3.plug_sn)
              annotation (Line(points={{24,-50},{24,-50}}, color={0,0,255}));
            connect(terminalBox3.plug_sp, aims3.plug_sp)
              annotation (Line(points={{36,-50},{36,-50}}, color={0,0,255}));
            connect(rheostat3.plug_p, aims3.plug_rp) annotation (Line(points={{10,-54},
                    {10,-54},{20,-54}}, color={0,0,255}));
            connect(rheostat3.plug_n, aims3.plug_rn) annotation (Line(points={{10,-66},
                    {10,-66},{20,-66}}, color={0,0,255}));
            connect(loadInertiaM.flange_b, quadraticLoadTorqueM.flange)
              annotation (Line(points={{70,40},{70,40},{80,40}}, color={0,0,0}));
            connect(aimsM.flange, loadInertiaM.flange_a)
              annotation (Line(points={{40,40},{40,40},{50,40}}, color={0,0,0}));
            connect(terminalBoxM.plug_sp, aimsM.plug_sp)
              annotation (Line(points={{36,50},{36,50}}, color={0,0,255}));
            connect(terminalBoxM.plug_sn, aimsM.plug_sn)
              annotation (Line(points={{24,50},{24,50}}, color={0,0,255}));
            connect(rheostatM.plug_p, aimsM.plug_rp) annotation (Line(
                points={{10,46},{20,46}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(rheostatM.plug_n, aimsM.plug_rn) annotation (Line(
                points={{10,34},{20,34}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(starM.pin_n, groundM.p) annotation (Line(points={{-90,72},{-90,
                    72},{-90,60}}, color={0,0,255}));
            connect(sineVoltageM.plug_n, starM.plug_p) annotation (Line(points={{-60,
                    72},{-60,72},{-70,72}}, color={0,0,255}));
            connect(sineVoltageM.plug_p, idealCloserM.plug_p) annotation (Line(
                points={{-40,72},{-30,72}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(idealCloserM.plug_n, currentRMSsensorM.plug_p) annotation (Line(
                points={{-10,72},{0,72}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(booleanStepM.y, idealCloserM.control) annotation (Line(
                points={{-29,40},{-20,40},{-20,65}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(star3.pin_n, ground3.p)
              annotation (Line(points={{-90,-30},{-90,-42}}, color={0,0,255}));
            connect(sineVoltage3.plug_n, star3.plug_p) annotation (Line(points={{-60,
                    -30},{-60,-30},{-70,-30}}, color={0,0,255}));
            connect(sineVoltage3.plug_p, idealCloser3.plug_p) annotation (Line(
                points={{-40,-30},{-30,-30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(idealCloser3.plug_n, currentRMSsensor3.plug_p) annotation (Line(
                points={{-10,-30},{0,-30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(booleanStep3.y, idealCloser3.control) annotation (Line(
                points={{-29,-60},{-20,-60},{-20,-37}},
                color={255,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensorM.I, gain.u) annotation (Line(
                points={{10,82},{10,90},{38,90}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(currentRMSsensor3.plug_n, terminalBox3.plugSupply) annotation (
                Line(
                points={{20,-30},{30,-30},{30,-48}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensorM.plug_n, terminalBoxM.plugSupply) annotation (
                Line(
                points={{20,72},{30,72},{30,52}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensor3.I, feedback.u1) annotation (Line(
                points={{10,-19},{10,0},{82,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(feedback.u2, gain.y) annotation (Line(
                points={{90,8},{90,16},{100,16},{100,90},{61,90}},
                color={0,0,127},
                smooth=Smooth.None));
            annotation (
              experiment(
                StopTime=1.5,
                Interval=0.001,
                Tolerance=1e-05),
              Documentation(info="<HTML>
<h4>Starting of an asynchronous induction machine with slipring rotor resistance starting</h4>
<p>
At start time <code>tOn</code> voltages are supplied to the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SlipRing\">asynchronous induction machines with sliprings</a>.
The two machine start from standstill, accelerating inertias against load torque quadratic dependent on speed,
using a starting resistance. At time tRheostat external rotor resistance is shortened, finally reaching nominal speed. Two equivalent machines with different numbers of phases are compared and their equal behavior is demonstrated.</p>

<p>
Simulate for 1.5 seconds and plot (versus time):
</p>

<ul>
<li><code>aimcM|M3.tauElectrical</code>: machine torque</li>
<li><code>aimsM|M3.wMechanical</code>: machine speed</li>
<li><code>feedback.y</code>: zero since difference of three phase current phasor and scaled multi phase current phasor are equal</li>
</ul>

</HTML>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics={Rectangle(
                          extent={{-100,100},{100,20}},
                          lineColor={0,0,255},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash),Rectangle(
                          extent={{-100,-10},{100,-80}},
                          lineColor={0,0,255},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash),Text(
                          extent={{40,68},{100,60}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textString="%m phase machine
",                        textStyle={TextStyle.Bold}),Text(
                          extent={{40,-32},{100,-40}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textString="3 phase machine
",                        textStyle={TextStyle.Bold})}));
          end AIMS_Start_MultiPhase;

          model SMPM_Inverter "Starting of permanent magnet synchronous machine with inverter"
            extends Modelica.Icons.Example;
            constant Integer m=3 "Number of phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fsNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.Frequency fKnee=50 "Knee frequency of V/f curve";
            parameter Modelica.SIunits.Time tRamp=1 "Frequency ramp";
            parameter Modelica.SIunits.Torque T_Load=181.4 "Nominal load torque";
            parameter Modelica.SIunits.Time tStep=1.2 "Time of load torque step";
            parameter Modelica.SIunits.Inertia J_Load=0.29 "Load inertia";
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={-90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                Placement(transformation(extent={{-50,80},{-70,100}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SignalVoltage signalVoltage(
                final m=m) annotation (Placement(transformation(
                  origin={0,60},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Modelica.Blocks.Sources.Ramp ramp(height=fKnee, duration=tRamp)
              annotation (Placement(transformation(extent={{-80,50},{-60,70}},
                    rotation=0)));
            Modelica.Electrical.Machines.Utilities.VfController vfController(
              final m=m,
              VNominal=VsNominal,
              fNominal=fsNominal,
              BasePhase=+Modelica.Constants.pi/2) annotation (Placement(
                  transformation(extent={{-40,50},{-20,70}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM annotation (Placement(transformation(
                  origin={0,30},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorE annotation (Placement(transformation(
                  origin={-60,30},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(
                terminalConnection="Y") annotation (Placement(transformation(extent=
                     {{-10,-10},{10,10}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxE(
                terminalConnection="Y") annotation (Placement(transformation(extent=
                     {{-10,-70},{10,-50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_PermanentMagnet
              smpmM(
              Jr=smpmData.Jr,
              Js=smpmData.Js,
              p=smpmData.p,
              fsNominal=smpmData.fsNominal,
              Rs=smpmData.Rs,
              TsRef=smpmData.TsRef,
              alpha20s(displayUnit="1/K") = smpmData.alpha20s,
              Lssigma=smpmData.Lssigma,
              Lszero=smpmData.Lszero,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              Lmd=smpmData.Lmd,
              Lmq=smpmData.Lmq,
              useDamperCage=smpmData.useDamperCage,
              Lrsigmad=smpmData.Lrsigmad,
              Lrsigmaq=smpmData.Lrsigmaq,
              Rrd=smpmData.Rrd,
              Rrq=smpmData.Rrq,
              TrRef=smpmData.TrRef,
              alpha20r(displayUnit="1/K") = smpmData.alpha20r,
              VsOpenCircuit=smpmData.VsOpenCircuit,
              frictionParameters=smpmData.frictionParameters,
              statorCoreParameters=smpmData.statorCoreParameters,
              strayLoadParameters=smpmData.strayLoadParameters,
              permanentMagnetLossParameters=smpmData.permanentMagnetLossParameters,
              TsOperational=293.15,
              TrOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,-30},
                      {10,-10}}, rotation=0)));
            Modelica.Electrical.Machines.BasicMachines.SynchronousInductionMachines.SM_PermanentMagnet
              smpmE(
              p=smpmData.p,
              fsNominal=smpmData.fsNominal,
              Rs=smpmData.Rs,
              TsRef=smpmData.TsRef,
              alpha20s(displayUnit="1/K") = smpmData.alpha20s,
              Lszero=smpmData.Lszero,
              Lssigma=smpmData.Lssigma,
              Jr=smpmData.Jr,
              Js=smpmData.Js,
              frictionParameters=smpmData.frictionParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              statorCoreParameters=smpmData.statorCoreParameters,
              strayLoadParameters=smpmData.strayLoadParameters,
              VsOpenCircuit=smpmData.VsOpenCircuit,
              Lmd=smpmData.Lmd,
              Lmq=smpmData.Lmq,
              useDamperCage=smpmData.useDamperCage,
              Lrsigmad=smpmData.Lrsigmad,
              Lrsigmaq=smpmData.Lrsigmaq,
              Rrd=smpmData.Rrd,
              Rrq=smpmData.Rrq,
              TrRef=smpmData.TrRef,
              alpha20r(displayUnit="1/K") = smpmData.alpha20r,
              permanentMagnetLossParameters=smpmData.permanentMagnetLossParameters,
              TsOperational=293.15,
              ir(fixed=true),
              TrOperational=293.15) annotation (Placement(transformation(extent={{-10,
                      -90},{10,-70}}, rotation=0)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngleM(
                p=smpmM.p) annotation (Placement(transformation(
                  origin={30,-20},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngleE(
                p=smpmE.p) annotation (Placement(transformation(
                  origin={30,-80},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaM(J=J_Load)
              annotation (Placement(transformation(extent={{50,-30},{70,-10}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaE(J=J_Load)
              annotation (Placement(transformation(extent={{50,-90},{70,-70}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStepM(
              startTime=tStep,
              stepTorque=-T_Load,
              useSupport=false,
              offsetTorque=0) annotation (Placement(transformation(extent={{100,-30},
                      {80,-10}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStepE(
              startTime=tStep,
              stepTorque=-T_Load,
              useSupport=false,
              offsetTorque=0) annotation (Placement(transformation(extent={{100,-90},
                      {80,-70}}, rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.SM_PermanentMagnetData
              smpmData
              annotation (Placement(transformation(extent={{-40,-100},{-20,-80}})));
          initial equation
            smpmE.is[1:2] = zeros(2);
            smpmM.is[1:2] = zeros(2);
            //conditional damper cage currents are defined as fixed start values
          equation
            connect(signalVoltage.plug_n, star.plug_p)
              annotation (Line(points={{0,70},{0,90},{-50,90}}, color={0,0,255}));
            connect(star.pin_n, ground.p)
              annotation (Line(points={{-70,90},{-80,90}}, color={0,0,255}));
            connect(ramp.y, vfController.u)
              annotation (Line(points={{-59,60},{-42,60}}, color={0,0,255}));
            connect(vfController.y, signalVoltage.v)
              annotation (Line(points={{-19,60},{-7,60}}, color={0,0,255}));
            connect(loadInertiaM.flange_b, torqueStepM.flange)
              annotation (Line(points={{70,-20},{80,-20}}, color={0,0,0}));
            connect(signalVoltage.plug_p, currentRMSsensorM.plug_p)
              annotation (Line(points={{0,50},{0,50},{0,40}}, color={0,0,255}));
            connect(rotorAngleM.plug_n, smpmM.plug_sn) annotation (Line(points={{36,
                    -10},{36,0},{-6,0},{-6,-10}}, color={0,0,255}));
            connect(rotorAngleM.plug_p, smpmM.plug_sp) annotation (Line(points={{24,
                    -10},{15,-10},{6,-10}}, color={0,0,255}));
            connect(rotorAngleM.flange, smpmM.flange)
              annotation (Line(points={{20,-20},{10,-20}}, color={0,0,0}));
            connect(smpmM.flange, loadInertiaM.flange_a)
              annotation (Line(points={{10,-20},{50,-20}}, color={0,0,0}));
            connect(terminalBoxM.plug_sn, smpmM.plug_sn)
              annotation (Line(points={{-6,-10},{-6,-10}}, color={0,0,255}));
            connect(terminalBoxM.plug_sp, smpmM.plug_sp)
              annotation (Line(points={{6,-10},{6,-10}}, color={0,0,255}));
            connect(terminalBoxM.plugSupply, currentRMSsensorM.plug_n) annotation (
                Line(points={{0,-8},{0,-1},{0,-1},{0,6},{0,6},{0,20}}, color={0,0,
                    255}));
            connect(loadInertiaE.flange_b, torqueStepE.flange)
              annotation (Line(points={{70,-80},{80,-80}}, color={0,0,0}));
            connect(rotorAngleE.plug_n, smpmE.plug_sn) annotation (Line(points={{36,
                    -70},{36,-60},{-6,-60},{-6,-70}}, color={0,0,255}));
            connect(rotorAngleE.plug_p, smpmE.plug_sp)
              annotation (Line(points={{24,-70},{6,-70}}, color={0,0,255}));
            connect(rotorAngleE.flange, smpmE.flange)
              annotation (Line(points={{20,-80},{10,-80}}, color={0,0,0}));
            connect(smpmE.flange, loadInertiaE.flange_a)
              annotation (Line(points={{10,-80},{50,-80}}, color={0,0,0}));
            connect(terminalBoxE.plug_sn, smpmE.plug_sn)
              annotation (Line(points={{-6,-70},{-6,-70}}, color={0,0,255}));
            connect(terminalBoxE.plug_sp, smpmE.plug_sp)
              annotation (Line(points={{6,-70},{6,-70}}, color={0,0,255}));
            connect(currentRMSsensorE.plug_n, terminalBoxE.plugSupply) annotation (
                Line(points={{-60,20},{-60,-50},{0,-50},{0,-68}}, color={0,0,255}));
            connect(currentRMSsensorE.plug_p, signalVoltage.plug_p) annotation (
                Line(
                points={{-60,40},{0,40},{0,50}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (experiment(
                StopTime=1.5,
                Interval=0.0005,
                Tolerance=1e-005), Documentation(info="<HTML>
<h4>Permanent magnet synchronous induction machine fed by an ideal inverter</h4>
<p>

An ideal frequency inverter is modeled by using a
<a href=\"modelica://Modelica.Electrical.Machines.Utilities.VfController\">VfController</a>
and a three-phase <a href=\"modelica://Modelica.Electrical.MultiPhase.Sources.SignalVoltage\">SignalVoltage</a>.
Frequency is raised by a ramp, causing the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_PermanentMagnet\">permanent magnet synchronous induction machine</a> to start,
and accelerate the inertias.</p>

<p>At time tStep a load step is applied. Simulate for 1.5 seconds and plot (versus time):</p>

<ul>
<li><code>currentRMSsensorM|E.I</code>: equivalent RMS stator current</li>
<li><code>smpmM|E.wMechanical</code>: machine speed</li>
<li><code>smpmM|E.tauElectrical</code>: machine torque</li>
<li><code>rotorAnglepmsmM|E.rotorDisplacementAngle</code>: rotor displacement angle</li>
</ul>
</HTML>"));
          end SMPM_Inverter;

          model SMPM_Inverter_MultiPhase "Starting of multi phase permanent magnet synchronous machine with inverter"
            import Modelica;
            import Modelica_AddOn;
            extends Modelica.Icons.Example;
            constant Integer m3=3 "Number of stator phases of threephase system";
            parameter Integer m=5 "Number of stator phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fsNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.Frequency fKnee=50 "Knee frequency of V/f curve";
            parameter Modelica.SIunits.Time tRamp=1 "Frequency ramp";
            parameter Modelica.SIunits.Torque T_Load=181.4 "Nominal load torque";
            parameter Modelica.SIunits.Time tStep=1.2 "Time of load torque step";
            parameter Modelica.SIunits.Inertia J_Load=0.29 "Load inertia";
            Modelica.Electrical.Analog.Basic.Ground ground3 annotation (Placement(
                  transformation(
                  origin={-90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Star star3(final m=m3) annotation (
               Placement(transformation(extent={{-50,80},{-70,100}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SignalVoltage signalVoltage3(
                final m=m3) annotation (Placement(transformation(
                  origin={0,70},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Modelica.Blocks.Sources.Ramp ramp(height=fKnee, duration=tRamp)
              annotation (Placement(transformation(extent={{-80,60},{-60,80}},
                    rotation=0)));
            Modelica.Electrical.Machines.Utilities.VfController vfController3(
              VNominal=VsNominal,
              fNominal=fsNominal,
              BasePhase=+Modelica.Constants.pi/2,
              final m=m3,
              orientation=-
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m3))
              annotation (Placement(transformation(extent={{-40,60},{-20,80}},
                    rotation=0)));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM(m=m) annotation (Placement(transformation(
                  origin={30,20},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensor3 annotation (Placement(transformation(
                  origin={-80,0},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(
                terminalConnection="Y", m=m) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBox3(
                terminalConnection="Y", m=m3) annotation (Placement(transformation(
                    extent={{-10,-70},{10,-50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_PermanentMagnet
              smpmM(
              Jr=smpmData.Jr,
              Js=smpmData.Js,
              p=smpmData.p,
              fsNominal=smpmData.fsNominal,
              TsRef=smpmData.TsRef,
              alpha20s(displayUnit="1/K") = smpmData.alpha20s,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              useDamperCage=smpmData.useDamperCage,
              Lrsigmad=smpmData.Lrsigmad,
              Lrsigmaq=smpmData.Lrsigmaq,
              Rrd=smpmData.Rrd,
              Rrq=smpmData.Rrq,
              TrRef=smpmData.TrRef,
              alpha20r(displayUnit="1/K") = smpmData.alpha20r,
              VsOpenCircuit=smpmData.VsOpenCircuit,
              frictionParameters=smpmData.frictionParameters,
              statorCoreParameters=smpmData.statorCoreParameters,
              strayLoadParameters=smpmData.strayLoadParameters,
              permanentMagnetLossParameters=smpmData.permanentMagnetLossParameters,
              m=m,
              Rs=smpmData.Rs*m/3,
              Lssigma=smpmData.Lssigma*m/3,
              Lszero=smpmData.Lszero*m/3,
              Lmd=smpmData.Lmd*m/3,
              Lmq=smpmData.Lmq*m/3,
              TsOperational=293.15,
              TrOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,-30},
                      {10,-10}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_PermanentMagnet
              smpm3(
              p=smpmData.p,
              fsNominal=smpmData.fsNominal,
              Rs=smpmData.Rs,
              TsRef=smpmData.TsRef,
              alpha20s(displayUnit="1/K") = smpmData.alpha20s,
              Lszero=smpmData.Lszero,
              Lssigma=smpmData.Lssigma,
              Jr=smpmData.Jr,
              Js=smpmData.Js,
              frictionParameters=smpmData.frictionParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              statorCoreParameters=smpmData.statorCoreParameters,
              strayLoadParameters=smpmData.strayLoadParameters,
              VsOpenCircuit=smpmData.VsOpenCircuit,
              Lmd=smpmData.Lmd,
              Lmq=smpmData.Lmq,
              useDamperCage=smpmData.useDamperCage,
              Lrsigmad=smpmData.Lrsigmad,
              Lrsigmaq=smpmData.Lrsigmaq,
              Rrd=smpmData.Rrd,
              Rrq=smpmData.Rrq,
              TrRef=smpmData.TrRef,
              alpha20r(displayUnit="1/K") = smpmData.alpha20r,
              permanentMagnetLossParameters=smpmData.permanentMagnetLossParameters,
              m=m3,
              TsOperational=293.15,
              TrOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,-90},
                      {10,-70}}, rotation=0)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngle3(
               p=smpm3.p) annotation (Placement(transformation(
                  origin={30,-80},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaM(J=J_Load)
              annotation (Placement(transformation(extent={{50,-30},{70,-10}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertia3(J=J_Load)
              annotation (Placement(transformation(extent={{50,-90},{70,-70}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStepM(
              startTime=tStep,
              stepTorque=-T_Load,
              useSupport=false,
              offsetTorque=0) annotation (Placement(transformation(extent={{100,-30},
                      {80,-10}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStep3(
              startTime=tStep,
              stepTorque=-T_Load,
              useSupport=false,
              offsetTorque=0) annotation (Placement(transformation(extent={{100,-90},
                      {80,-70}}, rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.SM_PermanentMagnetData
              smpmData annotation (Placement(transformation(extent={{-100,-100},{-80,
                      -80}})));
            Modelica.Electrical.MultiPhase.Sources.SignalVoltage signalVoltageM(
                final m=m) annotation (Placement(transformation(
                  origin={30,50},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Star starM(final m=m) annotation (
                Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=180,
                  origin={60,90})));
            Modelica.Electrical.Analog.Basic.Ground groundM annotation (Placement(
                  transformation(
                  origin={90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.Machines.Utilities.VfController vfController(
              VNominal=VsNominal,
              fNominal=fsNominal,
              BasePhase=+Modelica.Constants.pi/2,
              final m=m,
              orientation=-
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m))
              annotation (Placement(transformation(
                  extent={{10,10},{-10,-10}},
                  rotation=180,
                  origin={-30,50})));
            Modelica.Blocks.Math.Feedback feedback annotation (Placement(
                  transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=0,
                  origin={-50,0})));
            Modelica.Blocks.Math.Gain gain(k=(m/m3))
              annotation (Placement(transformation(extent={{-20,10},{-40,30}})));
          initial equation
            smpm3.is[1:2] = zeros(2);
            smpmM.is[1:2] = zeros(2);
            //conditional damper cage currents are defined as fixed start values
          equation
            connect(signalVoltage3.plug_n, star3.plug_p)
              annotation (Line(points={{0,80},{0,90},{-50,90}}, color={0,0,255}));
            connect(star3.pin_n, ground3.p)
              annotation (Line(points={{-70,90},{-80,90}}, color={0,0,255}));
            connect(ramp.y, vfController3.u)
              annotation (Line(points={{-59,70},{-42,70}}, color={0,0,255}));
            connect(vfController3.y, signalVoltage3.v)
              annotation (Line(points={{-19,70},{-7,70}}, color={0,0,255}));
            connect(loadInertiaM.flange_b, torqueStepM.flange)
              annotation (Line(points={{70,-20},{80,-20}}, color={0,0,0}));
            connect(smpmM.flange, loadInertiaM.flange_a)
              annotation (Line(points={{10,-20},{50,-20}}, color={0,0,0}));
            connect(terminalBoxM.plug_sn, smpmM.plug_sn)
              annotation (Line(points={{-6,-10},{-6,-10}}, color={0,0,255}));
            connect(terminalBoxM.plug_sp, smpmM.plug_sp)
              annotation (Line(points={{6,-10},{6,-10}}, color={0,0,255}));
            connect(terminalBoxM.plugSupply, currentRMSsensorM.plug_n) annotation (
                Line(points={{0,-8},{0,-1},{0,-1},{0,10},{30,10}}, color={0,0,255}));
            connect(loadInertia3.flange_b, torqueStep3.flange)
              annotation (Line(points={{70,-80},{80,-80}}, color={0,0,0}));
            connect(rotorAngle3.plug_n, smpm3.plug_sn) annotation (Line(points={{36,
                    -70},{36,-64},{-6,-64},{-6,-70}}, color={0,0,255}));
            connect(rotorAngle3.plug_p, smpm3.plug_sp)
              annotation (Line(points={{24,-70},{6,-70}}, color={0,0,255}));
            connect(rotorAngle3.flange, smpm3.flange)
              annotation (Line(points={{20,-80},{10,-80}}, color={0,0,0}));
            connect(smpm3.flange, loadInertia3.flange_a)
              annotation (Line(points={{10,-80},{50,-80}}, color={0,0,0}));
            connect(terminalBox3.plug_sn, smpm3.plug_sn)
              annotation (Line(points={{-6,-70},{-6,-70}}, color={0,0,255}));
            connect(terminalBox3.plug_sp, smpm3.plug_sp)
              annotation (Line(points={{6,-70},{6,-70}}, color={0,0,255}));
            connect(currentRMSsensor3.plug_n, terminalBox3.plugSupply) annotation (
                Line(points={{-80,-10},{-80,-60},{0,-60},{0,-68}}, color={0,0,255}));
            connect(signalVoltage3.plug_p, currentRMSsensor3.plug_p) annotation (
                Line(
                points={{0,60},{0,34},{-80,34},{-80,10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(signalVoltageM.plug_n, starM.plug_p) annotation (Line(
                points={{30,60},{30,90},{50,90}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(starM.pin_n, groundM.p) annotation (Line(
                points={{70,90},{80,90}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(vfController.y, signalVoltageM.v) annotation (Line(
                points={{-19,50},{23,50}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(vfController.u, ramp.y) annotation (Line(
                points={{-42,50},{-50,50},{-50,70},{-59,70}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(signalVoltageM.plug_p, currentRMSsensorM.plug_p) annotation (
                Line(
                points={{30,40},{30,30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensor3.I, feedback.u1) annotation (Line(
                points={{-69,0},{-64.5,0},{-64.5,0},{-58,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(gain.y, feedback.u2) annotation (Line(
                points={{-41,20},{-50,20},{-50,8}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(gain.u, currentRMSsensorM.I) annotation (Line(
                points={{-18,20},{20,20}},
                color={0,0,127},
                smooth=Smooth.None));
            annotation (
              experiment(
                StopTime=1.5,
                Interval=0.0005,
                Tolerance=1e-005),
              Documentation(info="<HTML>
<h4>Permanent magnet synchronous induction machine fed by an ideal inverter</h4>
<p>

An ideal frequency inverter is modeled by using
<a href=\"modelica://Modelica.Electrical.Machines.Utilities.VfController\">VfController</a>s
and <a href=\"modelica://Modelica.Electrical.MultiPhase.Sources.SignalVoltage\">SignalVoltages</a>s.
Frequency is raised by a ramp, causing the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_PermanentMagnet\">permanent magnet synchronous induction machines</a> to start,
and accelerate the inertias. Two equivalent machines with different numbers of phases are compared and their equal behavior is demonstrated.</p>

<p>At time tStep a load step is applied. Simulate for 1.5 seconds and plot (versus time):</p>

<ul>
<li><code>aimcM|M3.tauElectrical</code>: machine torque</li>
<li><code>aimsM|M3.wMechanical</code>: machine speed</li>
<li><code>feedback.y</code>: zero since difference of three phase current phasor and scaled multi phase current phasor are equal</li>
</ul>

</HTML>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics={Rectangle(
                          extent={{-20,0},{100,-40}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash),Rectangle(
                          extent={{-20,-60},{100,-100}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash),Text(
                          extent={{40,-54},{100,-62}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textStyle={TextStyle.Bold},
                          textString="3 phase machine
"),Text(                      extent={{40,-44},{100,-52}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textStyle={TextStyle.Bold},
                          textString="%m phase machine
")}));
          end SMPM_Inverter_MultiPhase;

          model SMEE_Generator "Electrical excited synchronous machine operating as generator"
            extends Modelica.Icons.Example;
            import Modelica.Constants.pi;
            constant Integer m=3 "Number of stator phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fsNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.AngularVelocity w=
                Modelica.SIunits.Conversions.from_rpm(1499) "Nominal speed";
            parameter Modelica.SIunits.Current Ie=19 "Excitation current";
            parameter Modelica.SIunits.Current Ie0=10 "Initial excitation current";
            parameter Modelica.SIunits.Angle gamma0(displayUnit="deg") = 0 "Initial rotor displacement angle";
            parameter Integer p=2 "Number of pole pairs";
            parameter Modelica.SIunits.Resistance Rs=0.03 "Warm stator resistance per phase";
            parameter Modelica.SIunits.Inductance Lssigma=0.1/(2*Modelica.Constants.pi
                *fsNominal) "Stator stray inductance per phase";
            parameter Modelica.SIunits.Inductance Lmd=1.5/(2*Modelica.Constants.pi*
                fsNominal) "Main field inductance in d-axis";
            parameter Modelica.SIunits.Inductance Lmq=1.5/(2*Modelica.Constants.pi*
                fsNominal) "Main field inductance in q-axis";
            parameter Modelica.SIunits.Inductance Lrsigmad=0.05/(2*Modelica.Constants.pi
                *fsNominal) "Damper stray inductance (equivalent three phase winding) d-axis";
            parameter Modelica.SIunits.Inductance Lrsigmaq=Lrsigmad "Damper stray inductance (equivalent three phase winding) q-axis";
            parameter Modelica.SIunits.Resistance Rrd=0.04 "Warm damper resistance (equivalent three phase winding) d-axis";
            parameter Modelica.SIunits.Resistance Rrq=Rrd "Warm damper resistance (equivalent three phase winding) q-axis";
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                Placement(transformation(extent={{-50,80},{-70,100}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={-90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage(
              final m=m,
              final V=fill(VsNominal*sqrt(2), m),
              final freqHz=fill(fsNominal, m)) annotation (Placement(transformation(
                    extent={{-20,80},{-40,100}}, rotation=0)));
            Modelica.Electrical.Machines.Sensors.ElectricalPowerSensor
              electricalPowerSensorM annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={0,30})));
            Modelica.Electrical.Machines.Sensors.ElectricalPowerSensor
              electricalPowerSensorE annotation (Placement(transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=270,
                  origin={-60,30})));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(
                terminalConnection="Y") annotation (Placement(transformation(extent=
                     {{-10,-10},{10,10}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxE(
                terminalConnection="Y") annotation (Placement(transformation(extent=
                     {{-10,-70},{10,-50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ElectricalExcited
              smeeM(
              phiMechanical(start=-(Modelica.Constants.pi + gamma0)/p, fixed=true),
              Jr=0.29,
              Js=0.29,
              p=2,
              fsNominal=smeeData.fsNominal,
              Rs=smeeData.Rs,
              TsRef=smeeData.TsRef,
              alpha20s(displayUnit="1/K") = smeeData.alpha20s,
              Lssigma=smeeData.Lssigma,
              Lmd=smeeData.Lmd,
              Lmq=smeeData.Lmq,
              useDamperCage=true,
              Lrsigmad=smeeData.Lrsigmad,
              Lrsigmaq=smeeData.Lrsigmaq,
              Rrd=smeeData.Rrd,
              Rrq=smeeData.Rrq,
              TrRef=smeeData.TrRef,
              alpha20r(displayUnit="1/K") = smeeData.alpha20r,
              VsNominal=smeeData.VsNominal,
              IeOpenCircuit=smeeData.IeOpenCircuit,
              Re=smeeData.Re,
              TeRef=smeeData.TeRef,
              alpha20e(displayUnit="1/K") = smeeData.alpha20e,
              sigmae=smeeData.sigmae,
              statorCoreParameters(VRef=100),
              strayLoadParameters(IRef=100),
              brushParameters(ILinear=0.01),
              TsOperational=293.15,
              TrOperational=293.15,
              TeOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,-30},
                      {10,-10}}, rotation=0)));
            Modelica.Electrical.Machines.BasicMachines.SynchronousInductionMachines.SM_ElectricalExcited
              smeeE(
              phiMechanical(start=-(Modelica.Constants.pi + gamma0)/p, fixed=true),
              p=2,
              fsNominal=smeeData.fsNominal,
              Rs=smeeData.Rs,
              TsRef=smeeData.TsRef,
              alpha20s(displayUnit="1/K") = smeeData.alpha20s,
              Lssigma=smeeData.Lssigma,
              Jr=0.29,
              Js=0.29,
              frictionParameters(PRef=0),
              statorCoreParameters(PRef=0, VRef=100),
              strayLoadParameters(PRef=0, IRef=100),
              Lmd=smeeData.Lmd,
              Lmq=smeeData.Lmq,
              useDamperCage=true,
              Lrsigmad=smeeData.Lrsigmad,
              Rrd=smeeData.Rrd,
              Rrq=smeeData.Rrq,
              alpha20r(displayUnit="1/K") = smeeData.alpha20r,
              VsNominal=smeeData.VsNominal,
              IeOpenCircuit=smeeData.IeOpenCircuit,
              Re=smeeData.Re,
              TeRef=smeeData.TeRef,
              alpha20e(displayUnit="1/K") = smeeData.alpha20e,
              sigmae=smeeData.sigmae,
              brushParameters(V=0, ILinear=0.01),
              Lrsigmaq=smeeData.Lrsigmaq,
              TrRef=smeeData.TrRef,
              TsOperational=293.15,
              ir(fixed=true),
              TrOperational=293.15,
              TeOperational=293.15) annotation (Placement(transformation(extent={{-10,
                      -90},{10,-70}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground groundM annotation (Placement(
                  transformation(
                  origin={-50,-30},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.Analog.Basic.Ground groundE annotation (Placement(
                  transformation(
                  origin={-50,-90},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.Analog.Sources.RampCurrent rampCurrentM(
              duration=0.1,
              I=Ie - Ie0,
              offset=Ie0) annotation (Placement(transformation(
                  origin={-30,-20},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.Analog.Sources.RampCurrent rampCurrentE(
              duration=0.1,
              I=Ie - Ie0,
              offset=Ie0) annotation (Placement(transformation(
                  origin={-30,-80},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngleM(
                p=p) annotation (Placement(transformation(
                  origin={30,-20},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngleE(
                p=p) annotation (Placement(transformation(
                  origin={30,-80},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.MechanicalPowerSensor
              mechanicalPowerSensorM annotation (Placement(transformation(extent={{
                      50,-30},{70,-10}}, rotation=0)));
            Modelica.Electrical.Machines.Sensors.MechanicalPowerSensor
              mechanicalPowerSensorE annotation (Placement(transformation(extent={{
                      50,-90},{70,-70}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.ConstantSpeed constantSpeedM(
                final w_fixed=w, useSupport=false) annotation (Placement(
                  transformation(extent={{100,-30},{80,-10}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.ConstantSpeed constantSpeedE(
                final w_fixed=w, useSupport=false) annotation (Placement(
                  transformation(extent={{100,-90},{80,-70}}, rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.SynchronousMachineData
              smeeData(
              SNominal=30e3,
              VsNominal=100,
              fsNominal=50,
              IeOpenCircuit=10,
              x0=0.1,
              xd=1.6,
              xq=1.6,
              xdTransient=0.1375,
              xdSubtransient=0.121428571,
              xqSubtransient=0.148387097,
              Ta=0.014171268,
              Td0Transient=0.261177343,
              Td0Subtransient=0.006963029,
              Tq0Subtransient=0.123345081,
              alpha20s(displayUnit="1/K") = Modelica.Electrical.Machines.Thermal.Constants.alpha20Zero,
              alpha20r(displayUnit="1/K") = Modelica.Electrical.Machines.Thermal.Constants.alpha20Zero,
              alpha20e(displayUnit="1/K") = Modelica.Electrical.Machines.Thermal.Constants.alpha20Zero,
              TsSpecification=293.15,
              TsRef=293.15,
              TrSpecification=293.15,
              TrRef=293.15,
              TeSpecification=293.15,
              TeRef=293.15)
              annotation (Placement(transformation(extent={{-80,-80},{-60,-60}})));
          initial equation
            smeeE.is[1:2] = zeros(2);
            smeeM.is[1:2] = zeros(2);
            //conditional damper cage currents are defined as fixed start values
          equation
            connect(rotorAngleE.plug_n, smeeE.plug_sn) annotation (Line(points={{36,
                    -70},{36,-60},{-6,-60},{-6,-70}}, color={0,0,255}));
            connect(rotorAngleE.plug_p, smeeE.plug_sp)
              annotation (Line(points={{24,-70},{6,-70}}, color={0,0,255}));
            connect(rotorAngleE.flange, smeeE.flange)
              annotation (Line(points={{20,-80},{10,-80}}, color={0,0,0}));
            connect(star.pin_n, ground.p)
              annotation (Line(points={{-70,90},{-80,90}}, color={0,0,255}));
            connect(star.plug_p, sineVoltage.plug_n)
              annotation (Line(points={{-50,90},{-40,90}}, color={0,0,255}));
            connect(smeeE.flange, mechanicalPowerSensorE.flange_a)
              annotation (Line(points={{10,-80},{50,-80}}, color={0,0,0}));
            connect(mechanicalPowerSensorE.flange_b, constantSpeedE.flange)
              annotation (Line(points={{70,-80},{80,-80}}, color={0,0,0}));
            connect(rampCurrentE.p, groundE.p)
              annotation (Line(points={{-30,-90},{-40,-90}}, color={0,0,255}));
            connect(rampCurrentE.p, smeeE.pin_en) annotation (Line(points={{-30,-90},
                    {-20,-90},{-20,-86},{-10,-86}}, color={0,0,255}));
            connect(rampCurrentE.n, smeeE.pin_ep) annotation (Line(points={{-30,-70},
                    {-20,-70},{-20,-74},{-10,-74}}, color={0,0,255}));
            connect(smeeE.plug_sn, terminalBoxE.plug_sn)
              annotation (Line(points={{-6,-70},{-6,-70}}, color={0,0,255}));
            connect(smeeE.plug_sp, terminalBoxE.plug_sp)
              annotation (Line(points={{6,-70},{6,-70}}, color={0,0,255}));
            connect(rotorAngleM.plug_n, smeeM.plug_sn) annotation (Line(points={{36,
                    -10},{36,0},{-6,0},{-6,-10}}, color={0,0,255}));
            connect(rotorAngleM.plug_p, smeeM.plug_sp) annotation (Line(points={{24,
                    -10},{24,-10},{6,-10}}, color={0,0,255}));
            connect(rotorAngleM.flange, smeeM.flange) annotation (Line(points={{20,
                    -20},{15,-20},{10,-20}}, color={0,0,0}));
            connect(smeeM.flange, mechanicalPowerSensorM.flange_a)
              annotation (Line(points={{10,-20},{50,-20}}, color={0,0,0}));
            connect(mechanicalPowerSensorM.flange_b, constantSpeedM.flange)
              annotation (Line(points={{70,-20},{80,-20}}, color={0,0,0}));
            connect(rampCurrentM.p, groundM.p) annotation (Line(points={{-30,-30},{
                    -35,-30},{-35,-30},{-40,-30}}, color={0,0,255}));
            connect(rampCurrentM.p, smeeM.pin_en) annotation (Line(points={{-30,-30},
                    {-20,-30},{-20,-26},{-10,-26}}, color={0,0,255}));
            connect(rampCurrentM.n, smeeM.pin_ep) annotation (Line(points={{-30,-10},
                    {-20,-10},{-20,-14},{-10,-14}}, color={0,0,255}));
            connect(smeeM.plug_sn, terminalBoxM.plug_sn)
              annotation (Line(points={{-6,-10},{-6,-10}}, color={0,0,255}));
            connect(smeeM.plug_sp, terminalBoxM.plug_sp)
              annotation (Line(points={{6,-10},{6,-10}}, color={0,0,255}));
            connect(electricalPowerSensorM.plug_p, sineVoltage.plug_p) annotation (
                Line(
                points={{0,40},{0,90},{-20,90}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensorE.plug_p, sineVoltage.plug_p) annotation (
                Line(
                points={{-60,40},{0,40},{0,90},{-20,90}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensorM.plug_ni, terminalBoxM.plugSupply)
              annotation (Line(
                points={{0,20},{0,13},{0,13},{0,6},{0,6},{0,-8}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensorE.plug_ni, terminalBoxE.plugSupply)
              annotation (Line(
                points={{-60,20},{-60,-50},{0,-50},{0,-68}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensorE.plug_nv, star.plug_p) annotation (Line(
                points={{-50,30},{-50,90}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensorM.plug_nv, star.plug_p) annotation (Line(
                points={{-10,30},{-50,30},{-50,90}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (experiment(
                StopTime=30,
                Interval=0.005,
                Tolerance=1e-06), Documentation(info="<HTML>
<h4>Electrical excited synchronous induction machine as generator</h4>
<p>
An
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ElectricalExcited\">electrically excited synchronous generator</a> is connected to the grid and driven with constant speed.
Since speed is slightly smaller than synchronous speed corresponding to mains frequency,
rotor angle is very slowly increased. This allows to see several characteristics dependent on rotor angle.
</p>

<p>
Simulate for 30 seconds and plot (versus <code>rotorAngleM.rotorDisplacementAngle</code>):
</p>

<ul>
<li><code>speedM|E.tauElectrical</code>: machine torque</li>
<li><code>mechanicalPowerSensorM|E.P</code>: mechanical power</li>
</ul>
</HTML>"));
          end SMEE_Generator;

          model SMEE_Generator_MultiPhase "Electrical excited multi phase synchronous machine operating as generator"
            import Modelica;
            import Modelica_AddOn;
            extends Modelica.Icons.Example;
            import Modelica.Constants.pi;
            constant Integer m3=3 "Number of stator phases of threephase system";
            parameter Integer m=5 "Number of stator phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fsNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.AngularVelocity w=
                Modelica.SIunits.Conversions.from_rpm(1499) "Nominal speed";
            parameter Modelica.SIunits.Current Ie=19 "Excitation current";
            parameter Modelica.SIunits.Current Ie0=10 "Initial excitation current";
            parameter Modelica.SIunits.Angle gamma0(displayUnit="deg") = 0 "Initial rotor displacement angle";
            parameter Integer p=2 "Number of pole pairs";
            parameter Modelica.SIunits.Resistance Rs=0.03 "Warm stator resistance per phase";
            parameter Modelica.SIunits.Inductance Lssigma=0.1/(2*Modelica.Constants.pi
                *fsNominal) "Stator stray inductance per phase";
            parameter Modelica.SIunits.Inductance Lmd=1.5/(2*Modelica.Constants.pi*
                fsNominal) "Main field inductance in d-axis";
            parameter Modelica.SIunits.Inductance Lmq=1.5/(2*Modelica.Constants.pi*
                fsNominal) "Main field inductance in q-axis";
            parameter Modelica.SIunits.Inductance Lrsigmad=0.05/(2*Modelica.Constants.pi
                *fsNominal) "Damper stray inductance (equivalent three phase winding) d-axis";
            parameter Modelica.SIunits.Inductance Lrsigmaq=Lrsigmad "Damper stray inductance (equivalent three phase winding) q-axis";
            parameter Modelica.SIunits.Resistance Rrd=0.04 "Warm damper resistance (equivalent three phase winding) d-axis";
            parameter Modelica.SIunits.Resistance Rrq=Rrd "Warm damper resistance (equivalent three phase winding) q-axis";
            Modelica.Electrical.MultiPhase.Basic.Star star3(final m=m3) annotation (
               Placement(transformation(extent={{-50,-30},{-70,-10}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground ground3 annotation (Placement(
                  transformation(
                  origin={-90,-20},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage3(
              final m=m3,
              final V=fill(VsNominal*sqrt(2), m3),
              phase=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                  m3),
              final freqHz=fill(fsNominal, m3)) annotation (Placement(
                  transformation(extent={{-20,-30},{-40,-10}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sensors.PowerSensor
              electricalPowerSensorM(m=m) annotation (Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=180,
                  origin={-2,80})));
            Modelica.Electrical.Machines.Sensors.ElectricalPowerSensor
              electricalPowerSensor3 annotation (Placement(transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=0,
                  origin={0,-20})));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(
                terminalConnection="Y", m=m) annotation (Placement(transformation(
                    extent={{-10,50},{10,70}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBox3(
                terminalConnection="Y", m=m3) annotation (Placement(transformation(
                    extent={{-10,-70},{10,-50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ElectricalExcited
              smeeM(
              phiMechanical(start=-(Modelica.Constants.pi + gamma0)/p, fixed=true),
              Jr=0.29,
              Js=0.29,
              p=2,
              fsNominal=smeeData.fsNominal,
              TsRef=smeeData.TsRef,
              alpha20s(displayUnit="1/K") = smeeData.alpha20s,
              useDamperCage=true,
              Lrsigmad=smeeData.Lrsigmad,
              Lrsigmaq=smeeData.Lrsigmaq,
              Rrd=smeeData.Rrd,
              Rrq=smeeData.Rrq,
              TrRef=smeeData.TrRef,
              alpha20r(displayUnit="1/K") = smeeData.alpha20r,
              VsNominal=smeeData.VsNominal,
              IeOpenCircuit=smeeData.IeOpenCircuit,
              Re=smeeData.Re,
              TeRef=smeeData.TeRef,
              alpha20e(displayUnit="1/K") = smeeData.alpha20e,
              sigmae=smeeData.sigmae,
              m=m,
              Rs=smeeData.Rs*m/3,
              Lssigma=smeeData.Lssigma*m/3,
              Lmd=smeeData.Lmd*m/3,
              Lmq=smeeData.Lmq*m/3,
              statorCoreParameters(VRef=100),
              strayLoadParameters(IRef=100),
              brushParameters(ILinear=0.01),
              TsOperational=293.15,
              TrOperational=293.15,
              TeOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,30},
                      {10,50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ElectricalExcited
              smee3(
              phiMechanical(start=-(Modelica.Constants.pi + gamma0)/p, fixed=true),
              p=2,
              fsNominal=smeeData.fsNominal,
              Rs=smeeData.Rs,
              TsRef=smeeData.TsRef,
              alpha20s(displayUnit="1/K") = smeeData.alpha20s,
              Lssigma=smeeData.Lssigma,
              Jr=0.29,
              Js=0.29,
              frictionParameters(PRef=0),
              statorCoreParameters(PRef=0, VRef=100),
              strayLoadParameters(PRef=0, IRef=100),
              Lmd=smeeData.Lmd,
              Lmq=smeeData.Lmq,
              useDamperCage=true,
              Lrsigmad=smeeData.Lrsigmad,
              Rrd=smeeData.Rrd,
              Rrq=smeeData.Rrq,
              alpha20r(displayUnit="1/K") = smeeData.alpha20r,
              VsNominal=smeeData.VsNominal,
              IeOpenCircuit=smeeData.IeOpenCircuit,
              Re=smeeData.Re,
              TeRef=smeeData.TeRef,
              alpha20e(displayUnit="1/K") = smeeData.alpha20e,
              sigmae=smeeData.sigmae,
              brushParameters(V=0, ILinear=0.01),
              Lrsigmaq=smeeData.Lrsigmaq,
              TrRef=smeeData.TrRef,
              m=m3,
              TsOperational=293.15,
              TrOperational=293.15,
              TeOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,-90},
                      {10,-70}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground groundRM annotation (Placement(
                  transformation(
                  origin={-20,20},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground groundR3 annotation (Placement(
                  transformation(
                  origin={-20,-100},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Electrical.Analog.Sources.RampCurrent rampCurrentM(
              duration=0.1,
              I=Ie - Ie0,
              offset=Ie0) annotation (Placement(transformation(
                  origin={-30,40},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.Analog.Sources.RampCurrent rampCurrent3(
              duration=0.1,
              I=Ie - Ie0,
              offset=Ie0) annotation (Placement(transformation(
                  origin={-30,-80},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngle3(
               p=p) annotation (Placement(transformation(
                  origin={30,-80},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.MechanicalPowerSensor
              mechanicalPowerSensorM annotation (Placement(transformation(extent={{
                      20,30},{40,50}}, rotation=0)));
            Modelica.Electrical.Machines.Sensors.MechanicalPowerSensor
              mechanicalPowerSensor3 annotation (Placement(transformation(extent={{
                      50,-90},{70,-70}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.ConstantSpeed constantSpeedM(
                final w_fixed=w, useSupport=false) annotation (Placement(
                  transformation(extent={{70,30},{50,50}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.ConstantSpeed constantSpeed3(
                final w_fixed=w, useSupport=false) annotation (Placement(
                  transformation(extent={{100,-90},{80,-70}}, rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.SynchronousMachineData
              smeeData(
              SNominal=30e3,
              VsNominal=100,
              fsNominal=50,
              IeOpenCircuit=10,
              x0=0.1,
              xd=1.6,
              xq=1.6,
              xdTransient=0.1375,
              xdSubtransient=0.121428571,
              xqSubtransient=0.148387097,
              Ta=0.014171268,
              Td0Transient=0.261177343,
              Td0Subtransient=0.006963029,
              Tq0Subtransient=0.123345081,
              alpha20s(displayUnit="1/K") = Modelica.Electrical.Machines.Thermal.Constants.alpha20Zero,
              alpha20r(displayUnit="1/K") = Modelica.Electrical.Machines.Thermal.Constants.alpha20Zero,
              alpha20e(displayUnit="1/K") = Modelica.Electrical.Machines.Thermal.Constants.alpha20Zero,
              TsSpecification=293.15,
              TsRef=293.15,
              TrSpecification=293.15,
              TrRef=293.15,
              TeSpecification=293.15,
              TeRef=293.15) annotation (Placement(transformation(extent={{-100,-100},
                      {-80,-80}})));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM(m=m) annotation (Placement(transformation(
                  origin={30,80},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensor3 annotation (Placement(transformation(
                  origin={30,-20},
                  extent={{-10,10},{10,-10}},
                  rotation=0)));
            Modelica.Blocks.Math.Gain gain(k=(m/m3)) annotation (Placement(
                  transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=90,
                  origin={90,30})));
            Modelica.Blocks.Math.Feedback feedback annotation (Placement(
                  transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=0,
                  origin={90,0})));
            Modelica.Electrical.MultiPhase.Basic.Star starM(final m=m) annotation (
                Placement(transformation(extent={{-50,70},{-70,90}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground groundM annotation (Placement(
                  transformation(
                  origin={-90,80},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltageM(
              final V=fill(VsNominal*sqrt(2), m),
              final freqHz=fill(fsNominal, m),
              final m=m,
              phase=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                  m)) annotation (Placement(transformation(extent={{-20,70},{-40,90}},
                    rotation=0)));
          initial equation
            smee3.is[1:2] = zeros(2);
            smeeM.is[1:2] = zeros(2);
            //conditional damper cage currents are defined as fixed start values
          equation
            connect(rotorAngle3.plug_n, smee3.plug_sn) annotation (Line(points={{36,
                    -70},{36,-60},{-6,-60},{-6,-70}}, color={0,0,255}));
            connect(rotorAngle3.plug_p, smee3.plug_sp)
              annotation (Line(points={{24,-70},{6,-70}}, color={0,0,255}));
            connect(rotorAngle3.flange, smee3.flange)
              annotation (Line(points={{20,-80},{10,-80}}, color={0,0,0}));
            connect(star3.pin_n, ground3.p) annotation (Line(points={{-70,-20},{-75,
                    -20},{-80,-20}}, color={0,0,255}));
            connect(star3.plug_p, sineVoltage3.plug_n) annotation (Line(points={{-50,
                    -20},{-48,-20},{-46,-20},{-40,-20}}, color={0,0,255}));
            connect(smee3.flange, mechanicalPowerSensor3.flange_a)
              annotation (Line(points={{10,-80},{50,-80}}, color={0,0,0}));
            connect(mechanicalPowerSensor3.flange_b, constantSpeed3.flange)
              annotation (Line(points={{70,-80},{80,-80}}, color={0,0,0}));
            connect(rampCurrent3.p, groundR3.p) annotation (Line(points={{-30,-90},
                    {-26,-90},{-20,-90}}, color={0,0,255}));
            connect(rampCurrent3.p, smee3.pin_en) annotation (Line(points={{-30,-90},
                    {-20,-90},{-20,-86},{-10,-86}}, color={0,0,255}));
            connect(rampCurrent3.n, smee3.pin_ep) annotation (Line(points={{-30,-70},
                    {-20,-70},{-20,-74},{-10,-74}}, color={0,0,255}));
            connect(smee3.plug_sn, terminalBox3.plug_sn)
              annotation (Line(points={{-6,-70},{-6,-70}}, color={0,0,255}));
            connect(smee3.plug_sp, terminalBox3.plug_sp)
              annotation (Line(points={{6,-70},{6,-70}}, color={0,0,255}));
            connect(smeeM.flange, mechanicalPowerSensorM.flange_a)
              annotation (Line(points={{10,40},{10,40},{20,40}}, color={0,0,0}));
            connect(mechanicalPowerSensorM.flange_b, constantSpeedM.flange)
              annotation (Line(points={{40,40},{44,40},{46,40},{50,40}}, color={0,0,
                    0}));
            connect(rampCurrentM.p, groundRM.p) annotation (Line(points={{-30,30},{
                    -30,30},{-20,30}}, color={0,0,255}));
            connect(rampCurrentM.p, smeeM.pin_en) annotation (Line(points={{-30,30},
                    {-20,30},{-20,34},{-10,34}}, color={0,0,255}));
            connect(rampCurrentM.n, smeeM.pin_ep) annotation (Line(points={{-30,50},
                    {-20,50},{-20,46},{-10,46}}, color={0,0,255}));
            connect(smeeM.plug_sn, terminalBoxM.plug_sn)
              annotation (Line(points={{-6,50},{-6,50}}, color={0,0,255}));
            connect(smeeM.plug_sp, terminalBoxM.plug_sp)
              annotation (Line(points={{6,50},{6,50}}, color={0,0,255}));
            connect(electricalPowerSensor3.plug_p, sineVoltage3.plug_p) annotation (
               Line(
                points={{-10,-20},{-20,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensor3.plug_nv, star3.plug_p) annotation (Line(
                points={{0,-10},{0,-8},{-50,-8},{-50,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(gain.y, feedback.u2) annotation (Line(
                points={{90,19},{90,8}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(electricalPowerSensor3.plug_ni, currentRMSsensor3.plug_p)
              annotation (Line(
                points={{10,-20},{20,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensor3.plug_n, terminalBox3.plugSupply) annotation (
                Line(
                points={{40,-20},{40,-40},{0,-40},{0,-68}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensor3.I, feedback.u1) annotation (Line(
                points={{30,-9},{30,0},{82,0}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(terminalBoxM.plugSupply, currentRMSsensorM.plug_n) annotation (
                Line(
                points={{0,52},{0,60},{40,60},{40,80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(currentRMSsensorM.I, gain.u) annotation (Line(
                points={{30,90},{30,100},{90,100},{90,42}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(starM.pin_n, groundM.p) annotation (Line(points={{-70,80},{-75,
                    80},{-80,80}}, color={0,0,255}));
            connect(starM.plug_p, sineVoltageM.plug_n) annotation (Line(points={{-50,
                    80},{-48,80},{-40,80}}, color={0,0,255}));
            connect(sineVoltageM.plug_p, electricalPowerSensorM.pc) annotation (
                Line(
                points={{-20,80},{-12,80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensorM.pc, electricalPowerSensorM.pv)
              annotation (Line(
                points={{-12,80},{-12,70},{-2,70}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensorM.nc, currentRMSsensorM.plug_p)
              annotation (Line(
                points={{8,80},{20,80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electricalPowerSensorM.nv, starM.plug_p) annotation (Line(
                points={{-2,90},{-2,94},{-50,94},{-50,80}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (
              experiment(
                StopTime=30,
                Interval=0.005,
                Tolerance=1e-06),
              Documentation(info="<HTML>
<h4>Electrical excited synchronous induction machine as generator</h4>
<p>
Two
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ElectricalExcited\">electrically excited synchronous generators</a> are connected to grids and driven with constant speed.
Since speed is slightly smaller than synchronous speed corresponding to mains frequency,
rotor angle is very slowly increased. Two equivalent machines with different numbers of phases are compared and their equal behavior is demonstrated.
</p>

<p>
Simulate for 30 seconds and plot (versus <code>rotorAngleM3.rotorDisplacementAngle</code>):
</p>

<ul>
<li><code>aimcM|M3.tauElectrical</code>: machine torque</li>
<li><code>aimsM|M3.wMechanical</code>: machine speed</li>
<li><code>feedback.y</code>: zero since difference of three phase current phasor and scaled multi phase current phasor are equal</li>
</ul>

</HTML>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics={Rectangle(
                          extent={{-50,60},{70,20}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash),Text(
                          extent={{10,16},{70,8}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textStyle={TextStyle.Bold},
                          textString="%m phase machine
"),Text(                      extent={{10,-52},{70,-60}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textStyle={TextStyle.Bold},
                          textString="3 phase machine
"),Rectangle(                 extent={{-50,-60},{100,-100}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash)}));
          end SMEE_Generator_MultiPhase;

          model SMR_Inverter "Starting of synchronous reluctance machine with inverter"
            extends Modelica.Icons.Example;
            constant Integer m=3 "Number of stator phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fsNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.Frequency fKnee=50 "Knee frequency of V/f curve";
            parameter Modelica.SIunits.Time tRamp=1 "Frequency ramp";
            parameter Modelica.SIunits.Torque T_Load=46 "Nominal load torque";
            parameter Modelica.SIunits.Time tStep=1.2 "Time of load torque step";
            parameter Modelica.SIunits.Inertia J_Load=0.29 "Load inertia";
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={-90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                Placement(transformation(extent={{-50,80},{-70,100}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SignalVoltage signalVoltage(
                final m=m) annotation (Placement(transformation(
                  origin={0,60},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Modelica.Blocks.Sources.Ramp ramp(height=fKnee, duration=tRamp)
              annotation (Placement(transformation(extent={{-80,50},{-60,70}},
                    rotation=0)));
            Modelica.Electrical.Machines.Utilities.VfController vfController(
              final m=m,
              VNominal=VsNominal,
              fNominal=fsNominal) annotation (Placement(transformation(extent={{-40,
                      50},{-20,70}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM annotation (Placement(transformation(
                  origin={0,20},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorE annotation (Placement(transformation(
                  origin={-60,20},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(
                terminalConnection="Y") annotation (Placement(transformation(extent=
                     {{-10,-10},{10,10}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxE(
                terminalConnection="Y") annotation (Placement(transformation(extent=
                     {{-10,-70},{10,-50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ReluctanceRotor
              smrM(
              Jr=smrData.Jr,
              Js=smrData.Js,
              p=smrData.p,
              fsNominal=smrData.fsNominal,
              Rs=smrData.Rs,
              TsRef=smrData.TsRef,
              alpha20s(displayUnit="1/K") = smrData.alpha20s,
              Lssigma=smrData.Lssigma,
              Lszero=smrData.Lszero,
              frictionParameters=smrData.frictionParameters,
              statorCoreParameters=smrData.statorCoreParameters,
              strayLoadParameters=smrData.strayLoadParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              Lmd=smrData.Lmd,
              Lmq=smrData.Lmq,
              useDamperCage=smrData.useDamperCage,
              Lrsigmad=smrData.Lrsigmad,
              Lrsigmaq=smrData.Lrsigmaq,
              Rrd=smrData.Rrd,
              Rrq=smrData.Rrq,
              TrRef=smrData.TrRef,
              alpha20r(displayUnit="1/K") = smrData.alpha20r,
              TsOperational=293.15,
              TrOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,-30},
                      {10,-10}}, rotation=0)));
            Modelica.Electrical.Machines.BasicMachines.SynchronousInductionMachines.SM_ReluctanceRotor
              smrE(
              p=smrData.p,
              fsNominal=smrData.fsNominal,
              Rs=smrData.Rs,
              TsRef=smrData.TsRef,
              alpha20s(displayUnit="1/K") = smrData.alpha20s,
              Lszero=smrData.Lszero,
              Lssigma=smrData.Lssigma,
              Jr=smrData.Jr,
              Js=smrData.Js,
              frictionParameters=smrData.frictionParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              statorCoreParameters=smrData.statorCoreParameters,
              strayLoadParameters=smrData.strayLoadParameters,
              Lmd=smrData.Lmd,
              Lmq=smrData.Lmq,
              useDamperCage=smrData.useDamperCage,
              Lrsigmad=smrData.Lrsigmad,
              Lrsigmaq=smrData.Lrsigmaq,
              Rrd=smrData.Rrd,
              Rrq=smrData.Rrq,
              TrRef=smrData.TrRef,
              alpha20r(displayUnit="1/K") = smrData.alpha20r,
              TsOperational=293.15,
              ir(fixed=true),
              TrOperational=293.15) annotation (Placement(transformation(extent={{-10,
                      -90},{10,-70}}, rotation=0)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngleM(
                p=smrM.p) annotation (Placement(transformation(
                  origin={30,-20},
                  extent={{10,-10},{-10,10}},
                  rotation=90)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngleE(
                p=smrE.p) annotation (Placement(transformation(
                  origin={30,-80},
                  extent={{10,-10},{-10,10}},
                  rotation=90)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaM(J=J_Load)
              annotation (Placement(transformation(extent={{50,-30},{70,-10}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaE(J=J_Load)
              annotation (Placement(transformation(extent={{50,-90},{70,-70}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStepM(
              startTime=tStep,
              stepTorque=-T_Load,
              useSupport=false,
              offsetTorque=0) annotation (Placement(transformation(extent={{100,-30},
                      {80,-10}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStepE(
              startTime=tStep,
              stepTorque=-T_Load,
              useSupport=false,
              offsetTorque=0) annotation (Placement(transformation(extent={{100,-90},
                      {80,-70}}, rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.SM_ReluctanceRotorData
              smrData
              annotation (Placement(transformation(extent={{-40,-100},{-20,-80}})));
          initial equation
            smrE.is[1:2] = zeros(2);
            smrM.is[1:2] = zeros(2);
            //conditional damper cage currents are defined as fixed start values
          equation
            connect(signalVoltage.plug_n, star.plug_p)
              annotation (Line(points={{0,70},{0,90},{-50,90}}, color={0,0,255}));
            connect(star.pin_n, ground.p)
              annotation (Line(points={{-70,90},{-80,90}}, color={0,0,255}));
            connect(smrE.flange, loadInertiaE.flange_a)
              annotation (Line(points={{10,-80},{50,-80}}, color={0,0,0}));
            connect(ramp.y, vfController.u)
              annotation (Line(points={{-59,60},{-42,60}}, color={0,0,255}));
            connect(vfController.y, signalVoltage.v)
              annotation (Line(points={{-19,60},{-7,60}}, color={0,0,255}));
            connect(loadInertiaE.flange_b, torqueStepE.flange)
              annotation (Line(points={{70,-80},{80,-80}}, color={0,0,0}));
            connect(smrE.plug_sn, rotorAngleE.plug_n) annotation (Line(points={{-6,
                    -70},{-6,-60},{36,-60},{36,-70}}, color={0,0,255}));
            connect(smrE.plug_sp, rotorAngleE.plug_p)
              annotation (Line(points={{6,-70},{24,-70}}, color={0,0,255}));
            connect(smrE.flange, rotorAngleE.flange)
              annotation (Line(points={{10,-80},{20,-80}}, color={0,0,0}));
            connect(terminalBoxE.plug_sp, smrE.plug_sp)
              annotation (Line(points={{6,-70},{6,-70}}, color={0,0,255}));
            connect(terminalBoxE.plug_sn, smrE.plug_sn)
              annotation (Line(points={{-6,-70},{-6,-70}}, color={0,0,255}));
            connect(terminalBoxE.plugSupply, currentRMSsensorE.plug_n) annotation (
                Line(points={{0,-68},{0,-50},{-60,-50},{-60,10}}, color={0,0,255}));
            connect(smrM.flange, loadInertiaM.flange_a) annotation (Line(points={{
                    10,-20},{10,-20},{50,-20}}, color={0,0,0}));
            connect(loadInertiaM.flange_b, torqueStepM.flange)
              annotation (Line(points={{70,-20},{80,-20}}, color={0,0,0}));
            connect(smrM.plug_sn, rotorAngleM.plug_n) annotation (Line(points={{-6,
                    -10},{-6,0},{36,0},{36,-10}}, color={0,0,255}));
            connect(smrM.plug_sp, rotorAngleM.plug_p) annotation (Line(points={{6,-10},
                    {6,-10},{24,-10}}, color={0,0,255}));
            connect(smrM.flange, rotorAngleM.flange) annotation (Line(points={{10,-20},
                    {10,-20},{20,-20}}, color={0,0,0}));
            connect(terminalBoxM.plug_sp, smrM.plug_sp)
              annotation (Line(points={{6,-10},{6,-10}}, color={0,0,255}));
            connect(terminalBoxM.plug_sn, smrM.plug_sn)
              annotation (Line(points={{-6,-10},{-6,-10}}, color={0,0,255}));
            connect(currentRMSsensorM.plug_n, terminalBoxM.plugSupply) annotation (
                Line(points={{0,10},{0,5.5},{0,5.5},{0,1},{0,1},{0,-8}}, color={0,0,
                    255}));
            connect(signalVoltage.plug_p, currentRMSsensorM.plug_p) annotation (
                Line(points={{0,50},{0,45},{-1.1102e-16,45},{-1.1102e-16,40},{0,40},
                    {0,30}}, color={0,0,255}));
            connect(signalVoltage.plug_p, currentRMSsensorE.plug_p) annotation (
                Line(points={{0,50},{0,50},{0,30},{-60,30}}, color={0,0,255}));
            annotation (experiment(
                StopTime=1.5,
                Interval=0.001,
                Tolerance=1e-06), Documentation(info="<HTML>
<h4>Synchronous induction machine with reluctance rotor fed by an ideal inverter</h4>
<p>
An ideal frequency inverter is modeled by using a
<a href=\"modelica://Modelica.Electrical.Machines.Utilities.VfController\">VfController</a>
and a three-phase <a href=\"modelica://Modelica.Electrical.MultiPhase.Sources.SignalVoltage\">SignalVoltage</a>.
Frequency is raised by a ramp, causing the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ReluctanceRotor\">reluctance machine</a> to start,
and accelerating inertias. At time <code>tStep</code> a load step is applied.
</p>

<p>
Simulate for 1.5 seconds and plot (versus time):
</p>

<ul>
<li><code>currentRMSsensorM|E.I</code>: equivalent RMS stator current</li>
<li><code>smrM|E.wMechanical</code>: machine speed</li>
<li><code>smrM|E.tauElectrical</code>: machine torque</li>
<li><code>rotorAngleM|R.rotorDisplacementAngle</code>: rotor displacement angle</li>
</ul>
</HTML>"));
          end SMR_Inverter;

          model SMR_Inverter_MultiPhase "Starting of multi phase synchronous reluctance machine with inverter"
            import Modelica;
            import Modelica_AddOn;
            extends Modelica.Icons.Example;
            constant Integer m3=3 "Number of stator phases of threephase system";
            parameter Integer m=5 "Number of stator phases";
            parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
            parameter Modelica.SIunits.Frequency fsNominal=50 "Nominal frequency";
            parameter Modelica.SIunits.Frequency fKnee=50 "Knee frequency of V/f curve";
            parameter Modelica.SIunits.Time tRamp=1 "Frequency ramp";
            parameter Modelica.SIunits.Torque T_Load=46 "Nominal load torque";
            parameter Modelica.SIunits.Time tStep=1.2 "Time of load torque step";
            parameter Modelica.SIunits.Inertia J_Load=0.29 "Load inertia";
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(
                terminalConnection="Y", m=m) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}}, rotation=0)));
            Modelica.Electrical.Machines.Utilities.TerminalBox terminalBox3(
                terminalConnection="Y", m=m3) annotation (Placement(transformation(
                    extent={{-10,-70},{10,-50}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ReluctanceRotor
              smrM(
              Jr=smrData.Jr,
              Js=smrData.Js,
              p=smrData.p,
              fsNominal=smrData.fsNominal,
              TsRef=smrData.TsRef,
              alpha20s(displayUnit="1/K") = smrData.alpha20s,
              frictionParameters=smrData.frictionParameters,
              statorCoreParameters=smrData.statorCoreParameters,
              strayLoadParameters=smrData.strayLoadParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              useDamperCage=smrData.useDamperCage,
              Lrsigmad=smrData.Lrsigmad,
              Lrsigmaq=smrData.Lrsigmaq,
              Rrd=smrData.Rrd,
              Rrq=smrData.Rrq,
              TrRef=smrData.TrRef,
              alpha20r(displayUnit="1/K") = smrData.alpha20r,
              Rs=smrData.Rs*m/3,
              Lssigma=smrData.Lssigma*m/3,
              Lszero=smrData.Lszero*m/3,
              Lmd=smrData.Lmd*m/3,
              Lmq=smrData.Lmq*m/3,
              m=m,
              TsOperational=293.15,
              TrOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,-30},
                      {10,-10}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ReluctanceRotor
              smr3(
              p=smrData.p,
              fsNominal=smrData.fsNominal,
              Rs=smrData.Rs,
              TsRef=smrData.TsRef,
              alpha20s(displayUnit="1/K") = smrData.alpha20s,
              Lszero=smrData.Lszero,
              Lssigma=smrData.Lssigma,
              Jr=smrData.Jr,
              Js=smrData.Js,
              frictionParameters=smrData.frictionParameters,
              phiMechanical(fixed=true),
              wMechanical(fixed=true),
              statorCoreParameters=smrData.statorCoreParameters,
              strayLoadParameters=smrData.strayLoadParameters,
              Lmd=smrData.Lmd,
              Lmq=smrData.Lmq,
              useDamperCage=smrData.useDamperCage,
              Lrsigmad=smrData.Lrsigmad,
              Lrsigmaq=smrData.Lrsigmaq,
              Rrd=smrData.Rrd,
              Rrq=smrData.Rrq,
              TrRef=smrData.TrRef,
              alpha20r(displayUnit="1/K") = smrData.alpha20r,
              m=m3,
              TsOperational=293.15,
              TrOperational=293.15,
              ir(fixed=true)) annotation (Placement(transformation(extent={{-10,-90},
                      {10,-70}}, rotation=0)));
            Modelica.Electrical.Machines.Sensors.RotorDisplacementAngle rotorAngle3(
               p=smr3.p) annotation (Placement(transformation(
                  origin={30,-80},
                  extent={{10,-10},{-10,10}},
                  rotation=90)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertiaM(J=J_Load)
              annotation (Placement(transformation(extent={{50,-30},{70,-10}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Components.Inertia loadInertia3(J=J_Load)
              annotation (Placement(transformation(extent={{50,-90},{70,-70}},
                    rotation=0)));
            Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStepM(
              startTime=tStep,
              stepTorque=-T_Load,
              useSupport=false,
              offsetTorque=0) annotation (Placement(transformation(extent={{100,-30},
                      {80,-10}}, rotation=0)));
            Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStep3(
              startTime=tStep,
              stepTorque=-T_Load,
              useSupport=false,
              offsetTorque=0) annotation (Placement(transformation(extent={{100,-90},
                      {80,-70}}, rotation=0)));
            parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.SM_ReluctanceRotorData
              smrData annotation (Placement(transformation(extent={{-100,-100},{-80,
                      -80}})));
            Modelica.Electrical.Analog.Basic.Ground ground3 annotation (Placement(
                  transformation(
                  origin={-90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Star star3(final m=m3) annotation (
               Placement(transformation(extent={{-50,80},{-70,100}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Sources.SignalVoltage signalVoltage3(
                final m=m3) annotation (Placement(transformation(
                  origin={0,70},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Modelica.Blocks.Sources.Ramp ramp(height=fKnee, duration=tRamp)
              annotation (Placement(transformation(extent={{-80,60},{-60,80}},
                    rotation=0)));
            Modelica.Electrical.Machines.Utilities.VfController vfController3(
              VNominal=VsNominal,
              fNominal=fsNominal,
              BasePhase=+Modelica.Constants.pi/2,
              final m=m3,
              orientation=-
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m3))
              annotation (Placement(transformation(extent={{-40,60},{-20,80}},
                    rotation=0)));
            Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
              currentRMSsensorM(m=m) annotation (Placement(transformation(
                  origin={30,20},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.Machines.Sensors.CurrentQuasiRMSSensor
              currentRMSsensor3 annotation (Placement(transformation(
                  origin={-80,0},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Sources.SignalVoltage signalVoltageM(
                final m=m) annotation (Placement(transformation(
                  origin={30,50},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Star starM(final m=m) annotation (
                Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=180,
                  origin={60,90})));
            Modelica.Electrical.Analog.Basic.Ground groundM annotation (Placement(
                  transformation(
                  origin={90,90},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.Machines.Utilities.VfController vfControllerM(
              VNominal=VsNominal,
              fNominal=fsNominal,
              BasePhase=+Modelica.Constants.pi/2,
              final m=m,
              orientation=-
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m))
              annotation (Placement(transformation(
                  extent={{10,10},{-10,-10}},
                  rotation=180,
                  origin={-30,50})));
            Modelica.Blocks.Math.Feedback feedback annotation (Placement(
                  transformation(
                  extent={{-10,10},{10,-10}},
                  rotation=0,
                  origin={-50,0})));
            Modelica.Blocks.Math.Gain gain(k=(m/m3))
              annotation (Placement(transformation(extent={{-20,10},{-40,30}})));
          initial equation
            smr3.is[1:2] = zeros(2);
            smrM.is[1:2] = zeros(2);
            //conditional damper cage currents are defined as fixed start values
          equation
            connect(smr3.flange, loadInertia3.flange_a)
              annotation (Line(points={{10,-80},{50,-80}}, color={0,0,0}));
            connect(loadInertia3.flange_b, torqueStep3.flange)
              annotation (Line(points={{70,-80},{80,-80}}, color={0,0,0}));
            connect(smr3.plug_sn, rotorAngle3.plug_n) annotation (Line(points={{-6,
                    -70},{-6,-60},{36,-60},{36,-70}}, color={0,0,255}));
            connect(smr3.plug_sp, rotorAngle3.plug_p)
              annotation (Line(points={{6,-70},{24,-70}}, color={0,0,255}));
            connect(smr3.flange, rotorAngle3.flange)
              annotation (Line(points={{10,-80},{20,-80}}, color={0,0,0}));
            connect(terminalBox3.plug_sp, smr3.plug_sp)
              annotation (Line(points={{6,-70},{6,-70}}, color={0,0,255}));
            connect(terminalBox3.plug_sn, smr3.plug_sn)
              annotation (Line(points={{-6,-70},{-6,-70}}, color={0,0,255}));
            connect(smrM.flange, loadInertiaM.flange_a) annotation (Line(points={{
                    10,-20},{10,-20},{50,-20}}, color={0,0,0}));
            connect(loadInertiaM.flange_b, torqueStepM.flange)
              annotation (Line(points={{70,-20},{80,-20}}, color={0,0,0}));
            connect(terminalBoxM.plug_sp, smrM.plug_sp)
              annotation (Line(points={{6,-10},{6,-10}}, color={0,0,255}));
            connect(terminalBoxM.plug_sn, smrM.plug_sn)
              annotation (Line(points={{-6,-10},{-6,-10}}, color={0,0,255}));
            connect(signalVoltage3.plug_n, star3.plug_p)
              annotation (Line(points={{0,80},{0,90},{-50,90}}, color={0,0,255}));
            connect(star3.pin_n, ground3.p)
              annotation (Line(points={{-70,90},{-80,90}}, color={0,0,255}));
            connect(ramp.y, vfController3.u)
              annotation (Line(points={{-59,70},{-42,70}}, color={0,0,255}));
            connect(vfController3.y, signalVoltage3.v)
              annotation (Line(points={{-19,70},{-7,70}}, color={0,0,255}));
            connect(terminalBoxM.plugSupply, currentRMSsensorM.plug_n) annotation (
                Line(points={{0,-8},{0,-1},{0,-1},{0,10},{30,10}}, color={0,0,255}));
            connect(signalVoltage3.plug_p, currentRMSsensor3.plug_p) annotation (
                Line(
                points={{0,60},{0,34},{-80,34},{-80,10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(signalVoltageM.plug_n, starM.plug_p) annotation (Line(
                points={{30,60},{30,90},{50,90}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(starM.pin_n, groundM.p) annotation (Line(
                points={{70,90},{80,90}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(vfControllerM.y, signalVoltageM.v) annotation (Line(
                points={{-19,50},{23,50}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(vfControllerM.u, ramp.y) annotation (Line(
                points={{-42,50},{-50,50},{-50,70},{-59,70}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(signalVoltageM.plug_p, currentRMSsensorM.plug_p) annotation (
                Line(
                points={{30,40},{30,30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(gain.y, feedback.u2) annotation (Line(
                points={{-41,20},{-50,20},{-50,8}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(gain.u, currentRMSsensorM.I) annotation (Line(
                points={{-18,20},{20,20}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(currentRMSsensor3.plug_n, terminalBox3.plugSupply) annotation (
                Line(points={{-80,-10},{-80,-60},{0,-60},{0,-68}}, color={0,0,255}));
            connect(currentRMSsensor3.I, feedback.u1) annotation (Line(
                points={{-69,0},{-58,0}},
                color={0,0,127},
                smooth=Smooth.None));
            annotation (
              experiment(
                StopTime=1.5,
                Interval=0.001,
                Tolerance=1e-06),
              Documentation(info="<HTML>
<h4>Synchronous induction machine with reluctance rotor fed by an ideal inverter</h4>
<p>
Ideal frequency inverters are modeled by using a
<a href=\"modelica://Modelica.Electrical.Machines.Utilities.VfController\">VfController</a>
and phase <a href=\"modelica://Modelica.Electrical.MultiPhase.Sources.SignalVoltage\">SignalVoltage</a>s.
Frequency is raised by a ramp, causing the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ReluctanceRotor\">reluctance machine</a> to start,
and accelerating inertias. At time <code>tStep</code> a load step is applied. Two equivalent machines with different numbers of phases are compared and their equal behavior is demonstrated.
</p>

<p>
Simulate for 1.5 seconds and plot (versus time):
</p>

<ul>
<li><code>aimcM|M3.tauElectrical</code>: machine torque</li>
<li><code>aimsM|M3.wMechanical</code>: machine speed</li>
<li><code>feedback.y</code>: zero since difference of three phase current phasor and scaled multi phase current phasor are equal</li>
</ul>

</HTML>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics={Rectangle(
                          extent={{-20,0},{100,-40}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash),Text(
                          extent={{40,-44},{100,-52}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textStyle={TextStyle.Bold},
                          textString="%m phase machine
"),Text(                      extent={{40,-54},{100,-62}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          textStyle={TextStyle.Bold},
                          textString="3 phase machine
"),Rectangle(                 extent={{-20,-60},{100,-100}},
                          lineColor={0,0,0},
                          fillColor={255,255,170},
                          fillPattern=FillPattern.Solid,
                          pattern=LinePattern.Dash)}));
          end SMR_Inverter_MultiPhase;
        end BasicMachines;
        annotation (Documentation(info="<html>
<p>Examples comparing the models of
<a href=\"modelica://Modelica.Electrical.Machines.BasicMachines\">Electrical.Machines.BasicMachines</a> with
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines\">Magnetic.FundamentalWave.BasicMachines</a>.
</p>
</html>"));
      end Examples;

      package Components "Basic fundamental wave components"
        extends Modelica.Icons.Package;
        model Ground "Magnetic ground"
          Interfaces.PositiveMagneticPort port_p "Complex magnetic port"
            annotation (Placement(transformation(extent={{-10,90},{10,110}},
                  rotation=0)));
        equation
          port_p.V_m = Complex(0, 0);
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics={Line(points={{0,100},{0,50}}, color={255,
                  128,0}),Line(points={{-60,50},{60,50}}, color={255,128,0}),Line(
                  points={{-40,30},{40,30}}, color={255,128,0}),Line(points={{-20,
                  10},{20,10}}, color={255,128,0})}),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={
                Line(points={{0,100},{0,50}}, color={255,128,0}),
                Line(points={{-60,50},{60,50}}, color={255,128,0}),
                Line(points={{-40,30},{40,30}}, color={255,128,0}),
                Line(points={{-20,10},{20,10}}, color={255,128,0}),
                Text(
                  extent={{-144,-9},{156,-49}},
                  textString="%name",
                  lineColor={0,0,255})}),
            Documentation(info="<html>

<p>
Grounding of the complex magnetic potential. Each magnetic circuit has to be grounded at least one point of the circuit.
</p>

</html>"));
        end Ground;

        model Reluctance "Salient reluctance"
          import Modelica.Constants.pi;
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPortElementary;
          parameter Modelica_AddOn.Magnetic.FundamentalWave.Types.SalientReluctance
            R_m(d(start=1), q(start=1)) "Magnetic reluctance in d=re and q=im axis";
        equation
          (pi/2)*V_m.re = R_m.d*Phi.re;
          (pi/2)*V_m.im = R_m.q*Phi.im;
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={Rectangle(
                      extent={{-70,30},{70,-30}},
                      lineColor={255,128,0},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(points={{-96,0},{-70,0}},
                  color={255,128,0}),Line(points={{70,0},{96,0}}, color={255,128,0}),
                  Text(
                      extent={{0,60},{0,100}},
                      lineColor={0,0,255},
                      textString="%name")}), Documentation(info="<html>
<p>
The salient reluctance models the relationship between the complex magnetic potential difference
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/V_m.png\" alt=\"V_m.png\"> and the complex magnetic flux <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Phi.png\">,
</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/reluctance.png\"
      alt=\"reluctance.png\">
</blockquote>

<p>which can also be expressed in terms complex phasors:</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/reluctance_alt.png\"
     alt=\"reluctance_alt.png\">
</blockquote>

</html>"));
        end Reluctance;

        model Permeance "Salient Permeance"
          import Modelica.Constants.pi;
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPortElementary;
          parameter Modelica_AddOn.Magnetic.FundamentalWave.Types.SalientPermeance
            G_m(d(start=1), q(start=1)) "Magnetic permeance in d=re and q=im axis";
        equation
          (pi/2)*G_m.d*V_m.re = Phi.re;
          (pi/2)*G_m.q*V_m.im = Phi.im;
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={Rectangle(
                      extent={{-70,30},{70,-30}},
                      lineColor={255,128,0},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(points={{-96,0},{-70,0}},
                  color={255,128,0}),Line(points={{70,0},{96,0}}, color={255,128,0}),
                  Text(
                      extent={{0,60},{0,100}},
                      lineColor={0,0,255},
                      textString="%name")}), Documentation(info="<html>
<p>
The salient permeance models the relationship between the complex magnetic potential difference
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/V_m.png\" alt=\"V_m.png\"> and the complex magnetic flux <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Phi.png\">:
</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/permeance.png\"
      alt=\"reluctance.png\">
</blockquote>
<p></p>


</html>"));
        end Permeance;

        model EddyCurrent "Constant loss model under sinusoidal magnetic conditions"
          import Modelica.Constants.pi;
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPortElementary;
          parameter Modelica.SIunits.Conductance G(min=0) "Equivalent symmetric loss conductance";
          extends Modelica.Thermal.HeatTransfer.Interfaces.PartialElementaryConditionalHeatPort(
              final T=273.15);
        equation
          lossPower = (pi/2)*(V_m.re*der(Phi.re) + V_m.im*der(Phi.im));
          if G > 0 then
            (pi/2)*V_m.re = G*der(Phi.re);
            (pi/2)*V_m.im = G*der(Phi.im);
          else
            V_m.re = 0;
            V_m.im = 0;
          end if;
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Rectangle(
                      extent={{-70,30},{70,-30}},
                      lineColor={255,128,0},
                      fillColor={255,128,0},
                      fillPattern=FillPattern.Solid),Line(points={{-96,0},{-70,0}},
                  color={255,128,0}),Line(points={{70,0},{96,0}}, color={255,128,0}),
                  Text(
                      extent={{0,60},{0,100}},
                      lineColor={0,0,255},
                      textString="%name"),Text(
                      extent={{0,-40},{0,-80}},
                      lineColor={0,0,0},
                      textString="G=%G")}), Documentation(info="<html>
<p>
The eddy current loss model with respect to fundamental wave effects is designed in accordance to
<a href=\"modelica://Modelica.Magnetic.FluxTubes.Basic.EddyCurrent\">FluxTubes.Basic.EddyCurrent</a>.
</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/eddycurrent.png\"
     alt=\"eddycurrent.png\">
</blockquote>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\">Fig. 1: equivalent models of eddy current losses</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/eddycurrent_electric.png\"
           alt=\"eddycurrent_electric.png\">
    </td>
  </tr>
</table>

<p>Due to the nature of eddy current losses, which can be represented by symmetric
conductors in an equivalent electric circuit (Fig. 1), the respective
number of phases <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\" alt=\"m\"> has to be taken into account.
Assume that the <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\" alt=\"m\"> conductances
of the equivalent circuit are <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/Gc.png\" alt=\"G_c\">,
the conductance for the eddy current loss model is determined by</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/GGc.png\"
     alt=\"GGc\">
</blockquote>

<p>
where <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/N.png\" alt=\"N\"> is the number of turns of the symmetric electro magnetic coupling.
</p>

<p>For such an <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\" alt=\"m\"> phase system
the relationship between the voltage and current <a href=\"http://www.haumer.at/refimg/SpacePhasors.pdf\">space phasors</a>
and the magnetic flux and magnetic potential difference phasor is
</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/vPhi.png\" alt=\"vPhi\">,<br>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/iV_m.png\" alt=\"iV_m\">,
</blockquote>

<p>
where <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/v_k.png\" alt=\"v_k\">
and <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/i_k.png\" alt=\"i_k\">
are the phase voltages and currents, respectively.
</p>

<p>
The dissipated loss power
</p>
<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/lossPower.png\" alt=\"lossPower\">
</blockquote>
<p>
can be determined for the <a href=\"http://www.haumer.at/refimg/SpacePhasors.pdf\">space phasor</a>
relationship of the voltage and current space phasor.
</p>
<h4>See also</h4>

<p><a href=\"modelica://Modelica.Magnetic.FluxTubes.Basic.EddyCurrent\">FluxTubes.Basic.EddyCurrent</a></p>

</html>"));
        end EddyCurrent;

        model SinglePhaseElectroMagneticConverter "Single phase electro magnetic converter"
          import Modelica.Constants.pi;
          Modelica.Electrical.Analog.Interfaces.PositivePin pin_p "Positive pin"
            annotation (Placement(transformation(
                origin={-100,100},
                extent={{-10,-10},{10,10}},
                rotation=180)));
          Modelica.Electrical.Analog.Interfaces.NegativePin pin_n "Negative pin"
            annotation (Placement(transformation(
                origin={-100,-100},
                extent={{-10,-10},{10,10}},
                rotation=180)));
          Interfaces.PositiveMagneticPort port_p "Positive complex magnetic port"
            annotation (Placement(transformation(extent={{90,90},{110,110}},
                  rotation=0)));
          Interfaces.NegativeMagneticPort port_n "Negative complex magnetic port"
            annotation (Placement(transformation(extent={{90,-110},{110,-90}},
                  rotation=0)));
          parameter Real effectiveTurns "Effective number of turns"
            annotation (Evaluate=true);
          parameter Modelica.SIunits.Angle orientation "Orientation of the resulting fundamental wave V_m phasor"
            annotation (Evaluate=true);
          // Local electric single phase quantities
          Modelica.SIunits.Voltage v "Voltage";
          Modelica.SIunits.Current i "Current";
          // Local electromagnetic fundamental wave quantities
          Modelica.SIunits.ComplexMagneticPotentialDifference V_m "Complex magnetic potential difference";
          Modelica.SIunits.MagneticPotentialDifference abs_V_m=
              Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
          Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
          Modelica.SIunits.ComplexMagneticFlux Phi "Complex magnetic flux";
          Modelica.SIunits.MagneticPotentialDifference abs_Phi=
              Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
          Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
          final parameter Complex N=effectiveTurns*Modelica.ComplexMath.exp(Complex(
              0, orientation)) "Complex number of turns";
        equation
          // Magnetic flux and flux balance of the magnetic ports
          port_p.Phi = Phi;
          port_p.Phi + port_n.Phi = Complex(0, 0);
          // Magnetic potential difference of the magnetic ports
          port_p.V_m - port_n.V_m = V_m;
          // Voltage drop between the electrical pins
          v = pin_p.v - pin_n.v;
          // Current and current balance of the electric pins
          i = pin_p.i;
          pin_p.i + pin_n.i = 0;
          // Complex magnetic potential difference is determined from currents, number
          // of turns and angles of orientation of winding
          // V_m.re = (2/pi) * effectiveTurns*cos(orientation)*i;
          // V_m.im = (2/pi) * effectiveTurns*sin(orientation)*i;
          V_m = (2.0/pi)*N*i;
          // Induced voltages is determined from complex magnetic flux, number of turns
          // and angles of orientation of winding
          // -v = effectiveTurns*cos(orientation)*der(Phi.re)
          //    + effectiveTurns*sin(orientation)*der(Phi.im);
          -v = Modelica.ComplexMath.real(Modelica.ComplexMath.conj(N)*Complex(der(
            Phi.re), der(Phi.im)));
          annotation (
            defaultComponentName="converter",
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Ellipse(
                      extent={{-60,60},{58,0}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Ellipse(
                      extent={{-58,0},{60,-60}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Rectangle(
                      extent={{-60,60},{0,-60}},
                      lineColor={0,0,255},
                      pattern=LinePattern.None,
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(points={{100,-100},{94,-100},
                  {84,-98},{76,-94},{64,-86},{50,-72},{42,-58},{36,-40},{30,-18},{
                  30,0},{30,18},{34,36},{46,66},{62,84},{78,96},{90,100},{100,100}},
                  color={255,128,0}),Line(points={{0,60},{-100,60},{-100,100}},
                  color={0,0,255}),Line(points={{0,-60},{-100,-60},{-100,-98}},
                  color={0,0,255}),Text(
                      extent={{0,160},{0,120}},
                      lineColor={0,0,255},
                      fillColor={255,128,0},
                      fillPattern=FillPattern.Solid,
                      textString="%name")}),
            Documentation(info="<html>
<p>
The single phase winding has an effective number of turns, <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/effectiveTurns.png\"> and a respective orientation of the winding, <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/orientation.png\">. The current in winding is <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/i.png\">.
</p>

<p>
The total complex magnetic potential difference of the single phase winding is determined by:
</p>

<p>
&nbsp;&nbsp;<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/singlephaseconverter_vm.png\">
</p>

<p>
In this equation the magneto motive force is aligned with the orientation of the winding.
</p>

<p>
The voltage <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/v.png\"> induced in the winding depends on the cosine between the orientation of the winding and the angle of the complex magnetic flux. Additionally, the magnitudes of the induced voltages are proportional to the respective number of turns. This relationship can be modeled by means of</p>

<p>
&nbsp;&nbsp;<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/singlephaseconverter_phi.png\">
</p>

<p>The single phase electromagnetic converter is a special case of the
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter\">MultiPhaseElectroMagneticConverter</a>
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter\">MultiPhaseElectroMagneticConverter</a>
</p>

</html>"));
        end SinglePhaseElectroMagneticConverter;

        model MultiPhaseElectroMagneticConverter "Multi phase electro magnetic converter"
          import Modelica.Constants.pi;
          // Global plug and port variables
          Modelica.SIunits.Voltage v[m]=plug_p.pin.v - plug_n.pin.v "Voltage";
          Modelica.SIunits.Current i[m]=plug_p.pin.i "Current";
          Modelica.SIunits.ComplexMagneticPotentialDifference V_m=port_p.V_m -
              port_n.V_m "Magnetic potential difference";
          Modelica.SIunits.MagneticPotentialDifference abs_V_m=
              Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
          Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
          Modelica.SIunits.ComplexMagneticFlux Phi=port_p.Phi "Magnetic flux";
          Modelica.SIunits.MagneticPotentialDifference abs_Phi=
              Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
          Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
          Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug_p(final m=m) "Positive plug"
                            annotation (Placement(transformation(
                origin={-100,100},
                extent={{-10,-10},{10,10}},
                rotation=180)));
          Modelica.Electrical.MultiPhase.Interfaces.NegativePlug plug_n(final m=m) "Negative plug"
                            annotation (Placement(transformation(
                origin={-100,-100},
                extent={{-10,-10},{10,10}},
                rotation=180)));
          Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort
            port_p "Positive complex magnetic port" annotation (Placement(
                transformation(extent={{90,90},{110,110}}, rotation=0)));
          Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort
            port_n "Negative complex magnetic port" annotation (Placement(
                transformation(extent={{90,-110},{110,-90}}, rotation=0)));
          parameter Integer m=3 "Number of phases";
          parameter Real effectiveTurns[m] "Effective number of turns";
          parameter Modelica.SIunits.Angle orientation[m] "Orientation of the resulting fundamental wave field phasor";
          Modelica_AddOn.Magnetic.FundamentalWave.Components.SinglePhaseElectroMagneticConverter
            singlePhaseElectroMagneticConverter[m](final effectiveTurns=
                effectiveTurns, final orientation=orientation)
            annotation (Placement(transformation(extent={{-8,-10},{12,10}})));
        equation
          connect(plug_p.pin, singlePhaseElectroMagneticConverter.pin_p)
            annotation (Line(
              points={{-100,100},{-8,100},{-8,10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(singlePhaseElectroMagneticConverter.pin_n, plug_n.pin)
            annotation (Line(
              points={{-8,-10},{-8,-100},{-100,-100}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(singlePhaseElectroMagneticConverter[1].port_p, port_p)
            annotation (Line(
              points={{12,10},{12,100},{100,100}},
              color={255,128,0},
              smooth=Smooth.None));
          for k in 2:m loop
            connect(singlePhaseElectroMagneticConverter[k - 1].port_n,
              singlePhaseElectroMagneticConverter[k].port_p);
          end for;
          connect(singlePhaseElectroMagneticConverter[m].port_n, port_n)
            annotation (Line(
              points={{12,-10},{12,-100},{100,-100}},
              color={255,128,0},
              smooth=Smooth.None));
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Ellipse(
                      extent={{-60,60},{58,0}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Ellipse(
                      extent={{-58,0},{60,-60}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Rectangle(
                      extent={{-60,60},{0,-60}},
                      lineColor={0,0,255},
                      pattern=LinePattern.None,
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(points={{100,-100},{94,-100},
                  {84,-98},{76,-94},{64,-86},{50,-72},{42,-58},{36,-40},{30,-18},{
                  30,0},{30,18},{34,36},{46,66},{62,84},{78,96},{90,100},{100,100}},
                  color={255,128,0}),Line(points={{0,60},{-100,60},{-100,100}},
                  color={0,0,255}),Line(points={{0,-60},{-100,-60},{-100,-98}},
                  color={0,0,255}),Text(
                      extent={{0,160},{0,120}},
                      lineColor={0,0,255},
                      fillColor={255,128,0},
                      fillPattern=FillPattern.Solid,
                      textString="%name")}),
            Documentation(info="<html>
<p>
Each phase <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/k.png\"> of an <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\"> phase winding has an effective number of turns, <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/effectiveTurns_k.png\"> and an respective winging angle <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/orientation_k.png\"> and a phase current <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/i_k.png\">.
</p>

<p>
The total complex magnetic potential difference of the multi phase winding is determined by:
</p>

<p>
&nbsp;&nbsp;<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/multiphaseconverter_vm.png\">
</p>

<p>
In this equation each contribution of a winding magneto motive force on the total complex magnetic potential difference is aligned with the respective orientation of the winding.
</p>

<p>
The voltages <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/v_k.png\"> induced in each winding depend on the cosines between the orientation of the winding and the angle of the complex magnetic flux. Additionally, the magnitudes of the induced voltages are proportional to the respective number of turns. This relationship can be modeled by means of</p>

<p>
&nbsp;&nbsp;<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/multiphaseconverter_phi.png\">
</p>

<p>for <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/k_in_1_m.png\"> and is also illustrated by the following figure:</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Fig:</b> Orientation of winding and location of complex magnetic flux</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Components/coupling.png\">
    </td>
  </tr>
</table>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.SinglePhaseElectroMagneticConverter\">SinglePhaseElectroMagneticConverter</a>
</p>
</html>"),  defaultComponentName="converter");
        end MultiPhaseElectroMagneticConverter;

        model Idle "Idle running branch"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPortElementary;
        equation
          Phi = Complex(0, 0);
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{0,60},{0,100}},
                      lineColor={0,0,255},
                      textString="%name"),Rectangle(
                      extent={{-100,40},{100,-40}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(points={{-100,0},{-40,0}},
                  color={255,128,0}),Line(points={{40,0},{100,0}}, color={255,128,0})}),
            Documentation(info="<html>
<p>
This is a simple idle running branch.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Short\">Short</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Crossing\">Crossing</a>
</p>

</html>"),  Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics={Line(points={{-100,0},{-60,0}}, color={
                  255,128,0}),Line(points={{60,0},{100,0}}, color={255,128,0}),Line(
                  points={{-60,0},{-40,2},{-18,6},{0,14},{12,26}}, color={255,128,0}),
                  Line(points={{60,0},{40,-2},{18,-6},{0,-14},{-12,-26}}, color={
                  255,128,0})}));
        end Idle;

        model Short "Short cut branch"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPort;
        equation
          connect(port_p, port_n) annotation (Line(points={{-100,0},{-1,0},{-1,0},{
                  100,0}}, color={255,128,0}));
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={
                Text(
                  extent={{0,60},{0,100}},
                  lineColor={0,0,255},
                  textString="%name"),
                Rectangle(
                  extent={{-100,40},{100,-40}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{-100,0},{100,0}}, color={255,128,0})}), Documentation(
                info="<html>
<p>
This is a simple short cut branch.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Idle\">Idle</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Crossing\">Crossing</a>
</p>

</html>"));
        end Short;

        model Crossing "Crossing of two branches"
          Interfaces.PositiveMagneticPort port_p1 "Positive port_p1 connected with port_p2"
            annotation (Placement(transformation(extent={{-110,90},{-90,110}})));
          Interfaces.PositiveMagneticPort port_p2 "Positive port_p2 connected with port_p1"
            annotation (Placement(transformation(extent={{90,-110},{110,-90}})));
          Interfaces.NegativeMagneticPort port_n1 "Negative port_n1 connected with port_n2"
            annotation (Placement(transformation(extent={{-110,-110},{-90,-90}})));
          Interfaces.NegativeMagneticPort port_n2 "Negative port_n2 connected with port_n1"
            annotation (Placement(transformation(extent={{90,90},{110,110}})));
        equation
          connect(port_p1, port_p2) annotation (Line(
              points={{-100,100},{-100,20},{0,20},{0,-20},{100,-20},{100,-100}},
              color={255,128,0},
              smooth=Smooth.None));
          connect(port_n1, port_n2) annotation (Line(
              points={{-100,-100},{-100,0},{100,0},{100,100}},
              color={255,128,0},
              smooth=Smooth.None));
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Text(
                      extent={{0,60},{0,100}},
                      lineColor={0,0,255},
                      textString="%name"),Rectangle(
                      extent={{-100,40},{100,-40}},
                      lineColor={255,255,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{100,100},{100,40},{-100,-40},{-100,-100}},
                      color={255,128,0},
                      smooth=Smooth.None),Line(
                      points={{-100,100},{-100,40},{100,-40},{100,-100}},
                      color={255,128,0},
                      smooth=Smooth.None)}),
            Documentation(info="<html>
<p>
This is a simple crossing of two branches. The ports <code>port_p1</code> and <code>port_p2</code> are connected, as well as <code>port_n1</code> and <code>port_n2</code>.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Idle\">Idle</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Short\">Short</a>
</p>

</html>"),  Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics));
        end Crossing;
        annotation (Documentation(info="<html>
<p>Basic components of the FundamentalWave library for modeling magnetic circuits. Machine specific components are
located at <a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components\">Machines.Components</a>.</p>
</html>"));
      end Components;

      package BasicMachines "Machine components and modelsElectric machine models based on FundamentalWave package"
        extends Modelica.Icons.Package;
        package AsynchronousInductionMachines "Asynchronous induction machines"
          extends Modelica.Icons.VariantsPackage;
          model AIM_SquirrelCage "Asynchronous induction machine with squirrel cage"
            extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialBasicInductionMachine(
              is(start=zeros(m)),
              Rs(start=0.03),
              Lssigma(start=3*(1 - sqrt(1 - 0.0667))/(2*pi*fsNominal)),
              final L0(d=2.0*Lm/m/effectiveStatorTurns^2, q=2.0*Lm/m/
                    effectiveStatorTurns^2),
              redeclare final Modelica.Electrical.Machines.Thermal.AsynchronousInductionMachines.ThermalAmbientAIMC
                thermalAmbient(final Tr=TrOperational),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortAIMC
                thermalPort,
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortAIMC
                internalThermalPort,
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.PowerBalanceAIMC
                powerBalance(final lossPowerRotorWinding=sum(rotorCage.resistor.resistor.LossPower),
                  final lossPowerRotorCore=0));
            parameter Modelica.SIunits.Inductance Lm(start=3*sqrt(1 - 0.0667)/(2*pi
                  *fsNominal)) "Stator main field inductance per phase" annotation (
               Dialog(tab="Nominal resistances and inductances", groupImage=
                    "modelica://Modelica_AddOn/Resources/Images/Electrical/Machines/IMC.png"));
            parameter Modelica.SIunits.Inductance Lrsigma(start=3*(1 - sqrt(1 -
                  0.0667))/(2*pi*fsNominal)) "Rotor leakage inductance of equivalent m phase winding w.r.t. stator side"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.SIunits.Resistance Rr(start=0.04) "Rotor resistance of equivalent m phase winding w.r.t. stator side"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.SIunits.Temperature TrRef(start=293.15) "Reference temperature of rotor resistance"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20r(start=0) "Temperature coefficient of rotor resistance at 20 degC"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.SIunits.Temperature TrOperational(start=293.15) "Operational temperature of rotor resistance"
                                                            annotation (Dialog(
                  group="Operational temperatures", enable=not useThermalPort));
            output Modelica.SIunits.Current ir[m]=rotorCage.i "Rotor cage currents";
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseCageWinding
              rotorCage(
              final Lsigma=Lrsigma,
              final effectiveTurns=effectiveStatorTurns,
              final useHeatPort=true,
              final RRef=Rr,
              final TRef=TrRef,
              final TOperational=TrRef,
              final m=m,
              final alpha20=alpha20r) "Symmetric rotor cage winding including resistances and stray inductances"
              annotation (Placement(transformation(extent={{-10,-40},{10,-20}},
                    rotation=0)));
          equation
            connect(rotorCage.heatPortWinding, internalThermalPort.heatPortRotorWinding)
              annotation (Line(
                points={{0,-40},{-40,-40},{-40,-90}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(airGap.port_rn, rotorCage.port_p) annotation (Line(
                points={{-10,-10},{-10,-30}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(airGap.port_rp, rotorCage.port_n) annotation (Line(
                points={{10,-10},{10,-30}},
                color={255,128,0},
                smooth=Smooth.None));
            annotation (
              defaultComponentName="aimc",
              Documentation(info="<html>
<p>
Resistances and stray inductances of the machine refer to an <code>m</code> phase stator. The symmetry of the stator and rotor is assumed. The machine models take the following loss effects into account:
</p>

<ul>
<li>heat losses in the temperature dependent stator winding resistances</li>
<li>heat losses in the temperature dependent cage resistances</li>
<li>friction losses</li>
<li>core losses (only eddy current losses, no hysteresis losses)</li>
<li>stray load losses</li>
</ul>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SlipRing\">AIM_SlipRing</a>,
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics));
          end AIM_SquirrelCage;

          model AIM_SlipRing "Asynchronous induction machine with slip ring rotor"
            parameter Integer mr(min=3) = m "Number of rotor phases";
            extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialBasicInductionMachine(
              is(start=zeros(m)),
              Rs(start=0.03),
              Lssigma(start=3*(1 - sqrt(1 - 0.0667))/(2*pi*fsNominal)),
              final L0(d=2.0*Lm/m/effectiveStatorTurns^2, q=2.0*Lm/m/
                    effectiveStatorTurns^2),
              redeclare final Modelica.Electrical.Machines.Thermal.AsynchronousInductionMachines.ThermalAmbientAIMS
                thermalAmbient(final Tr=TrOperational, final mr=mr),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortAIMS
                thermalPort(final mr=mr),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortAIMS
                internalThermalPort(final mr=mr),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.PowerBalanceAIMS
                powerBalance(
                final lossPowerRotorWinding=sum(rotor.resistor.resistor.LossPower),
                final lossPowerRotorCore=rotor.core.lossPower,
                final lossPowerBrush=0,
                final powerRotor=
                    Modelica.Electrical.MultiPhase.Functions.activePower(vr, ir)));
            Modelica.Electrical.MultiPhase.Interfaces.NegativePlug plug_rn(final m=
                  mr) "Negative plug of rotor" annotation (Placement(transformation(
                    extent={{-110,-50},{-90,-70}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug_rp(final m=
                  mr) "Positive plug of rotor" annotation (Placement(transformation(
                    extent={{-110,70},{-90,50}}, rotation=0)));
            parameter Modelica.SIunits.Inductance Lm(start=3*sqrt(1 - 0.0667)/(2*pi
                  *fsNominal)) "Stator main field inductance per phase" annotation (
               Dialog(tab="Nominal resistances and inductances", groupImage=
                    "modelica://Modelica_AddOn/Resources/Images/Electrical/Machines/IMS.png"));
            parameter Modelica.SIunits.Inductance Lrsigma(start=3*(1 - sqrt(1 -
                  0.0667))/(2*pi*fsNominal)) "Rotor leakage inductance per phase w.r.t. rotor side"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.SIunits.Inductance Lrzero=Lrsigma "Rotor zero inductance w.r.t. rotor side"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.SIunits.Resistance Rr(start=0.04) "Rotor resistance per phase w.r.t. rotor side"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.SIunits.Temperature TrRef(start=293.15) "Reference temperature of rotor resistance"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20r(start=0) "Temperature coefficient of rotor resistance at 20 degC"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            parameter Modelica.SIunits.Temperature TrOperational(start=293.15) "Operational temperature of rotor resistance"
                                                            annotation (Dialog(
                  group="Operational temperatures", enable=not useThermalPort));
            parameter Boolean useTurnsRatio(start=true) "Use TurnsRatio or calculate from locked-rotor voltage?";
            parameter Real TurnsRatio(final min=Modelica.Constants.small, start=1) "Effective number of stator turns / effective number of rotor turns"
              annotation (Dialog(enable=useTurnsRatio));
            parameter Modelica.SIunits.Voltage VsNominal(start=100) "Nominal stator voltage per phase"
              annotation (Dialog(enable=not useTurnsRatio));
            parameter Modelica.SIunits.Voltage VrLockedRotor(start=100*(2*pi*
                  fsNominal*Lm)/sqrt(Rs^2 + (2*pi*fsNominal*(Lm + Lssigma))^2)) "Locked rotor voltage per phase"
              annotation (Dialog(enable=not useTurnsRatio));
            parameter Modelica.Electrical.Machines.Losses.CoreParameters
              rotorCoreParameters(
              final m=3,
              PRef=0,
              VRef(start=1) = 1,
              wRef(start=1) = 1) "Rotor core loss parameter record, all quantities refer to rotor side"
              annotation (Dialog(tab="Losses"));
            output Modelica.SIunits.Voltage vr[mr]=plug_rp.pin.v - plug_rn.pin.v "Rotor instantaneous voltages";
            output Modelica.SIunits.Current ir[mr]=plug_rp.pin.i "Rotor instantaneous currents";
          protected
            final parameter Real internalTurnsRatio=if useTurnsRatio then
                TurnsRatio else VsNominal/VrLockedRotor*(2*pi*fsNominal*Lm)/sqrt(Rs
                ^2 + (2*pi*fsNominal*(Lm + Lssigma))^2);
          public
            Components.SymmetricMultiPhaseWinding rotor(
              final Lsigma=Lrsigma,
              final effectiveTurns=effectiveStatorTurns/internalTurnsRatio,
              final useHeatPort=true,
              final RRef=Rr,
              final TRef=TrRef,
              final TOperational=TrOperational,
              final Lzero=Lrsigma,
              final GcRef=rotorCoreParameters.GcRef,
              final m=mr,
              final alpha20=alpha20r) "Symmetric rotor winding including resistances, zero and stray inductances and zero core losses"
              annotation (Placement(transformation(
                  origin={0,-40},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            /* previously used: state selection, now commented
  FundamentalWave.Interfaces.StateSelector stateSelectorR(
    final m=m,
    final xi=ir,
    final gamma=0) "State selection of rotor currents"
    annotation (Placement(transformation(extent={{-10,-10},{10,10}},
        rotation=90,
        origin={-90,0})));
  */
          equation
            connect(rotor.plug_n, plug_rn) annotation (Line(points={{10,-50},{10,-60},
                    {-100,-60}}, color={0,0,255}));
            connect(rotor.heatPortCore, internalThermalPort.heatPortRotorCore)
              annotation (Line(
                points={{10,-36},{16,-36},{16,-36},{20,-36},{20,-80},{-40,-80},{-40,
                    -90}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(rotor.heatPortWinding, internalThermalPort.heatPortRotorWinding)
              annotation (Line(
                points={{10,-44},{20,-44},{20,-80},{-40,-80},{-40,-90}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(plug_rp, rotor.plug_p) annotation (Line(
                points={{-100,60},{-80,60},{-80,-50},{-10,-50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(airGap.port_rn, rotor.port_p) annotation (Line(
                points={{-10,-10},{-10,-30}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(airGap.port_rp, rotor.port_n) annotation (Line(
                points={{10,-10},{10,-30}},
                color={255,128,0},
                smooth=Smooth.None));
            annotation (
              defaultComponentName="aims",
              Icon(graphics={Line(points={{-100,50},{-100,20},{-60,20}}, color={0,0,
                        255}), Line(points={{-100,-50},{-100,-20},{-60,-20}}, color=
                       {0,0,255})}),
              Documentation(info="<html>
<p>
Resistances and stray inductances of the machine always refer to either stator or rotor. The symmetry of the stator and rotor is assumed. The number of stator and rotor phases may be different. The machine models take the following loss effects into account:
</p>

<ul>
<li>heat losses in the temperature dependent stator winding resistances</li>
<li>heat losses in the temperature dependent rotor winding resistances</li>
<li>friction losses</li>
<li>stator and rotor core losses (only eddy current losses, no hysteresis losses)</li>
<li>stray load losses</li>
</ul>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage\">AIM_SquirrelCage</a>,
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics));
          end AIM_SlipRing;
          annotation (Documentation(info="<html>
<p>This package provides squirrel cage and slip ring induction machine models.</p>

<h4>See also</h4>

<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines\">SynchronousInductionMachines</a>
</p>
</html>"));
        end AsynchronousInductionMachines;

        package SynchronousInductionMachines "Synchronous machines"
          extends Modelica.Icons.VariantsPackage;
          model SM_PermanentMagnet "Permanent magnet synchronous machine with optional damper cage"
            extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialBasicInductionMachine(
              is(start=zeros(m)),
              Rs(start=0.03),
              Lssigma(start=0.1/(2*pi*fsNominal)),
              final L0(d=2.0*Lmd/m/effectiveStatorTurns^2, q=2.0*Lmq/m/
                    effectiveStatorTurns^2),
              redeclare final Modelica.Electrical.Machines.Thermal.SynchronousInductionMachines.ThermalAmbientSMPM
                thermalAmbient(
                final useDamperCage=useDamperCage,
                final Tr=TrOperational,
                final Tpm=TpmOperational),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortSMPM
                thermalPort(final useDamperCage=useDamperCage),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortSMPM
                internalThermalPort(final useDamperCage=useDamperCage),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.PowerBalanceSMPM
                powerBalance(
                final lossPowerRotorWinding=damperCageLossPower,
                final lossPowerRotorCore=0,
                final lossPowerPermanentMagnet=permanentMagnet.lossPower));
            parameter Modelica.SIunits.Inductance Lmd(start=0.3/(2*pi*fsNominal)) "Stator main field inductance per phase, d-axis"
                                                               annotation (Dialog(
                  tab="Nominal resistances and inductances", groupImage=
                    "modelica://Modelica_AddOn/Resources/Images/Electrical/Machines/SMPM.png"));
            parameter Modelica.SIunits.Inductance Lmq(start=0.3/(2*pi*fsNominal)) "Stator main field inductance per phase, q-axis"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            // Rotor cage parameters
            parameter Boolean useDamperCage(start=true) "Enable/disable damper cage"
                                           annotation (Dialog(tab=
                    "Nominal resistances and inductances", group="Damper cage"));
            parameter Modelica.SIunits.Inductance Lrsigmad(start=0.05/(2*pi*
                  fsNominal)) "Rotor leakage inductance, d-axis, w.r.t. stator side"
                                                                     annotation (
                Dialog(
                tab="Nominal resistances and inductances",
                group="Damper cage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Inductance Lrsigmaq=Lrsigmad "Rotor leakage inductance, q-axis, w.r.t. stator side"
                                                                     annotation (
                Dialog(
                tab="Nominal resistances and inductances",
                group="Damper cage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Resistance Rrd(start=0.04) "Rotor resistance, d-axis, w.r.t. stator side"
                                                             annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="Damper cage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Resistance Rrq=Rrd "Rotor resistance , q-axis, w.r.t. stator side"
                                                              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="Damper cage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Temperature TrRef(start=293.15) "Reference temperature of damper resistances in d- and q-axis"
              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="Damper cage",
                enable=useDamperCage));
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20r(start=0) "Temperature coefficient of damper resistances in d- and q-axis"
              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="Damper cage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Voltage VsOpenCircuit(start=112.3) "Open circuit RMS voltage per phase @ fsNominal";
            final parameter Modelica.SIunits.Temperature TpmOperational=293.15 "Operational temperature of permanent magnet"
              annotation (Dialog(group="Operational temperatures"));
            parameter Modelica.SIunits.Temperature TrOperational(start=293.15) "Operational temperature of (optional) damper cage"
                                                                  annotation (
                Dialog(group="Operational temperatures", enable=not useThermalPort
                     and useDamperCage));
            parameter Modelica.Electrical.Machines.Losses.PermanentMagnetLossParameters
              permanentMagnetLossParameters(IRef(start=100), wRef(start=2*pi*
                    fsNominal/p)) "Permanent magnet loss parameter record"
              annotation (Dialog(tab="Losses"));
            Modelica.Blocks.Interfaces.RealOutput ir[2](
              start=zeros(2),
              each final quantity="ElectricCurrent",
              each final unit="A") if useDamperCage "Damper cage currents"
              annotation (Dialog(showStartAttribute=true));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Ground groundR "Ground of rotor magnetic circuit"
                                                 annotation (Placement(
                  transformation(extent={{-40,-30},{-20,-10}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Short short if not
              useDamperCage "Magnetic connection in case the damper cage is not present"
              annotation (Placement(transformation(
                  origin={10,-40},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.Components.SaliencyCageWinding
              rotorCage(
              final RRef(d=Rrd, q=Rrq),
              final Lsigma(d=Lrsigmad, q=Lrsigmaq),
              final effectiveTurns=sqrt(3.0/2.0)*effectiveStatorTurns,
              final useHeatPort=true,
              final TRef=TrRef,
              final alpha20=alpha20r,
              final TOperational=TrOperational) if useDamperCage "Symmetric rotor cage winding including resistances and stray inductances"
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={20,-40})));
            Components.PermanentMagnet permanentMagnet(
              final V_m=Complex(V_mPM, 0),
              final m=m,
              final permanentMagnetLossParameters=permanentMagnetLossParameters,
              final useHeatPort=true,
              final is=is) "Magnetic potential difference of permanent magnet"
              annotation (Placement(transformation(
                  origin={-10,-40},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
          protected
            final parameter Modelica.SIunits.MagneticPotentialDifference V_mPM=(2/
                pi)*sqrt(2)*(m/2)*VsOpenCircuit/effectiveStatorTurns/(Lmd/
                effectiveStatorTurns^2*2*pi*fsNominal) "Equivalent excitation magnetic potential difference";
            Modelica.Blocks.Interfaces.RealOutput damperCageLossPower(final
                quantity="Power", final unit="W") "Damper losses";
          equation
            connect(ir, rotorCage.i);
            connect(damperCageLossPower, rotorCage.lossPower);
            if not useDamperCage then
              damperCageLossPower = 0;
            end if;
            connect(permanentMagnet.port_p, airGap.port_rn) annotation (Line(
                points={{-10,-30},{-10,-10}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(permanentMagnet.support, airGap.support) annotation (Line(
                points={{-20,-40},{-50,-40},{-50,0},{-10,0}},
                color={0,0,0},
                smooth=Smooth.None));
            connect(permanentMagnet.heatPort, internalThermalPort.heatPortPermanentMagnet)
              annotation (Line(
                points={{-20,-30},{-40,-30},{-40,-90}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(permanentMagnet.flange, inertiaRotor.flange_b) annotation (Line(
                points={{0,-40},{0,-20},{90,-20},{90,0}},
                color={0,0,0},
                smooth=Smooth.None));
            connect(airGap.port_rp, rotorCage.port_n) annotation (Line(
                points={{10,-10},{10,-10},{10,-30},{10,-30},{10,-30},{20,-30},{20,-30}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(short.port_n, airGap.port_rp) annotation (Line(
                points={{10,-30},{10,-10}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(short.port_p, permanentMagnet.port_n) annotation (Line(
                points={{10,-50},{-10,-50}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(rotorCage.port_p, permanentMagnet.port_n) annotation (Line(
                points={{20,-50},{-10,-50}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(rotorCage.heatPortWinding, internalThermalPort.heatPortRotorWinding)
              annotation (Line(
                points={{30,-40},{40,-40},{40,-80},{-40,-80},{-40,-90}},
                color={191,0,0},
                smooth=Smooth.None));
            annotation (
              defaultComponentName="smpm",
              Icon(graphics={
                  Rectangle(
                    extent={{-130,10},{-100,-10}},
                    lineColor={0,0,0},
                    fillColor={0,255,0},
                    fillPattern=FillPattern.Solid),
                  Rectangle(
                    extent={{-100,10},{-70,-10}},
                    lineColor={0,0,0},
                    fillColor={255,0,0},
                    fillPattern=FillPattern.Solid),
                  Ellipse(extent={{-134,34},{-66,-34}}, lineColor={0,0,255})}),
              Documentation(info="<html>
<p>
Resistances and stray inductances of the machine refer to an <code>m</code> phase stator. The symmetry of the stator is assumed. For rotor asymmetries can be taken into account by different resistances and stray inductances in the d- and q-axis. The machine models take the following loss effects into account:
</p>

<ul>
<li>heat losses in the temperature dependent stator winding resistances</li>
<li>optional, when enabled: heat losses in the temperature dependent damper cage resistances</li>
<li>friction losses</li>
<li>core losses (only eddy current losses, no hysteresis losses)</li>
<li>stray load losses</li>
<li>permanent magnet losses</li>
</ul>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ElectricalExcited\">SM_ElectricalExcited</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ReluctanceRotor\">SM_ReluctanceRotor</a>,
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics));
          end SM_PermanentMagnet;

          model SM_ElectricalExcited "Electrical excited synchronous machine with optional damper cage"
            import Modelica_AddOn;
            extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialBasicInductionMachine(
              is(start=zeros(m)),
              Rs(start=0.03),
              Lssigma(start=0.1/(2*pi*fsNominal)),
              final L0(d=2.0*Lmd/m/effectiveStatorTurns^2, q=2.0*Lmq/m/
                    effectiveStatorTurns^2),
              redeclare final Modelica.Electrical.Machines.Thermal.SynchronousInductionMachines.ThermalAmbientSMEE
                thermalAmbient(
                final useDamperCage=useDamperCage,
                final Te=TeOperational,
                final Tr=TrOperational),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortSMEE
                thermalPort(final useDamperCage=useDamperCage),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortSMEE
                internalThermalPort(final useDamperCage=useDamperCage),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.PowerBalanceSMEE
                powerBalance(
                final lossPowerRotorWinding=damperCageLossPower,
                final powerExcitation=ve*ie,
                final lossPowerExcitation=excitation.resistor.LossPower,
                final lossPowerBrush=brush.lossPower,
                final lossPowerRotorCore=0));
            parameter Modelica.SIunits.Inductance Lmd(start=1.5/(2*pi*fsNominal)) "Stator main field inductance per phase, d-axis"
                                                               annotation (Dialog(
                  tab="Nominal resistances and inductances", groupImage=
                    "modelica://Modelica_AddOn/Resources/Images/Electrical/Machines/SMEE.png"));
            parameter Modelica.SIunits.Inductance Lmq(start=1.5/(2*pi*fsNominal)) "Stator main field inductance per phase, q-axis"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            // Rotor cage parameters
            parameter Boolean useDamperCage(start=true) "Enable/disable damper cage"
                                           annotation (Dialog(tab=
                    "Nominal resistances and inductances", group="DamperCage"));
            parameter Modelica.SIunits.Inductance Lrsigmad(start=0.05/(2*pi*
                  fsNominal)) "Rotor leakage inductance, d-axis, w.r.t. stator side"
                                                                     annotation (
                Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Inductance Lrsigmaq=Lrsigmad "Rotor leakage inductance, q-axis, w.r.t. stator side"
                                                                     annotation (
                Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Resistance Rrd(start=0.04) "Rotor resistance, d-axis, w.r.t. stator side"
                                                             annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Resistance Rrq=Rrd "Rotor resistance , q-axis, w.r.t. stator side"
                                                              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Temperature TrRef(start=293.15) "Reference temperature of damper resistances in d- and q-axis"
              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20r(start=0) "Temperature coefficient of damper resistances in d- and q-axis"
              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            // Operational temperature
            parameter Modelica.SIunits.Temperature TrOperational(start=293.15) "Operational temperature of (optional) damper cage"
                                                                  annotation (
                Dialog(group="Operational temperatures", enable=not useThermalPort
                     and useDamperCage));
            parameter Modelica.SIunits.Temperature TeOperational(start=293.15) "Operational excitation temperature"
                                                   annotation (Dialog(group=
                    "Operational temperatures", enable=not useThermalPort));
            // Excitation parameters
            parameter Modelica.SIunits.Voltage VsNominal(start=100) "Nominal stator voltage"
                                       annotation (Dialog(tab="Excitation"));
            parameter Modelica.SIunits.Current IeOpenCircuit(start=10) "Open circuit excitation current @ nominal voltage and frequency"
              annotation (Dialog(tab="Excitation"));
            parameter Modelica.SIunits.Resistance Re(start=2.5) "Warm excitation resistance"
                                           annotation (Dialog(tab="Excitation"));
            parameter Modelica.SIunits.Temperature TeRef(start=293.15) "Reference temperture of excitation resistance"
              annotation (Dialog(tab="Excitation"));
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20e(start=0) "Temperature coefficient of excitation resistance"
              annotation (Dialog(tab="Excitation"));
            parameter Real sigmae(
              min=0,
              max=1,
              start=0.025) "Stray fraction of total excitation inductance"
              annotation (Dialog(tab="Excitation"));
            parameter Modelica.Electrical.Machines.Losses.BrushParameters
              brushParameters "Brush loss parameter record"
              annotation (Dialog(tab="Losses"));
            output Modelica.SIunits.Voltage ve=pin_ep.v - pin_en.v "Excitation voltage";
            output Modelica.SIunits.Current ie=pin_ep.i "Excitation current";
            Modelica.Blocks.Interfaces.RealOutput ir[2](
              start=zeros(2),
              each final quantity="ElectricCurrent",
              each final unit="A") if useDamperCage "Damper cage currents"
              annotation (Dialog(showStartAttribute=true));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Short short if not
              useDamperCage "Magnetic connection in case the damper cage is not present"
              annotation (Placement(transformation(
                  origin={10,-40},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Components.SaliencyCageWinding rotorCage(
              final Lsigma(d=Lrsigmad, q=Lrsigmaq),
              final effectiveTurns=sqrt(3.0/2.0)*effectiveStatorTurns,
              final useHeatPort=true,
              final TRef=TrRef,
              final TOperational=TrOperational,
              final RRef(d=Rrd, q=Rrq),
              final alpha20=alpha20r) if useDamperCage "Symmetric rotor cage winding including resistances and stray inductances"
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={20,-40})));
            Components.SinglePhaseWinding excitation(
              final orientation=0,
              final RRef=Re,
              final TRef=TeRef,
              final Lsigma=Lesigma,
              final effectiveTurns=effectiveStatorTurns*turnsRatio*m/2,
              final useHeatPort=true,
              final TOperational=TeOperational,
              final alpha20=alpha20e) "Excitation winding including resistance and stray inductance"
              annotation (Placement(transformation(extent={{-30,-50},{-10,-30}},
                    rotation=0)));
            Modelica.Electrical.Analog.Interfaces.PositivePin pin_ep "Positive pin of excitation"
                                           annotation (Placement(transformation(
                    extent={{-110,70},{-90,50}}, rotation=0)));
            Modelica.Electrical.Analog.Interfaces.NegativePin pin_en "Negative pin of excitation"
                                           annotation (Placement(transformation(
                    extent={{-90,-50},{-110,-70}}, rotation=0)));
            Modelica.Electrical.Machines.Losses.DCMachines.Brush brush(final
                brushParameters=brushParameters, final useHeatPort=true)
              annotation (Placement(transformation(
                  extent={{10,-10},{-10,10}},
                  rotation=90,
                  origin={-80,40})));
          protected
            final parameter Real turnsRatio=sqrt(2)*VsNominal/(2*pi*fsNominal*Lmd*
                IeOpenCircuit) "Stator current / excitation current";
            final parameter Modelica.SIunits.Inductance Lesigma=Lmd*turnsRatio^2*3/
                2*sigmae/(1 - sigmae) "Leakage inductance of the excitation winding";
            Modelica.Blocks.Interfaces.RealOutput damperCageLossPower(final
                quantity="Power", final unit="W") "Damper losses";
          equation
            connect(ir, rotorCage.i);
            connect(damperCageLossPower, rotorCage.lossPower);
            if not useDamperCage then
              damperCageLossPower = 0;
            end if;
            connect(pin_en, excitation.pin_n) annotation (Line(points={{-100,-60},{
                    -100,-60},{-100,-50},{-30,-50}}, color={0,0,255}));
            connect(airGap.port_rn, excitation.port_p) annotation (Line(
                points={{-10,-10},{-10,-20},{-10,-20},{-10,-30}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(pin_ep, brush.p) annotation (Line(
                points={{-100,60},{-80,60},{-80,50}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(brush.n, excitation.pin_p) annotation (Line(
                points={{-80,30},{-80,-30},{-30,-30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(brush.heatPort, internalThermalPort.heatPortBrush) annotation (
                Line(
                points={{-70,50},{-40,50},{-40,-90}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(excitation.heatPortWinding, internalThermalPort.heatPortExcitation)
              annotation (Line(
                points={{-20,-50},{-20,-80},{-40,-80},{-40,-90}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(airGap.port_rp, rotorCage.port_n) annotation (Line(
                points={{10,-10},{10,-30},{20,-30}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(short.port_n, airGap.port_rp) annotation (Line(
                points={{10,-30},{10,-10}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(rotorCage.port_p, excitation.port_n) annotation (Line(
                points={{20,-50},{-10,-50}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(short.port_p, excitation.port_n) annotation (Line(
                points={{10,-50},{-10,-50}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(rotorCage.heatPortWinding, internalThermalPort.heatPortRotorWinding)
              annotation (Line(
                points={{30,-40},{40,-40},{40,-80},{-40,-80},{-40,-90}},
                color={191,0,0},
                smooth=Smooth.None));
            annotation (
              defaultComponentName="smee",
              Icon(graphics={
                  Ellipse(extent={{-134,34},{-66,-34}}, lineColor={0,0,255}),
                  Line(points={{-100,50},{-100,20},{-130,20},{-130,-4}}, color={0,0,
                        255}),
                  Line(points={{-130,-4},{-129,1},{-125,5},{-120,6},{-115,5},{-111,
                        1},{-110,-4}}, color={0,0,255}),
                  Line(points={{-110,-4},{-109,1},{-105,5},{-100,6},{-95,5},{-91,1},
                        {-90,-4}}, color={0,0,255}),
                  Line(points={{-90,-4},{-89,1},{-85,5},{-80,6},{-75,5},{-71,1},{-70,
                        -4}}, color={0,0,255}),
                  Line(points={{-100,-50},{-100,-20},{-70,-20},{-70,-2}}, color={0,
                        0,255})}),
              Documentation(info="<html>
<p>
The symmetry of the stator is assumed. For rotor asymmetries can be taken into account by different resistances and stray inductances in the d- and q-axis. The machine models take the following loss effects into account:
</p>

<ul>
<li>heat losses in the temperature dependent stator winding resistances</li>
<li>heat losses in the temperature dependent excitation winding resistance</li>
<li>optional, when enabled: heat losses in the temperature dependent damper cage resistances</li>
<li>brush losses in the excitation circuit</li>
<li>friction losses</li>
<li>core losses (only eddy current losses, no hysteresis losses)</li>
<li>stray load losses</li>
</ul>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_PermanentMagnet\">SM_PermanentMagnet</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ReluctanceRotor\">SM_ReluctanceRotor</a>,
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics));
          end SM_ElectricalExcited;

          model SM_ReluctanceRotor "Reluctance machine with optional damper cage"
            extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialBasicInductionMachine(
              is(start=zeros(m)),
              Rs(start=0.03),
              Lssigma(start=0.1/(2*pi*fsNominal)),
              final L0(d=2.0*Lmd/m/effectiveStatorTurns^2, q=2.0*Lmq/m/
                    effectiveStatorTurns^2),
              redeclare final Modelica.Electrical.Machines.Thermal.SynchronousInductionMachines.ThermalAmbientSMR
                thermalAmbient(final useDamperCage=useDamperCage, final Tr=
                    TrOperational),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortSMR
                thermalPort(final useDamperCage=useDamperCage),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.ThermalPortSMR
                internalThermalPort(final useDamperCage=useDamperCage),
              redeclare final Modelica.Electrical.Machines.Interfaces.InductionMachines.PowerBalanceSMR
                powerBalance(final lossPowerRotorWinding=damperCageLossPower,
                  final lossPowerRotorCore=0));
            parameter Modelica.SIunits.Temperature TrOperational(start=293.15) "Operational temperature of (optional) damper cage"
                                                                  annotation (
                Dialog(group="Operational temperatures", enable=not useThermalPort
                     and useDamperCage));
            parameter Modelica.SIunits.Inductance Lmd(start=2.9/(2*pi*fsNominal)) "Stator main field inductanceper phase, d-axis"
                                                              annotation (Dialog(
                  tab="Nominal resistances and inductances", groupImage=
                    "modelica://Modelica_AddOn/Resources/Images/Electrical/Machines/SMR.png"));
            parameter Modelica.SIunits.Inductance Lmq(start=0.9/(2*pi*fsNominal)) "Stator main field inductance per phase, q-axis"
              annotation (Dialog(tab="Nominal resistances and inductances"));
            // Rotor cage parameters
            parameter Boolean useDamperCage(start=true) "Enable/disable damper cage"
                                           annotation (Dialog(tab=
                    "Nominal resistances and inductances", group="DamperCage"));
            parameter Modelica.SIunits.Inductance Lrsigmad(start=0.05/(2*pi*
                  fsNominal)) "Rotor leakage inductance, d-axis, w.r.t. stator side"
                                                                     annotation (
                Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Inductance Lrsigmaq=Lrsigmad "Rotor leakage inductance, q-axis, w.r.t. stator side"
                                                                     annotation (
                Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Resistance Rrd(start=0.04) "Rotor resistance, d-axis, w.r.t. stator side"
                                                             annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Resistance Rrq=Rrd "Rotor resistance , q-axis, w.r.t. stator side"
                                                              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.SIunits.Temperature TrRef(start=293.15) "Reference temperature of damper resistances in d- and q-axis"
              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20r(start=0) "Temperature coefficient of damper resistances in d- and q-axis"
              annotation (Dialog(
                tab="Nominal resistances and inductances",
                group="DamperCage",
                enable=useDamperCage));
            Modelica.Blocks.Interfaces.RealOutput ir[2](
              start=zeros(2),
              each final quantity="ElectricCurrent",
              each final unit="A") if useDamperCage "Damper cage currents"
              annotation (Dialog(showStartAttribute=true));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Ground groundR "Ground of rotor magnetic circuit"
                                                 annotation (Placement(
                  transformation(extent={{-40,-30},{-20,-10}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Short short if not
              useDamperCage "Magnetic connection in case the damper cage is not present"
              annotation (Placement(transformation(
                  origin={10,-40},
                  extent={{10,10},{-10,-10}},
                  rotation=270)));
            Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.Components.SaliencyCageWinding
              rotorCage(
              final RRef(d=Rrd, q=Rrq),
              final Lsigma(d=Lrsigmad, q=Lrsigmaq),
              final effectiveTurns=sqrt(3.0/2.0)*effectiveStatorTurns,
              final useHeatPort=true,
              final TRef=TrRef,
              final alpha20=alpha20r,
              final TOperational=TrOperational) if useDamperCage "Symmetric rotor cage winding including resistances and stray inductances"
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=90,
                  origin={20,-40})));
          protected
            Modelica.Blocks.Interfaces.RealOutput damperCageLossPower(final
                quantity="Power", final unit="W") "Damper losses";
          equation
            connect(ir, rotorCage.i);
            connect(damperCageLossPower, rotorCage.lossPower);
            if not useDamperCage then
              damperCageLossPower = 0;
            end if;
            connect(rotorCage.port_n, airGap.port_rp) annotation (Line(
                points={{20,-30},{20,-30},{10,-30},{10,-30},{10,-30},{10,-10},{10,-10}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(short.port_n, airGap.port_rp) annotation (Line(
                points={{10,-30},{10,-10}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(rotorCage.port_p, airGap.port_rn) annotation (Line(
                points={{20,-50},{-10,-50},{-10,-50},{-10,-50},{-10,-10},{-10,-10}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(short.port_p, airGap.port_rn) annotation (Line(
                points={{10,-50},{-10,-50},{-10,-10}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(rotorCage.heatPortWinding, internalThermalPort.heatPortRotorWinding)
              annotation (Line(
                points={{30,-40},{40,-40},{40,-80},{-40,-80},{-40,-90}},
                color={191,0,0},
                smooth=Smooth.None));
            annotation (
              defaultComponentName="smr",
              Icon(graphics={
                  Rectangle(extent={{-130,10},{-100,-10}}, lineColor={0,0,0}),
                  Rectangle(extent={{-100,10},{-70,-10}}, lineColor={0,0,0}),
                  Ellipse(extent={{-134,34},{-66,-34}}, lineColor={0,0,255})}),
              Documentation(info="<html>
<p>
The symmetry of the stator is assumed. For rotor asymmetries can be taken into account by different resistances and stray inductances in the d- and q-axis. The machine models take the following loss effects into account:
</p>

<ul>
<li>heat losses in the temperature dependent stator winding resistances</li>
<li>optional, when enabled: heat losses in the temperature dependent damper cage resistances</li>
<li>friction losses</li>
<li>core losses (only eddy current losses, no hysteresis losses)</li>
<li>stray load losses</li>
</ul>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_ElectricalExcited\">SM_ElectricalExcited</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.SynchronousInductionMachines.SM_PermanentMagnet\">SM_PermanentMagnet</a>,
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics));
          end SM_ReluctanceRotor;
          annotation (Documentation(info="<html>
<p>This package contains various synchronous induction machine models.</p>

<h4>See also</h4>

<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines\">AsynchronousInductionMachines</a>
</p>
</html>"));
        end SynchronousInductionMachines;

        package Components "Components specially for electric machines"
          extends Modelica.Icons.Package;
          model SinglePhaseWinding "Symmetric winding model coupling electrical and magnetic domain"
            Modelica.Electrical.Analog.Interfaces.PositivePin pin_p "Positive pin"
              annotation (Placement(transformation(
                  origin={-100,100},
                  extent={{-10,-10},{10,10}},
                  rotation=180)));
            Modelica.Electrical.Analog.Interfaces.NegativePin pin_n "Negative pin"
              annotation (Placement(transformation(
                  origin={-100,-100},
                  extent={{-10,-10},{10,10}},
                  rotation=180)));
            Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort
              port_n "Negative complex magnetic port" annotation (Placement(
                  transformation(extent={{90,-110},{110,-90}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort
              port_p "Positive complex magnetic port" annotation (Placement(
                  transformation(extent={{90,90},{110,110}}, rotation=0)));
            parameter Boolean useHeatPort=false "Enable / disable (=fixed temperatures) thermal port"
              annotation (Evaluate=true);
            parameter Modelica.SIunits.Resistance RRef "Winding resistance per phase at TRef";
            parameter Modelica.SIunits.Temperature TRef(start=293.15) "Reference temperature of winding";
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20(start=0) "Temperature coefficient of winding at 20 degC";
            final parameter Modelica.SIunits.LinearTemperatureCoefficient alphaRef=
                Modelica.Electrical.Machines.Thermal.convertAlpha(
                      alpha20,
                      TRef,
                      293.15);
            parameter Modelica.SIunits.Temperature TOperational(start=293.15) "Operational temperature of winding"
              annotation (Dialog(enable=not useHeatPort));
            parameter Modelica.SIunits.Inductance Lsigma "Winding stray inductance per phase";
            parameter Real effectiveTurns=1 "Effective number of turns per phase";
            parameter Modelica.SIunits.Angle orientation "Orientation of the resulting fundamental wave field phasor";
            Modelica.SIunits.Voltage v=pin_p.v - pin_n.v "Voltage";
            Modelica.SIunits.Current i=pin_p.i "Current";
            Modelica.SIunits.ComplexMagneticPotentialDifference V_m=port_p.V_m -
                port_n.V_m "Complex magnetic potential difference";
            Modelica.SIunits.MagneticPotentialDifference abs_V_m=
                Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
            Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
            Modelica.SIunits.ComplexMagneticFlux Phi=port_p.Phi "Complex magnetic flux";
            Modelica.SIunits.MagneticPotentialDifference abs_Phi=
                Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
            Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
            Modelica.Electrical.Analog.Basic.Resistor resistor(
              final useHeatPort=useHeatPort,
              final R=RRef,
              final T_ref=TRef,
              final alpha=alphaRef,
              final T=TOperational) annotation (Placement(transformation(
                  origin={-10,70},
                  extent={{10,10},{-10,-10}},
                  rotation=90)));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.SinglePhaseElectroMagneticConverter
              electroMagneticConverter(final effectiveTurns=effectiveTurns, final
                orientation=orientation) "Winding" annotation (Placement(
                  transformation(extent={{-10,-10},{10,10}}, rotation=0)));
            Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPortWinding if
              useHeatPort "Heat ports of winding resistor"
              annotation (Placement(transformation(extent={{-10,-110},{10,-90}})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Reluctance
              reluctance(final R_m(d=effectiveTurns^2/Lsigma, q=effectiveTurns^2/
                    Lsigma)) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={30,0})));
          equation
            connect(pin_p, resistor.p) annotation (Line(points={{-100,100},{-10,100},
                    {-10,80}}, color={0,0,255}));
            connect(electroMagneticConverter.pin_n, pin_n) annotation (Line(points=
                    {{-10,-10},{-10,-100},{-100,-100}}, color={0,0,255}));
            connect(electroMagneticConverter.port_p, port_p) annotation (Line(
                  points={{10,10},{10,100},{100,100}}, color={255,128,0}));
            connect(electroMagneticConverter.port_n, port_n) annotation (Line(
                  points={{10,-10},{10,-100},{100,-100}}, color={255,128,0}));
            connect(heatPortWinding, resistor.heatPort) annotation (Line(
                points={{0,-100},{0,-60},{-40,-60},{-40,70},{-20,70}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(resistor.n, electroMagneticConverter.pin_p) annotation (Line(
                points={{-10,60},{-10,10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(electroMagneticConverter.port_p, reluctance.port_p) annotation (
               Line(
                points={{10,10},{30,10}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(electroMagneticConverter.port_n, reluctance.port_n) annotation (
               Line(
                points={{10,-10},{30,-10}},
                color={255,128,0},
                smooth=Smooth.None));
            annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                      -100},{100,100}}), graphics={
                  Rectangle(
                    extent={{-100,60},{100,-60}},
                    lineColor={0,0,255},
                    pattern=LinePattern.None,
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Line(points={{100,-100},{94,-100},{84,-98},{76,-94},{64,-86},{50,
                        -72},{42,-58},{36,-40},{30,-18},{30,0},{30,18},{34,36},{46,
                        66},{62,84},{78,96},{90,100},{100,100}}, color={255,128,0}),
                  Line(points={{40,60},{-100,60},{-100,100}}, color={0,0,255}),
                  Line(points={{40,-60},{-100,-60},{-100,-98}}, color={0,0,255}),
                  Line(points={{40,60},{100,20},{40,-20},{0,-20},{-40,0},{0,20},{40,
                        20},{100,-20},{40,-60}}, color={0,0,255}),
                  Text(
                    extent={{0,160},{0,120}},
                    lineColor={0,0,255},
                    fillColor={255,128,0},
                    fillPattern=FillPattern.Solid,
                    textString="%name")}), Documentation(info="<html>
<p>
The single phase winding consists of a
<a href=\"modelica://Modelica.Electrical.Analog.Basic.Resistor\">resistor</a>, a symmetrical
<a href=\"modelica://Modelica.Electrical.Analog.Basic.Inductor\">stray inductor</a> and a
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.SinglePhaseElectroMagneticConverter\">single phase electromagnetic coupling</a>.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">SymmetricMultiPhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseCageWinding\">SymmetricMultiPhaseCageWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SaliencyCageWinding\">SaliencyCageWinding</a>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap\">RotorSaliencyAirGap</a>
</p>
</html>"));
          end SinglePhaseWinding;

          model SymmetricMultiPhaseWinding "Symmetric winding model coupling electrical and magnetic domain"
            // Orientation changed
            Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug_p(final m=m) "Positive plug"
                              annotation (Placement(transformation(
                  origin={-100,100},
                  extent={{-10,-10},{10,10}},
                  rotation=180)));
            Modelica.Electrical.MultiPhase.Interfaces.NegativePlug plug_n(final m=m) "Negative plug"
                              annotation (Placement(transformation(
                  origin={-100,-100},
                  extent={{-10,-10},{10,10}},
                  rotation=180)));
            Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort
              port_n "Negative complex magnetic port" annotation (Placement(
                  transformation(extent={{90,-110},{110,-90}}, rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort
              port_p "Positive complex magnetic port" annotation (Placement(
                  transformation(extent={{90,90},{110,110}}, rotation=0)));
            parameter Integer m=3 "Number of phases";
            parameter Boolean useHeatPort=false "Enable / disable (=fixed temperatures) thermal port"
              annotation (Evaluate=true);
            // Resistor model
            parameter Modelica.SIunits.Resistance RRef "Winding resistance per phase at TRef";
            parameter Modelica.SIunits.Temperature TRef(start=293.15) "Reference temperature of winding";
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20(start=0) "Temperature coefficient of winding at 20 degC";
            final parameter Modelica.SIunits.LinearTemperatureCoefficient alphaRef=
                Modelica.Electrical.Machines.Thermal.convertAlpha(
                      alpha20,
                      TRef,
                      293.15);
            parameter Modelica.SIunits.Temperature TOperational(start=293.15) "Operational temperature of winding"
              annotation (Dialog(enable=not useHeatPort));
            parameter Modelica.SIunits.Inductance Lsigma "Winding stray inductance per phase";
            parameter Modelica.SIunits.Inductance Lzero "Zero sequence inductance of winding";
            parameter Real effectiveTurns=1 "Effective number of turns per phase";
            parameter Modelica.SIunits.Conductance GcRef "Electrical reference core loss reluctance";
            Modelica.SIunits.Voltage v[m]=plug_p.pin.v - plug_n.pin.v "Voltage";
            Modelica.SIunits.Current i[m]=plug_p.pin.i "Current";
            Modelica.SIunits.ComplexMagneticPotentialDifference V_m=port_p.V_m -
                port_n.V_m "Complex magnetic potential difference";
            Modelica.SIunits.MagneticPotentialDifference abs_V_m=
                Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
            Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
            Modelica.SIunits.ComplexMagneticFlux Phi=port_p.Phi "Complex magnetic flux";
            Modelica.SIunits.MagneticPotentialDifference abs_Phi=
                Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
            Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
            Modelica_AddOn.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
              electroMagneticConverter(
              final m=m,
              final effectiveTurns=fill(effectiveTurns, m),
              final orientation=
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m)) "Symmetric winding"
                                  annotation (Placement(transformation(extent={{-10,
                      -40},{10,-20}}, rotation=0)));
            Modelica.Electrical.MultiPhase.Basic.ZeroInductor zeroInductor(final m=
                  m, final Lzero=Lzero) "Zero sequence inductance of winding"
              annotation (Placement(transformation(
                  origin={-20,30},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor(
              final m=m,
              final useHeatPort=useHeatPort,
              final R=fill(RRef, m),
              final T_ref=fill(TRef, m),
              final alpha=fill(alphaRef, m),
              final T=fill(TOperational, m)) "Winding resistor" annotation (
                Placement(transformation(
                  origin={-20,70},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPortWinding[m] if
                 useHeatPort "Heat ports of winding resistors"
              annotation (Placement(transformation(extent={{-50,-110},{-30,-90}})));
            Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPortCore if
              useHeatPort "Heat ports of winding resistor"
              annotation (Placement(transformation(extent={{30,-110},{50,-90}})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.EddyCurrent core(
                final useHeatPort=useHeatPort, final G=(m/2)*GcRef*effectiveTurns^2) "Core loss model (currently eddy currents only)"
                                                               annotation (
                Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={50,-40})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Reluctance
              strayReluctance(final R_m(d=m*effectiveTurns^2/2/Lsigma, q=m*
                    effectiveTurns^2/2/Lsigma)) "Stray reluctance equivalent to ideally coupled stray inductances"
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=270,
                  origin={80,30})));
          equation
            connect(plug_p, resistor.plug_p) annotation (Line(points={{-100,100},{-20,
                    100},{-20,80}}, color={0,0,255}));
            connect(resistor.plug_n, zeroInductor.plug_p) annotation (Line(points={
                    {-20,60},{-20,55},{-20,50},{-20,40}}, color={0,0,255}));
            connect(zeroInductor.plug_n, electroMagneticConverter.plug_p)
              annotation (Line(points={{-20,20},{-20,-20},{-10,-20}}, color={0,0,
                    255}));
            connect(electroMagneticConverter.plug_n, plug_n) annotation (Line(
                  points={{-10,-40},{-10,-40},{-100,-40},{-100,-100}}, color={0,0,
                    255}));
            connect(electroMagneticConverter.port_p, port_p) annotation (Line(
                  points={{10,-20},{10,100},{100,100}}, color={255,128,0}));
            connect(resistor.heatPort, heatPortWinding) annotation (Line(
                points={{-30,70},{-40,70},{-40,-100}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(electroMagneticConverter.port_n, core.port_p) annotation (Line(
                points={{10,-40},{40,-40}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(core.port_n, port_n) annotation (Line(
                points={{60,-40},{100,-40},{100,-100}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(core.heatPort, heatPortCore) annotation (Line(
                points={{40,-50},{40,-100}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(strayReluctance.port_n, core.port_n) annotation (Line(
                points={{80,20},{80,-40},{60,-40}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(strayReluctance.port_p, electroMagneticConverter.port_p)
              annotation (Line(
                points={{80,40},{80,100},{10,100},{10,-20}},
                color={255,128,0},
                smooth=Smooth.None));
            annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                      -100},{100,100}}), graphics={
                  Rectangle(
                    extent={{-100,60},{100,-60}},
                    lineColor={0,0,255},
                    pattern=LinePattern.None,
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Line(points={{100,-100},{94,-100},{84,-98},{76,-94},{64,-86},{50,
                        -72},{42,-58},{36,-40},{30,-18},{30,0},{30,18},{34,36},{46,
                        66},{62,84},{78,96},{90,100},{100,100}}, color={255,128,0}),
                  Line(points={{40,60},{-100,60},{-100,100}}, color={0,0,255}),
                  Line(points={{40,-60},{-100,-60},{-100,-98}}, color={0,0,255}),
                  Line(points={{40,60},{100,20},{40,-20},{0,-20},{-40,0},{0,20},{40,
                        20},{100,-20},{40,-60}}, color={0,0,255}),
                  Text(
                    extent={{0,160},{0,120}},
                    lineColor={0,0,255},
                    fillColor={255,128,0},
                    fillPattern=FillPattern.Solid,
                    textString="%name")}), Documentation(info="<html>
<p>
The symmetrical multi phase winding consists of a symmetrical winding
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.Resistor\">resistor</a>, a
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.MutualInductor\">zero</a> and
<a href=\"modelica://Modelica.Electrical.MultiPhase.Basic.Inductor\">stray inductor</a> as well as a symmetrical
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter\">multi phase electromagnetic coupling</a> and a
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.EddyCurrent\">core loss</a> model including
heat <a href=\"modelica://Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a\">port</a>.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">SinglePhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseCageWinding\">SymmetricMultiPhaseCageWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SaliencyCageWinding\">SaliencyCageWinding</a>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap\">RotorSaliencyAirGap</a>
</p>
</html>"));
          end SymmetricMultiPhaseWinding;

          model RotorSaliencyAirGap "Air gap model with rotor saliency"
            import Modelica.Constants.pi;
            Interfaces.PositiveMagneticPort port_sp "Positive complex magnetic stator port"
                                                      annotation (Placement(
                  transformation(extent={{-110,-110},{-90,-90}}, rotation=0)));
            Interfaces.NegativeMagneticPort port_sn "Negative complex magnetic stator port"
                                                      annotation (Placement(
                  transformation(extent={{-110,90},{-90,110}}, rotation=0)));
            Interfaces.PositiveMagneticPort port_rp "Positive complex magnetic rotor port"
                                                     annotation (Placement(
                  transformation(extent={{90,90},{110,110}}, rotation=0)));
            Interfaces.NegativeMagneticPort port_rn "Negative complex magnetic rotor port"
                                                     annotation (Placement(
                  transformation(extent={{90,-110},{110,-90}}, rotation=0)));
            Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a "Flange of the rotor"
                                    annotation (Placement(transformation(extent={{-10,
                      110},{10,90}}, rotation=0)));
            Modelica.Mechanics.Rotational.Interfaces.Flange_a support "Support at which the reaction torque is acting"
                                                               annotation (
                Placement(transformation(extent={{-10,-110},{10,-90}}, rotation=0)));
            parameter Integer p "Number of pole pairs";
            parameter Modelica_AddOn.Magnetic.FundamentalWave.Types.SalientInductance
                                                                              L0(d(
                  start=1), q(start=1)) "Salient inductance of a single unchorded coil w.r.t. the fundamental wave";
            final parameter Modelica_AddOn.Magnetic.FundamentalWave.Types.SalientReluctance
                                                                              R_m(d=
                 1/L0.d, q=1/L0.q) "Reluctance of the air gap model";
            // Complex phasors of magnetic potential differences
            Modelica.SIunits.ComplexMagneticPotentialDifference V_mss "Complex magnetic potential difference of stator w.r.t. stator reference frame";
            Modelica.SIunits.ComplexMagneticPotentialDifference V_msr "Complex magnetic potential difference of stator w.r.t. rotor reference frame";
            Modelica.SIunits.ComplexMagneticPotentialDifference V_mrr "Complex magnetic potential difference of rotor w.r.t. rotor reference frame";
            // Modelica.SIunits.ComplexMagneticPotentialDifference V_mrs
            //   "Complex magnetic potential difference of rotor w.r.t. stator reference frame";
            // Complex phasors of magnetic fluxes
            Modelica.SIunits.ComplexMagneticFlux Phi_ss "Complex magnetic potential difference of stator w.r.t. stator reference frame";
            Modelica.SIunits.ComplexMagneticFlux Phi_sr "Complex magnetic potential difference of stator w.r.t. rotor reference frame";
            Modelica.SIunits.ComplexMagneticFlux Phi_rr "Complex magnetic potential difference of rotor w.r.t. rotor reference frame";
            // Modelica.SIunits.ComplexMagneticFlux Phi_rs
            //   "Complex magnetic potential difference of rotor w.r.t. stator reference frame";
            // Electrical torque and mechanical angle
            Modelica.SIunits.Torque tauElectrical "Electrical torque";
            // Modelica.SIunits.Torque tauTemp "Electrical torque";
            Modelica.SIunits.Angle gamma "Electrical angle between rotor and stator";
            Complex rotator "Equivalent vector representation of orientation";
          equation
            // Stator flux into positive stator port
            port_sp.Phi = Phi_ss;
            // Balance of stator flux
            port_sp.Phi + port_sn.Phi = Complex(0, 0);
            // Rotor flux into positive rotor port
            port_rp.Phi = Phi_rr;
            // Balance of rotor flux
            port_rp.Phi + port_rn.Phi = Complex(0, 0);
            // Magneto motive force of stator
            port_sp.V_m - port_sn.V_m = V_mss;
            // Magneto motive force of stator
            port_rp.V_m - port_rn.V_m = V_mrr;
            // Transformation of fluxes between stator and rotor fixed frame, if wanted
            // Phi_rs.re = + Phi_rr.re * cos(gamma) - Phi_rr.im * sin(gamma);
            // Phi_rs.im = + Phi_rr.re * sin(gamma) + Phi_rr.im * cos(gamma);
            // Alternative transformation
            // Phi_rr.re = + Phi_rs.re * cos(gamma) + Phi_rs.im * sin(gamma);
            // Phi_rr.im = - Phi_rs.re * sin(gamma) + Phi_rs.im * cos(gamma);
            // Transformed stator flux is not needed
            // Phi_sr.re = + Phi_ss.re * cos(gamma) + Phi_ss.im * sin(gamma);
            // Phi_sr.im = - Phi_ss.re * sin(gamma) + Phi_ss.im * cos(gamma);
            Phi_sr = Phi_ss*Modelica.ComplexMath.conj(rotator);
            // Alternative transformation
            // Phi_ss.re = + Phi_sr.re * cos(gamma) - Phi_sr.im * sin(gamma);
            // Phi_ss.im = + Phi_sr.re * sin(gamma) + Phi_sr.im * cos(gamma);
            // Stator flux w.r.t. the rotor fixed frame and rotor flux are equal
            Phi_sr = Phi_rr;
            // Transformation of magnetic potential difference between stator and rotor fixed frame
            // V_mrs.re = + V_mrr.re * cos(gamma) - V_mrr.im * sin(gamma);
            // V_mrs.im = + V_mrr.re * sin(gamma) + V_mrr.im * cos(gamma);
            // V_mrr.re = + V_mrs.re * cos(gamma) + V_mrs.im * sin(gamma);
            // V_mrr.im = - V_mrs.re * sin(gamma) + V_mrs.im * cos(gamma);
            // V_msr.re = + V_mss.re * cos(gamma) + V_mss.im * sin(gamma);
            // V_msr.im = - V_mss.re * sin(gamma) + V_mss.im * cos(gamma);
            V_msr = V_mss*Modelica.ComplexMath.conj(rotator);
            // V_msr.re = + V_mss.re * cos(gamma) + V_mss.im * sin(gamma);
            // V_msr.im = - V_mss.re * sin(gamma) + V_mss.im * cos(gamma);
            // Local balance of magneto motive force
            (pi/2.0)*(V_mrr.re + V_msr.re) = Phi_rr.re*R_m.d;
            (pi/2.0)*(V_mrr.im + V_msr.im) = Phi_rr.im*R_m.q;
            // Torque
            tauElectrical = -(pi*p/2.0)*(Phi_ss.im*V_mss.re - Phi_ss.re*V_mss.im);
            flange_a.tau = -tauElectrical;
            support.tau = tauElectrical;
            // Electrical angle between stator and rotor
            gamma = p*(flange_a.phi - support.phi);
            rotator = Modelica.ComplexMath.exp(Complex(0, gamma));
            annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                      -100},{100,100}}), graphics={
                  Ellipse(
                    extent={{-100,100},{100,-100}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Line(points={{-100,90},{-100,60},{-80,60}}, color={255,128,0}),
                  Line(points={{-100,-90},{-100,-60},{-80,-60}}, color={255,128,0}),
                  Line(points={{40,60},{100,60},{100,90}}, color={255,128,0}),
                  Line(points={{40,-60},{100,-60},{100,-90}}, color={255,128,0}),
                  Ellipse(
                    extent={{-60,80},{60,-80}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Line(points={{0,80},{0,90}}, color={0,0,0})}), Documentation(info=
                   "<html>
<p>
This salient air gap model can be used for machines with uniform airgaps and for machines with rotor saliencies. The air gap model is not symmetrical towards stator and rotor since it is assumed the saliency always refers to the rotor. The saliency of the air gap is represented by a main field inductance in the d- and q-axis.
</p>

<p>
For the mechanical interaction of the air gap model with the stator and the rotor it is equipped with to
<a href=\"modelica://Modelica.Mechanics.Rotational.Interfaces.Flange_a\">rotational connectors</a>. The torques acting on both connectors have the same absolute values but different signs. The difference between the stator and the rotor angle,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/gamma.png\">, is required for the transformation of the magnetic stator quantities to the rotor side.</p>

<p>
The air gap model has two magnetic stator and two magnetic rotor
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.MagneticPort\">ports</a>. The magnetic potential difference and the magnetic flux of the stator (superscript s) are transformed to the rotor fixed reference frame (superscript r). The effective reluctances of the main field with respect to the d- and q-axis are considered then in the balance equations
</p>

<p>
&nbsp;&nbsp;<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Machines/Components/airgap.png\">
</p>

<p>
according to the following figure.
</p>
<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Fig:</b> Magnetic equivalent circuit of the air gap model</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Machines/Components/airgap_phasors.png\">
    </td>
  </tr>
</table>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">SinglePhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">SymmetricMultiPhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseCageWinding\">SymmetricMultiPhaseCageWinding</a>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SaliencyCageWinding\">SaliencyCageWinding</a>
</p>

</html>"));
          end RotorSaliencyAirGap;

          model SymmetricMultiPhaseCageWinding "Symmetrical rotor cage"
            import Modelica.Constants.pi;
            import Modelica;
            import Modelica_AddOn;
            extends Interfaces.PartialTwoPortExtended;
            parameter Integer m=3 "Number of phases";
            parameter Boolean useHeatPort=false "Enable / disable (=fixed temperatures) thermal port"
              annotation (Evaluate=true);
            parameter Modelica.SIunits.Resistance RRef "Winding resistance per phase at TRef";
            parameter Modelica.SIunits.Temperature TRef(start=293.15) "Reference temperature of winding";
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20(start=0) "Temperature coefficient of winding at 20 degC";
            final parameter Modelica.SIunits.LinearTemperatureCoefficient alphaRef=
                Modelica.Electrical.Machines.Thermal.convertAlpha(
                      alpha20,
                      TRef,
                      293.15);
            parameter Modelica.SIunits.Temperature TOperational(start=293.15) "Operational temperature of winding"
              annotation (Dialog(enable=not useHeatPort));
            parameter Modelica.SIunits.Inductance Lsigma "Cage stray inductance";
            parameter Real effectiveTurns=1 "Effective number of turns";
            Modelica.SIunits.Current i[m]=electroMagneticConverter.i "Cage currents";
            Modelica_AddOn.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
              electroMagneticConverter(
              final m=m,
              final effectiveTurns=fill(effectiveTurns, m),
              final orientation=
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m)) "Symmetric winding"
                                  annotation (Placement(transformation(
                  origin={0,-10},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor(
              final useHeatPort=useHeatPort,
              final m=m,
              final R=fill(RRef, m),
              final T_ref=fill(TRef, m),
              final alpha=fill(alphaRef, m),
              final T=fill(TRef, m)) annotation (Placement(transformation(
                  origin={-20,-50},
                  extent={{10,10},{-10,-10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                Placement(transformation(extent={{30,-30},{50,-10}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={70,-20},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPortWinding if
              useHeatPort "Heat ports of winding resistor"
              annotation (Placement(transformation(extent={{-10,-110},{10,-90}})));
            Modelica.Thermal.HeatTransfer.Components.ThermalCollector
              thermalCollector(final m=m) if useHeatPort "Connector of thermal rotor resistance heat ports"
              annotation (Placement(transformation(extent={{-50,-90},{-30,-70}})));
            Modelica.Electrical.MultiPhase.Basic.Star starAuxiliary(final m=m)
              annotation (Placement(transformation(extent={{30,-90},{50,-70}},
                    rotation=0)));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Reluctance
              strayReluctance(final R_m(d=m*effectiveTurns^2/2/Lsigma, q=m*
                    effectiveTurns^2/2/Lsigma)) "Stray reluctance equivalent to ideally coupled stray inductances"
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={0,20})));
          equation
            connect(port_p, electroMagneticConverter.port_p)
              annotation (Line(points={{-100,0},{-10,0}}, color={255,128,0}));
            connect(electroMagneticConverter.port_n, port_n) annotation (Line(
                  points={{10,-5.72459e-17},{100,-5.72459e-17},{100,0}}, color={255,
                    128,0}));
            connect(ground.p, star.pin_n) annotation (Line(points={{60,-20},{56,-20},
                    {50,-20}}, color={0,0,255}));
            connect(star.plug_p, electroMagneticConverter.plug_n) annotation (Line(
                points={{30,-20},{10,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(thermalCollector.port_a, resistor.heatPort) annotation (Line(
                points={{-40,-70},{-40,-70},{-40,-50},{-30,-50}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(thermalCollector.port_b, heatPortWinding) annotation (Line(
                points={{-40,-90},{-40,-100},{0,-100}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(resistor.plug_n, starAuxiliary.plug_p) annotation (Line(
                points={{-20,-60},{-20,-60},{-20,-80},{30,-80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(strayReluctance.port_p, port_p) annotation (Line(
                points={{-10,20},{-30,20},{-30,0},{-100,0}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(strayReluctance.port_n, port_n) annotation (Line(
                points={{10,20},{30,20},{30,4.44089e-16},{100,4.44089e-16}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(electroMagneticConverter.plug_p, resistor.plug_p) annotation (
                Line(
                points={{-10,-20},{-20,-20},{-20,-40}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics={
                  Ellipse(
                    extent={{-80,80},{80,-80}},
                    lineColor={0,0,0},
                    fillColor={175,175,175},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{-20,76},{20,36}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{28,46},{68,6}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{28,-8},{68,-48}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{-20,-36},{20,-76}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{-68,-6},{-28,-46}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{-66,50},{-26,10}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Line(points={{-80,0},{-100,0}}, color={255,128,0}),
                  Line(points={{100,0},{80,0}}, color={255,128,0}),
                  Text(
                    extent={{0,100},{0,140}},
                    lineColor={0,0,255},
                    textString="%name")}),
              Documentation(info="<html>
<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Machines/Components/rotorcage.png\">
</p>
<p>
The symmetric rotor cage model of this library does not consist of rotor bars and end rings. Instead the symmetric cage is modeled by an equivalent symmetrical winding. The rotor cage model consists of
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\"> phases. If the cage is modeled by equivalent stator winding parameters, the number of effective turns, <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/effectiveTurns.png\">, has to be chosen equivalent to the effective number of stator turns.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">SinglePhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">SymmetricMultiPhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SaliencyCageWinding\">SaliencyCageWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap\">RotorSaliencyAirGap</a>
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics));
          end SymmetricMultiPhaseCageWinding;

          model SaliencyCageWinding "Rotor cage with saliency in d- and q-axis"
            import Modelica;
            import Modelica_AddOn;
            extends Interfaces.PartialTwoPortExtended;
            parameter Boolean useHeatPort=false "Enable / disable (=fixed temperatures) thermal port"
              annotation (Evaluate=true);
            parameter Types.SalientResistance RRef(d(start=1), q(start=1)) "Salient cage resistance";
            parameter Modelica.SIunits.Temperature TRef(start=293.15) "Reference temperature of winding";
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20(start=0) "Temperature coefficient of winding at 20 degC";
            final parameter Modelica.SIunits.LinearTemperatureCoefficient alphaRef=
                Modelica.Electrical.Machines.Thermal.convertAlpha(
                      alpha20,
                      TRef,
                      293.15);
            parameter Modelica.SIunits.Temperature TOperational(start=293.15) "Operational temperature of winding"
              annotation (Dialog(enable=not useHeatPort));
            parameter Types.SalientInductance Lsigma(d(start=1), q(start=1)) "Salient cage stray inductance";
            parameter Real effectiveTurns=1 "Effective number of turns";
            Modelica.Blocks.Interfaces.RealOutput i[2](
              each final quantity="ElectricCurrent",
              each final unit="A") = electroMagneticConverter.i "Currents out from damper";
            Modelica.Blocks.Interfaces.RealOutput lossPower(
              final quantity="Power",
              final unit="W") = sum(resistor.resistor.LossPower) "Damper losses";
            Modelica_AddOn.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
              electroMagneticConverter(
              final m=2,
              final orientation={0,Modelica.Constants.pi/2},
              final effectiveTurns=fill(effectiveTurns, 2)) annotation (Placement(
                  transformation(
                  origin={0,-10},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor(
              final useHeatPort=useHeatPort,
              final m=2,
              final R={RRef.d,RRef.q},
              final T_ref=fill(TRef, 2),
              final alpha=fill(alphaRef, 2),
              final T=fill(TOperational, 2)) annotation (Placement(transformation(
                  origin={-20,-50},
                  extent={{10,10},{-10,-10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=2) annotation (
                Placement(transformation(extent={{30,-90},{50,-70}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={70,-80},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPortWinding if
              useHeatPort "Heat ports of winding resistor"
              annotation (Placement(transformation(extent={{-10,-110},{10,-90}})));
            Modelica.Thermal.HeatTransfer.Components.ThermalCollector
              thermalCollector(final m=2) if useHeatPort "Connector of thermal rotor resistance heat ports"
              annotation (Placement(transformation(extent={{-50,-90},{-30,-70}})));
            Modelica_AddOn.Magnetic.FundamentalWave.Components.Reluctance
              strayReluctance(final R_m(d=effectiveTurns^2/Lsigma.d, q=
                    effectiveTurns^2/Lsigma.q)) "Stray reluctance equivalent to ideally coupled stray inductances"
              annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={0,20})));
          equation
            connect(port_p, electroMagneticConverter.port_p)
              annotation (Line(points={{-100,0},{-10,0}}, color={255,128,0}));
            connect(electroMagneticConverter.port_n, port_n)
              annotation (Line(points={{10,0},{100,0}}, color={255,128,0}));
            connect(ground.p, star.pin_n)
              annotation (Line(points={{60,-80},{50,-80}}, color={0,0,255}));
            connect(electroMagneticConverter.plug_n, resistor.plug_n) annotation (
                Line(
                points={{10,-20},{20,-20},{20,-80},{-20,-80},{-20,-60}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(star.plug_p, electroMagneticConverter.plug_n) annotation (Line(
                points={{30,-80},{20,-80},{20,-20},{10,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(thermalCollector.port_b, heatPortWinding) annotation (Line(
                points={{-40,-90},{-40,-100},{0,-100}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(resistor.heatPort, thermalCollector.port_a) annotation (Line(
                points={{-30,-50},{-40,-50},{-40,-70}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(electroMagneticConverter.plug_p, resistor.plug_p) annotation (
                Line(
                points={{-10,-20},{-20,-20},{-20,-40}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(strayReluctance.port_p, port_p) annotation (Line(
                points={{-10,20},{-30,20},{-30,0},{-100,0}},
                color={255,128,0},
                smooth=Smooth.None));
            connect(strayReluctance.port_n, port_n) annotation (Line(
                points={{10,20},{30,20},{30,0},{100,0}},
                color={255,128,0},
                smooth=Smooth.None));
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics={
                  Ellipse(
                    extent={{-80,80},{80,-80}},
                    lineColor={0,0,0},
                    fillColor={175,175,175},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{-20,76},{20,36}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{28,46},{68,6}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{28,-8},{68,-48}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{-20,-36},{20,-76}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{-68,-6},{-28,-46}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{-66,50},{-26,10}},
                    lineColor={0,0,0},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),
                  Line(points={{-80,0},{-100,0}}, color={255,128,0}),
                  Line(points={{100,0},{80,0}}, color={255,128,0}),
                  Text(
                    extent={{0,100},{0,140}},
                    lineColor={0,0,255},
                    textString="%name")}),
              Documentation(info="<html>

<p>
The salient cage model is a two axis model with two phases. The electromagnetic coupling therefore is also two phase coupling model. The angles of the two orientations are 0 and <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/pi_over_2.png\">. This way an asymmetrical rotor cage with different resistances and stray inductances in d- and q-axis can be modeled.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">SinglePhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">SymmetricMultiPhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseCageWinding\">SymmetricMultiPhaseCageWinding</a>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap\">RotorSaliencyAirGap</a>
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics));
          end SaliencyCageWinding;

          model PermanentMagnet "Permanent magnet represented by magnetic potential difference"
            extends Modelica_AddOn.Magnetic.FundamentalWave.Sources.ConstantMagneticPotentialDifference;
            extends Modelica.Electrical.Machines.Losses.InductionMachines.PermanentMagnetLosses;
            annotation (Documentation(info="<html>
<p>
Simple model of a permanent magnet, containing:
</p>
<ul>
<li><a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.ConstantMagneticPotentialDifference\">constant magnetomotive force</a></li>
<li><a href=\"modelica://Modelica.Electrical.Machines.Losses.InductionMachines.PermanentMagnetLosses\">loss model</a></li>
</ul>
<p>
The permanent magnet is modeled by a magnetic potential difference. The internal reluctance of the permanent magnet is not taken into accout. The internal reluctance needs to be modeled outside the permanent magnet model, e.g., by the total machine reluctance considered in the air gap model.
</p>
</html>"));
          end PermanentMagnet;

          model SymmetricMultiPhaseCageWinding_obsolete "Symmetrical rotor cage"
            import Modelica.Constants.pi;
            extends Modelica.Icons.ObsoleteModel;
            extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPortExtended;
            parameter Integer m=3 "Number of phases";
            parameter Boolean useHeatPort=false "Enable / disable (=fixed temperatures) thermal port"
              annotation (Evaluate=true);
            parameter Modelica.SIunits.Resistance RRef "Winding resistance per phase at TRef";
            parameter Modelica.SIunits.Temperature TRef(start=293.15) "Reference temperature of winding";
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20(start=0) "Temperature coefficient of winding at 20 degC";
            final parameter Modelica.SIunits.LinearTemperatureCoefficient alphaRef=
                Modelica.Electrical.Machines.Thermal.convertAlpha(
                      alpha20,
                      TRef,
                      293.15);
            parameter Modelica.SIunits.Temperature TOperational(start=293.15) "Operational temperature of winding"
              annotation (Dialog(enable=not useHeatPort));
            parameter Modelica.SIunits.Inductance Lsigma "Cage stray inductance";
            parameter Real effectiveTurns=1 "Effective number of turns";
            Modelica.SIunits.Current i[m]=strayInductor.i "Cage currents";
            Modelica_AddOn.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
              winding(
              final m=m,
              final effectiveTurns=fill(effectiveTurns, m),
              final orientation=
                  Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m)) "Symmetric winding"
                                  annotation (Placement(transformation(
                  origin={0,-10},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Inductor strayInductor(final m=m,
                final L=fill(Lsigma, m)) annotation (Placement(transformation(
                  origin={-20,-30},
                  extent={{10,-10},{-10,10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor(
              final useHeatPort=useHeatPort,
              final m=m,
              final R=fill(RRef, m),
              final T_ref=fill(TRef, m),
              final alpha=fill(alphaRef, m),
              final T=fill(TRef, m)) annotation (Placement(transformation(
                  origin={-20,-70},
                  extent={{10,10},{-10,-10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                Placement(transformation(extent={{30,-30},{50,-10}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={70,-20},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPortWinding if
              useHeatPort "Heat ports of winding resistor"
              annotation (Placement(transformation(extent={{-10,-110},{10,-90}})));
            Modelica.Thermal.HeatTransfer.Components.ThermalCollector
              thermalCollector(final m=m) if useHeatPort "Connector of thermal rotor resistance heat ports"
              annotation (Placement(transformation(extent={{-50,-90},{-30,-70}})));
            Modelica.Electrical.MultiPhase.Basic.Star starAuxiliary(final m=m)
              annotation (Placement(transformation(extent={{30,-90},{50,-70}},
                    rotation=0)));
          equation
            connect(port_p, winding.port_p)
              annotation (Line(points={{-100,0},{-10,0}}, color={255,128,0}));
            connect(winding.port_n, port_n) annotation (Line(points={{10,-5.72459e-17},
                    {100,-5.72459e-17},{100,0}},color={255,128,0}));
            connect(ground.p, star.pin_n) annotation (Line(points={{60,-20},{56,-20},
                    {50,-20}}, color={0,0,255}));
            connect(strayInductor.plug_n, resistor.plug_p)
              annotation (Line(points={{-20,-40},{-20,-60}}, color={0,0,255}));
            connect(strayInductor.plug_p, winding.plug_p) annotation (Line(
                points={{-20,-20},{-10,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(star.plug_p, winding.plug_n) annotation (Line(
                points={{30,-20},{10,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(thermalCollector.port_a, resistor.heatPort) annotation (Line(
                points={{-40,-70},{-30,-70}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(thermalCollector.port_b, heatPortWinding) annotation (Line(
                points={{-40,-90},{-40,-100},{0,-100}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(resistor.plug_n, starAuxiliary.plug_p) annotation (Line(
                points={{-20,-80},{30,-80}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}), graphics={Ellipse(
                          extent={{-80,80},{80,-80}},
                          lineColor={0,0,0},
                          fillColor={175,175,175},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{-20,76},{20,36}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{28,46},{68,6}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{28,-8},{68,-48}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{-20,-36},{20,-76}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{-68,-6},{-28,-46}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{-66,50},{-26,10}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Line(points={{-80,0},{-100,
                    0}}, color={255,128,0}),Line(points={{100,0},{80,0}}, color={
                    255,128,0}),Text(
                          extent={{0,100},{0,140}},
                          lineColor={0,0,255},
                          textString="%name")}),
              Documentation(info="<html>
<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Machines/Components/rotorcage.png\">
</p>
<p>
The symmetric rotor cage model of this library does not consist of rotor bars and end rings. Instead the symmetric cage is modeled by an equivalent symmetrical winding. The rotor cage model consists of
<img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/m.png\"> phases. If the cage is modeled by equivalent stator winding parameters, the number of effective turns, <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/effectiveTurns.png\">, has to be chosen equivalent to the effective number of stator turns.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">SinglePhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">SymmetricMultiPhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SaliencyCageWinding\">SaliencyCageWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap\">RotorSaliencyAirGap</a>
</p>
</html>"),    Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                      {100,100}}),graphics));
          end SymmetricMultiPhaseCageWinding_obsolete;

          model SaliencyCageWinding_obsolete "Rotor cage with saliency in d- and q-axis"
            extends Modelica.Icons.ObsoleteModel;
            extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPortExtended;
            parameter Boolean useHeatPort=false "Enable / disable (=fixed temperatures) thermal port"
              annotation (Evaluate=true);
            parameter Modelica_AddOn.Magnetic.FundamentalWave.Types.SalientResistance
                                                                              RRef(
                d(start=1), q(start=1)) "Salient cage resistance";
            parameter Modelica.SIunits.Temperature TRef(start=293.15) "Reference temperature of winding";
            parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
              alpha20(start=0) "Temperature coefficient of winding at 20 degC";
            final parameter Modelica.SIunits.LinearTemperatureCoefficient alphaRef=
                Modelica.Electrical.Machines.Thermal.convertAlpha(
                      alpha20,
                      TRef,
                      293.15);
            parameter Modelica.SIunits.Temperature TOperational(start=293.15) "Operational temperature of winding"
              annotation (Dialog(enable=not useHeatPort));
            parameter Modelica_AddOn.Magnetic.FundamentalWave.Types.SalientInductance
              Lsigma(d(start=1), q(start=1)) "Salient cage stray inductance";
            parameter Real effectiveTurns=1 "Effective number of turns";
            Modelica.Blocks.Interfaces.RealOutput i[2](
              each final quantity="ElectricCurrent",
              each final unit="A") = resistor.i "Currents out from damper";
            Modelica.Blocks.Interfaces.RealOutput lossPower(
              final quantity="Power",
              final unit="W") = sum(resistor.resistor.LossPower) "Damper losses";
            Modelica_AddOn.Magnetic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
              winding(
              final m=2,
              final orientation={0,Modelica.Constants.pi/2},
              final effectiveTurns=fill(effectiveTurns, 2)) "Symmetric winding"
              annotation (Placement(transformation(
                  origin={0,-10},
                  extent={{-10,-10},{10,10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Inductor strayInductor(final m=2,
                final L={Lsigma.d,Lsigma.q}) annotation (Placement(transformation(
                  origin={-20,-30},
                  extent={{10,-10},{-10,10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Resistor resistor(
              final useHeatPort=useHeatPort,
              final m=2,
              final R={RRef.d,RRef.q},
              final T_ref=fill(TRef, 2),
              final alpha=fill(alphaRef, 2),
              final T=fill(TOperational, 2)) annotation (Placement(transformation(
                  origin={-20,-70},
                  extent={{10,10},{-10,-10}},
                  rotation=90)));
            Modelica.Electrical.MultiPhase.Basic.Star star(final m=2) annotation (
                Placement(transformation(extent={{30,-90},{50,-70}}, rotation=0)));
            Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                  transformation(
                  origin={70,-80},
                  extent={{-10,10},{10,-10}},
                  rotation=270)));
            Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPortWinding if
              useHeatPort "Heat ports of winding resistor"
              annotation (Placement(transformation(extent={{-10,-110},{10,-90}})));
            Modelica.Thermal.HeatTransfer.Components.ThermalCollector
              thermalCollector(final m=2) if useHeatPort "Connector of thermal rotor resistance heat ports"
              annotation (Placement(transformation(extent={{-50,-90},{-30,-70}})));
          equation
            connect(port_p, winding.port_p)
              annotation (Line(points={{-100,0},{-10,0}}, color={255,128,0}));
            connect(winding.port_n, port_n)
              annotation (Line(points={{10,0},{100,0}}, color={255,128,0}));
            connect(ground.p, star.pin_n)
              annotation (Line(points={{60,-80},{50,-80}}, color={0,0,255}));
            connect(strayInductor.plug_n, resistor.plug_p)
              annotation (Line(points={{-20,-40},{-20,-60}}, color={0,0,255}));
            connect(winding.plug_n, resistor.plug_n) annotation (Line(
                points={{10,-20},{20,-20},{20,-80},{-20,-80}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(star.plug_p, winding.plug_n) annotation (Line(
                points={{30,-80},{20,-80},{20,-20},{10,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(strayInductor.plug_p, winding.plug_p) annotation (Line(
                points={{-20,-20},{-10,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(thermalCollector.port_b, heatPortWinding) annotation (Line(
                points={{-40,-90},{-40,-100},{0,-100}},
                color={191,0,0},
                smooth=Smooth.None));
            connect(resistor.heatPort, thermalCollector.port_a) annotation (Line(
                points={{-30,-70},{-40,-70}},
                color={191,0,0},
                smooth=Smooth.None));
            annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                      -100},{100,100}}), graphics={Ellipse(
                          extent={{-80,80},{80,-80}},
                          lineColor={0,0,0},
                          fillColor={175,175,175},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{-20,76},{20,36}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{28,46},{68,6}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{28,-8},{68,-48}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{-20,-36},{20,-76}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{-68,-6},{-28,-46}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Ellipse(
                          extent={{-66,50},{-26,10}},
                          lineColor={0,0,0},
                          fillColor={255,255,255},
                          fillPattern=FillPattern.Solid),Line(points={{-80,0},{-100,
                    0}}, color={255,128,0}),Line(points={{100,0},{80,0}}, color={
                    255,128,0}),Text(
                          extent={{0,100},{0,140}},
                          lineColor={0,0,255},
                          textString="%name")}), Documentation(info="<html>

<p>
The salient cage model is a two axis model with two phases. The electromagnetic coupling therefore is also two phase coupling model. The angles of the two orientations are 0 and <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/pi_over_2.png\">. This way an asymmetrical rotor cage with different resistances and stray inductances in d- and q-axis can be modeled.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SinglePhaseWinding\">SinglePhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseWinding\">SymmetricMultiPhaseWinding</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.SymmetricMultiPhaseCageWinding\">SymmetricMultiPhaseCageWinding</a>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap\">RotorSaliencyAirGap</a>
</p>
</html>"));
          end SaliencyCageWinding_obsolete;
        end Components;
        annotation (Documentation(info="<html>
<p>
This package contains electric machine models and
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.BasicMachines.Components\">components</a>
for electric machines.
</p>
</html>"));
      end BasicMachines;

      package Sources "Sources"
        extends Modelica.Icons.SourcesPackage;
        model ConstantMagneticPotentialDifference "Source with constant magnetic potential difference"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPort;
          parameter Modelica.SIunits.ComplexMagneticPotentialDifference V_m=Complex(
              re=1, im=0) "Complex magnetic potential difference";
          Modelica.SIunits.MagneticPotentialDifference abs_V_m=
              Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
          Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
          Modelica.SIunits.ComplexMagneticFlux Phi "Complex magnetic flux";
          Modelica.SIunits.MagneticPotentialDifference abs_Phi=
              Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
          Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
        equation
          // Flux into positive port
          port_p.V_m - port_n.V_m = V_m;
          // Magneto motive force
          port_p.Phi = Phi;
          // Local flux balance
          port_p.Phi + port_n.Phi = Complex(0, 0);
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={
                Text(
                  extent={{-80,-20},{-80,-40}},
                  lineColor={255,128,0},
                  textString="+"),
                Text(
                  extent={{80,-20},{80,-40}},
                  lineColor={255,128,0},
                  textString="-"),
                Ellipse(
                  extent={{-50,-50},{50,50}},
                  lineColor={255,128,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{100,0},{50,0}}, color={255,128,0}),
                Line(points={{-50,0},{-100,0}}, color={255,128,0}),
                Line(points={{-50,0},{50,0}}, color={255,128,0}),
                Text(
                  extent={{0,-120},{0,-80}},
                  textString="%name",
                  lineColor={0,0,255})}), Documentation(info="<html>
<p>
Source of constant magneto motive force.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.SignalMagneticPotentialDifference\">SignalMagneticPotentialDifference</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.ConstantFlux\">ConstantFlux</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.SignalFlux\">SignalFlux</a>
</p>
</html>"));
        end ConstantMagneticPotentialDifference;

        model SignalMagneticPotentialDifference "Source of magnetic potential difference with signal input"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPort;
          Modelica.ComplexBlocks.Interfaces.ComplexInput V_m "Complex signal input of magnetic potential difference"
                                                                    annotation (
              Placement(transformation(
                origin={0,100},
                extent={{-20,-20},{20,20}},
                rotation=270)));
          Modelica.SIunits.MagneticPotentialDifference abs_V_m=
              Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
          Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
          Modelica.SIunits.ComplexMagneticFlux Phi "Complex magnetic flux";
          Modelica.SIunits.MagneticPotentialDifference abs_Phi=
              Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
          Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
        equation
          // Flux into positive port
          port_p.V_m - port_n.V_m = V_m;
          // Magneto motive force
          port_p.Phi = Phi;
          // Local flux balance
          port_p.Phi + port_n.Phi = Complex(0, 0);
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                      extent={{80,-20},{80,-40}},
                      lineColor={255,128,0},
                      textString="-"),Ellipse(
                      extent={{-50,-50},{50,50}},
                      lineColor={255,128,0},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(points={{100,0},{50,0}},
                  color={255,128,0}),Line(points={{-50,0},{-100,0}}, color={255,128,
                  0}),Line(points={{-50,0},{50,0}}, color={255,128,0}),Line(points=
                  {{0,100},{0,50}}, color={255,128,0}),Text(
                      extent={{0,-120},{0,-80}},
                      textString="%name",
                      lineColor={0,0,255})}), Documentation(info="<html>
<p>
Source of magneto motive force with complex signal input.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.ConstantMagneticPotentialDifference\">ConstantMagneticPotentialDifference</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.ConstantFlux\">ConstantFlux</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.SignalFlux\">SignalFlux</a>
</p>

</html>"));
        end SignalMagneticPotentialDifference;

        model ConstantFlux "Source of constant magnetic flux"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPort;
          Modelica.SIunits.ComplexMagneticPotentialDifference V_m "Complex magnetic potential difference";
          Modelica.SIunits.MagneticPotentialDifference abs_V_m=
              Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
          Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
          parameter Modelica.SIunits.ComplexMagneticFlux Phi=Complex(re=1, im=0) "Complex magnetic flux";
          Modelica.SIunits.MagneticPotentialDifference abs_Phi=
              Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
          Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
        equation
          // Flux into positive port
          port_p.V_m - port_n.V_m = V_m;
          // Magneto motive force
          port_p.Phi = Phi;
          // Local flux balance
          port_p.Phi + port_n.Phi = Complex(0, 0);
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={Ellipse(
                      extent={{-50,-50},{50,50}},
                      lineColor={255,128,0},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(points={{100,0},{50,0}},
                  color={255,128,0}),Line(points={{-50,0},{-100,0}}, color={255,128,
                  0}),Line(points={{0,50},{0,-50}}, color={255,128,0}),Polygon(
                      points={{80,0},{60,6},{60,-6},{80,0}},
                      lineColor={255,128,0},
                      fillColor={255,128,0},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{0,-120},{0,-80}},
                      textString="%name",
                      lineColor={0,0,255})}), Documentation(info="<html>
<p>
Source of constant magnetic flux.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.ConstantMagneticPotentialDifference\">
   ConstantMagneticPotentialDifference</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.SignalMagneticPotentialDifference\">
   SignalMagneticPotentialDifference</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.SignalFlux\">SignalFlux</a>
</p>

</html>"));
        end ConstantFlux;

        model SignalFlux "Source of constant magnetic flux"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPort;
          Modelica.SIunits.ComplexMagneticPotentialDifference V_m "Complex magnetic potential difference";
          Modelica.SIunits.MagneticPotentialDifference abs_V_m=
              Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
          Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
          Modelica.ComplexBlocks.Interfaces.ComplexInput Phi "Complex signal input of magnetic flux"
                                                    annotation (Placement(
                transformation(
                origin={0,100},
                extent={{-20,-20},{20,20}},
                rotation=270)));
          Modelica.SIunits.MagneticPotentialDifference abs_Phi=
              Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
          Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
        equation
          // Flux into positive port
          port_p.V_m - port_n.V_m = V_m;
          // Magneto motive force
          port_p.Phi = Phi;
          // Local flux balance
          port_p.Phi + port_n.Phi = Complex(0, 0);
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={Ellipse(
                      extent={{-50,-50},{50,50}},
                      lineColor={255,128,0},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(points={{100,0},{50,0}},
                  color={255,128,0}),Line(points={{-50,0},{-100,0}}, color={255,128,
                  0}),Line(points={{0,50},{0,-50}}, color={255,128,0}),Polygon(
                      points={{80,0},{60,6},{60,-6},{80,0}},
                      lineColor={255,128,0},
                      fillColor={255,128,0},
                      fillPattern=FillPattern.Solid),Line(points={{0,100},{0,50}},
                  color={255,128,0}),Text(
                      extent={{0,-120},{0,-80}},
                      textString="%name",
                      lineColor={0,0,255})}), Documentation(info="<html>
<p>
Source of magnetic flux with complex signal input.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.ConstantMagneticPotentialDifference\">
   ConstantMagneticPotentialDifference</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.SignalMagneticPotentialDifference\">
   SignalMagneticPotentialDifference</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sources.ConstantFlux\">ConstantFlux</a>,
</p>

</html>"));
        end SignalFlux;
        annotation (Documentation(info="<html>
<p>This package provides sources of magnetic potential difference and magnetic flux.</p>
</html>"));
      end Sources;

      package Sensors "Sensors to measure variables in magnetic networks"
        extends Modelica.Icons.SensorsPackage;
        model MagneticFluxSensor "Sensor to measure magnetic flux"
          extends Modelica.Icons.RotationalSensor;
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPort;
          Modelica.SIunits.ComplexMagneticPotentialDifference V_m "Complex magnetic potential difference";
          Modelica.ComplexBlocks.Interfaces.ComplexOutput Phi "Complex magnetic flux from por_ p to port_n as output signal"
            annotation (Placement(transformation(
                origin={0,-100},
                extent={{10,-10},{-10,10}},
                rotation=90)));
        equation
          // Flux into positive port
          port_p.V_m - port_n.V_m = V_m;
          // Magneto motive force
          port_p.Phi = Phi;
          // Local flux balance
          port_p.Phi + port_n.Phi = Complex(0, 0);
          // No magnetic potential difference at sensor
          V_m = Complex(0, 0);
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                      extent={{-29,-11},{30,-70}},
                      lineColor={0,0,0},
                      textString="Phi"),Line(points={{-72,0},{-90,0}}, color={0,0,0}),
                  Text(
                      extent={{-140,120},{140,80}},
                      textString="%name",
                      lineColor={0,0,255}),Line(points={{70,0},{90,0}}, color={0,0,
                  0}),Line(points={{0,-90},{0,-70}})}), Documentation(info="<html>
<p>Sensor for magnetic flux.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sensors.MagneticPotentialDifferenceSensor\">MagneticPotentialDifferenceSensor</a>
</p>
</html>"));
        end MagneticFluxSensor;

        model MagneticPotentialDifferenceSensor "Sensor to measure magnetic potential difference"
          extends Modelica.Icons.RotationalSensor;
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPort;
          Modelica.ComplexBlocks.Interfaces.ComplexOutput V_m "Complex magnetic potential difference between port_p and port_n as output signal"
            annotation (Placement(transformation(
                origin={0,-100},
                extent={{10,-10},{-10,10}},
                rotation=90)));
          Modelica.SIunits.ComplexMagneticFlux Phi "Complex magnetic flux";
        equation
          // Flux into positive port
          port_p.V_m - port_n.V_m = V_m;
          // Magneto motive force
          port_p.Phi = Phi;
          // Local flux balance
          port_p.Phi + port_n.Phi = Complex(0, 0);
          // No magnetic flux through sensor
          Phi = Complex(0, 0);
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                      extent={{-52,1},{48,-57}},
                      lineColor={0,0,0},
                      fillColor={0,0,0},
                      fillPattern=FillPattern.Solid,
                      textString="V_m"),Line(points={{-70,0},{-90,0}}, color={0,0,0}),
                  Line(points={{70,0},{90,0}}, color={0,0,0}),Line(points={{0,-90},
                  {0,-70}}),Text(
                      extent={{-140,120},{140,80}},
                      textString="%name",
                      lineColor={0,0,255})}), Documentation(info="<html>
<p>Sensor for magnetic potential difference.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sensors.MagneticFluxSensor\">MagneticFluxSensor</a>
</p></html>"));
        end MagneticPotentialDifferenceSensor;

        model MagneticPotentialSensor "Sensor to measure magnetic potential"
          extends Modelica.Icons.RotationalSensor;
          Modelica.ComplexBlocks.Interfaces.ComplexOutput V_m "Complex magnetic potential as output signal"
                                                          annotation (Placement(
                transformation(
                origin={0,-100},
                extent={{10,-10},{-10,10}},
                rotation=90)));
          Interfaces.PositiveMagneticPort port_p "Magnetic connector of sensor"
            annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
        equation
          // No magnetic flux through sensor
          port_p.Phi = Complex(0, 0);
          // Magnetic potential
          V_m = port_p.V_m;
          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                      extent={{-52,1},{48,-57}},
                      lineColor={0,0,0},
                      fillColor={0,0,0},
                      fillPattern=FillPattern.Solid,
                      textString="V_m"),Line(points={{-70,0},{-90,0}}, color={0,0,0}),
                  Line(points={{0,-90},{0,-70}}),Text(
                      extent={{-140,120},{140,80}},
                      textString="%name",
                      lineColor={0,0,255})}), Documentation(info="<html>
<p>Sensor for magnetic potential difference.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Sensors.MagneticFluxSensor\">MagneticFluxSensor</a>
</p></html>"));
        end MagneticPotentialSensor;
        annotation (Documentation(info="<html>
<p>
This package provides sensors for the magnetic potential difference and the magnetic flux in magnetic circuit.
</p>
</html>"));
      end Sensors;

      package Interfaces "Interfaces and partial models"
        extends Modelica.Icons.InterfacesPackage;
        connector MagneticPort "Complex magnetic port"
          Modelica.SIunits.ComplexMagneticPotentialDifference V_m "Complex magnetic potential difference";
          flow Modelica.SIunits.ComplexMagneticFlux Phi "Complex magnetic flux";
          annotation (Documentation(info="<html>
<p>
The potential quantity of the magnetic port is the complex magnetic potential difference <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/V_m.png\">. The corresponding flow quantity is the magnetic flux <img src=\"modelica://Modelica/Resources/Images/Magnetic/FundamentalWave/Phi.png\">.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort\">PositiveMagneticPort</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort\">NegativeMagneticPort</a>
</p>

</html>"));
        end MagneticPort;

        connector NegativeMagneticPort "Negative complex magnetic port"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.MagneticPort;
          annotation (
            defaultComponentName="port_n",
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Ellipse(
                  extent={{-100,100},{100,-100}},
                  lineColor={255,128,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid)}),
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics={Text(
                  extent={{-60,100},{-60,60}},
                  lineColor={255,128,0},
                  textString="%name"), Ellipse(
                  extent={{-50,50},{50,-50}},
                  lineColor={255,128,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid)}),
            Documentation(info="<html>
<p>
Negative magnetic <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.MagneticPort\">port</a>.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.MagneticPort\">MagneticPort</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort\">PositiveMagneticPort</a>
</p>
</html>"));
        end NegativeMagneticPort;

        connector PositiveMagneticPort "Positive complex magnetic port"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.MagneticPort;
          annotation (
            defaultComponentName="port_p",
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={Ellipse(
                  extent={{-100,100},{100,-100}},
                  lineColor={255,128,0},
                  fillColor={255,128,0},
                  fillPattern=FillPattern.Solid)}),
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics={Text(
                  extent={{-60,100},{-60,60}},
                  lineColor={255,128,0},
                  textString="%name"), Ellipse(
                  extent={{-50,50},{50,-50}},
                  lineColor={255,128,0},
                  fillColor={255,128,0},
                  fillPattern=FillPattern.Solid)}),
            Documentation(info="<html>
<p>
Positive magnetic <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.MagneticPort\">port</a>.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.MagneticPort\">MagneticPort</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort\">NegativeMagneticPort</a>
</p>

</html>"));
        end PositiveMagneticPort;

        partial model PartialTwoPort "Two magnetic ports for graphical modeling"
          PositiveMagneticPort port_p "Positive complex magnetic port" annotation (
              Placement(transformation(extent={{-110,-10},{-90,10}}, rotation=0)));
          NegativeMagneticPort port_n "Negative complex magnetic port" annotation (
              Placement(transformation(extent={{90,-10},{110,10}}, rotation=0)));
          annotation (Documentation(info="<html>
<p>
This magnetic two port element consists of a
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort\">positive</a> and a
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort\">negative magnetic port</a> and
considers the flux balance of the two ports. Additionally the magnetic potential difference (of the positive and the negative port) and the magnetic flux (into the positive magnetic port) are defined. This model is mainly to used to extend from in order build more complex - graphical - models.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort\">PositiveMagneticPort</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort\">NegativeMagneticPort</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PartialTwoPortExtended\">PartialTwoPortExtended</a>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PartialTwoPortElementary\">PartialTwoPortElementary</a>
</p></html>"),     Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}), graphics));
        end PartialTwoPort;

        partial model PartialTwoPortExtended "Two magnetic ports for graphical modeling with additonal variables"
          extends Interfaces.PartialTwoPort;
          Modelica.SIunits.ComplexMagneticPotentialDifference V_m=port_p.V_m -
              port_n.V_m "Complex magnetic potential difference";
          Modelica.SIunits.MagneticPotentialDifference abs_V_m=
              Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
          Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
          Modelica.SIunits.ComplexMagneticFlux Phi=port_p.Phi "Complex magnetic flux";
          Modelica.SIunits.MagneticFlux abs_Phi=Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
          Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
          annotation (Documentation(info="<html>
<p>This magnetic two port element consists of a <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort\">positive</a> and a <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort\">negative magnetic port</a> and some additionally variables, but no physical balance equations. </p>
<h4>See also</h4>
<p><a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort\">PositiveMagneticPort</a>, <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort\">NegativeMagneticPort</a>, <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PartialTwoPort\">PartialTwoPort</a>, <a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PartialTwoPortElementary\">PartialTwoPortElementary</a> </p>
</html>"),     Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}), graphics));
        end PartialTwoPortExtended;

        partial model PartialTwoPortElementary "Two magnetic ports for textual modeling"
          extends Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PartialTwoPort;
          Modelica.SIunits.ComplexMagneticPotentialDifference V_m "Complex magnetic potential difference";
          Modelica.SIunits.MagneticPotentialDifference abs_V_m=
              Modelica.ComplexMath.'abs'(V_m) "Magnitude of complex magnetic potential difference";
          Modelica.SIunits.Angle arg_V_m=Modelica.ComplexMath.arg(V_m) "Argument of complex magnetic potential difference";
          Modelica.SIunits.ComplexMagneticFlux Phi "Complex magnetic flux";
          Modelica.SIunits.MagneticFlux abs_Phi=Modelica.ComplexMath.'abs'(Phi) "Magnitude of complex magnetic flux";
          Modelica.SIunits.Angle arg_Phi=Modelica.ComplexMath.arg(Phi) "Argument of complex magnetic flux";
        equation
          // Flux into positive port
          V_m = port_p.V_m - port_n.V_m;
          // Magneto motive force
          port_p.Phi = Phi;
          // Local flux balance
          port_p.Phi + port_n.Phi = Complex(0, 0);
          annotation (Documentation(info="<html>
<p>
This magnetic two port element only consists of a
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort\">positive</a> and a
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort\">negative magnetic port</a>.
This model is mainly used to extend from in order build more complex - equation based - models.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort\">PositiveMagneticPort</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort\">NegativeMagneticPort</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PartialTwoPort\">PartialTwoPort</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces.PartialTwoPortExtended\">PartialTwoPortExtended</a>
</p>
</html>"));
        end PartialTwoPortElementary;

        partial model PartialBasicInductionMachine "Partial model for induction machine"
          extends Modelica.Electrical.Machines.Icons.FundamentalWaveMachine;
          constant Modelica.SIunits.Angle pi=Modelica.Constants.pi;
          parameter Integer m(min=3) = 3 "Number of stator phases";
          // Mechanical parameters
          parameter Modelica.SIunits.Inertia Jr(start=0.29) "Rotor inertia";
          parameter Boolean useSupport=false "Enable / disable (=fixed stator) support"
                                                       annotation (Evaluate=true);
          parameter Modelica.SIunits.Inertia Js(start=Jr) "Stator inertia"
            annotation (Dialog(enable=useSupport));
          parameter Boolean useThermalPort=false "Enable / disable (=fixed temperatures) thermal port"
            annotation (Evaluate=true);
          parameter Integer p(min=1, start=2) "Number of pole pairs (Integer)";
          parameter Modelica.SIunits.Frequency fsNominal(start=50) "Nominal frequency";
          parameter Modelica.SIunits.Temperature TsOperational(start=293.15) "Operational temperature of stator resistance"
                                                           annotation (Dialog(group=
                 "Operational temperatures", enable=not useThermalPort));
          parameter Modelica.SIunits.Resistance Rs(start=0.03) "Stator resistance per phase at TRef"
            annotation (Dialog(tab="Nominal resistances and inductances"));
          parameter Modelica.SIunits.Temperature TsRef(start=293.15) "Reference temperature of stator resistance"
            annotation (Dialog(tab="Nominal resistances and inductances"));
          parameter Modelica.Electrical.Machines.Thermal.LinearTemperatureCoefficient20
            alpha20s(start=0) "Temperature coefficient of stator resistance at 20 degC"
            annotation (Dialog(tab="Nominal resistances and inductances"));
          parameter Real effectiveStatorTurns=1 "Effective number of stator turns";
          parameter Modelica.SIunits.Inductance Lssigma(start=3*(1 - sqrt(1 -
                0.0667))/(2*pi*fsNominal)) "Stator stray inductance per phase"
            annotation (Dialog(tab="Nominal resistances and inductances"));
          parameter Modelica.SIunits.Inductance Lszero=Lssigma "Stator zero inductance"
            annotation (Dialog(tab="Nominal resistances and inductances"));
          parameter Modelica_AddOn.Magnetic.FundamentalWave.Types.SalientInductance
            L0(d(start=1),q(start=1)) "Salient inductance of an unchorded coil"
            annotation (Dialog(tab="Nominal resistances and inductances"));
          parameter Modelica.Electrical.Machines.Losses.FrictionParameters
            frictionParameters(wRef=2*pi*fsNominal/p) "Friction loss parameter record"
                                             annotation (Dialog(tab="Losses"));
          parameter Modelica.Electrical.Machines.Losses.CoreParameters
            statorCoreParameters(
            final m=3,
            wRef=2*pi*fsNominal/p,
            VRef(start=100)) "Stator core loss parameter record; all parameters refer to stator side"
            annotation (Dialog(tab="Losses"));
          parameter Modelica.Electrical.Machines.Losses.StrayLoadParameters
            strayLoadParameters(IRef(start=100), wRef=2*pi*fsNominal/p) "Stray load loss parameter record"
                                               annotation (Dialog(tab="Losses"));
          // Mechanical quantities
          output Modelica.SIunits.Angle phiMechanical(start=0) = flange.phi -
            internalSupport.phi "Mechanical angle of rotor against stator";
          output Modelica.SIunits.AngularVelocity wMechanical(
            start=0,
            displayUnit="1/min") = der(phiMechanical) "Mechanical angular velocity of rotor against stator";
          output Modelica.SIunits.Torque tauElectrical=inertiaRotor.flange_a.tau "Electromagnetic torque";
          output Modelica.SIunits.Torque tauShaft=-flange.tau "Shaft torque";
          replaceable output Modelica.Electrical.Machines.Interfaces.InductionMachines.PartialPowerBalanceInductionMachines
            powerBalance(
            final powerStator=Modelica.Electrical.MultiPhase.Functions.activePower(
                vs, is),
            final powerMechanical=wMechanical*tauShaft,
            final powerInertiaStator=inertiaStator.J*inertiaStator.a*inertiaStator.w,
            final powerInertiaRotor=inertiaRotor.J*inertiaRotor.a*inertiaRotor.w,
            final lossPowerStatorWinding=sum(stator.resistor.resistor.LossPower),
            final lossPowerStatorCore=stator.core.lossPower,
            final lossPowerStrayLoad=strayLoad.lossPower,
            final lossPowerFriction=friction.lossPower) "Power balance";
          // Stator voltages and currents
          output Modelica.SIunits.Voltage vs[m]=plug_sp.pin.v - plug_sn.pin.v "Stator instantaneous voltages";
          output Modelica.SIunits.Current is[m]=plug_sp.pin.i "Stator instantaneous currents";
          Modelica.Mechanics.Rotational.Interfaces.Flange_a flange "Shaft"
            annotation (Placement(transformation(extent={{90,-10},{110,10}},
                  rotation=0)));
          Modelica.Mechanics.Rotational.Components.Inertia inertiaRotor(final J=Jr)
            annotation (Placement(transformation(
                origin={80,0},
                extent={{10,10},{-10,-10}},
                rotation=180)));
          Modelica.Mechanics.Rotational.Interfaces.Flange_a support if useSupport "Support at which the reaction torque is acting"
                                                             annotation (Placement(
                transformation(extent={{90,-110},{110,-90}}, rotation=0)));
          Modelica.Mechanics.Rotational.Components.Inertia inertiaStator(final J=Js)
            annotation (Placement(transformation(
                origin={80,-100},
                extent={{10,10},{-10,-10}},
                rotation=180)));
          Modelica.Mechanics.Rotational.Components.Fixed fixed if (not useSupport)
            annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=180,
                origin={70,-90})));
          Modelica.Electrical.MultiPhase.Interfaces.PositivePlug plug_sp(final m=m) "Positive plug of stator"
                                      annotation (Placement(transformation(extent={
                    {50,90},{70,110}}, rotation=0)));
          Modelica.Electrical.MultiPhase.Interfaces.NegativePlug plug_sn(final m=m) "Negative plug of stator"
                                      annotation (Placement(transformation(extent={
                    {-70,90},{-50,110}}, rotation=0)));
          BasicMachines.Components.SymmetricMultiPhaseWinding stator(
            final useHeatPort=true,
            final m=m,
            final RRef=Rs,
            final TRef=TsRef,
            final Lsigma=Lssigma,
            final effectiveTurns=effectiveStatorTurns,
            final TOperational=TsOperational,
            final GcRef=statorCoreParameters.GcRef,
            final alpha20=alpha20s,
            final Lzero=Lszero) "Symmetric stator winding including resistances, zero and stray inductances and core losses"
            annotation (Placement(transformation(
                origin={0,40},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          replaceable Modelica.Electrical.Machines.Interfaces.InductionMachines.PartialThermalAmbientInductionMachines
            thermalAmbient(
            final useTemperatureInputs=false,
            final Ts=TsOperational,
            final m=m) if not useThermalPort annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=270,
                origin={-70,-90})));
          replaceable Modelica.Electrical.Machines.Interfaces.InductionMachines.PartialThermalPortInductionMachines
            thermalPort(final m=m) if useThermalPort "Thermal port of induction machines"
            annotation (Placement(transformation(extent={{-10,-110},{10,-90}})));
          Modelica_AddOn.Magnetic.FundamentalWave.Components.Ground groundS "Ground of stator magnetic circuit"
                                                annotation (Placement(
                transformation(extent={{-40,30},{-20,10}}, rotation=0)));
          Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.Components.RotorSaliencyAirGap
            airGap(final p=p, final L0=L0) annotation (Placement(transformation(
                origin={0,0},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica_AddOn.Magnetic.FundamentalWave.Components.Ground groundR "Ground of rotor magnetic circuit"
                                               annotation (Placement(transformation(
                  extent={{-40,-30},{-20,-10}}, rotation=0)));
          /* previously used: state selection, now commented
  FundamentalWave.Interfaces.StateSelector stateSelectorS(
    final m=m,
    final xi=is,
    final gamma=p*phiMechanical) "State selection of stator currents"
    annotation (Placement(transformation(extent={{-10,80},{10,100}})));
  */
          Modelica.Electrical.Machines.Losses.InductionMachines.StrayLoad strayLoad(
            final strayLoadParameters=strayLoadParameters,
            final useHeatPort=true,
            final m=m)
            annotation (Placement(transformation(extent={{60,60},{40,80}})));
          Modelica.Electrical.Machines.Losses.Friction friction(final
              frictionParameters=frictionParameters, final useHeatPort=true)
            annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=0,
                origin={90,-30})));
        protected
          replaceable Modelica.Electrical.Machines.Interfaces.InductionMachines.PartialThermalPortInductionMachines
            internalThermalPort(final m=m)
            annotation (Placement(transformation(extent={{-44,-94},{-36,-86}})));
          Modelica.Mechanics.Rotational.Interfaces.Support internalSupport
            annotation (Placement(transformation(extent={{56,-104},{64,-96}},
                  rotation=0)));
        initial algorithm
          assert(not Modelica.Math.isPowerOf2(m), String(m) +
            " phases are currently not supported in this version of FundametalWave");
        equation
          connect(stator.plug_n, plug_sn) annotation (Line(
              points={{-10,50},{-10,70},{-60,70},{-60,100}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(thermalPort, internalThermalPort) annotation (Line(
              points={{0,-100},{0,-90},{-40,-90}},
              color={199,0,0},
              smooth=Smooth.None));
          connect(thermalAmbient.thermalPort, internalThermalPort) annotation (Line(
              points={{-60,-90},{-40,-90}},
              color={199,0,0},
              smooth=Smooth.None));
          connect(inertiaRotor.flange_b, flange)
            annotation (Line(points={{90,0},{100,0},{100,0}}, color={0,0,0}));
          connect(internalSupport, inertiaStator.flange_a) annotation (Line(
              points={{60,-100},{70,-100}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(internalSupport, fixed.flange) annotation (Line(
              points={{60,-100},{60,-90},{70,-90}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(inertiaStator.flange_b, support) annotation (Line(points={{90,-100},
                  {90,-100},{100,-100}}, color={0,0,0}));
          connect(airGap.flange_a, inertiaRotor.flange_a) annotation (Line(
              points={{10,0},{25,0},{25,0},{40,0},{40,0},{70,0}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(airGap.support, internalSupport) annotation (Line(
              points={{-10,0},{-50,0},{-50,-70},{60,-70},{60,-100}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(groundR.port_p, airGap.port_rn)
            annotation (Line(points={{-30,-10},{-10,-10}}, color={255,128,0}));
          connect(stator.plug_p, strayLoad.plug_n) annotation (Line(
              points={{10,50},{10,70},{40,70}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(plug_sp, strayLoad.plug_p) annotation (Line(
              points={{60,100},{60,70}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(strayLoad.support, internalSupport) annotation (Line(
              points={{50,60},{50,50},{60,50},{60,-100}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(strayLoad.heatPort, internalThermalPort.heatPortStrayLoad)
            annotation (Line(
              points={{60,60},{60,50},{50,50},{50,-80},{-40,-80},{-40,-90}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(friction.support, internalSupport) annotation (Line(
              points={{90,-40},{90,-70},{60,-70},{60,-100}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(strayLoad.flange, inertiaRotor.flange_b) annotation (Line(
              points={{50,80},{90,80},{90,0}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(friction.flange, inertiaRotor.flange_b) annotation (Line(
              points={{90,-20},{90,0}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(friction.heatPort, internalThermalPort.heatPortFriction)
            annotation (Line(
              points={{80,-40},{50,-40},{50,-80},{-40,-80},{-40,-90}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(groundS.port_p, airGap.port_sp) annotation (Line(
              points={{-30,10},{-10,10}},
              color={255,128,0},
              smooth=Smooth.None));
          connect(stator.port_n, airGap.port_sp) annotation (Line(
              points={{-10,30},{-10,10}},
              color={255,128,0},
              smooth=Smooth.None));
          connect(stator.port_p, airGap.port_sn) annotation (Line(
              points={{10,30},{10,10}},
              color={255,128,0},
              smooth=Smooth.None));
          connect(stator.heatPortWinding, internalThermalPort.heatPortStatorWinding)
            annotation (Line(
              points={{-10,44},{-40,44},{-40,-90}},
              color={191,0,0},
              smooth=Smooth.None));
          connect(stator.heatPortCore, internalThermalPort.heatPortStatorCore)
            annotation (Line(
              points={{-10,36},{-40,36},{-40,-90}},
              color={191,0,0},
              smooth=Smooth.None));
          annotation (Documentation(info="<HTML>
<p>This partial model for induction machines contains elements common in all machine models.</p>
</HTML>"),     Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                    {100,100}}),graphics={
                Rectangle(
                  extent={{80,-80},{120,-120}},
                  lineColor={192,192,192},
                  fillColor={192,192,192},
                  fillPattern=FillPattern.Solid),
                Line(points={{-50,100},{-20,100},{-20,70}}, color={0,0,255}),
                Line(points={{50,100},{20,100},{20,70}}, color={0,0,255}),
                Text(
                  extent={{-150,-120},{150,-180}},
                  lineColor={0,0,255},
                  textString="%name"),
                Line(
                  visible=not useSupport,
                  points={{80,-100},{120,-100}},
                  color={0,0,0},
                  smooth=Smooth.None),
                Line(
                  visible=not useSupport,
                  points={{90,-100},{80,-120}},
                  color={0,0,0},
                  smooth=Smooth.None),
                Line(
                  visible=not useSupport,
                  points={{100,-100},{90,-120}},
                  color={0,0,0},
                  smooth=Smooth.None),
                Line(
                  visible=not useSupport,
                  points={{110,-100},{100,-120}},
                  color={0,0,0},
                  smooth=Smooth.None),
                Line(
                  visible=not useSupport,
                  points={{120,-100},{110,-120}},
                  color={0,0,0},
                  smooth=Smooth.None)}));
        end PartialBasicInductionMachine;

        model StateSelector "Transform instantaneous values to space phasors and select states"
          import Modelica.Constants.pi;
          parameter Integer m(min=3) = 3 "Number of phases";
          input Real xi[m](each stateSelect=StateSelect.avoid) "Instantaneous values"
                                   annotation (Dialog);
          input Modelica.SIunits.Angle gamma "Angle of rotation" annotation (Dialog);
          parameter StateSelect x0StateSelect=StateSelect.prefer "Priority to use zero systems as states";
          parameter StateSelect xrStateSelect=StateSelect.prefer "Priority to use space phasors w.r.t. rotating frame as states";
          Real x0(stateSelect=x0StateSelect) = 1/sqrt(m)*sum(xi) "Zero system";
          Real x00(stateSelect=x0StateSelect) = 1/sqrt(m)*sum({xi[2*l - 1] - xi[2*l]
            for l in 1:integer(m/2)}) if m == 2*integer(m/2) "Second zero system, if present (mp even)";
          final parameter Integer np=integer((m - 1)/2) "Number of space phasors";
          Complex xf[np](each re(stateSelect=StateSelect.avoid), each im(
                stateSelect=StateSelect.avoid)) "Space phasors w.r.t. fixed frame";
          Complex xr[np](each re(stateSelect=xrStateSelect), each im(stateSelect=
                  xrStateSelect)) "Space phasors w.r.t. rotating frame";
        equation
          //space phasor transformations
          for k in 1:np loop
            xf[k].re = 1/sqrt(m)*sum({cos(k*(l - 1)*2*pi/m)*xi[l] for l in 1:m});
            xf[k].im = 1/sqrt(m)*sum({sin(k*(l - 1)*2*pi/m)*xi[l] for l in 1:m});
            xr[k] = xf[k]*Modelica.ComplexMath.conj(Modelica.ComplexMath.exp(
              Complex(0, gamma)));
          end for;
          annotation (Documentation(info="<html>
<p>
Transforms instantaneous values into space phasors and zero system currents,
rotates space phasors and sets stateSelect modifiers in order to choose states w.r.t. rotating frame,
i.e., with small derivatives.
</p>
</html>"),     Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}), graphics={
                Ellipse(
                  extent={{-60,60},{60,-60}},
                  lineColor={170,213,255},
                  fillColor={170,213,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-60,60},{60,-60}},
                  textString="S",
                  lineColor={0,0,255},
                  fillColor={255,170,85},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{0,-60},{0,-100}},
                  lineColor={0,0,255},
                  textString="%name")}));
        end StateSelector;

        model PositivePortInterface "Postive port interface to FluxTubes"
          Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.PositiveMagneticPort
            port "FundamentalWave port"
            annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
          Modelica.Magnetic.FluxTubes.Interfaces.PositiveMagneticPort port_re "Flux tubes port, real part"
            annotation (Placement(transformation(extent={{90,90},{110,110}})));
          Modelica.Magnetic.FluxTubes.Interfaces.PositiveMagneticPort port_im "Flux tubes port, imag part"
            annotation (Placement(transformation(extent={{90,-108},{110,-88}})));
        equation
          port.V_m.re = port_re.V_m;
          port.V_m.im = port_im.V_m;
          port.Phi.re + port_re.Phi = 0;
          port.Phi.im + port_im.Phi = 0;
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={
                Line(
                  points={{-100,0},{0,0},{100,100}},
                  color={255,128,0},
                  smooth=Smooth.None),
                Line(
                  points={{0,0},{100,-100}},
                  color={255,128,0},
                  smooth=Smooth.None),
                Text(
                  extent={{80,80},{120,40}},
                  lineColor={255,128,0},
                  textString="re"),
                Text(
                  extent={{80,-40},{120,-80}},
                  lineColor={255,128,0},
                  textString="im")}),
            Documentation(info="<html>
<p>Connects a FundamentalWave port with a real and imaginary part FluxTube port.</p>
</html>"));
        end PositivePortInterface;

        model NegativePortInterface "Negative port interface to FluxTubes"
          Modelica_AddOn.Magnetic.FundamentalWave.Interfaces.NegativeMagneticPort
            port "FundamentalWave port"
            annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
          Modelica.Magnetic.FluxTubes.Interfaces.NegativeMagneticPort port_re "Flux tubes port, real part"
            annotation (Placement(transformation(extent={{90,90},{110,110}})));
          Modelica.Magnetic.FluxTubes.Interfaces.NegativeMagneticPort port_im "Flux tubes port, imag part"
            annotation (Placement(transformation(extent={{90,-108},{110,-88}})));
        equation
          port.V_m.re = port_re.V_m;
          port.V_m.im = port_im.V_m;
          port.Phi.re + port_re.Phi = 0;
          port.Phi.im + port_im.Phi = 0;
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}),graphics),
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}}), graphics={
                Line(
                  points={{-100,0},{0,0},{100,100}},
                  color={255,128,0},
                  smooth=Smooth.None),
                Line(
                  points={{0,0},{100,-100}},
                  color={255,128,0},
                  smooth=Smooth.None),
                Text(
                  extent={{80,80},{120,40}},
                  lineColor={255,128,0},
                  textString="re"),
                Text(
                  extent={{80,-40},{120,-80}},
                  lineColor={255,128,0},
                  textString="im")}),
            Documentation(info="<html>
<p>Connects a FundamentalWave port with a real and imaginary part FluxTube port.</p>
</html>"));
        end NegativePortInterface;
        annotation (Documentation(info="<html>
<p>
This package contains interface definitions of the magnetic ports as well as partial models.
</p>
</html>"));
      end Interfaces;

      package Types "Definition of salient types"
        extends Modelica.Icons.TypesPackage;
        record Salient "Base record of saliency with d and q component"
          replaceable Real d "Component of d (direct) axis, aligned to real part";
          replaceable Real q "Component of q (quadrature) axis, aligned to imaginary part";
          annotation (Documentation(info="<html>
<p>
Definition of saliency with respect to the orthogonal d- and q-axis. Saliency, however, refers to different properties in d- and q-axis and thus considers the anisotropic behavior.
</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientCurrent\">SalientCurrent</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientVoltage\">SalientVoltage</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientInductance\">SalientInductance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientReluctance\">SalientReluctance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientResistance\">SalientResistance</a>
</p>

</html>"));
        end Salient;

        record SalientCurrent = Salient (redeclare Modelica.SIunits.Current d,
              redeclare Modelica.SIunits.Current q) "Salient current" annotation (
            Documentation(info="<html>
<p>Type representing the d- and q-axis of a current phasor.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.Salient\">Salient</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientVoltage\">SalientVoltage</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientResistance\">SalientResistance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientInductance\">SalientInductance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientReluctance\">SalientReluctance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientPermeance\">SalientPermeance</a>
</p>

</html>"));
        record SalientVoltage = Salient (redeclare Modelica.SIunits.Voltage d,
              redeclare Modelica.SIunits.Voltage q) "Salient voltage" annotation (
            Documentation(info="<html>
<p>Type representing the d- and q-axis of a voltage phasor.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.Salient\">Salient</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientCurrent\">SalientCurrent</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientResistance\">SalientResistance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientInductance\">SalientInductance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientReluctance\">SalientReluctance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientPermeance\">SalientPermeance</a>
</p>

</html>"));
        record SalientResistance = Salient (redeclare Modelica.SIunits.Resistance d,
              redeclare Modelica.SIunits.Resistance q) "Salient resistance"
          annotation (Documentation(info="<html>
<p>Type representing the d- and q-axis of an resistance with respect to the fundamental wave.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.Salient\">Salient</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientCurrent\">SalientCurrent</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientVoltage\">SalientVoltage</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientInductance\">SalientInductance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientReluctance\">SalientReluctance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientPermeance\">SalientPermeance</a>
</p>

</html>"));
        record SalientInductance = Salient (redeclare Modelica.SIunits.Inductance d,
              redeclare Modelica.SIunits.Inductance q) "Salient inductance"
          annotation (Documentation(info="<html>
<p>Type representing the d- and q-axis of an inductance with respect to the fundamental wave.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.Salient\">Salient</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientCurrent\">SalientCurrent</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientVoltage\">SalientVoltage</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientResistance\">SalientResistance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientReluctance\">SalientReluctance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientPermeance\">SalientPermeance</a>
</p>

</html>"));
        record SalientReluctance = Salient (redeclare Modelica.SIunits.Reluctance d,
              redeclare Modelica.SIunits.Reluctance q) "Salient reluctance"
          annotation (Documentation(info="<html>
<p>Type representing the d- and q-axis of an reluctance with respect to the fundamental wave.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.Salient\">Salient</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientCurrent\">SalientCurrent</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientVoltage\">SalientVoltage</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientResistance\">SalientResistance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientInductance\">SalientInductance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientPermeance\">SalientPermeance</a>
</p>

</html>"));
        record SalientPermeance = Salient (redeclare Modelica.SIunits.Permeance d,
              redeclare Modelica.SIunits.Permeance q) "Salient permeance"
          annotation (Documentation(info="<html>
<p>Type representing the d- and q-axis of an reluctance with respect to the fundamental wave.</p>

<h4>See also</h4>
<p>
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.Salient\">Salient</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientCurrent\">SalientCurrent</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientVoltage\">SalientVoltage</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientResistance\">SalientResistance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientInductance\">SalientInductance</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Types.SalientReluctance\">SalientReluctance</a>
</p>

</html>"));
        annotation (Documentation(info="<html>
<p>This package provides types for modeling anisotropic saliency effects in electric machines. These saliencies are usually considered by a d- (direct) and q-axis (quadrature) components in the respective axis (of the rotor).</p>
</html>"));
      end Types;
      annotation (preferredView="info", Documentation(revisions="<html>

<p>A detailed list of changes is summarized in the <a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.ReleaseNotes\">release notes</a>.</p>

</html>",     info="<html>
<p>
Copyright &copy; 2009-2014, Modelica Association, <a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.Contact\">Christian Kral</a>,
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide.Contact\">Anton Haumer</a> and AIT
</p>
<p>
<i>This Modelica package is <u>free</u> software and the use is completely at <u>your own risk</u>; it can be redistributed and/or modified under the terms of the Modelica License 2. For license conditions (including the disclaimer of warranty) see <a href=\"modelica://Modelica.UsersGuide.ModelicaLicense2\">Modelica.UsersGuide.ModelicaLicense2</a> or visit <a href=\"https://www.modelica.org/licenses/ModelicaLicense2\"> https://www.modelica.org/licenses/ModelicaLicense2</a>.</i>
</p>
</html>"));
    end FundamentalWave;

    package QuasiStatic "Quasi static magnetic"
    extends Modelica.Icons.Package;
      package FundamentalWave "Quasi static fundamental wave electric machines"
        extends Modelica.Icons.Package;
        package UsersGuide "User's Guide"
          extends Modelica.Icons.Information;
          class Concept "Fundamental wave concept"
            extends Modelica.Icons.Information;
            annotation (Documentation(info="<html>
<h5>Reference frames</h5>

<p>Quasi static  magnetic ports contain the complex magnetic flux (flow variable) and the comlplex magnetic potential difference (potential variable) and a reference ange. The relationship between the different complex phasors with respect to different refrences will be explained by means of the complex magnetic flux. The same transformation relationships the also apply to the complex magnetic potential difference. However, the discussed relationsships are important for handling connectors in the air gap model, transform equations into the rotor fixed reference frame, etc. </p>

<p>
Let us assume that the air gap model contains stator and rotor magnetic ports which relate to the different sides of the machine. The anlge relationship between these ports is
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/gamma_relationship.png\"/>, 
</p>

<p>where
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/gamma_s.png\"/> 
is the connector reference angle of the stator ports,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/gamma_r.png\"/> 
is the connector reference angle of the rotor ports, and
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/gamma_mechanical.png\"/> 
is the difference of the mechanical angles of the flange and the support, respectively, 
multiplied by the number of pole pairs,
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/p.png\"/>. 
The stator and rotor reference angles are directly related with the electrical frequencies of the 
electric circuits of the stator, 
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/f_s.png\"/>,
and rotor, 
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/f_r.png\"/>,
respectively, by means of:
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/gamma_f.png\"/>
</p>

<p>
This is a strict consequence of the elctro magnetic coupling between the quasi static electric and the quasi static magnetic domain.</p>


<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Fig. 1:</b> Reference frames of the quasi static fundamental wave library</caption>
  <tr>
    <td>
      <img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/ReferenceFrames.png\"/>
    </td>
  </tr>
</table>

<p>
The complex magnetic flux with respect a stator and rotor magnetic port are equal, 
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/Phi(ref)=Phi,re+jPhi,im.png\"/>,
</p>

<p>
but the reference phase angles are different according to the relationship explained above. The stator and rotor reference angles refer to quasi static magnetic connectors. The complex magnetic flux of the (stator) port with respect to the <b>stator fixed</b> reference frame is then calculated by</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/Phi_s_ref.png\"/>.
</p>

<p>
The complex magnetic flux of the (rotor) magnetic port with respect to the <b>rotor fixed</b> reference frame is then calculated by</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/Phi_r_ref.png\"/>.
</p>

<p>
The two stator and rotor fixed complex fluxes are related by</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Magnetic/QuasiStatic/FundamentalWave/Phi_r_s.png\"/>.
</p>

</html>"));
          end Concept;

          class Contact "Contact"
            extends Modelica.Icons.Contact;
            annotation (Documentation(info="<html>
<h4>Contact</h4>

<p>
  Dr. Christian Kral<br>
  <a href=\"http://christiankral.net/\">Electric Machines, Drives and Systems</a><br>
  A-1060 Vienna, Austria<br>
  email: <a href=\"mailto:dr.christian.kral@gmail.com\">dr.christian.kral@gmail.com</a>
</p>

<p>
Anton Haumer<br>
<a href=\"http://www.haumer.at\">Technical Consulting &amp; Electrical Engineering</a><br>
3423 St. Andrae-Woerdern, Austria<br>
email: <a HREF=\"mailto:a.haumer@haumer.at\">a.haumer@haumer.at</a><br>
</p>

</html>"));
          end Contact;

          class ReleaseNotes "Release Notes"
            extends Modelica.Icons.ReleaseNotes;
            annotation (Documentation(info="<html>
<h5>Version local in Modelica_AddOn, 2015-07-01</h5>
<ul>
<li>Replaced stray reluctances by permeances in order to consider zero leakage inductances </li>
</ul>
<h5>Version 3.2.2, 2015-02-02</h5>
<ul>
<li>Restructuring of components in Interfaces and BasesClasses</li>
<li>Migration of library to MSL trunk</li>
<li>Update and improvement of documentation</li>
<li>Added new component:</li>
<ul>
    <li><a href=\"modelica://Modelica.Magnetic.FundamentalWave.Components.Permeance\">Permenace</a></li>   
</ul>
<li>Removed parameter text from icon layer for reluctance and permeance model</li>
<li>Fixed issues of ticket #1524</li>
<li>Restructured cage models with reluctance instead of inductance model according to ticket #1537</li>
<li>Bug fixes according to #1226</li>
<li>Added magnitude and argument of complex magnetic potentials, magnetic fluxes, voltages and currents in interface, electromagnetic coupling and machine models, see #1405</li>
<li>Added active, reactive and aparrent power and power factor in interface and machine models, see #1405</li>
<li>Added new interface model 
<a href=\"modelica://Modelica.Magnetic.QuasiStatic.FundamentalWave.Interfaces.PartialTwoPortExtended\">PartialTwoPortExtended</a>
to simplify consistent inclusion of variables, see #1405</li>
</ul>

<h5>Version 0.4.1, 2013-12-18</h5>
<ul>
<li>Renamed base magnetic port to MagneticPort</li>
<li>Bug fix of single to multi phase converter</li>
<li>Bug fix of phase number propagation in SaliencyCageWinding fixed</li>
<li>Improved documentation of library</li>
<li>Added current controlled SMR example and indicated SMR inverter example as obsolete</li>
<li>Improved example of mains supplied SMPM with damper cage</li>
</ul>

<h5>Version 0.4.0, 2013-11-13</h5>
<ul>
<li>Renamed all machine class names according to #1348</li>
</ul>

<h5>Version 0.3.0, 2013-11-07</h5>
<ul>
<li>Renamed the library from QuasiStationaryFundamantalWave to QuasiStaticFundamantalWave according to #1344</li>
</ul>

<h5>Version 0.2.5, 2013-11-06</h5>
<ul>
<li>Changed implementation of symmetrical components: symmetricTransformationMatrix(m) is now multiplied by numberOfSymmetricBaseSystems(m) in order to overcome differences in calculation of current and voltage symmetrical components. The symmetrical components of a system of even phase numbers are now equal to the symmetrical components of one corresponding base system. </li>
<li>Imporoved examples package and removed SMPM_Inverter example</li>
</ul>

<h5>Version 0.2.4, 2013-10-02</h5>
<ul>
<li>Implemented induction machine with squirrel cage example with inverter</li>
<li>Alternative implementation of transformation matrix for faster compilation in Dymola</li>
</ul>

<h5>Version 0.2.3, 2013-09-25</h5>
<ul>
<li>Adapted sine / cosine of QS V/f-converter to match transient behavior</li>
</ul>

<h5>Version 0.2.2, 2013-09-24</h5>
<ul>
<li>Fixed initialization of examples (changed implementation of QuasiStationary.Sources, added start values for gamma, gammas, gammar)</li>
</ul>

<h5>Vrsion 0.2.1, 2013-09-23</h5>
<ul>
<li>Implemented pemanent magnet synchronous machine example with inverter</li>
</ul>

<h5>Version 0.2.0, 2013-09-01</h5>
<ul>
<li>Implemented induction machine with slip ring rotor including example</li>
<li>Implemented magnetic crossing </li>
</ul>

<h5>Version 0.1.0, 2013-08-27</h5>
<ul>
<li>Documentation of <a href=\"modelica://Modelica.Magnetic.QuasiStatic.FundamentalWave.UsersGuide.Concept\">phasor concept</a></li>
<li>Connections.branch between electric and magnetic quasi static connectors to handle open circuit and motor operation of machines</li>
<li>Saliency effects are properly considered</li>
<li>Electromagnetic coupling with Analog domain is implemented fully quasi static with v = 0 at the electric connectors -- this may have to be changed in the future</li>
<li>Implemented machine types</li>
<li><ul>
<li>Induction machine with squirrel cage </li>
<li>Permanent magnet synchronous machine with optional damper cage </li>
<li>Electrical excited synchronous machine with optional damper cage (may be removed in first release) </li>
<li>Synchronous reluctance machine with optional damper cage (may be removed in first release) </li>
</ul></li>
</ul>
</html>"));
          end ReleaseNotes;

          class References "References"
            extends Modelica.Icons.References;
            annotation (Documentation(info="<html>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td valign=\"top\">[Lang1984]</td>
      <td valign=\"top\">W. Lang,
        &quot;&Uuml;ber die Bemessung verlustarmer Asynchronmotoren mit K&auml;figl&auml;ufer f&uuml;r 
        Pulsumrichterspeisung,&quot;
        Doctoral Thesis,
        Technical University of Vienna, 1984.</td>
    </tr>
</table>
</html>"));
          end References;
          annotation (Documentation(info="<html>
<p>
This is the library of quasi static fundamental wave models for multi phase electric machines. This is a complementary library to transient machine models of
<a href=\"modelica://Modelica.Magnetic.FundamentalWave\">Modelica.Magnetic.FundamentalWave</a>.
</p>

</html>"));
        end UsersGuide;

        package Examples "Examples"
          extends Modelica.Icons.ExamplesPackage;
          package Components "Examples for testing quasi static fundamental wave components"
            extends Modelica.Icons.ExamplesPackage;
            model MultiPhaseInductance "Multi phase inductance"
              extends Modelica.Icons.Example;
              parameter Integer m=5 "Number of phases";
              parameter Modelica.SIunits.Frequency f=1 "Supply frequency";
              parameter Modelica.SIunits.Voltage VRMS=100 "RMS supply voltage";
              parameter Modelica.SIunits.Resistance R=1E-5 "Resistance";
              parameter Modelica.SIunits.Inductance L=1 "Load inductance";
              parameter Real effectiveTurns=5 "Effective number of turns";
              // Symmetrical multi phase magnetic reluctance
              final parameter Modelica.SIunits.Reluctance R_m=m*effectiveTurns^2/2/L "Equivalent magnetic reluctance";
              Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground_e
                annotation (Placement(transformation(extent={{-70,10},{-50,30}})));
              Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground_m
                annotation (Placement(transformation(extent={{-70,-90},{-50,-70}})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star star_e(m=m)
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-60,40})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star star_m(m=m)
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-60,-60})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VoltageSource
                voltageSource_e(
                m=m,
                f=f,
                phi=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                V=fill(VRMS, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-60,70})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VoltageSource
                voltageSource_m(
                m=m,
                f=f,
                phi=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                V=fill(VRMS, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-60,-30})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Resistor
                resistor_e(m=m, R_ref=fill(R*m/3, m))
                annotation (Placement(transformation(extent={{-40,70},{-20,90}})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Resistor
                resistor_m(m=m, R_ref=fill(R*m/3, m))
                annotation (Placement(transformation(extent={{-40,-30},{-20,-10}})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Inductor
                inductor_e(m=m, L=fill(L, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={0,70})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
                converter_m(m=m, effectiveTurns=effectiveTurns)
                annotation (Placement(transformation(extent={{0,-40},{20,-20}})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.Reluctance
                reluctance_m(R_m(d=R_m, q=R_m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={60,-30})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.Ground
                groundM_m
                annotation (Placement(transformation(extent={{10,-90},{30,-70}})));
            equation
              connect(star_e.pin_n, ground_e.pin) annotation (Line(
                  points={{-60,30},{-60,30}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(star_e.plug_p, voltageSource_e.plug_n) annotation (Line(
                  points={{-60,50},{-60,60}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(voltageSource_e.plug_n, inductor_e.plug_n) annotation (Line(
                  points={{-60,60},{0,60}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(converter_m.port_p, reluctance_m.port_p) annotation (Line(
                  points={{20,-20},{60,-20}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(converter_m.port_n, reluctance_m.port_n) annotation (Line(
                  points={{20,-40},{60,-40}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(converter_m.port_n, groundM_m.port_p) annotation (Line(
                  points={{20,-40},{20,-70}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(voltageSource_m.plug_n, star_m.plug_p) annotation (Line(
                  points={{-60,-40},{-60,-50}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(star_m.pin_n, ground_m.pin) annotation (Line(
                  points={{-60,-70},{-60,-70}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(voltageSource_m.plug_n, converter_m.plug_n) annotation (Line(
                  points={{-60,-40},{0,-40}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(voltageSource_e.plug_p, resistor_e.plug_p) annotation (Line(
                  points={{-60,80},{-40,80}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(resistor_e.plug_n, inductor_e.plug_p) annotation (Line(
                  points={{-20,80},{0,80}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(voltageSource_m.plug_p, resistor_m.plug_p) annotation (Line(
                  points={{-60,-20},{-40,-20}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(resistor_m.plug_n, converter_m.plug_p) annotation (Line(
                  points={{-20,-20},{0,-20}},
                  color={85,170,255},
                  smooth=Smooth.None));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent=
                        {{-100,-100},{100,100}}), graphics), experiment(StopTime=100,
                    Interval=0.01));
            end MultiPhaseInductance;

            model EddyCurrentLosses "Comparison of equivalent circuits of eddy current loss models"
              extends Modelica.Icons.Example;
              constant Integer m=3 "Number of phases";
              // ## Original value R = 0.1 Ohm
              parameter Modelica.SIunits.Resistance R=0.1 "Resistance";
              parameter Modelica.SIunits.Conductance Gc=0.0001 "Loss conductance";
              parameter Modelica.SIunits.Reluctance R_m=1 "Reluctance of the magnetic circuit";
              parameter Real N=1 "Number of turns";
              output Modelica.SIunits.Power lossPower_e=sum(loss_e.conductor.LossPower);
              output Modelica.SIunits.Power lossPower_m=loss_m.lossPower;
              Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground_e
                annotation (Placement(transformation(extent={{-90,0},{-70,20}})));
              Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground_m
                annotation (Placement(transformation(extent={{-90,-90},{-70,-70}})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star star_e(m=m)
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,30})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star star_m(m=m)
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-60})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VoltageSource
                sineVoltage_e(
                m=m,
                f=1,
                phi=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                V=fill(1/sqrt(2), m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,60})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VoltageSource
                sineVoltage_m(
                m=m,
                f=1,
                phi=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(m),
                V=fill(1/sqrt(2), m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={-80,-30})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Resistor
                resistor_e(m=m, R_ref=fill(R*m/3, m)) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-60,70})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Resistor
                resistor_m(m=m, R_ref=fill(R*m/3, m)) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-60,-20})));
              Electrical.QuasiStatic.MultiPhase.Sensors.PowerSensor powerb_e(m=m)
                annotation (Placement(transformation(extent={{-40,60},{-20,80}})));
              Electrical.QuasiStatic.MultiPhase.Sensors.PowerSensor powerb_m(m=m)
                annotation (Placement(transformation(extent={{-40,-30},{-20,-10}})));
              Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Conductor loss_e(m=
                   m, G_ref=fill(Gc*3/m, m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={0,60})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
                converter_e(effectiveTurns=N)
                annotation (Placement(transformation(extent={{20,50},{40,70}})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.MultiPhaseElectroMagneticConverter
                converter_m(effectiveTurns=N)
                annotation (Placement(transformation(extent={{20,-40},{40,-20}})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.EddyCurrent
                loss_m(G=m*N^2*Gc/2) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={60,-20})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.Reluctance
                reluctance_e(R_m(d=R_m, q=R_m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={80,60})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.Reluctance
                reluctance_m(R_m(d=R_m, q=R_m)) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=270,
                    origin={80,-30})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.Ground
                mground_e
                annotation (Placement(transformation(extent={{30,0},{50,20}})));
              Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.Components.Ground
                mground_m
                annotation (Placement(transformation(extent={{30,-90},{50,-70}})));
            equation
              connect(sineVoltage_e.plug_n, converter_e.plug_n) annotation (Line(
                  points={{-80,50},{20,50}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(sineVoltage_e.plug_n, star_e.plug_p) annotation (Line(
                  points={{-80,50},{-80,40}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(converter_e.port_p, reluctance_e.port_p) annotation (Line(
                  points={{40,70},{80,70}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(converter_e.port_n, reluctance_e.port_n) annotation (Line(
                  points={{40,50},{80,50}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(converter_e.port_n, mground_e.port_p) annotation (Line(
                  points={{40,50},{40,20}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(resistor_e.plug_p, sineVoltage_e.plug_p) annotation (Line(
                  points={{-70,70},{-80,70}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(loss_e.plug_n, sineVoltage_e.plug_n) annotation (Line(
                  points={{0,50},{-80,50}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(loss_e.plug_p, converter_e.plug_p) annotation (Line(
                  points={{0,70},{20,70}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(resistor_e.plug_n, powerb_e.currentP) annotation (Line(
                  points={{-50,70},{-40,70}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(powerb_e.currentN, converter_e.plug_p) annotation (Line(
                  points={{-20,70},{20,70}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(star_e.pin_n, ground_e.pin) annotation (Line(
                  points={{-80,20},{-80,20}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(powerb_e.currentP, powerb_e.voltageP) annotation (Line(
                  points={{-40,70},{-40,80},{-30,80}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(powerb_e.voltageN, sineVoltage_e.plug_n) annotation (Line(
                  points={{-30,60},{-30,50},{-80,50}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(sineVoltage_m.plug_n, star_m.plug_p) annotation (Line(
                  points={{-80,-40},{-80,-50}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(sineVoltage_m.plug_n, converter_m.plug_n) annotation (Line(
                  points={{-80,-40},{20,-40}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(converter_m.port_n, reluctance_m.port_n) annotation (Line(
                  points={{40,-40},{80,-40}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(converter_m.port_p, loss_m.port_p) annotation (Line(
                  points={{40,-20},{50,-20}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(loss_m.port_n, reluctance_m.port_p) annotation (Line(
                  points={{70,-20},{80,-20}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(converter_m.port_n, mground_m.port_p) annotation (Line(
                  points={{40,-40},{40,-70}},
                  color={255,170,85},
                  smooth=Smooth.None));
              connect(sineVoltage_m.plug_p, resistor_m.plug_p) annotation (Line(
                  points={{-80,-20},{-70,-20}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(resistor_m.plug_n, powerb_m.currentP) annotation (Line(
                  points={{-50,-20},{-40,-20}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(powerb_m.currentN, converter_m.plug_p) annotation (Line(
                  points={{-20,-20},{20,-20}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(star_m.pin_n, ground_m.pin) annotation (Line(
                  points={{-80,-70},{-80,-70}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(powerb_m.currentP, powerb_m.voltageP) annotation (Line(
                  points={{-40,-20},{-40,-10},{-30,-10}},
                  color={85,170,255},
                  smooth=Smooth.None));
              connect(powerb_m.voltageN, sineVoltage_m.plug_n) annotation (Line(
                  points={{-30,-30},{-30,-40},{-80,-40}},
                  color={85,170,255},
                  smooth=Smooth.None));
              annotation (
                experiment(StopTime=40, Interval=0.01),
                Documentation(info="<html>
<p>
In this example the eddy current losses are implemented in two different ways. Compare the loss dissipation <code>powerb_e.power</code> and <code>powerb_m.power</code> of the two models indicated by power meters.</p>
</html>"),      Diagram(coordinateSystem(extent={{-100,-100},{100,100}},
                      preserveAspectRatio=false), graphics),
                Icon(coordinateSystem(extent={{-100,-100},{100,100}})));
            end EddyCurrentLosses;
          end Components;

          package BasicMachines "Examples of basic machines"
            extends Modelica.Icons.ExamplesPackage;
            package InductionMachines "Induction machine examples"
              extends Modelica.Icons.ExamplesPackage;
              model IMC_DOL "Induction machines with squirrel cage started directly on line (DOL)"
                import Modelica.Constants.pi;
                extends Modelica.Icons.Example;
                parameter Integer m=5 "Number of phases";
                parameter Modelica.SIunits.Voltage VsNominal=100 "Nominal RMS voltage per phase";
                parameter Modelica.SIunits.Frequency fNominal=50 "Nominal frequency";
                parameter Modelica.SIunits.Time tOn=0.1 "Start time of machine";
                parameter Modelica.SIunits.Torque T_Load=161.4 "Nominal load torque";
                parameter Modelica.SIunits.AngularVelocity w_Load(displayUnit="1/min")=
                     1440.45*2*Modelica.Constants.pi/60 "Nominal load speed";
                parameter Modelica.SIunits.Inertia J_Load=0.5 "Load inertia";
                parameter Integer p=2 "Number of pole pairs";
                Modelica.Electrical.QuasiStationary.MultiPhase.Sources.VoltageSource
                  voltageSourceQS(
                  m=m,
                  f=fNominal,
                  V=fill(VsNominal, m),
                  phi=-Modelica.Electrical.MultiPhase.Functions.symmetricOrientation(
                      m)) annotation (Placement(transformation(
                      origin={-60,40},
                      extent={{-10,-10},{10,10}},
                      rotation=270)));
                Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star starQS(m=m)
                  annotation (Placement(transformation(
                      origin={-70,20},
                      extent={{-10,-10},{10,10}},
                      rotation=180)));
                Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground groundQS
                  annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=270,
                      origin={-90,20})));
                Modelica_AddOn.Electrical.QuasiStatic.MultiPhase.Sensors.PowerSensor
                  powerSensorQS(m=m) annotation (Placement(transformation(extent={{-60,
                          70},{-40,90}}, rotation=0)));
                Modelica.Electrical.QuasiStationary.MultiPhase.Sensors.CurrentSensor
                  currentSensorQS(m=m) annotation (Placement(transformation(extent={{
                          -30,70},{-10,90}}, rotation=0)));
                Modelica.Electrical.QuasiStationary.MultiPhase.Ideal.IdealClosingSwitch
                  idealCloserQS(
                  final m=m,
                  Ron=fill(1e-5*m/3, m),
                  Goff=fill(1e-5*3/m, m)) annotation (Placement(transformation(
                      origin={-60,70},
                      extent={{10,10},{-10,-10}},
                      rotation=270)));
                Modelica.Blocks.Sources.BooleanStep booleanStepQS[m](each startTime=
                      tOn, each startValue=false) annotation (Placement(
                      transformation(extent={{-96,60},{-76,80}}, rotation=0)));
                Modelica.Electrical.Analog.Basic.Ground ground annotation (Placement(
                      transformation(
                      origin={-90,-80},
                      extent={{-10,-10},{10,10}},
                      rotation=270)));
                Modelica.Electrical.MultiPhase.Basic.Star star(final m=m) annotation (
                   Placement(transformation(extent={{-60,-90},{-80,-70}}, rotation=0)));
                Modelica.Electrical.MultiPhase.Sources.CosineVoltage cosineVoltage(
                  final m=m,
                  freqHz=fill(fNominal, m),
                  V=fill(sqrt(2.0)*VsNominal, m)) annotation (Placement(
                      transformation(
                      origin={-60,-60},
                      extent={{10,-10},{-10,10}},
                      rotation=90)));
                Modelica.Electrical.MultiPhase.Ideal.IdealClosingSwitch idealCloser(
                  final m=m,
                  Ron=fill(1e-5*m/3, m),
                  Goff=fill(1e-5*3/m, m)) annotation (Placement(transformation(
                      origin={-60,-30},
                      extent={{10,10},{-10,-10}},
                      rotation=270)));
                Modelica.Blocks.Sources.BooleanStep booleanStep[m](each startTime=tOn,
                    each startValue=false) annotation (Placement(transformation(
                        extent={{-96,-40},{-76,-20}}, rotation=0)));
                Modelica.Electrical.MultiPhase.Sensors.CurrentQuasiRMSSensor
                  currentRMSsensor(final m=m) annotation (Placement(transformation(
                      origin={-20,-20},
                      extent={{-10,-10},{10,10}},
                      rotation=0)));
                Modelica.Electrical.Machines.Utilities.TerminalBox terminalBoxM(m=m,
                    terminalConnection="Y") annotation (Placement(transformation(
                        extent={{20,-60},{40,-40}}, rotation=0)));
                Modelica_AddOn.Magnetic.FundamentalWave.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage
                  imc(
                  Jr=imcData.Jr,
                  Js=imcData.Js,
                  p=imcData.p,
                  fsNominal=imcData.fsNominal,
                  TsRef=imcData.TsRef,
                  alpha20s(displayUnit="1/K") = imcData.alpha20s,
                  frictionParameters=imcData.frictionParameters,
                  statorCoreParameters=imcData.statorCoreParameters,
                  strayLoadParameters=imcData.strayLoadParameters,
                  alpha20r(displayUnit="1/K") = imcData.alpha20r,
                  phiMechanical(fixed=true),
                  wMechanical(fixed=true),
                  Rs=imcData.Rs*m/3,
                  Lssigma=imcData.Lssigma*m/3,
                  Lszero=imcData.Lszero*m/3,
                  Lm=imcData.Lm*m/3,
                  Lrsigma=imcData.Lrsigma*m/3,
                  Rr=imcData.Rr*m/3,
                  TrRef=imcData.TrRef,
                  m=m,
                  TsOperational=293.15,
                  TrOperational=293.15) annotation (Placement(transformation(extent={
                          {20,-80},{40,-60}}, rotation=0)));
                Modelica.Mechanics.Rotational.Components.Inertia loadInertia(J=J_Load)
                  annotation (Placement(transformation(extent={{50,-80},{70,-60}},
                        rotation=0)));
                Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
                  quadraticLoadTorque(
                  w_nominal=w_Load,
                  tau_nominal=-T_Load,
                  TorqueDirection=false,
                  useSupport=false) annotation (Placement(transformation(extent={{100,
                          -80},{80,-60}}, rotation=0)));
                Modelica.Electrical.MultiPhase.Sensors.PowerSensor powerSensor(final
                    m=m) annotation (Placement(transformation(extent={{-60,-30},{-40,
                          -10}})));
                Modelica.Mechanics.Rotational.Components.Inertia loadInertiaQS(J=
                      J_Load) annotation (Placement(transformation(extent={{50,20},{
                          70,40}}, rotation=0)));
                Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque
                  quadraticLoadTorqueQS(
                  w_nominal=w_Load,
                  tau_nominal=-T_Load,
                  TorqueDirection=false,
                  useSupport=false) annotation (Placement(transformation(extent={{100,
                          20},{80,40}}, rotation=0)));
                parameter Modelica.Electrical.Machines.Utilities.ParameterRecords.AIM_SquirrelCageData
                  imcData "Machine data"
                  annotation (Placement(transformation(extent={{70,74},{90,94}})));
                Modelica_AddOn.Magnetic.QuasiStatic.FundamentalWave.BasicMachines.InductionMachines.IM_SquirrelCage
                  imcQS(
                  Jr=imcData.Jr,
                  Js=imcData.Js,
                  p=imcData.p,
                  fsNominal=imcData.fsNominal,
                  TsRef=imcData.TsRef,
                  alpha20s(displayUnit="1/K") = imcData.alpha20s,
                  frictionParameters=imcData.frictionParameters,
                  statorCoreParameters=imcData.statorCoreParameters,
                  strayLoadParameters=imcData.strayLoadParameters,
                  alpha20r(displayUnit="1/K") = imcData.alpha20r,
                  Rs=imcData.Rs*m/3,
                  Lssigma=imcData.Lssigma*m/3,
                  Lm=imcData.Lm*m/3,
                  Lrsigma=imcData.Lrsigma*m/3,
                  Rr=imcData.Rr*m/3,
                  TrRef=imcData.TrRef,
                  m=m,
                  wMechanical(fixed=true),
                  TsOperational=293.15,
                  gammar(fixed=true, start=pi/2),
                  gamma(fixed=true, start=-pi/2),
                  TrOperational=293.15) annotation (Placement(transformation(extent={
                          {20,20},{40,40}}, rotation=0)));
                Modelica_AddOn.Electrical.QuasiStatic.MultiPhase.Blocks.SymmetricalComponents
                  symmetricalComponents(m=m) annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=270,
                      origin={-20,50})));
                Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground
                  groundMachineQS annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=0,
                      origin={10,10})));
                Modelica.Electrical.QuasiStationary.MultiPhase.Basic.Star
                  starMachineQS(m=
                      Modelica_AddOn.Electrical.MultiPhase.Functions.numberOfSymmetricBaseSystems(
                      m)) annotation (Placement(transformation(
                      extent={{-10,10},{10,-10}},
                      rotation=270,
                      origin={10,30})));
                Utilities.MultiTerminalBox terminalBoxQS(m=m, terminalConnection="Y")
                  annotation (Placement(transformation(extent={{20,40},{40,60}},
                        rotation=0)));
              initial equation
                imc.is[1:2] = zeros(2);
                imc.rotorCage.electroMagneticConverter.Phi = Complex(0, 0);
              equation
                connect(groundQS.pin, starQS.pin_n)
                  annotation (Line(points={{-80,20},{-80,20}}, color={85,170,255}));
                connect(starQS.plug_p, voltageSourceQS.plug_n)
                  annotation (Line(points={{-60,20},{-60,30}}, color={85,170,255}));
                connect(powerSensorQS.currentN, currentSensorQS.plug_p)
                  annotation (Line(points={{-40,80},{-30,80}}, color={85,170,255}));
                connect(powerSensorQS.voltageP, powerSensorQS.currentP) annotation (
                    Line(points={{-50,90},{-60,90},{-60,80}}, color={85,170,255}));
                connect(powerSensorQS.voltageN, starQS.plug_p) annotation (Line(
                      points={{-50,70},{-50,20},{-60,20}}, color={85,170,255}));
                connect(booleanStepQS.y, idealCloserQS.control) annotation (Line(
                    points={{-75,70},{-67,70}},
                    color={255,0,255},
                    smooth=Smooth.None));
                connect(star.pin_n, ground.p)
                  annotation (Line(points={{-80,-80},{-80,-80}}, color={0,0,255}));
                connect(cosineVoltage.plug_n, star.plug_p)
                  annotation (Line(points={{-60,-70},{-60,-80}}, color={0,0,255}));
                connect(imc.flange, loadInertia.flange_a) annotation (Line(points={{
                        40,-70},{40,-70},{50,-70}}, color={0,0,0}));
                connect(loadInertia.flange_b, quadraticLoadTorque.flange)
                  annotation (Line(points={{70,-70},{80,-70}}, color={0,0,0}));
                connect(terminalBoxM.plug_sn, imc.plug_sn)
                  annotation (Line(points={{24,-60},{24,-60}}, color={0,0,255}));
                connect(terminalBoxM.plug_sp, imc.plug_sp)
                  annotation (Line(points={{36,-60},{36,-60}}, color={0,0,255}));
                connect(booleanStep.y, idealCloser.control) annotation (Line(
                    points={{-75,-30},{-67,-30}},
                    color={255,0,255},
                    smooth=Smooth.None));
                connect(idealCloser.plug_p, cosineVoltage.plug_p) annotation (Line(
                    points={{-60,-40},{-60,-50}},
                    color={0,0,255},
                    smooth=Smooth.None));
                connect(idealCloserQS.plug_p, voltageSourceQS.plug_p) annotation (
                    Line(
                    points={{-60,60},{-60,50}},
                    color={85,170,255},
                    smooth=Smooth.None));
                connect(idealCloserQS.plug_n, powerSensorQS.currentP) annotation (
                    Line(
                    points={{-60,80},{-60,80}},
                    color={85,170,255},
                    smooth=Smooth.None));
                connect(idealCloser.plug_n, powerSensor.pc) annotation (Line(
                    points={{-60,-20},{-60,-20}},
                    color={0,0,255},
                    smooth=Smooth.None));
                connect(powerSensor.nc, currentRMSsensor.plug_p) annotation (Line(
                    points={{-40,-20},{-30,-20}},
                    color={0,0,255},
                    smooth=Smooth.None));
                connect(currentRMSsensor.plug_n, terminalBoxM.plugSupply) annotation (
                   Line(
                    points={{-10,-20},{30,-20},{30,-58}},
                    color={0,0,255},
                    smooth=Smooth.None));
                connect(loadInertiaQS.flange_b, quadraticLoadTorqueQS.flange)
                  annotation (Line(points={{70,30},{80,30}}, color={0,0,0}));
                connect(powerSensor.pv, powerSensor.pc) annotation (Line(
                    points={{-50,-10},{-60,-10},{-60,-20}},
                    color={0,0,255},
                    smooth=Smooth.None));
                connect(powerSensor.nv, star.plug_p) annotation (Line(
                    points={{-50,-30},{-50,-80},{-60,-80}},
                    color={0,0,255},
                    smooth=Smooth.None));
                connect(imcQS.flange, loadInertiaQS.flange_a) annotation (Line(
                    points={{40,30},{50,30}},
                    color={0,0,0},
                    smooth=Smooth.None));
                connect(currentSensorQS.y, symmetricalComponents.u) annotation (Line(
                    points={{-20,69},{-20,62}},
                    color={85,170,255},
                    smooth=Smooth.None));
                connect(terminalBoxQS.plug_sn, imcQS.plug_sn) annotation (Line(
                    points={{24,40},{24,40}},
                    color={85,170,255},
                    smooth=Smooth.None));
                connect(terminalBoxQS.plug_sp, imcQS.plug_sp) annotation (Line(
                    points={{36,40},{36,40}},
                    color={85,170,255},
                    smooth=Smooth.None));
                connect(starMachineQS.plug_p, terminalBoxQS.starpoint) annotation (
                    Line(
                    points={{10,40},{10,42},{21,42}},
                    color={85,170,255},
                    smooth=Smooth.None));
                connect(currentSensorQS.plug_n, terminalBoxQS.plugSupply) annotation (
                   Line(
                    points={{-10,80},{30,80},{30,42}},
                    color={85,170,255},
                    smooth=Smooth.None));
                connect(starMachineQS.pin_n, groundMachineQS.pin) annotation (Line(
                    points={{10,20},{10,20}},
                    color={85,170,255},
                    smooth=Smooth.None));
                annotation (Diagram(coordinateSystem(preserveAspectRatio=false,
                        extent={{-100,-100},{100,100}}), graphics={Rectangle(
                                extent={{-100,98},{100,4}},
                                lineColor={0,0,255},
                                fillColor={255,255,170},
                            