model airconds
  constant Integer N = 100;
  parameter Real THA = 32;
  output Real ptotal;
  parameter Real CAP[100] = {598.249, 571.582, 645.025, 642.013, 564.766, 638.106, 614.108, 593.195, 611.96, 578.106, 628.6, 580.746, 594.703, 572.611, 568.753, 577.623, 605.644, 591.65, 566.961, 640.68, 560.317, 562.608, 599.544, 626.048, 648.475, 643.5, 618.445, 588.319, 624.977, 586.866, 579.416, 573.226, 608.449, 574.441, 565.239, 623.215, 562.547, 629.347, 566.41, 624.507, 557.453, 645.01, 555.253, 602.156, 567.621, 574.006, 629.78, 623.265, 615.656, 646.741, 613.946, 625.973, 559.348, 563.49, 602.021, 557.823, 556.991, 570.466, 596.142, 631.968, 607.332, 625.558, 555.194, 565.781, 649.999, 570.433, 638.996, 562.547, 649.78, 555.406, 637.054, 557.233, 550.416, 642.307, 609.389, 568.037, 566.313, 589.169, 641.303, 631.97, 585.91, 605.249, 607.943, 595.258, 618.739, 559.964, 603.081, 625.729, 580.43, 649.223, 607.697, 637.761, 624.781, 612.891, 553.542, 624.78, 633.324, 642.538, 637.327, 633.104};
  parameter Real RES[100] = {2.28972, 2.17191, 2.25168, 2.2918, 2.13344, 2.04863, 1.88198, 2.21501, 2.24447, 1.8385, 2.12485, 1.92402, 2.11474, 1.91457, 2.15031, 1.95843, 1.96439, 1.91571, 1.83708, 2.11654, 1.91183, 2.12557, 2.05534, 2.28573, 1.94002, 2.07305, 2.15963, 1.85664, 2.03574, 2.09627, 2.27216, 2.02546, 1.96818, 2.22384, 2.01726, 1.80162, 1.97247, 2.09924, 2.21662, 1.91695, 2.13774, 2.04148, 2.04097, 1.95248, 2.15604, 1.89128, 2.11091, 1.82043, 2.00699, 2.14799, 2.13697, 2.11882, 1.97356, 1.89231, 2.10455, 2.11358, 2.16536, 1.96419, 2.17022, 1.90111, 2.26046, 2.14238, 2.12657, 1.92863, 2.06622, 1.84382, 1.93025, 2.23869, 2.14306, 1.84687, 1.85564, 1.9808, 2.08835, 2.09661, 2.13328, 1.94439, 2.18788, 1.94419, 1.96482, 1.89488, 2.29218, 1.80179, 2.2137, 1.96574, 1.8941, 2.01825, 2.27932, 2.25947, 2.18244, 2.14954, 1.86057, 2.14289, 1.99192, 2.18714, 2.27153, 2.25814, 2.23096, 1.90177, 2.19683, 2.07402};
  parameter Real POT[100] = {13.0595, 13.181, 13.1819, 13.1748, 13.0996, 13.1152, 13.0326, 13.0548, 13.1729, 13.0985, 13.0927, 13.1698, 13.0992, 13.0582, 13.0361, 13.1368, 13.1455, 13.0278, 13.1206, 13.0985, 13.1676, 13.1449, 13.0356, 13.0444, 13.0997, 13.0243, 13.0276, 13.0721, 13.065, 13.1864, 13.1817, 13.1244, 13.1674, 13.1636, 13.0992, 13.067, 13.0789, 13.1318, 13.1218, 13.0518, 13.0302, 13.0145, 13.0216, 13.1294, 13.0727, 13.0577, 13.0663, 13.0182, 13.0855, 13.1869, 13.1167, 13.0531, 13.1317, 13.1524, 13.0975, 13.0315, 13.1766, 13.1251, 13.1035, 13.0416, 13.1115, 13.0852, 13.166, 13.0789, 13.0489, 13.0652, 13.1459, 13.1277, 13.197, 13.0676, 13.1795, 13.0272, 13.0822, 13.0011, 13.1567, 13.1549, 13.0587, 13.0229, 13.1731, 13.1442, 13.0098, 13.0898, 13.1973, 13.1416, 13.0422, 13.0948, 13.173, 13.0188, 13.0199, 13.0766, 13.0604, 13.1314, 13.1618, 13.0263, 13.0103, 13.0107, 13.0915, 13.1562, 13.1384, 13.0885};
  parameter Real th0[100] = {21.3608, 19.5775, 21.1324, 21.1938, 21.6466, 18.7902, 19.3409, 21.0729, 19.1111, 20.2159, 19.9096, 20.5155, 19.4591, 20.0536, 21.8089, 21.6648, 20.5428, 20.8692, 18.5664, 20.4279, 18.0652, 18.9715, 18.5489, 21.2167, 18.6267, 19.6038, 18.5192, 18.4352, 21.9957, 18.873, 20.0517, 21.3564, 20.4506, 19.1841, 20.5502, 20.0971, 19.9743, 21.8911, 19.1701, 21.0854, 20.107, 21.0797, 19.6009, 21.5661, 19.1333, 19.4098, 21.2309, 21.6761, 18.279, 21.7973, 20.104, 18.3442, 18.7689, 20.6529, 21.5609, 19.3956, 18.2567, 18.0801, 19.8308, 18.2524, 18.9531, 21.8825, 21.6088, 21.4037, 19.0667, 20.159, 19.5008, 21.041, 20.0501, 20.6709, 20.1264, 18.1571, 19.7506, 21.7273, 21.7232, 20.8838, 19.1372, 20.9541, 20.5599, 19.4162, 20.7514, 18.6639, 19.7604, 21.5203, 21.3168, 19.3213, 18.9159, 21.5735, 19.4014, 20.7467, 21.8259, 20.3546, 20.6292, 21.4347, 19.7582, 21.6959, 19.5937, 21.2591, 20.7369, 21.6439};
  parameter Real pmax = sum(POT);
  Real th[N](start = th0);
  discrete Real tref(start = 20);
  discrete Real on[N](start = array(if th0[i] > 20 then 1 else 0 for i in 1:N));
equation
  for i in 1:N loop
    der(th[i]) = (THA / RES[i] - POT[i] * on[i] - th[i] / RES[i] + 0.5 / RES[i]) / CAP[i];
  end for;
algorithm
  for i in 1:N loop
    when th[i] - tref + on[i] - 0.5 > 0 then
      on[i] := 1;
      ptotal := POT * on;
    elsewhen th[i] - tref + on[i] - 0.5 < 0 then
      if time > 0 then
        on[i] := 0;
        ptotal := POT * on;
      end if;
    end when;
  end for;
  when time > 1000 then
    tref := 20.5;
  end when;
  when time > 2000 then
    tref := 20;
  end when;
  annotation(experiment(StartTime = 0, StopTime = 3000, Tolerance = 0.00001, Interval = 0.6));
end airconds;
