model Bang
  parameter Integer N = 400;
  Real x[N];
equation
  der(x[1]) = -x[1] + 1; 
  for i in 2:N-1 loop 
    der(x[i]) = homotopy(-x[i] + 1 + 1e-6*sin(x[i-1]) + 1e-6*sin(x[i+1]), -x[i] + 1 + 1e-6*sin(x[i-1]) + 1e-6*sin(x[i+1]));
  end for;
  der(x[N]) = -x[N] + 1; 
initial equation
  for i in 1:N loop
    der(x[i]) = 0;
  end for;
end Bang;