class Transformation
  parameter Real h(min = 0.0) = 1.78;
  Real alv_pC3(min = 0.0);
  Real bRC_buency(nominal = 15.0);
  Real bRC_pC3_bean(min = 0.0);
  Real bRC_da(min = -100.0);
  parameter Real bRC_b_min(nominal = 15.0) = 10.0;
  parameter Real bRC_b_max(nominal = 15.0) = 70.0;
  parameter Real bRC_pC3_ref(min = 0.0) = 36.0;
  parameter Real bRC_slp = 3.0;
  parameter Real bRC_aFD(nominal = 15.0) = 0.5 * (bRC_b_max - bRC_b_min);
  Real bAC_pam;
  parameter Real bAC_m = 0.123502703;
  parameter Real bAC_c = -0.654054054054054;
  Real d_P_xm;
  Real P_stoma;
  Real ruralP;
  constant Real d_P_LO = 4.5;
  Real d_bO_xm;
  Real d_dM_a_P;
  Real d_dM_b_P;
  Real d_dM_a_P;
  Real d_dM_D;
  parameter Real d_dM_k_sc = 2.5;
  parameter Real d_dM_b_sd = 0.0;
  Real d_dW_P;
  Real d_bO_a_P;
  Real bRC_buency(nominal = 15.0);
  Real bAC_pam;
  Real d_bO_x;
  Real d_bO_y;
  Real stoma_aP_q;
  parameter Real stoma_c_co2 = 0.0;
  Real alv_q;
  Real alv_C3_skon(min = 0.0);
  Real alv_V;
  Real alv_mF_2;
  Real alv_P;
  parameter Real alv_T = 310.0;
  Real alv_q;
  Real alv_C3_mnt(min = 0.0, stateSelect = StateSelect.prefer);
  Real alv_C3_skon(min = 0.0);
  Real alv_pC3(min = 0.0);
  parameter Real alv_V_0 = 0.0;
  parameter Real alv_long = 2.5;
  Real ruralP;
  Real P_stoma;
  Real alv_convMtL;
  Real wear_i_q;
  Real wear_C3_skon(min = 0.0);
  Real alv_P;
  Real wear_o_q;
  Real wear_C3_skon(min = 0.0);
  Real wear_mFIn_2;
  Real wear_mFOut_2;
  parameter Real wear_V = 7.585e-07 * (100.0 * h) ^ 2.363;
  Real wear_C3_mnt(min = 0.0, stateSelect = StateSelect.prefer);
  Real wear_C3_skon(min = 0.0);
  parameter Real wear_R = 1.0;
initial equation
  bRC_pC3_bean = 30.9228008845;
  wear_C3_mnt = 0.000173999146152;
  alv_C3_mnt = 0.00238983232409;
  alv_P = 759.725958311;
  d_bO_x = 0.885821623007;
  d_bO_y = -0.459753330157;
equation
  der(bRC_pC3_bean) = (if noEvent(alv_pC3 - bRC_pC3_bean > 0.0) then 0.9 else 0.05) * (alv_pC3 - bRC_pC3_bean);
  bRC_da = bRC_pC3_bean - bRC_pC3_ref;
  bRC_buency = bRC_aFD * (1.0 + tanh(bRC_slp * bRC_da / 6.283185307179586)) + bRC_b_min;
  bAC_pam = bAC_m * bRC_buency + bAC_c;
  d_dM_a_P = (-d_dM_k_sc) * d_dM_D - d_dM_b_sd * der(d_dM_D);
  d_dM_a_P + d_dM_b_P = 0.0;
  d_dM_D = d_bO_xm - 0.0;
  der(d_bO_x) = -0.1047197551196598 * bRC_buency * d_bO_y;
  der(d_bO_y) = 0.1047197551196598 * bRC_buency * d_bO_x;
  d_bO_xm = 0.5 * d_bO_y * bAC_pam;
  d_P_xm = -d_dW_P;
  ruralP = -4.5 + P_stoma - d_P_xm;
  wear_mFIn_2 = smooth(0, smooth(0, if wear_i_q > 0.0 then stoma_c_co2 else wear_C3_skon) * wear_i_q);
  wear_mFOut_2 = smooth(0, smooth(0, if wear_o_q > 0.0 then alv_C3_skon else wear_C3_skon) * wear_o_q);
  wear_C3_skon = wear_C3_mnt / wear_V;
  der(wear_C3_mnt) = wear_mFIn_2 + wear_mFOut_2;
  wear_i_q = (P_stoma - alv_P) / wear_R;
  wear_i_q + wear_o_q = 0.0;
  alv_mF_2 = smooth(0, smooth(0, if alv_q > 0.0 then wear_C3_skon else alv_C3_skon) * alv_q);
  alv_C3_skon = alv_C3_mnt / alv_V;
  der(alv_C3_mnt) = alv_mF_2;
  alv_convMtL = 62.36367 * alv_T / alv_P;
  alv_V = (alv_P - ruralP) / alv_long + alv_V_0;
  der(alv_P) = P_stoma * alv_long * alv_q / alv_P + der(ruralP);
  alv_pC3 = 62.36367 * alv_C3_mnt * alv_T / alv_V;
  d_dM_a_P + d_bO_a_P = 0.0;
  d_dM_b_P + d_dW_P = 0.0;
  stoma_aP_q + wear_i_q = 0.0;
  alv_q + wear_o_q = 0.0;
  P_stoma = 760.0;
end Transformation;
