within TestPackage.Setups.PVGenerator;
record StandardParameters "Standard parameters for PV generators"

  constant Real qDer = 0.0001 "derivative of the reactive power";
  constant SIunits.Time timeToSaturation = 15 "simulation time before reaching reactive power saturation";
  parameter SIunits.Time T = 1 "integration time-constant for the PV generator";
  parameter SIunits.ActivePower p0 = 1.0 "initial active power supplied by the generator";
  parameter SIunits.ReactivePower q0 = 0.0 "initial reactive power supplied by the generator";
  parameter Real lambda = 0.1 "voltage sensitivity of reactive power regulation";
  parameter SIunits.ReactivePower QMin = 0 "minimum reactive power";
  parameter SIunits.ReactivePower QMax = qDer * timeToSaturation "maximump reactive power";
  parameter SIunits.ActivePower PMin = 0.0 "minimum active power";
  parameter SIunits.ActivePower PMax = 3.0 "maximum active power";

end StandardParameters;