within TestPackage;
package Types "Standard types for electrical variables"

public
  package AC "types for AC variables"
    // voltages
    // record Voltage = Complex (re (VoltageComponent), im (VoltageComponent)) "AC voltage as complex number";
    record Voltage = Complex "AC voltage as complex number";
      type VoltageComponent = SIunits.Voltage "real or imaginary part of complex AC voltage";
    type VoltageModule = SIunits.Voltage "AC voltage module";

    // currents
    // record Current = flow Complex (re (CurrentComponent), im (CurrentComponent)) "AC current as complex number";
    record Current = Complex "AC current as complex number";
    type CurrentComponent = SIunits.ElectricCurrent "real or imaginary part of complex AC current";
    type CurrentModule = SIunits.ElectricCurrent "AC current module";

    // apparent power
    // record ApparentPower = Complex (re (ActivePower), im (ReactivePower)) "AC apparent power";
    record ApparentPower = Complex "AC apparent power";
    type ApparentPowerModule = Real (final unit = "MVA") "AC apparent power module";
    type ActivePower = SIunits.ActivePower "AC active power";
    type ReactivePower = SIunits.ReactivePower "AC reactive power";

    // impedance
    // record Impedance = Complex (re (Resistance), im (Reactance)) "complex impedance";
    record Impedance = Complex "complex impedance";

  end AC;

end Types;

