within TestPackage.Electrical;
model simpleLoadVar "simple load with reactive power variation"
                    // 8 unknowns, 6 equations
  import Complex;
  import Modelica.ComplexMath;//add a comment
  import TestPackage.Connectors;
  parameter Real p0;
  parameter Real q0;
  parameter Real qDer;
  parameter Real alpha;
  parameter Real beta;
  parameter Real T;
  parameter Real u0 = 1.0;
  Complex s;
  Real p;
  Real q;
  discrete Real pControl(  start = p0);
  discrete Real qControl(  start = q0);
  Connectors.ACPower pin
    annotation (Placement(transformation(extent={{-120,-10},{-100,10}}), iconTransformation(extent={{-120,-10},{-100,10}})));
equation
  when sample(0, T) then
    pControl = pre( pControl);
    qControl = pre(qControl) + T * qDer;
  end when;
  p = pControl * (ComplexMath.'abs'(pin.V) / u0) ^ alpha;
  q = qControl * (ComplexMath.'abs'(pin.V) / u0) ^ beta;
  s = Complex( p, q);
  s = pin.V * ComplexMath.conj( pin.i);
  annotation (uses(Modelica(version="3.2.1")), Icon(graphics={
        Rectangle(
          extent={{-100,100},{100,-100}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid),
        Text(
          extent={{-84,-94},{86,-152}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid,
          textString="Load"),
        Text(
          extent={{-88,82},{82,24}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid,
          textString="p0=%p0"),
        Text(
          extent={{-88,-6},{82,-64}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid,
          textString="q0=%q0")}));
end simpleLoadVar;
