within TestPackage.Electrical;
partial model GeneratorPV
  "Generator with pre-set active power and voltage outputs"
  // 14 unknowns, 12 equations
  import Modelica.ComplexMath;
  import Modelica.Blocks.Interfaces;
  import TestPackage.Connectors;
public
    parameter SIunits.ActivePower P0 "initial active power supplied";
    parameter SIunits.ReactivePower Q0 "initial reactive power supplied";
    parameter Real lambda( unit = "kV/MVAr")
    "voltage sensitivity of reactive power regulation";
    parameter SIunits.ReactivePower QMin "minimum reactive power";
    parameter SIunits.ReactivePower QMax "maximum reactive power";
    parameter SIunits.ActivePower PMin "minimum active power";
    parameter SIunits.ActivePower PMax "minimum reactive power";
    Connectors.ACPower out "voltage and current output"
    annotation (Placement(transformation(extent={{102,-10},{122,10}}),
        iconTransformation(extent={{102,-10},{122,10}})));
    Interfaces.RealInput UControl
    "control voltage. this variable is set in order to allower the user to change this set-point during the simulation."
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
//protected
    Real PRaw
    "active power output without taking maximum and minimum power into account";
    Real P( start = P0) "active power";
    Real QControl "reactive power target";
    Real Q( start = Q0) "reactive power";
    Complex S "apparent power";
    Real VNw;
    parameter Real QDeadBand = 1e-4 "reactive power dead-band";
    parameter Real VDeadBand = 1e-4 "voltage dead-band";
equation
    PRaw = P0;
    //managing complex numbers
    S = Complex(P, Q);
    VNw = ComplexMath.'abs'(out.V);
    UControl - VNw = lambda * QControl;
    P = smooth(0,
      if PRaw >= PMax then PMax
      elseif PRaw <= PMin then PMin
      else PRaw);
   //assert( Q <= 1.1 * QMax, "Q is too big");
    // the current is positive when entering the device
    S = - out.V * ComplexMath.conj( out.i);
  annotation (uses(Modelica(version="3.2.1")), Icon(graphics={
                             Rectangle(
          extent={{-100,100},{102,-100}},
          lineColor={95,95,95},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid),
        Text(
          extent={{-92,94},{92,-90}},
          lineColor={95,95,95},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid,
          textString="GeneratorPV")}));
end GeneratorPV;
