within FalseIterationsNLS;
function pureComponentProperties_pTnc
  input Modelica.SIunits.AbsolutePressure p "Pressure";
  input Modelica.SIunits.Temperature T "Temperature";
  input Integer nc "Number of components";
  output Modelica.SIunits.PartialPressure ppS "Saturation partial pressure of condensing component";
  output Modelica.SIunits.SpecificEnthalpy delta_hv "Specific enthalpy of vaporation of condensing component";
  output Modelica.SIunits.SpecificEnthalpy delta_hd "Specific enthalpy of desublimation of condensing component";
  output Modelica.SIunits.SpecificEnthalpy h_idealGas[nc] "Specific enthalpy of theoretical pure component ideal gas state";

  external "C" TILMedia_Gas_pureComponentProperties_pT(p, T, ppS, delta_hv, delta_hd, h_idealGas) annotation(Include="

void TILMedia_Gas_pureComponentProperties_pT(double p, double T, double *ppS, double *delta_hv, double *delta_hd, double *h_idealGas){
        *ppS = 0.1*p;
        *delta_hv = -1;
        *delta_hd = -1;
}
  ");
end pureComponentProperties_pTnc;
