void collisionDetection( int maxContacts,
                         double *r_a, size_t r_a_dim,
                         double *Q_a, size_t Q_a_dim,
                         const char * id_a,
                         double *r_b, size_t r_b_dim,
                         double *Q_b, size_t Q_b_dim,
                         const char * id_b,
                         double *numberOfContactPoints,
                         double *cp_a, size_t cp_a_dim1, size_t cp_a_dim2,
                         double *cp_b, size_t cp_b_dim1, size_t cp_b_dim2,
                         double *depth_a, size_t depth_a_dim,
                         double *depth_b, size_t depth_b_dim,
                         double *normals_a, size_t normals_a_dim1, size_t normals_a_dim2,
                         double *normals_b, size_t normals_b_dim1, size_t normals_b_dim2);

// input Integer maxContacts "Maximum number of contact points";
// input Real r_a[3] "Position vector of object a from world frame to the connector frame origin, resolved in world frame";
// input Frames.Quaternions.Orientation Q_a "Quaternion corresponding to the rotation matrix of object b from world frame to local frame";
// input Real r_b[3] "Position vector of object b from world frame to the connector frame origin, resolved in world frame";
// input Frames.Quaternions.Orientation Q_b "Quaternion corresponding to the rotation matrix of object b from world frame to local frame";
// output Real numberOfContactPoints "Number of actual contact points";
// output Real cp_a[maxContacts, 3] "Array of contact points on body a, resolved in frame_a";
// output Real cp_b[maxContacts, 3] "Array of contact points on body b, resolved in frame_b";
// output Real depth_a[maxContacts] "Array of penetration depths in body a";
// output Real depth_b[maxContacts] "Array of penetration depths in body a";
// output Real normals_a[maxContacts, 3] "Array of normals (as defined by Gazebo) on body a, resolved in frame_a";
// output Real normals_b[maxContacts, 3] "Array of normals (as defined by Gazebo) on body a, resolved in frame_a";

