model Test


  inner ThermoPower.System system(
    allowFlowReversal=false,
    T_amb=288.15,
    T_wb=285.55)                                                 annotation (
    Placement(visible = true, transformation(origin = {180, 150}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  ThermoPower.Water.Flow1DFV pipeToCoolingTower(A = 0.125 ^ 2 * 3.14, FFtype = ThermoPower.Choices.Flow1D.FFtypes.OpPoint, H = 30, L = 30,                initOpt = ThermoPower.Choices.Init.Options.steadyState, noInitialPressure = true, omega = 0.250 * 3.14, wnom = 300 / 3600 * 989,
    dpnom=50000,
    rhonom=999)                                                                                                                                                                                                         annotation (
    Placement(visible = true, transformation(origin = {-12, -2}, extent = {{10, -10}, {-10, 10}}, rotation = -90)));
  ThermoPower.Water.CoolingTower coolingTower(Wnom(displayUnit = "kW") = 22000, gamma_wp_nom = 10, k_wa_nom = 28, S = 1, Mp = 1,Mnom = 1, M0 = 0.9, cp = 500, nu_a = 0.8, nu_l = 0, qanom = 1150e3 / 3600, rhoanom = 1.2, rpm_nom = 230, wlnom = 300 / 3600 * 995,
    staticModel=true)                                                                                                                                                                                                         annotation (
    Placement(visible = true, transformation(origin = {66, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  ThermoPower.Water.SourcePressure sourcePressure1 annotation (
    Placement(visible = true, transformation(origin = {-96, -36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  ThermoPower.Water.SinkPressure sinkPressure1 annotation (
    Placement(visible = true, transformation(origin = {128, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.TimeTable fanSpeed(table = [0, 230; 1000, 230]) annotation (
    Placement(visible = true, transformation(origin = {32, 38}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(fanSpeed.y, coolingTower.fanRpm) annotation (
    Line(points={{43,38},{58,38}},                          color = {0, 0, 127}));
  connect(sourcePressure1.flange, pipeToCoolingTower.infl) annotation (
    Line(points={{-86,-36},{-12,-36},{-12,-12}},                    color = {0, 0, 255}));
  connect(coolingTower.waterOutlet, sinkPressure1.flange) annotation (
    Line(points={{66,25},{66,25},{66,-40},{118,-40}},                      color = {0, 0, 255}));
  connect(pipeToCoolingTower.outfl, coolingTower.waterInlet) annotation (
    Line(points = {{-12, 8}, {-12, 70}, {66, 70}, {66, 43}}, color = {0, 0, 255}));
  annotation (
    Diagram(coordinateSystem(extent = {{-200, -200}, {200, 200}})),
    Icon(coordinateSystem(extent = {{-200, -200}, {200, 200}})),
    __OpenModelica_commandLineOptions = "",
    experiment(StopTime=100));

end Test;
