model SimpleSynch3
  import SI = Modelica.SIunits;
  import CON = Modelica.Constants;
  parameter Real sysFreqHz = 60.0;
  parameter SI.Voltage sourceV = 100.0;
  parameter SI.ElectricalTorqueConstant kTorq = 0.5;
  parameter Real speed0 = 0.5 * sysFreqHz * 2.0 * CON.pi;
  // no damper load: 79.15, damper = 0.01: 71.7
  parameter Real phaseS = 20 * CON.pi / 180.0 "phase offset for source voltage";
  parameter Real phase0 = 0.0 * CON.pi / 180.0 "phase offset for emf coefficient";
  parameter Real kAngle = 2.0;
  parameter SI.Resistance res = 0.1, resSine = 0.1, resLoad = 1.0;
  parameter SI.Torque appliedTorque = 200.0;
  parameter SI.RotationalDampingConstant damp = 0.0;
  Real anglep1(fixed = false), anglep2(fixed = false), anglep3(fixed = false);
  Real anglem1(fixed = false), anglem2(fixed = false), anglem3(fixed = false);
  Real angle1(fixed = false), angle2(fixed = false), angle3(fixed = false);
  SI.Power mechPower(fixed = false);
  Modelica.Electrical.MultiPhase.Basic.PlugToPin_n plugToPin_n1(k = 1) annotation(
    Placement(visible = true, transformation(origin = {4, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Star star1 annotation(
    Placement(visible = true, transformation(origin = {-138, 18}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {-148, -4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  EMFvar emf1(useSupport = false, phi(fixed = false, start = 0)) annotation(
    Placement(visible = true, transformation(origin = {32, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Mechanics.Rotational.Components.Inertia inertia1(J = 0.29, phi(displayUnit = "rad", fixed = false, start = 0), w(fixed = true, start = speed0)) annotation(
    Placement(visible = true, transformation(origin = {64, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Ground ground2 annotation(
    Placement(visible = true, transformation(origin = {148, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  EMFvar emf2(useSupport = false) annotation(
    Placement(visible = true, transformation(origin = {32, 24}, extent = {{-10, 10}, {10, -10}}, rotation = 0)));
  EMFvar emf3(useSupport = false) annotation(
    Placement(visible = true, transformation(origin = {32, -10}, extent = {{-10, 10}, {10, -10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.PlugToPin_n plugToPin_n3(k = 3) annotation(
    Placement(visible = true, transformation(origin = {4, -10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage1(V = {sourceV, sourceV, sourceV}, freqHz = {60, 60, 60}, phase = -{0.0 + phaseS, 2.0 * CON.pi / 3.0 + phaseS, 4.0 * CON.pi / 3.0 + phaseS}) annotation(
    Placement(visible = true, transformation(origin = {-110, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Mechanics.Rotational.Components.Fixed fixed1 annotation(
    Placement(visible = true, transformation(origin = {112, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  DamperVar damperVar1(phi_rel(fixed = true)) annotation(
    Placement(visible = true, transformation(origin = {90, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.PlugToPin_n plugToPin_n2(k = 2) annotation(
    Placement(visible = true, transformation(origin = {4, 24}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Resistor resistor1(R = {res, res, res}) annotation(
    Placement(visible = true, transformation(origin = {-34, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Machines.Sensors.ElectricalPowerSensor electricalPowerSensorSine annotation(
    Placement(visible = true, transformation(origin = {-108, 18}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Mechanics.Rotational.Sources.Torque torque1 annotation(
    Placement(visible = true, transformation(origin = {86, 76}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Resistor resistor2(R = {resSine, resSine, resSine}) annotation(
    Placement(visible = true, transformation(origin = {-78, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Resistor resistorLoad(R = {resLoad, resLoad, resLoad}) annotation(
    Placement(visible = true, transformation(origin = {-60, 20}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.MultiPhase.Basic.Star star2 annotation(
    Placement(visible = true, transformation(origin = {-60, -44}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground3 annotation(
    Placement(visible = true, transformation(origin = {-60, -72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.PlugToPins_n plugToPins_n1 annotation(
    Placement(visible = true, transformation(origin = {72, 22}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Star star3 annotation(
    Placement(visible = true, transformation(origin = {124, 22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Machines.Sensors.ElectricalPowerSensor electricalPowerSensorGen annotation(
    Placement(visible = true, transformation(origin = {96, 22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(resistor1.plug_p, resistor2.plug_n) annotation(
    Line(points = {{-44, 52}, {-68, 52}, {-68, 52}, {-68, 52}}, color = {0, 0, 255}));
  connect(resistorLoad.plug_n, star2.plug_p) annotation(
    Line(points = {{-60, 10}, {-60, 10}, {-60, -34}, {-60, -34}}, color = {0, 0, 255}));
  connect(electricalPowerSensorSine.plug_nv, resistor2.plug_n) annotation(
    Line(points = {{-108, 8}, {-80, 8}, {-80, 34}, {-68, 34}, {-68, 52}, {-68, 52}}, color = {0, 0, 255}));
  connect(electricalPowerSensorSine.plug_p, sineVoltage1.plug_p) annotation(
    Line(points = {{-98, 18}, {-94, 18}, {-94, 38}, {-124, 38}, {-124, 52}, {-120, 52}, {-120, 52}}, color = {0, 0, 255}));
  connect(star1.plug_p, electricalPowerSensorSine.plug_ni) annotation(
    Line(points = {{-128, 18}, {-118, 18}, {-118, 18}, {-118, 18}}, color = {0, 0, 255}));
  connect(sineVoltage1.plug_n, resistor2.plug_p) annotation(
    Line(points = {{-100, 52}, {-88, 52}, {-88, 52}, {-88, 52}}, color = {0, 0, 255}));
  connect(resistor1.plug_p, electricalPowerSensorGen.plug_nv) annotation(
    Line(points = {{-44, 52}, {-44, 52}, {-44, 32}, {-32, 32}, {-32, -24}, {96, -24}, {96, 12}, {96, 12}}, color = {0, 0, 255}));
  connect(plugToPins_n1.plug_n, electricalPowerSensorGen.plug_p) annotation(
    Line(points = {{74, 22}, {86, 22}, {86, 22}, {86, 22}}, color = {0, 0, 255}));
  connect(electricalPowerSensorGen.plug_ni, star3.plug_p) annotation(
    Line(points = {{106, 22}, {114, 22}, {114, 22}, {114, 22}}, color = {0, 0, 255}));
  connect(star3.pin_n, ground2.p) annotation(
    Line(points = {{134, 22}, {148, 22}, {148, 22}, {148, 22}}, color = {0, 0, 255}));
  connect(emf3.n, plugToPins_n1.pin_n[3]) annotation(
    Line(points = {{32, 0}, {62, 0}, {62, 22}, {70, 22}, {70, 22}, {70, 22}}, color = {0, 0, 255}));
  connect(emf2.n, plugToPins_n1.pin_n[2]) annotation(
    Line(points = {{32, 34}, {58, 34}, {58, 22}, {70, 22}, {70, 22}, {70, 22}}, color = {0, 0, 255}));
  connect(emf1.n, plugToPins_n1.pin_n[1]) annotation(
    Line(points = {{32, 42}, {52, 42}, {52, 22}, {70, 22}, {70, 22}}, color = {0, 0, 255}));
  connect(star2.pin_n, ground3.p) annotation(
    Line(points = {{-60, -54}, {-60, -54}, {-60, -62}, {-60, -62}}, color = {0, 0, 255}));
  connect(resistorLoad.plug_p, resistor2.plug_n) annotation(
    Line(points = {{-60, 30}, {-60, 30}, {-60, 52}, {-68, 52}, {-68, 52}}, color = {0, 0, 255}));
  connect(star1.pin_n, ground1.p) annotation(
    Line(points = {{-148, 20}, {-148, 20}, {-148, 8}, {-148, 8}}, color = {0, 0, 255}));
  connect(torque1.flange, inertia1.flange_b) annotation(
    Line(points = {{76, 76}, {74, 76}, {74, 52}, {74, 52}}));
  connect(plugToPin_n3.pin_n, emf3.p) annotation(
    Line(points = {{6, -10}, {16, -10}, {16, -20}, {32, -20}, {32, -20}}, color = {0, 0, 255}));
  connect(plugToPin_n2.pin_n, emf2.p) annotation(
    Line(points = {{6, 24}, {18, 24}, {18, 14}, {32, 14}, {32, 14}}, color = {0, 0, 255}));
  connect(plugToPin_n1.pin_n, emf1.p) annotation(
    Line(points = {{6, 52}, {18, 52}, {18, 62}, {32, 62}, {32, 62}, {32, 62}}, color = {0, 0, 255}));
  connect(resistor1.plug_n, plugToPin_n3.plug_n) annotation(
    Line(points = {{-24, 52}, {-12, 52}, {-12, -10}, {2, -10}, {2, -10}, {2, -10}}, color = {0, 0, 255}));
  connect(resistor1.plug_n, plugToPin_n2.plug_n) annotation(
    Line(points = {{-24, 52}, {-12, 52}, {-12, 24}, {2, 24}, {2, 24}, {2, 24}}, color = {0, 0, 255}));
  connect(resistor1.plug_n, plugToPin_n1.plug_n) annotation(
    Line(points = {{-24, 52}, {2, 52}, {2, 52}, {2, 52}}, color = {0, 0, 255}));
  connect(inertia1.flange_b, damperVar1.flange_a) annotation(
    Line(points = {{74, 52}, {80, 52}, {80, 52}, {80, 52}}));
  connect(damperVar1.flange_b, fixed1.flange) annotation(
    Line(points = {{100, 52}, {110, 52}, {110, 52}, {112, 52}}));
  connect(emf2.flange, inertia1.flange_a) annotation(
    Line(points = {{42, 24}, {48, 24}, {48, 52}, {54, 52}, {54, 52}}));
  connect(emf1.flange, inertia1.flange_a) annotation(
    Line(points = {{42, 52}, {54, 52}, {54, 52}, {54, 52}}));
  connect(emf3.flange, inertia1.flange_a) annotation(
    Line(points = {{42, -10}, {54, -10}, {54, 52}, {54, 52}}));
  if time <= 5.0 then
    damperVar1.dd = damp;
    torque1.tau = appliedTorque;
  else
    damperVar1.dd = 2.0 * damp;
    torque1.tau = 2.0 * appliedTorque;
  end if;
  anglep1 = mod(inertia1.phi + phase0, 2.0 * CON.pi);
  anglem1 = mod(inertia1.phi + phase0, -2.0 * CON.pi);
  if abs(anglep1) <= abs(anglem1) then
    angle1 = anglep1;
  else
    angle1 = anglem1;
  end if;
  emf1.k = -kTorq * sin(angle1 * kAngle);
  anglep2 = mod(inertia1.phi - 240.0 * CON.pi / 180.0 + phase0, 2.0 * CON.pi);
  anglem2 = mod(inertia1.phi - 240.0 * CON.pi / 180.0 + phase0, -2.0 * CON.pi);
  if abs(anglep2) <= abs(anglem2) then
    angle2 = anglep2;
  else
    angle2 = anglem2;
  end if;
  emf2.k = -kTorq * sin(angle2 * kAngle);
  anglep3 = mod(inertia1.phi - 120.0 * CON.pi / 180.0 + phase0, 2.0 * CON.pi);
  anglem3 = mod(inertia1.phi - 120.0 * CON.pi / 180.0 + phase0, -2.0 * CON.pi);
  if abs(anglep3) <= abs(anglem3) then
    angle3 = anglep3;
  else
    angle3 = anglem3;
  end if;
  emf3.k = -kTorq * sin(angle3 * kAngle);
  
  mechPower = torque1.tau * inertia1.w;
  annotation(
    uses(Modelica(version = "3.2.2")),
    experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-06, Interval = 0.0202429));
end SimpleSynch3;
