model HPStorage_System4
  constant String Pfad = Modelica.Utilities.System.getWorkDirectory();
  parameter Boolean allowFlowReversal = true;
  replaceable package MediumWater = Modelica.Media.Water.ConstantPropertyLiquidWater;
  replaceable package MediumGlycol = ConstantPropertyGlycol30;
  //******* Buffer Storage ************************************************************
  Storage_mod BufferStorage(redeclare package Medium = MediumWater, A_HE = 1, V_HE = 0.2, allowFlowReversal = allowFlowReversal, alpha_in = 200, alpha_out = 15, d = 0.6, h = 1.4, k_HE = 1e6, lambda_ins = 0.04, layer_TempMeasure = 8, n = 10, s_ins = 0.1) annotation(
    Placement(visible = true, transformation(origin = {38, -2}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  //******* Sensors ************************************************************
  Modelica.Blocks.Interfaces.RealOutput COP annotation(
    Placement(visible = true, transformation(origin = {2, -72}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {2, -72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  AixLib.Fluid.Sensors.TemperatureTwoPort T_bufOut(redeclare package Medium = MediumWater, allowFlowReversal = allowFlowReversal, m_flow_nominal = 0.1, tau = 10) annotation(
    Placement(visible = true, transformation(origin = {54, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  //******* Controller ************************************************************
  HPcontroller_v2 HPcontrol(bandwidth = 8, mdot_set = 1, pre_y_start = true) annotation(
    Placement(visible = true, transformation(origin = {-124, 64}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 //******* Data Reader ************************************************************
  Modelica.Blocks.Tables.CombiTable1D combiTable1D1(columns = 2:2, fileName = "data/Tevap_in.txt", tableName = "tab1", tableOnFile = true) annotation(
    Placement(visible = true, transformation(origin = {-170, 4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.RealExpression realExpression1(y = time / 60) annotation(
    Placement(visible = true, transformation(origin = {-204, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Tables.CombiTable1D combiTable1D3(columns = 2:2, fileName = "data/mdot_Last.txt", tableName = "tab1", tableOnFile = true) annotation(
    Placement(visible = true, transformation(origin = {138, -36}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.RealExpression realExpression2(y = time / 60) annotation(
    Placement(visible = true, transformation(origin = {166, -36}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  //******* Heat Pump *****************************************************************
  HeatPump_mod heatPump(redeclare package Medium_con = MediumWater, redeclare package Medium_eva = MediumGlycol, CorrFlowCo = false, CorrFlowEv = false, T_startEva = 278.15, allowFlowReversal = allowFlowReversal, capCalcType = 2, dataTable = Dimplex_SI8TU(), Corr_icing = AixLib.Fluid.HeatPumps.BaseClasses.Functions.DefrostCorrection.noModel) annotation(
    Placement(visible = true, transformation(origin = {-67.4258, 0.41147}, extent = {{-17.0742, -7.58853}, {17.0742, 7.58853}}, rotation = 0)));

  //******* Boundary Conditions  ************************************************************
  Modelica.Thermal.HeatTransfer.Sources.FixedTemperature Tamb(T = 288.15) annotation(
    Placement(visible = true, transformation(origin = {82, -6}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Fluid.Sources.FixedBoundary BC_bufOut(redeclare package Medium = MediumWater, nPorts = 1) annotation(
    Placement(visible = true, transformation(origin = {92, 42}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.RealExpression Tref(y = 35) annotation(
    Placement(visible = true, transformation(origin = {-178, 68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Fluid.Sources.MassFlowSource_T BC_evapIn(redeclare package Medium = MediumGlycol, T = 278, m_flow = 0.5, nPorts = 1, use_T_in = true, use_m_flow_in = true) annotation(
    Placement(visible = true, transformation(origin = {-124, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Fluid.Sources.FixedBoundary BC_evapOut(redeclare package Medium = MediumGlycol, nPorts = 1) annotation(
    Placement(visible = true, transformation(origin = {-148, -28}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Fluid.Sources.FixedBoundary BC_pressure(redeclare package Medium = MediumWater, nPorts = 1, p = 2e5) annotation(
    Placement(visible = true, transformation(origin = {-46, 46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Fluid.Sources.MassFlowSource_T BC_bufIn(redeclare package Medium = MediumWater, T = 303, m_flow = 0.05, nPorts = 1, use_m_flow_in = true) annotation(
    Placement(visible = true, transformation(origin = {90, -44}, extent = {{-10, 10}, {10, -10}}, rotation = 180)));
  //******* Pump ************************************************************
  Modelica.Fluid.Machines.ControlledPump pump(redeclare package Medium = MediumWater, T_start = 293, allowFlowReversal = allowFlowReversal, m_flow_nominal = 0.27, m_flow_start = 0.25, rho_nominal = 1000, use_m_flow_set = true) annotation(
    Placement(visible = true, transformation(origin = {-14, 16}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.RealExpression mdot_evap_set(y = 0.5) annotation(
    Placement(visible = true, transformation(origin = {-192, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.RealExpression mdot_cond_set(y = 0.27) annotation(
    Placement(visible = true, transformation(origin = {-50, 78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Math.Product mdot_evap annotation(
    Placement(visible = true, transformation(origin = {-155, 39}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  Modelica.Blocks.Math.Product mdot_cond annotation(
    Placement(visible = true, transformation(origin = {-17, 73}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  //******* equation ************************************************************
equation
  connect(mdot_cond_set.y, mdot_cond.u1) annotation(
    Line(points = {{-39, 78}, {-36, 78}, {-36, 77}, {-25, 77}}, color = {0, 0, 127}));
  connect(mdot_cond.y, pump.m_flow_set) annotation(
    Line(points = {{-9, 73}, {-4, 73}, {-4, 32}, {-18, 32}, {-18, 24}}, color = {0, 0, 127}));
  connect(HPcontrol.mdot, mdot_cond.u2) annotation(
    Line(points = {{-112, 62}, {-78, 62}, {-78, 69}, {-25, 69}}, color = {0, 0, 127}));
  connect(mdot_evap_set.y, mdot_evap.u2) annotation(
    Line(points = {{-181, 36}, {-176.5, 36}, {-176.5, 35}, {-163, 35}}, color = {0, 0, 127}));
  connect(mdot_evap.y, BC_evapIn.m_flow_in) annotation(
    Line(points = {{-147, 39}, {-144, 39}, {-144, 8}, {-134, 8}}, color = {0, 0, 127}));
  connect(HPcontrol.mdot, mdot_evap.u1) annotation(
    Line(points = {{-112, 62}, {-104, 62}, {-104, 52}, {-178, 52}, {-178, 43}, {-163, 43}}, color = {0, 0, 127}));
  connect(heatPump.port_evaOut, BC_evapOut.ports[1]) annotation(
    Line(points = {{-82, -4}, {-90, -4}, {-90, -28}, {-138, -28}, {-138, -28}}, color = {0, 127, 255}));
  connect(combiTable1D3.y[1], BC_bufIn.m_flow_in) annotation(
    Line(points = {{127, -38}, {114, -38}, {114, -36}, {100, -36}}, color = {0, 0, 127}, thickness = 0.5));
  connect(realExpression2.y, combiTable1D3.u[1]) annotation(
    Line(points = {{155, -36}, {152.5, -36}, {152.5, -38}, {150, -38}}, color = {0, 0, 127}));
  connect(BufferStorage.MediumTemperature, HPcontrol.Tsensor) annotation(
    Line(points = {{49, 6}, {60, 6}, {60, 90}, {-150, 90}, {-150, 60}, {-136, 60}}, color = {0, 0, 127}));
  connect(Tref.y, HPcontrol.Tset) annotation(
    Line(points = {{-167, 68}, {-137, 68}}, color = {0, 0, 127}));
  connect(HPcontrol.y, heatPump.onOff_in) annotation(
    Line(points = {{-113, 68}, {-68, 68}, {-68, 7}, {-73, 7}}, color = {255, 0, 255}));
  connect(BC_evapIn.ports[1], heatPump.port_evaIn) annotation(
    Line(points = {{-114, 0}, {-103.5, 0}, {-103.5, 6}, {-82, 6}}, color = {0, 127, 255}, thickness = 0.5));
  connect(heatPump.port_conOut, pump.port_a) annotation(
    Line(points = {{-53, 6}, {-53, 8}, {-24, 8}, {-24, 16}}, color = {0, 127, 255}));
  connect(heatPump.CoP_out, COP) annotation(
    Line(points = {{-69, -6}, {-69, -72}, {2, -72}}, color = {0, 0, 127}));
  connect(BufferStorage.port_b_heatGenerator, heatPump.port_conIn) annotation(
    Line(points = {{30, -10}, {-6.5, -10}, {-6.5, -5}, {-53, -5}}, color = {0, 127, 255}));
  connect(T_bufOut.port_b, BC_bufOut.ports[1]) annotation(
    Line(points = {{64, 42}, {82, 42}, {82, 42}, {82, 42}}, color = {0, 127, 255}));
  connect(BufferStorage.port_b_consumer, T_bufOut.port_a) annotation(
    Line(points = {{38, 8}, {36, 8}, {36, 42}, {44, 42}, {44, 42}}, color = {0, 127, 255}));
  connect(BC_bufIn.ports[1], BufferStorage.port_a_consumer) annotation(
    Line(points = {{78, -44}, {38, -44}, {38, -12}}, color = {0, 127, 255}, thickness = 0.5));
  connect(pump.port_b, BufferStorage.port_a_heatGenerator) annotation(
    Line(points = {{-4, 16}, {14, 16}, {14, 7}, {30, 7}}, color = {0, 127, 255}));
  connect(Tamb.port, BufferStorage.heatPort) annotation(
    Line(points = {{70, -6}, {61, -6}, {61, -2}, {48, -2}}, color = {191, 0, 0}));
  connect(BC_pressure.ports[1], pump.port_a) annotation(
    Line(points = {{-36, 44}, {-24, 44}, {-24, 16}}, color = {0, 127, 255}, thickness = 0.5));
  connect(realExpression1.y, combiTable1D1.u[1]) annotation(
    Line(points = {{-193, 0}, {-186.5, 0}, {-186.5, 4}, {-182, 4}}, color = {0, 0, 127}));
  connect(combiTable1D1.y[1], BC_evapIn.T_in) annotation(
    Line(points = {{-159, 2}, {-144, 2}, {-144, 4}, {-136, 4}}, color = {0, 0, 127}, thickness = 0.5));
  annotation(
    uses(AixLib(version = "0.5.2"), Modelica(version = "3.2.2")),
    experiment(StartTime = 0, StopTime = 31536000, Tolerance = 0.0001, Interval = 600),
    __OpenModelica_simulationFlags(lv = "LOG_STATS", s = "dassl", jacobian = "numerical", noEventEmit = "()"));
end HPStorage_System4;