model HPCalculation

  // Inputs
  Modelica.Blocks.Interfaces.RealInput T_evaIn annotation(
    Placement(visible = true, transformation(origin = {-120, 60}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 60}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput T_evaOut annotation(
  Placement(visible = true, transformation(origin = {-120, 20}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 20}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput mFlow_eva annotation(
  Placement(visible = true, transformation(origin = {-120, -20}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, -20}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput T_conIn annotation(
    Placement(visible = true, transformation(origin = {120, 60}, extent = {{20, -20}, {-20, 20}}, rotation = 0), iconTransformation(origin = {120, 60}, extent = {{20, -20}, {-20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput T_conOut annotation(
  Placement(visible = true, transformation(origin = {120, 20}, extent = {{20, -20}, {-20, 20}}, rotation = 0), iconTransformation(origin = {120, 20}, extent = {{20, -20}, {-20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput mFlow_con annotation(
  Placement(visible = true, transformation(origin = {120, -20}, extent = {{20, -20}, {-20, 20}}, rotation = 0), iconTransformation(origin = {120, -20}, extent = {{20, -20}, {-20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput ControlSignal annotation(
    Placement(visible = true, transformation(origin = {0, 120}, extent = {{-20, -20}, {20, 20}}, rotation = -90), iconTransformation(origin = {0, 120}, extent = {{-20, -20}, {20, 20}}, rotation = -90)));

  // Outputs
  Modelica.Blocks.Interfaces.RealOutput Qdot_con annotation(
    Placement(visible = true, transformation(origin = {-110, -80}, extent = {{10, -10}, {-10, 10}}, rotation = 0), iconTransformation(origin = {110, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput Qdot_eva annotation(
    Placement(visible = true, transformation(origin = {110, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-110, -80}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput Pel annotation(
    Placement(visible = true, transformation(origin = {-40, -110}, extent = {{-10, -10}, {10, 10}}, rotation = -90), iconTransformation(origin = {-40, -110}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealOutput COP annotation(
    Placement(visible = true, transformation(origin = {40, -110}, extent = {{-10, -10}, {10, 10}}, rotation = -90), iconTransformation(origin = {40, -110}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
 
  // Parameter
  parameter Modelica.Blocks.Types.Smoothness smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments
    "smoothness of table interpolation" annotation(Dialog(group = "Assumptions",tab="Advanced"));
  parameter AixLib.DataBase.HeatPump.HeatPumpBaseDataDefinition dataTable=
      AixLib.DataBase.HeatPump.EN255.Vitocal350BWH113() "Look-up table data for on/off heat pump according to EN255/EN14511";
    
  // Locals
  final parameter Real tableQdot_con[:,:]=dataTable.tableQdot_con;
  final parameter Real tableP_el[:,:]= dataTable.tableP_ele;
  Modelica.Blocks.Tables.CombiTable2D Qdot_conTable(
    tableName="NoName",
    fileName="NoName",
    table=tableQdot_con,
    smoothness=smoothness) annotation( 
      extent=[-60,40; -40,60], Placement(transformation(extent={{-40,20},{-20,40}})) );
    
  Modelica.Blocks.Tables.CombiTable2D Pel_Table(
    tableName="NoName",
    fileName="NoName",
    table=tableP_el,
    smoothness=smoothness) annotation( 
      extent=[-60,-20; -40,0], Placement(transformation(extent={{-40,-10}, {-20,10}})));

equation

  Qdot_conTable.u1 = T_conIn - 273.15;
  Qdot_conTable.u2 = T_evaIn - 273.15;
  Pel_Table.u1 = T_conIn - 273.15;
  Pel_Table.u2 = T_evaIn - 273.15;  
  
//  if ControlSignal < 1e-5 then
//    Qdot_con = 0;
//    Pel = 0;
//    Qdot_eva = 0;
//    COP = 0;
//  else  
    Qdot_con = ControlSignal * Qdot_conTable.y;
    Pel = ControlSignal * Pel_Table.y;
    Qdot_eva = Qdot_con - Pel;
    COP = Qdot_con/Pel;
//  end if;

  annotation(
    uses(Modelica(version = "3.2.2")),
    Icon(graphics = {Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-100, 100}, {100, -100}}), Text(origin = {0, 21}, extent = {{-70, 17}, {70, -17}}, textString = "SimpleCycle")}));
 
end HPCalculation;
