model HPcontroller_v2
  Modelica.Blocks.Interfaces.RealInput Tset annotation(
    Placement(visible = true, transformation(origin = {-120, 40}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 40}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput Tsensor annotation(
    Placement(visible = true, transformation(origin = {-120, -40}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, -40}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));

 parameter Real mdot_set = 0.5 "set value mass flow rate";
 parameter Real bandwidth = 5 "Bandwidth around reference signal";
 parameter Boolean pre_y_start=false "Value of pre(y) at initial time";
  Modelica.Blocks.Interfaces.RealOutput mdot annotation(
    Placement(visible = true, transformation(origin = {110, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 Modelica.Blocks.Interfaces.BooleanOutput y annotation(
    Placement(visible = true, transformation(origin = {110, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));

 Real Tsensor_degC = Tsensor-273.15 "avoid additional Temperature Sensor";


initial equation
  pre(y) = pre_y_start;
equation
  y = pre(y) and (Tsensor_degC < Tset + bandwidth/2) or (Tsensor_degC < Tset - bandwidth/2);
  
  if y then 
    mdot = mdot_set; 
  else 
    mdot = 1e-6;
  end if;
  
annotation(
    uses(Modelica(version = "3.2.2")),
    Icon(graphics = {Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-100, 100}, {100, -100}}), Text(origin = {-6, 5}, extent = {{-60, 23}, {60, -23}}, textString = "HP control")}));

end HPcontroller_v2;
