
#include <iostream>
#include <cstdlib>

using namespace std;

#define FMI2_FUNCTION_PREFIX
#include "fmi2Functions.h"

void logfunc(fmi2ComponentEnvironment, fmi2String, fmi2Status, fmi2String, fmi2String, ...)
{
    cout<<"Something should be logged"<<endl;
}

int main()
{
    cout<<fmi2GetVersion()<<endl;
    
    fmi2CallbackFunctions callbacks;
    callbacks.componentEnvironment=nullptr;
    callbacks.allocateMemory=calloc;
    callbacks.freeMemory=free;
    callbacks.logger=logfunc;
    callbacks.stepFinished=[](fmi2ComponentEnvironment, fmi2Status) {
        cout<<"stepFinished called"<<endl;
    };
    
    fmi2Component model=fmi2Instantiate(
        "test",                                   //fmi2String instanceName,
        fmi2CoSimulation,                         //fmi2Type fmuType,
        "{78daf3ce-5bc6-4c3e-8e37-44ca0d416ef3}", //fmi2String fmuGUID,
        "FmiTest.Model/resources",                //fmi2String fmuResourceLocation,
        &callbacks,                               //const fmi2CallbackFunctions* functions,
        true,                                     //fmi2Boolean visible,
        true                                      //fmi2Boolean loggingOn
    );

    cout<<model<<endl;
}
